-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.7.18-log


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema dcma
--

-- CREATE DATABASE IF NOT EXISTS dcma;
-- USE dcma;

--
-- Temporary table structure for view `v_candidatura_mapa`
--
DROP TABLE IF EXISTS `v_candidatura_mapa`;
DROP VIEW IF EXISTS `v_candidatura_mapa`;
CREATE TABLE `v_candidatura_mapa` (
  `idElecCandidatura` int(11),
  `Convocatoria_idConvocatoria` int(11),
  `Orden` int(11),
  `idCandidatura` int(11),
  `Codigo` varchar(10),
  `Titulo` varchar(50),
  `Color` varchar(10),
  `Votos` decimal(32,0)
);

--
-- Temporary table structure for view `v_convocatoria_anterior`
--
DROP TABLE IF EXISTS `v_convocatoria_anterior`;
DROP VIEW IF EXISTS `v_convocatoria_anterior`;
CREATE TABLE `v_convocatoria_anterior` (
  `idConvocatoria` int(11),
  `Titulo` varchar(30),
  `Descripcion` varchar(500),
  `idConvocatoria2` int(11),
  `Titulo2` varchar(30),
  `Descripcion2` varchar(500)
);

--
-- Temporary table structure for view `v_convocatoria_total`
--
DROP TABLE IF EXISTS `v_convocatoria_total`;
DROP VIEW IF EXISTS `v_convocatoria_total`;
CREATE TABLE `v_convocatoria_total` (
  `Convocatoria_idConvocatoria` int(11),
  `Censo` decimal(32,0),
  `CensoOficial` decimal(32,0),
  `Certificacion` decimal(32,0),
  `CertificacionAlta` decimal(32,0),
  `CertificacionError` decimal(32,0),
  `Voto` decimal(32,0),
  `Interventores` decimal(32,0),
  `Nulo` decimal(32,0),
  `Blanco` decimal(32,0),
  `Validos` decimal(32,0)
);

--
-- Temporary table structure for view `v_distrito_voto`
--
DROP TABLE IF EXISTS `v_distrito_voto`;
DROP VIEW IF EXISTS `v_distrito_voto`;
CREATE TABLE `v_distrito_voto` (
  `Convocatoria_idConvocatoria` int(11),
  `Municipio` int(11),
  `Distrito` int(11),
  `idCandidatura` int(11),
  `Codigo` varchar(10),
  `Titulo` varchar(50),
  `Color` varchar(10),
  `Logo` varchar(500),
  `Votos` int(11),
  `PorcVotos` decimal(5,2)
);

--
-- Temporary table structure for view `v_elec_distri`
--
DROP TABLE IF EXISTS `v_elec_distri`;
DROP VIEW IF EXISTS `v_elec_distri`;
CREATE TABLE `v_elec_distri` (
  `NumeroMunicipio` int(11),
  `NumeroDistrito` int(11),
  `NombreDistrito` varchar(50),
  `idElecDistriTotal` int(11),
  `Convocatoria_idConvocatoria` int(11),
  `Censo` int(11),
  `Certificacion` int(11),
  `Interventores` int(11),
  `Nulo` int(11),
  `Blanco` int(11),
  `Validos` int(11)
);

--
-- Temporary table structure for view `v_elec_muni`
--
DROP TABLE IF EXISTS `v_elec_muni`;
DROP VIEW IF EXISTS `v_elec_muni`;
CREATE TABLE `v_elec_muni` (
  `NumeroMunicipio` int(11),
  `NombreMunicipio` varchar(50),
  `Convocatoria_idConvocatoria` int(11),
  `Censo` int(11),
  `Certificacion` int(11),
  `Interventores` int(11),
  `Nulo` int(11),
  `Blanco` int(11),
  `Validos` int(11)
);

--
-- Temporary table structure for view `v_municipio_voto`
--
DROP TABLE IF EXISTS `v_municipio_voto`;
DROP VIEW IF EXISTS `v_municipio_voto`;
CREATE TABLE `v_municipio_voto` (
  `Convocatoria_idConvocatoria` int(11),
  `Municipio` int(11),
  `idCandidatura` int(11),
  `Codigo` varchar(10),
  `Titulo` varchar(50),
  `Color` varchar(10),
  `Logo` varchar(500),
  `Votos` int(11),
  `PorcVotos` decimal(5,2)
);

--
-- Definition of table `areadescarga`
--

DROP TABLE IF EXISTS `areadescarga`;
CREATE TABLE `areadescarga` (
  `idAreaDescarga` int(11) NOT NULL AUTO_INCREMENT,
  `Convocatoria_idConvocatoria` int(11) NOT NULL,
  `Orden` int(11) NOT NULL,
  `Descripcion` varchar(200) NOT NULL,
  `Ficheros` varchar(3000) DEFAULT NULL,
  PRIMARY KEY (`idAreaDescarga`),
  KEY `fk_AreaDescarga_Convocatoria1_idx` (`Convocatoria_idConvocatoria`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `areadescarga`
--

/*!40000 ALTER TABLE `areadescarga` DISABLE KEYS */;
INSERT INTO `areadescarga` (`idAreaDescarga`,`Convocatoria_idConvocatoria`,`Orden`,`Descripcion`,`Ficheros`) VALUES 
 (1,7,5,'Fichero de votación a nivel de Mesa','[{\"name\":\"..\\/..\\/Documentos\\/decma\\/excel\\/1995_Mesas_b6i3yulp.xls\",\"usrName\":\"1995_Mesas.xls\",\"size\":1185280,\"type\":\"application\\/vnd.ms-excel\",\"searchStr\":\"1995_Mesas.xls,!:sStrEnd\"}]'),
 (2,6,6,'Fichero de votación a nivel de Mesa','[{\"name\":\"..\\/..\\/Documentos\\/decma\\/excel\\/1999_Mesas_tbhgokoa.xls\",\"usrName\":\"1999_Mesas.xls\",\"size\":1234432,\"type\":\"application\\/vnd.ms-excel\",\"searchStr\":\"1999_Mesas.xls,!:sStrEnd\"}]'),
 (3,5,7,'Fichero de votación a nivel de Mesa','[{\"name\":\"..\\/..\\/Documentos\\/decma\\/excel\\/2003_mayo_Mesas_7wk4pj1g.xls\",\"usrName\":\"2003_mayo_Mesas.xls\",\"size\":1427968,\"type\":\"application\\/vnd.ms-excel\",\"searchStr\":\"2003_mayo_Mesas.xls,!:sStrEnd\"}]'),
 (4,4,8,'Fichero de votación a nivel de Mesa','[{\"name\":\"..\\/..\\/Documentos\\/decma\\/excel\\/2003_octubre_Mesas_7omi5dj9.xls\",\"usrName\":\"2003_octubre_Mesas.xls\",\"size\":1497088,\"type\":\"application\\/vnd.ms-excel\",\"searchStr\":\"2003_octubre_Mesas.xls,!:sStrEnd\"}]'),
 (5,3,9,'Fichero de votación a nivel de Mesa','[{\"name\":\"..\\/..\\/Documentos\\/decma\\/excel\\/2007_Mesas_ej00jq11.xls\",\"usrName\":\"2007_Mesas.xls\",\"size\":1635328,\"type\":\"application\\/vnd.ms-excel\",\"searchStr\":\"2007_Mesas.xls,!:sStrEnd\"}]'),
 (6,2,10,'Fichero de votación a nivel de Mesa','[{\"name\":\"..\\/..\\/Documentos\\/decma\\/excel\\/2011_Mesas_imrcm5xt.xls\",\"usrName\":\"2011_Mesas.xls\",\"size\":2271232,\"type\":\"application\\/vnd.ms-excel\",\"searchStr\":\"2011_Mesas.xls,!:sStrEnd\"}]'),
 (7,1,11,'Fichero de votación a nivel de Mesa','[{\"name\":\"..\\/..\\/Documentos\\/decma\\/excel\\/2015_Mesas_g5kdyphx.xls\",\"usrName\":\"2015_Mesas.xls\",\"size\":2210816,\"type\":\"application\\/vnd.ms-excel\",\"searchStr\":\"2015_Mesas.xls,!:sStrEnd\"}]'),
 (9,29,12,'Fichero de votación a nivel mesa','[{\"name\":\"..\\/..\\/Documentos\\/decma\\/excel\\/2019_Mesas_l7u047sn.xls\",\"usrName\":\"2019_Mesas.xls\",\"size\":2286592,\"type\":\"application\\/vnd.ms-excel\",\"searchStr\":\"2019_Mesas.xls,!:sStrEnd\"}]');
/*!40000 ALTER TABLE `areadescarga` ENABLE KEYS */;


--
-- Definition of table `candidatura`
--

DROP TABLE IF EXISTS `candidatura`;
CREATE TABLE `candidatura` (
  `idCandidatura` int(11) NOT NULL AUTO_INCREMENT,
  `Codigo` varchar(10) NOT NULL,
  `Titulo` varchar(50) NOT NULL,
  `Descripcion` varchar(500) DEFAULT NULL,
  `Color` varchar(10) NOT NULL DEFAULT '#FFFFFF',
  `Logo` varchar(500) DEFAULT NULL,
  `AgregacionExcel` int(11) NOT NULL DEFAULT '1',
  `OrdenExcel` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idCandidatura`),
  KEY `fk_Candidatura_Candidatura1_idx` (`AgregacionExcel`),
  CONSTRAINT `fk_Candidatura_Candidatura1` FOREIGN KEY (`AgregacionExcel`) REFERENCES `candidatura` (`idCandidatura`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=99 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `candidatura`
--

/*!40000 ALTER TABLE `candidatura` DISABLE KEYS */;
INSERT INTO `candidatura` (`idCandidatura`,`Codigo`,`Titulo`,`Descripcion`,`Color`,`Logo`,`AgregacionExcel`,`OrdenExcel`) VALUES 
 (1,'PP','Partido Popular','','#0572E8','',1,1),
 (2,'PSOE','Partido Socialista Obrero Español','','#F70A16','',2,2),
 (3,'E2000','España 2000','','#E3C010','',95,7),
 (4,'AES','Alternativa Española','','#6762E0','',95,7),
 (5,'PODEMOS','Podemos','','#9638DE','',5,3),
 (6,'ULEG','Unión por Leganés','','#28F040','',95,7),
 (7,'PCAS-TC','Partido Castellano-Tierra Comunera','','#8A0F1D','',95,7),
 (8,'CS','Ciudadanos - Partido de la Ciudadanía','','#FC7E08','',8,4),
 (9,'UPYD','Unión Progreso y Democracia','','#E009E0','',95,7),
 (10,'P-LIB','Partido Libertario','','#A30C80','',95,7),
 (11,'CN','La Coalición Nacional','','#F09D0E','',95,7),
 (12,'IUCM-LV','Izquierda Unida Comunidad de Madrid - Los Verdes','','#07A814','',63,3),
 (13,'SAIN','Solidaridad y Autogestión Internacionalista','','#9A4F9E','',95,7),
 (14,'PH','Partido Humanista','','#E8C82A','',95,7),
 (15,'PCPE','Partido Comunista  de los Pueblos de España','','#F26161','',95,7),
 (16,'FE-JONS','Falange Española de las J.O.N.S.','','#7386D4','',95,7),
 (17,'PACMA','Partido Animalista  Contra el Maltrato Animal','','#9BA80C','',95,7),
 (18,'R-CERO','Agrupación de Electores Recortes Cero','','#CFC9C9','',95,7),
 (19,'VOX','VOX','','#459418','',19,5),
 (20,'IU-LV','Izquierda Unida - Los Verdes Comunidad de Madrid','','#058518','',63,3),
 (21,'CENB','Ciudadanos en Blanco','','#CBD6CF','',95,7),
 (22,'PUM+J','Por Un Mundo más Justo','','#E35B12','',95,7),
 (23,'ECOLO','ECOLO Verdes','','#0CED41','',95,7),
 (24,'CYD','Foro Centro y Democracia','','#0D065E','',95,7),
 (25,'CDL','Centro Democratico Liberal','','#A34A06','',95,7),
 (26,'UCL','Unión Centrista Liberal','','#D7E819','',95,7),
 (27,'PM','Primero Madrid','','#1008F5','',95,7),
 (28,'FE','La Falange','','#03075C','',95,7),
 (29,'PSTM','Partido Salvemos Telemadrid','','#EBA715','',95,7),
 (30,'UPL','Unión por Leganés','','#DDF009','',95,7),
 (31,'VERDES','Los Verdes','','#12660A','',95,7),
 (32,'UC','Partido Político \"Unidad Ciudadana\"','','#ED864E','',95,7),
 (33,'PMMJ','Por un Mundo más Justo','','#DB74D2','',95,7),
 (34,'MEC','Madrid es Castilla','','#F5F50A','',95,7),
 (35,'ID','Innovación Democrática','','#8E1BD1','',95,7),
 (36,'DN','Democracia Nacional','','#9794E8','',95,7),
 (37,'CDE','Centro Democrático Español','','#27E8E8','',95,7),
 (38,'IU-CM','Izquierda Unidad de la Comunidad de Madrid','','#0D5703','',63,3),
 (39,'LV-CM','Los Verdes  de la Comunidad de Madrid','','#1C7A14','',95,7),
 (40,'TC-PNC','Tierra Comunera - Partido Nacionalista Castellano','','#572905','',95,7),
 (41,'PAVIEL','Partido de la Asociación de Viudas y Esposas Legal','','#ED8AEA','',95,7),
 (42,'IR','Izquierda Republicana','','#AD2828','',95,7),
 (43,'NS','Nuevo Socialismo','','#C4375A','',95,7),
 (44,'PMAR','Partido del Mutuo Apoyo Romántico','','#7B3182','',95,7),
 (45,'PRIM','Partido Regional Independiente Madrileño','','#F7E76C','',95,7),
 (46,'PFV','Partido Familia y Vida','','#0A72C2','',95,7),
 (47,'ODEP','Otra Democracia es Posible','','#D94214','',95,7),
 (48,'PADE','Partido Demócrata Español','','#37C74D','',95,7),
 (49,'CB','Ciudadanos en Blanco','','#757070','',95,7),
 (50,'PF','Progresistas Federales','','#389981','',95,7),
 (51,'LV','Los Verdes','','#05F219','',95,7),
 (52,'IZCA','Izquierda Castellana','','#4A0606','',95,7),
 (53,'CDS','Centro Democrático y Social','','#68D9D0','',95,7),
 (54,'FEI-FE','Falange Española Independiente-Falange 2000','','#09043D','',95,7),
 (55,'UCMA','Unión Comunidad de Madrid','','#754491','',95,7),
 (56,'LV-GV','los Verdes-Grupo Verde','','#05ED18','',95,7),
 (57,'UC-CDS','Unión Centrista-Centro Democrático y Social','','#12E8BD','',95,7),
 (58,'PRV','Partido Roji-Verde','','#B33E3E','',95,7),
 (59,'URI','Unidad Regional Independiente','','#31488F','',95,7),
 (60,'FEI','Falange Española Independiente ','','#05054A','',95,7),
 (61,'PLN','Partido de la Ley Natural','','#2A6351','',95,7),
 (62,'PB','Partido de El Bierzo','','#7A230D','',95,7),
 (63,'IU','Izquierda Unida','','#168505','',63,3),
 (64,'LVA','Los Verdes Alternativos','','#1CE634','',95,7),
 (65,'PIE','Independientes de España','','#444894','',95,7),
 (66,'EXT.UNID','Extremadura Unida','','#1FDE72','',95,7),
 (67,'POR','Partido Obrero Revolucionario','','#EB6363','',95,7),
 (68,'NPS','Coalición Nuevo Partido Socialista','','#AD2929','',95,7),
 (69,'FAP','Federación de Partidos de Alianza Popular','','#1919E6','',1,1),
 (70,'PTE-UC','Partido de los Trabajadores de España-U. Comunista','','#D11761','',95,7),
 (71,'CV','Confederación de Los Verdes','','#21EB2F','',95,7),
 (72,'PDP','Partido Demócrata Popular','','#EDC31A','',95,7),
 (73,'POSI','Partido Obrero Socialista Internacionalista','','#630B0B','',95,7),
 (74,'IM','Agrupación Independiente Autonómica de Madrid','','#81BA36','',95,7),
 (75,'UCE','Unificación Comunista de España','','#A34DB0','',95,7),
 (76,'LE','Los Ecologistas','','#64BD71','',95,7),
 (77,'UVE','Unión Verde','','#60872C','',95,7),
 (78,'PST','Partido Socialista de los Trabajadores','','#E67575','',95,7),
 (79,'PAM','Partido de Madrid','','#CAE021','',95,7),
 (80,'CCI','Convergencia de Candidaturas Independientes','','#4074C2','',95,7),
 (81,'PORE','Partido Obrero Revolucionario de España','','#D17AD9','',95,7),
 (82,'AIA','Agrupación Independiente de Aranjuez','','#BDA02A','',95,7),
 (83,'AR','Alianza por la República','','#2087F5','',95,7),
 (84,'PI','Coalición Plataforma de Izquierda','','#C43379','',95,7),
 (85,'ARU','Acción Republicana Unida','','#834BA3','',95,7),
 (86,'UCM','Unidad Centrista Madrileña','','#32EB98','',95,7),
 (87,'IG','Integración Generacional','','#D93E23','',95,7),
 (88,'AP-PDP-UL','Alianza Popular-Partido Demócrata Popular-Unión Li','','#0D0DE0','',1,1),
 (89,'PCE','Partido Comunista de España','','#28EB35','',95,7),
 (90,'PDL','Partido Demócrata Liberal','','#1BF2E7','',95,7),
 (91,'ADEI','Acción de Electores Independientes','','#AED640','',95,7),
 (92,'LCCAO','Liga Comunista (Acuerdo Obrero)','','#5E0C13','',95,7),
 (93,'PCOE','Coalición PCOE-PCEU','','#CC12B6','',95,7),
 (94,'CLP','Candidatura de Coalición de Lucha Popular','','#F22C7B','',95,7),
 (95,'Otros','Agregación de Candidaturas sin Escaño en CM','Agregación de Candidatura en convocatorias que no son de la Asamble de Madrid y de años anteriores a 1999','#7A7676','',95,7),
 (96,'MÁS MADRID','Más Madrid','','#1CDBB5','',96,6),
 (97,'PCTE','Partido Comunista de los Trabajadores de  España','','#E67373','',95,7),
 (98,'PODEMOS-IU','Unidas Podemos - IU-Madrid en Pie','','#A136E8','',5,3);
/*!40000 ALTER TABLE `candidatura` ENABLE KEYS */;


--
-- Definition of table `convocatoria`
--

DROP TABLE IF EXISTS `convocatoria`;
CREATE TABLE `convocatoria` (
  `idConvocatoria` int(11) NOT NULL AUTO_INCREMENT,
  `Orden` int(11) NOT NULL,
  `EsAsamblea` varchar(1) NOT NULL DEFAULT '1' COMMENT 'Si es de Asamblea de Madrid es #1#',
  `Titulo` varchar(30) NOT NULL,
  `Descripcion` varchar(500) DEFAULT NULL,
  `TipoConvocatoria_idTipoConvocatoria` int(11) NOT NULL DEFAULT '1',
  `EsFicticia` varchar(1) NOT NULL DEFAULT '0',
  `Orden_Ana` int(11) DEFAULT NULL COMMENT 'Orden cronologico para analisis',
  PRIMARY KEY (`idConvocatoria`),
  KEY `fk_Convocatoria_TipoConvocatoria1_idx` (`TipoConvocatoria_idTipoConvocatoria`),
  CONSTRAINT `fk_Convocatoria_TipoConvocatoria1` FOREIGN KEY (`TipoConvocatoria_idTipoConvocatoria`) REFERENCES `tipoconvocatoria` (`idTipoConvocatoria`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=103 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `convocatoria`
--

/*!40000 ALTER TABLE `convocatoria` DISABLE KEYS */;
INSERT INTO `convocatoria` (`idConvocatoria`,`Orden`,`EsAsamblea`,`Titulo`,`Descripcion`,`TipoConvocatoria_idTipoConvocatoria`,`EsFicticia`,`Orden_Ana`) VALUES 
 (1,34,'1','2015-AM','2015 - Asamblea de Madrid',1,'0',26),
 (2,38,'1','2011-AM','2011 - Asamblea de Madrid',1,'0',22),
 (3,42,'1','2007-AM','2007 - Asamblea de Madrid',1,'0',17),
 (4,45,'1','2003/2-AM','2003 - Octubre - Asamblea de Madrid',1,'0',13),
 (5,46,'1','2003/1-AM','2003 - Mayo - Asamblea de Madrid',1,'0',12),
 (6,51,'1','1999-AM','1999 - Asamblea de Madrid',1,'0',9),
 (7,53,'1','1995-AM','1995 - Asamblea de Madrid',1,'0',5),
 (8,55,'1','1991-AM','1991 - Asamblea de Madrid',1,'0',3),
 (9,56,'1','1987-AM','1987 - Asamblea de Madrid',1,'0',2),
 (10,57,'1','1983-AM','1983 - Asamblea de Madrid',1,'0',1),
 (11,54,'0','1994-EU','1994 - Europeas',4,'0',4),
 (12,52,'0','1996-GE','1996 - Generales',3,'0',6),
 (13,50,'0','1999-EU','1999 - Europeas',4,'0',7),
 (14,49,'0','1999-LO','1999 - Locales',2,'0',8),
 (15,48,'0','2000-GE','2000 - Generales',3,'0',10),
 (16,47,'0','2003-LO','2003 - Locales',2,'0',11),
 (17,43,'0','2004-GE','2004 - Generales',3,'0',15),
 (18,41,'0','2007-LO','2007 - Locales',2,'0',16),
 (19,40,'0','2008-GE','2008 - Generales',3,'0',18),
 (20,39,'0','2009-EU','2009 - Europeas',4,'0',19),
 (21,37,'0','2011-LO','2011 - Locales',2,'0',21),
 (22,36,'0','2011-GE','2011 - Generales',3,'0',20),
 (23,35,'0','2014-EU','2014 - Europeas',4,'0',23),
 (24,33,'0','2015-LO','2015 - Locales',2,'0',25),
 (25,32,'0','2015-GE','2015 - Generales',3,'0',24),
 (26,31,'0','2016-GE','2016 - Generales',3,'0',27),
 (27,44,'0','2004-EU','2004 - Europeas',4,'0',14),
 (28,30,'0','2019-GE','2019 - Generales',3,'0',28),
 (29,33,'1','2019-AM','2019 - Asamblea de Madrid',1,'0',32),
 (100,1,'0','2019-AM','2019 - Asamblea de Madrid',1,'1',31),
 (101,2,'0','2019-LO','2019 - Locales',2,'1',30),
 (102,3,'0','2019-EU','2019 - Europeas',4,'1',29);
/*!40000 ALTER TABLE `convocatoria` ENABLE KEYS */;


--
-- Definition of table `distrito`
--

DROP TABLE IF EXISTS `distrito`;
CREATE TABLE `distrito` (
  `idDistrito` int(11) NOT NULL AUTO_INCREMENT,
  `NumeroMunicipio` int(11) NOT NULL,
  `NumeroDistrito` int(11) NOT NULL,
  `NombreDistrito` varchar(50) NOT NULL,
  PRIMARY KEY (`idDistrito`)
) ENGINE=InnoDB AUTO_INCREMENT=4342 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `distrito`
--

/*!40000 ALTER TABLE `distrito` DISABLE KEYS */;
INSERT INTO `distrito` (`idDistrito`,`NumeroMunicipio`,`NumeroDistrito`,`NombreDistrito`) VALUES 
 (1,79,1,'CENTRO'),
 (2,79,2,'ARGANZUELA'),
 (3,79,3,'RETIRO'),
 (4,79,4,'SALAMANCA'),
 (5,79,5,'CHAMARTÍN'),
 (6,79,6,'TETUÁN'),
 (7,79,7,'CHAMBERÍ'),
 (8,79,8,'FUENCARRAL-EL PARDO'),
 (9,79,9,'MONCLOA-ARAVACA'),
 (10,79,10,'LATINA'),
 (11,79,11,'CARABANCHEL'),
 (12,79,12,'USERA'),
 (13,79,13,'PUENTE VALLECAS'),
 (14,79,14,'MORATALAZ'),
 (15,79,15,'CIUDAD LINEAL'),
 (16,79,16,'HORTALEZA'),
 (17,79,17,'VILLAVERDE'),
 (18,79,18,'VILLA DE VALLECAS'),
 (19,79,19,'VICÁLVARO'),
 (20,79,20,'SAN BLAS'),
 (21,79,21,'BARAJAS'),
 (4117,1,1,''),
 (4118,2,1,''),
 (4119,3,1,''),
 (4120,4,1,''),
 (4121,5,1,''),
 (4122,5,2,''),
 (4123,5,3,''),
 (4124,5,4,''),
 (4125,5,5,''),
 (4126,6,1,''),
 (4127,7,1,''),
 (4128,7,2,''),
 (4129,7,3,''),
 (4130,7,4,''),
 (4131,8,1,''),
 (4132,9,1,''),
 (4133,10,1,''),
 (4134,11,1,''),
 (4135,12,1,''),
 (4136,13,1,''),
 (4137,13,2,''),
 (4138,13,3,''),
 (4139,13,4,''),
 (4140,14,1,''),
 (4141,15,1,''),
 (4142,16,1,''),
 (4143,17,1,''),
 (4144,18,1,''),
 (4145,19,1,''),
 (4146,20,1,''),
 (4147,21,1,''),
 (4148,22,1,''),
 (4149,23,1,''),
 (4150,24,1,''),
 (4151,25,1,''),
 (4152,26,1,''),
 (4153,27,1,''),
 (4154,28,1,''),
 (4155,29,1,''),
 (4156,30,1,''),
 (4157,31,1,''),
 (4158,32,1,''),
 (4159,33,1,''),
 (4160,34,1,''),
 (4161,35,1,''),
 (4162,36,1,''),
 (4163,37,1,''),
 (4164,38,1,''),
 (4165,39,1,''),
 (4166,40,1,''),
 (4167,40,2,''),
 (4168,40,3,''),
 (4169,41,1,''),
 (4170,42,1,''),
 (4171,43,1,''),
 (4172,43,2,''),
 (4173,44,1,''),
 (4174,45,1,''),
 (4175,46,1,''),
 (4176,47,1,''),
 (4177,48,1,''),
 (4178,49,1,''),
 (4179,49,2,''),
 (4180,49,3,''),
 (4181,49,4,''),
 (4182,50,1,''),
 (4183,51,1,''),
 (4184,52,1,''),
 (4185,53,1,''),
 (4186,54,1,''),
 (4187,54,2,''),
 (4188,55,1,''),
 (4189,56,1,''),
 (4190,57,1,''),
 (4191,58,1,''),
 (4192,58,2,''),
 (4193,58,3,''),
 (4194,58,4,''),
 (4195,58,5,''),
 (4196,58,6,''),
 (4197,58,7,''),
 (4198,58,8,''),
 (4199,58,9,''),
 (4200,59,1,''),
 (4201,60,1,''),
 (4202,61,1,''),
 (4203,62,1,''),
 (4204,63,1,''),
 (4205,64,1,''),
 (4206,65,1,''),
 (4207,65,2,''),
 (4208,65,3,''),
 (4209,65,4,''),
 (4210,66,1,''),
 (4211,67,1,''),
 (4212,68,1,''),
 (4213,69,1,''),
 (4214,70,1,''),
 (4215,71,1,''),
 (4216,72,1,''),
 (4217,73,1,''),
 (4218,74,1,''),
 (4219,74,2,''),
 (4220,74,3,''),
 (4221,74,4,''),
 (4222,74,5,''),
 (4223,74,6,''),
 (4224,74,7,''),
 (4225,75,1,''),
 (4226,76,1,''),
 (4227,78,1,''),
 (4228,80,1,''),
 (4229,80,2,''),
 (4230,82,1,''),
 (4231,83,1,''),
 (4232,84,1,''),
 (4233,85,1,''),
 (4234,86,1,''),
 (4235,87,1,''),
 (4236,88,1,''),
 (4237,89,1,''),
 (4238,90,1,''),
 (4239,91,1,''),
 (4240,91,2,''),
 (4241,92,1,''),
 (4242,92,2,''),
 (4243,92,3,''),
 (4244,92,4,''),
 (4245,93,1,''),
 (4246,94,1,''),
 (4247,95,1,''),
 (4248,96,1,''),
 (4249,97,1,''),
 (4250,99,1,''),
 (4251,100,1,''),
 (4252,101,1,''),
 (4253,102,1,''),
 (4254,104,1,''),
 (4255,106,1,''),
 (4256,107,1,''),
 (4257,108,1,''),
 (4258,109,1,''),
 (4259,110,1,''),
 (4260,111,1,''),
 (4261,112,1,''),
 (4262,113,1,''),
 (4263,113,2,''),
 (4264,114,1,''),
 (4265,115,1,''),
 (4266,115,2,''),
 (4267,116,1,''),
 (4268,117,1,''),
 (4269,118,1,''),
 (4270,119,1,''),
 (4271,120,1,''),
 (4272,121,1,''),
 (4273,122,1,''),
 (4274,123,1,''),
 (4275,124,1,''),
 (4276,125,1,''),
 (4277,126,1,''),
 (4278,127,1,''),
 (4279,128,1,''),
 (4280,129,1,''),
 (4281,130,1,''),
 (4282,131,1,''),
 (4283,131,2,''),
 (4284,132,1,''),
 (4285,133,1,''),
 (4286,134,1,''),
 (4287,135,1,''),
 (4288,136,1,''),
 (4289,137,1,''),
 (4290,138,1,''),
 (4291,140,1,''),
 (4292,141,1,''),
 (4293,143,1,''),
 (4294,144,1,''),
 (4295,145,1,''),
 (4296,146,1,''),
 (4297,147,1,''),
 (4298,148,1,''),
 (4299,148,2,''),
 (4300,148,3,''),
 (4301,148,4,''),
 (4302,149,1,''),
 (4303,150,1,''),
 (4304,151,1,''),
 (4305,151,2,''),
 (4306,152,1,''),
 (4307,153,1,''),
 (4308,154,1,''),
 (4309,155,1,''),
 (4310,156,1,''),
 (4311,157,1,''),
 (4312,158,1,''),
 (4313,159,1,''),
 (4314,160,1,''),
 (4315,161,1,''),
 (4316,161,2,''),
 (4317,162,1,''),
 (4318,163,1,''),
 (4319,164,1,''),
 (4320,165,1,''),
 (4321,166,1,''),
 (4322,167,1,''),
 (4323,168,1,''),
 (4324,169,1,''),
 (4325,170,1,''),
 (4326,171,1,''),
 (4327,172,1,''),
 (4328,173,1,''),
 (4329,174,1,''),
 (4330,175,1,''),
 (4331,176,1,''),
 (4332,177,1,''),
 (4333,178,1,''),
 (4334,179,1,''),
 (4335,180,1,''),
 (4336,181,1,''),
 (4337,182,1,''),
 (4338,183,1,''),
 (4339,901,1,''),
 (4340,902,1,''),
 (4341,903,1,'');
/*!40000 ALTER TABLE `distrito` ENABLE KEYS */;


--
-- Definition of table `eleccandidatura`
--

DROP TABLE IF EXISTS `eleccandidatura`;
CREATE TABLE `eleccandidatura` (
  `idElecCandidatura` int(11) NOT NULL AUTO_INCREMENT,
  `Convocatoria_idConvocatoria` int(11) NOT NULL,
  `Orden` int(11) NOT NULL,
  `Candidatura_idCandidatura` int(11) NOT NULL,
  PRIMARY KEY (`idElecCandidatura`),
  KEY `fk_ConvocatoriaCandidatura_Convocatoria_idx` (`Convocatoria_idConvocatoria`),
  KEY `fk_ConvocatoriaCandidatura_Candidatura1_idx` (`Candidatura_idCandidatura`),
  CONSTRAINT `fk_ConvocatoriaCandidatura_Candidatura1` FOREIGN KEY (`Candidatura_idCandidatura`) REFERENCES `candidatura` (`idCandidatura`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_ConvocatoriaCandidatura_Convocatoria` FOREIGN KEY (`Convocatoria_idConvocatoria`) REFERENCES `convocatoria` (`idConvocatoria`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=190 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `eleccandidatura`
--

/*!40000 ALTER TABLE `eleccandidatura` DISABLE KEYS */;
INSERT INTO `eleccandidatura` (`idElecCandidatura`,`Convocatoria_idConvocatoria`,`Orden`,`Candidatura_idCandidatura`) VALUES 
 (1,1,1,1),
 (2,1,2,2),
 (3,1,3,3),
 (4,1,4,4),
 (5,1,5,5),
 (6,1,6,6),
 (7,1,7,7),
 (8,1,8,8),
 (9,1,9,9),
 (10,1,10,10),
 (11,1,11,11),
 (12,1,12,12),
 (13,1,13,13),
 (14,1,14,14),
 (15,1,15,15),
 (16,1,16,16),
 (17,1,17,17),
 (18,1,18,18),
 (19,1,19,19),
 (20,2,1,20),
 (21,2,2,1),
 (22,2,3,6),
 (23,2,4,13),
 (24,2,5,16),
 (25,2,6,21),
 (26,2,7,2),
 (27,2,8,22),
 (28,2,9,7),
 (29,2,10,9),
 (30,2,11,4),
 (31,2,12,8),
 (32,2,13,23),
 (33,2,14,17),
 (34,2,15,14),
 (35,2,16,24),
 (36,2,17,15),
 (37,2,18,25),
 (38,3,1,12),
 (39,3,2,26),
 (40,3,3,27),
 (41,3,4,28),
 (42,3,5,29),
 (43,3,6,4),
 (44,3,7,14),
 (45,3,8,17),
 (46,3,9,30),
 (47,3,10,15),
 (48,3,11,2),
 (49,3,12,31),
 (50,3,13,32),
 (51,3,14,33),
 (52,3,15,1),
 (53,3,16,34),
 (54,3,17,35),
 (55,3,18,16),
 (56,3,19,36),
 (57,3,20,37),
 (58,4,1,28),
 (59,4,2,38),
 (60,4,3,1),
 (61,4,4,14),
 (62,4,5,39),
 (63,4,6,40),
 (64,4,7,2),
 (65,4,8,41),
 (66,4,9,42),
 (67,4,10,43),
 (68,4,11,16),
 (69,4,12,36),
 (70,4,13,44),
 (71,4,14,45),
 (72,4,15,46),
 (73,4,16,32),
 (74,4,17,51),
 (75,4,18,47),
 (76,4,19,48),
 (77,4,20,49),
 (78,4,21,15),
 (79,4,22,50),
 (80,5,1,51),
 (81,5,2,28),
 (82,5,3,2),
 (83,5,4,1),
 (84,5,5,39),
 (85,5,6,38),
 (86,5,7,45),
 (87,5,8,42),
 (88,5,9,47),
 (89,5,10,14),
 (90,5,11,40),
 (91,5,12,46),
 (92,5,13,52),
 (93,5,14,53),
 (94,5,15,41),
 (95,5,16,32),
 (96,5,17,54),
 (97,5,18,15),
 (98,5,19,36),
 (99,5,20,48),
 (100,6,1,38),
 (101,6,2,55),
 (102,6,3,40),
 (103,6,4,45),
 (104,6,5,1),
 (105,6,6,32),
 (106,6,7,56),
 (107,6,8,48),
 (108,6,9,57),
 (109,6,10,14),
 (110,6,11,58),
 (111,6,12,59),
 (112,6,13,28),
 (113,6,14,2),
 (114,6,15,60),
 (115,6,16,51),
 (116,6,17,61),
 (117,6,18,62),
 (118,6,19,15),
 (119,6,20,50),
 (120,7,1,1),
 (121,7,2,2),
 (122,7,3,63),
 (123,7,4,56),
 (124,7,5,64),
 (125,7,6,65),
 (126,7,7,45),
 (127,7,8,66),
 (128,7,9,32),
 (129,7,10,67),
 (130,7,11,15),
 (131,7,12,16),
 (132,7,13,14),
 (133,7,14,59),
 (134,7,15,60),
 (135,7,16,68),
 (136,9,1,2),
 (137,9,2,69),
 (138,9,3,53),
 (139,9,4,63),
 (140,9,5,70),
 (141,9,6,51),
 (142,9,7,71),
 (143,9,8,72),
 (144,9,9,14),
 (145,9,10,73),
 (146,9,11,74),
 (147,9,12,75),
 (148,8,1,1),
 (149,8,2,2),
 (150,8,3,63),
 (151,8,4,53),
 (152,8,5,51),
 (153,8,6,76),
 (154,8,7,77),
 (155,8,8,45),
 (156,8,9,78),
 (157,8,10,79),
 (158,8,11,80),
 (159,8,12,81),
 (160,8,13,82),
 (161,8,14,83),
 (162,8,15,84),
 (163,8,16,85),
 (164,8,17,86),
 (165,8,18,87),
 (166,10,1,2),
 (167,10,2,88),
 (168,10,3,89),
 (169,10,4,53),
 (170,10,5,90),
 (171,10,6,91),
 (172,10,7,92),
 (173,10,8,93),
 (174,10,9,94),
 (175,29,1,17),
 (176,29,2,96),
 (177,29,3,2),
 (178,29,4,14),
 (179,29,5,6),
 (180,29,6,8),
 (181,29,7,16),
 (182,29,8,7),
 (183,29,9,22),
 (184,29,10,10),
 (185,29,11,1),
 (186,29,12,97),
 (187,29,13,19),
 (188,29,14,9),
 (189,29,15,98);
/*!40000 ALTER TABLE `eleccandidatura` ENABLE KEYS */;


--
-- Definition of table `elecciones_settings`
--

DROP TABLE IF EXISTS `elecciones_settings`;
CREATE TABLE `elecciones_settings` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `TYPE` int(11) DEFAULT '1',
  `NAME` mediumtext,
  `USERNAME` mediumtext,
  `COOKIE` varchar(500) DEFAULT NULL,
  `SEARCH` mediumtext,
  `TABLENAME` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `elecciones_settings`
--

/*!40000 ALTER TABLE `elecciones_settings` DISABLE KEYS */;
INSERT INTO `elecciones_settings` (`ID`,`TYPE`,`NAME`,`USERNAME`,`COOKIE`,`SEARCH`,`TABLENAME`) VALUES 
 (1,2,NULL,NULL,'jr6k44wrc0cen1ig84vm70oq','{\"gridWidth\":347.4,\"thWidths\":{\"grid_headcell_field\":161.4,\"grid_headcell_field1\":58.4,\"grid_headcell_field2\":35.4,\"grid_headcell_field3\":54.4}}','escanos');
/*!40000 ALTER TABLE `elecciones_settings` ENABLE KEYS */;


--
-- Definition of table `elecdistricandi`
--

DROP TABLE IF EXISTS `elecdistricandi`;
CREATE TABLE `elecdistricandi` (
  `idElecDistriCandi` int(11) NOT NULL AUTO_INCREMENT,
  `Convocatoria_idConvocatoria` int(11) NOT NULL,
  `Candidatura_idCandidatura` int(11) NOT NULL,
  `Municipio` int(11) NOT NULL,
  `Distrito` int(11) NOT NULL,
  `Votos` int(11) NOT NULL,
  `PorcVotos` decimal(5,2) NOT NULL,
  PRIMARY KEY (`idElecDistriCandi`),
  KEY `i_ElecDistriCandi_Distrito` (`Distrito`),
  KEY `i_ElecDistriCandi_Municipio` (`Municipio`),
  KEY `fk_ElecDistriCandi_Convocatoria1_idx` (`Convocatoria_idConvocatoria`),
  KEY `fk_ElecDistriCandi_Candidatura1_idx` (`Candidatura_idCandidatura`),
  CONSTRAINT `fk_ElecDistriCandi_Candidatura1` FOREIGN KEY (`Candidatura_idCandidatura`) REFERENCES `candidatura` (`idCandidatura`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_ElecDistriCandi_Convocatoria1` FOREIGN KEY (`Convocatoria_idConvocatoria`) REFERENCES `convocatoria` (`idConvocatoria`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=10261 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `elecdistricandi`
--

/*!40000 ALTER TABLE `elecdistricandi` DISABLE KEYS */;
INSERT INTO `elecdistricandi` (`idElecDistriCandi`,`Convocatoria_idConvocatoria`,`Candidatura_idCandidatura`,`Municipio`,`Distrito`,`Votos`,`PorcVotos`) VALUES 
 (1,1,1,79,1,17136,'26.93'),
 (2,1,2,79,1,16272,'25.57'),
 (3,1,3,79,1,32,'0.05'),
 (4,1,4,79,1,46,'0.07'),
 (5,1,5,79,1,17307,'27.20'),
 (6,1,6,79,1,8,'0.01'),
 (7,1,7,79,1,36,'0.06'),
 (8,1,8,79,1,5624,'8.84'),
 (9,1,9,79,1,1063,'1.67'),
 (10,1,10,79,1,26,'0.04'),
 (11,1,11,79,1,63,'0.10'),
 (12,1,12,79,1,3877,'6.09'),
 (13,1,13,79,1,18,'0.03'),
 (14,1,14,79,1,65,'0.10'),
 (15,1,15,79,1,55,'0.09'),
 (16,1,16,79,1,64,'0.10'),
 (17,1,17,79,1,641,'1.01'),
 (18,1,18,79,1,98,'0.15'),
 (19,1,19,79,1,663,'1.04'),
 (20,1,1,79,2,27540,'32.13'),
 (21,1,2,79,2,22336,'26.06'),
 (22,1,3,79,2,44,'0.05'),
 (23,1,4,79,2,48,'0.06'),
 (24,1,5,79,2,16674,'19.45'),
 (25,1,6,79,2,16,'0.02'),
 (26,1,7,79,2,35,'0.04'),
 (27,1,8,79,2,10088,'11.77'),
 (28,1,9,79,2,1910,'2.23'),
 (29,1,10,79,2,42,'0.05'),
 (30,1,11,79,2,112,'0.13'),
 (31,1,12,79,2,4023,'4.69'),
 (32,1,13,79,2,32,'0.04'),
 (33,1,14,79,2,74,'0.09'),
 (34,1,15,79,2,62,'0.07'),
 (35,1,16,79,2,96,'0.11'),
 (36,1,17,79,2,650,'0.76'),
 (37,1,18,79,2,99,'0.12'),
 (38,1,19,79,2,1008,'1.18'),
 (39,1,1,79,3,31614,'44.09'),
 (40,1,2,79,3,15238,'21.25'),
 (41,1,3,79,3,36,'0.05'),
 (42,1,4,79,3,67,'0.09'),
 (43,1,5,79,3,9159,'12.77'),
 (44,1,6,79,3,10,'0.01'),
 (45,1,7,79,3,25,'0.03'),
 (46,1,8,79,3,8840,'12.33'),
 (47,1,9,79,3,1404,'1.96'),
 (48,1,10,79,3,33,'0.05'),
 (49,1,11,79,3,63,'0.09'),
 (50,1,12,79,3,2348,'3.27'),
 (51,1,13,79,3,24,'0.03'),
 (52,1,14,79,3,49,'0.07'),
 (53,1,15,79,3,37,'0.05'),
 (54,1,16,79,3,71,'0.10'),
 (55,1,17,79,3,482,'0.67'),
 (56,1,18,79,3,51,'0.07'),
 (57,1,19,79,3,1447,'2.02'),
 (58,1,1,79,4,42066,'52.25'),
 (59,1,2,79,4,13860,'17.22'),
 (60,1,3,79,4,34,'0.04'),
 (61,1,4,79,4,101,'0.13'),
 (62,1,5,79,4,7540,'9.37'),
 (63,1,6,79,4,7,'0.01'),
 (64,1,7,79,4,27,'0.03'),
 (65,1,8,79,4,9781,'12.15'),
 (66,1,9,79,4,1287,'1.60'),
 (67,1,10,79,4,64,'0.08'),
 (68,1,11,79,4,71,'0.09'),
 (69,1,12,79,4,1931,'2.40'),
 (70,1,13,79,4,22,'0.03'),
 (71,1,14,79,4,58,'0.07'),
 (72,1,15,79,4,21,'0.03'),
 (73,1,16,79,4,92,'0.11'),
 (74,1,17,79,4,506,'0.63'),
 (75,1,18,79,4,62,'0.08'),
 (76,1,19,79,4,2213,'2.75'),
 (77,1,1,79,5,42464,'51.86'),
 (78,1,2,79,5,14217,'17.36'),
 (79,1,3,79,5,30,'0.04'),
 (80,1,4,79,5,78,'0.10'),
 (81,1,5,79,5,7189,'8.78'),
 (82,1,6,79,5,11,'0.01'),
 (83,1,7,79,5,21,'0.03'),
 (84,1,8,79,5,10911,'13.33'),
 (85,1,9,79,5,1276,'1.56'),
 (86,1,10,79,5,38,'0.05'),
 (87,1,11,79,5,57,'0.07'),
 (88,1,12,79,5,1905,'2.33'),
 (89,1,13,79,5,38,'0.05'),
 (90,1,14,79,5,57,'0.07'),
 (91,1,15,79,5,31,'0.04'),
 (92,1,16,79,5,76,'0.09'),
 (93,1,17,79,5,490,'0.60'),
 (94,1,18,79,5,47,'0.06'),
 (95,1,19,79,5,2062,'2.52'),
 (96,1,1,79,6,27437,'38.06'),
 (97,1,2,79,6,17645,'24.47'),
 (98,1,3,79,6,43,'0.06'),
 (99,1,4,79,6,81,'0.11'),
 (100,1,5,79,6,11521,'15.98'),
 (101,1,6,79,6,11,'0.02'),
 (102,1,7,79,6,39,'0.05'),
 (103,1,8,79,6,8228,'11.41'),
 (104,1,9,79,6,1509,'2.09'),
 (105,1,10,79,6,63,'0.09'),
 (106,1,11,79,6,76,'0.11'),
 (107,1,12,79,6,2599,'3.60'),
 (108,1,13,79,6,31,'0.04'),
 (109,1,14,79,6,114,'0.16'),
 (110,1,15,79,6,60,'0.08'),
 (111,1,16,79,6,112,'0.16'),
 (112,1,17,79,6,689,'0.96'),
 (113,1,18,79,6,94,'0.13'),
 (114,1,19,79,6,1009,'1.40'),
 (115,1,1,79,7,37452,'47.15'),
 (116,1,2,79,7,15455,'19.46'),
 (117,1,3,79,7,34,'0.04'),
 (118,1,4,79,7,97,'0.12'),
 (119,1,5,79,7,9305,'11.71'),
 (120,1,6,79,7,15,'0.02'),
 (121,1,7,79,7,18,'0.02'),
 (122,1,8,79,7,9507,'11.97'),
 (123,1,9,79,7,1355,'1.71'),
 (124,1,10,79,7,37,'0.05'),
 (125,1,11,79,7,70,'0.09'),
 (126,1,12,79,7,2553,'3.21'),
 (127,1,13,79,7,25,'0.03'),
 (128,1,14,79,7,61,'0.08'),
 (129,1,15,79,7,31,'0.04'),
 (130,1,16,79,7,101,'0.13'),
 (131,1,17,79,7,448,'0.56'),
 (132,1,18,79,7,59,'0.07'),
 (133,1,19,79,7,2009,'2.53'),
 (134,1,1,79,8,51125,'39.84'),
 (135,1,2,79,8,30361,'23.66'),
 (136,1,3,79,8,63,'0.05'),
 (137,1,4,79,8,146,'0.11'),
 (138,1,5,79,8,16759,'13.06'),
 (139,1,6,79,8,17,'0.01'),
 (140,1,7,79,8,43,'0.03'),
 (141,1,8,79,8,17723,'13.81'),
 (142,1,9,79,8,2634,'2.05'),
 (143,1,10,79,8,65,'0.05'),
 (144,1,11,79,8,127,'0.10'),
 (145,1,12,79,8,4024,'3.14'),
 (146,1,13,79,8,51,'0.04'),
 (147,1,14,79,8,111,'0.09'),
 (148,1,15,79,8,89,'0.07'),
 (149,1,16,79,8,175,'0.14'),
 (150,1,17,79,8,919,'0.72'),
 (151,1,18,79,8,134,'0.10'),
 (152,1,19,79,8,2265,'1.77'),
 (153,1,1,79,9,28983,'44.86'),
 (154,1,2,79,9,13499,'20.89'),
 (155,1,3,79,9,28,'0.04'),
 (156,1,4,79,9,83,'0.13'),
 (157,1,5,79,9,8255,'12.78'),
 (158,1,6,79,9,7,'0.01'),
 (159,1,7,79,9,14,'0.02'),
 (160,1,8,79,9,7704,'11.92'),
 (161,1,9,79,9,1111,'1.72'),
 (162,1,10,79,9,35,'0.05'),
 (163,1,11,79,9,52,'0.08'),
 (164,1,12,79,9,2156,'3.34'),
 (165,1,13,79,9,17,'0.03'),
 (166,1,14,79,9,33,'0.05'),
 (167,1,15,79,9,38,'0.06'),
 (168,1,16,79,9,70,'0.11'),
 (169,1,17,79,9,443,'0.69'),
 (170,1,18,79,9,43,'0.07'),
 (171,1,19,79,9,1361,'2.11'),
 (172,1,1,79,10,40553,'33.55'),
 (173,1,2,79,10,33158,'27.43'),
 (174,1,3,79,10,112,'0.09'),
 (175,1,4,79,10,84,'0.07'),
 (176,1,5,79,10,23397,'19.35'),
 (177,1,6,79,10,54,'0.04'),
 (178,1,7,79,10,79,'0.07'),
 (179,1,8,79,10,11349,'9.39'),
 (180,1,9,79,10,2370,'1.96'),
 (181,1,10,79,10,56,'0.05'),
 (182,1,11,79,10,101,'0.08'),
 (183,1,12,79,10,5440,'4.50'),
 (184,1,13,79,10,46,'0.04'),
 (185,1,14,79,10,166,'0.14'),
 (186,1,15,79,10,105,'0.09'),
 (187,1,16,79,10,171,'0.14'),
 (188,1,17,79,10,1119,'0.93'),
 (189,1,18,79,10,203,'0.17'),
 (190,1,19,79,10,1202,'0.99'),
 (191,1,1,79,11,33114,'30.24'),
 (192,1,2,79,11,31806,'29.04'),
 (193,1,3,79,11,104,'0.09'),
 (194,1,4,79,11,63,'0.06'),
 (195,1,5,79,11,22051,'20.14'),
 (196,1,6,79,11,49,'0.04'),
 (197,1,7,79,11,61,'0.06'),
 (198,1,8,79,11,10971,'10.02'),
 (199,1,9,79,11,2179,'1.99'),
 (200,1,10,79,11,47,'0.04'),
 (201,1,11,79,11,111,'0.10'),
 (202,1,12,79,11,5216,'4.76'),
 (203,1,13,79,11,93,'0.08'),
 (204,1,14,79,11,144,'0.13'),
 (205,1,15,79,11,149,'0.14'),
 (206,1,16,79,11,212,'0.19'),
 (207,1,17,79,11,1012,'0.92'),
 (208,1,18,79,11,177,'0.16'),
 (209,1,19,79,11,896,'0.82'),
 (210,1,1,79,12,13632,'24.51'),
 (211,1,2,79,12,18210,'32.74'),
 (212,1,3,79,12,80,'0.14'),
 (213,1,4,79,12,39,'0.07'),
 (214,1,5,79,12,12931,'23.25'),
 (215,1,6,79,12,22,'0.04'),
 (216,1,7,79,12,26,'0.05'),
 (217,1,8,79,12,4897,'8.80'),
 (218,1,9,79,12,1021,'1.84'),
 (219,1,10,79,12,60,'0.11'),
 (220,1,11,79,12,48,'0.09'),
 (221,1,12,79,12,2890,'5.20'),
 (222,1,13,79,12,59,'0.11'),
 (223,1,14,79,12,85,'0.15'),
 (224,1,15,79,12,98,'0.18'),
 (225,1,16,79,12,97,'0.17'),
 (226,1,17,79,12,544,'0.98'),
 (227,1,18,79,12,101,'0.18'),
 (228,1,19,79,12,293,'0.53'),
 (229,1,1,79,13,19478,'18.64'),
 (230,1,2,79,13,35476,'33.95'),
 (231,1,3,79,13,116,'0.11'),
 (232,1,4,79,13,64,'0.06'),
 (233,1,5,79,13,30354,'29.05'),
 (234,1,6,79,13,37,'0.04'),
 (235,1,7,79,13,90,'0.09'),
 (236,1,8,79,13,7478,'7.16'),
 (237,1,9,79,13,1630,'1.56'),
 (238,1,10,79,13,76,'0.07'),
 (239,1,11,79,13,107,'0.10'),
 (240,1,12,79,13,6440,'6.16'),
 (241,1,13,79,13,57,'0.05'),
 (242,1,14,79,13,163,'0.16'),
 (243,1,15,79,13,164,'0.16'),
 (244,1,16,79,13,154,'0.15'),
 (245,1,17,79,13,1163,'1.11'),
 (246,1,18,79,13,159,'0.15'),
 (247,1,19,79,13,440,'0.42'),
 (248,1,1,79,14,17476,'32.43'),
 (249,1,2,79,14,15343,'28.47'),
 (250,1,3,79,14,40,'0.07'),
 (251,1,4,79,14,35,'0.06'),
 (252,1,5,79,14,10270,'19.06'),
 (253,1,6,79,14,12,'0.02'),
 (254,1,7,79,14,30,'0.06'),
 (255,1,8,79,14,5427,'10.07'),
 (256,1,9,79,14,1013,'1.88'),
 (257,1,10,79,14,15,'0.03'),
 (258,1,11,79,14,35,'0.06'),
 (259,1,12,79,14,2384,'4.42'),
 (260,1,13,79,14,16,'0.03'),
 (261,1,14,79,14,50,'0.09'),
 (262,1,15,79,14,52,'0.10'),
 (263,1,16,79,14,56,'0.10'),
 (264,1,17,79,14,495,'0.92'),
 (265,1,18,79,14,45,'0.08'),
 (266,1,19,79,14,562,'1.04'),
 (267,1,1,79,15,42137,'38.39'),
 (268,1,2,79,15,27938,'25.45'),
 (269,1,3,79,15,91,'0.08'),
 (270,1,4,79,15,71,'0.06'),
 (271,1,5,79,15,16865,'15.36'),
 (272,1,6,79,15,24,'0.02'),
 (273,1,7,79,15,64,'0.06'),
 (274,1,8,79,15,12120,'11.04'),
 (275,1,9,79,15,2012,'1.83'),
 (276,1,10,79,15,58,'0.05'),
 (277,1,11,79,15,119,'0.11'),
 (278,1,12,79,15,4256,'3.88'),
 (279,1,13,79,15,40,'0.04'),
 (280,1,14,79,15,104,'0.09'),
 (281,1,15,79,15,81,'0.07'),
 (282,1,16,79,15,152,'0.14'),
 (283,1,17,79,15,950,'0.87'),
 (284,1,18,79,15,143,'0.13'),
 (285,1,19,79,15,1448,'1.32'),
 (286,1,1,79,16,34081,'36.69'),
 (287,1,2,79,16,22829,'24.58'),
 (288,1,3,79,16,48,'0.05'),
 (289,1,4,79,16,60,'0.06'),
 (290,1,5,79,16,14625,'15.75'),
 (291,1,6,79,16,15,'0.02'),
 (292,1,7,79,16,16,'0.02'),
 (293,1,8,79,16,12825,'13.81'),
 (294,1,9,79,16,1889,'2.03'),
 (295,1,10,79,16,55,'0.06'),
 (296,1,11,79,16,85,'0.09'),
 (297,1,12,79,16,2985,'3.21'),
 (298,1,13,79,16,31,'0.03'),
 (299,1,14,79,16,101,'0.11'),
 (300,1,15,79,16,70,'0.08'),
 (301,1,16,79,16,118,'0.13'),
 (302,1,17,79,16,721,'0.78'),
 (303,1,18,79,16,106,'0.11'),
 (304,1,19,79,16,1209,'1.30'),
 (305,1,1,79,17,14642,'23.51'),
 (306,1,2,79,17,20817,'33.42'),
 (307,1,3,79,17,81,'0.13'),
 (308,1,4,79,17,31,'0.05'),
 (309,1,5,79,17,14024,'22.52'),
 (310,1,6,79,17,26,'0.04'),
 (311,1,7,79,17,35,'0.06'),
 (312,1,8,79,17,5821,'9.35'),
 (313,1,9,79,17,1173,'1.88'),
 (314,1,10,79,17,22,'0.04'),
 (315,1,11,79,17,68,'0.11'),
 (316,1,12,79,17,3583,'5.75'),
 (317,1,13,79,17,41,'0.07'),
 (318,1,14,79,17,69,'0.11'),
 (319,1,15,79,17,71,'0.11'),
 (320,1,16,79,17,135,'0.22'),
 (321,1,17,79,17,665,'1.07'),
 (322,1,18,79,17,105,'0.17'),
 (323,1,19,79,17,327,'0.53'),
 (324,1,1,79,18,10193,'20.96'),
 (325,1,2,79,18,14116,'29.03'),
 (326,1,3,79,18,76,'0.16'),
 (327,1,4,79,18,11,'0.02'),
 (328,1,5,79,18,12646,'26.01'),
 (329,1,6,79,18,20,'0.04'),
 (330,1,7,79,18,24,'0.05'),
 (331,1,8,79,18,6246,'12.85'),
 (332,1,9,79,18,980,'2.02'),
 (333,1,10,79,18,11,'0.02'),
 (334,1,11,79,18,39,'0.08'),
 (335,1,12,79,18,2726,'5.61'),
 (336,1,13,79,18,18,'0.04'),
 (337,1,14,79,18,61,'0.13'),
 (338,1,15,79,18,39,'0.08'),
 (339,1,16,79,18,65,'0.13'),
 (340,1,17,79,18,567,'1.17'),
 (341,1,18,79,18,59,'0.12'),
 (342,1,19,79,18,250,'0.51'),
 (343,1,1,79,19,7485,'22.32'),
 (344,1,2,79,19,10529,'31.39'),
 (345,1,3,79,19,47,'0.14'),
 (346,1,4,79,19,23,'0.07'),
 (347,1,5,79,19,7498,'22.35'),
 (348,1,6,79,19,10,'0.03'),
 (349,1,7,79,19,29,'0.09'),
 (350,1,8,79,19,4221,'12.58'),
 (351,1,9,79,19,829,'2.47'),
 (352,1,10,79,19,16,'0.05'),
 (353,1,11,79,19,17,'0.05'),
 (354,1,12,79,19,1744,'5.20'),
 (355,1,13,79,19,20,'0.06'),
 (356,1,14,79,19,66,'0.20'),
 (357,1,15,79,19,56,'0.17'),
 (358,1,16,79,19,44,'0.13'),
 (359,1,17,79,19,310,'0.92'),
 (360,1,18,79,19,45,'0.13'),
 (361,1,19,79,19,162,'0.48'),
 (362,1,1,79,20,21426,'28.07'),
 (363,1,2,79,20,21975,'28.79'),
 (364,1,3,79,20,96,'0.13'),
 (365,1,4,79,20,50,'0.07'),
 (366,1,5,79,20,15404,'20.18'),
 (367,1,6,79,20,17,'0.02'),
 (368,1,7,79,20,40,'0.05'),
 (369,1,8,79,20,9176,'12.02'),
 (370,1,9,79,20,1675,'2.19'),
 (371,1,10,79,20,54,'0.07'),
 (372,1,11,79,20,59,'0.08'),
 (373,1,12,79,20,3761,'4.93'),
 (374,1,13,79,20,26,'0.03'),
 (375,1,14,79,20,92,'0.12'),
 (376,1,15,79,20,94,'0.12'),
 (377,1,16,79,20,140,'0.18'),
 (378,1,17,79,20,760,'1.00'),
 (379,1,18,79,20,108,'0.14'),
 (380,1,19,79,20,598,'0.78'),
 (381,1,1,79,21,8772,'35.75'),
 (382,1,2,79,21,5695,'23.21'),
 (383,1,3,79,21,26,'0.11'),
 (384,1,4,79,21,13,'0.05'),
 (385,1,5,79,21,3830,'15.61'),
 (386,1,6,79,21,2,'0.01'),
 (387,1,7,79,21,3,'0.01'),
 (388,1,8,79,21,3800,'15.49'),
 (389,1,9,79,21,579,'2.36'),
 (390,1,10,79,21,19,'0.08'),
 (391,1,11,79,21,14,'0.06'),
 (392,1,12,79,21,876,'3.57'),
 (393,1,13,79,21,6,'0.02'),
 (394,1,14,79,21,20,'0.08'),
 (395,1,15,79,21,17,'0.07'),
 (396,1,16,79,21,32,'0.13'),
 (397,1,17,79,21,254,'1.04'),
 (398,1,18,79,21,22,'0.09'),
 (399,1,19,79,21,295,'1.20'),
 (400,2,1,79,1,24560,'43.14'),
 (401,2,2,79,1,14201,'24.94'),
 (402,2,4,79,1,58,'0.10'),
 (403,2,6,79,1,20,'0.04'),
 (404,2,7,79,1,31,'0.05'),
 (405,2,8,79,1,158,'0.28'),
 (406,2,9,79,1,3843,'6.75'),
 (407,2,13,79,1,34,'0.06'),
 (408,2,14,79,1,158,'0.28'),
 (409,2,15,79,1,101,'0.18'),
 (410,2,16,79,1,86,'0.15'),
 (411,2,17,79,1,427,'0.75'),
 (412,2,20,79,1,9723,'17.08'),
 (413,2,21,79,1,749,'1.32'),
 (414,2,22,79,1,334,'0.59'),
 (415,2,23,79,1,1023,'1.80'),
 (416,2,24,79,1,23,'0.04'),
 (417,2,25,79,1,21,'0.04'),
 (418,2,1,79,2,39223,'50.59'),
 (419,2,2,79,2,18468,'23.82'),
 (420,2,4,79,2,81,'0.10'),
 (421,2,6,79,2,20,'0.03'),
 (422,2,7,79,2,47,'0.06'),
 (423,2,8,79,2,148,'0.19'),
 (424,2,9,79,2,5764,'7.43'),
 (425,2,13,79,2,31,'0.04'),
 (426,2,14,79,2,128,'0.17'),
 (427,2,15,79,2,101,'0.13'),
 (428,2,16,79,2,97,'0.13'),
 (429,2,17,79,2,347,'0.45'),
 (430,2,20,79,2,9121,'11.76'),
 (431,2,21,79,2,736,'0.95'),
 (432,2,22,79,2,310,'0.40'),
 (433,2,23,79,2,806,'1.04'),
 (434,2,24,79,2,35,'0.05'),
 (435,2,25,79,2,54,'0.07'),
 (436,2,1,79,3,42509,'61.63'),
 (437,2,2,79,3,12562,'18.21'),
 (438,2,4,79,3,100,'0.14'),
 (439,2,6,79,3,8,'0.01'),
 (440,2,7,79,3,38,'0.06'),
 (441,2,8,79,3,86,'0.12'),
 (442,2,9,79,3,4652,'6.74'),
 (443,2,13,79,3,20,'0.03'),
 (444,2,14,79,3,92,'0.13'),
 (445,2,15,79,3,87,'0.13'),
 (446,2,16,79,3,80,'0.12'),
 (447,2,17,79,3,309,'0.45'),
 (448,2,20,79,3,5395,'7.82'),
 (449,2,21,79,3,495,'0.72'),
 (450,2,22,79,3,356,'0.52'),
 (451,2,23,79,3,550,'0.80'),
 (452,2,24,79,3,26,'0.04'),
 (453,2,25,79,3,34,'0.05'),
 (454,2,1,79,4,54057,'69.24'),
 (455,2,2,79,4,11190,'14.33'),
 (456,2,4,79,4,145,'0.19'),
 (457,2,6,79,4,7,'0.01'),
 (458,2,7,79,4,37,'0.05'),
 (459,2,8,79,4,110,'0.14'),
 (460,2,9,79,4,4565,'5.85'),
 (461,2,13,79,4,29,'0.04'),
 (462,2,14,79,4,69,'0.09'),
 (463,2,15,79,4,70,'0.09'),
 (464,2,16,79,4,101,'0.13'),
 (465,2,17,79,4,282,'0.36'),
 (466,2,20,79,4,4326,'5.54'),
 (467,2,21,79,4,542,'0.69'),
 (468,2,22,79,4,305,'0.39'),
 (469,2,23,79,4,521,'0.67'),
 (470,2,24,79,4,22,'0.03'),
 (471,2,25,79,4,57,'0.07'),
 (472,2,1,79,5,53828,'68.97'),
 (473,2,2,79,5,11089,'14.21'),
 (474,2,4,79,5,124,'0.16'),
 (475,2,6,79,5,11,'0.01'),
 (476,2,7,79,5,18,'0.02'),
 (477,2,8,79,5,165,'0.21'),
 (478,2,9,79,5,4843,'6.21'),
 (479,2,13,79,5,20,'0.03'),
 (480,2,14,79,5,69,'0.09'),
 (481,2,15,79,5,78,'0.10'),
 (482,2,16,79,5,80,'0.10'),
 (483,2,17,79,5,255,'0.33'),
 (484,2,20,79,5,4197,'5.38'),
 (485,2,21,79,5,509,'0.65'),
 (486,2,22,79,5,421,'0.54'),
 (487,2,23,79,5,544,'0.70'),
 (488,2,24,79,5,23,'0.03'),
 (489,2,25,79,5,24,'0.03'),
 (490,2,1,79,6,38249,'56.42'),
 (491,2,2,79,6,15025,'22.16'),
 (492,2,4,79,6,109,'0.16'),
 (493,2,6,79,6,14,'0.02'),
 (494,2,7,79,6,45,'0.07'),
 (495,2,8,79,6,116,'0.17'),
 (496,2,9,79,6,4430,'6.53'),
 (497,2,13,79,6,35,'0.05'),
 (498,2,14,79,6,139,'0.21'),
 (499,2,15,79,6,89,'0.13'),
 (500,2,16,79,6,130,'0.19'),
 (501,2,17,79,6,326,'0.48'),
 (502,2,20,79,6,5881,'8.68'),
 (503,2,21,79,6,533,'0.79'),
 (504,2,22,79,6,312,'0.46'),
 (505,2,23,79,6,647,'0.95'),
 (506,2,24,79,6,38,'0.06'),
 (507,2,25,79,6,41,'0.06'),
 (508,2,1,79,7,49107,'64.36'),
 (509,2,2,79,7,12636,'16.56'),
 (510,2,4,79,7,127,'0.17'),
 (511,2,6,79,7,7,'0.01'),
 (512,2,7,79,7,21,'0.03'),
 (513,2,8,79,7,142,'0.19'),
 (514,2,9,79,7,4888,'6.41'),
 (515,2,13,79,7,32,'0.04'),
 (516,2,14,79,7,68,'0.09'),
 (517,2,15,79,7,86,'0.11'),
 (518,2,16,79,7,101,'0.13'),
 (519,2,17,79,7,280,'0.37'),
 (520,2,20,79,7,5493,'7.20'),
 (521,2,21,79,7,527,'0.69'),
 (522,2,22,79,7,329,'0.43'),
 (523,2,23,79,7,606,'0.79'),
 (524,2,24,79,7,25,'0.03'),
 (525,2,25,79,7,41,'0.05'),
 (526,2,1,79,8,68507,'57.39'),
 (527,2,2,79,8,26253,'21.99'),
 (528,2,4,79,8,216,'0.18'),
 (529,2,6,79,8,24,'0.02'),
 (530,2,7,79,8,71,'0.06'),
 (531,2,8,79,8,248,'0.21'),
 (532,2,9,79,8,8451,'7.08'),
 (533,2,13,79,8,49,'0.04'),
 (534,2,14,79,8,183,'0.15'),
 (535,2,15,79,8,177,'0.15'),
 (536,2,16,79,8,194,'0.16'),
 (537,2,17,79,8,552,'0.46'),
 (538,2,20,79,8,9058,'7.59'),
 (539,2,21,79,8,898,'0.75'),
 (540,2,22,79,8,483,'0.40'),
 (541,2,23,79,8,1006,'0.84'),
 (542,2,24,79,8,50,'0.04'),
 (543,2,25,79,8,74,'0.06'),
 (544,2,1,79,9,37288,'61.37'),
 (545,2,2,79,9,11270,'18.55'),
 (546,2,4,79,9,105,'0.17'),
 (547,2,6,79,9,11,'0.02'),
 (548,2,7,79,9,24,'0.04'),
 (549,2,8,79,9,102,'0.17'),
 (550,2,9,79,9,3884,'6.39'),
 (551,2,13,79,9,22,'0.04'),
 (552,2,14,79,9,63,'0.10'),
 (553,2,15,79,9,53,'0.09'),
 (554,2,16,79,9,74,'0.12'),
 (555,2,17,79,9,229,'0.38'),
 (556,2,20,79,9,5047,'8.31'),
 (557,2,21,79,9,402,'0.66'),
 (558,2,22,79,9,257,'0.42'),
 (559,2,23,79,9,495,'0.81'),
 (560,2,24,79,9,23,'0.04'),
 (561,2,25,79,9,27,'0.04'),
 (562,2,1,79,10,60340,'51.26'),
 (563,2,2,79,10,31523,'26.78'),
 (564,2,4,79,10,127,'0.11'),
 (565,2,6,79,10,33,'0.03'),
 (566,2,7,79,10,115,'0.10'),
 (567,2,8,79,10,195,'0.17'),
 (568,2,9,79,10,6810,'5.78'),
 (569,2,13,79,10,67,'0.06'),
 (570,2,14,79,10,206,'0.17'),
 (571,2,15,79,10,202,'0.17'),
 (572,2,16,79,10,250,'0.21'),
 (573,2,17,79,10,585,'0.50'),
 (574,2,20,79,10,12249,'10.40'),
 (575,2,21,79,10,834,'0.71'),
 (576,2,22,79,10,486,'0.41'),
 (577,2,23,79,10,1128,'0.96'),
 (578,2,24,79,10,67,'0.06'),
 (579,2,25,79,10,75,'0.06'),
 (580,2,1,79,11,50940,'48.64'),
 (581,2,2,79,11,30295,'28.93'),
 (582,2,4,79,11,108,'0.10'),
 (583,2,6,79,11,45,'0.04'),
 (584,2,7,79,11,73,'0.07'),
 (585,2,8,79,11,212,'0.20'),
 (586,2,9,79,11,6211,'5.93'),
 (587,2,13,79,11,55,'0.05'),
 (588,2,14,79,11,183,'0.17'),
 (589,2,15,79,11,204,'0.19'),
 (590,2,16,79,11,216,'0.21'),
 (591,2,17,79,11,502,'0.48'),
 (592,2,20,79,11,11071,'10.57'),
 (593,2,21,79,11,719,'0.69'),
 (594,2,22,79,11,395,'0.38'),
 (595,2,23,79,11,1004,'0.96'),
 (596,2,24,79,11,71,'0.07'),
 (597,2,25,79,11,66,'0.06'),
 (598,2,1,79,12,21949,'42.34'),
 (599,2,2,79,12,17846,'34.42'),
 (600,2,4,79,12,54,'0.10'),
 (601,2,6,79,12,21,'0.04'),
 (602,2,7,79,12,36,'0.07'),
 (603,2,8,79,12,75,'0.14'),
 (604,2,9,79,12,2770,'5.34'),
 (605,2,13,79,12,33,'0.06'),
 (606,2,14,79,12,89,'0.17'),
 (607,2,15,79,12,120,'0.23'),
 (608,2,16,79,12,127,'0.24'),
 (609,2,17,79,12,289,'0.56'),
 (610,2,20,79,12,6179,'11.92'),
 (611,2,21,79,12,279,'0.54'),
 (612,2,22,79,12,189,'0.36'),
 (613,2,23,79,12,521,'1.00'),
 (614,2,24,79,12,41,'0.08'),
 (615,2,25,79,12,30,'0.06'),
 (616,2,1,79,13,32160,'33.72'),
 (617,2,2,79,13,37247,'39.05'),
 (618,2,4,79,13,100,'0.10'),
 (619,2,6,79,13,33,'0.03'),
 (620,2,7,79,13,80,'0.08'),
 (621,2,8,79,13,180,'0.19'),
 (622,2,9,79,13,4512,'4.73'),
 (623,2,13,79,13,41,'0.04'),
 (624,2,14,79,13,187,'0.20'),
 (625,2,15,79,13,273,'0.29'),
 (626,2,16,79,13,201,'0.21'),
 (627,2,17,79,13,612,'0.64'),
 (628,2,20,79,13,15550,'16.30'),
 (629,2,21,79,13,616,'0.65'),
 (630,2,22,79,13,336,'0.35'),
 (631,2,23,79,13,981,'1.03'),
 (632,2,24,79,13,94,'0.10'),
 (633,2,25,79,13,87,'0.09'),
 (634,2,1,79,14,25442,'49.14'),
 (635,2,2,79,14,14417,'27.84'),
 (636,2,4,79,14,62,'0.12'),
 (637,2,6,79,14,15,'0.03'),
 (638,2,7,79,14,47,'0.09'),
 (639,2,8,79,14,73,'0.14'),
 (640,2,9,79,14,3295,'6.36'),
 (641,2,13,79,14,29,'0.06'),
 (642,2,14,79,14,63,'0.12'),
 (643,2,15,79,14,92,'0.18'),
 (644,2,16,79,14,103,'0.20'),
 (645,2,17,79,14,264,'0.51'),
 (646,2,20,79,14,5711,'11.03'),
 (647,2,21,79,14,320,'0.62'),
 (648,2,22,79,14,239,'0.46'),
 (649,2,23,79,14,415,'0.80'),
 (650,2,24,79,14,29,'0.06'),
 (651,2,25,79,14,24,'0.05'),
 (652,2,1,79,15,59421,'56.08'),
 (653,2,2,79,15,24806,'23.41'),
 (654,2,4,79,15,136,'0.13'),
 (655,2,6,79,15,22,'0.02'),
 (656,2,7,79,15,75,'0.07'),
 (657,2,8,79,15,157,'0.15'),
 (658,2,9,79,15,6468,'6.10'),
 (659,2,13,79,15,52,'0.05'),
 (660,2,14,79,15,144,'0.14'),
 (661,2,15,79,15,146,'0.14'),
 (662,2,16,79,15,161,'0.15'),
 (663,2,17,79,15,500,'0.47'),
 (664,2,20,79,15,9257,'8.74'),
 (665,2,21,79,15,738,'0.70'),
 (666,2,22,79,15,470,'0.44'),
 (667,2,23,79,15,919,'0.87'),
 (668,2,24,79,15,50,'0.05'),
 (669,2,25,79,15,67,'0.06'),
 (670,2,1,79,16,45832,'54.08'),
 (671,2,2,79,16,20144,'23.77'),
 (672,2,4,79,16,90,'0.11'),
 (673,2,6,79,16,10,'0.01'),
 (674,2,7,79,16,38,'0.04'),
 (675,2,8,79,16,161,'0.19'),
 (676,2,9,79,16,6074,'7.17'),
 (677,2,13,79,16,18,'0.02'),
 (678,2,14,79,16,99,'0.12'),
 (679,2,15,79,16,122,'0.14'),
 (680,2,16,79,16,129,'0.15'),
 (681,2,17,79,16,354,'0.42'),
 (682,2,20,79,16,7587,'8.95'),
 (683,2,21,79,16,669,'0.79'),
 (684,2,22,79,16,412,'0.49'),
 (685,2,23,79,16,750,'0.89'),
 (686,2,24,79,16,52,'0.06'),
 (687,2,25,79,16,55,'0.06'),
 (688,2,1,79,17,24278,'41.68'),
 (689,2,2,79,17,20365,'34.96'),
 (690,2,4,79,17,61,'0.10'),
 (691,2,6,79,17,26,'0.04'),
 (692,2,7,79,17,63,'0.11'),
 (693,2,8,79,17,89,'0.15'),
 (694,2,9,79,17,3074,'5.28'),
 (695,2,13,79,17,45,'0.08'),
 (696,2,14,79,17,87,'0.15'),
 (697,2,15,79,17,117,'0.20'),
 (698,2,16,79,17,143,'0.25'),
 (699,2,17,79,17,275,'0.47'),
 (700,2,20,79,17,7146,'12.27'),
 (701,2,21,79,17,396,'0.68'),
 (702,2,22,79,17,162,'0.28'),
 (703,2,23,79,17,503,'0.86'),
 (704,2,24,79,17,41,'0.07'),
 (705,2,25,79,17,42,'0.07'),
 (706,2,1,79,18,15088,'38.23'),
 (707,2,2,79,18,12461,'31.58'),
 (708,2,4,79,18,39,'0.10'),
 (709,2,6,79,18,6,'0.02'),
 (710,2,7,79,18,24,'0.06'),
 (711,2,8,79,18,69,'0.17'),
 (712,2,9,79,18,2856,'7.24'),
 (713,2,13,79,18,11,'0.03'),
 (714,2,14,79,18,59,'0.15'),
 (715,2,15,79,18,64,'0.16'),
 (716,2,16,79,18,81,'0.21'),
 (717,2,17,79,18,256,'0.65'),
 (718,2,20,79,18,6284,'15.92'),
 (719,2,21,79,18,332,'0.84'),
 (720,2,22,79,18,168,'0.43'),
 (721,2,23,79,18,474,'1.20'),
 (722,2,24,79,18,33,'0.08'),
 (723,2,25,79,18,34,'0.09'),
 (724,2,1,79,19,11861,'39.49'),
 (725,2,2,79,19,9743,'32.44'),
 (726,2,4,79,19,22,'0.07'),
 (727,2,6,79,19,4,'0.01'),
 (728,2,7,79,19,19,'0.06'),
 (729,2,8,79,19,43,'0.14'),
 (730,2,9,79,19,2497,'8.31'),
 (731,2,13,79,19,4,'0.01'),
 (732,2,14,79,19,50,'0.17'),
 (733,2,15,79,19,49,'0.16'),
 (734,2,16,79,19,70,'0.23'),
 (735,2,17,79,19,123,'0.41'),
 (736,2,20,79,19,4100,'13.65'),
 (737,2,21,79,19,180,'0.60'),
 (738,2,22,79,19,111,'0.37'),
 (739,2,23,79,19,321,'1.07'),
 (740,2,24,79,19,29,'0.10'),
 (741,2,25,79,19,19,'0.06'),
 (742,2,1,79,20,32426,'46.04'),
 (743,2,2,79,20,20517,'29.13'),
 (744,2,4,79,20,58,'0.08'),
 (745,2,6,79,20,12,'0.02'),
 (746,2,7,79,20,50,'0.07'),
 (747,2,8,79,20,127,'0.18'),
 (748,2,9,79,20,4917,'6.98'),
 (749,2,13,79,20,32,'0.05'),
 (750,2,14,79,20,98,'0.14'),
 (751,2,15,79,20,112,'0.16'),
 (752,2,16,79,20,157,'0.22'),
 (753,2,17,79,20,378,'0.54'),
 (754,2,20,79,20,8179,'11.61'),
 (755,2,21,79,20,502,'0.71'),
 (756,2,22,79,20,259,'0.37'),
 (757,2,23,79,20,757,'1.07'),
 (758,2,24,79,20,37,'0.05'),
 (759,2,25,79,20,51,'0.07'),
 (760,2,1,79,21,12310,'55.70'),
 (761,2,2,79,21,4671,'21.14'),
 (762,2,4,79,21,15,'0.07'),
 (763,2,6,79,21,1,'0.00'),
 (764,2,7,79,21,9,'0.04'),
 (765,2,8,79,21,45,'0.20'),
 (766,2,9,79,21,1662,'7.52'),
 (767,2,13,79,21,9,'0.04'),
 (768,2,14,79,21,20,'0.09'),
 (769,2,15,79,21,17,'0.08'),
 (770,2,16,79,21,36,'0.16'),
 (771,2,17,79,21,132,'0.60'),
 (772,2,20,79,21,2085,'9.43'),
 (773,2,21,79,21,199,'0.90'),
 (774,2,22,79,21,107,'0.48'),
 (775,2,23,79,21,212,'0.96'),
 (776,2,24,79,21,7,'0.03'),
 (777,2,25,79,21,17,'0.08'),
 (778,3,1,79,1,28135,'47.90'),
 (779,3,2,79,1,18751,'31.92'),
 (780,3,4,79,1,129,'0.22'),
 (781,3,12,79,1,9243,'15.73'),
 (782,3,14,79,1,51,'0.09'),
 (783,3,15,79,1,46,'0.08'),
 (784,3,16,79,1,68,'0.12'),
 (785,3,17,79,1,117,'0.20'),
 (786,3,26,79,1,12,'0.02'),
 (787,3,27,79,1,19,'0.03'),
 (788,3,28,79,1,45,'0.08'),
 (789,3,29,79,1,0,'0.00'),
 (790,3,30,79,1,0,'0.00'),
 (791,3,31,79,1,654,'1.11'),
 (792,3,32,79,1,22,'0.04'),
 (793,3,33,79,1,83,'0.14'),
 (794,3,34,79,1,240,'0.41'),
 (795,3,35,79,1,11,'0.02'),
 (796,3,36,79,1,30,'0.05'),
 (797,3,37,79,1,23,'0.04'),
 (798,3,1,79,2,42038,'54.62'),
 (799,3,2,79,2,22942,'29.81'),
 (800,3,4,79,2,168,'0.22'),
 (801,3,12,79,2,8574,'11.14'),
 (802,3,14,79,2,40,'0.05'),
 (803,3,15,79,2,272,'0.35'),
 (804,3,16,79,2,62,'0.08'),
 (805,3,17,79,2,145,'0.19'),
 (806,3,26,79,2,19,'0.02'),
 (807,3,27,79,2,47,'0.06'),
 (808,3,28,79,2,64,'0.08'),
 (809,3,29,79,2,0,'0.00'),
 (810,3,30,79,2,6,'0.01'),
 (811,3,31,79,2,674,'0.88'),
 (812,3,32,79,2,20,'0.03'),
 (813,3,33,79,2,130,'0.17'),
 (814,3,34,79,2,48,'0.06'),
 (815,3,35,79,2,13,'0.02'),
 (816,3,36,79,2,58,'0.08'),
 (817,3,37,79,2,57,'0.07'),
 (818,3,1,79,3,47777,'65.63'),
 (819,3,2,79,3,16131,'22.16'),
 (820,3,4,79,3,171,'0.23'),
 (821,3,12,79,3,5959,'8.19'),
 (822,3,14,79,3,34,'0.05'),
 (823,3,15,79,3,114,'0.16'),
 (824,3,16,79,3,56,'0.08'),
 (825,3,17,79,3,136,'0.19'),
 (826,3,26,79,3,25,'0.03'),
 (827,3,27,79,3,17,'0.02'),
 (828,3,28,79,3,38,'0.05'),
 (829,3,29,79,3,0,'0.00'),
 (830,3,30,79,3,11,'0.02'),
 (831,3,31,79,3,557,'0.77'),
 (832,3,32,79,3,25,'0.03'),
 (833,3,33,79,3,122,'0.17'),
 (834,3,34,79,3,50,'0.07'),
 (835,3,35,79,3,18,'0.02'),
 (836,3,36,79,3,28,'0.04'),
 (837,3,37,79,3,41,'0.06'),
 (838,3,1,79,4,58489,'72.37'),
 (839,3,2,79,4,14726,'18.22'),
 (840,3,4,79,4,258,'0.32'),
 (841,3,12,79,4,4588,'5.68'),
 (842,3,14,79,4,36,'0.04'),
 (843,3,15,79,4,208,'0.26'),
 (844,3,16,79,4,59,'0.07'),
 (845,3,17,79,4,123,'0.15'),
 (846,3,26,79,4,33,'0.04'),
 (847,3,27,79,4,27,'0.03'),
 (848,3,28,79,4,36,'0.04'),
 (849,3,29,79,4,0,'0.00'),
 (850,3,30,79,4,4,'0.00'),
 (851,3,31,79,4,569,'0.70'),
 (852,3,32,79,4,21,'0.03'),
 (853,3,33,79,4,122,'0.15'),
 (854,3,34,79,4,29,'0.04'),
 (855,3,35,79,4,14,'0.02'),
 (856,3,36,79,4,33,'0.04'),
 (857,3,37,79,4,37,'0.05'),
 (858,3,1,79,5,57962,'72.04'),
 (859,3,2,79,5,14598,'18.14'),
 (860,3,4,79,5,180,'0.22'),
 (861,3,12,79,5,4891,'6.08'),
 (862,3,14,79,5,30,'0.04'),
 (863,3,15,79,5,23,'0.03'),
 (864,3,16,79,5,53,'0.07'),
 (865,3,17,79,5,123,'0.15'),
 (866,3,26,79,5,11,'0.01'),
 (867,3,27,79,5,18,'0.02'),
 (868,3,28,79,5,34,'0.04'),
 (869,3,29,79,5,0,'0.00'),
 (870,3,30,79,5,7,'0.01'),
 (871,3,31,79,5,589,'0.73'),
 (872,3,32,79,5,26,'0.03'),
 (873,3,33,79,5,176,'0.22'),
 (874,3,34,79,5,33,'0.04'),
 (875,3,35,79,5,31,'0.04'),
 (876,3,36,79,5,32,'0.04'),
 (877,3,37,79,5,32,'0.04'),
 (878,3,1,79,6,42000,'59.62'),
 (879,3,2,79,6,19713,'27.99'),
 (880,3,4,79,6,170,'0.24'),
 (881,3,12,79,6,5919,'8.40'),
 (882,3,14,79,6,71,'0.10'),
 (883,3,15,79,6,55,'0.08'),
 (884,3,16,79,6,90,'0.13'),
 (885,3,17,79,6,128,'0.18'),
 (886,3,26,79,6,22,'0.03'),
 (887,3,27,79,6,41,'0.06'),
 (888,3,28,79,6,62,'0.09'),
 (889,3,29,79,6,0,'0.00'),
 (890,3,30,79,6,5,'0.01'),
 (891,3,31,79,6,607,'0.86'),
 (892,3,32,79,6,37,'0.05'),
 (893,3,33,79,6,99,'0.14'),
 (894,3,34,79,6,50,'0.07'),
 (895,3,35,79,6,8,'0.01'),
 (896,3,36,79,6,88,'0.12'),
 (897,3,37,79,6,41,'0.06'),
 (898,3,1,79,7,55031,'68.80'),
 (899,3,2,79,7,16389,'20.49'),
 (900,3,4,79,7,237,'0.30'),
 (901,3,12,79,7,5713,'7.14'),
 (902,3,14,79,7,31,'0.04'),
 (903,3,15,79,7,28,'0.04'),
 (904,3,16,79,7,72,'0.09'),
 (905,3,17,79,7,129,'0.16'),
 (906,3,26,79,7,13,'0.02'),
 (907,3,27,79,7,18,'0.02'),
 (908,3,28,79,7,42,'0.05'),
 (909,3,29,79,7,0,'0.00'),
 (910,3,30,79,7,4,'0.01'),
 (911,3,31,79,7,536,'0.67'),
 (912,3,32,79,7,23,'0.03'),
 (913,3,33,79,7,126,'0.16'),
 (914,3,34,79,7,29,'0.04'),
 (915,3,35,79,7,29,'0.04'),
 (916,3,36,79,7,37,'0.05'),
 (917,3,37,79,7,27,'0.03'),
 (918,3,1,79,8,69084,'59.17'),
 (919,3,2,79,8,33610,'28.79'),
 (920,3,4,79,8,286,'0.24'),
 (921,3,12,79,8,9002,'7.71'),
 (922,3,14,79,8,68,'0.06'),
 (923,3,15,79,8,95,'0.08'),
 (924,3,16,79,8,116,'0.10'),
 (925,3,17,79,8,214,'0.18'),
 (926,3,26,79,8,26,'0.02'),
 (927,3,27,79,8,43,'0.04'),
 (928,3,28,79,8,59,'0.05'),
 (929,3,29,79,8,0,'0.00'),
 (930,3,30,79,8,6,'0.01'),
 (931,3,31,79,8,1198,'1.03'),
 (932,3,32,79,8,55,'0.05'),
 (933,3,33,79,8,188,'0.16'),
 (934,3,34,79,8,91,'0.08'),
 (935,3,35,79,8,13,'0.01'),
 (936,3,36,79,8,106,'0.09'),
 (937,3,37,79,8,69,'0.06'),
 (938,3,1,79,9,40078,'64.16'),
 (939,3,2,79,9,14798,'23.69'),
 (940,3,4,79,9,172,'0.28'),
 (941,3,12,79,9,5119,'8.20'),
 (942,3,14,79,9,17,'0.03'),
 (943,3,15,79,9,32,'0.05'),
 (944,3,16,79,9,47,'0.08'),
 (945,3,17,79,9,120,'0.19'),
 (946,3,26,79,9,64,'0.10'),
 (947,3,27,79,9,23,'0.04'),
 (948,3,28,79,9,39,'0.06'),
 (949,3,29,79,9,0,'0.00'),
 (950,3,30,79,9,4,'0.01'),
 (951,3,31,79,9,520,'0.83'),
 (952,3,32,79,9,24,'0.04'),
 (953,3,33,79,9,102,'0.16'),
 (954,3,34,79,9,26,'0.04'),
 (955,3,35,79,9,17,'0.03'),
 (956,3,36,79,9,38,'0.06'),
 (957,3,37,79,9,33,'0.05'),
 (958,3,1,79,10,68756,'53.55'),
 (959,3,2,79,10,42785,'33.32'),
 (960,3,4,79,10,229,'0.18'),
 (961,3,12,79,10,12000,'9.35'),
 (962,3,14,79,10,75,'0.06'),
 (963,3,15,79,10,100,'0.08'),
 (964,3,16,79,10,132,'0.10'),
 (965,3,17,79,10,225,'0.18'),
 (966,3,26,79,10,38,'0.03'),
 (967,3,27,79,10,78,'0.06'),
 (968,3,28,79,10,95,'0.07'),
 (969,3,29,79,10,0,'0.00'),
 (970,3,30,79,10,18,'0.01'),
 (971,3,31,79,10,1143,'0.89'),
 (972,3,32,79,10,59,'0.05'),
 (973,3,33,79,10,213,'0.17'),
 (974,3,34,79,10,83,'0.06'),
 (975,3,35,79,10,17,'0.01'),
 (976,3,36,79,10,142,'0.11'),
 (977,3,37,79,10,65,'0.05'),
 (978,3,1,79,11,55623,'50.55'),
 (979,3,2,79,11,39394,'35.80'),
 (980,3,4,79,11,210,'0.19'),
 (981,3,12,79,11,10815,'9.83'),
 (982,3,14,79,11,73,'0.07'),
 (983,3,15,79,11,79,'0.07'),
 (984,3,16,79,11,125,'0.11'),
 (985,3,17,79,11,202,'0.18'),
 (986,3,26,79,11,31,'0.03'),
 (987,3,27,79,11,78,'0.07'),
 (988,3,28,79,11,109,'0.10'),
 (989,3,29,79,11,0,'0.00'),
 (990,3,30,79,11,15,'0.01'),
 (991,3,31,79,11,932,'0.85'),
 (992,3,32,79,11,51,'0.05'),
 (993,3,33,79,11,178,'0.16'),
 (994,3,34,79,11,64,'0.06'),
 (995,3,35,79,11,20,'0.02'),
 (996,3,36,79,11,127,'0.12'),
 (997,3,37,79,11,64,'0.06'),
 (998,3,1,79,12,24366,'43.49'),
 (999,3,2,79,12,23851,'42.57'),
 (1000,3,4,79,12,93,'0.17'),
 (1001,3,12,79,12,5831,'10.41'),
 (1002,3,14,79,12,32,'0.06'),
 (1003,3,15,79,12,52,'0.09'),
 (1004,3,16,79,12,74,'0.13'),
 (1005,3,17,79,12,96,'0.17'),
 (1006,3,26,79,12,22,'0.04'),
 (1007,3,27,79,12,28,'0.05'),
 (1008,3,28,79,12,62,'0.11'),
 (1009,3,29,79,12,0,'0.00'),
 (1010,3,30,79,12,10,'0.02'),
 (1011,3,31,79,12,534,'0.95'),
 (1012,3,32,79,12,21,'0.04'),
 (1013,3,33,79,12,67,'0.12'),
 (1014,3,34,79,12,29,'0.05'),
 (1015,3,35,79,12,12,'0.02'),
 (1016,3,36,79,12,47,'0.08'),
 (1017,3,37,79,12,23,'0.04'),
 (1018,3,1,79,13,35029,'33.77'),
 (1019,3,2,79,13,51316,'49.47'),
 (1020,3,4,79,13,125,'0.12'),
 (1021,3,12,79,13,13759,'13.26'),
 (1022,3,14,79,13,86,'0.08'),
 (1023,3,15,79,13,121,'0.12'),
 (1024,3,16,79,13,132,'0.13'),
 (1025,3,17,79,13,233,'0.22'),
 (1026,3,26,79,13,32,'0.03'),
 (1027,3,27,79,13,56,'0.05'),
 (1028,3,28,79,13,81,'0.08'),
 (1029,3,29,79,13,0,'0.00'),
 (1030,3,30,79,13,8,'0.01'),
 (1031,3,31,79,13,946,'0.91'),
 (1032,3,32,79,13,51,'0.05'),
 (1033,3,33,79,13,135,'0.13'),
 (1034,3,34,79,13,65,'0.06'),
 (1035,3,35,79,13,21,'0.02'),
 (1036,3,36,79,13,105,'0.10'),
 (1037,3,37,79,13,36,'0.03'),
 (1038,3,1,79,14,28987,'52.03'),
 (1039,3,2,79,14,19201,'34.46'),
 (1040,3,4,79,14,94,'0.17'),
 (1041,3,12,79,14,5477,'9.83'),
 (1042,3,14,79,14,21,'0.04'),
 (1043,3,15,79,14,46,'0.08'),
 (1044,3,16,79,14,46,'0.08'),
 (1045,3,17,79,14,89,'0.16'),
 (1046,3,26,79,14,20,'0.04'),
 (1047,3,27,79,14,40,'0.07'),
 (1048,3,28,79,14,39,'0.07'),
 (1049,3,29,79,14,0,'0.00'),
 (1050,3,30,79,14,11,'0.02'),
 (1051,3,31,79,14,490,'0.88'),
 (1052,3,32,79,14,23,'0.04'),
 (1053,3,33,79,14,121,'0.22'),
 (1054,3,34,79,14,51,'0.09'),
 (1055,3,35,79,14,9,'0.02'),
 (1056,3,36,79,14,21,'0.04'),
 (1057,3,37,79,14,33,'0.06'),
 (1058,3,1,79,15,66483,'59.01'),
 (1059,3,2,79,15,32555,'28.90'),
 (1060,3,4,79,15,209,'0.19'),
 (1061,3,12,79,15,9328,'8.28'),
 (1062,3,14,79,15,54,'0.05'),
 (1063,3,15,79,15,87,'0.08'),
 (1064,3,16,79,15,88,'0.08'),
 (1065,3,17,79,15,225,'0.20'),
 (1066,3,26,79,15,38,'0.03'),
 (1067,3,27,79,15,49,'0.04'),
 (1068,3,28,79,15,86,'0.08'),
 (1069,3,29,79,15,0,'0.00'),
 (1070,3,30,79,15,9,'0.01'),
 (1071,3,31,79,15,1024,'0.91'),
 (1072,3,32,79,15,27,'0.02'),
 (1073,3,33,79,15,183,'0.16'),
 (1074,3,34,79,15,65,'0.06'),
 (1075,3,35,79,15,18,'0.02'),
 (1076,3,36,79,15,100,'0.09'),
 (1077,3,37,79,15,59,'0.05'),
 (1078,3,1,79,16,46404,'55.39'),
 (1079,3,2,79,16,26798,'31.99'),
 (1080,3,4,79,16,137,'0.16'),
 (1081,3,12,79,16,7224,'8.62'),
 (1082,3,14,79,16,39,'0.05'),
 (1083,3,15,79,16,48,'0.06'),
 (1084,3,16,79,16,66,'0.08'),
 (1085,3,17,79,16,140,'0.17'),
 (1086,3,26,79,16,23,'0.03'),
 (1087,3,27,79,16,39,'0.05'),
 (1088,3,28,79,16,44,'0.05'),
 (1089,3,29,79,16,0,'0.00'),
 (1090,3,30,79,16,4,'0.00'),
 (1091,3,31,79,16,831,'0.99'),
 (1092,3,32,79,16,33,'0.04'),
 (1093,3,33,79,16,147,'0.18'),
 (1094,3,34,79,16,53,'0.06'),
 (1095,3,35,79,16,7,'0.01'),
 (1096,3,36,79,16,57,'0.07'),
 (1097,3,37,79,16,40,'0.05'),
 (1098,3,1,79,17,26767,'43.24'),
 (1099,3,2,79,17,26375,'42.61'),
 (1100,3,4,79,17,77,'0.12'),
 (1101,3,12,79,17,6523,'10.54'),
 (1102,3,14,79,17,32,'0.05'),
 (1103,3,15,79,17,53,'0.09'),
 (1104,3,16,79,17,73,'0.12'),
 (1105,3,17,79,17,109,'0.18'),
 (1106,3,26,79,17,11,'0.02'),
 (1107,3,27,79,17,36,'0.06'),
 (1108,3,28,79,17,50,'0.08'),
 (1109,3,29,79,17,0,'0.00'),
 (1110,3,30,79,17,15,'0.02'),
 (1111,3,31,79,17,558,'0.90'),
 (1112,3,32,79,17,34,'0.05'),
 (1113,3,33,79,17,89,'0.14'),
 (1114,3,34,79,17,44,'0.07'),
 (1115,3,35,79,17,18,'0.03'),
 (1116,3,36,79,17,68,'0.11'),
 (1117,3,37,79,17,43,'0.07'),
 (1118,3,1,79,18,12556,'40.61'),
 (1119,3,2,79,18,13548,'43.82'),
 (1120,3,4,79,18,34,'0.11'),
 (1121,3,12,79,18,3557,'11.50'),
 (1122,3,14,79,18,20,'0.06'),
 (1123,3,15,79,18,22,'0.07'),
 (1124,3,16,79,18,32,'0.10'),
 (1125,3,17,79,18,61,'0.20'),
 (1126,3,26,79,18,11,'0.04'),
 (1127,3,27,79,18,12,'0.04'),
 (1128,3,28,79,18,20,'0.06'),
 (1129,3,29,79,18,0,'0.00'),
 (1130,3,30,79,18,0,'0.00'),
 (1131,3,31,79,18,345,'1.12'),
 (1132,3,32,79,18,16,'0.05'),
 (1133,3,33,79,18,37,'0.12'),
 (1134,3,34,79,18,22,'0.07'),
 (1135,3,35,79,18,7,'0.02'),
 (1136,3,36,79,18,43,'0.14'),
 (1137,3,37,79,18,16,'0.05'),
 (1138,3,1,79,19,12178,'40.45'),
 (1139,3,2,79,19,13070,'43.41'),
 (1140,3,4,79,19,41,'0.14'),
 (1141,3,12,79,19,3535,'11.74'),
 (1142,3,14,79,19,18,'0.06'),
 (1143,3,15,79,19,18,'0.06'),
 (1144,3,16,79,19,37,'0.12'),
 (1145,3,17,79,19,60,'0.20'),
 (1146,3,26,79,19,9,'0.03'),
 (1147,3,27,79,19,29,'0.10'),
 (1148,3,28,79,19,23,'0.08'),
 (1149,3,29,79,19,0,'0.00'),
 (1150,3,30,79,19,2,'0.01'),
 (1151,3,31,79,19,376,'1.25'),
 (1152,3,32,79,19,23,'0.08'),
 (1153,3,33,79,19,60,'0.20'),
 (1154,3,34,79,19,17,'0.06'),
 (1155,3,35,79,19,5,'0.02'),
 (1156,3,36,79,19,20,'0.07'),
 (1157,3,37,79,19,25,'0.08'),
 (1158,3,1,79,20,34380,'47.53'),
 (1159,3,2,79,20,27666,'38.25'),
 (1160,3,4,79,20,73,'0.10'),
 (1161,3,12,79,20,7357,'10.17'),
 (1162,3,14,79,20,46,'0.06'),
 (1163,3,15,79,20,211,'0.29'),
 (1164,3,16,79,20,75,'0.10'),
 (1165,3,17,79,20,134,'0.19'),
 (1166,3,26,79,20,13,'0.02'),
 (1167,3,27,79,20,69,'0.10'),
 (1168,3,28,79,20,69,'0.10'),
 (1169,3,29,79,20,0,'0.00'),
 (1170,3,30,79,20,11,'0.02'),
 (1171,3,31,79,20,715,'0.99'),
 (1172,3,32,79,20,34,'0.05'),
 (1173,3,33,79,20,80,'0.11'),
 (1174,3,34,79,20,39,'0.05'),
 (1175,3,35,79,20,11,'0.02'),
 (1176,3,36,79,20,101,'0.14'),
 (1177,3,37,79,20,38,'0.05'),
 (1178,3,1,79,21,13011,'59.17'),
 (1179,3,2,79,21,6140,'27.92'),
 (1180,3,4,79,21,26,'0.12'),
 (1181,3,12,79,21,1916,'8.71'),
 (1182,3,14,79,21,6,'0.03'),
 (1183,3,15,79,21,13,'0.06'),
 (1184,3,16,79,21,18,'0.08'),
 (1185,3,17,79,21,37,'0.17'),
 (1186,3,26,79,21,5,'0.02'),
 (1187,3,27,79,21,13,'0.06'),
 (1188,3,28,79,21,12,'0.05'),
 (1189,3,29,79,21,0,'0.00'),
 (1190,3,30,79,21,2,'0.01'),
 (1191,3,31,79,21,254,'1.16'),
 (1192,3,32,79,21,6,'0.03'),
 (1193,3,33,79,21,24,'0.11'),
 (1194,3,34,79,21,6,'0.03'),
 (1195,3,35,79,21,8,'0.04'),
 (1196,3,36,79,21,16,'0.07'),
 (1197,3,37,79,21,8,'0.04'),
 (1198,4,1,79,1,28705,'47.94'),
 (1199,4,2,79,1,20676,'34.53'),
 (1200,4,14,79,1,17,'0.03'),
 (1201,4,15,79,1,43,'0.07'),
 (1202,4,16,79,1,41,'0.07'),
 (1203,4,28,79,1,65,'0.11'),
 (1204,4,32,79,1,13,'0.02'),
 (1205,4,36,79,1,51,'0.09'),
 (1206,4,38,79,1,8128,'13.57'),
 (1207,4,39,79,1,246,'0.41'),
 (1208,4,40,79,1,26,'0.04'),
 (1209,4,41,79,1,34,'0.06'),
 (1210,4,42,79,1,60,'0.10'),
 (1211,4,43,79,1,125,'0.21'),
 (1212,4,44,79,1,43,'0.07'),
 (1213,4,45,79,1,17,'0.03'),
 (1214,4,46,79,1,33,'0.06'),
 (1215,4,47,79,1,16,'0.03'),
 (1216,4,48,79,1,0,'0.00'),
 (1217,4,49,79,1,190,'0.32'),
 (1218,4,50,79,1,10,'0.02'),
 (1219,4,51,79,1,279,'0.47'),
 (1220,4,1,79,2,37568,'52.63'),
 (1221,4,2,79,2,24191,'33.89'),
 (1222,4,14,79,2,39,'0.05'),
 (1223,4,15,79,2,39,'0.05'),
 (1224,4,16,79,2,69,'0.10'),
 (1225,4,28,79,2,51,'0.07'),
 (1226,4,32,79,2,2,'0.00'),
 (1227,4,36,79,2,91,'0.13'),
 (1228,4,38,79,2,6624,'9.28'),
 (1229,4,39,79,2,277,'0.39'),
 (1230,4,40,79,2,34,'0.05'),
 (1231,4,41,79,2,33,'0.05'),
 (1232,4,42,79,2,39,'0.05'),
 (1233,4,43,79,2,189,'0.26'),
 (1234,4,44,79,2,30,'0.04'),
 (1235,4,45,79,2,26,'0.04'),
 (1236,4,46,79,2,50,'0.07'),
 (1237,4,47,79,2,19,'0.03'),
 (1238,4,48,79,2,0,'0.00'),
 (1239,4,49,79,2,236,'0.33'),
 (1240,4,50,79,2,8,'0.01'),
 (1241,4,51,79,2,322,'0.45'),
 (1242,4,1,79,3,45592,'64.53'),
 (1243,4,2,79,3,17599,'24.91'),
 (1244,4,14,79,3,21,'0.03'),
 (1245,4,15,79,3,21,'0.03'),
 (1246,4,16,79,3,42,'0.06'),
 (1247,4,28,79,3,50,'0.07'),
 (1248,4,32,79,3,5,'0.01'),
 (1249,4,36,79,3,23,'0.03'),
 (1250,4,38,79,3,4681,'6.63'),
 (1251,4,39,79,3,272,'0.38'),
 (1252,4,40,79,3,27,'0.04'),
 (1253,4,41,79,3,31,'0.04'),
 (1254,4,42,79,3,33,'0.05'),
 (1255,4,43,79,3,180,'0.25'),
 (1256,4,44,79,3,29,'0.04'),
 (1257,4,45,79,3,23,'0.03'),
 (1258,4,46,79,3,49,'0.07'),
 (1259,4,47,79,3,24,'0.03'),
 (1260,4,48,79,3,0,'0.00'),
 (1261,4,49,79,3,219,'0.31'),
 (1262,4,50,79,3,4,'0.01'),
 (1263,4,51,79,3,235,'0.33'),
 (1264,4,1,79,4,56857,'70.58'),
 (1265,4,2,79,4,16627,'20.64'),
 (1266,4,14,79,4,23,'0.03'),
 (1267,4,15,79,4,25,'0.03'),
 (1268,4,16,79,4,54,'0.07'),
 (1269,4,28,79,4,70,'0.09'),
 (1270,4,32,79,4,5,'0.01'),
 (1271,4,36,79,4,41,'0.05'),
 (1272,4,38,79,4,4106,'5.10'),
 (1273,4,39,79,4,258,'0.32'),
 (1274,4,40,79,4,30,'0.04'),
 (1275,4,41,79,4,33,'0.04'),
 (1276,4,42,79,4,44,'0.05'),
 (1277,4,43,79,4,181,'0.22'),
 (1278,4,44,79,4,42,'0.05'),
 (1279,4,45,79,4,18,'0.02'),
 (1280,4,46,79,4,118,'0.15'),
 (1281,4,47,79,4,25,'0.03'),
 (1282,4,48,79,4,0,'0.00'),
 (1283,4,49,79,4,282,'0.35'),
 (1284,4,50,79,4,12,'0.01'),
 (1285,4,51,79,4,265,'0.33'),
 (1286,4,1,79,5,54147,'70.46'),
 (1287,4,2,79,5,15784,'20.54'),
 (1288,4,14,79,5,28,'0.04'),
 (1289,4,15,79,5,18,'0.02'),
 (1290,4,16,79,5,39,'0.05'),
 (1291,4,28,79,5,49,'0.06'),
 (1292,4,32,79,5,7,'0.01'),
 (1293,4,36,79,5,26,'0.03'),
 (1294,4,38,79,5,4021,'5.23'),
 (1295,4,39,79,5,222,'0.29'),
 (1296,4,40,79,5,15,'0.02'),
 (1297,4,41,79,5,25,'0.03'),
 (1298,4,42,79,5,37,'0.05'),
 (1299,4,43,79,5,161,'0.21'),
 (1300,4,44,79,5,50,'0.07'),
 (1301,4,45,79,5,12,'0.02'),
 (1302,4,46,79,5,90,'0.12'),
 (1303,4,47,79,5,19,'0.02'),
 (1304,4,48,79,5,0,'0.00'),
 (1305,4,49,79,5,289,'0.38'),
 (1306,4,50,79,5,4,'0.01'),
 (1307,4,51,79,5,202,'0.26'),
 (1308,4,1,79,6,39539,'57.06'),
 (1309,4,2,79,6,22286,'32.16'),
 (1310,4,14,79,6,48,'0.07'),
 (1311,4,15,79,6,41,'0.06'),
 (1312,4,16,79,6,51,'0.07'),
 (1313,4,28,79,6,78,'0.11'),
 (1314,4,32,79,6,15,'0.02'),
 (1315,4,36,79,6,84,'0.12'),
 (1316,4,38,79,6,4713,'6.80'),
 (1317,4,39,79,6,305,'0.44'),
 (1318,4,40,79,6,31,'0.04'),
 (1319,4,41,79,6,30,'0.04'),
 (1320,4,42,79,6,44,'0.06'),
 (1321,4,43,79,6,135,'0.19'),
 (1322,4,44,79,6,34,'0.05'),
 (1323,4,45,79,6,39,'0.06'),
 (1324,4,46,79,6,69,'0.10'),
 (1325,4,47,79,6,21,'0.03'),
 (1326,4,48,79,6,0,'0.00'),
 (1327,4,49,79,6,209,'0.30'),
 (1328,4,50,79,6,11,'0.02'),
 (1329,4,51,79,6,257,'0.37'),
 (1330,4,1,79,7,54806,'67.60'),
 (1331,4,2,79,7,18280,'22.55'),
 (1332,4,14,79,7,38,'0.05'),
 (1333,4,15,79,7,23,'0.03'),
 (1334,4,16,79,7,61,'0.08'),
 (1335,4,28,79,7,73,'0.09'),
 (1336,4,32,79,7,10,'0.01'),
 (1337,4,36,79,7,24,'0.03'),
 (1338,4,38,79,7,4933,'6.08'),
 (1339,4,39,79,7,273,'0.34'),
 (1340,4,40,79,7,24,'0.03'),
 (1341,4,41,79,7,24,'0.03'),
 (1342,4,42,79,7,50,'0.06'),
 (1343,4,43,79,7,171,'0.21'),
 (1344,4,44,79,7,51,'0.06'),
 (1345,4,45,79,7,20,'0.02'),
 (1346,4,46,79,7,86,'0.11'),
 (1347,4,47,79,7,23,'0.03'),
 (1348,4,48,79,7,0,'0.00'),
 (1349,4,49,79,7,248,'0.31'),
 (1350,4,50,79,7,9,'0.01'),
 (1351,4,51,79,7,257,'0.32'),
 (1352,4,1,79,8,61540,'55.48'),
 (1353,4,2,79,8,36711,'33.10'),
 (1354,4,14,79,8,42,'0.04'),
 (1355,4,15,79,8,46,'0.04'),
 (1356,4,16,79,8,65,'0.06'),
 (1357,4,28,79,8,64,'0.06'),
 (1358,4,32,79,8,23,'0.02'),
 (1359,4,36,79,8,78,'0.07'),
 (1360,4,38,79,8,7706,'6.95'),
 (1361,4,39,79,8,521,'0.47'),
 (1362,4,40,79,8,67,'0.06'),
 (1363,4,41,79,8,44,'0.04'),
 (1364,4,42,79,8,56,'0.05'),
 (1365,4,43,79,8,266,'0.24'),
 (1366,4,44,79,8,51,'0.05'),
 (1367,4,45,79,8,44,'0.04'),
 (1368,4,46,79,8,135,'0.12'),
 (1369,4,47,79,8,57,'0.05'),
 (1370,4,48,79,8,0,'0.00'),
 (1371,4,49,79,8,474,'0.43'),
 (1372,4,50,79,8,7,'0.01'),
 (1373,4,51,79,8,463,'0.42'),
 (1374,4,1,79,9,38235,'61.31'),
 (1375,4,2,79,9,16957,'27.19'),
 (1376,4,14,79,9,16,'0.03'),
 (1377,4,15,79,9,34,'0.05'),
 (1378,4,16,79,9,36,'0.06'),
 (1379,4,28,79,9,27,'0.04'),
 (1380,4,32,79,9,14,'0.02'),
 (1381,4,36,79,9,42,'0.07'),
 (1382,4,38,79,9,4520,'7.25'),
 (1383,4,39,79,9,255,'0.41'),
 (1384,4,40,79,9,33,'0.05'),
 (1385,4,41,79,9,21,'0.03'),
 (1386,4,42,79,9,22,'0.04'),
 (1387,4,43,79,9,162,'0.26'),
 (1388,4,44,79,9,53,'0.08'),
 (1389,4,45,79,9,18,'0.03'),
 (1390,4,46,79,9,51,'0.08'),
 (1391,4,47,79,9,14,'0.02'),
 (1392,4,48,79,9,0,'0.00'),
 (1393,4,49,79,9,248,'0.40'),
 (1394,4,50,79,9,6,'0.01'),
 (1395,4,51,79,9,255,'0.41'),
 (1396,4,1,79,10,64323,'48.78'),
 (1397,4,2,79,10,50908,'38.61'),
 (1398,4,14,79,10,88,'0.07'),
 (1399,4,15,79,10,66,'0.05'),
 (1400,4,16,79,10,123,'0.09'),
 (1401,4,28,79,10,120,'0.09'),
 (1402,4,32,79,10,32,'0.02'),
 (1403,4,36,79,10,144,'0.11'),
 (1404,4,38,79,10,11422,'8.66'),
 (1405,4,39,79,10,642,'0.49'),
 (1406,4,40,79,10,75,'0.06'),
 (1407,4,41,79,10,72,'0.05'),
 (1408,4,42,79,10,42,'0.03'),
 (1409,4,43,79,10,311,'0.24'),
 (1410,4,44,79,10,79,'0.06'),
 (1411,4,45,79,10,56,'0.04'),
 (1412,4,46,79,10,96,'0.07'),
 (1413,4,47,79,10,45,'0.03'),
 (1414,4,48,79,10,0,'0.00'),
 (1415,4,49,79,10,374,'0.28'),
 (1416,4,50,79,10,27,'0.02'),
 (1417,4,51,79,10,565,'0.43'),
 (1418,4,1,79,11,49623,'45.52'),
 (1419,4,2,79,11,45757,'41.97'),
 (1420,4,14,79,11,63,'0.06'),
 (1421,4,15,79,11,61,'0.06'),
 (1422,4,16,79,11,101,'0.09'),
 (1423,4,28,79,11,106,'0.10'),
 (1424,4,32,79,11,21,'0.02'),
 (1425,4,36,79,11,164,'0.15'),
 (1426,4,38,79,11,9419,'8.64'),
 (1427,4,39,79,11,519,'0.48'),
 (1428,4,40,79,11,43,'0.04'),
 (1429,4,41,79,11,66,'0.06'),
 (1430,4,42,79,11,54,'0.05'),
 (1431,4,43,79,11,217,'0.20'),
 (1432,4,44,79,11,60,'0.06'),
 (1433,4,45,79,11,54,'0.05'),
 (1434,4,46,79,11,94,'0.09'),
 (1435,4,47,79,11,34,'0.03'),
 (1436,4,48,79,11,0,'0.00'),
 (1437,4,49,79,11,317,'0.29'),
 (1438,4,50,79,11,14,'0.01'),
 (1439,4,51,79,11,466,'0.43'),
 (1440,4,1,79,12,20556,'36.80'),
 (1441,4,2,79,12,28216,'50.51'),
 (1442,4,14,79,12,21,'0.04'),
 (1443,4,15,79,12,35,'0.06'),
 (1444,4,16,79,12,59,'0.11'),
 (1445,4,28,79,12,33,'0.06'),
 (1446,4,32,79,12,13,'0.02'),
 (1447,4,36,79,12,72,'0.13'),
 (1448,4,38,79,12,5182,'9.28'),
 (1449,4,39,79,12,281,'0.50'),
 (1450,4,40,79,12,23,'0.04'),
 (1451,4,41,79,12,43,'0.08'),
 (1452,4,42,79,12,16,'0.03'),
 (1453,4,43,79,12,154,'0.28'),
 (1454,4,44,79,12,27,'0.05'),
 (1455,4,45,79,12,24,'0.04'),
 (1456,4,46,79,12,31,'0.06'),
 (1457,4,47,79,12,10,'0.02'),
 (1458,4,48,79,12,0,'0.00'),
 (1459,4,49,79,12,123,'0.22'),
 (1460,4,50,79,12,9,'0.02'),
 (1461,4,51,79,12,218,'0.39'),
 (1462,4,1,79,13,31007,'28.53'),
 (1463,4,2,79,13,61228,'56.34'),
 (1464,4,14,79,13,60,'0.06'),
 (1465,4,15,79,13,94,'0.09'),
 (1466,4,16,79,13,77,'0.07'),
 (1467,4,28,79,13,105,'0.10'),
 (1468,4,32,79,13,8,'0.01'),
 (1469,4,36,79,13,91,'0.08'),
 (1470,4,38,79,13,13043,'12.00'),
 (1471,4,39,79,13,466,'0.43'),
 (1472,4,40,79,13,38,'0.03'),
 (1473,4,41,79,13,43,'0.04'),
 (1474,4,42,79,13,43,'0.04'),
 (1475,4,43,79,13,170,'0.16'),
 (1476,4,44,79,13,39,'0.04'),
 (1477,4,45,79,13,45,'0.04'),
 (1478,4,46,79,13,57,'0.05'),
 (1479,4,47,79,13,20,'0.02'),
 (1480,4,48,79,13,0,'0.00'),
 (1481,4,49,79,13,273,'0.25'),
 (1482,4,50,79,13,15,'0.01'),
 (1483,4,51,79,13,445,'0.41'),
 (1484,4,1,79,14,27152,'47.90'),
 (1485,4,2,79,14,22026,'38.85'),
 (1486,4,14,79,14,19,'0.03'),
 (1487,4,15,79,14,22,'0.04'),
 (1488,4,16,79,14,38,'0.07'),
 (1489,4,28,79,14,28,'0.05'),
 (1490,4,32,79,14,10,'0.02'),
 (1491,4,36,79,14,43,'0.08'),
 (1492,4,38,79,14,5366,'9.47'),
 (1493,4,39,79,14,253,'0.45'),
 (1494,4,40,79,14,30,'0.05'),
 (1495,4,41,79,14,24,'0.04'),
 (1496,4,42,79,14,21,'0.04'),
 (1497,4,43,79,14,99,'0.17'),
 (1498,4,44,79,14,21,'0.04'),
 (1499,4,45,79,14,26,'0.05'),
 (1500,4,46,79,14,41,'0.07'),
 (1501,4,47,79,14,19,'0.03'),
 (1502,4,48,79,14,0,'0.00'),
 (1503,4,49,79,14,169,'0.30'),
 (1504,4,50,79,14,11,'0.02'),
 (1505,4,51,79,14,225,'0.40'),
 (1506,4,1,79,15,62993,'55.07'),
 (1507,4,2,79,15,38659,'33.80'),
 (1508,4,14,79,15,61,'0.05'),
 (1509,4,15,79,15,50,'0.04'),
 (1510,4,16,79,15,57,'0.05'),
 (1511,4,28,79,15,90,'0.08'),
 (1512,4,32,79,15,22,'0.02'),
 (1513,4,36,79,15,114,'0.10'),
 (1514,4,38,79,15,8214,'7.18'),
 (1515,4,39,79,15,457,'0.40'),
 (1516,4,40,79,15,56,'0.05'),
 (1517,4,41,79,15,53,'0.05'),
 (1518,4,42,79,15,57,'0.05'),
 (1519,4,43,79,15,236,'0.21'),
 (1520,4,44,79,15,53,'0.05'),
 (1521,4,45,79,15,33,'0.03'),
 (1522,4,46,79,15,105,'0.09'),
 (1523,4,47,79,15,40,'0.03'),
 (1524,4,48,79,15,0,'0.00'),
 (1525,4,49,79,15,396,'0.35'),
 (1526,4,50,79,15,19,'0.02'),
 (1527,4,51,79,15,483,'0.42'),
 (1528,4,1,79,16,38243,'49.84'),
 (1529,4,2,79,16,29148,'37.98'),
 (1530,4,14,79,16,29,'0.04'),
 (1531,4,15,79,16,39,'0.05'),
 (1532,4,16,79,16,43,'0.06'),
 (1533,4,28,79,16,62,'0.08'),
 (1534,4,32,79,16,18,'0.02'),
 (1535,4,36,79,16,52,'0.07'),
 (1536,4,38,79,16,5945,'7.75'),
 (1537,4,39,79,16,414,'0.54'),
 (1538,4,40,79,16,35,'0.05'),
 (1539,4,41,79,16,33,'0.04'),
 (1540,4,42,79,16,44,'0.06'),
 (1541,4,43,79,16,171,'0.22'),
 (1542,4,44,79,16,39,'0.05'),
 (1543,4,45,79,16,44,'0.06'),
 (1544,4,46,79,16,56,'0.07'),
 (1545,4,47,79,16,19,'0.02'),
 (1546,4,48,79,16,0,'0.00'),
 (1547,4,49,79,16,421,'0.55'),
 (1548,4,50,79,16,18,'0.02'),
 (1549,4,51,79,16,347,'0.45'),
 (1550,4,1,79,17,21864,'34.76'),
 (1551,4,2,79,17,32422,'51.55'),
 (1552,4,14,79,17,26,'0.04'),
 (1553,4,15,79,17,34,'0.05'),
 (1554,4,16,79,17,51,'0.08'),
 (1555,4,28,79,17,60,'0.10'),
 (1556,4,32,79,17,19,'0.03'),
 (1557,4,36,79,17,94,'0.15'),
 (1558,4,38,79,17,6369,'10.13'),
 (1559,4,39,79,17,324,'0.52'),
 (1560,4,40,79,17,20,'0.03'),
 (1561,4,41,79,17,37,'0.06'),
 (1562,4,42,79,17,21,'0.03'),
 (1563,4,43,79,17,124,'0.20'),
 (1564,4,44,79,17,21,'0.03'),
 (1565,4,45,79,17,45,'0.07'),
 (1566,4,46,79,17,46,'0.07'),
 (1567,4,47,79,17,12,'0.02'),
 (1568,4,48,79,17,0,'0.00'),
 (1569,4,49,79,17,114,'0.18'),
 (1570,4,50,79,17,8,'0.01'),
 (1571,4,51,79,17,267,'0.42'),
 (1572,4,1,79,18,10420,'34.99'),
 (1573,4,2,79,18,15152,'50.87'),
 (1574,4,14,79,18,5,'0.02'),
 (1575,4,15,79,18,17,'0.06'),
 (1576,4,16,79,18,15,'0.05'),
 (1577,4,28,79,18,15,'0.05'),
 (1578,4,32,79,18,7,'0.02'),
 (1579,4,36,79,18,40,'0.13'),
 (1580,4,38,79,18,3171,'10.65'),
 (1581,4,39,79,18,124,'0.42'),
 (1582,4,40,79,18,15,'0.05'),
 (1583,4,41,79,18,22,'0.07'),
 (1584,4,42,79,18,17,'0.06'),
 (1585,4,43,79,18,55,'0.18'),
 (1586,4,44,79,18,12,'0.04'),
 (1587,4,45,79,18,9,'0.03'),
 (1588,4,46,79,18,14,'0.05'),
 (1589,4,47,79,18,3,'0.01'),
 (1590,4,48,79,18,0,'0.00'),
 (1591,4,49,79,18,73,'0.25'),
 (1592,4,50,79,18,7,'0.02'),
 (1593,4,51,79,18,121,'0.41'),
 (1594,4,1,79,19,8844,'33.17'),
 (1595,4,2,79,19,13388,'50.21'),
 (1596,4,14,79,19,8,'0.03'),
 (1597,4,15,79,19,16,'0.06'),
 (1598,4,16,79,19,19,'0.07'),
 (1599,4,28,79,19,27,'0.10'),
 (1600,4,32,79,19,8,'0.03'),
 (1601,4,36,79,19,41,'0.15'),
 (1602,4,38,79,19,3376,'12.66'),
 (1603,4,39,79,19,137,'0.51'),
 (1604,4,40,79,19,16,'0.06'),
 (1605,4,41,79,19,18,'0.07'),
 (1606,4,42,79,19,18,'0.07'),
 (1607,4,43,79,19,52,'0.20'),
 (1608,4,44,79,19,18,'0.07'),
 (1609,4,45,79,19,14,'0.05'),
 (1610,4,46,79,19,12,'0.05'),
 (1611,4,47,79,19,5,'0.02'),
 (1612,4,48,79,19,0,'0.00'),
 (1613,4,49,79,19,54,'0.20'),
 (1614,4,50,79,19,2,'0.01'),
 (1615,4,51,79,19,112,'0.42'),
 (1616,4,1,79,20,28620,'40.43'),
 (1617,4,2,79,20,32656,'46.13'),
 (1618,4,14,79,20,36,'0.05'),
 (1619,4,15,79,20,64,'0.09'),
 (1620,4,16,79,20,41,'0.06'),
 (1621,4,28,79,20,60,'0.08'),
 (1622,4,32,79,20,15,'0.02'),
 (1623,4,36,79,20,95,'0.13'),
 (1624,4,38,79,20,6613,'9.34'),
 (1625,4,39,79,20,393,'0.56'),
 (1626,4,40,79,20,33,'0.05'),
 (1627,4,41,79,20,54,'0.08'),
 (1628,4,42,79,20,26,'0.04'),
 (1629,4,43,79,20,147,'0.21'),
 (1630,4,44,79,20,47,'0.07'),
 (1631,4,45,79,20,46,'0.06'),
 (1632,4,46,79,20,41,'0.06'),
 (1633,4,47,79,20,17,'0.02'),
 (1634,4,48,79,20,0,'0.00'),
 (1635,4,49,79,20,186,'0.26'),
 (1636,4,50,79,20,10,'0.01'),
 (1637,4,51,79,20,330,'0.47'),
 (1638,4,1,79,21,10672,'52.71'),
 (1639,4,2,79,21,6825,'33.71'),
 (1640,4,14,79,21,7,'0.03'),
 (1641,4,15,79,21,12,'0.06'),
 (1642,4,16,79,21,9,'0.04'),
 (1643,4,28,79,21,17,'0.08'),
 (1644,4,32,79,21,1,'0.00'),
 (1645,4,36,79,21,19,'0.09'),
 (1646,4,38,79,21,1708,'8.44'),
 (1647,4,39,79,21,116,'0.57'),
 (1648,4,40,79,21,3,'0.01'),
 (1649,4,41,79,21,11,'0.05'),
 (1650,4,42,79,21,15,'0.07'),
 (1651,4,43,79,21,37,'0.18'),
 (1652,4,44,79,21,16,'0.08'),
 (1653,4,45,79,21,11,'0.05'),
 (1654,4,46,79,21,14,'0.07'),
 (1655,4,47,79,21,12,'0.06'),
 (1656,4,48,79,21,0,'0.00'),
 (1657,4,49,79,21,67,'0.33'),
 (1658,4,50,79,21,5,'0.02'),
 (1659,4,51,79,21,90,'0.44'),
 (1709,5,1,79,1,30496,'45.98'),
 (1710,5,2,79,1,24481,'36.91'),
 (1711,5,14,79,1,40,'0.06'),
 (1712,5,15,79,1,41,'0.06'),
 (1713,5,28,79,1,119,'0.18'),
 (1714,5,32,79,1,12,'0.02'),
 (1715,5,36,79,1,44,'0.07'),
 (1716,5,38,79,1,7292,'11.00'),
 (1717,5,39,79,1,467,'0.70'),
 (1718,5,40,79,1,29,'0.04'),
 (1719,5,41,79,1,52,'0.08'),
 (1720,5,42,79,1,92,'0.14'),
 (1721,5,45,79,1,39,'0.06'),
 (1722,5,46,79,1,84,'0.13'),
 (1723,5,47,79,1,43,'0.06'),
 (1724,5,48,79,1,32,'0.05'),
 (1725,5,51,79,1,1459,'2.20'),
 (1726,5,52,79,1,20,'0.03'),
 (1727,5,53,79,1,103,'0.16'),
 (1728,5,54,79,1,57,'0.09'),
 (1729,5,1,79,2,39461,'50.53'),
 (1730,5,2,79,2,28196,'36.11'),
 (1731,5,14,79,2,36,'0.05'),
 (1732,5,15,79,2,25,'0.03'),
 (1733,5,28,79,2,112,'0.14'),
 (1734,5,32,79,2,10,'0.01'),
 (1735,5,36,79,2,69,'0.09'),
 (1736,5,38,79,2,6006,'7.69'),
 (1737,5,39,79,2,499,'0.64'),
 (1738,5,40,79,2,38,'0.05'),
 (1739,5,41,79,2,45,'0.06'),
 (1740,5,42,79,2,71,'0.09'),
 (1741,5,45,79,2,34,'0.04'),
 (1742,5,46,79,2,100,'0.13'),
 (1743,5,47,79,2,34,'0.04'),
 (1744,5,48,79,2,46,'0.06'),
 (1745,5,51,79,2,1304,'1.67'),
 (1746,5,52,79,2,24,'0.03'),
 (1747,5,53,79,2,138,'0.18'),
 (1748,5,54,79,2,55,'0.07'),
 (1749,5,1,79,3,46274,'60.61'),
 (1750,5,2,79,3,21562,'28.24'),
 (1751,5,14,79,3,43,'0.06'),
 (1752,5,15,79,3,19,'0.02'),
 (1753,5,28,79,3,111,'0.15'),
 (1754,5,32,79,3,7,'0.01'),
 (1755,5,36,79,3,25,'0.03'),
 (1756,5,38,79,3,4316,'5.65'),
 (1757,5,39,79,3,391,'0.51'),
 (1758,5,40,79,3,48,'0.06'),
 (1759,5,41,79,3,66,'0.09'),
 (1760,5,42,79,3,54,'0.07'),
 (1761,5,45,79,3,36,'0.05'),
 (1762,5,46,79,3,155,'0.20'),
 (1763,5,47,79,3,42,'0.06'),
 (1764,5,48,79,3,16,'0.02'),
 (1765,5,51,79,3,1081,'1.42'),
 (1766,5,52,79,3,17,'0.02'),
 (1767,5,53,79,3,124,'0.16'),
 (1768,5,54,79,3,42,'0.06'),
 (1769,5,1,79,4,57674,'67.13'),
 (1770,5,2,79,4,20099,'23.39'),
 (1771,5,14,79,4,38,'0.04'),
 (1772,5,15,79,4,31,'0.04'),
 (1773,5,28,79,4,126,'0.15'),
 (1774,5,32,79,4,10,'0.01'),
 (1775,5,36,79,4,35,'0.04'),
 (1776,5,38,79,4,3640,'4.24'),
 (1777,5,39,79,4,489,'0.57'),
 (1778,5,40,79,4,42,'0.05'),
 (1779,5,41,79,4,60,'0.07'),
 (1780,5,42,79,4,70,'0.08'),
 (1781,5,45,79,4,35,'0.04'),
 (1782,5,46,79,4,253,'0.29'),
 (1783,5,47,79,4,53,'0.06'),
 (1784,5,48,79,4,26,'0.03'),
 (1785,5,51,79,4,994,'1.16'),
 (1786,5,52,79,4,18,'0.02'),
 (1787,5,53,79,4,155,'0.18'),
 (1788,5,54,79,4,75,'0.09'),
 (1789,5,1,79,5,54564,'66.80'),
 (1790,5,2,79,5,19341,'23.68'),
 (1791,5,14,79,5,56,'0.07'),
 (1792,5,15,79,5,17,'0.02'),
 (1793,5,28,79,5,84,'0.10'),
 (1794,5,32,79,5,10,'0.01'),
 (1795,5,36,79,5,32,'0.04'),
 (1796,5,38,79,5,3574,'4.38'),
 (1797,5,39,79,5,488,'0.60'),
 (1798,5,40,79,5,35,'0.04'),
 (1799,5,41,79,5,53,'0.06'),
 (1800,5,42,79,5,44,'0.05'),
 (1801,5,45,79,5,19,'0.02'),
 (1802,5,46,79,5,189,'0.23'),
 (1803,5,47,79,5,31,'0.04'),
 (1804,5,48,79,5,24,'0.03'),
 (1805,5,51,79,5,869,'1.06'),
 (1806,5,52,79,5,8,'0.01'),
 (1807,5,53,79,5,115,'0.14'),
 (1808,5,54,79,5,36,'0.04'),
 (1809,5,1,79,6,41453,'54.42'),
 (1810,5,2,79,6,25956,'34.08'),
 (1811,5,14,79,6,64,'0.08'),
 (1812,5,15,79,6,46,'0.06'),
 (1813,5,28,79,6,156,'0.20'),
 (1814,5,32,79,6,11,'0.01'),
 (1815,5,36,79,6,75,'0.10'),
 (1816,5,38,79,6,4585,'6.02'),
 (1817,5,39,79,6,541,'0.71'),
 (1818,5,40,79,6,55,'0.07'),
 (1819,5,41,79,6,53,'0.07'),
 (1820,5,42,79,6,54,'0.07'),
 (1821,5,45,79,6,57,'0.07'),
 (1822,5,46,79,6,122,'0.16'),
 (1823,5,47,79,6,47,'0.06'),
 (1824,5,48,79,6,40,'0.05'),
 (1825,5,51,79,6,1083,'1.42'),
 (1826,5,52,79,6,12,'0.02'),
 (1827,5,53,79,6,129,'0.17'),
 (1828,5,54,79,6,64,'0.08'),
 (1829,5,1,79,7,55527,'64.07'),
 (1830,5,2,79,7,22026,'25.41'),
 (1831,5,14,79,7,47,'0.05'),
 (1832,5,15,79,7,44,'0.05'),
 (1833,5,28,79,7,109,'0.13'),
 (1834,5,32,79,7,8,'0.01'),
 (1835,5,36,79,7,33,'0.04'),
 (1836,5,38,79,7,4428,'5.11'),
 (1837,5,39,79,7,436,'0.50'),
 (1838,5,40,79,7,48,'0.06'),
 (1839,5,41,79,7,49,'0.06'),
 (1840,5,42,79,7,79,'0.09'),
 (1841,5,45,79,7,29,'0.03'),
 (1842,5,46,79,7,189,'0.22'),
 (1843,5,47,79,7,45,'0.05'),
 (1844,5,48,79,7,32,'0.04'),
 (1845,5,51,79,7,1164,'1.34'),
 (1846,5,52,79,7,14,'0.02'),
 (1847,5,53,79,7,159,'0.18'),
 (1848,5,54,79,7,54,'0.06'),
 (1849,5,1,79,8,63726,'52.80'),
 (1850,5,2,79,8,42708,'35.38'),
 (1851,5,14,79,8,76,'0.06'),
 (1852,5,15,79,8,69,'0.06'),
 (1853,5,28,79,8,152,'0.13'),
 (1854,5,32,79,8,23,'0.02'),
 (1855,5,36,79,8,57,'0.05'),
 (1856,5,38,79,8,6949,'5.76'),
 (1857,5,39,79,8,1053,'0.87'),
 (1858,5,40,79,8,72,'0.06'),
 (1859,5,41,79,8,63,'0.05'),
 (1860,5,42,79,8,120,'0.10'),
 (1861,5,45,79,8,78,'0.06'),
 (1862,5,46,79,8,187,'0.15'),
 (1863,5,47,79,8,82,'0.07'),
 (1864,5,48,79,8,74,'0.06'),
 (1865,5,51,79,8,1628,'1.35'),
 (1866,5,52,79,8,25,'0.02'),
 (1867,5,53,79,8,238,'0.20'),
 (1868,5,54,79,8,77,'0.06'),
 (1869,5,1,79,9,39194,'58.37'),
 (1870,5,2,79,9,20250,'30.16'),
 (1871,5,14,79,9,30,'0.04'),
 (1872,5,15,79,9,23,'0.03'),
 (1873,5,28,79,9,70,'0.10'),
 (1874,5,32,79,9,10,'0.01'),
 (1875,5,36,79,9,40,'0.06'),
 (1876,5,38,79,9,4018,'5.98'),
 (1877,5,39,79,9,407,'0.61'),
 (1878,5,40,79,9,37,'0.06'),
 (1879,5,41,79,9,30,'0.04'),
 (1880,5,42,79,9,37,'0.06'),
 (1881,5,45,79,9,34,'0.05'),
 (1882,5,46,79,9,119,'0.18'),
 (1883,5,47,79,9,41,'0.06'),
 (1884,5,48,79,9,24,'0.04'),
 (1885,5,51,79,9,957,'1.43'),
 (1886,5,52,79,9,18,'0.03'),
 (1887,5,53,79,9,131,'0.20'),
 (1888,5,54,79,9,33,'0.05'),
 (1889,5,1,79,10,68776,'47.42'),
 (1890,5,2,79,10,57409,'39.58'),
 (1891,5,14,79,10,103,'0.07'),
 (1892,5,15,79,10,85,'0.06'),
 (1893,5,28,79,10,195,'0.13'),
 (1894,5,32,79,10,28,'0.02'),
 (1895,5,36,79,10,119,'0.08'),
 (1896,5,38,79,10,11016,'7.60'),
 (1897,5,39,79,10,1097,'0.76'),
 (1898,5,40,79,10,105,'0.07'),
 (1899,5,41,79,10,120,'0.08'),
 (1900,5,42,79,10,100,'0.07'),
 (1901,5,45,79,10,91,'0.06'),
 (1902,5,46,79,10,124,'0.09'),
 (1903,5,47,79,10,93,'0.06'),
 (1904,5,48,79,10,62,'0.04'),
 (1905,5,51,79,10,2089,'1.44'),
 (1906,5,52,79,10,32,'0.02'),
 (1907,5,53,79,10,254,'0.18'),
 (1908,5,54,79,10,158,'0.11'),
 (1909,5,1,79,11,53836,'44.73'),
 (1910,5,2,79,11,50996,'42.37'),
 (1911,5,14,79,11,94,'0.08'),
 (1912,5,15,79,11,83,'0.07'),
 (1913,5,28,79,11,177,'0.15'),
 (1914,5,32,79,11,26,'0.02'),
 (1915,5,36,79,11,115,'0.10'),
 (1916,5,38,79,11,9377,'7.79'),
 (1917,5,39,79,11,853,'0.71'),
 (1918,5,40,79,11,97,'0.08'),
 (1919,5,41,79,11,67,'0.06'),
 (1920,5,42,79,11,88,'0.07'),
 (1921,5,45,79,11,88,'0.07'),
 (1922,5,46,79,11,124,'0.10'),
 (1923,5,47,79,11,61,'0.05'),
 (1924,5,48,79,11,41,'0.03'),
 (1925,5,51,79,11,1768,'1.47'),
 (1926,5,52,79,11,33,'0.03'),
 (1927,5,53,79,11,186,'0.15'),
 (1928,5,54,79,11,124,'0.10'),
 (1929,5,1,79,12,22826,'36.90'),
 (1930,5,2,79,12,31003,'50.11'),
 (1931,5,14,79,12,43,'0.07'),
 (1932,5,15,79,12,31,'0.05'),
 (1933,5,28,79,12,70,'0.11'),
 (1934,5,32,79,12,11,'0.02'),
 (1935,5,36,79,12,32,'0.05'),
 (1936,5,38,79,12,5221,'8.44'),
 (1937,5,39,79,12,456,'0.74'),
 (1938,5,40,79,12,34,'0.05'),
 (1939,5,41,79,12,43,'0.07'),
 (1940,5,42,79,12,54,'0.09'),
 (1941,5,45,79,12,46,'0.07'),
 (1942,5,46,79,12,52,'0.08'),
 (1943,5,47,79,12,32,'0.05'),
 (1944,5,48,79,12,22,'0.04'),
 (1945,5,51,79,12,827,'1.34'),
 (1946,5,52,79,12,27,'0.04'),
 (1947,5,53,79,12,81,'0.13'),
 (1948,5,54,79,12,33,'0.05'),
 (1949,5,1,79,13,34638,'28.88'),
 (1950,5,2,79,13,66891,'55.77'),
 (1951,5,14,79,13,94,'0.08'),
 (1952,5,15,79,13,81,'0.07'),
 (1953,5,28,79,13,139,'0.12'),
 (1954,5,32,79,13,19,'0.02'),
 (1955,5,36,79,13,75,'0.06'),
 (1956,5,38,79,13,13132,'10.95'),
 (1957,5,39,79,13,809,'0.67'),
 (1958,5,40,79,13,70,'0.06'),
 (1959,5,41,79,13,75,'0.06'),
 (1960,5,42,79,13,66,'0.06'),
 (1961,5,45,79,13,74,'0.06'),
 (1962,5,46,79,13,99,'0.08'),
 (1963,5,47,79,13,69,'0.06'),
 (1964,5,48,79,13,44,'0.04'),
 (1965,5,51,79,13,1690,'1.41'),
 (1966,5,52,79,13,66,'0.06'),
 (1967,5,53,79,13,121,'0.10'),
 (1968,5,54,79,13,77,'0.06'),
 (1969,5,1,79,14,28828,'46.20'),
 (1970,5,2,79,14,25335,'40.60'),
 (1971,5,14,79,14,34,'0.05'),
 (1972,5,15,79,14,31,'0.05'),
 (1973,5,28,79,14,63,'0.10'),
 (1974,5,32,79,14,6,'0.01'),
 (1975,5,36,79,14,43,'0.07'),
 (1976,5,38,79,14,4874,'7.81'),
 (1977,5,39,79,14,489,'0.78'),
 (1978,5,40,79,14,35,'0.06'),
 (1979,5,41,79,14,36,'0.06'),
 (1980,5,42,79,14,43,'0.07'),
 (1981,5,45,79,14,52,'0.08'),
 (1982,5,46,79,14,59,'0.09'),
 (1983,5,47,79,14,32,'0.05'),
 (1984,5,48,79,14,16,'0.03'),
 (1985,5,51,79,14,885,'1.42'),
 (1986,5,52,79,14,22,'0.04'),
 (1987,5,53,79,14,131,'0.21'),
 (1988,5,54,79,14,46,'0.07'),
 (1989,5,1,79,15,65959,'52.59'),
 (1990,5,2,79,15,44757,'35.69'),
 (1991,5,14,79,15,73,'0.06'),
 (1992,5,15,79,15,71,'0.06'),
 (1993,5,28,79,15,148,'0.12'),
 (1994,5,32,79,15,24,'0.02'),
 (1995,5,36,79,15,74,'0.06'),
 (1996,5,38,79,15,7846,'6.26'),
 (1997,5,39,79,15,913,'0.73'),
 (1998,5,40,79,15,72,'0.06'),
 (1999,5,41,79,15,78,'0.06'),
 (2000,5,42,79,15,93,'0.07'),
 (2001,5,45,79,15,55,'0.04'),
 (2002,5,46,79,15,151,'0.12'),
 (2003,5,47,79,15,72,'0.06'),
 (2004,5,48,79,15,53,'0.04'),
 (2005,5,51,79,15,1845,'1.47'),
 (2006,5,52,79,15,25,'0.02'),
 (2007,5,53,79,15,219,'0.17'),
 (2008,5,54,79,15,96,'0.08'),
 (2009,5,1,79,16,40358,'47.86'),
 (2010,5,2,79,16,33627,'39.88'),
 (2011,5,14,79,16,53,'0.06'),
 (2012,5,15,79,16,47,'0.06'),
 (2013,5,28,79,16,84,'0.10'),
 (2014,5,32,79,16,11,'0.01'),
 (2015,5,36,79,16,41,'0.05'),
 (2016,5,38,79,16,5620,'6.67'),
 (2017,5,39,79,16,722,'0.86'),
 (2018,5,40,79,16,57,'0.07'),
 (2019,5,41,79,16,59,'0.07'),
 (2020,5,42,79,16,51,'0.06'),
 (2021,5,45,79,16,57,'0.07'),
 (2022,5,46,79,16,94,'0.11'),
 (2023,5,47,79,16,43,'0.05'),
 (2024,5,48,79,16,31,'0.04'),
 (2025,5,51,79,16,1223,'1.45'),
 (2026,5,52,79,16,24,'0.03'),
 (2027,5,53,79,16,123,'0.15'),
 (2028,5,54,79,16,42,'0.05'),
 (2029,5,1,79,17,24164,'34.72'),
 (2030,5,2,79,17,35870,'51.54'),
 (2031,5,14,79,17,27,'0.04'),
 (2032,5,15,79,17,45,'0.06'),
 (2033,5,28,79,17,61,'0.09'),
 (2034,5,32,79,17,12,'0.02'),
 (2035,5,36,79,17,41,'0.06'),
 (2036,5,38,79,17,6413,'9.21'),
 (2037,5,39,79,17,490,'0.70'),
 (2038,5,40,79,17,37,'0.05'),
 (2039,5,41,79,17,45,'0.06'),
 (2040,5,42,79,17,50,'0.07'),
 (2041,5,45,79,17,50,'0.07'),
 (2042,5,46,79,17,65,'0.09'),
 (2043,5,47,79,17,36,'0.05'),
 (2044,5,48,79,17,28,'0.04'),
 (2045,5,51,79,17,978,'1.41'),
 (2046,5,52,79,17,23,'0.03'),
 (2047,5,53,79,17,98,'0.14'),
 (2048,5,54,79,17,57,'0.08'),
 (2049,5,1,79,18,11645,'34.81'),
 (2050,5,2,79,18,17078,'51.05'),
 (2051,5,14,79,18,10,'0.03'),
 (2052,5,15,79,18,21,'0.06'),
 (2053,5,28,79,18,16,'0.05'),
 (2054,5,32,79,18,8,'0.02'),
 (2055,5,36,79,18,14,'0.04'),
 (2056,5,38,79,18,3182,'9.51'),
 (2057,5,39,79,18,247,'0.74'),
 (2058,5,40,79,18,25,'0.07'),
 (2059,5,41,79,18,17,'0.05'),
 (2060,5,42,79,18,13,'0.04'),
 (2061,5,45,79,18,19,'0.06'),
 (2062,5,46,79,18,38,'0.11'),
 (2063,5,47,79,18,13,'0.04'),
 (2064,5,48,79,18,6,'0.02'),
 (2065,5,51,79,18,429,'1.28'),
 (2066,5,52,79,18,13,'0.04'),
 (2067,5,53,79,18,44,'0.13'),
 (2068,5,54,79,18,22,'0.07'),
 (2069,5,1,79,19,9632,'32.87'),
 (2070,5,2,79,19,14666,'50.04'),
 (2071,5,14,79,19,15,'0.05'),
 (2072,5,15,79,19,15,'0.05'),
 (2073,5,28,79,19,33,'0.11'),
 (2074,5,32,79,19,6,'0.02'),
 (2075,5,36,79,19,25,'0.09'),
 (2076,5,38,79,19,3519,'12.01'),
 (2077,5,39,79,19,275,'0.94'),
 (2078,5,40,79,19,15,'0.05'),
 (2079,5,41,79,19,15,'0.05'),
 (2080,5,42,79,19,21,'0.07'),
 (2081,5,45,79,19,48,'0.16'),
 (2082,5,46,79,19,32,'0.11'),
 (2083,5,47,79,19,16,'0.05'),
 (2084,5,48,79,19,11,'0.04'),
 (2085,5,51,79,19,369,'1.26'),
 (2086,5,52,79,19,3,'0.01'),
 (2087,5,53,79,19,51,'0.17'),
 (2088,5,54,79,19,27,'0.09'),
 (2089,5,1,79,20,30997,'39.46'),
 (2090,5,2,79,20,36872,'46.93'),
 (2091,5,14,79,20,52,'0.07'),
 (2092,5,15,79,20,52,'0.07'),
 (2093,5,28,79,20,57,'0.07'),
 (2094,5,32,79,20,18,'0.02'),
 (2095,5,36,79,20,49,'0.06'),
 (2096,5,38,79,20,6619,'8.43'),
 (2097,5,39,79,20,640,'0.81'),
 (2098,5,40,79,20,44,'0.06'),
 (2099,5,41,79,20,46,'0.06'),
 (2100,5,42,79,20,45,'0.06'),
 (2101,5,45,79,20,76,'0.10'),
 (2102,5,46,79,20,80,'0.10'),
 (2103,5,47,79,20,41,'0.05'),
 (2104,5,48,79,20,31,'0.04'),
 (2105,5,51,79,20,1188,'1.51'),
 (2106,5,52,79,20,26,'0.03'),
 (2107,5,53,79,20,116,'0.15'),
 (2108,5,54,79,20,59,'0.08'),
 (2109,5,1,79,21,11309,'49.98'),
 (2110,5,2,79,21,8277,'36.58'),
 (2111,5,14,79,21,15,'0.07'),
 (2112,5,15,79,21,10,'0.04'),
 (2113,5,28,79,21,14,'0.06'),
 (2114,5,32,79,21,5,'0.02'),
 (2115,5,36,79,21,15,'0.07'),
 (2116,5,38,79,21,1599,'7.07'),
 (2117,5,39,79,21,190,'0.84'),
 (2118,5,40,79,21,8,'0.04'),
 (2119,5,41,79,21,15,'0.07'),
 (2120,5,42,79,21,17,'0.08'),
 (2121,5,45,79,21,14,'0.06'),
 (2122,5,46,79,21,22,'0.10'),
 (2123,5,47,79,21,20,'0.09'),
 (2124,5,48,79,21,7,'0.03'),
 (2125,5,51,79,21,387,'1.71'),
 (2126,5,52,79,21,3,'0.01'),
 (2127,5,53,79,21,47,'0.21'),
 (2128,5,54,79,21,10,'0.04'),
 (2220,6,1,79,1,32312,'54.88'),
 (2221,6,2,79,1,19433,'33.01'),
 (2222,6,14,79,1,55,'0.09'),
 (2223,6,15,79,1,49,'0.08'),
 (2224,6,28,79,1,115,'0.20'),
 (2225,6,32,79,1,18,'0.03'),
 (2226,6,38,79,1,4544,'7.72'),
 (2227,6,40,79,1,31,'0.05'),
 (2228,6,45,79,1,28,'0.05'),
 (2229,6,48,79,1,28,'0.05'),
 (2230,6,50,79,1,22,'0.04'),
 (2231,6,51,79,1,326,'0.55'),
 (2232,6,55,79,1,42,'0.07'),
 (2233,6,56,79,1,288,'0.49'),
 (2234,6,57,79,1,144,'0.24'),
 (2235,6,58,79,1,22,'0.04'),
 (2236,6,59,79,1,12,'0.02'),
 (2237,6,60,79,1,63,'0.11'),
 (2238,6,61,79,1,41,'0.07'),
 (2239,6,62,79,1,51,'0.09'),
 (2240,6,1,79,2,36070,'57.04'),
 (2241,6,2,79,2,20060,'31.72'),
 (2242,6,14,79,2,35,'0.06'),
 (2243,6,15,79,2,57,'0.09'),
 (2244,6,28,79,2,121,'0.19'),
 (2245,6,32,79,2,22,'0.03'),
 (2246,6,38,79,2,4298,'6.80'),
 (2247,6,40,79,2,41,'0.06'),
 (2248,6,45,79,2,40,'0.06'),
 (2249,6,48,79,2,41,'0.06'),
 (2250,6,50,79,2,24,'0.04'),
 (2251,6,51,79,2,281,'0.44'),
 (2252,6,55,79,2,65,'0.10'),
 (2253,6,56,79,2,288,'0.46'),
 (2254,6,57,79,2,176,'0.28'),
 (2255,6,58,79,2,24,'0.04'),
 (2256,6,59,79,2,5,'0.01'),
 (2257,6,60,79,2,45,'0.07'),
 (2258,6,61,79,2,40,'0.06'),
 (2259,6,62,79,2,31,'0.05'),
 (2260,6,1,79,3,45109,'67.93'),
 (2261,6,2,79,3,14893,'22.43'),
 (2262,6,14,79,3,38,'0.06'),
 (2263,6,15,79,3,34,'0.05'),
 (2264,6,28,79,3,103,'0.16'),
 (2265,6,32,79,3,12,'0.02'),
 (2266,6,38,79,3,3179,'4.79'),
 (2267,6,40,79,3,39,'0.06'),
 (2268,6,45,79,3,32,'0.05'),
 (2269,6,48,79,3,35,'0.05'),
 (2270,6,50,79,3,19,'0.03'),
 (2271,6,51,79,3,295,'0.44'),
 (2272,6,55,79,3,39,'0.06'),
 (2273,6,56,79,3,253,'0.38'),
 (2274,6,57,79,3,171,'0.26'),
 (2275,6,58,79,3,9,'0.01'),
 (2276,6,59,79,3,13,'0.02'),
 (2277,6,60,79,3,73,'0.11'),
 (2278,6,61,79,3,18,'0.03'),
 (2279,6,62,79,3,35,'0.05'),
 (2280,6,1,79,4,57933,'72.83'),
 (2281,6,2,79,4,15183,'19.09'),
 (2282,6,14,79,4,56,'0.07'),
 (2283,6,15,79,4,36,'0.05'),
 (2284,6,28,79,4,212,'0.27'),
 (2285,6,32,79,4,14,'0.02'),
 (2286,6,38,79,4,2921,'3.67'),
 (2287,6,40,79,4,41,'0.05'),
 (2288,6,45,79,4,40,'0.05'),
 (2289,6,48,79,4,27,'0.03'),
 (2290,6,50,79,4,17,'0.02'),
 (2291,6,51,79,4,255,'0.32'),
 (2292,6,55,79,4,30,'0.04'),
 (2293,6,56,79,4,266,'0.33'),
 (2294,6,57,79,4,197,'0.25'),
 (2295,6,58,79,4,40,'0.05'),
 (2296,6,59,79,4,17,'0.02'),
 (2297,6,60,79,4,72,'0.09');
INSERT INTO `elecdistricandi` (`idElecDistriCandi`,`Convocatoria_idConvocatoria`,`Candidatura_idCandidatura`,`Municipio`,`Distrito`,`Votos`,`PorcVotos`) VALUES 
 (2298,6,61,79,4,46,'0.06'),
 (2299,6,62,79,4,34,'0.04'),
 (2300,6,1,79,5,52613,'71.98'),
 (2301,6,2,79,5,13993,'19.14'),
 (2302,6,14,79,5,34,'0.05'),
 (2303,6,15,79,5,46,'0.06'),
 (2304,6,28,79,5,142,'0.19'),
 (2305,6,32,79,5,9,'0.01'),
 (2306,6,38,79,5,2947,'4.03'),
 (2307,6,40,79,5,40,'0.05'),
 (2308,6,45,79,5,29,'0.04'),
 (2309,6,48,79,5,68,'0.09'),
 (2310,6,50,79,5,9,'0.01'),
 (2311,6,51,79,5,291,'0.40'),
 (2312,6,55,79,5,16,'0.02'),
 (2313,6,56,79,5,273,'0.37'),
 (2314,6,57,79,5,215,'0.29'),
 (2315,6,58,79,5,18,'0.02'),
 (2316,6,59,79,5,5,'0.01'),
 (2317,6,60,79,5,81,'0.11'),
 (2318,6,61,79,5,31,'0.04'),
 (2319,6,62,79,5,14,'0.02'),
 (2320,6,1,79,6,40803,'58.72'),
 (2321,6,2,79,6,21065,'30.31'),
 (2322,6,14,79,6,73,'0.11'),
 (2323,6,15,79,6,46,'0.07'),
 (2324,6,28,79,6,147,'0.21'),
 (2325,6,32,79,6,28,'0.04'),
 (2326,6,38,79,6,4059,'5.84'),
 (2327,6,40,79,6,38,'0.05'),
 (2328,6,45,79,6,60,'0.09'),
 (2329,6,48,79,6,46,'0.07'),
 (2330,6,50,79,6,18,'0.03'),
 (2331,6,51,79,6,330,'0.47'),
 (2332,6,55,79,6,39,'0.06'),
 (2333,6,56,79,6,308,'0.44'),
 (2334,6,57,79,6,194,'0.28'),
 (2335,6,58,79,6,73,'0.11'),
 (2336,6,59,79,6,20,'0.03'),
 (2337,6,60,79,6,82,'0.12'),
 (2338,6,61,79,6,39,'0.06'),
 (2339,6,62,79,6,25,'0.04'),
 (2340,6,1,79,7,57323,'70.78'),
 (2341,6,2,79,7,16465,'20.33'),
 (2342,6,14,79,7,51,'0.06'),
 (2343,6,15,79,7,37,'0.05'),
 (2344,6,28,79,7,185,'0.23'),
 (2345,6,32,79,7,18,'0.02'),
 (2346,6,38,79,7,3404,'4.20'),
 (2347,6,40,79,7,43,'0.05'),
 (2348,6,45,79,7,31,'0.04'),
 (2349,6,48,79,7,53,'0.07'),
 (2350,6,50,79,7,20,'0.02'),
 (2351,6,51,79,7,323,'0.40'),
 (2352,6,55,79,7,32,'0.04'),
 (2353,6,56,79,7,240,'0.30'),
 (2354,6,57,79,7,299,'0.37'),
 (2355,6,58,79,7,27,'0.03'),
 (2356,6,59,79,7,12,'0.01'),
 (2357,6,60,79,7,80,'0.10'),
 (2358,6,61,79,7,30,'0.04'),
 (2359,6,62,79,7,46,'0.06'),
 (2360,6,1,79,8,60712,'58.13'),
 (2361,6,2,79,8,32145,'30.78'),
 (2362,6,14,79,8,89,'0.09'),
 (2363,6,15,79,8,90,'0.09'),
 (2364,6,28,79,8,158,'0.15'),
 (2365,6,32,79,8,23,'0.02'),
 (2366,6,38,79,8,6247,'5.98'),
 (2367,6,40,79,8,80,'0.08'),
 (2368,6,45,79,8,73,'0.07'),
 (2369,6,48,79,8,75,'0.07'),
 (2370,6,50,79,8,21,'0.02'),
 (2371,6,51,79,8,642,'0.61'),
 (2372,6,55,79,8,59,'0.06'),
 (2373,6,56,79,8,568,'0.54'),
 (2374,6,57,79,8,332,'0.32'),
 (2375,6,58,79,8,53,'0.05'),
 (2376,6,59,79,8,18,'0.02'),
 (2377,6,60,79,8,85,'0.08'),
 (2378,6,61,79,8,76,'0.07'),
 (2379,6,62,79,8,50,'0.05'),
 (2380,6,1,79,9,36605,'64.01'),
 (2381,6,2,79,9,14491,'25.34'),
 (2382,6,14,79,9,36,'0.06'),
 (2383,6,15,79,9,38,'0.07'),
 (2384,6,28,79,9,109,'0.19'),
 (2385,6,32,79,9,15,'0.03'),
 (2386,6,38,79,9,3069,'5.37'),
 (2387,6,40,79,9,33,'0.06'),
 (2388,6,45,79,9,28,'0.05'),
 (2389,6,48,79,9,27,'0.05'),
 (2390,6,50,79,9,12,'0.02'),
 (2391,6,51,79,9,336,'0.59'),
 (2392,6,55,79,9,22,'0.04'),
 (2393,6,56,79,9,248,'0.43'),
 (2394,6,57,79,9,157,'0.27'),
 (2395,6,58,79,9,21,'0.04'),
 (2396,6,59,79,9,8,'0.01'),
 (2397,6,60,79,9,79,'0.14'),
 (2398,6,61,79,9,24,'0.04'),
 (2399,6,62,79,9,34,'0.06'),
 (2400,6,1,79,10,71841,'53.21'),
 (2401,6,2,79,10,46089,'34.13'),
 (2402,6,14,79,10,123,'0.09'),
 (2403,6,15,79,10,120,'0.09'),
 (2404,6,28,79,10,185,'0.14'),
 (2405,6,32,79,10,32,'0.02'),
 (2406,6,38,79,10,10477,'7.76'),
 (2407,6,40,79,10,77,'0.06'),
 (2408,6,45,79,10,96,'0.07'),
 (2409,6,48,79,10,48,'0.04'),
 (2410,6,50,79,10,44,'0.03'),
 (2411,6,51,79,10,901,'0.67'),
 (2412,6,55,79,10,184,'0.14'),
 (2413,6,56,79,10,640,'0.47'),
 (2414,6,57,79,10,462,'0.34'),
 (2415,6,58,79,10,76,'0.06'),
 (2416,6,59,79,10,46,'0.03'),
 (2417,6,60,79,10,93,'0.07'),
 (2418,6,61,79,10,79,'0.06'),
 (2419,6,62,79,10,63,'0.05'),
 (2420,6,1,79,11,53432,'49.20'),
 (2421,6,2,79,11,41004,'37.76'),
 (2422,6,14,79,11,103,'0.09'),
 (2423,6,15,79,11,109,'0.10'),
 (2424,6,28,79,11,135,'0.12'),
 (2425,6,32,79,11,39,'0.04'),
 (2426,6,38,79,11,8768,'8.07'),
 (2427,6,40,79,11,71,'0.07'),
 (2428,6,45,79,11,66,'0.06'),
 (2429,6,48,79,11,59,'0.05'),
 (2430,6,50,79,11,43,'0.04'),
 (2431,6,51,79,11,745,'0.69'),
 (2432,6,55,79,11,721,'0.66'),
 (2433,6,56,79,11,493,'0.45'),
 (2434,6,57,79,11,292,'0.27'),
 (2435,6,58,79,11,45,'0.04'),
 (2436,6,59,79,11,28,'0.03'),
 (2437,6,60,79,11,95,'0.09'),
 (2438,6,61,79,11,63,'0.06'),
 (2439,6,62,79,11,51,'0.05'),
 (2440,6,1,79,12,21242,'38.85'),
 (2441,6,2,79,12,26110,'47.75'),
 (2442,6,14,79,12,66,'0.12'),
 (2443,6,15,79,12,31,'0.06'),
 (2444,6,28,79,12,58,'0.11'),
 (2445,6,32,79,12,13,'0.02'),
 (2446,6,38,79,12,4965,'9.08'),
 (2447,6,40,79,12,27,'0.05'),
 (2448,6,45,79,12,43,'0.08'),
 (2449,6,48,79,12,28,'0.05'),
 (2450,6,50,79,12,19,'0.03'),
 (2451,6,51,79,12,305,'0.56'),
 (2452,6,55,79,12,55,'0.10'),
 (2453,6,56,79,12,318,'0.58'),
 (2454,6,57,79,12,121,'0.22'),
 (2455,6,58,79,12,25,'0.05'),
 (2456,6,59,79,12,21,'0.04'),
 (2457,6,60,79,12,51,'0.09'),
 (2458,6,61,79,12,22,'0.04'),
 (2459,6,62,79,12,32,'0.06'),
 (2460,6,1,79,13,33019,'31.31'),
 (2461,6,2,79,13,57366,'54.39'),
 (2462,6,14,79,13,134,'0.13'),
 (2463,6,15,79,13,142,'0.13'),
 (2464,6,28,79,13,92,'0.09'),
 (2465,6,32,79,13,42,'0.04'),
 (2466,6,38,79,13,11196,'10.62'),
 (2467,6,40,79,13,58,'0.05'),
 (2468,6,45,79,13,61,'0.06'),
 (2469,6,48,79,13,24,'0.02'),
 (2470,6,50,79,13,35,'0.03'),
 (2471,6,51,79,13,636,'0.60'),
 (2472,6,55,79,13,80,'0.08'),
 (2473,6,56,79,13,586,'0.56'),
 (2474,6,57,79,13,155,'0.15'),
 (2475,6,58,79,13,62,'0.06'),
 (2476,6,59,79,13,42,'0.04'),
 (2477,6,60,79,13,66,'0.06'),
 (2478,6,61,79,13,47,'0.04'),
 (2479,6,62,79,13,33,'0.03'),
 (2480,6,1,79,14,27973,'52.25'),
 (2481,6,2,79,14,19304,'36.06'),
 (2482,6,14,79,14,42,'0.08'),
 (2483,6,15,79,14,56,'0.10'),
 (2484,6,28,79,14,62,'0.12'),
 (2485,6,32,79,14,16,'0.03'),
 (2486,6,38,79,14,3899,'7.28'),
 (2487,6,40,79,14,30,'0.06'),
 (2488,6,45,79,14,36,'0.07'),
 (2489,6,48,79,14,22,'0.04'),
 (2490,6,50,79,14,19,'0.04'),
 (2491,6,51,79,14,292,'0.55'),
 (2492,6,55,79,14,20,'0.04'),
 (2493,6,56,79,14,268,'0.50'),
 (2494,6,57,79,14,152,'0.28'),
 (2495,6,58,79,14,24,'0.04'),
 (2496,6,59,79,14,31,'0.06'),
 (2497,6,60,79,14,34,'0.06'),
 (2498,6,61,79,14,35,'0.07'),
 (2499,6,62,79,14,27,'0.05'),
 (2500,6,1,79,15,64048,'57.69'),
 (2501,6,2,79,15,35159,'31.67'),
 (2502,6,14,79,15,117,'0.11'),
 (2503,6,15,79,15,93,'0.08'),
 (2504,6,28,79,15,152,'0.14'),
 (2505,6,32,79,15,35,'0.03'),
 (2506,6,38,79,15,6932,'6.24'),
 (2507,6,40,79,15,65,'0.06'),
 (2508,6,45,79,15,82,'0.07'),
 (2509,6,48,79,15,33,'0.03'),
 (2510,6,50,79,15,34,'0.03'),
 (2511,6,51,79,15,595,'0.54'),
 (2512,6,55,79,15,87,'0.08'),
 (2513,6,56,79,15,543,'0.49'),
 (2514,6,57,79,15,299,'0.27'),
 (2515,6,58,79,15,48,'0.04'),
 (2516,6,59,79,15,33,'0.03'),
 (2517,6,60,79,15,119,'0.11'),
 (2518,6,61,79,15,53,'0.05'),
 (2519,6,62,79,15,53,'0.05'),
 (2520,6,1,79,16,37148,'52.48'),
 (2521,6,2,79,16,25303,'35.75'),
 (2522,6,14,79,16,60,'0.08'),
 (2523,6,15,79,16,70,'0.10'),
 (2524,6,28,79,16,66,'0.09'),
 (2525,6,32,79,16,30,'0.04'),
 (2526,6,38,79,16,4738,'6.69'),
 (2527,6,40,79,16,45,'0.06'),
 (2528,6,45,79,16,80,'0.11'),
 (2529,6,48,79,16,31,'0.04'),
 (2530,6,50,79,16,25,'0.04'),
 (2531,6,51,79,16,565,'0.80'),
 (2532,6,55,79,16,40,'0.06'),
 (2533,6,56,79,16,307,'0.43'),
 (2534,6,57,79,16,215,'0.30'),
 (2535,6,58,79,16,41,'0.06'),
 (2536,6,59,79,16,29,'0.04'),
 (2537,6,60,79,16,55,'0.08'),
 (2538,6,61,79,16,42,'0.06'),
 (2539,6,62,79,16,33,'0.05'),
 (2540,6,1,79,17,23129,'37.54'),
 (2541,6,2,79,17,29654,'48.14'),
 (2542,6,14,79,17,85,'0.14'),
 (2543,6,15,79,17,64,'0.10'),
 (2544,6,28,79,17,49,'0.08'),
 (2545,6,32,79,17,23,'0.04'),
 (2546,6,38,79,17,6481,'10.52'),
 (2547,6,40,79,17,48,'0.08'),
 (2548,6,45,79,17,43,'0.07'),
 (2549,6,48,79,17,27,'0.04'),
 (2550,6,50,79,17,18,'0.03'),
 (2551,6,51,79,17,315,'0.51'),
 (2552,6,55,79,17,39,'0.06'),
 (2553,6,56,79,17,351,'0.57'),
 (2554,6,57,79,17,131,'0.21'),
 (2555,6,58,79,17,17,'0.03'),
 (2556,6,59,79,17,22,'0.04'),
 (2557,6,60,79,17,32,'0.05'),
 (2558,6,61,79,17,44,'0.07'),
 (2559,6,62,79,17,19,'0.03'),
 (2560,6,1,79,18,10945,'40.15'),
 (2561,6,2,79,18,12853,'47.15'),
 (2562,6,14,79,18,17,'0.06'),
 (2563,6,15,79,18,24,'0.09'),
 (2564,6,28,79,18,29,'0.11'),
 (2565,6,32,79,18,18,'0.07'),
 (2566,6,38,79,18,2438,'8.94'),
 (2567,6,40,79,18,8,'0.03'),
 (2568,6,45,79,18,21,'0.08'),
 (2569,6,48,79,18,3,'0.01'),
 (2570,6,50,79,18,6,'0.02'),
 (2571,6,51,79,18,116,'0.43'),
 (2572,6,55,79,18,19,'0.07'),
 (2573,6,56,79,18,185,'0.68'),
 (2574,6,57,79,18,32,'0.12'),
 (2575,6,58,79,18,17,'0.06'),
 (2576,6,59,79,18,8,'0.03'),
 (2577,6,60,79,18,9,'0.03'),
 (2578,6,61,79,18,14,'0.05'),
 (2579,6,62,79,18,12,'0.04'),
 (2580,6,1,79,19,8397,'37.73'),
 (2581,6,2,79,19,10388,'46.68'),
 (2582,6,14,79,19,27,'0.12'),
 (2583,6,15,79,19,18,'0.08'),
 (2584,6,28,79,19,21,'0.09'),
 (2585,6,32,79,19,3,'0.01'),
 (2586,6,38,79,19,2564,'11.52'),
 (2587,6,40,79,19,12,'0.05'),
 (2588,6,45,79,19,20,'0.09'),
 (2589,6,48,79,19,8,'0.04'),
 (2590,6,50,79,19,5,'0.02'),
 (2591,6,51,79,19,177,'0.80'),
 (2592,6,55,79,19,16,'0.07'),
 (2593,6,56,79,19,112,'0.50'),
 (2594,6,57,79,19,62,'0.28'),
 (2595,6,58,79,19,29,'0.13'),
 (2596,6,59,79,19,7,'0.03'),
 (2597,6,60,79,19,9,'0.04'),
 (2598,6,61,79,19,18,'0.08'),
 (2599,6,62,79,19,9,'0.04'),
 (2600,6,1,79,20,26022,'41.79'),
 (2601,6,2,79,20,28055,'45.05'),
 (2602,6,14,79,20,52,'0.08'),
 (2603,6,15,79,20,77,'0.12'),
 (2604,6,28,79,20,85,'0.14'),
 (2605,6,32,79,20,26,'0.04'),
 (2606,6,38,79,20,5647,'9.07'),
 (2607,6,40,79,20,57,'0.09'),
 (2608,6,45,79,20,43,'0.07'),
 (2609,6,48,79,20,29,'0.05'),
 (2610,6,50,79,20,17,'0.03'),
 (2611,6,51,79,20,334,'0.54'),
 (2612,6,55,79,20,61,'0.10'),
 (2613,6,56,79,20,487,'0.78'),
 (2614,6,57,79,20,128,'0.21'),
 (2615,6,58,79,20,52,'0.08'),
 (2616,6,59,79,20,13,'0.02'),
 (2617,6,60,79,20,40,'0.06'),
 (2618,6,61,79,20,36,'0.06'),
 (2619,6,62,79,20,16,'0.03'),
 (2620,6,1,79,21,9398,'53.89'),
 (2621,6,2,79,21,5721,'32.80'),
 (2622,6,14,79,21,9,'0.05'),
 (2623,6,15,79,21,11,'0.06'),
 (2624,6,28,79,21,31,'0.18'),
 (2625,6,32,79,21,2,'0.01'),
 (2626,6,38,79,21,1349,'7.74'),
 (2627,6,40,79,21,10,'0.06'),
 (2628,6,45,79,21,15,'0.09'),
 (2629,6,48,79,21,7,'0.04'),
 (2630,6,50,79,21,10,'0.06'),
 (2631,6,51,79,21,90,'0.52'),
 (2632,6,55,79,21,8,'0.05'),
 (2633,6,56,79,21,170,'0.97'),
 (2634,6,57,79,21,54,'0.31'),
 (2635,6,58,79,21,10,'0.06'),
 (2636,6,59,79,21,7,'0.04'),
 (2637,6,60,79,21,10,'0.06'),
 (2638,6,61,79,21,6,'0.03'),
 (2639,6,62,79,21,4,'0.02'),
 (2640,11,1,79,1,36858,'55.46'),
 (2641,11,1,79,2,34782,'57.07'),
 (2642,11,1,79,3,49889,'69.49'),
 (2643,11,1,79,4,66839,'72.78'),
 (2644,11,1,79,5,59453,'72.48'),
 (2645,11,1,79,6,44228,'57.95'),
 (2646,11,1,79,7,66472,'70.63'),
 (2647,11,1,79,8,58200,'56.76'),
 (2648,11,1,79,9,38427,'64.71'),
 (2649,11,1,79,10,70628,'51.58'),
 (2650,11,1,79,11,53812,'47.85'),
 (2651,11,1,79,12,19986,'36.69'),
 (2652,11,1,79,13,28368,'28.53'),
 (2653,11,1,79,14,27585,'51.00'),
 (2654,11,1,79,15,65093,'56.03'),
 (2655,11,1,79,16,33370,'50.21'),
 (2656,11,1,79,17,19776,'34.19'),
 (2657,11,1,79,18,9192,'36.58'),
 (2658,11,1,79,19,5804,'33.81'),
 (2659,11,1,79,20,22810,'38.54'),
 (2660,11,1,79,21,9211,'54.04'),
 (2661,13,1,79,1,30779,'52.23'),
 (2662,13,1,79,2,34922,'55.26'),
 (2663,13,1,79,3,44001,'66.34'),
 (2664,13,1,79,4,57147,'71.50'),
 (2665,13,1,79,5,51814,'70.66'),
 (2666,13,1,79,6,39760,'57.73'),
 (2667,13,1,79,7,56169,'69.18'),
 (2668,13,1,79,8,58571,'56.12'),
 (2669,13,1,79,9,35480,'62.24'),
 (2670,13,1,79,10,69017,'51.42'),
 (2671,13,1,79,11,51893,'47.98'),
 (2672,13,1,79,12,20350,'37.54'),
 (2673,13,1,79,13,31160,'29.64'),
 (2674,13,1,79,14,26845,'50.35'),
 (2675,13,1,79,15,61817,'55.69'),
 (2676,13,1,79,16,35758,'50.67'),
 (2677,13,1,79,17,22245,'36.27'),
 (2678,13,1,79,18,10174,'37.49'),
 (2679,13,1,79,19,7667,'34.74'),
 (2680,13,1,79,20,24936,'40.17'),
 (2681,13,1,79,21,9243,'53.02'),
 (2682,27,1,79,1,23706,'47.32'),
 (2683,27,1,79,2,31644,'53.39'),
 (2684,27,1,79,3,39109,'64.78'),
 (2685,27,1,79,4,50318,'71.42'),
 (2686,27,1,79,5,47570,'71.14'),
 (2687,27,1,79,6,32994,'58.00'),
 (2688,27,1,79,7,48519,'68.59'),
 (2689,27,1,79,8,51131,'56.83'),
 (2690,27,1,79,9,33587,'62.54'),
 (2691,27,1,79,10,52162,'50.04'),
 (2692,27,1,79,11,38780,'46.60'),
 (2693,27,1,79,12,15586,'37.01'),
 (2694,27,1,79,13,22935,'28.23'),
 (2695,27,1,79,14,22112,'48.85'),
 (2696,27,1,79,15,52265,'55.88'),
 (2697,27,1,79,16,31203,'51.00'),
 (2698,27,1,79,17,16522,'35.24'),
 (2699,27,1,79,18,7710,'34.28'),
 (2700,27,1,79,19,6978,'34.28'),
 (2701,27,1,79,20,22034,'40.86'),
 (2702,27,1,79,21,8962,'54.39'),
 (2703,20,1,79,1,19118,'41.58'),
 (2704,20,1,79,2,29520,'48.10'),
 (2705,20,1,79,3,33432,'58.22'),
 (2706,20,1,79,4,43316,'65.35'),
 (2707,20,1,79,5,42406,'64.38'),
 (2708,20,1,79,6,29313,'53.04'),
 (2709,20,1,79,7,40154,'61.56'),
 (2710,20,1,79,8,50942,'53.58'),
 (2711,20,1,79,9,29113,'57.36'),
 (2712,20,1,79,10,47122,'49.49'),
 (2713,20,1,79,11,38657,'46.95'),
 (2714,20,1,79,12,16191,'39.83'),
 (2715,20,1,79,13,23693,'31.41'),
 (2716,20,1,79,14,19989,'47.04'),
 (2717,20,1,79,15,46905,'53.40'),
 (2718,20,1,79,16,33380,'50.03'),
 (2719,20,1,79,17,17712,'38.66'),
 (2720,20,1,79,18,9665,'36.45'),
 (2721,20,1,79,19,8472,'36.94'),
 (2722,20,1,79,20,23494,'42.75'),
 (2723,20,1,79,21,9096,'51.54'),
 (2745,12,1,79,1,46180,'54.22'),
 (2746,12,1,79,2,45058,'56.62'),
 (2747,12,1,79,3,60657,'68.66'),
 (2748,12,1,79,4,77658,'71.78'),
 (2749,12,1,79,5,71369,'72.15'),
 (2750,12,1,79,6,55660,'57.48'),
 (2751,12,1,79,7,77470,'70.47'),
 (2752,12,1,79,8,76318,'56.39'),
 (2753,12,1,79,9,46641,'64.02'),
 (2754,12,1,79,10,93172,'51.22'),
 (2755,12,1,79,11,72563,'47.74'),
 (2756,12,1,79,12,28236,'36.73'),
 (2757,12,1,79,13,42604,'29.22'),
 (2758,12,1,79,14,36454,'49.67'),
 (2759,12,1,79,15,83552,'55.54'),
 (2760,12,1,79,16,46147,'49.81'),
 (2761,12,1,79,17,29108,'34.82'),
 (2762,12,1,79,18,13462,'36.45'),
 (2763,12,1,79,19,8863,'33.65'),
 (2764,12,1,79,20,31672,'38.73'),
 (2765,12,1,79,21,12014,'53.50'),
 (2766,15,1,79,1,38167,'55.20'),
 (2767,15,1,79,2,43562,'57.64'),
 (2768,15,1,79,3,53880,'68.61'),
 (2769,15,1,79,4,67790,'73.17'),
 (2770,15,1,79,5,63301,'72.98'),
 (2771,15,1,79,6,49432,'60.54'),
 (2772,15,1,79,7,66524,'71.00'),
 (2773,15,1,79,8,73953,'59.08'),
 (2774,15,1,79,9,43791,'64.87'),
 (2775,15,1,79,10,84787,'54.24'),
 (2776,15,1,79,11,64848,'50.75'),
 (2777,15,1,79,12,26307,'41.00'),
 (2778,15,1,79,13,41487,'33.06'),
 (2779,15,1,79,14,34430,'52.84'),
 (2780,15,1,79,15,77767,'58.63'),
 (2781,15,1,79,16,46307,'53.91'),
 (2782,15,1,79,17,28805,'39.71'),
 (2783,15,1,79,18,13475,'40.18'),
 (2784,15,1,79,19,10498,'38.00'),
 (2785,15,1,79,20,33742,'43.90'),
 (2786,15,1,79,21,11755,'55.53'),
 (2787,17,1,79,1,32174,'44.16'),
 (2788,17,1,79,2,42268,'49.18'),
 (2789,17,1,79,3,49987,'60.19'),
 (2790,17,1,79,4,62517,'66.31'),
 (2791,17,1,79,5,58956,'66.25'),
 (2792,17,1,79,6,44332,'53.02'),
 (2793,17,1,79,7,59665,'63.48'),
 (2794,17,1,79,8,69174,'51.83'),
 (2795,17,1,79,9,42178,'57.81'),
 (2796,17,1,79,10,73530,'46.01'),
 (2797,17,1,79,11,56961,'42.77'),
 (2798,17,1,79,12,24273,'34.33'),
 (2799,17,1,79,13,36197,'26.71'),
 (2800,17,1,79,14,30530,'44.42'),
 (2801,17,1,79,15,71085,'51.40'),
 (2802,17,1,79,16,44170,'46.81'),
 (2803,17,1,79,17,25723,'32.86'),
 (2804,17,1,79,18,11941,'31.71'),
 (2805,17,1,79,19,10992,'31.86'),
 (2806,17,1,79,20,33798,'38.15'),
 (2807,17,1,79,21,12489,'49.37'),
 (2808,19,1,79,1,29626,'42.74'),
 (2809,19,1,79,2,44296,'49.70'),
 (2810,19,1,79,3,49140,'60.50'),
 (2811,19,1,79,4,60167,'66.22'),
 (2812,19,1,79,5,59820,'66.31'),
 (2813,19,1,79,6,44752,'54.55'),
 (2814,19,1,79,7,56725,'63.12'),
 (2815,19,1,79,8,74668,'54.94'),
 (2816,19,1,79,9,42041,'59.29'),
 (2817,19,1,79,10,72218,'49.61'),
 (2818,19,1,79,11,60868,'47.10'),
 (2819,19,1,79,12,27077,'40.42'),
 (2820,19,1,79,13,39750,'32.12'),
 (2821,19,1,79,14,30270,'47.52'),
 (2822,19,1,79,15,69516,'53.78'),
 (2823,19,1,79,16,50651,'51.11'),
 (2824,19,1,79,17,28484,'38.94'),
 (2825,19,1,79,18,14515,'37.83'),
 (2826,19,1,79,19,13856,'38.56'),
 (2827,19,1,79,20,37601,'43.66'),
 (2828,19,1,79,21,13660,'52.80'),
 (2829,22,1,79,1,26584,'41.52'),
 (2830,22,1,79,2,41909,'48.63'),
 (2831,22,1,79,3,45677,'60.14'),
 (2832,22,1,79,4,58007,'67.28'),
 (2833,22,1,79,5,58002,'67.29'),
 (2834,22,1,79,6,42300,'55.12'),
 (2835,22,1,79,7,52588,'62.64'),
 (2836,22,1,79,8,76264,'56.78'),
 (2837,22,1,79,9,39936,'59.78'),
 (2838,22,1,79,10,65740,'50.10'),
 (2839,22,1,79,11,56629,'47.87'),
 (2840,22,1,79,12,25140,'42.08'),
 (2841,22,1,79,13,38240,'34.82'),
 (2842,22,1,79,14,27853,'48.35'),
 (2843,22,1,79,15,64986,'54.75'),
 (2844,22,1,79,16,51136,'53.28'),
 (2845,22,1,79,17,27206,'40.81'),
 (2846,22,1,79,18,17957,'38.70'),
 (2847,22,1,79,19,13799,'40.01'),
 (2848,22,1,79,20,37100,'45.90'),
 (2849,22,1,79,21,13670,'54.28'),
 (2850,25,1,79,1,19197,'27.27'),
 (2851,25,1,79,2,30740,'32.50'),
 (2852,25,1,79,3,34780,'44.04'),
 (2853,25,1,79,4,46533,'51.95'),
 (2854,25,1,79,5,46987,'51.61'),
 (2855,25,1,79,6,31216,'38.39'),
 (2856,25,1,79,7,41194,'46.90'),
 (2857,25,1,79,8,58122,'40.39'),
 (2858,25,1,79,9,32437,'45.30'),
 (2859,25,1,79,10,46092,'34.53'),
 (2860,25,1,79,11,38568,'31.33'),
 (2861,25,1,79,12,16131,'25.80'),
 (2862,25,1,79,13,24000,'20.67'),
 (2863,25,1,79,14,19912,'33.60'),
 (2864,25,1,79,15,47572,'38.84'),
 (2865,25,1,79,16,39246,'37.16'),
 (2866,25,1,79,17,17589,'25.14'),
 (2867,25,1,79,18,12109,'21.98'),
 (2868,25,1,79,19,9065,'24.10'),
 (2869,25,1,79,20,24954,'28.96'),
 (2870,25,1,79,21,9904,'35.80'),
 (2871,26,1,79,1,20734,'30.46'),
 (2872,26,1,79,2,33256,'36.51'),
 (2873,26,1,79,3,37254,'48.74'),
 (2874,26,1,79,4,49908,'56.91'),
 (2875,26,1,79,5,50948,'57.14'),
 (2876,26,1,79,6,33787,'42.95'),
 (2877,26,1,79,7,44202,'51.49'),
 (2878,26,1,79,8,63268,'45.70'),
 (2879,26,1,79,9,34953,'50.15'),
 (2880,26,1,79,10,48810,'38.49'),
 (2881,26,1,79,11,41132,'35.45'),
 (2882,26,1,79,12,17614,'29.90'),
 (2883,26,1,79,13,25761,'23.58'),
 (2884,26,1,79,14,20951,'37.26'),
 (2885,26,1,79,15,50562,'43.04'),
 (2886,26,1,79,16,43116,'42.45'),
 (2887,26,1,79,17,18780,'28.64'),
 (2888,26,1,79,18,13691,'26.13'),
 (2889,26,1,79,19,10062,'28.21'),
 (2890,26,1,79,20,27152,'33.20'),
 (2891,26,1,79,21,10863,'40.91'),
 (2892,14,1,79,1,29666,'50.11'),
 (2893,14,1,79,2,33031,'52.29'),
 (2894,14,1,79,3,42536,'61.25'),
 (2895,14,1,79,4,53837,'67.45'),
 (2896,14,1,79,5,48683,'66.52'),
 (2897,14,1,79,6,37896,'54.83'),
 (2898,14,1,79,7,53584,'65.98'),
 (2899,14,1,79,8,54751,'52.37'),
 (2900,14,1,79,9,33453,'58.54'),
 (2901,14,1,79,10,64834,'48.26'),
 (2902,14,1,79,11,48572,'44.79'),
 (2903,14,1,79,12,19320,'35.58'),
 (2904,14,1,79,13,28983,'27.50'),
 (2905,14,1,79,14,25055,'46.87'),
 (2906,14,1,79,15,58455,'52.48'),
 (2907,14,1,79,16,33061,'46.76'),
 (2908,14,1,79,17,20685,'33.65'),
 (2909,14,1,79,18,9357,'34.32'),
 (2910,14,1,79,19,7251,'32.58'),
 (2911,14,1,79,20,23388,'37.61'),
 (2912,14,1,79,21,8523,'48.95'),
 (2913,16,1,79,1,31986,'47.61'),
 (2914,16,1,79,2,41656,'53.31'),
 (2915,16,1,79,3,49843,'62.08'),
 (2916,16,1,79,4,59899,'68.45'),
 (2917,16,1,79,5,57151,'68.79'),
 (2918,16,1,79,6,42279,'55.24'),
 (2919,16,1,79,7,57515,'65.74'),
 (2920,16,1,79,8,67446,'55.41'),
 (2921,16,1,79,9,40467,'60.08'),
 (2922,16,1,79,10,72512,'49.80'),
 (2923,16,1,79,11,56329,'46.83'),
 (2924,16,1,79,12,24231,'39.04'),
 (2925,16,1,79,13,36952,'30.80'),
 (2926,16,1,79,14,30683,'49.01'),
 (2927,16,1,79,15,69335,'55.11'),
 (2928,16,1,79,16,42601,'50.44'),
 (2929,16,1,79,17,25560,'36.69'),
 (2930,16,1,79,18,12510,'37.31'),
 (2931,16,1,79,19,10373,'35.35'),
 (2932,16,1,79,20,33175,'42.14'),
 (2933,16,1,79,21,11761,'51.72'),
 (2934,18,1,79,1,29037,'48.68'),
 (2935,18,1,79,2,42783,'55.36'),
 (2936,18,1,79,3,50106,'65.00'),
 (2937,18,1,79,4,58937,'72.03'),
 (2938,18,1,79,5,58169,'72.38'),
 (2939,18,1,79,6,42155,'59.65'),
 (2940,18,1,79,7,55271,'68.86'),
 (2941,18,1,79,8,68714,'58.73'),
 (2942,18,1,79,9,40549,'63.98'),
 (2943,18,1,79,10,69604,'54.17'),
 (2944,18,1,79,11,56248,'51.08'),
 (2945,18,1,79,12,24940,'44.40'),
 (2946,18,1,79,13,36033,'34.70'),
 (2947,18,1,79,14,29275,'52.52'),
 (2948,18,1,79,15,67125,'59.39'),
 (2949,18,1,79,16,47123,'55.97'),
 (2950,18,1,79,17,27195,'43.83'),
 (2951,18,1,79,18,13018,'42.06'),
 (2952,18,1,79,19,12628,'41.79'),
 (2953,18,1,79,20,35248,'48.58'),
 (2954,18,1,79,21,13386,'60.34'),
 (2997,11,2,79,1,14706,'22.13'),
 (2998,11,2,79,2,12509,'20.53'),
 (2999,11,2,79,3,9668,'13.47'),
 (3000,11,2,79,4,11563,'12.59'),
 (3001,11,2,79,5,9860,'12.02'),
 (3002,11,2,79,6,16534,'21.66'),
 (3003,11,2,79,7,12554,'13.34'),
 (3004,11,2,79,8,20009,'19.51'),
 (3005,11,2,79,9,9298,'15.66'),
 (3006,11,2,79,10,30023,'21.92'),
 (3007,11,2,79,11,28667,'25.49'),
 (3008,11,2,79,12,18425,'33.82'),
 (3009,11,2,79,13,40196,'40.43'),
 (3010,11,2,79,14,12298,'22.74'),
 (3011,11,2,79,15,24224,'20.85'),
 (3012,11,2,79,16,15520,'23.35'),
 (3013,11,2,79,17,18976,'32.81'),
 (3014,11,2,79,18,8180,'32.55'),
 (3015,11,2,79,19,5911,'34.43'),
 (3016,11,2,79,20,18844,'31.84'),
 (3017,11,2,79,21,3342,'19.61'),
 (3018,13,2,79,1,19178,'32.55'),
 (3019,13,2,79,2,20250,'32.04'),
 (3020,13,2,79,3,15579,'23.49'),
 (3021,13,2,79,4,15822,'19.80'),
 (3022,13,2,79,5,14611,'19.93'),
 (3023,13,2,79,6,21106,'30.64'),
 (3024,13,2,79,7,17113,'21.08'),
 (3025,13,2,79,8,33088,'31.71'),
 (3026,13,2,79,9,14938,'26.21'),
 (3027,13,2,79,10,46511,'34.65'),
 (3028,13,2,79,11,41308,'38.19'),
 (3029,13,2,79,12,25924,'47.82'),
 (3030,13,2,79,13,57260,'54.46'),
 (3031,13,2,79,14,19441,'36.47'),
 (3032,13,2,79,15,36037,'32.47'),
 (3033,13,2,79,16,25729,'36.46'),
 (3034,13,2,79,17,29403,'47.94'),
 (3035,13,2,79,18,12996,'47.89'),
 (3036,13,2,79,19,10487,'47.52'),
 (3037,13,2,79,20,27917,'44.97'),
 (3038,13,2,79,21,5698,'32.69'),
 (3039,27,2,79,1,20349,'40.62'),
 (3040,27,2,79,2,22716,'38.33'),
 (3041,27,2,79,3,17484,'28.96'),
 (3042,27,2,79,4,16484,'23.40'),
 (3043,27,2,79,5,15806,'23.64'),
 (3044,27,2,79,6,19972,'35.11'),
 (3045,27,2,79,7,17892,'25.29'),
 (3046,27,2,79,8,32902,'36.57'),
 (3047,27,2,79,9,16390,'30.52'),
 (3048,27,2,79,10,43860,'42.08'),
 (3049,27,2,79,11,38109,'45.79'),
 (3050,27,2,79,12,23133,'54.93'),
 (3051,27,2,79,13,50251,'61.86'),
 (3052,27,2,79,14,19657,'43.43'),
 (3053,27,2,79,15,35029,'37.45'),
 (3054,27,2,79,16,25604,'41.85'),
 (3055,27,2,79,17,26331,'56.16'),
 (3056,27,2,79,18,12833,'57.07'),
 (3057,27,2,79,19,11344,'55.73'),
 (3058,27,2,79,20,27505,'51.01'),
 (3059,27,2,79,21,6261,'38.00'),
 (3060,20,2,79,1,17263,'37.55'),
 (3061,20,2,79,2,20696,'33.72'),
 (3062,20,2,79,3,14413,'25.10'),
 (3063,20,2,79,4,13251,'19.99'),
 (3064,20,2,79,5,13095,'19.88'),
 (3065,20,2,79,6,16938,'30.65'),
 (3066,20,2,79,7,14810,'22.70'),
 (3067,20,2,79,8,28826,'30.32'),
 (3068,20,2,79,9,13230,'26.07'),
 (3069,20,2,79,10,34334,'36.06'),
 (3070,20,2,79,11,32179,'39.09'),
 (3071,20,2,79,12,18941,'46.60'),
 (3072,20,2,79,13,40123,'53.18'),
 (3073,20,2,79,14,16188,'38.09'),
 (3074,20,2,79,15,28203,'32.11'),
 (3075,20,2,79,16,22433,'33.62'),
 (3076,20,2,79,17,21724,'47.42'),
 (3077,20,2,79,18,12276,'46.29'),
 (3078,20,2,79,19,10349,'45.13'),
 (3079,20,2,79,20,22544,'41.02'),
 (3080,20,2,79,21,5390,'30.54'),
 (3102,12,2,79,1,23629,'27.74'),
 (3103,12,2,79,2,20539,'25.81'),
 (3104,12,2,79,3,15935,'18.04'),
 (3105,12,2,79,4,17951,'16.59'),
 (3106,12,2,79,5,16016,'16.19'),
 (3107,12,2,79,6,25935,'26.78'),
 (3108,12,2,79,7,19184,'17.45'),
 (3109,12,2,79,8,35302,'26.09'),
 (3110,12,2,79,9,15314,'21.02'),
 (3111,12,2,79,10,52482,'28.85'),
 (3112,12,2,79,11,49357,'32.47'),
 (3113,12,2,79,12,32185,'41.87'),
 (3114,12,2,79,13,70432,'48.30'),
 (3115,12,2,79,14,22179,'30.22'),
 (3116,12,2,79,15,40525,'26.94'),
 (3117,12,2,79,16,28478,'30.74'),
 (3118,12,2,79,17,34585,'41.37'),
 (3119,12,2,79,18,15269,'41.34'),
 (3120,12,2,79,19,11101,'42.14'),
 (3121,12,2,79,20,32599,'39.86'),
 (3122,12,2,79,21,5977,'26.62'),
 (3123,15,2,79,1,19913,'28.80'),
 (3124,15,2,79,2,21317,'28.20'),
 (3125,15,2,79,3,16338,'20.80'),
 (3126,15,2,79,4,16272,'17.56'),
 (3127,15,2,79,5,15376,'17.73'),
 (3128,15,2,79,6,22520,'27.58'),
 (3129,15,2,79,7,17714,'18.91'),
 (3130,15,2,79,8,34903,'27.88'),
 (3131,15,2,79,9,15752,'23.33'),
 (3132,15,2,79,10,48356,'30.94'),
 (3133,15,2,79,11,43693,'34.19'),
 (3134,15,2,79,12,27744,'43.24'),
 (3135,15,2,79,13,62413,'49.74'),
 (3136,15,2,79,14,21119,'32.41'),
 (3137,15,2,79,15,37948,'28.61'),
 (3138,15,2,79,16,27282,'31.76'),
 (3139,15,2,79,17,31306,'43.15'),
 (3140,15,2,79,18,14543,'43.37'),
 (3141,15,2,79,19,11922,'43.15'),
 (3142,15,2,79,20,30821,'40.10'),
 (3143,15,2,79,21,6150,'29.05'),
 (3144,17,2,79,1,30162,'41.40'),
 (3145,17,2,79,2,34004,'39.57'),
 (3146,17,2,79,3,25621,'30.85'),
 (3147,17,2,79,4,24546,'26.03'),
 (3148,17,2,79,5,23147,'26.01'),
 (3149,17,2,79,6,31260,'37.39'),
 (3150,17,2,79,7,26250,'27.93'),
 (3151,17,2,79,8,50985,'38.20'),
 (3152,17,2,79,9,23814,'32.64'),
 (3153,17,2,79,10,68775,'43.03'),
 (3154,17,2,79,11,61424,'46.12'),
 (3155,17,2,79,12,38546,'54.52'),
 (3156,17,2,79,13,81897,'60.44'),
 (3157,17,2,79,14,30571,'44.48'),
 (3158,17,2,79,15,53569,'38.74'),
 (3159,17,2,79,16,40434,'42.85'),
 (3160,17,2,79,17,43216,'55.20'),
 (3161,17,2,79,18,20999,'55.77'),
 (3162,17,2,79,19,18865,'54.68'),
 (3163,17,2,79,20,44574,'50.31'),
 (3164,17,2,79,21,10040,'39.69'),
 (3165,19,2,79,1,29401,'42.42'),
 (3166,19,2,79,2,33384,'37.46'),
 (3167,19,2,79,3,23374,'28.78'),
 (3168,19,2,79,4,21636,'23.81'),
 (3169,19,2,79,5,21376,'23.70'),
 (3170,19,2,79,6,28471,'34.71'),
 (3171,19,2,79,7,23862,'26.55'),
 (3172,19,2,79,8,46346,'34.10'),
 (3173,19,2,79,9,20822,'29.37'),
 (3174,19,2,79,10,57516,'39.51'),
 (3175,19,2,79,11,54363,'42.07'),
 (3176,19,2,79,12,32695,'48.80'),
 (3177,19,2,79,13,68884,'55.66'),
 (3178,19,2,79,14,26127,'41.02'),
 (3179,19,2,79,15,46303,'35.82'),
 (3180,19,2,79,16,36974,'37.31'),
 (3181,19,2,79,17,36075,'49.31'),
 (3182,19,2,79,18,19100,'49.78'),
 (3183,19,2,79,19,17440,'48.53'),
 (3184,19,2,79,20,38366,'44.55'),
 (3185,19,2,79,21,9065,'35.04'),
 (3186,22,2,79,1,17697,'27.64'),
 (3187,22,2,79,2,21586,'25.05'),
 (3188,22,2,79,3,14823,'19.52'),
 (3189,22,2,79,4,13645,'15.83'),
 (3190,22,2,79,5,13201,'15.31'),
 (3191,22,2,79,6,17977,'23.42'),
 (3192,22,2,79,7,15083,'17.97'),
 (3193,22,2,79,8,30061,'22.38'),
 (3194,22,2,79,9,13494,'20.20'),
 (3195,22,2,79,10,35768,'27.26'),
 (3196,22,2,79,11,34332,'29.02'),
 (3197,22,2,79,12,20518,'34.34'),
 (3198,22,2,79,13,42748,'38.92'),
 (3199,22,2,79,14,16543,'28.72'),
 (3200,22,2,79,15,29006,'24.44'),
 (3201,22,2,79,16,23205,'24.18'),
 (3202,22,2,79,17,23449,'35.18'),
 (3203,22,2,79,18,14935,'32.19'),
 (3204,22,2,79,19,11070,'32.10'),
 (3205,22,2,79,20,23873,'29.53'),
 (3206,22,2,79,21,5640,'22.40'),
 (3207,25,2,79,1,9912,'14.08'),
 (3208,25,2,79,2,14122,'14.93'),
 (3209,25,2,79,3,9404,'11.91'),
 (3210,25,2,79,4,8958,'10.00'),
 (3211,25,2,79,5,8674,'9.53'),
 (3212,25,2,79,6,12950,'15.93'),
 (3213,25,2,79,7,9601,'10.93'),
 (3214,25,2,79,8,21501,'14.94'),
 (3215,25,2,79,9,8986,'12.55'),
 (3216,25,2,79,10,25356,'19.00'),
 (3217,25,2,79,11,25195,'20.47'),
 (3218,25,2,79,12,15480,'24.76'),
 (3219,25,2,79,13,30142,'25.95'),
 (3220,25,2,79,14,11230,'18.95'),
 (3221,25,2,79,15,20649,'16.86'),
 (3222,25,2,79,16,16573,'15.69'),
 (3223,25,2,79,17,17928,'25.63'),
 (3224,25,2,79,18,10875,'19.74'),
 (3225,25,2,79,19,8081,'21.49'),
 (3226,25,2,79,20,17244,'20.01'),
 (3227,25,2,79,21,4026,'14.55'),
 (3228,26,2,79,1,11643,'17.10'),
 (3229,26,2,79,2,16328,'17.93'),
 (3230,26,2,79,3,11084,'14.50'),
 (3231,26,2,79,4,10092,'11.51'),
 (3232,26,2,79,5,9964,'11.17'),
 (3233,26,2,79,6,14161,'18.00'),
 (3234,26,2,79,7,11324,'13.19'),
 (3235,26,2,79,8,23287,'16.82'),
 (3236,26,2,79,9,10146,'14.56'),
 (3237,26,2,79,10,26642,'21.01'),
 (3238,26,2,79,11,26324,'22.69'),
 (3239,26,2,79,12,15552,'26.40'),
 (3240,26,2,79,13,30537,'27.95'),
 (3241,26,2,79,14,12017,'21.37'),
 (3242,26,2,79,15,21919,'18.66'),
 (3243,26,2,79,16,17774,'17.50'),
 (3244,26,2,79,17,18280,'27.88'),
 (3245,26,2,79,18,11726,'22.38'),
 (3246,26,2,79,19,8535,'23.93'),
 (3247,26,2,79,20,18228,'22.29'),
 (3248,26,2,79,21,4384,'16.51'),
 (3249,14,2,79,1,20693,'34.95'),
 (3250,14,2,79,2,21145,'33.47'),
 (3251,14,2,79,3,18048,'25.99'),
 (3252,14,2,79,4,17240,'21.60'),
 (3253,14,2,79,5,16062,'21.95'),
 (3254,14,2,79,6,22189,'32.10'),
 (3255,14,2,79,7,18408,'22.67'),
 (3256,14,2,79,8,34860,'33.34'),
 (3257,14,2,79,9,15861,'27.76'),
 (3258,14,2,79,10,48400,'36.03'),
 (3259,14,2,79,11,42306,'39.01'),
 (3260,14,2,79,12,26488,'48.78'),
 (3261,14,2,79,13,58725,'55.72'),
 (3262,14,2,79,14,20122,'37.64'),
 (3263,14,2,79,15,37558,'33.72'),
 (3264,14,2,79,16,27045,'38.25'),
 (3265,14,2,79,17,30311,'49.31'),
 (3266,14,2,79,18,13533,'49.63'),
 (3267,14,2,79,19,10801,'48.53'),
 (3268,14,2,79,20,28936,'46.54'),
 (3269,14,2,79,21,5969,'34.28'),
 (3270,16,2,79,1,23534,'35.03'),
 (3271,16,2,79,2,26631,'34.08'),
 (3272,16,2,79,3,21769,'27.11'),
 (3273,16,2,79,4,19517,'22.30'),
 (3274,16,2,79,5,18219,'21.93'),
 (3275,16,2,79,6,25259,'33.00'),
 (3276,16,2,79,7,21070,'24.08'),
 (3277,16,2,79,8,40827,'33.54'),
 (3278,16,2,79,9,18907,'28.07'),
 (3279,16,2,79,10,55460,'38.09'),
 (3280,16,2,79,11,49109,'40.83'),
 (3281,16,2,79,12,30080,'48.46'),
 (3282,16,2,79,13,65473,'54.57'),
 (3283,16,2,79,14,24384,'38.95'),
 (3284,16,2,79,15,42852,'34.06'),
 (3285,16,2,79,16,32163,'38.08'),
 (3286,16,2,79,17,34874,'50.06'),
 (3287,16,2,79,18,16713,'49.85'),
 (3288,16,2,79,19,14643,'49.91'),
 (3289,16,2,79,20,35630,'45.25'),
 (3290,16,2,79,21,8034,'35.33'),
 (3291,18,2,79,1,19379,'32.49'),
 (3292,18,2,79,2,22806,'29.51'),
 (3293,18,2,79,3,17480,'22.67'),
 (3294,18,2,79,4,14931,'18.25'),
 (3295,18,2,79,5,14289,'17.78'),
 (3296,18,2,79,6,19453,'27.52'),
 (3297,18,2,79,7,16224,'20.21'),
 (3298,18,2,79,8,33060,'28.26'),
 (3299,18,2,79,9,14942,'23.58'),
 (3300,18,2,79,10,41550,'32.33'),
 (3301,18,2,79,11,38696,'35.14'),
 (3302,18,2,79,12,23422,'41.70'),
 (3303,18,2,79,13,50511,'48.64'),
 (3304,18,2,79,14,18680,'33.52'),
 (3305,18,2,79,15,31772,'28.11'),
 (3306,18,2,79,16,26283,'31.22'),
 (3307,18,2,79,17,25827,'41.63'),
 (3308,18,2,79,18,13164,'42.53'),
 (3309,18,2,79,19,12657,'41.89'),
 (3310,18,2,79,20,26802,'36.94'),
 (3311,18,2,79,21,5965,'26.89'),
 (3564,25,5,79,1,23116,'32.84'),
 (3565,25,5,79,2,22292,'23.57'),
 (3566,25,5,79,3,12818,'16.23'),
 (3567,25,5,79,4,10488,'11.71'),
 (3568,25,5,79,5,10149,'11.15'),
 (3569,25,5,79,6,15299,'18.82'),
 (3570,25,5,79,7,12950,'14.75'),
 (3571,25,5,79,8,22584,'15.69'),
 (3572,25,5,79,9,11141,'15.56'),
 (3573,25,5,79,10,29724,'22.27'),
 (3574,25,5,79,11,28464,'23.13'),
 (3575,25,5,79,12,16427,'26.27'),
 (3576,25,5,79,13,37705,'32.47'),
 (3577,25,5,79,14,13337,'22.51'),
 (3578,25,5,79,15,22273,'18.19'),
 (3579,25,5,79,16,18709,'17.72'),
 (3580,25,5,79,17,17836,'25.50'),
 (3581,25,5,79,18,16256,'29.51'),
 (3582,25,5,79,19,9699,'25.79'),
 (3583,25,5,79,20,20012,'23.22'),
 (3584,25,5,79,21,5004,'18.09'),
 (3585,26,5,79,1,23760,'34.91'),
 (3586,26,5,79,2,22753,'24.98'),
 (3587,26,5,79,3,12192,'15.95'),
 (3588,26,5,79,4,10009,'11.41'),
 (3589,26,5,79,5,9675,'10.85'),
 (3590,26,5,79,6,15021,'19.09'),
 (3591,26,5,79,7,12681,'14.77'),
 (3592,26,5,79,8,21548,'15.56'),
 (3593,26,5,79,9,10872,'15.60'),
 (3594,26,5,79,10,29237,'23.06'),
 (3595,26,5,79,11,27707,'23.88'),
 (3596,26,5,79,12,15885,'26.96'),
 (3597,26,5,79,13,37003,'33.87'),
 (3598,26,5,79,14,13182,'23.44'),
 (3599,26,5,79,15,21936,'18.67'),
 (3600,26,5,79,16,17806,'17.53'),
 (3601,26,5,79,17,17279,'26.35'),
 (3602,26,5,79,18,15666,'29.90'),
 (3603,26,5,79,19,9415,'26.40'),
 (3604,26,5,79,20,19176,'23.45'),
 (3605,26,5,79,21,4723,'17.79'),
 (3879,19,8,79,1,148,'0.21'),
 (3880,19,8,79,2,170,'0.19'),
 (3881,19,8,79,3,132,'0.16'),
 (3882,19,8,79,4,143,'0.16'),
 (3883,19,8,79,5,152,'0.17'),
 (3884,19,8,79,6,136,'0.17'),
 (3885,19,8,79,7,203,'0.23'),
 (3886,19,8,79,8,181,'0.13'),
 (3887,19,8,79,9,124,'0.17'),
 (3888,19,8,79,10,155,'0.11'),
 (3889,19,8,79,11,132,'0.10'),
 (3890,19,8,79,12,42,'0.06'),
 (3891,19,8,79,13,97,'0.08'),
 (3892,19,8,79,14,89,'0.14'),
 (3893,19,8,79,15,144,'0.11'),
 (3894,19,8,79,16,113,'0.11'),
 (3895,19,8,79,17,41,'0.06'),
 (3896,19,8,79,18,38,'0.10'),
 (3897,19,8,79,19,40,'0.11'),
 (3898,19,8,79,20,93,'0.11'),
 (3899,19,8,79,21,37,'0.14'),
 (3921,25,8,79,1,9991,'14.19'),
 (3922,25,8,79,2,17429,'18.42'),
 (3923,25,8,79,3,15324,'19.40'),
 (3924,25,8,79,4,17292,'19.31'),
 (3925,25,8,79,5,18834,'20.69'),
 (3926,25,8,79,6,14315,'17.61'),
 (3927,25,8,79,7,16803,'19.13'),
 (3928,25,8,79,8,29992,'20.84'),
 (3929,25,8,79,9,13258,'18.52'),
 (3930,25,8,79,10,19539,'14.64'),
 (3931,25,8,79,11,18919,'15.37'),
 (3932,25,8,79,12,8497,'13.59'),
 (3933,25,8,79,13,12690,'10.93'),
 (3934,25,8,79,14,9158,'15.45'),
 (3935,25,8,79,15,21189,'17.30'),
 (3936,25,8,79,16,22392,'21.20'),
 (3937,25,8,79,17,9694,'13.86'),
 (3938,25,8,79,18,10277,'18.65'),
 (3939,25,8,79,19,6917,'18.39'),
 (3940,25,8,79,20,15874,'18.42'),
 (3941,25,8,79,21,6415,'23.19'),
 (3942,26,8,79,1,9737,'14.30'),
 (3943,26,8,79,2,16054,'17.62'),
 (3944,26,8,79,3,13782,'18.03'),
 (3945,26,8,79,4,15427,'17.59'),
 (3946,26,8,79,5,16327,'18.31'),
 (3947,26,8,79,6,13150,'16.72'),
 (3948,26,8,79,7,15234,'17.74'),
 (3949,26,8,79,8,26655,'19.25'),
 (3950,26,8,79,9,11914,'17.10'),
 (3951,26,8,79,10,18008,'14.20'),
 (3952,26,8,79,11,17215,'14.84'),
 (3953,26,8,79,12,7968,'13.52'),
 (3954,26,8,79,13,12425,'11.37'),
 (3955,26,8,79,14,8455,'15.04'),
 (3956,26,8,79,15,19646,'16.72'),
 (3957,26,8,79,16,20124,'19.81'),
 (3958,26,8,79,17,9130,'13.93'),
 (3959,26,8,79,18,9569,'18.26'),
 (3960,26,8,79,19,6453,'18.09'),
 (3961,26,8,79,20,14590,'17.84'),
 (3962,26,8,79,21,5848,'22.02'),
 (4131,20,9,79,1,3153,'6.86'),
 (4132,20,9,79,2,4881,'7.95'),
 (4133,20,9,79,3,4773,'8.31'),
 (4134,20,9,79,4,5085,'7.67'),
 (4135,20,9,79,5,5623,'8.54'),
 (4136,20,9,79,6,3897,'7.05'),
 (4137,20,9,79,7,4973,'7.62'),
 (4138,20,9,79,8,7737,'8.14'),
 (4139,20,9,79,9,4104,'8.09'),
 (4140,20,9,79,10,5113,'5.37'),
 (4141,20,9,79,11,4334,'5.26'),
 (4142,20,9,79,12,1901,'4.68'),
 (4143,20,9,79,13,2962,'3.93'),
 (4144,20,9,79,14,2618,'6.16'),
 (4145,20,9,79,15,5790,'6.59'),
 (4146,20,9,79,16,5361,'8.03'),
 (4147,20,9,79,17,2071,'4.52'),
 (4148,20,9,79,18,1603,'6.04'),
 (4149,20,9,79,19,1781,'7.77'),
 (4150,20,9,79,20,3914,'7.12'),
 (4151,20,9,79,21,1651,'9.36'),
 (4236,19,9,79,1,3022,'4.36'),
 (4237,19,9,79,2,4321,'4.85'),
 (4238,19,9,79,3,3936,'4.85'),
 (4239,19,9,79,4,4077,'4.49'),
 (4240,19,9,79,5,4674,'5.18'),
 (4241,19,9,79,6,3321,'4.05'),
 (4242,19,9,79,7,4106,'4.57'),
 (4243,19,9,79,8,6453,'4.75'),
 (4244,19,9,79,9,3386,'4.78'),
 (4245,19,9,79,10,4876,'3.35'),
 (4246,19,9,79,11,4041,'3.13'),
 (4247,19,9,79,12,1814,'2.71'),
 (4248,19,9,79,13,3001,'2.42'),
 (4249,19,9,79,14,2461,'3.86'),
 (4250,19,9,79,15,5064,'3.92'),
 (4251,19,9,79,16,4557,'4.60'),
 (4252,19,9,79,17,1944,'2.66'),
 (4253,19,9,79,18,1240,'3.23'),
 (4254,19,9,79,19,1507,'4.19'),
 (4255,19,9,79,20,3389,'3.94'),
 (4256,19,9,79,21,1415,'5.47'),
 (4257,22,9,79,1,5929,'9.26'),
 (4258,22,9,79,2,9456,'10.97'),
 (4259,22,9,79,3,7201,'9.48'),
 (4260,22,9,79,4,7143,'8.28'),
 (4261,22,9,79,5,7475,'8.67'),
 (4262,22,9,79,6,7452,'9.71'),
 (4263,22,9,79,7,7307,'8.70'),
 (4264,22,9,79,8,13788,'10.27'),
 (4265,22,9,79,9,5983,'8.96'),
 (4266,22,9,79,10,12477,'9.51'),
 (4267,22,9,79,11,11765,'9.95'),
 (4268,22,9,79,12,5604,'9.38'),
 (4269,22,9,79,13,9684,'8.82'),
 (4270,22,9,79,14,5528,'9.60'),
 (4271,22,9,79,15,11231,'9.46'),
 (4272,22,9,79,16,10538,'10.98'),
 (4273,22,9,79,17,6516,'9.78'),
 (4274,22,9,79,18,5473,'11.80'),
 (4275,22,9,79,19,4233,'12.27'),
 (4276,22,9,79,20,8949,'11.07'),
 (4277,22,9,79,21,2856,'11.34'),
 (4278,25,9,79,1,931,'1.32'),
 (4279,25,9,79,2,1493,'1.58'),
 (4280,25,9,79,3,1169,'1.48'),
 (4281,25,9,79,4,1068,'1.19'),
 (4282,25,9,79,5,1111,'1.22'),
 (4283,25,9,79,6,1114,'1.37'),
 (4284,25,9,79,7,1158,'1.32'),
 (4285,25,9,79,8,2015,'1.40'),
 (4286,25,9,79,9,993,'1.39'),
 (4287,25,9,79,10,1757,'1.32'),
 (4288,25,9,79,11,1484,'1.21'),
 (4289,25,9,79,12,639,'1.02'),
 (4290,25,9,79,13,1031,'0.89'),
 (4291,25,9,79,14,772,'1.30'),
 (4292,25,9,79,15,1539,'1.26'),
 (4293,25,9,79,16,1357,'1.29'),
 (4294,25,9,79,17,742,'1.06'),
 (4295,25,9,79,18,612,'1.11'),
 (4296,25,9,79,19,526,'1.40'),
 (4297,25,9,79,20,1035,'1.20'),
 (4298,25,9,79,21,394,'1.42'),
 (4299,26,9,79,1,335,'0.49'),
 (4300,26,9,79,2,491,'0.54'),
 (4301,26,9,79,3,371,'0.49'),
 (4302,26,9,79,4,296,'0.34'),
 (4303,26,9,79,5,344,'0.39'),
 (4304,26,9,79,6,367,'0.47'),
 (4305,26,9,79,7,386,'0.45'),
 (4306,26,9,79,8,599,'0.43'),
 (4307,26,9,79,9,291,'0.42'),
 (4308,26,9,79,10,553,'0.44'),
 (4309,26,9,79,11,494,'0.43'),
 (4310,26,9,79,12,250,'0.42'),
 (4311,26,9,79,13,352,'0.32'),
 (4312,26,9,79,14,214,'0.38'),
 (4313,26,9,79,15,440,'0.37'),
 (4314,26,9,79,16,430,'0.42'),
 (4315,26,9,79,17,261,'0.40'),
 (4316,26,9,79,18,231,'0.44'),
 (4317,26,9,79,19,181,'0.51'),
 (4318,26,9,79,20,335,'0.41'),
 (4319,26,9,79,21,115,'0.43'),
 (4425,11,12,79,1,10991,'16.54'),
 (4426,11,12,79,2,10088,'16.55'),
 (4427,11,12,79,3,7800,'10.86'),
 (4428,11,12,79,4,8337,'9.08'),
 (4429,11,12,79,5,7863,'9.59'),
 (4430,11,12,79,6,11281,'14.78'),
 (4431,11,12,79,7,9490,'10.08'),
 (4432,11,12,79,8,17234,'16.81'),
 (4433,11,12,79,9,7819,'13.17'),
 (4434,11,12,79,10,27207,'19.87'),
 (4435,11,12,79,11,23305,'20.72'),
 (4436,11,12,79,12,13264,'24.35'),
 (4437,11,12,79,13,25151,'25.29'),
 (4438,11,12,79,14,10623,'19.64'),
 (4439,11,12,79,15,19875,'17.11'),
 (4440,11,12,79,16,12934,'19.46'),
 (4441,11,12,79,17,15885,'27.46'),
 (4442,11,12,79,18,6296,'25.05'),
 (4443,11,12,79,19,4368,'25.45'),
 (4444,11,12,79,20,14268,'24.11'),
 (4445,11,12,79,21,3214,'18.86'),
 (4446,13,12,79,1,4729,'8.03'),
 (4447,13,12,79,2,4567,'7.23'),
 (4448,13,12,79,3,3258,'4.91'),
 (4449,13,12,79,4,3160,'3.95'),
 (4450,13,12,79,5,3205,'4.37'),
 (4451,13,12,79,6,4297,'6.24'),
 (4452,13,12,79,7,3694,'4.55'),
 (4453,13,12,79,8,6564,'6.29'),
 (4454,13,12,79,9,3354,'5.88'),
 (4455,13,12,79,10,10933,'8.14'),
 (4456,13,12,79,11,9170,'8.48'),
 (4457,13,12,79,12,5214,'9.62'),
 (4458,13,12,79,13,11645,'11.08'),
 (4459,13,12,79,14,4186,'7.85'),
 (4460,13,12,79,15,7347,'6.62'),
 (4461,13,12,79,16,5075,'7.19'),
 (4462,13,12,79,17,6741,'10.99'),
 (4463,13,12,79,18,2545,'9.38'),
 (4464,13,12,79,19,2644,'11.98'),
 (4465,13,12,79,20,5931,'9.55'),
 (4466,13,12,79,21,1409,'8.08'),
 (4467,27,12,79,1,4448,'8.88'),
 (4468,27,12,79,2,3372,'5.69'),
 (4469,27,12,79,3,2295,'3.80'),
 (4470,27,12,79,4,2030,'2.88'),
 (4471,27,12,79,5,1956,'2.93'),
 (4472,27,12,79,6,2460,'4.32'),
 (4473,27,12,79,7,2689,'3.80'),
 (4474,27,12,79,8,3627,'4.03'),
 (4475,27,12,79,9,2430,'4.52'),
 (4476,27,12,79,10,5708,'5.48'),
 (4477,27,12,79,11,4497,'5.40'),
 (4478,27,12,79,12,2560,'6.08'),
 (4479,27,12,79,13,6477,'7.97'),
 (4480,27,12,79,14,2444,'5.40'),
 (4481,27,12,79,15,4072,'4.35'),
 (4482,27,12,79,16,2905,'4.75'),
 (4483,27,12,79,17,3103,'6.62'),
 (4484,27,12,79,18,1456,'6.47'),
 (4485,27,12,79,19,1527,'7.50'),
 (4486,27,12,79,20,3132,'5.81'),
 (4487,27,12,79,21,794,'4.82'),
 (4488,20,12,79,1,3692,'8.03'),
 (4489,20,12,79,2,3319,'5.41'),
 (4490,20,12,79,3,2046,'3.56'),
 (4491,20,12,79,4,1641,'2.48'),
 (4492,20,12,79,5,1745,'2.65'),
 (4493,20,12,79,6,2179,'3.94'),
 (4494,20,12,79,7,2233,'3.42'),
 (4495,20,12,79,8,3212,'3.38'),
 (4496,20,12,79,9,1998,'3.94'),
 (4497,20,12,79,10,4510,'4.74'),
 (4498,20,12,79,11,3812,'4.63'),
 (4499,20,12,79,12,2111,'5.19'),
 (4500,20,12,79,13,5646,'7.48'),
 (4501,20,12,79,14,2024,'4.76'),
 (4502,20,12,79,15,3428,'3.90'),
 (4503,20,12,79,16,2611,'3.91'),
 (4504,20,12,79,17,2571,'5.61'),
 (4505,20,12,79,18,1820,'6.86'),
 (4506,20,12,79,19,1436,'6.26'),
 (4507,20,12,79,20,2793,'5.08'),
 (4508,20,12,79,21,751,'4.26'),
 (4530,12,12,79,1,13113,'15.40'),
 (4531,12,12,79,2,11870,'14.92'),
 (4532,12,12,79,3,9080,'10.28'),
 (4533,12,12,79,4,9363,'8.65'),
 (4534,12,12,79,5,8832,'8.93'),
 (4535,12,12,79,6,12588,'13.00'),
 (4536,12,12,79,7,10392,'9.45'),
 (4537,12,12,79,8,19314,'14.27'),
 (4538,12,12,79,9,8790,'12.06'),
 (4539,12,12,79,10,30803,'16.93'),
 (4540,12,12,79,11,26002,'17.11'),
 (4541,12,12,79,12,14524,'18.89'),
 (4542,12,12,79,13,29289,'20.08'),
 (4543,12,12,79,14,12429,'16.93'),
 (4544,12,12,79,15,22058,'14.66'),
 (4545,12,12,79,16,14900,'16.08'),
 (4546,12,12,79,17,17620,'21.08'),
 (4547,12,12,79,18,7217,'19.54'),
 (4548,12,12,79,19,5670,'21.52'),
 (4549,12,12,79,20,15307,'18.72'),
 (4550,12,12,79,21,3719,'16.56'),
 (4551,15,12,79,1,7542,'10.91'),
 (4552,15,12,79,2,6800,'9.00'),
 (4553,15,12,79,3,4847,'6.17'),
 (4554,15,12,79,4,4735,'5.11'),
 (4555,15,12,79,5,4551,'5.25'),
 (4556,15,12,79,6,5760,'7.05'),
 (4557,15,12,79,7,5493,'5.86'),
 (4558,15,12,79,8,9625,'7.69'),
 (4559,15,12,79,9,4834,'7.16'),
 (4560,15,12,79,10,14739,'9.43'),
 (4561,15,12,79,11,12364,'9.68'),
 (4562,15,12,79,12,6887,'10.73'),
 (4563,15,12,79,13,15432,'12.30'),
 (4564,15,12,79,14,6192,'9.50'),
 (4565,15,12,79,15,10596,'7.99'),
 (4566,15,12,79,16,7624,'8.88'),
 (4567,15,12,79,17,8699,'11.99'),
 (4568,15,12,79,18,3667,'10.94'),
 (4569,15,12,79,19,3629,'13.14'),
 (4570,15,12,79,20,8168,'10.63'),
 (4571,15,12,79,21,1999,'9.44'),
 (4572,17,12,79,1,7216,'9.91'),
 (4573,17,12,79,2,5596,'6.51'),
 (4574,17,12,79,3,3783,'4.56'),
 (4575,17,12,79,4,3492,'3.70'),
 (4576,17,12,79,5,3355,'3.77'),
 (4577,17,12,79,6,4235,'5.06'),
 (4578,17,12,79,7,4336,'4.61'),
 (4579,17,12,79,8,6815,'5.11'),
 (4580,17,12,79,9,3788,'5.19'),
 (4581,17,12,79,10,9935,'6.22'),
 (4582,17,12,79,11,8895,'6.68'),
 (4583,17,12,79,12,4839,'6.84'),
 (4584,17,12,79,13,12248,'9.04'),
 (4585,17,12,79,14,4484,'6.52'),
 (4586,17,12,79,15,7485,'5.41'),
 (4587,17,12,79,16,5199,'5.51'),
 (4588,17,12,79,17,6017,'7.69'),
 (4589,17,12,79,18,2964,'7.87'),
 (4590,17,12,79,19,2986,'8.65'),
 (4591,17,12,79,20,6250,'7.05'),
 (4592,17,12,79,21,1509,'5.96'),
 (4593,19,12,79,1,5558,'8.02'),
 (4594,19,12,79,2,4698,'5.27'),
 (4595,19,12,79,3,2916,'3.59'),
 (4596,19,12,79,4,2410,'2.65'),
 (4597,19,12,79,5,2458,'2.72'),
 (4598,19,12,79,6,3381,'4.12'),
 (4599,19,12,79,7,3225,'3.59'),
 (4600,19,12,79,8,5025,'3.70'),
 (4601,19,12,79,9,2861,'4.04'),
 (4602,19,12,79,10,7022,'4.82'),
 (4603,19,12,79,11,6494,'5.02'),
 (4604,19,12,79,12,3694,'5.51'),
 (4605,19,12,79,13,9038,'7.30'),
 (4606,19,12,79,14,3236,'5.08'),
 (4607,19,12,79,15,5226,'4.04'),
 (4608,19,12,79,16,4134,'4.17'),
 (4609,19,12,79,17,4473,'6.11'),
 (4610,19,12,79,18,2476,'6.45'),
 (4611,19,12,79,19,2133,'5.94'),
 (4612,19,12,79,20,4457,'5.18'),
 (4613,19,12,79,21,1079,'4.17'),
 (4614,22,12,79,1,7761,'12.12'),
 (4615,22,12,79,2,7787,'9.04'),
 (4616,22,12,79,3,4478,'5.90'),
 (4617,22,12,79,4,3662,'4.25'),
 (4618,22,12,79,5,3624,'4.20'),
 (4619,22,12,79,6,5147,'6.71'),
 (4620,22,12,79,7,4537,'5.40'),
 (4621,22,12,79,8,8089,'6.02'),
 (4622,22,12,79,9,4140,'6.20'),
 (4623,22,12,79,10,10994,'8.38'),
 (4624,22,12,79,11,10174,'8.60'),
 (4625,22,12,79,12,5763,'9.65'),
 (4626,22,12,79,13,13747,'12.52'),
 (4627,22,12,79,14,4923,'8.55'),
 (4628,22,12,79,15,8122,'6.84'),
 (4629,22,12,79,16,6551,'6.83'),
 (4630,22,12,79,17,6708,'10.06'),
 (4631,22,12,79,18,5601,'12.07'),
 (4632,22,12,79,19,3688,'10.69'),
 (4633,22,12,79,20,7353,'9.10'),
 (4634,22,12,79,21,1747,'6.94'),
 (4635,25,12,79,1,5623,'7.99'),
 (4636,25,12,79,2,6428,'6.80'),
 (4637,25,12,79,3,3546,'4.49'),
 (4638,25,12,79,4,2953,'3.30'),
 (4639,25,12,79,5,3134,'3.44'),
 (4640,25,12,79,6,4111,'5.06'),
 (4641,25,12,79,7,3855,'4.39'),
 (4642,25,12,79,8,6221,'4.32'),
 (4643,25,12,79,9,3180,'4.44'),
 (4644,25,12,79,10,7518,'5.63'),
 (4645,25,12,79,11,7219,'5.87'),
 (4646,25,12,79,12,3773,'6.03'),
 (4647,25,12,79,13,7814,'6.73'),
 (4648,25,12,79,14,3467,'5.85'),
 (4649,25,12,79,15,6199,'5.06'),
 (4650,25,12,79,16,4787,'4.53'),
 (4651,25,12,79,17,4400,'6.29'),
 (4652,25,12,79,18,3534,'6.41'),
 (4653,25,12,79,19,2488,'6.62'),
 (4654,25,12,79,20,4894,'5.68'),
 (4655,25,12,79,21,1222,'4.42'),
 (4677,14,12,79,1,5610,'9.48'),
 (4678,14,12,79,2,5279,'8.36'),
 (4679,14,12,79,3,4281,'6.16'),
 (4680,14,12,79,4,3813,'4.78'),
 (4681,14,12,79,5,3805,'5.20'),
 (4682,14,12,79,6,5048,'7.30'),
 (4683,14,12,79,7,4395,'5.41'),
 (4684,14,12,79,8,7870,'7.53'),
 (4685,14,12,79,9,3948,'6.91'),
 (4686,14,12,79,10,13113,'9.76'),
 (4687,14,12,79,11,10671,'9.84'),
 (4688,14,12,79,12,5940,'10.94'),
 (4689,14,12,79,13,12954,'12.29'),
 (4690,14,12,79,14,5059,'9.46'),
 (4691,14,12,79,15,8859,'7.95'),
 (4692,14,12,79,16,6025,'8.52'),
 (4693,14,12,79,17,7679,'12.49'),
 (4694,14,12,79,18,2987,'10.96'),
 (4695,14,12,79,19,3024,'13.59'),
 (4696,14,12,79,20,6668,'10.72'),
 (4697,14,12,79,21,1703,'9.78'),
 (4698,16,12,79,1,7735,'11.51'),
 (4699,16,12,79,2,6053,'7.75'),
 (4700,16,12,79,3,4754,'5.92'),
 (4701,16,12,79,4,3928,'4.49'),
 (4702,16,12,79,5,3837,'4.62'),
 (4703,16,12,79,6,4522,'5.91'),
 (4704,16,12,79,7,4729,'5.41'),
 (4705,16,12,79,8,6969,'5.73'),
 (4706,16,12,79,9,4146,'6.16'),
 (4707,16,12,79,10,10800,'7.42'),
 (4708,16,12,79,11,9167,'7.62'),
 (4709,16,12,79,12,5289,'8.52'),
 (4710,16,12,79,13,12752,'10.63'),
 (4711,16,12,79,14,4708,'7.52'),
 (4712,16,12,79,15,7784,'6.19'),
 (4713,16,12,79,16,5599,'6.63'),
 (4714,16,12,79,17,6206,'8.91'),
 (4715,16,12,79,18,2965,'8.84'),
 (4716,16,12,79,19,3015,'10.28'),
 (4717,16,12,79,20,6503,'8.26'),
 (4718,16,12,79,21,1554,'6.83'),
 (4719,18,12,79,1,8145,'13.65'),
 (4720,18,12,79,2,7768,'10.05'),
 (4721,18,12,79,3,5744,'7.45'),
 (4722,18,12,79,4,4093,'5.00'),
 (4723,18,12,79,5,3942,'4.91'),
 (4724,18,12,79,6,5463,'7.73'),
 (4725,18,12,79,7,4940,'6.15'),
 (4726,18,12,79,8,8428,'7.20'),
 (4727,18,12,79,9,4565,'7.20'),
 (4728,18,12,79,10,11531,'8.97'),
 (4729,18,12,79,11,10282,'9.34'),
 (4730,18,12,79,12,5541,'9.87'),
 (4731,18,12,79,13,13258,'12.77'),
 (4732,18,12,79,14,5239,'9.40'),
 (4733,18,12,79,15,8690,'7.69'),
 (4734,18,12,79,16,6804,'8.08'),
 (4735,18,12,79,17,6408,'10.33'),
 (4736,18,12,79,18,3504,'11.32'),
 (4737,18,12,79,19,3506,'11.60'),
 (4738,18,12,79,20,7238,'9.98'),
 (4739,18,12,79,21,1792,'8.08'),
 (4782,11,95,79,1,3215,'4.84'),
 (4783,11,95,79,2,2803,'4.60'),
 (4784,11,95,79,3,3467,'4.83'),
 (4785,11,95,79,4,4046,'4.41'),
 (4786,11,95,79,5,3787,'4.62'),
 (4787,11,95,79,6,3376,'4.42'),
 (4788,11,95,79,7,4596,'4.88'),
 (4789,11,95,79,8,5440,'5.31'),
 (4790,11,95,79,9,3013,'5.07'),
 (4791,11,95,79,10,7159,'5.23'),
 (4792,11,95,79,11,5327,'4.74'),
 (4793,11,95,79,12,2175,'3.99'),
 (4794,11,95,79,13,4628,'4.65'),
 (4795,11,95,79,14,2806,'5.19'),
 (4796,11,95,79,15,5460,'4.70'),
 (4797,11,95,79,16,3514,'5.29'),
 (4798,11,95,79,17,2531,'4.38'),
 (4799,11,95,79,18,1118,'4.45'),
 (4800,11,95,79,19,849,'4.95'),
 (4801,11,95,79,20,2561,'4.33'),
 (4802,11,95,79,21,977,'5.73'),
 (4803,13,95,79,1,3176,'5.39'),
 (4804,13,95,79,2,2087,'3.30'),
 (4805,13,95,79,3,1984,'2.99'),
 (4806,13,95,79,4,2223,'2.78'),
 (4807,13,95,79,5,2140,'2.92'),
 (4808,13,95,79,6,2379,'3.45'),
 (4809,13,95,79,7,2500,'3.08'),
 (4810,13,95,79,8,3670,'3.52'),
 (4811,13,95,79,9,1933,'3.39'),
 (4812,13,95,79,10,4968,'3.70'),
 (4813,13,95,79,11,3831,'3.54'),
 (4814,13,95,79,12,1797,'3.32'),
 (4815,13,95,79,13,3430,'3.26'),
 (4816,13,95,79,14,1694,'3.18'),
 (4817,13,95,79,15,3613,'3.25'),
 (4818,13,95,79,16,2441,'3.46'),
 (4819,13,95,79,17,1919,'3.13'),
 (4820,13,95,79,18,852,'3.14'),
 (4821,13,95,79,19,858,'3.89'),
 (4822,13,95,79,20,2205,'3.55'),
 (4823,13,95,79,21,635,'3.64'),
 (4824,27,95,79,1,1194,'2.38'),
 (4825,27,95,79,2,1043,'1.76'),
 (4826,27,95,79,3,981,'1.62'),
 (4827,27,95,79,4,1093,'1.55'),
 (4828,27,95,79,5,1009,'1.51'),
 (4829,27,95,79,6,1003,'1.76'),
 (4830,27,95,79,7,1104,'1.56'),
 (4831,27,95,79,8,1528,'1.70'),
 (4832,27,95,79,9,876,'1.63'),
 (4833,27,95,79,10,1747,'1.68'),
 (4834,27,95,79,11,1251,'1.50'),
 (4835,27,95,79,12,617,'1.47'),
 (4836,27,95,79,13,1162,'1.43'),
 (4837,27,95,79,14,705,'1.56'),
 (4838,27,95,79,15,1463,'1.56'),
 (4839,27,95,79,16,982,'1.61'),
 (4840,27,95,79,17,662,'1.41'),
 (4841,27,95,79,18,326,'1.45'),
 (4842,27,95,79,19,340,'1.67'),
 (4843,27,95,79,20,897,'1.66'),
 (4844,27,95,79,21,288,'1.75'),
 (4845,20,95,79,1,2213,'4.81'),
 (4846,20,95,79,2,2167,'3.53'),
 (4847,20,95,79,3,2062,'3.59'),
 (4848,20,95,79,4,2251,'3.40'),
 (4849,20,95,79,5,2171,'3.30'),
 (4850,20,95,79,6,2324,'4.20'),
 (4851,20,95,79,7,2272,'3.48'),
 (4852,20,95,79,8,3128,'3.29'),
 (4853,20,95,79,9,1701,'3.35'),
 (4854,20,95,79,10,3117,'3.27'),
 (4855,20,95,79,11,2524,'3.07'),
 (4856,20,95,79,12,1112,'2.74'),
 (4857,20,95,79,13,2323,'3.08'),
 (4858,20,95,79,14,1193,'2.81'),
 (4859,20,95,79,15,2526,'2.88'),
 (4860,20,95,79,16,2126,'3.19'),
 (4861,20,95,79,17,1267,'2.77'),
 (4862,20,95,79,18,806,'3.04'),
 (4863,20,95,79,19,592,'2.58'),
 (4864,20,95,79,20,1603,'2.92'),
 (4865,20,95,79,21,523,'2.96'),
 (4887,12,95,79,1,1259,'1.48'),
 (4888,12,95,79,2,1071,'1.35'),
 (4889,12,95,79,3,1166,'1.32'),
 (4890,12,95,79,4,1660,'1.53'),
 (4891,12,95,79,5,1101,'1.11'),
 (4892,12,95,79,6,1421,'1.47'),
 (4893,12,95,79,7,1357,'1.23'),
 (4894,12,95,79,8,2183,'1.61'),
 (4895,12,95,79,9,1001,'1.37'),
 (4896,12,95,79,10,3038,'1.67'),
 (4897,12,95,79,11,2276,'1.50'),
 (4898,12,95,79,12,1148,'1.49'),
 (4899,12,95,79,13,2071,'1.42'),
 (4900,12,95,79,14,1172,'1.60'),
 (4901,12,95,79,15,2217,'1.47'),
 (4902,12,95,79,16,1562,'1.69'),
 (4903,12,95,79,17,1361,'1.63'),
 (4904,12,95,79,18,560,'1.52'),
 (4905,12,95,79,19,447,'1.70'),
 (4906,12,95,79,20,1292,'1.58'),
 (4907,12,95,79,21,410,'1.83'),
 (4908,15,95,79,1,2175,'3.15'),
 (4909,15,95,79,2,2328,'3.08'),
 (4910,15,95,79,3,1735,'2.21'),
 (4911,15,95,79,4,1936,'2.09'),
 (4912,15,95,79,5,1670,'1.93'),
 (4913,15,95,79,6,2377,'2.91'),
 (4914,15,95,79,7,2029,'2.17'),
 (4915,15,95,79,8,3687,'2.95'),
 (4916,15,95,79,9,1642,'2.43'),
 (4917,15,95,79,10,5391,'3.45'),
 (4918,15,95,79,11,4581,'3.59'),
 (4919,15,95,79,12,2282,'3.56'),
 (4920,15,95,79,13,4327,'3.45'),
 (4921,15,95,79,14,2031,'3.12'),
 (4922,15,95,79,15,3678,'2.77'),
 (4923,15,95,79,16,2731,'3.18'),
 (4924,15,95,79,17,2549,'3.51'),
 (4925,15,95,79,18,1255,'3.74'),
 (4926,15,95,79,19,1071,'3.88'),
 (4927,15,95,79,20,2739,'3.56'),
 (4928,15,95,79,21,722,'3.41'),
 (4929,17,95,79,1,1816,'2.49'),
 (4930,17,95,79,2,2024,'2.36'),
 (4931,17,95,79,3,1515,'1.82'),
 (4932,17,95,79,4,1684,'1.79'),
 (4933,17,95,79,5,1482,'1.67'),
 (4934,17,95,79,6,2013,'2.41'),
 (4935,17,95,79,7,1645,'1.75'),
 (4936,17,95,79,8,3233,'2.42'),
 (4937,17,95,79,9,1396,'1.91'),
 (4938,17,95,79,10,4260,'2.67'),
 (4939,17,95,79,11,3236,'2.43'),
 (4940,17,95,79,12,1905,'2.69'),
 (4941,17,95,79,13,3091,'2.28'),
 (4942,17,95,79,14,1605,'2.34'),
 (4943,17,95,79,15,3022,'2.19'),
 (4944,17,95,79,16,2343,'2.48'),
 (4945,17,95,79,17,2025,'2.59'),
 (4946,17,95,79,18,891,'2.37'),
 (4947,17,95,79,19,871,'2.52'),
 (4948,17,95,79,20,2168,'2.45'),
 (4949,17,95,79,21,572,'2.26'),
 (4950,19,95,79,1,976,'1.41'),
 (4951,19,95,79,2,1355,'1.52'),
 (4952,19,95,79,3,915,'1.13'),
 (4953,19,95,79,4,1613,'1.78'),
 (4954,19,95,79,5,879,'0.97'),
 (4955,19,95,79,6,1193,'1.45'),
 (4956,19,95,79,7,934,'1.04'),
 (4957,19,95,79,8,1836,'1.35'),
 (4958,19,95,79,9,1025,'1.45'),
 (4959,19,95,79,10,2396,'1.65'),
 (4960,19,95,79,11,2070,'1.60'),
 (4961,19,95,79,12,1067,'1.59'),
 (4962,19,95,79,13,2043,'1.65'),
 (4963,19,95,79,14,893,'1.40'),
 (4964,19,95,79,15,1734,'1.34'),
 (4965,19,95,79,16,1650,'1.66'),
 (4966,19,95,79,17,1429,'1.95'),
 (4967,19,95,79,18,599,'1.56'),
 (4968,19,95,79,19,587,'1.63'),
 (4969,19,95,79,20,1305,'1.52'),
 (4970,19,95,79,21,319,'1.23'),
 (4971,22,95,79,1,5459,'8.53'),
 (4972,22,95,79,2,4477,'5.20'),
 (4973,22,95,79,3,2961,'3.90'),
 (4974,22,95,79,4,2917,'3.38'),
 (4975,22,95,79,5,3073,'3.57'),
 (4976,22,95,79,6,3148,'4.10'),
 (4977,22,95,79,7,3570,'4.25'),
 (4978,22,95,79,8,4671,'3.48'),
 (4979,22,95,79,9,2568,'3.84'),
 (4980,22,95,79,10,5005,'3.81'),
 (4981,22,95,79,11,4197,'3.55'),
 (4982,22,95,79,12,2121,'3.55'),
 (4983,22,95,79,13,4386,'3.99'),
 (4984,22,95,79,14,2142,'3.72'),
 (4985,22,95,79,15,4228,'3.56'),
 (4986,22,95,79,16,3494,'3.64'),
 (4987,22,95,79,17,2055,'3.08'),
 (4988,22,95,79,18,1862,'4.01'),
 (4989,22,95,79,19,1311,'3.80'),
 (4990,22,95,79,20,2760,'3.41'),
 (4991,22,95,79,21,1002,'3.98'),
 (4992,25,95,79,1,1322,'1.88'),
 (4993,25,95,79,2,1642,'1.74'),
 (4994,25,95,79,3,1537,'1.95'),
 (4995,25,95,79,4,1857,'2.07'),
 (4996,25,95,79,5,1738,'1.91'),
 (4997,25,95,79,6,1853,'2.28'),
 (4998,25,95,79,7,1814,'2.07'),
 (4999,25,95,79,8,2731,'1.90'),
 (5000,25,95,79,9,1276,'1.78'),
 (5001,25,95,79,10,2810,'2.11'),
 (5002,25,95,79,11,2564,'2.08'),
 (5003,25,95,79,12,1282,'2.05'),
 (5004,25,95,79,13,2252,'1.94'),
 (5005,25,95,79,14,1099,'1.85'),
 (5006,25,95,79,15,2392,'1.95'),
 (5007,25,95,79,16,1986,'1.88'),
 (5008,25,95,79,17,1396,'2.00'),
 (5009,25,95,79,18,1126,'2.04'),
 (5010,25,95,79,19,629,'1.67'),
 (5011,25,95,79,20,1713,'1.99'),
 (5012,25,95,79,21,553,'2.00'),
 (5013,26,95,79,1,1521,'2.23'),
 (5014,26,95,79,2,1737,'1.91'),
 (5015,26,95,79,3,1388,'1.82'),
 (5016,26,95,79,4,1581,'1.80'),
 (5017,26,95,79,5,1501,'1.68'),
 (5018,26,95,79,6,1749,'2.22'),
 (5019,26,95,79,7,1577,'1.84'),
 (5020,26,95,79,8,2409,'1.74'),
 (5021,26,95,79,9,1188,'1.70'),
 (5022,26,95,79,10,2882,'2.27'),
 (5023,26,95,79,11,2522,'2.17'),
 (5024,26,95,79,12,1341,'2.28'),
 (5025,26,95,79,13,2579,'2.36'),
 (5026,26,95,79,14,1123,'2.00'),
 (5027,26,95,79,15,2358,'2.01'),
 (5028,26,95,79,16,1833,'1.80'),
 (5029,26,95,79,17,1477,'2.25'),
 (5030,26,95,79,18,1237,'2.36'),
 (5031,26,95,79,19,804,'2.25'),
 (5032,26,95,79,20,1868,'2.28'),
 (5033,26,95,79,21,496,'1.87'),
 (5034,14,95,79,1,1824,'3.08'),
 (5035,14,95,79,2,1810,'2.87'),
 (5036,14,95,79,3,1988,'2.86'),
 (5037,14,95,79,4,2086,'2.61'),
 (5038,14,95,79,5,1735,'2.37'),
 (5039,14,95,79,6,2017,'2.92'),
 (5040,14,95,79,7,2121,'2.61'),
 (5041,14,95,79,8,3334,'3.19'),
 (5042,14,95,79,9,1645,'2.88'),
 (5043,14,95,79,10,4350,'3.24'),
 (5044,14,95,79,11,4244,'3.91'),
 (5045,14,95,79,12,1498,'2.76'),
 (5046,14,95,79,13,2805,'2.66'),
 (5047,14,95,79,14,1604,'3.00'),
 (5048,14,95,79,15,3176,'2.85'),
 (5049,14,95,79,16,2320,'3.28'),
 (5050,14,95,79,17,1635,'2.66'),
 (5051,14,95,79,18,691,'2.53'),
 (5052,14,95,79,19,711,'3.19'),
 (5053,14,95,79,20,1885,'3.03'),
 (5054,14,95,79,21,582,'3.34'),
 (5055,16,95,79,1,2946,'4.38'),
 (5056,16,95,79,2,2500,'3.20'),
 (5057,16,95,79,3,2485,'3.09'),
 (5058,16,95,79,4,2583,'2.95'),
 (5059,16,95,79,5,2271,'2.73'),
 (5060,16,95,79,6,3255,'4.25'),
 (5061,16,95,79,7,2550,'2.91'),
 (5062,16,95,79,8,4026,'3.31'),
 (5063,16,95,79,9,2630,'3.90'),
 (5064,16,95,79,10,4521,'3.10'),
 (5065,16,95,79,11,3911,'3.25'),
 (5066,16,95,79,12,1751,'2.82'),
 (5067,16,95,79,13,3494,'2.91'),
 (5068,16,95,79,14,1871,'2.99'),
 (5069,16,95,79,15,3749,'2.98'),
 (5070,16,95,79,16,2635,'3.12'),
 (5071,16,95,79,17,2210,'3.17'),
 (5072,16,95,79,18,865,'2.58'),
 (5073,16,95,79,19,895,'3.05'),
 (5074,16,95,79,20,2324,'2.95'),
 (5075,16,95,79,21,938,'4.13'),
 (5076,18,95,79,1,1805,'3.03'),
 (5077,18,95,79,2,2142,'2.77'),
 (5078,18,95,79,3,2071,'2.69'),
 (5079,18,95,79,4,2158,'2.64'),
 (5080,18,95,79,5,2055,'2.56'),
 (5081,18,95,79,6,2160,'3.06'),
 (5082,18,95,79,7,2047,'2.55'),
 (5083,18,95,79,8,3721,'3.18'),
 (5084,18,95,79,9,1751,'2.76'),
 (5085,18,95,79,10,3452,'2.69'),
 (5086,18,95,79,11,2878,'2.61'),
 (5087,18,95,79,12,1360,'2.42'),
 (5088,18,95,79,13,2553,'2.46'),
 (5089,18,95,79,14,1509,'2.71'),
 (5090,18,95,79,15,3270,'2.89'),
 (5091,18,95,79,16,2114,'2.51'),
 (5092,18,95,79,17,1567,'2.53'),
 (5093,18,95,79,18,717,'2.32'),
 (5094,18,95,79,19,823,'2.72'),
 (5095,18,95,79,20,1953,'2.69'),
 (5096,18,95,79,21,541,'2.44'),
 (6735,7,1,79,21,11021,'56.30'),
 (6736,7,1,79,1,42702,'56.52'),
 (6737,7,1,79,2,41486,'58.50'),
 (6738,7,1,79,3,57482,'71.12'),
 (6739,7,1,79,4,74821,'74.61'),
 (6740,7,1,79,5,67592,'74.49'),
 (6741,7,1,79,6,51955,'59.33'),
 (6742,7,1,79,7,74753,'72.68'),
 (6743,7,1,79,8,70416,'58.49'),
 (6744,7,1,79,9,44309,'66.47'),
 (6745,7,1,79,10,84846,'52.49'),
 (6746,7,1,79,11,65529,'48.57'),
 (6747,7,1,79,12,24610,'36.86'),
 (6748,7,1,79,13,36487,'28.99'),
 (6749,7,1,79,14,33436,'51.60'),
 (6750,7,1,79,15,77720,'57.44'),
 (6751,7,1,79,16,41749,'51.38'),
 (6752,7,1,79,17,24981,'34.37'),
 (6753,7,1,79,18,11813,'36.64'),
 (6754,7,1,79,19,7372,'33.67'),
 (6755,7,1,79,20,28348,'39.19'),
 (6756,8,1,79,1,36306,'52.58'),
 (6757,8,1,79,2,30683,'52.82'),
 (6758,8,1,79,3,44337,'66.07'),
 (6759,8,1,79,4,63481,'70.76'),
 (6760,8,1,79,5,54164,'70.33'),
 (6761,8,1,79,6,39596,'52.06'),
 (6762,8,1,79,7,64363,'69.05'),
 (6763,8,1,79,8,46568,'50.25'),
 (6764,8,1,79,9,34548,'61.80'),
 (6765,8,1,79,10,60692,'45.19'),
 (6766,8,1,79,11,45369,'40.77'),
 (6767,8,1,79,12,15985,'28.58'),
 (6768,8,1,79,13,21051,'20.24'),
 (6769,8,1,79,14,22943,'45.14'),
 (6770,8,1,79,15,54497,'49.57'),
 (6771,8,1,79,16,26340,'42.78'),
 (6772,8,1,79,17,14893,'25.25'),
 (6773,8,1,79,18,6094,'25.74'),
 (6774,8,1,79,19,4310,'24.77'),
 (6775,8,1,79,20,17938,'29.68'),
 (6776,8,1,79,21,6965,'47.11'),
 (6777,7,2,79,21,4693,'23.98'),
 (6778,7,2,79,1,19831,'26.25'),
 (6779,7,2,79,2,17336,'24.45'),
 (6780,7,2,79,3,13627,'16.86'),
 (6781,7,2,79,4,15047,'15.00'),
 (6782,7,2,79,5,13348,'14.71'),
 (6783,7,2,79,6,22362,'25.54'),
 (6784,7,2,79,7,16548,'16.09'),
 (6785,7,2,79,8,29646,'24.63'),
 (6786,7,2,79,9,12998,'19.50'),
 (6787,7,2,79,10,45178,'27.95'),
 (6788,7,2,79,11,42580,'31.56'),
 (6789,7,2,79,12,27464,'41.14'),
 (6790,7,2,79,13,60587,'48.13'),
 (6791,7,2,79,14,18518,'28.58'),
 (6792,7,2,79,15,34498,'25.49'),
 (6793,7,2,79,16,23802,'29.29'),
 (6794,7,2,79,17,29717,'40.88'),
 (6795,7,2,79,18,13320,'41.32'),
 (6796,7,2,79,19,9363,'42.76'),
 (6797,7,2,79,20,28207,'38.99'),
 (6798,8,2,79,1,20470,'29.65'),
 (6799,8,2,79,2,16964,'29.20'),
 (6800,8,2,79,3,12394,'18.47'),
 (6801,8,2,79,4,14889,'16.60'),
 (6802,8,2,79,5,12399,'16.10'),
 (6803,8,2,79,6,23980,'31.53'),
 (6804,8,2,79,7,16189,'17.37'),
 (6805,8,2,79,8,28233,'30.47'),
 (6806,8,2,79,9,12274,'21.96'),
 (6807,8,2,79,10,44528,'33.16'),
 (6808,8,2,79,11,43042,'38.67'),
 (6809,8,2,79,12,27865,'49.82'),
 (6810,8,2,79,13,61849,'59.47'),
 (6811,8,2,79,14,17287,'34.01'),
 (6812,8,2,79,15,34546,'31.42'),
 (6813,8,2,79,16,22176,'36.01'),
 (6814,8,2,79,17,29759,'50.45'),
 (6815,8,2,79,18,12477,'52.70'),
 (6816,8,2,79,19,9382,'53.93'),
 (6817,8,2,79,20,29316,'48.51'),
 (6818,8,2,79,21,4637,'31.36'),
 (6945,7,12,79,21,3146,'16.07'),
 (6946,7,12,79,1,10899,'14.43'),
 (6947,7,12,79,2,9984,'14.08'),
 (6948,7,12,79,3,7392,'9.15'),
 (6949,7,12,79,4,7820,'7.80'),
 (6950,7,12,79,5,7395,'8.15'),
 (6951,7,12,79,6,10817,'12.35'),
 (6952,7,12,79,7,8870,'8.62'),
 (6953,7,12,79,8,16344,'13.58'),
 (6954,7,12,79,9,7283,'10.93'),
 (6955,7,12,79,10,26656,'16.49'),
 (6956,7,12,79,11,22808,'16.91'),
 (6957,7,12,79,12,12901,'19.32'),
 (6958,7,12,79,13,25323,'20.12'),
 (6959,7,12,79,14,10727,'16.55'),
 (6960,7,12,79,15,18924,'13.99'),
 (6961,7,12,79,16,12866,'15.83'),
 (6962,7,12,79,17,15819,'21.76'),
 (6963,7,12,79,18,6239,'19.35'),
 (6964,7,12,79,19,4501,'20.55'),
 (6965,7,12,79,20,13685,'18.92'),
 (6966,8,12,79,1,7354,'10.65'),
 (6967,8,12,79,2,5936,'10.22'),
 (6968,8,12,79,3,5170,'7.70'),
 (6969,8,12,79,4,5469,'6.10'),
 (6970,8,12,79,5,5140,'6.67'),
 (6971,8,12,79,6,6760,'8.89'),
 (6972,8,12,79,7,6498,'6.97'),
 (6973,8,12,79,8,9255,'9.99'),
 (6974,8,12,79,9,4786,'8.56'),
 (6975,8,12,79,10,16404,'12.21'),
 (6976,8,12,79,11,13567,'12.19'),
 (6977,8,12,79,12,8084,'14.45'),
 (6978,8,12,79,13,14295,'13.74'),
 (6979,8,12,79,14,6127,'12.05'),
 (6980,8,12,79,15,11763,'10.70'),
 (6981,8,12,79,16,7211,'11.71'),
 (6982,8,12,79,17,9428,'15.98'),
 (6983,8,12,79,18,3326,'14.05'),
 (6984,8,12,79,19,2152,'12.37'),
 (6985,8,12,79,20,8479,'14.03'),
 (6986,8,12,79,21,1822,'12.32'),
 (6987,7,95,79,21,379,'1.94'),
 (6988,7,95,79,1,1218,'1.61'),
 (6989,7,95,79,2,1141,'1.61'),
 (6990,7,95,79,3,1018,'1.26'),
 (6991,7,95,79,4,1103,'1.10'),
 (6992,7,95,79,5,1003,'1.11'),
 (6993,7,95,79,6,1336,'1.53'),
 (6994,7,95,79,7,1243,'1.21'),
 (6995,7,95,79,8,2019,'1.68'),
 (6996,7,95,79,9,1049,'1.57'),
 (6997,7,95,79,10,2810,'1.74'),
 (6998,7,95,79,11,2228,'1.65'),
 (6999,7,95,79,12,1117,'1.67'),
 (7000,7,95,79,13,2303,'1.83'),
 (7001,7,95,79,14,1122,'1.73'),
 (7002,7,95,79,15,2255,'1.67'),
 (7003,7,95,79,16,1474,'1.81'),
 (7004,7,95,79,17,1327,'1.83'),
 (7005,7,95,79,18,492,'1.53'),
 (7006,7,95,79,19,405,'1.85'),
 (7007,7,95,79,20,1234,'1.71'),
 (7008,8,95,79,1,4139,'5.99'),
 (7009,8,95,79,2,3762,'6.48'),
 (7010,8,95,79,3,4137,'6.16'),
 (7011,8,95,79,4,4611,'5.14'),
 (7012,8,95,79,5,4050,'5.26'),
 (7013,8,95,79,6,4676,'6.15'),
 (7014,8,95,79,7,4781,'5.13'),
 (7015,8,95,79,8,7049,'7.61'),
 (7016,8,95,79,9,3398,'6.08'),
 (7017,8,95,79,10,10713,'7.98'),
 (7018,8,95,79,11,8008,'7.20'),
 (7019,8,95,79,12,3441,'6.15'),
 (7020,8,95,79,13,5817,'5.59'),
 (7021,8,95,79,14,3695,'7.27'),
 (7022,8,95,79,15,7540,'6.86'),
 (7023,8,95,79,16,4916,'7.98'),
 (7024,8,95,79,17,4339,'7.36'),
 (7025,8,95,79,18,1478,'6.24'),
 (7026,8,95,79,19,1392,'8.00'),
 (7027,8,95,79,20,4028,'6.66'),
 (7028,8,95,79,21,1112,'7.52'),
 (7431,24,1,79,1,17208,'26.51'),
 (7432,24,2,79,1,6906,'10.64'),
 (7433,24,5,79,1,31900,'49.14'),
 (7434,24,8,79,1,5275,'8.13'),
 (7435,24,19,79,1,289,'0.45'),
 (7436,24,63,79,1,936,'1.44'),
 (7437,24,95,79,1,1968,'3.03'),
 (7438,24,1,79,2,27092,'31.36'),
 (7439,24,2,79,2,10343,'11.97'),
 (7440,24,5,79,2,33464,'38.73'),
 (7441,24,8,79,2,10142,'11.74'),
 (7442,24,19,79,2,470,'0.54'),
 (7443,24,63,79,2,1087,'1.26'),
 (7444,24,95,79,2,3036,'3.51'),
 (7445,24,1,79,3,31433,'43.52'),
 (7446,24,2,79,3,6659,'9.22'),
 (7447,24,5,79,3,20456,'28.32'),
 (7448,24,8,79,3,9105,'12.60'),
 (7449,24,19,79,3,607,'0.84'),
 (7450,24,63,79,3,733,'1.01'),
 (7451,24,95,79,3,2488,'3.44'),
 (7452,24,1,79,4,42482,'52.29'),
 (7453,24,2,79,4,6812,'8.38'),
 (7454,24,5,79,4,16893,'20.79'),
 (7455,24,8,79,4,10471,'12.89'),
 (7456,24,19,79,4,862,'1.06'),
 (7457,24,63,79,4,595,'0.73'),
 (7458,24,95,79,4,2244,'2.76'),
 (7459,24,1,79,5,42650,'51.61'),
 (7460,24,2,79,5,6667,'8.07'),
 (7461,24,5,79,5,16975,'20.54'),
 (7462,24,8,79,5,11660,'14.11'),
 (7463,24,19,79,5,832,'1.01'),
 (7464,24,63,79,5,590,'0.71'),
 (7465,24,95,79,5,2415,'2.92'),
 (7466,24,1,79,6,27458,'37.72'),
 (7467,24,2,79,6,10755,'14.78'),
 (7468,24,5,79,6,21114,'29.01'),
 (7469,24,8,79,6,8389,'11.53'),
 (7470,24,19,79,6,444,'0.61'),
 (7471,24,63,79,6,988,'1.36'),
 (7472,24,95,79,6,2859,'3.93'),
 (7473,24,1,79,7,37809,'47.19'),
 (7474,24,2,79,7,7018,'8.76'),
 (7475,24,5,79,7,20691,'25.83'),
 (7476,24,8,79,7,9960,'12.43'),
 (7477,24,19,79,7,780,'0.97'),
 (7478,24,63,79,7,734,'0.92'),
 (7479,24,95,79,7,2257,'2.82'),
 (7480,24,1,79,8,50662,'39.26'),
 (7481,24,2,79,8,17338,'13.44'),
 (7482,24,5,79,8,33837,'26.22'),
 (7483,24,8,79,8,18559,'14.38'),
 (7484,24,19,79,8,960,'0.74'),
 (7485,24,63,79,8,1567,'1.21'),
 (7486,24,95,79,8,4626,'3.59'),
 (7487,24,1,79,9,28976,'44.47'),
 (7488,24,2,79,9,6597,'10.12'),
 (7489,24,5,79,9,17503,'26.86'),
 (7490,24,8,79,9,8146,'12.50'),
 (7491,24,19,79,9,587,'0.90'),
 (7492,24,63,79,9,675,'1.04'),
 (7493,24,95,79,9,1954,'3.00'),
 (7494,24,1,79,10,40054,'32.96'),
 (7495,24,2,79,10,21300,'17.53'),
 (7496,24,5,79,10,40303,'33.16'),
 (7497,24,8,79,10,11189,'9.21'),
 (7498,24,19,79,10,650,'0.53'),
 (7499,24,63,79,10,2186,'1.80'),
 (7500,24,95,79,10,4679,'3.85'),
 (7501,24,1,79,11,32494,'29.52'),
 (7502,24,2,79,11,21042,'19.12'),
 (7503,24,5,79,11,37321,'33.90'),
 (7504,24,8,79,11,10914,'9.91'),
 (7505,24,19,79,11,514,'0.47'),
 (7506,24,63,79,11,2344,'2.13'),
 (7507,24,95,79,11,4373,'3.97'),
 (7508,24,1,79,12,13405,'23.93'),
 (7509,24,2,79,12,13068,'23.33'),
 (7510,24,5,79,12,20391,'36.41'),
 (7511,24,8,79,12,4829,'8.62'),
 (7512,24,19,79,12,177,'0.32'),
 (7513,24,63,79,12,1465,'2.62'),
 (7514,24,95,79,12,2207,'3.94'),
 (7515,24,1,79,13,19047,'18.12'),
 (7516,24,2,79,13,26228,'24.96'),
 (7517,24,5,79,13,44279,'42.13'),
 (7518,24,8,79,13,7110,'6.77'),
 (7519,24,19,79,13,275,'0.26'),
 (7520,24,63,79,13,3210,'3.05'),
 (7521,24,95,79,13,4052,'3.86'),
 (7522,24,1,79,14,17180,'31.71'),
 (7523,24,2,79,14,9227,'17.03'),
 (7524,24,5,79,14,18593,'34.31'),
 (7525,24,8,79,14,5510,'10.17'),
 (7526,24,19,79,14,269,'0.50'),
 (7527,24,63,79,14,1023,'1.89');
INSERT INTO `elecdistricandi` (`idElecDistriCandi`,`Convocatoria_idConvocatoria`,`Candidatura_idCandidatura`,`Municipio`,`Distrito`,`Votos`,`PorcVotos`) VALUES 
 (7528,24,95,79,14,1859,'3.43'),
 (7529,24,1,79,15,41600,'37.62'),
 (7530,24,2,79,15,16800,'15.19'),
 (7531,24,5,79,15,31810,'28.77'),
 (7532,24,8,79,15,12789,'11.57'),
 (7533,24,19,79,15,675,'0.61'),
 (7534,24,63,79,15,1886,'1.71'),
 (7535,24,95,79,15,3910,'3.54'),
 (7536,24,1,79,16,33606,'35.90'),
 (7537,24,2,79,16,13643,'14.57'),
 (7538,24,5,79,16,26592,'28.40'),
 (7539,24,8,79,16,13521,'14.44'),
 (7540,24,19,79,16,554,'0.59'),
 (7541,24,63,79,16,1307,'1.40'),
 (7542,24,95,79,16,3383,'3.61'),
 (7543,24,1,79,17,14432,'23.08'),
 (7544,24,2,79,17,15288,'24.45'),
 (7545,24,5,79,17,21820,'34.89'),
 (7546,24,8,79,17,5578,'8.92'),
 (7547,24,19,79,17,213,'0.34'),
 (7548,24,63,79,17,1976,'3.16'),
 (7549,24,95,79,17,2577,'4.12'),
 (7550,24,1,79,18,9852,'20.16'),
 (7551,24,2,79,18,9248,'18.93'),
 (7552,24,5,79,18,19933,'40.80'),
 (7553,24,8,79,18,6008,'12.30'),
 (7554,24,19,79,18,128,'0.26'),
 (7555,24,63,79,18,1250,'2.56'),
 (7556,24,95,79,18,1979,'4.05'),
 (7557,24,1,79,19,7258,'21.55'),
 (7558,24,2,79,19,6909,'20.51'),
 (7559,24,5,79,19,12641,'37.52'),
 (7560,24,8,79,19,4122,'12.24'),
 (7561,24,19,79,19,91,'0.27'),
 (7562,24,63,79,19,760,'2.26'),
 (7563,24,95,79,19,1516,'4.50'),
 (7564,24,1,79,20,20809,'27.16'),
 (7565,24,2,79,20,14269,'18.62'),
 (7566,24,5,79,20,26067,'34.02'),
 (7567,24,8,79,20,9291,'12.13'),
 (7568,24,19,79,20,335,'0.44'),
 (7569,24,63,79,20,1918,'2.50'),
 (7570,24,95,79,20,3118,'4.07'),
 (7571,24,1,79,21,8647,'34.97'),
 (7572,24,2,79,21,3169,'12.81'),
 (7573,24,5,79,21,7138,'28.86'),
 (7574,24,8,79,21,3919,'15.85'),
 (7575,24,19,79,21,155,'0.63'),
 (7576,24,63,79,21,421,'1.70'),
 (7577,24,95,79,21,1023,'4.14'),
 (7686,21,1,79,1,23215,'40.08'),
 (7687,21,2,79,1,13635,'23.54'),
 (7688,21,5,79,1,0,'0.00'),
 (7689,21,8,79,1,0,'0.00'),
 (7690,21,19,79,1,0,'0.00'),
 (7691,21,63,79,1,10483,'18.10'),
 (7692,21,95,79,1,8989,'15.52'),
 (7693,21,1,79,2,37962,'48.65'),
 (7694,21,2,79,2,17513,'22.44'),
 (7695,21,5,79,2,0,'0.00'),
 (7696,21,8,79,2,0,'0.00'),
 (7697,21,19,79,2,0,'0.00'),
 (7698,21,63,79,2,9881,'12.66'),
 (7699,21,95,79,2,10355,'13.27'),
 (7700,21,1,79,3,39543,'57.09'),
 (7701,21,2,79,3,11938,'17.24'),
 (7702,21,5,79,3,0,'0.00'),
 (7703,21,8,79,3,0,'0.00'),
 (7704,21,19,79,3,0,'0.00'),
 (7705,21,63,79,3,5951,'8.59'),
 (7706,21,95,79,3,9742,'14.07'),
 (7707,21,1,79,4,50200,'64.17'),
 (7708,21,2,79,4,10951,'14.00'),
 (7709,21,5,79,4,0,'0.00'),
 (7710,21,8,79,4,0,'0.00'),
 (7711,21,19,79,4,0,'0.00'),
 (7712,21,63,79,4,4585,'5.86'),
 (7713,21,95,79,4,10103,'12.91'),
 (7714,21,1,79,5,49510,'63.25'),
 (7715,21,2,79,5,10841,'13.85'),
 (7716,21,5,79,5,0,'0.00'),
 (7717,21,8,79,5,0,'0.00'),
 (7718,21,19,79,5,0,'0.00'),
 (7719,21,63,79,5,4503,'5.75'),
 (7720,21,95,79,5,10713,'13.69'),
 (7721,21,1,79,6,35781,'52.55'),
 (7722,21,2,79,6,14647,'21.51'),
 (7723,21,5,79,6,0,'0.00'),
 (7724,21,8,79,6,0,'0.00'),
 (7725,21,19,79,6,0,'0.00'),
 (7726,21,63,79,6,6378,'9.37'),
 (7727,21,95,79,6,9168,'13.46'),
 (7728,21,1,79,7,45390,'59.39'),
 (7729,21,2,79,7,12462,'16.31'),
 (7730,21,5,79,7,0,'0.00'),
 (7731,21,8,79,7,0,'0.00'),
 (7732,21,19,79,7,0,'0.00'),
 (7733,21,63,79,7,5830,'7.63'),
 (7734,21,95,79,7,10251,'13.41'),
 (7735,21,1,79,8,63624,'53.24'),
 (7736,21,2,79,8,25297,'21.17'),
 (7737,21,5,79,8,0,'0.00'),
 (7738,21,8,79,8,0,'0.00'),
 (7739,21,19,79,8,0,'0.00'),
 (7740,21,63,79,8,9530,'7.97'),
 (7741,21,95,79,8,17317,'14.49'),
 (7742,21,1,79,9,34668,'56.95'),
 (7743,21,2,79,9,11049,'18.15'),
 (7744,21,5,79,9,0,'0.00'),
 (7745,21,8,79,9,0,'0.00'),
 (7746,21,19,79,9,0,'0.00'),
 (7747,21,63,79,9,5303,'8.71'),
 (7748,21,95,79,9,7977,'13.10'),
 (7749,21,1,79,10,58714,'49.66'),
 (7750,21,2,79,10,30316,'25.64'),
 (7751,21,5,79,10,0,'0.00'),
 (7752,21,8,79,10,0,'0.00'),
 (7753,21,19,79,10,0,'0.00'),
 (7754,21,63,79,10,13073,'11.06'),
 (7755,21,95,79,10,13165,'11.14'),
 (7756,21,1,79,11,49565,'46.95'),
 (7757,21,2,79,11,29221,'27.68'),
 (7758,21,5,79,11,0,'0.00'),
 (7759,21,8,79,11,0,'0.00'),
 (7760,21,19,79,11,0,'0.00'),
 (7761,21,63,79,11,11853,'11.23'),
 (7762,21,95,79,11,12245,'11.60'),
 (7763,21,1,79,12,21651,'41.45'),
 (7764,21,2,79,12,17315,'33.15'),
 (7765,21,5,79,12,0,'0.00'),
 (7766,21,8,79,12,0,'0.00'),
 (7767,21,19,79,12,0,'0.00'),
 (7768,21,63,79,12,6557,'12.55'),
 (7769,21,95,79,12,5394,'10.33'),
 (7770,21,1,79,13,31161,'32.51'),
 (7771,21,2,79,13,35830,'37.38'),
 (7772,21,5,79,13,0,'0.00'),
 (7773,21,8,79,13,0,'0.00'),
 (7774,21,19,79,13,0,'0.00'),
 (7775,21,63,79,13,16293,'17.00'),
 (7776,21,95,79,13,10288,'10.73'),
 (7777,21,1,79,14,24458,'47.16'),
 (7778,21,2,79,14,13894,'26.79'),
 (7779,21,5,79,14,0,'0.00'),
 (7780,21,8,79,14,0,'0.00'),
 (7781,21,19,79,14,0,'0.00'),
 (7782,21,63,79,14,6014,'11.60'),
 (7783,21,95,79,14,6091,'11.74'),
 (7784,21,1,79,15,56492,'53.06'),
 (7785,21,2,79,15,24278,'22.80'),
 (7786,21,5,79,15,0,'0.00'),
 (7787,21,8,79,15,0,'0.00'),
 (7788,21,19,79,15,0,'0.00'),
 (7789,21,63,79,15,9733,'9.14'),
 (7790,21,95,79,15,12951,'12.16'),
 (7791,21,1,79,16,43000,'50.51'),
 (7792,21,2,79,16,19669,'23.11'),
 (7793,21,5,79,16,0,'0.00'),
 (7794,21,8,79,16,0,'0.00'),
 (7795,21,19,79,16,0,'0.00'),
 (7796,21,63,79,16,8007,'9.41'),
 (7797,21,95,79,16,11794,'13.85'),
 (7798,21,1,79,17,23727,'40.44'),
 (7799,21,2,79,17,19694,'33.57'),
 (7800,21,5,79,17,0,'0.00'),
 (7801,21,8,79,17,0,'0.00'),
 (7802,21,19,79,17,0,'0.00'),
 (7803,21,63,79,17,7779,'13.26'),
 (7804,21,95,79,17,5974,'10.18'),
 (7805,21,1,79,18,14461,'36.43'),
 (7806,21,2,79,18,12111,'30.51'),
 (7807,21,5,79,18,0,'0.00'),
 (7808,21,8,79,18,0,'0.00'),
 (7809,21,19,79,18,0,'0.00'),
 (7810,21,63,79,18,6710,'16.90'),
 (7811,21,95,79,18,4996,'12.59'),
 (7812,21,1,79,19,11347,'37.67'),
 (7813,21,2,79,19,9414,'31.26'),
 (7814,21,5,79,19,0,'0.00'),
 (7815,21,8,79,19,0,'0.00'),
 (7816,21,19,79,19,0,'0.00'),
 (7817,21,63,79,19,4382,'14.55'),
 (7818,21,95,79,19,3955,'13.13'),
 (7819,21,1,79,20,30865,'43.68'),
 (7820,21,2,79,20,19936,'28.22'),
 (7821,21,5,79,20,0,'0.00'),
 (7822,21,8,79,20,0,'0.00'),
 (7823,21,19,79,20,0,'0.00'),
 (7824,21,63,79,20,8706,'12.32'),
 (7825,21,95,79,20,9088,'12.86'),
 (7826,21,1,79,21,11618,'52.19'),
 (7827,21,2,79,21,4589,'20.61'),
 (7828,21,5,79,21,0,'0.00'),
 (7829,21,8,79,21,0,'0.00'),
 (7830,21,19,79,21,0,'0.00'),
 (7831,21,63,79,21,2155,'9.68'),
 (7832,21,95,79,21,3185,'14.31'),
 (7833,23,1,79,1,11440,'24.66'),
 (7834,23,2,79,1,7443,'16.04'),
 (7835,23,5,79,1,7329,'15.80'),
 (7836,23,8,79,1,1710,'3.69'),
 (7837,23,19,79,1,1328,'2.86'),
 (7838,23,63,79,1,6741,'14.53'),
 (7839,23,95,79,1,9723,'20.96'),
 (7840,23,1,79,2,17890,'28.87'),
 (7841,23,2,79,2,9968,'16.09'),
 (7842,23,5,79,2,7847,'12.66'),
 (7843,23,8,79,2,3281,'5.30'),
 (7844,23,19,79,2,2226,'3.59'),
 (7845,23,63,79,2,7289,'11.76'),
 (7846,23,95,79,2,12291,'19.84'),
 (7847,23,1,79,3,21231,'39.53'),
 (7848,23,2,79,3,7142,'13.30'),
 (7849,23,5,79,3,4369,'8.14'),
 (7850,23,8,79,3,3199,'5.96'),
 (7851,23,19,79,3,3226,'6.01'),
 (7852,23,63,79,3,4265,'7.94'),
 (7853,23,95,79,3,9147,'17.03'),
 (7854,23,1,79,4,28353,'46.81'),
 (7855,23,2,79,4,6631,'10.95'),
 (7856,23,5,79,4,3469,'5.73'),
 (7857,23,8,79,4,3661,'6.04'),
 (7858,23,19,79,4,4864,'8.03'),
 (7859,23,63,79,4,3448,'5.69'),
 (7860,23,95,79,4,8916,'14.72'),
 (7861,23,1,79,5,28043,'45.68'),
 (7862,23,2,79,5,6633,'10.81'),
 (7863,23,5,79,5,3459,'5.63'),
 (7864,23,8,79,5,4116,'6.71'),
 (7865,23,19,79,5,5023,'8.18'),
 (7866,23,63,79,5,3301,'5.38'),
 (7867,23,95,79,5,9472,'15.43'),
 (7868,23,1,79,6,18535,'35.74'),
 (7869,23,2,79,6,8921,'17.20'),
 (7870,23,5,79,6,4463,'8.61'),
 (7871,23,8,79,6,2569,'4.95'),
 (7872,23,19,79,6,2453,'4.73'),
 (7873,23,63,79,6,4747,'9.15'),
 (7874,23,95,79,6,9274,'17.88'),
 (7875,23,1,79,7,25732,'42.58'),
 (7876,23,2,79,7,7363,'12.18'),
 (7877,23,5,79,7,4472,'7.40'),
 (7878,23,8,79,7,3554,'5.88'),
 (7879,23,19,79,7,4371,'7.23'),
 (7880,23,63,79,7,4238,'7.01'),
 (7881,23,95,79,7,9470,'15.67'),
 (7882,23,1,79,8,32901,'35.74'),
 (7883,23,2,79,8,14955,'16.25'),
 (7884,23,5,79,8,7288,'7.92'),
 (7885,23,8,79,8,5539,'6.02'),
 (7886,23,19,79,8,5135,'5.58'),
 (7887,23,63,79,8,7358,'7.99'),
 (7888,23,95,79,8,16912,'18.37'),
 (7889,23,1,79,9,19049,'39.88'),
 (7890,23,2,79,9,6433,'13.47'),
 (7891,23,5,79,9,3951,'8.27'),
 (7892,23,8,79,9,2735,'5.73'),
 (7893,23,19,79,9,3223,'6.75'),
 (7894,23,63,79,9,3755,'7.86'),
 (7895,23,95,79,9,7670,'16.06'),
 (7896,23,1,79,10,28034,'32.31'),
 (7897,23,2,79,10,17395,'20.05'),
 (7898,23,5,79,10,9992,'11.52'),
 (7899,23,8,79,10,3048,'3.51'),
 (7900,23,19,79,10,2505,'2.89'),
 (7901,23,63,79,10,9340,'10.76'),
 (7902,23,95,79,10,15120,'17.43'),
 (7903,23,1,79,11,22448,'29.26'),
 (7904,23,2,79,11,16769,'21.86'),
 (7905,23,5,79,11,9111,'11.87'),
 (7906,23,8,79,11,2672,'3.48'),
 (7907,23,19,79,11,1727,'2.25'),
 (7908,23,63,79,11,9074,'11.83'),
 (7909,23,95,79,11,13675,'17.82'),
 (7910,23,1,79,12,8804,'23.42'),
 (7911,23,2,79,12,9855,'26.21'),
 (7912,23,5,79,12,4708,'12.52'),
 (7913,23,8,79,12,1107,'2.94'),
 (7914,23,19,79,12,629,'1.67'),
 (7915,23,63,79,12,4901,'13.03'),
 (7916,23,95,79,12,7014,'18.65'),
 (7917,23,1,79,13,13158,'18.17'),
 (7918,23,2,79,13,21213,'29.29'),
 (7919,23,5,79,13,10424,'14.40'),
 (7920,23,8,79,13,1733,'2.39'),
 (7921,23,19,79,13,982,'1.36'),
 (7922,23,63,79,13,11780,'16.27'),
 (7923,23,95,79,13,12103,'16.71'),
 (7924,23,1,79,14,12432,'31.88'),
 (7925,23,2,79,14,7991,'20.49'),
 (7926,23,5,79,14,4269,'10.95'),
 (7927,23,8,79,14,1467,'3.76'),
 (7928,23,19,79,14,1065,'2.73'),
 (7929,23,63,79,14,4436,'11.37'),
 (7930,23,95,79,14,6670,'17.10'),
 (7931,23,1,79,15,28552,'35.92'),
 (7932,23,2,79,15,14137,'17.78'),
 (7933,23,5,79,15,7612,'9.58'),
 (7934,23,8,79,15,3690,'4.64'),
 (7935,23,19,79,15,3312,'4.17'),
 (7936,23,63,79,15,6981,'8.78'),
 (7937,23,95,79,15,13727,'17.27'),
 (7938,23,1,79,16,20746,'32.26'),
 (7939,23,2,79,16,11282,'17.54'),
 (7940,23,5,79,16,6244,'9.71'),
 (7941,23,8,79,16,3733,'5.80'),
 (7942,23,19,79,16,2941,'4.57'),
 (7943,23,63,79,16,5657,'8.80'),
 (7944,23,95,79,16,12376,'19.24'),
 (7945,23,1,79,17,9865,'22.54'),
 (7946,23,2,79,17,11807,'26.98'),
 (7947,23,5,79,17,5269,'12.04'),
 (7948,23,8,79,17,1255,'2.87'),
 (7949,23,19,79,17,667,'1.52'),
 (7950,23,63,79,17,6191,'14.15'),
 (7951,23,95,79,17,7979,'18.23'),
 (7952,23,1,79,18,6050,'18.77'),
 (7953,23,2,79,18,6946,'21.55'),
 (7954,23,5,79,18,4736,'14.69'),
 (7955,23,8,79,18,1322,'4.10'),
 (7956,23,19,79,18,588,'1.82'),
 (7957,23,63,79,18,5109,'15.85'),
 (7958,23,95,79,18,6855,'21.27'),
 (7959,23,1,79,19,4852,'20.68'),
 (7960,23,2,79,19,5100,'21.74'),
 (7961,23,5,79,19,3593,'15.32'),
 (7962,23,8,79,19,1022,'4.36'),
 (7963,23,19,79,19,358,'1.53'),
 (7964,23,63,79,19,3107,'13.24'),
 (7965,23,95,79,19,4997,'21.30'),
 (7966,23,1,79,20,13147,'25.15'),
 (7967,23,2,79,20,10608,'20.29'),
 (7968,23,5,79,20,7046,'13.48'),
 (7969,23,8,79,20,2301,'4.40'),
 (7970,23,19,79,20,1287,'2.46'),
 (7971,23,63,79,20,5972,'11.42'),
 (7972,23,95,79,20,10940,'20.93'),
 (7973,23,1,79,21,5375,'31.34'),
 (7974,23,2,79,21,2744,'16.00'),
 (7975,23,5,79,21,1777,'10.36'),
 (7976,23,8,79,21,1068,'6.23'),
 (7977,23,19,79,21,805,'4.69'),
 (7978,23,63,79,21,1581,'9.22'),
 (7979,23,95,79,21,3406,'19.86'),
 (9806,29,17,79,1,388,'0.60'),
 (9807,29,17,79,2,414,'0.46'),
 (9808,29,17,79,3,277,'0.38'),
 (9809,29,17,79,4,325,'0.40'),
 (9810,29,17,79,5,321,'0.38'),
 (9811,29,17,79,6,449,'0.62'),
 (9812,29,17,79,7,298,'0.37'),
 (9813,29,17,79,8,628,'0.47'),
 (9814,29,17,79,9,296,'0.44'),
 (9815,29,17,79,10,742,'0.64'),
 (9816,29,17,79,11,669,'0.64'),
 (9817,29,17,79,12,397,'0.76'),
 (9818,29,17,79,13,730,'0.76'),
 (9819,29,17,79,14,309,'0.59'),
 (9820,29,17,79,15,669,'0.62'),
 (9821,29,17,79,16,520,'0.53'),
 (9822,29,17,79,17,444,'0.75'),
 (9823,29,17,79,18,401,'0.80'),
 (9824,29,17,79,19,242,'0.71'),
 (9825,29,17,79,20,516,'0.68'),
 (9826,29,17,79,21,153,'0.59'),
 (9837,29,96,79,1,17996,'27.78'),
 (9838,29,96,79,2,18333,'20.58'),
 (9839,29,96,79,3,9502,'13.02'),
 (9840,29,96,79,4,7748,'9.50'),
 (9841,29,96,79,5,7515,'8.86'),
 (9842,29,96,79,6,11265,'15.59'),
 (9843,29,96,79,7,10243,'12.61'),
 (9844,29,96,79,8,16202,'12.22'),
 (9845,29,96,79,9,8659,'12.89'),
 (9846,29,96,79,10,19597,'16.89'),
 (9847,29,96,79,11,18932,'18.01'),
 (9848,29,96,79,12,11043,'21.26'),
 (9849,29,96,79,13,22131,'22.91'),
 (9850,29,96,79,14,8668,'16.67'),
 (9851,29,96,79,15,15569,'14.43'),
 (9852,29,96,79,16,12839,'13.04'),
 (9853,29,96,79,17,11064,'18.67'),
 (9854,29,96,79,18,11642,'23.29'),
 (9855,29,96,79,19,6991,'20.44'),
 (9856,29,96,79,20,13295,'17.62'),
 (9857,29,96,79,21,3744,'14.40'),
 (9868,29,2,79,1,16473,'25.43'),
 (9869,29,2,79,2,23034,'25.86'),
 (9870,29,2,79,3,15614,'21.40'),
 (9871,29,2,79,4,13547,'16.60'),
 (9872,29,2,79,5,13840,'16.31'),
 (9873,29,2,79,6,17415,'24.11'),
 (9874,29,2,79,7,15566,'19.16'),
 (9875,29,2,79,8,30228,'22.79'),
 (9876,29,2,79,9,13611,'20.26'),
 (9877,29,2,79,10,33493,'28.87'),
 (9878,29,2,79,11,31888,'30.34'),
 (9879,29,2,79,12,17246,'33.21'),
 (9880,29,2,79,13,34682,'35.90'),
 (9881,29,2,79,14,15247,'29.33'),
 (9882,29,2,79,15,27994,'25.95'),
 (9883,29,2,79,16,23791,'24.17'),
 (9884,29,2,79,17,20934,'35.33'),
 (9885,29,2,79,18,14931,'29.86'),
 (9886,29,2,79,19,10945,'31.99'),
 (9887,29,2,79,20,22543,'29.88'),
 (9888,29,2,79,21,6042,'23.24'),
 (9899,29,14,79,1,21,'0.03'),
 (9900,29,14,79,2,33,'0.04'),
 (9901,29,14,79,3,23,'0.03'),
 (9902,29,14,79,4,16,'0.02'),
 (9903,29,14,79,5,19,'0.02'),
 (9904,29,14,79,6,45,'0.06'),
 (9905,29,14,79,7,23,'0.03'),
 (9906,29,14,79,8,55,'0.04'),
 (9907,29,14,79,9,23,'0.03'),
 (9908,29,14,79,10,72,'0.06'),
 (9909,29,14,79,11,51,'0.05'),
 (9910,29,14,79,12,28,'0.05'),
 (9911,29,14,79,13,59,'0.06'),
 (9912,29,14,79,14,13,'0.03'),
 (9913,29,14,79,15,37,'0.03'),
 (9914,29,14,79,16,135,'0.14'),
 (9915,29,14,79,17,31,'0.05'),
 (9916,29,14,79,18,19,'0.04'),
 (9917,29,14,79,19,14,'0.04'),
 (9918,29,14,79,20,27,'0.04'),
 (9919,29,14,79,21,10,'0.04'),
 (9930,29,6,79,1,4,'0.01'),
 (9931,29,6,79,2,7,'0.01'),
 (9932,29,6,79,3,7,'0.01'),
 (9933,29,6,79,4,9,'0.01'),
 (9934,29,6,79,5,4,'0.00'),
 (9935,29,6,79,6,7,'0.01'),
 (9936,29,6,79,7,8,'0.01'),
 (9937,29,6,79,8,7,'0.01'),
 (9938,29,6,79,9,7,'0.01'),
 (9939,29,6,79,10,30,'0.03'),
 (9940,29,6,79,11,16,'0.02'),
 (9941,29,6,79,12,12,'0.02'),
 (9942,29,6,79,13,22,'0.02'),
 (9943,29,6,79,14,8,'0.02'),
 (9944,29,6,79,15,11,'0.01'),
 (9945,29,6,79,16,9,'0.01'),
 (9946,29,6,79,17,24,'0.04'),
 (9947,29,6,79,18,6,'0.01'),
 (9948,29,6,79,19,5,'0.01'),
 (9949,29,6,79,20,10,'0.01'),
 (9950,29,6,79,21,2,'0.01'),
 (9961,29,8,79,1,9144,'14.11'),
 (9962,29,8,79,2,16673,'18.72'),
 (9963,29,8,79,3,15654,'21.45'),
 (9964,29,8,79,4,17743,'21.74'),
 (9965,29,8,79,5,19819,'23.36'),
 (9966,29,8,79,6,13834,'19.15'),
 (9967,29,8,79,7,16914,'20.82'),
 (9968,29,8,79,8,30886,'23.29'),
 (9969,29,8,79,9,13650,'20.31'),
 (9970,29,8,79,10,18895,'16.29'),
 (9971,29,8,79,11,17120,'16.29'),
 (9972,29,8,79,12,7701,'14.83'),
 (9973,29,8,79,13,11988,'12.41'),
 (9974,29,8,79,14,9054,'17.41'),
 (9975,29,8,79,15,21559,'19.98'),
 (9976,29,8,79,16,24382,'24.77'),
 (9977,29,8,79,17,8934,'15.08'),
 (9978,29,8,79,18,9430,'18.86'),
 (9979,29,8,79,19,6511,'19.03'),
 (9980,29,8,79,20,15178,'20.12'),
 (9981,29,8,79,21,6550,'25.20'),
 (9992,29,16,79,1,40,'0.06'),
 (9993,29,16,79,2,42,'0.05'),
 (9994,29,16,79,3,35,'0.05'),
 (9995,29,16,79,4,47,'0.06'),
 (9996,29,16,79,5,37,'0.04'),
 (9997,29,16,79,6,33,'0.05'),
 (9998,29,16,79,7,52,'0.06'),
 (9999,29,16,79,8,79,'0.06'),
 (10000,29,16,79,9,43,'0.06'),
 (10001,29,16,79,10,63,'0.05'),
 (10002,29,16,79,11,83,'0.08'),
 (10003,29,16,79,12,31,'0.06'),
 (10004,29,16,79,13,63,'0.07'),
 (10005,29,16,79,14,33,'0.06'),
 (10006,29,16,79,15,63,'0.06'),
 (10007,29,16,79,16,48,'0.05'),
 (10008,29,16,79,17,51,'0.09'),
 (10009,29,16,79,18,28,'0.06'),
 (10010,29,16,79,19,18,'0.05'),
 (10011,29,16,79,20,35,'0.05'),
 (10012,29,16,79,21,14,'0.05'),
 (10023,29,7,79,1,36,'0.06'),
 (10024,29,7,79,2,45,'0.05'),
 (10025,29,7,79,3,25,'0.03'),
 (10026,29,7,79,4,34,'0.04'),
 (10027,29,7,79,5,24,'0.03'),
 (10028,29,7,79,6,31,'0.04'),
 (10029,29,7,79,7,19,'0.02'),
 (10030,29,7,79,8,44,'0.03'),
 (10031,29,7,79,9,18,'0.03'),
 (10032,29,7,79,10,111,'0.10'),
 (10033,29,7,79,11,135,'0.13'),
 (10034,29,7,79,12,70,'0.13'),
 (10035,29,7,79,13,105,'0.11'),
 (10036,29,7,79,14,33,'0.06'),
 (10037,29,7,79,15,71,'0.07'),
 (10038,29,7,79,16,36,'0.04'),
 (10039,29,7,79,17,81,'0.14'),
 (10040,29,7,79,18,27,'0.05'),
 (10041,29,7,79,19,32,'0.09'),
 (10042,29,7,79,20,40,'0.05'),
 (10043,29,7,79,21,7,'0.03'),
 (10054,29,22,79,1,44,'0.07'),
 (10055,29,22,79,2,75,'0.08'),
 (10056,29,22,79,3,48,'0.07'),
 (10057,29,22,79,4,65,'0.08'),
 (10058,29,22,79,5,78,'0.09'),
 (10059,29,22,79,6,68,'0.09'),
 (10060,29,22,79,7,55,'0.07'),
 (10061,29,22,79,8,120,'0.09'),
 (10062,29,22,79,9,64,'0.10'),
 (10063,29,22,79,10,156,'0.13'),
 (10064,29,22,79,11,110,'0.10'),
 (10065,29,22,79,12,51,'0.10'),
 (10066,29,22,79,13,96,'0.10'),
 (10067,29,22,79,14,70,'0.13'),
 (10068,29,22,79,15,118,'0.11'),
 (10069,29,22,79,16,77,'0.08'),
 (10070,29,22,79,17,62,'0.10'),
 (10071,29,22,79,18,50,'0.10'),
 (10072,29,22,79,19,45,'0.13'),
 (10073,29,22,79,20,73,'0.10'),
 (10074,29,22,79,21,26,'0.10'),
 (10085,29,10,79,1,28,'0.04'),
 (10086,29,10,79,2,25,'0.03'),
 (10087,29,10,79,3,29,'0.04'),
 (10088,29,10,79,4,40,'0.05'),
 (10089,29,10,79,5,22,'0.03'),
 (10090,29,10,79,6,43,'0.06'),
 (10091,29,10,79,7,32,'0.04'),
 (10092,29,10,79,8,36,'0.03'),
 (10093,29,10,79,9,30,'0.04'),
 (10094,29,10,79,10,51,'0.04'),
 (10095,29,10,79,11,36,'0.03'),
 (10096,29,10,79,12,25,'0.05'),
 (10097,29,10,79,13,40,'0.04'),
 (10098,29,10,79,14,27,'0.05'),
 (10099,29,10,79,15,39,'0.04'),
 (10100,29,10,79,16,35,'0.04'),
 (10101,29,10,79,17,29,'0.05'),
 (10102,29,10,79,18,16,'0.03'),
 (10103,29,10,79,19,10,'0.03'),
 (10104,29,10,79,20,15,'0.02'),
 (10105,29,10,79,21,11,'0.04'),
 (10116,29,1,79,1,11246,'17.36'),
 (10117,29,1,79,2,18506,'20.77'),
 (10118,29,1,79,3,22040,'30.20'),
 (10119,29,1,79,4,30185,'36.99'),
 (10120,29,1,79,5,31418,'37.03'),
 (10121,29,1,79,6,18552,'25.68'),
 (10122,29,1,79,7,27059,'33.30'),
 (10123,29,1,79,8,35676,'26.90'),
 (10124,29,1,79,9,21273,'31.66'),
 (10125,29,1,79,10,26496,'22.84'),
 (10126,29,1,79,11,21028,'20.01'),
 (10127,29,1,79,12,8225,'15.84'),
 (10128,29,1,79,13,11566,'11.97'),
 (10129,29,1,79,14,11735,'22.57'),
 (10130,29,1,79,15,27605,'25.59'),
 (10131,29,1,79,16,23494,'23.87'),
 (10132,29,1,79,17,9043,'15.26'),
 (10133,29,1,79,18,6299,'12.60'),
 (10134,29,1,79,19,4735,'13.84'),
 (10135,29,1,79,20,13446,'17.82'),
 (10136,29,1,79,21,5850,'22.50'),
 (10147,29,97,79,1,34,'0.05'),
 (10148,29,97,79,2,55,'0.06'),
 (10149,29,97,79,3,33,'0.05'),
 (10150,29,97,79,4,58,'0.07'),
 (10151,29,97,79,5,35,'0.04'),
 (10152,29,97,79,6,35,'0.05'),
 (10153,29,97,79,7,23,'0.03'),
 (10154,29,97,79,8,64,'0.05'),
 (10155,29,97,79,9,37,'0.06'),
 (10156,29,97,79,10,82,'0.07'),
 (10157,29,97,79,11,82,'0.08'),
 (10158,29,97,79,12,74,'0.14'),
 (10159,29,97,79,13,128,'0.13'),
 (10160,29,97,79,14,39,'0.08'),
 (10161,29,97,79,15,77,'0.07'),
 (10162,29,97,79,16,53,'0.05'),
 (10163,29,97,79,17,97,'0.16'),
 (10164,29,97,79,18,43,'0.09'),
 (10165,29,97,79,19,28,'0.08'),
 (10166,29,97,79,20,67,'0.09'),
 (10167,29,97,79,21,11,'0.04'),
 (10178,29,19,79,1,3879,'5.99'),
 (10179,29,19,79,2,6212,'6.97'),
 (10180,29,19,79,3,6802,'9.32'),
 (10181,29,19,79,4,9496,'11.64'),
 (10182,29,19,79,5,9295,'10.95'),
 (10183,29,19,79,6,6670,'9.23'),
 (10184,29,19,79,7,8004,'9.85'),
 (10185,29,19,79,8,12978,'9.79'),
 (10186,29,19,79,9,6723,'10.00'),
 (10187,29,19,79,10,8811,'7.59'),
 (10188,29,19,79,11,7900,'7.52'),
 (10189,29,19,79,12,3416,'6.58'),
 (10190,29,19,79,13,5142,'5.32'),
 (10191,29,19,79,14,3488,'6.71'),
 (10192,29,19,79,15,8691,'8.06'),
 (10193,29,19,79,16,8742,'8.88'),
 (10194,29,19,79,17,3978,'6.71'),
 (10195,29,19,79,18,3290,'6.58'),
 (10196,29,19,79,19,2202,'6.44'),
 (10197,29,19,79,20,5504,'7.29'),
 (10198,29,19,79,21,2401,'9.24'),
 (10209,29,9,79,1,76,'0.12'),
 (10210,29,9,79,2,102,'0.11'),
 (10211,29,9,79,3,75,'0.10'),
 (10212,29,9,79,4,88,'0.11'),
 (10213,29,9,79,5,80,'0.09'),
 (10214,29,9,79,6,77,'0.11'),
 (10215,29,9,79,7,90,'0.11'),
 (10216,29,9,79,8,146,'0.11'),
 (10217,29,9,79,9,96,'0.14'),
 (10218,29,9,79,10,151,'0.13'),
 (10219,29,9,79,11,150,'0.14'),
 (10220,29,9,79,12,59,'0.11'),
 (10221,29,9,79,13,93,'0.10'),
 (10222,29,9,79,14,54,'0.10'),
 (10223,29,9,79,15,118,'0.11'),
 (10224,29,9,79,16,106,'0.11'),
 (10225,29,9,79,17,74,'0.12'),
 (10226,29,9,79,18,51,'0.10'),
 (10227,29,9,79,19,25,'0.07'),
 (10228,29,9,79,20,99,'0.13'),
 (10229,29,9,79,21,40,'0.15'),
 (10240,29,98,79,1,5080,'7.84'),
 (10241,29,98,79,2,5150,'5.78'),
 (10242,29,98,79,3,2495,'3.42'),
 (10243,29,98,79,4,1879,'2.30'),
 (10244,29,98,79,5,1984,'2.34'),
 (10245,29,98,79,6,3370,'4.66'),
 (10246,29,98,79,7,2509,'3.09'),
 (10247,29,98,79,8,4907,'3.70'),
 (10248,29,98,79,9,2381,'3.54'),
 (10249,29,98,79,10,6825,'5.88'),
 (10250,29,98,79,11,6415,'6.10'),
 (10251,29,98,79,12,3335,'6.42'),
 (10252,29,98,79,13,9346,'9.67'),
 (10253,29,98,79,14,2956,'5.69'),
 (10254,29,98,79,15,4777,'4.43'),
 (10255,29,98,79,16,3786,'3.85'),
 (10256,29,98,79,17,4143,'6.99'),
 (10257,29,98,79,18,3541,'7.08'),
 (10258,29,98,79,19,2250,'6.58'),
 (10259,29,98,79,20,4285,'5.68'),
 (10260,29,98,79,21,1043,'4.01');
/*!40000 ALTER TABLE `elecdistricandi` ENABLE KEYS */;


--
-- Definition of table `elecdistritotal`
--

DROP TABLE IF EXISTS `elecdistritotal`;
CREATE TABLE `elecdistritotal` (
  `idElecDistriTotal` int(11) NOT NULL AUTO_INCREMENT,
  `Convocatoria_idConvocatoria` int(11) NOT NULL,
  `Municipio` int(11) NOT NULL,
  `Distrito` int(11) NOT NULL,
  `Censo` int(11) NOT NULL,
  `CensoOficial` int(11) NOT NULL,
  `Certificacion` int(11) NOT NULL,
  `CertificacionAlta` int(11) NOT NULL DEFAULT '0',
  `CertificacionError` int(11) NOT NULL DEFAULT '0',
  `Voto` int(11) NOT NULL,
  `Interventores` int(11) NOT NULL,
  `Nulo` int(11) NOT NULL,
  `Blanco` int(11) NOT NULL,
  `Validos` int(11) NOT NULL,
  PRIMARY KEY (`idElecDistriTotal`),
  KEY `fk_ElecMuniTotal_Convocatoria1_idx` (`Convocatoria_idConvocatoria`),
  KEY `iElecDistriTotal_municipio` (`Municipio`),
  CONSTRAINT `fk_ElecMuniTotal_Convocatoria10` FOREIGN KEY (`Convocatoria_idConvocatoria`) REFERENCES `convocatoria` (`idConvocatoria`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=1348 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `elecdistritotal`
--

/*!40000 ALTER TABLE `elecdistritotal` DISABLE KEYS */;
INSERT INTO `elecdistritotal` (`idElecDistriTotal`,`Convocatoria_idConvocatoria`,`Municipio`,`Distrito`,`Censo`,`CensoOficial`,`Certificacion`,`CertificacionAlta`,`CertificacionError`,`Voto`,`Interventores`,`Nulo`,`Blanco`,`Validos`) VALUES 
 (1,1,79,1,96694,96694,14,14,0,64007,130,381,532,63626),
 (2,1,79,2,118026,118026,4,4,0,86342,99,635,818,85707),
 (3,1,79,3,96249,96249,2,2,0,72184,88,478,708,71706),
 (4,1,79,4,112545,112545,3,3,0,81005,140,503,759,80502),
 (5,1,79,5,111525,111525,10,10,0,82348,150,473,877,81875),
 (6,1,79,6,111293,111293,3,3,0,72656,76,560,735,72096),
 (7,1,79,7,109753,109753,1,1,0,79916,111,483,801,79433),
 (8,1,79,8,177769,177769,3,3,0,129179,107,858,1490,128321),
 (9,1,79,9,87966,87966,1,1,0,65009,82,401,676,64608),
 (10,1,79,10,177461,177461,0,0,0,122052,135,1166,1121,120886),
 (11,1,79,11,171858,171858,13,13,0,110526,94,1015,1056,109511),
 (12,1,79,12,91023,91023,6,6,0,56083,42,459,491,55624),
 (13,1,79,13,166112,166112,10,10,0,105439,191,947,846,104492),
 (14,1,79,14,76022,76022,19,19,0,54291,73,405,530,53886),
 (15,1,79,15,162048,162048,2,2,0,110660,62,895,1092,109765),
 (16,1,79,16,130807,130807,1,1,0,93614,52,734,1011,92880),
 (17,1,79,17,97702,97702,6,6,0,62883,63,598,549,62285),
 (18,1,79,18,71391,71391,3,3,0,49043,66,418,478,48625),
 (19,1,79,19,48320,48320,1,1,0,33851,43,310,390,33541),
 (20,1,79,20,113499,113499,5,5,0,77005,15,671,783,76334),
 (21,1,79,21,33788,33788,1,1,0,24737,56,198,264,24539),
 (22,2,79,1,93239,93239,22,22,0,58316,0,1380,1386,56936),
 (23,2,79,2,112042,112042,28,28,0,79104,0,1572,2015,77532),
 (24,2,79,3,95234,95234,28,28,0,70066,0,1087,1580,68979),
 (25,2,79,4,110133,110133,12,12,0,79025,0,952,1638,78073),
 (26,2,79,5,108350,108350,21,21,0,79011,0,967,1746,78044),
 (27,2,79,6,105961,105961,17,17,0,68822,0,1032,1631,67790),
 (28,2,79,7,107845,107845,31,31,0,77407,0,1106,1785,76301),
 (29,2,79,8,170610,170610,21,21,0,121199,0,1823,2882,119376),
 (30,2,79,9,84970,84970,11,11,0,61679,0,918,1385,60761),
 (31,2,79,10,175753,175753,17,17,0,119724,1,2000,2432,117724),
 (32,2,79,11,164516,164516,15,15,0,106633,0,1907,2356,104726),
 (33,2,79,12,87408,87408,9,9,0,52700,0,858,1194,51842),
 (34,2,79,13,161779,161779,16,16,0,96913,0,1537,2086,95376),
 (35,2,79,14,75980,75980,19,19,0,52583,0,804,1139,51779),
 (36,2,79,15,157807,157807,35,35,0,107645,2,1683,2373,105962),
 (37,2,79,16,124511,124511,9,9,0,86081,0,1340,2145,84741),
 (38,2,79,17,93065,93065,12,12,0,59288,0,1033,1342,58255),
 (39,2,79,18,62600,62600,3,3,0,40217,0,755,1123,39462),
 (40,2,79,19,46115,46115,2,2,0,30597,0,564,788,30033),
 (41,2,79,20,109508,109508,6,6,0,71518,0,1082,1767,70436),
 (42,2,79,21,32218,32218,5,5,0,22486,0,387,545,22099),
 (43,3,79,1,92374,92374,3,1,2,58997,194,255,1063,58742),
 (44,3,79,2,107533,107533,9,3,6,77273,230,313,1583,76960),
 (45,3,79,3,96670,96670,6,3,3,73022,174,229,1483,72793),
 (46,3,79,4,109526,109526,17,7,10,81095,171,276,1407,80819),
 (47,3,79,5,106630,106630,15,5,10,80719,225,264,1606,80455),
 (48,3,79,6,104967,104967,8,3,5,70727,181,286,1235,70441),
 (49,3,79,7,108970,108970,22,9,13,80279,230,290,1475,79989),
 (50,3,79,8,162024,162024,17,10,7,117230,270,472,2429,116758),
 (51,3,79,9,84813,84813,12,3,9,62671,182,210,1188,62461),
 (52,3,79,10,183089,183089,13,4,9,129028,332,630,2145,128398),
 (53,3,79,11,165365,165365,9,4,5,110582,226,557,1835,110025),
 (54,3,79,12,88762,88762,4,3,1,56266,141,234,782,56032),
 (55,3,79,13,165006,165006,3,2,1,104180,343,454,1389,103726),
 (56,3,79,14,79008,79008,5,2,3,55959,111,247,893,55712),
 (57,3,79,15,159780,159780,9,3,6,113122,210,465,1970,112657),
 (58,3,79,16,118078,118078,4,0,4,84145,170,368,1643,83777),
 (59,3,79,17,94739,94739,6,4,2,62198,153,293,930,61905),
 (60,3,79,18,46520,46520,3,1,2,31040,105,122,559,30918),
 (61,3,79,19,44926,44926,1,1,0,30210,91,102,562,30108),
 (62,3,79,20,108334,108334,2,0,2,72694,146,356,1216,72338),
 (63,3,79,21,31313,31313,3,1,2,22094,64,103,470,21991),
 (64,4,79,1,98495,98495,88,0,0,60110,242,231,1061,59879),
 (65,4,79,2,105646,105646,94,0,0,71677,225,298,1442,71379),
 (66,4,79,3,100048,100048,196,0,0,70945,131,295,1490,70650),
 (67,4,79,4,114072,114072,57,0,0,80849,246,291,1442,80558),
 (68,4,79,5,107560,107560,92,0,0,77065,240,219,1601,76846),
 (69,4,79,6,107256,107256,59,0,0,69551,170,261,1250,69290),
 (70,4,79,7,115323,115323,84,0,0,81380,119,307,1589,81073),
 (71,4,79,8,163177,163177,99,0,0,111312,66,397,2455,110915),
 (72,4,79,9,88106,88106,91,0,0,62597,0,234,1344,62363),
 (73,4,79,10,199217,199217,145,0,0,132564,0,707,2247,131857),
 (74,4,79,11,171938,171938,97,0,0,109441,0,419,1769,109022),
 (75,4,79,12,91635,91635,30,0,0,56030,0,165,719,55865),
 (76,4,79,13,176145,176145,53,0,0,108987,0,314,1306,108673),
 (77,4,79,14,85196,85196,40,0,0,56909,0,219,1047,56690),
 (78,4,79,15,172120,172120,131,0,0,114827,0,449,2130,114378),
 (79,4,79,16,116290,116290,74,0,0,76999,0,260,1519,76739),
 (80,4,79,17,99590,99590,45,0,0,63099,0,208,913,62891),
 (81,4,79,18,47556,47556,21,0,0,29903,0,119,470,29784),
 (82,4,79,19,42941,42941,60,0,0,26768,0,102,481,26666),
 (83,4,79,20,110672,110672,155,0,0,71055,0,266,1259,70789),
 (84,4,79,21,30916,30916,18,0,0,20328,0,83,578,20245),
 (95,5,79,1,98635,98635,28,0,0,66608,0,287,1319,66321),
 (96,5,79,2,105516,105516,65,0,0,78466,0,379,1784,78087),
 (97,5,79,3,100162,100162,36,0,0,76601,0,260,1912,76341),
 (98,5,79,4,114018,114018,29,0,0,86226,0,311,1992,85915),
 (99,5,79,5,107828,107828,42,0,0,81964,0,286,2089,81678),
 (100,5,79,6,107831,107831,46,0,0,76514,0,346,1565,76168),
 (101,5,79,7,115764,115764,49,0,0,87046,0,375,2151,86671),
 (102,5,79,8,163623,163623,104,0,0,121174,0,472,3245,120702),
 (103,5,79,9,87982,87982,19,0,0,67453,0,311,1639,67142),
 (104,5,79,10,200482,200482,61,0,0,145795,0,763,2976,145032),
 (105,5,79,11,172333,172333,76,0,0,120876,0,506,2136,120370),
 (106,5,79,12,91508,91508,20,0,0,62129,0,264,921,61865),
 (107,5,79,13,176631,176631,38,0,0,120424,0,487,1608,119937),
 (108,5,79,14,85475,85475,52,0,0,62631,0,226,1345,62405),
 (109,5,79,15,172854,172854,71,0,0,125976,0,565,2787,125411),
 (110,5,79,16,116533,116533,35,0,0,84640,0,319,1954,84321),
 (111,5,79,17,99717,99717,25,0,0,69875,0,280,1005,69595),
 (112,5,79,18,47597,47597,29,0,0,33637,0,183,594,33454),
 (113,5,79,19,42398,42398,4,0,0,29446,0,140,512,29306),
 (114,5,79,20,110589,110589,1780,0,0,78869,0,307,1454,78562),
 (115,5,79,21,30750,30750,35,0,0,22704,0,77,643,22627),
 (126,6,79,1,102859,102859,0,0,0,59217,0,342,1286,58875),
 (127,6,79,2,100319,100319,0,0,0,63529,0,292,1484,63237),
 (128,6,79,3,101214,101214,0,0,0,66684,0,278,1869,66406),
 (129,6,79,4,119794,119794,0,0,0,79979,0,435,2050,79544),
 (130,6,79,5,111554,111554,0,0,0,73395,0,302,2185,73093),
 (131,6,79,6,112251,112251,0,0,0,69852,0,364,1560,69488),
 (132,6,79,7,122278,122278,0,0,0,81414,0,427,2145,80987),
 (133,6,79,8,165158,165158,0,0,0,104933,0,483,2851,104450),
 (134,6,79,9,86276,86276,0,0,0,57452,0,267,1700,57185),
 (135,6,79,10,212617,212617,0,0,0,135766,0,741,2746,135025),
 (136,6,79,11,179848,179848,0,0,0,109167,0,566,1973,108601),
 (137,6,79,12,92834,92834,0,0,0,54950,0,268,821,54682),
 (138,6,79,13,182388,182388,0,0,0,105936,0,468,1557,105468),
 (139,6,79,14,87054,87054,0,0,0,53779,0,239,1193,53540),
 (140,6,79,15,178081,178081,0,0,0,111503,0,489,2460,111014),
 (141,6,79,16,115870,115870,0,0,0,71104,0,323,1597,70781),
 (142,6,79,17,101068,101068,0,0,0,61896,0,292,1009,61604),
 (143,6,79,18,47427,47427,0,0,0,27386,0,129,542,27257),
 (144,6,79,19,38646,38646,0,0,0,22342,0,88,356,22254),
 (145,6,79,20,104412,104412,0,0,0,62564,0,294,1018,62270),
 (146,6,79,21,27710,27710,0,0,0,17523,0,83,518,17440),
 (147,11,79,4,133777,133777,0,0,0,92020,0,183,1052,91837),
 (148,11,79,20,104812,104812,0,0,0,59345,0,163,699,59182),
 (149,11,79,9,88425,88425,0,0,0,59578,0,192,829,59386),
 (150,11,79,15,186202,186202,0,0,0,116505,0,339,1514,116166),
 (151,11,79,4,133777,133777,0,0,0,92020,0,183,1052,91837),
 (152,11,79,20,104812,104812,0,0,0,59345,0,163,699,59182),
 (153,11,79,10,223852,223852,0,0,0,137401,0,460,1924,136941),
 (154,11,79,15,186202,186202,0,0,0,116505,0,339,1514,116166),
 (155,11,79,5,120983,120983,0,0,0,82178,0,149,1066,82029),
 (156,11,79,21,26605,26605,0,0,0,17076,0,32,300,17044),
 (157,11,79,10,223852,223852,0,0,0,137401,0,460,1924,136941),
 (158,11,79,16,110522,110522,0,0,0,66643,0,183,1122,66460),
 (159,11,79,5,120983,120983,0,0,0,82178,0,149,1066,82029),
 (160,11,79,21,26605,26605,0,0,0,17076,0,32,300,17044),
 (161,11,79,11,193014,193014,0,0,0,112856,0,403,1342,112453),
 (162,11,79,16,110522,110522,0,0,0,66643,0,183,1122,66460),
 (163,11,79,6,123157,123157,0,0,0,76533,0,207,907,76326),
 (164,11,79,11,193014,193014,0,0,0,112856,0,403,1342,112453),
 (165,11,79,1,117803,117803,0,0,0,66717,0,260,687,66457),
 (166,11,79,17,101680,101680,0,0,0,58153,0,313,672,57840),
 (167,11,79,6,123157,123157,0,0,0,76533,0,207,907,76326),
 (168,11,79,12,98801,98801,0,0,0,54639,0,167,622,54472),
 (169,11,79,1,117803,117803,0,0,0,66717,0,260,687,66457),
 (170,11,79,17,101680,101680,0,0,0,58153,0,313,672,57840),
 (171,11,79,7,137953,137953,0,0,0,94489,0,371,1006,94118),
 (172,11,79,12,98801,98801,0,0,0,54639,0,167,622,54472),
 (173,11,79,2,97781,97781,0,0,0,61091,0,146,763,60945),
 (174,11,79,18,45444,45444,0,0,0,25205,0,74,345,25131),
 (175,11,79,7,137953,137953,0,0,0,94489,0,371,1006,94118),
 (176,11,79,13,182878,182878,0,0,0,99747,0,316,1088,99431),
 (177,11,79,2,97781,97781,0,0,0,61091,0,146,763,60945),
 (178,11,79,18,45444,45444,0,0,0,25205,0,74,345,25131),
 (179,11,79,8,163047,163047,0,0,0,102768,0,236,1649,102532),
 (180,11,79,13,182878,182878,0,0,0,99747,0,316,1088,99431),
 (181,11,79,3,105838,105838,0,0,0,71951,0,159,968,71792),
 (182,11,79,19,32779,32779,0,0,0,17233,0,67,234,17166),
 (183,11,79,8,163047,163047,0,0,0,102768,0,236,1649,102532),
 (184,11,79,14,88876,88876,0,0,0,54272,0,185,775,54087),
 (185,11,79,3,105838,105838,0,0,0,71951,0,159,968,71792),
 (186,11,79,19,32779,32779,0,0,0,17233,0,67,234,17166),
 (187,11,79,9,88425,88425,0,0,0,59578,0,192,829,59386),
 (188,11,79,14,88876,88876,0,0,0,54272,0,185,775,54087),
 (189,12,79,11,191792,191792,0,0,0,152559,0,552,1809,152007),
 (190,12,79,16,114393,114393,0,0,0,92955,0,301,1567,92654),
 (191,12,79,6,122629,122629,0,0,0,97146,0,308,1234,96838),
 (192,12,79,11,191792,191792,0,0,0,152559,0,552,1809,152007),
 (193,12,79,1,116551,116551,0,0,0,85480,0,311,988,85169),
 (194,12,79,17,104120,104120,0,0,0,83870,0,275,921,83595),
 (195,12,79,6,122629,122629,0,0,0,97146,0,308,1234,96838),
 (196,12,79,12,98562,98562,0,0,0,77140,0,267,780,76873),
 (197,12,79,1,116551,116551,0,0,0,85480,0,311,988,85169),
 (198,12,79,17,104120,104120,0,0,0,83870,0,275,921,83595),
 (199,12,79,7,135719,135719,0,0,0,110279,0,353,1523,109926),
 (200,12,79,12,98562,98562,0,0,0,77140,0,267,780,76873),
 (201,12,79,2,99435,99435,0,0,0,79861,0,286,1037,79575),
 (202,12,79,18,46872,46872,0,0,0,37072,0,137,427,36935),
 (203,12,79,7,135719,135719,0,0,0,110279,0,353,1523,109926),
 (204,12,79,13,187237,187237,0,0,0,146319,0,492,1431,145827),
 (205,12,79,2,99435,99435,0,0,0,79861,0,286,1037,79575),
 (206,12,79,18,46872,46872,0,0,0,37072,0,137,427,36935),
 (207,12,79,8,166661,166661,0,0,0,135836,0,506,2213,135330),
 (208,12,79,13,187237,187237,0,0,0,146319,0,492,1431,145827),
 (209,12,79,3,106792,106792,0,0,0,88596,0,255,1503,88341),
 (210,12,79,19,33964,33964,0,0,0,26442,0,100,261,26342),
 (211,12,79,8,166661,166661,0,0,0,135836,0,506,2213,135330),
 (212,12,79,14,90014,90014,0,0,0,73683,0,285,1164,73398),
 (213,12,79,3,106792,106792,0,0,0,88596,0,255,1503,88341),
 (214,12,79,19,33964,33964,0,0,0,26442,0,100,261,26342),
 (215,12,79,9,89129,89129,0,0,0,73095,0,237,1112,72858),
 (216,12,79,14,90014,90014,0,0,0,73683,0,285,1164,73398),
 (217,12,79,4,133031,133031,0,0,0,108484,0,300,1552,108184),
 (218,12,79,20,104167,104167,0,0,0,82085,0,303,912,81782),
 (219,12,79,9,89129,89129,0,0,0,73095,0,237,1112,72858),
 (220,12,79,15,186584,186584,0,0,0,150907,0,479,2076,150428),
 (221,12,79,4,133031,133031,0,0,0,108484,0,300,1552,108184),
 (222,12,79,20,104167,104167,0,0,0,82085,0,303,912,81782),
 (223,12,79,10,224416,224416,0,0,0,182627,0,709,2423,181918),
 (224,12,79,15,186584,186584,0,0,0,150907,0,479,2076,150428),
 (225,12,79,5,121173,121173,0,0,0,99192,0,269,1605,98923),
 (226,12,79,21,27424,27424,0,0,0,22545,0,90,335,22455),
 (227,12,79,10,224416,224416,0,0,0,182627,0,709,2423,181918),
 (228,12,79,16,114393,114393,0,0,0,92955,0,301,1567,92654),
 (229,12,79,5,121173,121173,0,0,0,99192,0,269,1605,98923),
 (230,12,79,21,27424,27424,0,0,0,22545,0,90,335,22455),
 (231,13,79,15,178432,178432,0,0,0,111567,0,565,2188,111002),
 (232,13,79,4,120176,120176,0,0,0,80300,0,371,1577,79929),
 (233,13,79,20,104522,104522,0,0,0,62484,0,406,1089,62078),
 (234,13,79,10,212774,212774,0,0,0,135135,0,905,2801,134230),
 (235,13,79,15,178432,178432,0,0,0,111567,0,565,2188,111002),
 (236,13,79,5,112008,112008,0,0,0,73611,0,283,1558,73328),
 (237,13,79,21,27812,27812,0,0,0,17518,0,86,447,17432),
 (238,13,79,10,212774,212774,0,0,0,135135,0,905,2801,134230),
 (239,13,79,16,116156,116156,0,0,0,70929,0,357,1569,70572),
 (240,13,79,5,112008,112008,0,0,0,73611,0,283,1558,73328),
 (241,13,79,21,27812,27812,0,0,0,17518,0,86,447,17432),
 (242,13,79,11,180007,180007,0,0,0,108831,0,671,1958,108160),
 (243,13,79,16,116156,116156,0,0,0,70929,0,357,1569,70572),
 (244,13,79,6,112452,112452,0,0,0,69310,0,432,1336,68878),
 (245,13,79,11,180007,180007,0,0,0,108831,0,671,1958,108160),
 (246,13,79,1,103254,103254,0,0,0,59319,0,393,1064,58926),
 (247,13,79,17,101131,101131,0,0,0,61749,0,415,1026,61334),
 (248,13,79,6,112452,112452,0,0,0,69310,0,432,1336,68878),
 (249,13,79,12,92880,92880,0,0,0,54533,0,327,921,54206),
 (250,13,79,1,103254,103254,0,0,0,59319,0,393,1064,58926),
 (251,13,79,17,101131,101131,0,0,0,61749,0,415,1026,61334),
 (252,13,79,7,122560,122560,0,0,0,81558,0,366,1716,81192),
 (253,13,79,12,92880,92880,0,0,0,54533,0,327,921,54206),
 (254,13,79,2,100504,100504,0,0,0,63526,0,333,1367,63193),
 (255,13,79,18,47464,47464,0,0,0,27339,0,200,572,27139),
 (256,13,79,7,122560,122560,0,0,0,81558,0,366,1716,81192),
 (257,13,79,13,182511,182511,0,0,0,105776,0,643,1638,105133),
 (258,13,79,2,100504,100504,0,0,0,63526,0,333,1367,63193),
 (259,13,79,18,47464,47464,0,0,0,27339,0,200,572,27139),
 (260,13,79,8,165495,165495,0,0,0,104873,0,513,2467,104360),
 (261,13,79,13,182511,182511,0,0,0,105776,0,643,1638,105133),
 (262,13,79,3,101437,101437,0,0,0,66627,0,299,1506,66328),
 (263,13,79,19,38682,38682,0,0,0,22204,0,134,414,22070),
 (264,13,79,8,165495,165495,0,0,0,104873,0,513,2467,104360),
 (265,13,79,14,87124,87124,0,0,0,53671,0,357,1148,53314),
 (266,13,79,3,101437,101437,0,0,0,66627,0,299,1506,66328),
 (267,13,79,19,38682,38682,0,0,0,22204,0,134,414,22070),
 (268,13,79,9,86528,86528,0,0,0,57242,0,240,1297,57002),
 (269,13,79,14,87124,87124,0,0,0,53671,0,357,1148,53314),
 (270,13,79,4,120176,120176,0,0,0,80300,0,371,1577,79929),
 (271,13,79,20,104522,104522,0,0,0,62484,0,406,1089,62078),
 (272,13,79,9,86528,86528,0,0,0,57242,0,240,1297,57002),
 (273,14,79,13,182512,182512,0,0,0,105945,0,557,1921,105388),
 (274,14,79,8,165537,165537,0,0,0,105090,0,539,3736,104551),
 (275,14,79,8,165537,165537,0,0,0,105090,0,539,3736,104551),
 (276,14,79,3,175495,175495,0,0,0,70092,0,648,2591,69444),
 (277,14,79,19,38681,38681,0,0,0,22365,0,109,469,22256),
 (278,14,79,3,175495,175495,0,0,0,70092,0,648,2591,69444),
 (279,14,79,19,38681,38681,0,0,0,22365,0,109,469,22256),
 (280,14,79,14,87137,87137,0,0,0,53802,0,349,1613,53453),
 (281,14,79,14,87137,87137,0,0,0,53802,0,349,1613,53453),
 (282,14,79,9,86525,86525,0,0,0,57413,0,272,2234,57141),
 (283,14,79,9,86525,86525,0,0,0,57413,0,272,2234,57141),
 (284,14,79,4,120211,120211,0,0,0,80246,0,429,2841,79817),
 (285,14,79,20,104522,104522,0,0,0,62561,0,382,1302,62179),
 (286,14,79,4,120211,120211,0,0,0,80246,0,429,2841,79817),
 (287,14,79,20,104522,104522,0,0,0,62561,0,382,1302,62179),
 (288,14,79,15,178462,178462,0,0,0,111934,0,547,3339,111387),
 (289,14,79,15,178462,178462,0,0,0,111934,0,547,3339,111387),
 (290,14,79,10,212764,212764,0,0,0,135215,0,868,3650,134347),
 (291,14,79,10,212764,212764,0,0,0,135215,0,868,3650,134347),
 (292,14,79,5,112066,112066,0,0,0,73487,0,299,2903,73188),
 (293,14,79,21,27816,27816,0,0,0,17499,0,87,635,17412),
 (294,14,79,5,112066,112066,0,0,0,73487,0,299,2903,73188),
 (295,14,79,21,27816,27816,0,0,0,17499,0,87,635,17412),
 (296,14,79,16,116178,116178,0,0,0,71086,0,386,2249,70700),
 (297,14,79,16,116178,116178,0,0,0,71086,0,386,2249,70700),
 (298,14,79,11,180008,180008,0,0,0,109167,0,720,2654,108447),
 (299,14,79,11,180008,180008,0,0,0,109167,0,720,2654,108447),
 (300,14,79,6,112466,112466,0,0,0,69549,0,433,1966,69116),
 (301,14,79,6,112466,112466,0,0,0,69549,0,433,1966,69116),
 (302,14,79,1,103317,103317,0,0,0,59576,0,376,1407,59200),
 (303,14,79,17,101126,101126,0,0,0,61852,0,384,1158,61468),
 (304,14,79,1,103317,103317,0,0,0,59576,0,376,1407,59200),
 (305,14,79,17,101126,101126,0,0,0,61852,0,384,1158,61468),
 (306,14,79,12,92876,92876,0,0,0,54646,0,350,1050,54296),
 (307,14,79,12,92876,92876,0,0,0,54646,0,350,1050,54296),
 (308,14,79,7,122603,122603,0,0,0,81610,0,400,2702,81210),
 (309,14,79,7,122603,122603,0,0,0,81610,0,400,2702,81210),
 (310,14,79,2,100531,100531,0,0,0,63526,0,358,1903,63168),
 (311,14,79,18,47463,47463,0,0,0,27429,0,163,698,27266),
 (312,14,79,2,100531,100531,0,0,0,63526,0,358,1903,63168),
 (313,14,79,18,47463,47463,0,0,0,27429,0,163,698,27266),
 (314,14,79,13,182512,182512,0,0,0,105945,0,557,1921,105388),
 (315,15,79,6,111443,111443,0,0,0,82038,0,381,1568,81657),
 (316,15,79,11,177931,177931,0,0,0,128594,0,815,2293,127779),
 (317,15,79,1,102479,102479,0,0,0,69550,0,411,1342,69139),
 (318,15,79,17,100734,100734,0,0,0,72939,0,392,1188,72547),
 (319,15,79,6,111443,111443,0,0,0,82038,0,381,1568,81657),
 (320,15,79,12,92206,92206,0,0,0,64546,0,386,940,64160),
 (321,15,79,1,102479,102479,0,0,0,69550,0,411,1342,69139),
 (322,15,79,17,100734,100734,0,0,0,72939,0,392,1188,72547),
 (323,15,79,7,121179,121179,0,0,0,94139,0,442,1937,93697),
 (324,15,79,12,92206,92206,0,0,0,64546,0,386,940,64160),
 (325,15,79,2,100791,100791,0,0,0,75976,0,397,1572,75579),
 (326,15,79,18,47590,47590,0,0,0,33735,0,201,594,33534),
 (327,15,79,7,121179,121179,0,0,0,94139,0,442,1937,93697),
 (328,15,79,13,181497,181497,0,0,0,126113,0,630,1824,125483),
 (329,15,79,2,100791,100791,0,0,0,75976,0,397,1572,75579),
 (330,15,79,18,47590,47590,0,0,0,33735,0,201,594,33534),
 (331,15,79,8,165330,165330,0,0,0,125762,0,585,3009,125177),
 (332,15,79,13,181497,181497,0,0,0,126113,0,630,1824,125483),
 (333,15,79,3,101164,101164,0,0,0,78892,0,360,1732,78532),
 (334,15,79,19,39366,39366,0,0,0,27785,0,157,508,27628),
 (335,15,79,8,165330,165330,0,0,0,125762,0,585,3009,125177),
 (336,15,79,14,87223,87223,0,0,0,65505,0,345,1388,65160),
 (337,15,79,3,101164,101164,0,0,0,78892,0,360,1732,78532),
 (338,15,79,19,39366,39366,0,0,0,27785,0,157,508,27628),
 (339,15,79,9,86830,86830,0,0,0,67843,0,333,1491,67510),
 (340,15,79,14,87223,87223,0,0,0,65505,0,345,1388,65160),
 (341,15,79,4,119037,119037,0,0,0,92993,0,347,1913,92646),
 (342,15,79,20,106400,106400,0,0,0,77260,0,405,1385,76855),
 (343,15,79,9,86830,86830,0,0,0,67843,0,333,1491,67510),
 (344,15,79,15,177435,177435,0,0,0,133279,0,650,2640,132629),
 (345,15,79,4,119037,119037,0,0,0,92993,0,347,1913,92646),
 (346,15,79,20,106400,106400,0,0,0,77260,0,405,1385,76855),
 (347,15,79,10,210811,210811,0,0,0,157273,0,962,3038,156311),
 (348,15,79,15,177435,177435,0,0,0,133279,0,650,2640,132629),
 (349,15,79,5,110785,110785,0,0,0,87076,0,340,1838,86736),
 (350,15,79,21,28158,28158,0,0,0,21267,0,99,542,21168),
 (351,15,79,10,210811,210811,0,0,0,157273,0,962,3038,156311),
 (352,15,79,16,116297,116297,0,0,0,86321,0,431,1946,85890),
 (353,15,79,5,110785,110785,0,0,0,87076,0,340,1838,86736),
 (354,15,79,21,28158,28158,0,0,0,21267,0,99,542,21168),
 (355,15,79,11,177931,177931,0,0,0,128594,0,815,2293,127779),
 (356,15,79,16,116297,116297,0,0,0,86321,0,431,1946,85890),
 (357,16,79,8,164290,164290,0,0,0,122205,0,490,2447,121715),
 (358,16,79,3,197985,197985,0,0,0,80835,0,542,1442,80293),
 (359,16,79,19,42451,42451,0,0,0,29475,0,134,415,29341),
 (360,16,79,3,197985,197985,0,0,0,80835,0,542,1442,80293),
 (361,16,79,19,42451,42451,0,0,0,29475,0,134,415,29341),
 (362,16,79,14,85652,85652,0,0,0,62841,0,231,964,62610),
 (363,16,79,14,85652,85652,0,0,0,62841,0,231,964,62610),
 (364,16,79,9,88463,88463,0,0,0,67639,0,289,1200,67350),
 (365,16,79,9,88463,88463,0,0,0,67639,0,289,1200,67350),
 (366,16,79,4,144293,144293,0,0,0,87934,0,422,1585,87512),
 (367,16,79,20,110867,110867,0,0,0,79041,0,309,1100,78732),
 (368,16,79,4,144293,144293,0,0,0,87934,0,422,1585,87512),
 (369,16,79,20,110867,110867,0,0,0,79041,0,309,1100,78732),
 (370,16,79,15,173579,173579,0,0,0,126396,0,574,2102,125822),
 (371,16,79,15,173579,173579,0,0,0,126396,0,574,2102,125822),
 (372,16,79,10,200865,200865,0,0,0,146389,0,773,2323,145616),
 (373,16,79,10,200865,200865,0,0,0,146389,0,773,2323,145616),
 (374,16,79,5,108702,108702,0,0,0,83352,0,274,1600,83078),
 (375,16,79,21,30951,30951,0,0,0,22835,0,97,451,22738),
 (376,16,79,5,108702,108702,0,0,0,83352,0,274,1600,83078),
 (377,16,79,21,30951,30951,0,0,0,22835,0,97,451,22738),
 (378,16,79,16,117206,117206,0,0,0,84780,0,314,1468,84466),
 (379,16,79,16,117206,117206,0,0,0,84780,0,314,1468,84466),
 (380,16,79,11,172602,172602,0,0,0,120760,0,482,1762,120278),
 (381,16,79,11,172602,172602,0,0,0,120760,0,482,1762,120278),
 (382,16,79,6,108295,108295,0,0,0,76843,0,312,1216,76531),
 (383,16,79,6,108295,108295,0,0,0,76843,0,312,1216,76531),
 (384,16,79,1,99807,99807,0,0,0,67473,0,283,989,67190),
 (385,16,79,17,99810,99810,0,0,0,69922,0,260,812,69662),
 (386,16,79,1,99807,99807,0,0,0,67473,0,283,989,67190),
 (387,16,79,17,99810,99810,0,0,0,69922,0,260,812,69662),
 (388,16,79,12,91635,91635,0,0,0,62339,0,264,724,62075),
 (389,16,79,12,91635,91635,0,0,0,62339,0,264,724,62075),
 (390,16,79,7,116407,116407,0,0,0,87876,0,390,1622,87486),
 (391,16,79,7,116407,116407,0,0,0,87876,0,390,1622,87486),
 (392,16,79,2,105954,105954,0,0,0,78508,0,368,1300,78140),
 (393,16,79,18,47664,47664,0,0,0,33715,0,188,474,33527),
 (394,16,79,2,105954,105954,0,0,0,78508,0,368,1300,78140),
 (395,16,79,18,47664,47664,0,0,0,33715,0,188,474,33527),
 (396,16,79,13,176850,176850,0,0,0,120455,0,476,1308,119979),
 (397,16,79,13,176850,176850,0,0,0,120455,0,476,1308,119979),
 (398,16,79,8,164290,164290,0,0,0,122205,0,490,2447,121715),
 (399,17,79,1,97895,97895,0,0,0,73182,0,332,1482,72850),
 (400,17,79,17,99367,99367,0,0,0,78670,0,381,1308,78289),
 (401,17,79,6,106525,106525,0,0,0,84007,0,391,1776,83616),
 (402,17,79,12,91725,91725,0,0,0,71059,0,352,1144,70707),
 (403,17,79,1,97895,97895,0,0,0,73182,0,332,1482,72850),
 (404,17,79,17,99367,99367,0,0,0,78670,0,381,1308,78289),
 (405,17,79,7,114685,114685,0,0,0,94386,0,390,2100,93996),
 (406,17,79,12,91725,91725,0,0,0,71059,0,352,1144,70707),
 (407,17,79,2,105379,105379,0,0,0,86398,0,461,2045,85937),
 (408,17,79,18,47360,47360,0,0,0,37887,0,231,861,37656),
 (409,17,79,7,114685,114685,0,0,0,94386,0,390,2100,93996),
 (410,17,79,13,174915,174915,0,0,0,136106,0,607,2066,135499),
 (411,17,79,2,105379,105379,0,0,0,86398,0,461,2045,85937),
 (412,17,79,18,47360,47360,0,0,0,37887,0,231,861,37656),
 (413,17,79,8,161936,161936,0,0,0,134060,0,586,3267,133474),
 (414,17,79,13,174915,174915,0,0,0,136106,0,607,2066,135499),
 (415,17,79,3,99426,99426,0,0,0,83422,0,379,2137,83043),
 (416,17,79,19,43809,43809,0,0,0,34657,0,154,789,34503),
 (417,17,79,8,161936,161936,0,0,0,134060,0,586,3267,133474),
 (418,17,79,14,84342,84342,0,0,0,69083,0,358,1535,68725),
 (419,17,79,3,99426,99426,0,0,0,83422,0,379,2137,83043),
 (420,17,79,19,43809,43809,0,0,0,34657,0,154,789,34503),
 (421,17,79,9,87897,87897,0,0,0,73303,0,338,1789,72965),
 (422,17,79,14,84342,84342,0,0,0,69083,0,358,1535,68725),
 (423,17,79,4,114317,114317,0,0,0,94652,0,368,2045,94284),
 (424,17,79,20,110677,110677,0,0,0,88975,0,383,1802,88592),
 (425,17,79,9,87897,87897,0,0,0,73303,0,338,1789,72965),
 (426,17,79,15,170777,170777,0,0,0,138929,0,639,3129,138290),
 (427,17,79,4,114317,114317,0,0,0,94652,0,368,2045,94284),
 (428,17,79,20,110677,110677,0,0,0,88975,0,383,1802,88592),
 (429,17,79,10,198073,198073,0,0,0,160782,0,954,3328,159828),
 (430,17,79,15,170777,170777,0,0,0,138929,0,639,3129,138290),
 (431,17,79,5,106702,106702,0,0,0,89324,0,329,2055,88995),
 (432,17,79,21,30863,30863,0,0,0,25404,0,106,688,25298),
 (433,17,79,10,198073,198073,0,0,0,160782,0,954,3328,159828),
 (434,17,79,16,115978,115978,0,0,0,94822,0,464,2212,94358),
 (435,17,79,5,106702,106702,0,0,0,89324,0,329,2055,88995),
 (436,17,79,21,30863,30863,0,0,0,25404,0,106,688,25298),
 (437,17,79,11,170053,170053,0,0,0,133917,0,745,2656,133172),
 (438,17,79,16,115978,115978,0,0,0,94822,0,464,2212,94358),
 (439,17,79,6,106525,106525,0,0,0,84007,0,391,1776,83616),
 (440,17,79,11,170053,170053,0,0,0,133917,0,745,2656,133172),
 (441,18,79,3,204193,204193,0,0,0,77762,0,671,1690,77091),
 (442,18,79,19,45240,45240,0,0,0,30363,0,146,603,30217),
 (443,18,79,14,79307,79307,0,0,0,56018,0,282,1033,55736),
 (444,18,79,14,79307,79307,0,0,0,56018,0,282,1033,55736),
 (445,18,79,9,85612,85612,0,0,0,63671,0,297,1567,63374),
 (446,18,79,9,85612,85612,0,0,0,63671,0,297,1567,63374),
 (447,18,79,4,134297,134297,0,0,0,82348,0,527,1702,81821),
 (448,18,79,20,108905,108905,0,0,0,72897,0,343,1313,72554),
 (449,18,79,4,134297,134297,0,0,0,82348,0,527,1702,81821),
 (450,18,79,20,108905,108905,0,0,0,72897,0,343,1313,72554),
 (451,18,79,15,160911,160911,0,0,0,113537,0,516,2164,113021),
 (452,18,79,15,160911,160911,0,0,0,113537,0,516,2164,113021),
 (453,18,79,10,183916,183916,0,0,0,129262,0,761,2364,128501),
 (454,18,79,10,183916,183916,0,0,0,129262,0,761,2364,128501),
 (455,18,79,5,107821,107821,0,0,0,80706,0,345,1906,80361),
 (456,18,79,21,31664,31664,0,0,0,22298,0,114,500,22184),
 (457,18,79,5,107821,107821,0,0,0,80706,0,345,1906,80361),
 (458,18,79,21,31664,31664,0,0,0,22298,0,114,500,22184),
 (459,18,79,16,119205,119205,0,0,0,84624,0,426,1874,84198),
 (460,18,79,16,119205,119205,0,0,0,84624,0,426,1874,84198),
 (461,18,79,11,166247,166247,0,0,0,110709,0,600,2005,110109),
 (462,18,79,11,166247,166247,0,0,0,110709,0,600,2005,110109),
 (463,18,79,6,105756,105756,0,0,0,71062,0,387,1444,70675),
 (464,18,79,6,105756,105756,0,0,0,71062,0,387,1444,70675),
 (465,18,79,1,94164,94164,0,0,0,59966,0,317,1283,59649),
 (466,18,79,17,95140,95140,0,0,0,62348,0,305,1046,62043),
 (467,18,79,1,94164,94164,0,0,0,59966,0,317,1283,59649),
 (468,18,79,17,95140,95140,0,0,0,62348,0,305,1046,62043),
 (469,18,79,12,89143,89143,0,0,0,56406,0,239,904,56167),
 (470,18,79,12,89143,89143,0,0,0,56406,0,239,904,56167),
 (471,18,79,7,109931,109931,0,0,0,80623,0,362,1779,80261),
 (472,18,79,7,109931,109931,0,0,0,80623,0,362,1779,80261),
 (473,18,79,2,108304,108304,0,0,0,77715,0,438,1778,77277),
 (474,18,79,18,46895,46895,0,0,0,31073,0,120,550,30953),
 (475,18,79,2,108304,108304,0,0,0,77715,0,438,1778,77277),
 (476,18,79,18,46895,46895,0,0,0,31073,0,120,550,30953),
 (477,18,79,13,165732,165732,0,0,0,104349,0,512,1482,103837),
 (478,18,79,13,165732,165732,0,0,0,104349,0,512,1482,103837),
 (479,18,79,8,163072,163072,0,0,0,117665,0,663,3079,117002),
 (480,18,79,8,163072,163072,0,0,0,117665,0,663,3079,117002),
 (481,18,79,3,204193,204193,0,0,0,77762,0,671,1690,77091),
 (482,18,79,19,45240,45240,0,0,0,30363,0,146,603,30217),
 (483,19,79,17,93835,93835,0,0,0,73598,0,441,711,73157),
 (484,19,79,12,88394,88394,0,0,0,67371,0,378,604,66993),
 (485,19,79,1,92296,92296,0,0,0,69779,0,464,584,69315),
 (486,19,79,7,108808,108808,0,0,0,90203,0,334,814,89869),
 (487,19,79,12,88394,88394,0,0,0,67371,0,378,604,66993),
 (488,19,79,2,108798,108798,0,0,0,89559,0,429,906,89130),
 (489,19,79,18,48817,48817,0,0,0,38579,0,214,397,38365),
 (490,19,79,7,108808,108808,0,0,0,90203,0,334,814,89869),
 (491,19,79,18,48817,48817,0,0,0,38579,0,214,397,38365),
 (492,19,79,13,164035,164035,0,0,0,124384,0,618,953,123766),
 (493,19,79,2,108798,108798,0,0,0,89559,0,429,906,89130),
 (494,19,79,8,164360,164360,0,0,0,136420,0,506,1405,135914),
 (495,19,79,13,164035,164035,0,0,0,124384,0,618,953,123766),
 (496,19,79,3,96266,96266,0,0,0,81475,0,258,804,81217),
 (497,19,79,19,45273,45273,0,0,0,36085,0,149,373,35936),
 (498,19,79,8,164360,164360,0,0,0,136420,0,506,1405,135914),
 (499,19,79,19,45273,45273,0,0,0,36085,0,149,373,35936),
 (500,19,79,14,78295,78295,0,0,0,63987,0,288,623,63699),
 (501,19,79,3,96266,96266,0,0,0,81475,0,258,804,81217),
 (502,19,79,9,84841,84841,0,0,0,71212,0,308,645,70904),
 (503,19,79,14,78295,78295,0,0,0,63987,0,288,623,63699),
 (504,19,79,4,109707,109707,0,0,0,91188,0,323,819,90865),
 (505,19,79,20,108877,108877,0,0,0,86524,0,404,909,86120),
 (506,19,79,9,84841,84841,0,0,0,71212,0,308,645,70904),
 (507,19,79,20,108877,108877,0,0,0,86524,0,404,909,86120),
 (508,19,79,15,159201,159201,0,0,0,129830,0,582,1261,129248),
 (509,19,79,4,109707,109707,0,0,0,91188,0,323,819,90865),
 (510,19,79,10,181476,181476,0,0,0,146531,0,958,1390,145573),
 (511,19,79,15,159201,159201,0,0,0,129830,0,582,1261,129248),
 (512,19,79,5,107157,107157,0,0,0,90554,0,345,850,90209),
 (513,19,79,21,31366,31366,0,0,0,25969,0,100,294,25869),
 (514,19,79,10,181476,181476,0,0,0,146531,0,958,1390,145573),
 (515,19,79,21,31366,31366,0,0,0,25969,0,100,294,25869),
 (516,19,79,16,120798,120798,0,0,0,99497,0,395,1023,99102),
 (517,19,79,5,107157,107157,0,0,0,90554,0,345,850,90209),
 (518,19,79,11,165067,165067,0,0,0,130028,0,793,1267,129235),
 (519,19,79,16,120798,120798,0,0,0,99497,0,395,1023,99102),
 (520,19,79,6,105014,105014,0,0,0,82526,0,495,777,82031),
 (521,19,79,11,165067,165067,0,0,0,130028,0,793,1267,129235),
 (522,19,79,1,92296,92296,0,0,0,69779,0,464,584,69315),
 (523,19,79,17,93835,93835,0,0,0,73598,0,441,711,73157),
 (524,19,79,6,105014,105014,0,0,0,82526,0,495,777,82031),
 (525,20,79,5,108827,108827,0,0,0,66090,0,225,825,65865),
 (526,20,79,21,31796,31796,0,0,0,17715,0,68,236,17647),
 (527,20,79,10,179798,179798,0,0,0,95645,0,425,1024,95220),
 (528,20,79,16,123523,123523,0,0,0,67036,0,313,812,66723),
 (529,20,79,5,108827,108827,0,0,0,66090,0,225,825,65865),
 (530,20,79,21,31796,31796,0,0,0,17715,0,68,236,17647),
 (531,20,79,11,165562,165562,0,0,0,82683,0,353,824,82330),
 (532,20,79,16,123523,123523,0,0,0,67036,0,313,812,66723),
 (533,20,79,6,106084,106084,0,0,0,55578,0,307,620,55271),
 (534,20,79,11,165562,165562,0,0,0,82683,0,353,824,82330),
 (535,20,79,1,93907,93907,0,0,0,46219,0,242,538,45977),
 (536,20,79,17,93305,93305,0,0,0,46039,0,223,471,45816),
 (537,20,79,6,106084,106084,0,0,0,55578,0,307,620,55271),
 (538,20,79,12,88127,88127,0,0,0,40871,0,225,390,40646),
 (539,20,79,1,93907,93907,0,0,0,46219,0,242,538,45977),
 (540,20,79,17,93305,93305,0,0,0,46039,0,223,471,45816),
 (541,20,79,7,109218,109218,0,0,0,65477,0,245,790,65232),
 (542,20,79,12,88127,88127,0,0,0,40871,0,225,390,40646),
 (543,20,79,2,110587,110587,0,0,0,61671,0,298,790,61373),
 (544,20,79,18,55104,55104,0,0,0,26632,0,113,349,26519),
 (545,20,79,7,109218,109218,0,0,0,65477,0,245,790,65232),
 (546,20,79,13,163100,163100,0,0,0,75850,0,408,695,75442),
 (547,20,79,2,110587,110587,0,0,0,61671,0,298,790,61373),
 (548,20,79,18,55104,55104,0,0,0,26632,0,113,349,26519),
 (549,20,79,8,168200,168200,0,0,0,95424,0,356,1223,95068),
 (550,20,79,13,163100,163100,0,0,0,75850,0,408,695,75442),
 (551,20,79,3,96228,96228,0,0,0,57707,0,286,695,57421),
 (552,20,79,19,45870,45870,0,0,0,23031,0,98,303,22933),
 (553,20,79,8,168200,168200,0,0,0,95424,0,356,1223,95068),
 (554,20,79,14,77571,77571,0,0,0,42666,0,169,485,42497),
 (555,20,79,3,96228,96228,0,0,0,57707,0,286,695,57421),
 (556,20,79,19,45870,45870,0,0,0,23031,0,98,303,22933),
 (557,20,79,9,85464,85464,0,0,0,50961,0,210,605,50751),
 (558,20,79,14,77571,77571,0,0,0,42666,0,169,485,42497),
 (559,20,79,4,110586,110586,0,0,0,66519,0,238,737,66281),
 (560,20,79,20,109479,109479,0,0,0,55177,0,217,612,54960),
 (561,20,79,9,85464,85464,0,0,0,50961,0,210,605,50751),
 (562,20,79,15,159667,159667,0,0,0,88264,0,419,993,87845),
 (563,20,79,4,110586,110586,0,0,0,66519,0,238,737,66281),
 (564,20,79,20,109479,109479,0,0,0,55177,0,217,612,54960),
 (565,20,79,10,179798,179798,0,0,0,95645,0,425,1024,95220),
 (566,20,79,15,159667,159667,0,0,0,88264,0,419,993,87845),
 (567,21,79,14,76542,76542,0,0,0,52753,0,890,1406,51863),
 (568,21,79,9,86087,86087,0,0,0,62017,0,1140,1880,60877),
 (569,21,79,9,86087,86087,0,0,0,62017,0,1140,1880,60877),
 (570,21,79,4,111779,111779,0,0,0,79487,0,1260,2388,78227),
 (571,21,79,20,110645,110645,0,0,0,71872,0,1218,2059,70654),
 (572,21,79,4,111779,111779,0,0,0,79487,0,1260,2388,78227),
 (573,21,79,20,110645,110645,0,0,0,71872,0,1218,2059,70654),
 (574,21,79,15,159830,159830,0,0,0,108342,0,1864,2974,106478),
 (575,21,79,15,159830,159830,0,0,0,108342,0,1864,2974,106478),
 (576,21,79,10,177627,177627,0,0,0,120440,0,2214,2757,118226),
 (577,21,79,10,177627,177627,0,0,0,120440,0,2214,2757,118226),
 (578,21,79,5,109852,109852,0,0,0,79526,0,1252,2521,78274),
 (579,21,79,21,32741,32741,0,0,0,22706,0,444,688,22262),
 (580,21,79,5,109852,109852,0,0,0,79526,0,1252,2521,78274),
 (581,21,79,21,32741,32741,0,0,0,22706,0,444,688,22262),
 (582,21,79,16,126148,126148,0,0,0,86678,0,1551,2657,85127),
 (583,21,79,16,126148,126148,0,0,0,86678,0,1551,2657,85127),
 (584,21,79,11,166717,166717,0,0,0,107559,0,1984,2620,105575),
 (585,21,79,11,166717,166717,0,0,0,107559,0,1984,2620,105575),
 (586,21,79,6,107560,107560,0,0,0,69340,0,1249,2031,68091),
 (587,21,79,6,107560,107560,0,0,0,69340,0,1249,2031,68091),
 (588,21,79,1,95737,95737,0,0,0,59479,0,1554,1603,57925),
 (589,21,79,17,94102,94102,0,0,0,59749,0,1078,1497,58671),
 (590,21,79,1,95737,95737,0,0,0,59479,0,1554,1603,57925),
 (591,21,79,17,94102,94102,0,0,0,59749,0,1078,1497,58671),
 (592,21,79,12,88458,88458,0,0,0,53156,0,926,1313,52230),
 (593,21,79,12,88458,88458,0,0,0,53156,0,926,1313,52230),
 (594,21,79,7,109407,109407,0,0,0,77848,0,1427,2488,76421),
 (595,21,79,7,109407,109407,0,0,0,77848,0,1427,2488,76421),
 (596,21,79,2,113448,113448,0,0,0,79779,0,1751,2317,78028),
 (597,21,79,18,63378,63378,0,0,0,40435,0,740,1199,39695),
 (598,21,79,2,113448,113448,0,0,0,79779,0,1751,2317,78028),
 (599,21,79,18,63378,63378,0,0,0,40435,0,740,1199,39695),
 (600,21,79,13,163435,163435,0,0,0,97496,0,1632,2292,95864),
 (601,21,79,13,163435,163435,0,0,0,97496,0,1632,2292,95864),
 (602,21,79,8,172111,172111,0,0,0,121657,0,2153,3665,119504),
 (603,21,79,8,172111,172111,0,0,0,121657,0,2153,3665,119504),
 (604,21,79,3,96238,96238,0,0,0,70572,0,1309,2089,69263),
 (605,21,79,19,46518,46518,0,0,0,30722,0,603,848,30119),
 (606,21,79,3,96238,96238,0,0,0,70572,0,1309,2089,69263),
 (607,21,79,19,46518,46518,0,0,0,30722,0,603,848,30119),
 (608,21,79,14,76542,76542,0,0,0,52753,0,890,1406,51863),
 (609,22,79,12,87948,87948,0,0,0,60412,0,665,601,59747),
 (610,22,79,7,107974,107974,0,0,0,84600,0,653,862,83947),
 (611,22,79,7,107974,107974,0,0,0,84600,0,653,862,83947),
 (612,22,79,2,112682,112682,0,0,0,87125,0,948,962,86177),
 (613,22,79,18,63991,63991,0,0,0,46980,0,585,567,46395),
 (614,22,79,2,112682,112682,0,0,0,87125,0,948,962,86177),
 (615,22,79,18,63991,63991,0,0,0,46980,0,585,567,46395),
 (616,22,79,13,162379,162379,0,0,0,111074,0,1244,1025,109830),
 (617,22,79,13,162379,162379,0,0,0,111074,0,1244,1025,109830),
 (618,22,79,8,171856,171856,0,0,0,135459,0,1151,1435,134308),
 (619,22,79,8,171856,171856,0,0,0,135459,0,1151,1435,134308),
 (620,22,79,3,95355,95355,0,0,0,76563,0,612,811,75951),
 (621,22,79,19,46381,46381,0,0,0,34857,0,369,387,34488),
 (622,22,79,3,95355,95355,0,0,0,76563,0,612,811,75951),
 (623,22,79,19,46381,46381,0,0,0,34857,0,369,387,34488),
 (624,22,79,14,76070,76070,0,0,0,58161,0,557,615,57604),
 (625,22,79,14,76070,76070,0,0,0,58161,0,557,615,57604),
 (626,22,79,9,85080,85080,0,0,0,67376,0,566,689,66810),
 (627,22,79,9,85080,85080,0,0,0,67376,0,566,689,66810),
 (628,22,79,4,110273,110273,0,0,0,86771,0,554,843,86217),
 (629,22,79,20,110177,110177,0,0,0,81634,0,798,801,80836),
 (630,22,79,4,110273,110273,0,0,0,86771,0,554,843,86217),
 (631,22,79,20,110177,110177,0,0,0,81634,0,798,801,80836),
 (632,22,79,15,158503,158503,0,0,0,119804,0,1099,1132,118705),
 (633,22,79,15,158503,158503,0,0,0,119804,0,1099,1132,118705),
 (634,22,79,10,175800,175800,0,0,0,132650,0,1436,1230,131214),
 (635,22,79,10,175800,175800,0,0,0,132650,0,1436,1230,131214),
 (636,22,79,5,108630,108630,0,0,0,86799,0,601,823,86198),
 (637,22,79,21,32441,32441,0,0,0,25454,0,271,268,25183),
 (638,22,79,5,108630,108630,0,0,0,86799,0,601,823,86198),
 (639,22,79,21,32441,32441,0,0,0,25454,0,271,268,25183),
 (640,22,79,16,125380,125380,0,0,0,96932,0,952,1056,95980),
 (641,22,79,16,125380,125380,0,0,0,96932,0,952,1056,95980),
 (642,22,79,11,165641,165641,0,0,0,119605,0,1313,1195,118292),
 (643,22,79,11,165641,165641,0,0,0,119605,0,1313,1195,118292),
 (644,22,79,6,106442,106442,0,0,0,77419,0,671,724,76748),
 (645,22,79,6,106442,106442,0,0,0,77419,0,671,724,76748),
 (646,22,79,1,93869,93869,0,0,0,64786,0,765,591,64021),
 (647,22,79,17,93626,93626,0,0,0,67376,0,717,725,66659),
 (648,22,79,1,93869,93869,0,0,0,64786,0,765,591,64021),
 (649,22,79,17,93626,93626,0,0,0,67376,0,717,725,66659),
 (650,22,79,12,87948,87948,0,0,0,60412,0,665,601,59747),
 (651,23,79,16,128925,128925,0,0,0,65145,0,831,1335,64314),
 (652,23,79,5,111911,111911,0,0,0,61907,0,522,1338,61385),
 (653,23,79,21,33561,33561,0,0,0,17365,0,212,397,17153),
 (654,23,79,11,170329,170329,0,0,0,77939,0,1213,1250,76726),
 (655,23,79,16,128925,128925,0,0,0,65145,0,831,1335,64314),
 (656,23,79,6,110540,110540,0,0,0,52502,0,643,897,51859),
 (657,23,79,11,170329,170329,0,0,0,77939,0,1213,1250,76726),
 (658,23,79,1,97711,97711,0,0,0,46815,0,418,683,46397),
 (659,23,79,17,96625,96625,0,0,0,44456,0,688,735,43768),
 (660,23,79,6,110540,110540,0,0,0,52502,0,643,897,51859),
 (661,23,79,12,90045,90045,0,0,0,38155,0,556,581,37599),
 (662,23,79,1,97711,97711,0,0,0,46815,0,418,683,46397),
 (663,23,79,17,96625,96625,0,0,0,44456,0,688,735,43768),
 (664,23,79,7,109904,109904,0,0,0,61009,0,574,1235,60435),
 (665,23,79,12,90045,90045,0,0,0,38155,0,556,581,37599),
 (666,23,79,2,117395,117395,0,0,0,62823,0,859,1172,61964),
 (667,23,79,18,70306,70306,0,0,0,32777,0,542,629,32235),
 (668,23,79,7,109904,109904,0,0,0,61009,0,574,1235,60435),
 (669,23,79,13,164953,164953,0,0,0,73349,0,936,1020,72413),
 (670,23,79,2,117395,117395,0,0,0,62823,0,859,1172,61964),
 (671,23,79,18,70306,70306,0,0,0,32777,0,542,629,32235),
 (672,23,79,8,176738,176738,0,0,0,93160,0,1112,1960,92048),
 (673,23,79,13,164953,164953,0,0,0,73349,0,936,1020,72413),
 (674,23,79,3,96388,96388,0,0,0,54281,0,579,1123,53702),
 (675,23,79,19,47860,47860,0,0,0,23818,0,359,430,23459),
 (676,23,79,8,176738,176738,0,0,0,93160,0,1112,1960,92048),
 (677,23,79,14,76136,76136,0,0,0,39533,0,535,668,38998),
 (678,23,79,3,96388,96388,0,0,0,54281,0,579,1123,53702),
 (679,23,79,19,47860,47860,0,0,0,23818,0,359,430,23459),
 (680,23,79,9,86935,86935,0,0,0,48227,0,460,951,47767),
 (681,23,79,14,76136,76136,0,0,0,39533,0,535,668,38998),
 (682,23,79,4,112645,112645,0,0,0,61161,0,585,1234,60576),
 (683,23,79,20,113037,113037,0,0,0,53177,0,905,971,52272),
 (684,23,79,9,86935,86935,0,0,0,48227,0,460,951,47767),
 (685,23,79,15,161474,161474,0,0,0,80497,0,1006,1480,79491),
 (686,23,79,4,112645,112645,0,0,0,61161,0,585,1234,60576),
 (687,23,79,20,113037,113037,0,0,0,53177,0,905,971,52272),
 (688,23,79,10,177280,177280,0,0,0,88060,0,1293,1333,86767),
 (689,23,79,15,161474,161474,0,0,0,80497,0,1006,1480,79491),
 (690,23,79,5,111911,111911,0,0,0,61907,0,522,1338,61385),
 (691,23,79,21,33561,33561,0,0,0,17365,0,212,397,17153),
 (692,23,79,10,177280,177280,0,0,0,88060,0,1293,1333,86767),
 (693,24,79,4,114076,114076,0,0,0,81726,0,478,808,81248),
 (694,24,79,20,114457,114457,0,0,0,77289,0,665,767,76624),
 (695,24,79,4,114076,114076,0,0,0,81726,0,478,808,81248),
 (696,24,79,15,163671,163671,0,0,0,111411,0,843,1098,110568),
 (697,24,79,10,178849,178849,0,0,0,122660,0,1130,1122,121530),
 (698,24,79,5,113006,113006,0,0,0,83087,0,449,849,82638),
 (699,24,79,21,34282,34282,0,0,0,24928,0,198,256,24730),
 (700,24,79,5,113006,113006,0,0,0,83087,0,449,849,82638),
 (701,24,79,16,132439,132439,0,0,0,94324,0,701,1017,93623),
 (702,24,79,11,173328,173328,0,0,0,111053,0,975,1009,110078),
 (703,24,79,6,112560,112560,0,0,0,73292,0,506,737,72786),
 (704,24,79,1,99103,99103,0,0,0,65249,0,334,433,64915),
 (705,24,79,17,98449,98449,0,0,0,63151,0,618,592,62533),
 (706,24,79,1,99103,99103,0,0,0,65249,0,334,433,64915),
 (707,24,79,12,91723,91723,0,0,0,56492,0,483,467,56009),
 (708,24,79,7,111126,111126,0,0,0,80635,0,515,784,80120),
 (709,24,79,2,119204,119204,0,0,0,86972,0,575,763,86397),
 (710,24,79,18,72132,72132,0,0,0,49286,0,427,454,48859),
 (711,24,79,2,119204,119204,0,0,0,86972,0,575,763,86397),
 (712,24,79,13,167308,167308,0,0,0,105921,0,826,894,105095),
 (713,24,79,8,179096,179096,0,0,0,129905,0,879,1477,129026),
 (714,24,79,3,97151,97151,0,0,0,72652,0,418,753,72234),
 (715,24,79,19,48694,48694,0,0,0,33948,0,261,370,33687),
 (716,24,79,3,97151,97151,0,0,0,72652,0,418,753,72234),
 (717,24,79,14,76481,76481,0,0,0,54574,0,390,523,54184),
 (718,24,79,9,88985,88985,0,0,0,65538,0,380,652,65158),
 (719,25,79,7,109796,109796,0,0,0,88173,0,348,450,87825),
 (720,25,79,2,118609,118609,0,0,0,95093,0,496,451,94597),
 (721,25,79,18,72600,72600,0,0,0,55424,0,330,305,55094),
 (722,25,79,2,118609,118609,0,0,0,95093,0,496,451,94597),
 (723,25,79,18,72600,72600,0,0,0,55424,0,330,305,55094),
 (724,25,79,13,166541,166541,0,0,0,116898,0,762,502,116136),
 (725,25,79,13,166541,166541,0,0,0,116898,0,762,502,116136),
 (726,25,79,8,178680,178680,0,0,0,144625,0,732,727,143893),
 (727,25,79,8,178680,178680,0,0,0,144625,0,732,727,143893),
 (728,25,79,3,96295,96295,0,0,0,79289,0,318,393,78971),
 (729,25,79,19,48615,48615,0,0,0,37892,0,284,203,37608),
 (730,25,79,3,96295,96295,0,0,0,79289,0,318,393,78971),
 (731,25,79,19,48615,48615,0,0,0,37892,0,284,203,37608),
 (732,25,79,14,75883,75883,0,0,0,59573,0,315,283,59258),
 (733,25,79,14,75883,75883,0,0,0,59573,0,315,283,59258),
 (734,25,79,9,88453,88453,0,0,0,71926,0,324,331,71602),
 (735,25,79,9,88453,88453,0,0,0,71926,0,324,331,71602),
 (736,25,79,4,112517,112517,0,0,0,89967,0,398,420,89569),
 (737,25,79,20,114157,114157,0,0,0,86668,0,496,446,86172),
 (738,25,79,4,112517,112517,0,0,0,89967,0,398,420,89569),
 (739,25,79,20,114157,114157,0,0,0,86668,0,496,446,86172),
 (740,25,79,15,162189,162189,0,0,0,123210,0,743,654,122467),
 (741,25,79,15,162189,162189,0,0,0,123210,0,743,654,122467),
 (742,25,79,10,177523,177523,0,0,0,134467,0,984,687,133483),
 (743,25,79,10,177523,177523,0,0,0,134467,0,984,687,133483),
 (744,25,79,5,111785,111785,0,0,0,91414,0,366,421,91048),
 (745,25,79,21,34044,34044,0,0,0,27819,0,154,147,27665),
 (746,25,79,5,111785,111785,0,0,0,91414,0,366,421,91048),
 (747,25,79,21,34044,34044,0,0,0,27819,0,154,147,27665),
 (748,25,79,16,132156,132156,0,0,0,106096,0,493,553,105603),
 (749,25,79,16,132156,132156,0,0,0,106096,0,493,553,105603),
 (750,25,79,11,172740,172740,0,0,0,124029,0,945,671,123084),
 (751,25,79,11,172740,172740,0,0,0,124029,0,945,671,123084),
 (752,25,79,6,111855,111855,0,0,0,81776,0,466,452,81310),
 (753,25,79,6,111855,111855,0,0,0,81776,0,466,452,81310),
 (754,25,79,1,97365,97365,0,0,0,70724,0,327,305,70397),
 (755,25,79,17,98164,98164,0,0,0,70492,0,541,366,69951),
 (756,25,79,1,97365,97365,0,0,0,70724,0,327,305,70397),
 (757,25,79,17,98164,98164,0,0,0,70492,0,541,366,69951),
 (758,25,79,12,91360,91360,0,0,0,62940,0,411,300,62529),
 (759,25,79,12,91360,91360,0,0,0,62940,0,411,300,62529),
 (760,25,79,7,109796,109796,0,0,0,88173,0,348,450,87825),
 (761,26,79,2,118554,118554,0,0,0,91594,0,507,468,91087),
 (762,26,79,18,72965,72965,0,0,0,52829,0,429,280,52400),
 (763,26,79,13,165306,165306,0,0,0,110006,0,757,592,109249),
 (764,26,79,13,165306,165306,0,0,0,110006,0,757,592,109249),
 (765,26,79,8,178259,178259,0,0,0,139149,0,703,680,138446),
 (766,26,79,8,178259,178259,0,0,0,139149,0,703,680,138446),
 (767,26,79,3,96058,96058,0,0,0,76821,0,385,365,76436),
 (768,26,79,19,48590,48590,0,0,0,35911,0,243,218,35668),
 (769,26,79,3,96058,96058,0,0,0,76821,0,385,365,76436),
 (770,26,79,19,48590,48590,0,0,0,35911,0,243,218,35668),
 (771,26,79,14,75412,75412,0,0,0,56547,0,313,292,56234),
 (772,26,79,14,75412,75412,0,0,0,56547,0,313,292,56234),
 (773,26,79,9,88151,88151,0,0,0,70029,0,337,328,69692),
 (774,26,79,9,88151,88151,0,0,0,70029,0,337,328,69692),
 (775,26,79,4,112053,112053,0,0,0,88117,0,415,389,87702),
 (776,26,79,20,113755,113755,0,0,0,82330,0,554,427,81776),
 (777,26,79,4,112053,112053,0,0,0,88117,0,415,389,87702),
 (778,26,79,20,113755,113755,0,0,0,82330,0,554,427,81776),
 (779,26,79,15,161127,161127,0,0,0,118203,0,730,612,117473),
 (780,26,79,15,161127,161127,0,0,0,118203,0,730,612,117473),
 (781,26,79,10,176464,176464,0,0,0,127801,0,993,676,126808),
 (782,26,79,10,176464,176464,0,0,0,127801,0,993,676,126808),
 (783,26,79,5,111444,111444,0,0,0,89544,0,376,409,89168),
 (784,26,79,21,34098,34098,0,0,0,26709,0,153,127,26556),
 (785,26,79,5,111444,111444,0,0,0,89544,0,376,409,89168),
 (786,26,79,21,34098,34098,0,0,0,26709,0,153,127,26556),
 (787,26,79,16,132616,132616,0,0,0,102121,0,549,489,101572),
 (788,26,79,16,132616,132616,0,0,0,102121,0,549,489,101572),
 (789,26,79,11,171403,171403,0,0,0,117000,0,981,625,116019),
 (790,26,79,11,171403,171403,0,0,0,117000,0,981,625,116019),
 (791,26,79,6,111397,111397,0,0,0,79115,0,450,430,78665),
 (792,26,79,6,111397,111397,0,0,0,79115,0,450,430,78665),
 (793,26,79,1,96833,96833,0,0,0,68405,0,336,339,68069),
 (794,26,79,17,97466,97466,0,0,0,66073,0,508,358,65565),
 (795,26,79,1,96833,96833,0,0,0,68405,0,336,339,68069),
 (796,26,79,17,97466,97466,0,0,0,66073,0,508,358,65565),
 (797,26,79,12,90703,90703,0,0,0,59342,0,426,306,58916),
 (798,26,79,12,90703,90703,0,0,0,59342,0,426,306,58916),
 (799,26,79,7,109384,109384,0,0,0,86278,0,425,449,85853),
 (800,26,79,7,109384,109384,0,0,0,86278,0,425,449,85853),
 (801,26,79,2,118554,118554,0,0,0,91594,0,507,468,91087),
 (802,26,79,18,72965,72965,0,0,0,52829,0,429,280,52400),
 (803,27,79,10,197295,197295,0,0,0,104485,0,250,758,104235),
 (804,27,79,15,170675,170675,0,0,0,93732,0,196,707,93536),
 (805,27,79,5,107085,107085,0,0,0,66976,0,111,524,66865),
 (806,27,79,21,31093,31093,0,0,0,16499,0,21,173,16478),
 (807,27,79,10,197295,197295,0,0,0,104485,0,250,758,104235),
 (808,27,79,16,116376,116376,0,0,0,61287,0,109,484,61178),
 (809,27,79,5,107085,107085,0,0,0,66976,0,111,524,66865),
 (810,27,79,21,31093,31093,0,0,0,16499,0,21,173,16478),
 (811,27,79,11,169791,169791,0,0,0,83419,0,201,581,83218),
 (812,27,79,16,116376,116376,0,0,0,61287,0,109,484,61178),
 (813,27,79,6,106415,106415,0,0,0,57008,0,126,453,56882),
 (814,27,79,11,169791,169791,0,0,0,83419,0,201,581,83218),
 (815,27,79,1,98536,98536,0,0,0,50175,0,83,395,50092),
 (816,27,79,17,99370,99370,0,0,0,46980,0,91,271,46889),
 (817,27,79,6,106415,106415,0,0,0,57008,0,126,453,56882),
 (818,27,79,12,91780,91780,0,0,0,42203,0,89,218,42114),
 (819,27,79,1,98536,98536,0,0,0,50175,0,83,395,50092),
 (820,27,79,17,99370,99370,0,0,0,46980,0,91,271,46889),
 (821,27,79,7,114791,114791,0,0,0,70845,0,104,537,70741),
 (822,27,79,12,91780,91780,0,0,0,42203,0,89,218,42114),
 (823,27,79,2,105791,105791,0,0,0,59405,0,137,493,59268),
 (824,27,79,18,47511,47511,0,0,0,22522,0,34,163,22488),
 (825,27,79,7,114791,114791,0,0,0,70845,0,104,537,70741),
 (826,27,79,13,174464,174464,0,0,0,81385,0,147,413,81238),
 (827,27,79,2,105791,105791,0,0,0,59405,0,137,493,59268),
 (828,27,79,18,47511,47511,0,0,0,22522,0,34,163,22488),
 (829,27,79,8,162017,162017,0,0,0,90084,0,117,779,89967),
 (830,27,79,13,174464,174464,0,0,0,81385,0,147,413,81238),
 (831,27,79,3,99374,99374,0,0,0,60454,0,83,502,60371),
 (832,27,79,19,44204,44204,0,0,0,20384,0,27,168,20357),
 (833,27,79,8,162017,162017,0,0,0,90084,0,117,779,89967),
 (834,27,79,14,84157,84157,0,0,0,45356,0,93,345,45263),
 (835,27,79,3,99374,99374,0,0,0,60454,0,83,502,60371),
 (836,27,79,19,44204,44204,0,0,0,20384,0,27,168,20357),
 (837,27,79,9,88151,88151,0,0,0,53806,0,99,424,53707),
 (838,27,79,14,84157,84157,0,0,0,45356,0,93,345,45263),
 (839,27,79,4,114642,114642,0,0,0,70577,0,126,526,70451),
 (840,27,79,20,110934,110934,0,0,0,54014,0,93,353,53921),
 (841,27,79,9,88151,88151,0,0,0,53806,0,99,424,53707),
 (842,27,79,15,170675,170675,0,0,0,93732,0,196,707,93536),
 (843,27,79,4,114642,114642,0,0,0,70577,0,126,526,70451),
 (844,27,79,20,110934,110934,0,0,0,54014,0,93,353,53921),
 (1170,7,79,7,136526,136526,0,0,0,103130,0,271,1445,102859),
 (1171,7,79,2,98348,98348,0,0,0,71128,0,210,971,70918),
 (1172,7,79,18,46204,46204,0,0,0,32348,0,111,373,32237),
 (1173,7,79,13,185107,185107,0,0,0,126406,0,524,1182,125882),
 (1174,7,79,8,164612,164612,0,0,0,120795,0,415,1955,120380),
 (1175,7,79,3,106311,106311,0,0,0,81047,0,223,1305,80824),
 (1176,7,79,19,32842,32842,0,0,0,21992,0,94,257,21898),
 (1177,7,79,14,89108,89108,0,0,0,65038,0,238,997,64800),
 (1178,7,79,9,88485,88485,0,0,0,66841,0,183,1019,66658),
 (1179,7,79,4,133247,133247,0,0,0,100571,0,284,1496,100287),
 (1180,7,79,20,104371,104371,0,0,0,72653,0,314,865,72339),
 (1181,7,79,15,186078,186078,0,0,0,135777,0,463,1917,135314),
 (1182,7,79,10,223859,223859,0,0,0,162274,0,633,2151,161641),
 (1183,7,79,5,120992,120992,0,0,0,90992,0,250,1404,90742),
 (1184,7,79,21,27111,27111,0,0,0,19628,0,54,335,19574),
 (1185,7,79,16,112424,112424,0,0,0,81569,0,307,1371,81262),
 (1186,7,79,11,192038,192038,0,0,0,135480,0,576,1759,134904),
 (1187,7,79,6,122870,122870,0,0,0,87874,0,301,1103,87573),
 (1188,7,79,1,116845,116845,0,0,0,75871,0,319,902,75552),
 (1189,7,79,17,102996,102996,0,0,0,73030,0,344,842,72686),
 (1190,7,79,12,98674,98674,0,0,0,67118,0,355,671,66763),
 (1191,8,79,3,105530,105530,309,309,0,67359,192,251,1070,67108),
 (1192,8,79,19,31367,31367,8,8,0,17478,73,81,161,17397),
 (1193,8,79,14,85507,85507,122,122,0,51015,182,186,777,50829),
 (1194,8,79,9,87956,87956,89,89,0,56102,235,199,897,55903),
 (1195,8,79,4,140059,140059,77,77,0,90019,193,305,1264,89714),
 (1196,8,79,20,107236,107236,462,462,0,60716,734,280,675,60436),
 (1197,8,79,15,185035,185035,299,299,0,110391,372,454,1591,109937),
 (1198,8,79,10,223857,223857,1305,1305,0,134965,333,663,1965,134302),
 (1199,8,79,5,121016,121016,95,95,0,77228,256,217,1258,77011),
 (1200,8,79,21,24355,24355,426,426,0,14826,44,42,248,14784),
 (1201,8,79,16,105195,105195,53,53,0,61843,182,267,933,61576),
 (1202,8,79,11,193493,193493,142,142,0,111772,303,480,1306,111292),
 (1203,8,79,6,127530,127530,101,101,0,76359,259,302,1045,76057),
 (1204,8,79,1,123444,123444,78,78,0,69309,263,260,780,69049),
 (1205,8,79,17,101378,101378,81,81,0,59197,147,213,565,58984),
 (1206,8,79,12,99841,99841,1250,1250,0,56211,256,285,551,55926),
 (1207,8,79,7,143923,143923,116,116,0,93473,260,264,1378,93209),
 (1208,8,79,2,97524,97524,83,83,0,58313,175,221,747,58092),
 (1209,8,79,18,41811,41811,34,34,0,23771,82,94,302,23677),
 (1210,8,79,13,180631,180631,435,435,0,104543,308,541,990,104002),
 (1211,8,79,8,153881,153881,109,109,0,92976,620,311,1560,92665),
 (1254,28,79,1,95857,95862,5,5,0,72777,7,417,424,72360),
 (1255,28,79,2,119629,119637,8,8,0,98982,52,592,609,98390),
 (1256,28,79,3,95261,95267,6,6,0,80198,17,393,501,79805),
 (1257,28,79,4,111266,111276,10,10,0,91421,20,489,516,90932),
 (1258,28,79,5,112269,112276,7,7,0,94266,20,449,590,93817),
 (1259,28,79,6,111994,111996,2,2,0,85127,7,669,566,84458),
 (1260,28,79,7,109252,109261,9,9,0,90614,13,490,588,90124),
 (1261,28,79,8,181497,181513,16,16,0,150523,2,948,942,149575),
 (1262,28,79,9,89519,89528,9,9,0,74393,60,436,475,73957),
 (1263,28,79,10,174519,174533,14,14,0,135435,41,1189,860,134246),
 (1264,28,79,11,171450,171454,4,4,0,126813,9,1156,852,125657),
 (1265,28,79,12,90135,90148,13,13,0,64041,1,594,414,63447),
 (1266,28,79,13,164399,164403,4,4,0,118643,50,1048,759,117595),
 (1267,28,79,14,74743,74750,7,7,0,59735,3,463,373,59272),
 (1268,28,79,15,160150,160154,4,4,0,125018,2,931,816,124087),
 (1269,28,79,16,136843,136853,10,10,0,112697,4,701,741,111996),
 (1270,28,79,17,98353,98354,1,1,0,72278,18,707,467,71571),
 (1271,28,79,18,76643,76648,5,5,0,59970,29,573,432,59397),
 (1272,28,79,19,50274,50275,1,1,0,40297,1,373,292,39924),
 (1273,28,79,20,114889,114893,4,4,0,89823,0,733,597,89090),
 (1274,28,79,21,35424,35427,3,3,0,29628,10,234,184,29394),
 (1327,29,79,1,96301,96301,0,0,0,64985,1,201,295,64784),
 (1328,29,79,2,119762,119762,0,0,0,89347,11,267,374,89080),
 (1329,29,79,3,95273,95274,0,1,0,73154,8,182,313,72972),
 (1330,29,79,4,111194,111198,0,4,0,81800,12,201,319,81599),
 (1331,29,79,5,112245,112253,0,8,0,85052,9,199,362,84853),
 (1332,29,79,6,111790,111793,0,3,0,72543,10,299,350,72244),
 (1333,29,79,7,109196,109198,0,2,0,81461,9,214,352,81247),
 (1334,29,79,8,181565,181567,0,2,0,133053,4,423,574,132630),
 (1335,29,79,9,89611,89612,0,1,0,67381,25,183,287,67198),
 (1336,29,79,10,174308,174309,0,1,0,116563,22,538,450,116025),
 (1337,29,79,11,171295,171295,0,0,0,105608,10,502,491,105106),
 (1338,29,79,12,90011,90011,0,0,0,52163,0,228,222,51935),
 (1339,29,79,13,164239,164241,0,2,0,97053,2,448,414,96605),
 (1340,29,79,14,74719,74719,0,0,0,52198,3,207,257,51991),
 (1341,29,79,15,160050,160051,0,1,0,108329,1,443,488,107886),
 (1342,29,79,16,136893,136898,0,5,0,98735,1,313,369,98422),
 (1343,29,79,17,98340,98341,0,1,0,59551,12,292,270,59259),
 (1344,29,79,18,76659,76660,0,1,0,50219,0,224,221,49995),
 (1345,29,79,19,50435,50435,0,0,0,34336,3,127,156,34209),
 (1346,29,79,20,114778,114779,0,1,0,75786,0,336,317,75450),
 (1347,29,79,21,35449,35450,0,1,0,26088,7,91,93,25997);
/*!40000 ALTER TABLE `elecdistritotal` ENABLE KEYS */;


--
-- Definition of table `elecmunicandi`
--

DROP TABLE IF EXISTS `elecmunicandi`;
CREATE TABLE `elecmunicandi` (
  `idElecMuniCandi` int(11) NOT NULL AUTO_INCREMENT,
  `Convocatoria_idConvocatoria` int(11) NOT NULL,
  `Candidatura_idCandidatura` int(11) NOT NULL,
  `Municipio` int(11) NOT NULL,
  `Votos` int(11) NOT NULL,
  `PorcVotos` decimal(5,2) NOT NULL,
  `Concejales` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idElecMuniCandi`),
  KEY `i_ElecMuniCandi_Municipio` (`Municipio`),
  KEY `fk_ElecMuniCandi_Convocatoria1_idx` (`Convocatoria_idConvocatoria`),
  KEY `fk_ElecMuniCandi_Candidatura1_idx` (`Candidatura_idCandidatura`),
  CONSTRAINT `fk_ElecMuniCandi_Candidatura1` FOREIGN KEY (`Candidatura_idCandidatura`) REFERENCES `candidatura` (`idCandidatura`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_ElecMuniCandi_Convocatoria1` FOREIGN KEY (`Convocatoria_idConvocatoria`) REFERENCES `convocatoria` (`idConvocatoria`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=84674 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `elecmunicandi`
--

/*!40000 ALTER TABLE `elecmunicandi` DISABLE KEYS */;
INSERT INTO `elecmunicandi` (`idElecMuniCandi`,`Convocatoria_idConvocatoria`,`Candidatura_idCandidatura`,`Municipio`,`Votos`,`PorcVotos`,`Concejales`) VALUES 
 (1,1,1,1,37,'72.55',0),
 (2,1,2,1,4,'7.84',0),
 (3,1,3,1,0,'0.00',0),
 (4,1,4,1,0,'0.00',0),
 (5,1,5,1,4,'7.84',0),
 (6,1,6,1,0,'0.00',0),
 (7,1,7,1,0,'0.00',0),
 (8,1,8,1,1,'1.96',0),
 (9,1,9,1,1,'1.96',0),
 (10,1,10,1,0,'0.00',0),
 (11,1,11,1,0,'0.00',0),
 (12,1,12,1,1,'1.96',0),
 (13,1,13,1,0,'0.00',0),
 (14,1,14,1,0,'0.00',0),
 (15,1,15,1,0,'0.00',0),
 (16,1,16,1,0,'0.00',0),
 (17,1,17,1,2,'3.92',0),
 (18,1,18,1,0,'0.00',0),
 (19,1,19,1,1,'1.96',0),
 (20,1,1,2,788,'40.83',0),
 (21,1,2,2,473,'24.51',0),
 (22,1,3,2,9,'0.47',0),
 (23,1,4,2,4,'0.21',0),
 (24,1,5,2,228,'11.81',0),
 (25,1,6,2,2,'0.10',0),
 (26,1,7,2,1,'0.05',0),
 (27,1,8,2,261,'13.52',0),
 (28,1,9,2,33,'1.71',0),
 (29,1,10,2,1,'0.05',0),
 (30,1,11,2,3,'0.16',0),
 (31,1,12,2,56,'2.90',0),
 (32,1,13,2,0,'0.00',0),
 (33,1,14,2,3,'0.16',0),
 (34,1,15,2,2,'0.10',0),
 (35,1,16,2,4,'0.21',0),
 (36,1,17,2,23,'1.19',0),
 (37,1,18,2,1,'0.05',0),
 (38,1,19,2,10,'0.52',0),
 (39,1,1,3,47,'31.33',0),
 (40,1,2,3,55,'36.67',0),
 (41,1,3,3,0,'0.00',0),
 (42,1,4,3,0,'0.00',0),
 (43,1,5,3,26,'17.33',0),
 (44,1,6,3,0,'0.00',0),
 (45,1,7,3,0,'0.00',0),
 (46,1,8,3,13,'8.67',0),
 (47,1,9,3,0,'0.00',0),
 (48,1,10,3,0,'0.00',0),
 (49,1,11,3,0,'0.00',0),
 (50,1,12,3,3,'2.00',0),
 (51,1,13,3,0,'0.00',0),
 (52,1,14,3,0,'0.00',0),
 (53,1,15,3,0,'0.00',0),
 (54,1,16,3,0,'0.00',0),
 (55,1,17,3,0,'0.00',0),
 (56,1,18,3,0,'0.00',0),
 (57,1,19,3,1,'0.67',0),
 (58,1,1,4,1513,'39.44',0),
 (59,1,2,4,970,'25.29',0),
 (60,1,3,4,6,'0.16',0),
 (61,1,4,4,1,'0.03',0),
 (62,1,5,4,602,'15.69',0),
 (63,1,6,4,0,'0.00',0),
 (64,1,7,4,1,'0.03',0),
 (65,1,8,4,411,'10.71',0),
 (66,1,9,4,34,'0.89',0),
 (67,1,10,4,1,'0.03',0),
 (68,1,11,4,4,'0.10',0),
 (69,1,12,4,159,'4.14',0),
 (70,1,13,4,0,'0.00',0),
 (71,1,14,4,4,'0.10',0),
 (72,1,15,4,7,'0.18',0),
 (73,1,16,4,11,'0.29',0),
 (74,1,17,4,37,'0.96',0),
 (75,1,18,4,3,'0.08',0),
 (76,1,19,4,42,'1.09',0),
 (77,1,1,5,24560,'27.41',0),
 (78,1,2,5,23663,'26.41',0),
 (79,1,3,5,1853,'2.07',0),
 (80,1,4,5,54,'0.06',0),
 (81,1,5,5,18156,'20.26',0),
 (82,1,6,5,19,'0.02',0),
 (83,1,7,5,69,'0.08',0),
 (84,1,8,5,11977,'13.37',0),
 (85,1,9,5,2025,'2.26',0),
 (86,1,10,5,41,'0.05',0),
 (87,1,11,5,52,'0.06',0),
 (88,1,12,5,4009,'4.47',0),
 (89,1,13,5,82,'0.09',0),
 (90,1,14,5,118,'0.13',0),
 (91,1,15,5,97,'0.11',0),
 (92,1,16,5,127,'0.14',0),
 (93,1,17,5,875,'0.98',0),
 (94,1,18,5,107,'0.12',0),
 (95,1,19,5,692,'0.77',0),
 (96,1,1,6,18491,'35.13',0),
 (97,1,2,6,13230,'25.13',0),
 (98,1,3,6,49,'0.09',0),
 (99,1,4,6,79,'0.15',0),
 (100,1,5,6,8760,'16.64',0),
 (101,1,6,6,9,'0.02',0),
 (102,1,7,6,20,'0.04',0),
 (103,1,8,6,6615,'12.57',0),
 (104,1,9,6,1470,'2.79',0),
 (105,1,10,6,42,'0.08',0),
 (106,1,11,6,41,'0.08',0),
 (107,1,12,6,1705,'3.24',0),
 (108,1,13,6,15,'0.03',0),
 (109,1,14,6,87,'0.17',0),
 (110,1,15,6,47,'0.09',0),
 (111,1,16,6,106,'0.20',0),
 (112,1,17,6,505,'0.96',0),
 (113,1,18,6,46,'0.09',0),
 (114,1,19,6,754,'1.43',0),
 (115,1,1,7,25881,'29.93',0),
 (116,1,2,7,23494,'27.17',0),
 (117,1,3,7,69,'0.08',0),
 (118,1,4,7,73,'0.08',0),
 (119,1,5,7,17780,'20.56',0),
 (120,1,6,7,28,'0.03',0),
 (121,1,7,7,96,'0.11',0),
 (122,1,8,7,10345,'11.96',0),
 (123,1,9,7,2056,'2.38',0),
 (124,1,10,7,39,'0.05',0),
 (125,1,11,7,52,'0.06',0),
 (126,1,12,7,3467,'4.01',0),
 (127,1,13,7,36,'0.04',0),
 (128,1,14,7,100,'0.12',0),
 (129,1,15,7,104,'0.12',0),
 (130,1,16,7,106,'0.12',0),
 (131,1,17,7,934,'1.08',0),
 (132,1,18,7,147,'0.17',0),
 (133,1,19,7,727,'0.84',0),
 (134,1,1,8,529,'43.33',0),
 (135,1,2,8,290,'23.75',0),
 (136,1,3,8,2,'0.16',0),
 (137,1,4,8,0,'0.00',0),
 (138,1,5,8,174,'14.25',0),
 (139,1,6,8,1,'0.08',0),
 (140,1,7,8,0,'0.00',0),
 (141,1,8,8,119,'9.75',0),
 (142,1,9,8,6,'0.49',0),
 (143,1,10,8,0,'0.00',0),
 (144,1,11,8,1,'0.08',0),
 (145,1,12,8,54,'4.42',0),
 (146,1,13,8,0,'0.00',0),
 (147,1,14,8,1,'0.08',0),
 (148,1,15,8,1,'0.08',0),
 (149,1,16,8,6,'0.49',0),
 (150,1,17,8,10,'0.82',0),
 (151,1,18,8,0,'0.00',0),
 (152,1,19,8,2,'0.16',0),
 (153,1,1,9,3364,'35.43',0),
 (154,1,2,9,2175,'22.90',0),
 (155,1,3,9,34,'0.36',0),
 (156,1,4,9,18,'0.19',0),
 (157,1,5,9,1439,'15.15',0),
 (158,1,6,9,2,'0.02',0),
 (159,1,7,9,8,'0.08',0),
 (160,1,8,9,1460,'15.37',0),
 (161,1,9,9,173,'1.82',0),
 (162,1,10,9,5,'0.05',0),
 (163,1,11,9,6,'0.06',0),
 (164,1,12,9,369,'3.89',0),
 (165,1,13,9,0,'0.00',0),
 (166,1,14,9,10,'0.11',0),
 (167,1,15,9,24,'0.25',0),
 (168,1,16,9,22,'0.23',0),
 (169,1,17,9,120,'1.26',0),
 (170,1,18,9,19,'0.20',0),
 (171,1,19,9,117,'1.23',0),
 (172,1,1,10,2306,'34.49',0),
 (173,1,2,10,1371,'20.51',0),
 (174,1,3,10,8,'0.12',0),
 (175,1,4,10,11,'0.16',0),
 (176,1,5,10,1323,'19.79',0),
 (177,1,6,10,2,'0.03',0),
 (178,1,7,10,2,'0.03',0),
 (179,1,8,10,974,'14.57',0),
 (180,1,9,10,169,'2.53',0),
 (181,1,10,10,1,'0.01',0),
 (182,1,11,10,4,'0.06',0),
 (183,1,12,10,224,'3.35',0),
 (184,1,13,10,5,'0.07',0),
 (185,1,14,10,8,'0.12',0),
 (186,1,15,10,0,'0.00',0),
 (187,1,16,10,21,'0.31',0),
 (188,1,17,10,76,'1.14',0),
 (189,1,18,10,8,'0.12',0),
 (190,1,19,10,95,'1.42',0),
 (191,1,1,11,126,'38.41',0),
 (192,1,2,11,58,'17.68',0),
 (193,1,3,11,1,'0.30',0),
 (194,1,4,11,0,'0.00',0),
 (195,1,5,11,58,'17.68',0),
 (196,1,6,11,0,'0.00',0),
 (197,1,7,11,1,'0.30',0),
 (198,1,8,11,37,'11.28',0),
 (199,1,9,11,5,'1.52',0),
 (200,1,10,11,0,'0.00',0),
 (201,1,11,11,0,'0.00',0),
 (202,1,12,11,20,'6.10',0),
 (203,1,13,11,0,'0.00',0),
 (204,1,14,11,0,'0.00',0),
 (205,1,15,11,1,'0.30',0),
 (206,1,16,11,9,'2.74',0),
 (207,1,17,11,5,'1.52',0),
 (208,1,18,11,0,'0.00',0),
 (209,1,19,11,3,'0.91',0),
 (210,1,1,12,230,'37.16',0),
 (211,1,2,12,172,'27.79',0),
 (212,1,3,12,7,'1.13',0),
 (213,1,4,12,0,'0.00',0),
 (214,1,5,12,88,'14.22',0),
 (215,1,6,12,0,'0.00',0),
 (216,1,7,12,0,'0.00',0),
 (217,1,8,12,74,'11.95',0),
 (218,1,9,12,7,'1.13',0),
 (219,1,10,12,0,'0.00',0),
 (220,1,11,12,0,'0.00',0),
 (221,1,12,12,16,'2.58',0),
 (222,1,13,12,0,'0.00',0),
 (223,1,14,12,2,'0.32',0),
 (224,1,15,12,0,'0.00',0),
 (225,1,16,12,0,'0.00',0),
 (226,1,17,12,7,'1.13',0),
 (227,1,18,12,0,'0.00',0),
 (228,1,19,12,4,'0.65',0),
 (229,1,1,13,8151,'31.62',0),
 (230,1,2,13,7613,'29.53',0),
 (231,1,3,13,27,'0.10',0),
 (232,1,4,13,11,'0.04',0),
 (233,1,5,13,4817,'18.68',0),
 (234,1,6,13,10,'0.04',0),
 (235,1,7,13,12,'0.05',0),
 (236,1,8,13,2924,'11.34',0),
 (237,1,9,13,340,'1.32',0),
 (238,1,10,13,11,'0.04',0),
 (239,1,11,13,15,'0.06',0),
 (240,1,12,13,902,'3.50',0),
 (241,1,13,13,3,'0.01',0),
 (242,1,14,13,21,'0.08',0),
 (243,1,15,13,23,'0.09',0),
 (244,1,16,13,62,'0.24',0),
 (245,1,17,13,286,'1.11',0),
 (246,1,18,13,30,'0.12',0),
 (247,1,19,13,208,'0.81',0),
 (248,1,1,14,6803,'32.65',0),
 (249,1,2,14,5083,'24.39',0),
 (250,1,3,14,53,'0.25',0),
 (251,1,4,14,15,'0.07',0),
 (252,1,5,14,3934,'18.88',0),
 (253,1,6,14,7,'0.03',0),
 (254,1,7,14,13,'0.06',0),
 (255,1,8,14,2721,'13.06',0),
 (256,1,9,14,475,'2.28',0),
 (257,1,10,14,7,'0.03',0),
 (258,1,11,14,15,'0.07',0),
 (259,1,12,14,908,'4.36',0),
 (260,1,13,14,2,'0.01',0),
 (261,1,14,14,27,'0.13',0),
 (262,1,15,14,35,'0.17',0),
 (263,1,16,14,52,'0.25',0),
 (264,1,17,14,259,'1.24',0),
 (265,1,18,14,38,'0.18',0),
 (266,1,19,14,106,'0.51',0),
 (267,1,1,15,3718,'30.21',0),
 (268,1,2,15,2307,'18.74',0),
 (269,1,3,15,13,'0.11',0),
 (270,1,4,15,8,'0.06',0),
 (271,1,5,15,2276,'18.49',0),
 (272,1,6,15,6,'0.05',0),
 (273,1,7,15,4,'0.03',0),
 (274,1,8,15,2645,'21.49',0),
 (275,1,9,15,380,'3.09',0),
 (276,1,10,15,6,'0.05',0),
 (277,1,11,15,12,'0.10',0),
 (278,1,12,15,396,'3.22',0),
 (279,1,13,15,3,'0.02',0),
 (280,1,14,15,14,'0.11',0),
 (281,1,15,15,7,'0.06',0),
 (282,1,16,15,30,'0.24',0),
 (283,1,17,15,152,'1.23',0),
 (284,1,18,15,9,'0.07',0),
 (285,1,19,15,158,'1.28',0),
 (286,1,1,16,19,'27.94',0),
 (287,1,2,16,26,'38.24',0),
 (288,1,3,16,3,'4.41',0),
 (289,1,4,16,0,'0.00',0),
 (290,1,5,16,6,'8.82',0),
 (291,1,6,16,0,'0.00',0),
 (292,1,7,16,0,'0.00',0),
 (293,1,8,16,3,'4.41',0),
 (294,1,9,16,1,'1.47',0),
 (295,1,10,16,1,'1.47',0),
 (296,1,11,16,0,'0.00',0),
 (297,1,12,16,6,'8.82',0),
 (298,1,13,16,0,'0.00',0),
 (299,1,14,16,0,'0.00',0),
 (300,1,15,16,0,'0.00',0),
 (301,1,16,16,0,'0.00',0),
 (302,1,17,16,0,'0.00',0),
 (303,1,18,16,0,'0.00',0),
 (304,1,19,16,0,'0.00',0),
 (305,1,1,17,247,'29.40',0),
 (306,1,2,17,173,'20.60',0),
 (307,1,3,17,0,'0.00',0),
 (308,1,4,17,0,'0.00',0),
 (309,1,5,17,227,'27.02',0),
 (310,1,6,17,0,'0.00',0),
 (311,1,7,17,0,'0.00',0),
 (312,1,8,17,105,'12.50',0),
 (313,1,9,17,23,'2.74',0),
 (314,1,10,17,0,'0.00',0),
 (315,1,11,17,1,'0.12',0),
 (316,1,12,17,29,'3.45',0),
 (317,1,13,17,1,'0.12',0),
 (318,1,14,17,2,'0.24',0),
 (319,1,15,17,0,'0.00',0),
 (320,1,16,17,0,'0.00',0),
 (321,1,17,17,11,'1.31',0),
 (322,1,18,17,1,'0.12',0),
 (323,1,19,17,10,'1.19',0),
 (324,1,1,18,1138,'41.16',0),
 (325,1,2,18,611,'22.10',0),
 (326,1,3,18,1,'0.04',0),
 (327,1,4,18,0,'0.00',0),
 (328,1,5,18,466,'16.85',0),
 (329,1,6,18,0,'0.00',0),
 (330,1,7,18,1,'0.04',0),
 (331,1,8,18,313,'11.32',0),
 (332,1,9,18,38,'1.37',0),
 (333,1,10,18,2,'0.07',0),
 (334,1,11,18,1,'0.04',0),
 (335,1,12,18,122,'4.41',0),
 (336,1,13,18,0,'0.00',0),
 (337,1,14,18,2,'0.07',0),
 (338,1,15,18,3,'0.11',0),
 (339,1,16,18,6,'0.22',0),
 (340,1,17,18,14,'0.51',0),
 (341,1,18,18,0,'0.00',0),
 (342,1,19,18,23,'0.83',0),
 (343,1,1,19,251,'28.49',0),
 (344,1,2,19,329,'37.34',0),
 (345,1,3,19,0,'0.00',0),
 (346,1,4,19,1,'0.11',0),
 (347,1,5,19,121,'13.73',0),
 (348,1,6,19,0,'0.00',0),
 (349,1,7,19,0,'0.00',0),
 (350,1,8,19,69,'7.83',0),
 (351,1,9,19,12,'1.36',0),
 (352,1,10,19,2,'0.23',0),
 (353,1,11,19,11,'1.25',0),
 (354,1,12,19,44,'4.99',0),
 (355,1,13,19,0,'0.00',0),
 (356,1,14,19,4,'0.45',0),
 (357,1,15,19,1,'0.11',0),
 (358,1,16,19,0,'0.00',0),
 (359,1,17,19,9,'1.02',0),
 (360,1,18,19,2,'0.23',0),
 (361,1,19,19,8,'0.91',0),
 (362,1,1,20,41,'38.32',0),
 (363,1,2,20,20,'18.69',0),
 (364,1,3,20,0,'0.00',0),
 (365,1,4,20,0,'0.00',0),
 (366,1,5,20,34,'31.78',0),
 (367,1,6,20,0,'0.00',0),
 (368,1,7,20,0,'0.00',0),
 (369,1,8,20,7,'6.54',0),
 (370,1,9,20,1,'0.93',0),
 (371,1,10,20,0,'0.00',0),
 (372,1,11,20,0,'0.00',0),
 (373,1,12,20,2,'1.87',0),
 (374,1,13,20,0,'0.00',0),
 (375,1,14,20,1,'0.93',0),
 (376,1,15,20,0,'0.00',0),
 (377,1,16,20,0,'0.00',0),
 (378,1,17,20,1,'0.93',0),
 (379,1,18,20,0,'0.00',0),
 (380,1,19,20,0,'0.00',0),
 (381,1,1,21,122,'36.20',0),
 (382,1,2,21,57,'16.91',0),
 (383,1,3,21,1,'0.30',0),
 (384,1,4,21,0,'0.00',0),
 (385,1,5,21,93,'27.60',0),
 (386,1,6,21,0,'0.00',0),
 (387,1,7,21,0,'0.00',0),
 (388,1,8,21,36,'10.68',0),
 (389,1,9,21,5,'1.48',0),
 (390,1,10,21,0,'0.00',0),
 (391,1,11,21,0,'0.00',0),
 (392,1,12,21,6,'1.78',0),
 (393,1,13,21,0,'0.00',0),
 (394,1,14,21,0,'0.00',0),
 (395,1,15,21,2,'0.59',0),
 (396,1,16,21,0,'0.00',0),
 (397,1,17,21,6,'1.78',0),
 (398,1,18,21,0,'0.00',0),
 (399,1,19,21,2,'0.59',0),
 (400,1,1,22,10763,'46.30',0),
 (401,1,2,22,3576,'15.38',0),
 (402,1,3,22,17,'0.07',0),
 (403,1,4,22,29,'0.12',0),
 (404,1,5,22,2441,'10.50',0),
 (405,1,6,22,2,'0.01',0),
 (406,1,7,22,5,'0.02',0),
 (407,1,8,22,4322,'18.59',0),
 (408,1,9,22,457,'1.97',0),
 (409,1,10,22,14,'0.06',0),
 (410,1,11,22,25,'0.11',0),
 (411,1,12,22,417,'1.79',0),
 (412,1,13,22,7,'0.03',0),
 (413,1,14,22,11,'0.05',0),
 (414,1,15,22,14,'0.06',0),
 (415,1,16,22,37,'0.16',0),
 (416,1,17,22,191,'0.82',0),
 (417,1,18,22,18,'0.08',0),
 (418,1,19,22,613,'2.64',0),
 (419,1,1,23,1258,'36.03',0),
 (420,1,2,23,760,'21.76',0),
 (421,1,3,23,0,'0.00',0),
 (422,1,4,23,6,'0.17',0),
 (423,1,5,23,663,'18.99',0),
 (424,1,6,23,0,'0.00',0),
 (425,1,7,23,5,'0.14',0),
 (426,1,8,23,454,'13.00',0),
 (427,1,9,23,61,'1.75',0),
 (428,1,10,23,2,'0.06',0),
 (429,1,11,23,3,'0.09',0),
 (430,1,12,23,133,'3.81',0),
 (431,1,13,23,1,'0.03',0),
 (432,1,14,23,0,'0.00',0),
 (433,1,15,23,0,'0.00',0),
 (434,1,16,23,8,'0.23',0),
 (435,1,17,23,38,'1.09',0),
 (436,1,18,23,4,'0.11',0),
 (437,1,19,23,52,'1.49',0),
 (438,1,1,24,70,'51.85',0),
 (439,1,2,24,34,'25.19',0),
 (440,1,3,24,0,'0.00',0),
 (441,1,4,24,0,'0.00',0),
 (442,1,5,24,12,'8.89',0),
 (443,1,6,24,0,'0.00',0),
 (444,1,7,24,0,'0.00',0),
 (445,1,8,24,9,'6.67',0),
 (446,1,9,24,1,'0.74',0),
 (447,1,10,24,0,'0.00',0),
 (448,1,11,24,0,'0.00',0),
 (449,1,12,24,4,'2.96',0),
 (450,1,13,24,0,'0.00',0),
 (451,1,14,24,0,'0.00',0),
 (452,1,15,24,0,'0.00',0),
 (453,1,16,24,1,'0.74',0),
 (454,1,17,24,1,'0.74',0),
 (455,1,18,24,0,'0.00',0),
 (456,1,19,24,3,'2.22',0),
 (457,1,1,25,212,'61.63',0),
 (458,1,2,25,68,'19.77',0),
 (459,1,3,25,0,'0.00',0),
 (460,1,4,25,0,'0.00',0),
 (461,1,5,25,24,'6.98',0),
 (462,1,6,25,0,'0.00',0),
 (463,1,7,25,0,'0.00',0),
 (464,1,8,25,19,'5.52',0),
 (465,1,9,25,3,'0.87',0),
 (466,1,10,25,0,'0.00',0),
 (467,1,11,25,0,'0.00',0),
 (468,1,12,25,7,'2.03',0),
 (469,1,13,25,0,'0.00',0),
 (470,1,14,25,0,'0.00',0),
 (471,1,15,25,1,'0.29',0),
 (472,1,16,25,1,'0.29',0),
 (473,1,17,25,2,'0.58',0),
 (474,1,18,25,0,'0.00',0),
 (475,1,19,25,0,'0.00',0),
 (476,1,1,26,1702,'40.77',0),
 (477,1,2,26,798,'19.11',0),
 (478,1,3,26,2,'0.05',0),
 (479,1,4,26,4,'0.10',0),
 (480,1,5,26,671,'16.07',0),
 (481,1,6,26,0,'0.00',0),
 (482,1,7,26,0,'0.00',0),
 (483,1,8,26,587,'14.06',0),
 (484,1,9,26,55,'1.32',0),
 (485,1,10,26,0,'0.00',0),
 (486,1,11,26,6,'0.14',0),
 (487,1,12,26,165,'3.95',0),
 (488,1,13,26,0,'0.00',0),
 (489,1,14,26,4,'0.10',0),
 (490,1,15,26,11,'0.26',0),
 (491,1,16,26,9,'0.22',0),
 (492,1,17,26,45,'1.08',0),
 (493,1,18,26,4,'0.10',0),
 (494,1,19,26,50,'1.20',0),
 (495,1,1,27,329,'40.37',0),
 (496,1,2,27,211,'25.89',0),
 (497,1,3,27,1,'0.12',0),
 (498,1,4,27,0,'0.00',0),
 (499,1,5,27,125,'15.34',0),
 (500,1,6,27,0,'0.00',0),
 (501,1,7,27,0,'0.00',0),
 (502,1,8,27,79,'9.69',0),
 (503,1,9,27,10,'1.23',0),
 (504,1,10,27,1,'0.12',0),
 (505,1,11,27,0,'0.00',0),
 (506,1,12,27,40,'4.91',0),
 (507,1,13,27,0,'0.00',0),
 (508,1,14,27,1,'0.12',0),
 (509,1,15,27,0,'0.00',0),
 (510,1,16,27,1,'0.12',0),
 (511,1,17,27,3,'0.37',0),
 (512,1,18,27,1,'0.12',0),
 (513,1,19,27,4,'0.49',0),
 (514,1,1,28,404,'31.61',0),
 (515,1,2,28,282,'22.07',0),
 (516,1,3,28,1,'0.08',0),
 (517,1,4,28,2,'0.16',0),
 (518,1,5,28,342,'26.76',0),
 (519,1,6,28,1,'0.08',0),
 (520,1,7,28,1,'0.08',0),
 (521,1,8,28,105,'8.22',0),
 (522,1,9,28,23,'1.80',0),
 (523,1,10,28,2,'0.16',0),
 (524,1,11,28,1,'0.08',0),
 (525,1,12,28,61,'4.77',0),
 (526,1,13,28,1,'0.08',0),
 (527,1,14,28,0,'0.00',0),
 (528,1,15,28,1,'0.08',0),
 (529,1,16,28,8,'0.63',0),
 (530,1,17,28,14,'1.10',0),
 (531,1,18,28,2,'0.16',0),
 (532,1,19,28,9,'0.70',0),
 (533,1,1,29,190,'43.58',0),
 (534,1,2,29,82,'18.81',0),
 (535,1,3,29,1,'0.23',0),
 (536,1,4,29,0,'0.00',0),
 (537,1,5,29,73,'16.74',0),
 (538,1,6,29,0,'0.00',0),
 (539,1,7,29,0,'0.00',0),
 (540,1,8,29,53,'12.16',0),
 (541,1,9,29,7,'1.61',0),
 (542,1,10,29,0,'0.00',0),
 (543,1,11,29,0,'0.00',0),
 (544,1,12,29,10,'2.29',0),
 (545,1,13,29,0,'0.00',0),
 (546,1,14,29,0,'0.00',0),
 (547,1,15,29,0,'0.00',0),
 (548,1,16,29,1,'0.23',0),
 (549,1,17,29,5,'1.15',0),
 (550,1,18,29,0,'0.00',0),
 (551,1,19,29,5,'1.15',0),
 (552,1,1,30,488,'39.07',0),
 (553,1,2,30,275,'22.02',0),
 (554,1,3,30,2,'0.16',0),
 (555,1,4,30,3,'0.24',0),
 (556,1,5,30,266,'21.30',0),
 (557,1,6,30,2,'0.16',0),
 (558,1,7,30,0,'0.00',0),
 (559,1,8,30,110,'8.81',0),
 (560,1,9,30,9,'0.72',0),
 (561,1,10,30,1,'0.08',0),
 (562,1,11,30,0,'0.00',0),
 (563,1,12,30,51,'4.08',0),
 (564,1,13,30,1,'0.08',0),
 (565,1,14,30,1,'0.08',0),
 (566,1,15,30,0,'0.00',0),
 (567,1,16,30,1,'0.08',0),
 (568,1,17,30,15,'1.20',0),
 (569,1,18,30,1,'0.08',0),
 (570,1,19,30,4,'0.32',0),
 (571,1,1,31,762,'47.01',0),
 (572,1,2,31,613,'37.82',0),
 (573,1,3,31,3,'0.19',0),
 (574,1,4,31,0,'0.00',0),
 (575,1,5,31,126,'7.77',0),
 (576,1,6,31,0,'0.00',0),
 (577,1,7,31,0,'0.00',0),
 (578,1,8,31,48,'2.96',0),
 (579,1,9,31,4,'0.25',0),
 (580,1,10,31,1,'0.06',0),
 (581,1,11,31,1,'0.06',0),
 (582,1,12,31,39,'2.41',0),
 (583,1,13,31,0,'0.00',0),
 (584,1,14,31,0,'0.00',0),
 (585,1,15,31,1,'0.06',0),
 (586,1,16,31,3,'0.19',0),
 (587,1,17,31,4,'0.25',0),
 (588,1,18,31,0,'0.00',0),
 (589,1,19,31,2,'0.12',0),
 (590,1,1,32,955,'30.40',0),
 (591,1,2,32,890,'28.33',0),
 (592,1,3,32,60,'1.91',0),
 (593,1,4,32,1,'0.03',0),
 (594,1,5,32,525,'16.71',0),
 (595,1,6,32,0,'0.00',0),
 (596,1,7,32,1,'0.03',0),
 (597,1,8,32,403,'12.83',0),
 (598,1,9,32,68,'2.16',0),
 (599,1,10,32,0,'0.00',0),
 (600,1,11,32,0,'0.00',0),
 (601,1,12,32,142,'4.52',0),
 (602,1,13,32,0,'0.00',0),
 (603,1,14,32,0,'0.00',0),
 (604,1,15,32,4,'0.13',0),
 (605,1,16,32,2,'0.06',0),
 (606,1,17,32,22,'0.70',0),
 (607,1,18,32,0,'0.00',0),
 (608,1,19,32,23,'0.73',0),
 (609,1,1,33,1064,'42.17',0),
 (610,1,2,33,550,'21.80',0),
 (611,1,3,33,6,'0.24',0),
 (612,1,4,33,2,'0.08',0),
 (613,1,5,33,325,'12.88',0),
 (614,1,6,33,0,'0.00',0),
 (615,1,7,33,1,'0.04',0),
 (616,1,8,33,367,'14.55',0),
 (617,1,9,33,24,'0.95',0),
 (618,1,10,33,3,'0.12',0),
 (619,1,11,33,7,'0.28',0),
 (620,1,12,33,85,'3.37',0),
 (621,1,13,33,3,'0.12',0),
 (622,1,14,33,1,'0.04',0),
 (623,1,15,33,1,'0.04',0),
 (624,1,16,33,12,'0.48',0),
 (625,1,17,33,34,'1.35',0),
 (626,1,18,33,5,'0.20',0),
 (627,1,19,33,10,'0.40',0),
 (628,1,1,34,154,'56.41',0),
 (629,1,2,34,53,'19.41',0),
 (630,1,3,34,1,'0.37',0),
 (631,1,4,34,0,'0.00',0),
 (632,1,5,34,24,'8.79',0),
 (633,1,6,34,0,'0.00',0),
 (634,1,7,34,0,'0.00',0),
 (635,1,8,34,14,'5.13',0),
 (636,1,9,34,2,'0.73',0),
 (637,1,10,34,0,'0.00',0),
 (638,1,11,34,0,'0.00',0),
 (639,1,12,34,14,'5.13',0),
 (640,1,13,34,0,'0.00',0),
 (641,1,14,34,0,'0.00',0),
 (642,1,15,34,1,'0.37',0),
 (643,1,16,34,1,'0.37',0),
 (644,1,17,34,0,'0.00',0),
 (645,1,18,34,0,'0.00',0),
 (646,1,19,34,1,'0.37',0),
 (647,1,1,35,412,'39.92',0),
 (648,1,2,35,341,'33.04',0),
 (649,1,3,35,0,'0.00',0),
 (650,1,4,35,1,'0.10',0),
 (651,1,5,35,132,'12.79',0),
 (652,1,6,35,0,'0.00',0),
 (653,1,7,35,0,'0.00',0),
 (654,1,8,35,67,'6.49',0),
 (655,1,9,35,7,'0.68',0),
 (656,1,10,35,0,'0.00',0),
 (657,1,11,35,0,'0.00',0),
 (658,1,12,35,45,'4.36',0),
 (659,1,13,35,0,'0.00',0),
 (660,1,14,35,2,'0.19',0),
 (661,1,15,35,1,'0.10',0),
 (662,1,16,35,1,'0.10',0),
 (663,1,17,35,8,'0.78',0),
 (664,1,18,35,0,'0.00',0),
 (665,1,19,35,3,'0.29',0),
 (666,1,1,36,503,'28.84',0),
 (667,1,2,36,307,'17.60',0),
 (668,1,3,36,1,'0.06',0),
 (669,1,4,36,0,'0.00',0),
 (670,1,5,36,405,'23.22',0),
 (671,1,6,36,1,'0.06',0),
 (672,1,7,36,0,'0.00',0),
 (673,1,8,36,218,'12.50',0),
 (674,1,9,36,23,'1.32',0),
 (675,1,10,36,1,'0.06',0),
 (676,1,11,36,0,'0.00',0),
 (677,1,12,36,222,'12.73',0),
 (678,1,13,36,1,'0.06',0),
 (679,1,14,36,2,'0.11',0),
 (680,1,15,36,3,'0.17',0),
 (681,1,16,36,6,'0.34',0),
 (682,1,17,36,28,'1.61',0),
 (683,1,18,36,0,'0.00',0),
 (684,1,19,36,8,'0.46',0),
 (685,1,1,37,429,'34.05',0),
 (686,1,2,37,610,'48.41',0),
 (687,1,3,37,0,'0.00',0),
 (688,1,4,37,0,'0.00',0),
 (689,1,5,37,89,'7.06',0),
 (690,1,6,37,0,'0.00',0),
 (691,1,7,37,18,'1.43',0),
 (692,1,8,37,53,'4.21',0),
 (693,1,9,37,9,'0.71',0),
 (694,1,10,37,0,'0.00',0),
 (695,1,11,37,0,'0.00',0),
 (696,1,12,37,39,'3.10',0),
 (697,1,13,37,0,'0.00',0),
 (698,1,14,37,0,'0.00',0),
 (699,1,15,37,1,'0.08',0),
 (700,1,16,37,1,'0.08',0),
 (701,1,17,37,3,'0.24',0),
 (702,1,18,37,0,'0.00',0),
 (703,1,19,37,1,'0.08',0),
 (704,1,1,38,1134,'32.56',0),
 (705,1,2,38,936,'26.87',0),
 (706,1,3,38,1,'0.03',0),
 (707,1,4,38,0,'0.00',0),
 (708,1,5,38,723,'20.76',0),
 (709,1,6,38,0,'0.00',0),
 (710,1,7,38,1,'0.03',0),
 (711,1,8,38,325,'9.33',0),
 (712,1,9,38,38,'1.09',0),
 (713,1,10,38,0,'0.00',0),
 (714,1,11,38,1,'0.03',0),
 (715,1,12,38,209,'6.00',0),
 (716,1,13,38,2,'0.06',0),
 (717,1,14,38,6,'0.17',0),
 (718,1,15,38,2,'0.06',0),
 (719,1,16,38,1,'0.03',0),
 (720,1,17,38,33,'0.95',0),
 (721,1,18,38,1,'0.03',0),
 (722,1,19,38,24,'0.69',0),
 (723,1,1,39,30,'28.04',0),
 (724,1,2,39,42,'39.25',0),
 (725,1,3,39,1,'0.93',0),
 (726,1,4,39,0,'0.00',0),
 (727,1,5,39,16,'14.95',0),
 (728,1,6,39,0,'0.00',0),
 (729,1,7,39,0,'0.00',0),
 (730,1,8,39,4,'3.74',0),
 (731,1,9,39,0,'0.00',0),
 (732,1,10,39,0,'0.00',0),
 (733,1,11,39,1,'0.93',0),
 (734,1,12,39,7,'6.54',0),
 (735,1,13,39,1,'0.93',0),
 (736,1,14,39,0,'0.00',0),
 (737,1,15,39,1,'0.93',0),
 (738,1,16,39,0,'0.00',0),
 (739,1,17,39,1,'0.93',0),
 (740,1,18,39,0,'0.00',0),
 (741,1,19,39,1,'0.93',0),
 (742,1,1,40,2519,'27.21',0),
 (743,1,2,40,2593,'28.01',0),
 (744,1,3,40,26,'0.28',0),
 (745,1,4,40,10,'0.11',0),
 (746,1,5,40,1929,'20.83',0),
 (747,1,6,40,8,'0.09',0),
 (748,1,7,40,5,'0.05',0),
 (749,1,8,40,990,'10.69',0),
 (750,1,9,40,159,'1.72',0),
 (751,1,10,40,7,'0.08',0),
 (752,1,11,40,12,'0.13',0),
 (753,1,12,40,604,'6.52',0),
 (754,1,13,40,6,'0.06',0),
 (755,1,14,40,6,'0.06',0),
 (756,1,15,40,24,'0.26',0),
 (757,1,16,40,28,'0.30',0),
 (758,1,17,40,130,'1.40',0),
 (759,1,18,40,18,'0.19',0),
 (760,1,19,40,50,'0.54',0),
 (761,1,1,41,1172,'36.59',0),
 (762,1,2,41,629,'19.64',0),
 (763,1,3,41,2,'0.06',0),
 (764,1,4,41,8,'0.25',0),
 (765,1,5,41,453,'14.14',0),
 (766,1,6,41,0,'0.00',0),
 (767,1,7,41,5,'0.16',0),
 (768,1,8,41,562,'17.55',0),
 (769,1,9,41,86,'2.68',0),
 (770,1,10,41,4,'0.12',0),
 (771,1,11,41,0,'0.00',0),
 (772,1,12,41,124,'3.87',0),
 (773,1,13,41,2,'0.06',0),
 (774,1,14,41,5,'0.16',0),
 (775,1,15,41,2,'0.06',0),
 (776,1,16,41,6,'0.19',0),
 (777,1,17,41,52,'1.62',0),
 (778,1,18,41,3,'0.09',0),
 (779,1,19,41,38,'1.19',0),
 (780,1,1,42,438,'52.71',0),
 (781,1,2,42,133,'16.00',0),
 (782,1,3,42,1,'0.12',0),
 (783,1,4,42,1,'0.12',0),
 (784,1,5,42,125,'15.04',0),
 (785,1,6,42,0,'0.00',0),
 (786,1,7,42,0,'0.00',0),
 (787,1,8,42,64,'7.70',0),
 (788,1,9,42,13,'1.56',0),
 (789,1,10,42,1,'0.12',0),
 (790,1,11,42,2,'0.24',0),
 (791,1,12,42,28,'3.37',0),
 (792,1,13,42,1,'0.12',0),
 (793,1,14,42,0,'0.00',0),
 (794,1,15,42,4,'0.48',0),
 (795,1,16,42,1,'0.12',0),
 (796,1,17,42,8,'0.96',0),
 (797,1,18,42,0,'0.00',0),
 (798,1,19,42,6,'0.72',0),
 (799,1,1,43,1402,'40.67',0),
 (800,1,2,43,932,'27.04',0),
 (801,1,3,43,3,'0.09',0),
 (802,1,4,43,0,'0.00',0),
 (803,1,5,43,550,'15.96',0),
 (804,1,6,43,0,'0.00',0),
 (805,1,7,43,2,'0.06',0),
 (806,1,8,43,263,'7.63',0),
 (807,1,9,43,37,'1.07',0),
 (808,1,10,43,2,'0.06',0),
 (809,1,11,43,4,'0.12',0),
 (810,1,12,43,130,'3.77',0),
 (811,1,13,43,3,'0.09',0),
 (812,1,14,43,2,'0.06',0),
 (813,1,15,43,2,'0.06',0),
 (814,1,16,43,6,'0.17',0),
 (815,1,17,43,35,'1.02',0),
 (816,1,18,43,2,'0.06',0),
 (817,1,19,43,13,'0.38',0),
 (818,1,1,44,1238,'30.73',0),
 (819,1,2,44,914,'22.69',0),
 (820,1,3,44,11,'0.27',0),
 (821,1,4,44,10,'0.25',0),
 (822,1,5,44,797,'19.79',0),
 (823,1,6,44,1,'0.02',0),
 (824,1,7,44,1,'0.02',0),
 (825,1,8,44,600,'14.90',0),
 (826,1,9,44,81,'2.01',0),
 (827,1,10,44,4,'0.10',0),
 (828,1,11,44,5,'0.12',0),
 (829,1,12,44,197,'4.89',0),
 (830,1,13,44,3,'0.07',0),
 (831,1,14,44,6,'0.15',0),
 (832,1,15,44,3,'0.07',0),
 (833,1,16,44,8,'0.20',0),
 (834,1,17,44,38,'0.94',0),
 (835,1,18,44,2,'0.05',0),
 (836,1,19,44,48,'1.19',0),
 (837,1,1,45,7468,'34.33',0),
 (838,1,2,45,4964,'22.82',0),
 (839,1,3,45,29,'0.13',0),
 (840,1,4,45,14,'0.06',0),
 (841,1,5,45,4000,'18.39',0),
 (842,1,6,45,4,'0.02',0),
 (843,1,7,45,14,'0.06',0),
 (844,1,8,45,2957,'13.59',0),
 (845,1,9,45,612,'2.81',0),
 (846,1,10,45,8,'0.04',0),
 (847,1,11,45,23,'0.11',0),
 (848,1,12,45,822,'3.78',0),
 (849,1,13,45,5,'0.02',0),
 (850,1,14,45,23,'0.11',0),
 (851,1,15,45,23,'0.11',0),
 (852,1,16,45,46,'0.21',0),
 (853,1,17,45,218,'1.00',0),
 (854,1,18,45,24,'0.11',0),
 (855,1,19,45,213,'0.98',0),
 (856,1,1,46,1202,'38.92',0),
 (857,1,2,46,653,'21.15',0),
 (858,1,3,46,0,'0.00',0),
 (859,1,4,46,0,'0.00',0),
 (860,1,5,46,579,'18.75',0),
 (861,1,6,46,0,'0.00',0),
 (862,1,7,46,1,'0.03',0),
 (863,1,8,46,363,'11.76',0),
 (864,1,9,46,41,'1.33',0),
 (865,1,10,46,3,'0.10',0),
 (866,1,11,46,0,'0.00',0),
 (867,1,12,46,146,'4.73',0),
 (868,1,13,46,4,'0.13',0),
 (869,1,14,46,6,'0.19',0),
 (870,1,15,46,2,'0.06',0),
 (871,1,16,46,6,'0.19',0),
 (872,1,17,46,29,'0.94',0),
 (873,1,18,46,1,'0.03',0),
 (874,1,19,46,25,'0.81',0),
 (875,1,1,47,8035,'30.05',0),
 (876,1,2,47,6432,'24.05',0),
 (877,1,3,47,15,'0.06',0),
 (878,1,4,47,29,'0.11',0),
 (879,1,5,47,5640,'21.09',0),
 (880,1,6,47,5,'0.02',0),
 (881,1,7,47,26,'0.10',0),
 (882,1,8,47,3563,'13.32',0),
 (883,1,9,47,681,'2.55',0),
 (884,1,10,47,26,'0.10',0),
 (885,1,11,47,26,'0.10',0),
 (886,1,12,47,1131,'4.23',0),
 (887,1,13,47,31,'0.12',0),
 (888,1,14,47,31,'0.12',0),
 (889,1,15,47,22,'0.08',0),
 (890,1,16,47,79,'0.30',0),
 (891,1,17,47,360,'1.35',0),
 (892,1,18,47,49,'0.18',0),
 (893,1,19,47,276,'1.03',0),
 (894,1,1,48,118,'30.49',0),
 (895,1,2,48,122,'31.52',0),
 (896,1,3,48,3,'0.78',0),
 (897,1,4,48,0,'0.00',0),
 (898,1,5,48,86,'22.22',0),
 (899,1,6,48,0,'0.00',0),
 (900,1,7,48,0,'0.00',0),
 (901,1,8,48,14,'3.62',0),
 (902,1,9,48,3,'0.78',0),
 (903,1,10,48,0,'0.00',0),
 (904,1,11,48,0,'0.00',0),
 (905,1,12,48,35,'9.04',0),
 (906,1,13,48,0,'0.00',0),
 (907,1,14,48,0,'0.00',0),
 (908,1,15,48,0,'0.00',0),
 (909,1,16,48,0,'0.00',0),
 (910,1,17,48,1,'0.26',0),
 (911,1,18,48,1,'0.26',0),
 (912,1,19,48,1,'0.26',0),
 (913,1,1,49,9767,'23.64',0),
 (914,1,2,49,11524,'27.90',0),
 (915,1,3,49,201,'0.49',0),
 (916,1,4,49,11,'0.03',0),
 (917,1,5,49,9971,'24.14',0),
 (918,1,6,49,16,'0.04',0),
 (919,1,7,49,21,'0.05',0),
 (920,1,8,49,4728,'11.44',0),
 (921,1,9,49,897,'2.17',0),
 (922,1,10,49,32,'0.08',0),
 (923,1,11,49,24,'0.06',0),
 (924,1,12,49,2474,'5.99',0),
 (925,1,13,49,13,'0.03',0),
 (926,1,14,49,47,'0.11',0),
 (927,1,15,49,89,'0.22',0),
 (928,1,16,49,70,'0.17',0),
 (929,1,17,49,654,'1.58',0),
 (930,1,18,49,74,'0.18',0),
 (931,1,19,49,184,'0.45',0),
 (932,1,1,50,1049,'39.81',0),
 (933,1,2,50,509,'19.32',0),
 (934,1,3,50,3,'0.11',0),
 (935,1,4,50,2,'0.08',0),
 (936,1,5,50,426,'16.17',0),
 (937,1,6,50,2,'0.08',0),
 (938,1,7,50,2,'0.08',0),
 (939,1,8,50,395,'14.99',0),
 (940,1,9,50,43,'1.63',0),
 (941,1,10,50,1,'0.04',0),
 (942,1,11,50,1,'0.04',0),
 (943,1,12,50,82,'3.11',0),
 (944,1,13,50,2,'0.08',0),
 (945,1,14,50,2,'0.08',0),
 (946,1,15,50,0,'0.00',0),
 (947,1,16,50,12,'0.46',0),
 (948,1,17,50,39,'1.48',0),
 (949,1,18,50,3,'0.11',0),
 (950,1,19,50,21,'0.80',0),
 (951,1,1,51,430,'38.91',0),
 (952,1,2,51,275,'24.89',0),
 (953,1,3,51,1,'0.09',0),
 (954,1,4,51,0,'0.00',0),
 (955,1,5,51,177,'16.02',0),
 (956,1,6,51,0,'0.00',0),
 (957,1,7,51,0,'0.00',0),
 (958,1,8,51,135,'12.22',0),
 (959,1,9,51,13,'1.18',0),
 (960,1,10,51,0,'0.00',0),
 (961,1,11,51,0,'0.00',0),
 (962,1,12,51,50,'4.52',0),
 (963,1,13,51,0,'0.00',0),
 (964,1,14,51,1,'0.09',0),
 (965,1,15,51,2,'0.18',0),
 (966,1,16,51,2,'0.18',0),
 (967,1,17,51,6,'0.54',0),
 (968,1,18,51,3,'0.27',0),
 (969,1,19,51,8,'0.72',0),
 (970,1,1,52,1265,'48.60',0),
 (971,1,2,52,599,'23.01',0),
 (972,1,3,52,4,'0.15',0),
 (973,1,4,52,1,'0.04',0),
 (974,1,5,52,274,'10.53',0),
 (975,1,6,52,1,'0.04',0),
 (976,1,7,52,0,'0.00',0),
 (977,1,8,52,268,'10.30',0),
 (978,1,9,52,17,'0.65',0),
 (979,1,10,52,1,'0.04',0),
 (980,1,11,52,4,'0.15',0),
 (981,1,12,52,77,'2.96',0),
 (982,1,13,52,1,'0.04',0),
 (983,1,14,52,1,'0.04',0),
 (984,1,15,52,4,'0.15',0),
 (985,1,16,52,7,'0.27',0),
 (986,1,17,52,19,'0.73',0),
 (987,1,18,52,0,'0.00',0),
 (988,1,19,52,15,'0.58',0),
 (989,1,1,53,1513,'33.04',0),
 (990,1,2,53,1002,'21.88',0),
 (991,1,3,53,17,'0.37',0),
 (992,1,4,53,7,'0.15',0),
 (993,1,5,53,881,'19.24',0),
 (994,1,6,53,5,'0.11',0),
 (995,1,7,53,3,'0.07',0),
 (996,1,8,53,719,'15.70',0),
 (997,1,9,53,91,'1.99',0),
 (998,1,10,53,0,'0.00',0),
 (999,1,11,53,2,'0.04',0),
 (1000,1,12,53,183,'4.00',0),
 (1001,1,13,53,5,'0.11',0),
 (1002,1,14,53,4,'0.09',0),
 (1003,1,15,53,2,'0.04',0),
 (1004,1,16,53,10,'0.22',0),
 (1005,1,17,53,36,'0.79',0),
 (1006,1,18,53,1,'0.02',0),
 (1007,1,19,53,31,'0.68',0),
 (1008,1,1,54,2627,'36.25',0),
 (1009,1,2,54,1584,'21.86',0),
 (1010,1,3,54,3,'0.04',0),
 (1011,1,4,54,14,'0.19',0),
 (1012,1,5,54,1300,'17.94',0),
 (1013,1,6,54,4,'0.06',0),
 (1014,1,7,54,3,'0.04',0),
 (1015,1,8,54,898,'12.39',0),
 (1016,1,9,54,134,'1.85',0),
 (1017,1,10,54,6,'0.08',0),
 (1018,1,11,54,2,'0.03',0),
 (1019,1,12,54,284,'3.92',0),
 (1020,1,13,54,1,'0.01',0),
 (1021,1,14,54,3,'0.04',0),
 (1022,1,15,54,6,'0.08',0),
 (1023,1,16,54,12,'0.17',0),
 (1024,1,17,54,81,'1.12',0),
 (1025,1,18,54,5,'0.07',0),
 (1026,1,19,54,175,'2.41',0),
 (1027,1,1,55,318,'47.32',0),
 (1028,1,2,55,256,'38.10',0),
 (1029,1,3,55,1,'0.15',0),
 (1030,1,4,55,0,'0.00',0),
 (1031,1,5,55,32,'4.76',0),
 (1032,1,6,55,0,'0.00',0),
 (1033,1,7,55,0,'0.00',0),
 (1034,1,8,55,37,'5.51',0),
 (1035,1,9,55,4,'0.60',0),
 (1036,1,10,55,0,'0.00',0),
 (1037,1,11,55,1,'0.15',0),
 (1038,1,12,55,7,'1.04',0),
 (1039,1,13,55,0,'0.00',0),
 (1040,1,14,55,1,'0.15',0),
 (1041,1,15,55,0,'0.00',0),
 (1042,1,16,55,3,'0.45',0),
 (1043,1,17,55,1,'0.15',0),
 (1044,1,18,55,0,'0.00',0),
 (1045,1,19,55,1,'0.15',0),
 (1046,1,1,56,266,'39.94',0),
 (1047,1,2,56,170,'25.53',0),
 (1048,1,3,56,1,'0.15',0),
 (1049,1,4,56,1,'0.15',0),
 (1050,1,5,56,137,'20.57',0),
 (1051,1,6,56,0,'0.00',0),
 (1052,1,7,56,1,'0.15',0),
 (1053,1,8,56,39,'5.86',0),
 (1054,1,9,56,5,'0.75',0),
 (1055,1,10,56,0,'0.00',0),
 (1056,1,11,56,0,'0.00',0),
 (1057,1,12,56,19,'2.85',0),
 (1058,1,13,56,2,'0.30',0),
 (1059,1,14,56,1,'0.15',0),
 (1060,1,15,56,0,'0.00',0),
 (1061,1,16,56,0,'0.00',0),
 (1062,1,17,56,6,'0.90',0),
 (1063,1,18,56,0,'0.00',0),
 (1064,1,19,56,1,'0.15',0),
 (1065,1,1,57,383,'35.93',0),
 (1066,1,2,57,216,'20.26',0),
 (1067,1,3,57,13,'1.22',0),
 (1068,1,4,57,3,'0.28',0),
 (1069,1,5,57,204,'19.14',0),
 (1070,1,6,57,0,'0.00',0),
 (1071,1,7,57,0,'0.00',0),
 (1072,1,8,57,134,'12.57',0),
 (1073,1,9,57,14,'1.31',0),
 (1074,1,10,57,7,'0.66',0),
 (1075,1,11,57,0,'0.00',0),
 (1076,1,12,57,37,'3.47',0),
 (1077,1,13,57,1,'0.09',0),
 (1078,1,14,57,0,'0.00',0),
 (1079,1,15,57,5,'0.47',0),
 (1080,1,16,57,3,'0.28',0),
 (1081,1,17,57,18,'1.69',0),
 (1082,1,18,57,2,'0.19',0),
 (1083,1,19,57,11,'1.03',0),
 (1084,1,1,58,18373,'20.51',0),
 (1085,1,2,58,29472,'32.90',0),
 (1086,1,3,58,159,'0.18',0),
 (1087,1,4,58,57,'0.06',0),
 (1088,1,5,58,20550,'22.94',0),
 (1089,1,6,58,100,'0.11',0),
 (1090,1,7,58,42,'0.05',0),
 (1091,1,8,58,11454,'12.79',0),
 (1092,1,9,58,1908,'2.13',0),
 (1093,1,10,58,60,'0.07',0),
 (1094,1,11,58,85,'0.09',0),
 (1095,1,12,58,3809,'4.25',0),
 (1096,1,13,58,29,'0.03',0),
 (1097,1,14,58,108,'0.12',0),
 (1098,1,15,58,93,'0.10',0),
 (1099,1,16,58,257,'0.29',0),
 (1100,1,17,58,1397,'1.56',0),
 (1101,1,18,58,174,'0.19',0),
 (1102,1,19,58,451,'0.50',0),
 (1103,1,1,59,1060,'38.53',0),
 (1104,1,2,59,626,'22.76',0),
 (1105,1,3,59,5,'0.18',0),
 (1106,1,4,59,3,'0.11',0),
 (1107,1,5,59,426,'15.49',0),
 (1108,1,6,59,0,'0.00',0),
 (1109,1,7,59,1,'0.04',0),
 (1110,1,8,59,334,'12.14',0),
 (1111,1,9,59,56,'2.04',0),
 (1112,1,10,59,1,'0.04',0),
 (1113,1,11,59,2,'0.07',0),
 (1114,1,12,59,112,'4.07',0),
 (1115,1,13,59,1,'0.04',0),
 (1116,1,14,59,7,'0.25',0),
 (1117,1,15,59,3,'0.11',0),
 (1118,1,16,59,6,'0.22',0),
 (1119,1,17,59,34,'1.24',0),
 (1120,1,18,59,3,'0.11',0),
 (1121,1,19,59,23,'0.84',0),
 (1122,1,1,60,251,'21.13',0),
 (1123,1,2,60,543,'45.71',0),
 (1124,1,3,60,0,'0.00',0),
 (1125,1,4,60,0,'0.00',0),
 (1126,1,5,60,146,'12.29',0),
 (1127,1,6,60,0,'0.00',0),
 (1128,1,7,60,1,'0.08',0),
 (1129,1,8,60,58,'4.88',0),
 (1130,1,9,60,7,'0.59',0),
 (1131,1,10,60,0,'0.00',0),
 (1132,1,11,60,0,'0.00',0),
 (1133,1,12,60,151,'12.71',0),
 (1134,1,13,60,0,'0.00',0),
 (1135,1,14,60,2,'0.17',0),
 (1136,1,15,60,1,'0.08',0),
 (1137,1,16,60,0,'0.00',0),
 (1138,1,17,60,10,'0.84',0),
 (1139,1,18,60,1,'0.08',0),
 (1140,1,19,60,2,'0.17',0),
 (1141,1,1,61,5117,'36.11',0),
 (1142,1,2,61,2930,'20.68',0),
 (1143,1,3,61,11,'0.08',0),
 (1144,1,4,61,33,'0.23',0),
 (1145,1,5,61,2513,'17.73',0),
 (1146,1,6,61,4,'0.03',0),
 (1147,1,7,61,13,'0.09',0),
 (1148,1,8,61,2025,'14.29',0),
 (1149,1,9,61,292,'2.06',0),
 (1150,1,10,61,13,'0.09',0),
 (1151,1,11,61,14,'0.10',0),
 (1152,1,12,61,579,'4.09',0),
 (1153,1,13,61,4,'0.03',0),
 (1154,1,14,61,12,'0.08',0),
 (1155,1,15,61,16,'0.11',0),
 (1156,1,16,61,37,'0.26',0),
 (1157,1,17,61,160,'1.13',0),
 (1158,1,18,61,19,'0.13',0),
 (1159,1,19,61,217,'1.53',0),
 (1160,1,1,62,34,'14.29',0),
 (1161,1,2,62,22,'9.24',0),
 (1162,1,3,62,1,'0.42',0),
 (1163,1,4,62,0,'0.00',0),
 (1164,1,5,62,37,'15.55',0),
 (1165,1,6,62,0,'0.00',0),
 (1166,1,7,62,0,'0.00',0),
 (1167,1,8,62,33,'13.87',0),
 (1168,1,9,62,3,'1.26',0),
 (1169,1,10,62,0,'0.00',0),
 (1170,1,11,62,0,'0.00',0),
 (1171,1,12,62,5,'2.10',0),
 (1172,1,13,62,0,'0.00',0),
 (1173,1,14,62,0,'0.00',0),
 (1174,1,15,62,0,'0.00',0),
 (1175,1,16,62,1,'0.42',0),
 (1176,1,17,62,0,'0.00',0),
 (1177,1,18,62,0,'0.00',0),
 (1178,1,19,62,2,'0.84',0),
 (1179,1,1,63,88,'41.31',0),
 (1180,1,2,63,48,'22.54',0),
 (1181,1,3,63,0,'0.00',0),
 (1182,1,4,63,0,'0.00',0),
 (1183,1,5,63,40,'18.78',0),
 (1184,1,6,63,0,'0.00',0),
 (1185,1,7,63,0,'0.00',0),
 (1186,1,8,63,20,'9.39',0),
 (1187,1,9,63,1,'0.47',0),
 (1188,1,10,63,0,'0.00',0),
 (1189,1,11,63,0,'0.00',0),
 (1190,1,12,63,10,'4.69',0),
 (1191,1,13,63,0,'0.00',0),
 (1192,1,14,63,0,'0.00',0),
 (1193,1,15,63,0,'0.00',0),
 (1194,1,16,63,1,'0.47',0),
 (1195,1,17,63,3,'1.41',0),
 (1196,1,18,63,0,'0.00',0),
 (1197,1,19,63,0,'0.00',0),
 (1198,1,1,64,63,'54.31',0),
 (1199,1,2,64,23,'19.83',0),
 (1200,1,3,64,0,'0.00',0),
 (1201,1,4,64,0,'0.00',0),
 (1202,1,5,64,14,'12.07',0),
 (1203,1,6,64,0,'0.00',0),
 (1204,1,7,64,1,'0.86',0),
 (1205,1,8,64,9,'7.76',0),
 (1206,1,9,64,0,'0.00',0),
 (1207,1,10,64,0,'0.00',0),
 (1208,1,11,64,0,'0.00',0),
 (1209,1,12,64,5,'4.31',0),
 (1210,1,13,64,0,'0.00',0),
 (1211,1,14,64,0,'0.00',0),
 (1212,1,15,64,0,'0.00',0),
 (1213,1,16,64,0,'0.00',0),
 (1214,1,17,64,0,'0.00',0),
 (1215,1,18,64,0,'0.00',0),
 (1216,1,19,64,0,'0.00',0),
 (1217,1,1,65,22419,'25.71',0),
 (1218,1,2,65,26151,'29.99',0),
 (1219,1,3,65,117,'0.13',0),
 (1220,1,4,65,47,'0.05',0),
 (1221,1,5,65,20107,'23.06',0),
 (1222,1,6,65,66,'0.08',0),
 (1223,1,7,65,102,'0.12',0),
 (1224,1,8,65,8664,'9.94',0),
 (1225,1,9,65,1841,'2.11',0),
 (1226,1,10,65,47,'0.05',0),
 (1227,1,11,65,51,'0.06',0),
 (1228,1,12,65,4655,'5.34',0),
 (1229,1,13,65,38,'0.04',0),
 (1230,1,14,65,86,'0.10',0),
 (1231,1,15,65,71,'0.08',0),
 (1232,1,16,65,148,'0.17',0),
 (1233,1,17,65,982,'1.13',0),
 (1234,1,18,65,161,'0.18',0),
 (1235,1,19,65,596,'0.68',0),
 (1236,1,1,66,1975,'43.55',0),
 (1237,1,2,66,767,'16.91',0),
 (1238,1,3,66,4,'0.09',0),
 (1239,1,4,66,1,'0.02',0),
 (1240,1,5,66,629,'13.87',0),
 (1241,1,6,66,4,'0.09',0),
 (1242,1,7,66,2,'0.04',0),
 (1243,1,8,66,715,'15.77',0),
 (1244,1,9,66,88,'1.94',0),
 (1245,1,10,66,3,'0.07',0),
 (1246,1,11,66,0,'0.00',0),
 (1247,1,12,66,122,'2.69',0),
 (1248,1,13,66,1,'0.02',0),
 (1249,1,14,66,4,'0.09',0),
 (1250,1,15,66,5,'0.11',0),
 (1251,1,16,66,15,'0.33',0),
 (1252,1,17,66,56,'1.23',0),
 (1253,1,18,66,4,'0.09',0),
 (1254,1,19,66,87,'1.92',0),
 (1255,1,1,67,1098,'37.44',0),
 (1256,1,2,67,848,'28.91',0),
 (1257,1,3,67,2,'0.07',0),
 (1258,1,4,67,1,'0.03',0),
 (1259,1,5,67,424,'14.46',0),
 (1260,1,6,67,0,'0.00',0),
 (1261,1,7,67,0,'0.00',0),
 (1262,1,8,67,332,'11.32',0),
 (1263,1,9,67,29,'0.99',0),
 (1264,1,10,67,1,'0.03',0),
 (1265,1,11,67,5,'0.17',0),
 (1266,1,12,67,79,'2.69',0),
 (1267,1,13,67,1,'0.03',0),
 (1268,1,14,67,3,'0.10',0),
 (1269,1,15,67,1,'0.03',0),
 (1270,1,16,67,6,'0.20',0),
 (1271,1,17,67,35,'1.19',0),
 (1272,1,18,67,3,'0.10',0),
 (1273,1,19,67,33,'1.13',0),
 (1274,1,1,68,2699,'37.65',0),
 (1275,1,2,68,1652,'23.04',0),
 (1276,1,3,68,13,'0.18',0),
 (1277,1,4,68,7,'0.10',0),
 (1278,1,5,68,1218,'16.99',0),
 (1279,1,6,68,2,'0.03',0),
 (1280,1,7,68,8,'0.11',0),
 (1281,1,8,68,850,'11.86',0),
 (1282,1,9,68,143,'1.99',0),
 (1283,1,10,68,11,'0.15',0),
 (1284,1,11,68,6,'0.08',0),
 (1285,1,12,68,200,'2.79',0),
 (1286,1,13,68,2,'0.03',0),
 (1287,1,14,68,4,'0.06',0),
 (1288,1,15,68,10,'0.14',0),
 (1289,1,16,68,26,'0.36',0),
 (1290,1,17,68,86,'1.20',0),
 (1291,1,18,68,5,'0.07',0),
 (1292,1,19,68,129,'1.80',0),
 (1293,1,1,69,13,'38.24',0),
 (1294,1,2,69,10,'29.41',0),
 (1295,1,3,69,0,'0.00',0),
 (1296,1,4,69,0,'0.00',0),
 (1297,1,5,69,8,'23.53',0),
 (1298,1,6,69,0,'0.00',0),
 (1299,1,7,69,0,'0.00',0),
 (1300,1,8,69,2,'5.88',0),
 (1301,1,9,69,0,'0.00',0),
 (1302,1,10,69,0,'0.00',0),
 (1303,1,11,69,0,'0.00',0),
 (1304,1,12,69,0,'0.00',0),
 (1305,1,13,69,0,'0.00',0),
 (1306,1,14,69,0,'0.00',0),
 (1307,1,15,69,0,'0.00',0),
 (1308,1,16,69,0,'0.00',0),
 (1309,1,17,69,0,'0.00',0),
 (1310,1,18,69,1,'2.94',0),
 (1311,1,19,69,0,'0.00',0),
 (1312,1,1,70,44,'46.81',0),
 (1313,1,2,70,14,'14.89',0),
 (1314,1,3,70,0,'0.00',0),
 (1315,1,4,70,0,'0.00',0),
 (1316,1,5,70,20,'21.28',0),
 (1317,1,6,70,0,'0.00',0),
 (1318,1,7,70,0,'0.00',0),
 (1319,1,8,70,10,'10.64',0),
 (1320,1,9,70,0,'0.00',0),
 (1321,1,10,70,0,'0.00',0),
 (1322,1,11,70,1,'1.06',0),
 (1323,1,12,70,2,'2.13',0),
 (1324,1,13,70,0,'0.00',0),
 (1325,1,14,70,0,'0.00',0),
 (1326,1,15,70,0,'0.00',0),
 (1327,1,16,70,0,'0.00',0),
 (1328,1,17,70,0,'0.00',0),
 (1329,1,18,70,0,'0.00',0),
 (1330,1,19,70,1,'1.06',0),
 (1331,1,1,71,21,'42.86',0),
 (1332,1,2,71,13,'26.53',0),
 (1333,1,3,71,0,'0.00',0),
 (1334,1,4,71,0,'0.00',0),
 (1335,1,5,71,4,'8.16',0),
 (1336,1,6,71,0,'0.00',0),
 (1337,1,7,71,0,'0.00',0),
 (1338,1,8,71,4,'8.16',0),
 (1339,1,9,71,0,'0.00',0),
 (1340,1,10,71,0,'0.00',0),
 (1341,1,11,71,0,'0.00',0),
 (1342,1,12,71,1,'2.04',0),
 (1343,1,13,71,0,'0.00',0),
 (1344,1,14,71,0,'0.00',0),
 (1345,1,15,71,0,'0.00',0),
 (1346,1,16,71,1,'2.04',0),
 (1347,1,17,71,0,'0.00',0),
 (1348,1,18,71,0,'0.00',0),
 (1349,1,19,71,1,'2.04',0),
 (1350,1,1,72,1497,'39.05',0),
 (1351,1,2,72,769,'20.06',0),
 (1352,1,3,72,2,'0.05',0),
 (1353,1,4,72,2,'0.05',0),
 (1354,1,5,72,612,'15.96',0),
 (1355,1,6,72,0,'0.00',0),
 (1356,1,7,72,2,'0.05',0),
 (1357,1,8,72,539,'14.06',0),
 (1358,1,9,72,76,'1.98',0),
 (1359,1,10,72,5,'0.13',0),
 (1360,1,11,72,0,'0.00',0),
 (1361,1,12,72,132,'3.44',0),
 (1362,1,13,72,3,'0.08',0),
 (1363,1,14,72,1,'0.03',0),
 (1364,1,15,72,2,'0.05',0),
 (1365,1,16,72,13,'0.34',0),
 (1366,1,17,72,40,'1.04',0),
 (1367,1,18,72,2,'0.05',0),
 (1368,1,19,72,91,'2.37',0),
 (1369,1,1,73,2791,'32.70',0),
 (1370,1,2,73,1969,'23.07',0),
 (1371,1,3,73,22,'0.26',0),
 (1372,1,4,73,2,'0.02',0),
 (1373,1,5,73,1680,'19.68',0),
 (1374,1,6,73,11,'0.13',0),
 (1375,1,7,73,8,'0.09',0),
 (1376,1,8,73,1114,'13.05',0),
 (1377,1,9,73,213,'2.50',0),
 (1378,1,10,73,8,'0.09',0),
 (1379,1,11,73,8,'0.09',0),
 (1380,1,12,73,348,'4.08',0),
 (1381,1,13,73,7,'0.08',0),
 (1382,1,14,73,19,'0.22',0),
 (1383,1,15,73,15,'0.18',0),
 (1384,1,16,73,20,'0.23',0),
 (1385,1,17,73,111,'1.30',0),
 (1386,1,18,73,14,'0.16',0),
 (1387,1,19,73,38,'0.45',0),
 (1388,1,1,74,21795,'22.91',0),
 (1389,1,2,74,28241,'29.69',0),
 (1390,1,3,74,92,'0.10',0),
 (1391,1,4,74,48,'0.05',0),
 (1392,1,5,74,21543,'22.65',0),
 (1393,1,6,74,4473,'4.70',0),
 (1394,1,7,74,44,'0.05',0),
 (1395,1,8,74,9648,'10.14',0),
 (1396,1,9,74,1784,'1.88',0),
 (1397,1,10,74,41,'0.04',0),
 (1398,1,11,74,79,'0.08',0),
 (1399,1,12,74,4369,'4.59',0),
 (1400,1,13,74,24,'0.03',0),
 (1401,1,14,74,92,'0.10',0),
 (1402,1,15,74,131,'0.14',0),
 (1403,1,16,74,167,'0.18',0),
 (1404,1,17,74,899,'0.95',0),
 (1405,1,18,74,121,'0.13',0),
 (1406,1,19,74,536,'0.56',0),
 (1407,1,1,75,1232,'31.26',0),
 (1408,1,2,75,1024,'25.98',0),
 (1409,1,3,75,27,'0.69',0),
 (1410,1,4,75,1,'0.03',0),
 (1411,1,5,75,728,'18.47',0),
 (1412,1,6,75,1,'0.03',0),
 (1413,1,7,75,2,'0.05',0),
 (1414,1,8,75,513,'13.02',0),
 (1415,1,9,75,72,'1.83',0),
 (1416,1,10,75,2,'0.05',0),
 (1417,1,11,75,13,'0.33',0),
 (1418,1,12,75,145,'3.68',0),
 (1419,1,13,75,1,'0.03',0),
 (1420,1,14,75,9,'0.23',0),
 (1421,1,15,75,4,'0.10',0),
 (1422,1,16,75,18,'0.46',0),
 (1423,1,17,75,90,'2.28',0),
 (1424,1,18,75,4,'0.10',0),
 (1425,1,19,75,14,'0.36',0),
 (1426,1,1,76,143,'42.06',0),
 (1427,1,2,76,106,'31.18',0),
 (1428,1,3,76,0,'0.00',0),
 (1429,1,4,76,1,'0.29',0),
 (1430,1,5,76,41,'12.06',0),
 (1431,1,6,76,1,'0.29',0),
 (1432,1,7,76,0,'0.00',0),
 (1433,1,8,76,23,'6.76',0),
 (1434,1,9,76,2,'0.59',0),
 (1435,1,10,76,0,'0.00',0),
 (1436,1,11,76,0,'0.00',0),
 (1437,1,12,76,15,'4.41',0),
 (1438,1,13,76,0,'0.00',0),
 (1439,1,14,76,0,'0.00',0),
 (1440,1,15,76,1,'0.29',0),
 (1441,1,16,76,1,'0.29',0),
 (1442,1,17,76,2,'0.59',0),
 (1443,1,18,76,0,'0.00',0),
 (1444,1,19,76,1,'0.29',0),
 (1445,1,1,78,14,'41.18',0),
 (1446,1,2,78,5,'14.71',0),
 (1447,1,3,78,0,'0.00',0),
 (1448,1,4,78,0,'0.00',0),
 (1449,1,5,78,12,'35.29',0),
 (1450,1,6,78,0,'0.00',0),
 (1451,1,7,78,0,'0.00',0),
 (1452,1,8,78,2,'5.88',0),
 (1453,1,9,78,0,'0.00',0),
 (1454,1,10,78,0,'0.00',0),
 (1455,1,11,78,0,'0.00',0),
 (1456,1,12,78,0,'0.00',0),
 (1457,1,13,78,0,'0.00',0),
 (1458,1,14,78,1,'2.94',0),
 (1459,1,15,78,0,'0.00',0),
 (1460,1,16,78,0,'0.00',0),
 (1461,1,17,78,0,'0.00',0),
 (1462,1,18,78,0,'0.00',0),
 (1463,1,19,78,0,'0.00',0),
 (1464,1,1,79,568806,'35.11',0),
 (1465,1,2,79,416775,'25.72',0),
 (1466,1,3,79,1261,'0.08',0),
 (1467,1,4,79,1291,'0.08',0),
 (1468,1,5,79,287604,'17.75',0),
 (1469,1,6,79,390,'0.02',0),
 (1470,1,7,79,755,'0.05',0),
 (1471,1,8,79,182737,'11.28',0),
 (1472,1,9,79,30899,'1.91',0),
 (1473,1,10,79,892,'0.06',0),
 (1474,1,11,79,1494,'0.09',0),
 (1475,1,12,79,67717,'4.18',0),
 (1476,1,13,79,711,'0.04',0),
 (1477,1,14,79,1743,'0.11',0),
 (1478,1,15,79,1420,'0.09',0),
 (1479,1,16,79,2233,'0.14',0),
 (1480,1,17,79,13828,'0.85',0),
 (1481,1,18,79,1960,'0.12',0),
 (1482,1,19,79,21719,'1.34',0),
 (1483,1,1,80,15300,'44.94',0),
 (1484,1,2,80,5740,'16.86',0),
 (1485,1,3,80,19,'0.06',0),
 (1486,1,4,80,38,'0.11',0),
 (1487,1,5,80,3629,'10.66',0),
 (1488,1,6,80,5,'0.01',0),
 (1489,1,7,80,10,'0.03',0),
 (1490,1,8,80,6089,'17.88',0),
 (1491,1,9,80,663,'1.95',0),
 (1492,1,10,80,19,'0.06',0),
 (1493,1,11,80,25,'0.07',0),
 (1494,1,12,80,774,'2.27',0),
 (1495,1,13,80,12,'0.04',0),
 (1496,1,14,80,18,'0.05',0),
 (1497,1,15,80,9,'0.03',0),
 (1498,1,16,80,57,'0.17',0),
 (1499,1,17,80,278,'0.82',0),
 (1500,1,18,80,34,'0.10',0),
 (1501,1,19,80,924,'2.71',0),
 (1502,1,1,82,1282,'32.17',0),
 (1503,1,2,82,879,'22.06',0),
 (1504,1,3,82,2,'0.05',0),
 (1505,1,4,82,1,'0.03',0),
 (1506,1,5,82,1014,'25.45',0),
 (1507,1,6,82,4,'0.10',0),
 (1508,1,7,82,3,'0.08',0),
 (1509,1,8,82,488,'12.25',0),
 (1510,1,9,82,62,'1.56',0),
 (1511,1,10,82,1,'0.03',0),
 (1512,1,11,82,2,'0.05',0),
 (1513,1,12,82,119,'2.99',0),
 (1514,1,13,82,0,'0.00',0),
 (1515,1,14,82,3,'0.08',0),
 (1516,1,15,82,5,'0.13',0),
 (1517,1,16,82,3,'0.08',0),
 (1518,1,17,82,45,'1.13',0),
 (1519,1,18,82,6,'0.15',0),
 (1520,1,19,82,22,'0.55',0),
 (1521,1,1,83,1741,'30.66',0),
 (1522,1,2,83,1274,'22.43',0),
 (1523,1,3,83,118,'2.08',0),
 (1524,1,4,83,3,'0.05',0),
 (1525,1,5,83,1097,'19.32',0),
 (1526,1,6,83,0,'0.00',0),
 (1527,1,7,83,2,'0.04',0),
 (1528,1,8,83,832,'14.65',0),
 (1529,1,9,83,139,'2.45',0),
 (1530,1,10,83,1,'0.02',0),
 (1531,1,11,83,3,'0.05',0),
 (1532,1,12,83,233,'4.10',0),
 (1533,1,13,83,4,'0.07',0),
 (1534,1,14,83,8,'0.14',0),
 (1535,1,15,83,7,'0.12',0),
 (1536,1,16,83,8,'0.14',0),
 (1537,1,17,83,71,'1.25',0),
 (1538,1,18,83,11,'0.19',0),
 (1539,1,19,83,52,'0.92',0),
 (1540,1,1,84,2316,'22.75',0),
 (1541,1,2,84,2871,'28.21',0),
 (1542,1,3,84,69,'0.68',0),
 (1543,1,4,84,5,'0.05',0),
 (1544,1,5,84,2382,'23.40',0),
 (1545,1,6,84,1,'0.01',0),
 (1546,1,7,84,5,'0.05',0),
 (1547,1,8,84,1067,'10.48',0),
 (1548,1,9,84,394,'3.87',0),
 (1549,1,10,84,4,'0.04',0),
 (1550,1,11,84,21,'0.21',0),
 (1551,1,12,84,599,'5.89',0),
 (1552,1,13,84,8,'0.08',0),
 (1553,1,14,84,23,'0.23',0),
 (1554,1,15,84,21,'0.21',0),
 (1555,1,16,84,24,'0.24',0),
 (1556,1,17,84,164,'1.61',0),
 (1557,1,18,84,25,'0.25',0),
 (1558,1,19,84,48,'0.47',0),
 (1559,1,1,85,1036,'37.09',0),
 (1560,1,2,85,904,'32.37',0),
 (1561,1,3,85,0,'0.00',0),
 (1562,1,4,85,0,'0.00',0),
 (1563,1,5,85,407,'14.57',0),
 (1564,1,6,85,0,'0.00',0),
 (1565,1,7,85,1,'0.04',0),
 (1566,1,8,85,218,'7.81',0),
 (1567,1,9,85,52,'1.86',0),
 (1568,1,10,85,0,'0.00',0),
 (1569,1,11,85,3,'0.11',0),
 (1570,1,12,85,85,'3.04',0),
 (1571,1,13,85,0,'0.00',0),
 (1572,1,14,85,4,'0.14',0),
 (1573,1,15,85,2,'0.07',0),
 (1574,1,16,85,9,'0.32',0),
 (1575,1,17,85,24,'0.86',0),
 (1576,1,18,85,2,'0.07',0),
 (1577,1,19,85,17,'0.61',0),
 (1578,1,1,86,1147,'36.46',0),
 (1579,1,2,86,789,'25.08',0),
 (1580,1,3,86,0,'0.00',0),
 (1581,1,4,86,6,'0.19',0),
 (1582,1,5,86,477,'15.16',0),
 (1583,1,6,86,0,'0.00',0),
 (1584,1,7,86,3,'0.10',0),
 (1585,1,8,86,427,'13.57',0),
 (1586,1,9,86,55,'1.75',0),
 (1587,1,10,86,1,'0.03',0),
 (1588,1,11,86,3,'0.10',0),
 (1589,1,12,86,83,'2.64',0),
 (1590,1,13,86,3,'0.10',0),
 (1591,1,14,86,7,'0.22',0),
 (1592,1,15,86,4,'0.13',0),
 (1593,1,16,86,11,'0.35',0),
 (1594,1,17,86,41,'1.30',0),
 (1595,1,18,86,4,'0.13',0),
 (1596,1,19,86,19,'0.60',0),
 (1597,1,1,87,1021,'44.08',0),
 (1598,1,2,87,553,'23.88',0),
 (1599,1,3,87,0,'0.00',0),
 (1600,1,4,87,2,'0.09',0),
 (1601,1,5,87,307,'13.26',0),
 (1602,1,6,87,0,'0.00',0),
 (1603,1,7,87,0,'0.00',0),
 (1604,1,8,87,236,'10.19',0),
 (1605,1,9,87,28,'1.21',0),
 (1606,1,10,87,0,'0.00',0),
 (1607,1,11,87,4,'0.17',0),
 (1608,1,12,87,79,'3.41',0),
 (1609,1,13,87,0,'0.00',0),
 (1610,1,14,87,3,'0.13',0),
 (1611,1,15,87,1,'0.04',0),
 (1612,1,16,87,5,'0.22',0),
 (1613,1,17,87,19,'0.82',0),
 (1614,1,18,87,2,'0.09',0),
 (1615,1,19,87,27,'1.17',0),
 (1616,1,1,88,52,'30.23',0),
 (1617,1,2,88,44,'25.58',0),
 (1618,1,3,88,0,'0.00',0),
 (1619,1,4,88,0,'0.00',0),
 (1620,1,5,88,38,'22.09',0),
 (1621,1,6,88,0,'0.00',0),
 (1622,1,7,88,0,'0.00',0),
 (1623,1,8,88,21,'12.21',0),
 (1624,1,9,88,1,'0.58',0),
 (1625,1,10,88,0,'0.00',0),
 (1626,1,11,88,1,'0.58',0),
 (1627,1,12,88,9,'5.23',0),
 (1628,1,13,88,0,'0.00',0),
 (1629,1,14,88,1,'0.58',0),
 (1630,1,15,88,0,'0.00',0),
 (1631,1,16,88,0,'0.00',0),
 (1632,1,17,88,0,'0.00',0),
 (1633,1,18,88,0,'0.00',0),
 (1634,1,19,88,1,'0.58',0),
 (1635,1,1,89,1018,'39.17',0),
 (1636,1,2,89,676,'26.01',0),
 (1637,1,3,89,6,'0.23',0),
 (1638,1,4,89,0,'0.00',0),
 (1639,1,5,89,358,'13.77',0),
 (1640,1,6,89,3,'0.12',0),
 (1641,1,7,89,0,'0.00',0),
 (1642,1,8,89,341,'13.12',0),
 (1643,1,9,89,49,'1.89',0),
 (1644,1,10,89,1,'0.04',0),
 (1645,1,11,89,0,'0.00',0),
 (1646,1,12,89,70,'2.69',0),
 (1647,1,13,89,0,'0.00',0),
 (1648,1,14,89,2,'0.08',0),
 (1649,1,15,89,0,'0.00',0),
 (1650,1,16,89,6,'0.23',0),
 (1651,1,17,89,26,'1.00',0),
 (1652,1,18,89,2,'0.08',0),
 (1653,1,19,89,7,'0.27',0),
 (1654,1,1,90,2060,'34.53',0),
 (1655,1,2,90,1260,'21.12',0),
 (1656,1,3,90,6,'0.10',0),
 (1657,1,4,90,3,'0.05',0),
 (1658,1,5,90,1081,'18.12',0),
 (1659,1,6,90,1,'0.02',0),
 (1660,1,7,90,3,'0.05',0),
 (1661,1,8,90,885,'14.83',0),
 (1662,1,9,90,124,'2.08',0),
 (1663,1,10,90,4,'0.07',0),
 (1664,1,11,90,17,'0.28',0),
 (1665,1,12,90,263,'4.41',0),
 (1666,1,13,90,2,'0.03',0),
 (1667,1,14,90,11,'0.18',0),
 (1668,1,15,90,11,'0.18',0),
 (1669,1,16,90,15,'0.25',0),
 (1670,1,17,90,81,'1.36',0),
 (1671,1,18,90,5,'0.08',0),
 (1672,1,19,90,59,'0.99',0),
 (1673,1,1,91,1324,'36.90',0),
 (1674,1,2,91,1144,'31.88',0),
 (1675,1,3,91,3,'0.08',0),
 (1676,1,4,91,0,'0.00',0),
 (1677,1,5,91,546,'15.22',0),
 (1678,1,6,91,1,'0.03',0),
 (1679,1,7,91,1,'0.03',0),
 (1680,1,8,91,234,'6.52',0),
 (1681,1,9,91,19,'0.53',0),
 (1682,1,10,91,6,'0.17',0),
 (1683,1,11,91,3,'0.08',0),
 (1684,1,12,91,190,'5.30',0),
 (1685,1,13,91,7,'0.20',0),
 (1686,1,14,91,1,'0.03',0),
 (1687,1,15,91,3,'0.08',0),
 (1688,1,16,91,3,'0.08',0),
 (1689,1,17,91,26,'0.72',0),
 (1690,1,18,91,1,'0.03',0),
 (1691,1,19,91,7,'0.20',0),
 (1692,1,1,92,28544,'28.86',0),
 (1693,1,2,92,26469,'26.76',0),
 (1694,1,3,92,160,'0.16',0),
 (1695,1,4,92,95,'0.10',0),
 (1696,1,5,92,22588,'22.84',0),
 (1697,1,6,92,48,'0.05',0),
 (1698,1,7,92,88,'0.09',0),
 (1699,1,8,92,10357,'10.47',0),
 (1700,1,9,92,2307,'2.33',0),
 (1701,1,10,92,82,'0.08',0),
 (1702,1,11,92,89,'0.09',0),
 (1703,1,12,92,4235,'4.28',0),
 (1704,1,13,92,44,'0.04',0),
 (1705,1,14,92,110,'0.11',0),
 (1706,1,15,92,134,'0.14',0),
 (1707,1,16,92,220,'0.22',0),
 (1708,1,17,92,1346,'1.36',0),
 (1709,1,18,92,212,'0.21',0),
 (1710,1,19,92,584,'0.59',0),
 (1711,1,1,93,662,'44.25',0),
 (1712,1,2,93,356,'23.80',0),
 (1713,1,3,93,1,'0.07',0),
 (1714,1,4,93,0,'0.00',0),
 (1715,1,5,93,166,'11.10',0),
 (1716,1,6,93,0,'0.00',0),
 (1717,1,7,93,0,'0.00',0),
 (1718,1,8,93,188,'12.57',0),
 (1719,1,9,93,17,'1.14',0),
 (1720,1,10,93,0,'0.00',0),
 (1721,1,11,93,0,'0.00',0),
 (1722,1,12,93,32,'2.14',0),
 (1723,1,13,93,0,'0.00',0),
 (1724,1,14,93,5,'0.33',0),
 (1725,1,15,93,2,'0.13',0),
 (1726,1,16,93,8,'0.53',0),
 (1727,1,17,93,19,'1.27',0),
 (1728,1,18,93,1,'0.07',0),
 (1729,1,19,93,23,'1.54',0),
 (1730,1,1,94,186,'33.70',0),
 (1731,1,2,94,117,'21.20',0),
 (1732,1,3,94,2,'0.36',0),
 (1733,1,4,94,1,'0.18',0),
 (1734,1,5,94,137,'24.82',0),
 (1735,1,6,94,1,'0.18',0),
 (1736,1,7,94,0,'0.00',0),
 (1737,1,8,94,65,'11.78',0),
 (1738,1,9,94,9,'1.63',0),
 (1739,1,10,94,0,'0.00',0),
 (1740,1,11,94,2,'0.36',0),
 (1741,1,12,94,12,'2.17',0),
 (1742,1,13,94,0,'0.00',0),
 (1743,1,14,94,0,'0.00',0),
 (1744,1,15,94,0,'0.00',0),
 (1745,1,16,94,5,'0.91',0),
 (1746,1,17,94,10,'1.81',0),
 (1747,1,18,94,1,'0.18',0),
 (1748,1,19,94,1,'0.18',0),
 (1749,1,1,95,447,'41.89',0),
 (1750,1,2,95,229,'21.46',0),
 (1751,1,3,95,1,'0.09',0),
 (1752,1,4,95,0,'0.00',0),
 (1753,1,5,95,196,'18.37',0),
 (1754,1,6,95,0,'0.00',0),
 (1755,1,7,95,0,'0.00',0),
 (1756,1,8,95,78,'7.31',0),
 (1757,1,9,95,15,'1.41',0),
 (1758,1,10,95,0,'0.00',0),
 (1759,1,11,95,3,'0.28',0),
 (1760,1,12,95,53,'4.97',0),
 (1761,1,13,95,1,'0.09',0),
 (1762,1,14,95,1,'0.09',0),
 (1763,1,15,95,3,'0.28',0),
 (1764,1,16,95,2,'0.19',0),
 (1765,1,17,95,9,'0.84',0),
 (1766,1,18,95,2,'0.19',0),
 (1767,1,19,95,13,'1.22',0),
 (1768,1,1,96,3885,'32.31',0),
 (1769,1,2,96,3263,'27.14',0),
 (1770,1,3,96,10,'0.08',0),
 (1771,1,4,96,8,'0.07',0),
 (1772,1,5,96,2032,'16.90',0),
 (1773,1,6,96,6,'0.05',0),
 (1774,1,7,96,8,'0.07',0),
 (1775,1,8,96,1706,'14.19',0),
 (1776,1,9,96,310,'2.58',0),
 (1777,1,10,96,14,'0.12',0),
 (1778,1,11,96,11,'0.09',0),
 (1779,1,12,96,335,'2.79',0),
 (1780,1,13,96,5,'0.04',0),
 (1781,1,14,96,8,'0.07',0),
 (1782,1,15,96,20,'0.17',0),
 (1783,1,16,96,43,'0.36',0),
 (1784,1,17,96,111,'0.92',0),
 (1785,1,18,96,14,'0.12',0),
 (1786,1,19,96,89,'0.74',0),
 (1787,1,1,97,19,'20.43',0),
 (1788,1,2,97,43,'46.24',0),
 (1789,1,3,97,1,'1.08',0),
 (1790,1,4,97,0,'0.00',0),
 (1791,1,5,97,21,'22.58',0),
 (1792,1,6,97,0,'0.00',0),
 (1793,1,7,97,0,'0.00',0),
 (1794,1,8,97,6,'6.45',0),
 (1795,1,9,97,1,'1.08',0),
 (1796,1,10,97,0,'0.00',0),
 (1797,1,11,97,0,'0.00',0),
 (1798,1,12,97,2,'2.15',0),
 (1799,1,13,97,0,'0.00',0),
 (1800,1,14,97,0,'0.00',0),
 (1801,1,15,97,0,'0.00',0),
 (1802,1,16,97,0,'0.00',0),
 (1803,1,17,97,0,'0.00',0),
 (1804,1,18,97,0,'0.00',0),
 (1805,1,19,97,0,'0.00',0),
 (1806,1,1,99,601,'48.00',0),
 (1807,1,2,99,275,'21.96',0),
 (1808,1,3,99,3,'0.24',0),
 (1809,1,4,99,0,'0.00',0),
 (1810,1,5,99,155,'12.38',0),
 (1811,1,6,99,1,'0.08',0),
 (1812,1,7,99,0,'0.00',0),
 (1813,1,8,99,120,'9.58',0),
 (1814,1,9,99,11,'0.88',0),
 (1815,1,10,99,3,'0.24',0),
 (1816,1,11,99,0,'0.00',0),
 (1817,1,12,99,44,'3.51',0),
 (1818,1,13,99,0,'0.00',0),
 (1819,1,14,99,2,'0.16',0),
 (1820,1,15,99,3,'0.24',0),
 (1821,1,16,99,5,'0.40',0),
 (1822,1,17,99,11,'0.88',0),
 (1823,1,18,99,0,'0.00',0),
 (1824,1,19,99,2,'0.16',0),
 (1825,1,1,100,833,'32.87',0),
 (1826,1,2,100,450,'17.76',0),
 (1827,1,3,100,7,'0.28',0),
 (1828,1,4,100,3,'0.12',0),
 (1829,1,5,100,600,'23.68',0),
 (1830,1,6,100,2,'0.08',0),
 (1831,1,7,100,3,'0.12',0),
 (1832,1,8,100,311,'12.27',0),
 (1833,1,9,100,77,'3.04',0),
 (1834,1,10,100,1,'0.04',0),
 (1835,1,11,100,1,'0.04',0),
 (1836,1,12,100,128,'5.05',0),
 (1837,1,13,100,4,'0.16',0),
 (1838,1,14,100,5,'0.20',0),
 (1839,1,15,100,0,'0.00',0),
 (1840,1,16,100,5,'0.20',0),
 (1841,1,17,100,41,'1.62',0),
 (1842,1,18,100,1,'0.04',0),
 (1843,1,19,100,18,'0.71',0),
 (1844,1,1,101,71,'37.17',0),
 (1845,1,2,101,48,'25.13',0),
 (1846,1,3,101,0,'0.00',0),
 (1847,1,4,101,0,'0.00',0),
 (1848,1,5,101,40,'20.94',0),
 (1849,1,6,101,0,'0.00',0),
 (1850,1,7,101,0,'0.00',0),
 (1851,1,8,101,20,'10.47',0),
 (1852,1,9,101,2,'1.05',0),
 (1853,1,10,101,0,'0.00',0),
 (1854,1,11,101,0,'0.00',0),
 (1855,1,12,101,6,'3.14',0),
 (1856,1,13,101,0,'0.00',0),
 (1857,1,14,101,1,'0.52',0),
 (1858,1,15,101,0,'0.00',0),
 (1859,1,16,101,0,'0.00',0),
 (1860,1,17,101,2,'1.05',0),
 (1861,1,18,101,0,'0.00',0),
 (1862,1,19,101,1,'0.52',0),
 (1863,1,1,102,218,'31.64',0),
 (1864,1,2,102,316,'45.86',0),
 (1865,1,3,102,1,'0.15',0),
 (1866,1,4,102,0,'0.00',0),
 (1867,1,5,102,61,'8.85',0),
 (1868,1,6,102,0,'0.00',0),
 (1869,1,7,102,0,'0.00',0),
 (1870,1,8,102,33,'4.79',0),
 (1871,1,9,102,7,'1.02',0),
 (1872,1,10,102,0,'0.00',0),
 (1873,1,11,102,0,'0.00',0),
 (1874,1,12,102,28,'4.06',0),
 (1875,1,13,102,1,'0.15',0),
 (1876,1,14,102,0,'0.00',0),
 (1877,1,15,102,1,'0.15',0),
 (1878,1,16,102,0,'0.00',0),
 (1879,1,17,102,4,'0.58',0),
 (1880,1,18,102,1,'0.15',0),
 (1881,1,19,102,3,'0.44',0),
 (1882,1,1,104,2997,'32.02',0),
 (1883,1,2,104,1772,'18.93',0),
 (1884,1,3,104,13,'0.14',0),
 (1885,1,4,104,4,'0.04',0),
 (1886,1,5,104,1592,'17.01',0),
 (1887,1,6,104,5,'0.05',0),
 (1888,1,7,104,6,'0.06',0),
 (1889,1,8,104,2083,'22.26',0),
 (1890,1,9,104,173,'1.85',0),
 (1891,1,10,104,6,'0.06',0),
 (1892,1,11,104,11,'0.12',0),
 (1893,1,12,104,318,'3.40',0),
 (1894,1,13,104,1,'0.01',0),
 (1895,1,14,104,9,'0.10',0),
 (1896,1,15,104,10,'0.11',0),
 (1897,1,16,104,25,'0.27',0),
 (1898,1,17,104,77,'0.82',0),
 (1899,1,18,104,8,'0.09',0),
 (1900,1,19,104,105,'1.12',0),
 (1901,1,1,106,10310,'21.90',0),
 (1902,1,2,106,11744,'24.94',0),
 (1903,1,3,106,109,'0.23',0),
 (1904,1,4,106,32,'0.07',0),
 (1905,1,5,106,12518,'26.59',0),
 (1906,1,6,106,54,'0.11',0),
 (1907,1,7,106,61,'0.13',0),
 (1908,1,8,106,5483,'11.64',0),
 (1909,1,9,106,1362,'2.89',0),
 (1910,1,10,106,34,'0.07',0),
 (1911,1,11,106,58,'0.12',0),
 (1912,1,12,106,2896,'6.15',0),
 (1913,1,13,106,29,'0.06',0),
 (1914,1,14,106,93,'0.20',0),
 (1915,1,15,106,102,'0.22',0),
 (1916,1,16,106,181,'0.38',0),
 (1917,1,17,106,905,'1.92',0),
 (1918,1,18,106,155,'0.33',0),
 (1919,1,19,106,316,'0.67',0),
 (1920,1,1,107,81,'23.89',0),
 (1921,1,2,107,161,'47.49',0),
 (1922,1,3,107,1,'0.29',0),
 (1923,1,4,107,0,'0.00',0),
 (1924,1,5,107,37,'10.91',0),
 (1925,1,6,107,0,'0.00',0),
 (1926,1,7,107,0,'0.00',0),
 (1927,1,8,107,38,'11.21',0),
 (1928,1,9,107,5,'1.47',0),
 (1929,1,10,107,0,'0.00',0),
 (1930,1,11,107,0,'0.00',0),
 (1931,1,12,107,12,'3.54',0),
 (1932,1,13,107,1,'0.29',0),
 (1933,1,14,107,0,'0.00',0),
 (1934,1,15,107,0,'0.00',0),
 (1935,1,16,107,1,'0.29',0),
 (1936,1,17,107,0,'0.00',0),
 (1937,1,18,107,0,'0.00',0),
 (1938,1,19,107,1,'0.29',0),
 (1939,1,1,108,713,'32.28',0),
 (1940,1,2,108,429,'19.42',0),
 (1941,1,3,108,0,'0.00',0),
 (1942,1,4,108,2,'0.09',0),
 (1943,1,5,108,470,'21.28',0),
 (1944,1,6,108,0,'0.00',0),
 (1945,1,7,108,0,'0.00',0),
 (1946,1,8,108,331,'14.98',0),
 (1947,1,9,108,60,'2.72',0),
 (1948,1,10,108,1,'0.05',0),
 (1949,1,11,108,1,'0.05',0),
 (1950,1,12,108,92,'4.16',0),
 (1951,1,13,108,1,'0.05',0),
 (1952,1,14,108,11,'0.50',0),
 (1953,1,15,108,1,'0.05',0),
 (1954,1,16,108,7,'0.32',0),
 (1955,1,17,108,29,'1.31',0),
 (1956,1,18,108,2,'0.09',0),
 (1957,1,19,108,23,'1.04',0),
 (1958,1,1,109,481,'47.20',0),
 (1959,1,2,109,200,'19.63',0),
 (1960,1,3,109,1,'0.10',0),
 (1961,1,4,109,0,'0.00',0),
 (1962,1,5,109,163,'16.00',0),
 (1963,1,6,109,0,'0.00',0),
 (1964,1,7,109,0,'0.00',0),
 (1965,1,8,109,85,'8.34',0),
 (1966,1,9,109,15,'1.47',0),
 (1967,1,10,109,0,'0.00',0),
 (1968,1,11,109,2,'0.20',0),
 (1969,1,12,109,30,'2.94',0),
 (1970,1,13,109,4,'0.39',0),
 (1971,1,14,109,0,'0.00',0),
 (1972,1,15,109,0,'0.00',0),
 (1973,1,16,109,5,'0.49',0),
 (1974,1,17,109,8,'0.79',0),
 (1975,1,18,109,1,'0.10',0),
 (1976,1,19,109,9,'0.88',0),
 (1977,1,1,110,609,'41.68',0),
 (1978,1,2,110,475,'32.51',0),
 (1979,1,3,110,2,'0.14',0),
 (1980,1,4,110,1,'0.07',0),
 (1981,1,5,110,166,'11.36',0),
 (1982,1,6,110,0,'0.00',0),
 (1983,1,7,110,0,'0.00',0),
 (1984,1,8,110,96,'6.57',0),
 (1985,1,9,110,14,'0.96',0),
 (1986,1,10,110,1,'0.07',0),
 (1987,1,11,110,0,'0.00',0),
 (1988,1,12,110,58,'3.97',0),
 (1989,1,13,110,0,'0.00',0),
 (1990,1,14,110,1,'0.07',0),
 (1991,1,15,110,0,'0.00',0),
 (1992,1,16,110,2,'0.14',0),
 (1993,1,17,110,6,'0.41',0),
 (1994,1,18,110,0,'0.00',0),
 (1995,1,19,110,12,'0.82',0),
 (1996,1,1,111,196,'43.17',0),
 (1997,1,2,111,95,'20.93',0),
 (1998,1,3,111,2,'0.44',0),
 (1999,1,4,111,0,'0.00',0),
 (2000,1,5,111,54,'11.89',0),
 (2001,1,6,111,0,'0.00',0),
 (2002,1,7,111,0,'0.00',0),
 (2003,1,8,111,63,'13.88',0),
 (2004,1,9,111,5,'1.10',0),
 (2005,1,10,111,1,'0.22',0),
 (2006,1,11,111,0,'0.00',0),
 (2007,1,12,111,19,'4.19',0),
 (2008,1,13,111,1,'0.22',0),
 (2009,1,14,111,1,'0.22',0),
 (2010,1,15,111,0,'0.00',0),
 (2011,1,16,111,0,'0.00',0),
 (2012,1,17,111,4,'0.88',0),
 (2013,1,18,111,0,'0.00',0),
 (2014,1,19,111,7,'1.54',0),
 (2015,1,1,112,55,'38.46',0),
 (2016,1,2,112,47,'32.87',0),
 (2017,1,3,112,0,'0.00',0),
 (2018,1,4,112,0,'0.00',0),
 (2019,1,5,112,16,'11.19',0),
 (2020,1,6,112,0,'0.00',0),
 (2021,1,7,112,0,'0.00',0),
 (2022,1,8,112,18,'12.59',0),
 (2023,1,9,112,2,'1.40',0),
 (2024,1,10,112,0,'0.00',0),
 (2025,1,11,112,0,'0.00',0),
 (2026,1,12,112,1,'0.70',0),
 (2027,1,13,112,0,'0.00',0),
 (2028,1,14,112,0,'0.00',0),
 (2029,1,15,112,0,'0.00',0),
 (2030,1,16,112,0,'0.00',0),
 (2031,1,17,112,1,'0.70',0),
 (2032,1,18,112,1,'0.70',0),
 (2033,1,19,112,1,'0.70',0),
 (2034,1,1,113,6165,'26.87',0),
 (2035,1,2,113,6267,'27.31',0),
 (2036,1,3,113,37,'0.16',0),
 (2037,1,4,113,10,'0.04',0),
 (2038,1,5,113,5238,'22.83',0),
 (2039,1,6,113,7,'0.03',0),
 (2040,1,7,113,50,'0.22',0),
 (2041,1,8,113,2814,'12.26',0),
 (2042,1,9,113,648,'2.82',0),
 (2043,1,10,113,7,'0.03',0),
 (2044,1,11,113,15,'0.07',0),
 (2045,1,12,113,774,'3.37',0),
 (2046,1,13,113,5,'0.02',0),
 (2047,1,14,113,30,'0.13',0),
 (2048,1,15,113,26,'0.11',0),
 (2049,1,16,113,47,'0.20',0),
 (2050,1,17,113,375,'1.63',0),
 (2051,1,18,113,25,'0.11',0),
 (2052,1,19,113,127,'0.55',0),
 (2053,1,1,114,43,'38.39',0),
 (2054,1,2,114,29,'25.89',0),
 (2055,1,3,114,1,'0.89',0),
 (2056,1,4,114,3,'2.68',0),
 (2057,1,5,114,12,'10.71',0),
 (2058,1,6,114,0,'0.00',0),
 (2059,1,7,114,1,'0.89',0),
 (2060,1,8,114,8,'7.14',0),
 (2061,1,9,114,8,'7.14',0),
 (2062,1,10,114,0,'0.00',0),
 (2063,1,11,114,0,'0.00',0),
 (2064,1,12,114,2,'1.79',0),
 (2065,1,13,114,0,'0.00',0),
 (2066,1,14,114,0,'0.00',0),
 (2067,1,15,114,0,'0.00',0),
 (2068,1,16,114,4,'3.57',0),
 (2069,1,17,114,0,'0.00',0),
 (2070,1,18,114,0,'0.00',0),
 (2071,1,19,114,0,'0.00',0),
 (2072,1,1,115,21107,'48.19',0),
 (2073,1,2,115,6998,'15.98',0),
 (2074,1,3,115,17,'0.04',0),
 (2075,1,4,115,46,'0.11',0),
 (2076,1,5,115,4217,'9.63',0),
 (2077,1,6,115,2,'0.00',0),
 (2078,1,7,115,14,'0.03',0),
 (2079,1,8,115,7498,'17.12',0),
 (2080,1,9,115,842,'1.92',0),
 (2081,1,10,115,30,'0.07',0),
 (2082,1,11,115,38,'0.09',0),
 (2083,1,12,115,727,'1.66',0),
 (2084,1,13,115,14,'0.03',0),
 (2085,1,14,115,25,'0.06',0),
 (2086,1,15,115,15,'0.03',0),
 (2087,1,16,115,62,'0.14',0),
 (2088,1,17,115,319,'0.73',0),
 (2089,1,18,115,31,'0.07',0),
 (2090,1,19,115,1363,'3.11',0),
 (2091,1,1,116,172,'32.45',0),
 (2092,1,2,116,127,'23.96',0),
 (2093,1,3,116,7,'1.32',0),
 (2094,1,4,116,0,'0.00',0),
 (2095,1,5,116,102,'19.25',0),
 (2096,1,6,116,0,'0.00',0),
 (2097,1,7,116,0,'0.00',0),
 (2098,1,8,116,67,'12.64',0),
 (2099,1,9,116,12,'2.26',0),
 (2100,1,10,116,0,'0.00',0),
 (2101,1,11,116,0,'0.00',0),
 (2102,1,12,116,21,'3.96',0),
 (2103,1,13,116,3,'0.57',0),
 (2104,1,14,116,0,'0.00',0),
 (2105,1,15,116,1,'0.19',0),
 (2106,1,16,116,0,'0.00',0),
 (2107,1,17,116,10,'1.89',0),
 (2108,1,18,116,0,'0.00',0),
 (2109,1,19,116,3,'0.57',0),
 (2110,1,1,117,35,'49.30',0),
 (2111,1,2,117,16,'22.54',0),
 (2112,1,3,117,0,'0.00',0),
 (2113,1,4,117,0,'0.00',0),
 (2114,1,5,117,11,'15.49',0),
 (2115,1,6,117,0,'0.00',0),
 (2116,1,7,117,0,'0.00',0),
 (2117,1,8,117,3,'4.23',0),
 (2118,1,9,117,0,'0.00',0),
 (2119,1,10,117,0,'0.00',0),
 (2120,1,11,117,0,'0.00',0),
 (2121,1,12,117,3,'4.23',0),
 (2122,1,13,117,0,'0.00',0),
 (2123,1,14,117,0,'0.00',0),
 (2124,1,15,117,0,'0.00',0),
 (2125,1,16,117,0,'0.00',0),
 (2126,1,17,117,0,'0.00',0),
 (2127,1,18,117,0,'0.00',0),
 (2128,1,19,117,0,'0.00',0),
 (2129,1,1,118,20,'36.36',0),
 (2130,1,2,118,13,'23.64',0),
 (2131,1,3,118,0,'0.00',0),
 (2132,1,4,118,0,'0.00',0),
 (2133,1,5,118,14,'25.45',0),
 (2134,1,6,118,0,'0.00',0),
 (2135,1,7,118,0,'0.00',0),
 (2136,1,8,118,0,'0.00',0),
 (2137,1,9,118,1,'1.82',0),
 (2138,1,10,118,0,'0.00',0),
 (2139,1,11,118,0,'0.00',0),
 (2140,1,12,118,2,'3.64',0),
 (2141,1,13,118,0,'0.00',0),
 (2142,1,14,118,0,'0.00',0),
 (2143,1,15,118,0,'0.00',0),
 (2144,1,16,118,0,'0.00',0),
 (2145,1,17,118,0,'0.00',0),
 (2146,1,18,118,0,'0.00',0),
 (2147,1,19,118,4,'7.27',0),
 (2148,1,1,119,591,'40.31',0),
 (2149,1,2,119,270,'18.42',0),
 (2150,1,3,119,0,'0.00',0),
 (2151,1,4,119,0,'0.00',0),
 (2152,1,5,119,190,'12.96',0),
 (2153,1,6,119,1,'0.07',0),
 (2154,1,7,119,0,'0.00',0),
 (2155,1,8,119,260,'17.74',0),
 (2156,1,9,119,33,'2.25',0),
 (2157,1,10,119,7,'0.48',0),
 (2158,1,11,119,1,'0.07',0),
 (2159,1,12,119,61,'4.16',0),
 (2160,1,13,119,0,'0.00',0),
 (2161,1,14,119,0,'0.00',0),
 (2162,1,15,119,3,'0.20',0),
 (2163,1,16,119,8,'0.55',0),
 (2164,1,17,119,16,'1.09',0),
 (2165,1,18,119,1,'0.07',0),
 (2166,1,19,119,12,'0.82',0),
 (2167,1,1,120,315,'35.92',0),
 (2168,1,2,120,283,'32.27',0),
 (2169,1,3,120,0,'0.00',0),
 (2170,1,4,120,0,'0.00',0),
 (2171,1,5,120,110,'12.54',0),
 (2172,1,6,120,0,'0.00',0),
 (2173,1,7,120,0,'0.00',0),
 (2174,1,8,120,61,'6.96',0),
 (2175,1,9,120,7,'0.80',0),
 (2176,1,10,120,0,'0.00',0),
 (2177,1,11,120,0,'0.00',0),
 (2178,1,12,120,68,'7.75',0),
 (2179,1,13,120,0,'0.00',0),
 (2180,1,14,120,0,'0.00',0),
 (2181,1,15,120,2,'0.23',0),
 (2182,1,16,120,5,'0.57',0),
 (2183,1,17,120,2,'0.23',0),
 (2184,1,18,120,2,'0.23',0),
 (2185,1,19,120,7,'0.80',0),
 (2186,1,1,121,66,'40.00',0),
 (2187,1,2,121,52,'31.52',0),
 (2188,1,3,121,0,'0.00',0),
 (2189,1,4,121,0,'0.00',0),
 (2190,1,5,121,21,'12.73',0),
 (2191,1,6,121,1,'0.61',0),
 (2192,1,7,121,0,'0.00',0),
 (2193,1,8,121,16,'9.70',0),
 (2194,1,9,121,1,'0.61',0),
 (2195,1,10,121,0,'0.00',0),
 (2196,1,11,121,0,'0.00',0),
 (2197,1,12,121,1,'0.61',0),
 (2198,1,13,121,0,'0.00',0),
 (2199,1,14,121,0,'0.00',0),
 (2200,1,15,121,0,'0.00',0),
 (2201,1,16,121,0,'0.00',0),
 (2202,1,17,121,1,'0.61',0),
 (2203,1,18,121,1,'0.61',0),
 (2204,1,19,121,1,'0.61',0),
 (2205,1,1,122,154,'39.90',0),
 (2206,1,2,122,105,'27.20',0),
 (2207,1,3,122,1,'0.26',0),
 (2208,1,4,122,0,'0.00',0),
 (2209,1,5,122,57,'14.77',0),
 (2210,1,6,122,0,'0.00',0),
 (2211,1,7,122,0,'0.00',0),
 (2212,1,8,122,29,'7.51',0),
 (2213,1,9,122,4,'1.04',0),
 (2214,1,10,122,0,'0.00',0),
 (2215,1,11,122,0,'0.00',0),
 (2216,1,12,122,17,'4.40',0),
 (2217,1,13,122,1,'0.26',0),
 (2218,1,14,122,0,'0.00',0),
 (2219,1,15,122,1,'0.26',0),
 (2220,1,16,122,1,'0.26',0),
 (2221,1,17,122,6,'1.55',0),
 (2222,1,18,122,0,'0.00',0),
 (2223,1,19,122,4,'1.04',0),
 (2224,1,1,123,7797,'19.06',0),
 (2225,1,2,123,10062,'24.60',0),
 (2226,1,3,123,48,'0.12',0),
 (2227,1,4,123,16,'0.04',0),
 (2228,1,5,123,12093,'29.57',0),
 (2229,1,6,123,8,'0.02',0),
 (2230,1,7,123,8,'0.02',0),
 (2231,1,8,123,5938,'14.52',0),
 (2232,1,9,123,725,'1.77',0),
 (2233,1,10,123,28,'0.07',0),
 (2234,1,11,123,19,'0.05',0),
 (2235,1,12,123,2713,'6.63',0),
 (2236,1,13,123,13,'0.03',0),
 (2237,1,14,123,47,'0.11',0),
 (2238,1,15,123,43,'0.11',0),
 (2239,1,16,123,56,'0.14',0),
 (2240,1,17,123,548,'1.34',0),
 (2241,1,18,123,55,'0.13',0),
 (2242,1,19,123,214,'0.52',0),
 (2243,1,1,124,25,'40.98',0),
 (2244,1,2,124,11,'18.03',0),
 (2245,1,3,124,0,'0.00',0),
 (2246,1,4,124,0,'0.00',0),
 (2247,1,5,124,11,'18.03',0),
 (2248,1,6,124,0,'0.00',0),
 (2249,1,7,124,0,'0.00',0),
 (2250,1,8,124,6,'9.84',0),
 (2251,1,9,124,2,'3.28',0),
 (2252,1,10,124,0,'0.00',0),
 (2253,1,11,124,0,'0.00',0),
 (2254,1,12,124,4,'6.56',0),
 (2255,1,13,124,0,'0.00',0),
 (2256,1,14,124,0,'0.00',0),
 (2257,1,15,124,0,'0.00',0),
 (2258,1,16,124,0,'0.00',0),
 (2259,1,17,124,1,'1.64',0),
 (2260,1,18,124,0,'0.00',0),
 (2261,1,19,124,0,'0.00',0),
 (2262,1,1,125,992,'47.33',0),
 (2263,1,2,125,461,'21.99',0),
 (2264,1,3,125,0,'0.00',0),
 (2265,1,4,125,1,'0.05',0),
 (2266,1,5,125,297,'14.17',0),
 (2267,1,6,125,1,'0.05',0),
 (2268,1,7,125,2,'0.10',0),
 (2269,1,8,125,155,'7.40',0),
 (2270,1,9,125,31,'1.48',0),
 (2271,1,10,125,0,'0.00',0);
INSERT INTO `elecmunicandi` (`idElecMuniCandi`,`Convocatoria_idConvocatoria`,`Candidatura_idCandidatura`,`Municipio`,`Votos`,`PorcVotos`,`Concejales`) VALUES 
 (2272,1,11,125,0,'0.00',0),
 (2273,1,12,125,66,'3.15',0),
 (2274,1,13,125,1,'0.05',0),
 (2275,1,14,125,1,'0.05',0),
 (2276,1,15,125,1,'0.05',0),
 (2277,1,16,125,8,'0.38',0),
 (2278,1,17,125,23,'1.10',0),
 (2279,1,18,125,0,'0.00',0),
 (2280,1,19,125,13,'0.62',0),
 (2281,1,1,126,13,'44.83',0),
 (2282,1,2,126,13,'44.83',0),
 (2283,1,3,126,0,'0.00',0),
 (2284,1,4,126,0,'0.00',0),
 (2285,1,5,126,0,'0.00',0),
 (2286,1,6,126,0,'0.00',0),
 (2287,1,7,126,0,'0.00',0),
 (2288,1,8,126,0,'0.00',0),
 (2289,1,9,126,1,'3.45',0),
 (2290,1,10,126,0,'0.00',0),
 (2291,1,11,126,0,'0.00',0),
 (2292,1,12,126,1,'3.45',0),
 (2293,1,13,126,0,'0.00',0),
 (2294,1,14,126,0,'0.00',0),
 (2295,1,15,126,0,'0.00',0),
 (2296,1,16,126,0,'0.00',0),
 (2297,1,17,126,0,'0.00',0),
 (2298,1,18,126,0,'0.00',0),
 (2299,1,19,126,0,'0.00',0),
 (2300,1,1,127,18595,'41.45',0),
 (2301,1,2,127,7580,'16.90',0),
 (2302,1,3,127,21,'0.05',0),
 (2303,1,4,127,51,'0.11',0),
 (2304,1,5,127,5198,'11.59',0),
 (2305,1,6,127,4,'0.01',0),
 (2306,1,7,127,6,'0.01',0),
 (2307,1,8,127,8718,'19.43',0),
 (2308,1,9,127,1116,'2.49',0),
 (2309,1,10,127,23,'0.05',0),
 (2310,1,11,127,29,'0.06',0),
 (2311,1,12,127,1065,'2.37',0),
 (2312,1,13,127,9,'0.02',0),
 (2313,1,14,127,31,'0.07',0),
 (2314,1,15,127,27,'0.06',0),
 (2315,1,16,127,82,'0.18',0),
 (2316,1,17,127,432,'0.96',0),
 (2317,1,18,127,27,'0.06',0),
 (2318,1,19,127,1290,'2.88',0),
 (2319,1,1,128,133,'41.18',0),
 (2320,1,2,128,99,'30.65',0),
 (2321,1,3,128,0,'0.00',0),
 (2322,1,4,128,0,'0.00',0),
 (2323,1,5,128,41,'12.69',0),
 (2324,1,6,128,0,'0.00',0),
 (2325,1,7,128,0,'0.00',0),
 (2326,1,8,128,27,'8.36',0),
 (2327,1,9,128,2,'0.62',0),
 (2328,1,10,128,0,'0.00',0),
 (2329,1,11,128,1,'0.31',0),
 (2330,1,12,128,10,'3.10',0),
 (2331,1,13,128,0,'0.00',0),
 (2332,1,14,128,0,'0.00',0),
 (2333,1,15,128,0,'0.00',0),
 (2334,1,16,128,0,'0.00',0),
 (2335,1,17,128,2,'0.62',0),
 (2336,1,18,128,1,'0.31',0),
 (2337,1,19,128,1,'0.31',0),
 (2338,1,1,129,1861,'35.08',0),
 (2339,1,2,129,1137,'21.43',0),
 (2340,1,3,129,8,'0.15',0),
 (2341,1,4,129,5,'0.09',0),
 (2342,1,5,129,835,'15.74',0),
 (2343,1,6,129,2,'0.04',0),
 (2344,1,7,129,2,'0.04',0),
 (2345,1,8,129,990,'18.66',0),
 (2346,1,9,129,93,'1.75',0),
 (2347,1,10,129,12,'0.23',0),
 (2348,1,11,129,3,'0.06',0),
 (2349,1,12,129,138,'2.60',0),
 (2350,1,13,129,3,'0.06',0),
 (2351,1,14,129,4,'0.08',0),
 (2352,1,15,129,6,'0.11',0),
 (2353,1,16,129,8,'0.15',0),
 (2354,1,17,129,64,'1.21',0),
 (2355,1,18,129,13,'0.25',0),
 (2356,1,19,129,54,'1.02',0),
 (2357,1,1,130,4447,'22.82',0),
 (2358,1,2,130,5333,'27.36',0),
 (2359,1,3,130,392,'2.01',0),
 (2360,1,4,130,18,'0.09',0),
 (2361,1,5,130,4487,'23.02',0),
 (2362,1,6,130,7,'0.04',0),
 (2363,1,7,130,15,'0.08',0),
 (2364,1,8,130,2122,'10.89',0),
 (2365,1,9,130,472,'2.42',0),
 (2366,1,10,130,3,'0.02',0),
 (2367,1,11,130,14,'0.07',0),
 (2368,1,12,130,1487,'7.63',0),
 (2369,1,13,130,12,'0.06',0),
 (2370,1,14,130,22,'0.11',0),
 (2371,1,15,130,28,'0.14',0),
 (2372,1,16,130,26,'0.13',0),
 (2373,1,17,130,292,'1.50',0),
 (2374,1,18,130,27,'0.14',0),
 (2375,1,19,130,74,'0.38',0),
 (2376,1,1,131,2961,'34.45',0),
 (2377,1,2,131,1886,'21.94',0),
 (2378,1,3,131,6,'0.07',0),
 (2379,1,4,131,26,'0.30',0),
 (2380,1,5,131,1505,'17.51',0),
 (2381,1,6,131,6,'0.07',0),
 (2382,1,7,131,5,'0.06',0),
 (2383,1,8,131,1327,'15.44',0),
 (2384,1,9,131,151,'1.76',0),
 (2385,1,10,131,5,'0.06',0),
 (2386,1,11,131,9,'0.10',0),
 (2387,1,12,131,280,'3.26',0),
 (2388,1,13,131,5,'0.06',0),
 (2389,1,14,131,10,'0.12',0),
 (2390,1,15,131,5,'0.06',0),
 (2391,1,16,131,22,'0.26',0),
 (2392,1,17,131,110,'1.28',0),
 (2393,1,18,131,9,'0.10',0),
 (2394,1,19,131,175,'2.04',0),
 (2395,1,1,132,2024,'26.80',0),
 (2396,1,2,132,2546,'33.71',0),
 (2397,1,3,132,11,'0.15',0),
 (2398,1,4,132,4,'0.05',0),
 (2399,1,5,132,1491,'19.74',0),
 (2400,1,6,132,7,'0.09',0),
 (2401,1,7,132,13,'0.17',0),
 (2402,1,8,132,765,'10.13',0),
 (2403,1,9,132,144,'1.91',0),
 (2404,1,10,132,5,'0.07',0),
 (2405,1,11,132,8,'0.11',0),
 (2406,1,12,132,231,'3.06',0),
 (2407,1,13,132,2,'0.03',0),
 (2408,1,14,132,2,'0.03',0),
 (2409,1,15,132,14,'0.19',0),
 (2410,1,16,132,34,'0.45',0),
 (2411,1,17,132,114,'1.51',0),
 (2412,1,18,132,19,'0.25',0),
 (2413,1,19,132,30,'0.40',0),
 (2414,1,1,133,1543,'39.53',0),
 (2415,1,2,133,1416,'36.28',0),
 (2416,1,3,133,0,'0.00',0),
 (2417,1,4,133,2,'0.05',0),
 (2418,1,5,133,439,'11.25',0),
 (2419,1,6,133,3,'0.08',0),
 (2420,1,7,133,2,'0.05',0),
 (2421,1,8,133,236,'6.05',0),
 (2422,1,9,133,13,'0.33',0),
 (2423,1,10,133,2,'0.05',0),
 (2424,1,11,133,5,'0.13',0),
 (2425,1,12,133,110,'2.82',0),
 (2426,1,13,133,6,'0.15',0),
 (2427,1,14,133,3,'0.08',0),
 (2428,1,15,133,8,'0.20',0),
 (2429,1,16,133,5,'0.13',0),
 (2430,1,17,133,28,'0.72',0),
 (2431,1,18,133,4,'0.10',0),
 (2432,1,19,133,27,'0.69',0),
 (2433,1,1,134,11482,'29.25',0),
 (2434,1,2,134,10246,'26.10',0),
 (2435,1,3,134,61,'0.16',0),
 (2436,1,4,134,51,'0.13',0),
 (2437,1,5,134,7833,'19.96',0),
 (2438,1,6,134,6,'0.02',0),
 (2439,1,7,134,33,'0.08',0),
 (2440,1,8,134,5298,'13.50',0),
 (2441,1,9,134,862,'2.20',0),
 (2442,1,10,134,37,'0.09',0),
 (2443,1,11,134,24,'0.06',0),
 (2444,1,12,134,1894,'4.83',0),
 (2445,1,13,134,10,'0.03',0),
 (2446,1,14,134,53,'0.14',0),
 (2447,1,15,134,46,'0.12',0),
 (2448,1,16,134,76,'0.19',0),
 (2449,1,17,134,403,'1.03',0),
 (2450,1,18,134,61,'0.16',0),
 (2451,1,19,134,293,'0.75',0),
 (2452,1,1,135,325,'45.01',0),
 (2453,1,2,135,165,'22.85',0),
 (2454,1,3,135,0,'0.00',0),
 (2455,1,4,135,1,'0.14',0),
 (2456,1,5,135,142,'19.67',0),
 (2457,1,6,135,0,'0.00',0),
 (2458,1,7,135,0,'0.00',0),
 (2459,1,8,135,43,'5.96',0),
 (2460,1,9,135,6,'0.83',0),
 (2461,1,10,135,0,'0.00',0),
 (2462,1,11,135,2,'0.28',0),
 (2463,1,12,135,21,'2.91',0),
 (2464,1,13,135,0,'0.00',0),
 (2465,1,14,135,0,'0.00',0),
 (2466,1,15,135,0,'0.00',0),
 (2467,1,16,135,0,'0.00',0),
 (2468,1,17,135,6,'0.83',0),
 (2469,1,18,135,0,'0.00',0),
 (2470,1,19,135,4,'0.55',0),
 (2471,1,1,136,228,'43.93',0),
 (2472,1,2,136,124,'23.89',0),
 (2473,1,3,136,8,'1.54',0),
 (2474,1,4,136,0,'0.00',0),
 (2475,1,5,136,63,'12.14',0),
 (2476,1,6,136,0,'0.00',0),
 (2477,1,7,136,0,'0.00',0),
 (2478,1,8,136,43,'8.29',0),
 (2479,1,9,136,4,'0.77',0),
 (2480,1,10,136,0,'0.00',0),
 (2481,1,11,136,0,'0.00',0),
 (2482,1,12,136,28,'5.39',0),
 (2483,1,13,136,0,'0.00',0),
 (2484,1,14,136,0,'0.00',0),
 (2485,1,15,136,0,'0.00',0),
 (2486,1,16,136,2,'0.39',0),
 (2487,1,17,136,3,'0.58',0),
 (2488,1,18,136,0,'0.00',0),
 (2489,1,19,136,3,'0.58',0),
 (2490,1,1,137,407,'33.01',0),
 (2491,1,2,137,388,'31.47',0),
 (2492,1,3,137,60,'4.87',0),
 (2493,1,4,137,1,'0.08',0),
 (2494,1,5,137,195,'15.82',0),
 (2495,1,6,137,0,'0.00',0),
 (2496,1,7,137,0,'0.00',0),
 (2497,1,8,137,119,'9.65',0),
 (2498,1,9,137,7,'0.57',0),
 (2499,1,10,137,1,'0.08',0),
 (2500,1,11,137,0,'0.00',0),
 (2501,1,12,137,19,'1.54',0),
 (2502,1,13,137,0,'0.00',0),
 (2503,1,14,137,0,'0.00',0),
 (2504,1,15,137,2,'0.16',0),
 (2505,1,16,137,3,'0.24',0),
 (2506,1,17,137,9,'0.73',0),
 (2507,1,18,137,3,'0.24',0),
 (2508,1,19,137,6,'0.49',0),
 (2509,1,1,138,29,'52.73',0),
 (2510,1,2,138,5,'9.09',0),
 (2511,1,3,138,0,'0.00',0),
 (2512,1,4,138,0,'0.00',0),
 (2513,1,5,138,12,'21.82',0),
 (2514,1,6,138,0,'0.00',0),
 (2515,1,7,138,0,'0.00',0),
 (2516,1,8,138,2,'3.64',0),
 (2517,1,9,138,3,'5.45',0),
 (2518,1,10,138,0,'0.00',0),
 (2519,1,11,138,0,'0.00',0),
 (2520,1,12,138,3,'5.45',0),
 (2521,1,13,138,0,'0.00',0),
 (2522,1,14,138,0,'0.00',0),
 (2523,1,15,138,1,'1.82',0),
 (2524,1,16,138,0,'0.00',0),
 (2525,1,17,138,0,'0.00',0),
 (2526,1,18,138,0,'0.00',0),
 (2527,1,19,138,0,'0.00',0),
 (2528,1,1,140,817,'39.05',0),
 (2529,1,2,140,445,'21.27',0),
 (2530,1,3,140,8,'0.38',0),
 (2531,1,4,140,1,'0.05',0),
 (2532,1,5,140,342,'16.35',0),
 (2533,1,6,140,0,'0.00',0),
 (2534,1,7,140,2,'0.10',0),
 (2535,1,8,140,273,'13.05',0),
 (2536,1,9,140,32,'1.53',0),
 (2537,1,10,140,1,'0.05',0),
 (2538,1,11,140,2,'0.10',0),
 (2539,1,12,140,77,'3.68',0),
 (2540,1,13,140,1,'0.05',0),
 (2541,1,14,140,1,'0.05',0),
 (2542,1,15,140,4,'0.19',0),
 (2543,1,16,140,11,'0.53',0),
 (2544,1,17,140,40,'1.91',0),
 (2545,1,18,140,3,'0.14',0),
 (2546,1,19,140,13,'0.62',0),
 (2547,1,1,141,1447,'37.24',0),
 (2548,1,2,141,646,'16.62',0),
 (2549,1,3,141,9,'0.23',0),
 (2550,1,4,141,0,'0.00',0),
 (2551,1,5,141,702,'18.06',0),
 (2552,1,6,141,3,'0.08',0),
 (2553,1,7,141,2,'0.05',0),
 (2554,1,8,141,690,'17.76',0),
 (2555,1,9,141,78,'2.01',0),
 (2556,1,10,141,5,'0.13',0),
 (2557,1,11,141,2,'0.05',0),
 (2558,1,12,141,154,'3.96',0),
 (2559,1,13,141,0,'0.00',0),
 (2560,1,14,141,2,'0.05',0),
 (2561,1,15,141,1,'0.03',0),
 (2562,1,16,141,12,'0.31',0),
 (2563,1,17,141,41,'1.06',0),
 (2564,1,18,141,6,'0.15',0),
 (2565,1,19,141,27,'0.69',0),
 (2566,1,1,143,35,'58.33',0),
 (2567,1,2,143,15,'25.00',0),
 (2568,1,3,143,0,'0.00',0),
 (2569,1,4,143,0,'0.00',0),
 (2570,1,5,143,5,'8.33',0),
 (2571,1,6,143,0,'0.00',0),
 (2572,1,7,143,0,'0.00',0),
 (2573,1,8,143,5,'8.33',0),
 (2574,1,9,143,0,'0.00',0),
 (2575,1,10,143,0,'0.00',0),
 (2576,1,11,143,0,'0.00',0),
 (2577,1,12,143,0,'0.00',0),
 (2578,1,13,143,0,'0.00',0),
 (2579,1,14,143,0,'0.00',0),
 (2580,1,15,143,0,'0.00',0),
 (2581,1,16,143,0,'0.00',0),
 (2582,1,17,143,0,'0.00',0),
 (2583,1,18,143,0,'0.00',0),
 (2584,1,19,143,0,'0.00',0),
 (2585,1,1,144,1755,'40.61',0),
 (2586,1,2,144,1011,'23.39',0),
 (2587,1,3,144,5,'0.12',0),
 (2588,1,4,144,4,'0.09',0),
 (2589,1,5,144,651,'15.06',0),
 (2590,1,6,144,1,'0.02',0),
 (2591,1,7,144,4,'0.09',0),
 (2592,1,8,144,545,'12.61',0),
 (2593,1,9,144,59,'1.37',0),
 (2594,1,10,144,3,'0.07',0),
 (2595,1,11,144,5,'0.12',0),
 (2596,1,12,144,97,'2.24',0),
 (2597,1,13,144,1,'0.02',0),
 (2598,1,14,144,0,'0.00',0),
 (2599,1,15,144,4,'0.09',0),
 (2600,1,16,144,7,'0.16',0),
 (2601,1,17,144,31,'0.72',0),
 (2602,1,18,144,2,'0.05',0),
 (2603,1,19,144,96,'2.22',0),
 (2604,1,1,145,492,'29.46',0),
 (2605,1,2,145,534,'31.98',0),
 (2606,1,3,145,0,'0.00',0),
 (2607,1,4,145,3,'0.18',0),
 (2608,1,5,145,293,'17.54',0),
 (2609,1,6,145,0,'0.00',0),
 (2610,1,7,145,1,'0.06',0),
 (2611,1,8,145,178,'10.66',0),
 (2612,1,9,145,39,'2.34',0),
 (2613,1,10,145,1,'0.06',0),
 (2614,1,11,145,3,'0.18',0),
 (2615,1,12,145,74,'4.43',0),
 (2616,1,13,145,0,'0.00',0),
 (2617,1,14,145,1,'0.06',0),
 (2618,1,15,145,1,'0.06',0),
 (2619,1,16,145,4,'0.24',0),
 (2620,1,17,145,9,'0.54',0),
 (2621,1,18,145,0,'0.00',0),
 (2622,1,19,145,13,'0.78',0),
 (2623,1,1,146,527,'45.87',0),
 (2624,1,2,146,334,'29.07',0),
 (2625,1,3,146,4,'0.35',0),
 (2626,1,4,146,0,'0.00',0),
 (2627,1,5,146,111,'9.66',0),
 (2628,1,6,146,0,'0.00',0),
 (2629,1,7,146,0,'0.00',0),
 (2630,1,8,146,131,'11.40',0),
 (2631,1,9,146,4,'0.35',0),
 (2632,1,10,146,0,'0.00',0),
 (2633,1,11,146,1,'0.09',0),
 (2634,1,12,146,18,'1.57',0),
 (2635,1,13,146,0,'0.00',0),
 (2636,1,14,146,0,'0.00',0),
 (2637,1,15,146,0,'0.00',0),
 (2638,1,16,146,2,'0.17',0),
 (2639,1,17,146,3,'0.26',0),
 (2640,1,18,146,0,'0.00',0),
 (2641,1,19,146,1,'0.09',0),
 (2642,1,1,147,322,'42.99',0),
 (2643,1,2,147,243,'32.44',0),
 (2644,1,3,147,0,'0.00',0),
 (2645,1,4,147,0,'0.00',0),
 (2646,1,5,147,101,'13.48',0),
 (2647,1,6,147,0,'0.00',0),
 (2648,1,7,147,0,'0.00',0),
 (2649,1,8,147,46,'6.14',0),
 (2650,1,9,147,5,'0.67',0),
 (2651,1,10,147,0,'0.00',0),
 (2652,1,11,147,0,'0.00',0),
 (2653,1,12,147,15,'2.00',0),
 (2654,1,13,147,0,'0.00',0),
 (2655,1,14,147,0,'0.00',0),
 (2656,1,15,147,1,'0.13',0),
 (2657,1,16,147,0,'0.00',0),
 (2658,1,17,147,4,'0.53',0),
 (2659,1,18,147,0,'0.00',0),
 (2660,1,19,147,4,'0.53',0),
 (2661,1,1,148,19036,'33.58',0),
 (2662,1,2,148,12964,'22.87',0),
 (2663,1,3,148,173,'0.31',0),
 (2664,1,4,148,39,'0.07',0),
 (2665,1,5,148,11707,'20.65',0),
 (2666,1,6,148,13,'0.02',0),
 (2667,1,7,148,25,'0.04',0),
 (2668,1,8,148,6894,'12.16',0),
 (2669,1,9,148,1251,'2.21',0),
 (2670,1,10,148,24,'0.04',0),
 (2671,1,11,148,44,'0.08',0),
 (2672,1,12,148,2274,'4.01',0),
 (2673,1,13,148,31,'0.05',0),
 (2674,1,14,148,74,'0.13',0),
 (2675,1,15,148,90,'0.16',0),
 (2676,1,16,148,116,'0.20',0),
 (2677,1,17,148,811,'1.43',0),
 (2678,1,18,148,82,'0.14',0),
 (2679,1,19,148,243,'0.43',0),
 (2680,1,1,149,1256,'32.85',0),
 (2681,1,2,149,814,'21.29',0),
 (2682,1,3,149,4,'0.10',0),
 (2683,1,4,149,4,'0.10',0),
 (2684,1,5,149,734,'19.19',0),
 (2685,1,6,149,1,'0.03',0),
 (2686,1,7,149,1,'0.03',0),
 (2687,1,8,149,588,'15.38',0),
 (2688,1,9,149,129,'3.37',0),
 (2689,1,10,149,3,'0.08',0),
 (2690,1,11,149,5,'0.13',0),
 (2691,1,12,149,135,'3.53',0),
 (2692,1,13,149,3,'0.08',0),
 (2693,1,14,149,5,'0.13',0),
 (2694,1,15,149,4,'0.10',0),
 (2695,1,16,149,7,'0.18',0),
 (2696,1,17,149,60,'1.57',0),
 (2697,1,18,149,7,'0.18',0),
 (2698,1,19,149,16,'0.42',0),
 (2699,1,1,150,894,'42.61',0),
 (2700,1,2,150,389,'18.54',0),
 (2701,1,3,150,0,'0.00',0),
 (2702,1,4,150,0,'0.00',0),
 (2703,1,5,150,355,'16.92',0),
 (2704,1,6,150,0,'0.00',0),
 (2705,1,7,150,0,'0.00',0),
 (2706,1,8,150,243,'11.58',0),
 (2707,1,9,150,39,'1.86',0),
 (2708,1,10,150,1,'0.05',0),
 (2709,1,11,150,0,'0.00',0),
 (2710,1,12,150,87,'4.15',0),
 (2711,1,13,150,0,'0.00',0),
 (2712,1,14,150,2,'0.10',0),
 (2713,1,15,150,4,'0.19',0),
 (2714,1,16,150,7,'0.33',0),
 (2715,1,17,150,25,'1.19',0),
 (2716,1,18,150,3,'0.14',0),
 (2717,1,19,150,12,'0.57',0),
 (2718,1,1,151,698,'32.71',0),
 (2719,1,2,151,749,'35.10',0),
 (2720,1,3,151,7,'0.33',0),
 (2721,1,4,151,1,'0.05',0),
 (2722,1,5,151,294,'13.78',0),
 (2723,1,6,151,0,'0.00',0),
 (2724,1,7,151,1,'0.05',0),
 (2725,1,8,151,223,'10.45',0),
 (2726,1,9,151,16,'0.75',0),
 (2727,1,10,151,2,'0.09',0),
 (2728,1,11,151,1,'0.05',0),
 (2729,1,12,151,72,'3.37',0),
 (2730,1,13,151,4,'0.19',0),
 (2731,1,14,151,2,'0.09',0),
 (2732,1,15,151,2,'0.09',0),
 (2733,1,16,151,9,'0.42',0),
 (2734,1,17,151,15,'0.70',0),
 (2735,1,18,151,0,'0.00',0),
 (2736,1,19,151,21,'0.98',0),
 (2737,1,1,152,4809,'42.59',0),
 (2738,1,2,152,1946,'17.23',0),
 (2739,1,3,152,6,'0.05',0),
 (2740,1,4,152,18,'0.16',0),
 (2741,1,5,152,1447,'12.81',0),
 (2742,1,6,152,1,'0.01',0),
 (2743,1,7,152,5,'0.04',0),
 (2744,1,8,152,1954,'17.30',0),
 (2745,1,9,152,218,'1.93',0),
 (2746,1,10,152,11,'0.10',0),
 (2747,1,11,152,5,'0.04',0),
 (2748,1,12,152,286,'2.53',0),
 (2749,1,13,152,6,'0.05',0),
 (2750,1,14,152,9,'0.08',0),
 (2751,1,15,152,8,'0.07',0),
 (2752,1,16,152,20,'0.18',0),
 (2753,1,17,152,148,'1.31',0),
 (2754,1,18,152,9,'0.08',0),
 (2755,1,19,152,232,'2.05',0),
 (2756,1,1,153,107,'21.62',0),
 (2757,1,2,153,139,'28.08',0),
 (2758,1,3,153,2,'0.40',0),
 (2759,1,4,153,0,'0.00',0),
 (2760,1,5,153,146,'29.49',0),
 (2761,1,6,153,0,'0.00',0),
 (2762,1,7,153,1,'0.20',0),
 (2763,1,8,153,34,'6.87',0),
 (2764,1,9,153,7,'1.41',0),
 (2765,1,10,153,0,'0.00',0),
 (2766,1,11,153,0,'0.00',0),
 (2767,1,12,153,27,'5.45',0),
 (2768,1,13,153,8,'1.62',0),
 (2769,1,14,153,0,'0.00',0),
 (2770,1,15,153,2,'0.40',0),
 (2771,1,16,153,2,'0.40',0),
 (2772,1,17,153,6,'1.21',0),
 (2773,1,18,153,1,'0.20',0),
 (2774,1,19,153,6,'1.21',0),
 (2775,1,1,154,1067,'30.03',0),
 (2776,1,2,154,1161,'32.68',0),
 (2777,1,3,154,32,'0.90',0),
 (2778,1,4,154,0,'0.00',0),
 (2779,1,5,154,531,'14.95',0),
 (2780,1,6,154,0,'0.00',0),
 (2781,1,7,154,0,'0.00',0),
 (2782,1,8,154,463,'13.03',0),
 (2783,1,9,154,73,'2.05',0),
 (2784,1,10,154,1,'0.03',0),
 (2785,1,11,154,0,'0.00',0),
 (2786,1,12,154,92,'2.59',0),
 (2787,1,13,154,0,'0.00',0),
 (2788,1,14,154,0,'0.00',0),
 (2789,1,15,154,6,'0.17',0),
 (2790,1,16,154,10,'0.28',0),
 (2791,1,17,154,38,'1.07',0),
 (2792,1,18,154,7,'0.20',0),
 (2793,1,19,154,16,'0.45',0),
 (2794,1,1,155,186,'42.76',0),
 (2795,1,2,155,180,'41.38',0),
 (2796,1,3,155,0,'0.00',0),
 (2797,1,4,155,0,'0.00',0),
 (2798,1,5,155,35,'8.05',0),
 (2799,1,6,155,0,'0.00',0),
 (2800,1,7,155,0,'0.00',0),
 (2801,1,8,155,16,'3.68',0),
 (2802,1,9,155,1,'0.23',0),
 (2803,1,10,155,0,'0.00',0),
 (2804,1,11,155,0,'0.00',0),
 (2805,1,12,155,14,'3.22',0),
 (2806,1,13,155,0,'0.00',0),
 (2807,1,14,155,0,'0.00',0),
 (2808,1,15,155,0,'0.00',0),
 (2809,1,16,155,1,'0.23',0),
 (2810,1,17,155,0,'0.00',0),
 (2811,1,18,155,0,'0.00',0),
 (2812,1,19,155,1,'0.23',0),
 (2813,1,1,156,248,'36.85',0),
 (2814,1,2,156,188,'27.93',0),
 (2815,1,3,156,10,'1.49',0),
 (2816,1,4,156,1,'0.15',0),
 (2817,1,5,156,107,'15.90',0),
 (2818,1,6,156,0,'0.00',0),
 (2819,1,7,156,0,'0.00',0),
 (2820,1,8,156,48,'7.13',0),
 (2821,1,9,156,14,'2.08',0),
 (2822,1,10,156,0,'0.00',0),
 (2823,1,11,156,1,'0.15',0),
 (2824,1,12,156,24,'3.57',0),
 (2825,1,13,156,2,'0.30',0),
 (2826,1,14,156,0,'0.00',0),
 (2827,1,15,156,4,'0.59',0),
 (2828,1,16,156,1,'0.15',0),
 (2829,1,17,156,5,'0.74',0),
 (2830,1,18,156,4,'0.59',0),
 (2831,1,19,156,4,'0.59',0),
 (2832,1,1,157,195,'49.49',0),
 (2833,1,2,157,84,'21.32',0),
 (2834,1,3,157,1,'0.25',0),
 (2835,1,4,157,1,'0.25',0),
 (2836,1,5,157,51,'12.94',0),
 (2837,1,6,157,0,'0.00',0),
 (2838,1,7,157,0,'0.00',0),
 (2839,1,8,157,41,'10.41',0),
 (2840,1,9,157,2,'0.51',0),
 (2841,1,10,157,0,'0.00',0),
 (2842,1,11,157,0,'0.00',0),
 (2843,1,12,157,11,'2.79',0),
 (2844,1,13,157,0,'0.00',0),
 (2845,1,14,157,0,'0.00',0),
 (2846,1,15,157,1,'0.25',0),
 (2847,1,16,157,0,'0.00',0),
 (2848,1,17,157,3,'0.76',0),
 (2849,1,18,157,0,'0.00',0),
 (2850,1,19,157,0,'0.00',0),
 (2851,1,1,158,276,'51.11',0),
 (2852,1,2,158,84,'15.56',0),
 (2853,1,3,158,0,'0.00',0),
 (2854,1,4,158,0,'0.00',0),
 (2855,1,5,158,78,'14.44',0),
 (2856,1,6,158,0,'0.00',0),
 (2857,1,7,158,1,'0.19',0),
 (2858,1,8,158,66,'12.22',0),
 (2859,1,9,158,5,'0.93',0),
 (2860,1,10,158,0,'0.00',0),
 (2861,1,11,158,0,'0.00',0),
 (2862,1,12,158,13,'2.41',0),
 (2863,1,13,158,0,'0.00',0),
 (2864,1,14,158,0,'0.00',0),
 (2865,1,15,158,0,'0.00',0),
 (2866,1,16,158,1,'0.19',0),
 (2867,1,17,158,5,'0.93',0),
 (2868,1,18,158,0,'0.00',0),
 (2869,1,19,158,4,'0.74',0),
 (2870,1,1,159,257,'49.14',0),
 (2871,1,2,159,157,'30.02',0),
 (2872,1,3,159,0,'0.00',0),
 (2873,1,4,159,1,'0.19',0),
 (2874,1,5,159,51,'9.75',0),
 (2875,1,6,159,0,'0.00',0),
 (2876,1,7,159,0,'0.00',0),
 (2877,1,8,159,24,'4.59',0),
 (2878,1,9,159,4,'0.76',0),
 (2879,1,10,159,0,'0.00',0),
 (2880,1,11,159,0,'0.00',0),
 (2881,1,12,159,8,'1.53',0),
 (2882,1,13,159,0,'0.00',0),
 (2883,1,14,159,0,'0.00',0),
 (2884,1,15,159,1,'0.19',0),
 (2885,1,16,159,0,'0.00',0),
 (2886,1,17,159,7,'1.34',0),
 (2887,1,18,159,0,'0.00',0),
 (2888,1,19,159,5,'0.96',0),
 (2889,1,1,160,2099,'38.21',0),
 (2890,1,2,160,1136,'20.68',0),
 (2891,1,3,160,8,'0.15',0),
 (2892,1,4,160,2,'0.04',0),
 (2893,1,5,160,937,'17.05',0),
 (2894,1,6,160,0,'0.00',0),
 (2895,1,7,160,0,'0.00',0),
 (2896,1,8,160,790,'14.38',0),
 (2897,1,9,160,102,'1.86',0),
 (2898,1,10,160,1,'0.02',0),
 (2899,1,11,160,4,'0.07',0),
 (2900,1,12,160,160,'2.91',0),
 (2901,1,13,160,1,'0.02',0),
 (2902,1,14,160,12,'0.22',0),
 (2903,1,15,160,7,'0.13',0),
 (2904,1,16,160,19,'0.35',0),
 (2905,1,17,160,87,'1.58',0),
 (2906,1,18,160,4,'0.07',0),
 (2907,1,19,160,58,'1.06',0),
 (2908,1,1,161,8160,'26.28',0),
 (2909,1,2,161,6943,'22.36',0),
 (2910,1,3,161,56,'0.18',0),
 (2911,1,4,161,25,'0.08',0),
 (2912,1,5,161,6192,'19.94',0),
 (2913,1,6,161,22,'0.07',0),
 (2914,1,7,161,10,'0.03',0),
 (2915,1,8,161,5970,'19.22',0),
 (2916,1,9,161,866,'2.79',0),
 (2917,1,10,161,24,'0.08',0),
 (2918,1,11,161,32,'0.10',0),
 (2919,1,12,161,1319,'4.25',0),
 (2920,1,13,161,18,'0.06',0),
 (2921,1,14,161,42,'0.14',0),
 (2922,1,15,161,53,'0.17',0),
 (2923,1,16,161,112,'0.36',0),
 (2924,1,17,161,464,'1.49',0),
 (2925,1,18,161,35,'0.11',0),
 (2926,1,19,161,316,'1.02',0),
 (2927,1,1,162,716,'40.47',0),
 (2928,1,2,162,331,'18.71',0),
 (2929,1,3,162,0,'0.00',0),
 (2930,1,4,162,0,'0.00',0),
 (2931,1,5,162,256,'14.47',0),
 (2932,1,6,162,1,'0.06',0),
 (2933,1,7,162,0,'0.00',0),
 (2934,1,8,162,287,'16.22',0),
 (2935,1,9,162,24,'1.36',0),
 (2936,1,10,162,0,'0.00',0),
 (2937,1,11,162,2,'0.11',0),
 (2938,1,12,162,52,'2.94',0),
 (2939,1,13,162,1,'0.06',0),
 (2940,1,14,162,1,'0.06',0),
 (2941,1,15,162,5,'0.28',0),
 (2942,1,16,162,4,'0.23',0),
 (2943,1,17,162,27,'1.53',0),
 (2944,1,18,162,3,'0.17',0),
 (2945,1,19,162,26,'1.47',0),
 (2946,1,1,163,98,'32.45',0),
 (2947,1,2,163,82,'27.15',0),
 (2948,1,3,163,0,'0.00',0),
 (2949,1,4,163,0,'0.00',0),
 (2950,1,5,163,60,'19.87',0),
 (2951,1,6,163,0,'0.00',0),
 (2952,1,7,163,0,'0.00',0),
 (2953,1,8,163,24,'7.95',0),
 (2954,1,9,163,6,'1.99',0),
 (2955,1,10,163,0,'0.00',0),
 (2956,1,11,163,0,'0.00',0),
 (2957,1,12,163,20,'6.62',0),
 (2958,1,13,163,0,'0.00',0),
 (2959,1,14,163,1,'0.33',0),
 (2960,1,15,163,0,'0.00',0),
 (2961,1,16,163,3,'0.99',0),
 (2962,1,17,163,2,'0.66',0),
 (2963,1,18,163,0,'0.00',0),
 (2964,1,19,163,1,'0.33',0),
 (2965,1,1,164,829,'40.86',0),
 (2966,1,2,164,468,'23.07',0),
 (2967,1,3,164,6,'0.30',0),
 (2968,1,4,164,0,'0.00',0),
 (2969,1,5,164,326,'16.07',0),
 (2970,1,6,164,1,'0.05',0),
 (2971,1,7,164,1,'0.05',0),
 (2972,1,8,164,207,'10.20',0),
 (2973,1,9,164,28,'1.38',0),
 (2974,1,10,164,4,'0.20',0),
 (2975,1,11,164,2,'0.10',0),
 (2976,1,12,164,50,'2.46',0),
 (2977,1,13,164,3,'0.15',0),
 (2978,1,14,164,1,'0.05',0),
 (2979,1,15,164,1,'0.05',0),
 (2980,1,16,164,12,'0.59',0),
 (2981,1,17,164,27,'1.33',0),
 (2982,1,18,164,5,'0.25',0),
 (2983,1,19,164,22,'1.08',0),
 (2984,1,1,165,648,'51.51',0),
 (2985,1,2,165,351,'27.90',0),
 (2986,1,3,165,1,'0.08',0),
 (2987,1,4,165,0,'0.00',0),
 (2988,1,5,165,108,'8.59',0),
 (2989,1,6,165,0,'0.00',0),
 (2990,1,7,165,0,'0.00',0),
 (2991,1,8,165,76,'6.04',0),
 (2992,1,9,165,6,'0.48',0),
 (2993,1,10,165,0,'0.00',0),
 (2994,1,11,165,2,'0.16',0),
 (2995,1,12,165,31,'2.46',0),
 (2996,1,13,165,1,'0.08',0),
 (2997,1,14,165,3,'0.24',0),
 (2998,1,15,165,3,'0.24',0),
 (2999,1,16,165,5,'0.40',0),
 (3000,1,17,165,8,'0.64',0),
 (3001,1,18,165,0,'0.00',0),
 (3002,1,19,165,1,'0.08',0),
 (3003,1,1,166,79,'33.33',0),
 (3004,1,2,166,72,'30.38',0),
 (3005,1,3,166,1,'0.42',0),
 (3006,1,4,166,0,'0.00',0),
 (3007,1,5,166,46,'19.41',0),
 (3008,1,6,166,0,'0.00',0),
 (3009,1,7,166,1,'0.42',0),
 (3010,1,8,166,20,'8.44',0),
 (3011,1,9,166,7,'2.95',0),
 (3012,1,10,166,0,'0.00',0),
 (3013,1,11,166,0,'0.00',0),
 (3014,1,12,166,5,'2.11',0),
 (3015,1,13,166,0,'0.00',0),
 (3016,1,14,166,0,'0.00',0),
 (3017,1,15,166,0,'0.00',0),
 (3018,1,16,166,0,'0.00',0),
 (3019,1,17,166,0,'0.00',0),
 (3020,1,18,166,0,'0.00',0),
 (3021,1,19,166,0,'0.00',0),
 (3022,1,1,167,1334,'23.43',0),
 (3023,1,2,167,1479,'25.98',0),
 (3024,1,3,167,92,'1.62',0),
 (3025,1,4,167,3,'0.05',0),
 (3026,1,5,167,1233,'21.66',0),
 (3027,1,6,167,1,'0.02',0),
 (3028,1,7,167,2,'0.04',0),
 (3029,1,8,167,738,'12.96',0),
 (3030,1,9,167,173,'3.04',0),
 (3031,1,10,167,2,'0.04',0),
 (3032,1,11,167,5,'0.09',0),
 (3033,1,12,167,357,'6.27',0),
 (3034,1,13,167,1,'0.02',0),
 (3035,1,14,167,6,'0.11',0),
 (3036,1,15,167,6,'0.11',0),
 (3037,1,16,167,10,'0.18',0),
 (3038,1,17,167,122,'2.14',0),
 (3039,1,18,167,9,'0.16',0),
 (3040,1,19,167,20,'0.35',0),
 (3041,1,1,168,326,'39.61',0),
 (3042,1,2,168,223,'27.10',0),
 (3043,1,3,168,1,'0.12',0),
 (3044,1,4,168,0,'0.00',0),
 (3045,1,5,168,152,'18.47',0),
 (3046,1,6,168,0,'0.00',0),
 (3047,1,7,168,0,'0.00',0),
 (3048,1,8,168,67,'8.14',0),
 (3049,1,9,168,12,'1.46',0),
 (3050,1,10,168,0,'0.00',0),
 (3051,1,11,168,0,'0.00',0),
 (3052,1,12,168,22,'2.67',0),
 (3053,1,13,168,0,'0.00',0),
 (3054,1,14,168,0,'0.00',0),
 (3055,1,15,168,0,'0.00',0),
 (3056,1,16,168,5,'0.61',0),
 (3057,1,17,168,5,'0.61',0),
 (3058,1,18,168,0,'0.00',0),
 (3059,1,19,168,1,'0.12',0),
 (3060,1,1,169,416,'38.91',0),
 (3061,1,2,169,196,'18.33',0),
 (3062,1,3,169,0,'0.00',0),
 (3063,1,4,169,1,'0.09',0),
 (3064,1,5,169,139,'13.00',0),
 (3065,1,6,169,0,'0.00',0),
 (3066,1,7,169,0,'0.00',0),
 (3067,1,8,169,185,'17.31',0),
 (3068,1,9,169,21,'1.96',0),
 (3069,1,10,169,1,'0.09',0),
 (3070,1,11,169,0,'0.00',0),
 (3071,1,12,169,42,'3.93',0),
 (3072,1,13,169,1,'0.09',0),
 (3073,1,14,169,0,'0.00',0),
 (3074,1,15,169,0,'0.00',0),
 (3075,1,16,169,3,'0.28',0),
 (3076,1,17,169,20,'1.87',0),
 (3077,1,18,169,0,'0.00',0),
 (3078,1,19,169,18,'1.68',0),
 (3079,1,1,170,614,'36.42',0),
 (3080,1,2,170,533,'31.61',0),
 (3081,1,3,170,1,'0.06',0),
 (3082,1,4,170,0,'0.00',0),
 (3083,1,5,170,149,'8.84',0),
 (3084,1,6,170,0,'0.00',0),
 (3085,1,7,170,0,'0.00',0),
 (3086,1,8,170,95,'5.63',0),
 (3087,1,9,170,17,'1.01',0),
 (3088,1,10,170,0,'0.00',0),
 (3089,1,11,170,8,'0.47',0),
 (3090,1,12,170,209,'12.40',0),
 (3091,1,13,170,1,'0.06',0),
 (3092,1,14,170,1,'0.06',0),
 (3093,1,15,170,4,'0.24',0),
 (3094,1,16,170,12,'0.71',0),
 (3095,1,17,170,9,'0.53',0),
 (3096,1,18,170,2,'0.12',0),
 (3097,1,19,170,5,'0.30',0),
 (3098,1,1,171,1397,'49.54',0),
 (3099,1,2,171,769,'27.27',0),
 (3100,1,3,171,4,'0.14',0),
 (3101,1,4,171,0,'0.00',0),
 (3102,1,5,171,303,'10.74',0),
 (3103,1,6,171,2,'0.07',0),
 (3104,1,7,171,1,'0.04',0),
 (3105,1,8,171,183,'6.49',0),
 (3106,1,9,171,12,'0.43',0),
 (3107,1,10,171,0,'0.00',0),
 (3108,1,11,171,1,'0.04',0),
 (3109,1,12,171,70,'2.48',0),
 (3110,1,13,171,0,'0.00',0),
 (3111,1,14,171,2,'0.07',0),
 (3112,1,15,171,0,'0.00',0),
 (3113,1,16,171,10,'0.35',0),
 (3114,1,17,171,15,'0.53',0),
 (3115,1,18,171,2,'0.07',0),
 (3116,1,19,171,8,'0.28',0),
 (3117,1,1,172,2125,'35.40',0),
 (3118,1,2,172,1076,'17.93',0),
 (3119,1,3,172,62,'1.03',0),
 (3120,1,4,172,9,'0.15',0),
 (3121,1,5,172,1073,'17.88',0),
 (3122,1,6,172,1,'0.02',0),
 (3123,1,7,172,3,'0.05',0),
 (3124,1,8,172,1003,'16.71',0),
 (3125,1,9,172,187,'3.12',0),
 (3126,1,10,172,8,'0.13',0),
 (3127,1,11,172,1,'0.02',0),
 (3128,1,12,172,174,'2.90',0),
 (3129,1,13,172,2,'0.03',0),
 (3130,1,14,172,8,'0.13',0),
 (3131,1,15,172,3,'0.05',0),
 (3132,1,16,172,6,'0.10',0),
 (3133,1,17,172,96,'1.60',0),
 (3134,1,18,172,5,'0.08',0),
 (3135,1,19,172,54,'0.90',0),
 (3136,1,1,173,173,'43.58',0),
 (3137,1,2,173,120,'30.23',0),
 (3138,1,3,173,0,'0.00',0),
 (3139,1,4,173,0,'0.00',0),
 (3140,1,5,173,56,'14.11',0),
 (3141,1,6,173,0,'0.00',0),
 (3142,1,7,173,0,'0.00',0),
 (3143,1,8,173,27,'6.80',0),
 (3144,1,9,173,3,'0.76',0),
 (3145,1,10,173,0,'0.00',0),
 (3146,1,11,173,0,'0.00',0),
 (3147,1,12,173,6,'1.51',0),
 (3148,1,13,173,0,'0.00',0),
 (3149,1,14,173,0,'0.00',0),
 (3150,1,15,173,1,'0.25',0),
 (3151,1,16,173,2,'0.50',0),
 (3152,1,17,173,2,'0.50',0),
 (3153,1,18,173,0,'0.00',0),
 (3154,1,19,173,1,'0.25',0),
 (3155,1,1,174,504,'41.72',0),
 (3156,1,2,174,337,'27.90',0),
 (3157,1,3,174,0,'0.00',0),
 (3158,1,4,174,0,'0.00',0),
 (3159,1,5,174,160,'13.25',0),
 (3160,1,6,174,0,'0.00',0),
 (3161,1,7,174,0,'0.00',0),
 (3162,1,8,174,130,'10.76',0),
 (3163,1,9,174,16,'1.32',0),
 (3164,1,10,174,1,'0.08',0),
 (3165,1,11,174,3,'0.25',0),
 (3166,1,12,174,21,'1.74',0),
 (3167,1,13,174,0,'0.00',0),
 (3168,1,14,174,3,'0.25',0),
 (3169,1,15,174,0,'0.00',0),
 (3170,1,16,174,2,'0.17',0),
 (3171,1,17,174,10,'0.83',0),
 (3172,1,18,174,0,'0.00',0),
 (3173,1,19,174,8,'0.66',0),
 (3174,1,1,175,272,'42.90',0),
 (3175,1,2,175,129,'20.35',0),
 (3176,1,3,175,1,'0.16',0),
 (3177,1,4,175,0,'0.00',0),
 (3178,1,5,175,82,'12.93',0),
 (3179,1,6,175,0,'0.00',0),
 (3180,1,7,175,0,'0.00',0),
 (3181,1,8,175,95,'14.98',0),
 (3182,1,9,175,8,'1.26',0),
 (3183,1,10,175,0,'0.00',0),
 (3184,1,11,175,0,'0.00',0),
 (3185,1,12,175,23,'3.63',0),
 (3186,1,13,175,0,'0.00',0),
 (3187,1,14,175,0,'0.00',0),
 (3188,1,15,175,1,'0.16',0),
 (3189,1,16,175,3,'0.47',0),
 (3190,1,17,175,5,'0.79',0),
 (3191,1,18,175,0,'0.00',0),
 (3192,1,19,175,2,'0.32',0),
 (3193,1,1,176,3782,'46.50',0),
 (3194,1,2,176,1078,'13.25',0),
 (3195,1,3,176,2,'0.02',0),
 (3196,1,4,176,9,'0.11',0),
 (3197,1,5,176,867,'10.66',0),
 (3198,1,6,176,1,'0.01',0),
 (3199,1,7,176,0,'0.00',0),
 (3200,1,8,176,1551,'19.07',0),
 (3201,1,9,176,184,'2.26',0),
 (3202,1,10,176,6,'0.07',0),
 (3203,1,11,176,6,'0.07',0),
 (3204,1,12,176,173,'2.13',0),
 (3205,1,13,176,5,'0.06',0),
 (3206,1,14,176,5,'0.06',0),
 (3207,1,15,176,2,'0.02',0),
 (3208,1,16,176,29,'0.36',0),
 (3209,1,17,176,105,'1.29',0),
 (3210,1,18,176,7,'0.09',0),
 (3211,1,19,176,215,'2.64',0),
 (3212,1,1,177,2535,'35.64',0),
 (3213,1,2,177,1497,'21.05',0),
 (3214,1,3,177,6,'0.08',0),
 (3215,1,4,177,7,'0.10',0),
 (3216,1,5,177,854,'12.01',0),
 (3217,1,6,177,1,'0.01',0),
 (3218,1,7,177,2,'0.03',0),
 (3219,1,8,177,1505,'21.16',0),
 (3220,1,9,177,151,'2.12',0),
 (3221,1,10,177,10,'0.14',0),
 (3222,1,11,177,17,'0.24',0),
 (3223,1,12,177,177,'2.49',0),
 (3224,1,13,177,1,'0.01',0),
 (3225,1,14,177,7,'0.10',0),
 (3226,1,15,177,3,'0.04',0),
 (3227,1,16,177,21,'0.30',0),
 (3228,1,17,177,98,'1.38',0),
 (3229,1,18,177,6,'0.08',0),
 (3230,1,19,177,116,'1.63',0),
 (3231,1,1,178,253,'31.27',0),
 (3232,1,2,178,262,'32.39',0),
 (3233,1,3,178,1,'0.12',0),
 (3234,1,4,178,0,'0.00',0),
 (3235,1,5,178,123,'15.20',0),
 (3236,1,6,178,0,'0.00',0),
 (3237,1,7,178,0,'0.00',0),
 (3238,1,8,178,112,'13.84',0),
 (3239,1,9,178,10,'1.24',0),
 (3240,1,10,178,0,'0.00',0),
 (3241,1,11,178,0,'0.00',0),
 (3242,1,12,178,12,'1.48',0),
 (3243,1,13,178,1,'0.12',0),
 (3244,1,14,178,2,'0.25',0),
 (3245,1,15,178,1,'0.12',0),
 (3246,1,16,178,3,'0.37',0),
 (3247,1,17,178,9,'1.11',0),
 (3248,1,18,178,2,'0.25',0),
 (3249,1,19,178,11,'1.36',0),
 (3250,1,1,179,357,'37.74',0),
 (3251,1,2,179,177,'18.71',0),
 (3252,1,3,179,2,'0.21',0),
 (3253,1,4,179,0,'0.00',0),
 (3254,1,5,179,190,'20.08',0),
 (3255,1,6,179,0,'0.00',0),
 (3256,1,7,179,0,'0.00',0),
 (3257,1,8,179,116,'12.26',0),
 (3258,1,9,179,22,'2.33',0),
 (3259,1,10,179,0,'0.00',0),
 (3260,1,11,179,1,'0.11',0),
 (3261,1,12,179,44,'4.65',0),
 (3262,1,13,179,0,'0.00',0),
 (3263,1,14,179,0,'0.00',0),
 (3264,1,15,179,2,'0.21',0),
 (3265,1,16,179,2,'0.21',0),
 (3266,1,17,179,15,'1.59',0),
 (3267,1,18,179,1,'0.11',0),
 (3268,1,19,179,5,'0.53',0),
 (3269,1,1,180,1403,'38.28',0),
 (3270,1,2,180,1289,'35.17',0),
 (3271,1,3,180,4,'0.11',0),
 (3272,1,4,180,0,'0.00',0),
 (3273,1,5,180,445,'12.14',0),
 (3274,1,6,180,3,'0.08',0),
 (3275,1,7,180,1,'0.03',0),
 (3276,1,8,180,274,'7.48',0),
 (3277,1,9,180,50,'1.36',0),
 (3278,1,10,180,0,'0.00',0),
 (3279,1,11,180,4,'0.11',0),
 (3280,1,12,180,74,'2.02',0),
 (3281,1,13,180,0,'0.00',0),
 (3282,1,14,180,1,'0.03',0),
 (3283,1,15,180,2,'0.05',0),
 (3284,1,16,180,4,'0.11',0),
 (3285,1,17,180,27,'0.74',0),
 (3286,1,18,180,11,'0.30',0),
 (3287,1,19,180,15,'0.41',0),
 (3288,1,1,181,6365,'44.99',0),
 (3289,1,2,181,2481,'17.53',0),
 (3290,1,3,181,8,'0.06',0),
 (3291,1,4,181,9,'0.06',0),
 (3292,1,5,181,1840,'13.00',0),
 (3293,1,6,181,4,'0.03',0),
 (3294,1,7,181,3,'0.02',0),
 (3295,1,8,181,1952,'13.80',0),
 (3296,1,9,181,333,'2.35',0),
 (3297,1,10,181,7,'0.05',0),
 (3298,1,11,181,9,'0.06',0),
 (3299,1,12,181,420,'2.97',0),
 (3300,1,13,181,2,'0.01',0),
 (3301,1,14,181,9,'0.06',0),
 (3302,1,15,181,8,'0.06',0),
 (3303,1,16,181,23,'0.16',0),
 (3304,1,17,181,155,'1.10',0),
 (3305,1,18,181,10,'0.07',0),
 (3306,1,19,181,339,'2.40',0),
 (3307,1,1,182,65,'35.52',0),
 (3308,1,2,182,36,'19.67',0),
 (3309,1,3,182,0,'0.00',0),
 (3310,1,4,182,0,'0.00',0),
 (3311,1,5,182,42,'22.95',0),
 (3312,1,6,182,1,'0.55',0),
 (3313,1,7,182,0,'0.00',0),
 (3314,1,8,182,14,'7.65',0),
 (3315,1,9,182,5,'2.73',0),
 (3316,1,10,182,0,'0.00',0),
 (3317,1,11,182,0,'0.00',0),
 (3318,1,12,182,12,'6.56',0),
 (3319,1,13,182,0,'0.00',0),
 (3320,1,14,182,0,'0.00',0),
 (3321,1,15,182,1,'0.55',0),
 (3322,1,16,182,0,'0.00',0),
 (3323,1,17,182,1,'0.55',0),
 (3324,1,18,182,0,'0.00',0),
 (3325,1,19,182,1,'0.55',0),
 (3326,1,1,183,233,'32.96',0),
 (3327,1,2,183,172,'24.33',0),
 (3328,1,3,183,2,'0.28',0),
 (3329,1,4,183,0,'0.00',0),
 (3330,1,5,183,190,'26.87',0),
 (3331,1,6,183,0,'0.00',0),
 (3332,1,7,183,0,'0.00',0),
 (3333,1,8,183,37,'5.23',0),
 (3334,1,9,183,6,'0.85',0),
 (3335,1,10,183,0,'0.00',0),
 (3336,1,11,183,1,'0.14',0),
 (3337,1,12,183,38,'5.37',0),
 (3338,1,13,183,0,'0.00',0),
 (3339,1,14,183,1,'0.14',0),
 (3340,1,15,183,0,'0.00',0),
 (3341,1,16,183,1,'0.14',0),
 (3342,1,17,183,12,'1.70',0),
 (3343,1,18,183,3,'0.42',0),
 (3344,1,19,183,4,'0.57',0),
 (3345,1,1,901,187,'31.64',0),
 (3346,1,2,901,196,'33.16',0),
 (3347,1,3,901,1,'0.17',0),
 (3348,1,4,901,0,'0.00',0),
 (3349,1,5,901,108,'18.27',0),
 (3350,1,6,901,1,'0.17',0),
 (3351,1,7,901,0,'0.00',0),
 (3352,1,8,901,53,'8.97',0),
 (3353,1,9,901,8,'1.35',0),
 (3354,1,10,901,0,'0.00',0),
 (3355,1,11,901,0,'0.00',0),
 (3356,1,12,901,18,'3.05',0),
 (3357,1,13,901,0,'0.00',0),
 (3358,1,14,901,1,'0.17',0),
 (3359,1,15,901,2,'0.34',0),
 (3360,1,16,901,3,'0.51',0),
 (3361,1,17,901,3,'0.51',0),
 (3362,1,18,901,0,'0.00',0),
 (3363,1,19,901,1,'0.17',0),
 (3364,1,1,902,143,'41.09',0),
 (3365,1,2,902,68,'19.54',0),
 (3366,1,3,902,0,'0.00',0),
 (3367,1,4,902,0,'0.00',0),
 (3368,1,5,902,74,'21.26',0),
 (3369,1,6,902,0,'0.00',0),
 (3370,1,7,902,0,'0.00',0),
 (3371,1,8,902,29,'8.33',0),
 (3372,1,9,902,6,'1.72',0),
 (3373,1,10,902,0,'0.00',0),
 (3374,1,11,902,0,'0.00',0),
 (3375,1,12,902,14,'4.02',0),
 (3376,1,13,902,0,'0.00',0),
 (3377,1,14,902,0,'0.00',0),
 (3378,1,15,902,1,'0.29',0),
 (3379,1,16,902,0,'0.00',0),
 (3380,1,17,902,3,'0.86',0),
 (3381,1,18,902,0,'0.00',0),
 (3382,1,19,902,2,'0.57',0),
 (3383,1,1,903,7392,'30.75',0),
 (3384,1,2,903,5547,'23.07',0),
 (3385,1,3,903,9,'0.04',0),
 (3386,1,4,903,28,'0.12',0),
 (3387,1,5,903,4507,'18.75',0),
 (3388,1,6,903,4,'0.02',0),
 (3389,1,7,903,8,'0.03',0),
 (3390,1,8,903,3805,'15.83',0),
 (3391,1,9,903,609,'2.53',0),
 (3392,1,10,903,20,'0.08',0),
 (3393,1,11,903,14,'0.06',0),
 (3394,1,12,903,1051,'4.37',0),
 (3395,1,13,903,6,'0.02',0),
 (3396,1,14,903,27,'0.11',0),
 (3397,1,15,903,16,'0.07',0),
 (3398,1,16,903,35,'0.15',0),
 (3399,1,17,903,204,'0.85',0),
 (3400,1,18,903,19,'0.08',0),
 (3401,1,19,903,407,'1.69',0),
 (3402,1,1,999,2628,'26.09',0),
 (3403,1,2,999,1882,'18.68',0),
 (3404,1,3,999,10,'0.10',0),
 (3405,1,4,999,19,'0.19',0),
 (3406,1,5,999,2971,'29.49',0),
 (3407,1,6,999,3,'0.03',0),
 (3408,1,7,999,10,'0.10',0),
 (3409,1,8,999,1403,'13.93',0),
 (3410,1,9,999,229,'2.27',0),
 (3411,1,10,999,14,'0.14',0),
 (3412,1,11,999,11,'0.11',0),
 (3413,1,12,999,510,'5.06',0),
 (3414,1,13,999,0,'0.00',0),
 (3415,1,14,999,13,'0.13',0),
 (3416,1,15,999,14,'0.14',0),
 (3417,1,16,999,7,'0.07',0),
 (3418,1,17,999,81,'0.80',0),
 (3419,1,18,999,13,'0.13',0),
 (3420,1,19,999,190,'1.89',0),
 (3421,2,1,1,41,'82.00',0),
 (3422,2,2,1,3,'6.00',0),
 (3423,2,4,1,0,'0.00',0),
 (3424,2,6,1,0,'0.00',0),
 (3425,2,7,1,0,'0.00',0),
 (3426,2,8,1,0,'0.00',0),
 (3427,2,9,1,0,'0.00',0),
 (3428,2,13,1,0,'0.00',0),
 (3429,2,14,1,0,'0.00',0),
 (3430,2,15,1,0,'0.00',0),
 (3431,2,16,1,0,'0.00',0),
 (3432,2,17,1,0,'0.00',0),
 (3433,2,20,1,2,'4.00',0),
 (3434,2,21,1,0,'0.00',0),
 (3435,2,22,1,0,'0.00',0),
 (3436,2,23,1,2,'4.00',0),
 (3437,2,24,1,0,'0.00',0),
 (3438,2,25,1,0,'0.00',0),
 (3439,2,1,2,1129,'60.57',0),
 (3440,2,2,2,457,'24.52',0),
 (3441,2,4,2,6,'0.32',0),
 (3442,2,6,2,0,'0.00',0),
 (3443,2,7,2,0,'0.00',0),
 (3444,2,8,2,2,'0.11',0),
 (3445,2,9,2,89,'4.77',0),
 (3446,2,13,2,1,'0.05',0),
 (3447,2,14,2,0,'0.00',0),
 (3448,2,15,2,2,'0.11',0),
 (3449,2,16,2,5,'0.27',0),
 (3450,2,17,2,14,'0.75',0),
 (3451,2,20,2,92,'4.94',0),
 (3452,2,21,2,8,'0.43',0),
 (3453,2,22,2,2,'0.11',0),
 (3454,2,23,2,5,'0.27',0),
 (3455,2,24,2,0,'0.00',0),
 (3456,2,25,2,1,'0.05',0),
 (3457,2,1,3,72,'46.45',0),
 (3458,2,2,3,55,'35.48',0),
 (3459,2,4,3,1,'0.65',0),
 (3460,2,6,3,0,'0.00',0),
 (3461,2,7,3,1,'0.65',0),
 (3462,2,8,3,1,'0.65',0),
 (3463,2,9,3,6,'3.87',0),
 (3464,2,13,3,0,'0.00',0),
 (3465,2,14,3,1,'0.65',0),
 (3466,2,15,3,0,'0.00',0),
 (3467,2,16,3,1,'0.65',0),
 (3468,2,17,3,1,'0.65',0),
 (3469,2,20,3,11,'7.10',0),
 (3470,2,21,3,0,'0.00',0),
 (3471,2,22,3,0,'0.00',0),
 (3472,2,23,3,0,'0.00',0),
 (3473,2,24,3,0,'0.00',0),
 (3474,2,25,3,0,'0.00',0),
 (3475,2,1,4,2286,'60.78',0),
 (3476,2,2,4,982,'26.11',0),
 (3477,2,4,4,1,'0.03',0),
 (3478,2,6,4,0,'0.00',0),
 (3479,2,7,4,0,'0.00',0),
 (3480,2,8,4,0,'0.00',0),
 (3481,2,9,4,106,'2.82',0),
 (3482,2,13,4,0,'0.00',0),
 (3483,2,14,4,0,'0.00',0),
 (3484,2,15,4,4,'0.11',0),
 (3485,2,16,4,12,'0.32',0),
 (3486,2,17,4,12,'0.32',0),
 (3487,2,20,4,240,'6.38',0),
 (3488,2,21,4,12,'0.32',0),
 (3489,2,22,4,6,'0.16',0),
 (3490,2,23,4,29,'0.77',0),
 (3491,2,24,4,0,'0.00',0),
 (3492,2,25,4,1,'0.03',0),
 (3493,2,1,5,39829,'45.84',0),
 (3494,2,2,5,26808,'30.85',0),
 (3495,2,4,5,169,'0.19',0),
 (3496,2,6,5,18,'0.02',0),
 (3497,2,7,5,68,'0.08',0),
 (3498,2,8,5,111,'0.13',0),
 (3499,2,9,5,6388,'7.35',0),
 (3500,2,13,5,101,'0.12',0),
 (3501,2,14,5,140,'0.16',0),
 (3502,2,15,5,214,'0.25',0),
 (3503,2,16,5,461,'0.53',0),
 (3504,2,17,5,430,'0.49',0),
 (3505,2,20,5,8330,'9.59',0),
 (3506,2,21,5,429,'0.49',0),
 (3507,2,22,5,151,'0.17',0),
 (3508,2,23,5,1111,'1.28',0),
 (3509,2,24,5,50,'0.06',0),
 (3510,2,25,5,83,'0.10',0),
 (3511,2,1,6,26316,'52.40',0),
 (3512,2,2,6,12713,'25.31',0),
 (3513,2,4,6,80,'0.16',0),
 (3514,2,6,6,26,'0.05',0),
 (3515,2,7,6,22,'0.04',0),
 (3516,2,8,6,80,'0.16',0),
 (3517,2,9,6,4546,'9.05',0),
 (3518,2,13,6,17,'0.03',0),
 (3519,2,14,6,96,'0.19',0),
 (3520,2,15,6,89,'0.18',0),
 (3521,2,16,6,117,'0.23',0),
 (3522,2,17,6,268,'0.53',0),
 (3523,2,20,6,3660,'7.29',0),
 (3524,2,21,6,322,'0.64',0),
 (3525,2,22,6,159,'0.32',0),
 (3526,2,23,6,584,'1.16',0),
 (3527,2,24,6,21,'0.04',0),
 (3528,2,25,6,41,'0.08',0),
 (3529,2,1,7,41490,'48.96',0),
 (3530,2,2,7,25805,'30.45',0),
 (3531,2,4,7,66,'0.08',0),
 (3532,2,6,7,29,'0.03',0),
 (3533,2,7,7,32,'0.04',0),
 (3534,2,8,7,113,'0.13',0),
 (3535,2,9,7,5470,'6.45',0),
 (3536,2,13,7,35,'0.04',0),
 (3537,2,14,7,108,'0.13',0),
 (3538,2,15,7,289,'0.34',0),
 (3539,2,16,7,136,'0.16',0),
 (3540,2,17,7,430,'0.51',0),
 (3541,2,20,7,7279,'8.59',0),
 (3542,2,21,7,387,'0.46',0),
 (3543,2,22,7,219,'0.26',0),
 (3544,2,23,7,781,'0.92',0),
 (3545,2,24,7,37,'0.04',0),
 (3546,2,25,7,85,'0.10',0),
 (3547,2,1,8,816,'62.53',0),
 (3548,2,2,8,330,'25.29',0),
 (3549,2,4,8,0,'0.00',0),
 (3550,2,6,8,1,'0.08',0),
 (3551,2,7,8,0,'0.00',0),
 (3552,2,8,8,0,'0.00',0),
 (3553,2,9,8,23,'1.76',0),
 (3554,2,13,8,0,'0.00',0),
 (3555,2,14,8,1,'0.08',0),
 (3556,2,15,8,2,'0.15',0),
 (3557,2,16,8,0,'0.00',0),
 (3558,2,17,8,14,'1.07',0),
 (3559,2,20,8,60,'4.60',0),
 (3560,2,21,8,6,'0.46',0),
 (3561,2,22,8,5,'0.38',0),
 (3562,2,23,8,14,'1.07',0),
 (3563,2,24,8,1,'0.08',0),
 (3564,2,25,8,1,'0.08',0),
 (3565,2,1,9,5165,'55.98',0),
 (3566,2,2,9,2201,'23.85',0),
 (3567,2,4,9,21,'0.23',0),
 (3568,2,6,9,1,'0.01',0),
 (3569,2,7,9,2,'0.02',0),
 (3570,2,8,9,17,'0.18',0),
 (3571,2,9,9,575,'6.23',0),
 (3572,2,13,9,1,'0.01',0),
 (3573,2,14,9,9,'0.10',0),
 (3574,2,15,9,10,'0.11',0),
 (3575,2,16,9,24,'0.26',0),
 (3576,2,17,9,60,'0.65',0),
 (3577,2,20,9,759,'8.23',0),
 (3578,2,21,9,48,'0.52',0),
 (3579,2,22,9,14,'0.15',0),
 (3580,2,23,9,96,'1.04',0),
 (3581,2,24,9,3,'0.03',0),
 (3582,2,25,9,7,'0.08',0),
 (3583,2,1,10,3634,'56.31',0),
 (3584,2,2,10,1400,'21.70',0),
 (3585,2,4,10,12,'0.19',0),
 (3586,2,6,10,4,'0.06',0),
 (3587,2,7,10,1,'0.02',0),
 (3588,2,8,10,11,'0.17',0),
 (3589,2,9,10,402,'6.23',0),
 (3590,2,13,10,5,'0.08',0),
 (3591,2,14,10,3,'0.05',0),
 (3592,2,15,10,14,'0.22',0),
 (3593,2,16,10,17,'0.26',0),
 (3594,2,17,10,25,'0.39',0),
 (3595,2,20,10,631,'9.78',0),
 (3596,2,21,10,37,'0.57',0),
 (3597,2,22,10,15,'0.23',0),
 (3598,2,23,10,68,'1.05',0),
 (3599,2,24,10,3,'0.05',0),
 (3600,2,25,10,6,'0.09',0),
 (3601,2,1,11,207,'60.70',0),
 (3602,2,2,11,60,'17.60',0),
 (3603,2,4,11,0,'0.00',0),
 (3604,2,6,11,0,'0.00',0),
 (3605,2,7,11,0,'0.00',0),
 (3606,2,8,11,0,'0.00',0),
 (3607,2,9,11,8,'2.35',0),
 (3608,2,13,11,2,'0.59',0),
 (3609,2,14,11,0,'0.00',0),
 (3610,2,15,11,3,'0.88',0),
 (3611,2,16,11,2,'0.59',0),
 (3612,2,17,11,0,'0.00',0),
 (3613,2,20,11,53,'15.54',0),
 (3614,2,21,11,1,'0.29',0),
 (3615,2,22,11,1,'0.29',0),
 (3616,2,23,11,0,'0.00',0),
 (3617,2,24,11,0,'0.00',0),
 (3618,2,25,11,0,'0.00',0),
 (3619,2,1,12,359,'54.98',0),
 (3620,2,2,12,217,'33.23',0),
 (3621,2,4,12,0,'0.00',0),
 (3622,2,6,12,1,'0.15',0),
 (3623,2,7,12,0,'0.00',0),
 (3624,2,8,12,1,'0.15',0),
 (3625,2,9,12,20,'3.06',0),
 (3626,2,13,12,0,'0.00',0),
 (3627,2,14,12,2,'0.31',0),
 (3628,2,15,12,0,'0.00',0),
 (3629,2,16,12,2,'0.31',0),
 (3630,2,17,12,3,'0.46',0),
 (3631,2,20,12,27,'4.13',0),
 (3632,2,21,12,0,'0.00',0),
 (3633,2,22,12,0,'0.00',0),
 (3634,2,23,12,2,'0.31',0),
 (3635,2,24,12,0,'0.00',0),
 (3636,2,25,12,2,'0.31',0),
 (3637,2,1,13,13220,'52.16',0),
 (3638,2,2,13,7613,'30.04',0),
 (3639,2,4,13,27,'0.11',0),
 (3640,2,6,13,3,'0.01',0),
 (3641,2,7,13,12,'0.05',0),
 (3642,2,8,13,21,'0.08',0),
 (3643,2,9,13,1119,'4.41',0),
 (3644,2,13,13,5,'0.02',0),
 (3645,2,14,13,33,'0.13',0),
 (3646,2,15,13,126,'0.50',0),
 (3647,2,16,13,50,'0.20',0),
 (3648,2,17,13,106,'0.42',0),
 (3649,2,20,13,2051,'8.09',0),
 (3650,2,21,13,124,'0.49',0),
 (3651,2,22,13,57,'0.22',0),
 (3652,2,23,13,189,'0.75',0),
 (3653,2,24,13,14,'0.06',0),
 (3654,2,25,13,9,'0.04',0),
 (3655,2,1,14,10627,'53.60',0),
 (3656,2,2,14,4975,'25.09',0),
 (3657,2,4,14,15,'0.08',0),
 (3658,2,6,14,9,'0.05',0),
 (3659,2,7,14,11,'0.06',0),
 (3660,2,8,14,32,'0.16',0),
 (3661,2,9,14,1130,'5.70',0),
 (3662,2,13,14,4,'0.02',0),
 (3663,2,14,14,7,'0.04',0),
 (3664,2,15,14,32,'0.16',0),
 (3665,2,16,14,50,'0.25',0),
 (3666,2,17,14,101,'0.51',0),
 (3667,2,20,14,2093,'10.56',0),
 (3668,2,21,14,85,'0.43',0),
 (3669,2,22,14,45,'0.23',0),
 (3670,2,23,14,115,'0.58',0),
 (3671,2,24,14,10,'0.05',0),
 (3672,2,25,14,13,'0.07',0),
 (3673,2,1,15,5169,'55.74',0),
 (3674,2,2,15,1816,'19.58',0),
 (3675,2,4,15,5,'0.05',0),
 (3676,2,6,15,6,'0.06',0),
 (3677,2,7,15,5,'0.05',0),
 (3678,2,8,15,6,'0.06',0),
 (3679,2,9,15,839,'9.05',0),
 (3680,2,13,15,1,'0.01',0),
 (3681,2,14,15,14,'0.15',0),
 (3682,2,15,15,16,'0.17',0),
 (3683,2,16,15,31,'0.33',0),
 (3684,2,17,15,66,'0.71',0),
 (3685,2,20,15,728,'7.85',0),
 (3686,2,21,15,71,'0.77',0),
 (3687,2,22,15,19,'0.20',0),
 (3688,2,23,15,136,'1.47',0),
 (3689,2,24,15,4,'0.04',0),
 (3690,2,25,15,7,'0.08',0),
 (3691,2,1,16,24,'36.36',0),
 (3692,2,2,16,28,'42.42',0),
 (3693,2,4,16,0,'0.00',0),
 (3694,2,6,16,0,'0.00',0),
 (3695,2,7,16,0,'0.00',0),
 (3696,2,8,16,0,'0.00',0),
 (3697,2,9,16,2,'3.03',0),
 (3698,2,13,16,0,'0.00',0),
 (3699,2,14,16,0,'0.00',0),
 (3700,2,15,16,1,'1.52',0),
 (3701,2,16,16,1,'1.52',0),
 (3702,2,17,16,0,'0.00',0),
 (3703,2,20,16,6,'9.09',0),
 (3704,2,21,16,1,'1.52',0),
 (3705,2,22,16,0,'0.00',0),
 (3706,2,23,16,1,'1.52',0),
 (3707,2,24,16,0,'0.00',0),
 (3708,2,25,16,0,'0.00',0),
 (3709,2,1,17,423,'52.81',0),
 (3710,2,2,17,184,'22.97',0),
 (3711,2,4,17,0,'0.00',0),
 (3712,2,6,17,3,'0.37',0),
 (3713,2,7,17,1,'0.12',0),
 (3714,2,8,17,0,'0.00',0),
 (3715,2,9,17,95,'11.86',0),
 (3716,2,13,17,0,'0.00',0),
 (3717,2,14,17,1,'0.12',0),
 (3718,2,15,17,0,'0.00',0),
 (3719,2,16,17,4,'0.50',0),
 (3720,2,17,17,6,'0.75',0),
 (3721,2,20,17,53,'6.62',0),
 (3722,2,21,17,6,'0.75',0),
 (3723,2,22,17,0,'0.00',0),
 (3724,2,23,17,11,'1.37',0),
 (3725,2,24,17,0,'0.00',0),
 (3726,2,25,17,2,'0.25',0),
 (3727,2,1,18,1545,'58.95',0),
 (3728,2,2,18,632,'24.11',0),
 (3729,2,4,18,3,'0.11',0),
 (3730,2,6,18,0,'0.00',0),
 (3731,2,7,18,2,'0.08',0),
 (3732,2,8,18,2,'0.08',0),
 (3733,2,9,18,76,'2.90',0),
 (3734,2,13,18,2,'0.08',0),
 (3735,2,14,18,3,'0.11',0),
 (3736,2,15,18,8,'0.31',0),
 (3737,2,16,18,6,'0.23',0),
 (3738,2,17,18,12,'0.46',0),
 (3739,2,20,18,249,'9.50',0),
 (3740,2,21,18,11,'0.42',0),
 (3741,2,22,18,5,'0.19',0),
 (3742,2,23,18,19,'0.72',0),
 (3743,2,24,18,0,'0.00',0),
 (3744,2,25,18,0,'0.00',0),
 (3745,2,1,19,410,'46.22',0),
 (3746,2,2,19,361,'40.70',0),
 (3747,2,4,19,1,'0.11',0),
 (3748,2,6,19,0,'0.00',0),
 (3749,2,7,19,0,'0.00',0),
 (3750,2,8,19,0,'0.00',0),
 (3751,2,9,19,26,'2.93',0),
 (3752,2,13,19,0,'0.00',0),
 (3753,2,14,19,0,'0.00',0),
 (3754,2,15,19,2,'0.23',0),
 (3755,2,16,19,3,'0.34',0),
 (3756,2,17,19,4,'0.45',0),
 (3757,2,20,19,54,'6.09',0),
 (3758,2,21,19,1,'0.11',0),
 (3759,2,22,19,1,'0.11',0),
 (3760,2,23,19,9,'1.01',0),
 (3761,2,24,19,1,'0.11',0),
 (3762,2,25,19,3,'0.34',0),
 (3763,2,1,20,46,'41.44',0),
 (3764,2,2,20,34,'30.63',0),
 (3765,2,4,20,0,'0.00',0),
 (3766,2,6,20,0,'0.00',0),
 (3767,2,7,20,1,'0.90',0),
 (3768,2,8,20,0,'0.00',0),
 (3769,2,9,20,5,'4.50',0),
 (3770,2,13,20,0,'0.00',0),
 (3771,2,14,20,0,'0.00',0),
 (3772,2,15,20,0,'0.00',0),
 (3773,2,16,20,0,'0.00',0),
 (3774,2,17,20,1,'0.90',0),
 (3775,2,20,20,21,'18.92',0),
 (3776,2,21,20,0,'0.00',0),
 (3777,2,22,20,2,'1.80',0),
 (3778,2,23,20,0,'0.00',0),
 (3779,2,24,20,0,'0.00',0),
 (3780,2,25,20,0,'0.00',0),
 (3781,2,1,21,174,'54.21',0),
 (3782,2,2,21,65,'20.25',0),
 (3783,2,4,21,1,'0.31',0),
 (3784,2,6,21,0,'0.00',0),
 (3785,2,7,21,0,'0.00',0),
 (3786,2,8,21,1,'0.31',0),
 (3787,2,9,21,20,'6.23',0),
 (3788,2,13,21,0,'0.00',0),
 (3789,2,14,21,1,'0.31',0),
 (3790,2,15,21,0,'0.00',0),
 (3791,2,16,21,5,'1.56',0),
 (3792,2,17,21,3,'0.93',0),
 (3793,2,20,21,25,'7.79',0),
 (3794,2,21,21,4,'1.25',0),
 (3795,2,22,21,1,'0.31',0),
 (3796,2,23,21,7,'2.18',0),
 (3797,2,24,21,1,'0.31',0),
 (3798,2,25,21,0,'0.00',0),
 (3799,2,1,22,14150,'65.41',0),
 (3800,2,2,22,3403,'15.73',0),
 (3801,2,4,22,60,'0.28',0),
 (3802,2,6,22,6,'0.03',0),
 (3803,2,7,22,10,'0.05',0),
 (3804,2,8,22,48,'0.22',0),
 (3805,2,9,22,1833,'8.47',0),
 (3806,2,13,22,5,'0.02',0),
 (3807,2,14,22,14,'0.06',0),
 (3808,2,15,22,17,'0.08',0),
 (3809,2,16,22,43,'0.20',0),
 (3810,2,17,22,91,'0.42',0),
 (3811,2,20,22,974,'4.50',0),
 (3812,2,21,22,125,'0.58',0),
 (3813,2,22,22,82,'0.38',0),
 (3814,2,23,22,177,'0.82',0),
 (3815,2,24,22,7,'0.03',0),
 (3816,2,25,22,9,'0.04',0),
 (3817,2,1,23,1823,'55.97',0),
 (3818,2,2,23,695,'21.34',0),
 (3819,2,4,23,5,'0.15',0),
 (3820,2,6,23,2,'0.06',0),
 (3821,2,7,23,0,'0.00',0),
 (3822,2,8,23,3,'0.09',0),
 (3823,2,9,23,159,'4.88',0),
 (3824,2,13,23,0,'0.00',0),
 (3825,2,14,23,4,'0.12',0),
 (3826,2,15,23,6,'0.18',0),
 (3827,2,16,23,4,'0.12',0),
 (3828,2,17,23,24,'0.74',0),
 (3829,2,20,23,388,'11.91',0),
 (3830,2,21,23,16,'0.49',0),
 (3831,2,22,23,2,'0.06',0),
 (3832,2,23,23,32,'0.98',0),
 (3833,2,24,23,2,'0.06',0),
 (3834,2,25,23,0,'0.00',0),
 (3835,2,1,24,83,'59.71',0),
 (3836,2,2,24,24,'17.27',0),
 (3837,2,4,24,0,'0.00',0),
 (3838,2,6,24,0,'0.00',0),
 (3839,2,7,24,0,'0.00',0),
 (3840,2,8,24,0,'0.00',0),
 (3841,2,9,24,4,'2.88',0),
 (3842,2,13,24,0,'0.00',0),
 (3843,2,14,24,0,'0.00',0),
 (3844,2,15,24,0,'0.00',0),
 (3845,2,16,24,3,'2.16',0),
 (3846,2,17,24,0,'0.00',0),
 (3847,2,20,24,14,'10.07',0),
 (3848,2,21,24,1,'0.72',0),
 (3849,2,22,24,0,'0.00',0),
 (3850,2,23,24,4,'2.88',0),
 (3851,2,24,24,0,'0.00',0),
 (3852,2,25,24,0,'0.00',0),
 (3853,2,1,25,226,'66.28',0),
 (3854,2,2,25,92,'26.98',0),
 (3855,2,4,25,0,'0.00',0),
 (3856,2,6,25,0,'0.00',0),
 (3857,2,7,25,0,'0.00',0),
 (3858,2,8,25,0,'0.00',0),
 (3859,2,9,25,3,'0.88',0),
 (3860,2,13,25,0,'0.00',0),
 (3861,2,14,25,0,'0.00',0),
 (3862,2,15,25,1,'0.29',0),
 (3863,2,16,25,2,'0.59',0),
 (3864,2,17,25,1,'0.29',0),
 (3865,2,20,25,9,'2.64',0),
 (3866,2,21,25,2,'0.59',0),
 (3867,2,22,25,0,'0.00',0),
 (3868,2,23,25,0,'0.00',0),
 (3869,2,24,25,0,'0.00',0),
 (3870,2,25,25,1,'0.29',0),
 (3871,2,1,26,2238,'58.65',0),
 (3872,2,2,26,746,'19.55',0),
 (3873,2,4,26,6,'0.16',0),
 (3874,2,6,26,1,'0.03',0),
 (3875,2,7,26,2,'0.05',0),
 (3876,2,8,26,3,'0.08',0),
 (3877,2,9,26,267,'7.00',0),
 (3878,2,13,26,1,'0.03',0),
 (3879,2,14,26,2,'0.05',0),
 (3880,2,15,26,6,'0.16',0),
 (3881,2,16,26,21,'0.55',0),
 (3882,2,17,26,28,'0.73',0),
 (3883,2,20,26,356,'9.33',0),
 (3884,2,21,26,18,'0.47',0),
 (3885,2,22,26,7,'0.18',0),
 (3886,2,23,26,24,'0.63',0),
 (3887,2,24,26,3,'0.08',0),
 (3888,2,25,26,6,'0.16',0),
 (3889,2,1,27,490,'55.62',0),
 (3890,2,2,27,232,'26.33',0),
 (3891,2,4,27,0,'0.00',0),
 (3892,2,6,27,1,'0.11',0),
 (3893,2,7,27,0,'0.00',0),
 (3894,2,8,27,0,'0.00',0),
 (3895,2,9,27,46,'5.22',0),
 (3896,2,13,27,0,'0.00',0),
 (3897,2,14,27,0,'0.00',0),
 (3898,2,15,27,0,'0.00',0),
 (3899,2,16,27,4,'0.45',0),
 (3900,2,17,27,7,'0.79',0),
 (3901,2,20,27,58,'6.58',0),
 (3902,2,21,27,2,'0.23',0),
 (3903,2,22,27,2,'0.23',0),
 (3904,2,23,27,2,'0.23',0),
 (3905,2,24,27,0,'0.00',0),
 (3906,2,25,27,0,'0.00',0),
 (3907,2,1,28,510,'45.58',0),
 (3908,2,2,28,304,'27.17',0),
 (3909,2,4,28,1,'0.09',0),
 (3910,2,6,28,0,'0.00',0),
 (3911,2,7,28,1,'0.09',0),
 (3912,2,8,28,1,'0.09',0),
 (3913,2,9,28,31,'2.77',0),
 (3914,2,13,28,1,'0.09',0),
 (3915,2,14,28,2,'0.18',0),
 (3916,2,15,28,1,'0.09',0),
 (3917,2,16,28,5,'0.45',0),
 (3918,2,17,28,9,'0.80',0),
 (3919,2,20,28,201,'17.96',0),
 (3920,2,21,28,6,'0.54',0),
 (3921,2,22,28,4,'0.36',0),
 (3922,2,23,28,13,'1.16',0),
 (3923,2,24,28,0,'0.00',0),
 (3924,2,25,28,0,'0.00',0),
 (3925,2,1,29,255,'60.00',0),
 (3926,2,2,29,104,'24.47',0),
 (3927,2,4,29,0,'0.00',0),
 (3928,2,6,29,0,'0.00',0),
 (3929,2,7,29,0,'0.00',0),
 (3930,2,8,29,0,'0.00',0),
 (3931,2,9,29,8,'1.88',0),
 (3932,2,13,29,0,'0.00',0),
 (3933,2,14,29,0,'0.00',0),
 (3934,2,15,29,1,'0.24',0),
 (3935,2,16,29,1,'0.24',0),
 (3936,2,17,29,3,'0.71',0),
 (3937,2,20,29,27,'6.35',0),
 (3938,2,21,29,1,'0.24',0),
 (3939,2,22,29,2,'0.47',0),
 (3940,2,23,29,5,'1.18',0),
 (3941,2,24,29,0,'0.00',0),
 (3942,2,25,29,9,'2.12',0),
 (3943,2,1,30,610,'52.27',0),
 (3944,2,2,30,346,'29.65',0),
 (3945,2,4,30,1,'0.09',0),
 (3946,2,6,30,0,'0.00',0),
 (3947,2,7,30,0,'0.00',0),
 (3948,2,8,30,2,'0.17',0),
 (3949,2,9,30,43,'3.68',0),
 (3950,2,13,30,1,'0.09',0),
 (3951,2,14,30,1,'0.09',0),
 (3952,2,15,30,3,'0.26',0),
 (3953,2,16,30,4,'0.34',0),
 (3954,2,17,30,13,'1.11',0),
 (3955,2,20,30,91,'7.80',0),
 (3956,2,21,30,6,'0.51',0),
 (3957,2,22,30,3,'0.26',0),
 (3958,2,23,30,18,'1.54',0),
 (3959,2,24,30,1,'0.09',0),
 (3960,2,25,30,1,'0.09',0),
 (3961,2,1,31,969,'59.89',0),
 (3962,2,2,31,564,'34.86',0),
 (3963,2,4,31,0,'0.00',0),
 (3964,2,6,31,0,'0.00',0),
 (3965,2,7,31,0,'0.00',0),
 (3966,2,8,31,1,'0.06',0),
 (3967,2,9,31,9,'0.56',0),
 (3968,2,13,31,0,'0.00',0),
 (3969,2,14,31,0,'0.00',0),
 (3970,2,15,31,1,'0.06',0),
 (3971,2,16,31,2,'0.12',0),
 (3972,2,17,31,0,'0.00',0),
 (3973,2,20,31,49,'3.03',0),
 (3974,2,21,31,4,'0.25',0),
 (3975,2,22,31,0,'0.00',0),
 (3976,2,23,31,8,'0.49',0),
 (3977,2,24,31,0,'0.00',0),
 (3978,2,25,31,2,'0.12',0),
 (3979,2,1,32,1584,'51.82',0),
 (3980,2,2,32,901,'29.47',0),
 (3981,2,4,32,7,'0.23',0),
 (3982,2,6,32,0,'0.00',0),
 (3983,2,7,32,3,'0.10',0),
 (3984,2,8,32,3,'0.10',0),
 (3985,2,9,32,183,'5.99',0),
 (3986,2,13,32,3,'0.10',0),
 (3987,2,14,32,0,'0.00',0),
 (3988,2,15,32,5,'0.16',0),
 (3989,2,16,32,8,'0.26',0),
 (3990,2,17,32,14,'0.46',0),
 (3991,2,20,32,223,'7.29',0),
 (3992,2,21,32,10,'0.33',0),
 (3993,2,22,32,3,'0.10',0),
 (3994,2,23,32,27,'0.88',0),
 (3995,2,24,32,5,'0.16',0),
 (3996,2,25,32,0,'0.00',0),
 (3997,2,1,33,1600,'63.47',0),
 (3998,2,2,33,580,'23.01',0),
 (3999,2,4,33,1,'0.04',0),
 (4000,2,6,33,0,'0.00',0),
 (4001,2,7,33,0,'0.00',0),
 (4002,2,8,33,0,'0.00',0),
 (4003,2,9,33,77,'3.05',0),
 (4004,2,13,33,1,'0.04',0),
 (4005,2,14,33,0,'0.00',0),
 (4006,2,15,33,7,'0.28',0),
 (4007,2,16,33,3,'0.12',0),
 (4008,2,17,33,12,'0.48',0),
 (4009,2,20,33,147,'5.83',0),
 (4010,2,21,33,12,'0.48',0),
 (4011,2,22,33,4,'0.16',0),
 (4012,2,23,33,13,'0.52',0),
 (4013,2,24,33,3,'0.12',0),
 (4014,2,25,33,34,'1.35',0),
 (4015,2,1,34,189,'67.99',0),
 (4016,2,2,34,66,'23.74',0),
 (4017,2,4,34,0,'0.00',0),
 (4018,2,6,34,1,'0.36',0),
 (4019,2,7,34,1,'0.36',0),
 (4020,2,8,34,0,'0.00',0),
 (4021,2,9,34,5,'1.80',0),
 (4022,2,13,34,0,'0.00',0),
 (4023,2,14,34,0,'0.00',0),
 (4024,2,15,34,0,'0.00',0),
 (4025,2,16,34,0,'0.00',0),
 (4026,2,17,34,1,'0.36',0),
 (4027,2,20,34,7,'2.52',0),
 (4028,2,21,34,3,'1.08',0),
 (4029,2,22,34,0,'0.00',0),
 (4030,2,23,34,1,'0.36',0),
 (4031,2,24,34,0,'0.00',0),
 (4032,2,25,34,0,'0.00',0),
 (4033,2,1,35,566,'53.85',0),
 (4034,2,2,35,371,'35.30',0),
 (4035,2,4,35,0,'0.00',0),
 (4036,2,6,35,0,'0.00',0),
 (4037,2,7,35,0,'0.00',0),
 (4038,2,8,35,0,'0.00',0),
 (4039,2,9,35,30,'2.85',0),
 (4040,2,13,35,0,'0.00',0),
 (4041,2,14,35,0,'0.00',0),
 (4042,2,15,35,0,'0.00',0),
 (4043,2,16,35,1,'0.10',0),
 (4044,2,17,35,4,'0.38',0),
 (4045,2,20,35,62,'5.90',0),
 (4046,2,21,35,4,'0.38',0),
 (4047,2,22,35,0,'0.00',0),
 (4048,2,23,35,5,'0.48',0),
 (4049,2,24,35,0,'0.00',0),
 (4050,2,25,35,0,'0.00',0),
 (4051,2,1,36,865,'49.15',0),
 (4052,2,2,36,380,'21.59',0),
 (4053,2,4,36,2,'0.11',0),
 (4054,2,6,36,3,'0.17',0),
 (4055,2,7,36,0,'0.00',0),
 (4056,2,8,36,0,'0.00',0),
 (4057,2,9,36,67,'3.81',0),
 (4058,2,13,36,0,'0.00',0),
 (4059,2,14,36,2,'0.11',0),
 (4060,2,15,36,4,'0.23',0),
 (4061,2,16,36,4,'0.23',0),
 (4062,2,17,36,10,'0.57',0),
 (4063,2,20,36,348,'19.77',0),
 (4064,2,21,36,7,'0.40',0),
 (4065,2,22,36,16,'0.91',0),
 (4066,2,23,36,13,'0.74',0),
 (4067,2,24,36,0,'0.00',0),
 (4068,2,25,36,0,'0.00',0),
 (4069,2,1,37,765,'54.76',0),
 (4070,2,2,37,575,'41.16',0),
 (4071,2,4,37,1,'0.07',0),
 (4072,2,6,37,0,'0.00',0),
 (4073,2,7,37,0,'0.00',0),
 (4074,2,8,37,0,'0.00',0),
 (4075,2,9,37,3,'0.21',0),
 (4076,2,13,37,0,'0.00',0),
 (4077,2,14,37,0,'0.00',0),
 (4078,2,15,37,1,'0.07',0),
 (4079,2,16,37,1,'0.07',0),
 (4080,2,17,37,1,'0.07',0),
 (4081,2,20,37,40,'2.86',0),
 (4082,2,21,37,0,'0.00',0),
 (4083,2,22,37,0,'0.00',0),
 (4084,2,23,37,1,'0.07',0),
 (4085,2,24,37,0,'0.00',0),
 (4086,2,25,37,0,'0.00',0),
 (4087,2,1,38,1669,'48.63',0),
 (4088,2,2,38,1035,'30.16',0),
 (4089,2,4,38,7,'0.20',0),
 (4090,2,6,38,1,'0.03',0),
 (4091,2,7,38,2,'0.06',0),
 (4092,2,8,38,3,'0.09',0),
 (4093,2,9,38,161,'4.69',0),
 (4094,2,13,38,1,'0.03',0),
 (4095,2,14,38,3,'0.09',0),
 (4096,2,15,38,8,'0.23',0),
 (4097,2,16,38,3,'0.09',0),
 (4098,2,17,38,17,'0.50',0),
 (4099,2,20,38,420,'12.24',0),
 (4100,2,21,38,9,'0.26',0),
 (4101,2,22,38,8,'0.23',0),
 (4102,2,23,38,30,'0.87',0),
 (4103,2,24,38,0,'0.00',0),
 (4104,2,25,38,1,'0.03',0),
 (4105,2,1,39,45,'40.18',0),
 (4106,2,2,39,43,'38.39',0),
 (4107,2,4,39,0,'0.00',0),
 (4108,2,6,39,0,'0.00',0),
 (4109,2,7,39,1,'0.89',0),
 (4110,2,8,39,0,'0.00',0),
 (4111,2,9,39,3,'2.68',0),
 (4112,2,13,39,0,'0.00',0),
 (4113,2,14,39,0,'0.00',0),
 (4114,2,15,39,2,'1.79',0),
 (4115,2,16,39,0,'0.00',0),
 (4116,2,17,39,2,'1.79',0),
 (4117,2,20,39,11,'9.82',0),
 (4118,2,21,39,0,'0.00',0),
 (4119,2,22,39,0,'0.00',0),
 (4120,2,23,39,1,'0.89',0),
 (4121,2,24,39,0,'0.00',0),
 (4122,2,25,39,0,'0.00',0),
 (4123,2,1,40,4285,'48.86',0),
 (4124,2,2,40,2579,'29.41',0),
 (4125,2,4,40,7,'0.08',0),
 (4126,2,6,40,4,'0.05',0),
 (4127,2,7,40,5,'0.06',0),
 (4128,2,8,40,13,'0.15',0),
 (4129,2,9,40,281,'3.20',0),
 (4130,2,13,40,3,'0.03',0),
 (4131,2,14,40,11,'0.13',0),
 (4132,2,15,40,20,'0.23',0),
 (4133,2,16,40,29,'0.33',0),
 (4134,2,17,40,60,'0.68',0),
 (4135,2,20,40,1101,'12.55',0),
 (4136,2,21,40,35,'0.40',0),
 (4137,2,22,40,14,'0.16',0),
 (4138,2,23,40,78,'0.89',0),
 (4139,2,24,40,9,'0.10',0),
 (4140,2,25,40,16,'0.18',0),
 (4141,2,1,41,1725,'59.46',0),
 (4142,2,2,41,572,'19.72',0),
 (4143,2,4,41,6,'0.21',0),
 (4144,2,6,41,0,'0.00',0),
 (4145,2,7,41,2,'0.07',0),
 (4146,2,8,41,7,'0.24',0),
 (4147,2,9,41,141,'4.86',0),
 (4148,2,13,41,0,'0.00',0),
 (4149,2,14,41,3,'0.10',0),
 (4150,2,15,41,5,'0.17',0),
 (4151,2,16,41,8,'0.28',0),
 (4152,2,17,41,17,'0.59',0),
 (4153,2,20,41,245,'8.45',0),
 (4154,2,21,41,26,'0.90',0),
 (4155,2,22,41,9,'0.31',0),
 (4156,2,23,41,28,'0.97',0),
 (4157,2,24,41,1,'0.03',0),
 (4158,2,25,41,13,'0.45',0),
 (4159,2,1,42,558,'70.10',0),
 (4160,2,2,42,129,'16.21',0),
 (4161,2,4,42,0,'0.00',0),
 (4162,2,6,42,0,'0.00',0),
 (4163,2,7,42,0,'0.00',0),
 (4164,2,8,42,0,'0.00',0),
 (4165,2,9,42,29,'3.64',0),
 (4166,2,13,42,0,'0.00',0),
 (4167,2,14,42,1,'0.13',0),
 (4168,2,15,42,1,'0.13',0),
 (4169,2,16,42,2,'0.25',0),
 (4170,2,17,42,1,'0.13',0),
 (4171,2,20,42,45,'5.65',0),
 (4172,2,21,42,3,'0.38',0),
 (4173,2,22,42,0,'0.00',0),
 (4174,2,23,42,10,'1.26',0),
 (4175,2,24,42,0,'0.00',0),
 (4176,2,25,42,0,'0.00',0),
 (4177,2,1,43,2405,'63.71',0),
 (4178,2,2,43,1001,'26.52',0),
 (4179,2,4,43,0,'0.00',0),
 (4180,2,6,43,2,'0.05',0),
 (4181,2,7,43,2,'0.05',0),
 (4182,2,8,43,4,'0.11',0),
 (4183,2,9,43,64,'1.70',0),
 (4184,2,13,43,0,'0.00',0),
 (4185,2,14,43,1,'0.03',0),
 (4186,2,15,43,3,'0.08',0),
 (4187,2,16,43,13,'0.34',0),
 (4188,2,17,43,10,'0.26',0),
 (4189,2,20,43,147,'3.89',0),
 (4190,2,21,43,13,'0.34',0),
 (4191,2,22,43,9,'0.24',0),
 (4192,2,23,43,21,'0.56',0),
 (4193,2,24,43,1,'0.03',0),
 (4194,2,25,43,2,'0.05',0),
 (4195,2,1,44,2038,'53.32',0),
 (4196,2,2,44,917,'23.99',0),
 (4197,2,4,44,6,'0.16',0),
 (4198,2,6,44,0,'0.00',0),
 (4199,2,7,44,1,'0.03',0),
 (4200,2,8,44,11,'0.29',0),
 (4201,2,9,44,196,'5.13',0),
 (4202,2,13,44,6,'0.16',0),
 (4203,2,14,44,8,'0.21',0),
 (4204,2,15,44,8,'0.21',0),
 (4205,2,16,44,5,'0.13',0),
 (4206,2,17,44,36,'0.94',0),
 (4207,2,20,44,390,'10.20',0),
 (4208,2,21,44,22,'0.58',0),
 (4209,2,22,44,9,'0.24',0),
 (4210,2,23,44,56,'1.47',0),
 (4211,2,24,44,1,'0.03',0),
 (4212,2,25,44,0,'0.00',0),
 (4213,2,1,45,10536,'51.99',0),
 (4214,2,2,45,4804,'23.71',0),
 (4215,2,4,45,14,'0.07',0),
 (4216,2,6,45,13,'0.06',0),
 (4217,2,7,45,13,'0.06',0),
 (4218,2,8,45,26,'0.13',0),
 (4219,2,9,45,1634,'8.06',0),
 (4220,2,13,45,7,'0.03',0),
 (4221,2,14,45,22,'0.11',0),
 (4222,2,15,45,31,'0.15',0),
 (4223,2,16,45,46,'0.23',0),
 (4224,2,17,45,105,'0.52',0),
 (4225,2,20,45,2080,'10.26',0),
 (4226,2,21,45,119,'0.59',0),
 (4227,2,22,45,72,'0.36',0),
 (4228,2,23,45,187,'0.92',0),
 (4229,2,24,45,9,'0.04',0),
 (4230,2,25,45,92,'0.45',0),
 (4231,2,1,46,1646,'54.99',0),
 (4232,2,2,46,664,'22.19',0),
 (4233,2,4,46,1,'0.03',0),
 (4234,2,6,46,0,'0.00',0),
 (4235,2,7,46,7,'0.23',0),
 (4236,2,8,46,4,'0.13',0),
 (4237,2,9,46,156,'5.21',0),
 (4238,2,13,46,3,'0.10',0),
 (4239,2,14,46,2,'0.07',0),
 (4240,2,15,46,5,'0.17',0),
 (4241,2,16,46,6,'0.20',0),
 (4242,2,17,46,14,'0.47',0),
 (4243,2,20,46,312,'10.42',0),
 (4244,2,21,46,11,'0.37',0),
 (4245,2,22,46,7,'0.23',0),
 (4246,2,23,46,74,'2.47',0),
 (4247,2,24,46,1,'0.03',0),
 (4248,2,25,46,0,'0.00',0),
 (4249,2,1,47,12985,'50.31',0),
 (4250,2,2,47,6703,'25.97',0),
 (4251,2,4,47,24,'0.09',0),
 (4252,2,6,47,8,'0.03',0),
 (4253,2,7,47,14,'0.05',0),
 (4254,2,8,47,24,'0.09',0),
 (4255,2,9,47,2026,'7.85',0),
 (4256,2,13,47,25,'0.10',0),
 (4257,2,14,47,30,'0.12',0),
 (4258,2,15,47,51,'0.20',0),
 (4259,2,16,47,61,'0.24',0),
 (4260,2,17,47,191,'0.74',0),
 (4261,2,20,47,2518,'9.76',0),
 (4262,2,21,47,181,'0.70',0),
 (4263,2,22,47,86,'0.33',0),
 (4264,2,23,47,242,'0.94',0),
 (4265,2,24,47,13,'0.05',0),
 (4266,2,25,47,15,'0.06',0),
 (4267,2,1,48,193,'48.86',0),
 (4268,2,2,48,134,'33.92',0),
 (4269,2,4,48,0,'0.00',0),
 (4270,2,6,48,0,'0.00',0),
 (4271,2,7,48,1,'0.25',0),
 (4272,2,8,48,0,'0.00',0),
 (4273,2,9,48,2,'0.51',0),
 (4274,2,13,48,0,'0.00',0),
 (4275,2,14,48,0,'0.00',0),
 (4276,2,15,48,0,'0.00',0),
 (4277,2,16,48,3,'0.76',0),
 (4278,2,17,48,2,'0.51',0),
 (4279,2,20,48,53,'13.42',0),
 (4280,2,21,48,0,'0.00',0),
 (4281,2,22,48,1,'0.25',0),
 (4282,2,23,48,0,'0.00',0),
 (4283,2,24,48,0,'0.00',0),
 (4284,2,25,48,1,'0.25',0),
 (4285,2,1,49,17003,'42.06',0),
 (4286,2,2,49,12705,'31.43',0),
 (4287,2,4,49,35,'0.09',0),
 (4288,2,6,49,11,'0.03',0),
 (4289,2,7,49,39,'0.10',0),
 (4290,2,8,49,45,'0.11',0),
 (4291,2,9,49,2949,'7.29',0),
 (4292,2,13,49,15,'0.04',0),
 (4293,2,14,49,40,'0.10',0),
 (4294,2,15,49,123,'0.30',0),
 (4295,2,16,49,101,'0.25',0),
 (4296,2,17,49,251,'0.62',0),
 (4297,2,20,49,5054,'12.50',0),
 (4298,2,21,49,255,'0.63',0),
 (4299,2,22,49,107,'0.26',0),
 (4300,2,23,49,455,'1.13',0),
 (4301,2,24,49,45,'0.11',0),
 (4302,2,25,49,134,'0.33',0),
 (4303,2,1,50,1424,'59.86',0),
 (4304,2,2,50,539,'22.66',0),
 (4305,2,4,50,1,'0.04',0),
 (4306,2,6,50,2,'0.08',0),
 (4307,2,7,50,1,'0.04',0),
 (4308,2,8,50,1,'0.04',0),
 (4309,2,9,50,115,'4.83',0),
 (4310,2,13,50,0,'0.00',0),
 (4311,2,14,50,1,'0.04',0),
 (4312,2,15,50,7,'0.29',0),
 (4313,2,16,50,13,'0.55',0),
 (4314,2,17,50,21,'0.88',0),
 (4315,2,20,50,167,'7.02',0),
 (4316,2,21,50,14,'0.59',0),
 (4317,2,22,50,3,'0.13',0),
 (4318,2,23,50,25,'1.05',0),
 (4319,2,24,50,1,'0.04',0),
 (4320,2,25,50,1,'0.04',0),
 (4321,2,1,51,715,'62.50',0),
 (4322,2,2,51,244,'21.33',0),
 (4323,2,4,51,0,'0.00',0),
 (4324,2,6,51,1,'0.09',0),
 (4325,2,7,51,1,'0.09',0),
 (4326,2,8,51,0,'0.00',0),
 (4327,2,9,51,43,'3.76',0),
 (4328,2,13,51,0,'0.00',0),
 (4329,2,14,51,1,'0.09',0),
 (4330,2,15,51,1,'0.09',0),
 (4331,2,16,51,2,'0.17',0),
 (4332,2,17,51,9,'0.79',0),
 (4333,2,20,51,72,'6.29',0),
 (4334,2,21,51,6,'0.52',0),
 (4335,2,22,51,2,'0.17',0),
 (4336,2,23,51,18,'1.57',0),
 (4337,2,24,51,1,'0.09',0),
 (4338,2,25,51,3,'0.26',0),
 (4339,2,1,52,1741,'67.22',0),
 (4340,2,2,52,609,'23.51',0),
 (4341,2,4,52,3,'0.12',0),
 (4342,2,6,52,0,'0.00',0),
 (4343,2,7,52,0,'0.00',0),
 (4344,2,8,52,2,'0.08',0),
 (4345,2,9,52,36,'1.39',0),
 (4346,2,13,52,0,'0.00',0),
 (4347,2,14,52,0,'0.00',0),
 (4348,2,15,52,0,'0.00',0),
 (4349,2,16,52,7,'0.27',0),
 (4350,2,17,52,5,'0.19',0),
 (4351,2,20,52,116,'4.48',0),
 (4352,2,21,52,8,'0.31',0),
 (4353,2,22,52,1,'0.04',0),
 (4354,2,23,52,5,'0.19',0),
 (4355,2,24,52,1,'0.04',0),
 (4356,2,25,52,1,'0.04',0),
 (4357,2,1,53,2348,'53.01',0),
 (4358,2,2,53,1300,'29.35',0),
 (4359,2,4,53,2,'0.05',0),
 (4360,2,6,53,0,'0.00',0),
 (4361,2,7,53,7,'0.16',0),
 (4362,2,8,53,5,'0.11',0),
 (4363,2,9,53,223,'5.03',0),
 (4364,2,13,53,0,'0.00',0),
 (4365,2,14,53,2,'0.05',0),
 (4366,2,15,53,3,'0.07',0),
 (4367,2,16,53,9,'0.20',0),
 (4368,2,17,53,18,'0.41',0),
 (4369,2,20,53,312,'7.04',0),
 (4370,2,21,53,33,'0.75',0),
 (4371,2,22,53,9,'0.20',0),
 (4372,2,23,53,30,'0.68',0),
 (4373,2,24,53,1,'0.02',0),
 (4374,2,25,53,1,'0.02',0),
 (4375,2,1,54,3831,'56.45',0),
 (4376,2,2,54,1564,'23.05',0),
 (4377,2,4,54,10,'0.15',0),
 (4378,2,6,54,1,'0.01',0),
 (4379,2,7,54,5,'0.07',0),
 (4380,2,8,54,11,'0.16',0),
 (4381,2,9,54,358,'5.28',0),
 (4382,2,13,54,4,'0.06',0),
 (4383,2,14,54,7,'0.10',0),
 (4384,2,15,54,8,'0.12',0),
 (4385,2,16,54,10,'0.15',0),
 (4386,2,17,54,47,'0.69',0),
 (4387,2,20,54,582,'8.58',0),
 (4388,2,21,54,56,'0.83',0),
 (4389,2,22,54,20,'0.29',0),
 (4390,2,23,54,81,'1.19',0),
 (4391,2,24,54,3,'0.04',0),
 (4392,2,25,54,5,'0.07',0),
 (4393,2,1,55,436,'56.55',0),
 (4394,2,2,55,297,'38.52',0),
 (4395,2,4,55,0,'0.00',0),
 (4396,2,6,55,0,'0.00',0),
 (4397,2,7,55,0,'0.00',0),
 (4398,2,8,55,0,'0.00',0),
 (4399,2,9,55,6,'0.78',0),
 (4400,2,13,55,0,'0.00',0),
 (4401,2,14,55,0,'0.00',0),
 (4402,2,15,55,0,'0.00',0),
 (4403,2,16,55,3,'0.39',0),
 (4404,2,17,55,5,'0.65',0),
 (4405,2,20,55,8,'1.04',0),
 (4406,2,21,55,0,'0.00',0),
 (4407,2,22,55,0,'0.00',0),
 (4408,2,23,55,8,'1.04',0),
 (4409,2,24,55,0,'0.00',0),
 (4410,2,25,55,0,'0.00',0),
 (4411,2,1,56,327,'51.99',0),
 (4412,2,2,56,186,'29.57',0),
 (4413,2,4,56,0,'0.00',0),
 (4414,2,6,56,0,'0.00',0),
 (4415,2,7,56,0,'0.00',0),
 (4416,2,8,56,0,'0.00',0),
 (4417,2,9,56,14,'2.23',0),
 (4418,2,13,56,0,'0.00',0),
 (4419,2,14,56,0,'0.00',0),
 (4420,2,15,56,3,'0.48',0),
 (4421,2,16,56,0,'0.00',0),
 (4422,2,17,56,6,'0.95',0),
 (4423,2,20,56,75,'11.92',0),
 (4424,2,21,56,1,'0.16',0),
 (4425,2,22,56,0,'0.00',0),
 (4426,2,23,56,3,'0.48',0),
 (4427,2,24,56,0,'0.00',0),
 (4428,2,25,56,1,'0.16',0),
 (4429,2,1,57,607,'58.25',0),
 (4430,2,2,57,236,'22.65',0),
 (4431,2,4,57,0,'0.00',0),
 (4432,2,6,57,0,'0.00',0),
 (4433,2,7,57,0,'0.00',0),
 (4434,2,8,57,1,'0.10',0),
 (4435,2,9,57,39,'3.74',0),
 (4436,2,13,57,1,'0.10',0),
 (4437,2,14,57,2,'0.19',0),
 (4438,2,15,57,5,'0.48',0),
 (4439,2,16,57,4,'0.38',0),
 (4440,2,17,57,8,'0.77',0),
 (4441,2,20,57,86,'8.25',0),
 (4442,2,21,57,8,'0.77',0),
 (4443,2,22,57,0,'0.00',0),
 (4444,2,23,57,23,'2.21',0),
 (4445,2,24,57,1,'0.10',0),
 (4446,2,25,57,2,'0.19',0),
 (4447,2,1,58,35668,'41.78',0),
 (4448,2,2,58,30276,'35.47',0),
 (4449,2,4,58,60,'0.07',0),
 (4450,2,6,58,89,'0.10',0),
 (4451,2,7,58,37,'0.04',0),
 (4452,2,8,58,135,'0.16',0),
 (4453,2,9,58,5322,'6.23',0),
 (4454,2,13,58,20,'0.02',0),
 (4455,2,14,58,91,'0.11',0),
 (4456,2,15,58,217,'0.25',0),
 (4457,2,16,58,290,'0.34',0),
 (4458,2,17,58,644,'0.75',0),
 (4459,2,20,58,8486,'9.94',0),
 (4460,2,21,58,399,'0.47',0),
 (4461,2,22,58,240,'0.28',0),
 (4462,2,23,58,944,'1.11',0),
 (4463,2,24,58,34,'0.04',0),
 (4464,2,25,58,82,'0.10',0),
 (4465,2,1,59,1640,'56.32',0),
 (4466,2,2,59,765,'26.27',0),
 (4467,2,4,59,4,'0.14',0),
 (4468,2,6,59,0,'0.00',0),
 (4469,2,7,59,1,'0.03',0),
 (4470,2,8,59,2,'0.07',0),
 (4471,2,9,59,108,'3.71',0),
 (4472,2,13,59,1,'0.03',0),
 (4473,2,14,59,5,'0.17',0),
 (4474,2,15,59,9,'0.31',0),
 (4475,2,16,59,11,'0.38',0),
 (4476,2,17,59,10,'0.34',0),
 (4477,2,20,59,194,'6.66',0),
 (4478,2,21,59,14,'0.48',0),
 (4479,2,22,59,14,'0.48',0),
 (4480,2,23,59,42,'1.44',0),
 (4481,2,24,59,2,'0.07',0),
 (4482,2,25,59,6,'0.21',0),
 (4483,2,1,60,389,'31.91',0);
INSERT INTO `elecmunicandi` (`idElecMuniCandi`,`Convocatoria_idConvocatoria`,`Candidatura_idCandidatura`,`Municipio`,`Votos`,`PorcVotos`,`Concejales`) VALUES 
 (4484,2,2,60,537,'44.05',0),
 (4485,2,4,60,0,'0.00',0),
 (4486,2,6,60,0,'0.00',0),
 (4487,2,7,60,0,'0.00',0),
 (4488,2,8,60,0,'0.00',0),
 (4489,2,9,60,8,'0.66',0),
 (4490,2,13,60,0,'0.00',0),
 (4491,2,14,60,1,'0.08',0),
 (4492,2,15,60,0,'0.00',0),
 (4493,2,16,60,0,'0.00',0),
 (4494,2,17,60,6,'0.49',0),
 (4495,2,20,60,252,'20.67',0),
 (4496,2,21,60,5,'0.41',0),
 (4497,2,22,60,0,'0.00',0),
 (4498,2,23,60,1,'0.08',0),
 (4499,2,24,60,2,'0.16',0),
 (4500,2,25,60,0,'0.00',0),
 (4501,2,1,61,7454,'56.27',0),
 (4502,2,2,61,2896,'21.86',0),
 (4503,2,4,61,21,'0.16',0),
 (4504,2,6,61,7,'0.05',0),
 (4505,2,7,61,5,'0.04',0),
 (4506,2,8,61,31,'0.23',0),
 (4507,2,9,61,901,'6.80',0),
 (4508,2,13,61,3,'0.02',0),
 (4509,2,14,61,11,'0.08',0),
 (4510,2,15,61,18,'0.14',0),
 (4511,2,16,61,32,'0.24',0),
 (4512,2,17,61,71,'0.54',0),
 (4513,2,20,61,1145,'8.64',0),
 (4514,2,21,61,83,'0.63',0),
 (4515,2,22,61,44,'0.33',0),
 (4516,2,23,61,119,'0.90',0),
 (4517,2,24,61,5,'0.04',0),
 (4518,2,25,61,17,'0.13',0),
 (4519,2,1,62,182,'71.09',0),
 (4520,2,2,62,31,'12.11',0),
 (4521,2,4,62,0,'0.00',0),
 (4522,2,6,62,0,'0.00',0),
 (4523,2,7,62,0,'0.00',0),
 (4524,2,8,62,0,'0.00',0),
 (4525,2,9,62,16,'6.25',0),
 (4526,2,13,62,0,'0.00',0),
 (4527,2,14,62,0,'0.00',0),
 (4528,2,15,62,2,'0.78',0),
 (4529,2,16,62,0,'0.00',0),
 (4530,2,17,62,0,'0.00',0),
 (4531,2,20,62,15,'5.86',0),
 (4532,2,21,62,0,'0.00',0),
 (4533,2,22,62,0,'0.00',0),
 (4534,2,23,62,1,'0.39',0),
 (4535,2,24,62,0,'0.00',0),
 (4536,2,25,62,0,'0.00',0),
 (4537,2,1,63,115,'53.49',0),
 (4538,2,2,63,52,'24.19',0),
 (4539,2,4,63,0,'0.00',0),
 (4540,2,6,63,0,'0.00',0),
 (4541,2,7,63,0,'0.00',0),
 (4542,2,8,63,0,'0.00',0),
 (4543,2,9,63,7,'3.26',0),
 (4544,2,13,63,0,'0.00',0),
 (4545,2,14,63,0,'0.00',0),
 (4546,2,15,63,0,'0.00',0),
 (4547,2,16,63,1,'0.47',0),
 (4548,2,17,63,3,'1.40',0),
 (4549,2,20,63,21,'9.77',0),
 (4550,2,21,63,0,'0.00',0),
 (4551,2,22,63,2,'0.93',0),
 (4552,2,23,63,5,'2.33',0),
 (4553,2,24,63,0,'0.00',0),
 (4554,2,25,63,0,'0.00',0),
 (4555,2,1,64,77,'62.10',0),
 (4556,2,2,64,22,'17.74',0),
 (4557,2,4,64,0,'0.00',0),
 (4558,2,6,64,0,'0.00',0),
 (4559,2,7,64,2,'1.61',0),
 (4560,2,8,64,1,'0.81',0),
 (4561,2,9,64,6,'4.84',0),
 (4562,2,13,64,0,'0.00',0),
 (4563,2,14,64,0,'0.00',0),
 (4564,2,15,64,0,'0.00',0),
 (4565,2,16,64,0,'0.00',0),
 (4566,2,17,64,1,'0.81',0),
 (4567,2,20,64,7,'5.65',0),
 (4568,2,21,64,0,'0.00',0),
 (4569,2,22,64,0,'0.00',0),
 (4570,2,23,64,3,'2.42',0),
 (4571,2,24,64,0,'0.00',0),
 (4572,2,25,64,0,'0.00',0),
 (4573,2,1,65,34804,'41.72',0),
 (4574,2,2,65,29300,'35.12',0),
 (4575,2,4,65,67,'0.08',0),
 (4576,2,6,65,31,'0.04',0),
 (4577,2,7,65,39,'0.05',0),
 (4578,2,8,65,93,'0.11',0),
 (4579,2,9,65,5397,'6.47',0),
 (4580,2,13,65,37,'0.04',0),
 (4581,2,14,65,85,'0.10',0),
 (4582,2,15,65,214,'0.26',0),
 (4583,2,16,65,183,'0.22',0),
 (4584,2,17,65,482,'0.58',0),
 (4585,2,20,65,9265,'11.11',0),
 (4586,2,21,65,379,'0.45',0),
 (4587,2,22,65,200,'0.24',0),
 (4588,2,23,65,781,'0.94',0),
 (4589,2,24,65,29,'0.03',0),
 (4590,2,25,65,219,'0.26',0),
 (4591,2,1,66,3285,'66.75',0),
 (4592,2,2,66,924,'18.78',0),
 (4593,2,4,66,7,'0.14',0),
 (4594,2,6,66,1,'0.02',0),
 (4595,2,7,66,4,'0.08',0),
 (4596,2,8,66,9,'0.18',0),
 (4597,2,9,66,200,'4.06',0),
 (4598,2,13,66,0,'0.00',0),
 (4599,2,14,66,10,'0.20',0),
 (4600,2,15,66,15,'0.30',0),
 (4601,2,16,66,12,'0.24',0),
 (4602,2,17,66,21,'0.43',0),
 (4603,2,20,66,238,'4.84',0),
 (4604,2,21,66,24,'0.49',0),
 (4605,2,22,66,13,'0.26',0),
 (4606,2,23,66,44,'0.89',0),
 (4607,2,24,66,4,'0.08',0),
 (4608,2,25,66,10,'0.20',0),
 (4609,2,1,67,1532,'52.92',0),
 (4610,2,2,67,910,'31.43',0),
 (4611,2,4,67,1,'0.03',0),
 (4612,2,6,67,0,'0.00',0),
 (4613,2,7,67,3,'0.10',0),
 (4614,2,8,67,1,'0.03',0),
 (4615,2,9,67,101,'3.49',0),
 (4616,2,13,67,0,'0.00',0),
 (4617,2,14,67,1,'0.03',0),
 (4618,2,15,67,5,'0.17',0),
 (4619,2,16,67,2,'0.07',0),
 (4620,2,17,67,5,'0.17',0),
 (4621,2,20,67,247,'8.53',0),
 (4622,2,21,67,11,'0.38',0),
 (4623,2,22,67,3,'0.10',0),
 (4624,2,23,67,13,'0.45',0),
 (4625,2,24,67,0,'0.00',0),
 (4626,2,25,67,11,'0.38',0),
 (4627,2,1,68,3961,'57.30',0),
 (4628,2,2,68,1633,'23.62',0),
 (4629,2,4,68,8,'0.12',0),
 (4630,2,6,68,0,'0.00',0),
 (4631,2,7,68,4,'0.06',0),
 (4632,2,8,68,8,'0.12',0),
 (4633,2,9,68,405,'5.86',0),
 (4634,2,13,68,6,'0.09',0),
 (4635,2,14,68,10,'0.14',0),
 (4636,2,15,68,12,'0.17',0),
 (4637,2,16,68,23,'0.33',0),
 (4638,2,17,68,41,'0.59',0),
 (4639,2,20,68,507,'7.33',0),
 (4640,2,21,68,27,'0.39',0),
 (4641,2,22,68,26,'0.38',0),
 (4642,2,23,68,62,'0.90',0),
 (4643,2,24,68,3,'0.04',0),
 (4644,2,25,68,4,'0.06',0),
 (4645,2,1,69,22,'61.11',0),
 (4646,2,2,69,9,'25.00',0),
 (4647,2,4,69,0,'0.00',0),
 (4648,2,6,69,0,'0.00',0),
 (4649,2,7,69,0,'0.00',0),
 (4650,2,8,69,0,'0.00',0),
 (4651,2,9,69,1,'2.78',0),
 (4652,2,13,69,0,'0.00',0),
 (4653,2,14,69,0,'0.00',0),
 (4654,2,15,69,0,'0.00',0),
 (4655,2,16,69,0,'0.00',0),
 (4656,2,17,69,0,'0.00',0),
 (4657,2,20,69,2,'5.56',0),
 (4658,2,21,69,0,'0.00',0),
 (4659,2,22,69,1,'2.78',0),
 (4660,2,23,69,0,'0.00',0),
 (4661,2,24,69,0,'0.00',0),
 (4662,2,25,69,0,'0.00',0),
 (4663,2,1,70,57,'50.44',0),
 (4664,2,2,70,21,'18.58',0),
 (4665,2,4,70,0,'0.00',0),
 (4666,2,6,70,0,'0.00',0),
 (4667,2,7,70,0,'0.00',0),
 (4668,2,8,70,0,'0.00',0),
 (4669,2,9,70,4,'3.54',0),
 (4670,2,13,70,0,'0.00',0),
 (4671,2,14,70,0,'0.00',0),
 (4672,2,15,70,0,'0.00',0),
 (4673,2,16,70,3,'2.65',0),
 (4674,2,17,70,4,'3.54',0),
 (4675,2,20,70,19,'16.81',0),
 (4676,2,21,70,0,'0.00',0),
 (4677,2,22,70,1,'0.88',0),
 (4678,2,23,70,2,'1.77',0),
 (4679,2,24,70,0,'0.00',0),
 (4680,2,25,70,0,'0.00',0),
 (4681,2,1,71,38,'56.72',0),
 (4682,2,2,71,20,'29.85',0),
 (4683,2,4,71,0,'0.00',0),
 (4684,2,6,71,0,'0.00',0),
 (4685,2,7,71,0,'0.00',0),
 (4686,2,8,71,0,'0.00',0),
 (4687,2,9,71,2,'2.99',0),
 (4688,2,13,71,0,'0.00',0),
 (4689,2,14,71,0,'0.00',0),
 (4690,2,15,71,0,'0.00',0),
 (4691,2,16,71,1,'1.49',0),
 (4692,2,17,71,0,'0.00',0),
 (4693,2,20,71,5,'7.46',0),
 (4694,2,21,71,0,'0.00',0),
 (4695,2,22,71,0,'0.00',0),
 (4696,2,23,71,1,'1.49',0),
 (4697,2,24,71,0,'0.00',0),
 (4698,2,25,71,0,'0.00',0),
 (4699,2,1,72,2095,'58.88',0),
 (4700,2,2,72,648,'18.21',0),
 (4701,2,4,72,14,'0.39',0),
 (4702,2,6,72,0,'0.00',0),
 (4703,2,7,72,2,'0.06',0),
 (4704,2,8,72,3,'0.08',0),
 (4705,2,9,72,210,'5.90',0),
 (4706,2,13,72,2,'0.06',0),
 (4707,2,14,72,3,'0.08',0),
 (4708,2,15,72,6,'0.17',0),
 (4709,2,16,72,4,'0.11',0),
 (4710,2,17,72,19,'0.53',0),
 (4711,2,20,72,336,'9.44',0),
 (4712,2,21,72,28,'0.79',0),
 (4713,2,22,72,16,'0.45',0),
 (4714,2,23,72,40,'1.12',0),
 (4715,2,24,72,6,'0.17',0),
 (4716,2,25,72,3,'0.08',0),
 (4717,2,1,73,4292,'53.89',0),
 (4718,2,2,73,2075,'26.05',0),
 (4719,2,4,73,4,'0.05',0),
 (4720,2,6,73,7,'0.09',0),
 (4721,2,7,73,2,'0.03',0),
 (4722,2,8,73,13,'0.16',0),
 (4723,2,9,73,497,'6.24',0),
 (4724,2,13,73,3,'0.04',0),
 (4725,2,14,73,15,'0.19',0),
 (4726,2,15,73,31,'0.39',0),
 (4727,2,16,73,32,'0.40',0),
 (4728,2,17,73,43,'0.54',0),
 (4729,2,20,73,566,'7.11',0),
 (4730,2,21,73,37,'0.46',0),
 (4731,2,22,73,12,'0.15',0),
 (4732,2,23,73,88,'1.10',0),
 (4733,2,24,73,3,'0.04',0),
 (4734,2,25,73,18,'0.23',0),
 (4735,2,1,74,39113,'42.02',0),
 (4736,2,2,74,31991,'34.37',0),
 (4737,2,4,74,67,'0.07',0),
 (4738,2,6,74,2628,'2.82',0),
 (4739,2,7,74,48,'0.05',0),
 (4740,2,8,74,89,'0.10',0),
 (4741,2,9,74,5493,'5.90',0),
 (4742,2,13,74,24,'0.03',0),
 (4743,2,14,74,85,'0.09',0),
 (4744,2,15,74,309,'0.33',0),
 (4745,2,16,74,183,'0.20',0),
 (4746,2,17,74,447,'0.48',0),
 (4747,2,20,74,9037,'9.71',0),
 (4748,2,21,74,452,'0.49',0),
 (4749,2,22,74,189,'0.20',0),
 (4750,2,23,74,782,'0.84',0),
 (4751,2,24,74,37,'0.04',0),
 (4752,2,25,74,78,'0.08',0),
 (4753,2,1,75,2107,'58.12',0),
 (4754,2,2,75,910,'25.10',0),
 (4755,2,4,75,2,'0.06',0),
 (4756,2,6,75,0,'0.00',0),
 (4757,2,7,75,4,'0.11',0),
 (4758,2,8,75,1,'0.03',0),
 (4759,2,9,75,133,'3.67',0),
 (4760,2,13,75,3,'0.08',0),
 (4761,2,14,75,1,'0.03',0),
 (4762,2,15,75,12,'0.33',0),
 (4763,2,16,75,20,'0.55',0),
 (4764,2,17,75,20,'0.55',0),
 (4765,2,20,75,226,'6.23',0),
 (4766,2,21,75,12,'0.33',0),
 (4767,2,22,75,3,'0.08',0),
 (4768,2,23,75,19,'0.52',0),
 (4769,2,24,75,61,'1.68',0),
 (4770,2,25,75,5,'0.14',0),
 (4771,2,1,76,190,'55.07',0),
 (4772,2,2,76,118,'34.20',0),
 (4773,2,4,76,0,'0.00',0),
 (4774,2,6,76,0,'0.00',0),
 (4775,2,7,76,0,'0.00',0),
 (4776,2,8,76,0,'0.00',0),
 (4777,2,9,76,8,'2.32',0),
 (4778,2,13,76,0,'0.00',0),
 (4779,2,14,76,0,'0.00',0),
 (4780,2,15,76,0,'0.00',0),
 (4781,2,16,76,0,'0.00',0),
 (4782,2,17,76,1,'0.29',0),
 (4783,2,20,76,21,'6.09',0),
 (4784,2,21,76,1,'0.29',0),
 (4785,2,22,76,0,'0.00',0),
 (4786,2,23,76,1,'0.29',0),
 (4787,2,24,76,0,'0.00',0),
 (4788,2,25,76,0,'0.00',0),
 (4789,2,1,78,18,'66.67',0),
 (4790,2,2,78,3,'11.11',0),
 (4791,2,4,78,0,'0.00',0),
 (4792,2,6,78,0,'0.00',0),
 (4793,2,7,78,0,'0.00',0),
 (4794,2,8,78,0,'0.00',0),
 (4795,2,9,78,0,'0.00',0),
 (4796,2,13,78,0,'0.00',0),
 (4797,2,14,78,0,'0.00',0),
 (4798,2,15,78,0,'0.00',0),
 (4799,2,16,78,0,'0.00',0),
 (4800,2,17,78,0,'0.00',0),
 (4801,2,20,78,3,'11.11',0),
 (4802,2,21,78,0,'0.00',0),
 (4803,2,22,78,1,'3.70',0),
 (4804,2,23,78,1,'3.70',0),
 (4805,2,24,78,0,'0.00',0),
 (4806,2,25,78,0,'0.00',0),
 (4807,2,1,79,799375,'52.72',0),
 (4808,2,2,79,376729,'24.85',0),
 (4809,2,4,79,1937,'0.13',0),
 (4810,2,6,79,350,'0.02',0),
 (4811,2,7,79,961,'0.06',0),
 (4812,2,8,79,2701,'0.18',0),
 (4813,2,9,79,96466,'6.36',0),
 (4814,2,13,79,668,'0.04',0),
 (4815,2,14,79,2254,'0.15',0),
 (4816,2,15,79,2360,'0.16',0),
 (4817,2,16,79,2617,'0.17',0),
 (4818,2,17,79,7277,'0.48',0),
 (4819,2,20,79,153639,'10.13',0),
 (4820,2,21,79,11175,'0.74',0),
 (4821,2,22,79,6441,'0.42',0),
 (4822,2,23,79,14183,'0.94',0),
 (4823,2,24,79,816,'0.05',0),
 (4824,2,25,79,940,'0.06',0),
 (4825,2,1,80,20662,'63.86',0),
 (4826,2,2,80,4883,'15.09',0),
 (4827,2,4,80,66,'0.20',0),
 (4828,2,6,80,9,'0.03',0),
 (4829,2,7,80,9,'0.03',0),
 (4830,2,8,80,67,'0.21',0),
 (4831,2,9,80,2626,'8.12',0),
 (4832,2,13,80,15,'0.05',0),
 (4833,2,14,80,29,'0.09',0),
 (4834,2,15,80,28,'0.09',0),
 (4835,2,16,80,51,'0.16',0),
 (4836,2,17,80,144,'0.45',0),
 (4837,2,20,80,2164,'6.69',0),
 (4838,2,21,80,268,'0.83',0),
 (4839,2,22,80,154,'0.48',0),
 (4840,2,23,80,273,'0.84',0),
 (4841,2,24,80,12,'0.04',0),
 (4842,2,25,80,67,'0.21',0),
 (4843,2,1,82,1922,'53.11',0),
 (4844,2,2,82,818,'22.60',0),
 (4845,2,4,82,2,'0.06',0),
 (4846,2,6,82,3,'0.08',0),
 (4847,2,7,82,1,'0.03',0),
 (4848,2,8,82,6,'0.17',0),
 (4849,2,9,82,166,'4.59',0),
 (4850,2,13,82,0,'0.00',0),
 (4851,2,14,82,3,'0.08',0),
 (4852,2,15,82,5,'0.14',0),
 (4853,2,16,82,5,'0.14',0),
 (4854,2,17,82,31,'0.86',0),
 (4855,2,20,82,449,'12.41',0),
 (4856,2,21,82,37,'1.02',0),
 (4857,2,22,82,9,'0.25',0),
 (4858,2,23,82,58,'1.60',0),
 (4859,2,24,82,1,'0.03',0),
 (4860,2,25,82,5,'0.14',0),
 (4861,2,1,83,2616,'50.69',0),
 (4862,2,2,83,1281,'24.82',0),
 (4863,2,4,83,4,'0.08',0),
 (4864,2,6,83,1,'0.02',0),
 (4865,2,7,83,6,'0.12',0),
 (4866,2,8,83,6,'0.12',0),
 (4867,2,9,83,411,'7.96',0),
 (4868,2,13,83,5,'0.10',0),
 (4869,2,14,83,7,'0.14',0),
 (4870,2,15,83,12,'0.23',0),
 (4871,2,16,83,38,'0.74',0),
 (4872,2,17,83,27,'0.52',0),
 (4873,2,20,83,526,'10.19',0),
 (4874,2,21,83,21,'0.41',0),
 (4875,2,22,83,11,'0.21',0),
 (4876,2,23,83,53,'1.03',0),
 (4877,2,24,83,6,'0.12',0),
 (4878,2,25,83,2,'0.04',0),
 (4879,2,1,84,4920,'49.33',0),
 (4880,2,2,84,2732,'27.39',0),
 (4881,2,4,84,11,'0.11',0),
 (4882,2,6,84,1,'0.01',0),
 (4883,2,7,84,6,'0.06',0),
 (4884,2,8,84,16,'0.16',0),
 (4885,2,9,84,634,'6.36',0),
 (4886,2,13,84,4,'0.04',0),
 (4887,2,14,84,8,'0.08',0),
 (4888,2,15,84,33,'0.33',0),
 (4889,2,16,84,19,'0.19',0),
 (4890,2,17,84,56,'0.56',0),
 (4891,2,20,84,1131,'11.34',0),
 (4892,2,21,84,41,'0.41',0),
 (4893,2,22,84,25,'0.25',0),
 (4894,2,23,84,106,'1.06',0),
 (4895,2,24,84,5,'0.05',0),
 (4896,2,25,84,7,'0.07',0),
 (4897,2,1,85,1404,'50.20',0),
 (4898,2,2,85,993,'35.50',0),
 (4899,2,4,85,1,'0.04',0),
 (4900,2,6,85,0,'0.00',0),
 (4901,2,7,85,0,'0.00',0),
 (4902,2,8,85,2,'0.07',0),
 (4903,2,9,85,75,'2.68',0),
 (4904,2,13,85,1,'0.04',0),
 (4905,2,14,85,4,'0.14',0),
 (4906,2,15,85,8,'0.29',0),
 (4907,2,16,85,3,'0.11',0),
 (4908,2,17,85,10,'0.36',0),
 (4909,2,20,85,194,'6.94',0),
 (4910,2,21,85,11,'0.39',0),
 (4911,2,22,85,4,'0.14',0),
 (4912,2,23,85,24,'0.86',0),
 (4913,2,24,85,0,'0.00',0),
 (4914,2,25,85,6,'0.21',0),
 (4915,2,1,86,1754,'58.76',0),
 (4916,2,2,86,766,'25.66',0),
 (4917,2,4,86,2,'0.07',0),
 (4918,2,6,86,2,'0.07',0),
 (4919,2,7,86,2,'0.07',0),
 (4920,2,8,86,6,'0.20',0),
 (4921,2,9,86,142,'4.76',0),
 (4922,2,13,86,4,'0.13',0),
 (4923,2,14,86,5,'0.17',0),
 (4924,2,15,86,6,'0.20',0),
 (4925,2,16,86,15,'0.50',0),
 (4926,2,17,86,17,'0.57',0),
 (4927,2,20,86,134,'4.49',0),
 (4928,2,21,86,10,'0.34',0),
 (4929,2,22,86,6,'0.20',0),
 (4930,2,23,86,31,'1.04',0),
 (4931,2,24,86,2,'0.07',0),
 (4932,2,25,86,2,'0.07',0),
 (4933,2,1,87,1340,'57.93',0),
 (4934,2,2,87,577,'24.95',0),
 (4935,2,4,87,1,'0.04',0),
 (4936,2,6,87,1,'0.04',0),
 (4937,2,7,87,1,'0.04',0),
 (4938,2,8,87,0,'0.00',0),
 (4939,2,9,87,105,'4.54',0),
 (4940,2,13,87,3,'0.13',0),
 (4941,2,14,87,1,'0.04',0),
 (4942,2,15,87,2,'0.09',0),
 (4943,2,16,87,3,'0.13',0),
 (4944,2,17,87,12,'0.52',0),
 (4945,2,20,87,165,'7.13',0),
 (4946,2,21,87,8,'0.35',0),
 (4947,2,22,87,5,'0.22',0),
 (4948,2,23,87,10,'0.43',0),
 (4949,2,24,87,3,'0.13',0),
 (4950,2,25,87,2,'0.09',0),
 (4951,2,1,88,79,'42.93',0),
 (4952,2,2,88,80,'43.48',0),
 (4953,2,4,88,0,'0.00',0),
 (4954,2,6,88,0,'0.00',0),
 (4955,2,7,88,0,'0.00',0),
 (4956,2,8,88,0,'0.00',0),
 (4957,2,9,88,8,'4.35',0),
 (4958,2,13,88,0,'0.00',0),
 (4959,2,14,88,0,'0.00',0),
 (4960,2,15,88,0,'0.00',0),
 (4961,2,16,88,0,'0.00',0),
 (4962,2,17,88,1,'0.54',0),
 (4963,2,20,88,8,'4.35',0),
 (4964,2,21,88,1,'0.54',0),
 (4965,2,22,88,1,'0.54',0),
 (4966,2,23,88,0,'0.00',0),
 (4967,2,24,88,0,'0.00',0),
 (4968,2,25,88,0,'0.00',0),
 (4969,2,1,89,1543,'59.35',0),
 (4970,2,2,89,706,'27.15',0),
 (4971,2,4,89,2,'0.08',0),
 (4972,2,6,89,0,'0.00',0),
 (4973,2,7,89,0,'0.00',0),
 (4974,2,8,89,1,'0.04',0),
 (4975,2,9,89,89,'3.42',0),
 (4976,2,13,89,0,'0.00',0),
 (4977,2,14,89,2,'0.08',0),
 (4978,2,15,89,3,'0.12',0),
 (4979,2,16,89,14,'0.54',0),
 (4980,2,17,89,9,'0.35',0),
 (4981,2,20,89,138,'5.31',0),
 (4982,2,21,89,7,'0.27',0),
 (4983,2,22,89,10,'0.38',0),
 (4984,2,23,89,15,'0.58',0),
 (4985,2,24,89,3,'0.12',0),
 (4986,2,25,89,2,'0.08',0),
 (4987,2,1,90,3043,'55.22',0),
 (4988,2,2,90,1284,'23.30',0),
 (4989,2,4,90,6,'0.11',0),
 (4990,2,6,90,0,'0.00',0),
 (4991,2,7,90,6,'0.11',0),
 (4992,2,8,90,2,'0.04',0),
 (4993,2,9,90,270,'4.90',0),
 (4994,2,13,90,1,'0.02',0),
 (4995,2,14,90,5,'0.09',0),
 (4996,2,15,90,4,'0.07',0),
 (4997,2,16,90,20,'0.36',0),
 (4998,2,17,90,46,'0.83',0),
 (4999,2,20,90,571,'10.36',0),
 (5000,2,21,90,31,'0.56',0),
 (5001,2,22,90,11,'0.20',0),
 (5002,2,23,90,54,'0.98',0),
 (5003,2,24,90,1,'0.02',0),
 (5004,2,25,90,1,'0.02',0),
 (5005,2,1,91,1873,'55.51',0),
 (5006,2,2,91,944,'27.98',0),
 (5007,2,4,91,2,'0.06',0),
 (5008,2,6,91,0,'0.00',0),
 (5009,2,7,91,1,'0.03',0),
 (5010,2,8,91,6,'0.18',0),
 (5011,2,9,91,51,'1.51',0),
 (5012,2,13,91,2,'0.06',0),
 (5013,2,14,91,1,'0.03',0),
 (5014,2,15,91,2,'0.06',0),
 (5015,2,16,91,9,'0.27',0),
 (5016,2,17,91,10,'0.30',0),
 (5017,2,20,91,368,'10.91',0),
 (5018,2,21,91,4,'0.12',0),
 (5019,2,22,91,4,'0.12',0),
 (5020,2,23,91,11,'0.33',0),
 (5021,2,24,91,1,'0.03',0),
 (5022,2,25,91,2,'0.06',0),
 (5023,2,1,92,47358,'49.82',0),
 (5024,2,2,92,27353,'28.78',0),
 (5025,2,4,92,124,'0.13',0),
 (5026,2,6,92,27,'0.03',0),
 (5027,2,7,92,58,'0.06',0),
 (5028,2,8,92,159,'0.17',0),
 (5029,2,9,92,5276,'5.55',0),
 (5030,2,13,92,42,'0.04',0),
 (5031,2,14,92,119,'0.13',0),
 (5032,2,15,92,226,'0.24',0),
 (5033,2,16,92,203,'0.21',0),
 (5034,2,17,92,623,'0.66',0),
 (5035,2,20,92,8984,'9.45',0),
 (5036,2,21,92,551,'0.58',0),
 (5037,2,22,92,274,'0.29',0),
 (5038,2,23,92,1044,'1.10',0),
 (5039,2,24,92,57,'0.06',0),
 (5040,2,25,92,86,'0.09',0),
 (5041,2,1,93,835,'58.15',0),
 (5042,2,2,93,400,'27.86',0),
 (5043,2,4,93,3,'0.21',0),
 (5044,2,6,93,0,'0.00',0),
 (5045,2,7,93,0,'0.00',0),
 (5046,2,8,93,0,'0.00',0),
 (5047,2,9,93,54,'3.76',0),
 (5048,2,13,93,0,'0.00',0),
 (5049,2,14,93,4,'0.28',0),
 (5050,2,15,93,2,'0.14',0),
 (5051,2,16,93,4,'0.28',0),
 (5052,2,17,93,5,'0.35',0),
 (5053,2,20,93,70,'4.87',0),
 (5054,2,21,93,7,'0.49',0),
 (5055,2,22,93,3,'0.21',0),
 (5056,2,23,93,13,'0.91',0),
 (5057,2,24,93,3,'0.21',0),
 (5058,2,25,93,2,'0.14',0),
 (5059,2,1,94,317,'55.71',0),
 (5060,2,2,94,107,'18.80',0),
 (5061,2,4,94,0,'0.00',0),
 (5062,2,6,94,0,'0.00',0),
 (5063,2,7,94,0,'0.00',0),
 (5064,2,8,94,2,'0.35',0),
 (5065,2,9,94,37,'6.50',0),
 (5066,2,13,94,0,'0.00',0),
 (5067,2,14,94,1,'0.18',0),
 (5068,2,15,94,1,'0.18',0),
 (5069,2,16,94,4,'0.70',0),
 (5070,2,17,94,6,'1.05',0),
 (5071,2,20,94,40,'7.03',0),
 (5072,2,21,94,6,'1.05',0),
 (5073,2,22,94,1,'0.18',0),
 (5074,2,23,94,26,'4.57',0),
 (5075,2,24,94,1,'0.18',0),
 (5076,2,25,94,1,'0.18',0),
 (5077,2,1,95,572,'54.63',0),
 (5078,2,2,95,251,'23.97',0),
 (5079,2,4,95,2,'0.19',0),
 (5080,2,6,95,0,'0.00',0),
 (5081,2,7,95,0,'0.00',0),
 (5082,2,8,95,3,'0.29',0),
 (5083,2,9,95,29,'2.77',0),
 (5084,2,13,95,1,'0.10',0),
 (5085,2,14,95,1,'0.10',0),
 (5086,2,15,95,5,'0.48',0),
 (5087,2,16,95,2,'0.19',0),
 (5088,2,17,95,10,'0.96',0),
 (5089,2,20,95,148,'14.14',0),
 (5090,2,21,95,2,'0.19',0),
 (5091,2,22,95,1,'0.10',0),
 (5092,2,23,95,4,'0.38',0),
 (5093,2,24,95,0,'0.00',0),
 (5094,2,25,95,0,'0.00',0),
 (5095,2,1,96,6145,'56.10',0),
 (5096,2,2,96,3026,'27.62',0),
 (5097,2,4,96,14,'0.13',0),
 (5098,2,6,96,3,'0.03',0),
 (5099,2,7,96,4,'0.04',0),
 (5100,2,8,96,14,'0.13',0),
 (5101,2,9,96,554,'5.06',0),
 (5102,2,13,96,1,'0.01',0),
 (5103,2,14,96,13,'0.12',0),
 (5104,2,15,96,16,'0.15',0),
 (5105,2,16,96,29,'0.26',0),
 (5106,2,17,96,52,'0.47',0),
 (5107,2,20,96,673,'6.14',0),
 (5108,2,21,96,48,'0.44',0),
 (5109,2,22,96,29,'0.26',0),
 (5110,2,23,96,98,'0.89',0),
 (5111,2,24,96,3,'0.03',0),
 (5112,2,25,96,7,'0.06',0),
 (5113,2,1,97,35,'33.65',0),
 (5114,2,2,97,49,'47.12',0),
 (5115,2,4,97,0,'0.00',0),
 (5116,2,6,97,0,'0.00',0),
 (5117,2,7,97,0,'0.00',0),
 (5118,2,8,97,0,'0.00',0),
 (5119,2,9,97,3,'2.88',0),
 (5120,2,13,97,0,'0.00',0),
 (5121,2,14,97,0,'0.00',0),
 (5122,2,15,97,0,'0.00',0),
 (5123,2,16,97,0,'0.00',0),
 (5124,2,17,97,2,'1.92',0),
 (5125,2,20,97,6,'5.77',0),
 (5126,2,21,97,0,'0.00',0),
 (5127,2,22,97,0,'0.00',0),
 (5128,2,23,97,0,'0.00',0),
 (5129,2,24,97,0,'0.00',0),
 (5130,2,25,97,0,'0.00',0),
 (5131,2,1,99,880,'71.95',0),
 (5132,2,2,99,200,'16.35',0),
 (5133,2,4,99,1,'0.08',0),
 (5134,2,6,99,0,'0.00',0),
 (5135,2,7,99,0,'0.00',0),
 (5136,2,8,99,5,'0.41',0),
 (5137,2,9,99,27,'2.21',0),
 (5138,2,13,99,2,'0.16',0),
 (5139,2,14,99,0,'0.00',0),
 (5140,2,15,99,3,'0.25',0),
 (5141,2,16,99,7,'0.57',0),
 (5142,2,17,99,10,'0.82',0),
 (5143,2,20,99,55,'4.50',0),
 (5144,2,21,99,6,'0.49',0),
 (5145,2,22,99,1,'0.08',0),
 (5146,2,23,99,9,'0.74',0),
 (5147,2,24,99,0,'0.00',0),
 (5148,2,25,99,0,'0.00',0),
 (5149,2,1,100,1412,'55.22',0),
 (5150,2,2,100,488,'19.08',0),
 (5151,2,4,100,25,'0.98',0),
 (5152,2,6,100,1,'0.04',0),
 (5153,2,7,100,0,'0.00',0),
 (5154,2,8,100,1,'0.04',0),
 (5155,2,9,100,204,'7.98',0),
 (5156,2,13,100,0,'0.00',0),
 (5157,2,14,100,4,'0.16',0),
 (5158,2,15,100,1,'0.04',0),
 (5159,2,16,100,4,'0.16',0),
 (5160,2,17,100,15,'0.59',0),
 (5161,2,20,100,277,'10.83',0),
 (5162,2,21,100,11,'0.43',0),
 (5163,2,22,100,8,'0.31',0),
 (5164,2,23,100,26,'1.02',0),
 (5165,2,24,100,4,'0.16',0),
 (5166,2,25,100,17,'0.66',0),
 (5167,2,1,101,95,'50.26',0),
 (5168,2,2,101,42,'22.22',0),
 (5169,2,4,101,0,'0.00',0),
 (5170,2,6,101,0,'0.00',0),
 (5171,2,7,101,1,'0.53',0),
 (5172,2,8,101,0,'0.00',0),
 (5173,2,9,101,7,'3.70',0),
 (5174,2,13,101,0,'0.00',0),
 (5175,2,14,101,1,'0.53',0),
 (5176,2,15,101,0,'0.00',0),
 (5177,2,16,101,0,'0.00',0),
 (5178,2,17,101,1,'0.53',0),
 (5179,2,20,101,23,'12.17',0),
 (5180,2,21,101,1,'0.53',0),
 (5181,2,22,101,2,'1.06',0),
 (5182,2,23,101,1,'0.53',0),
 (5183,2,24,101,0,'0.00',0),
 (5184,2,25,101,1,'0.53',0),
 (5185,2,1,102,341,'47.76',0),
 (5186,2,2,102,316,'44.26',0),
 (5187,2,4,102,0,'0.00',0),
 (5188,2,6,102,0,'0.00',0),
 (5189,2,7,102,0,'0.00',0),
 (5190,2,8,102,0,'0.00',0),
 (5191,2,9,102,3,'0.42',0),
 (5192,2,13,102,0,'0.00',0),
 (5193,2,14,102,0,'0.00',0),
 (5194,2,15,102,3,'0.42',0),
 (5195,2,16,102,0,'0.00',0),
 (5196,2,17,102,2,'0.28',0),
 (5197,2,20,102,33,'4.62',0),
 (5198,2,21,102,0,'0.00',0),
 (5199,2,22,102,0,'0.00',0),
 (5200,2,23,102,3,'0.42',0),
 (5201,2,24,102,0,'0.00',0),
 (5202,2,25,102,0,'0.00',0),
 (5203,2,1,104,4666,'56.81',0),
 (5204,2,2,104,1600,'19.48',0),
 (5205,2,4,104,11,'0.13',0),
 (5206,2,6,104,1,'0.01',0),
 (5207,2,7,104,1,'0.01',0),
 (5208,2,8,104,17,'0.21',0),
 (5209,2,9,104,718,'8.74',0),
 (5210,2,13,104,0,'0.00',0),
 (5211,2,14,104,7,'0.09',0),
 (5212,2,15,104,10,'0.12',0),
 (5213,2,16,104,25,'0.30',0),
 (5214,2,17,104,60,'0.73',0),
 (5215,2,20,104,644,'7.84',0),
 (5216,2,21,104,64,'0.78',0),
 (5217,2,22,104,21,'0.26',0),
 (5218,2,23,104,98,'1.19',0),
 (5219,2,24,104,7,'0.09',0),
 (5220,2,25,104,5,'0.06',0),
 (5221,2,1,106,17320,'37.47',0),
 (5222,2,2,106,20242,'43.80',0),
 (5223,2,4,106,42,'0.09',0),
 (5224,2,6,106,23,'0.05',0),
 (5225,2,7,106,18,'0.04',0),
 (5226,2,8,106,53,'0.11',0),
 (5227,2,9,106,2187,'4.73',0),
 (5228,2,13,106,11,'0.02',0),
 (5229,2,14,106,58,'0.13',0),
 (5230,2,15,106,142,'0.31',0),
 (5231,2,16,106,164,'0.35',0),
 (5232,2,17,106,319,'0.69',0),
 (5233,2,20,106,3887,'8.41',0),
 (5234,2,21,106,188,'0.41',0),
 (5235,2,22,106,109,'0.24',0),
 (5236,2,23,106,376,'0.81',0),
 (5237,2,24,106,35,'0.08',0),
 (5238,2,25,106,71,'0.15',0),
 (5239,2,1,107,149,'41.97',0),
 (5240,2,2,107,147,'41.41',0),
 (5241,2,4,107,0,'0.00',0),
 (5242,2,6,107,0,'0.00',0),
 (5243,2,7,107,0,'0.00',0),
 (5244,2,8,107,0,'0.00',0),
 (5245,2,9,107,9,'2.54',0),
 (5246,2,13,107,1,'0.28',0),
 (5247,2,14,107,0,'0.00',0),
 (5248,2,15,107,1,'0.28',0),
 (5249,2,16,107,9,'2.54',0),
 (5250,2,17,107,3,'0.85',0),
 (5251,2,20,107,23,'6.48',0),
 (5252,2,21,107,2,'0.56',0),
 (5253,2,22,107,0,'0.00',0),
 (5254,2,23,107,3,'0.85',0),
 (5255,2,24,107,0,'0.00',0),
 (5256,2,25,107,0,'0.00',0),
 (5257,2,1,108,1092,'54.55',0),
 (5258,2,2,108,464,'23.18',0),
 (5259,2,4,108,8,'0.40',0),
 (5260,2,6,108,1,'0.05',0),
 (5261,2,7,108,1,'0.05',0),
 (5262,2,8,108,2,'0.10',0),
 (5263,2,9,108,105,'5.24',0),
 (5264,2,13,108,2,'0.10',0),
 (5265,2,14,108,0,'0.00',0),
 (5266,2,15,108,9,'0.45',0),
 (5267,2,16,108,6,'0.30',0),
 (5268,2,17,108,15,'0.75',0),
 (5269,2,20,108,164,'8.19',0),
 (5270,2,21,108,23,'1.15',0),
 (5271,2,22,108,3,'0.15',0),
 (5272,2,23,108,35,'1.75',0),
 (5273,2,24,108,2,'0.10',0),
 (5274,2,25,108,1,'0.05',0),
 (5275,2,1,109,767,'71.88',0),
 (5276,2,2,109,183,'17.15',0),
 (5277,2,4,109,1,'0.09',0),
 (5278,2,6,109,1,'0.09',0),
 (5279,2,7,109,0,'0.00',0),
 (5280,2,8,109,1,'0.09',0),
 (5281,2,9,109,27,'2.53',0),
 (5282,2,13,109,2,'0.19',0),
 (5283,2,14,109,0,'0.00',0),
 (5284,2,15,109,0,'0.00',0),
 (5285,2,16,109,5,'0.47',0),
 (5286,2,17,109,8,'0.75',0),
 (5287,2,20,109,52,'4.87',0),
 (5288,2,21,109,3,'0.28',0),
 (5289,2,22,109,1,'0.09',0),
 (5290,2,23,109,4,'0.37',0),
 (5291,2,24,109,0,'0.00',0),
 (5292,2,25,109,0,'0.00',0),
 (5293,2,1,110,813,'54.60',0),
 (5294,2,2,110,532,'35.73',0),
 (5295,2,4,110,0,'0.00',0),
 (5296,2,6,110,0,'0.00',0),
 (5297,2,7,110,0,'0.00',0),
 (5298,2,8,110,1,'0.07',0),
 (5299,2,9,110,22,'1.48',0),
 (5300,2,13,110,0,'0.00',0),
 (5301,2,14,110,1,'0.07',0),
 (5302,2,15,110,0,'0.00',0),
 (5303,2,16,110,1,'0.07',0),
 (5304,2,17,110,2,'0.13',0),
 (5305,2,20,110,90,'6.04',0),
 (5306,2,21,110,4,'0.27',0),
 (5307,2,22,110,1,'0.07',0),
 (5308,2,23,110,4,'0.27',0),
 (5309,2,24,110,0,'0.00',0),
 (5310,2,25,110,5,'0.34',0),
 (5311,2,1,111,299,'57.39',0),
 (5312,2,2,111,118,'22.65',0),
 (5313,2,4,111,0,'0.00',0),
 (5314,2,6,111,0,'0.00',0),
 (5315,2,7,111,0,'0.00',0),
 (5316,2,8,111,0,'0.00',0),
 (5317,2,9,111,16,'3.07',0),
 (5318,2,13,111,0,'0.00',0),
 (5319,2,14,111,0,'0.00',0),
 (5320,2,15,111,2,'0.38',0),
 (5321,2,16,111,2,'0.38',0),
 (5322,2,17,111,1,'0.19',0),
 (5323,2,20,111,69,'13.24',0),
 (5324,2,21,111,0,'0.00',0),
 (5325,2,22,111,0,'0.00',0),
 (5326,2,23,111,0,'0.00',0),
 (5327,2,24,111,0,'0.00',0),
 (5328,2,25,111,1,'0.19',0),
 (5329,2,1,112,80,'55.17',0),
 (5330,2,2,112,58,'40.00',0),
 (5331,2,4,112,0,'0.00',0),
 (5332,2,6,112,0,'0.00',0),
 (5333,2,7,112,0,'0.00',0),
 (5334,2,8,112,0,'0.00',0),
 (5335,2,9,112,2,'1.38',0),
 (5336,2,13,112,0,'0.00',0),
 (5337,2,14,112,0,'0.00',0),
 (5338,2,15,112,0,'0.00',0),
 (5339,2,16,112,0,'0.00',0),
 (5340,2,17,112,0,'0.00',0),
 (5341,2,20,112,2,'1.38',0),
 (5342,2,21,112,1,'0.69',0),
 (5343,2,22,112,0,'0.00',0),
 (5344,2,23,112,0,'0.00',0),
 (5345,2,24,112,0,'0.00',0),
 (5346,2,25,112,0,'0.00',0),
 (5347,2,1,113,10238,'49.10',0),
 (5348,2,2,113,6398,'30.68',0),
 (5349,2,4,113,14,'0.07',0),
 (5350,2,6,113,4,'0.02',0),
 (5351,2,7,113,12,'0.06',0),
 (5352,2,8,113,24,'0.12',0),
 (5353,2,9,113,1501,'7.20',0),
 (5354,2,13,113,7,'0.03',0),
 (5355,2,14,113,31,'0.15',0),
 (5356,2,15,113,52,'0.25',0),
 (5357,2,16,113,59,'0.28',0),
 (5358,2,17,113,215,'1.03',0),
 (5359,2,20,113,1377,'6.60',0),
 (5360,2,21,113,102,'0.49',0),
 (5361,2,22,113,47,'0.23',0),
 (5362,2,23,113,189,'0.91',0),
 (5363,2,24,113,6,'0.03',0),
 (5364,2,25,113,15,'0.07',0),
 (5365,2,1,114,68,'54.84',0),
 (5366,2,2,114,37,'29.84',0),
 (5367,2,4,114,0,'0.00',0),
 (5368,2,6,114,0,'0.00',0),
 (5369,2,7,114,0,'0.00',0),
 (5370,2,8,114,0,'0.00',0),
 (5371,2,9,114,6,'4.84',0),
 (5372,2,13,114,0,'0.00',0),
 (5373,2,14,114,0,'0.00',0),
 (5374,2,15,114,0,'0.00',0),
 (5375,2,16,114,3,'2.42',0),
 (5376,2,17,114,2,'1.61',0),
 (5377,2,20,114,4,'3.23',0),
 (5378,2,21,114,1,'0.81',0),
 (5379,2,22,114,0,'0.00',0),
 (5380,2,23,114,1,'0.81',0),
 (5381,2,24,114,0,'0.00',0),
 (5382,2,25,114,0,'0.00',0),
 (5383,2,1,115,27735,'67.22',0),
 (5384,2,2,115,6061,'14.69',0),
 (5385,2,4,115,81,'0.20',0),
 (5386,2,6,115,3,'0.01',0),
 (5387,2,7,115,16,'0.04',0),
 (5388,2,8,115,125,'0.30',0),
 (5389,2,9,115,3169,'7.68',0),
 (5390,2,13,115,15,'0.04',0),
 (5391,2,14,115,47,'0.11',0),
 (5392,2,15,115,38,'0.09',0),
 (5393,2,16,115,55,'0.13',0),
 (5394,2,17,115,172,'0.42',0),
 (5395,2,20,115,1914,'4.64',0),
 (5396,2,21,115,280,'0.68',0),
 (5397,2,22,115,148,'0.36',0),
 (5398,2,23,115,277,'0.67',0),
 (5399,2,24,115,22,'0.05',0),
 (5400,2,25,115,114,'0.28',0),
 (5401,2,1,116,252,'52.50',0),
 (5402,2,2,116,157,'32.71',0),
 (5403,2,4,116,0,'0.00',0),
 (5404,2,6,116,0,'0.00',0),
 (5405,2,7,116,0,'0.00',0),
 (5406,2,8,116,1,'0.21',0),
 (5407,2,9,116,16,'3.33',0),
 (5408,2,13,116,0,'0.00',0),
 (5409,2,14,116,2,'0.42',0),
 (5410,2,15,116,2,'0.42',0),
 (5411,2,16,116,5,'1.04',0),
 (5412,2,17,116,1,'0.21',0),
 (5413,2,20,116,25,'5.21',0),
 (5414,2,21,116,1,'0.21',0),
 (5415,2,22,116,0,'0.00',0),
 (5416,2,23,116,4,'0.83',0),
 (5417,2,24,116,1,'0.21',0),
 (5418,2,25,116,3,'0.63',0),
 (5419,2,1,117,58,'60.42',0),
 (5420,2,2,117,23,'23.96',0),
 (5421,2,4,117,0,'0.00',0),
 (5422,2,6,117,0,'0.00',0),
 (5423,2,7,117,0,'0.00',0),
 (5424,2,8,117,0,'0.00',0),
 (5425,2,9,117,1,'1.04',0),
 (5426,2,13,117,0,'0.00',0),
 (5427,2,14,117,0,'0.00',0),
 (5428,2,15,117,0,'0.00',0),
 (5429,2,16,117,0,'0.00',0),
 (5430,2,17,117,0,'0.00',0),
 (5431,2,20,117,9,'9.38',0),
 (5432,2,21,117,0,'0.00',0),
 (5433,2,22,117,0,'0.00',0),
 (5434,2,23,117,3,'3.13',0),
 (5435,2,24,117,0,'0.00',0),
 (5436,2,25,117,0,'0.00',0),
 (5437,2,1,118,33,'64.71',0),
 (5438,2,2,118,9,'17.65',0),
 (5439,2,4,118,0,'0.00',0),
 (5440,2,6,118,0,'0.00',0),
 (5441,2,7,118,0,'0.00',0),
 (5442,2,8,118,0,'0.00',0),
 (5443,2,9,118,1,'1.96',0),
 (5444,2,13,118,0,'0.00',0),
 (5445,2,14,118,0,'0.00',0),
 (5446,2,15,118,1,'1.96',0),
 (5447,2,16,118,0,'0.00',0),
 (5448,2,17,118,0,'0.00',0),
 (5449,2,20,118,5,'9.80',0),
 (5450,2,21,118,1,'1.96',0),
 (5451,2,22,118,0,'0.00',0),
 (5452,2,23,118,0,'0.00',0),
 (5453,2,24,118,0,'0.00',0),
 (5454,2,25,118,0,'0.00',0),
 (5455,2,1,119,944,'65.10',0),
 (5456,2,2,119,286,'19.72',0),
 (5457,2,4,119,1,'0.07',0),
 (5458,2,6,119,1,'0.07',0),
 (5459,2,7,119,1,'0.07',0),
 (5460,2,8,119,1,'0.07',0),
 (5461,2,9,119,62,'4.28',0),
 (5462,2,13,119,0,'0.00',0),
 (5463,2,14,119,4,'0.28',0),
 (5464,2,15,119,0,'0.00',0),
 (5465,2,16,119,3,'0.21',0),
 (5466,2,17,119,11,'0.76',0),
 (5467,2,20,119,85,'5.86',0),
 (5468,2,21,119,8,'0.55',0),
 (5469,2,22,119,1,'0.07',0),
 (5470,2,23,119,15,'1.03',0),
 (5471,2,24,119,0,'0.00',0),
 (5472,2,25,119,0,'0.00',0),
 (5473,2,1,120,469,'49.68',0),
 (5474,2,2,120,357,'37.82',0),
 (5475,2,4,120,2,'0.21',0),
 (5476,2,6,120,0,'0.00',0),
 (5477,2,7,120,1,'0.11',0),
 (5478,2,8,120,0,'0.00',0),
 (5479,2,9,120,25,'2.65',0),
 (5480,2,13,120,0,'0.00',0),
 (5481,2,14,120,0,'0.00',0),
 (5482,2,15,120,1,'0.11',0),
 (5483,2,16,120,1,'0.11',0),
 (5484,2,17,120,1,'0.11',0),
 (5485,2,20,120,53,'5.61',0),
 (5486,2,21,120,2,'0.21',0),
 (5487,2,22,120,0,'0.00',0),
 (5488,2,23,120,8,'0.85',0),
 (5489,2,24,120,1,'0.11',0),
 (5490,2,25,120,1,'0.11',0),
 (5491,2,1,121,74,'46.84',0),
 (5492,2,2,121,59,'37.34',0),
 (5493,2,4,121,1,'0.63',0),
 (5494,2,6,121,0,'0.00',0),
 (5495,2,7,121,0,'0.00',0),
 (5496,2,8,121,0,'0.00',0),
 (5497,2,9,121,5,'3.16',0),
 (5498,2,13,121,0,'0.00',0),
 (5499,2,14,121,0,'0.00',0),
 (5500,2,15,121,1,'0.63',0),
 (5501,2,16,121,0,'0.00',0),
 (5502,2,17,121,1,'0.63',0),
 (5503,2,20,121,5,'3.16',0),
 (5504,2,21,121,2,'1.27',0),
 (5505,2,22,121,0,'0.00',0),
 (5506,2,23,121,5,'3.16',0),
 (5507,2,24,121,0,'0.00',0),
 (5508,2,25,121,0,'0.00',0),
 (5509,2,1,122,216,'54.96',0),
 (5510,2,2,122,121,'30.79',0),
 (5511,2,4,122,2,'0.51',0),
 (5512,2,6,122,0,'0.00',0),
 (5513,2,7,122,0,'0.00',0),
 (5514,2,8,122,0,'0.00',0),
 (5515,2,9,122,6,'1.53',0),
 (5516,2,13,122,0,'0.00',0),
 (5517,2,14,122,0,'0.00',0),
 (5518,2,15,122,1,'0.25',0),
 (5519,2,16,122,0,'0.00',0),
 (5520,2,17,122,5,'1.27',0),
 (5521,2,20,122,22,'5.60',0),
 (5522,2,21,122,1,'0.25',0),
 (5523,2,22,122,2,'0.51',0),
 (5524,2,23,122,5,'1.27',0),
 (5525,2,24,122,0,'0.00',0),
 (5526,2,25,122,0,'0.00',0),
 (5527,2,1,123,11846,'35.43',0),
 (5528,2,2,123,9676,'28.94',0),
 (5529,2,4,123,17,'0.05',0),
 (5530,2,6,123,4,'0.01',0),
 (5531,2,7,123,18,'0.05',0),
 (5532,2,8,123,84,'0.25',0),
 (5533,2,9,123,2185,'6.54',0),
 (5534,2,13,123,17,'0.05',0),
 (5535,2,14,123,46,'0.14',0),
 (5536,2,15,123,77,'0.23',0),
 (5537,2,16,123,57,'0.17',0),
 (5538,2,17,123,234,'0.70',0),
 (5539,2,20,123,7229,'21.62',0),
 (5540,2,21,123,281,'0.84',0),
 (5541,2,22,123,101,'0.30',0),
 (5542,2,23,123,452,'1.35',0),
 (5543,2,24,123,17,'0.05',0),
 (5544,2,25,123,34,'0.10',0),
 (5545,2,1,124,29,'46.03',0),
 (5546,2,2,124,15,'23.81',0),
 (5547,2,4,124,0,'0.00',0),
 (5548,2,6,124,0,'0.00',0),
 (5549,2,7,124,0,'0.00',0),
 (5550,2,8,124,0,'0.00',0),
 (5551,2,9,124,6,'9.52',0),
 (5552,2,13,124,0,'0.00',0),
 (5553,2,14,124,0,'0.00',0),
 (5554,2,15,124,0,'0.00',0),
 (5555,2,16,124,0,'0.00',0),
 (5556,2,17,124,4,'6.35',0),
 (5557,2,20,124,9,'14.29',0),
 (5558,2,21,124,0,'0.00',0),
 (5559,2,22,124,0,'0.00',0),
 (5560,2,23,124,0,'0.00',0),
 (5561,2,24,124,0,'0.00',0),
 (5562,2,25,124,0,'0.00',0),
 (5563,2,1,125,1266,'63.30',0),
 (5564,2,2,125,432,'21.60',0),
 (5565,2,4,125,1,'0.05',0),
 (5566,2,6,125,0,'0.00',0),
 (5567,2,7,125,1,'0.05',0),
 (5568,2,8,125,2,'0.10',0),
 (5569,2,9,125,35,'1.75',0),
 (5570,2,13,125,2,'0.10',0),
 (5571,2,14,125,0,'0.00',0),
 (5572,2,15,125,2,'0.10',0),
 (5573,2,16,125,9,'0.45',0),
 (5574,2,17,125,7,'0.35',0),
 (5575,2,20,125,169,'8.45',0),
 (5576,2,21,125,6,'0.30',0),
 (5577,2,22,125,5,'0.25',0),
 (5578,2,23,125,18,'0.90',0),
 (5579,2,24,125,0,'0.00',0),
 (5580,2,25,125,1,'0.05',0),
 (5581,2,1,126,20,'45.45',0),
 (5582,2,2,126,19,'43.18',0),
 (5583,2,4,126,0,'0.00',0),
 (5584,2,6,126,0,'0.00',0),
 (5585,2,7,126,0,'0.00',0),
 (5586,2,8,126,0,'0.00',0),
 (5587,2,9,126,1,'2.27',0),
 (5588,2,13,126,0,'0.00',0),
 (5589,2,14,126,0,'0.00',0),
 (5590,2,15,126,0,'0.00',0),
 (5591,2,16,126,0,'0.00',0),
 (5592,2,17,126,0,'0.00',0),
 (5593,2,20,126,3,'6.82',0),
 (5594,2,21,126,0,'0.00',0),
 (5595,2,22,126,0,'0.00',0),
 (5596,2,23,126,0,'0.00',0),
 (5597,2,24,126,0,'0.00',0),
 (5598,2,25,126,0,'0.00',0),
 (5599,2,1,127,26618,'63.46',0),
 (5600,2,2,127,6480,'15.45',0),
 (5601,2,4,127,75,'0.18',0),
 (5602,2,6,127,1,'0.00',0),
 (5603,2,7,127,15,'0.04',0),
 (5604,2,8,127,92,'0.22',0),
 (5605,2,9,127,3838,'9.15',0),
 (5606,2,13,127,6,'0.01',0),
 (5607,2,14,127,49,'0.12',0),
 (5608,2,15,127,37,'0.09',0),
 (5609,2,16,127,69,'0.16',0),
 (5610,2,17,127,221,'0.53',0),
 (5611,2,20,127,2484,'5.92',0),
 (5612,2,21,127,293,'0.70',0),
 (5613,2,22,127,117,'0.28',0),
 (5614,2,23,127,382,'0.91',0),
 (5615,2,24,127,14,'0.03',0),
 (5616,2,25,127,32,'0.08',0),
 (5617,2,1,128,180,'57.88',0),
 (5618,2,2,128,98,'31.51',0),
 (5619,2,4,128,0,'0.00',0),
 (5620,2,6,128,0,'0.00',0),
 (5621,2,7,128,0,'0.00',0),
 (5622,2,8,128,0,'0.00',0),
 (5623,2,9,128,4,'1.29',0),
 (5624,2,13,128,1,'0.32',0),
 (5625,2,14,128,0,'0.00',0),
 (5626,2,15,128,0,'0.00',0),
 (5627,2,16,128,1,'0.32',0),
 (5628,2,17,128,0,'0.00',0),
 (5629,2,20,128,20,'6.43',0),
 (5630,2,21,128,1,'0.32',0),
 (5631,2,22,128,0,'0.00',0),
 (5632,2,23,128,1,'0.32',0),
 (5633,2,24,128,1,'0.32',0),
 (5634,2,25,128,0,'0.00',0),
 (5635,2,1,129,2714,'57.70',0),
 (5636,2,2,129,1048,'22.28',0),
 (5637,2,4,129,39,'0.83',0),
 (5638,2,6,129,0,'0.00',0),
 (5639,2,7,129,2,'0.04',0),
 (5640,2,8,129,10,'0.21',0),
 (5641,2,9,129,282,'5.99',0),
 (5642,2,13,129,5,'0.11',0),
 (5643,2,14,129,5,'0.11',0),
 (5644,2,15,129,8,'0.17',0),
 (5645,2,16,129,8,'0.17',0),
 (5646,2,17,129,30,'0.64',0),
 (5647,2,20,129,332,'7.06',0),
 (5648,2,21,129,30,'0.64',0),
 (5649,2,22,129,22,'0.47',0),
 (5650,2,23,129,45,'0.96',0),
 (5651,2,24,129,4,'0.09',0),
 (5652,2,25,129,3,'0.06',0),
 (5653,2,1,130,7622,'40.70',0),
 (5654,2,2,130,5318,'28.40',0),
 (5655,2,4,130,19,'0.10',0),
 (5656,2,6,130,3,'0.02',0),
 (5657,2,7,130,11,'0.06',0),
 (5658,2,8,130,31,'0.17',0),
 (5659,2,9,130,1020,'5.45',0),
 (5660,2,13,130,4,'0.02',0),
 (5661,2,14,130,22,'0.12',0),
 (5662,2,15,130,37,'0.20',0),
 (5663,2,16,130,54,'0.29',0),
 (5664,2,17,130,146,'0.78',0),
 (5665,2,20,130,3614,'19.30',0),
 (5666,2,21,130,91,'0.49',0),
 (5667,2,22,130,43,'0.23',0),
 (5668,2,23,130,177,'0.95',0),
 (5669,2,24,130,7,'0.04',0),
 (5670,2,25,130,68,'0.36',0),
 (5671,2,1,131,4604,'56.04',0),
 (5672,2,2,131,1915,'23.31',0),
 (5673,2,4,131,15,'0.18',0),
 (5674,2,6,131,0,'0.00',0),
 (5675,2,7,131,4,'0.05',0),
 (5676,2,8,131,20,'0.24',0),
 (5677,2,9,131,465,'5.66',0),
 (5678,2,13,131,4,'0.05',0),
 (5679,2,14,131,13,'0.16',0),
 (5680,2,15,131,10,'0.12',0),
 (5681,2,16,131,25,'0.30',0),
 (5682,2,17,131,59,'0.72',0),
 (5683,2,20,131,678,'8.25',0),
 (5684,2,21,131,61,'0.74',0),
 (5685,2,22,131,35,'0.43',0),
 (5686,2,23,131,99,'1.20',0),
 (5687,2,24,131,3,'0.04',0),
 (5688,2,25,131,4,'0.05',0),
 (5689,2,1,132,3481,'48.79',0),
 (5690,2,2,132,2335,'32.73',0),
 (5691,2,4,132,5,'0.07',0),
 (5692,2,6,132,2,'0.03',0),
 (5693,2,7,132,4,'0.06',0),
 (5694,2,8,132,14,'0.20',0),
 (5695,2,9,132,237,'3.32',0),
 (5696,2,13,132,0,'0.00',0),
 (5697,2,14,132,2,'0.03',0),
 (5698,2,15,132,11,'0.15',0),
 (5699,2,16,132,38,'0.53',0),
 (5700,2,17,132,43,'0.60',0),
 (5701,2,20,132,610,'8.55',0),
 (5702,2,21,132,37,'0.52',0),
 (5703,2,22,132,20,'0.28',0),
 (5704,2,23,132,101,'1.42',0),
 (5705,2,24,132,2,'0.03',0),
 (5706,2,25,132,5,'0.07',0),
 (5707,2,1,133,2178,'52.29',0),
 (5708,2,2,133,1588,'38.13',0),
 (5709,2,4,133,2,'0.05',0),
 (5710,2,6,133,0,'0.00',0),
 (5711,2,7,133,0,'0.00',0),
 (5712,2,8,133,2,'0.05',0),
 (5713,2,9,133,102,'2.45',0),
 (5714,2,13,133,3,'0.07',0),
 (5715,2,14,133,2,'0.05',0),
 (5716,2,15,133,5,'0.12',0),
 (5717,2,16,133,9,'0.22',0),
 (5718,2,17,133,10,'0.24',0),
 (5719,2,20,133,184,'4.42',0),
 (5720,2,21,133,11,'0.26',0),
 (5721,2,22,133,4,'0.10',0),
 (5722,2,23,133,18,'0.43',0),
 (5723,2,24,133,1,'0.02',0),
 (5724,2,25,133,2,'0.05',0),
 (5725,2,1,134,18099,'49.54',0),
 (5726,2,2,134,9925,'27.17',0),
 (5727,2,4,134,26,'0.07',0),
 (5728,2,6,134,9,'0.02',0),
 (5729,2,7,134,26,'0.07',0),
 (5730,2,8,134,57,'0.16',0),
 (5731,2,9,134,2232,'6.11',0),
 (5732,2,13,134,19,'0.05',0),
 (5733,2,14,134,48,'0.13',0),
 (5734,2,15,134,72,'0.20',0),
 (5735,2,16,134,83,'0.23',0),
 (5736,2,17,134,174,'0.48',0),
 (5737,2,20,134,3890,'10.65',0),
 (5738,2,21,134,287,'0.79',0),
 (5739,2,22,134,147,'0.40',0),
 (5740,2,23,134,388,'1.06',0),
 (5741,2,24,134,19,'0.05',0),
 (5742,2,25,134,26,'0.07',0),
 (5743,2,1,135,407,'61.20',0),
 (5744,2,2,135,148,'22.26',0),
 (5745,2,4,135,0,'0.00',0),
 (5746,2,6,135,0,'0.00',0),
 (5747,2,7,135,0,'0.00',0),
 (5748,2,8,135,0,'0.00',0),
 (5749,2,9,135,10,'1.50',0),
 (5750,2,13,135,1,'0.15',0),
 (5751,2,14,135,1,'0.15',0),
 (5752,2,15,135,0,'0.00',0),
 (5753,2,16,135,3,'0.45',0),
 (5754,2,17,135,5,'0.75',0),
 (5755,2,20,135,59,'8.87',0),
 (5756,2,21,135,4,'0.60',0),
 (5757,2,22,135,0,'0.00',0),
 (5758,2,23,135,4,'0.60',0),
 (5759,2,24,135,1,'0.15',0),
 (5760,2,25,135,1,'0.15',0),
 (5761,2,1,136,306,'60.12',0),
 (5762,2,2,136,154,'30.26',0),
 (5763,2,4,136,3,'0.59',0),
 (5764,2,6,136,0,'0.00',0),
 (5765,2,7,136,0,'0.00',0),
 (5766,2,8,136,0,'0.00',0),
 (5767,2,9,136,11,'2.16',0),
 (5768,2,13,136,0,'0.00',0),
 (5769,2,14,136,2,'0.39',0),
 (5770,2,15,136,0,'0.00',0),
 (5771,2,16,136,1,'0.20',0),
 (5772,2,17,136,0,'0.00',0),
 (5773,2,20,136,17,'3.34',0),
 (5774,2,21,136,0,'0.00',0),
 (5775,2,22,136,3,'0.59',0),
 (5776,2,23,136,5,'0.98',0),
 (5777,2,24,136,0,'0.00',0),
 (5778,2,25,136,0,'0.00',0),
 (5779,2,1,137,625,'50.65',0),
 (5780,2,2,137,459,'37.20',0),
 (5781,2,4,137,8,'0.65',0),
 (5782,2,6,137,0,'0.00',0),
 (5783,2,7,137,2,'0.16',0),
 (5784,2,8,137,0,'0.00',0),
 (5785,2,9,137,23,'1.86',0),
 (5786,2,13,137,0,'0.00',0),
 (5787,2,14,137,0,'0.00',0),
 (5788,2,15,137,2,'0.16',0),
 (5789,2,16,137,10,'0.81',0),
 (5790,2,17,137,4,'0.32',0),
 (5791,2,20,137,55,'4.46',0),
 (5792,2,21,137,7,'0.57',0),
 (5793,2,22,137,0,'0.00',0),
 (5794,2,23,137,12,'0.97',0),
 (5795,2,24,137,0,'0.00',0),
 (5796,2,25,137,0,'0.00',0),
 (5797,2,1,138,42,'68.85',0),
 (5798,2,2,138,15,'24.59',0),
 (5799,2,4,138,0,'0.00',0),
 (5800,2,6,138,0,'0.00',0),
 (5801,2,7,138,0,'0.00',0),
 (5802,2,8,138,0,'0.00',0),
 (5803,2,9,138,1,'1.64',0),
 (5804,2,13,138,0,'0.00',0),
 (5805,2,14,138,0,'0.00',0),
 (5806,2,15,138,0,'0.00',0),
 (5807,2,16,138,0,'0.00',0),
 (5808,2,17,138,1,'1.64',0),
 (5809,2,20,138,2,'3.28',0),
 (5810,2,21,138,0,'0.00',0),
 (5811,2,22,138,0,'0.00',0),
 (5812,2,23,138,0,'0.00',0),
 (5813,2,24,138,0,'0.00',0),
 (5814,2,25,138,0,'0.00',0),
 (5815,2,1,140,1139,'58.92',0),
 (5816,2,2,140,476,'24.62',0),
 (5817,2,4,140,4,'0.21',0),
 (5818,2,6,140,4,'0.21',0),
 (5819,2,7,140,1,'0.05',0),
 (5820,2,8,140,1,'0.05',0),
 (5821,2,9,140,71,'3.67',0),
 (5822,2,13,140,2,'0.10',0),
 (5823,2,14,140,2,'0.10',0),
 (5824,2,15,140,2,'0.10',0),
 (5825,2,16,140,11,'0.57',0),
 (5826,2,17,140,18,'0.93',0),
 (5827,2,20,140,98,'5.07',0),
 (5828,2,21,140,14,'0.72',0),
 (5829,2,22,140,3,'0.16',0),
 (5830,2,23,140,27,'1.40',0),
 (5831,2,24,140,2,'0.10',0),
 (5832,2,25,140,8,'0.41',0),
 (5833,2,1,141,2144,'60.02',0),
 (5834,2,2,141,717,'20.07',0),
 (5835,2,4,141,4,'0.11',0),
 (5836,2,6,141,1,'0.03',0),
 (5837,2,7,141,0,'0.00',0),
 (5838,2,8,141,1,'0.03',0),
 (5839,2,9,141,175,'4.90',0),
 (5840,2,13,141,0,'0.00',0),
 (5841,2,14,141,3,'0.08',0),
 (5842,2,15,141,10,'0.28',0),
 (5843,2,16,141,10,'0.28',0),
 (5844,2,17,141,30,'0.84',0),
 (5845,2,20,141,254,'7.11',0),
 (5846,2,21,141,16,'0.45',0),
 (5847,2,22,141,4,'0.11',0),
 (5848,2,23,141,38,'1.06',0),
 (5849,2,24,141,0,'0.00',0),
 (5850,2,25,141,74,'2.07',0),
 (5851,2,1,143,41,'58.57',0),
 (5852,2,2,143,19,'27.14',0),
 (5853,2,4,143,1,'1.43',0),
 (5854,2,6,143,0,'0.00',0),
 (5855,2,7,143,0,'0.00',0),
 (5856,2,8,143,0,'0.00',0),
 (5857,2,9,143,3,'4.29',0),
 (5858,2,13,143,0,'0.00',0),
 (5859,2,14,143,0,'0.00',0),
 (5860,2,15,143,0,'0.00',0),
 (5861,2,16,143,0,'0.00',0),
 (5862,2,17,143,0,'0.00',0),
 (5863,2,20,143,3,'4.29',0),
 (5864,2,21,143,1,'1.43',0),
 (5865,2,22,143,0,'0.00',0),
 (5866,2,23,143,0,'0.00',0),
 (5867,2,24,143,0,'0.00',0),
 (5868,2,25,143,0,'0.00',0),
 (5869,2,1,144,2410,'58.84',0),
 (5870,2,2,144,1018,'24.85',0),
 (5871,2,4,144,9,'0.22',0),
 (5872,2,6,144,3,'0.07',0),
 (5873,2,7,144,0,'0.00',0),
 (5874,2,8,144,5,'0.12',0),
 (5875,2,9,144,210,'5.13',0),
 (5876,2,13,144,0,'0.00',0),
 (5877,2,14,144,1,'0.02',0),
 (5878,2,15,144,5,'0.12',0),
 (5879,2,16,144,17,'0.42',0),
 (5880,2,17,144,23,'0.56',0),
 (5881,2,20,144,264,'6.45',0),
 (5882,2,21,144,16,'0.39',0),
 (5883,2,22,144,7,'0.17',0),
 (5884,2,23,144,32,'0.78',0),
 (5885,2,24,144,3,'0.07',0),
 (5886,2,25,144,2,'0.05',0),
 (5887,2,1,145,740,'50.17',0),
 (5888,2,2,145,462,'31.32',0),
 (5889,2,4,145,2,'0.14',0),
 (5890,2,6,145,0,'0.00',0),
 (5891,2,7,145,0,'0.00',0),
 (5892,2,8,145,0,'0.00',0),
 (5893,2,9,145,51,'3.46',0),
 (5894,2,13,145,0,'0.00',0),
 (5895,2,14,145,0,'0.00',0),
 (5896,2,15,145,2,'0.14',0),
 (5897,2,16,145,0,'0.00',0),
 (5898,2,17,145,8,'0.54',0),
 (5899,2,20,145,145,'9.83',0),
 (5900,2,21,145,8,'0.54',0),
 (5901,2,22,145,4,'0.27',0),
 (5902,2,23,145,13,'0.88',0),
 (5903,2,24,145,2,'0.14',0),
 (5904,2,25,145,1,'0.07',0),
 (5905,2,1,146,722,'57.62',0),
 (5906,2,2,146,442,'35.28',0),
 (5907,2,4,146,0,'0.00',0),
 (5908,2,6,146,1,'0.08',0),
 (5909,2,7,146,0,'0.00',0),
 (5910,2,8,146,0,'0.00',0),
 (5911,2,9,146,19,'1.52',0),
 (5912,2,13,146,0,'0.00',0),
 (5913,2,14,146,0,'0.00',0),
 (5914,2,15,146,0,'0.00',0),
 (5915,2,16,146,2,'0.16',0),
 (5916,2,17,146,1,'0.08',0),
 (5917,2,20,146,44,'3.51',0),
 (5918,2,21,146,4,'0.32',0),
 (5919,2,22,146,1,'0.08',0),
 (5920,2,23,146,2,'0.16',0),
 (5921,2,24,146,0,'0.00',0),
 (5922,2,25,146,1,'0.08',0),
 (5923,2,1,147,387,'51.95',0),
 (5924,2,2,147,275,'36.91',0),
 (5925,2,4,147,0,'0.00',0),
 (5926,2,6,147,0,'0.00',0),
 (5927,2,7,147,0,'0.00',0),
 (5928,2,8,147,0,'0.00',0),
 (5929,2,9,147,11,'1.48',0),
 (5930,2,13,147,0,'0.00',0),
 (5931,2,14,147,0,'0.00',0),
 (5932,2,15,147,1,'0.13',0),
 (5933,2,16,147,2,'0.27',0),
 (5934,2,17,147,2,'0.27',0),
 (5935,2,20,147,40,'5.37',0),
 (5936,2,21,147,2,'0.27',0),
 (5937,2,22,147,1,'0.13',0),
 (5938,2,23,147,2,'0.27',0),
 (5939,2,24,147,0,'0.00',0),
 (5940,2,25,147,11,'1.48',0),
 (5941,2,1,148,30825,'57.86',0),
 (5942,2,2,148,12073,'22.66',0),
 (5943,2,4,148,37,'0.07',0),
 (5944,2,6,148,9,'0.02',0),
 (5945,2,7,148,18,'0.03',0),
 (5946,2,8,148,56,'0.11',0),
 (5947,2,9,148,2674,'5.02',0),
 (5948,2,13,148,26,'0.05',0),
 (5949,2,14,148,43,'0.08',0),
 (5950,2,15,148,114,'0.21',0),
 (5951,2,16,148,99,'0.19',0),
 (5952,2,17,148,297,'0.56',0),
 (5953,2,20,148,4426,'8.31',0),
 (5954,2,21,148,282,'0.53',0),
 (5955,2,22,148,123,'0.23',0),
 (5956,2,23,148,564,'1.06',0),
 (5957,2,24,148,62,'0.12',0),
 (5958,2,25,148,31,'0.06',0),
 (5959,2,1,149,2043,'55.71',0),
 (5960,2,2,149,1022,'27.87',0),
 (5961,2,4,149,5,'0.14',0),
 (5962,2,6,149,2,'0.05',0),
 (5963,2,7,149,0,'0.00',0),
 (5964,2,8,149,2,'0.05',0),
 (5965,2,9,149,239,'6.52',0),
 (5966,2,13,149,0,'0.00',0),
 (5967,2,14,149,7,'0.19',0),
 (5968,2,15,149,4,'0.11',0),
 (5969,2,16,149,14,'0.38',0),
 (5970,2,17,149,22,'0.60',0),
 (5971,2,20,149,177,'4.83',0),
 (5972,2,21,149,14,'0.38',0),
 (5973,2,22,149,6,'0.16',0),
 (5974,2,23,149,28,'0.76',0),
 (5975,2,24,149,0,'0.00',0),
 (5976,2,25,149,1,'0.03',0),
 (5977,2,1,150,1383,'61.93',0),
 (5978,2,2,150,524,'23.47',0),
 (5979,2,4,150,5,'0.22',0),
 (5980,2,6,150,0,'0.00',0),
 (5981,2,7,150,0,'0.00',0),
 (5982,2,8,150,1,'0.04',0),
 (5983,2,9,150,63,'2.82',0),
 (5984,2,13,150,0,'0.00',0),
 (5985,2,14,150,1,'0.04',0),
 (5986,2,15,150,6,'0.27',0),
 (5987,2,16,150,5,'0.22',0),
 (5988,2,17,150,13,'0.58',0),
 (5989,2,20,150,169,'7.57',0),
 (5990,2,21,150,6,'0.27',0),
 (5991,2,22,150,3,'0.13',0),
 (5992,2,23,150,14,'0.63',0),
 (5993,2,24,150,2,'0.09',0),
 (5994,2,25,150,1,'0.04',0),
 (5995,2,1,151,974,'47.75',0),
 (5996,2,2,151,767,'37.60',0),
 (5997,2,4,151,0,'0.00',0),
 (5998,2,6,151,0,'0.00',0),
 (5999,2,7,151,1,'0.05',0),
 (6000,2,8,151,0,'0.00',0),
 (6001,2,9,151,73,'3.58',0),
 (6002,2,13,151,6,'0.29',0),
 (6003,2,14,151,5,'0.25',0),
 (6004,2,15,151,0,'0.00',0),
 (6005,2,16,151,8,'0.39',0),
 (6006,2,17,151,7,'0.34',0),
 (6007,2,20,151,140,'6.86',0),
 (6008,2,21,151,9,'0.44',0),
 (6009,2,22,151,2,'0.10',0),
 (6010,2,23,151,8,'0.39',0),
 (6011,2,24,151,1,'0.05',0),
 (6012,2,25,151,6,'0.29',0),
 (6013,2,1,152,6653,'62.44',0),
 (6014,2,2,152,1760,'16.52',0),
 (6015,2,4,152,22,'0.21',0),
 (6016,2,6,152,0,'0.00',0),
 (6017,2,7,152,11,'0.10',0),
 (6018,2,8,152,37,'0.35',0),
 (6019,2,9,152,770,'7.23',0),
 (6020,2,13,152,6,'0.06',0),
 (6021,2,14,152,11,'0.10',0),
 (6022,2,15,152,18,'0.17',0),
 (6023,2,16,152,28,'0.26',0),
 (6024,2,17,152,85,'0.80',0),
 (6025,2,20,152,674,'6.33',0),
 (6026,2,21,152,92,'0.86',0),
 (6027,2,22,152,46,'0.43',0),
 (6028,2,23,152,137,'1.29',0),
 (6029,2,24,152,1,'0.01',0),
 (6030,2,25,152,11,'0.10',0),
 (6031,2,1,153,186,'40.97',0),
 (6032,2,2,153,149,'32.82',0),
 (6033,2,4,153,1,'0.22',0),
 (6034,2,6,153,0,'0.00',0),
 (6035,2,7,153,0,'0.00',0),
 (6036,2,8,153,0,'0.00',0),
 (6037,2,9,153,17,'3.74',0),
 (6038,2,13,153,16,'3.52',0),
 (6039,2,14,153,1,'0.22',0),
 (6040,2,15,153,0,'0.00',0),
 (6041,2,16,153,1,'0.22',0),
 (6042,2,17,153,3,'0.66',0),
 (6043,2,20,153,51,'11.23',0),
 (6044,2,21,153,4,'0.88',0),
 (6045,2,22,153,1,'0.22',0),
 (6046,2,23,153,12,'2.64',0),
 (6047,2,24,153,1,'0.22',0),
 (6048,2,25,153,0,'0.00',0),
 (6049,2,1,154,1782,'51.13',0),
 (6050,2,2,154,1163,'33.37',0),
 (6051,2,4,154,0,'0.00',0),
 (6052,2,6,154,0,'0.00',0),
 (6053,2,7,154,1,'0.03',0),
 (6054,2,8,154,0,'0.00',0),
 (6055,2,9,154,148,'4.25',0),
 (6056,2,13,154,0,'0.00',0),
 (6057,2,14,154,2,'0.06',0),
 (6058,2,15,154,8,'0.23',0),
 (6059,2,16,154,13,'0.37',0),
 (6060,2,17,154,23,'0.66',0),
 (6061,2,20,154,216,'6.20',0),
 (6062,2,21,154,3,'0.09',0),
 (6063,2,22,154,8,'0.23',0),
 (6064,2,23,154,23,'0.66',0),
 (6065,2,24,154,0,'0.00',0),
 (6066,2,25,154,1,'0.03',0),
 (6067,2,1,155,237,'51.08',0),
 (6068,2,2,155,172,'37.07',0),
 (6069,2,4,155,0,'0.00',0),
 (6070,2,6,155,0,'0.00',0),
 (6071,2,7,155,0,'0.00',0),
 (6072,2,8,155,0,'0.00',0),
 (6073,2,9,155,5,'1.08',0),
 (6074,2,13,155,0,'0.00',0),
 (6075,2,14,155,0,'0.00',0),
 (6076,2,15,155,0,'0.00',0),
 (6077,2,16,155,0,'0.00',0),
 (6078,2,17,155,1,'0.22',0),
 (6079,2,20,155,46,'9.91',0),
 (6080,2,21,155,1,'0.22',0),
 (6081,2,22,155,0,'0.00',0),
 (6082,2,23,155,0,'0.00',0),
 (6083,2,24,155,1,'0.22',0),
 (6084,2,25,155,0,'0.00',0),
 (6085,2,1,156,375,'55.07',0),
 (6086,2,2,156,209,'30.69',0),
 (6087,2,4,156,0,'0.00',0),
 (6088,2,6,156,0,'0.00',0),
 (6089,2,7,156,0,'0.00',0),
 (6090,2,8,156,0,'0.00',0),
 (6091,2,9,156,23,'3.38',0),
 (6092,2,13,156,1,'0.15',0),
 (6093,2,14,156,2,'0.29',0),
 (6094,2,15,156,7,'1.03',0),
 (6095,2,16,156,2,'0.29',0),
 (6096,2,17,156,3,'0.44',0),
 (6097,2,20,156,39,'5.73',0),
 (6098,2,21,156,0,'0.00',0),
 (6099,2,22,156,0,'0.00',0),
 (6100,2,23,156,3,'0.44',0),
 (6101,2,24,156,0,'0.00',0),
 (6102,2,25,156,0,'0.00',0),
 (6103,2,1,157,295,'61.33',0),
 (6104,2,2,157,143,'29.73',0),
 (6105,2,4,157,0,'0.00',0),
 (6106,2,6,157,0,'0.00',0),
 (6107,2,7,157,0,'0.00',0),
 (6108,2,8,157,0,'0.00',0),
 (6109,2,9,157,7,'1.46',0),
 (6110,2,13,157,0,'0.00',0),
 (6111,2,14,157,1,'0.21',0),
 (6112,2,15,157,2,'0.42',0),
 (6113,2,16,157,0,'0.00',0),
 (6114,2,17,157,0,'0.00',0),
 (6115,2,20,157,14,'2.91',0),
 (6116,2,21,157,0,'0.00',0),
 (6117,2,22,157,0,'0.00',0),
 (6118,2,23,157,8,'1.66',0),
 (6119,2,24,157,0,'0.00',0),
 (6120,2,25,157,0,'0.00',0),
 (6121,2,1,158,342,'66.15',0),
 (6122,2,2,158,91,'17.60',0),
 (6123,2,4,158,0,'0.00',0),
 (6124,2,6,158,0,'0.00',0),
 (6125,2,7,158,0,'0.00',0),
 (6126,2,8,158,0,'0.00',0),
 (6127,2,9,158,29,'5.61',0),
 (6128,2,13,158,1,'0.19',0),
 (6129,2,14,158,2,'0.39',0),
 (6130,2,15,158,2,'0.39',0),
 (6131,2,16,158,3,'0.58',0),
 (6132,2,17,158,2,'0.39',0),
 (6133,2,20,158,26,'5.03',0),
 (6134,2,21,158,2,'0.39',0),
 (6135,2,22,158,2,'0.39',0),
 (6136,2,23,158,7,'1.35',0),
 (6137,2,24,158,0,'0.00',0),
 (6138,2,25,158,0,'0.00',0),
 (6139,2,1,159,343,'62.71',0),
 (6140,2,2,159,161,'29.43',0),
 (6141,2,4,159,0,'0.00',0),
 (6142,2,6,159,0,'0.00',0),
 (6143,2,7,159,2,'0.37',0),
 (6144,2,8,159,0,'0.00',0),
 (6145,2,9,159,3,'0.55',0),
 (6146,2,13,159,0,'0.00',0),
 (6147,2,14,159,0,'0.00',0),
 (6148,2,15,159,0,'0.00',0),
 (6149,2,16,159,0,'0.00',0),
 (6150,2,17,159,3,'0.55',0),
 (6151,2,20,159,21,'3.84',0),
 (6152,2,21,159,0,'0.00',0),
 (6153,2,22,159,0,'0.00',0),
 (6154,2,23,159,1,'0.18',0),
 (6155,2,24,159,0,'0.00',0),
 (6156,2,25,159,0,'0.00',0),
 (6157,2,1,160,2976,'58.68',0),
 (6158,2,2,160,1088,'21.45',0),
 (6159,2,4,160,2,'0.04',0),
 (6160,2,6,160,4,'0.08',0),
 (6161,2,7,160,0,'0.00',0),
 (6162,2,8,160,5,'0.10',0),
 (6163,2,9,160,227,'4.48',0),
 (6164,2,13,160,2,'0.04',0),
 (6165,2,14,160,4,'0.08',0),
 (6166,2,15,160,9,'0.18',0),
 (6167,2,16,160,21,'0.41',0),
 (6168,2,17,160,42,'0.83',0),
 (6169,2,20,160,405,'7.99',0),
 (6170,2,21,160,33,'0.65',0),
 (6171,2,22,160,15,'0.30',0),
 (6172,2,23,160,74,'1.46',0),
 (6173,2,24,160,2,'0.04',0),
 (6174,2,25,160,5,'0.10',0),
 (6175,2,1,161,14828,'53.18',0),
 (6176,2,2,161,6494,'23.29',0),
 (6177,2,4,161,39,'0.14',0),
 (6178,2,6,161,19,'0.07',0),
 (6179,2,7,161,14,'0.05',0),
 (6180,2,8,161,44,'0.16',0),
 (6181,2,9,161,1855,'6.65',0),
 (6182,2,13,161,10,'0.04',0),
 (6183,2,14,161,33,'0.12',0),
 (6184,2,15,161,82,'0.29',0),
 (6185,2,16,161,94,'0.34',0),
 (6186,2,17,161,207,'0.74',0),
 (6187,2,20,161,2384,'8.55',0),
 (6188,2,21,161,125,'0.45',0),
 (6189,2,22,161,66,'0.24',0),
 (6190,2,23,161,547,'1.96',0),
 (6191,2,24,161,23,'0.08',0),
 (6192,2,25,161,290,'1.04',0),
 (6193,2,1,162,986,'61.70',0),
 (6194,2,2,162,322,'20.15',0),
 (6195,2,4,162,1,'0.06',0),
 (6196,2,6,162,0,'0.00',0),
 (6197,2,7,162,2,'0.13',0),
 (6198,2,8,162,0,'0.00',0),
 (6199,2,9,162,62,'3.88',0),
 (6200,2,13,162,1,'0.06',0),
 (6201,2,14,162,0,'0.00',0),
 (6202,2,15,162,0,'0.00',0),
 (6203,2,16,162,3,'0.19',0),
 (6204,2,17,162,14,'0.88',0),
 (6205,2,20,162,115,'7.20',0),
 (6206,2,21,162,16,'1.00',0),
 (6207,2,22,162,0,'0.00',0),
 (6208,2,23,162,18,'1.13',0),
 (6209,2,24,162,2,'0.13',0),
 (6210,2,25,162,0,'0.00',0),
 (6211,2,1,163,126,'47.01',0),
 (6212,2,2,163,73,'27.24',0),
 (6213,2,4,163,0,'0.00',0),
 (6214,2,6,163,0,'0.00',0),
 (6215,2,7,163,0,'0.00',0),
 (6216,2,8,163,0,'0.00',0),
 (6217,2,9,163,6,'2.24',0),
 (6218,2,13,163,0,'0.00',0),
 (6219,2,14,163,1,'0.37',0),
 (6220,2,15,163,1,'0.37',0),
 (6221,2,16,163,1,'0.37',0),
 (6222,2,17,163,5,'1.87',0),
 (6223,2,20,163,35,'13.06',0),
 (6224,2,21,163,0,'0.00',0),
 (6225,2,22,163,0,'0.00',0),
 (6226,2,23,163,3,'1.12',0),
 (6227,2,24,163,0,'0.00',0),
 (6228,2,25,163,1,'0.37',0),
 (6229,2,1,164,1182,'57.27',0),
 (6230,2,2,164,537,'26.02',0),
 (6231,2,4,164,0,'0.00',0),
 (6232,2,6,164,3,'0.15',0),
 (6233,2,7,164,2,'0.10',0),
 (6234,2,8,164,5,'0.24',0),
 (6235,2,9,164,54,'2.62',0),
 (6236,2,13,164,2,'0.10',0),
 (6237,2,14,164,2,'0.10',0),
 (6238,2,15,164,2,'0.10',0),
 (6239,2,16,164,9,'0.44',0),
 (6240,2,17,164,19,'0.92',0),
 (6241,2,20,164,129,'6.25',0),
 (6242,2,21,164,10,'0.48',0),
 (6243,2,22,164,6,'0.29',0),
 (6244,2,23,164,26,'1.26',0),
 (6245,2,24,164,2,'0.10',0),
 (6246,2,25,164,13,'0.63',0),
 (6247,2,1,165,884,'65.34',0),
 (6248,2,2,165,370,'27.35',0),
 (6249,2,4,165,0,'0.00',0),
 (6250,2,6,165,0,'0.00',0),
 (6251,2,7,165,0,'0.00',0),
 (6252,2,8,165,0,'0.00',0),
 (6253,2,9,165,24,'1.77',0),
 (6254,2,13,165,0,'0.00',0),
 (6255,2,14,165,0,'0.00',0),
 (6256,2,15,165,0,'0.00',0),
 (6257,2,16,165,1,'0.07',0),
 (6258,2,17,165,4,'0.30',0),
 (6259,2,20,165,36,'2.66',0),
 (6260,2,21,165,2,'0.15',0),
 (6261,2,22,165,0,'0.00',0),
 (6262,2,23,165,4,'0.30',0),
 (6263,2,24,165,0,'0.00',0),
 (6264,2,25,165,0,'0.00',0),
 (6265,2,1,166,142,'53.79',0),
 (6266,2,2,166,99,'37.50',0),
 (6267,2,4,166,1,'0.38',0),
 (6268,2,6,166,0,'0.00',0),
 (6269,2,7,166,0,'0.00',0),
 (6270,2,8,166,0,'0.00',0),
 (6271,2,9,166,5,'1.89',0),
 (6272,2,13,166,0,'0.00',0),
 (6273,2,14,166,0,'0.00',0),
 (6274,2,15,166,1,'0.38',0),
 (6275,2,16,166,4,'1.52',0),
 (6276,2,17,166,0,'0.00',0),
 (6277,2,20,166,9,'3.41',0),
 (6278,2,21,166,0,'0.00',0),
 (6279,2,22,166,0,'0.00',0),
 (6280,2,23,166,0,'0.00',0),
 (6281,2,24,166,0,'0.00',0),
 (6282,2,25,166,0,'0.00',0),
 (6283,2,1,167,2402,'46.71',0),
 (6284,2,2,167,1383,'26.90',0),
 (6285,2,4,167,1,'0.02',0),
 (6286,2,6,167,0,'0.00',0),
 (6287,2,7,167,1,'0.02',0),
 (6288,2,8,167,4,'0.08',0),
 (6289,2,9,167,495,'9.63',0),
 (6290,2,13,167,3,'0.06',0),
 (6291,2,14,167,9,'0.18',0),
 (6292,2,15,167,21,'0.41',0),
 (6293,2,16,167,11,'0.21',0),
 (6294,2,17,167,37,'0.72',0),
 (6295,2,20,167,493,'9.59',0),
 (6296,2,21,167,28,'0.54',0),
 (6297,2,22,167,13,'0.25',0),
 (6298,2,23,167,61,'1.19',0),
 (6299,2,24,167,2,'0.04',0),
 (6300,2,25,167,4,'0.08',0),
 (6301,2,1,168,417,'53.12',0),
 (6302,2,2,168,243,'30.96',0),
 (6303,2,4,168,2,'0.25',0),
 (6304,2,6,168,0,'0.00',0),
 (6305,2,7,168,0,'0.00',0),
 (6306,2,8,168,1,'0.13',0),
 (6307,2,9,168,46,'5.86',0),
 (6308,2,13,168,0,'0.00',0),
 (6309,2,14,168,0,'0.00',0),
 (6310,2,15,168,3,'0.38',0),
 (6311,2,16,168,6,'0.76',0),
 (6312,2,17,168,3,'0.38',0),
 (6313,2,20,168,32,'4.08',0),
 (6314,2,21,168,2,'0.25',0),
 (6315,2,22,168,1,'0.13',0),
 (6316,2,23,168,8,'1.02',0),
 (6317,2,24,168,1,'0.13',0),
 (6318,2,25,168,0,'0.00',0),
 (6319,2,1,169,606,'61.34',0),
 (6320,2,2,169,200,'20.24',0),
 (6321,2,4,169,2,'0.20',0),
 (6322,2,6,169,0,'0.00',0),
 (6323,2,7,169,0,'0.00',0),
 (6324,2,8,169,3,'0.30',0),
 (6325,2,9,169,52,'5.26',0),
 (6326,2,13,169,3,'0.30',0),
 (6327,2,14,169,1,'0.10',0),
 (6328,2,15,169,1,'0.10',0),
 (6329,2,16,169,1,'0.10',0),
 (6330,2,17,169,5,'0.51',0),
 (6331,2,20,169,59,'5.97',0),
 (6332,2,21,169,3,'0.30',0),
 (6333,2,22,169,2,'0.20',0),
 (6334,2,23,169,27,'2.73',0),
 (6335,2,24,169,0,'0.00',0),
 (6336,2,25,169,0,'0.00',0),
 (6337,2,1,170,954,'52.48',0),
 (6338,2,2,170,536,'29.48',0),
 (6339,2,4,170,1,'0.06',0),
 (6340,2,6,170,0,'0.00',0),
 (6341,2,7,170,0,'0.00',0),
 (6342,2,8,170,1,'0.06',0),
 (6343,2,9,170,13,'0.72',0),
 (6344,2,13,170,0,'0.00',0),
 (6345,2,14,170,4,'0.22',0),
 (6346,2,15,170,4,'0.22',0),
 (6347,2,16,170,6,'0.33',0),
 (6348,2,17,170,9,'0.50',0),
 (6349,2,20,170,243,'13.37',0),
 (6350,2,21,170,1,'0.06',0),
 (6351,2,22,170,1,'0.06',0),
 (6352,2,23,170,8,'0.44',0),
 (6353,2,24,170,1,'0.06',0),
 (6354,2,25,170,0,'0.00',0),
 (6355,2,1,171,1928,'63.82',0),
 (6356,2,2,171,871,'28.83',0),
 (6357,2,4,171,1,'0.03',0),
 (6358,2,6,171,0,'0.00',0),
 (6359,2,7,171,1,'0.03',0),
 (6360,2,8,171,0,'0.00',0),
 (6361,2,9,171,58,'1.92',0),
 (6362,2,13,171,0,'0.00',0),
 (6363,2,14,171,2,'0.07',0),
 (6364,2,15,171,2,'0.07',0),
 (6365,2,16,171,4,'0.13',0),
 (6366,2,17,171,12,'0.40',0),
 (6367,2,20,171,66,'2.18',0),
 (6368,2,21,171,7,'0.23',0),
 (6369,2,22,171,3,'0.10',0),
 (6370,2,23,171,24,'0.79',0),
 (6371,2,24,171,0,'0.00',0),
 (6372,2,25,171,1,'0.03',0),
 (6373,2,1,172,3160,'58.89',0),
 (6374,2,2,172,1116,'20.80',0),
 (6375,2,4,172,12,'0.22',0),
 (6376,2,6,172,0,'0.00',0),
 (6377,2,7,172,0,'0.00',0),
 (6378,2,8,172,7,'0.13',0),
 (6379,2,9,172,288,'5.37',0),
 (6380,2,13,172,2,'0.04',0),
 (6381,2,14,172,6,'0.11',0),
 (6382,2,15,172,11,'0.20',0),
 (6383,2,16,172,19,'0.35',0),
 (6384,2,17,172,46,'0.86',0),
 (6385,2,20,172,370,'6.90',0),
 (6386,2,21,172,34,'0.63',0),
 (6387,2,22,172,13,'0.24',0),
 (6388,2,23,172,77,'1.43',0),
 (6389,2,24,172,4,'0.07',0),
 (6390,2,25,172,44,'0.82',0),
 (6391,2,1,173,248,'58.08',0),
 (6392,2,2,173,142,'33.26',0),
 (6393,2,4,173,0,'0.00',0),
 (6394,2,6,173,0,'0.00',0),
 (6395,2,7,173,0,'0.00',0),
 (6396,2,8,173,0,'0.00',0),
 (6397,2,9,173,3,'0.70',0),
 (6398,2,13,173,0,'0.00',0),
 (6399,2,14,173,1,'0.23',0),
 (6400,2,15,173,0,'0.00',0),
 (6401,2,16,173,5,'1.17',0),
 (6402,2,17,173,1,'0.23',0),
 (6403,2,20,173,12,'2.81',0),
 (6404,2,21,173,1,'0.23',0),
 (6405,2,22,173,1,'0.23',0),
 (6406,2,23,173,2,'0.47',0),
 (6407,2,24,173,0,'0.00',0),
 (6408,2,25,173,0,'0.00',0),
 (6409,2,1,174,705,'56.09',0),
 (6410,2,2,174,452,'35.96',0),
 (6411,2,4,174,1,'0.08',0),
 (6412,2,6,174,0,'0.00',0),
 (6413,2,7,174,1,'0.08',0),
 (6414,2,8,174,0,'0.00',0),
 (6415,2,9,174,23,'1.83',0),
 (6416,2,13,174,0,'0.00',0),
 (6417,2,14,174,2,'0.16',0),
 (6418,2,15,174,3,'0.24',0),
 (6419,2,16,174,1,'0.08',0),
 (6420,2,17,174,2,'0.16',0),
 (6421,2,20,174,32,'2.55',0),
 (6422,2,21,174,5,'0.40',0),
 (6423,2,22,174,2,'0.16',0),
 (6424,2,23,174,7,'0.56',0),
 (6425,2,24,174,0,'0.00',0),
 (6426,2,25,174,0,'0.00',0),
 (6427,2,1,175,375,'62.19',0),
 (6428,2,2,175,128,'21.23',0),
 (6429,2,4,175,3,'0.50',0),
 (6430,2,6,175,1,'0.17',0),
 (6431,2,7,175,0,'0.00',0),
 (6432,2,8,175,1,'0.17',0),
 (6433,2,9,175,24,'3.98',0),
 (6434,2,13,175,0,'0.00',0),
 (6435,2,14,175,1,'0.17',0),
 (6436,2,15,175,0,'0.00',0),
 (6437,2,16,175,1,'0.17',0),
 (6438,2,17,175,7,'1.16',0),
 (6439,2,20,175,34,'5.64',0),
 (6440,2,21,175,2,'0.33',0),
 (6441,2,22,175,4,'0.66',0),
 (6442,2,23,175,1,'0.17',0),
 (6443,2,24,175,0,'0.00',0),
 (6444,2,25,175,2,'0.33',0),
 (6445,2,1,176,5301,'69.14',0),
 (6446,2,2,176,913,'11.91',0),
 (6447,2,4,176,16,'0.21',0),
 (6448,2,6,176,1,'0.01',0),
 (6449,2,7,176,5,'0.07',0),
 (6450,2,8,176,13,'0.17',0),
 (6451,2,9,176,655,'8.54',0),
 (6452,2,13,176,2,'0.03',0),
 (6453,2,14,176,9,'0.12',0),
 (6454,2,15,176,12,'0.16',0),
 (6455,2,16,176,21,'0.27',0),
 (6456,2,17,176,36,'0.47',0),
 (6457,2,20,176,339,'4.42',0),
 (6458,2,21,176,55,'0.72',0),
 (6459,2,22,176,23,'0.30',0),
 (6460,2,23,176,78,'1.02',0),
 (6461,2,24,176,2,'0.03',0),
 (6462,2,25,176,6,'0.08',0),
 (6463,2,1,177,4096,'59.31',0),
 (6464,2,2,177,1486,'21.52',0),
 (6465,2,4,177,6,'0.09',0),
 (6466,2,6,177,0,'0.00',0),
 (6467,2,7,177,2,'0.03',0),
 (6468,2,8,177,100,'1.45',0),
 (6469,2,9,177,491,'7.11',0),
 (6470,2,13,177,0,'0.00',0),
 (6471,2,14,177,6,'0.09',0),
 (6472,2,15,177,6,'0.09',0),
 (6473,2,16,177,16,'0.23',0),
 (6474,2,17,177,49,'0.71',0),
 (6475,2,20,177,358,'5.18',0),
 (6476,2,21,177,29,'0.42',0),
 (6477,2,22,177,29,'0.42',0),
 (6478,2,23,177,67,'0.97',0),
 (6479,2,24,177,3,'0.04',0),
 (6480,2,25,177,12,'0.17',0),
 (6481,2,1,178,471,'57.16',0),
 (6482,2,2,178,261,'31.67',0),
 (6483,2,4,178,0,'0.00',0),
 (6484,2,6,178,0,'0.00',0),
 (6485,2,7,178,0,'0.00',0),
 (6486,2,8,178,0,'0.00',0),
 (6487,2,9,178,28,'3.40',0),
 (6488,2,13,178,0,'0.00',0),
 (6489,2,14,178,6,'0.73',0),
 (6490,2,15,178,1,'0.12',0),
 (6491,2,16,178,0,'0.00',0),
 (6492,2,17,178,2,'0.24',0),
 (6493,2,20,178,29,'3.52',0),
 (6494,2,21,178,4,'0.49',0),
 (6495,2,22,178,0,'0.00',0),
 (6496,2,23,178,5,'0.61',0),
 (6497,2,24,178,1,'0.12',0),
 (6498,2,25,178,1,'0.12',0),
 (6499,2,1,179,562,'62.93',0),
 (6500,2,2,179,181,'20.27',0),
 (6501,2,4,179,1,'0.11',0),
 (6502,2,6,179,0,'0.00',0),
 (6503,2,7,179,1,'0.11',0),
 (6504,2,8,179,0,'0.00',0),
 (6505,2,9,179,35,'3.92',0),
 (6506,2,13,179,1,'0.11',0),
 (6507,2,14,179,0,'0.00',0),
 (6508,2,15,179,1,'0.11',0),
 (6509,2,16,179,0,'0.00',0),
 (6510,2,17,179,7,'0.78',0),
 (6511,2,20,179,84,'9.41',0),
 (6512,2,21,179,2,'0.22',0),
 (6513,2,22,179,1,'0.11',0),
 (6514,2,23,179,5,'0.56',0),
 (6515,2,24,179,1,'0.11',0),
 (6516,2,25,179,1,'0.11',0),
 (6517,2,1,180,2041,'52.24',0),
 (6518,2,2,180,1512,'38.70',0),
 (6519,2,4,180,2,'0.05',0),
 (6520,2,6,180,5,'0.13',0),
 (6521,2,7,180,1,'0.03',0),
 (6522,2,8,180,2,'0.05',0),
 (6523,2,9,180,69,'1.77',0),
 (6524,2,13,180,1,'0.03',0),
 (6525,2,14,180,8,'0.20',0),
 (6526,2,15,180,4,'0.10',0),
 (6527,2,16,180,2,'0.05',0),
 (6528,2,17,180,9,'0.23',0),
 (6529,2,20,180,145,'3.71',0),
 (6530,2,21,180,8,'0.20',0),
 (6531,2,22,180,2,'0.05',0),
 (6532,2,23,180,17,'0.44',0),
 (6533,2,24,180,0,'0.00',0),
 (6534,2,25,180,2,'0.05',0),
 (6535,2,1,181,8944,'63.68',0),
 (6536,2,2,181,2394,'17.05',0),
 (6537,2,4,181,15,'0.11',0),
 (6538,2,6,181,1,'0.01',0),
 (6539,2,7,181,12,'0.09',0),
 (6540,2,8,181,12,'0.09',0),
 (6541,2,9,181,1072,'7.63',0),
 (6542,2,13,181,4,'0.03',0),
 (6543,2,14,181,13,'0.09',0),
 (6544,2,15,181,10,'0.07',0),
 (6545,2,16,181,20,'0.14',0),
 (6546,2,17,181,72,'0.51',0),
 (6547,2,20,181,938,'6.68',0),
 (6548,2,21,181,81,'0.58',0),
 (6549,2,22,181,37,'0.26',0),
 (6550,2,23,181,125,'0.89',0),
 (6551,2,24,181,6,'0.04',0),
 (6552,2,25,181,8,'0.06',0),
 (6553,2,1,182,99,'50.25',0),
 (6554,2,2,182,62,'31.47',0),
 (6555,2,4,182,0,'0.00',0),
 (6556,2,6,182,1,'0.51',0),
 (6557,2,7,182,1,'0.51',0),
 (6558,2,8,182,0,'0.00',0),
 (6559,2,9,182,2,'1.02',0),
 (6560,2,13,182,0,'0.00',0),
 (6561,2,14,182,0,'0.00',0),
 (6562,2,15,182,0,'0.00',0),
 (6563,2,16,182,1,'0.51',0),
 (6564,2,17,182,1,'0.51',0),
 (6565,2,20,182,18,'9.14',0),
 (6566,2,21,182,3,'1.52',0),
 (6567,2,22,182,1,'0.51',0),
 (6568,2,23,182,4,'2.03',0),
 (6569,2,24,182,0,'0.00',0),
 (6570,2,25,182,0,'0.00',0),
 (6571,2,1,183,306,'48.96',0),
 (6572,2,2,183,196,'31.36',0),
 (6573,2,4,183,1,'0.16',0),
 (6574,2,6,183,0,'0.00',0),
 (6575,2,7,183,0,'0.00',0),
 (6576,2,8,183,0,'0.00',0),
 (6577,2,9,183,11,'1.76',0),
 (6578,2,13,183,0,'0.00',0),
 (6579,2,14,183,1,'0.16',0),
 (6580,2,15,183,1,'0.16',0),
 (6581,2,16,183,2,'0.32',0),
 (6582,2,17,183,9,'1.44',0),
 (6583,2,20,183,70,'11.20',0),
 (6584,2,21,183,2,'0.32',0),
 (6585,2,22,183,4,'0.64',0),
 (6586,2,23,183,6,'0.96',0),
 (6587,2,24,183,0,'0.00',0),
 (6588,2,25,183,1,'0.16',0),
 (6589,2,1,901,305,'51.26',0),
 (6590,2,2,901,197,'33.11',0),
 (6591,2,4,901,0,'0.00',0),
 (6592,2,6,901,0,'0.00',0),
 (6593,2,7,901,1,'0.17',0),
 (6594,2,8,901,0,'0.00',0),
 (6595,2,9,901,16,'2.69',0),
 (6596,2,13,901,0,'0.00',0),
 (6597,2,14,901,0,'0.00',0),
 (6598,2,15,901,3,'0.50',0),
 (6599,2,16,901,5,'0.84',0),
 (6600,2,17,901,4,'0.67',0),
 (6601,2,20,901,36,'6.05',0),
 (6602,2,21,901,4,'0.67',0),
 (6603,2,22,901,4,'0.67',0),
 (6604,2,23,901,6,'1.01',0),
 (6605,2,24,901,0,'0.00',0),
 (6606,2,25,901,1,'0.17',0),
 (6607,2,1,902,206,'60.59',0),
 (6608,2,2,902,49,'14.41',0),
 (6609,2,4,902,6,'1.76',0),
 (6610,2,6,902,0,'0.00',0),
 (6611,2,7,902,0,'0.00',0),
 (6612,2,8,902,1,'0.29',0),
 (6613,2,9,902,12,'3.53',0),
 (6614,2,13,902,1,'0.29',0),
 (6615,2,14,902,0,'0.00',0),
 (6616,2,15,902,0,'0.00',0),
 (6617,2,16,902,0,'0.00',0),
 (6618,2,17,902,1,'0.29',0),
 (6619,2,20,902,48,'14.12',0),
 (6620,2,21,902,2,'0.59',0),
 (6621,2,22,902,1,'0.29',0),
 (6622,2,23,902,4,'1.18',0),
 (6623,2,24,902,0,'0.00',0),
 (6624,2,25,902,0,'0.00',0),
 (6625,2,1,903,10521,'49.22',0),
 (6626,2,2,903,4984,'23.32',0),
 (6627,2,4,903,33,'0.15',0),
 (6628,2,6,903,5,'0.02',0),
 (6629,2,7,903,12,'0.06',0),
 (6630,2,8,903,27,'0.13',0),
 (6631,2,9,903,2006,'9.38',0),
 (6632,2,13,903,7,'0.03',0),
 (6633,2,14,903,33,'0.15',0),
 (6634,2,15,903,27,'0.13',0),
 (6635,2,16,903,34,'0.16',0),
 (6636,2,17,903,141,'0.66',0),
 (6637,2,20,903,2323,'10.87',0),
 (6638,2,21,903,192,'0.90',0),
 (6639,2,22,903,88,'0.41',0),
 (6640,2,23,903,269,'1.26',0),
 (6641,2,24,903,4,'0.02',0),
 (6642,2,25,903,5,'0.02',0),
 (6643,2,1,999,3222,'47.00',0),
 (6644,2,2,999,2339,'34.12',0),
 (6645,2,4,999,15,'0.22',0),
 (6646,2,6,999,3,'0.04',0),
 (6647,2,7,999,16,'0.23',0),
 (6648,2,8,999,14,'0.20',0),
 (6649,2,9,999,257,'3.75',0),
 (6650,2,13,999,4,'0.06',0),
 (6651,2,14,999,14,'0.20',0),
 (6652,2,15,999,30,'0.44',0),
 (6653,2,16,999,14,'0.20',0),
 (6654,2,17,999,75,'1.09',0),
 (6655,2,20,999,633,'9.23',0),
 (6656,2,21,999,15,'0.22',0),
 (6657,2,22,999,23,'0.34',0),
 (6658,2,23,999,107,'1.56',0),
 (6659,2,24,999,9,'0.13',0),
 (6660,2,25,999,18,'0.26',0),
 (6661,3,1,1,41,'91.11',0),
 (6662,3,2,1,2,'4.44',0),
 (6663,3,4,1,0,'0.00',0),
 (6664,3,12,1,1,'2.22',0),
 (6665,3,14,1,0,'0.00',0),
 (6666,3,15,1,0,'0.00',0),
 (6667,3,16,1,0,'0.00',0),
 (6668,3,17,1,0,'0.00',0),
 (6669,3,26,1,0,'0.00',0),
 (6670,3,27,1,1,'2.22',0),
 (6671,3,28,1,0,'0.00',0),
 (6672,3,29,1,0,'0.00',0),
 (6673,3,30,1,0,'0.00',0),
 (6674,3,31,1,0,'0.00',0),
 (6675,3,32,1,0,'0.00',0),
 (6676,3,33,1,0,'0.00',0),
 (6677,3,34,1,0,'0.00',0),
 (6678,3,35,1,0,'0.00',0),
 (6679,3,36,1,0,'0.00',0),
 (6680,3,37,1,0,'0.00',0),
 (6681,3,1,2,967,'57.87',0);
INSERT INTO `elecmunicandi` (`idElecMuniCandi`,`Convocatoria_idConvocatoria`,`Candidatura_idCandidatura`,`Municipio`,`Votos`,`PorcVotos`,`Concejales`) VALUES 
 (6682,3,2,2,546,'32.68',0),
 (6683,3,4,2,10,'0.60',0),
 (6684,3,12,2,98,'5.86',0),
 (6685,3,14,2,0,'0.00',0),
 (6686,3,15,2,0,'0.00',0),
 (6687,3,16,2,2,'0.12',0),
 (6688,3,17,2,4,'0.24',0),
 (6689,3,26,2,1,'0.06',0),
 (6690,3,27,2,2,'0.12',0),
 (6691,3,28,2,1,'0.06',0),
 (6692,3,29,2,0,'0.00',0),
 (6693,3,30,2,1,'0.06',0),
 (6694,3,31,2,20,'1.20',0),
 (6695,3,32,2,1,'0.06',0),
 (6696,3,33,2,0,'0.00',0),
 (6697,3,34,2,0,'0.00',0),
 (6698,3,35,2,0,'0.00',0),
 (6699,3,36,2,2,'0.12',0),
 (6700,3,37,2,0,'0.00',0),
 (6701,3,1,3,87,'53.05',0),
 (6702,3,2,3,52,'31.71',0),
 (6703,3,4,3,0,'0.00',0),
 (6704,3,12,3,16,'9.76',0),
 (6705,3,14,3,0,'0.00',0),
 (6706,3,15,3,0,'0.00',0),
 (6707,3,16,3,0,'0.00',0),
 (6708,3,17,3,3,'1.83',0),
 (6709,3,26,3,0,'0.00',0),
 (6710,3,27,3,1,'0.61',0),
 (6711,3,28,3,0,'0.00',0),
 (6712,3,29,3,0,'0.00',0),
 (6713,3,30,3,0,'0.00',0),
 (6714,3,31,3,0,'0.00',0),
 (6715,3,32,3,0,'0.00',0),
 (6716,3,33,3,2,'1.22',0),
 (6717,3,34,3,0,'0.00',0),
 (6718,3,35,3,0,'0.00',0),
 (6719,3,36,3,0,'0.00',0),
 (6720,3,37,3,0,'0.00',0),
 (6721,3,1,4,2174,'58.98',0),
 (6722,3,2,4,1202,'32.61',0),
 (6723,3,4,4,5,'0.14',0),
 (6724,3,12,4,189,'5.13',0),
 (6725,3,14,4,2,'0.05',0),
 (6726,3,15,4,3,'0.08',0),
 (6727,3,16,4,3,'0.08',0),
 (6728,3,17,4,10,'0.27',0),
 (6729,3,26,4,0,'0.00',0),
 (6730,3,27,4,1,'0.03',0),
 (6731,3,28,4,3,'0.08',0),
 (6732,3,29,4,0,'0.00',0),
 (6733,3,30,4,0,'0.00',0),
 (6734,3,31,4,32,'0.87',0),
 (6735,3,32,4,0,'0.00',0),
 (6736,3,33,4,5,'0.14',0),
 (6737,3,34,4,2,'0.05',0),
 (6738,3,35,4,0,'0.00',0),
 (6739,3,36,4,4,'0.11',0),
 (6740,3,37,4,0,'0.00',0),
 (6741,3,1,5,42600,'49.40',0),
 (6742,3,2,5,32312,'37.47',0),
 (6743,3,4,5,80,'0.09',0),
 (6744,3,12,5,6849,'7.94',0),
 (6745,3,14,5,63,'0.07',0),
 (6746,3,15,5,203,'0.24',0),
 (6747,3,16,5,98,'0.11',0),
 (6748,3,17,5,192,'0.22',0),
 (6749,3,26,5,26,'0.03',0),
 (6750,3,27,5,85,'0.10',0),
 (6751,3,28,5,195,'0.23',0),
 (6752,3,29,5,0,'0.00',0),
 (6753,3,30,5,8,'0.01',0),
 (6754,3,31,5,1279,'1.48',0),
 (6755,3,32,5,66,'0.08',0),
 (6756,3,33,5,100,'0.12',0),
 (6757,3,34,5,74,'0.09',0),
 (6758,3,35,5,12,'0.01',0),
 (6759,3,36,5,438,'0.51',0),
 (6760,3,37,5,40,'0.05',0),
 (6761,3,1,6,27595,'55.51',0),
 (6762,3,2,6,16009,'32.21',0),
 (6763,3,4,6,71,'0.14',0),
 (6764,3,12,6,3967,'7.98',0),
 (6765,3,14,6,50,'0.10',0),
 (6766,3,15,6,65,'0.13',0),
 (6767,3,16,6,59,'0.12',0),
 (6768,3,17,6,88,'0.18',0),
 (6769,3,26,6,13,'0.03',0),
 (6770,3,27,6,13,'0.03',0),
 (6771,3,28,6,38,'0.08',0),
 (6772,3,29,6,0,'0.00',0),
 (6773,3,30,6,4,'0.01',0),
 (6774,3,31,6,663,'1.33',0),
 (6775,3,32,6,38,'0.08',0),
 (6776,3,33,6,87,'0.18',0),
 (6777,3,34,6,38,'0.08',0),
 (6778,3,35,6,5,'0.01',0),
 (6779,3,36,6,46,'0.09',0),
 (6780,3,37,6,47,'0.09',0),
 (6781,3,1,7,40815,'48.31',0),
 (6782,3,2,7,33376,'39.50',0),
 (6783,3,4,7,125,'0.15',0),
 (6784,3,12,7,6246,'7.39',0),
 (6785,3,14,7,34,'0.04',0),
 (6786,3,15,7,156,'0.18',0),
 (6787,3,16,7,71,'0.08',0),
 (6788,3,17,7,186,'0.22',0),
 (6789,3,26,7,29,'0.03',0),
 (6790,3,27,7,17,'0.02',0),
 (6791,3,28,7,77,'0.09',0),
 (6792,3,29,7,0,'0.00',0),
 (6793,3,30,7,12,'0.01',0),
 (6794,3,31,7,1376,'1.63',0),
 (6795,3,32,7,47,'0.06',0),
 (6796,3,33,7,86,'0.10',0),
 (6797,3,34,7,84,'0.10',0),
 (6798,3,35,7,13,'0.02',0),
 (6799,3,36,7,68,'0.08',0),
 (6800,3,37,7,102,'0.12',0),
 (6801,3,1,8,702,'57.21',0),
 (6802,3,2,8,358,'29.18',0),
 (6803,3,4,8,0,'0.00',0),
 (6804,3,12,8,62,'5.05',0),
 (6805,3,14,8,2,'0.16',0),
 (6806,3,15,8,0,'0.00',0),
 (6807,3,16,8,3,'0.24',0),
 (6808,3,17,8,2,'0.16',0),
 (6809,3,26,8,1,'0.08',0),
 (6810,3,27,8,41,'3.34',0),
 (6811,3,28,8,1,'0.08',0),
 (6812,3,29,8,0,'0.00',0),
 (6813,3,30,8,1,'0.08',0),
 (6814,3,31,8,12,'0.98',0),
 (6815,3,32,8,1,'0.08',0),
 (6816,3,33,8,0,'0.00',0),
 (6817,3,34,8,0,'0.00',0),
 (6818,3,35,8,0,'0.00',0),
 (6819,3,36,8,0,'0.00',0),
 (6820,3,37,8,11,'0.90',0),
 (6821,3,1,9,4798,'56.04',0),
 (6822,3,2,9,2716,'31.72',0),
 (6823,3,4,9,12,'0.14',0),
 (6824,3,12,9,583,'6.81',0),
 (6825,3,14,9,4,'0.05',0),
 (6826,3,15,9,17,'0.20',0),
 (6827,3,16,9,9,'0.11',0),
 (6828,3,17,9,18,'0.21',0),
 (6829,3,26,9,1,'0.01',0),
 (6830,3,27,9,93,'1.09',0),
 (6831,3,28,9,4,'0.05',0),
 (6832,3,29,9,0,'0.00',0),
 (6833,3,30,9,0,'0.00',0),
 (6834,3,31,9,159,'1.86',0),
 (6835,3,32,9,5,'0.06',0),
 (6836,3,33,9,10,'0.12',0),
 (6837,3,34,9,3,'0.04',0),
 (6838,3,35,9,1,'0.01',0),
 (6839,3,36,9,10,'0.12',0),
 (6840,3,37,9,1,'0.01',0),
 (6841,3,1,10,3474,'57.19',0),
 (6842,3,2,10,1735,'28.56',0),
 (6843,3,4,10,11,'0.18',0),
 (6844,3,12,10,606,'9.98',0),
 (6845,3,14,10,2,'0.03',0),
 (6846,3,15,10,8,'0.13',0),
 (6847,3,16,10,6,'0.10',0),
 (6848,3,17,10,5,'0.08',0),
 (6849,3,26,10,2,'0.03',0),
 (6850,3,27,10,3,'0.05',0),
 (6851,3,28,10,3,'0.05',0),
 (6852,3,29,10,0,'0.00',0),
 (6853,3,30,10,4,'0.07',0),
 (6854,3,31,10,98,'1.61',0),
 (6855,3,32,10,4,'0.07',0),
 (6856,3,33,10,9,'0.15',0),
 (6857,3,34,10,6,'0.10',0),
 (6858,3,35,10,1,'0.02',0),
 (6859,3,36,10,3,'0.05',0),
 (6860,3,37,10,5,'0.08',0),
 (6861,3,1,11,178,'60.54',0),
 (6862,3,2,11,60,'20.41',0),
 (6863,3,4,11,2,'0.68',0),
 (6864,3,12,11,43,'14.63',0),
 (6865,3,14,11,0,'0.00',0),
 (6866,3,15,11,2,'0.68',0),
 (6867,3,16,11,2,'0.68',0),
 (6868,3,17,11,1,'0.34',0),
 (6869,3,26,11,0,'0.00',0),
 (6870,3,27,11,0,'0.00',0),
 (6871,3,28,11,0,'0.00',0),
 (6872,3,29,11,0,'0.00',0),
 (6873,3,30,11,0,'0.00',0),
 (6874,3,31,11,0,'0.00',0),
 (6875,3,32,11,0,'0.00',0),
 (6876,3,33,11,2,'0.68',0),
 (6877,3,34,11,0,'0.00',0),
 (6878,3,35,11,0,'0.00',0),
 (6879,3,36,11,0,'0.00',0),
 (6880,3,37,11,1,'0.34',0),
 (6881,3,1,12,345,'58.47',0),
 (6882,3,2,12,203,'34.41',0),
 (6883,3,4,12,0,'0.00',0),
 (6884,3,12,12,21,'3.56',0),
 (6885,3,14,12,0,'0.00',0),
 (6886,3,15,12,0,'0.00',0),
 (6887,3,16,12,1,'0.17',0),
 (6888,3,17,12,1,'0.17',0),
 (6889,3,26,12,0,'0.00',0),
 (6890,3,27,12,0,'0.00',0),
 (6891,3,28,12,0,'0.00',0),
 (6892,3,29,12,0,'0.00',0),
 (6893,3,30,12,0,'0.00',0),
 (6894,3,31,12,3,'0.51',0),
 (6895,3,32,12,0,'0.00',0),
 (6896,3,33,12,0,'0.00',0),
 (6897,3,34,12,1,'0.17',0),
 (6898,3,35,12,0,'0.00',0),
 (6899,3,36,12,2,'0.34',0),
 (6900,3,37,12,1,'0.17',0),
 (6901,3,1,13,11630,'48.95',0),
 (6902,3,2,13,9604,'40.42',0),
 (6903,3,4,13,26,'0.11',0),
 (6904,3,12,13,1575,'6.63',0),
 (6905,3,14,13,10,'0.04',0),
 (6906,3,15,13,81,'0.34',0),
 (6907,3,16,13,23,'0.10',0),
 (6908,3,17,13,39,'0.16',0),
 (6909,3,26,13,3,'0.01',0),
 (6910,3,27,13,6,'0.03',0),
 (6911,3,28,13,14,'0.06',0),
 (6912,3,29,13,0,'0.00',0),
 (6913,3,30,13,2,'0.01',0),
 (6914,3,31,13,226,'0.95',0),
 (6915,3,32,13,9,'0.04',0),
 (6916,3,33,13,19,'0.08',0),
 (6917,3,34,13,9,'0.04',0),
 (6918,3,35,13,1,'0.00',0),
 (6919,3,36,13,58,'0.24',0),
 (6920,3,37,13,6,'0.03',0),
 (6921,3,1,14,10606,'55.55',0),
 (6922,3,2,14,6415,'33.60',0),
 (6923,3,4,14,22,'0.12',0),
 (6924,3,12,14,1518,'7.95',0),
 (6925,3,14,14,5,'0.03',0),
 (6926,3,15,14,6,'0.03',0),
 (6927,3,16,14,16,'0.08',0),
 (6928,3,17,14,29,'0.15',0),
 (6929,3,26,14,2,'0.01',0),
 (6930,3,27,14,7,'0.04',0),
 (6931,3,28,14,18,'0.09',0),
 (6932,3,29,14,0,'0.00',0),
 (6933,3,30,14,2,'0.01',0),
 (6934,3,31,14,158,'0.83',0),
 (6935,3,32,14,3,'0.02',0),
 (6936,3,33,14,10,'0.05',0),
 (6937,3,34,14,5,'0.03',0),
 (6938,3,35,14,4,'0.02',0),
 (6939,3,36,14,12,'0.06',0),
 (6940,3,37,14,2,'0.01',0),
 (6941,3,1,15,3180,'62.15',0),
 (6942,3,2,15,1426,'27.87',0),
 (6943,3,4,15,4,'0.08',0),
 (6944,3,12,15,288,'5.63',0),
 (6945,3,14,15,0,'0.00',0),
 (6946,3,15,15,2,'0.04',0),
 (6947,3,16,15,2,'0.04',0),
 (6948,3,17,15,7,'0.14',0),
 (6949,3,26,15,2,'0.04',0),
 (6950,3,27,15,2,'0.04',0),
 (6951,3,28,15,2,'0.04',0),
 (6952,3,29,15,0,'0.00',0),
 (6953,3,30,15,0,'0.00',0),
 (6954,3,31,15,86,'1.68',0),
 (6955,3,32,15,1,'0.02',0),
 (6956,3,33,15,8,'0.16',0),
 (6957,3,34,15,0,'0.00',0),
 (6958,3,35,15,0,'0.00',0),
 (6959,3,36,15,2,'0.04',0),
 (6960,3,37,15,2,'0.04',0),
 (6961,3,1,16,34,'43.04',0),
 (6962,3,2,16,28,'35.44',0),
 (6963,3,4,16,0,'0.00',0),
 (6964,3,12,16,15,'18.99',0),
 (6965,3,14,16,0,'0.00',0),
 (6966,3,15,16,0,'0.00',0),
 (6967,3,16,16,0,'0.00',0),
 (6968,3,17,16,0,'0.00',0),
 (6969,3,26,16,0,'0.00',0),
 (6970,3,27,16,0,'0.00',0),
 (6971,3,28,16,1,'1.27',0),
 (6972,3,29,16,0,'0.00',0),
 (6973,3,30,16,0,'0.00',0),
 (6974,3,31,16,1,'1.27',0),
 (6975,3,32,16,0,'0.00',0),
 (6976,3,33,16,0,'0.00',0),
 (6977,3,34,16,0,'0.00',0),
 (6978,3,35,16,0,'0.00',0),
 (6979,3,36,16,0,'0.00',0),
 (6980,3,37,16,0,'0.00',0),
 (6981,3,1,17,466,'57.89',0),
 (6982,3,2,17,242,'30.06',0),
 (6983,3,4,17,1,'0.12',0),
 (6984,3,12,17,68,'8.45',0),
 (6985,3,14,17,0,'0.00',0),
 (6986,3,15,17,0,'0.00',0),
 (6987,3,16,17,0,'0.00',0),
 (6988,3,17,17,1,'0.12',0),
 (6989,3,26,17,0,'0.00',0),
 (6990,3,27,17,1,'0.12',0),
 (6991,3,28,17,1,'0.12',0),
 (6992,3,29,17,0,'0.00',0),
 (6993,3,30,17,0,'0.00',0),
 (6994,3,31,17,11,'1.37',0),
 (6995,3,32,17,1,'0.12',0),
 (6996,3,33,17,1,'0.12',0),
 (6997,3,34,17,5,'0.62',0),
 (6998,3,35,17,0,'0.00',0),
 (6999,3,36,17,0,'0.00',0),
 (7000,3,37,17,0,'0.00',0),
 (7001,3,1,18,1502,'61.08',0),
 (7002,3,2,18,702,'28.55',0),
 (7003,3,4,18,4,'0.16',0),
 (7004,3,12,18,180,'7.32',0),
 (7005,3,14,18,2,'0.08',0),
 (7006,3,15,18,0,'0.00',0),
 (7007,3,16,18,0,'0.00',0),
 (7008,3,17,18,7,'0.28',0),
 (7009,3,26,18,0,'0.00',0),
 (7010,3,27,18,0,'0.00',0),
 (7011,3,28,18,2,'0.08',0),
 (7012,3,29,18,0,'0.00',0),
 (7013,3,30,18,0,'0.00',0),
 (7014,3,31,18,23,'0.94',0),
 (7015,3,32,18,4,'0.16',0),
 (7016,3,33,18,1,'0.04',0),
 (7017,3,34,18,0,'0.00',0),
 (7018,3,35,18,0,'0.00',0),
 (7019,3,36,18,0,'0.00',0),
 (7020,3,37,18,0,'0.00',0),
 (7021,3,1,19,376,'45.80',0),
 (7022,3,2,19,374,'45.55',0),
 (7023,3,4,19,0,'0.00',0),
 (7024,3,12,19,45,'5.48',0),
 (7025,3,14,19,0,'0.00',0),
 (7026,3,15,19,1,'0.12',0),
 (7027,3,16,19,3,'0.37',0),
 (7028,3,17,19,1,'0.12',0),
 (7029,3,26,19,1,'0.12',0),
 (7030,3,27,19,0,'0.00',0),
 (7031,3,28,19,0,'0.00',0),
 (7032,3,29,19,0,'0.00',0),
 (7033,3,30,19,2,'0.24',0),
 (7034,3,31,19,7,'0.85',0),
 (7035,3,32,19,0,'0.00',0),
 (7036,3,33,19,0,'0.00',0),
 (7037,3,34,19,0,'0.00',0),
 (7038,3,35,19,0,'0.00',0),
 (7039,3,36,19,0,'0.00',0),
 (7040,3,37,19,1,'0.12',0),
 (7041,3,1,20,60,'46.15',0),
 (7042,3,2,20,25,'19.23',0),
 (7043,3,4,20,0,'0.00',0),
 (7044,3,12,20,40,'30.77',0),
 (7045,3,14,20,0,'0.00',0),
 (7046,3,15,20,0,'0.00',0),
 (7047,3,16,20,0,'0.00',0),
 (7048,3,17,20,2,'1.54',0),
 (7049,3,26,20,0,'0.00',0),
 (7050,3,27,20,0,'0.00',0),
 (7051,3,28,20,0,'0.00',0),
 (7052,3,29,20,0,'0.00',0),
 (7053,3,30,20,0,'0.00',0),
 (7054,3,31,20,1,'0.77',0),
 (7055,3,32,20,0,'0.00',0),
 (7056,3,33,20,0,'0.00',0),
 (7057,3,34,20,0,'0.00',0),
 (7058,3,35,20,0,'0.00',0),
 (7059,3,36,20,0,'0.00',0),
 (7060,3,37,20,0,'0.00',0),
 (7061,3,1,21,192,'60.38',0),
 (7062,3,2,21,80,'25.16',0),
 (7063,3,4,21,1,'0.31',0),
 (7064,3,12,21,25,'7.86',0),
 (7065,3,14,21,0,'0.00',0),
 (7066,3,15,21,0,'0.00',0),
 (7067,3,16,21,1,'0.31',0),
 (7068,3,17,21,1,'0.31',0),
 (7069,3,26,21,0,'0.00',0),
 (7070,3,27,21,0,'0.00',0),
 (7071,3,28,21,0,'0.00',0),
 (7072,3,29,21,0,'0.00',0),
 (7073,3,30,21,0,'0.00',0),
 (7074,3,31,21,6,'1.89',0),
 (7075,3,32,21,0,'0.00',0),
 (7076,3,33,21,0,'0.00',0),
 (7077,3,34,21,1,'0.31',0),
 (7078,3,35,21,0,'0.00',0),
 (7079,3,36,21,0,'0.00',0),
 (7080,3,37,21,1,'0.31',0),
 (7081,3,1,22,13841,'70.66',0),
 (7082,3,2,22,3898,'19.90',0),
 (7083,3,4,22,46,'0.23',0),
 (7084,3,12,22,1032,'5.27',0),
 (7085,3,14,22,6,'0.03',0),
 (7086,3,15,22,13,'0.07',0),
 (7087,3,16,22,13,'0.07',0),
 (7088,3,17,22,43,'0.22',0),
 (7089,3,26,22,5,'0.03',0),
 (7090,3,27,22,4,'0.02',0),
 (7091,3,28,22,15,'0.08',0),
 (7092,3,29,22,0,'0.00',0),
 (7093,3,30,22,2,'0.01',0),
 (7094,3,31,22,220,'1.12',0),
 (7095,3,32,22,9,'0.05',0),
 (7096,3,33,22,34,'0.17',0),
 (7097,3,34,22,7,'0.04',0),
 (7098,3,35,22,3,'0.02',0),
 (7099,3,36,22,4,'0.02',0),
 (7100,3,37,22,17,'0.09',0),
 (7101,3,1,23,1636,'58.22',0),
 (7102,3,2,23,784,'27.90',0),
 (7103,3,4,23,1,'0.04',0),
 (7104,3,12,23,252,'8.97',0),
 (7105,3,14,23,3,'0.11',0),
 (7106,3,15,23,2,'0.07',0),
 (7107,3,16,23,2,'0.07',0),
 (7108,3,17,23,12,'0.43',0),
 (7109,3,26,23,1,'0.04',0),
 (7110,3,27,23,1,'0.04',0),
 (7111,3,28,23,3,'0.11',0),
 (7112,3,29,23,0,'0.00',0),
 (7113,3,30,23,2,'0.07',0),
 (7114,3,31,23,36,'1.28',0),
 (7115,3,32,23,0,'0.00',0),
 (7116,3,33,23,10,'0.36',0),
 (7117,3,34,23,0,'0.00',0),
 (7118,3,35,23,4,'0.14',0),
 (7119,3,36,23,2,'0.07',0),
 (7120,3,37,23,0,'0.00',0),
 (7121,3,1,24,60,'55.05',0),
 (7122,3,2,24,38,'34.86',0),
 (7123,3,4,24,0,'0.00',0),
 (7124,3,12,24,9,'8.26',0),
 (7125,3,14,24,0,'0.00',0),
 (7126,3,15,24,0,'0.00',0),
 (7127,3,16,24,1,'0.92',0),
 (7128,3,17,24,0,'0.00',0),
 (7129,3,26,24,0,'0.00',0),
 (7130,3,27,24,0,'0.00',0),
 (7131,3,28,24,0,'0.00',0),
 (7132,3,29,24,0,'0.00',0),
 (7133,3,30,24,0,'0.00',0),
 (7134,3,31,24,0,'0.00',0),
 (7135,3,32,24,0,'0.00',0),
 (7136,3,33,24,0,'0.00',0),
 (7137,3,34,24,0,'0.00',0),
 (7138,3,35,24,0,'0.00',0),
 (7139,3,36,24,1,'0.92',0),
 (7140,3,37,24,0,'0.00',0),
 (7141,3,1,25,237,'66.20',0),
 (7142,3,2,25,99,'27.65',0),
 (7143,3,4,25,0,'0.00',0),
 (7144,3,12,25,13,'3.63',0),
 (7145,3,14,25,0,'0.00',0),
 (7146,3,15,25,0,'0.00',0),
 (7147,3,16,25,3,'0.84',0),
 (7148,3,17,25,0,'0.00',0),
 (7149,3,26,25,0,'0.00',0),
 (7150,3,27,25,0,'0.00',0),
 (7151,3,28,25,0,'0.00',0),
 (7152,3,29,25,0,'0.00',0),
 (7153,3,30,25,0,'0.00',0),
 (7154,3,31,25,3,'0.84',0),
 (7155,3,32,25,0,'0.00',0),
 (7156,3,33,25,1,'0.28',0),
 (7157,3,34,25,1,'0.28',0),
 (7158,3,35,25,0,'0.00',0),
 (7159,3,36,25,0,'0.00',0),
 (7160,3,37,25,0,'0.00',0),
 (7161,3,1,26,2450,'62.92',0),
 (7162,3,2,26,969,'24.88',0),
 (7163,3,4,26,6,'0.15',0),
 (7164,3,12,26,311,'7.99',0),
 (7165,3,14,26,1,'0.03',0),
 (7166,3,15,26,3,'0.08',0),
 (7167,3,16,26,5,'0.13',0),
 (7168,3,17,26,12,'0.31',0),
 (7169,3,26,26,1,'0.03',0),
 (7170,3,27,26,3,'0.08',0),
 (7171,3,28,26,20,'0.51',0),
 (7172,3,29,26,0,'0.00',0),
 (7173,3,30,26,1,'0.03',0),
 (7174,3,31,26,35,'0.90',0),
 (7175,3,32,26,1,'0.03',0),
 (7176,3,33,26,7,'0.18',0),
 (7177,3,34,26,0,'0.00',0),
 (7178,3,35,26,0,'0.00',0),
 (7179,3,36,26,2,'0.05',0),
 (7180,3,37,26,3,'0.08',0),
 (7181,3,1,27,499,'54.77',0),
 (7182,3,2,27,328,'36.00',0),
 (7183,3,4,27,0,'0.00',0),
 (7184,3,12,27,55,'6.04',0),
 (7185,3,14,27,0,'0.00',0),
 (7186,3,15,27,1,'0.11',0),
 (7187,3,16,27,1,'0.11',0),
 (7188,3,17,27,1,'0.11',0),
 (7189,3,26,27,2,'0.22',0),
 (7190,3,27,27,0,'0.00',0),
 (7191,3,28,27,0,'0.00',0),
 (7192,3,29,27,0,'0.00',0),
 (7193,3,30,27,1,'0.11',0),
 (7194,3,31,27,6,'0.66',0),
 (7195,3,32,27,0,'0.00',0),
 (7196,3,33,27,0,'0.00',0),
 (7197,3,34,27,0,'0.00',0),
 (7198,3,35,27,0,'0.00',0),
 (7199,3,36,27,0,'0.00',0),
 (7200,3,37,27,0,'0.00',0),
 (7201,3,1,28,517,'47.74',0),
 (7202,3,2,28,318,'29.36',0),
 (7203,3,4,28,0,'0.00',0),
 (7204,3,12,28,206,'19.02',0),
 (7205,3,14,28,0,'0.00',0),
 (7206,3,15,28,0,'0.00',0),
 (7207,3,16,28,6,'0.55',0),
 (7208,3,17,28,5,'0.46',0),
 (7209,3,26,28,0,'0.00',0),
 (7210,3,27,28,0,'0.00',0),
 (7211,3,28,28,2,'0.18',0),
 (7212,3,29,28,0,'0.00',0),
 (7213,3,30,28,0,'0.00',0),
 (7214,3,31,28,11,'1.02',0),
 (7215,3,32,28,0,'0.00',0),
 (7216,3,33,28,0,'0.00',0),
 (7217,3,34,28,1,'0.09',0),
 (7218,3,35,28,0,'0.00',0),
 (7219,3,36,28,0,'0.00',0),
 (7220,3,37,28,0,'0.00',0),
 (7221,3,1,29,263,'58.84',0),
 (7222,3,2,29,130,'29.08',0),
 (7223,3,4,29,1,'0.22',0),
 (7224,3,12,29,39,'8.72',0),
 (7225,3,14,29,0,'0.00',0),
 (7226,3,15,29,1,'0.22',0),
 (7227,3,16,29,0,'0.00',0),
 (7228,3,17,29,4,'0.89',0),
 (7229,3,26,29,0,'0.00',0),
 (7230,3,27,29,0,'0.00',0),
 (7231,3,28,29,1,'0.22',0),
 (7232,3,29,29,0,'0.00',0),
 (7233,3,30,29,0,'0.00',0),
 (7234,3,31,29,5,'1.12',0),
 (7235,3,32,29,0,'0.00',0),
 (7236,3,33,29,0,'0.00',0),
 (7237,3,34,29,0,'0.00',0),
 (7238,3,35,29,0,'0.00',0),
 (7239,3,36,29,1,'0.22',0),
 (7240,3,37,29,0,'0.00',0),
 (7241,3,1,30,671,'55.92',0),
 (7242,3,2,30,401,'33.42',0),
 (7243,3,4,30,0,'0.00',0),
 (7244,3,12,30,82,'6.83',0),
 (7245,3,14,30,4,'0.33',0),
 (7246,3,15,30,0,'0.00',0),
 (7247,3,16,30,1,'0.08',0),
 (7248,3,17,30,1,'0.08',0),
 (7249,3,26,30,0,'0.00',0),
 (7250,3,27,30,0,'0.00',0),
 (7251,3,28,30,1,'0.08',0),
 (7252,3,29,30,0,'0.00',0),
 (7253,3,30,30,0,'0.00',0),
 (7254,3,31,30,13,'1.08',0),
 (7255,3,32,30,1,'0.08',0),
 (7256,3,33,30,3,'0.25',0),
 (7257,3,34,30,5,'0.42',0),
 (7258,3,35,30,1,'0.08',0),
 (7259,3,36,30,0,'0.00',0),
 (7260,3,37,30,1,'0.08',0),
 (7261,3,1,31,776,'48.90',0),
 (7262,3,2,31,729,'45.94',0),
 (7263,3,4,31,0,'0.00',0),
 (7264,3,12,31,61,'3.84',0),
 (7265,3,14,31,0,'0.00',0),
 (7266,3,15,31,0,'0.00',0),
 (7267,3,16,31,1,'0.06',0),
 (7268,3,17,31,0,'0.00',0),
 (7269,3,26,31,0,'0.00',0),
 (7270,3,27,31,0,'0.00',0),
 (7271,3,28,31,0,'0.00',0),
 (7272,3,29,31,0,'0.00',0),
 (7273,3,30,31,0,'0.00',0),
 (7274,3,31,31,5,'0.32',0),
 (7275,3,32,31,0,'0.00',0),
 (7276,3,33,31,2,'0.13',0),
 (7277,3,34,31,0,'0.00',0),
 (7278,3,35,31,0,'0.00',0),
 (7279,3,36,31,1,'0.06',0),
 (7280,3,37,31,0,'0.00',0),
 (7281,3,1,32,1301,'49.06',0),
 (7282,3,2,32,974,'36.73',0),
 (7283,3,4,32,5,'0.19',0),
 (7284,3,12,32,235,'8.86',0),
 (7285,3,14,32,1,'0.04',0),
 (7286,3,15,32,1,'0.04',0),
 (7287,3,16,32,1,'0.04',0),
 (7288,3,17,32,11,'0.41',0),
 (7289,3,26,32,3,'0.11',0),
 (7290,3,27,32,2,'0.08',0),
 (7291,3,28,32,2,'0.08',0),
 (7292,3,29,32,0,'0.00',0),
 (7293,3,30,32,0,'0.00',0),
 (7294,3,31,32,47,'1.77',0),
 (7295,3,32,32,3,'0.11',0),
 (7296,3,33,32,2,'0.08',0),
 (7297,3,34,32,4,'0.15',0),
 (7298,3,35,32,1,'0.04',0),
 (7299,3,36,32,15,'0.57',0),
 (7300,3,37,32,2,'0.08',0),
 (7301,3,1,33,1423,'65.34',0),
 (7302,3,2,33,577,'26.49',0),
 (7303,3,4,33,0,'0.00',0),
 (7304,3,12,33,109,'5.00',0),
 (7305,3,14,33,1,'0.05',0),
 (7306,3,15,33,0,'0.00',0),
 (7307,3,16,33,1,'0.05',0),
 (7308,3,17,33,5,'0.23',0),
 (7309,3,26,33,2,'0.09',0),
 (7310,3,27,33,2,'0.09',0),
 (7311,3,28,33,2,'0.09',0),
 (7312,3,29,33,0,'0.00',0),
 (7313,3,30,33,0,'0.00',0),
 (7314,3,31,33,20,'0.92',0),
 (7315,3,32,33,1,'0.05',0),
 (7316,3,33,33,1,'0.05',0),
 (7317,3,34,33,1,'0.05',0),
 (7318,3,35,33,3,'0.14',0),
 (7319,3,36,33,1,'0.05',0),
 (7320,3,37,33,1,'0.05',0),
 (7321,3,1,34,199,'65.25',0),
 (7322,3,2,34,78,'25.57',0),
 (7323,3,4,34,0,'0.00',0),
 (7324,3,12,34,15,'4.92',0),
 (7325,3,14,34,0,'0.00',0),
 (7326,3,15,34,1,'0.33',0),
 (7327,3,16,34,0,'0.00',0),
 (7328,3,17,34,2,'0.66',0),
 (7329,3,26,34,0,'0.00',0),
 (7330,3,27,34,0,'0.00',0),
 (7331,3,28,34,0,'0.00',0),
 (7332,3,29,34,0,'0.00',0),
 (7333,3,30,34,0,'0.00',0),
 (7334,3,31,34,1,'0.33',0),
 (7335,3,32,34,0,'0.00',0),
 (7336,3,33,34,0,'0.00',0),
 (7337,3,34,34,0,'0.00',0),
 (7338,3,35,34,0,'0.00',0),
 (7339,3,36,34,0,'0.00',0),
 (7340,3,37,34,0,'0.00',0),
 (7341,3,1,35,462,'50.60',0),
 (7342,3,2,35,383,'41.95',0),
 (7343,3,4,35,0,'0.00',0),
 (7344,3,12,35,57,'6.24',0),
 (7345,3,14,35,2,'0.22',0),
 (7346,3,15,35,0,'0.00',0),
 (7347,3,16,35,1,'0.11',0),
 (7348,3,17,35,1,'0.11',0),
 (7349,3,26,35,0,'0.00',0),
 (7350,3,27,35,1,'0.11',0),
 (7351,3,28,35,0,'0.00',0),
 (7352,3,29,35,0,'0.00',0),
 (7353,3,30,35,0,'0.00',0),
 (7354,3,31,35,0,'0.00',0),
 (7355,3,32,35,0,'0.00',0),
 (7356,3,33,35,1,'0.11',0),
 (7357,3,34,35,0,'0.00',0),
 (7358,3,35,35,0,'0.00',0),
 (7359,3,36,35,1,'0.11',0),
 (7360,3,37,35,0,'0.00',0),
 (7361,3,1,36,764,'46.25',0),
 (7362,3,2,36,444,'26.88',0),
 (7363,3,4,36,0,'0.00',0),
 (7364,3,12,36,390,'23.61',0),
 (7365,3,14,36,0,'0.00',0),
 (7366,3,15,36,4,'0.24',0),
 (7367,3,16,36,1,'0.06',0),
 (7368,3,17,36,2,'0.12',0),
 (7369,3,26,36,1,'0.06',0),
 (7370,3,27,36,0,'0.00',0),
 (7371,3,28,36,2,'0.12',0),
 (7372,3,29,36,0,'0.00',0),
 (7373,3,30,36,0,'0.00',0),
 (7374,3,31,36,20,'1.21',0),
 (7375,3,32,36,1,'0.06',0),
 (7376,3,33,36,0,'0.00',0),
 (7377,3,34,36,1,'0.06',0),
 (7378,3,35,36,0,'0.00',0),
 (7379,3,36,36,3,'0.18',0),
 (7380,3,37,36,0,'0.00',0),
 (7381,3,1,37,664,'51.04',0),
 (7382,3,2,37,583,'44.81',0),
 (7383,3,4,37,2,'0.15',0),
 (7384,3,12,37,34,'2.61',0),
 (7385,3,14,37,0,'0.00',0),
 (7386,3,15,37,1,'0.08',0),
 (7387,3,16,37,0,'0.00',0),
 (7388,3,17,37,2,'0.15',0),
 (7389,3,26,37,0,'0.00',0),
 (7390,3,27,37,0,'0.00',0),
 (7391,3,28,37,1,'0.08',0),
 (7392,3,29,37,0,'0.00',0),
 (7393,3,30,37,0,'0.00',0),
 (7394,3,31,37,2,'0.15',0),
 (7395,3,32,37,0,'0.00',0),
 (7396,3,33,37,0,'0.00',0),
 (7397,3,34,37,0,'0.00',0),
 (7398,3,35,37,0,'0.00',0),
 (7399,3,36,37,0,'0.00',0),
 (7400,3,37,37,0,'0.00',0),
 (7401,3,1,38,1708,'47.76',0),
 (7402,3,2,38,1342,'37.53',0),
 (7403,3,4,38,6,'0.17',0),
 (7404,3,12,38,353,'9.87',0),
 (7405,3,14,38,1,'0.03',0),
 (7406,3,15,38,2,'0.06',0),
 (7407,3,16,38,1,'0.03',0),
 (7408,3,17,38,13,'0.36',0),
 (7409,3,26,38,1,'0.03',0),
 (7410,3,27,38,0,'0.00',0),
 (7411,3,28,38,1,'0.03',0),
 (7412,3,29,38,0,'0.00',0),
 (7413,3,30,38,0,'0.00',0),
 (7414,3,31,38,69,'1.93',0),
 (7415,3,32,38,3,'0.08',0),
 (7416,3,33,38,9,'0.25',0),
 (7417,3,34,38,3,'0.08',0),
 (7418,3,35,38,1,'0.03',0),
 (7419,3,36,38,0,'0.00',0),
 (7420,3,37,38,5,'0.14',0),
 (7421,3,1,39,48,'49.48',0),
 (7422,3,2,39,39,'40.21',0),
 (7423,3,4,39,0,'0.00',0),
 (7424,3,12,39,7,'7.22',0),
 (7425,3,14,39,0,'0.00',0),
 (7426,3,15,39,0,'0.00',0),
 (7427,3,16,39,0,'0.00',0),
 (7428,3,17,39,0,'0.00',0),
 (7429,3,26,39,0,'0.00',0),
 (7430,3,27,39,0,'0.00',0),
 (7431,3,28,39,0,'0.00',0),
 (7432,3,29,39,0,'0.00',0),
 (7433,3,30,39,0,'0.00',0),
 (7434,3,31,39,0,'0.00',0),
 (7435,3,32,39,0,'0.00',0),
 (7436,3,33,39,0,'0.00',0),
 (7437,3,34,39,1,'1.03',0),
 (7438,3,35,39,0,'0.00',0),
 (7439,3,36,39,0,'0.00',0),
 (7440,3,37,39,0,'0.00',0),
 (7441,3,1,40,3860,'48.51',0),
 (7442,3,2,40,2666,'33.51',0),
 (7443,3,4,40,7,'0.09',0),
 (7444,3,12,40,1077,'13.54',0),
 (7445,3,14,40,3,'0.04',0),
 (7446,3,15,40,17,'0.21',0),
 (7447,3,16,40,11,'0.14',0),
 (7448,3,17,40,26,'0.33',0),
 (7449,3,26,40,6,'0.08',0),
 (7450,3,27,40,4,'0.05',0),
 (7451,3,28,40,13,'0.16',0),
 (7452,3,29,40,0,'0.00',0),
 (7453,3,30,40,2,'0.03',0),
 (7454,3,31,40,80,'1.01',0),
 (7455,3,32,40,3,'0.04',0),
 (7456,3,33,40,9,'0.11',0),
 (7457,3,34,40,7,'0.09',0),
 (7458,3,35,40,2,'0.03',0),
 (7459,3,36,40,8,'0.10',0),
 (7460,3,37,40,5,'0.06',0),
 (7461,3,1,41,1232,'56.83',0),
 (7462,3,2,41,479,'22.09',0),
 (7463,3,4,41,10,'0.46',0),
 (7464,3,12,41,238,'10.98',0),
 (7465,3,14,41,2,'0.09',0),
 (7466,3,15,41,108,'4.98',0),
 (7467,3,16,41,2,'0.09',0),
 (7468,3,17,41,5,'0.23',0),
 (7469,3,26,41,2,'0.09',0),
 (7470,3,27,41,10,'0.46',0),
 (7471,3,28,41,0,'0.00',0),
 (7472,3,29,41,0,'0.00',0),
 (7473,3,30,41,0,'0.00',0),
 (7474,3,31,41,39,'1.80',0),
 (7475,3,32,41,1,'0.05',0),
 (7476,3,33,41,2,'0.09',0),
 (7477,3,34,41,1,'0.05',0),
 (7478,3,35,41,0,'0.00',0),
 (7479,3,36,41,0,'0.00',0),
 (7480,3,37,41,0,'0.00',0),
 (7481,3,1,42,484,'69.64',0),
 (7482,3,2,42,0,'0.00',0),
 (7483,3,4,42,1,'0.14',0),
 (7484,3,12,42,54,'7.77',0),
 (7485,3,14,42,0,'0.00',0),
 (7486,3,15,42,139,'20.00',0),
 (7487,3,16,42,1,'0.14',0),
 (7488,3,17,42,1,'0.14',0),
 (7489,3,26,42,0,'0.00',0),
 (7490,3,27,42,0,'0.00',0),
 (7491,3,28,42,0,'0.00',0),
 (7492,3,29,42,0,'0.00',0),
 (7493,3,30,42,0,'0.00',0),
 (7494,3,31,42,7,'1.01',0),
 (7495,3,32,42,0,'0.00',0),
 (7496,3,33,42,0,'0.00',0),
 (7497,3,34,42,0,'0.00',0),
 (7498,3,35,42,0,'0.00',0),
 (7499,3,36,42,0,'0.00',0),
 (7500,3,37,42,0,'0.00',0),
 (7501,3,1,43,2427,'63.92',0),
 (7502,3,2,43,1090,'28.71',0),
 (7503,3,4,43,1,'0.03',0),
 (7504,3,12,43,167,'4.40',0),
 (7505,3,14,43,4,'0.11',0),
 (7506,3,15,43,4,'0.11',0),
 (7507,3,16,43,4,'0.11',0),
 (7508,3,17,43,9,'0.24',0),
 (7509,3,26,43,7,'0.18',0),
 (7510,3,27,43,1,'0.03',0),
 (7511,3,28,43,5,'0.13',0),
 (7512,3,29,43,0,'0.00',0),
 (7513,3,30,43,0,'0.00',0),
 (7514,3,31,43,18,'0.47',0),
 (7515,3,32,43,2,'0.05',0),
 (7516,3,33,43,3,'0.08',0),
 (7517,3,34,43,2,'0.05',0),
 (7518,3,35,43,1,'0.03',0),
 (7519,3,36,43,4,'0.11',0),
 (7520,3,37,43,3,'0.08',0),
 (7521,3,1,44,1885,'53.17',0),
 (7522,3,2,44,1128,'31.82',0),
 (7523,3,4,44,12,'0.34',0),
 (7524,3,12,44,362,'10.21',0),
 (7525,3,14,44,4,'0.11',0),
 (7526,3,15,44,5,'0.14',0),
 (7527,3,16,44,1,'0.03',0),
 (7528,3,17,44,13,'0.37',0),
 (7529,3,26,44,1,'0.03',0),
 (7530,3,27,44,15,'0.42',0),
 (7531,3,28,44,2,'0.06',0),
 (7532,3,29,44,0,'0.00',0),
 (7533,3,30,44,0,'0.00',0),
 (7534,3,31,44,45,'1.27',0),
 (7535,3,32,44,1,'0.03',0),
 (7536,3,33,44,7,'0.20',0),
 (7537,3,34,44,1,'0.03',0),
 (7538,3,35,44,2,'0.06',0),
 (7539,3,36,44,1,'0.03',0),
 (7540,3,37,44,1,'0.03',0),
 (7541,3,1,45,10073,'53.27',0),
 (7542,3,2,45,6094,'32.23',0),
 (7543,3,4,45,30,'0.16',0),
 (7544,3,12,45,1873,'9.91',0),
 (7545,3,14,45,18,'0.10',0),
 (7546,3,15,45,23,'0.12',0),
 (7547,3,16,45,16,'0.08',0),
 (7548,3,17,45,45,'0.24',0),
 (7549,3,26,45,8,'0.04',0),
 (7550,3,27,45,17,'0.09',0),
 (7551,3,28,45,27,'0.14',0),
 (7552,3,29,45,0,'0.00',0),
 (7553,3,30,45,2,'0.01',0),
 (7554,3,31,45,245,'1.30',0),
 (7555,3,32,45,14,'0.07',0),
 (7556,3,33,45,23,'0.12',0),
 (7557,3,34,45,18,'0.10',0),
 (7558,3,35,45,1,'0.01',0),
 (7559,3,36,45,10,'0.05',0),
 (7560,3,37,45,12,'0.06',0),
 (7561,3,1,46,1636,'58.24',0),
 (7562,3,2,46,758,'26.98',0),
 (7563,3,4,46,1,'0.04',0),
 (7564,3,12,46,277,'9.86',0),
 (7565,3,14,46,2,'0.07',0),
 (7566,3,15,46,3,'0.11',0),
 (7567,3,16,46,3,'0.11',0),
 (7568,3,17,46,9,'0.32',0),
 (7569,3,26,46,0,'0.00',0),
 (7570,3,27,46,1,'0.04',0),
 (7571,3,28,46,2,'0.07',0),
 (7572,3,29,46,0,'0.00',0),
 (7573,3,30,46,0,'0.00',0),
 (7574,3,31,46,58,'2.06',0),
 (7575,3,32,46,3,'0.11',0),
 (7576,3,33,46,11,'0.39',0),
 (7577,3,34,46,1,'0.04',0),
 (7578,3,35,46,0,'0.00',0),
 (7579,3,36,46,3,'0.11',0),
 (7580,3,37,46,1,'0.04',0),
 (7581,3,1,47,11617,'49.75',0),
 (7582,3,2,47,8705,'37.28',0),
 (7583,3,4,47,42,'0.18',0),
 (7584,3,12,47,1829,'7.83',0),
 (7585,3,14,47,6,'0.03',0),
 (7586,3,15,47,16,'0.07',0),
 (7587,3,16,47,23,'0.10',0),
 (7588,3,17,47,78,'0.33',0),
 (7589,3,26,47,8,'0.03',0),
 (7590,3,27,47,5,'0.02',0),
 (7591,3,28,47,27,'0.12',0),
 (7592,3,29,47,0,'0.00',0),
 (7593,3,30,47,3,'0.01',0),
 (7594,3,31,47,320,'1.37',0),
 (7595,3,32,47,18,'0.08',0),
 (7596,3,33,47,34,'0.15',0),
 (7597,3,34,47,17,'0.07',0),
 (7598,3,35,47,2,'0.01',0),
 (7599,3,36,47,18,'0.08',0),
 (7600,3,37,47,40,'0.17',0),
 (7601,3,1,48,163,'44.17',0),
 (7602,3,2,48,157,'42.55',0),
 (7603,3,4,48,0,'0.00',0),
 (7604,3,12,48,40,'10.84',0),
 (7605,3,14,48,0,'0.00',0),
 (7606,3,15,48,0,'0.00',0),
 (7607,3,16,48,0,'0.00',0),
 (7608,3,17,48,2,'0.54',0),
 (7609,3,26,48,0,'0.00',0),
 (7610,3,27,48,1,'0.27',0),
 (7611,3,28,48,0,'0.00',0),
 (7612,3,29,48,0,'0.00',0),
 (7613,3,30,48,0,'0.00',0),
 (7614,3,31,48,2,'0.54',0),
 (7615,3,32,48,0,'0.00',0),
 (7616,3,33,48,0,'0.00',0),
 (7617,3,34,48,0,'0.00',0),
 (7618,3,35,48,0,'0.00',0),
 (7619,3,36,48,3,'0.81',0),
 (7620,3,37,48,0,'0.00',0),
 (7621,3,1,49,18331,'44.62',0),
 (7622,3,2,49,16119,'39.23',0),
 (7623,3,4,49,28,'0.07',0),
 (7624,3,12,49,4721,'11.49',0),
 (7625,3,14,49,15,'0.04',0),
 (7626,3,15,49,78,'0.19',0),
 (7627,3,16,49,49,'0.12',0),
 (7628,3,17,49,138,'0.34',0),
 (7629,3,26,49,16,'0.04',0),
 (7630,3,27,49,11,'0.03',0),
 (7631,3,28,49,47,'0.11',0),
 (7632,3,29,49,0,'0.00',0),
 (7633,3,30,49,9,'0.02',0),
 (7634,3,31,49,614,'1.49',0),
 (7635,3,32,49,44,'0.11',0),
 (7636,3,33,49,66,'0.16',0),
 (7637,3,34,49,21,'0.05',0),
 (7638,3,35,49,6,'0.01',0),
 (7639,3,36,49,79,'0.19',0),
 (7640,3,37,49,12,'0.03',0),
 (7641,3,1,50,1231,'65.55',0),
 (7642,3,2,50,484,'25.77',0),
 (7643,3,4,50,0,'0.00',0),
 (7644,3,12,50,110,'5.86',0),
 (7645,3,14,50,0,'0.00',0),
 (7646,3,15,50,0,'0.00',0),
 (7647,3,16,50,3,'0.16',0),
 (7648,3,17,50,2,'0.11',0),
 (7649,3,26,50,7,'0.37',0),
 (7650,3,27,50,0,'0.00',0),
 (7651,3,28,50,2,'0.11',0),
 (7652,3,29,50,0,'0.00',0),
 (7653,3,30,50,0,'0.00',0),
 (7654,3,31,50,23,'1.22',0),
 (7655,3,32,50,1,'0.05',0),
 (7656,3,33,50,1,'0.05',0),
 (7657,3,34,50,0,'0.00',0),
 (7658,3,35,50,0,'0.00',0),
 (7659,3,36,50,2,'0.11',0),
 (7660,3,37,50,0,'0.00',0),
 (7661,3,1,51,684,'61.35',0),
 (7662,3,2,51,308,'27.62',0),
 (7663,3,4,51,0,'0.00',0),
 (7664,3,12,51,84,'7.53',0),
 (7665,3,14,51,0,'0.00',0),
 (7666,3,15,51,2,'0.18',0),
 (7667,3,16,51,2,'0.18',0),
 (7668,3,17,51,9,'0.81',0),
 (7669,3,26,51,0,'0.00',0),
 (7670,3,27,51,1,'0.09',0),
 (7671,3,28,51,3,'0.27',0),
 (7672,3,29,51,0,'0.00',0),
 (7673,3,30,51,0,'0.00',0),
 (7674,3,31,51,14,'1.26',0),
 (7675,3,32,51,0,'0.00',0),
 (7676,3,33,51,0,'0.00',0),
 (7677,3,34,51,0,'0.00',0),
 (7678,3,35,51,0,'0.00',0),
 (7679,3,36,51,0,'0.00',0),
 (7680,3,37,51,0,'0.00',0),
 (7681,3,1,52,1645,'61.82',0),
 (7682,3,2,52,871,'32.73',0),
 (7683,3,4,52,5,'0.19',0),
 (7684,3,12,52,98,'3.68',0),
 (7685,3,14,52,0,'0.00',0),
 (7686,3,15,52,0,'0.00',0),
 (7687,3,16,52,4,'0.15',0),
 (7688,3,17,52,2,'0.08',0),
 (7689,3,26,52,0,'0.00',0),
 (7690,3,27,52,2,'0.08',0),
 (7691,3,28,52,3,'0.11',0),
 (7692,3,29,52,0,'0.00',0),
 (7693,3,30,52,1,'0.04',0),
 (7694,3,31,52,5,'0.19',0),
 (7695,3,32,52,0,'0.00',0),
 (7696,3,33,52,2,'0.08',0),
 (7697,3,34,52,0,'0.00',0),
 (7698,3,35,52,1,'0.04',0),
 (7699,3,36,52,2,'0.08',0),
 (7700,3,37,52,0,'0.00',0),
 (7701,3,1,53,2082,'51.14',0),
 (7702,3,2,53,1523,'37.41',0),
 (7703,3,4,53,4,'0.10',0),
 (7704,3,12,53,308,'7.57',0),
 (7705,3,14,53,1,'0.02',0),
 (7706,3,15,53,5,'0.12',0),
 (7707,3,16,53,8,'0.20',0),
 (7708,3,17,53,6,'0.15',0),
 (7709,3,26,53,3,'0.07',0),
 (7710,3,27,53,1,'0.02',0),
 (7711,3,28,53,2,'0.05',0),
 (7712,3,29,53,0,'0.00',0),
 (7713,3,30,53,0,'0.00',0),
 (7714,3,31,53,71,'1.74',0),
 (7715,3,32,53,1,'0.02',0),
 (7716,3,33,53,0,'0.00',0),
 (7717,3,34,53,0,'0.00',0),
 (7718,3,35,53,0,'0.00',0),
 (7719,3,36,53,3,'0.07',0),
 (7720,3,37,53,0,'0.00',0),
 (7721,3,1,54,4052,'58.49',0),
 (7722,3,2,54,2001,'28.88',0),
 (7723,3,4,54,11,'0.16',0),
 (7724,3,12,54,561,'8.10',0),
 (7725,3,14,54,4,'0.06',0),
 (7726,3,15,54,3,'0.04',0),
 (7727,3,16,54,6,'0.09',0),
 (7728,3,17,54,17,'0.25',0),
 (7729,3,26,54,2,'0.03',0),
 (7730,3,27,54,3,'0.04',0),
 (7731,3,28,54,9,'0.13',0),
 (7732,3,29,54,0,'0.00',0),
 (7733,3,30,54,1,'0.01',0),
 (7734,3,31,54,93,'1.34',0),
 (7735,3,32,54,2,'0.03',0),
 (7736,3,33,54,15,'0.22',0),
 (7737,3,34,54,4,'0.06',0),
 (7738,3,35,54,2,'0.03',0),
 (7739,3,36,54,9,'0.13',0),
 (7740,3,37,54,3,'0.04',0),
 (7741,3,1,55,494,'55.38',0),
 (7742,3,2,55,367,'41.14',0),
 (7743,3,4,55,2,'0.22',0),
 (7744,3,12,55,17,'1.91',0),
 (7745,3,14,55,0,'0.00',0),
 (7746,3,15,55,0,'0.00',0),
 (7747,3,16,55,3,'0.34',0),
 (7748,3,17,55,1,'0.11',0),
 (7749,3,26,55,0,'0.00',0),
 (7750,3,27,55,0,'0.00',0),
 (7751,3,28,55,0,'0.00',0),
 (7752,3,29,55,0,'0.00',0),
 (7753,3,30,55,0,'0.00',0),
 (7754,3,31,55,4,'0.45',0),
 (7755,3,32,55,0,'0.00',0),
 (7756,3,33,55,0,'0.00',0),
 (7757,3,34,55,0,'0.00',0),
 (7758,3,35,55,0,'0.00',0),
 (7759,3,36,55,2,'0.22',0),
 (7760,3,37,55,0,'0.00',0),
 (7761,3,1,56,317,'56.81',0),
 (7762,3,2,56,158,'28.32',0),
 (7763,3,4,56,0,'0.00',0),
 (7764,3,12,56,64,'11.47',0),
 (7765,3,14,56,0,'0.00',0),
 (7766,3,15,56,0,'0.00',0),
 (7767,3,16,56,0,'0.00',0),
 (7768,3,17,56,2,'0.36',0),
 (7769,3,26,56,0,'0.00',0),
 (7770,3,27,56,0,'0.00',0),
 (7771,3,28,56,0,'0.00',0),
 (7772,3,29,56,0,'0.00',0),
 (7773,3,30,56,0,'0.00',0),
 (7774,3,31,56,4,'0.72',0),
 (7775,3,32,56,0,'0.00',0),
 (7776,3,33,56,0,'0.00',0),
 (7777,3,34,56,0,'0.00',0),
 (7778,3,35,56,0,'0.00',0),
 (7779,3,36,56,0,'0.00',0),
 (7780,3,37,56,0,'0.00',0),
 (7781,3,1,57,553,'53.02',0),
 (7782,3,2,57,315,'30.20',0),
 (7783,3,4,57,1,'0.10',0),
 (7784,3,12,57,96,'9.20',0),
 (7785,3,14,57,1,'0.10',0),
 (7786,3,15,57,0,'0.00',0),
 (7787,3,16,57,4,'0.38',0),
 (7788,3,17,57,4,'0.38',0),
 (7789,3,26,57,0,'0.00',0),
 (7790,3,27,57,1,'0.10',0),
 (7791,3,28,57,1,'0.10',0),
 (7792,3,29,57,0,'0.00',0),
 (7793,3,30,57,0,'0.00',0),
 (7794,3,31,57,29,'2.78',0),
 (7795,3,32,57,3,'0.29',0),
 (7796,3,33,57,3,'0.29',0),
 (7797,3,34,57,0,'0.00',0),
 (7798,3,35,57,1,'0.10',0),
 (7799,3,36,57,2,'0.19',0),
 (7800,3,37,57,11,'1.05',0),
 (7801,3,1,58,32945,'39.93',0),
 (7802,3,2,58,39020,'47.29',0),
 (7803,3,4,58,105,'0.13',0),
 (7804,3,12,58,6414,'7.77',0),
 (7805,3,14,58,79,'0.10',0),
 (7806,3,15,58,117,'0.14',0),
 (7807,3,16,58,140,'0.17',0),
 (7808,3,17,58,282,'0.34',0),
 (7809,3,26,58,251,'0.30',0),
 (7810,3,27,58,43,'0.05',0),
 (7811,3,28,58,106,'0.13',0),
 (7812,3,29,58,0,'0.00',0),
 (7813,3,30,58,30,'0.04',0),
 (7814,3,31,58,1152,'1.40',0),
 (7815,3,32,58,27,'0.03',0),
 (7816,3,33,58,93,'0.11',0),
 (7817,3,34,58,58,'0.07',0),
 (7818,3,35,58,11,'0.01',0),
 (7819,3,36,58,201,'0.24',0),
 (7820,3,37,58,59,'0.07',0),
 (7821,3,1,59,1638,'56.62',0),
 (7822,3,2,59,943,'32.60',0),
 (7823,3,4,59,1,'0.03',0),
 (7824,3,12,59,214,'7.40',0),
 (7825,3,14,59,1,'0.03',0),
 (7826,3,15,59,1,'0.03',0),
 (7827,3,16,59,4,'0.14',0),
 (7828,3,17,59,3,'0.10',0),
 (7829,3,26,59,1,'0.03',0),
 (7830,3,27,59,2,'0.07',0),
 (7831,3,28,59,2,'0.07',0),
 (7832,3,29,59,0,'0.00',0),
 (7833,3,30,59,0,'0.00',0),
 (7834,3,31,59,21,'0.73',0),
 (7835,3,32,59,0,'0.00',0),
 (7836,3,33,59,0,'0.00',0),
 (7837,3,34,59,1,'0.03',0),
 (7838,3,35,59,15,'0.52',0),
 (7839,3,36,59,0,'0.00',0),
 (7840,3,37,59,0,'0.00',0),
 (7841,3,1,60,390,'32.75',0),
 (7842,3,2,60,527,'44.25',0),
 (7843,3,4,60,0,'0.00',0),
 (7844,3,12,60,265,'22.25',0),
 (7845,3,14,60,1,'0.08',0),
 (7846,3,15,60,0,'0.00',0),
 (7847,3,16,60,2,'0.17',0),
 (7848,3,17,60,1,'0.08',0),
 (7849,3,26,60,0,'0.00',0),
 (7850,3,27,60,0,'0.00',0),
 (7851,3,28,60,0,'0.00',0),
 (7852,3,29,60,0,'0.00',0),
 (7853,3,30,60,0,'0.00',0),
 (7854,3,31,60,0,'0.00',0),
 (7855,3,32,60,0,'0.00',0),
 (7856,3,33,60,0,'0.00',0),
 (7857,3,34,60,0,'0.00',0),
 (7858,3,35,60,0,'0.00',0),
 (7859,3,36,60,1,'0.08',0),
 (7860,3,37,60,0,'0.00',0),
 (7861,3,1,61,7271,'56.66',0),
 (7862,3,2,61,3810,'29.69',0),
 (7863,3,4,61,24,'0.19',0),
 (7864,3,12,61,1073,'8.36',0),
 (7865,3,14,61,10,'0.08',0),
 (7866,3,15,61,9,'0.07',0),
 (7867,3,16,61,15,'0.12',0),
 (7868,3,17,61,31,'0.24',0),
 (7869,3,26,61,7,'0.05',0),
 (7870,3,27,61,8,'0.06',0),
 (7871,3,28,61,20,'0.16',0),
 (7872,3,29,61,0,'0.00',0),
 (7873,3,30,61,2,'0.02',0),
 (7874,3,31,61,188,'1.46',0),
 (7875,3,32,61,20,'0.16',0),
 (7876,3,33,61,18,'0.14',0),
 (7877,3,34,61,11,'0.09',0),
 (7878,3,35,61,3,'0.02',0),
 (7879,3,36,61,7,'0.05',0),
 (7880,3,37,61,8,'0.06',0),
 (7881,3,1,62,186,'71.54',0),
 (7882,3,2,62,52,'20.00',0),
 (7883,3,4,62,0,'0.00',0),
 (7884,3,12,62,16,'6.15',0),
 (7885,3,14,62,0,'0.00',0),
 (7886,3,15,62,0,'0.00',0),
 (7887,3,16,62,1,'0.38',0),
 (7888,3,17,62,0,'0.00',0),
 (7889,3,26,62,0,'0.00',0),
 (7890,3,27,62,0,'0.00',0),
 (7891,3,28,62,1,'0.38',0),
 (7892,3,29,62,0,'0.00',0),
 (7893,3,30,62,0,'0.00',0),
 (7894,3,31,62,0,'0.00',0),
 (7895,3,32,62,0,'0.00',0),
 (7896,3,33,62,1,'0.38',0),
 (7897,3,34,62,1,'0.38',0),
 (7898,3,35,62,0,'0.00',0),
 (7899,3,36,62,0,'0.00',0),
 (7900,3,37,62,0,'0.00',0),
 (7901,3,1,63,117,'52.23',0),
 (7902,3,2,63,65,'29.02',0),
 (7903,3,4,63,0,'0.00',0),
 (7904,3,12,63,29,'12.95',0),
 (7905,3,14,63,1,'0.45',0),
 (7906,3,15,63,1,'0.45',0),
 (7907,3,16,63,0,'0.00',0),
 (7908,3,17,63,0,'0.00',0),
 (7909,3,26,63,2,'0.89',0),
 (7910,3,27,63,0,'0.00',0),
 (7911,3,28,63,0,'0.00',0),
 (7912,3,29,63,0,'0.00',0),
 (7913,3,30,63,0,'0.00',0),
 (7914,3,31,63,2,'0.89',0),
 (7915,3,32,63,0,'0.00',0),
 (7916,3,33,63,0,'0.00',0),
 (7917,3,34,63,1,'0.45',0),
 (7918,3,35,63,0,'0.00',0),
 (7919,3,36,63,0,'0.00',0),
 (7920,3,37,63,0,'0.00',0),
 (7921,3,1,64,64,'60.38',0),
 (7922,3,2,64,34,'32.08',0),
 (7923,3,4,64,0,'0.00',0),
 (7924,3,12,64,3,'2.83',0),
 (7925,3,14,64,0,'0.00',0),
 (7926,3,15,64,1,'0.94',0),
 (7927,3,16,64,0,'0.00',0),
 (7928,3,17,64,0,'0.00',0),
 (7929,3,26,64,0,'0.00',0),
 (7930,3,27,64,0,'0.00',0),
 (7931,3,28,64,0,'0.00',0),
 (7932,3,29,64,0,'0.00',0),
 (7933,3,30,64,0,'0.00',0),
 (7934,3,31,64,0,'0.00',0),
 (7935,3,32,64,0,'0.00',0),
 (7936,3,33,64,0,'0.00',0),
 (7937,3,34,64,1,'0.94',0),
 (7938,3,35,64,0,'0.00',0),
 (7939,3,36,64,1,'0.94',0),
 (7940,3,37,64,0,'0.00',0),
 (7941,3,1,65,33132,'41.55',0),
 (7942,3,2,65,34094,'42.76',0),
 (7943,3,4,65,107,'0.13',0),
 (7944,3,12,65,9086,'11.39',0),
 (7945,3,14,65,38,'0.05',0),
 (7946,3,15,65,142,'0.18',0),
 (7947,3,16,65,64,'0.08',0),
 (7948,3,17,65,202,'0.25',0),
 (7949,3,26,65,28,'0.04',0),
 (7950,3,27,65,26,'0.03',0),
 (7951,3,28,65,85,'0.11',0),
 (7952,3,29,65,0,'0.00',0),
 (7953,3,30,65,16,'0.02',0),
 (7954,3,31,65,1043,'1.31',0),
 (7955,3,32,65,71,'0.09',0),
 (7956,3,33,65,133,'0.17',0),
 (7957,3,34,65,59,'0.07',0),
 (7958,3,35,65,11,'0.01',0),
 (7959,3,36,65,102,'0.13',0),
 (7960,3,37,65,52,'0.07',0),
 (7961,3,1,66,3229,'71.31',0),
 (7962,3,2,66,949,'20.96',0),
 (7963,3,4,66,2,'0.04',0),
 (7964,3,12,66,177,'3.91',0),
 (7965,3,14,66,0,'0.00',0),
 (7966,3,15,66,6,'0.13',0),
 (7967,3,16,66,5,'0.11',0),
 (7968,3,17,66,12,'0.27',0),
 (7969,3,26,66,5,'0.11',0),
 (7970,3,27,66,1,'0.02',0),
 (7971,3,28,66,5,'0.11',0),
 (7972,3,29,66,0,'0.00',0),
 (7973,3,30,66,0,'0.00',0),
 (7974,3,31,66,57,'1.26',0),
 (7975,3,32,66,7,'0.15',0),
 (7976,3,33,66,2,'0.04',0),
 (7977,3,34,66,1,'0.02',0),
 (7978,3,35,66,1,'0.02',0),
 (7979,3,36,66,5,'0.11',0),
 (7980,3,37,66,3,'0.07',0),
 (7981,3,1,67,1255,'53.93',0),
 (7982,3,2,67,766,'32.92',0),
 (7983,3,4,67,1,'0.04',0),
 (7984,3,12,67,202,'8.68',0),
 (7985,3,14,67,0,'0.00',0),
 (7986,3,15,67,2,'0.09',0),
 (7987,3,16,67,7,'0.30',0),
 (7988,3,17,67,3,'0.13',0),
 (7989,3,26,67,0,'0.00',0),
 (7990,3,27,67,0,'0.00',0),
 (7991,3,28,67,4,'0.17',0),
 (7992,3,29,67,0,'0.00',0),
 (7993,3,30,67,2,'0.09',0),
 (7994,3,31,67,22,'0.95',0),
 (7995,3,32,67,4,'0.17',0),
 (7996,3,33,67,3,'0.13',0),
 (7997,3,34,67,2,'0.09',0),
 (7998,3,35,67,0,'0.00',0),
 (7999,3,36,67,2,'0.09',0),
 (8000,3,37,67,1,'0.04',0),
 (8001,3,1,68,3953,'61.04',0),
 (8002,3,2,68,1860,'28.72',0),
 (8003,3,4,68,6,'0.09',0),
 (8004,3,12,68,387,'5.98',0),
 (8005,3,14,68,1,'0.02',0),
 (8006,3,15,68,5,'0.08',0),
 (8007,3,16,68,11,'0.17',0),
 (8008,3,17,68,13,'0.20',0),
 (8009,3,26,68,1,'0.02',0),
 (8010,3,27,68,4,'0.06',0),
 (8011,3,28,68,5,'0.08',0),
 (8012,3,29,68,0,'0.00',0),
 (8013,3,30,68,0,'0.00',0),
 (8014,3,31,68,72,'1.11',0),
 (8015,3,32,68,4,'0.06',0),
 (8016,3,33,68,7,'0.11',0),
 (8017,3,34,68,6,'0.09',0),
 (8018,3,35,68,1,'0.02',0),
 (8019,3,36,68,10,'0.15',0),
 (8020,3,37,68,4,'0.06',0),
 (8021,3,1,69,44,'73.33',0),
 (8022,3,2,69,9,'15.00',0),
 (8023,3,4,69,0,'0.00',0),
 (8024,3,12,69,3,'5.00',0),
 (8025,3,14,69,0,'0.00',0),
 (8026,3,15,69,0,'0.00',0),
 (8027,3,16,69,0,'0.00',0),
 (8028,3,17,69,0,'0.00',0),
 (8029,3,26,69,0,'0.00',0),
 (8030,3,27,69,0,'0.00',0),
 (8031,3,28,69,0,'0.00',0),
 (8032,3,29,69,0,'0.00',0),
 (8033,3,30,69,0,'0.00',0),
 (8034,3,31,69,2,'3.33',0),
 (8035,3,32,69,0,'0.00',0),
 (8036,3,33,69,0,'0.00',0),
 (8037,3,34,69,0,'0.00',0),
 (8038,3,35,69,0,'0.00',0),
 (8039,3,36,69,0,'0.00',0),
 (8040,3,37,69,0,'0.00',0),
 (8041,3,1,70,58,'59.79',0),
 (8042,3,2,70,16,'16.49',0),
 (8043,3,4,70,1,'1.03',0),
 (8044,3,12,70,17,'17.53',0),
 (8045,3,14,70,0,'0.00',0),
 (8046,3,15,70,0,'0.00',0),
 (8047,3,16,70,3,'3.09',0),
 (8048,3,17,70,1,'1.03',0),
 (8049,3,26,70,0,'0.00',0),
 (8050,3,27,70,0,'0.00',0),
 (8051,3,28,70,0,'0.00',0),
 (8052,3,29,70,0,'0.00',0),
 (8053,3,30,70,0,'0.00',0),
 (8054,3,31,70,0,'0.00',0),
 (8055,3,32,70,0,'0.00',0),
 (8056,3,33,70,0,'0.00',0),
 (8057,3,34,70,0,'0.00',0),
 (8058,3,35,70,0,'0.00',0),
 (8059,3,36,70,0,'0.00',0),
 (8060,3,37,70,0,'0.00',0),
 (8061,3,1,71,33,'60.00',0),
 (8062,3,2,71,15,'27.27',0),
 (8063,3,4,71,0,'0.00',0),
 (8064,3,12,71,3,'5.45',0),
 (8065,3,14,71,0,'0.00',0),
 (8066,3,15,71,0,'0.00',0),
 (8067,3,16,71,0,'0.00',0),
 (8068,3,17,71,1,'1.82',0),
 (8069,3,26,71,0,'0.00',0),
 (8070,3,27,71,0,'0.00',0),
 (8071,3,28,71,0,'0.00',0),
 (8072,3,29,71,0,'0.00',0),
 (8073,3,30,71,0,'0.00',0),
 (8074,3,31,71,1,'1.82',0),
 (8075,3,32,71,0,'0.00',0),
 (8076,3,33,71,0,'0.00',0),
 (8077,3,34,71,0,'0.00',0),
 (8078,3,35,71,0,'0.00',0),
 (8079,3,36,71,0,'0.00',0),
 (8080,3,37,71,0,'0.00',0),
 (8081,3,1,72,2233,'61.16',0),
 (8082,3,2,72,880,'24.10',0),
 (8083,3,4,72,4,'0.11',0),
 (8084,3,12,72,365,'10.00',0),
 (8085,3,14,72,2,'0.05',0),
 (8086,3,15,72,5,'0.14',0),
 (8087,3,16,72,3,'0.08',0),
 (8088,3,17,72,9,'0.25',0),
 (8089,3,26,72,3,'0.08',0),
 (8090,3,27,72,1,'0.03',0),
 (8091,3,28,72,3,'0.08',0),
 (8092,3,29,72,0,'0.00',0),
 (8093,3,30,72,0,'0.00',0),
 (8094,3,31,72,51,'1.40',0),
 (8095,3,32,72,0,'0.00',0),
 (8096,3,33,72,7,'0.19',0),
 (8097,3,34,72,0,'0.00',0),
 (8098,3,35,72,0,'0.00',0),
 (8099,3,36,72,5,'0.14',0),
 (8100,3,37,72,1,'0.03',0),
 (8101,3,1,73,3661,'50.52',0),
 (8102,3,2,73,2668,'36.82',0),
 (8103,3,4,73,6,'0.08',0),
 (8104,3,12,73,521,'7.19',0),
 (8105,3,14,73,8,'0.11',0),
 (8106,3,15,73,8,'0.11',0),
 (8107,3,16,73,9,'0.12',0),
 (8108,3,17,73,28,'0.39',0),
 (8109,3,26,73,3,'0.04',0),
 (8110,3,27,73,3,'0.04',0),
 (8111,3,28,73,15,'0.21',0),
 (8112,3,29,73,0,'0.00',0),
 (8113,3,30,73,2,'0.03',0),
 (8114,3,31,73,127,'1.75',0),
 (8115,3,32,73,6,'0.08',0),
 (8116,3,33,73,11,'0.15',0),
 (8117,3,34,73,3,'0.04',0),
 (8118,3,35,73,1,'0.01',0),
 (8119,3,36,73,24,'0.33',0),
 (8120,3,37,73,8,'0.11',0),
 (8121,3,1,74,37940,'41.28',0),
 (8122,3,2,74,39407,'42.87',0),
 (8123,3,4,74,105,'0.11',0),
 (8124,3,12,74,9617,'10.46',0),
 (8125,3,14,74,39,'0.04',0),
 (8126,3,15,74,175,'0.19',0),
 (8127,3,16,74,103,'0.11',0),
 (8128,3,17,74,221,'0.24',0),
 (8129,3,26,74,26,'0.03',0),
 (8130,3,27,74,41,'0.04',0),
 (8131,3,28,74,83,'0.09',0),
 (8132,3,29,74,0,'0.00',0),
 (8133,3,30,74,1061,'1.15',0),
 (8134,3,31,74,1087,'1.18',0),
 (8135,3,32,74,51,'0.06',0),
 (8136,3,33,74,262,'0.29',0),
 (8137,3,34,74,45,'0.05',0),
 (8138,3,35,74,11,'0.01',0),
 (8139,3,36,74,151,'0.16',0),
 (8140,3,37,74,34,'0.04',0),
 (8141,3,1,75,1491,'51.47',0),
 (8142,3,2,75,1044,'36.04',0),
 (8143,3,4,75,0,'0.00',0),
 (8144,3,12,75,266,'9.18',0),
 (8145,3,14,75,0,'0.00',0),
 (8146,3,15,75,1,'0.03',0),
 (8147,3,16,75,2,'0.07',0),
 (8148,3,17,75,9,'0.31',0),
 (8149,3,26,75,0,'0.00',0),
 (8150,3,27,75,0,'0.00',0),
 (8151,3,28,75,5,'0.17',0),
 (8152,3,29,75,0,'0.00',0),
 (8153,3,30,75,0,'0.00',0),
 (8154,3,31,75,30,'1.04',0),
 (8155,3,32,75,3,'0.10',0),
 (8156,3,33,75,1,'0.03',0),
 (8157,3,34,75,2,'0.07',0),
 (8158,3,35,75,1,'0.03',0),
 (8159,3,36,75,5,'0.17',0),
 (8160,3,37,75,2,'0.07',0),
 (8161,3,1,76,200,'58.82',0),
 (8162,3,2,76,104,'30.59',0),
 (8163,3,4,76,0,'0.00',0),
 (8164,3,12,76,29,'8.53',0),
 (8165,3,14,76,0,'0.00',0),
 (8166,3,15,76,0,'0.00',0),
 (8167,3,16,76,0,'0.00',0),
 (8168,3,17,76,1,'0.29',0),
 (8169,3,26,76,0,'0.00',0),
 (8170,3,27,76,0,'0.00',0),
 (8171,3,28,76,0,'0.00',0),
 (8172,3,29,76,0,'0.00',0),
 (8173,3,30,76,0,'0.00',0),
 (8174,3,31,76,2,'0.59',0),
 (8175,3,32,76,0,'0.00',0),
 (8176,3,33,76,0,'0.00',0),
 (8177,3,34,76,0,'0.00',0),
 (8178,3,35,76,0,'0.00',0),
 (8179,3,36,76,1,'0.29',0),
 (8180,3,37,76,0,'0.00',0),
 (8181,3,1,78,16,'59.26',0),
 (8182,3,2,78,5,'18.52',0),
 (8183,3,4,78,0,'0.00',0),
 (8184,3,12,78,4,'14.81',0),
 (8185,3,14,78,0,'0.00',0),
 (8186,3,15,78,0,'0.00',0),
 (8187,3,16,78,0,'0.00',0),
 (8188,3,17,78,0,'0.00',0),
 (8189,3,26,78,0,'0.00',0),
 (8190,3,27,78,0,'0.00',0),
 (8191,3,28,78,0,'0.00',0),
 (8192,3,29,78,0,'0.00',0),
 (8193,3,30,78,0,'0.00',0),
 (8194,3,31,78,2,'7.41',0),
 (8195,3,32,78,0,'0.00',0),
 (8196,3,33,78,0,'0.00',0),
 (8197,3,34,78,0,'0.00',0),
 (8198,3,35,78,0,'0.00',0),
 (8199,3,36,78,0,'0.00',0),
 (8200,3,37,78,0,'0.00',0),
 (8201,3,1,79,865134,'55.21',0),
 (8202,3,2,79,494357,'31.55',0),
 (8203,3,4,79,3119,'0.20',0),
 (8204,3,12,79,146330,'9.34',0),
 (8205,3,14,79,880,'0.06',0),
 (8206,3,15,79,1723,'0.11',0),
 (8207,3,16,79,1521,'0.10',0),
 (8208,3,17,79,2846,'0.18',0),
 (8209,3,26,79,478,'0.03',0),
 (8210,3,27,79,780,'0.05',0),
 (8211,3,28,79,1109,'0.07',0),
 (8212,3,29,79,0,'0.00',0),
 (8213,3,30,79,152,'0.01',0),
 (8214,3,31,79,14052,'0.90',0),
 (8215,3,32,79,631,'0.04',0),
 (8216,3,33,79,2482,'0.16',0),
 (8217,3,34,79,1134,'0.07',0),
 (8218,3,35,79,307,'0.02',0),
 (8219,3,36,79,1297,'0.08',0),
 (8220,3,37,79,810,'0.05',0),
 (8221,3,1,80,21290,'68.35',0),
 (8222,3,2,80,6474,'20.79',0),
 (8223,3,4,80,61,'0.20',0),
 (8224,3,12,80,2072,'6.65',0),
 (8225,3,14,80,10,'0.03',0),
 (8226,3,15,80,10,'0.03',0),
 (8227,3,16,80,23,'0.07',0),
 (8228,3,17,80,73,'0.23',0),
 (8229,3,26,80,26,'0.08',0),
 (8230,3,27,80,6,'0.02',0),
 (8231,3,28,80,22,'0.07',0),
 (8232,3,29,80,0,'0.00',0),
 (8233,3,30,80,2,'0.01',0),
 (8234,3,31,80,341,'1.09',0),
 (8235,3,32,80,18,'0.06',0),
 (8236,3,33,80,55,'0.18',0),
 (8237,3,34,80,21,'0.07',0),
 (8238,3,35,80,1,'0.00',0),
 (8239,3,36,80,11,'0.04',0),
 (8240,3,37,80,27,'0.09',0),
 (8241,3,1,82,1544,'46.87',0),
 (8242,3,2,82,875,'26.56',0),
 (8243,3,4,82,2,'0.06',0),
 (8244,3,12,82,385,'11.69',0),
 (8245,3,14,82,3,'0.09',0),
 (8246,3,15,82,6,'0.18',0),
 (8247,3,16,82,3,'0.09',0),
 (8248,3,17,82,16,'0.49',0),
 (8249,3,26,82,0,'0.00',0),
 (8250,3,27,82,0,'0.00',0),
 (8251,3,28,82,2,'0.06',0),
 (8252,3,29,82,0,'0.00',0),
 (8253,3,30,82,1,'0.03',0),
 (8254,3,31,82,60,'1.82',0),
 (8255,3,32,82,1,'0.03',0),
 (8256,3,33,82,321,'9.74',0),
 (8257,3,34,82,6,'0.18',0),
 (8258,3,35,82,3,'0.09',0),
 (8259,3,36,82,4,'0.12',0),
 (8260,3,37,82,0,'0.00',0),
 (8261,3,1,83,2408,'53.87',0),
 (8262,3,2,83,1473,'32.95',0),
 (8263,3,4,83,1,'0.02',0),
 (8264,3,12,83,366,'8.19',0),
 (8265,3,14,83,1,'0.02',0),
 (8266,3,15,83,6,'0.13',0),
 (8267,3,16,83,19,'0.43',0),
 (8268,3,17,83,9,'0.20',0),
 (8269,3,26,83,0,'0.00',0),
 (8270,3,27,83,1,'0.02',0),
 (8271,3,28,83,9,'0.20',0),
 (8272,3,29,83,0,'0.00',0),
 (8273,3,30,83,0,'0.00',0),
 (8274,3,31,83,84,'1.88',0),
 (8275,3,32,83,7,'0.16',0),
 (8276,3,33,83,4,'0.09',0),
 (8277,3,34,83,4,'0.09',0),
 (8278,3,35,83,1,'0.02',0),
 (8279,3,36,83,15,'0.34',0),
 (8280,3,37,83,3,'0.07',0),
 (8281,3,1,84,4146,'45.59',0),
 (8282,3,2,84,3572,'39.27',0),
 (8283,3,4,84,4,'0.04',0),
 (8284,3,12,84,974,'10.71',0),
 (8285,3,14,84,2,'0.02',0),
 (8286,3,15,84,15,'0.16',0),
 (8287,3,16,84,6,'0.07',0),
 (8288,3,17,84,27,'0.30',0),
 (8289,3,26,84,3,'0.03',0),
 (8290,3,27,84,2,'0.02',0),
 (8291,3,28,84,16,'0.18',0),
 (8292,3,29,84,0,'0.00',0),
 (8293,3,30,84,2,'0.02',0),
 (8294,3,31,84,151,'1.66',0),
 (8295,3,32,84,6,'0.07',0),
 (8296,3,33,84,6,'0.07',0),
 (8297,3,34,84,5,'0.05',0),
 (8298,3,35,84,2,'0.02',0),
 (8299,3,36,84,17,'0.19',0),
 (8300,3,37,84,4,'0.04',0),
 (8301,3,1,85,1498,'54.41',0),
 (8302,3,2,85,905,'32.87',0),
 (8303,3,4,85,1,'0.04',0),
 (8304,3,12,85,280,'10.17',0),
 (8305,3,14,85,1,'0.04',0),
 (8306,3,15,85,1,'0.04',0),
 (8307,3,16,85,1,'0.04',0),
 (8308,3,17,85,2,'0.07',0),
 (8309,3,26,85,1,'0.04',0),
 (8310,3,27,85,1,'0.04',0),
 (8311,3,28,85,0,'0.00',0),
 (8312,3,29,85,0,'0.00',0),
 (8313,3,30,85,0,'0.00',0),
 (8314,3,31,85,26,'0.94',0),
 (8315,3,32,85,0,'0.00',0),
 (8316,3,33,85,0,'0.00',0),
 (8317,3,34,85,2,'0.07',0),
 (8318,3,35,85,0,'0.00',0),
 (8319,3,36,85,1,'0.04',0),
 (8320,3,37,85,1,'0.04',0),
 (8321,3,1,86,1642,'62.50',0),
 (8322,3,2,86,717,'27.29',0),
 (8323,3,4,86,2,'0.08',0),
 (8324,3,12,86,154,'5.86',0),
 (8325,3,14,86,1,'0.04',0),
 (8326,3,15,86,1,'0.04',0),
 (8327,3,16,86,7,'0.27',0),
 (8328,3,17,86,9,'0.34',0),
 (8329,3,26,86,2,'0.08',0),
 (8330,3,27,86,0,'0.00',0),
 (8331,3,28,86,0,'0.00',0),
 (8332,3,29,86,0,'0.00',0),
 (8333,3,30,86,0,'0.00',0),
 (8334,3,31,86,22,'0.84',0),
 (8335,3,32,86,0,'0.00',0),
 (8336,3,33,86,6,'0.23',0),
 (8337,3,34,86,2,'0.08',0),
 (8338,3,35,86,16,'0.61',0),
 (8339,3,36,86,5,'0.19',0),
 (8340,3,37,86,4,'0.15',0),
 (8341,3,1,87,1314,'58.56',0),
 (8342,3,2,87,650,'28.97',0),
 (8343,3,4,87,6,'0.27',0),
 (8344,3,12,87,192,'8.56',0),
 (8345,3,14,87,1,'0.04',0),
 (8346,3,15,87,4,'0.18',0),
 (8347,3,16,87,2,'0.09',0),
 (8348,3,17,87,1,'0.04',0),
 (8349,3,26,87,2,'0.09',0),
 (8350,3,27,87,2,'0.09',0),
 (8351,3,28,87,0,'0.00',0),
 (8352,3,29,87,0,'0.00',0),
 (8353,3,30,87,1,'0.04',0),
 (8354,3,31,87,19,'0.85',0),
 (8355,3,32,87,0,'0.00',0),
 (8356,3,33,87,3,'0.13',0),
 (8357,3,34,87,3,'0.13',0),
 (8358,3,35,87,0,'0.00',0),
 (8359,3,36,87,1,'0.04',0),
 (8360,3,37,87,0,'0.00',0),
 (8361,3,1,88,97,'44.91',0),
 (8362,3,2,88,83,'38.43',0),
 (8363,3,4,88,0,'0.00',0),
 (8364,3,12,88,27,'12.50',0),
 (8365,3,14,88,0,'0.00',0),
 (8366,3,15,88,0,'0.00',0),
 (8367,3,16,88,0,'0.00',0),
 (8368,3,17,88,0,'0.00',0),
 (8369,3,26,88,0,'0.00',0),
 (8370,3,27,88,0,'0.00',0),
 (8371,3,28,88,0,'0.00',0),
 (8372,3,29,88,0,'0.00',0),
 (8373,3,30,88,0,'0.00',0),
 (8374,3,31,88,1,'0.46',0),
 (8375,3,32,88,0,'0.00',0),
 (8376,3,33,88,0,'0.00',0),
 (8377,3,34,88,2,'0.93',0),
 (8378,3,35,88,0,'0.00',0),
 (8379,3,36,88,0,'0.00',0),
 (8380,3,37,88,1,'0.46',0),
 (8381,3,1,89,1555,'62.42',0),
 (8382,3,2,89,751,'30.15',0),
 (8383,3,4,89,1,'0.04',0),
 (8384,3,12,89,112,'4.50',0),
 (8385,3,14,89,0,'0.00',0),
 (8386,3,15,89,3,'0.12',0),
 (8387,3,16,89,2,'0.08',0),
 (8388,3,17,89,6,'0.24',0),
 (8389,3,26,89,2,'0.08',0),
 (8390,3,27,89,0,'0.00',0),
 (8391,3,28,89,1,'0.04',0),
 (8392,3,29,89,0,'0.00',0),
 (8393,3,30,89,0,'0.00',0),
 (8394,3,31,89,22,'0.88',0),
 (8395,3,32,89,0,'0.00',0),
 (8396,3,33,89,3,'0.12',0),
 (8397,3,34,89,0,'0.00',0),
 (8398,3,35,89,0,'0.00',0),
 (8399,3,36,89,2,'0.08',0),
 (8400,3,37,89,1,'0.04',0),
 (8401,3,1,90,2968,'56.85',0),
 (8402,3,2,90,1551,'29.71',0),
 (8403,3,4,90,11,'0.21',0),
 (8404,3,12,90,448,'8.58',0),
 (8405,3,14,90,2,'0.04',0),
 (8406,3,15,90,6,'0.11',0),
 (8407,3,16,90,9,'0.17',0),
 (8408,3,17,90,16,'0.31',0),
 (8409,3,26,90,0,'0.00',0),
 (8410,3,27,90,1,'0.02',0),
 (8411,3,28,90,5,'0.10',0),
 (8412,3,29,90,0,'0.00',0),
 (8413,3,30,90,2,'0.04',0),
 (8414,3,31,90,82,'1.57',0),
 (8415,3,32,90,3,'0.06',0),
 (8416,3,33,90,8,'0.15',0),
 (8417,3,34,90,1,'0.02',0),
 (8418,3,35,90,1,'0.02',0),
 (8419,3,36,90,3,'0.06',0),
 (8420,3,37,90,2,'0.04',0),
 (8421,3,1,91,1793,'52.57',0),
 (8422,3,2,91,1160,'34.01',0),
 (8423,3,4,91,3,'0.09',0),
 (8424,3,12,91,340,'9.97',0),
 (8425,3,14,91,1,'0.03',0),
 (8426,3,15,91,3,'0.09',0),
 (8427,3,16,91,1,'0.03',0),
 (8428,3,17,91,5,'0.15',0),
 (8429,3,26,91,1,'0.03',0),
 (8430,3,27,91,1,'0.03',0),
 (8431,3,28,91,2,'0.06',0),
 (8432,3,29,91,0,'0.00',0),
 (8433,3,30,91,0,'0.00',0),
 (8434,3,31,91,23,'0.67',0),
 (8435,3,32,91,1,'0.03',0),
 (8436,3,33,91,3,'0.09',0),
 (8437,3,34,91,1,'0.03',0),
 (8438,3,35,91,0,'0.00',0),
 (8439,3,36,91,5,'0.15',0),
 (8440,3,37,91,0,'0.00',0),
 (8441,3,1,92,49486,'50.37',0),
 (8442,3,2,92,37064,'37.73',0),
 (8443,3,4,92,223,'0.23',0),
 (8444,3,12,92,7061,'7.19',0),
 (8445,3,14,92,49,'0.05',0),
 (8446,3,15,92,136,'0.14',0),
 (8447,3,16,92,119,'0.12',0),
 (8448,3,17,92,233,'0.24',0),
 (8449,3,26,92,27,'0.03',0),
 (8450,3,27,92,44,'0.04',0),
 (8451,3,28,92,113,'0.12',0),
 (8452,3,29,92,0,'0.00',0),
 (8453,3,30,92,15,'0.02',0),
 (8454,3,31,92,1481,'1.51',0),
 (8455,3,32,92,62,'0.06',0),
 (8456,3,33,92,115,'0.12',0),
 (8457,3,34,92,65,'0.07',0),
 (8458,3,35,92,18,'0.02',0),
 (8459,3,36,92,129,'0.13',0),
 (8460,3,37,92,46,'0.05',0),
 (8461,3,1,93,870,'62.82',0),
 (8462,3,2,93,385,'27.80',0),
 (8463,3,4,93,2,'0.14',0),
 (8464,3,12,93,76,'5.49',0),
 (8465,3,14,93,1,'0.07',0),
 (8466,3,15,93,0,'0.00',0),
 (8467,3,16,93,4,'0.29',0),
 (8468,3,17,93,5,'0.36',0),
 (8469,3,26,93,2,'0.14',0),
 (8470,3,27,93,2,'0.14',0),
 (8471,3,28,93,0,'0.00',0),
 (8472,3,29,93,0,'0.00',0),
 (8473,3,30,93,0,'0.00',0),
 (8474,3,31,93,13,'0.94',0),
 (8475,3,32,93,0,'0.00',0),
 (8476,3,33,93,1,'0.07',0),
 (8477,3,34,93,1,'0.07',0),
 (8478,3,35,93,0,'0.00',0),
 (8479,3,36,93,0,'0.00',0),
 (8480,3,37,93,1,'0.07',0),
 (8481,3,1,94,306,'65.38',0),
 (8482,3,2,94,92,'19.66',0),
 (8483,3,4,94,0,'0.00',0),
 (8484,3,12,94,44,'9.40',0),
 (8485,3,14,94,0,'0.00',0),
 (8486,3,15,94,2,'0.43',0),
 (8487,3,16,94,1,'0.21',0),
 (8488,3,17,94,3,'0.64',0),
 (8489,3,26,94,0,'0.00',0),
 (8490,3,27,94,0,'0.00',0),
 (8491,3,28,94,1,'0.21',0),
 (8492,3,29,94,0,'0.00',0),
 (8493,3,30,94,0,'0.00',0),
 (8494,3,31,94,5,'1.07',0),
 (8495,3,32,94,3,'0.64',0),
 (8496,3,33,94,0,'0.00',0),
 (8497,3,34,94,0,'0.00',0),
 (8498,3,35,94,0,'0.00',0),
 (8499,3,36,94,1,'0.21',0),
 (8500,3,37,94,0,'0.00',0),
 (8501,3,1,95,496,'54.21',0),
 (8502,3,2,95,259,'28.31',0),
 (8503,3,4,95,0,'0.00',0),
 (8504,3,12,95,133,'14.54',0),
 (8505,3,14,95,1,'0.11',0),
 (8506,3,15,95,0,'0.00',0),
 (8507,3,16,95,3,'0.33',0),
 (8508,3,17,95,3,'0.33',0),
 (8509,3,26,95,0,'0.00',0),
 (8510,3,27,95,0,'0.00',0),
 (8511,3,28,95,0,'0.00',0),
 (8512,3,29,95,0,'0.00',0),
 (8513,3,30,95,0,'0.00',0),
 (8514,3,31,95,2,'0.22',0),
 (8515,3,32,95,0,'0.00',0),
 (8516,3,33,95,1,'0.11',0),
 (8517,3,34,95,1,'0.11',0),
 (8518,3,35,95,0,'0.00',0),
 (8519,3,36,95,0,'0.00',0),
 (8520,3,37,95,0,'0.00',0),
 (8521,3,1,96,5489,'62.77',0),
 (8522,3,2,96,2639,'30.18',0),
 (8523,3,4,96,13,'0.15',0),
 (8524,3,12,96,322,'3.68',0),
 (8525,3,14,96,4,'0.05',0),
 (8526,3,15,96,4,'0.05',0),
 (8527,3,16,96,14,'0.16',0),
 (8528,3,17,96,21,'0.24',0),
 (8529,3,26,96,3,'0.03',0),
 (8530,3,27,96,4,'0.05',0),
 (8531,3,28,96,10,'0.11',0),
 (8532,3,29,96,0,'0.00',0),
 (8533,3,30,96,0,'0.00',0),
 (8534,3,31,96,71,'0.81',0),
 (8535,3,32,96,1,'0.01',0),
 (8536,3,33,96,6,'0.07',0),
 (8537,3,34,96,7,'0.08',0),
 (8538,3,35,96,1,'0.01',0),
 (8539,3,36,96,4,'0.05',0),
 (8540,3,37,96,3,'0.03',0),
 (8541,3,1,97,27,'27.55',0),
 (8542,3,2,97,59,'60.20',0),
 (8543,3,4,97,0,'0.00',0),
 (8544,3,12,97,8,'8.16',0),
 (8545,3,14,97,0,'0.00',0),
 (8546,3,15,97,0,'0.00',0),
 (8547,3,16,97,0,'0.00',0),
 (8548,3,17,97,0,'0.00',0),
 (8549,3,26,97,0,'0.00',0),
 (8550,3,27,97,1,'1.02',0),
 (8551,3,28,97,0,'0.00',0),
 (8552,3,29,97,0,'0.00',0),
 (8553,3,30,97,0,'0.00',0),
 (8554,3,31,97,2,'2.04',0),
 (8555,3,32,97,0,'0.00',0),
 (8556,3,33,97,1,'1.02',0),
 (8557,3,34,97,0,'0.00',0),
 (8558,3,35,97,0,'0.00',0),
 (8559,3,36,97,0,'0.00',0),
 (8560,3,37,97,0,'0.00',0),
 (8561,3,1,99,789,'68.13',0),
 (8562,3,2,99,264,'22.80',0),
 (8563,3,4,99,0,'0.00',0),
 (8564,3,12,99,71,'6.13',0),
 (8565,3,14,99,0,'0.00',0),
 (8566,3,15,99,0,'0.00',0),
 (8567,3,16,99,7,'0.60',0),
 (8568,3,17,99,2,'0.17',0),
 (8569,3,26,99,0,'0.00',0),
 (8570,3,27,99,0,'0.00',0),
 (8571,3,28,99,0,'0.00',0),
 (8572,3,29,99,0,'0.00',0),
 (8573,3,30,99,0,'0.00',0),
 (8574,3,31,99,7,'0.60',0),
 (8575,3,32,99,1,'0.09',0),
 (8576,3,33,99,0,'0.00',0),
 (8577,3,34,99,1,'0.09',0),
 (8578,3,35,99,0,'0.00',0),
 (8579,3,36,99,4,'0.35',0),
 (8580,3,37,99,0,'0.00',0),
 (8581,3,1,100,1319,'55.68',0),
 (8582,3,2,100,695,'29.34',0),
 (8583,3,4,100,3,'0.13',0),
 (8584,3,12,100,250,'10.55',0),
 (8585,3,14,100,5,'0.21',0),
 (8586,3,15,100,2,'0.08',0),
 (8587,3,16,100,1,'0.04',0),
 (8588,3,17,100,6,'0.25',0),
 (8589,3,26,100,0,'0.00',0),
 (8590,3,27,100,1,'0.04',0),
 (8591,3,28,100,3,'0.13',0),
 (8592,3,29,100,0,'0.00',0),
 (8593,3,30,100,1,'0.04',0),
 (8594,3,31,100,45,'1.90',0),
 (8595,3,32,100,2,'0.08',0),
 (8596,3,33,100,1,'0.04',0),
 (8597,3,34,100,1,'0.04',0),
 (8598,3,35,100,0,'0.00',0),
 (8599,3,36,100,2,'0.08',0),
 (8600,3,37,100,0,'0.00',0),
 (8601,3,1,101,84,'53.50',0),
 (8602,3,2,101,43,'27.39',0),
 (8603,3,4,101,0,'0.00',0),
 (8604,3,12,101,18,'11.46',0),
 (8605,3,14,101,0,'0.00',0),
 (8606,3,15,101,0,'0.00',0),
 (8607,3,16,101,0,'0.00',0),
 (8608,3,17,101,0,'0.00',0),
 (8609,3,26,101,0,'0.00',0),
 (8610,3,27,101,0,'0.00',0),
 (8611,3,28,101,0,'0.00',0),
 (8612,3,29,101,0,'0.00',0),
 (8613,3,30,101,0,'0.00',0),
 (8614,3,31,101,4,'2.55',0),
 (8615,3,32,101,0,'0.00',0),
 (8616,3,33,101,0,'0.00',0),
 (8617,3,34,101,1,'0.64',0),
 (8618,3,35,101,0,'0.00',0),
 (8619,3,36,101,0,'0.00',0),
 (8620,3,37,101,0,'0.00',0),
 (8621,3,1,102,280,'43.01',0),
 (8622,3,2,102,279,'42.86',0),
 (8623,3,4,102,0,'0.00',0),
 (8624,3,12,102,78,'11.98',0),
 (8625,3,14,102,0,'0.00',0),
 (8626,3,15,102,0,'0.00',0),
 (8627,3,16,102,2,'0.31',0),
 (8628,3,17,102,3,'0.46',0),
 (8629,3,26,102,0,'0.00',0),
 (8630,3,27,102,0,'0.00',0),
 (8631,3,28,102,0,'0.00',0),
 (8632,3,29,102,0,'0.00',0),
 (8633,3,30,102,0,'0.00',0),
 (8634,3,31,102,3,'0.46',0),
 (8635,3,32,102,0,'0.00',0),
 (8636,3,33,102,0,'0.00',0),
 (8637,3,34,102,1,'0.15',0),
 (8638,3,35,102,0,'0.00',0),
 (8639,3,36,102,0,'0.00',0),
 (8640,3,37,102,0,'0.00',0),
 (8641,3,1,104,2333,'55.26',0),
 (8642,3,2,104,1019,'24.14',0),
 (8643,3,4,104,4,'0.09',0),
 (8644,3,12,104,502,'11.89',0),
 (8645,3,14,104,0,'0.00',0),
 (8646,3,15,104,195,'4.62',0),
 (8647,3,16,104,3,'0.07',0),
 (8648,3,17,104,9,'0.21',0),
 (8649,3,26,104,0,'0.00',0),
 (8650,3,27,104,2,'0.05',0),
 (8651,3,28,104,5,'0.12',0),
 (8652,3,29,104,0,'0.00',0),
 (8653,3,30,104,0,'0.00',0),
 (8654,3,31,104,46,'1.09',0),
 (8655,3,32,104,6,'0.14',0),
 (8656,3,33,104,3,'0.07',0),
 (8657,3,34,104,4,'0.09',0),
 (8658,3,35,104,2,'0.05',0),
 (8659,3,36,104,4,'0.09',0),
 (8660,3,37,104,4,'0.09',0),
 (8661,3,1,106,12980,'33.13',0),
 (8662,3,2,106,21776,'55.58',0),
 (8663,3,4,106,37,'0.09',0),
 (8664,3,12,106,2850,'7.27',0),
 (8665,3,14,106,20,'0.05',0),
 (8666,3,15,106,64,'0.16',0),
 (8667,3,16,106,66,'0.17',0),
 (8668,3,17,106,123,'0.31',0),
 (8669,3,26,106,10,'0.03',0),
 (8670,3,27,106,11,'0.03',0),
 (8671,3,28,106,60,'0.15',0),
 (8672,3,29,106,0,'0.00',0),
 (8673,3,30,106,8,'0.02',0),
 (8674,3,31,106,513,'1.31',0),
 (8675,3,32,106,17,'0.04',0),
 (8676,3,33,106,40,'0.10',0),
 (8677,3,34,106,20,'0.05',0),
 (8678,3,35,106,5,'0.01',0),
 (8679,3,36,106,63,'0.16',0),
 (8680,3,37,106,16,'0.04',0),
 (8681,3,1,107,153,'45.67',0),
 (8682,3,2,107,143,'42.69',0),
 (8683,3,4,107,0,'0.00',0),
 (8684,3,12,107,23,'6.87',0),
 (8685,3,14,107,0,'0.00',0),
 (8686,3,15,107,0,'0.00',0),
 (8687,3,16,107,2,'0.60',0),
 (8688,3,17,107,0,'0.00',0),
 (8689,3,26,107,0,'0.00',0),
 (8690,3,27,107,0,'0.00',0),
 (8691,3,28,107,3,'0.90',0),
 (8692,3,29,107,0,'0.00',0),
 (8693,3,30,107,0,'0.00',0),
 (8694,3,31,107,2,'0.60',0),
 (8695,3,32,107,0,'0.00',0),
 (8696,3,33,107,0,'0.00',0),
 (8697,3,34,107,0,'0.00',0),
 (8698,3,35,107,0,'0.00',0),
 (8699,3,36,107,0,'0.00',0),
 (8700,3,37,107,0,'0.00',0),
 (8701,3,1,108,984,'61.04',0),
 (8702,3,2,108,472,'29.28',0),
 (8703,3,4,108,0,'0.00',0),
 (8704,3,12,108,108,'6.70',0),
 (8705,3,14,108,1,'0.06',0),
 (8706,3,15,108,3,'0.19',0),
 (8707,3,16,108,0,'0.00',0),
 (8708,3,17,108,5,'0.31',0),
 (8709,3,26,108,0,'0.00',0),
 (8710,3,27,108,0,'0.00',0),
 (8711,3,28,108,0,'0.00',0),
 (8712,3,29,108,0,'0.00',0),
 (8713,3,30,108,0,'0.00',0),
 (8714,3,31,108,19,'1.18',0),
 (8715,3,32,108,0,'0.00',0),
 (8716,3,33,108,3,'0.19',0),
 (8717,3,34,108,0,'0.00',0),
 (8718,3,35,108,2,'0.12',0),
 (8719,3,36,108,0,'0.00',0),
 (8720,3,37,108,1,'0.06',0),
 (8721,3,1,109,694,'69.12',0),
 (8722,3,2,109,226,'22.51',0),
 (8723,3,4,109,1,'0.10',0),
 (8724,3,12,109,44,'4.38',0),
 (8725,3,14,109,0,'0.00',0),
 (8726,3,15,109,2,'0.20',0),
 (8727,3,16,109,5,'0.50',0),
 (8728,3,17,109,3,'0.30',0),
 (8729,3,26,109,0,'0.00',0),
 (8730,3,27,109,1,'0.10',0),
 (8731,3,28,109,0,'0.00',0),
 (8732,3,29,109,0,'0.00',0),
 (8733,3,30,109,0,'0.00',0),
 (8734,3,31,109,11,'1.10',0),
 (8735,3,32,109,1,'0.10',0),
 (8736,3,33,109,3,'0.30',0),
 (8737,3,34,109,1,'0.10',0),
 (8738,3,35,109,1,'0.10',0),
 (8739,3,36,109,1,'0.10',0),
 (8740,3,37,109,4,'0.40',0),
 (8741,3,1,110,853,'54.78',0),
 (8742,3,2,110,605,'38.86',0),
 (8743,3,4,110,0,'0.00',0),
 (8744,3,12,110,49,'3.15',0),
 (8745,3,14,110,0,'0.00',0),
 (8746,3,15,110,1,'0.06',0),
 (8747,3,16,110,4,'0.26',0),
 (8748,3,17,110,1,'0.06',0),
 (8749,3,26,110,0,'0.00',0),
 (8750,3,27,110,8,'0.51',0),
 (8751,3,28,110,2,'0.13',0),
 (8752,3,29,110,0,'0.00',0),
 (8753,3,30,110,0,'0.00',0),
 (8754,3,31,110,8,'0.51',0),
 (8755,3,32,110,0,'0.00',0),
 (8756,3,33,110,1,'0.06',0),
 (8757,3,34,110,0,'0.00',0),
 (8758,3,35,110,0,'0.00',0),
 (8759,3,36,110,3,'0.19',0),
 (8760,3,37,110,0,'0.00',0),
 (8761,3,1,111,255,'55.92',0),
 (8762,3,2,111,139,'30.48',0),
 (8763,3,4,111,1,'0.22',0),
 (8764,3,12,111,49,'10.75',0),
 (8765,3,14,111,0,'0.00',0),
 (8766,3,15,111,1,'0.22',0),
 (8767,3,16,111,0,'0.00',0),
 (8768,3,17,111,0,'0.00',0),
 (8769,3,26,111,0,'0.00',0),
 (8770,3,27,111,0,'0.00',0),
 (8771,3,28,111,1,'0.22',0),
 (8772,3,29,111,0,'0.00',0),
 (8773,3,30,111,0,'0.00',0),
 (8774,3,31,111,1,'0.22',0),
 (8775,3,32,111,0,'0.00',0),
 (8776,3,33,111,1,'0.22',0),
 (8777,3,34,111,1,'0.22',0),
 (8778,3,35,111,0,'0.00',0),
 (8779,3,36,111,3,'0.66',0),
 (8780,3,37,111,0,'0.00',0),
 (8781,3,1,112,79,'56.43',0),
 (8782,3,2,112,54,'38.57',0),
 (8783,3,4,112,1,'0.71',0),
 (8784,3,12,112,3,'2.14',0),
 (8785,3,14,112,0,'0.00',0),
 (8786,3,15,112,0,'0.00',0),
 (8787,3,16,112,0,'0.00',0),
 (8788,3,17,112,0,'0.00',0),
 (8789,3,26,112,0,'0.00',0),
 (8790,3,27,112,0,'0.00',0),
 (8791,3,28,112,1,'0.71',0),
 (8792,3,29,112,0,'0.00',0),
 (8793,3,30,112,0,'0.00',0),
 (8794,3,31,112,0,'0.00',0),
 (8795,3,32,112,0,'0.00',0),
 (8796,3,33,112,1,'0.71',0),
 (8797,3,34,112,0,'0.00',0),
 (8798,3,35,112,0,'0.00',0),
 (8799,3,36,112,0,'0.00',0),
 (8800,3,37,112,0,'0.00',0),
 (8801,3,1,113,9184,'47.44',0),
 (8802,3,2,113,7677,'39.65',0),
 (8803,3,4,113,16,'0.08',0),
 (8804,3,12,113,1540,'7.95',0),
 (8805,3,14,113,11,'0.06',0),
 (8806,3,15,113,35,'0.18',0),
 (8807,3,16,113,14,'0.07',0),
 (8808,3,17,113,53,'0.27',0),
 (8809,3,26,113,4,'0.02',0),
 (8810,3,27,113,7,'0.04',0),
 (8811,3,28,113,12,'0.06',0),
 (8812,3,29,113,0,'0.00',0),
 (8813,3,30,113,1,'0.01',0),
 (8814,3,31,113,365,'1.89',0),
 (8815,3,32,113,20,'0.10',0),
 (8816,3,33,113,27,'0.14',0),
 (8817,3,34,113,17,'0.09',0),
 (8818,3,35,113,1,'0.01',0),
 (8819,3,36,113,41,'0.21',0),
 (8820,3,37,113,6,'0.03',0),
 (8821,3,1,114,99,'74.44',0),
 (8822,3,2,114,23,'17.29',0),
 (8823,3,4,114,0,'0.00',0),
 (8824,3,12,114,4,'3.01',0),
 (8825,3,14,114,0,'0.00',0),
 (8826,3,15,114,0,'0.00',0),
 (8827,3,16,114,0,'0.00',0),
 (8828,3,17,114,2,'1.50',0),
 (8829,3,26,114,0,'0.00',0),
 (8830,3,27,114,0,'0.00',0),
 (8831,3,28,114,0,'0.00',0),
 (8832,3,29,114,0,'0.00',0),
 (8833,3,30,114,0,'0.00',0),
 (8834,3,31,114,0,'0.00',0),
 (8835,3,32,114,0,'0.00',0),
 (8836,3,33,114,0,'0.00',0),
 (8837,3,34,114,1,'0.75',0),
 (8838,3,35,114,0,'0.00',0),
 (8839,3,36,114,0,'0.00',0),
 (8840,3,37,114,0,'0.00',0),
 (8841,3,1,115,28768,'70.82',0),
 (8842,3,2,115,8082,'19.90',0),
 (8843,3,4,115,83,'0.20',0),
 (8844,3,12,115,2094,'5.15',0),
 (8845,3,14,115,24,'0.06',0),
 (8846,3,15,115,31,'0.08',0),
 (8847,3,16,115,21,'0.05',0),
 (8848,3,17,115,92,'0.23',0),
 (8849,3,26,115,12,'0.03',0),
 (8850,3,27,115,8,'0.02',0),
 (8851,3,28,115,36,'0.09',0),
 (8852,3,29,115,0,'0.00',0),
 (8853,3,30,115,1,'0.00',0),
 (8854,3,31,115,427,'1.05',0),
 (8855,3,32,115,17,'0.04',0),
 (8856,3,33,115,68,'0.17',0),
 (8857,3,34,115,8,'0.02',0),
 (8858,3,35,115,17,'0.04',0),
 (8859,3,36,115,18,'0.04',0),
 (8860,3,37,115,16,'0.04',0),
 (8861,3,1,116,120,'45.63',0),
 (8862,3,2,116,130,'49.43',0),
 (8863,3,4,116,0,'0.00',0),
 (8864,3,12,116,10,'3.80',0),
 (8865,3,14,116,1,'0.38',0),
 (8866,3,15,116,0,'0.00',0),
 (8867,3,16,116,0,'0.00',0),
 (8868,3,17,116,0,'0.00',0),
 (8869,3,26,116,0,'0.00',0),
 (8870,3,27,116,0,'0.00',0),
 (8871,3,28,116,1,'0.38',0),
 (8872,3,29,116,0,'0.00',0),
 (8873,3,30,116,0,'0.00',0),
 (8874,3,31,116,1,'0.38',0),
 (8875,3,32,116,0,'0.00',0),
 (8876,3,33,116,0,'0.00',0),
 (8877,3,34,116,0,'0.00',0),
 (8878,3,35,116,0,'0.00',0),
 (8879,3,36,116,0,'0.00',0),
 (8880,3,37,116,0,'0.00',0),
 (8881,3,1,117,57,'67.86',0),
 (8882,3,2,117,16,'19.05',0),
 (8883,3,4,117,0,'0.00',0),
 (8884,3,12,117,9,'10.71',0),
 (8885,3,14,117,0,'0.00',0),
 (8886,3,15,117,0,'0.00',0),
 (8887,3,16,117,0,'0.00',0),
 (8888,3,17,117,1,'1.19',0),
 (8889,3,26,117,0,'0.00',0),
 (8890,3,27,117,0,'0.00',0),
 (8891,3,28,117,0,'0.00',0),
 (8892,3,29,117,0,'0.00',0),
 (8893,3,30,117,0,'0.00',0),
 (8894,3,31,117,1,'1.19',0),
 (8895,3,32,117,0,'0.00',0),
 (8896,3,33,117,0,'0.00',0),
 (8897,3,34,117,0,'0.00',0),
 (8898,3,35,117,0,'0.00',0),
 (8899,3,36,117,0,'0.00',0),
 (8900,3,37,117,0,'0.00',0),
 (8901,3,1,118,27,'40.30',0),
 (8902,3,2,118,24,'35.82',0),
 (8903,3,4,118,0,'0.00',0),
 (8904,3,12,118,7,'10.45',0),
 (8905,3,14,118,0,'0.00',0),
 (8906,3,15,118,0,'0.00',0),
 (8907,3,16,118,1,'1.49',0),
 (8908,3,17,118,1,'1.49',0),
 (8909,3,26,118,0,'0.00',0),
 (8910,3,27,118,0,'0.00',0),
 (8911,3,28,118,0,'0.00',0),
 (8912,3,29,118,0,'0.00',0),
 (8913,3,30,118,0,'0.00',0),
 (8914,3,31,118,4,'5.97',0),
 (8915,3,32,118,0,'0.00',0),
 (8916,3,33,118,1,'1.49',0),
 (8917,3,34,118,0,'0.00',0),
 (8918,3,35,118,0,'0.00',0);
INSERT INTO `elecmunicandi` (`idElecMuniCandi`,`Convocatoria_idConvocatoria`,`Candidatura_idCandidatura`,`Municipio`,`Votos`,`PorcVotos`,`Concejales`) VALUES 
 (8919,3,36,118,0,'0.00',0),
 (8920,3,37,118,1,'1.49',0),
 (8921,3,1,119,853,'65.67',0),
 (8922,3,2,119,284,'21.86',0),
 (8923,3,4,119,1,'0.08',0),
 (8924,3,12,119,101,'7.78',0),
 (8925,3,14,119,1,'0.08',0),
 (8926,3,15,119,0,'0.00',0),
 (8927,3,16,119,4,'0.31',0),
 (8928,3,17,119,4,'0.31',0),
 (8929,3,26,119,0,'0.00',0),
 (8930,3,27,119,0,'0.00',0),
 (8931,3,28,119,1,'0.08',0),
 (8932,3,29,119,0,'0.00',0),
 (8933,3,30,119,0,'0.00',0),
 (8934,3,31,119,15,'1.15',0),
 (8935,3,32,119,1,'0.08',0),
 (8936,3,33,119,3,'0.23',0),
 (8937,3,34,119,0,'0.00',0),
 (8938,3,35,119,0,'0.00',0),
 (8939,3,36,119,0,'0.00',0),
 (8940,3,37,119,4,'0.31',0),
 (8941,3,1,120,501,'50.05',0),
 (8942,3,2,120,402,'40.16',0),
 (8943,3,4,120,1,'0.10',0),
 (8944,3,12,120,60,'5.99',0),
 (8945,3,14,120,0,'0.00',0),
 (8946,3,15,120,1,'0.10',0),
 (8947,3,16,120,1,'0.10',0),
 (8948,3,17,120,0,'0.00',0),
 (8949,3,26,120,3,'0.30',0),
 (8950,3,27,120,0,'0.00',0),
 (8951,3,28,120,0,'0.00',0),
 (8952,3,29,120,0,'0.00',0),
 (8953,3,30,120,1,'0.10',0),
 (8954,3,31,120,7,'0.70',0),
 (8955,3,32,120,0,'0.00',0),
 (8956,3,33,120,2,'0.20',0),
 (8957,3,34,120,0,'0.00',0),
 (8958,3,35,120,0,'0.00',0),
 (8959,3,36,120,0,'0.00',0),
 (8960,3,37,120,1,'0.10',0),
 (8961,3,1,121,76,'49.67',0),
 (8962,3,2,121,63,'41.18',0),
 (8963,3,4,121,0,'0.00',0),
 (8964,3,12,121,5,'3.27',0),
 (8965,3,14,121,0,'0.00',0),
 (8966,3,15,121,0,'0.00',0),
 (8967,3,16,121,0,'0.00',0),
 (8968,3,17,121,0,'0.00',0),
 (8969,3,26,121,0,'0.00',0),
 (8970,3,27,121,0,'0.00',0),
 (8971,3,28,121,2,'1.31',0),
 (8972,3,29,121,0,'0.00',0),
 (8973,3,30,121,0,'0.00',0),
 (8974,3,31,121,3,'1.96',0),
 (8975,3,32,121,0,'0.00',0),
 (8976,3,33,121,0,'0.00',0),
 (8977,3,34,121,1,'0.65',0),
 (8978,3,35,121,0,'0.00',0),
 (8979,3,36,121,0,'0.00',0),
 (8980,3,37,121,0,'0.00',0),
 (8981,3,1,122,216,'62.25',0),
 (8982,3,2,122,103,'29.68',0),
 (8983,3,4,122,0,'0.00',0),
 (8984,3,12,122,12,'3.46',0),
 (8985,3,14,122,0,'0.00',0),
 (8986,3,15,122,0,'0.00',0),
 (8987,3,16,122,0,'0.00',0),
 (8988,3,17,122,2,'0.58',0),
 (8989,3,26,122,0,'0.00',0),
 (8990,3,27,122,0,'0.00',0),
 (8991,3,28,122,0,'0.00',0),
 (8992,3,29,122,0,'0.00',0),
 (8993,3,30,122,0,'0.00',0),
 (8994,3,31,122,11,'3.17',0),
 (8995,3,32,122,0,'0.00',0),
 (8996,3,33,122,0,'0.00',0),
 (8997,3,34,122,0,'0.00',0),
 (8998,3,35,122,0,'0.00',0),
 (8999,3,36,122,0,'0.00',0),
 (9000,3,37,122,0,'0.00',0),
 (9001,3,1,123,10361,'36.10',0),
 (9002,3,2,123,10974,'38.23',0),
 (9003,3,4,123,18,'0.06',0),
 (9004,3,12,123,6120,'21.32',0),
 (9005,3,14,123,12,'0.04',0),
 (9006,3,15,123,35,'0.12',0),
 (9007,3,16,123,19,'0.07',0),
 (9008,3,17,123,70,'0.24',0),
 (9009,3,26,123,83,'0.29',0),
 (9010,3,27,123,5,'0.02',0),
 (9011,3,28,123,20,'0.07',0),
 (9012,3,29,123,0,'0.00',0),
 (9013,3,30,123,0,'0.00',0),
 (9014,3,31,123,323,'1.13',0),
 (9015,3,32,123,12,'0.04',0),
 (9016,3,33,123,19,'0.07',0),
 (9017,3,34,123,16,'0.06',0),
 (9018,3,35,123,1,'0.00',0),
 (9019,3,36,123,16,'0.06',0),
 (9020,3,37,123,18,'0.06',0),
 (9021,3,1,124,69,'61.61',0),
 (9022,3,2,124,30,'26.79',0),
 (9023,3,4,124,0,'0.00',0),
 (9024,3,12,124,10,'8.93',0),
 (9025,3,14,124,0,'0.00',0),
 (9026,3,15,124,0,'0.00',0),
 (9027,3,16,124,0,'0.00',0),
 (9028,3,17,124,0,'0.00',0),
 (9029,3,26,124,0,'0.00',0),
 (9030,3,27,124,0,'0.00',0),
 (9031,3,28,124,0,'0.00',0),
 (9032,3,29,124,0,'0.00',0),
 (9033,3,30,124,0,'0.00',0),
 (9034,3,31,124,1,'0.89',0),
 (9035,3,32,124,0,'0.00',0),
 (9036,3,33,124,0,'0.00',0),
 (9037,3,34,124,0,'0.00',0),
 (9038,3,35,124,0,'0.00',0),
 (9039,3,36,124,0,'0.00',0),
 (9040,3,37,124,0,'0.00',0),
 (9041,3,1,125,1278,'65.98',0),
 (9042,3,2,125,497,'25.66',0),
 (9043,3,4,125,1,'0.05',0),
 (9044,3,12,125,122,'6.30',0),
 (9045,3,14,125,0,'0.00',0),
 (9046,3,15,125,0,'0.00',0),
 (9047,3,16,125,3,'0.15',0),
 (9048,3,17,125,5,'0.26',0),
 (9049,3,26,125,0,'0.00',0),
 (9050,3,27,125,2,'0.10',0),
 (9051,3,28,125,2,'0.10',0),
 (9052,3,29,125,0,'0.00',0),
 (9053,3,30,125,0,'0.00',0),
 (9054,3,31,125,11,'0.57',0),
 (9055,3,32,125,1,'0.05',0),
 (9056,3,33,125,0,'0.00',0),
 (9057,3,34,125,0,'0.00',0),
 (9058,3,35,125,0,'0.00',0),
 (9059,3,36,125,1,'0.05',0),
 (9060,3,37,125,0,'0.00',0),
 (9061,3,1,126,25,'50.00',0),
 (9062,3,2,126,23,'46.00',0),
 (9063,3,4,126,0,'0.00',0),
 (9064,3,12,126,1,'2.00',0),
 (9065,3,14,126,0,'0.00',0),
 (9066,3,15,126,0,'0.00',0),
 (9067,3,16,126,0,'0.00',0),
 (9068,3,17,126,0,'0.00',0),
 (9069,3,26,126,0,'0.00',0),
 (9070,3,27,126,0,'0.00',0),
 (9071,3,28,126,0,'0.00',0),
 (9072,3,29,126,0,'0.00',0),
 (9073,3,30,126,0,'0.00',0),
 (9074,3,31,126,0,'0.00',0),
 (9075,3,32,126,0,'0.00',0),
 (9076,3,33,126,0,'0.00',0),
 (9077,3,34,126,0,'0.00',0),
 (9078,3,35,126,0,'0.00',0),
 (9079,3,36,126,0,'0.00',0),
 (9080,3,37,126,0,'0.00',0),
 (9081,3,1,127,26776,'67.46',0),
 (9082,3,2,127,8846,'22.29',0),
 (9083,3,4,127,99,'0.25',0),
 (9084,3,12,127,2313,'5.83',0),
 (9085,3,14,127,13,'0.03',0),
 (9086,3,15,127,19,'0.05',0),
 (9087,3,16,127,26,'0.07',0),
 (9088,3,17,127,87,'0.22',0),
 (9089,3,26,127,18,'0.05',0),
 (9090,3,27,127,15,'0.04',0),
 (9091,3,28,127,30,'0.08',0),
 (9092,3,29,127,0,'0.00',0),
 (9093,3,30,127,7,'0.02',0),
 (9094,3,31,127,527,'1.33',0),
 (9095,3,32,127,21,'0.05',0),
 (9096,3,33,127,46,'0.12',0),
 (9097,3,34,127,12,'0.03',0),
 (9098,3,35,127,6,'0.02',0),
 (9099,3,36,127,28,'0.07',0),
 (9100,3,37,127,18,'0.05',0),
 (9101,3,1,128,146,'54.89',0),
 (9102,3,2,128,82,'30.83',0),
 (9103,3,4,128,2,'0.75',0),
 (9104,3,12,128,31,'11.65',0),
 (9105,3,14,128,0,'0.00',0),
 (9106,3,15,128,0,'0.00',0),
 (9107,3,16,128,2,'0.75',0),
 (9108,3,17,128,0,'0.00',0),
 (9109,3,26,128,0,'0.00',0),
 (9110,3,27,128,0,'0.00',0),
 (9111,3,28,128,0,'0.00',0),
 (9112,3,29,128,0,'0.00',0),
 (9113,3,30,128,0,'0.00',0),
 (9114,3,31,128,0,'0.00',0),
 (9115,3,32,128,1,'0.38',0),
 (9116,3,33,128,0,'0.00',0),
 (9117,3,34,128,0,'0.00',0),
 (9118,3,35,128,0,'0.00',0),
 (9119,3,36,128,0,'0.00',0),
 (9120,3,37,128,0,'0.00',0),
 (9121,3,1,129,2491,'60.86',0),
 (9122,3,2,129,1172,'28.63',0),
 (9123,3,4,129,1,'0.02',0),
 (9124,3,12,129,254,'6.21',0),
 (9125,3,14,129,7,'0.17',0),
 (9126,3,15,129,5,'0.12',0),
 (9127,3,16,129,8,'0.20',0),
 (9128,3,17,129,12,'0.29',0),
 (9129,3,26,129,0,'0.00',0),
 (9130,3,27,129,2,'0.05',0),
 (9131,3,28,129,1,'0.02',0),
 (9132,3,29,129,0,'0.00',0),
 (9133,3,30,129,0,'0.00',0),
 (9134,3,31,129,46,'1.12',0),
 (9135,3,32,129,1,'0.02',0),
 (9136,3,33,129,6,'0.15',0),
 (9137,3,34,129,0,'0.00',0),
 (9138,3,35,129,1,'0.02',0),
 (9139,3,36,129,4,'0.10',0),
 (9140,3,37,129,3,'0.07',0),
 (9141,3,1,130,7786,'42.83',0),
 (9142,3,2,130,6627,'36.46',0),
 (9143,3,4,130,16,'0.09',0),
 (9144,3,12,130,3095,'17.03',0),
 (9145,3,14,130,10,'0.06',0),
 (9146,3,15,130,15,'0.08',0),
 (9147,3,16,130,16,'0.09',0),
 (9148,3,17,130,53,'0.29',0),
 (9149,3,26,130,5,'0.03',0),
 (9150,3,27,130,9,'0.05',0),
 (9151,3,28,130,11,'0.06',0),
 (9152,3,29,130,0,'0.00',0),
 (9153,3,30,130,1,'0.01',0),
 (9154,3,31,130,190,'1.05',0),
 (9155,3,32,130,6,'0.03',0),
 (9156,3,33,130,19,'0.10',0),
 (9157,3,34,130,9,'0.05',0),
 (9158,3,35,130,1,'0.01',0),
 (9159,3,36,130,68,'0.37',0),
 (9160,3,37,130,7,'0.04',0),
 (9161,3,1,131,4641,'58.20',0),
 (9162,3,2,131,2321,'29.11',0),
 (9163,3,4,131,20,'0.25',0),
 (9164,3,12,131,637,'7.99',0),
 (9165,3,14,131,3,'0.04',0),
 (9166,3,15,131,7,'0.09',0),
 (9167,3,16,131,14,'0.18',0),
 (9168,3,17,131,16,'0.20',0),
 (9169,3,26,131,2,'0.03',0),
 (9170,3,27,131,2,'0.03',0),
 (9171,3,28,131,16,'0.20',0),
 (9172,3,29,131,0,'0.00',0),
 (9173,3,30,131,1,'0.01',0),
 (9174,3,31,131,117,'1.47',0),
 (9175,3,32,131,5,'0.06',0),
 (9176,3,33,131,10,'0.13',0),
 (9177,3,34,131,1,'0.01',0),
 (9178,3,35,131,3,'0.04',0),
 (9179,3,36,131,2,'0.03',0),
 (9180,3,37,131,12,'0.15',0),
 (9181,3,1,132,3425,'51.30',0),
 (9182,3,2,132,2610,'39.09',0),
 (9183,3,4,132,1,'0.01',0),
 (9184,3,12,132,433,'6.48',0),
 (9185,3,14,132,1,'0.01',0),
 (9186,3,15,132,15,'0.22',0),
 (9187,3,16,132,2,'0.03',0),
 (9188,3,17,132,12,'0.18',0),
 (9189,3,26,132,0,'0.00',0),
 (9190,3,27,132,1,'0.01',0),
 (9191,3,28,132,10,'0.15',0),
 (9192,3,29,132,0,'0.00',0),
 (9193,3,30,132,0,'0.00',0),
 (9194,3,31,132,70,'1.05',0),
 (9195,3,32,132,3,'0.04',0),
 (9196,3,33,132,2,'0.03',0),
 (9197,3,34,132,1,'0.01',0),
 (9198,3,35,132,0,'0.00',0),
 (9199,3,36,132,10,'0.15',0),
 (9200,3,37,132,3,'0.04',0),
 (9201,3,1,133,2180,'54.11',0),
 (9202,3,2,133,1528,'37.93',0),
 (9203,3,4,133,4,'0.10',0),
 (9204,3,12,133,223,'5.53',0),
 (9205,3,14,133,1,'0.02',0),
 (9206,3,15,133,3,'0.07',0),
 (9207,3,16,133,5,'0.12',0),
 (9208,3,17,133,5,'0.12',0),
 (9209,3,26,133,1,'0.02',0),
 (9210,3,27,133,1,'0.02',0),
 (9211,3,28,133,4,'0.10',0),
 (9212,3,29,133,0,'0.00',0),
 (9213,3,30,133,2,'0.05',0),
 (9214,3,31,133,15,'0.37',0),
 (9215,3,32,133,0,'0.00',0),
 (9216,3,33,133,1,'0.02',0),
 (9217,3,34,133,0,'0.00',0),
 (9218,3,35,133,0,'0.00',0),
 (9219,3,36,133,3,'0.07',0),
 (9220,3,37,133,9,'0.22',0),
 (9221,3,1,134,16916,'51.85',0),
 (9222,3,2,134,11322,'34.70',0),
 (9223,3,4,134,29,'0.09',0),
 (9224,3,12,134,2917,'8.94',0),
 (9225,3,14,134,30,'0.09',0),
 (9226,3,15,134,78,'0.24',0),
 (9227,3,16,134,30,'0.09',0),
 (9228,3,17,134,67,'0.21',0),
 (9229,3,26,134,9,'0.03',0),
 (9230,3,27,134,17,'0.05',0),
 (9231,3,28,134,32,'0.10',0),
 (9232,3,29,134,0,'0.00',0),
 (9233,3,30,134,4,'0.01',0),
 (9234,3,31,134,464,'1.42',0),
 (9235,3,32,134,20,'0.06',0),
 (9236,3,33,134,47,'0.14',0),
 (9237,3,34,134,23,'0.07',0),
 (9238,3,35,134,4,'0.01',0),
 (9239,3,36,134,34,'0.10',0),
 (9240,3,37,134,21,'0.06',0),
 (9241,3,1,135,413,'58.25',0),
 (9242,3,2,135,187,'26.38',0),
 (9243,3,4,135,1,'0.14',0),
 (9244,3,12,135,64,'9.03',0),
 (9245,3,14,135,2,'0.28',0),
 (9246,3,15,135,1,'0.14',0),
 (9247,3,16,135,1,'0.14',0),
 (9248,3,17,135,7,'0.99',0),
 (9249,3,26,135,0,'0.00',0),
 (9250,3,27,135,0,'0.00',0),
 (9251,3,28,135,3,'0.42',0),
 (9252,3,29,135,0,'0.00',0),
 (9253,3,30,135,0,'0.00',0),
 (9254,3,31,135,11,'1.55',0),
 (9255,3,32,135,2,'0.28',0),
 (9256,3,33,135,2,'0.28',0),
 (9257,3,34,135,2,'0.28',0),
 (9258,3,35,135,0,'0.00',0),
 (9259,3,36,135,0,'0.00',0),
 (9260,3,37,135,0,'0.00',0),
 (9261,3,1,136,302,'58.41',0),
 (9262,3,2,136,171,'33.08',0),
 (9263,3,4,136,1,'0.19',0),
 (9264,3,12,136,27,'5.22',0),
 (9265,3,14,136,0,'0.00',0),
 (9266,3,15,136,0,'0.00',0),
 (9267,3,16,136,0,'0.00',0),
 (9268,3,17,136,0,'0.00',0),
 (9269,3,26,136,0,'0.00',0),
 (9270,3,27,136,0,'0.00',0),
 (9271,3,28,136,0,'0.00',0),
 (9272,3,29,136,0,'0.00',0),
 (9273,3,30,136,0,'0.00',0),
 (9274,3,31,136,2,'0.39',0),
 (9275,3,32,136,0,'0.00',0),
 (9276,3,33,136,1,'0.19',0),
 (9277,3,34,136,1,'0.19',0),
 (9278,3,35,136,0,'0.00',0),
 (9279,3,36,136,9,'1.74',0),
 (9280,3,37,136,0,'0.00',0),
 (9281,3,1,137,565,'52.27',0),
 (9282,3,2,137,425,'39.32',0),
 (9283,3,4,137,0,'0.00',0),
 (9284,3,12,137,47,'4.35',0),
 (9285,3,14,137,0,'0.00',0),
 (9286,3,15,137,0,'0.00',0),
 (9287,3,16,137,1,'0.09',0),
 (9288,3,17,137,1,'0.09',0),
 (9289,3,26,137,0,'0.00',0),
 (9290,3,27,137,0,'0.00',0),
 (9291,3,28,137,0,'0.00',0),
 (9292,3,29,137,0,'0.00',0),
 (9293,3,30,137,0,'0.00',0),
 (9294,3,31,137,13,'1.20',0),
 (9295,3,32,137,0,'0.00',0),
 (9296,3,33,137,0,'0.00',0),
 (9297,3,34,137,0,'0.00',0),
 (9298,3,35,137,0,'0.00',0),
 (9299,3,36,137,9,'0.83',0),
 (9300,3,37,137,0,'0.00',0),
 (9301,3,1,138,46,'58.97',0),
 (9302,3,2,138,24,'30.77',0),
 (9303,3,4,138,0,'0.00',0),
 (9304,3,12,138,4,'5.13',0),
 (9305,3,14,138,0,'0.00',0),
 (9306,3,15,138,0,'0.00',0),
 (9307,3,16,138,0,'0.00',0),
 (9308,3,17,138,0,'0.00',0),
 (9309,3,26,138,0,'0.00',0),
 (9310,3,27,138,0,'0.00',0),
 (9311,3,28,138,0,'0.00',0),
 (9312,3,29,138,0,'0.00',0),
 (9313,3,30,138,0,'0.00',0),
 (9314,3,31,138,0,'0.00',0),
 (9315,3,32,138,0,'0.00',0),
 (9316,3,33,138,0,'0.00',0),
 (9317,3,34,138,0,'0.00',0),
 (9318,3,35,138,0,'0.00',0),
 (9319,3,36,138,0,'0.00',0),
 (9320,3,37,138,1,'1.28',0),
 (9321,3,1,140,1048,'61.18',0),
 (9322,3,2,140,524,'30.59',0),
 (9323,3,4,140,5,'0.29',0),
 (9324,3,12,140,80,'4.67',0),
 (9325,3,14,140,0,'0.00',0),
 (9326,3,15,140,3,'0.18',0),
 (9327,3,16,140,3,'0.18',0),
 (9328,3,17,140,1,'0.06',0),
 (9329,3,26,140,0,'0.00',0),
 (9330,3,27,140,0,'0.00',0),
 (9331,3,28,140,4,'0.23',0),
 (9332,3,29,140,0,'0.00',0),
 (9333,3,30,140,0,'0.00',0),
 (9334,3,31,140,18,'1.05',0),
 (9335,3,32,140,0,'0.00',0),
 (9336,3,33,140,4,'0.23',0),
 (9337,3,34,140,0,'0.00',0),
 (9338,3,35,140,0,'0.00',0),
 (9339,3,36,140,1,'0.06',0),
 (9340,3,37,140,3,'0.18',0),
 (9341,3,1,141,2040,'62.90',0),
 (9342,3,2,141,855,'26.36',0),
 (9343,3,4,141,4,'0.12',0),
 (9344,3,12,141,217,'6.69',0),
 (9345,3,14,141,3,'0.09',0),
 (9346,3,15,141,2,'0.06',0),
 (9347,3,16,141,7,'0.22',0),
 (9348,3,17,141,3,'0.09',0),
 (9349,3,26,141,0,'0.00',0),
 (9350,3,27,141,1,'0.03',0),
 (9351,3,28,141,3,'0.09',0),
 (9352,3,29,141,0,'0.00',0),
 (9353,3,30,141,1,'0.03',0),
 (9354,3,31,141,37,'1.14',0),
 (9355,3,32,141,3,'0.09',0),
 (9356,3,33,141,4,'0.12',0),
 (9357,3,34,141,3,'0.09',0),
 (9358,3,35,141,1,'0.03',0),
 (9359,3,36,141,0,'0.00',0),
 (9360,3,37,141,12,'0.37',0),
 (9361,3,1,143,46,'57.50',0),
 (9362,3,2,143,26,'32.50',0),
 (9363,3,4,143,1,'1.25',0),
 (9364,3,12,143,2,'2.50',0),
 (9365,3,14,143,0,'0.00',0),
 (9366,3,15,143,0,'0.00',0),
 (9367,3,16,143,0,'0.00',0),
 (9368,3,17,143,0,'0.00',0),
 (9369,3,26,143,0,'0.00',0),
 (9370,3,27,143,2,'2.50',0),
 (9371,3,28,143,0,'0.00',0),
 (9372,3,29,143,0,'0.00',0),
 (9373,3,30,143,0,'0.00',0),
 (9374,3,31,143,3,'3.75',0),
 (9375,3,32,143,0,'0.00',0),
 (9376,3,33,143,0,'0.00',0),
 (9377,3,34,143,0,'0.00',0),
 (9378,3,35,143,0,'0.00',0),
 (9379,3,36,143,0,'0.00',0),
 (9380,3,37,143,0,'0.00',0),
 (9381,3,1,144,2378,'58.51',0),
 (9382,3,2,144,1209,'29.75',0),
 (9383,3,4,144,7,'0.17',0),
 (9384,3,12,144,281,'6.91',0),
 (9385,3,14,144,3,'0.07',0),
 (9386,3,15,144,4,'0.10',0),
 (9387,3,16,144,7,'0.17',0),
 (9388,3,17,144,18,'0.44',0),
 (9389,3,26,144,0,'0.00',0),
 (9390,3,27,144,1,'0.02',0),
 (9391,3,28,144,6,'0.15',0),
 (9392,3,29,144,0,'0.00',0),
 (9393,3,30,144,0,'0.00',0),
 (9394,3,31,144,64,'1.57',0),
 (9395,3,32,144,2,'0.05',0),
 (9396,3,33,144,6,'0.15',0),
 (9397,3,34,144,1,'0.02',0),
 (9398,3,35,144,1,'0.02',0),
 (9399,3,36,144,5,'0.12',0),
 (9400,3,37,144,3,'0.07',0),
 (9401,3,1,145,533,'47.04',0),
 (9402,3,2,145,460,'40.60',0),
 (9403,3,4,145,1,'0.09',0),
 (9404,3,12,145,94,'8.30',0),
 (9405,3,14,145,1,'0.09',0),
 (9406,3,15,145,1,'0.09',0),
 (9407,3,16,145,1,'0.09',0),
 (9408,3,17,145,4,'0.35',0),
 (9409,3,26,145,0,'0.00',0),
 (9410,3,27,145,9,'0.79',0),
 (9411,3,28,145,1,'0.09',0),
 (9412,3,29,145,0,'0.00',0),
 (9413,3,30,145,0,'0.00',0),
 (9414,3,31,145,11,'0.97',0),
 (9415,3,32,145,0,'0.00',0),
 (9416,3,33,145,2,'0.18',0),
 (9417,3,34,145,0,'0.00',0),
 (9418,3,35,145,0,'0.00',0),
 (9419,3,36,145,4,'0.35',0),
 (9420,3,37,145,0,'0.00',0),
 (9421,3,1,146,670,'55.79',0),
 (9422,3,2,146,472,'39.30',0),
 (9423,3,4,146,1,'0.08',0),
 (9424,3,12,146,46,'3.83',0),
 (9425,3,14,146,0,'0.00',0),
 (9426,3,15,146,0,'0.00',0),
 (9427,3,16,146,0,'0.00',0),
 (9428,3,17,146,0,'0.00',0),
 (9429,3,26,146,1,'0.08',0),
 (9430,3,27,146,1,'0.08',0),
 (9431,3,28,146,1,'0.08',0),
 (9432,3,29,146,0,'0.00',0),
 (9433,3,30,146,0,'0.00',0),
 (9434,3,31,146,0,'0.00',0),
 (9435,3,32,146,0,'0.00',0),
 (9436,3,33,146,0,'0.00',0),
 (9437,3,34,146,0,'0.00',0),
 (9438,3,35,146,0,'0.00',0),
 (9439,3,36,146,0,'0.00',0),
 (9440,3,37,146,0,'0.00',0),
 (9441,3,1,147,364,'55.66',0),
 (9442,3,2,147,235,'35.93',0),
 (9443,3,4,147,0,'0.00',0),
 (9444,3,12,147,36,'5.50',0),
 (9445,3,14,147,0,'0.00',0),
 (9446,3,15,147,1,'0.15',0),
 (9447,3,16,147,1,'0.15',0),
 (9448,3,17,147,0,'0.00',0),
 (9449,3,26,147,0,'0.00',0),
 (9450,3,27,147,0,'0.00',0),
 (9451,3,28,147,1,'0.15',0),
 (9452,3,29,147,0,'0.00',0),
 (9453,3,30,147,4,'0.61',0),
 (9454,3,31,147,3,'0.46',0),
 (9455,3,32,147,0,'0.00',0),
 (9456,3,33,147,0,'0.00',0),
 (9457,3,34,147,0,'0.00',0),
 (9458,3,35,147,0,'0.00',0),
 (9459,3,36,147,1,'0.15',0),
 (9460,3,37,147,0,'0.00',0),
 (9461,3,1,148,23620,'48.56',0),
 (9462,3,2,148,18696,'38.44',0),
 (9463,3,4,148,29,'0.06',0),
 (9464,3,12,148,3507,'7.21',0),
 (9465,3,14,148,21,'0.04',0),
 (9466,3,15,148,61,'0.13',0),
 (9467,3,16,148,65,'0.13',0),
 (9468,3,17,148,100,'0.21',0),
 (9469,3,26,148,22,'0.05',0),
 (9470,3,27,148,37,'0.08',0),
 (9471,3,28,148,61,'0.13',0),
 (9472,3,29,148,0,'0.00',0),
 (9473,3,30,148,6,'0.01',0),
 (9474,3,31,148,687,'1.41',0),
 (9475,3,32,148,619,'1.27',0),
 (9476,3,33,148,209,'0.43',0),
 (9477,3,34,148,17,'0.03',0),
 (9478,3,35,148,10,'0.02',0),
 (9479,3,36,148,115,'0.24',0),
 (9480,3,37,148,14,'0.03',0),
 (9481,3,1,149,1844,'58.43',0),
 (9482,3,2,149,1011,'32.03',0),
 (9483,3,4,149,3,'0.10',0),
 (9484,3,12,149,179,'5.67',0),
 (9485,3,14,149,0,'0.00',0),
 (9486,3,15,149,3,'0.10',0),
 (9487,3,16,149,4,'0.13',0),
 (9488,3,17,149,8,'0.25',0),
 (9489,3,26,149,0,'0.00',0),
 (9490,3,27,149,0,'0.00',0),
 (9491,3,28,149,4,'0.13',0),
 (9492,3,29,149,0,'0.00',0),
 (9493,3,30,149,0,'0.00',0),
 (9494,3,31,149,41,'1.30',0),
 (9495,3,32,149,3,'0.10',0),
 (9496,3,33,149,6,'0.19',0),
 (9497,3,34,149,1,'0.03',0),
 (9498,3,35,149,1,'0.03',0),
 (9499,3,36,149,1,'0.03',0),
 (9500,3,37,149,1,'0.03',0),
 (9501,3,1,150,1330,'62.53',0),
 (9502,3,2,150,561,'26.38',0),
 (9503,3,4,150,1,'0.05',0),
 (9504,3,12,150,179,'8.42',0),
 (9505,3,14,150,1,'0.05',0),
 (9506,3,15,150,5,'0.24',0),
 (9507,3,16,150,1,'0.05',0),
 (9508,3,17,150,3,'0.14',0),
 (9509,3,26,150,0,'0.00',0),
 (9510,3,27,150,0,'0.00',0),
 (9511,3,28,150,1,'0.05',0),
 (9512,3,29,150,0,'0.00',0),
 (9513,3,30,150,0,'0.00',0),
 (9514,3,31,150,9,'0.42',0),
 (9515,3,32,150,1,'0.05',0),
 (9516,3,33,150,2,'0.09',0),
 (9517,3,34,150,2,'0.09',0),
 (9518,3,35,150,0,'0.00',0),
 (9519,3,36,150,5,'0.24',0),
 (9520,3,37,150,0,'0.00',0),
 (9521,3,1,151,1103,'52.83',0),
 (9522,3,2,151,792,'37.93',0),
 (9523,3,4,151,1,'0.05',0),
 (9524,3,12,151,127,'6.08',0),
 (9525,3,14,151,0,'0.00',0),
 (9526,3,15,151,0,'0.00',0),
 (9527,3,16,151,4,'0.19',0),
 (9528,3,17,151,4,'0.19',0),
 (9529,3,26,151,1,'0.05',0),
 (9530,3,27,151,4,'0.19',0),
 (9531,3,28,151,0,'0.00',0),
 (9532,3,29,151,0,'0.00',0),
 (9533,3,30,151,0,'0.00',0),
 (9534,3,31,151,21,'1.01',0),
 (9535,3,32,151,0,'0.00',0),
 (9536,3,33,151,1,'0.05',0),
 (9537,3,34,151,2,'0.10',0),
 (9538,3,35,151,1,'0.05',0),
 (9539,3,36,151,0,'0.00',0),
 (9540,3,37,151,1,'0.05',0),
 (9541,3,1,152,6529,'64.82',0),
 (9542,3,2,152,2278,'22.61',0),
 (9543,3,4,152,33,'0.33',0),
 (9544,3,12,152,731,'7.26',0),
 (9545,3,14,152,7,'0.07',0),
 (9546,3,15,152,6,'0.06',0),
 (9547,3,16,152,6,'0.06',0),
 (9548,3,17,152,35,'0.35',0),
 (9549,3,26,152,1,'0.01',0),
 (9550,3,27,152,6,'0.06',0),
 (9551,3,28,152,5,'0.05',0),
 (9552,3,29,152,0,'0.00',0),
 (9553,3,30,152,2,'0.02',0),
 (9554,3,31,152,173,'1.72',0),
 (9555,3,32,152,5,'0.05',0),
 (9556,3,33,152,21,'0.21',0),
 (9557,3,34,152,5,'0.05',0),
 (9558,3,35,152,2,'0.02',0),
 (9559,3,36,152,9,'0.09',0),
 (9560,3,37,152,11,'0.11',0),
 (9561,3,1,153,190,'47.86',0),
 (9562,3,2,153,134,'33.75',0),
 (9563,3,4,153,0,'0.00',0),
 (9564,3,12,153,58,'14.61',0),
 (9565,3,14,153,1,'0.25',0),
 (9566,3,15,153,0,'0.00',0),
 (9567,3,16,153,1,'0.25',0),
 (9568,3,17,153,0,'0.00',0),
 (9569,3,26,153,0,'0.00',0),
 (9570,3,27,153,0,'0.00',0),
 (9571,3,28,153,0,'0.00',0),
 (9572,3,29,153,0,'0.00',0),
 (9573,3,30,153,0,'0.00',0),
 (9574,3,31,153,3,'0.76',0),
 (9575,3,32,153,0,'0.00',0),
 (9576,3,33,153,0,'0.00',0),
 (9577,3,34,153,0,'0.00',0),
 (9578,3,35,153,0,'0.00',0),
 (9579,3,36,153,0,'0.00',0),
 (9580,3,37,153,0,'0.00',0),
 (9581,3,1,154,1814,'51.95',0),
 (9582,3,2,154,1369,'39.20',0),
 (9583,3,4,154,1,'0.03',0),
 (9584,3,12,154,180,'5.15',0),
 (9585,3,14,154,1,'0.03',0),
 (9586,3,15,154,5,'0.14',0),
 (9587,3,16,154,4,'0.11',0),
 (9588,3,17,154,10,'0.29',0),
 (9589,3,26,154,0,'0.00',0),
 (9590,3,27,154,2,'0.06',0),
 (9591,3,28,154,2,'0.06',0),
 (9592,3,29,154,0,'0.00',0),
 (9593,3,30,154,0,'0.00',0),
 (9594,3,31,154,45,'1.29',0),
 (9595,3,32,154,2,'0.06',0),
 (9596,3,33,154,1,'0.03',0),
 (9597,3,34,154,1,'0.03',0),
 (9598,3,35,154,0,'0.00',0),
 (9599,3,36,154,7,'0.20',0),
 (9600,3,37,154,2,'0.06',0),
 (9601,3,1,155,226,'49.78',0),
 (9602,3,2,155,197,'43.39',0),
 (9603,3,4,155,0,'0.00',0),
 (9604,3,12,155,27,'5.95',0),
 (9605,3,14,155,0,'0.00',0),
 (9606,3,15,155,0,'0.00',0),
 (9607,3,16,155,0,'0.00',0),
 (9608,3,17,155,0,'0.00',0),
 (9609,3,26,155,0,'0.00',0),
 (9610,3,27,155,0,'0.00',0),
 (9611,3,28,155,0,'0.00',0),
 (9612,3,29,155,0,'0.00',0),
 (9613,3,30,155,0,'0.00',0),
 (9614,3,31,155,1,'0.22',0),
 (9615,3,32,155,0,'0.00',0),
 (9616,3,33,155,0,'0.00',0),
 (9617,3,34,155,0,'0.00',0),
 (9618,3,35,155,0,'0.00',0),
 (9619,3,36,155,0,'0.00',0),
 (9620,3,37,155,0,'0.00',0),
 (9621,3,1,156,312,'54.83',0),
 (9622,3,2,156,210,'36.91',0),
 (9623,3,4,156,0,'0.00',0),
 (9624,3,12,156,38,'6.68',0),
 (9625,3,14,156,0,'0.00',0),
 (9626,3,15,156,0,'0.00',0),
 (9627,3,16,156,1,'0.18',0),
 (9628,3,17,156,1,'0.18',0),
 (9629,3,26,156,0,'0.00',0),
 (9630,3,27,156,0,'0.00',0),
 (9631,3,28,156,1,'0.18',0),
 (9632,3,29,156,0,'0.00',0),
 (9633,3,30,156,0,'0.00',0),
 (9634,3,31,156,3,'0.53',0),
 (9635,3,32,156,0,'0.00',0),
 (9636,3,33,156,0,'0.00',0),
 (9637,3,34,156,1,'0.18',0),
 (9638,3,35,156,1,'0.18',0),
 (9639,3,36,156,1,'0.18',0),
 (9640,3,37,156,0,'0.00',0),
 (9641,3,1,157,300,'67.26',0),
 (9642,3,2,157,108,'24.22',0),
 (9643,3,4,157,1,'0.22',0),
 (9644,3,12,157,22,'4.93',0),
 (9645,3,14,157,0,'0.00',0),
 (9646,3,15,157,1,'0.22',0),
 (9647,3,16,157,1,'0.22',0),
 (9648,3,17,157,0,'0.00',0),
 (9649,3,26,157,0,'0.00',0),
 (9650,3,27,157,2,'0.45',0),
 (9651,3,28,157,0,'0.00',0),
 (9652,3,29,157,0,'0.00',0),
 (9653,3,30,157,0,'0.00',0),
 (9654,3,31,157,2,'0.45',0),
 (9655,3,32,157,0,'0.00',0),
 (9656,3,33,157,2,'0.45',0),
 (9657,3,34,157,0,'0.00',0),
 (9658,3,35,157,0,'0.00',0),
 (9659,3,36,157,1,'0.22',0),
 (9660,3,37,157,0,'0.00',0),
 (9661,3,1,158,351,'69.09',0),
 (9662,3,2,158,109,'21.46',0),
 (9663,3,4,158,0,'0.00',0),
 (9664,3,12,158,28,'5.51',0),
 (9665,3,14,158,0,'0.00',0),
 (9666,3,15,158,0,'0.00',0),
 (9667,3,16,158,0,'0.00',0),
 (9668,3,17,158,0,'0.00',0),
 (9669,3,26,158,0,'0.00',0),
 (9670,3,27,158,0,'0.00',0),
 (9671,3,28,158,4,'0.79',0),
 (9672,3,29,158,0,'0.00',0),
 (9673,3,30,158,0,'0.00',0),
 (9674,3,31,158,5,'0.98',0),
 (9675,3,32,158,0,'0.00',0),
 (9676,3,33,158,1,'0.20',0),
 (9677,3,34,158,0,'0.00',0),
 (9678,3,35,158,0,'0.00',0),
 (9679,3,36,158,0,'0.00',0),
 (9680,3,37,158,1,'0.20',0),
 (9681,3,1,159,315,'57.80',0),
 (9682,3,2,159,197,'36.15',0),
 (9683,3,4,159,0,'0.00',0),
 (9684,3,12,159,21,'3.85',0),
 (9685,3,14,159,0,'0.00',0),
 (9686,3,15,159,0,'0.00',0),
 (9687,3,16,159,4,'0.73',0),
 (9688,3,17,159,0,'0.00',0),
 (9689,3,26,159,0,'0.00',0),
 (9690,3,27,159,0,'0.00',0),
 (9691,3,28,159,0,'0.00',0),
 (9692,3,29,159,0,'0.00',0),
 (9693,3,30,159,0,'0.00',0),
 (9694,3,31,159,0,'0.00',0),
 (9695,3,32,159,0,'0.00',0),
 (9696,3,33,159,0,'0.00',0),
 (9697,3,34,159,0,'0.00',0),
 (9698,3,35,159,0,'0.00',0),
 (9699,3,36,159,0,'0.00',0),
 (9700,3,37,159,0,'0.00',0),
 (9701,3,1,160,2955,'60.58',0),
 (9702,3,2,160,1349,'27.65',0),
 (9703,3,4,160,7,'0.14',0),
 (9704,3,12,160,345,'7.07',0),
 (9705,3,14,160,3,'0.06',0),
 (9706,3,15,160,2,'0.04',0),
 (9707,3,16,160,8,'0.16',0),
 (9708,3,17,160,18,'0.37',0),
 (9709,3,26,160,1,'0.02',0),
 (9710,3,27,160,0,'0.00',0),
 (9711,3,28,160,9,'0.18',0),
 (9712,3,29,160,0,'0.00',0),
 (9713,3,30,160,1,'0.02',0),
 (9714,3,31,160,79,'1.62',0),
 (9715,3,32,160,0,'0.00',0),
 (9716,3,33,160,5,'0.10',0),
 (9717,3,34,160,5,'0.10',0),
 (9718,3,35,160,0,'0.00',0),
 (9719,3,36,160,2,'0.04',0),
 (9720,3,37,160,5,'0.10',0),
 (9721,3,1,161,14335,'60.87',0),
 (9722,3,2,161,6251,'26.54',0),
 (9723,3,4,161,25,'0.11',0),
 (9724,3,12,161,1866,'7.92',0),
 (9725,3,14,161,12,'0.05',0),
 (9726,3,15,161,35,'0.15',0),
 (9727,3,16,161,41,'0.17',0),
 (9728,3,17,161,60,'0.25',0),
 (9729,3,26,161,11,'0.05',0),
 (9730,3,27,161,5,'0.02',0),
 (9731,3,28,161,26,'0.11',0),
 (9732,3,29,161,0,'0.00',0),
 (9733,3,30,161,6,'0.03',0),
 (9734,3,31,161,292,'1.24',0),
 (9735,3,32,161,21,'0.09',0),
 (9736,3,33,161,38,'0.16',0),
 (9737,3,34,161,11,'0.05',0),
 (9738,3,35,161,5,'0.02',0),
 (9739,3,36,161,51,'0.22',0),
 (9740,3,37,161,13,'0.06',0),
 (9741,3,1,162,928,'65.96',0),
 (9742,3,2,162,356,'25.30',0),
 (9743,3,4,162,0,'0.00',0),
 (9744,3,12,162,70,'4.98',0),
 (9745,3,14,162,0,'0.00',0),
 (9746,3,15,162,1,'0.07',0),
 (9747,3,16,162,0,'0.00',0),
 (9748,3,17,162,2,'0.14',0),
 (9749,3,26,162,1,'0.07',0),
 (9750,3,27,162,2,'0.14',0),
 (9751,3,28,162,2,'0.14',0),
 (9752,3,29,162,0,'0.00',0),
 (9753,3,30,162,0,'0.00',0),
 (9754,3,31,162,18,'1.28',0),
 (9755,3,32,162,0,'0.00',0),
 (9756,3,33,162,1,'0.07',0),
 (9757,3,34,162,1,'0.07',0),
 (9758,3,35,162,1,'0.07',0),
 (9759,3,36,162,3,'0.21',0),
 (9760,3,37,162,1,'0.07',0),
 (9761,3,1,163,129,'49.81',0),
 (9762,3,2,163,100,'38.61',0),
 (9763,3,4,163,0,'0.00',0),
 (9764,3,12,163,12,'4.63',0),
 (9765,3,14,163,0,'0.00',0),
 (9766,3,15,163,1,'0.39',0),
 (9767,3,16,163,1,'0.39',0),
 (9768,3,17,163,0,'0.00',0),
 (9769,3,26,163,0,'0.00',0),
 (9770,3,27,163,0,'0.00',0),
 (9771,3,28,163,1,'0.39',0),
 (9772,3,29,163,0,'0.00',0),
 (9773,3,30,163,0,'0.00',0),
 (9774,3,31,163,5,'1.93',0),
 (9775,3,32,163,0,'0.00',0),
 (9776,3,33,163,0,'0.00',0),
 (9777,3,34,163,0,'0.00',0),
 (9778,3,35,163,0,'0.00',0),
 (9779,3,36,163,0,'0.00',0),
 (9780,3,37,163,0,'0.00',0),
 (9781,3,1,164,1147,'60.05',0),
 (9782,3,2,164,562,'29.42',0),
 (9783,3,4,164,0,'0.00',0),
 (9784,3,12,164,126,'6.60',0),
 (9785,3,14,164,3,'0.16',0),
 (9786,3,15,164,4,'0.21',0),
 (9787,3,16,164,8,'0.42',0),
 (9788,3,17,164,9,'0.47',0),
 (9789,3,26,164,12,'0.63',0),
 (9790,3,27,164,2,'0.10',0),
 (9791,3,28,164,1,'0.05',0),
 (9792,3,29,164,0,'0.00',0),
 (9793,3,30,164,0,'0.00',0),
 (9794,3,31,164,6,'0.31',0),
 (9795,3,32,164,2,'0.10',0),
 (9796,3,33,164,0,'0.00',0),
 (9797,3,34,164,3,'0.16',0),
 (9798,3,35,164,0,'0.00',0),
 (9799,3,36,164,2,'0.10',0),
 (9800,3,37,164,2,'0.10',0),
 (9801,3,1,165,781,'60.17',0),
 (9802,3,2,165,461,'35.52',0),
 (9803,3,4,165,0,'0.00',0),
 (9804,3,12,165,20,'1.54',0),
 (9805,3,14,165,0,'0.00',0),
 (9806,3,15,165,0,'0.00',0),
 (9807,3,16,165,0,'0.00',0),
 (9808,3,17,165,3,'0.23',0),
 (9809,3,26,165,2,'0.15',0),
 (9810,3,27,165,0,'0.00',0),
 (9811,3,28,165,4,'0.31',0),
 (9812,3,29,165,0,'0.00',0),
 (9813,3,30,165,0,'0.00',0),
 (9814,3,31,165,3,'0.23',0),
 (9815,3,32,165,0,'0.00',0),
 (9816,3,33,165,0,'0.00',0),
 (9817,3,34,165,1,'0.08',0),
 (9818,3,35,165,1,'0.08',0),
 (9819,3,36,165,0,'0.00',0),
 (9820,3,37,165,1,'0.08',0),
 (9821,3,1,166,134,'49.81',0),
 (9822,3,2,166,110,'40.89',0),
 (9823,3,4,166,0,'0.00',0),
 (9824,3,12,166,14,'5.20',0),
 (9825,3,14,166,0,'0.00',0),
 (9826,3,15,166,0,'0.00',0),
 (9827,3,16,166,1,'0.37',0),
 (9828,3,17,166,1,'0.37',0),
 (9829,3,26,166,0,'0.00',0),
 (9830,3,27,166,0,'0.00',0),
 (9831,3,28,166,0,'0.00',0),
 (9832,3,29,166,0,'0.00',0),
 (9833,3,30,166,0,'0.00',0),
 (9834,3,31,166,2,'0.74',0),
 (9835,3,32,166,0,'0.00',0),
 (9836,3,33,166,0,'0.00',0),
 (9837,3,34,166,0,'0.00',0),
 (9838,3,35,166,0,'0.00',0),
 (9839,3,36,166,0,'0.00',0),
 (9840,3,37,166,0,'0.00',0),
 (9841,3,1,167,2164,'46.07',0),
 (9842,3,2,167,1860,'39.60',0),
 (9843,3,4,167,3,'0.06',0),
 (9844,3,12,167,493,'10.50',0),
 (9845,3,14,167,2,'0.04',0),
 (9846,3,15,167,2,'0.04',0),
 (9847,3,16,167,5,'0.11',0),
 (9848,3,17,167,5,'0.11',0),
 (9849,3,26,167,0,'0.00',0),
 (9850,3,27,167,2,'0.04',0),
 (9851,3,28,167,5,'0.11',0),
 (9852,3,29,167,0,'0.00',0),
 (9853,3,30,167,0,'0.00',0),
 (9854,3,31,167,58,'1.23',0),
 (9855,3,32,167,8,'0.17',0),
 (9856,3,33,167,11,'0.23',0),
 (9857,3,34,167,3,'0.06',0),
 (9858,3,35,167,2,'0.04',0),
 (9859,3,36,167,4,'0.09',0),
 (9860,3,37,167,0,'0.00',0),
 (9861,3,1,168,435,'57.24',0),
 (9862,3,2,168,264,'34.74',0),
 (9863,3,4,168,0,'0.00',0),
 (9864,3,12,168,38,'5.00',0),
 (9865,3,14,168,0,'0.00',0),
 (9866,3,15,168,1,'0.13',0),
 (9867,3,16,168,0,'0.00',0),
 (9868,3,17,168,2,'0.26',0),
 (9869,3,26,168,0,'0.00',0),
 (9870,3,27,168,1,'0.13',0),
 (9871,3,28,168,0,'0.00',0),
 (9872,3,29,168,0,'0.00',0),
 (9873,3,30,168,0,'0.00',0),
 (9874,3,31,168,1,'0.13',0),
 (9875,3,32,168,0,'0.00',0),
 (9876,3,33,168,1,'0.13',0),
 (9877,3,34,168,0,'0.00',0),
 (9878,3,35,168,0,'0.00',0),
 (9879,3,36,168,0,'0.00',0),
 (9880,3,37,168,0,'0.00',0),
 (9881,3,1,169,572,'63.49',0),
 (9882,3,2,169,239,'26.53',0),
 (9883,3,4,169,1,'0.11',0),
 (9884,3,12,169,55,'6.10',0),
 (9885,3,14,169,1,'0.11',0),
 (9886,3,15,169,0,'0.00',0),
 (9887,3,16,169,1,'0.11',0),
 (9888,3,17,169,3,'0.33',0),
 (9889,3,26,169,0,'0.00',0),
 (9890,3,27,169,0,'0.00',0),
 (9891,3,28,169,3,'0.33',0),
 (9892,3,29,169,0,'0.00',0),
 (9893,3,30,169,0,'0.00',0),
 (9894,3,31,169,9,'1.00',0),
 (9895,3,32,169,3,'0.33',0),
 (9896,3,33,169,0,'0.00',0),
 (9897,3,34,169,1,'0.11',0),
 (9898,3,35,169,0,'0.00',0),
 (9899,3,36,169,1,'0.11',0),
 (9900,3,37,169,0,'0.00',0),
 (9901,3,1,170,778,'45.02',0),
 (9902,3,2,170,634,'36.69',0),
 (9903,3,4,170,0,'0.00',0),
 (9904,3,12,170,264,'15.28',0),
 (9905,3,14,170,0,'0.00',0),
 (9906,3,15,170,0,'0.00',0),
 (9907,3,16,170,3,'0.17',0),
 (9908,3,17,170,1,'0.06',0),
 (9909,3,26,170,2,'0.12',0),
 (9910,3,27,170,0,'0.00',0),
 (9911,3,28,170,4,'0.23',0),
 (9912,3,29,170,0,'0.00',0),
 (9913,3,30,170,1,'0.06',0),
 (9914,3,31,170,5,'0.29',0),
 (9915,3,32,170,0,'0.00',0),
 (9916,3,33,170,2,'0.12',0),
 (9917,3,34,170,0,'0.00',0),
 (9918,3,35,170,0,'0.00',0),
 (9919,3,36,170,1,'0.06',0),
 (9920,3,37,170,0,'0.00',0),
 (9921,3,1,171,1899,'62.32',0),
 (9922,3,2,171,981,'32.20',0),
 (9923,3,4,171,6,'0.20',0),
 (9924,3,12,171,100,'3.28',0),
 (9925,3,14,171,1,'0.03',0),
 (9926,3,15,171,2,'0.07',0),
 (9927,3,16,171,3,'0.10',0),
 (9928,3,17,171,2,'0.07',0),
 (9929,3,26,171,0,'0.00',0),
 (9930,3,27,171,0,'0.00',0),
 (9931,3,28,171,3,'0.10',0),
 (9932,3,29,171,0,'0.00',0),
 (9933,3,30,171,1,'0.03',0),
 (9934,3,31,171,14,'0.46',0),
 (9935,3,32,171,0,'0.00',0),
 (9936,3,33,171,1,'0.03',0),
 (9937,3,34,171,2,'0.07',0),
 (9938,3,35,171,0,'0.00',0),
 (9939,3,36,171,2,'0.07',0),
 (9940,3,37,171,2,'0.07',0),
 (9941,3,1,172,2564,'63.91',0),
 (9942,3,2,172,1031,'25.70',0),
 (9943,3,4,172,6,'0.15',0),
 (9944,3,12,172,234,'5.83',0),
 (9945,3,14,172,1,'0.02',0),
 (9946,3,15,172,1,'0.02',0),
 (9947,3,16,172,1,'0.02',0),
 (9948,3,17,172,9,'0.22',0),
 (9949,3,26,172,0,'0.00',0),
 (9950,3,27,172,8,'0.20',0),
 (9951,3,28,172,3,'0.07',0),
 (9952,3,29,172,0,'0.00',0),
 (9953,3,30,172,0,'0.00',0),
 (9954,3,31,172,59,'1.47',0),
 (9955,3,32,172,4,'0.10',0),
 (9956,3,33,172,5,'0.12',0),
 (9957,3,34,172,0,'0.00',0),
 (9958,3,35,172,2,'0.05',0),
 (9959,3,36,172,10,'0.25',0),
 (9960,3,37,172,0,'0.00',0),
 (9961,3,1,173,227,'57.32',0),
 (9962,3,2,173,150,'37.88',0),
 (9963,3,4,173,0,'0.00',0),
 (9964,3,12,173,8,'2.02',0),
 (9965,3,14,173,0,'0.00',0),
 (9966,3,15,173,0,'0.00',0),
 (9967,3,16,173,0,'0.00',0),
 (9968,3,17,173,0,'0.00',0),
 (9969,3,26,173,0,'0.00',0),
 (9970,3,27,173,0,'0.00',0),
 (9971,3,28,173,2,'0.51',0),
 (9972,3,29,173,0,'0.00',0),
 (9973,3,30,173,0,'0.00',0),
 (9974,3,31,173,1,'0.25',0),
 (9975,3,32,173,0,'0.00',0),
 (9976,3,33,173,0,'0.00',0),
 (9977,3,34,173,0,'0.00',0),
 (9978,3,35,173,0,'0.00',0),
 (9979,3,36,173,0,'0.00',0),
 (9980,3,37,173,0,'0.00',0),
 (9981,3,1,174,755,'60.06',0),
 (9982,3,2,174,417,'33.17',0),
 (9983,3,4,174,3,'0.24',0),
 (9984,3,12,174,35,'2.78',0),
 (9985,3,14,174,0,'0.00',0),
 (9986,3,15,174,0,'0.00',0),
 (9987,3,16,174,3,'0.24',0),
 (9988,3,17,174,2,'0.16',0),
 (9989,3,26,174,0,'0.00',0),
 (9990,3,27,174,17,'1.35',0),
 (9991,3,28,174,1,'0.08',0),
 (9992,3,29,174,0,'0.00',0),
 (9993,3,30,174,0,'0.00',0),
 (9994,3,31,174,16,'1.27',0),
 (9995,3,32,174,0,'0.00',0),
 (9996,3,33,174,0,'0.00',0),
 (9997,3,34,174,0,'0.00',0),
 (9998,3,35,174,1,'0.08',0),
 (9999,3,36,174,0,'0.00',0),
 (10000,3,37,174,0,'0.00',0),
 (10001,3,1,175,279,'67.72',0),
 (10002,3,2,175,93,'22.57',0),
 (10003,3,4,175,0,'0.00',0),
 (10004,3,12,175,26,'6.31',0),
 (10005,3,14,175,2,'0.49',0),
 (10006,3,15,175,0,'0.00',0),
 (10007,3,16,175,0,'0.00',0),
 (10008,3,17,175,0,'0.00',0),
 (10009,3,26,175,0,'0.00',0),
 (10010,3,27,175,0,'0.00',0),
 (10011,3,28,175,0,'0.00',0),
 (10012,3,29,175,0,'0.00',0),
 (10013,3,30,175,0,'0.00',0),
 (10014,3,31,175,1,'0.24',0),
 (10015,3,32,175,0,'0.00',0),
 (10016,3,33,175,0,'0.00',0),
 (10017,3,34,175,1,'0.24',0),
 (10018,3,35,175,0,'0.00',0),
 (10019,3,36,175,0,'0.00',0),
 (10020,3,37,175,0,'0.00',0),
 (10021,3,1,176,5001,'71.95',0),
 (10022,3,2,176,1248,'17.95',0),
 (10023,3,4,176,18,'0.26',0),
 (10024,3,12,176,308,'4.43',0),
 (10025,3,14,176,3,'0.04',0),
 (10026,3,15,176,86,'1.24',0),
 (10027,3,16,176,10,'0.14',0),
 (10028,3,17,176,32,'0.46',0),
 (10029,3,26,176,4,'0.06',0),
 (10030,3,27,176,1,'0.01',0),
 (10031,3,28,176,15,'0.22',0),
 (10032,3,29,176,0,'0.00',0),
 (10033,3,30,176,1,'0.01',0),
 (10034,3,31,176,85,'1.22',0),
 (10035,3,32,176,6,'0.09',0),
 (10036,3,33,176,9,'0.13',0),
 (10037,3,34,176,4,'0.06',0),
 (10038,3,35,176,0,'0.00',0),
 (10039,3,36,176,4,'0.06',0),
 (10040,3,37,176,2,'0.03',0),
 (10041,3,1,177,4032,'64.23',0),
 (10042,3,2,177,1613,'25.70',0),
 (10043,3,4,177,10,'0.16',0),
 (10044,3,12,177,352,'5.61',0),
 (10045,3,14,177,3,'0.05',0),
 (10046,3,15,177,4,'0.06',0),
 (10047,3,16,177,5,'0.08',0),
 (10048,3,17,177,12,'0.19',0),
 (10049,3,26,177,6,'0.10',0),
 (10050,3,27,177,3,'0.05',0),
 (10051,3,28,177,7,'0.11',0),
 (10052,3,29,177,0,'0.00',0),
 (10053,3,30,177,1,'0.02',0),
 (10054,3,31,177,72,'1.15',0),
 (10055,3,32,177,2,'0.03',0),
 (10056,3,33,177,8,'0.13',0),
 (10057,3,34,177,4,'0.06',0),
 (10058,3,35,177,2,'0.03',0),
 (10059,3,36,177,1,'0.02',0),
 (10060,3,37,177,30,'0.48',0),
 (10061,3,1,178,426,'58.68',0),
 (10062,3,2,178,223,'30.72',0),
 (10063,3,4,178,0,'0.00',0),
 (10064,3,12,178,45,'6.20',0),
 (10065,3,14,178,0,'0.00',0),
 (10066,3,15,178,0,'0.00',0),
 (10067,3,16,178,1,'0.14',0),
 (10068,3,17,178,0,'0.00',0),
 (10069,3,26,178,0,'0.00',0),
 (10070,3,27,178,0,'0.00',0),
 (10071,3,28,178,0,'0.00',0),
 (10072,3,29,178,0,'0.00',0),
 (10073,3,30,178,0,'0.00',0),
 (10074,3,31,178,9,'1.24',0),
 (10075,3,32,178,0,'0.00',0),
 (10076,3,33,178,0,'0.00',0),
 (10077,3,34,178,0,'0.00',0),
 (10078,3,35,178,0,'0.00',0),
 (10079,3,36,178,0,'0.00',0),
 (10080,3,37,178,15,'2.07',0),
 (10081,3,1,179,524,'64.69',0),
 (10082,3,2,179,215,'26.54',0),
 (10083,3,4,179,0,'0.00',0),
 (10084,3,12,179,53,'6.54',0),
 (10085,3,14,179,0,'0.00',0),
 (10086,3,15,179,0,'0.00',0),
 (10087,3,16,179,1,'0.12',0),
 (10088,3,17,179,2,'0.25',0),
 (10089,3,26,179,0,'0.00',0),
 (10090,3,27,179,0,'0.00',0),
 (10091,3,28,179,1,'0.12',0),
 (10092,3,29,179,0,'0.00',0),
 (10093,3,30,179,0,'0.00',0),
 (10094,3,31,179,6,'0.74',0),
 (10095,3,32,179,0,'0.00',0),
 (10096,3,33,179,0,'0.00',0),
 (10097,3,34,179,0,'0.00',0),
 (10098,3,35,179,0,'0.00',0),
 (10099,3,36,179,1,'0.12',0),
 (10100,3,37,179,0,'0.00',0),
 (10101,3,1,180,1866,'50.71',0),
 (10102,3,2,180,1589,'43.18',0),
 (10103,3,4,180,2,'0.05',0),
 (10104,3,12,180,141,'3.83',0),
 (10105,3,14,180,0,'0.00',0),
 (10106,3,15,180,1,'0.03',0),
 (10107,3,16,180,2,'0.05',0),
 (10108,3,17,180,1,'0.03',0),
 (10109,3,26,180,0,'0.00',0),
 (10110,3,27,180,5,'0.14',0),
 (10111,3,28,180,0,'0.00',0),
 (10112,3,29,180,0,'0.00',0),
 (10113,3,30,180,0,'0.00',0),
 (10114,3,31,180,19,'0.52',0),
 (10115,3,32,180,3,'0.08',0),
 (10116,3,33,180,3,'0.08',0),
 (10117,3,34,180,3,'0.08',0),
 (10118,3,35,180,0,'0.00',0),
 (10119,3,36,180,1,'0.03',0),
 (10120,3,37,180,3,'0.08',0),
 (10121,3,1,181,9153,'65.76',0),
 (10122,3,2,181,3484,'25.03',0),
 (10123,3,4,181,25,'0.18',0),
 (10124,3,12,181,753,'5.41',0),
 (10125,3,14,181,4,'0.03',0),
 (10126,3,15,181,5,'0.04',0),
 (10127,3,16,181,9,'0.06',0),
 (10128,3,17,181,37,'0.27',0),
 (10129,3,26,181,1,'0.01',0),
 (10130,3,27,181,10,'0.07',0),
 (10131,3,28,181,6,'0.04',0),
 (10132,3,29,181,0,'0.00',0),
 (10133,3,30,181,2,'0.01',0),
 (10134,3,31,181,151,'1.08',0),
 (10135,3,32,181,4,'0.03',0),
 (10136,3,33,181,12,'0.09',0),
 (10137,3,34,181,6,'0.04',0),
 (10138,3,35,181,2,'0.01',0),
 (10139,3,36,181,3,'0.02',0),
 (10140,3,37,181,6,'0.04',0),
 (10141,3,1,182,89,'50.28',0),
 (10142,3,2,182,61,'34.46',0),
 (10143,3,4,182,0,'0.00',0),
 (10144,3,12,182,20,'11.30',0),
 (10145,3,14,182,0,'0.00',0),
 (10146,3,15,182,0,'0.00',0),
 (10147,3,16,182,0,'0.00',0),
 (10148,3,17,182,1,'0.56',0),
 (10149,3,26,182,0,'0.00',0),
 (10150,3,27,182,0,'0.00',0),
 (10151,3,28,182,0,'0.00',0),
 (10152,3,29,182,0,'0.00',0),
 (10153,3,30,182,0,'0.00',0),
 (10154,3,31,182,3,'1.69',0),
 (10155,3,32,182,0,'0.00',0),
 (10156,3,33,182,1,'0.56',0),
 (10157,3,34,182,0,'0.00',0),
 (10158,3,35,182,0,'0.00',0),
 (10159,3,36,182,0,'0.00',0),
 (10160,3,37,182,0,'0.00',0),
 (10161,3,1,183,339,'48.57',0),
 (10162,3,2,183,257,'36.82',0),
 (10163,3,4,183,3,'0.43',0),
 (10164,3,12,183,72,'10.32',0),
 (10165,3,14,183,0,'0.00',0),
 (10166,3,15,183,0,'0.00',0),
 (10167,3,16,183,0,'0.00',0),
 (10168,3,17,183,2,'0.29',0),
 (10169,3,26,183,0,'0.00',0),
 (10170,3,27,183,2,'0.29',0),
 (10171,3,28,183,0,'0.00',0),
 (10172,3,29,183,0,'0.00',0),
 (10173,3,30,183,0,'0.00',0),
 (10174,3,31,183,7,'1.00',0),
 (10175,3,32,183,0,'0.00',0),
 (10176,3,33,183,0,'0.00',0),
 (10177,3,34,183,0,'0.00',0),
 (10178,3,35,183,0,'0.00',0),
 (10179,3,36,183,0,'0.00',0),
 (10180,3,37,183,1,'0.14',0),
 (10181,3,1,901,297,'55.10',0),
 (10182,3,2,901,186,'34.51',0),
 (10183,3,4,901,0,'0.00',0),
 (10184,3,12,901,28,'5.19',0),
 (10185,3,14,901,0,'0.00',0),
 (10186,3,15,901,2,'0.37',0),
 (10187,3,16,901,3,'0.56',0),
 (10188,3,17,901,0,'0.00',0),
 (10189,3,26,901,0,'0.00',0),
 (10190,3,27,901,2,'0.37',0),
 (10191,3,28,901,0,'0.00',0),
 (10192,3,29,901,0,'0.00',0),
 (10193,3,30,901,0,'0.00',0),
 (10194,3,31,901,9,'1.67',0),
 (10195,3,32,901,0,'0.00',0),
 (10196,3,33,901,0,'0.00',0),
 (10197,3,34,901,1,'0.19',0),
 (10198,3,35,901,0,'0.00',0),
 (10199,3,36,901,0,'0.00',0),
 (10200,3,37,901,0,'0.00',0),
 (10201,3,1,902,217,'67.60',0),
 (10202,3,2,902,61,'19.00',0),
 (10203,3,4,902,0,'0.00',0),
 (10204,3,12,902,23,'7.17',0),
 (10205,3,14,902,0,'0.00',0),
 (10206,3,15,902,1,'0.31',0),
 (10207,3,16,902,0,'0.00',0),
 (10208,3,17,902,2,'0.62',0),
 (10209,3,26,902,0,'0.00',0),
 (10210,3,27,902,10,'3.12',0),
 (10211,3,28,902,0,'0.00',0),
 (10212,3,29,902,0,'0.00',0),
 (10213,3,30,902,1,'0.31',0),
 (10214,3,31,902,1,'0.31',0),
 (10215,3,32,902,0,'0.00',0),
 (10216,3,33,902,0,'0.00',0),
 (10217,3,34,902,0,'0.00',0),
 (10218,3,35,902,0,'0.00',0),
 (10219,3,36,902,0,'0.00',0),
 (10220,3,37,902,0,'0.00',0),
 (10221,3,1,903,10790,'52.33',0),
 (10222,3,2,903,6421,'31.14',0),
 (10223,3,4,903,44,'0.21',0),
 (10224,3,12,903,2264,'10.98',0),
 (10225,3,14,903,5,'0.02',0),
 (10226,3,15,903,16,'0.08',0),
 (10227,3,16,903,23,'0.11',0),
 (10228,3,17,903,47,'0.23',0),
 (10229,3,26,903,3,'0.01',0),
 (10230,3,27,903,2,'0.01',0),
 (10231,3,28,903,5,'0.02',0),
 (10232,3,29,903,0,'0.00',0),
 (10233,3,30,903,5,'0.02',0),
 (10234,3,31,903,413,'2.00',0),
 (10235,3,32,903,8,'0.04',0),
 (10236,3,33,903,23,'0.11',0),
 (10237,3,34,903,18,'0.09',0),
 (10238,3,35,903,3,'0.01',0),
 (10239,3,36,903,25,'0.12',0),
 (10240,3,37,903,7,'0.03',0),
 (10241,3,1,999,12183,'43.90',0),
 (10242,3,2,999,11707,'42.18',0),
 (10243,3,4,999,50,'0.18',0),
 (10244,3,12,999,1293,'4.66',0),
 (10245,3,14,999,147,'0.53',0),
 (10246,3,15,999,93,'0.34',0),
 (10247,3,16,999,45,'0.16',0),
 (10248,3,17,999,623,'2.24',0),
 (10249,3,26,999,89,'0.32',0),
 (10250,3,27,999,105,'0.38',0),
 (10251,3,28,999,50,'0.18',0),
 (10252,3,29,999,0,'0.00',0),
 (10253,3,30,999,15,'0.05',0),
 (10254,3,31,999,650,'2.34',0),
 (10255,3,32,999,48,'0.17',0),
 (10256,3,33,999,199,'0.72',0),
 (10257,3,34,999,85,'0.31',0),
 (10258,3,35,999,21,'0.08',0),
 (10259,3,36,999,102,'0.37',0),
 (10260,3,37,999,123,'0.44',0),
 (10261,4,1,1,44,'93.62',0),
 (10262,4,2,1,2,'4.26',0),
 (10263,4,14,1,0,'0.00',0),
 (10264,4,15,1,0,'0.00',0),
 (10265,4,16,1,0,'0.00',0),
 (10266,4,28,1,0,'0.00',0),
 (10267,4,32,1,0,'0.00',0),
 (10268,4,36,1,0,'0.00',0),
 (10269,4,38,1,0,'0.00',0),
 (10270,4,39,1,0,'0.00',0),
 (10271,4,40,1,0,'0.00',0),
 (10272,4,41,1,0,'0.00',0),
 (10273,4,42,1,0,'0.00',0),
 (10274,4,43,1,0,'0.00',0),
 (10275,4,44,1,0,'0.00',0),
 (10276,4,45,1,0,'0.00',0),
 (10277,4,46,1,0,'0.00',0),
 (10278,4,47,1,0,'0.00',0),
 (10279,4,48,1,0,'0.00',0),
 (10280,4,49,1,0,'0.00',0),
 (10281,4,50,1,0,'0.00',0),
 (10282,4,51,1,0,'0.00',0),
 (10283,4,1,2,745,'54.42',0),
 (10284,4,2,2,500,'36.52',0),
 (10285,4,14,2,2,'0.15',0),
 (10286,4,15,2,0,'0.00',0),
 (10287,4,16,2,1,'0.07',0),
 (10288,4,28,2,0,'0.00',0),
 (10289,4,32,2,0,'0.00',0),
 (10290,4,36,2,15,'1.10',0),
 (10291,4,38,2,78,'5.70',0),
 (10292,4,39,2,8,'0.58',0),
 (10293,4,40,2,0,'0.00',0),
 (10294,4,41,2,1,'0.07',0),
 (10295,4,42,2,0,'0.00',0),
 (10296,4,43,2,3,'0.22',0),
 (10297,4,44,2,0,'0.00',0),
 (10298,4,45,2,0,'0.00',0),
 (10299,4,46,2,0,'0.00',0),
 (10300,4,47,2,0,'0.00',0),
 (10301,4,48,2,0,'0.00',0),
 (10302,4,49,2,0,'0.00',0),
 (10303,4,50,2,1,'0.07',0),
 (10304,4,51,2,3,'0.22',0),
 (10305,4,1,3,67,'55.37',0),
 (10306,4,2,3,43,'35.54',0),
 (10307,4,14,3,0,'0.00',0),
 (10308,4,15,3,0,'0.00',0),
 (10309,4,16,3,0,'0.00',0),
 (10310,4,28,3,0,'0.00',0),
 (10311,4,32,3,0,'0.00',0),
 (10312,4,36,3,0,'0.00',0),
 (10313,4,38,3,8,'6.61',0),
 (10314,4,39,3,0,'0.00',0),
 (10315,4,40,3,0,'0.00',0),
 (10316,4,41,3,2,'1.65',0),
 (10317,4,42,3,0,'0.00',0),
 (10318,4,43,3,0,'0.00',0),
 (10319,4,44,3,0,'0.00',0),
 (10320,4,45,3,0,'0.00',0),
 (10321,4,46,3,0,'0.00',0),
 (10322,4,47,3,0,'0.00',0),
 (10323,4,48,3,0,'0.00',0),
 (10324,4,49,3,0,'0.00',0),
 (10325,4,50,3,0,'0.00',0),
 (10326,4,51,3,0,'0.00',0),
 (10327,4,1,4,1459,'52.35',0),
 (10328,4,2,4,1183,'42.45',0),
 (10329,4,14,4,1,'0.04',0),
 (10330,4,15,4,1,'0.04',0),
 (10331,4,16,4,0,'0.00',0),
 (10332,4,28,4,4,'0.14',0),
 (10333,4,32,4,1,'0.04',0),
 (10334,4,36,4,2,'0.07',0),
 (10335,4,38,4,84,'3.01',0),
 (10336,4,39,4,9,'0.32',0),
 (10337,4,40,4,0,'0.00',0),
 (10338,4,41,4,1,'0.04',0),
 (10339,4,42,4,0,'0.00',0),
 (10340,4,43,4,4,'0.14',0),
 (10341,4,44,4,0,'0.00',0),
 (10342,4,45,4,1,'0.04',0),
 (10343,4,46,4,0,'0.00',0),
 (10344,4,47,4,0,'0.00',0),
 (10345,4,48,4,0,'0.00',0),
 (10346,4,49,4,4,'0.14',0),
 (10347,4,50,4,0,'0.00',0),
 (10348,4,51,4,6,'0.22',0),
 (10349,4,1,5,35120,'43.90',0),
 (10350,4,2,5,33602,'42.00',0),
 (10351,4,14,5,46,'0.06',0),
 (10352,4,15,5,74,'0.09',0),
 (10353,4,16,5,38,'0.05',0),
 (10354,4,28,5,55,'0.07',0),
 (10355,4,32,5,15,'0.02',0),
 (10356,4,36,5,686,'0.86',0),
 (10357,4,38,5,7231,'9.04',0),
 (10358,4,39,5,544,'0.68',0),
 (10359,4,40,5,49,'0.06',0),
 (10360,4,41,5,38,'0.05',0),
 (10361,4,42,5,42,'0.05',0),
 (10362,4,43,5,111,'0.14',0),
 (10363,4,44,5,31,'0.04',0),
 (10364,4,45,5,26,'0.03',0),
 (10365,4,46,5,54,'0.07',0),
 (10366,4,47,5,14,'0.02',0),
 (10367,4,48,5,0,'0.00',0),
 (10368,4,49,5,205,'0.26',0),
 (10369,4,50,5,20,'0.02',0),
 (10370,4,51,5,448,'0.56',0),
 (10371,4,1,6,22452,'50.15',0),
 (10372,4,2,6,17452,'38.98',0),
 (10373,4,14,6,30,'0.07',0),
 (10374,4,15,6,52,'0.12',0),
 (10375,4,16,6,53,'0.12',0),
 (10376,4,28,6,31,'0.07',0),
 (10377,4,32,6,8,'0.02',0),
 (10378,4,36,6,60,'0.13',0),
 (10379,4,38,6,2880,'6.43',0),
 (10380,4,39,6,272,'0.61',0),
 (10381,4,40,6,16,'0.04',0),
 (10382,4,41,6,21,'0.05',0),
 (10383,4,42,6,16,'0.04',0),
 (10384,4,43,6,106,'0.24',0),
 (10385,4,44,6,29,'0.06',0),
 (10386,4,45,6,14,'0.03',0),
 (10387,4,46,6,53,'0.12',0),
 (10388,4,47,6,15,'0.03',0),
 (10389,4,48,6,0,'0.00',0),
 (10390,4,49,6,126,'0.28',0),
 (10391,4,50,6,9,'0.02',0),
 (10392,4,51,6,250,'0.56',0),
 (10393,4,1,7,33699,'41.97',0),
 (10394,4,2,7,37150,'46.27',0),
 (10395,4,14,7,25,'0.03',0),
 (10396,4,15,7,82,'0.10',0),
 (10397,4,16,7,59,'0.07',0),
 (10398,4,28,7,59,'0.07',0),
 (10399,4,32,7,11,'0.01',0),
 (10400,4,36,7,70,'0.09',0),
 (10401,4,38,7,6302,'7.85',0),
 (10402,4,39,7,369,'0.46',0),
 (10403,4,40,7,27,'0.03',0),
 (10404,4,41,7,34,'0.04',0),
 (10405,4,42,7,18,'0.02',0),
 (10406,4,43,7,173,'0.22',0),
 (10407,4,44,7,39,'0.05',0),
 (10408,4,45,7,38,'0.05',0),
 (10409,4,46,7,74,'0.09',0),
 (10410,4,47,7,29,'0.04',0),
 (10411,4,48,7,0,'0.00',0),
 (10412,4,49,7,231,'0.29',0),
 (10413,4,50,7,20,'0.02',0),
 (10414,4,51,7,459,'0.57',0),
 (10415,4,1,8,424,'50.42',0),
 (10416,4,2,8,360,'42.81',0),
 (10417,4,14,8,1,'0.12',0),
 (10418,4,15,8,3,'0.36',0),
 (10419,4,16,8,0,'0.00',0),
 (10420,4,28,8,0,'0.00',0),
 (10421,4,32,8,0,'0.00',0),
 (10422,4,36,8,0,'0.00',0),
 (10423,4,38,8,24,'2.85',0),
 (10424,4,39,8,3,'0.36',0),
 (10425,4,40,8,0,'0.00',0),
 (10426,4,41,8,0,'0.00',0),
 (10427,4,42,8,0,'0.00',0),
 (10428,4,43,8,11,'1.31',0),
 (10429,4,44,8,0,'0.00',0),
 (10430,4,45,8,4,'0.48',0),
 (10431,4,46,8,0,'0.00',0),
 (10432,4,47,8,1,'0.12',0),
 (10433,4,48,8,0,'0.00',0),
 (10434,4,49,8,3,'0.36',0),
 (10435,4,50,8,0,'0.00',0),
 (10436,4,51,8,5,'0.59',0),
 (10437,4,1,9,3825,'52.56',0),
 (10438,4,2,9,2756,'37.87',0),
 (10439,4,14,9,3,'0.04',0),
 (10440,4,15,9,10,'0.14',0),
 (10441,4,16,9,5,'0.07',0),
 (10442,4,28,9,2,'0.03',0),
 (10443,4,32,9,2,'0.03',0),
 (10444,4,36,9,19,'0.26',0),
 (10445,4,38,9,397,'5.46',0),
 (10446,4,39,9,45,'0.62',0),
 (10447,4,40,9,3,'0.04',0),
 (10448,4,41,9,4,'0.05',0),
 (10449,4,42,9,1,'0.01',0),
 (10450,4,43,9,14,'0.19',0),
 (10451,4,44,9,6,'0.08',0),
 (10452,4,45,9,35,'0.48',0),
 (10453,4,46,9,1,'0.01',0),
 (10454,4,47,9,0,'0.00',0),
 (10455,4,48,9,0,'0.00',0),
 (10456,4,49,9,17,'0.23',0),
 (10457,4,50,9,1,'0.01',0),
 (10458,4,51,9,29,'0.40',0),
 (10459,4,1,10,2535,'54.76',0),
 (10460,4,2,10,1451,'31.35',0),
 (10461,4,14,10,1,'0.02',0),
 (10462,4,15,10,0,'0.00',0),
 (10463,4,16,10,2,'0.04',0),
 (10464,4,28,10,5,'0.11',0),
 (10465,4,32,10,0,'0.00',0),
 (10466,4,36,10,1,'0.02',0),
 (10467,4,38,10,443,'9.57',0),
 (10468,4,39,10,35,'0.76',0),
 (10469,4,40,10,2,'0.04',0),
 (10470,4,41,10,1,'0.02',0),
 (10471,4,42,10,2,'0.04',0),
 (10472,4,43,10,10,'0.22',0),
 (10473,4,44,10,4,'0.09',0),
 (10474,4,45,10,1,'0.02',0),
 (10475,4,46,10,0,'0.00',0),
 (10476,4,47,10,0,'0.00',0),
 (10477,4,48,10,0,'0.00',0),
 (10478,4,49,10,16,'0.35',0),
 (10479,4,50,10,1,'0.02',0),
 (10480,4,51,10,29,'0.63',0),
 (10481,4,1,11,133,'63.03',0),
 (10482,4,2,11,42,'19.91',0),
 (10483,4,14,11,0,'0.00',0),
 (10484,4,15,11,0,'0.00',0),
 (10485,4,16,11,0,'0.00',0),
 (10486,4,28,11,0,'0.00',0),
 (10487,4,32,11,0,'0.00',0),
 (10488,4,36,11,0,'0.00',0),
 (10489,4,38,11,35,'16.59',0),
 (10490,4,39,11,0,'0.00',0),
 (10491,4,40,11,0,'0.00',0),
 (10492,4,41,11,0,'0.00',0),
 (10493,4,42,11,0,'0.00',0),
 (10494,4,43,11,0,'0.00',0),
 (10495,4,44,11,0,'0.00',0),
 (10496,4,45,11,0,'0.00',0),
 (10497,4,46,11,0,'0.00',0),
 (10498,4,47,11,0,'0.00',0),
 (10499,4,48,11,0,'0.00',0),
 (10500,4,49,11,0,'0.00',0),
 (10501,4,50,11,0,'0.00',0),
 (10502,4,51,11,0,'0.00',0),
 (10503,4,1,12,197,'51.57',0),
 (10504,4,2,12,157,'41.10',0),
 (10505,4,14,12,0,'0.00',0),
 (10506,4,15,12,1,'0.26',0),
 (10507,4,16,12,0,'0.00',0),
 (10508,4,28,12,0,'0.00',0),
 (10509,4,32,12,0,'0.00',0),
 (10510,4,36,12,2,'0.52',0),
 (10511,4,38,12,18,'4.71',0),
 (10512,4,39,12,0,'0.00',0),
 (10513,4,40,12,0,'0.00',0),
 (10514,4,41,12,0,'0.00',0),
 (10515,4,42,12,0,'0.00',0),
 (10516,4,43,12,1,'0.26',0),
 (10517,4,44,12,0,'0.00',0),
 (10518,4,45,12,0,'0.00',0),
 (10519,4,46,12,0,'0.00',0),
 (10520,4,47,12,0,'0.00',0),
 (10521,4,48,12,0,'0.00',0),
 (10522,4,49,12,1,'0.26',0),
 (10523,4,50,12,0,'0.00',0),
 (10524,4,51,12,1,'0.26',0),
 (10525,4,1,13,9177,'42.40',0),
 (10526,4,2,13,10583,'48.90',0),
 (10527,4,14,13,7,'0.03',0),
 (10528,4,15,13,10,'0.05',0),
 (10529,4,16,13,11,'0.05',0),
 (10530,4,28,13,16,'0.07',0),
 (10531,4,32,13,3,'0.01',0),
 (10532,4,36,13,25,'0.12',0),
 (10533,4,38,13,1340,'6.19',0),
 (10534,4,39,13,67,'0.31',0),
 (10535,4,40,13,3,'0.01',0),
 (10536,4,41,13,12,'0.06',0),
 (10537,4,42,13,3,'0.01',0),
 (10538,4,43,13,35,'0.16',0),
 (10539,4,44,13,4,'0.02',0),
 (10540,4,45,13,9,'0.04',0),
 (10541,4,46,13,13,'0.06',0),
 (10542,4,47,13,1,'0.00',0),
 (10543,4,48,13,0,'0.00',0),
 (10544,4,49,13,36,'0.17',0),
 (10545,4,50,13,1,'0.00',0),
 (10546,4,51,13,37,'0.17',0),
 (10547,4,1,14,8030,'53.24',0),
 (10548,4,2,14,5553,'36.82',0),
 (10549,4,14,14,2,'0.01',0),
 (10550,4,15,14,3,'0.02',0),
 (10551,4,16,14,6,'0.04',0),
 (10552,4,28,14,7,'0.05',0),
 (10553,4,32,14,0,'0.00',0),
 (10554,4,36,14,18,'0.12',0),
 (10555,4,38,14,1194,'7.92',0),
 (10556,4,39,14,49,'0.32',0),
 (10557,4,40,14,0,'0.00',0),
 (10558,4,41,14,5,'0.03',0),
 (10559,4,42,14,0,'0.00',0),
 (10560,4,43,14,11,'0.07',0),
 (10561,4,44,14,5,'0.03',0),
 (10562,4,45,14,1,'0.01',0),
 (10563,4,46,14,3,'0.02',0),
 (10564,4,47,14,2,'0.01',0),
 (10565,4,48,14,0,'0.00',0),
 (10566,4,49,14,18,'0.12',0),
 (10567,4,50,14,1,'0.01',0),
 (10568,4,51,14,31,'0.21',0),
 (10569,4,1,15,1584,'50.97',0),
 (10570,4,2,15,1253,'40.32',0),
 (10571,4,14,15,1,'0.03',0),
 (10572,4,15,15,1,'0.03',0),
 (10573,4,16,15,2,'0.06',0),
 (10574,4,28,15,0,'0.00',0),
 (10575,4,32,15,2,'0.06',0),
 (10576,4,36,15,1,'0.03',0),
 (10577,4,38,15,177,'5.69',0),
 (10578,4,39,15,17,'0.55',0),
 (10579,4,40,15,0,'0.00',0),
 (10580,4,41,15,0,'0.00',0),
 (10581,4,42,15,1,'0.03',0),
 (10582,4,43,15,2,'0.06',0),
 (10583,4,44,15,0,'0.00',0),
 (10584,4,45,15,0,'0.00',0),
 (10585,4,46,15,1,'0.03',0),
 (10586,4,47,15,0,'0.00',0),
 (10587,4,48,15,0,'0.00',0),
 (10588,4,49,15,7,'0.23',0),
 (10589,4,50,15,0,'0.00',0),
 (10590,4,51,15,10,'0.32',0),
 (10591,4,1,16,32,'47.76',0),
 (10592,4,2,16,24,'35.82',0),
 (10593,4,14,16,0,'0.00',0),
 (10594,4,15,16,0,'0.00',0),
 (10595,4,16,16,1,'1.49',0),
 (10596,4,28,16,0,'0.00',0),
 (10597,4,32,16,0,'0.00',0),
 (10598,4,36,16,0,'0.00',0),
 (10599,4,38,16,7,'10.45',0),
 (10600,4,39,16,0,'0.00',0),
 (10601,4,40,16,0,'0.00',0),
 (10602,4,41,16,0,'0.00',0),
 (10603,4,42,16,0,'0.00',0),
 (10604,4,43,16,0,'0.00',0),
 (10605,4,44,16,0,'0.00',0),
 (10606,4,45,16,0,'0.00',0),
 (10607,4,46,16,0,'0.00',0),
 (10608,4,47,16,0,'0.00',0),
 (10609,4,48,16,0,'0.00',0),
 (10610,4,49,16,0,'0.00',0),
 (10611,4,50,16,0,'0.00',0),
 (10612,4,51,16,2,'2.99',0),
 (10613,4,1,17,291,'48.74',0),
 (10614,4,2,17,236,'39.53',0),
 (10615,4,14,17,0,'0.00',0),
 (10616,4,15,17,0,'0.00',0),
 (10617,4,16,17,0,'0.00',0),
 (10618,4,28,17,0,'0.00',0),
 (10619,4,32,17,0,'0.00',0),
 (10620,4,36,17,0,'0.00',0),
 (10621,4,38,17,48,'8.04',0),
 (10622,4,39,17,2,'0.34',0),
 (10623,4,40,17,3,'0.50',0),
 (10624,4,41,17,0,'0.00',0),
 (10625,4,42,17,0,'0.00',0),
 (10626,4,43,17,2,'0.34',0),
 (10627,4,44,17,0,'0.00',0),
 (10628,4,45,17,0,'0.00',0),
 (10629,4,46,17,0,'0.00',0),
 (10630,4,47,17,0,'0.00',0),
 (10631,4,48,17,0,'0.00',0),
 (10632,4,49,17,2,'0.34',0),
 (10633,4,50,17,1,'0.17',0),
 (10634,4,51,17,6,'1.01',0),
 (10635,4,1,18,1136,'56.97',0),
 (10636,4,2,18,669,'33.55',0),
 (10637,4,14,18,2,'0.10',0),
 (10638,4,15,18,3,'0.15',0),
 (10639,4,16,18,3,'0.15',0),
 (10640,4,28,18,0,'0.00',0),
 (10641,4,32,18,0,'0.00',0),
 (10642,4,36,18,1,'0.05',0),
 (10643,4,38,18,131,'6.57',0),
 (10644,4,39,18,7,'0.35',0),
 (10645,4,40,18,1,'0.05',0),
 (10646,4,41,18,1,'0.05',0),
 (10647,4,42,18,1,'0.05',0),
 (10648,4,43,18,4,'0.20',0),
 (10649,4,44,18,1,'0.05',0),
 (10650,4,45,18,2,'0.10',0),
 (10651,4,46,18,1,'0.05',0),
 (10652,4,47,18,1,'0.05',0),
 (10653,4,48,18,0,'0.00',0),
 (10654,4,49,18,5,'0.25',0),
 (10655,4,50,18,0,'0.00',0),
 (10656,4,51,18,8,'0.40',0),
 (10657,4,1,19,281,'42.64',0),
 (10658,4,2,19,340,'51.59',0),
 (10659,4,14,19,0,'0.00',0),
 (10660,4,15,19,0,'0.00',0),
 (10661,4,16,19,0,'0.00',0),
 (10662,4,28,19,0,'0.00',0),
 (10663,4,32,19,0,'0.00',0),
 (10664,4,36,19,0,'0.00',0),
 (10665,4,38,19,33,'5.01',0),
 (10666,4,39,19,1,'0.15',0),
 (10667,4,40,19,0,'0.00',0),
 (10668,4,41,19,0,'0.00',0),
 (10669,4,42,19,0,'0.00',0),
 (10670,4,43,19,0,'0.00',0),
 (10671,4,44,19,0,'0.00',0),
 (10672,4,45,19,0,'0.00',0),
 (10673,4,46,19,1,'0.15',0),
 (10674,4,47,19,0,'0.00',0),
 (10675,4,48,19,0,'0.00',0),
 (10676,4,49,19,0,'0.00',0),
 (10677,4,50,19,0,'0.00',0),
 (10678,4,51,19,0,'0.00',0),
 (10679,4,1,20,40,'38.10',0),
 (10680,4,2,20,25,'23.81',0),
 (10681,4,14,20,0,'0.00',0),
 (10682,4,15,20,0,'0.00',0),
 (10683,4,16,20,0,'0.00',0),
 (10684,4,28,20,0,'0.00',0),
 (10685,4,32,20,0,'0.00',0),
 (10686,4,36,20,0,'0.00',0),
 (10687,4,38,20,37,'35.24',0),
 (10688,4,39,20,1,'0.95',0),
 (10689,4,40,20,0,'0.00',0),
 (10690,4,41,20,2,'1.90',0),
 (10691,4,42,20,0,'0.00',0),
 (10692,4,43,20,0,'0.00',0),
 (10693,4,44,20,0,'0.00',0),
 (10694,4,45,20,0,'0.00',0),
 (10695,4,46,20,0,'0.00',0),
 (10696,4,47,20,0,'0.00',0),
 (10697,4,48,20,0,'0.00',0),
 (10698,4,49,20,0,'0.00',0),
 (10699,4,50,20,0,'0.00',0),
 (10700,4,51,20,0,'0.00',0),
 (10701,4,1,21,149,'58.66',0),
 (10702,4,2,21,73,'28.74',0),
 (10703,4,14,21,0,'0.00',0),
 (10704,4,15,21,0,'0.00',0),
 (10705,4,16,21,0,'0.00',0),
 (10706,4,28,21,0,'0.00',0),
 (10707,4,32,21,0,'0.00',0),
 (10708,4,36,21,0,'0.00',0),
 (10709,4,38,21,4,'1.57',0),
 (10710,4,39,21,0,'0.00',0),
 (10711,4,40,21,0,'0.00',0),
 (10712,4,41,21,0,'0.00',0),
 (10713,4,42,21,0,'0.00',0),
 (10714,4,43,21,23,'9.06',0),
 (10715,4,44,21,0,'0.00',0),
 (10716,4,45,21,0,'0.00',0),
 (10717,4,46,21,0,'0.00',0),
 (10718,4,47,21,0,'0.00',0),
 (10719,4,48,21,0,'0.00',0),
 (10720,4,49,21,1,'0.39',0),
 (10721,4,50,21,0,'0.00',0),
 (10722,4,51,21,1,'0.39',0),
 (10723,4,1,22,10638,'68.22',0),
 (10724,4,2,22,3579,'22.95',0),
 (10725,4,14,22,4,'0.03',0),
 (10726,4,15,22,3,'0.02',0),
 (10727,4,16,22,9,'0.06',0),
 (10728,4,28,22,8,'0.05',0),
 (10729,4,32,22,0,'0.00',0),
 (10730,4,36,22,5,'0.03',0),
 (10731,4,38,22,781,'5.01',0),
 (10732,4,39,22,64,'0.41',0),
 (10733,4,40,22,10,'0.06',0),
 (10734,4,41,22,5,'0.03',0),
 (10735,4,42,22,3,'0.02',0),
 (10736,4,43,22,42,'0.27',0),
 (10737,4,44,22,7,'0.04',0),
 (10738,4,45,22,4,'0.03',0),
 (10739,4,46,22,10,'0.06',0),
 (10740,4,47,22,12,'0.08',0),
 (10741,4,48,22,0,'0.00',0),
 (10742,4,49,22,51,'0.33',0),
 (10743,4,50,22,1,'0.01',0),
 (10744,4,51,22,46,'0.29',0),
 (10745,4,1,23,1129,'54.59',0),
 (10746,4,2,23,682,'32.98',0),
 (10747,4,14,23,5,'0.24',0),
 (10748,4,15,23,0,'0.00',0),
 (10749,4,16,23,0,'0.00',0),
 (10750,4,28,23,1,'0.05',0),
 (10751,4,32,23,0,'0.00',0),
 (10752,4,36,23,1,'0.05',0),
 (10753,4,38,23,174,'8.41',0),
 (10754,4,39,23,16,'0.77',0),
 (10755,4,40,23,1,'0.05',0),
 (10756,4,41,23,2,'0.10',0),
 (10757,4,42,23,1,'0.05',0),
 (10758,4,43,23,2,'0.10',0),
 (10759,4,44,23,1,'0.05',0),
 (10760,4,45,23,1,'0.05',0),
 (10761,4,46,23,1,'0.05',0),
 (10762,4,47,23,0,'0.00',0),
 (10763,4,48,23,0,'0.00',0),
 (10764,4,49,23,10,'0.48',0),
 (10765,4,50,23,1,'0.05',0),
 (10766,4,51,23,11,'0.53',0),
 (10767,4,1,24,60,'65.93',0),
 (10768,4,2,24,23,'25.27',0),
 (10769,4,14,24,0,'0.00',0),
 (10770,4,15,24,0,'0.00',0),
 (10771,4,16,24,0,'0.00',0),
 (10772,4,28,24,0,'0.00',0),
 (10773,4,32,24,0,'0.00',0),
 (10774,4,36,24,1,'1.10',0),
 (10775,4,38,24,3,'3.30',0),
 (10776,4,39,24,0,'0.00',0),
 (10777,4,40,24,0,'0.00',0),
 (10778,4,41,24,0,'0.00',0),
 (10779,4,42,24,0,'0.00',0),
 (10780,4,43,24,2,'2.20',0),
 (10781,4,44,24,0,'0.00',0),
 (10782,4,45,24,0,'0.00',0),
 (10783,4,46,24,0,'0.00',0),
 (10784,4,47,24,0,'0.00',0),
 (10785,4,48,24,0,'0.00',0),
 (10786,4,49,24,0,'0.00',0),
 (10787,4,50,24,0,'0.00',0),
 (10788,4,51,24,1,'1.10',0),
 (10789,4,1,25,206,'66.45',0),
 (10790,4,2,25,92,'29.68',0),
 (10791,4,14,25,0,'0.00',0),
 (10792,4,15,25,0,'0.00',0),
 (10793,4,16,25,0,'0.00',0),
 (10794,4,28,25,0,'0.00',0),
 (10795,4,32,25,0,'0.00',0),
 (10796,4,36,25,0,'0.00',0),
 (10797,4,38,25,7,'2.26',0),
 (10798,4,39,25,0,'0.00',0),
 (10799,4,40,25,0,'0.00',0),
 (10800,4,41,25,0,'0.00',0),
 (10801,4,42,25,1,'0.32',0),
 (10802,4,43,25,0,'0.00',0),
 (10803,4,44,25,0,'0.00',0),
 (10804,4,45,25,0,'0.00',0),
 (10805,4,46,25,0,'0.00',0),
 (10806,4,47,25,0,'0.00',0),
 (10807,4,48,25,0,'0.00',0),
 (10808,4,49,25,1,'0.32',0),
 (10809,4,50,25,0,'0.00',0),
 (10810,4,51,25,0,'0.00',0),
 (10811,4,1,26,1860,'59.60',0),
 (10812,4,2,26,924,'29.61',0),
 (10813,4,14,26,1,'0.03',0),
 (10814,4,15,26,0,'0.00',0),
 (10815,4,16,26,5,'0.16',0),
 (10816,4,28,26,3,'0.10',0),
 (10817,4,32,26,0,'0.00',0),
 (10818,4,36,26,0,'0.00',0),
 (10819,4,38,26,241,'7.72',0),
 (10820,4,39,26,16,'0.51',0),
 (10821,4,40,26,2,'0.06',0),
 (10822,4,41,26,0,'0.00',0),
 (10823,4,42,26,0,'0.00',0),
 (10824,4,43,26,5,'0.16',0),
 (10825,4,44,26,5,'0.16',0),
 (10826,4,45,26,1,'0.03',0),
 (10827,4,46,26,2,'0.06',0),
 (10828,4,47,26,1,'0.03',0),
 (10829,4,48,26,0,'0.00',0),
 (10830,4,49,26,4,'0.13',0),
 (10831,4,50,26,0,'0.00',0),
 (10832,4,51,26,13,'0.42',0),
 (10833,4,1,27,403,'52.89',0),
 (10834,4,2,27,290,'38.06',0),
 (10835,4,14,27,0,'0.00',0),
 (10836,4,15,27,0,'0.00',0),
 (10837,4,16,27,0,'0.00',0),
 (10838,4,28,27,0,'0.00',0),
 (10839,4,32,27,0,'0.00',0),
 (10840,4,36,27,0,'0.00',0),
 (10841,4,38,27,47,'6.17',0),
 (10842,4,39,27,1,'0.13',0),
 (10843,4,40,27,0,'0.00',0),
 (10844,4,41,27,0,'0.00',0),
 (10845,4,42,27,0,'0.00',0),
 (10846,4,43,27,3,'0.39',0),
 (10847,4,44,27,1,'0.13',0),
 (10848,4,45,27,1,'0.13',0),
 (10849,4,46,27,0,'0.00',0),
 (10850,4,47,27,1,'0.13',0),
 (10851,4,48,27,0,'0.00',0),
 (10852,4,49,27,1,'0.13',0),
 (10853,4,50,27,0,'0.00',0),
 (10854,4,51,27,0,'0.00',0),
 (10855,4,1,28,395,'47.71',0),
 (10856,4,2,28,274,'33.09',0),
 (10857,4,14,28,2,'0.24',0),
 (10858,4,15,28,0,'0.00',0),
 (10859,4,16,28,1,'0.12',0),
 (10860,4,28,28,3,'0.36',0),
 (10861,4,32,28,0,'0.00',0),
 (10862,4,36,28,0,'0.00',0),
 (10863,4,38,28,131,'15.82',0),
 (10864,4,39,28,0,'0.00',0),
 (10865,4,40,28,1,'0.12',0),
 (10866,4,41,28,0,'0.00',0),
 (10867,4,42,28,1,'0.12',0),
 (10868,4,43,28,3,'0.36',0),
 (10869,4,44,28,0,'0.00',0),
 (10870,4,45,28,2,'0.24',0),
 (10871,4,46,28,0,'0.00',0),
 (10872,4,47,28,0,'0.00',0),
 (10873,4,48,28,0,'0.00',0),
 (10874,4,49,28,3,'0.36',0),
 (10875,4,50,28,0,'0.00',0),
 (10876,4,51,28,3,'0.36',0),
 (10877,4,1,29,181,'56.04',0),
 (10878,4,2,29,115,'35.60',0),
 (10879,4,14,29,0,'0.00',0),
 (10880,4,15,29,0,'0.00',0),
 (10881,4,16,29,0,'0.00',0),
 (10882,4,28,29,0,'0.00',0),
 (10883,4,32,29,0,'0.00',0),
 (10884,4,36,29,0,'0.00',0),
 (10885,4,38,29,17,'5.26',0),
 (10886,4,39,29,0,'0.00',0),
 (10887,4,40,29,0,'0.00',0),
 (10888,4,41,29,0,'0.00',0),
 (10889,4,42,29,0,'0.00',0),
 (10890,4,43,29,1,'0.31',0),
 (10891,4,44,29,1,'0.31',0),
 (10892,4,45,29,0,'0.00',0),
 (10893,4,46,29,0,'0.00',0),
 (10894,4,47,29,0,'0.00',0),
 (10895,4,48,29,0,'0.00',0),
 (10896,4,49,29,1,'0.31',0),
 (10897,4,50,29,0,'0.00',0),
 (10898,4,51,29,0,'0.00',0),
 (10899,4,1,30,506,'52.22',0),
 (10900,4,2,30,334,'34.47',0),
 (10901,4,14,30,0,'0.00',0),
 (10902,4,15,30,1,'0.10',0),
 (10903,4,16,30,2,'0.21',0),
 (10904,4,28,30,1,'0.10',0),
 (10905,4,32,30,1,'0.10',0),
 (10906,4,36,30,2,'0.21',0),
 (10907,4,38,30,58,'5.99',0),
 (10908,4,39,30,7,'0.72',0),
 (10909,4,40,30,1,'0.10',0),
 (10910,4,41,30,1,'0.10',0),
 (10911,4,42,30,0,'0.00',0),
 (10912,4,43,30,32,'3.30',0),
 (10913,4,44,30,1,'0.10',0),
 (10914,4,45,30,0,'0.00',0),
 (10915,4,46,30,1,'0.10',0),
 (10916,4,47,30,0,'0.00',0),
 (10917,4,48,30,0,'0.00',0),
 (10918,4,49,30,3,'0.31',0),
 (10919,4,50,30,0,'0.00',0),
 (10920,4,51,30,0,'0.00',0),
 (10921,4,1,31,695,'52.45',0),
 (10922,4,2,31,579,'43.70',0),
 (10923,4,14,31,0,'0.00',0),
 (10924,4,15,31,0,'0.00',0),
 (10925,4,16,31,0,'0.00',0),
 (10926,4,28,31,0,'0.00',0),
 (10927,4,32,31,1,'0.08',0),
 (10928,4,36,31,0,'0.00',0),
 (10929,4,38,31,38,'2.87',0),
 (10930,4,39,31,0,'0.00',0),
 (10931,4,40,31,1,'0.08',0),
 (10932,4,41,31,0,'0.00',0),
 (10933,4,42,31,0,'0.00',0),
 (10934,4,43,31,0,'0.00',0),
 (10935,4,44,31,0,'0.00',0),
 (10936,4,45,31,0,'0.00',0),
 (10937,4,46,31,0,'0.00',0),
 (10938,4,47,31,1,'0.08',0),
 (10939,4,48,31,0,'0.00',0),
 (10940,4,49,31,0,'0.00',0),
 (10941,4,50,31,0,'0.00',0),
 (10942,4,51,31,2,'0.15',0),
 (10943,4,1,32,740,'46.48',0),
 (10944,4,2,32,635,'39.89',0),
 (10945,4,14,32,0,'0.00',0),
 (10946,4,15,32,0,'0.00',0),
 (10947,4,16,32,2,'0.13',0),
 (10948,4,28,32,0,'0.00',0),
 (10949,4,32,32,0,'0.00',0),
 (10950,4,36,32,7,'0.44',0),
 (10951,4,38,32,161,'10.11',0),
 (10952,4,39,32,8,'0.50',0),
 (10953,4,40,32,1,'0.06',0),
 (10954,4,41,32,0,'0.00',0),
 (10955,4,42,32,0,'0.00',0),
 (10956,4,43,32,1,'0.06',0),
 (10957,4,44,32,0,'0.00',0),
 (10958,4,45,32,0,'0.00',0),
 (10959,4,46,32,2,'0.13',0),
 (10960,4,47,32,0,'0.00',0),
 (10961,4,48,32,0,'0.00',0),
 (10962,4,49,32,7,'0.44',0),
 (10963,4,50,32,0,'0.00',0),
 (10964,4,51,32,5,'0.31',0),
 (10965,4,1,33,968,'61.19',0),
 (10966,4,2,33,529,'33.44',0),
 (10967,4,14,33,0,'0.00',0),
 (10968,4,15,33,1,'0.06',0),
 (10969,4,16,33,3,'0.19',0),
 (10970,4,28,33,0,'0.00',0),
 (10971,4,32,33,0,'0.00',0),
 (10972,4,36,33,3,'0.19',0),
 (10973,4,38,33,47,'2.97',0),
 (10974,4,39,33,2,'0.13',0),
 (10975,4,40,33,0,'0.00',0),
 (10976,4,41,33,1,'0.06',0),
 (10977,4,42,33,1,'0.06',0),
 (10978,4,43,33,3,'0.19',0),
 (10979,4,44,33,0,'0.00',0),
 (10980,4,45,33,0,'0.00',0),
 (10981,4,46,33,0,'0.00',0),
 (10982,4,47,33,0,'0.00',0),
 (10983,4,48,33,0,'0.00',0),
 (10984,4,49,33,4,'0.25',0),
 (10985,4,50,33,0,'0.00',0),
 (10986,4,51,33,4,'0.25',0),
 (10987,4,1,34,190,'61.69',0),
 (10988,4,2,34,99,'32.14',0),
 (10989,4,14,34,0,'0.00',0),
 (10990,4,15,34,0,'0.00',0),
 (10991,4,16,34,0,'0.00',0),
 (10992,4,28,34,0,'0.00',0),
 (10993,4,32,34,0,'0.00',0),
 (10994,4,36,34,0,'0.00',0),
 (10995,4,38,34,10,'3.25',0),
 (10996,4,39,34,0,'0.00',0),
 (10997,4,40,34,0,'0.00',0),
 (10998,4,41,34,1,'0.32',0),
 (10999,4,42,34,0,'0.00',0),
 (11000,4,43,34,5,'1.62',0),
 (11001,4,44,34,0,'0.00',0),
 (11002,4,45,34,0,'0.00',0),
 (11003,4,46,34,0,'0.00',0),
 (11004,4,47,34,0,'0.00',0),
 (11005,4,48,34,0,'0.00',0),
 (11006,4,49,34,0,'0.00',0),
 (11007,4,50,34,0,'0.00',0),
 (11008,4,51,34,0,'0.00',0),
 (11009,4,1,35,355,'48.30',0),
 (11010,4,2,35,293,'39.86',0),
 (11011,4,14,35,0,'0.00',0),
 (11012,4,15,35,0,'0.00',0),
 (11013,4,16,35,1,'0.14',0),
 (11014,4,28,35,0,'0.00',0),
 (11015,4,32,35,0,'0.00',0),
 (11016,4,36,35,0,'0.00',0),
 (11017,4,38,35,79,'10.75',0),
 (11018,4,39,35,0,'0.00',0),
 (11019,4,40,35,0,'0.00',0),
 (11020,4,41,35,0,'0.00',0),
 (11021,4,42,35,0,'0.00',0),
 (11022,4,43,35,0,'0.00',0),
 (11023,4,44,35,0,'0.00',0),
 (11024,4,45,35,1,'0.14',0),
 (11025,4,46,35,1,'0.14',0),
 (11026,4,47,35,0,'0.00',0),
 (11027,4,48,35,0,'0.00',0),
 (11028,4,49,35,0,'0.00',0),
 (11029,4,50,35,0,'0.00',0),
 (11030,4,51,35,2,'0.27',0),
 (11031,4,1,36,343,'40.74',0),
 (11032,4,2,36,261,'31.00',0),
 (11033,4,14,36,0,'0.00',0),
 (11034,4,15,36,1,'0.12',0),
 (11035,4,16,36,0,'0.00',0),
 (11036,4,28,36,2,'0.24',0),
 (11037,4,32,36,0,'0.00',0),
 (11038,4,36,36,2,'0.24',0),
 (11039,4,38,36,207,'24.58',0),
 (11040,4,39,36,5,'0.59',0),
 (11041,4,40,36,0,'0.00',0),
 (11042,4,41,36,2,'0.24',0),
 (11043,4,42,36,0,'0.00',0),
 (11044,4,43,36,0,'0.00',0),
 (11045,4,44,36,1,'0.12',0),
 (11046,4,45,36,0,'0.00',0),
 (11047,4,46,36,1,'0.12',0),
 (11048,4,47,36,0,'0.00',0),
 (11049,4,48,36,0,'0.00',0),
 (11050,4,49,36,3,'0.36',0),
 (11051,4,50,36,0,'0.00',0),
 (11052,4,51,36,2,'0.24',0),
 (11053,4,1,37,561,'46.87',0),
 (11054,4,2,37,598,'49.96',0),
 (11055,4,14,37,0,'0.00',0),
 (11056,4,15,37,0,'0.00',0),
 (11057,4,16,37,2,'0.17',0),
 (11058,4,28,37,1,'0.08',0),
 (11059,4,32,37,0,'0.00',0),
 (11060,4,36,37,0,'0.00',0),
 (11061,4,38,37,29,'2.42',0),
 (11062,4,39,37,2,'0.17',0),
 (11063,4,40,37,0,'0.00',0),
 (11064,4,41,37,1,'0.08',0),
 (11065,4,42,37,0,'0.00',0),
 (11066,4,43,37,0,'0.00',0),
 (11067,4,44,37,0,'0.00',0),
 (11068,4,45,37,0,'0.00',0),
 (11069,4,46,37,0,'0.00',0),
 (11070,4,47,37,0,'0.00',0),
 (11071,4,48,37,0,'0.00',0),
 (11072,4,49,37,0,'0.00',0),
 (11073,4,50,37,0,'0.00',0),
 (11074,4,51,37,1,'0.08',0),
 (11075,4,1,38,1303,'42.21',0),
 (11076,4,2,38,1410,'45.68',0),
 (11077,4,14,38,1,'0.03',0),
 (11078,4,15,38,1,'0.03',0),
 (11079,4,16,38,2,'0.06',0),
 (11080,4,28,38,2,'0.06',0),
 (11081,4,32,38,2,'0.06',0),
 (11082,4,36,38,1,'0.03',0),
 (11083,4,38,38,283,'9.17',0),
 (11084,4,39,38,11,'0.36',0),
 (11085,4,40,38,1,'0.03',0),
 (11086,4,41,38,4,'0.13',0),
 (11087,4,42,38,0,'0.00',0),
 (11088,4,43,38,3,'0.10',0);
INSERT INTO `elecmunicandi` (`idElecMuniCandi`,`Convocatoria_idConvocatoria`,`Candidatura_idCandidatura`,`Municipio`,`Votos`,`PorcVotos`,`Concejales`) VALUES 
 (11089,4,44,38,0,'0.00',0),
 (11090,4,45,38,2,'0.06',0),
 (11091,4,46,38,6,'0.19',0),
 (11092,4,47,38,0,'0.00',0),
 (11093,4,48,38,0,'0.00',0),
 (11094,4,49,38,6,'0.19',0),
 (11095,4,50,38,0,'0.00',0),
 (11096,4,51,38,13,'0.42',0),
 (11097,4,1,39,33,'40.24',0),
 (11098,4,2,39,43,'52.44',0),
 (11099,4,14,39,0,'0.00',0),
 (11100,4,15,39,0,'0.00',0),
 (11101,4,16,39,0,'0.00',0),
 (11102,4,28,39,0,'0.00',0),
 (11103,4,32,39,0,'0.00',0),
 (11104,4,36,39,0,'0.00',0),
 (11105,4,38,39,3,'3.66',0),
 (11106,4,39,39,0,'0.00',0),
 (11107,4,40,39,0,'0.00',0),
 (11108,4,41,39,0,'0.00',0),
 (11109,4,42,39,0,'0.00',0),
 (11110,4,43,39,0,'0.00',0),
 (11111,4,44,39,0,'0.00',0),
 (11112,4,45,39,0,'0.00',0),
 (11113,4,46,39,0,'0.00',0),
 (11114,4,47,39,0,'0.00',0),
 (11115,4,48,39,0,'0.00',0),
 (11116,4,49,39,0,'0.00',0),
 (11117,4,50,39,0,'0.00',0),
 (11118,4,51,39,1,'1.22',0),
 (11119,4,1,40,2523,'39.65',0),
 (11120,4,2,40,3008,'47.27',0),
 (11121,4,14,40,1,'0.02',0),
 (11122,4,15,40,4,'0.06',0),
 (11123,4,16,40,8,'0.13',0),
 (11124,4,28,40,6,'0.09',0),
 (11125,4,32,40,0,'0.00',0),
 (11126,4,36,40,14,'0.22',0),
 (11127,4,38,40,652,'10.25',0),
 (11128,4,39,40,19,'0.30',0),
 (11129,4,40,40,0,'0.00',0),
 (11130,4,41,40,2,'0.03',0),
 (11131,4,42,40,0,'0.00',0),
 (11132,4,43,40,6,'0.09',0),
 (11133,4,44,40,0,'0.00',0),
 (11134,4,45,40,3,'0.05',0),
 (11135,4,46,40,3,'0.05',0),
 (11136,4,47,40,1,'0.02',0),
 (11137,4,48,40,0,'0.00',0),
 (11138,4,49,40,14,'0.22',0),
 (11139,4,50,40,1,'0.02',0),
 (11140,4,51,40,23,'0.36',0),
 (11141,4,1,41,758,'51.78',0),
 (11142,4,2,41,526,'35.93',0),
 (11143,4,14,41,0,'0.00',0),
 (11144,4,15,41,0,'0.00',0),
 (11145,4,16,41,0,'0.00',0),
 (11146,4,28,41,1,'0.07',0),
 (11147,4,32,41,0,'0.00',0),
 (11148,4,36,41,0,'0.00',0),
 (11149,4,38,41,128,'8.74',0),
 (11150,4,39,41,11,'0.75',0),
 (11151,4,40,41,0,'0.00',0),
 (11152,4,41,41,0,'0.00',0),
 (11153,4,42,41,1,'0.07',0),
 (11154,4,43,41,3,'0.20',0),
 (11155,4,44,41,0,'0.00',0),
 (11156,4,45,41,1,'0.07',0),
 (11157,4,46,41,1,'0.07',0),
 (11158,4,47,41,0,'0.00',0),
 (11159,4,48,41,0,'0.00',0),
 (11160,4,49,41,5,'0.34',0),
 (11161,4,50,41,1,'0.07',0),
 (11162,4,51,41,4,'0.27',0),
 (11163,4,1,42,302,'64.53',0),
 (11164,4,2,42,131,'27.99',0),
 (11165,4,14,42,0,'0.00',0),
 (11166,4,15,42,0,'0.00',0),
 (11167,4,16,42,1,'0.21',0),
 (11168,4,28,42,1,'0.21',0),
 (11169,4,32,42,0,'0.00',0),
 (11170,4,36,42,1,'0.21',0),
 (11171,4,38,42,24,'5.13',0),
 (11172,4,39,42,1,'0.21',0),
 (11173,4,40,42,0,'0.00',0),
 (11174,4,41,42,0,'0.00',0),
 (11175,4,42,42,0,'0.00',0),
 (11176,4,43,42,0,'0.00',0),
 (11177,4,44,42,1,'0.21',0),
 (11178,4,45,42,0,'0.00',0),
 (11179,4,46,42,0,'0.00',0),
 (11180,4,47,42,0,'0.00',0),
 (11181,4,48,42,0,'0.00',0),
 (11182,4,49,42,1,'0.21',0),
 (11183,4,50,42,0,'0.00',0),
 (11184,4,51,42,1,'0.21',0),
 (11185,4,1,43,1517,'55.06',0),
 (11186,4,2,43,1066,'38.69',0),
 (11187,4,14,43,0,'0.00',0),
 (11188,4,15,43,1,'0.04',0),
 (11189,4,16,43,2,'0.07',0),
 (11190,4,28,43,1,'0.04',0),
 (11191,4,32,43,0,'0.00',0),
 (11192,4,36,43,7,'0.25',0),
 (11193,4,38,43,112,'4.07',0),
 (11194,4,39,43,1,'0.04',0),
 (11195,4,40,43,0,'0.00',0),
 (11196,4,41,43,0,'0.00',0),
 (11197,4,42,43,1,'0.04',0),
 (11198,4,43,43,4,'0.15',0),
 (11199,4,44,43,0,'0.00',0),
 (11200,4,45,43,1,'0.04',0),
 (11201,4,46,43,2,'0.07',0),
 (11202,4,47,43,0,'0.00',0),
 (11203,4,48,43,0,'0.00',0),
 (11204,4,49,43,1,'0.04',0),
 (11205,4,50,43,0,'0.00',0),
 (11206,4,51,43,8,'0.29',0),
 (11207,4,1,44,1382,'51.03',0),
 (11208,4,2,44,987,'36.45',0),
 (11209,4,14,44,1,'0.04',0),
 (11210,4,15,44,1,'0.04',0),
 (11211,4,16,44,1,'0.04',0),
 (11212,4,28,44,2,'0.07',0),
 (11213,4,32,44,0,'0.00',0),
 (11214,4,36,44,6,'0.22',0),
 (11215,4,38,44,230,'8.49',0),
 (11216,4,39,44,14,'0.52',0),
 (11217,4,40,44,1,'0.04',0),
 (11218,4,41,44,1,'0.04',0),
 (11219,4,42,44,4,'0.15',0),
 (11220,4,43,44,6,'0.22',0),
 (11221,4,44,44,6,'0.22',0),
 (11222,4,45,44,0,'0.00',0),
 (11223,4,46,44,2,'0.07',0),
 (11224,4,47,44,0,'0.00',0),
 (11225,4,48,44,0,'0.00',0),
 (11226,4,49,44,8,'0.30',0),
 (11227,4,50,44,0,'0.00',0),
 (11228,4,51,44,12,'0.44',0),
 (11229,4,1,45,8088,'48.49',0),
 (11230,4,2,45,6411,'38.44',0),
 (11231,4,14,45,12,'0.07',0),
 (11232,4,15,45,13,'0.08',0),
 (11233,4,16,45,13,'0.08',0),
 (11234,4,28,45,10,'0.06',0),
 (11235,4,32,45,2,'0.01',0),
 (11236,4,36,45,14,'0.08',0),
 (11237,4,38,45,1403,'8.41',0),
 (11238,4,39,45,123,'0.74',0),
 (11239,4,40,45,18,'0.11',0),
 (11240,4,41,45,13,'0.08',0),
 (11241,4,42,45,7,'0.04',0),
 (11242,4,43,45,36,'0.22',0),
 (11243,4,44,45,10,'0.06',0),
 (11244,4,45,45,8,'0.05',0),
 (11245,4,46,45,13,'0.08',0),
 (11246,4,47,45,4,'0.02',0),
 (11247,4,48,45,0,'0.00',0),
 (11248,4,49,45,59,'0.35',0),
 (11249,4,50,45,5,'0.03',0),
 (11250,4,51,45,79,'0.47',0),
 (11251,4,1,46,1219,'53.89',0),
 (11252,4,2,46,741,'32.76',0),
 (11253,4,14,46,0,'0.00',0),
 (11254,4,15,46,0,'0.00',0),
 (11255,4,16,46,3,'0.13',0),
 (11256,4,28,46,0,'0.00',0),
 (11257,4,32,46,0,'0.00',0),
 (11258,4,36,46,2,'0.09',0),
 (11259,4,38,46,186,'8.22',0),
 (11260,4,39,46,15,'0.66',0),
 (11261,4,40,46,0,'0.00',0),
 (11262,4,41,46,0,'0.00',0),
 (11263,4,42,46,0,'0.00',0),
 (11264,4,43,46,4,'0.18',0),
 (11265,4,44,46,1,'0.04',0),
 (11266,4,45,46,0,'0.00',0),
 (11267,4,46,46,1,'0.04',0),
 (11268,4,47,46,0,'0.00',0),
 (11269,4,48,46,0,'0.00',0),
 (11270,4,49,46,10,'0.44',0),
 (11271,4,50,46,0,'0.00',0),
 (11272,4,51,46,33,'1.46',0),
 (11273,4,1,47,9185,'44.96',0),
 (11274,4,2,47,8614,'42.16',0),
 (11275,4,14,47,6,'0.03',0),
 (11276,4,15,47,16,'0.08',0),
 (11277,4,16,47,12,'0.06',0),
 (11278,4,28,47,7,'0.03',0),
 (11279,4,32,47,2,'0.01',0),
 (11280,4,36,47,21,'0.10',0),
 (11281,4,38,47,1573,'7.70',0),
 (11282,4,39,47,131,'0.64',0),
 (11283,4,40,47,6,'0.03',0),
 (11284,4,41,47,14,'0.07',0),
 (11285,4,42,47,14,'0.07',0),
 (11286,4,43,47,168,'0.82',0),
 (11287,4,44,47,10,'0.05',0),
 (11288,4,45,47,6,'0.03',0),
 (11289,4,46,47,15,'0.07',0),
 (11290,4,47,47,14,'0.07',0),
 (11291,4,48,47,0,'0.00',0),
 (11292,4,49,47,66,'0.32',0),
 (11293,4,50,47,3,'0.01',0),
 (11294,4,51,47,117,'0.57',0),
 (11295,4,1,48,118,'39.86',0),
 (11296,4,2,48,141,'47.64',0),
 (11297,4,14,48,0,'0.00',0),
 (11298,4,15,48,2,'0.68',0),
 (11299,4,16,48,0,'0.00',0),
 (11300,4,28,48,0,'0.00',0),
 (11301,4,32,48,0,'0.00',0),
 (11302,4,36,48,1,'0.34',0),
 (11303,4,38,48,30,'10.14',0),
 (11304,4,39,48,0,'0.00',0),
 (11305,4,40,48,0,'0.00',0),
 (11306,4,41,48,0,'0.00',0),
 (11307,4,42,48,0,'0.00',0),
 (11308,4,43,48,0,'0.00',0),
 (11309,4,44,48,0,'0.00',0),
 (11310,4,45,48,0,'0.00',0),
 (11311,4,46,48,0,'0.00',0),
 (11312,4,47,48,0,'0.00',0),
 (11313,4,48,48,0,'0.00',0),
 (11314,4,49,48,0,'0.00',0),
 (11315,4,50,48,0,'0.00',0),
 (11316,4,51,48,0,'0.00',0),
 (11317,4,1,49,13842,'37.06',0),
 (11318,4,2,49,17254,'46.19',0),
 (11319,4,14,49,16,'0.04',0),
 (11320,4,15,49,39,'0.10',0),
 (11321,4,16,49,25,'0.07',0),
 (11322,4,28,49,15,'0.04',0),
 (11323,4,32,49,25,'0.07',0),
 (11324,4,36,49,89,'0.24',0),
 (11325,4,38,49,4684,'12.54',0),
 (11326,4,39,49,249,'0.67',0),
 (11327,4,40,49,14,'0.04',0),
 (11328,4,41,49,22,'0.06',0),
 (11329,4,42,49,18,'0.05',0),
 (11330,4,43,49,76,'0.20',0),
 (11331,4,44,49,28,'0.07',0),
 (11332,4,45,49,21,'0.06',0),
 (11333,4,46,49,20,'0.05',0),
 (11334,4,47,49,9,'0.02',0),
 (11335,4,48,49,0,'0.00',0),
 (11336,4,49,49,85,'0.23',0),
 (11337,4,50,49,2,'0.01',0),
 (11338,4,51,49,203,'0.54',0),
 (11339,4,1,50,675,'65.47',0),
 (11340,4,2,50,287,'27.84',0),
 (11341,4,14,50,0,'0.00',0),
 (11342,4,15,50,1,'0.10',0),
 (11343,4,16,50,0,'0.00',0),
 (11344,4,28,50,1,'0.10',0),
 (11345,4,32,50,0,'0.00',0),
 (11346,4,36,50,0,'0.00',0),
 (11347,4,38,50,49,'4.75',0),
 (11348,4,39,50,3,'0.29',0),
 (11349,4,40,50,0,'0.00',0),
 (11350,4,41,50,1,'0.10',0),
 (11351,4,42,50,0,'0.00',0),
 (11352,4,43,50,0,'0.00',0),
 (11353,4,44,50,0,'0.00',0),
 (11354,4,45,50,0,'0.00',0),
 (11355,4,46,50,0,'0.00',0),
 (11356,4,47,50,0,'0.00',0),
 (11357,4,48,50,0,'0.00',0),
 (11358,4,49,50,2,'0.19',0),
 (11359,4,50,50,0,'0.00',0),
 (11360,4,51,50,2,'0.19',0),
 (11361,4,1,51,419,'55.42',0),
 (11362,4,2,51,272,'35.98',0),
 (11363,4,14,51,0,'0.00',0),
 (11364,4,15,51,1,'0.13',0),
 (11365,4,16,51,1,'0.13',0),
 (11366,4,28,51,1,'0.13',0),
 (11367,4,32,51,0,'0.00',0),
 (11368,4,36,51,0,'0.00',0),
 (11369,4,38,51,48,'6.35',0),
 (11370,4,39,51,2,'0.26',0),
 (11371,4,40,51,0,'0.00',0),
 (11372,4,41,51,0,'0.00',0),
 (11373,4,42,51,0,'0.00',0),
 (11374,4,43,51,0,'0.00',0),
 (11375,4,44,51,0,'0.00',0),
 (11376,4,45,51,1,'0.13',0),
 (11377,4,46,51,1,'0.13',0),
 (11378,4,47,51,0,'0.00',0),
 (11379,4,48,51,0,'0.00',0),
 (11380,4,49,51,3,'0.40',0),
 (11381,4,50,51,0,'0.00',0),
 (11382,4,51,51,3,'0.40',0),
 (11383,4,1,52,1285,'55.01',0),
 (11384,4,2,52,922,'39.47',0),
 (11385,4,14,52,0,'0.00',0),
 (11386,4,15,52,0,'0.00',0),
 (11387,4,16,52,1,'0.04',0),
 (11388,4,28,52,2,'0.09',0),
 (11389,4,32,52,1,'0.04',0),
 (11390,4,36,52,2,'0.09',0),
 (11391,4,38,52,90,'3.85',0),
 (11392,4,39,52,2,'0.09',0),
 (11393,4,40,52,1,'0.04',0),
 (11394,4,41,52,0,'0.00',0),
 (11395,4,42,52,0,'0.00',0),
 (11396,4,43,52,0,'0.00',0),
 (11397,4,44,52,3,'0.13',0),
 (11398,4,45,52,0,'0.00',0),
 (11399,4,46,52,1,'0.04',0),
 (11400,4,47,52,0,'0.00',0),
 (11401,4,48,52,0,'0.00',0),
 (11402,4,49,52,1,'0.04',0),
 (11403,4,50,52,0,'0.00',0),
 (11404,4,51,52,5,'0.21',0),
 (11405,4,1,53,1104,'45.19',0),
 (11406,4,2,53,1042,'42.65',0),
 (11407,4,14,53,0,'0.00',0),
 (11408,4,15,53,3,'0.12',0),
 (11409,4,16,53,1,'0.04',0),
 (11410,4,28,53,3,'0.12',0),
 (11411,4,32,53,0,'0.00',0),
 (11412,4,36,53,10,'0.41',0),
 (11413,4,38,53,210,'8.60',0),
 (11414,4,39,53,9,'0.37',0),
 (11415,4,40,53,0,'0.00',0),
 (11416,4,41,53,1,'0.04',0),
 (11417,4,42,53,0,'0.00',0),
 (11418,4,43,53,7,'0.29',0),
 (11419,4,44,53,0,'0.00',0),
 (11420,4,45,53,4,'0.16',0),
 (11421,4,46,53,1,'0.04',0),
 (11422,4,47,53,0,'0.00',0),
 (11423,4,48,53,0,'0.00',0),
 (11424,4,49,53,4,'0.16',0),
 (11425,4,50,53,0,'0.00',0),
 (11426,4,51,53,13,'0.53',0),
 (11427,4,1,54,2898,'51.27',0),
 (11428,4,2,54,2036,'36.02',0),
 (11429,4,14,54,4,'0.07',0),
 (11430,4,15,54,2,'0.04',0),
 (11431,4,16,54,1,'0.02',0),
 (11432,4,28,54,1,'0.02',0),
 (11433,4,32,54,1,'0.02',0),
 (11434,4,36,54,6,'0.11',0),
 (11435,4,38,54,491,'8.69',0),
 (11436,4,39,54,28,'0.50',0),
 (11437,4,40,54,0,'0.00',0),
 (11438,4,41,54,1,'0.02',0),
 (11439,4,42,54,2,'0.04',0),
 (11440,4,43,54,21,'0.37',0),
 (11441,4,44,54,2,'0.04',0),
 (11442,4,45,54,1,'0.02',0),
 (11443,4,46,54,6,'0.11',0),
 (11444,4,47,54,3,'0.05',0),
 (11445,4,48,54,0,'0.00',0),
 (11446,4,49,54,21,'0.37',0),
 (11447,4,50,54,0,'0.00',0),
 (11448,4,51,54,20,'0.35',0),
 (11449,4,1,55,354,'55.31',0),
 (11450,4,2,55,272,'42.50',0),
 (11451,4,14,55,0,'0.00',0),
 (11452,4,15,55,2,'0.31',0),
 (11453,4,16,55,2,'0.31',0),
 (11454,4,28,55,0,'0.00',0),
 (11455,4,32,55,0,'0.00',0),
 (11456,4,36,55,0,'0.00',0),
 (11457,4,38,55,7,'1.09',0),
 (11458,4,39,55,0,'0.00',0),
 (11459,4,40,55,0,'0.00',0),
 (11460,4,41,55,0,'0.00',0),
 (11461,4,42,55,0,'0.00',0),
 (11462,4,43,55,1,'0.16',0),
 (11463,4,44,55,0,'0.00',0),
 (11464,4,45,55,0,'0.00',0),
 (11465,4,46,55,0,'0.00',0),
 (11466,4,47,55,0,'0.00',0),
 (11467,4,48,55,0,'0.00',0),
 (11468,4,49,55,0,'0.00',0),
 (11469,4,50,55,0,'0.00',0),
 (11470,4,51,55,0,'0.00',0),
 (11471,4,1,56,184,'47.67',0),
 (11472,4,2,56,149,'38.60',0),
 (11473,4,14,56,0,'0.00',0),
 (11474,4,15,56,0,'0.00',0),
 (11475,4,16,56,0,'0.00',0),
 (11476,4,28,56,0,'0.00',0),
 (11477,4,32,56,0,'0.00',0),
 (11478,4,36,56,1,'0.26',0),
 (11479,4,38,56,38,'9.84',0),
 (11480,4,39,56,0,'0.00',0),
 (11481,4,40,56,0,'0.00',0),
 (11482,4,41,56,0,'0.00',0),
 (11483,4,42,56,1,'0.26',0),
 (11484,4,43,56,0,'0.00',0),
 (11485,4,44,56,0,'0.00',0),
 (11486,4,45,56,1,'0.26',0),
 (11487,4,46,56,0,'0.00',0),
 (11488,4,47,56,0,'0.00',0),
 (11489,4,48,56,0,'0.00',0),
 (11490,4,49,56,0,'0.00',0),
 (11491,4,50,56,0,'0.00',0),
 (11492,4,51,56,3,'0.78',0),
 (11493,4,1,57,241,'48.69',0),
 (11494,4,2,57,186,'37.58',0),
 (11495,4,14,57,0,'0.00',0),
 (11496,4,15,57,4,'0.81',0),
 (11497,4,16,57,4,'0.81',0),
 (11498,4,28,57,0,'0.00',0),
 (11499,4,32,57,3,'0.61',0),
 (11500,4,36,57,1,'0.20',0),
 (11501,4,38,57,35,'7.07',0),
 (11502,4,39,57,7,'1.41',0),
 (11503,4,40,57,0,'0.00',0),
 (11504,4,41,57,0,'0.00',0),
 (11505,4,42,57,0,'0.00',0),
 (11506,4,43,57,1,'0.20',0),
 (11507,4,44,57,1,'0.20',0),
 (11508,4,45,57,0,'0.00',0),
 (11509,4,46,57,0,'0.00',0),
 (11510,4,47,57,0,'0.00',0),
 (11511,4,48,57,0,'0.00',0),
 (11512,4,49,57,2,'0.40',0),
 (11513,4,50,57,0,'0.00',0),
 (11514,4,51,57,3,'0.61',0),
 (11515,4,1,58,25347,'32.53',0),
 (11516,4,2,58,43300,'55.57',0),
 (11517,4,14,58,43,'0.06',0),
 (11518,4,15,58,87,'0.11',0),
 (11519,4,16,58,77,'0.10',0),
 (11520,4,28,58,101,'0.13',0),
 (11521,4,32,58,4,'0.01',0),
 (11522,4,36,58,114,'0.15',0),
 (11523,4,38,58,6102,'7.83',0),
 (11524,4,39,58,639,'0.82',0),
 (11525,4,40,58,31,'0.04',0),
 (11526,4,41,58,32,'0.04',0),
 (11527,4,42,58,43,'0.06',0),
 (11528,4,43,58,153,'0.20',0),
 (11529,4,44,58,45,'0.06',0),
 (11530,4,45,58,42,'0.05',0),
 (11531,4,46,58,50,'0.06',0),
 (11532,4,47,58,22,'0.03',0),
 (11533,4,48,58,0,'0.00',0),
 (11534,4,49,58,160,'0.21',0),
 (11535,4,50,58,22,'0.03',0),
 (11536,4,51,58,420,'0.54',0),
 (11537,4,1,59,1190,'52.26',0),
 (11538,4,2,59,871,'38.25',0),
 (11539,4,14,59,1,'0.04',0),
 (11540,4,15,59,1,'0.04',0),
 (11541,4,16,59,1,'0.04',0),
 (11542,4,28,59,2,'0.09',0),
 (11543,4,32,59,0,'0.00',0),
 (11544,4,36,59,0,'0.00',0),
 (11545,4,38,59,140,'6.15',0),
 (11546,4,39,59,8,'0.35',0),
 (11547,4,40,59,1,'0.04',0),
 (11548,4,41,59,1,'0.04',0),
 (11549,4,42,59,0,'0.00',0),
 (11550,4,43,59,5,'0.22',0),
 (11551,4,44,59,0,'0.00',0),
 (11552,4,45,59,1,'0.04',0),
 (11553,4,46,59,0,'0.00',0),
 (11554,4,47,59,0,'0.00',0),
 (11555,4,48,59,0,'0.00',0),
 (11556,4,49,59,3,'0.13',0),
 (11557,4,50,59,1,'0.04',0),
 (11558,4,51,59,16,'0.70',0),
 (11559,4,1,60,269,'29.02',0),
 (11560,4,2,60,522,'56.31',0),
 (11561,4,14,60,0,'0.00',0),
 (11562,4,15,60,0,'0.00',0),
 (11563,4,16,60,1,'0.11',0),
 (11564,4,28,60,0,'0.00',0),
 (11565,4,32,60,0,'0.00',0),
 (11566,4,36,60,0,'0.00',0),
 (11567,4,38,60,116,'12.51',0),
 (11568,4,39,60,2,'0.22',0),
 (11569,4,40,60,0,'0.00',0),
 (11570,4,41,60,1,'0.11',0),
 (11571,4,42,60,0,'0.00',0),
 (11572,4,43,60,2,'0.22',0),
 (11573,4,44,60,0,'0.00',0),
 (11574,4,45,60,0,'0.00',0),
 (11575,4,46,60,0,'0.00',0),
 (11576,4,47,60,0,'0.00',0),
 (11577,4,48,60,0,'0.00',0),
 (11578,4,49,60,0,'0.00',0),
 (11579,4,50,60,0,'0.00',0),
 (11580,4,51,60,0,'0.00',0),
 (11581,4,1,61,6188,'56.31',0),
 (11582,4,2,61,3543,'32.24',0),
 (11583,4,14,61,3,'0.03',0),
 (11584,4,15,61,6,'0.05',0),
 (11585,4,16,61,7,'0.06',0),
 (11586,4,28,61,9,'0.08',0),
 (11587,4,32,61,0,'0.00',0),
 (11588,4,36,61,7,'0.06',0),
 (11589,4,38,61,780,'7.10',0),
 (11590,4,39,61,67,'0.61',0),
 (11591,4,40,61,3,'0.03',0),
 (11592,4,41,61,3,'0.03',0),
 (11593,4,42,61,4,'0.04',0),
 (11594,4,43,61,31,'0.28',0),
 (11595,4,44,61,27,'0.25',0),
 (11596,4,45,61,4,'0.04',0),
 (11597,4,46,61,17,'0.15',0),
 (11598,4,47,61,3,'0.03',0),
 (11599,4,48,61,0,'0.00',0),
 (11600,4,49,61,36,'0.33',0),
 (11601,4,50,61,0,'0.00',0),
 (11602,4,51,61,48,'0.44',0),
 (11603,4,1,62,132,'66.00',0),
 (11604,4,2,62,58,'29.00',0),
 (11605,4,14,62,0,'0.00',0),
 (11606,4,15,62,0,'0.00',0),
 (11607,4,16,62,0,'0.00',0),
 (11608,4,28,62,0,'0.00',0),
 (11609,4,32,62,0,'0.00',0),
 (11610,4,36,62,0,'0.00',0),
 (11611,4,38,62,4,'2.00',0),
 (11612,4,39,62,1,'0.50',0),
 (11613,4,40,62,0,'0.00',0),
 (11614,4,41,62,0,'0.00',0),
 (11615,4,42,62,0,'0.00',0),
 (11616,4,43,62,0,'0.00',0),
 (11617,4,44,62,0,'0.00',0),
 (11618,4,45,62,0,'0.00',0),
 (11619,4,46,62,0,'0.00',0),
 (11620,4,47,62,0,'0.00',0),
 (11621,4,48,62,0,'0.00',0),
 (11622,4,49,62,0,'0.00',0),
 (11623,4,50,62,0,'0.00',0),
 (11624,4,51,62,1,'0.50',0),
 (11625,4,1,63,80,'50.00',0),
 (11626,4,2,63,59,'36.88',0),
 (11627,4,14,63,0,'0.00',0),
 (11628,4,15,63,0,'0.00',0),
 (11629,4,16,63,0,'0.00',0),
 (11630,4,28,63,0,'0.00',0),
 (11631,4,32,63,0,'0.00',0),
 (11632,4,36,63,0,'0.00',0),
 (11633,4,38,63,16,'10.00',0),
 (11634,4,39,63,1,'0.63',0),
 (11635,4,40,63,0,'0.00',0),
 (11636,4,41,63,0,'0.00',0),
 (11637,4,42,63,0,'0.00',0),
 (11638,4,43,63,0,'0.00',0),
 (11639,4,44,63,0,'0.00',0),
 (11640,4,45,63,0,'0.00',0),
 (11641,4,46,63,0,'0.00',0),
 (11642,4,47,63,0,'0.00',0),
 (11643,4,48,63,0,'0.00',0),
 (11644,4,49,63,0,'0.00',0),
 (11645,4,50,63,0,'0.00',0),
 (11646,4,51,63,2,'1.25',0),
 (11647,4,1,64,53,'55.79',0),
 (11648,4,2,64,36,'37.89',0),
 (11649,4,14,64,0,'0.00',0),
 (11650,4,15,64,0,'0.00',0),
 (11651,4,16,64,0,'0.00',0),
 (11652,4,28,64,0,'0.00',0),
 (11653,4,32,64,0,'0.00',0),
 (11654,4,36,64,0,'0.00',0),
 (11655,4,38,64,5,'5.26',0),
 (11656,4,39,64,1,'1.05',0),
 (11657,4,40,64,0,'0.00',0),
 (11658,4,41,64,0,'0.00',0),
 (11659,4,42,64,0,'0.00',0),
 (11660,4,43,64,0,'0.00',0),
 (11661,4,44,64,0,'0.00',0),
 (11662,4,45,64,0,'0.00',0),
 (11663,4,46,64,0,'0.00',0),
 (11664,4,47,64,0,'0.00',0),
 (11665,4,48,64,0,'0.00',0),
 (11666,4,49,64,0,'0.00',0),
 (11667,4,50,64,0,'0.00',0),
 (11668,4,51,64,0,'0.00',0),
 (11669,4,1,65,27897,'35.91',0),
 (11670,4,2,65,37033,'47.67',0),
 (11671,4,14,65,30,'0.04',0),
 (11672,4,15,65,83,'0.11',0),
 (11673,4,16,65,50,'0.06',0),
 (11674,4,28,65,54,'0.07',0),
 (11675,4,32,65,27,'0.03',0),
 (11676,4,36,65,86,'0.11',0),
 (11677,4,38,65,9606,'12.36',0),
 (11678,4,39,65,471,'0.61',0),
 (11679,4,40,65,25,'0.03',0),
 (11680,4,41,65,48,'0.06',0),
 (11681,4,42,65,39,'0.05',0),
 (11682,4,43,65,175,'0.23',0),
 (11683,4,44,65,50,'0.06',0),
 (11684,4,45,65,44,'0.06',0),
 (11685,4,46,65,40,'0.05',0),
 (11686,4,47,65,19,'0.02',0),
 (11687,4,48,65,0,'0.00',0),
 (11688,4,49,65,195,'0.25',0),
 (11689,4,50,65,21,'0.03',0),
 (11690,4,51,65,389,'0.50',0),
 (11691,4,1,66,2074,'65.24',0),
 (11692,4,2,66,861,'27.08',0),
 (11693,4,14,66,0,'0.00',0),
 (11694,4,15,66,3,'0.09',0),
 (11695,4,16,66,0,'0.00',0),
 (11696,4,28,66,1,'0.03',0),
 (11697,4,32,66,0,'0.00',0),
 (11698,4,36,66,0,'0.00',0),
 (11699,4,38,66,130,'4.09',0),
 (11700,4,39,66,22,'0.69',0),
 (11701,4,40,66,1,'0.03',0),
 (11702,4,41,66,1,'0.03',0),
 (11703,4,42,66,0,'0.00',0),
 (11704,4,43,66,5,'0.16',0),
 (11705,4,44,66,5,'0.16',0),
 (11706,4,45,66,2,'0.06',0),
 (11707,4,46,66,0,'0.00',0),
 (11708,4,47,66,0,'0.00',0),
 (11709,4,48,66,0,'0.00',0),
 (11710,4,49,66,7,'0.22',0),
 (11711,4,50,66,0,'0.00',0),
 (11712,4,51,66,12,'0.38',0),
 (11713,4,1,67,917,'48.62',0),
 (11714,4,2,67,753,'39.93',0),
 (11715,4,14,67,1,'0.05',0),
 (11716,4,15,67,0,'0.00',0),
 (11717,4,16,67,3,'0.16',0),
 (11718,4,28,67,1,'0.05',0),
 (11719,4,32,67,0,'0.00',0),
 (11720,4,36,67,6,'0.32',0),
 (11721,4,38,67,156,'8.27',0),
 (11722,4,39,67,8,'0.42',0),
 (11723,4,40,67,0,'0.00',0),
 (11724,4,41,67,1,'0.05',0),
 (11725,4,42,67,0,'0.00',0),
 (11726,4,43,67,1,'0.05',0),
 (11727,4,44,67,1,'0.05',0),
 (11728,4,45,67,0,'0.00',0),
 (11729,4,46,67,3,'0.16',0),
 (11730,4,47,67,1,'0.05',0),
 (11731,4,48,67,0,'0.00',0),
 (11732,4,49,67,6,'0.32',0),
 (11733,4,50,67,1,'0.05',0),
 (11734,4,51,67,2,'0.11',0),
 (11735,4,1,68,3064,'56.91',0),
 (11736,4,2,68,1891,'35.12',0),
 (11737,4,14,68,0,'0.00',0),
 (11738,4,15,68,3,'0.06',0),
 (11739,4,16,68,5,'0.09',0),
 (11740,4,28,68,1,'0.02',0),
 (11741,4,32,68,1,'0.02',0),
 (11742,4,36,68,9,'0.17',0),
 (11743,4,38,68,257,'4.77',0),
 (11744,4,39,68,20,'0.37',0),
 (11745,4,40,68,1,'0.02',0),
 (11746,4,41,68,4,'0.07',0),
 (11747,4,42,68,2,'0.04',0),
 (11748,4,43,68,13,'0.24',0),
 (11749,4,44,68,1,'0.02',0),
 (11750,4,45,68,1,'0.02',0),
 (11751,4,46,68,0,'0.00',0),
 (11752,4,47,68,1,'0.02',0),
 (11753,4,48,68,0,'0.00',0),
 (11754,4,49,68,10,'0.19',0),
 (11755,4,50,68,4,'0.07',0),
 (11756,4,51,68,16,'0.30',0),
 (11757,4,1,69,37,'57.81',0),
 (11758,4,2,69,15,'23.44',0),
 (11759,4,14,69,0,'0.00',0),
 (11760,4,15,69,0,'0.00',0),
 (11761,4,16,69,0,'0.00',0),
 (11762,4,28,69,0,'0.00',0),
 (11763,4,32,69,0,'0.00',0),
 (11764,4,36,69,0,'0.00',0),
 (11765,4,38,69,7,'10.94',0),
 (11766,4,39,69,2,'3.13',0),
 (11767,4,40,69,1,'1.56',0),
 (11768,4,41,69,0,'0.00',0),
 (11769,4,42,69,0,'0.00',0),
 (11770,4,43,69,0,'0.00',0),
 (11771,4,44,69,0,'0.00',0),
 (11772,4,45,69,0,'0.00',0),
 (11773,4,46,69,0,'0.00',0),
 (11774,4,47,69,0,'0.00',0),
 (11775,4,48,69,0,'0.00',0),
 (11776,4,49,69,0,'0.00',0),
 (11777,4,50,69,0,'0.00',0),
 (11778,4,51,69,1,'1.56',0),
 (11779,4,1,70,59,'66.29',0),
 (11780,4,2,70,21,'23.60',0),
 (11781,4,14,70,0,'0.00',0),
 (11782,4,15,70,0,'0.00',0),
 (11783,4,16,70,0,'0.00',0),
 (11784,4,28,70,0,'0.00',0),
 (11785,4,32,70,0,'0.00',0),
 (11786,4,36,70,0,'0.00',0),
 (11787,4,38,70,7,'7.87',0),
 (11788,4,39,70,0,'0.00',0),
 (11789,4,40,70,0,'0.00',0),
 (11790,4,41,70,0,'0.00',0),
 (11791,4,42,70,1,'1.12',0),
 (11792,4,43,70,0,'0.00',0),
 (11793,4,44,70,1,'1.12',0),
 (11794,4,45,70,0,'0.00',0),
 (11795,4,46,70,0,'0.00',0),
 (11796,4,47,70,0,'0.00',0),
 (11797,4,48,70,0,'0.00',0),
 (11798,4,49,70,0,'0.00',0),
 (11799,4,50,70,0,'0.00',0),
 (11800,4,51,70,0,'0.00',0),
 (11801,4,1,71,37,'60.66',0),
 (11802,4,2,71,18,'29.51',0),
 (11803,4,14,71,0,'0.00',0),
 (11804,4,15,71,0,'0.00',0),
 (11805,4,16,71,0,'0.00',0),
 (11806,4,28,71,0,'0.00',0),
 (11807,4,32,71,0,'0.00',0),
 (11808,4,36,71,0,'0.00',0),
 (11809,4,38,71,3,'4.92',0),
 (11810,4,39,71,0,'0.00',0),
 (11811,4,40,71,1,'1.64',0),
 (11812,4,41,71,0,'0.00',0),
 (11813,4,42,71,0,'0.00',0),
 (11814,4,43,71,0,'0.00',0),
 (11815,4,44,71,0,'0.00',0),
 (11816,4,45,71,0,'0.00',0),
 (11817,4,46,71,0,'0.00',0),
 (11818,4,47,71,0,'0.00',0),
 (11819,4,48,71,0,'0.00',0),
 (11820,4,49,71,0,'0.00',0),
 (11821,4,50,71,0,'0.00',0),
 (11822,4,51,71,2,'3.28',0),
 (11823,4,1,72,1875,'60.19',0),
 (11824,4,2,72,845,'27.13',0),
 (11825,4,14,72,1,'0.03',0),
 (11826,4,15,72,1,'0.03',0),
 (11827,4,16,72,3,'0.10',0),
 (11828,4,28,72,2,'0.06',0),
 (11829,4,32,72,0,'0.00',0),
 (11830,4,36,72,4,'0.13',0),
 (11831,4,38,72,263,'8.44',0),
 (11832,4,39,72,21,'0.67',0),
 (11833,4,40,72,1,'0.03',0),
 (11834,4,41,72,4,'0.13',0),
 (11835,4,42,72,3,'0.10',0),
 (11836,4,43,72,10,'0.32',0),
 (11837,4,44,72,3,'0.10',0),
 (11838,4,45,72,0,'0.00',0),
 (11839,4,46,72,1,'0.03',0),
 (11840,4,47,72,2,'0.06',0),
 (11841,4,48,72,0,'0.00',0),
 (11842,4,49,72,13,'0.42',0),
 (11843,4,50,72,0,'0.00',0),
 (11844,4,51,72,15,'0.48',0),
 (11845,4,1,73,1804,'44.14',0),
 (11846,4,2,73,1675,'40.98',0),
 (11847,4,14,73,2,'0.05',0),
 (11848,4,15,73,4,'0.10',0),
 (11849,4,16,73,5,'0.12',0),
 (11850,4,28,73,2,'0.05',0),
 (11851,4,32,73,1,'0.02',0),
 (11852,4,36,73,8,'0.20',0),
 (11853,4,38,73,400,'9.79',0),
 (11854,4,39,73,23,'0.56',0),
 (11855,4,40,73,7,'0.17',0),
 (11856,4,41,73,2,'0.05',0),
 (11857,4,42,73,2,'0.05',0),
 (11858,4,43,73,21,'0.51',0),
 (11859,4,44,73,4,'0.10',0),
 (11860,4,45,73,1,'0.02',0),
 (11861,4,46,73,4,'0.10',0),
 (11862,4,47,73,1,'0.02',0),
 (11863,4,48,73,0,'0.00',0),
 (11864,4,49,73,19,'0.46',0),
 (11865,4,50,73,0,'0.00',0),
 (11866,4,51,73,38,'0.93',0),
 (11867,4,1,74,30965,'35.21',0),
 (11868,4,2,74,44355,'50.43',0),
 (11869,4,14,74,36,'0.04',0),
 (11870,4,15,74,110,'0.13',0),
 (11871,4,16,74,60,'0.07',0),
 (11872,4,28,74,61,'0.07',0),
 (11873,4,32,74,21,'0.02',0),
 (11874,4,36,74,132,'0.15',0),
 (11875,4,38,74,9063,'10.31',0),
 (11876,4,39,74,603,'0.69',0),
 (11877,4,40,74,24,'0.03',0),
 (11878,4,41,74,61,'0.07',0),
 (11879,4,42,74,51,'0.06',0),
 (11880,4,43,74,237,'0.27',0),
 (11881,4,44,74,51,'0.06',0),
 (11882,4,45,74,38,'0.04',0),
 (11883,4,46,74,40,'0.05',0),
 (11884,4,47,74,39,'0.04',0),
 (11885,4,48,74,0,'0.00',0),
 (11886,4,49,74,224,'0.25',0),
 (11887,4,50,74,15,'0.02',0),
 (11888,4,51,74,484,'0.55',0),
 (11889,4,1,75,908,'48.53',0),
 (11890,4,2,75,770,'41.15',0),
 (11891,4,14,75,0,'0.00',0),
 (11892,4,15,75,1,'0.05',0),
 (11893,4,16,75,3,'0.16',0),
 (11894,4,28,75,1,'0.05',0),
 (11895,4,32,75,0,'0.00',0),
 (11896,4,36,75,1,'0.05',0),
 (11897,4,38,75,153,'8.18',0),
 (11898,4,39,75,5,'0.27',0),
 (11899,4,40,75,1,'0.05',0),
 (11900,4,41,75,0,'0.00',0),
 (11901,4,42,75,0,'0.00',0),
 (11902,4,43,75,3,'0.16',0),
 (11903,4,44,75,1,'0.05',0),
 (11904,4,45,75,0,'0.00',0),
 (11905,4,46,75,2,'0.11',0),
 (11906,4,47,75,2,'0.11',0),
 (11907,4,48,75,0,'0.00',0),
 (11908,4,49,75,0,'0.00',0),
 (11909,4,50,75,1,'0.05',0),
 (11910,4,51,75,6,'0.32',0),
 (11911,4,1,76,146,'49.49',0),
 (11912,4,2,76,130,'44.07',0),
 (11913,4,14,76,0,'0.00',0),
 (11914,4,15,76,1,'0.34',0),
 (11915,4,16,76,0,'0.00',0),
 (11916,4,28,76,2,'0.68',0),
 (11917,4,32,76,0,'0.00',0),
 (11918,4,36,76,1,'0.34',0),
 (11919,4,38,76,9,'3.05',0),
 (11920,4,39,76,2,'0.68',0),
 (11921,4,40,76,0,'0.00',0),
 (11922,4,41,76,0,'0.00',0),
 (11923,4,42,76,0,'0.00',0),
 (11924,4,43,76,1,'0.34',0),
 (11925,4,44,76,0,'0.00',0),
 (11926,4,45,76,0,'0.00',0),
 (11927,4,46,76,0,'0.00',0),
 (11928,4,47,76,0,'0.00',0),
 (11929,4,48,76,0,'0.00',0),
 (11930,4,49,76,2,'0.68',0),
 (11931,4,50,76,0,'0.00',0),
 (11932,4,51,76,0,'0.00',0),
 (11933,4,1,78,15,'62.50',0),
 (11934,4,2,78,5,'20.83',0),
 (11935,4,14,78,0,'0.00',0),
 (11936,4,15,78,0,'0.00',0),
 (11937,4,16,78,0,'0.00',0),
 (11938,4,28,78,0,'0.00',0),
 (11939,4,32,78,0,'0.00',0),
 (11940,4,36,78,0,'0.00',0),
 (11941,4,38,78,3,'12.50',0),
 (11942,4,39,78,0,'0.00',0),
 (11943,4,40,78,0,'0.00',0),
 (11944,4,41,78,0,'0.00',0),
 (11945,4,42,78,0,'0.00',0),
 (11946,4,43,78,0,'0.00',0),
 (11947,4,44,78,0,'0.00',0),
 (11948,4,45,78,0,'0.00',0),
 (11949,4,46,78,0,'0.00',0),
 (11950,4,47,78,0,'0.00',0),
 (11951,4,48,78,0,'0.00',0),
 (11952,4,49,78,0,'0.00',0),
 (11953,4,50,78,0,'0.00',0),
 (11954,4,51,78,1,'4.17',0),
 (11955,4,1,79,791306,'51.17',0),
 (11956,4,2,79,565496,'36.56',0),
 (11957,4,14,79,695,'0.04',0),
 (11958,4,15,79,800,'0.05',0),
 (11959,4,16,79,1091,'0.07',0),
 (11960,4,28,79,1250,'0.08',0),
 (11961,4,32,79,268,'0.02',0),
 (11962,4,36,79,1429,'0.09',0),
 (11963,4,38,79,129260,'8.36',0),
 (11964,4,39,79,6755,'0.44',0),
 (11965,4,40,79,674,'0.04',0),
 (11966,4,41,79,751,'0.05',0),
 (11967,4,42,79,759,'0.05',0),
 (11968,4,43,79,3343,'0.22',0),
 (11969,4,44,79,815,'0.05',0),
 (11970,4,45,79,624,'0.04',0),
 (11971,4,46,79,1288,'0.08',0),
 (11972,4,47,79,454,'0.03',0),
 (11973,4,48,79,0,'0.00',0),
 (11974,4,49,79,4962,'0.32',0),
 (11975,4,50,79,216,'0.01',0),
 (11976,4,51,79,6204,'0.40',0),
 (11977,4,1,80,17082,'63.37',0),
 (11978,4,2,80,6748,'25.03',0),
 (11979,4,14,80,15,'0.06',0),
 (11980,4,15,80,8,'0.03',0),
 (11981,4,16,80,15,'0.06',0),
 (11982,4,28,80,17,'0.06',0),
 (11983,4,32,80,7,'0.03',0),
 (11984,4,36,80,12,'0.04',0),
 (11985,4,38,80,1650,'6.12',0),
 (11986,4,39,80,143,'0.53',0),
 (11987,4,40,80,14,'0.05',0),
 (11988,4,41,80,9,'0.03',0),
 (11989,4,42,80,8,'0.03',0),
 (11990,4,43,80,75,'0.28',0),
 (11991,4,44,80,18,'0.07',0),
 (11992,4,45,80,8,'0.03',0),
 (11993,4,46,80,33,'0.12',0),
 (11994,4,47,80,29,'0.11',0),
 (11995,4,48,80,0,'0.00',0),
 (11996,4,49,80,134,'0.50',0),
 (11997,4,50,80,4,'0.01',0),
 (11998,4,51,80,156,'0.58',0),
 (11999,4,1,82,1342,'57.08',0),
 (12000,4,2,82,720,'30.63',0),
 (12001,4,14,82,3,'0.13',0),
 (12002,4,15,82,2,'0.09',0),
 (12003,4,16,82,2,'0.09',0),
 (12004,4,28,82,0,'0.00',0),
 (12005,4,32,82,1,'0.04',0),
 (12006,4,36,82,4,'0.17',0),
 (12007,4,38,82,203,'8.63',0),
 (12008,4,39,82,12,'0.51',0),
 (12009,4,40,82,0,'0.00',0),
 (12010,4,41,82,3,'0.13',0),
 (12011,4,42,82,2,'0.09',0),
 (12012,4,43,82,1,'0.04',0),
 (12013,4,44,82,0,'0.00',0),
 (12014,4,45,82,2,'0.09',0),
 (12015,4,46,82,0,'0.00',0),
 (12016,4,47,82,2,'0.09',0),
 (12017,4,48,82,0,'0.00',0),
 (12018,4,49,82,11,'0.47',0),
 (12019,4,50,82,0,'0.00',0),
 (12020,4,51,82,8,'0.34',0),
 (12021,4,1,83,1439,'44.62',0),
 (12022,4,2,83,1340,'41.55',0),
 (12023,4,14,83,2,'0.06',0),
 (12024,4,15,83,2,'0.06',0),
 (12025,4,16,83,2,'0.06',0),
 (12026,4,28,83,2,'0.06',0),
 (12027,4,32,83,3,'0.09',0),
 (12028,4,36,83,19,'0.59',0),
 (12029,4,38,83,295,'9.15',0),
 (12030,4,39,83,33,'1.02',0),
 (12031,4,40,83,0,'0.00',0),
 (12032,4,41,83,2,'0.06',0),
 (12033,4,42,83,1,'0.03',0),
 (12034,4,43,83,18,'0.56',0),
 (12035,4,44,83,1,'0.03',0),
 (12036,4,45,83,2,'0.06',0),
 (12037,4,46,83,1,'0.03',0),
 (12038,4,47,83,3,'0.09',0),
 (12039,4,48,83,0,'0.00',0),
 (12040,4,49,83,10,'0.31',0),
 (12041,4,50,83,2,'0.06',0),
 (12042,4,51,83,16,'0.50',0),
 (12043,4,1,84,2631,'37.36',0),
 (12044,4,2,84,3420,'48.56',0),
 (12045,4,14,84,1,'0.01',0),
 (12046,4,15,84,4,'0.06',0),
 (12047,4,16,84,2,'0.03',0),
 (12048,4,28,84,5,'0.07',0),
 (12049,4,32,84,1,'0.01',0),
 (12050,4,36,84,16,'0.23',0),
 (12051,4,38,84,779,'11.06',0),
 (12052,4,39,84,39,'0.55',0),
 (12053,4,40,84,2,'0.03',0),
 (12054,4,41,84,2,'0.03',0),
 (12055,4,42,84,10,'0.14',0),
 (12056,4,43,84,6,'0.09',0),
 (12057,4,44,84,0,'0.00',0),
 (12058,4,45,84,2,'0.03',0),
 (12059,4,46,84,6,'0.09',0),
 (12060,4,47,84,1,'0.01',0),
 (12061,4,48,84,0,'0.00',0),
 (12062,4,49,84,14,'0.20',0),
 (12063,4,50,84,1,'0.01',0),
 (12064,4,51,84,35,'0.50',0),
 (12065,4,1,85,1025,'48.08',0),
 (12066,4,2,85,905,'42.45',0),
 (12067,4,14,85,0,'0.00',0),
 (12068,4,15,85,0,'0.00',0),
 (12069,4,16,85,3,'0.14',0),
 (12070,4,28,85,2,'0.09',0),
 (12071,4,32,85,1,'0.05',0),
 (12072,4,36,85,1,'0.05',0),
 (12073,4,38,85,159,'7.46',0),
 (12074,4,39,85,6,'0.28',0),
 (12075,4,40,85,1,'0.05',0),
 (12076,4,41,85,0,'0.00',0),
 (12077,4,42,85,0,'0.00',0),
 (12078,4,43,85,5,'0.23',0),
 (12079,4,44,85,0,'0.00',0),
 (12080,4,45,85,1,'0.05',0),
 (12081,4,46,85,0,'0.00',0),
 (12082,4,47,85,2,'0.09',0),
 (12083,4,48,85,0,'0.00',0),
 (12084,4,49,85,3,'0.14',0),
 (12085,4,50,85,0,'0.00',0),
 (12086,4,51,85,5,'0.23',0),
 (12087,4,1,86,992,'55.86',0),
 (12088,4,2,86,651,'36.66',0),
 (12089,4,14,86,0,'0.00',0),
 (12090,4,15,86,0,'0.00',0),
 (12091,4,16,86,2,'0.11',0),
 (12092,4,28,86,4,'0.23',0),
 (12093,4,32,86,0,'0.00',0),
 (12094,4,36,86,2,'0.11',0),
 (12095,4,38,86,79,'4.45',0),
 (12096,4,39,86,7,'0.39',0),
 (12097,4,40,86,1,'0.06',0),
 (12098,4,41,86,2,'0.11',0),
 (12099,4,42,86,2,'0.11',0),
 (12100,4,43,86,4,'0.23',0),
 (12101,4,44,86,1,'0.06',0),
 (12102,4,45,86,0,'0.00',0),
 (12103,4,46,86,1,'0.06',0),
 (12104,4,47,86,4,'0.23',0),
 (12105,4,48,86,0,'0.00',0),
 (12106,4,49,86,1,'0.06',0),
 (12107,4,50,86,0,'0.00',0),
 (12108,4,51,86,2,'0.11',0),
 (12109,4,1,87,1056,'56.44',0),
 (12110,4,2,87,638,'34.10',0),
 (12111,4,14,87,0,'0.00',0),
 (12112,4,15,87,0,'0.00',0),
 (12113,4,16,87,1,'0.05',0),
 (12114,4,28,87,2,'0.11',0),
 (12115,4,32,87,0,'0.00',0),
 (12116,4,36,87,2,'0.11',0),
 (12117,4,38,87,113,'6.04',0),
 (12118,4,39,87,6,'0.32',0),
 (12119,4,40,87,0,'0.00',0),
 (12120,4,41,87,2,'0.11',0),
 (12121,4,42,87,0,'0.00',0),
 (12122,4,43,87,4,'0.21',0),
 (12123,4,44,87,2,'0.11',0),
 (12124,4,45,87,0,'0.00',0),
 (12125,4,46,87,1,'0.05',0),
 (12126,4,47,87,0,'0.00',0),
 (12127,4,48,87,0,'0.00',0),
 (12128,4,49,87,1,'0.05',0),
 (12129,4,50,87,0,'0.00',0),
 (12130,4,51,87,9,'0.48',0),
 (12131,4,1,88,85,'47.22',0),
 (12132,4,2,88,77,'42.78',0),
 (12133,4,14,88,0,'0.00',0),
 (12134,4,15,88,0,'0.00',0),
 (12135,4,16,88,0,'0.00',0),
 (12136,4,28,88,0,'0.00',0),
 (12137,4,32,88,0,'0.00',0),
 (12138,4,36,88,0,'0.00',0),
 (12139,4,38,88,15,'8.33',0),
 (12140,4,39,88,1,'0.56',0),
 (12141,4,40,88,0,'0.00',0),
 (12142,4,41,88,0,'0.00',0),
 (12143,4,42,88,0,'0.00',0),
 (12144,4,43,88,0,'0.00',0),
 (12145,4,44,88,0,'0.00',0),
 (12146,4,45,88,0,'0.00',0),
 (12147,4,46,88,1,'0.56',0),
 (12148,4,47,88,0,'0.00',0),
 (12149,4,48,88,0,'0.00',0),
 (12150,4,49,88,0,'0.00',0),
 (12151,4,50,88,0,'0.00',0),
 (12152,4,51,88,0,'0.00',0),
 (12153,4,1,89,988,'57.31',0),
 (12154,4,2,89,601,'34.86',0),
 (12155,4,14,89,0,'0.00',0),
 (12156,4,15,89,1,'0.06',0),
 (12157,4,16,89,2,'0.12',0),
 (12158,4,28,89,0,'0.00',0),
 (12159,4,32,89,0,'0.00',0),
 (12160,4,36,89,2,'0.12',0),
 (12161,4,38,89,88,'5.10',0),
 (12162,4,39,89,5,'0.29',0),
 (12163,4,40,89,0,'0.00',0),
 (12164,4,41,89,0,'0.00',0),
 (12165,4,42,89,0,'0.00',0),
 (12166,4,43,89,0,'0.00',0),
 (12167,4,44,89,0,'0.00',0),
 (12168,4,45,89,0,'0.00',0),
 (12169,4,46,89,1,'0.06',0),
 (12170,4,47,89,0,'0.00',0),
 (12171,4,48,89,0,'0.00',0),
 (12172,4,49,89,2,'0.12',0),
 (12173,4,50,89,0,'0.00',0),
 (12174,4,51,89,10,'0.58',0),
 (12175,4,1,90,1904,'50.88',0),
 (12176,4,2,90,1338,'35.76',0),
 (12177,4,14,90,0,'0.00',0),
 (12178,4,15,90,1,'0.03',0),
 (12179,4,16,90,8,'0.21',0),
 (12180,4,28,90,12,'0.32',0),
 (12181,4,32,90,1,'0.03',0),
 (12182,4,36,90,1,'0.03',0),
 (12183,4,38,90,317,'8.47',0),
 (12184,4,39,90,23,'0.61',0),
 (12185,4,40,90,3,'0.08',0),
 (12186,4,41,90,2,'0.05',0),
 (12187,4,42,90,1,'0.03',0),
 (12188,4,43,90,13,'0.35',0),
 (12189,4,44,90,6,'0.16',0),
 (12190,4,45,90,0,'0.00',0),
 (12191,4,46,90,3,'0.08',0),
 (12192,4,47,90,2,'0.05',0),
 (12193,4,48,90,0,'0.00',0),
 (12194,4,49,90,11,'0.29',0),
 (12195,4,50,90,0,'0.00',0),
 (12196,4,51,90,30,'0.80',0),
 (12197,4,1,91,1281,'45.90',0),
 (12198,4,2,91,1162,'41.63',0),
 (12199,4,14,91,1,'0.04',0),
 (12200,4,15,91,2,'0.07',0),
 (12201,4,16,91,6,'0.21',0),
 (12202,4,28,91,1,'0.04',0),
 (12203,4,32,91,0,'0.00',0),
 (12204,4,36,91,2,'0.07',0),
 (12205,4,38,91,287,'10.28',0),
 (12206,4,39,91,9,'0.32',0),
 (12207,4,40,91,1,'0.04',0),
 (12208,4,41,91,0,'0.00',0),
 (12209,4,42,91,0,'0.00',0),
 (12210,4,43,91,1,'0.04',0),
 (12211,4,44,91,0,'0.00',0),
 (12212,4,45,91,0,'0.00',0),
 (12213,4,46,91,1,'0.04',0),
 (12214,4,47,91,0,'0.00',0),
 (12215,4,48,91,0,'0.00',0),
 (12216,4,49,91,1,'0.04',0),
 (12217,4,50,91,0,'0.00',0),
 (12218,4,51,91,5,'0.18',0),
 (12219,4,1,92,38730,'42.46',0),
 (12220,4,2,92,41267,'45.24',0),
 (12221,4,14,92,32,'0.04',0),
 (12222,4,15,92,103,'0.11',0),
 (12223,4,16,92,81,'0.09',0),
 (12224,4,28,92,95,'0.10',0),
 (12225,4,32,92,33,'0.04',0),
 (12226,4,36,92,79,'0.09',0),
 (12227,4,38,92,7575,'8.30',0),
 (12228,4,39,92,499,'0.55',0),
 (12229,4,40,92,31,'0.03',0),
 (12230,4,41,92,53,'0.06',0),
 (12231,4,42,92,36,'0.04',0),
 (12232,4,43,92,196,'0.21',0),
 (12233,4,44,92,47,'0.05',0),
 (12234,4,45,92,49,'0.05',0),
 (12235,4,46,92,80,'0.09',0),
 (12236,4,47,92,25,'0.03',0),
 (12237,4,48,92,0,'0.00',0),
 (12238,4,49,92,203,'0.22',0),
 (12239,4,50,92,14,'0.02',0),
 (12240,4,51,92,587,'0.64',0),
 (12241,4,1,93,710,'60.79',0),
 (12242,4,2,93,385,'32.96',0),
 (12243,4,14,93,2,'0.17',0),
 (12244,4,15,93,0,'0.00',0),
 (12245,4,16,93,1,'0.09',0),
 (12246,4,28,93,0,'0.00',0),
 (12247,4,32,93,0,'0.00',0),
 (12248,4,36,93,1,'0.09',0),
 (12249,4,38,93,34,'2.91',0),
 (12250,4,39,93,8,'0.68',0),
 (12251,4,40,93,0,'0.00',0),
 (12252,4,41,93,0,'0.00',0),
 (12253,4,42,93,0,'0.00',0),
 (12254,4,43,93,1,'0.09',0),
 (12255,4,44,93,0,'0.00',0),
 (12256,4,45,93,0,'0.00',0),
 (12257,4,46,93,0,'0.00',0),
 (12258,4,47,93,1,'0.09',0),
 (12259,4,48,93,0,'0.00',0),
 (12260,4,49,93,4,'0.34',0),
 (12261,4,50,93,0,'0.00',0),
 (12262,4,51,93,3,'0.26',0),
 (12263,4,1,94,219,'61.52',0),
 (12264,4,2,94,99,'27.81',0),
 (12265,4,14,94,0,'0.00',0),
 (12266,4,15,94,0,'0.00',0),
 (12267,4,16,94,0,'0.00',0),
 (12268,4,28,94,0,'0.00',0),
 (12269,4,32,94,0,'0.00',0),
 (12270,4,36,94,1,'0.28',0),
 (12271,4,38,94,26,'7.30',0),
 (12272,4,39,94,0,'0.00',0),
 (12273,4,40,94,0,'0.00',0),
 (12274,4,41,94,0,'0.00',0),
 (12275,4,42,94,0,'0.00',0),
 (12276,4,43,94,0,'0.00',0),
 (12277,4,44,94,0,'0.00',0),
 (12278,4,45,94,0,'0.00',0),
 (12279,4,46,94,0,'0.00',0),
 (12280,4,47,94,0,'0.00',0),
 (12281,4,48,94,0,'0.00',0),
 (12282,4,49,94,3,'0.84',0),
 (12283,4,50,94,0,'0.00',0),
 (12284,4,51,94,2,'0.56',0),
 (12285,4,1,95,370,'53.94',0),
 (12286,4,2,95,240,'34.99',0),
 (12287,4,14,95,0,'0.00',0),
 (12288,4,15,95,0,'0.00',0),
 (12289,4,16,95,2,'0.29',0),
 (12290,4,28,95,0,'0.00',0),
 (12291,4,32,95,0,'0.00',0),
 (12292,4,36,95,0,'0.00',0),
 (12293,4,38,95,61,'8.89',0),
 (12294,4,39,95,2,'0.29',0),
 (12295,4,40,95,0,'0.00',0),
 (12296,4,41,95,0,'0.00',0),
 (12297,4,42,95,0,'0.00',0),
 (12298,4,43,95,0,'0.00',0),
 (12299,4,44,95,1,'0.15',0),
 (12300,4,45,95,0,'0.00',0),
 (12301,4,46,95,0,'0.00',0),
 (12302,4,47,95,0,'0.00',0),
 (12303,4,48,95,0,'0.00',0),
 (12304,4,49,95,0,'0.00',0),
 (12305,4,50,95,0,'0.00',0),
 (12306,4,51,95,4,'0.58',0),
 (12307,4,1,96,3771,'54.40',0),
 (12308,4,2,96,2715,'39.17',0),
 (12309,4,14,96,3,'0.04',0),
 (12310,4,15,96,0,'0.00',0),
 (12311,4,16,96,2,'0.03',0),
 (12312,4,28,96,6,'0.09',0),
 (12313,4,32,96,2,'0.03',0),
 (12314,4,36,96,4,'0.06',0),
 (12315,4,38,96,246,'3.55',0),
 (12316,4,39,96,37,'0.53',0),
 (12317,4,40,96,1,'0.01',0),
 (12318,4,41,96,3,'0.04',0),
 (12319,4,42,96,2,'0.03',0),
 (12320,4,43,96,9,'0.13',0),
 (12321,4,44,96,2,'0.03',0),
 (12322,4,45,96,7,'0.10',0),
 (12323,4,46,96,6,'0.09',0),
 (12324,4,47,96,3,'0.04',0),
 (12325,4,48,96,0,'0.00',0),
 (12326,4,49,96,6,'0.09',0),
 (12327,4,50,96,2,'0.03',0),
 (12328,4,51,96,26,'0.38',0),
 (12329,4,1,97,15,'18.75',0),
 (12330,4,2,97,53,'66.25',0),
 (12331,4,14,97,0,'0.00',0),
 (12332,4,15,97,0,'0.00',0),
 (12333,4,16,97,0,'0.00',0),
 (12334,4,28,97,0,'0.00',0),
 (12335,4,32,97,0,'0.00',0),
 (12336,4,36,97,0,'0.00',0),
 (12337,4,38,97,9,'11.25',0),
 (12338,4,39,97,0,'0.00',0),
 (12339,4,40,97,0,'0.00',0),
 (12340,4,41,97,0,'0.00',0),
 (12341,4,42,97,0,'0.00',0),
 (12342,4,43,97,0,'0.00',0),
 (12343,4,44,97,0,'0.00',0),
 (12344,4,45,97,0,'0.00',0),
 (12345,4,46,97,0,'0.00',0),
 (12346,4,47,97,0,'0.00',0),
 (12347,4,48,97,0,'0.00',0),
 (12348,4,49,97,1,'1.25',0),
 (12349,4,50,97,0,'0.00',0),
 (12350,4,51,97,1,'1.25',0),
 (12351,4,1,99,514,'60.97',0),
 (12352,4,2,99,267,'31.67',0),
 (12353,4,14,99,0,'0.00',0),
 (12354,4,15,99,2,'0.24',0),
 (12355,4,16,99,1,'0.12',0),
 (12356,4,28,99,1,'0.12',0),
 (12357,4,32,99,0,'0.00',0),
 (12358,4,36,99,1,'0.12',0),
 (12359,4,38,99,39,'4.63',0),
 (12360,4,39,99,4,'0.47',0),
 (12361,4,40,99,0,'0.00',0),
 (12362,4,41,99,1,'0.12',0),
 (12363,4,42,99,0,'0.00',0),
 (12364,4,43,99,1,'0.12',0),
 (12365,4,44,99,0,'0.00',0),
 (12366,4,45,99,0,'0.00',0),
 (12367,4,46,99,0,'0.00',0),
 (12368,4,47,99,0,'0.00',0),
 (12369,4,48,99,0,'0.00',0),
 (12370,4,49,99,1,'0.12',0),
 (12371,4,50,99,0,'0.00',0),
 (12372,4,51,99,2,'0.24',0),
 (12373,4,1,100,912,'53.05',0),
 (12374,4,2,100,561,'32.64',0),
 (12375,4,14,100,1,'0.06',0),
 (12376,4,15,100,0,'0.00',0),
 (12377,4,16,100,2,'0.12',0),
 (12378,4,28,100,1,'0.06',0),
 (12379,4,32,100,0,'0.00',0),
 (12380,4,36,100,4,'0.23',0),
 (12381,4,38,100,165,'9.60',0),
 (12382,4,39,100,15,'0.87',0),
 (12383,4,40,100,0,'0.00',0),
 (12384,4,41,100,1,'0.06',0),
 (12385,4,42,100,1,'0.06',0),
 (12386,4,43,100,6,'0.35',0),
 (12387,4,44,100,1,'0.06',0),
 (12388,4,45,100,0,'0.00',0),
 (12389,4,46,100,1,'0.06',0),
 (12390,4,47,100,0,'0.00',0),
 (12391,4,48,100,0,'0.00',0),
 (12392,4,49,100,1,'0.06',0),
 (12393,4,50,100,0,'0.00',0),
 (12394,4,51,100,8,'0.47',0),
 (12395,4,1,101,47,'57.32',0),
 (12396,4,2,101,27,'32.93',0),
 (12397,4,14,101,0,'0.00',0),
 (12398,4,15,101,0,'0.00',0),
 (12399,4,16,101,0,'0.00',0),
 (12400,4,28,101,0,'0.00',0),
 (12401,4,32,101,0,'0.00',0),
 (12402,4,36,101,0,'0.00',0),
 (12403,4,38,101,4,'4.88',0),
 (12404,4,39,101,1,'1.22',0),
 (12405,4,40,101,0,'0.00',0),
 (12406,4,41,101,0,'0.00',0),
 (12407,4,42,101,0,'0.00',0),
 (12408,4,43,101,0,'0.00',0),
 (12409,4,44,101,0,'0.00',0),
 (12410,4,45,101,0,'0.00',0),
 (12411,4,46,101,0,'0.00',0),
 (12412,4,47,101,0,'0.00',0),
 (12413,4,48,101,0,'0.00',0),
 (12414,4,49,101,0,'0.00',0),
 (12415,4,50,101,0,'0.00',0),
 (12416,4,51,101,1,'1.22',0),
 (12417,4,1,102,166,'32.11',0),
 (12418,4,2,102,276,'53.38',0),
 (12419,4,14,102,0,'0.00',0),
 (12420,4,15,102,0,'0.00',0),
 (12421,4,16,102,0,'0.00',0),
 (12422,4,28,102,1,'0.19',0),
 (12423,4,32,102,0,'0.00',0),
 (12424,4,36,102,0,'0.00',0),
 (12425,4,38,102,67,'12.96',0),
 (12426,4,39,102,0,'0.00',0),
 (12427,4,40,102,0,'0.00',0),
 (12428,4,41,102,0,'0.00',0),
 (12429,4,42,102,0,'0.00',0),
 (12430,4,43,102,0,'0.00',0),
 (12431,4,44,102,1,'0.19',0),
 (12432,4,45,102,0,'0.00',0),
 (12433,4,46,102,0,'0.00',0),
 (12434,4,47,102,1,'0.19',0),
 (12435,4,48,102,0,'0.00',0),
 (12436,4,49,102,0,'0.00',0),
 (12437,4,50,102,0,'0.00',0),
 (12438,4,51,102,0,'0.00',0),
 (12439,4,1,104,1639,'51.40',0),
 (12440,4,2,104,1051,'32.96',0),
 (12441,4,14,104,1,'0.03',0),
 (12442,4,15,104,1,'0.03',0),
 (12443,4,16,104,4,'0.13',0),
 (12444,4,28,104,2,'0.06',0),
 (12445,4,32,104,2,'0.06',0),
 (12446,4,36,104,8,'0.25',0),
 (12447,4,38,104,383,'12.01',0),
 (12448,4,39,104,20,'0.63',0),
 (12449,4,40,104,1,'0.03',0),
 (12450,4,41,104,4,'0.13',0),
 (12451,4,42,104,0,'0.00',0),
 (12452,4,43,104,9,'0.28',0),
 (12453,4,44,104,0,'0.00',0),
 (12454,4,45,104,1,'0.03',0),
 (12455,4,46,104,1,'0.03',0),
 (12456,4,47,104,0,'0.00',0),
 (12457,4,48,104,0,'0.00',0),
 (12458,4,49,104,10,'0.31',0),
 (12459,4,50,104,0,'0.00',0),
 (12460,4,51,104,5,'0.16',0),
 (12461,4,1,106,8947,'25.77',0),
 (12462,4,2,106,22067,'63.56',0),
 (12463,4,14,106,15,'0.04',0),
 (12464,4,15,106,49,'0.14',0),
 (12465,4,16,106,47,'0.14',0),
 (12466,4,28,106,14,'0.04',0),
 (12467,4,32,106,12,'0.03',0),
 (12468,4,36,106,42,'0.12',0),
 (12469,4,38,106,2648,'7.63',0),
 (12470,4,39,106,132,'0.38',0),
 (12471,4,40,106,8,'0.02',0),
 (12472,4,41,106,16,'0.05',0),
 (12473,4,42,106,22,'0.06',0),
 (12474,4,43,106,70,'0.20',0),
 (12475,4,44,106,13,'0.04',0),
 (12476,4,45,106,20,'0.06',0),
 (12477,4,46,106,20,'0.06',0),
 (12478,4,47,106,15,'0.04',0),
 (12479,4,48,106,0,'0.00',0),
 (12480,4,49,106,70,'0.20',0),
 (12481,4,50,106,7,'0.02',0),
 (12482,4,51,106,161,'0.46',0),
 (12483,4,1,107,80,'33.06',0),
 (12484,4,2,107,138,'57.02',0),
 (12485,4,14,107,0,'0.00',0),
 (12486,4,15,107,0,'0.00',0),
 (12487,4,16,107,1,'0.41',0),
 (12488,4,28,107,1,'0.41',0),
 (12489,4,32,107,0,'0.00',0),
 (12490,4,36,107,0,'0.00',0),
 (12491,4,38,107,12,'4.96',0),
 (12492,4,39,107,0,'0.00',0),
 (12493,4,40,107,0,'0.00',0),
 (12494,4,41,107,0,'0.00',0),
 (12495,4,42,107,0,'0.00',0),
 (12496,4,43,107,6,'2.48',0),
 (12497,4,44,107,0,'0.00',0),
 (12498,4,45,107,0,'0.00',0),
 (12499,4,46,107,0,'0.00',0),
 (12500,4,47,107,0,'0.00',0),
 (12501,4,48,107,0,'0.00',0),
 (12502,4,49,107,1,'0.41',0),
 (12503,4,50,107,0,'0.00',0),
 (12504,4,51,107,0,'0.00',0),
 (12505,4,1,108,622,'59.24',0),
 (12506,4,2,108,321,'30.57',0),
 (12507,4,14,108,0,'0.00',0),
 (12508,4,15,108,1,'0.10',0),
 (12509,4,16,108,2,'0.19',0),
 (12510,4,28,108,0,'0.00',0),
 (12511,4,32,108,0,'0.00',0),
 (12512,4,36,108,0,'0.00',0),
 (12513,4,38,108,56,'5.33',0),
 (12514,4,39,108,5,'0.48',0),
 (12515,4,40,108,0,'0.00',0),
 (12516,4,41,108,1,'0.10',0),
 (12517,4,42,108,0,'0.00',0),
 (12518,4,43,108,3,'0.29',0),
 (12519,4,44,108,3,'0.29',0),
 (12520,4,45,108,0,'0.00',0),
 (12521,4,46,108,0,'0.00',0),
 (12522,4,47,108,1,'0.10',0),
 (12523,4,48,108,0,'0.00',0),
 (12524,4,49,108,4,'0.38',0),
 (12525,4,50,108,0,'0.00',0),
 (12526,4,51,108,7,'0.67',0),
 (12527,4,1,109,467,'64.59',0),
 (12528,4,2,109,206,'28.49',0),
 (12529,4,14,109,0,'0.00',0),
 (12530,4,15,109,0,'0.00',0),
 (12531,4,16,109,0,'0.00',0),
 (12532,4,28,109,3,'0.41',0),
 (12533,4,32,109,0,'0.00',0),
 (12534,4,36,109,0,'0.00',0),
 (12535,4,38,109,36,'4.98',0),
 (12536,4,39,109,3,'0.41',0),
 (12537,4,40,109,0,'0.00',0),
 (12538,4,41,109,2,'0.28',0),
 (12539,4,42,109,1,'0.14',0),
 (12540,4,43,109,2,'0.28',0),
 (12541,4,44,109,0,'0.00',0),
 (12542,4,45,109,0,'0.00',0),
 (12543,4,46,109,0,'0.00',0),
 (12544,4,47,109,0,'0.00',0),
 (12545,4,48,109,0,'0.00',0),
 (12546,4,49,109,0,'0.00',0),
 (12547,4,50,109,0,'0.00',0),
 (12548,4,51,109,1,'0.14',0),
 (12549,4,1,110,704,'51.58',0),
 (12550,4,2,110,596,'43.66',0),
 (12551,4,14,110,0,'0.00',0),
 (12552,4,15,110,1,'0.07',0),
 (12553,4,16,110,2,'0.15',0),
 (12554,4,28,110,0,'0.00',0),
 (12555,4,32,110,1,'0.07',0),
 (12556,4,36,110,3,'0.22',0),
 (12557,4,38,110,32,'2.34',0),
 (12558,4,39,110,3,'0.22',0),
 (12559,4,40,110,1,'0.07',0),
 (12560,4,41,110,0,'0.00',0),
 (12561,4,42,110,1,'0.07',0),
 (12562,4,43,110,0,'0.00',0),
 (12563,4,44,110,0,'0.00',0),
 (12564,4,45,110,3,'0.22',0),
 (12565,4,46,110,0,'0.00',0),
 (12566,4,47,110,0,'0.00',0),
 (12567,4,48,110,0,'0.00',0),
 (12568,4,49,110,1,'0.07',0),
 (12569,4,50,110,0,'0.00',0),
 (12570,4,51,110,3,'0.22',0),
 (12571,4,1,111,173,'56.17',0),
 (12572,4,2,111,115,'37.34',0),
 (12573,4,14,111,0,'0.00',0),
 (12574,4,15,111,0,'0.00',0),
 (12575,4,16,111,0,'0.00',0),
 (12576,4,28,111,0,'0.00',0),
 (12577,4,32,111,0,'0.00',0),
 (12578,4,36,111,0,'0.00',0),
 (12579,4,38,111,15,'4.87',0),
 (12580,4,39,111,1,'0.32',0),
 (12581,4,40,111,0,'0.00',0),
 (12582,4,41,111,0,'0.00',0),
 (12583,4,42,111,0,'0.00',0),
 (12584,4,43,111,1,'0.32',0),
 (12585,4,44,111,0,'0.00',0),
 (12586,4,45,111,0,'0.00',0),
 (12587,4,46,111,0,'0.00',0),
 (12588,4,47,111,0,'0.00',0),
 (12589,4,48,111,0,'0.00',0),
 (12590,4,49,111,0,'0.00',0),
 (12591,4,50,111,0,'0.00',0),
 (12592,4,51,111,0,'0.00',0),
 (12593,4,1,112,62,'55.36',0),
 (12594,4,2,112,44,'39.29',0),
 (12595,4,14,112,0,'0.00',0),
 (12596,4,15,112,0,'0.00',0),
 (12597,4,16,112,0,'0.00',0),
 (12598,4,28,112,0,'0.00',0),
 (12599,4,32,112,0,'0.00',0),
 (12600,4,36,112,0,'0.00',0),
 (12601,4,38,112,2,'1.79',0),
 (12602,4,39,112,1,'0.89',0),
 (12603,4,40,112,0,'0.00',0),
 (12604,4,41,112,0,'0.00',0),
 (12605,4,42,112,0,'0.00',0),
 (12606,4,43,112,0,'0.00',0),
 (12607,4,44,112,0,'0.00',0),
 (12608,4,45,112,0,'0.00',0),
 (12609,4,46,112,0,'0.00',0),
 (12610,4,47,112,0,'0.00',0),
 (12611,4,48,112,0,'0.00',0),
 (12612,4,49,112,1,'0.89',0),
 (12613,4,50,112,0,'0.00',0),
 (12614,4,51,112,0,'0.00',0),
 (12615,4,1,113,5745,'38.41',0),
 (12616,4,2,113,7315,'48.90',0),
 (12617,4,14,113,2,'0.01',0),
 (12618,4,15,113,7,'0.05',0),
 (12619,4,16,113,11,'0.07',0),
 (12620,4,28,113,11,'0.07',0),
 (12621,4,32,113,2,'0.01',0),
 (12622,4,36,113,16,'0.11',0),
 (12623,4,38,113,1368,'9.15',0),
 (12624,4,39,113,88,'0.59',0),
 (12625,4,40,113,3,'0.02',0),
 (12626,4,41,113,12,'0.08',0),
 (12627,4,42,113,6,'0.04',0),
 (12628,4,43,113,25,'0.17',0),
 (12629,4,44,113,6,'0.04',0),
 (12630,4,45,113,3,'0.02',0),
 (12631,4,46,113,7,'0.05',0),
 (12632,4,47,113,4,'0.03',0),
 (12633,4,48,113,0,'0.00',0),
 (12634,4,49,113,42,'0.28',0),
 (12635,4,50,113,2,'0.01',0),
 (12636,4,51,113,56,'0.37',0),
 (12637,4,1,114,78,'77.23',0),
 (12638,4,2,114,17,'16.83',0),
 (12639,4,14,114,0,'0.00',0),
 (12640,4,15,114,0,'0.00',0),
 (12641,4,16,114,0,'0.00',0),
 (12642,4,28,114,0,'0.00',0),
 (12643,4,32,114,0,'0.00',0),
 (12644,4,36,114,0,'0.00',0),
 (12645,4,38,114,2,'1.98',0),
 (12646,4,39,114,0,'0.00',0),
 (12647,4,40,114,0,'0.00',0),
 (12648,4,41,114,0,'0.00',0),
 (12649,4,42,114,0,'0.00',0),
 (12650,4,43,114,1,'0.99',0),
 (12651,4,44,114,0,'0.00',0),
 (12652,4,45,114,0,'0.00',0),
 (12653,4,46,114,0,'0.00',0),
 (12654,4,47,114,0,'0.00',0),
 (12655,4,48,114,0,'0.00',0),
 (12656,4,49,114,0,'0.00',0),
 (12657,4,50,114,0,'0.00',0),
 (12658,4,51,114,2,'1.98',0),
 (12659,4,1,115,25052,'67.44',0),
 (12660,4,2,115,8774,'23.62',0),
 (12661,4,14,115,21,'0.06',0),
 (12662,4,15,115,20,'0.05',0),
 (12663,4,16,115,16,'0.04',0),
 (12664,4,28,115,14,'0.04',0),
 (12665,4,32,115,15,'0.04',0),
 (12666,4,36,115,14,'0.04',0),
 (12667,4,38,115,1671,'4.50',0),
 (12668,4,39,115,141,'0.38',0),
 (12669,4,40,115,10,'0.03',0),
 (12670,4,41,115,20,'0.05',0),
 (12671,4,42,115,20,'0.05',0),
 (12672,4,43,115,74,'0.20',0),
 (12673,4,44,115,27,'0.07',0),
 (12674,4,45,115,10,'0.03',0),
 (12675,4,46,115,57,'0.15',0),
 (12676,4,47,115,17,'0.05',0),
 (12677,4,48,115,0,'0.00',0),
 (12678,4,49,115,101,'0.27',0),
 (12679,4,50,115,4,'0.01',0),
 (12680,4,51,115,180,'0.48',0),
 (12681,4,1,116,85,'51.20',0),
 (12682,4,2,116,78,'46.99',0),
 (12683,4,14,116,0,'0.00',0),
 (12684,4,15,116,0,'0.00',0),
 (12685,4,16,116,0,'0.00',0),
 (12686,4,28,116,0,'0.00',0),
 (12687,4,32,116,0,'0.00',0),
 (12688,4,36,116,0,'0.00',0),
 (12689,4,38,116,1,'0.60',0),
 (12690,4,39,116,0,'0.00',0),
 (12691,4,40,116,0,'0.00',0),
 (12692,4,41,116,0,'0.00',0),
 (12693,4,42,116,0,'0.00',0),
 (12694,4,43,116,0,'0.00',0),
 (12695,4,44,116,0,'0.00',0),
 (12696,4,45,116,0,'0.00',0),
 (12697,4,46,116,0,'0.00',0),
 (12698,4,47,116,0,'0.00',0),
 (12699,4,48,116,0,'0.00',0),
 (12700,4,49,116,0,'0.00',0),
 (12701,4,50,116,0,'0.00',0),
 (12702,4,51,116,0,'0.00',0),
 (12703,4,1,117,47,'61.84',0),
 (12704,4,2,117,19,'25.00',0),
 (12705,4,14,117,0,'0.00',0),
 (12706,4,15,117,1,'1.32',0),
 (12707,4,16,117,0,'0.00',0),
 (12708,4,28,117,0,'0.00',0),
 (12709,4,32,117,0,'0.00',0),
 (12710,4,36,117,0,'0.00',0),
 (12711,4,38,117,5,'6.58',0),
 (12712,4,39,117,0,'0.00',0),
 (12713,4,40,117,0,'0.00',0),
 (12714,4,41,117,0,'0.00',0),
 (12715,4,42,117,0,'0.00',0),
 (12716,4,43,117,0,'0.00',0),
 (12717,4,44,117,0,'0.00',0),
 (12718,4,45,117,0,'0.00',0),
 (12719,4,46,117,0,'0.00',0),
 (12720,4,47,117,1,'1.32',0),
 (12721,4,48,117,0,'0.00',0),
 (12722,4,49,117,0,'0.00',0),
 (12723,4,50,117,0,'0.00',0),
 (12724,4,51,117,0,'0.00',0),
 (12725,4,1,118,24,'36.92',0),
 (12726,4,2,118,32,'49.23',0),
 (12727,4,14,118,0,'0.00',0),
 (12728,4,15,118,0,'0.00',0),
 (12729,4,16,118,1,'1.54',0),
 (12730,4,28,118,0,'0.00',0),
 (12731,4,32,118,0,'0.00',0),
 (12732,4,36,118,0,'0.00',0),
 (12733,4,38,118,8,'12.31',0),
 (12734,4,39,118,0,'0.00',0),
 (12735,4,40,118,0,'0.00',0),
 (12736,4,41,118,0,'0.00',0),
 (12737,4,42,118,0,'0.00',0),
 (12738,4,43,118,0,'0.00',0),
 (12739,4,44,118,0,'0.00',0),
 (12740,4,45,118,0,'0.00',0),
 (12741,4,46,118,0,'0.00',0),
 (12742,4,47,118,0,'0.00',0),
 (12743,4,48,118,0,'0.00',0),
 (12744,4,49,118,0,'0.00',0),
 (12745,4,50,118,0,'0.00',0),
 (12746,4,51,118,0,'0.00',0),
 (12747,4,1,119,429,'58.53',0),
 (12748,4,2,119,228,'31.11',0),
 (12749,4,14,119,0,'0.00',0),
 (12750,4,15,119,0,'0.00',0),
 (12751,4,16,119,1,'0.14',0),
 (12752,4,28,119,2,'0.27',0),
 (12753,4,32,119,0,'0.00',0),
 (12754,4,36,119,0,'0.00',0),
 (12755,4,38,119,41,'5.59',0),
 (12756,4,39,119,4,'0.55',0),
 (12757,4,40,119,1,'0.14',0),
 (12758,4,41,119,0,'0.00',0),
 (12759,4,42,119,0,'0.00',0),
 (12760,4,43,119,4,'0.55',0),
 (12761,4,44,119,0,'0.00',0),
 (12762,4,45,119,0,'0.00',0),
 (12763,4,46,119,2,'0.27',0),
 (12764,4,47,119,0,'0.00',0),
 (12765,4,48,119,0,'0.00',0),
 (12766,4,49,119,1,'0.14',0),
 (12767,4,50,119,0,'0.00',0),
 (12768,4,51,119,1,'0.14',0),
 (12769,4,1,120,403,'51.27',0),
 (12770,4,2,120,323,'41.09',0),
 (12771,4,14,120,0,'0.00',0),
 (12772,4,15,120,1,'0.13',0),
 (12773,4,16,120,0,'0.00',0),
 (12774,4,28,120,1,'0.13',0),
 (12775,4,32,120,0,'0.00',0),
 (12776,4,36,120,0,'0.00',0),
 (12777,4,38,120,32,'4.07',0),
 (12778,4,39,120,1,'0.13',0),
 (12779,4,40,120,0,'0.00',0),
 (12780,4,41,120,1,'0.13',0),
 (12781,4,42,120,0,'0.00',0),
 (12782,4,43,120,1,'0.13',0),
 (12783,4,44,120,1,'0.13',0),
 (12784,4,45,120,0,'0.00',0),
 (12785,4,46,120,0,'0.00',0),
 (12786,4,47,120,0,'0.00',0),
 (12787,4,48,120,0,'0.00',0),
 (12788,4,49,120,2,'0.25',0),
 (12789,4,50,120,0,'0.00',0),
 (12790,4,51,120,2,'0.25',0),
 (12791,4,1,121,63,'45.00',0),
 (12792,4,2,121,69,'49.29',0),
 (12793,4,14,121,0,'0.00',0),
 (12794,4,15,121,0,'0.00',0),
 (12795,4,16,121,0,'0.00',0),
 (12796,4,28,121,0,'0.00',0),
 (12797,4,32,121,0,'0.00',0),
 (12798,4,36,121,0,'0.00',0),
 (12799,4,38,121,3,'2.14',0),
 (12800,4,39,121,1,'0.71',0),
 (12801,4,40,121,0,'0.00',0),
 (12802,4,41,121,0,'0.00',0),
 (12803,4,42,121,0,'0.00',0),
 (12804,4,43,121,3,'2.14',0),
 (12805,4,44,121,0,'0.00',0),
 (12806,4,45,121,0,'0.00',0),
 (12807,4,46,121,0,'0.00',0),
 (12808,4,47,121,0,'0.00',0),
 (12809,4,48,121,0,'0.00',0),
 (12810,4,49,121,0,'0.00',0),
 (12811,4,50,121,0,'0.00',0),
 (12812,4,51,121,0,'0.00',0),
 (12813,4,1,122,128,'57.14',0),
 (12814,4,2,122,71,'31.70',0),
 (12815,4,14,122,0,'0.00',0),
 (12816,4,15,122,0,'0.00',0),
 (12817,4,16,122,0,'0.00',0),
 (12818,4,28,122,0,'0.00',0),
 (12819,4,32,122,0,'0.00',0),
 (12820,4,36,122,1,'0.45',0),
 (12821,4,38,122,14,'6.25',0),
 (12822,4,39,122,0,'0.00',0),
 (12823,4,40,122,0,'0.00',0),
 (12824,4,41,122,0,'0.00',0),
 (12825,4,42,122,0,'0.00',0),
 (12826,4,43,122,2,'0.89',0),
 (12827,4,44,122,0,'0.00',0),
 (12828,4,45,122,0,'0.00',0),
 (12829,4,46,122,0,'0.00',0),
 (12830,4,47,122,0,'0.00',0),
 (12831,4,48,122,0,'0.00',0),
 (12832,4,49,122,1,'0.45',0),
 (12833,4,50,122,1,'0.45',0),
 (12834,4,51,122,1,'0.45',0),
 (12835,4,1,123,5917,'29.80',0),
 (12836,4,2,123,6515,'32.81',0),
 (12837,4,14,123,10,'0.05',0),
 (12838,4,15,123,13,'0.07',0),
 (12839,4,16,123,5,'0.03',0),
 (12840,4,28,123,8,'0.04',0),
 (12841,4,32,123,1,'0.01',0),
 (12842,4,36,123,11,'0.06',0),
 (12843,4,38,123,6797,'34.23',0),
 (12844,4,39,123,85,'0.43',0),
 (12845,4,40,123,4,'0.02',0),
 (12846,4,41,123,4,'0.02',0),
 (12847,4,42,123,5,'0.03',0),
 (12848,4,43,123,36,'0.18',0),
 (12849,4,44,123,3,'0.02',0),
 (12850,4,45,123,3,'0.02',0),
 (12851,4,46,123,19,'0.10',0),
 (12852,4,47,123,3,'0.02',0),
 (12853,4,48,123,0,'0.00',0),
 (12854,4,49,123,56,'0.28',0),
 (12855,4,50,123,0,'0.00',0),
 (12856,4,51,123,65,'0.33',0),
 (12857,4,1,124,45,'62.50',0),
 (12858,4,2,124,18,'25.00',0),
 (12859,4,14,124,0,'0.00',0),
 (12860,4,15,124,0,'0.00',0),
 (12861,4,16,124,0,'0.00',0),
 (12862,4,28,124,0,'0.00',0),
 (12863,4,32,124,0,'0.00',0),
 (12864,4,36,124,0,'0.00',0),
 (12865,4,38,124,6,'8.33',0),
 (12866,4,39,124,0,'0.00',0),
 (12867,4,40,124,0,'0.00',0),
 (12868,4,41,124,0,'0.00',0),
 (12869,4,42,124,0,'0.00',0),
 (12870,4,43,124,0,'0.00',0),
 (12871,4,44,124,0,'0.00',0),
 (12872,4,45,124,0,'0.00',0),
 (12873,4,46,124,0,'0.00',0),
 (12874,4,47,124,0,'0.00',0),
 (12875,4,48,124,0,'0.00',0),
 (12876,4,49,124,2,'2.78',0),
 (12877,4,50,124,0,'0.00',0),
 (12878,4,51,124,0,'0.00',0),
 (12879,4,1,125,821,'60.72',0),
 (12880,4,2,125,425,'31.43',0),
 (12881,4,14,125,1,'0.07',0),
 (12882,4,15,125,0,'0.00',0),
 (12883,4,16,125,2,'0.15',0),
 (12884,4,28,125,0,'0.00',0),
 (12885,4,32,125,0,'0.00',0),
 (12886,4,36,125,0,'0.00',0),
 (12887,4,38,125,75,'5.55',0),
 (12888,4,39,125,8,'0.59',0),
 (12889,4,40,125,0,'0.00',0),
 (12890,4,41,125,0,'0.00',0),
 (12891,4,42,125,2,'0.15',0),
 (12892,4,43,125,1,'0.07',0),
 (12893,4,44,125,1,'0.07',0),
 (12894,4,45,125,1,'0.07',0),
 (12895,4,46,125,0,'0.00',0),
 (12896,4,47,125,1,'0.07',0),
 (12897,4,48,125,0,'0.00',0),
 (12898,4,49,125,1,'0.07',0),
 (12899,4,50,125,0,'0.00',0),
 (12900,4,51,125,3,'0.22',0),
 (12901,4,1,126,18,'32.73',0),
 (12902,4,2,126,35,'63.64',0),
 (12903,4,14,126,0,'0.00',0),
 (12904,4,15,126,0,'0.00',0),
 (12905,4,16,126,0,'0.00',0),
 (12906,4,28,126,0,'0.00',0),
 (12907,4,32,126,0,'0.00',0),
 (12908,4,36,126,0,'0.00',0),
 (12909,4,38,126,2,'3.64',0),
 (12910,4,39,126,0,'0.00',0),
 (12911,4,40,126,0,'0.00',0),
 (12912,4,41,126,0,'0.00',0),
 (12913,4,42,126,0,'0.00',0),
 (12914,4,43,126,0,'0.00',0),
 (12915,4,44,126,0,'0.00',0),
 (12916,4,45,126,0,'0.00',0),
 (12917,4,46,126,0,'0.00',0),
 (12918,4,47,126,0,'0.00',0),
 (12919,4,48,126,0,'0.00',0),
 (12920,4,49,126,0,'0.00',0),
 (12921,4,50,126,0,'0.00',0),
 (12922,4,51,126,0,'0.00',0),
 (12923,4,1,127,20625,'62.67',0),
 (12924,4,2,127,8782,'26.69',0),
 (12925,4,14,127,7,'0.02',0),
 (12926,4,15,127,10,'0.03',0),
 (12927,4,16,127,23,'0.07',0),
 (12928,4,28,127,24,'0.07',0),
 (12929,4,32,127,3,'0.01',0),
 (12930,4,36,127,25,'0.08',0),
 (12931,4,38,127,1809,'5.50',0),
 (12932,4,39,127,236,'0.72',0),
 (12933,4,40,127,19,'0.06',0),
 (12934,4,41,127,16,'0.05',0),
 (12935,4,42,127,13,'0.04',0),
 (12936,4,43,127,90,'0.27',0),
 (12937,4,44,127,22,'0.07',0),
 (12938,4,45,127,8,'0.02',0),
 (12939,4,46,127,35,'0.11',0),
 (12940,4,47,127,7,'0.02',0),
 (12941,4,48,127,0,'0.00',0),
 (12942,4,49,127,144,'0.44',0),
 (12943,4,50,127,4,'0.01',0),
 (12944,4,51,127,148,'0.45',0),
 (12945,4,1,128,122,'50.21',0),
 (12946,4,2,128,82,'33.74',0),
 (12947,4,14,128,0,'0.00',0),
 (12948,4,15,128,1,'0.41',0),
 (12949,4,16,128,1,'0.41',0),
 (12950,4,28,128,0,'0.00',0),
 (12951,4,32,128,0,'0.00',0),
 (12952,4,36,128,0,'0.00',0),
 (12953,4,38,128,34,'13.99',0),
 (12954,4,39,128,0,'0.00',0),
 (12955,4,40,128,0,'0.00',0),
 (12956,4,41,128,0,'0.00',0),
 (12957,4,42,128,1,'0.41',0),
 (12958,4,43,128,0,'0.00',0),
 (12959,4,44,128,0,'0.00',0),
 (12960,4,45,128,0,'0.00',0),
 (12961,4,46,128,0,'0.00',0),
 (12962,4,47,128,0,'0.00',0),
 (12963,4,48,128,0,'0.00',0),
 (12964,4,49,128,0,'0.00',0),
 (12965,4,50,128,1,'0.41',0),
 (12966,4,51,128,0,'0.00',0),
 (12967,4,1,129,1554,'51.02',0),
 (12968,4,2,129,1190,'39.07',0),
 (12969,4,14,129,1,'0.03',0),
 (12970,4,15,129,3,'0.10',0),
 (12971,4,16,129,2,'0.07',0),
 (12972,4,28,129,4,'0.13',0),
 (12973,4,32,129,0,'0.00',0),
 (12974,4,36,129,2,'0.07',0),
 (12975,4,38,129,169,'5.55',0),
 (12976,4,39,129,20,'0.66',0),
 (12977,4,40,129,1,'0.03',0),
 (12978,4,41,129,5,'0.16',0),
 (12979,4,42,129,4,'0.13',0),
 (12980,4,43,129,8,'0.26',0),
 (12981,4,44,129,5,'0.16',0),
 (12982,4,45,129,2,'0.07',0),
 (12983,4,46,129,1,'0.03',0),
 (12984,4,47,129,1,'0.03',0),
 (12985,4,48,129,0,'0.00',0),
 (12986,4,49,129,4,'0.13',0),
 (12987,4,50,129,1,'0.03',0),
 (12988,4,51,129,16,'0.53',0),
 (12989,4,1,130,5720,'35.10',0),
 (12990,4,2,130,7257,'44.54',0),
 (12991,4,14,130,6,'0.04',0),
 (12992,4,15,130,18,'0.11',0),
 (12993,4,16,130,6,'0.04',0),
 (12994,4,28,130,10,'0.06',0),
 (12995,4,32,130,4,'0.02',0),
 (12996,4,36,130,46,'0.28',0),
 (12997,4,38,130,2652,'16.28',0),
 (12998,4,39,130,83,'0.51',0),
 (12999,4,40,130,9,'0.06',0),
 (13000,4,41,130,7,'0.04',0),
 (13001,4,42,130,4,'0.02',0),
 (13002,4,43,130,28,'0.17',0),
 (13003,4,44,130,9,'0.06',0),
 (13004,4,45,130,10,'0.06',0),
 (13005,4,46,130,15,'0.09',0),
 (13006,4,47,130,5,'0.03',0),
 (13007,4,48,130,0,'0.00',0),
 (13008,4,49,130,33,'0.20',0),
 (13009,4,50,130,3,'0.02',0),
 (13010,4,51,130,103,'0.63',0),
 (13011,4,1,131,3760,'56.94',0),
 (13012,4,2,131,2165,'32.78',0),
 (13013,4,14,131,2,'0.03',0),
 (13014,4,15,131,1,'0.02',0),
 (13015,4,16,131,9,'0.14',0),
 (13016,4,28,131,6,'0.09',0),
 (13017,4,32,131,0,'0.00',0),
 (13018,4,36,131,3,'0.05',0),
 (13019,4,38,131,435,'6.59',0),
 (13020,4,39,131,26,'0.39',0),
 (13021,4,40,131,0,'0.00',0),
 (13022,4,41,131,1,'0.02',0),
 (13023,4,42,131,3,'0.05',0),
 (13024,4,43,131,20,'0.30',0),
 (13025,4,44,131,2,'0.03',0),
 (13026,4,45,131,3,'0.05',0),
 (13027,4,46,131,3,'0.05',0),
 (13028,4,47,131,6,'0.09',0),
 (13029,4,48,131,0,'0.00',0),
 (13030,4,49,131,22,'0.33',0),
 (13031,4,50,131,1,'0.02',0),
 (13032,4,51,131,19,'0.29',0),
 (13033,4,1,132,2495,'46.23',0),
 (13034,4,2,132,2332,'43.21',0),
 (13035,4,14,132,1,'0.02',0),
 (13036,4,15,132,3,'0.06',0),
 (13037,4,16,132,6,'0.11',0),
 (13038,4,28,132,2,'0.04',0),
 (13039,4,32,132,0,'0.00',0),
 (13040,4,36,132,3,'0.06',0),
 (13041,4,38,132,440,'8.15',0),
 (13042,4,39,132,23,'0.43',0),
 (13043,4,40,132,1,'0.02',0),
 (13044,4,41,132,0,'0.00',0),
 (13045,4,42,132,3,'0.06',0),
 (13046,4,43,132,6,'0.11',0),
 (13047,4,44,132,4,'0.07',0),
 (13048,4,45,132,0,'0.00',0),
 (13049,4,46,132,1,'0.02',0),
 (13050,4,47,132,1,'0.02',0),
 (13051,4,48,132,0,'0.00',0),
 (13052,4,49,132,11,'0.20',0),
 (13053,4,50,132,0,'0.00',0),
 (13054,4,51,132,15,'0.28',0),
 (13055,4,1,133,1580,'47.05',0),
 (13056,4,2,133,1532,'45.62',0),
 (13057,4,14,133,0,'0.00',0),
 (13058,4,15,133,0,'0.00',0),
 (13059,4,16,133,1,'0.03',0),
 (13060,4,28,133,1,'0.03',0),
 (13061,4,32,133,0,'0.00',0),
 (13062,4,36,133,1,'0.03',0),
 (13063,4,38,133,187,'5.57',0),
 (13064,4,39,133,6,'0.18',0),
 (13065,4,40,133,0,'0.00',0),
 (13066,4,41,133,2,'0.06',0),
 (13067,4,42,133,0,'0.00',0),
 (13068,4,43,133,1,'0.03',0),
 (13069,4,44,133,2,'0.06',0),
 (13070,4,45,133,0,'0.00',0),
 (13071,4,46,133,3,'0.09',0),
 (13072,4,47,133,0,'0.00',0),
 (13073,4,48,133,0,'0.00',0),
 (13074,4,49,133,3,'0.09',0),
 (13075,4,50,133,0,'0.00',0),
 (13076,4,51,133,4,'0.12',0),
 (13077,4,1,134,12442,'43.10',0),
 (13078,4,2,134,12591,'43.61',0),
 (13079,4,14,134,21,'0.07',0),
 (13080,4,15,134,15,'0.05',0),
 (13081,4,16,134,23,'0.08',0),
 (13082,4,28,134,25,'0.09',0),
 (13083,4,32,134,5,'0.02',0),
 (13084,4,36,134,22,'0.08',0),
 (13085,4,38,134,2547,'8.82',0),
 (13086,4,39,134,217,'0.75',0),
 (13087,4,40,134,15,'0.05',0),
 (13088,4,41,134,12,'0.04',0),
 (13089,4,42,134,20,'0.07',0),
 (13090,4,43,134,63,'0.22',0),
 (13091,4,44,134,14,'0.05',0),
 (13092,4,45,134,16,'0.06',0),
 (13093,4,46,134,16,'0.06',0),
 (13094,4,47,134,10,'0.03',0),
 (13095,4,48,134,0,'0.00',0),
 (13096,4,49,134,89,'0.31',0),
 (13097,4,50,134,4,'0.01',0),
 (13098,4,51,134,145,'0.50',0),
 (13099,4,1,135,273,'59.09',0),
 (13100,4,2,135,153,'33.12',0),
 (13101,4,14,135,0,'0.00',0),
 (13102,4,15,135,0,'0.00',0),
 (13103,4,16,135,0,'0.00',0),
 (13104,4,28,135,0,'0.00',0),
 (13105,4,32,135,0,'0.00',0),
 (13106,4,36,135,0,'0.00',0),
 (13107,4,38,135,31,'6.71',0),
 (13108,4,39,135,0,'0.00',0),
 (13109,4,40,135,0,'0.00',0),
 (13110,4,41,135,0,'0.00',0),
 (13111,4,42,135,0,'0.00',0),
 (13112,4,43,135,1,'0.22',0),
 (13113,4,44,135,0,'0.00',0),
 (13114,4,45,135,0,'0.00',0),
 (13115,4,46,135,0,'0.00',0),
 (13116,4,47,135,0,'0.00',0),
 (13117,4,48,135,0,'0.00',0),
 (13118,4,49,135,0,'0.00',0),
 (13119,4,50,135,0,'0.00',0),
 (13120,4,51,135,0,'0.00',0),
 (13121,4,1,136,216,'51.55',0),
 (13122,4,2,136,161,'38.42',0),
 (13123,4,14,136,0,'0.00',0),
 (13124,4,15,136,0,'0.00',0),
 (13125,4,16,136,0,'0.00',0),
 (13126,4,28,136,1,'0.24',0),
 (13127,4,32,136,0,'0.00',0),
 (13128,4,36,136,19,'4.53',0),
 (13129,4,38,136,14,'3.34',0),
 (13130,4,39,136,0,'0.00',0),
 (13131,4,40,136,1,'0.24',0),
 (13132,4,41,136,0,'0.00',0),
 (13133,4,42,136,0,'0.00',0),
 (13134,4,43,136,0,'0.00',0),
 (13135,4,44,136,0,'0.00',0),
 (13136,4,45,136,0,'0.00',0),
 (13137,4,46,136,2,'0.48',0),
 (13138,4,47,136,0,'0.00',0),
 (13139,4,48,136,0,'0.00',0),
 (13140,4,49,136,0,'0.00',0),
 (13141,4,50,136,0,'0.00',0),
 (13142,4,51,136,1,'0.24',0),
 (13143,4,1,137,395,'51.37',0),
 (13144,4,2,137,324,'42.13',0),
 (13145,4,14,137,0,'0.00',0),
 (13146,4,15,137,0,'0.00',0),
 (13147,4,16,137,0,'0.00',0),
 (13148,4,28,137,0,'0.00',0),
 (13149,4,32,137,0,'0.00',0),
 (13150,4,36,137,11,'1.43',0),
 (13151,4,38,137,28,'3.64',0),
 (13152,4,39,137,5,'0.65',0),
 (13153,4,40,137,0,'0.00',0),
 (13154,4,41,137,0,'0.00',0),
 (13155,4,42,137,0,'0.00',0),
 (13156,4,43,137,0,'0.00',0),
 (13157,4,44,137,0,'0.00',0),
 (13158,4,45,137,0,'0.00',0),
 (13159,4,46,137,2,'0.26',0),
 (13160,4,47,137,0,'0.00',0),
 (13161,4,48,137,0,'0.00',0),
 (13162,4,49,137,0,'0.00',0),
 (13163,4,50,137,0,'0.00',0),
 (13164,4,51,137,3,'0.39',0),
 (13165,4,1,138,50,'56.82',0),
 (13166,4,2,138,31,'35.23',0),
 (13167,4,14,138,0,'0.00',0),
 (13168,4,15,138,0,'0.00',0),
 (13169,4,16,138,0,'0.00',0),
 (13170,4,28,138,0,'0.00',0),
 (13171,4,32,138,0,'0.00',0),
 (13172,4,36,138,0,'0.00',0),
 (13173,4,38,138,5,'5.68',0),
 (13174,4,39,138,0,'0.00',0),
 (13175,4,40,138,0,'0.00',0),
 (13176,4,41,138,0,'0.00',0),
 (13177,4,42,138,0,'0.00',0),
 (13178,4,43,138,1,'1.14',0),
 (13179,4,44,138,0,'0.00',0),
 (13180,4,45,138,0,'0.00',0),
 (13181,4,46,138,0,'0.00',0),
 (13182,4,47,138,0,'0.00',0),
 (13183,4,48,138,0,'0.00',0),
 (13184,4,49,138,0,'0.00',0),
 (13185,4,50,138,0,'0.00',0),
 (13186,4,51,138,0,'0.00',0),
 (13187,4,1,140,577,'56.68',0),
 (13188,4,2,140,374,'36.74',0),
 (13189,4,14,140,0,'0.00',0),
 (13190,4,15,140,0,'0.00',0),
 (13191,4,16,140,1,'0.10',0),
 (13192,4,28,140,0,'0.00',0),
 (13193,4,32,140,0,'0.00',0),
 (13194,4,36,140,0,'0.00',0),
 (13195,4,38,140,42,'4.13',0),
 (13196,4,39,140,4,'0.39',0),
 (13197,4,40,140,0,'0.00',0),
 (13198,4,41,140,1,'0.10',0),
 (13199,4,42,140,2,'0.20',0),
 (13200,4,43,140,3,'0.29',0),
 (13201,4,44,140,0,'0.00',0),
 (13202,4,45,140,2,'0.20',0),
 (13203,4,46,140,2,'0.20',0),
 (13204,4,47,140,0,'0.00',0),
 (13205,4,48,140,0,'0.00',0),
 (13206,4,49,140,0,'0.00',0),
 (13207,4,50,140,0,'0.00',0),
 (13208,4,51,140,1,'0.10',0),
 (13209,4,1,141,1203,'56.67',0),
 (13210,4,2,141,722,'34.01',0),
 (13211,4,14,141,0,'0.00',0),
 (13212,4,15,141,1,'0.05',0),
 (13213,4,16,141,0,'0.00',0),
 (13214,4,28,141,1,'0.05',0),
 (13215,4,32,141,0,'0.00',0),
 (13216,4,36,141,2,'0.09',0),
 (13217,4,38,141,117,'5.51',0),
 (13218,4,39,141,9,'0.42',0),
 (13219,4,40,141,1,'0.05',0),
 (13220,4,41,141,2,'0.09',0),
 (13221,4,42,141,1,'0.05',0),
 (13222,4,43,141,3,'0.14',0),
 (13223,4,44,141,2,'0.09',0),
 (13224,4,45,141,1,'0.05',0),
 (13225,4,46,141,2,'0.09',0),
 (13226,4,47,141,0,'0.00',0),
 (13227,4,48,141,0,'0.00',0),
 (13228,4,49,141,4,'0.19',0);
INSERT INTO `elecmunicandi` (`idElecMuniCandi`,`Convocatoria_idConvocatoria`,`Candidatura_idCandidatura`,`Municipio`,`Votos`,`PorcVotos`,`Concejales`) VALUES 
 (13229,4,50,141,0,'0.00',0),
 (13230,4,51,141,15,'0.71',0),
 (13231,4,1,143,43,'53.09',0),
 (13232,4,2,143,36,'44.44',0),
 (13233,4,14,143,0,'0.00',0),
 (13234,4,15,143,0,'0.00',0),
 (13235,4,16,143,0,'0.00',0),
 (13236,4,28,143,0,'0.00',0),
 (13237,4,32,143,0,'0.00',0),
 (13238,4,36,143,0,'0.00',0),
 (13239,4,38,143,1,'1.23',0),
 (13240,4,39,143,0,'0.00',0),
 (13241,4,40,143,0,'0.00',0),
 (13242,4,41,143,0,'0.00',0),
 (13243,4,42,143,0,'0.00',0),
 (13244,4,43,143,0,'0.00',0),
 (13245,4,44,143,0,'0.00',0),
 (13246,4,45,143,0,'0.00',0),
 (13247,4,46,143,1,'1.23',0),
 (13248,4,47,143,0,'0.00',0),
 (13249,4,48,143,0,'0.00',0),
 (13250,4,49,143,0,'0.00',0),
 (13251,4,50,143,0,'0.00',0),
 (13252,4,51,143,0,'0.00',0),
 (13253,4,1,144,1763,'55.92',0),
 (13254,4,2,144,1053,'33.40',0),
 (13255,4,14,144,0,'0.00',0),
 (13256,4,15,144,1,'0.03',0),
 (13257,4,16,144,2,'0.06',0),
 (13258,4,28,144,1,'0.03',0),
 (13259,4,32,144,1,'0.03',0),
 (13260,4,36,144,3,'0.10',0),
 (13261,4,38,144,226,'7.17',0),
 (13262,4,39,144,15,'0.48',0),
 (13263,4,40,144,0,'0.00',0),
 (13264,4,41,144,0,'0.00',0),
 (13265,4,42,144,0,'0.00',0),
 (13266,4,43,144,8,'0.25',0),
 (13267,4,44,144,3,'0.10',0),
 (13268,4,45,144,1,'0.03',0),
 (13269,4,46,144,0,'0.00',0),
 (13270,4,47,144,0,'0.00',0),
 (13271,4,48,144,0,'0.00',0),
 (13272,4,49,144,5,'0.16',0),
 (13273,4,50,144,0,'0.00',0),
 (13274,4,51,144,20,'0.63',0),
 (13275,4,1,145,344,'41.00',0),
 (13276,4,2,145,388,'46.25',0),
 (13277,4,14,145,0,'0.00',0),
 (13278,4,15,145,0,'0.00',0),
 (13279,4,16,145,1,'0.12',0),
 (13280,4,28,145,0,'0.00',0),
 (13281,4,32,145,0,'0.00',0),
 (13282,4,36,145,2,'0.24',0),
 (13283,4,38,145,67,'7.99',0),
 (13284,4,39,145,2,'0.24',0),
 (13285,4,40,145,1,'0.12',0),
 (13286,4,41,145,0,'0.00',0),
 (13287,4,42,145,0,'0.00',0),
 (13288,4,43,145,8,'0.95',0),
 (13289,4,44,145,1,'0.12',0),
 (13290,4,45,145,5,'0.60',0),
 (13291,4,46,145,1,'0.12',0),
 (13292,4,47,145,0,'0.00',0),
 (13293,4,48,145,0,'0.00',0),
 (13294,4,49,145,0,'0.00',0),
 (13295,4,50,145,1,'0.12',0),
 (13296,4,51,145,2,'0.24',0),
 (13297,4,1,146,612,'55.79',0),
 (13298,4,2,146,441,'40.20',0),
 (13299,4,14,146,0,'0.00',0),
 (13300,4,15,146,0,'0.00',0),
 (13301,4,16,146,1,'0.09',0),
 (13302,4,28,146,1,'0.09',0),
 (13303,4,32,146,0,'0.00',0),
 (13304,4,36,146,0,'0.00',0),
 (13305,4,38,146,36,'3.28',0),
 (13306,4,39,146,0,'0.00',0),
 (13307,4,40,146,0,'0.00',0),
 (13308,4,41,146,0,'0.00',0),
 (13309,4,42,146,0,'0.00',0),
 (13310,4,43,146,0,'0.00',0),
 (13311,4,44,146,0,'0.00',0),
 (13312,4,45,146,0,'0.00',0),
 (13313,4,46,146,0,'0.00',0),
 (13314,4,47,146,0,'0.00',0),
 (13315,4,48,146,0,'0.00',0),
 (13316,4,49,146,0,'0.00',0),
 (13317,4,50,146,0,'0.00',0),
 (13318,4,51,146,2,'0.18',0),
 (13319,4,1,147,264,'52.59',0),
 (13320,4,2,147,212,'42.23',0),
 (13321,4,14,147,1,'0.20',0),
 (13322,4,15,147,0,'0.00',0),
 (13323,4,16,147,0,'0.00',0),
 (13324,4,28,147,2,'0.40',0),
 (13325,4,32,147,0,'0.00',0),
 (13326,4,36,147,0,'0.00',0),
 (13327,4,38,147,19,'3.78',0),
 (13328,4,39,147,0,'0.00',0),
 (13329,4,40,147,0,'0.00',0),
 (13330,4,41,147,0,'0.00',0),
 (13331,4,42,147,0,'0.00',0),
 (13332,4,43,147,0,'0.00',0),
 (13333,4,44,147,0,'0.00',0),
 (13334,4,45,147,1,'0.20',0),
 (13335,4,46,147,0,'0.00',0),
 (13336,4,47,147,0,'0.00',0),
 (13337,4,48,147,0,'0.00',0),
 (13338,4,49,147,0,'0.00',0),
 (13339,4,50,147,0,'0.00',0),
 (13340,4,51,147,0,'0.00',0),
 (13341,4,1,148,17380,'40.93',0),
 (13342,4,2,148,19166,'45.14',0),
 (13343,4,14,148,14,'0.03',0),
 (13344,4,15,148,42,'0.10',0),
 (13345,4,16,148,25,'0.06',0),
 (13346,4,28,148,31,'0.07',0),
 (13347,4,32,148,231,'0.54',0),
 (13348,4,36,148,207,'0.49',0),
 (13349,4,38,148,3800,'8.95',0),
 (13350,4,39,148,281,'0.66',0),
 (13351,4,40,148,13,'0.03',0),
 (13352,4,41,148,15,'0.04',0),
 (13353,4,42,148,19,'0.04',0),
 (13354,4,43,148,82,'0.19',0),
 (13355,4,44,148,17,'0.04',0),
 (13356,4,45,148,21,'0.05',0),
 (13357,4,46,148,27,'0.06',0),
 (13358,4,47,148,12,'0.03',0),
 (13359,4,48,148,0,'0.00',0),
 (13360,4,49,148,94,'0.22',0),
 (13361,4,50,148,8,'0.02',0),
 (13362,4,51,148,278,'0.65',0),
 (13363,4,1,149,1074,'48.42',0),
 (13364,4,2,149,914,'41.21',0),
 (13365,4,14,149,0,'0.00',0),
 (13366,4,15,149,3,'0.14',0),
 (13367,4,16,149,4,'0.18',0),
 (13368,4,28,149,4,'0.18',0),
 (13369,4,32,149,0,'0.00',0),
 (13370,4,36,149,2,'0.09',0),
 (13371,4,38,149,145,'6.54',0),
 (13372,4,39,149,17,'0.77',0),
 (13373,4,40,149,0,'0.00',0),
 (13374,4,41,149,0,'0.00',0),
 (13375,4,42,149,1,'0.05',0),
 (13376,4,43,149,5,'0.23',0),
 (13377,4,44,149,2,'0.09',0),
 (13378,4,45,149,0,'0.00',0),
 (13379,4,46,149,1,'0.05',0),
 (13380,4,47,149,0,'0.00',0),
 (13381,4,48,149,0,'0.00',0),
 (13382,4,49,149,8,'0.36',0),
 (13383,4,50,149,0,'0.00',0),
 (13384,4,51,149,20,'0.90',0),
 (13385,4,1,150,662,'49.29',0),
 (13386,4,2,150,537,'39.99',0),
 (13387,4,14,150,0,'0.00',0),
 (13388,4,15,150,3,'0.22',0),
 (13389,4,16,150,0,'0.00',0),
 (13390,4,28,150,1,'0.07',0),
 (13391,4,32,150,0,'0.00',0),
 (13392,4,36,150,1,'0.07',0),
 (13393,4,38,150,115,'8.56',0),
 (13394,4,39,150,2,'0.15',0),
 (13395,4,40,150,1,'0.07',0),
 (13396,4,41,150,0,'0.00',0),
 (13397,4,42,150,0,'0.00',0),
 (13398,4,43,150,0,'0.00',0),
 (13399,4,44,150,0,'0.00',0),
 (13400,4,45,150,0,'0.00',0),
 (13401,4,46,150,0,'0.00',0),
 (13402,4,47,150,0,'0.00',0),
 (13403,4,48,150,0,'0.00',0),
 (13404,4,49,150,3,'0.22',0),
 (13405,4,50,150,0,'0.00',0),
 (13406,4,51,150,4,'0.30',0),
 (13407,4,1,151,780,'48.72',0),
 (13408,4,2,151,699,'43.66',0),
 (13409,4,14,151,0,'0.00',0),
 (13410,4,15,151,3,'0.19',0),
 (13411,4,16,151,1,'0.06',0),
 (13412,4,28,151,0,'0.00',0),
 (13413,4,32,151,1,'0.06',0),
 (13414,4,36,151,3,'0.19',0),
 (13415,4,38,151,80,'5.00',0),
 (13416,4,39,151,4,'0.25',0),
 (13417,4,40,151,0,'0.00',0),
 (13418,4,41,151,4,'0.25',0),
 (13419,4,42,151,0,'0.00',0),
 (13420,4,43,151,2,'0.12',0),
 (13421,4,44,151,1,'0.06',0),
 (13422,4,45,151,1,'0.06',0),
 (13423,4,46,151,2,'0.12',0),
 (13424,4,47,151,0,'0.00',0),
 (13425,4,48,151,0,'0.00',0),
 (13426,4,49,151,3,'0.19',0),
 (13427,4,50,151,0,'0.00',0),
 (13428,4,51,151,1,'0.06',0),
 (13429,4,1,152,5319,'64.14',0),
 (13430,4,2,152,2056,'24.79',0),
 (13431,4,14,152,2,'0.02',0),
 (13432,4,15,152,3,'0.04',0),
 (13433,4,16,152,1,'0.01',0),
 (13434,4,28,152,4,'0.05',0),
 (13435,4,32,152,0,'0.00',0),
 (13436,4,36,152,6,'0.07',0),
 (13437,4,38,152,547,'6.60',0),
 (13438,4,39,152,38,'0.46',0),
 (13439,4,40,152,2,'0.02',0),
 (13440,4,41,152,4,'0.05',0),
 (13441,4,42,152,2,'0.02',0),
 (13442,4,43,152,16,'0.19',0),
 (13443,4,44,152,10,'0.12',0),
 (13444,4,45,152,5,'0.06',0),
 (13445,4,46,152,12,'0.14',0),
 (13446,4,47,152,3,'0.04',0),
 (13447,4,48,152,0,'0.00',0),
 (13448,4,49,152,29,'0.35',0),
 (13449,4,50,152,2,'0.02',0),
 (13450,4,51,152,46,'0.55',0),
 (13451,4,1,153,117,'44.83',0),
 (13452,4,2,153,96,'36.78',0),
 (13453,4,14,153,0,'0.00',0),
 (13454,4,15,153,0,'0.00',0),
 (13455,4,16,153,1,'0.38',0),
 (13456,4,28,153,0,'0.00',0),
 (13457,4,32,153,0,'0.00',0),
 (13458,4,36,153,0,'0.00',0),
 (13459,4,38,153,35,'13.41',0),
 (13460,4,39,153,3,'1.15',0),
 (13461,4,40,153,0,'0.00',0),
 (13462,4,41,153,0,'0.00',0),
 (13463,4,42,153,0,'0.00',0),
 (13464,4,43,153,1,'0.38',0),
 (13465,4,44,153,1,'0.38',0),
 (13466,4,45,153,0,'0.00',0),
 (13467,4,46,153,0,'0.00',0),
 (13468,4,47,153,0,'0.00',0),
 (13469,4,48,153,0,'0.00',0),
 (13470,4,49,153,0,'0.00',0),
 (13471,4,50,153,0,'0.00',0),
 (13472,4,51,153,0,'0.00',0),
 (13473,4,1,154,1035,'42.16',0),
 (13474,4,2,154,1253,'51.04',0),
 (13475,4,14,154,1,'0.04',0),
 (13476,4,15,154,4,'0.16',0),
 (13477,4,16,154,0,'0.00',0),
 (13478,4,28,154,0,'0.00',0),
 (13479,4,32,154,0,'0.00',0),
 (13480,4,36,154,5,'0.20',0),
 (13481,4,38,154,114,'4.64',0),
 (13482,4,39,154,4,'0.16',0),
 (13483,4,40,154,1,'0.04',0),
 (13484,4,41,154,1,'0.04',0),
 (13485,4,42,154,4,'0.16',0),
 (13486,4,43,154,1,'0.04',0),
 (13487,4,44,154,1,'0.04',0),
 (13488,4,45,154,0,'0.00',0),
 (13489,4,46,154,0,'0.00',0),
 (13490,4,47,154,0,'0.00',0),
 (13491,4,48,154,0,'0.00',0),
 (13492,4,49,154,3,'0.12',0),
 (13493,4,50,154,0,'0.00',0),
 (13494,4,51,154,7,'0.29',0),
 (13495,4,1,155,154,'37.65',0),
 (13496,4,2,155,244,'59.66',0),
 (13497,4,14,155,0,'0.00',0),
 (13498,4,15,155,0,'0.00',0),
 (13499,4,16,155,0,'0.00',0),
 (13500,4,28,155,0,'0.00',0),
 (13501,4,32,155,0,'0.00',0),
 (13502,4,36,155,0,'0.00',0),
 (13503,4,38,155,9,'2.20',0),
 (13504,4,39,155,0,'0.00',0),
 (13505,4,40,155,0,'0.00',0),
 (13506,4,41,155,0,'0.00',0),
 (13507,4,42,155,0,'0.00',0),
 (13508,4,43,155,0,'0.00',0),
 (13509,4,44,155,0,'0.00',0),
 (13510,4,45,155,0,'0.00',0),
 (13511,4,46,155,0,'0.00',0),
 (13512,4,47,155,0,'0.00',0),
 (13513,4,48,155,0,'0.00',0),
 (13514,4,49,155,0,'0.00',0),
 (13515,4,50,155,0,'0.00',0),
 (13516,4,51,155,0,'0.00',0),
 (13517,4,1,156,211,'49.30',0),
 (13518,4,2,156,182,'42.52',0),
 (13519,4,14,156,0,'0.00',0),
 (13520,4,15,156,0,'0.00',0),
 (13521,4,16,156,0,'0.00',0),
 (13522,4,28,156,0,'0.00',0),
 (13523,4,32,156,0,'0.00',0),
 (13524,4,36,156,3,'0.70',0),
 (13525,4,38,156,15,'3.50',0),
 (13526,4,39,156,1,'0.23',0),
 (13527,4,40,156,0,'0.00',0),
 (13528,4,41,156,0,'0.00',0),
 (13529,4,42,156,5,'1.17',0),
 (13530,4,43,156,1,'0.23',0),
 (13531,4,44,156,1,'0.23',0),
 (13532,4,45,156,0,'0.00',0),
 (13533,4,46,156,0,'0.00',0),
 (13534,4,47,156,1,'0.23',0),
 (13535,4,48,156,0,'0.00',0),
 (13536,4,49,156,1,'0.23',0),
 (13537,4,50,156,0,'0.00',0),
 (13538,4,51,156,2,'0.47',0),
 (13539,4,1,157,219,'63.11',0),
 (13540,4,2,157,113,'32.56',0),
 (13541,4,14,157,0,'0.00',0),
 (13542,4,15,157,0,'0.00',0),
 (13543,4,16,157,0,'0.00',0),
 (13544,4,28,157,0,'0.00',0),
 (13545,4,32,157,0,'0.00',0),
 (13546,4,36,157,0,'0.00',0),
 (13547,4,38,157,11,'3.17',0),
 (13548,4,39,157,0,'0.00',0),
 (13549,4,40,157,0,'0.00',0),
 (13550,4,41,157,0,'0.00',0),
 (13551,4,42,157,0,'0.00',0),
 (13552,4,43,157,0,'0.00',0),
 (13553,4,44,157,0,'0.00',0),
 (13554,4,45,157,1,'0.29',0),
 (13555,4,46,157,0,'0.00',0),
 (13556,4,47,157,0,'0.00',0),
 (13557,4,48,157,0,'0.00',0),
 (13558,4,49,157,0,'0.00',0),
 (13559,4,50,157,0,'0.00',0),
 (13560,4,51,157,2,'0.58',0),
 (13561,4,1,158,235,'64.03',0),
 (13562,4,2,158,108,'29.43',0),
 (13563,4,14,158,0,'0.00',0),
 (13564,4,15,158,0,'0.00',0),
 (13565,4,16,158,1,'0.27',0),
 (13566,4,28,158,2,'0.54',0),
 (13567,4,32,158,0,'0.00',0),
 (13568,4,36,158,0,'0.00',0),
 (13569,4,38,158,15,'4.09',0),
 (13570,4,39,158,1,'0.27',0),
 (13571,4,40,158,0,'0.00',0),
 (13572,4,41,158,0,'0.00',0),
 (13573,4,42,158,0,'0.00',0),
 (13574,4,43,158,0,'0.00',0),
 (13575,4,44,158,0,'0.00',0),
 (13576,4,45,158,0,'0.00',0),
 (13577,4,46,158,0,'0.00',0),
 (13578,4,47,158,0,'0.00',0),
 (13579,4,48,158,0,'0.00',0),
 (13580,4,49,158,1,'0.27',0),
 (13581,4,50,158,0,'0.00',0),
 (13582,4,51,158,0,'0.00',0),
 (13583,4,1,159,163,'40.35',0),
 (13584,4,2,159,226,'55.94',0),
 (13585,4,14,159,0,'0.00',0),
 (13586,4,15,159,0,'0.00',0),
 (13587,4,16,159,0,'0.00',0),
 (13588,4,28,159,0,'0.00',0),
 (13589,4,32,159,0,'0.00',0),
 (13590,4,36,159,0,'0.00',0),
 (13591,4,38,159,14,'3.47',0),
 (13592,4,39,159,0,'0.00',0),
 (13593,4,40,159,0,'0.00',0),
 (13594,4,41,159,0,'0.00',0),
 (13595,4,42,159,0,'0.00',0),
 (13596,4,43,159,0,'0.00',0),
 (13597,4,44,159,0,'0.00',0),
 (13598,4,45,159,0,'0.00',0),
 (13599,4,46,159,0,'0.00',0),
 (13600,4,47,159,0,'0.00',0),
 (13601,4,48,159,0,'0.00',0),
 (13602,4,49,159,0,'0.00',0),
 (13603,4,50,159,0,'0.00',0),
 (13604,4,51,159,0,'0.00',0),
 (13605,4,1,160,1885,'54.51',0),
 (13606,4,2,160,1208,'34.93',0),
 (13607,4,14,160,0,'0.00',0),
 (13608,4,15,160,1,'0.03',0),
 (13609,4,16,160,8,'0.23',0),
 (13610,4,28,160,2,'0.06',0),
 (13611,4,32,160,0,'0.00',0),
 (13612,4,36,160,8,'0.23',0),
 (13613,4,38,160,242,'7.00',0),
 (13614,4,39,160,20,'0.58',0),
 (13615,4,40,160,0,'0.00',0),
 (13616,4,41,160,3,'0.09',0),
 (13617,4,42,160,3,'0.09',0),
 (13618,4,43,160,7,'0.20',0),
 (13619,4,44,160,2,'0.06',0),
 (13620,4,45,160,0,'0.00',0),
 (13621,4,46,160,0,'0.00',0),
 (13622,4,47,160,1,'0.03',0),
 (13623,4,48,160,0,'0.00',0),
 (13624,4,49,160,8,'0.23',0),
 (13625,4,50,160,0,'0.00',0),
 (13626,4,51,160,14,'0.40',0),
 (13627,4,1,161,8735,'53.68',0),
 (13628,4,2,161,5689,'34.96',0),
 (13629,4,14,161,7,'0.04',0),
 (13630,4,15,161,16,'0.10',0),
 (13631,4,16,161,11,'0.07',0),
 (13632,4,28,161,18,'0.11',0),
 (13633,4,32,161,2,'0.01',0),
 (13634,4,36,161,16,'0.10',0),
 (13635,4,38,161,1119,'6.88',0),
 (13636,4,39,161,79,'0.49',0),
 (13637,4,40,161,7,'0.04',0),
 (13638,4,41,161,5,'0.03',0),
 (13639,4,42,161,2,'0.01',0),
 (13640,4,43,161,35,'0.22',0),
 (13641,4,44,161,8,'0.05',0),
 (13642,4,45,161,1,'0.01',0),
 (13643,4,46,161,5,'0.03',0),
 (13644,4,47,161,3,'0.02',0),
 (13645,4,48,161,0,'0.00',0),
 (13646,4,49,161,44,'0.27',0),
 (13647,4,50,161,0,'0.00',0),
 (13648,4,51,161,196,'1.20',0),
 (13649,4,1,162,632,'59.91',0),
 (13650,4,2,162,316,'29.95',0),
 (13651,4,14,162,0,'0.00',0),
 (13652,4,15,162,1,'0.09',0),
 (13653,4,16,162,0,'0.00',0),
 (13654,4,28,162,0,'0.00',0),
 (13655,4,32,162,0,'0.00',0),
 (13656,4,36,162,1,'0.09',0),
 (13657,4,38,162,60,'5.69',0),
 (13658,4,39,162,5,'0.47',0),
 (13659,4,40,162,0,'0.00',0),
 (13660,4,41,162,0,'0.00',0),
 (13661,4,42,162,0,'0.00',0),
 (13662,4,43,162,2,'0.19',0),
 (13663,4,44,162,1,'0.09',0),
 (13664,4,45,162,4,'0.38',0),
 (13665,4,46,162,0,'0.00',0),
 (13666,4,47,162,0,'0.00',0),
 (13667,4,48,162,0,'0.00',0),
 (13668,4,49,162,1,'0.09',0),
 (13669,4,50,162,0,'0.00',0),
 (13670,4,51,162,9,'0.85',0),
 (13671,4,1,163,98,'50.00',0),
 (13672,4,2,163,77,'39.29',0),
 (13673,4,14,163,0,'0.00',0),
 (13674,4,15,163,0,'0.00',0),
 (13675,4,16,163,0,'0.00',0),
 (13676,4,28,163,0,'0.00',0),
 (13677,4,32,163,0,'0.00',0),
 (13678,4,36,163,0,'0.00',0),
 (13679,4,38,163,12,'6.12',0),
 (13680,4,39,163,0,'0.00',0),
 (13681,4,40,163,0,'0.00',0),
 (13682,4,41,163,0,'0.00',0),
 (13683,4,42,163,0,'0.00',0),
 (13684,4,43,163,1,'0.51',0),
 (13685,4,44,163,0,'0.00',0),
 (13686,4,45,163,1,'0.51',0),
 (13687,4,46,163,0,'0.00',0),
 (13688,4,47,163,0,'0.00',0),
 (13689,4,48,163,0,'0.00',0),
 (13690,4,49,163,0,'0.00',0),
 (13691,4,50,163,0,'0.00',0),
 (13692,4,51,163,0,'0.00',0),
 (13693,4,1,164,608,'53.43',0),
 (13694,4,2,164,416,'36.56',0),
 (13695,4,14,164,0,'0.00',0),
 (13696,4,15,164,1,'0.09',0),
 (13697,4,16,164,3,'0.26',0),
 (13698,4,28,164,0,'0.00',0),
 (13699,4,32,164,0,'0.00',0),
 (13700,4,36,164,1,'0.09',0),
 (13701,4,38,164,60,'5.27',0),
 (13702,4,39,164,8,'0.70',0),
 (13703,4,40,164,0,'0.00',0),
 (13704,4,41,164,0,'0.00',0),
 (13705,4,42,164,3,'0.26',0),
 (13706,4,43,164,8,'0.70',0),
 (13707,4,44,164,2,'0.18',0),
 (13708,4,45,164,1,'0.09',0),
 (13709,4,46,164,0,'0.00',0),
 (13710,4,47,164,0,'0.00',0),
 (13711,4,48,164,0,'0.00',0),
 (13712,4,49,164,0,'0.00',0),
 (13713,4,50,164,0,'0.00',0),
 (13714,4,51,164,9,'0.79',0),
 (13715,4,1,165,596,'57.47',0),
 (13716,4,2,165,421,'40.60',0),
 (13717,4,14,165,1,'0.10',0),
 (13718,4,15,165,0,'0.00',0),
 (13719,4,16,165,0,'0.00',0),
 (13720,4,28,165,0,'0.00',0),
 (13721,4,32,165,0,'0.00',0),
 (13722,4,36,165,0,'0.00',0),
 (13723,4,38,165,11,'1.06',0),
 (13724,4,39,165,0,'0.00',0),
 (13725,4,40,165,0,'0.00',0),
 (13726,4,41,165,0,'0.00',0),
 (13727,4,42,165,0,'0.00',0),
 (13728,4,43,165,0,'0.00',0),
 (13729,4,44,165,0,'0.00',0),
 (13730,4,45,165,0,'0.00',0),
 (13731,4,46,165,0,'0.00',0),
 (13732,4,47,165,0,'0.00',0),
 (13733,4,48,165,0,'0.00',0),
 (13734,4,49,165,0,'0.00',0),
 (13735,4,50,165,0,'0.00',0),
 (13736,4,51,165,0,'0.00',0),
 (13737,4,1,166,87,'45.31',0),
 (13738,4,2,166,87,'45.31',0),
 (13739,4,14,166,0,'0.00',0),
 (13740,4,15,166,0,'0.00',0),
 (13741,4,16,166,0,'0.00',0),
 (13742,4,28,166,0,'0.00',0),
 (13743,4,32,166,0,'0.00',0),
 (13744,4,36,166,0,'0.00',0),
 (13745,4,38,166,15,'7.81',0),
 (13746,4,39,166,1,'0.52',0),
 (13747,4,40,166,0,'0.00',0),
 (13748,4,41,166,0,'0.00',0),
 (13749,4,42,166,0,'0.00',0),
 (13750,4,43,166,1,'0.52',0),
 (13751,4,44,166,0,'0.00',0),
 (13752,4,45,166,0,'0.00',0),
 (13753,4,46,166,0,'0.00',0),
 (13754,4,47,166,0,'0.00',0),
 (13755,4,48,166,0,'0.00',0),
 (13756,4,49,166,0,'0.00',0),
 (13757,4,50,166,0,'0.00',0),
 (13758,4,51,166,0,'0.00',0),
 (13759,4,1,167,1517,'38.73',0),
 (13760,4,2,167,1777,'45.37',0),
 (13761,4,14,167,2,'0.05',0),
 (13762,4,15,167,2,'0.05',0),
 (13763,4,16,167,0,'0.00',0),
 (13764,4,28,167,3,'0.08',0),
 (13765,4,32,167,1,'0.03',0),
 (13766,4,36,167,6,'0.15',0),
 (13767,4,38,167,467,'11.92',0),
 (13768,4,39,167,27,'0.69',0),
 (13769,4,40,167,1,'0.03',0),
 (13770,4,41,167,1,'0.03',0),
 (13771,4,42,167,2,'0.05',0),
 (13772,4,43,167,12,'0.31',0),
 (13773,4,44,167,2,'0.05',0),
 (13774,4,45,167,1,'0.03',0),
 (13775,4,46,167,4,'0.10',0),
 (13776,4,47,167,4,'0.10',0),
 (13777,4,48,167,0,'0.00',0),
 (13778,4,49,167,13,'0.33',0),
 (13779,4,50,167,0,'0.00',0),
 (13780,4,51,167,17,'0.43',0),
 (13781,4,1,168,356,'56.96',0),
 (13782,4,2,168,244,'39.04',0),
 (13783,4,14,168,0,'0.00',0),
 (13784,4,15,168,0,'0.00',0),
 (13785,4,16,168,0,'0.00',0),
 (13786,4,28,168,0,'0.00',0),
 (13787,4,32,168,0,'0.00',0),
 (13788,4,36,168,0,'0.00',0),
 (13789,4,38,168,17,'2.72',0),
 (13790,4,39,168,0,'0.00',0),
 (13791,4,40,168,0,'0.00',0),
 (13792,4,41,168,0,'0.00',0),
 (13793,4,42,168,0,'0.00',0),
 (13794,4,43,168,0,'0.00',0),
 (13795,4,44,168,0,'0.00',0),
 (13796,4,45,168,0,'0.00',0),
 (13797,4,46,168,0,'0.00',0),
 (13798,4,47,168,0,'0.00',0),
 (13799,4,48,168,0,'0.00',0),
 (13800,4,49,168,0,'0.00',0),
 (13801,4,50,168,0,'0.00',0),
 (13802,4,51,168,1,'0.16',0),
 (13803,4,1,169,324,'61.83',0),
 (13804,4,2,169,151,'28.82',0),
 (13805,4,14,169,0,'0.00',0),
 (13806,4,15,169,0,'0.00',0),
 (13807,4,16,169,0,'0.00',0),
 (13808,4,28,169,1,'0.19',0),
 (13809,4,32,169,0,'0.00',0),
 (13810,4,36,169,0,'0.00',0),
 (13811,4,38,169,25,'4.77',0),
 (13812,4,39,169,6,'1.15',0),
 (13813,4,40,169,0,'0.00',0),
 (13814,4,41,169,0,'0.00',0),
 (13815,4,42,169,1,'0.19',0),
 (13816,4,43,169,1,'0.19',0),
 (13817,4,44,169,0,'0.00',0),
 (13818,4,45,169,1,'0.19',0),
 (13819,4,46,169,0,'0.00',0),
 (13820,4,47,169,0,'0.00',0),
 (13821,4,48,169,0,'0.00',0),
 (13822,4,49,169,0,'0.00',0),
 (13823,4,50,169,0,'0.00',0),
 (13824,4,51,169,4,'0.76',0),
 (13825,4,1,170,418,'35.88',0),
 (13826,4,2,170,556,'47.73',0),
 (13827,4,14,170,0,'0.00',0),
 (13828,4,15,170,1,'0.09',0),
 (13829,4,16,170,0,'0.00',0),
 (13830,4,28,170,0,'0.00',0),
 (13831,4,32,170,0,'0.00',0),
 (13832,4,36,170,0,'0.00',0),
 (13833,4,38,170,177,'15.19',0),
 (13834,4,39,170,3,'0.26',0),
 (13835,4,40,170,0,'0.00',0),
 (13836,4,41,170,0,'0.00',0),
 (13837,4,42,170,0,'0.00',0),
 (13838,4,43,170,5,'0.43',0),
 (13839,4,44,170,0,'0.00',0),
 (13840,4,45,170,0,'0.00',0),
 (13841,4,46,170,0,'0.00',0),
 (13842,4,47,170,0,'0.00',0),
 (13843,4,48,170,0,'0.00',0),
 (13844,4,49,170,0,'0.00',0),
 (13845,4,50,170,0,'0.00',0),
 (13846,4,51,170,1,'0.09',0),
 (13847,4,1,171,1363,'61.01',0),
 (13848,4,2,171,775,'34.69',0),
 (13849,4,14,171,1,'0.04',0),
 (13850,4,15,171,0,'0.00',0),
 (13851,4,16,171,0,'0.00',0),
 (13852,4,28,171,0,'0.00',0),
 (13853,4,32,171,0,'0.00',0),
 (13854,4,36,171,1,'0.04',0),
 (13855,4,38,171,65,'2.91',0),
 (13856,4,39,171,3,'0.13',0),
 (13857,4,40,171,0,'0.00',0),
 (13858,4,41,171,0,'0.00',0),
 (13859,4,42,171,1,'0.04',0),
 (13860,4,43,171,4,'0.18',0),
 (13861,4,44,171,0,'0.00',0),
 (13862,4,45,171,0,'0.00',0),
 (13863,4,46,171,2,'0.09',0),
 (13864,4,47,171,1,'0.04',0),
 (13865,4,48,171,0,'0.00',0),
 (13866,4,49,171,2,'0.09',0),
 (13867,4,50,171,1,'0.04',0),
 (13868,4,51,171,3,'0.13',0),
 (13869,4,1,172,1936,'59.99',0),
 (13870,4,2,172,982,'30.43',0),
 (13871,4,14,172,2,'0.06',0),
 (13872,4,15,172,3,'0.09',0),
 (13873,4,16,172,1,'0.03',0),
 (13874,4,28,172,1,'0.03',0),
 (13875,4,32,172,1,'0.03',0),
 (13876,4,36,172,13,'0.40',0),
 (13877,4,38,172,171,'5.30',0),
 (13878,4,39,172,20,'0.62',0),
 (13879,4,40,172,1,'0.03',0),
 (13880,4,41,172,2,'0.06',0),
 (13881,4,42,172,1,'0.03',0),
 (13882,4,43,172,6,'0.19',0),
 (13883,4,44,172,1,'0.03',0),
 (13884,4,45,172,3,'0.09',0),
 (13885,4,46,172,1,'0.03',0),
 (13886,4,47,172,1,'0.03',0),
 (13887,4,48,172,0,'0.00',0),
 (13888,4,49,172,11,'0.34',0),
 (13889,4,50,172,0,'0.00',0),
 (13890,4,51,172,16,'0.50',0),
 (13891,4,1,173,178,'53.29',0),
 (13892,4,2,173,144,'43.11',0),
 (13893,4,14,173,0,'0.00',0),
 (13894,4,15,173,0,'0.00',0),
 (13895,4,16,173,0,'0.00',0),
 (13896,4,28,173,0,'0.00',0),
 (13897,4,32,173,0,'0.00',0),
 (13898,4,36,173,0,'0.00',0),
 (13899,4,38,173,9,'2.69',0),
 (13900,4,39,173,1,'0.30',0),
 (13901,4,40,173,0,'0.00',0),
 (13902,4,41,173,0,'0.00',0),
 (13903,4,42,173,0,'0.00',0),
 (13904,4,43,173,0,'0.00',0),
 (13905,4,44,173,0,'0.00',0),
 (13906,4,45,173,0,'0.00',0),
 (13907,4,46,173,0,'0.00',0),
 (13908,4,47,173,0,'0.00',0),
 (13909,4,48,173,0,'0.00',0),
 (13910,4,49,173,1,'0.30',0),
 (13911,4,50,173,0,'0.00',0),
 (13912,4,51,173,0,'0.00',0),
 (13913,4,1,174,477,'58.46',0),
 (13914,4,2,174,302,'37.01',0),
 (13915,4,14,174,0,'0.00',0),
 (13916,4,15,174,0,'0.00',0),
 (13917,4,16,174,1,'0.12',0),
 (13918,4,28,174,0,'0.00',0),
 (13919,4,32,174,0,'0.00',0),
 (13920,4,36,174,0,'0.00',0),
 (13921,4,38,174,17,'2.08',0),
 (13922,4,39,174,1,'0.12',0),
 (13923,4,40,174,2,'0.25',0),
 (13924,4,41,174,1,'0.12',0),
 (13925,4,42,174,0,'0.00',0),
 (13926,4,43,174,1,'0.12',0),
 (13927,4,44,174,0,'0.00',0),
 (13928,4,45,174,0,'0.00',0),
 (13929,4,46,174,1,'0.12',0),
 (13930,4,47,174,0,'0.00',0),
 (13931,4,48,174,0,'0.00',0),
 (13932,4,49,174,4,'0.49',0),
 (13933,4,50,174,0,'0.00',0),
 (13934,4,51,174,3,'0.37',0),
 (13935,4,1,175,169,'66.02',0),
 (13936,4,2,175,75,'29.30',0),
 (13937,4,14,175,2,'0.78',0),
 (13938,4,15,175,0,'0.00',0),
 (13939,4,16,175,1,'0.39',0),
 (13940,4,28,175,1,'0.39',0),
 (13941,4,32,175,0,'0.00',0),
 (13942,4,36,175,0,'0.00',0),
 (13943,4,38,175,5,'1.95',0),
 (13944,4,39,175,1,'0.39',0),
 (13945,4,40,175,0,'0.00',0),
 (13946,4,41,175,0,'0.00',0),
 (13947,4,42,175,0,'0.00',0),
 (13948,4,43,175,0,'0.00',0),
 (13949,4,44,175,0,'0.00',0),
 (13950,4,45,175,0,'0.00',0),
 (13951,4,46,175,0,'0.00',0),
 (13952,4,47,175,0,'0.00',0),
 (13953,4,48,175,0,'0.00',0),
 (13954,4,49,175,1,'0.39',0),
 (13955,4,50,175,0,'0.00',0),
 (13956,4,51,175,0,'0.00',0),
 (13957,4,1,176,3834,'69.65',0),
 (13958,4,2,176,1189,'21.60',0),
 (13959,4,14,176,2,'0.04',0),
 (13960,4,15,176,4,'0.07',0),
 (13961,4,16,176,6,'0.11',0),
 (13962,4,28,176,3,'0.05',0),
 (13963,4,32,176,0,'0.00',0),
 (13964,4,36,176,1,'0.02',0),
 (13965,4,38,176,249,'4.52',0),
 (13966,4,39,176,42,'0.76',0),
 (13967,4,40,176,2,'0.04',0),
 (13968,4,41,176,1,'0.02',0),
 (13969,4,42,176,3,'0.05',0),
 (13970,4,43,176,18,'0.33',0),
 (13971,4,44,176,4,'0.07',0),
 (13972,4,45,176,2,'0.04',0),
 (13973,4,46,176,5,'0.09',0),
 (13974,4,47,176,3,'0.05',0),
 (13975,4,48,176,0,'0.00',0),
 (13976,4,49,176,15,'0.27',0),
 (13977,4,50,176,1,'0.02',0),
 (13978,4,51,176,21,'0.38',0),
 (13979,4,1,177,1933,'57.09',0),
 (13980,4,2,177,1092,'32.25',0),
 (13981,4,14,177,5,'0.15',0),
 (13982,4,15,177,0,'0.00',0),
 (13983,4,16,177,6,'0.18',0),
 (13984,4,28,177,1,'0.03',0),
 (13985,4,32,177,0,'0.00',0),
 (13986,4,36,177,1,'0.03',0),
 (13987,4,38,177,193,'5.70',0),
 (13988,4,39,177,23,'0.68',0),
 (13989,4,40,177,1,'0.03',0),
 (13990,4,41,177,6,'0.18',0),
 (13991,4,42,177,5,'0.15',0),
 (13992,4,43,177,12,'0.35',0),
 (13993,4,44,177,0,'0.00',0),
 (13994,4,45,177,2,'0.06',0),
 (13995,4,46,177,8,'0.24',0),
 (13996,4,47,177,1,'0.03',0),
 (13997,4,48,177,0,'0.00',0),
 (13998,4,49,177,11,'0.32',0),
 (13999,4,50,177,3,'0.09',0),
 (14000,4,51,177,14,'0.41',0),
 (14001,4,1,178,243,'52.26',0),
 (14002,4,2,178,180,'38.71',0),
 (14003,4,14,178,0,'0.00',0),
 (14004,4,15,178,0,'0.00',0),
 (14005,4,16,178,0,'0.00',0),
 (14006,4,28,178,0,'0.00',0),
 (14007,4,32,178,0,'0.00',0),
 (14008,4,36,178,0,'0.00',0),
 (14009,4,38,178,31,'6.67',0),
 (14010,4,39,178,2,'0.43',0),
 (14011,4,40,178,0,'0.00',0),
 (14012,4,41,178,0,'0.00',0),
 (14013,4,42,178,0,'0.00',0),
 (14014,4,43,178,2,'0.43',0),
 (14015,4,44,178,0,'0.00',0),
 (14016,4,45,178,0,'0.00',0),
 (14017,4,46,178,0,'0.00',0),
 (14018,4,47,178,0,'0.00',0),
 (14019,4,48,178,0,'0.00',0),
 (14020,4,49,178,0,'0.00',0),
 (14021,4,50,178,0,'0.00',0),
 (14022,4,51,178,4,'0.86',0),
 (14023,4,1,179,406,'58.17',0),
 (14024,4,2,179,217,'31.09',0),
 (14025,4,14,179,0,'0.00',0),
 (14026,4,15,179,0,'0.00',0),
 (14027,4,16,179,1,'0.14',0),
 (14028,4,28,179,0,'0.00',0),
 (14029,4,32,179,0,'0.00',0),
 (14030,4,36,179,0,'0.00',0),
 (14031,4,38,179,51,'7.31',0),
 (14032,4,39,179,3,'0.43',0),
 (14033,4,40,179,0,'0.00',0),
 (14034,4,41,179,0,'0.00',0),
 (14035,4,42,179,0,'0.00',0),
 (14036,4,43,179,1,'0.14',0),
 (14037,4,44,179,1,'0.14',0),
 (14038,4,45,179,1,'0.14',0),
 (14039,4,46,179,0,'0.00',0),
 (14040,4,47,179,0,'0.00',0),
 (14041,4,48,179,0,'0.00',0),
 (14042,4,49,179,2,'0.29',0),
 (14043,4,50,179,0,'0.00',0),
 (14044,4,51,179,1,'0.14',0),
 (14045,4,1,180,1568,'49.39',0),
 (14046,4,2,180,1420,'44.72',0),
 (14047,4,14,180,0,'0.00',0),
 (14048,4,15,180,1,'0.03',0),
 (14049,4,16,180,1,'0.03',0),
 (14050,4,28,180,1,'0.03',0),
 (14051,4,32,180,0,'0.00',0),
 (14052,4,36,180,3,'0.09',0),
 (14053,4,38,180,128,'4.03',0),
 (14054,4,39,180,15,'0.47',0),
 (14055,4,40,180,1,'0.03',0),
 (14056,4,41,180,0,'0.00',0),
 (14057,4,42,180,0,'0.00',0),
 (14058,4,43,180,1,'0.03',0),
 (14059,4,44,180,0,'0.00',0),
 (14060,4,45,180,2,'0.06',0),
 (14061,4,46,180,0,'0.00',0),
 (14062,4,47,180,0,'0.00',0),
 (14063,4,48,180,0,'0.00',0),
 (14064,4,49,180,1,'0.03',0),
 (14065,4,50,180,0,'0.00',0),
 (14066,4,51,180,9,'0.28',0),
 (14067,4,1,181,7569,'61.49',0),
 (14068,4,2,181,3489,'28.35',0),
 (14069,4,14,181,3,'0.02',0),
 (14070,4,15,181,4,'0.03',0),
 (14071,4,16,181,15,'0.12',0),
 (14072,4,28,181,6,'0.05',0),
 (14073,4,32,181,3,'0.02',0),
 (14074,4,36,181,4,'0.03',0),
 (14075,4,38,181,750,'6.09',0),
 (14076,4,39,181,65,'0.53',0),
 (14077,4,40,181,4,'0.03',0),
 (14078,4,41,181,6,'0.05',0),
 (14079,4,42,181,5,'0.04',0),
 (14080,4,43,181,24,'0.19',0),
 (14081,4,44,181,11,'0.09',0),
 (14082,4,45,181,0,'0.00',0),
 (14083,4,46,181,3,'0.02',0),
 (14084,4,47,181,4,'0.03',0),
 (14085,4,48,181,0,'0.00',0),
 (14086,4,49,181,45,'0.37',0),
 (14087,4,50,181,1,'0.01',0),
 (14088,4,51,181,59,'0.48',0),
 (14089,4,1,182,54,'46.15',0),
 (14090,4,2,182,46,'39.32',0),
 (14091,4,14,182,0,'0.00',0),
 (14092,4,15,182,0,'0.00',0),
 (14093,4,16,182,1,'0.85',0),
 (14094,4,28,182,0,'0.00',0),
 (14095,4,32,182,0,'0.00',0),
 (14096,4,36,182,0,'0.00',0),
 (14097,4,38,182,13,'11.11',0),
 (14098,4,39,182,1,'0.85',0),
 (14099,4,40,182,0,'0.00',0),
 (14100,4,41,182,0,'0.00',0),
 (14101,4,42,182,0,'0.00',0),
 (14102,4,43,182,0,'0.00',0),
 (14103,4,44,182,0,'0.00',0),
 (14104,4,45,182,0,'0.00',0),
 (14105,4,46,182,0,'0.00',0),
 (14106,4,47,182,0,'0.00',0),
 (14107,4,48,182,0,'0.00',0),
 (14108,4,49,182,0,'0.00',0),
 (14109,4,50,182,0,'0.00',0),
 (14110,4,51,182,2,'1.71',0),
 (14111,4,1,183,282,'51.74',0),
 (14112,4,2,183,195,'35.78',0),
 (14113,4,14,183,0,'0.00',0),
 (14114,4,15,183,0,'0.00',0),
 (14115,4,16,183,0,'0.00',0),
 (14116,4,28,183,2,'0.37',0),
 (14117,4,32,183,1,'0.18',0),
 (14118,4,36,183,0,'0.00',0),
 (14119,4,38,183,53,'9.72',0),
 (14120,4,39,183,2,'0.37',0),
 (14121,4,40,183,0,'0.00',0),
 (14122,4,41,183,0,'0.00',0),
 (14123,4,42,183,1,'0.18',0),
 (14124,4,43,183,1,'0.18',0),
 (14125,4,44,183,0,'0.00',0),
 (14126,4,45,183,0,'0.00',0),
 (14127,4,46,183,0,'0.00',0),
 (14128,4,47,183,2,'0.37',0),
 (14129,4,48,183,0,'0.00',0),
 (14130,4,49,183,1,'0.18',0),
 (14131,4,50,183,0,'0.00',0),
 (14132,4,51,183,1,'0.18',0),
 (14133,4,1,901,241,'57.11',0),
 (14134,4,2,901,148,'35.07',0),
 (14135,4,14,901,0,'0.00',0),
 (14136,4,15,901,1,'0.24',0),
 (14137,4,16,901,2,'0.47',0),
 (14138,4,28,901,1,'0.24',0),
 (14139,4,32,901,0,'0.00',0),
 (14140,4,36,901,1,'0.24',0),
 (14141,4,38,901,18,'4.27',0),
 (14142,4,39,901,3,'0.71',0),
 (14143,4,40,901,0,'0.00',0),
 (14144,4,41,901,0,'0.00',0),
 (14145,4,42,901,0,'0.00',0),
 (14146,4,43,901,3,'0.71',0),
 (14147,4,44,901,1,'0.24',0),
 (14148,4,45,901,0,'0.00',0),
 (14149,4,46,901,0,'0.00',0),
 (14150,4,47,901,0,'0.00',0),
 (14151,4,48,901,0,'0.00',0),
 (14152,4,49,901,0,'0.00',0),
 (14153,4,50,901,0,'0.00',0),
 (14154,4,51,901,1,'0.24',0),
 (14155,4,1,902,162,'66.67',0),
 (14156,4,2,902,47,'19.34',0),
 (14157,4,14,902,1,'0.41',0),
 (14158,4,15,902,0,'0.00',0),
 (14159,4,16,902,0,'0.00',0),
 (14160,4,28,902,0,'0.00',0),
 (14161,4,32,902,0,'0.00',0),
 (14162,4,36,902,0,'0.00',0),
 (14163,4,38,902,26,'10.70',0),
 (14164,4,39,902,0,'0.00',0),
 (14165,4,40,902,0,'0.00',0),
 (14166,4,41,902,0,'0.00',0),
 (14167,4,42,902,0,'0.00',0),
 (14168,4,43,902,0,'0.00',0),
 (14169,4,44,902,1,'0.41',0),
 (14170,4,45,902,0,'0.00',0),
 (14171,4,46,902,0,'0.00',0),
 (14172,4,47,902,1,'0.41',0),
 (14173,4,48,902,0,'0.00',0),
 (14174,4,49,902,0,'0.00',0),
 (14175,4,50,902,0,'0.00',0),
 (14176,4,51,902,0,'0.00',0),
 (14177,4,1,903,9103,'48.53',0),
 (14178,4,2,903,6570,'35.03',0),
 (14179,4,14,903,8,'0.04',0),
 (14180,4,15,903,8,'0.04',0),
 (14181,4,16,903,14,'0.07',0),
 (14182,4,28,903,6,'0.03',0),
 (14183,4,32,903,2,'0.01',0),
 (14184,4,36,903,14,'0.07',0),
 (14185,4,38,903,2072,'11.05',0),
 (14186,4,39,903,120,'0.64',0),
 (14187,4,40,903,8,'0.04',0),
 (14188,4,41,903,15,'0.08',0),
 (14189,4,42,903,9,'0.05',0),
 (14190,4,43,903,67,'0.36',0),
 (14191,4,44,903,9,'0.05',0),
 (14192,4,45,903,4,'0.02',0),
 (14193,4,46,903,18,'0.10',0),
 (14194,4,47,903,10,'0.05',0),
 (14195,4,48,903,0,'0.00',0),
 (14196,4,49,903,84,'0.45',0),
 (14197,4,50,903,2,'0.01',0),
 (14198,4,51,903,104,'0.55',0),
 (14199,4,1,999,11156,'49.62',0),
 (14200,4,2,999,7509,'33.40',0),
 (14201,4,14,999,137,'0.61',0),
 (14202,4,15,999,85,'0.38',0),
 (14203,4,16,999,43,'0.19',0),
 (14204,4,28,999,103,'0.46',0),
 (14205,4,32,999,37,'0.16',0),
 (14206,4,36,999,118,'0.52',0),
 (14207,4,38,999,1521,'6.77',0),
 (14208,4,39,999,449,'2.00',0),
 (14209,4,40,999,28,'0.12',0),
 (14210,4,41,999,108,'0.48',0),
 (14211,4,42,999,115,'0.51',0),
 (14212,4,43,999,93,'0.41',0),
 (14213,4,44,999,28,'0.12',0),
 (14214,4,45,999,96,'0.43',0),
 (14215,4,46,999,176,'0.78',0),
 (14216,4,47,999,59,'0.26',0),
 (14217,4,48,999,0,'0.00',0),
 (14218,4,49,999,25,'0.11',0),
 (14219,4,50,999,28,'0.12',0),
 (14220,4,51,999,310,'1.38',0),
 (14356,5,1,1,44,'91.67',0),
 (14357,5,2,1,2,'4.17',0),
 (14358,5,14,1,0,'0.00',0),
 (14359,5,15,1,0,'0.00',0),
 (14360,5,28,1,0,'0.00',0),
 (14361,5,32,1,0,'0.00',0),
 (14362,5,36,1,0,'0.00',0),
 (14363,5,38,1,1,'2.08',0),
 (14364,5,39,1,0,'0.00',0),
 (14365,5,40,1,0,'0.00',0),
 (14366,5,41,1,0,'0.00',0),
 (14367,5,42,1,0,'0.00',0),
 (14368,5,45,1,0,'0.00',0),
 (14369,5,46,1,0,'0.00',0),
 (14370,5,47,1,0,'0.00',0),
 (14371,5,48,1,0,'0.00',0),
 (14372,5,51,1,0,'0.00',0),
 (14373,5,52,1,0,'0.00',0),
 (14374,5,53,1,0,'0.00',0),
 (14375,5,54,1,0,'0.00',0),
 (14376,5,1,2,785,'50.13',0),
 (14377,5,2,2,619,'39.53',0),
 (14378,5,14,2,0,'0.00',0),
 (14379,5,15,2,0,'0.00',0),
 (14380,5,28,2,1,'0.06',0),
 (14381,5,32,2,0,'0.00',0),
 (14382,5,36,2,12,'0.77',0),
 (14383,5,38,2,94,'6.00',0),
 (14384,5,39,2,8,'0.51',0),
 (14385,5,40,2,0,'0.00',0),
 (14386,5,41,2,1,'0.06',0),
 (14387,5,42,2,0,'0.00',0),
 (14388,5,45,2,0,'0.00',0),
 (14389,5,46,2,0,'0.00',0),
 (14390,5,47,2,1,'0.06',0),
 (14391,5,48,2,0,'0.00',0),
 (14392,5,51,2,15,'0.96',0),
 (14393,5,52,2,0,'0.00',0),
 (14394,5,53,2,2,'0.13',0),
 (14395,5,54,2,1,'0.06',0),
 (14396,5,1,3,76,'53.52',0),
 (14397,5,2,3,53,'37.32',0),
 (14398,5,14,3,0,'0.00',0),
 (14399,5,15,3,0,'0.00',0),
 (14400,5,28,3,0,'0.00',0),
 (14401,5,32,3,0,'0.00',0),
 (14402,5,36,3,0,'0.00',0),
 (14403,5,38,3,5,'3.52',0),
 (14404,5,39,3,0,'0.00',0),
 (14405,5,40,3,0,'0.00',0),
 (14406,5,41,3,1,'0.70',0),
 (14407,5,42,3,1,'0.70',0),
 (14408,5,45,3,0,'0.00',0),
 (14409,5,46,3,0,'0.00',0),
 (14410,5,47,3,0,'0.00',0),
 (14411,5,48,3,0,'0.00',0),
 (14412,5,51,3,0,'0.00',0),
 (14413,5,52,3,0,'0.00',0),
 (14414,5,53,3,0,'0.00',0),
 (14415,5,54,3,0,'0.00',0),
 (14416,5,1,4,1874,'53.80',0),
 (14417,5,2,4,1418,'40.71',0),
 (14418,5,14,4,0,'0.00',0),
 (14419,5,15,4,3,'0.09',0),
 (14420,5,28,4,4,'0.11',0),
 (14421,5,32,4,2,'0.06',0),
 (14422,5,36,4,0,'0.00',0),
 (14423,5,38,4,89,'2.56',0),
 (14424,5,39,4,18,'0.52',0),
 (14425,5,40,4,0,'0.00',0),
 (14426,5,41,4,1,'0.03',0),
 (14427,5,42,4,1,'0.03',0),
 (14428,5,45,4,3,'0.09',0),
 (14429,5,46,4,0,'0.00',0),
 (14430,5,47,4,1,'0.03',0),
 (14431,5,48,4,1,'0.03',0),
 (14432,5,51,4,24,'0.69',0),
 (14433,5,52,4,2,'0.06',0),
 (14434,5,53,4,3,'0.09',0),
 (14435,5,54,4,1,'0.03',0),
 (14436,5,1,5,39260,'43.77',0),
 (14437,5,2,5,35542,'39.63',0),
 (14438,5,14,5,124,'0.14',0),
 (14439,5,15,5,106,'0.12',0),
 (14440,5,28,5,153,'0.17',0),
 (14441,5,32,5,26,'0.03',0),
 (14442,5,36,5,786,'0.88',0),
 (14443,5,38,5,8226,'9.17',0),
 (14444,5,39,5,1395,'1.56',0),
 (14445,5,40,5,98,'0.11',0),
 (14446,5,41,5,88,'0.10',0),
 (14447,5,42,5,51,'0.06',0),
 (14448,5,45,5,61,'0.07',0),
 (14449,5,46,5,75,'0.08',0),
 (14450,5,47,5,29,'0.03',0),
 (14451,5,48,5,63,'0.07',0),
 (14452,5,51,5,1307,'1.46',0),
 (14453,5,52,5,24,'0.03',0),
 (14454,5,53,5,114,'0.13',0),
 (14455,5,54,5,70,'0.08',0),
 (14456,5,1,6,23667,'47.46',0),
 (14457,5,2,6,20103,'40.31',0),
 (14458,5,14,6,77,'0.15',0),
 (14459,5,15,6,56,'0.11',0),
 (14460,5,28,6,81,'0.16',0),
 (14461,5,32,6,6,'0.01',0),
 (14462,5,36,6,55,'0.11',0),
 (14463,5,38,6,2816,'5.65',0),
 (14464,5,39,6,790,'1.58',0),
 (14465,5,40,6,29,'0.06',0),
 (14466,5,41,6,37,'0.07',0),
 (14467,5,42,6,28,'0.06',0),
 (14468,5,45,6,29,'0.06',0),
 (14469,5,46,6,63,'0.13',0),
 (14470,5,47,6,31,'0.06',0),
 (14471,5,48,6,196,'0.39',0),
 (14472,5,51,6,664,'1.33',0),
 (14473,5,52,6,31,'0.06',0),
 (14474,5,53,6,72,'0.14',0),
 (14475,5,54,6,57,'0.11',0),
 (14476,5,1,7,37124,'41.86',0),
 (14477,5,2,7,39915,'45.01',0),
 (14478,5,14,7,75,'0.08',0),
 (14479,5,15,7,136,'0.15',0),
 (14480,5,28,7,105,'0.12',0),
 (14481,5,32,7,26,'0.03',0),
 (14482,5,36,7,76,'0.09',0),
 (14483,5,38,7,6594,'7.44',0),
 (14484,5,39,7,942,'1.06',0),
 (14485,5,40,7,47,'0.05',0),
 (14486,5,41,7,68,'0.08',0),
 (14487,5,42,7,44,'0.05',0),
 (14488,5,45,7,39,'0.04',0),
 (14489,5,46,7,78,'0.09',0),
 (14490,5,47,7,47,'0.05',0),
 (14491,5,48,7,45,'0.05',0),
 (14492,5,51,7,856,'0.97',0),
 (14493,5,52,7,88,'0.10',0),
 (14494,5,53,7,651,'0.73',0),
 (14495,5,54,7,62,'0.07',0),
 (14496,5,1,8,524,'47.04',0),
 (14497,5,2,8,487,'43.72',0),
 (14498,5,14,8,1,'0.09',0),
 (14499,5,15,8,1,'0.09',0),
 (14500,5,28,8,3,'0.27',0),
 (14501,5,32,8,0,'0.00',0),
 (14502,5,36,8,0,'0.00',0),
 (14503,5,38,8,28,'2.51',0),
 (14504,5,39,8,4,'0.36',0),
 (14505,5,40,8,0,'0.00',0),
 (14506,5,41,8,0,'0.00',0),
 (14507,5,42,8,0,'0.00',0),
 (14508,5,45,8,21,'1.89',0),
 (14509,5,46,8,0,'0.00',0),
 (14510,5,47,8,1,'0.09',0),
 (14511,5,48,8,0,'0.00',0),
 (14512,5,51,8,3,'0.27',0),
 (14513,5,52,8,11,'0.99',0),
 (14514,5,53,8,13,'1.17',0),
 (14515,5,54,8,1,'0.09',0),
 (14516,5,1,9,4152,'49.45',0),
 (14517,5,2,9,3281,'39.08',0),
 (14518,5,14,9,6,'0.07',0),
 (14519,5,15,9,4,'0.05',0),
 (14520,5,28,9,15,'0.18',0),
 (14521,5,32,9,3,'0.04',0),
 (14522,5,36,9,8,'0.10',0),
 (14523,5,38,9,390,'4.65',0),
 (14524,5,39,9,117,'1.39',0),
 (14525,5,40,9,4,'0.05',0),
 (14526,5,41,9,8,'0.10',0),
 (14527,5,42,9,5,'0.06',0),
 (14528,5,45,9,90,'1.07',0),
 (14529,5,46,9,13,'0.15',0),
 (14530,5,47,9,1,'0.01',0),
 (14531,5,48,9,42,'0.50',0),
 (14532,5,51,9,97,'1.16',0),
 (14533,5,52,9,2,'0.02',0),
 (14534,5,53,9,10,'0.12',0),
 (14535,5,54,9,5,'0.06',0),
 (14536,5,1,10,2555,'50.58',0),
 (14537,5,2,10,1779,'35.22',0),
 (14538,5,14,10,2,'0.04',0),
 (14539,5,15,10,1,'0.02',0),
 (14540,5,28,10,1,'0.02',0),
 (14541,5,32,10,2,'0.04',0),
 (14542,5,36,10,7,'0.14',0),
 (14543,5,38,10,385,'7.62',0),
 (14544,5,39,10,47,'0.93',0),
 (14545,5,40,10,4,'0.08',0),
 (14546,5,41,10,7,'0.14',0),
 (14547,5,42,10,6,'0.12',0),
 (14548,5,45,10,0,'0.00',0),
 (14549,5,46,10,11,'0.22',0),
 (14550,5,47,10,2,'0.04',0),
 (14551,5,48,10,17,'0.34',0),
 (14552,5,51,10,93,'1.84',0),
 (14553,5,52,10,1,'0.02',0),
 (14554,5,53,10,6,'0.12',0),
 (14555,5,54,10,4,'0.08',0),
 (14556,5,1,11,141,'59.24',0),
 (14557,5,2,11,39,'16.39',0),
 (14558,5,14,11,0,'0.00',0),
 (14559,5,15,11,0,'0.00',0),
 (14560,5,28,11,0,'0.00',0),
 (14561,5,32,11,0,'0.00',0),
 (14562,5,36,11,0,'0.00',0),
 (14563,5,38,11,53,'22.27',0),
 (14564,5,39,11,0,'0.00',0),
 (14565,5,40,11,0,'0.00',0),
 (14566,5,41,11,0,'0.00',0),
 (14567,5,42,11,0,'0.00',0),
 (14568,5,45,11,0,'0.00',0),
 (14569,5,46,11,0,'0.00',0),
 (14570,5,47,11,0,'0.00',0),
 (14571,5,48,11,0,'0.00',0),
 (14572,5,51,11,2,'0.84',0),
 (14573,5,52,11,0,'0.00',0),
 (14574,5,53,11,0,'0.00',0),
 (14575,5,54,11,1,'0.42',0),
 (14576,5,1,12,233,'50.22',0),
 (14577,5,2,12,200,'43.10',0),
 (14578,5,14,12,0,'0.00',0),
 (14579,5,15,12,0,'0.00',0),
 (14580,5,28,12,1,'0.22',0),
 (14581,5,32,12,0,'0.00',0),
 (14582,5,36,12,4,'0.86',0),
 (14583,5,38,12,11,'2.37',0),
 (14584,5,39,12,7,'1.51',0),
 (14585,5,40,12,0,'0.00',0),
 (14586,5,41,12,0,'0.00',0),
 (14587,5,42,12,0,'0.00',0),
 (14588,5,45,12,0,'0.00',0),
 (14589,5,46,12,2,'0.43',0),
 (14590,5,47,12,0,'0.00',0),
 (14591,5,48,12,0,'0.00',0),
 (14592,5,51,12,1,'0.22',0),
 (14593,5,52,12,0,'0.00',0),
 (14594,5,53,12,1,'0.22',0),
 (14595,5,54,12,0,'0.00',0),
 (14596,5,1,13,10518,'43.69',0),
 (14597,5,2,13,10995,'45.68',0),
 (14598,5,14,13,8,'0.03',0),
 (14599,5,15,13,15,'0.06',0),
 (14600,5,28,13,42,'0.17',0),
 (14601,5,32,13,11,'0.05',0),
 (14602,5,36,13,18,'0.07',0),
 (14603,5,38,13,1567,'6.51',0),
 (14604,5,39,13,187,'0.78',0),
 (14605,5,40,13,7,'0.03',0),
 (14606,5,41,13,22,'0.09',0),
 (14607,5,42,13,11,'0.05',0),
 (14608,5,45,13,13,'0.05',0),
 (14609,5,46,13,17,'0.07',0),
 (14610,5,47,13,6,'0.02',0),
 (14611,5,48,13,12,'0.05',0),
 (14612,5,51,13,183,'0.76',0),
 (14613,5,52,13,5,'0.02',0),
 (14614,5,53,13,39,'0.16',0),
 (14615,5,54,13,15,'0.06',0),
 (14616,5,1,14,8816,'51.05',0),
 (14617,5,2,14,6584,'38.12',0),
 (14618,5,14,14,12,'0.07',0),
 (14619,5,15,14,11,'0.06',0),
 (14620,5,28,14,20,'0.12',0),
 (14621,5,32,14,2,'0.01',0),
 (14622,5,36,14,7,'0.04',0),
 (14623,5,38,14,1306,'7.56',0),
 (14624,5,39,14,106,'0.61',0),
 (14625,5,40,14,4,'0.02',0),
 (14626,5,41,14,5,'0.03',0),
 (14627,5,42,14,4,'0.02',0),
 (14628,5,45,14,11,'0.06',0),
 (14629,5,46,14,13,'0.08',0),
 (14630,5,47,14,5,'0.03',0),
 (14631,5,48,14,3,'0.02',0),
 (14632,5,51,14,106,'0.61',0),
 (14633,5,52,14,0,'0.00',0),
 (14634,5,53,14,5,'0.03',0),
 (14635,5,54,14,14,'0.08',0),
 (14636,5,1,15,1068,'47.61',0),
 (14637,5,2,15,836,'37.27',0),
 (14638,5,14,15,1,'0.04',0),
 (14639,5,15,15,1,'0.04',0),
 (14640,5,28,15,1,'0.04',0),
 (14641,5,32,15,2,'0.09',0),
 (14642,5,36,15,0,'0.00',0),
 (14643,5,38,15,165,'7.36',0),
 (14644,5,39,15,33,'1.47',0),
 (14645,5,40,15,2,'0.09',0),
 (14646,5,41,15,6,'0.27',0),
 (14647,5,42,15,1,'0.04',0),
 (14648,5,45,15,1,'0.04',0),
 (14649,5,46,15,0,'0.00',0),
 (14650,5,47,15,2,'0.09',0),
 (14651,5,48,15,26,'1.16',0),
 (14652,5,51,15,43,'1.92',0),
 (14653,5,52,15,0,'0.00',0),
 (14654,5,53,15,15,'0.67',0),
 (14655,5,54,15,0,'0.00',0),
 (14656,5,1,16,41,'47.67',0),
 (14657,5,2,16,30,'34.88',0),
 (14658,5,14,16,0,'0.00',0),
 (14659,5,15,16,0,'0.00',0),
 (14660,5,28,16,0,'0.00',0),
 (14661,5,32,16,0,'0.00',0),
 (14662,5,36,16,0,'0.00',0),
 (14663,5,38,16,10,'11.63',0),
 (14664,5,39,16,1,'1.16',0),
 (14665,5,40,16,0,'0.00',0),
 (14666,5,41,16,0,'0.00',0),
 (14667,5,42,16,0,'0.00',0),
 (14668,5,45,16,0,'0.00',0),
 (14669,5,46,16,0,'0.00',0),
 (14670,5,47,16,0,'0.00',0),
 (14671,5,48,16,0,'0.00',0),
 (14672,5,51,16,4,'4.65',0),
 (14673,5,52,16,0,'0.00',0),
 (14674,5,53,16,0,'0.00',0),
 (14675,5,54,16,0,'0.00',0),
 (14676,5,1,17,346,'48.12',0),
 (14677,5,2,17,252,'35.05',0),
 (14678,5,14,17,0,'0.00',0),
 (14679,5,15,17,0,'0.00',0),
 (14680,5,28,17,0,'0.00',0),
 (14681,5,32,17,0,'0.00',0),
 (14682,5,36,17,0,'0.00',0),
 (14683,5,38,17,72,'10.01',0),
 (14684,5,39,17,11,'1.53',0),
 (14685,5,40,17,1,'0.14',0),
 (14686,5,41,17,1,'0.14',0),
 (14687,5,42,17,1,'0.14',0),
 (14688,5,45,17,0,'0.00',0),
 (14689,5,46,17,0,'0.00',0),
 (14690,5,47,17,3,'0.42',0),
 (14691,5,48,17,0,'0.00',0),
 (14692,5,51,17,15,'2.09',0),
 (14693,5,52,17,0,'0.00',0),
 (14694,5,53,17,1,'0.14',0),
 (14695,5,54,17,0,'0.00',0),
 (14696,5,1,18,1215,'53.64',0),
 (14697,5,2,18,835,'36.87',0),
 (14698,5,14,18,0,'0.00',0),
 (14699,5,15,18,1,'0.04',0),
 (14700,5,28,18,2,'0.09',0),
 (14701,5,32,18,1,'0.04',0),
 (14702,5,36,18,0,'0.00',0),
 (14703,5,38,18,119,'5.25',0),
 (14704,5,39,18,18,'0.79',0),
 (14705,5,40,18,0,'0.00',0),
 (14706,5,41,18,0,'0.00',0),
 (14707,5,42,18,0,'0.00',0),
 (14708,5,45,18,2,'0.09',0),
 (14709,5,46,18,6,'0.26',0),
 (14710,5,47,18,1,'0.04',0),
 (14711,5,48,18,2,'0.09',0),
 (14712,5,51,18,20,'0.88',0),
 (14713,5,52,18,0,'0.00',0),
 (14714,5,53,18,3,'0.13',0),
 (14715,5,54,18,0,'0.00',0),
 (14716,5,1,19,325,'41.99',0),
 (14717,5,2,19,399,'51.55',0),
 (14718,5,14,19,0,'0.00',0),
 (14719,5,15,19,1,'0.13',0),
 (14720,5,28,19,3,'0.39',0),
 (14721,5,32,19,0,'0.00',0),
 (14722,5,36,19,0,'0.00',0),
 (14723,5,38,19,24,'3.10',0),
 (14724,5,39,19,6,'0.78',0),
 (14725,5,40,19,0,'0.00',0),
 (14726,5,41,19,0,'0.00',0),
 (14727,5,42,19,0,'0.00',0),
 (14728,5,45,19,0,'0.00',0),
 (14729,5,46,19,2,'0.26',0),
 (14730,5,47,19,0,'0.00',0),
 (14731,5,48,19,0,'0.00',0),
 (14732,5,51,19,5,'0.65',0),
 (14733,5,52,19,0,'0.00',0),
 (14734,5,53,19,1,'0.13',0),
 (14735,5,54,19,0,'0.00',0),
 (14736,5,1,20,40,'35.40',0),
 (14737,5,2,20,37,'32.74',0),
 (14738,5,14,20,0,'0.00',0),
 (14739,5,15,20,0,'0.00',0),
 (14740,5,28,20,0,'0.00',0),
 (14741,5,32,20,0,'0.00',0),
 (14742,5,36,20,0,'0.00',0),
 (14743,5,38,20,24,'21.24',0),
 (14744,5,39,20,8,'7.08',0),
 (14745,5,40,20,0,'0.00',0),
 (14746,5,41,20,0,'0.00',0),
 (14747,5,42,20,0,'0.00',0),
 (14748,5,45,20,1,'0.88',0),
 (14749,5,46,20,0,'0.00',0),
 (14750,5,47,20,0,'0.00',0),
 (14751,5,48,20,0,'0.00',0),
 (14752,5,51,20,3,'2.65',0),
 (14753,5,52,20,0,'0.00',0),
 (14754,5,53,20,0,'0.00',0),
 (14755,5,54,20,0,'0.00',0),
 (14756,5,1,21,181,'61.36',0),
 (14757,5,2,21,94,'31.86',0),
 (14758,5,14,21,0,'0.00',0),
 (14759,5,15,21,1,'0.34',0),
 (14760,5,28,21,0,'0.00',0),
 (14761,5,32,21,0,'0.00',0),
 (14762,5,36,21,0,'0.00',0),
 (14763,5,38,21,9,'3.05',0),
 (14764,5,39,21,1,'0.34',0),
 (14765,5,40,21,1,'0.34',0),
 (14766,5,41,21,1,'0.34',0),
 (14767,5,42,21,0,'0.00',0),
 (14768,5,45,21,0,'0.00',0),
 (14769,5,46,21,0,'0.00',0),
 (14770,5,47,21,0,'0.00',0),
 (14771,5,48,21,0,'0.00',0),
 (14772,5,51,21,4,'1.36',0),
 (14773,5,52,21,0,'0.00',0),
 (14774,5,53,21,0,'0.00',0),
 (14775,5,54,21,0,'0.00',0),
 (14776,5,1,22,10457,'63.07',0),
 (14777,5,2,22,4466,'26.93',0),
 (14778,5,14,22,7,'0.04',0),
 (14779,5,15,22,7,'0.04',0),
 (14780,5,28,22,36,'0.22',0),
 (14781,5,32,22,0,'0.00',0),
 (14782,5,36,22,6,'0.04',0),
 (14783,5,38,22,680,'4.10',0),
 (14784,5,39,22,180,'1.09',0),
 (14785,5,40,22,8,'0.05',0),
 (14786,5,41,22,15,'0.09',0),
 (14787,5,42,22,10,'0.06',0),
 (14788,5,45,22,16,'0.10',0),
 (14789,5,46,22,31,'0.19',0),
 (14790,5,47,22,12,'0.07',0),
 (14791,5,48,22,14,'0.08',0),
 (14792,5,51,22,160,'0.96',0),
 (14793,5,52,22,1,'0.01',0),
 (14794,5,53,22,85,'0.51',0),
 (14795,5,54,22,11,'0.07',0),
 (14796,5,1,23,994,'54.20',0),
 (14797,5,2,23,625,'34.08',0),
 (14798,5,14,23,1,'0.05',0),
 (14799,5,15,23,1,'0.05',0),
 (14800,5,28,23,1,'0.05',0),
 (14801,5,32,23,0,'0.00',0),
 (14802,5,36,23,0,'0.00',0),
 (14803,5,38,23,99,'5.40',0),
 (14804,5,39,23,31,'1.69',0),
 (14805,5,40,23,3,'0.16',0),
 (14806,5,41,23,4,'0.22',0),
 (14807,5,42,23,0,'0.00',0),
 (14808,5,45,23,0,'0.00',0),
 (14809,5,46,23,1,'0.05',0),
 (14810,5,47,23,1,'0.05',0),
 (14811,5,48,23,14,'0.76',0),
 (14812,5,51,23,27,'1.47',0),
 (14813,5,52,23,0,'0.00',0),
 (14814,5,53,23,7,'0.38',0),
 (14815,5,54,23,4,'0.22',0),
 (14816,5,1,24,65,'60.75',0),
 (14817,5,2,24,29,'27.10',0),
 (14818,5,14,24,0,'0.00',0),
 (14819,5,15,24,0,'0.00',0),
 (14820,5,28,24,0,'0.00',0),
 (14821,5,32,24,0,'0.00',0),
 (14822,5,36,24,0,'0.00',0),
 (14823,5,38,24,3,'2.80',0),
 (14824,5,39,24,0,'0.00',0),
 (14825,5,40,24,0,'0.00',0),
 (14826,5,41,24,0,'0.00',0),
 (14827,5,42,24,0,'0.00',0),
 (14828,5,45,24,1,'0.93',0),
 (14829,5,46,24,0,'0.00',0),
 (14830,5,47,24,0,'0.00',0),
 (14831,5,48,24,0,'0.00',0),
 (14832,5,51,24,0,'0.00',0),
 (14833,5,52,24,0,'0.00',0),
 (14834,5,53,24,1,'0.93',0),
 (14835,5,54,24,2,'1.87',0),
 (14836,5,1,25,239,'66.57',0),
 (14837,5,2,25,107,'29.81',0),
 (14838,5,14,25,1,'0.28',0),
 (14839,5,15,25,0,'0.00',0),
 (14840,5,28,25,1,'0.28',0),
 (14841,5,32,25,0,'0.00',0),
 (14842,5,36,25,0,'0.00',0),
 (14843,5,38,25,8,'2.23',0),
 (14844,5,39,25,0,'0.00',0),
 (14845,5,40,25,0,'0.00',0),
 (14846,5,41,25,0,'0.00',0),
 (14847,5,42,25,0,'0.00',0),
 (14848,5,45,25,0,'0.00',0),
 (14849,5,46,25,0,'0.00',0),
 (14850,5,47,25,0,'0.00',0),
 (14851,5,48,25,0,'0.00',0),
 (14852,5,51,25,1,'0.28',0),
 (14853,5,52,25,0,'0.00',0),
 (14854,5,53,25,0,'0.00',0),
 (14855,5,54,25,0,'0.00',0),
 (14856,5,1,26,1990,'57.78',0),
 (14857,5,2,26,1062,'30.84',0),
 (14858,5,14,26,2,'0.06',0),
 (14859,5,15,26,0,'0.00',0),
 (14860,5,28,26,11,'0.32',0),
 (14861,5,32,26,0,'0.00',0),
 (14862,5,36,26,0,'0.00',0),
 (14863,5,38,26,218,'6.33',0),
 (14864,5,39,26,41,'1.19',0),
 (14865,5,40,26,0,'0.00',0),
 (14866,5,41,26,1,'0.03',0),
 (14867,5,42,26,2,'0.06',0),
 (14868,5,45,26,3,'0.09',0),
 (14869,5,46,26,2,'0.06',0),
 (14870,5,47,26,1,'0.03',0),
 (14871,5,48,26,0,'0.00',0),
 (14872,5,51,26,36,'1.05',0),
 (14873,5,52,26,0,'0.00',0),
 (14874,5,53,26,11,'0.32',0),
 (14875,5,54,26,6,'0.17',0),
 (14876,5,1,27,488,'55.39',0),
 (14877,5,2,27,314,'35.64',0),
 (14878,5,14,27,0,'0.00',0),
 (14879,5,15,27,0,'0.00',0),
 (14880,5,28,27,1,'0.11',0),
 (14881,5,32,27,0,'0.00',0),
 (14882,5,36,27,0,'0.00',0),
 (14883,5,38,27,49,'5.56',0),
 (14884,5,39,27,5,'0.57',0),
 (14885,5,40,27,0,'0.00',0),
 (14886,5,41,27,0,'0.00',0),
 (14887,5,42,27,0,'0.00',0),
 (14888,5,45,27,0,'0.00',0),
 (14889,5,46,27,1,'0.11',0),
 (14890,5,47,27,0,'0.00',0),
 (14891,5,48,27,0,'0.00',0),
 (14892,5,51,27,6,'0.68',0),
 (14893,5,52,27,0,'0.00',0),
 (14894,5,53,27,1,'0.11',0),
 (14895,5,54,27,1,'0.11',0),
 (14896,5,1,28,478,'47.47',0),
 (14897,5,2,28,353,'35.05',0),
 (14898,5,14,28,0,'0.00',0),
 (14899,5,15,28,0,'0.00',0),
 (14900,5,28,28,5,'0.50',0),
 (14901,5,32,28,0,'0.00',0),
 (14902,5,36,28,0,'0.00',0),
 (14903,5,38,28,123,'12.21',0),
 (14904,5,39,28,4,'0.40',0),
 (14905,5,40,28,0,'0.00',0),
 (14906,5,41,28,0,'0.00',0),
 (14907,5,42,28,0,'0.00',0),
 (14908,5,45,28,0,'0.00',0),
 (14909,5,46,28,2,'0.20',0),
 (14910,5,47,28,0,'0.00',0),
 (14911,5,48,28,0,'0.00',0),
 (14912,5,51,28,13,'1.29',0),
 (14913,5,52,28,0,'0.00',0),
 (14914,5,53,28,1,'0.10',0),
 (14915,5,54,28,3,'0.30',0),
 (14916,5,1,29,211,'53.69',0),
 (14917,5,2,29,150,'38.17',0),
 (14918,5,14,29,0,'0.00',0),
 (14919,5,15,29,0,'0.00',0),
 (14920,5,28,29,0,'0.00',0),
 (14921,5,32,29,0,'0.00',0),
 (14922,5,36,29,0,'0.00',0),
 (14923,5,38,29,17,'4.33',0),
 (14924,5,39,29,5,'1.27',0),
 (14925,5,40,29,1,'0.25',0),
 (14926,5,41,29,0,'0.00',0),
 (14927,5,42,29,1,'0.25',0),
 (14928,5,45,29,0,'0.00',0),
 (14929,5,46,29,0,'0.00',0),
 (14930,5,47,29,0,'0.00',0),
 (14931,5,48,29,0,'0.00',0),
 (14932,5,51,29,2,'0.51',0),
 (14933,5,52,29,0,'0.00',0),
 (14934,5,53,29,0,'0.00',0),
 (14935,5,54,29,0,'0.00',0),
 (14936,5,1,30,586,'50.30',0),
 (14937,5,2,30,462,'39.66',0),
 (14938,5,14,30,1,'0.09',0),
 (14939,5,15,30,0,'0.00',0),
 (14940,5,28,30,0,'0.00',0),
 (14941,5,32,30,0,'0.00',0),
 (14942,5,36,30,1,'0.09',0),
 (14943,5,38,30,54,'4.64',0),
 (14944,5,39,30,13,'1.12',0),
 (14945,5,40,30,2,'0.17',0),
 (14946,5,41,30,1,'0.09',0),
 (14947,5,42,30,1,'0.09',0),
 (14948,5,45,30,1,'0.09',0),
 (14949,5,46,30,0,'0.00',0),
 (14950,5,47,30,0,'0.00',0),
 (14951,5,48,30,20,'1.72',0),
 (14952,5,51,30,8,'0.69',0),
 (14953,5,52,30,0,'0.00',0),
 (14954,5,53,30,0,'0.00',0),
 (14955,5,54,30,2,'0.17',0),
 (14956,5,1,31,853,'54.26',0),
 (14957,5,2,31,645,'41.03',0),
 (14958,5,14,31,0,'0.00',0),
 (14959,5,15,31,0,'0.00',0),
 (14960,5,28,31,1,'0.06',0),
 (14961,5,32,31,0,'0.00',0),
 (14962,5,36,31,0,'0.00',0),
 (14963,5,38,31,48,'3.05',0),
 (14964,5,39,31,3,'0.19',0),
 (14965,5,40,31,1,'0.06',0),
 (14966,5,41,31,0,'0.00',0),
 (14967,5,42,31,0,'0.00',0),
 (14968,5,45,31,0,'0.00',0),
 (14969,5,46,31,1,'0.06',0),
 (14970,5,47,31,1,'0.06',0),
 (14971,5,48,31,0,'0.00',0),
 (14972,5,51,31,5,'0.32',0),
 (14973,5,52,31,0,'0.00',0),
 (14974,5,53,31,1,'0.06',0),
 (14975,5,54,31,2,'0.13',0),
 (14976,5,1,32,759,'41.25',0),
 (14977,5,2,32,817,'44.40',0),
 (14978,5,14,32,3,'0.16',0),
 (14979,5,15,32,3,'0.16',0),
 (14980,5,28,32,0,'0.00',0),
 (14981,5,32,32,0,'0.00',0),
 (14982,5,36,32,4,'0.22',0),
 (14983,5,38,32,172,'9.35',0),
 (14984,5,39,32,17,'0.92',0),
 (14985,5,40,32,2,'0.11',0),
 (14986,5,41,32,1,'0.05',0),
 (14987,5,42,32,1,'0.05',0),
 (14988,5,45,32,0,'0.00',0),
 (14989,5,46,32,1,'0.05',0),
 (14990,5,47,32,1,'0.05',0),
 (14991,5,48,32,1,'0.05',0),
 (14992,5,51,32,21,'1.14',0),
 (14993,5,52,32,0,'0.00',0),
 (14994,5,53,32,5,'0.27',0),
 (14995,5,54,32,0,'0.00',0),
 (14996,5,1,33,1135,'60.21',0),
 (14997,5,2,33,632,'33.53',0),
 (14998,5,14,33,0,'0.00',0),
 (14999,5,15,33,3,'0.16',0),
 (15000,5,28,33,8,'0.42',0),
 (15001,5,32,33,1,'0.05',0),
 (15002,5,36,33,1,'0.05',0),
 (15003,5,38,33,55,'2.92',0),
 (15004,5,39,33,4,'0.21',0),
 (15005,5,40,33,0,'0.00',0),
 (15006,5,41,33,3,'0.16',0),
 (15007,5,42,33,0,'0.00',0),
 (15008,5,45,33,1,'0.05',0),
 (15009,5,46,33,4,'0.21',0),
 (15010,5,47,33,0,'0.00',0),
 (15011,5,48,33,0,'0.00',0),
 (15012,5,51,33,17,'0.90',0),
 (15013,5,52,33,0,'0.00',0),
 (15014,5,53,33,4,'0.21',0),
 (15015,5,54,33,2,'0.11',0),
 (15016,5,1,34,205,'57.75',0),
 (15017,5,2,34,133,'37.46',0),
 (15018,5,14,34,0,'0.00',0),
 (15019,5,15,34,0,'0.00',0),
 (15020,5,28,34,0,'0.00',0),
 (15021,5,32,34,0,'0.00',0),
 (15022,5,36,34,0,'0.00',0),
 (15023,5,38,34,7,'1.97',0),
 (15024,5,39,34,1,'0.28',0),
 (15025,5,40,34,0,'0.00',0),
 (15026,5,41,34,0,'0.00',0),
 (15027,5,42,34,0,'0.00',0),
 (15028,5,45,34,6,'1.69',0),
 (15029,5,46,34,0,'0.00',0),
 (15030,5,47,34,0,'0.00',0),
 (15031,5,48,34,0,'0.00',0),
 (15032,5,51,34,2,'0.56',0),
 (15033,5,52,34,0,'0.00',0),
 (15034,5,53,34,1,'0.28',0),
 (15035,5,54,34,0,'0.00',0),
 (15036,5,1,35,391,'47.51',0),
 (15037,5,2,35,335,'40.70',0),
 (15038,5,14,35,0,'0.00',0),
 (15039,5,15,35,0,'0.00',0),
 (15040,5,28,35,0,'0.00',0),
 (15041,5,32,35,0,'0.00',0),
 (15042,5,36,35,0,'0.00',0),
 (15043,5,38,35,78,'9.48',0),
 (15044,5,39,35,2,'0.24',0),
 (15045,5,40,35,0,'0.00',0),
 (15046,5,41,35,1,'0.12',0),
 (15047,5,42,35,0,'0.00',0),
 (15048,5,45,35,2,'0.24',0),
 (15049,5,46,35,0,'0.00',0),
 (15050,5,47,35,1,'0.12',0),
 (15051,5,48,35,0,'0.00',0),
 (15052,5,51,35,4,'0.49',0),
 (15053,5,52,35,0,'0.00',0),
 (15054,5,53,35,0,'0.00',0),
 (15055,5,54,35,0,'0.00',0),
 (15056,5,1,36,387,'39.09',0),
 (15057,5,2,36,227,'22.93',0),
 (15058,5,14,36,0,'0.00',0),
 (15059,5,15,36,1,'0.10',0),
 (15060,5,28,36,0,'0.00',0),
 (15061,5,32,36,0,'0.00',0),
 (15062,5,36,36,3,'0.30',0),
 (15063,5,38,36,351,'35.45',0),
 (15064,5,39,36,6,'0.61',0),
 (15065,5,40,36,0,'0.00',0),
 (15066,5,41,36,0,'0.00',0),
 (15067,5,42,36,0,'0.00',0),
 (15068,5,45,36,0,'0.00',0),
 (15069,5,46,36,1,'0.10',0),
 (15070,5,47,36,1,'0.10',0),
 (15071,5,48,36,0,'0.00',0),
 (15072,5,51,36,2,'0.20',0),
 (15073,5,52,36,0,'0.00',0),
 (15074,5,53,36,0,'0.00',0),
 (15075,5,54,36,1,'0.10',0),
 (15076,5,1,37,659,'49.07',0),
 (15077,5,2,37,618,'46.02',0),
 (15078,5,14,37,0,'0.00',0),
 (15079,5,15,37,0,'0.00',0),
 (15080,5,28,37,2,'0.15',0),
 (15081,5,32,37,0,'0.00',0),
 (15082,5,36,37,0,'0.00',0),
 (15083,5,38,37,30,'2.23',0),
 (15084,5,39,37,1,'0.07',0),
 (15085,5,40,37,0,'0.00',0),
 (15086,5,41,37,0,'0.00',0),
 (15087,5,42,37,0,'0.00',0),
 (15088,5,45,37,0,'0.00',0),
 (15089,5,46,37,0,'0.00',0),
 (15090,5,47,37,0,'0.00',0),
 (15091,5,48,37,27,'2.01',0),
 (15092,5,51,37,4,'0.30',0),
 (15093,5,52,37,0,'0.00',0),
 (15094,5,53,37,0,'0.00',0),
 (15095,5,54,37,0,'0.00',0),
 (15096,5,1,38,1464,'41.85',0),
 (15097,5,2,38,1606,'45.91',0),
 (15098,5,14,38,2,'0.06',0),
 (15099,5,15,38,6,'0.17',0),
 (15100,5,28,38,3,'0.09',0),
 (15101,5,32,38,3,'0.09',0),
 (15102,5,36,38,1,'0.03',0),
 (15103,5,38,38,261,'7.46',0),
 (15104,5,39,38,35,'1.00',0),
 (15105,5,40,38,1,'0.03',0),
 (15106,5,41,38,7,'0.20',0),
 (15107,5,42,38,1,'0.03',0),
 (15108,5,45,38,4,'0.11',0),
 (15109,5,46,38,4,'0.11',0),
 (15110,5,47,38,1,'0.03',0),
 (15111,5,48,38,3,'0.09',0),
 (15112,5,51,38,37,'1.06',0),
 (15113,5,52,38,0,'0.00',0),
 (15114,5,53,38,6,'0.17',0),
 (15115,5,54,38,1,'0.03',0),
 (15116,5,1,39,41,'40.59',0),
 (15117,5,2,39,52,'51.49',0),
 (15118,5,14,39,0,'0.00',0),
 (15119,5,15,39,0,'0.00',0),
 (15120,5,28,39,0,'0.00',0),
 (15121,5,32,39,0,'0.00',0),
 (15122,5,36,39,0,'0.00',0),
 (15123,5,38,39,4,'3.96',0),
 (15124,5,39,39,0,'0.00',0),
 (15125,5,40,39,0,'0.00',0),
 (15126,5,41,39,0,'0.00',0),
 (15127,5,42,39,1,'0.99',0),
 (15128,5,45,39,0,'0.00',0),
 (15129,5,46,39,0,'0.00',0),
 (15130,5,47,39,0,'0.00',0),
 (15131,5,48,39,0,'0.00',0),
 (15132,5,51,39,2,'1.98',0),
 (15133,5,52,39,0,'0.00',0),
 (15134,5,53,39,0,'0.00',0),
 (15135,5,54,39,1,'0.99',0),
 (15136,5,1,40,3057,'40.30',0),
 (15137,5,2,40,3242,'42.74',0),
 (15138,5,14,40,6,'0.08',0),
 (15139,5,15,40,10,'0.13',0),
 (15140,5,28,40,4,'0.05',0),
 (15141,5,32,40,5,'0.07',0),
 (15142,5,36,40,13,'0.17',0),
 (15143,5,38,40,833,'10.98',0),
 (15144,5,39,40,72,'0.95',0),
 (15145,5,40,40,0,'0.00',0),
 (15146,5,41,40,2,'0.03',0),
 (15147,5,42,40,8,'0.11',0),
 (15148,5,45,40,10,'0.13',0),
 (15149,5,46,40,8,'0.11',0),
 (15150,5,47,40,4,'0.05',0),
 (15151,5,48,40,141,'1.86',0),
 (15152,5,51,40,56,'0.74',0),
 (15153,5,52,40,4,'0.05',0),
 (15154,5,53,40,11,'0.15',0),
 (15155,5,54,40,6,'0.08',0),
 (15156,5,1,41,920,'49.60',0),
 (15157,5,2,41,663,'35.74',0),
 (15158,5,14,41,3,'0.16',0),
 (15159,5,15,41,1,'0.05',0),
 (15160,5,28,41,3,'0.16',0),
 (15161,5,32,41,2,'0.11',0),
 (15162,5,36,41,0,'0.00',0),
 (15163,5,38,41,134,'7.22',0),
 (15164,5,39,41,29,'1.56',0),
 (15165,5,40,41,3,'0.16',0),
 (15166,5,41,41,1,'0.05',0),
 (15167,5,42,41,0,'0.00',0),
 (15168,5,45,41,5,'0.27',0),
 (15169,5,46,41,4,'0.22',0),
 (15170,5,47,41,0,'0.00',0),
 (15171,5,48,41,8,'0.43',0),
 (15172,5,51,41,31,'1.67',0),
 (15173,5,52,41,1,'0.05',0),
 (15174,5,53,41,4,'0.22',0),
 (15175,5,54,41,0,'0.00',0),
 (15176,5,1,42,382,'63.88',0),
 (15177,5,2,42,170,'28.43',0),
 (15178,5,14,42,1,'0.17',0),
 (15179,5,15,42,0,'0.00',0),
 (15180,5,28,42,2,'0.33',0),
 (15181,5,32,42,0,'0.00',0),
 (15182,5,36,42,0,'0.00',0),
 (15183,5,38,42,23,'3.85',0),
 (15184,5,39,42,5,'0.84',0),
 (15185,5,40,42,0,'0.00',0),
 (15186,5,41,42,2,'0.33',0),
 (15187,5,42,42,0,'0.00',0),
 (15188,5,45,42,2,'0.33',0),
 (15189,5,46,42,0,'0.00',0),
 (15190,5,47,42,0,'0.00',0),
 (15191,5,48,42,0,'0.00',0),
 (15192,5,51,42,1,'0.17',0),
 (15193,5,52,42,0,'0.00',0),
 (15194,5,53,42,0,'0.00',0),
 (15195,5,54,42,1,'0.17',0),
 (15196,5,1,43,1939,'53.76',0),
 (15197,5,2,43,1431,'39.67',0),
 (15198,5,14,43,1,'0.03',0),
 (15199,5,15,43,4,'0.11',0),
 (15200,5,28,43,1,'0.03',0),
 (15201,5,32,43,3,'0.08',0),
 (15202,5,36,43,19,'0.53',0),
 (15203,5,38,43,111,'3.08',0),
 (15204,5,39,43,10,'0.28',0),
 (15205,5,40,43,4,'0.11',0),
 (15206,5,41,43,1,'0.03',0),
 (15207,5,42,43,1,'0.03',0),
 (15208,5,45,43,4,'0.11',0),
 (15209,5,46,43,3,'0.08',0),
 (15210,5,47,43,4,'0.11',0),
 (15211,5,48,43,1,'0.03',0),
 (15212,5,51,43,15,'0.42',0),
 (15213,5,52,43,0,'0.00',0),
 (15214,5,53,43,6,'0.17',0),
 (15215,5,54,43,7,'0.19',0),
 (15216,5,1,44,1531,'47.89',0),
 (15217,5,2,44,1223,'38.25',0),
 (15218,5,14,44,0,'0.00',0),
 (15219,5,15,44,2,'0.06',0),
 (15220,5,28,44,1,'0.03',0),
 (15221,5,32,44,0,'0.00',0),
 (15222,5,36,44,6,'0.19',0),
 (15223,5,38,44,258,'8.07',0),
 (15224,5,39,44,42,'1.31',0),
 (15225,5,40,44,5,'0.16',0),
 (15226,5,41,44,3,'0.09',0),
 (15227,5,42,44,9,'0.28',0),
 (15228,5,45,44,2,'0.06',0),
 (15229,5,46,44,4,'0.13',0),
 (15230,5,47,44,1,'0.03',0),
 (15231,5,48,44,0,'0.00',0),
 (15232,5,51,44,43,'1.35',0),
 (15233,5,52,44,0,'0.00',0),
 (15234,5,53,44,6,'0.19',0),
 (15235,5,54,44,4,'0.13',0),
 (15236,5,1,45,8621,'47.05',0),
 (15237,5,2,45,7135,'38.94',0),
 (15238,5,14,45,12,'0.07',0),
 (15239,5,15,45,15,'0.08',0),
 (15240,5,28,45,35,'0.19',0),
 (15241,5,32,45,7,'0.04',0),
 (15242,5,36,45,11,'0.06',0),
 (15243,5,38,45,1415,'7.72',0),
 (15244,5,39,45,205,'1.12',0),
 (15245,5,40,45,19,'0.10',0),
 (15246,5,41,45,22,'0.12',0),
 (15247,5,42,45,15,'0.08',0),
 (15248,5,45,45,24,'0.13',0),
 (15249,5,46,45,11,'0.06',0),
 (15250,5,47,45,14,'0.08',0),
 (15251,5,48,45,9,'0.05',0),
 (15252,5,51,45,281,'1.53',0),
 (15253,5,52,45,9,'0.05',0),
 (15254,5,53,45,23,'0.13',0),
 (15255,5,54,45,15,'0.08',0),
 (15256,5,1,46,1283,'49.94',0),
 (15257,5,2,46,897,'34.92',0),
 (15258,5,14,46,2,'0.08',0),
 (15259,5,15,46,1,'0.04',0),
 (15260,5,28,46,5,'0.19',0),
 (15261,5,32,46,0,'0.00',0),
 (15262,5,36,46,0,'0.00',0),
 (15263,5,38,46,181,'7.05',0),
 (15264,5,39,46,30,'1.17',0),
 (15265,5,40,46,1,'0.04',0),
 (15266,5,41,46,1,'0.04',0),
 (15267,5,42,46,4,'0.16',0),
 (15268,5,45,46,0,'0.00',0),
 (15269,5,46,46,5,'0.19',0),
 (15270,5,47,46,1,'0.04',0),
 (15271,5,48,46,1,'0.04',0),
 (15272,5,51,46,61,'2.37',0),
 (15273,5,52,46,2,'0.08',0),
 (15274,5,53,46,24,'0.93',0),
 (15275,5,54,46,3,'0.12',0),
 (15276,5,1,47,9326,'41.21',0),
 (15277,5,2,47,10497,'46.39',0),
 (15278,5,14,47,10,'0.04',0),
 (15279,5,15,47,22,'0.10',0),
 (15280,5,28,47,32,'0.14',0),
 (15281,5,32,47,2,'0.01',0),
 (15282,5,36,47,27,'0.12',0),
 (15283,5,38,47,1393,'6.16',0),
 (15284,5,39,47,285,'1.26',0),
 (15285,5,40,47,21,'0.09',0),
 (15286,5,41,47,15,'0.07',0),
 (15287,5,42,47,24,'0.11',0),
 (15288,5,45,47,14,'0.06',0),
 (15289,5,46,47,24,'0.11',0),
 (15290,5,47,47,9,'0.04',0),
 (15291,5,48,47,9,'0.04',0),
 (15292,5,51,47,321,'1.42',0),
 (15293,5,52,47,8,'0.04',0),
 (15294,5,53,47,107,'0.47',0),
 (15295,5,54,47,12,'0.05',0),
 (15296,5,1,48,120,'36.04',0),
 (15297,5,2,48,171,'51.35',0),
 (15298,5,14,48,0,'0.00',0),
 (15299,5,15,48,0,'0.00',0),
 (15300,5,28,48,0,'0.00',0),
 (15301,5,32,48,0,'0.00',0),
 (15302,5,36,48,0,'0.00',0),
 (15303,5,38,48,33,'9.91',0),
 (15304,5,39,48,3,'0.90',0),
 (15305,5,40,48,0,'0.00',0),
 (15306,5,41,48,0,'0.00',0),
 (15307,5,42,48,0,'0.00',0),
 (15308,5,45,48,0,'0.00',0),
 (15309,5,46,48,0,'0.00',0),
 (15310,5,47,48,0,'0.00',0),
 (15311,5,48,48,0,'0.00',0),
 (15312,5,51,48,0,'0.00',0),
 (15313,5,52,48,0,'0.00',0),
 (15314,5,53,48,2,'0.60',0),
 (15315,5,54,48,0,'0.00',0),
 (15316,5,1,49,14962,'35.71',0),
 (15317,5,2,49,18746,'44.74',0),
 (15318,5,14,49,32,'0.08',0),
 (15319,5,15,49,72,'0.17',0),
 (15320,5,28,49,34,'0.08',0),
 (15321,5,32,49,28,'0.07',0),
 (15322,5,36,49,62,'0.15',0),
 (15323,5,38,49,5580,'13.32',0),
 (15324,5,39,49,657,'1.57',0),
 (15325,5,40,49,31,'0.07',0),
 (15326,5,41,49,40,'0.10',0),
 (15327,5,42,49,68,'0.16',0),
 (15328,5,45,49,24,'0.06',0),
 (15329,5,46,49,33,'0.08',0),
 (15330,5,47,49,22,'0.05',0),
 (15331,5,48,49,20,'0.05',0),
 (15332,5,51,49,531,'1.27',0),
 (15333,5,52,49,20,'0.05',0),
 (15334,5,53,49,162,'0.39',0),
 (15335,5,54,49,33,'0.08',0),
 (15336,5,1,50,805,'60.57',0),
 (15337,5,2,50,392,'29.50',0),
 (15338,5,14,50,0,'0.00',0),
 (15339,5,15,50,3,'0.23',0),
 (15340,5,28,50,2,'0.15',0),
 (15341,5,32,50,1,'0.08',0),
 (15342,5,36,50,1,'0.08',0),
 (15343,5,38,50,66,'4.97',0),
 (15344,5,39,50,14,'1.05',0),
 (15345,5,40,50,2,'0.15',0),
 (15346,5,41,50,0,'0.00',0),
 (15347,5,42,50,2,'0.15',0),
 (15348,5,45,50,0,'0.00',0),
 (15349,5,46,50,1,'0.08',0),
 (15350,5,47,50,2,'0.15',0),
 (15351,5,48,50,1,'0.08',0),
 (15352,5,51,50,13,'0.98',0),
 (15353,5,52,50,0,'0.00',0),
 (15354,5,53,50,7,'0.53',0),
 (15355,5,54,50,2,'0.15',0),
 (15356,5,1,51,520,'53.55',0),
 (15357,5,2,51,353,'36.35',0),
 (15358,5,14,51,0,'0.00',0),
 (15359,5,15,51,0,'0.00',0),
 (15360,5,28,51,1,'0.10',0),
 (15361,5,32,51,0,'0.00',0),
 (15362,5,36,51,1,'0.10',0),
 (15363,5,38,51,62,'6.39',0),
 (15364,5,39,51,8,'0.82',0),
 (15365,5,40,51,1,'0.10',0),
 (15366,5,41,51,0,'0.00',0),
 (15367,5,42,51,0,'0.00',0),
 (15368,5,45,51,0,'0.00',0),
 (15369,5,46,51,0,'0.00',0),
 (15370,5,47,51,0,'0.00',0),
 (15371,5,48,51,2,'0.21',0),
 (15372,5,51,51,3,'0.31',0),
 (15373,5,52,51,2,'0.21',0),
 (15374,5,53,51,2,'0.21',0),
 (15375,5,54,51,2,'0.21',0),
 (15376,5,1,52,1544,'56.93',0),
 (15377,5,2,52,1012,'37.32',0),
 (15378,5,14,52,0,'0.00',0),
 (15379,5,15,52,0,'0.00',0),
 (15380,5,28,52,3,'0.11',0),
 (15381,5,32,52,1,'0.04',0),
 (15382,5,36,52,0,'0.00',0),
 (15383,5,38,52,89,'3.28',0),
 (15384,5,39,52,7,'0.26',0),
 (15385,5,40,52,1,'0.04',0),
 (15386,5,41,52,1,'0.04',0),
 (15387,5,42,52,0,'0.00',0),
 (15388,5,45,52,1,'0.04',0),
 (15389,5,46,52,0,'0.00',0),
 (15390,5,47,52,1,'0.04',0),
 (15391,5,48,52,11,'0.41',0),
 (15392,5,51,52,11,'0.41',0),
 (15393,5,52,52,0,'0.00',0),
 (15394,5,53,52,0,'0.00',0),
 (15395,5,54,52,1,'0.04',0),
 (15396,5,1,53,1307,'45.59',0),
 (15397,5,2,53,1180,'41.16',0),
 (15398,5,14,53,3,'0.10',0),
 (15399,5,15,53,2,'0.07',0),
 (15400,5,28,53,1,'0.03',0),
 (15401,5,32,53,1,'0.03',0),
 (15402,5,36,53,10,'0.35',0),
 (15403,5,38,53,196,'6.84',0),
 (15404,5,39,53,49,'1.71',0),
 (15405,5,40,53,3,'0.10',0),
 (15406,5,41,53,0,'0.00',0),
 (15407,5,42,53,0,'0.00',0),
 (15408,5,45,53,9,'0.31',0),
 (15409,5,46,53,1,'0.03',0),
 (15410,5,47,53,1,'0.03',0),
 (15411,5,48,53,1,'0.03',0),
 (15412,5,51,53,25,'0.87',0),
 (15413,5,52,53,0,'0.00',0),
 (15414,5,53,53,1,'0.03',0),
 (15415,5,54,53,2,'0.07',0),
 (15416,5,1,54,3103,'49.14',0),
 (15417,5,2,54,2474,'39.18',0),
 (15418,5,14,54,1,'0.02',0),
 (15419,5,15,54,0,'0.00',0),
 (15420,5,28,54,2,'0.03',0),
 (15421,5,32,54,1,'0.02',0),
 (15422,5,36,54,6,'0.10',0),
 (15423,5,38,54,382,'6.05',0),
 (15424,5,39,54,86,'1.36',0),
 (15425,5,40,54,3,'0.05',0),
 (15426,5,41,54,8,'0.13',0),
 (15427,5,42,54,11,'0.17',0),
 (15428,5,45,54,4,'0.06',0),
 (15429,5,46,54,13,'0.21',0),
 (15430,5,47,54,3,'0.05',0),
 (15431,5,48,54,0,'0.00',0),
 (15432,5,51,54,58,'0.92',0),
 (15433,5,52,54,1,'0.02',0),
 (15434,5,53,54,12,'0.19',0),
 (15435,5,54,54,4,'0.06',0),
 (15436,5,1,55,408,'54.40',0),
 (15437,5,2,55,332,'44.27',0),
 (15438,5,14,55,0,'0.00',0),
 (15439,5,15,55,0,'0.00',0),
 (15440,5,28,55,0,'0.00',0),
 (15441,5,32,55,0,'0.00',0),
 (15442,5,36,55,0,'0.00',0),
 (15443,5,38,55,3,'0.40',0),
 (15444,5,39,55,0,'0.00',0),
 (15445,5,40,55,0,'0.00',0),
 (15446,5,41,55,0,'0.00',0),
 (15447,5,42,55,0,'0.00',0),
 (15448,5,45,55,0,'0.00',0),
 (15449,5,46,55,0,'0.00',0),
 (15450,5,47,55,0,'0.00',0),
 (15451,5,48,55,0,'0.00',0),
 (15452,5,51,55,1,'0.13',0),
 (15453,5,52,55,0,'0.00',0),
 (15454,5,53,55,0,'0.00',0),
 (15455,5,54,55,1,'0.13',0),
 (15456,5,1,56,262,'51.37',0),
 (15457,5,2,56,193,'37.84',0),
 (15458,5,14,56,0,'0.00',0),
 (15459,5,15,56,0,'0.00',0),
 (15460,5,28,56,0,'0.00',0),
 (15461,5,32,56,0,'0.00',0),
 (15462,5,36,56,0,'0.00',0),
 (15463,5,38,56,38,'7.45',0),
 (15464,5,39,56,2,'0.39',0),
 (15465,5,40,56,0,'0.00',0),
 (15466,5,41,56,0,'0.00',0),
 (15467,5,42,56,0,'0.00',0),
 (15468,5,45,56,1,'0.20',0),
 (15469,5,46,56,0,'0.00',0),
 (15470,5,47,56,0,'0.00',0),
 (15471,5,48,56,0,'0.00',0),
 (15472,5,51,56,4,'0.78',0),
 (15473,5,52,56,1,'0.20',0),
 (15474,5,53,56,1,'0.20',0),
 (15475,5,54,56,1,'0.20',0),
 (15476,5,1,57,315,'51.05',0),
 (15477,5,2,57,208,'33.71',0),
 (15478,5,14,57,0,'0.00',0),
 (15479,5,15,57,1,'0.16',0),
 (15480,5,28,57,4,'0.65',0),
 (15481,5,32,57,13,'2.11',0),
 (15482,5,36,57,0,'0.00',0),
 (15483,5,38,57,40,'6.48',0),
 (15484,5,39,57,13,'2.11',0),
 (15485,5,40,57,0,'0.00',0),
 (15486,5,41,57,1,'0.16',0),
 (15487,5,42,57,0,'0.00',0),
 (15488,5,45,57,0,'0.00',0),
 (15489,5,46,57,2,'0.32',0),
 (15490,5,47,57,0,'0.00',0),
 (15491,5,48,57,1,'0.16',0),
 (15492,5,51,57,13,'2.11',0),
 (15493,5,52,57,0,'0.00',0),
 (15494,5,53,57,0,'0.00',0),
 (15495,5,54,57,0,'0.00',0),
 (15496,5,1,58,28645,'32.55',0),
 (15497,5,2,58,48221,'54.80',0),
 (15498,5,14,58,63,'0.07',0),
 (15499,5,15,58,105,'0.12',0),
 (15500,5,28,58,177,'0.20',0),
 (15501,5,32,58,18,'0.02',0),
 (15502,5,36,58,61,'0.07',0),
 (15503,5,38,58,6586,'7.48',0),
 (15504,5,39,58,1113,'1.26',0);
INSERT INTO `elecmunicandi` (`idElecMuniCandi`,`Convocatoria_idConvocatoria`,`Candidatura_idCandidatura`,`Municipio`,`Votos`,`PorcVotos`,`Concejales`) VALUES 
 (15505,5,40,58,30,'0.03',0),
 (15506,5,41,58,62,'0.07',0),
 (15507,5,42,58,78,'0.09',0),
 (15508,5,45,58,55,'0.06',0),
 (15509,5,46,58,83,'0.09',0),
 (15510,5,47,58,37,'0.04',0),
 (15511,5,48,58,37,'0.04',0),
 (15512,5,51,58,1170,'1.33',0),
 (15513,5,52,58,36,'0.04',0),
 (15514,5,53,58,102,'0.12',0),
 (15515,5,54,58,77,'0.09',0),
 (15516,5,1,59,1334,'50.61',0),
 (15517,5,2,59,977,'37.06',0),
 (15518,5,14,59,2,'0.08',0),
 (15519,5,15,59,0,'0.00',0),
 (15520,5,28,59,3,'0.11',0),
 (15521,5,32,59,0,'0.00',0),
 (15522,5,36,59,1,'0.04',0),
 (15523,5,38,59,156,'5.92',0),
 (15524,5,39,59,16,'0.61',0),
 (15525,5,40,59,1,'0.04',0),
 (15526,5,41,59,1,'0.04',0),
 (15527,5,42,59,0,'0.00',0),
 (15528,5,45,59,0,'0.00',0),
 (15529,5,46,59,0,'0.00',0),
 (15530,5,47,59,2,'0.08',0),
 (15531,5,48,59,49,'1.86',0),
 (15532,5,51,59,45,'1.71',0),
 (15533,5,52,59,0,'0.00',0),
 (15534,5,53,59,2,'0.08',0),
 (15535,5,54,59,2,'0.08',0),
 (15536,5,1,60,272,'25.71',0),
 (15537,5,2,60,622,'58.79',0),
 (15538,5,14,60,0,'0.00',0),
 (15539,5,15,60,0,'0.00',0),
 (15540,5,28,60,0,'0.00',0),
 (15541,5,32,60,0,'0.00',0),
 (15542,5,36,60,0,'0.00',0),
 (15543,5,38,60,151,'14.27',0),
 (15544,5,39,60,2,'0.19',0),
 (15545,5,40,60,0,'0.00',0),
 (15546,5,41,60,0,'0.00',0),
 (15547,5,42,60,0,'0.00',0),
 (15548,5,45,60,0,'0.00',0),
 (15549,5,46,60,1,'0.09',0),
 (15550,5,47,60,0,'0.00',0),
 (15551,5,48,60,0,'0.00',0),
 (15552,5,51,60,2,'0.19',0),
 (15553,5,52,60,0,'0.00',0),
 (15554,5,53,60,0,'0.00',0),
 (15555,5,54,60,0,'0.00',0),
 (15556,5,1,61,6369,'51.81',0),
 (15557,5,2,61,4413,'35.90',0),
 (15558,5,14,61,19,'0.15',0),
 (15559,5,15,61,6,'0.05',0),
 (15560,5,28,61,26,'0.21',0),
 (15561,5,32,61,5,'0.04',0),
 (15562,5,36,61,13,'0.11',0),
 (15563,5,38,61,726,'5.91',0),
 (15564,5,39,61,164,'1.33',0),
 (15565,5,40,61,10,'0.08',0),
 (15566,5,41,61,8,'0.07',0),
 (15567,5,42,61,9,'0.07',0),
 (15568,5,45,61,6,'0.05',0),
 (15569,5,46,61,16,'0.13',0),
 (15570,5,47,61,14,'0.11',0),
 (15571,5,48,61,9,'0.07',0),
 (15572,5,51,61,153,'1.24',0),
 (15573,5,52,61,0,'0.00',0),
 (15574,5,53,61,28,'0.23',0),
 (15575,5,54,61,9,'0.07',0),
 (15576,5,1,62,165,'67.62',0),
 (15577,5,2,62,72,'29.51',0),
 (15578,5,14,62,0,'0.00',0),
 (15579,5,15,62,1,'0.41',0),
 (15580,5,28,62,1,'0.41',0),
 (15581,5,32,62,0,'0.00',0),
 (15582,5,36,62,0,'0.00',0),
 (15583,5,38,62,1,'0.41',0),
 (15584,5,39,62,0,'0.00',0),
 (15585,5,40,62,0,'0.00',0),
 (15586,5,41,62,0,'0.00',0),
 (15587,5,42,62,0,'0.00',0),
 (15588,5,45,62,0,'0.00',0),
 (15589,5,46,62,0,'0.00',0),
 (15590,5,47,62,0,'0.00',0),
 (15591,5,48,62,0,'0.00',0),
 (15592,5,51,62,1,'0.41',0),
 (15593,5,52,62,0,'0.00',0),
 (15594,5,53,62,0,'0.00',0),
 (15595,5,54,62,0,'0.00',0),
 (15596,5,1,63,111,'59.36',0),
 (15597,5,2,63,59,'31.55',0),
 (15598,5,14,63,0,'0.00',0),
 (15599,5,15,63,2,'1.07',0),
 (15600,5,28,63,0,'0.00',0),
 (15601,5,32,63,0,'0.00',0),
 (15602,5,36,63,0,'0.00',0),
 (15603,5,38,63,9,'4.81',0),
 (15604,5,39,63,3,'1.60',0),
 (15605,5,40,63,0,'0.00',0),
 (15606,5,41,63,0,'0.00',0),
 (15607,5,42,63,0,'0.00',0),
 (15608,5,45,63,0,'0.00',0),
 (15609,5,46,63,0,'0.00',0),
 (15610,5,47,63,0,'0.00',0),
 (15611,5,48,63,0,'0.00',0),
 (15612,5,51,63,2,'1.07',0),
 (15613,5,52,63,0,'0.00',0),
 (15614,5,53,63,0,'0.00',0),
 (15615,5,54,63,0,'0.00',0),
 (15616,5,1,64,55,'52.88',0),
 (15617,5,2,64,43,'41.35',0),
 (15618,5,14,64,0,'0.00',0),
 (15619,5,15,64,0,'0.00',0),
 (15620,5,28,64,0,'0.00',0),
 (15621,5,32,64,0,'0.00',0),
 (15622,5,36,64,0,'0.00',0),
 (15623,5,38,64,2,'1.92',0),
 (15624,5,39,64,0,'0.00',0),
 (15625,5,40,64,0,'0.00',0),
 (15626,5,41,64,0,'0.00',0),
 (15627,5,42,64,0,'0.00',0),
 (15628,5,45,64,0,'0.00',0),
 (15629,5,46,64,0,'0.00',0),
 (15630,5,47,64,1,'0.96',0),
 (15631,5,48,64,0,'0.00',0),
 (15632,5,51,64,1,'0.96',0),
 (15633,5,52,64,0,'0.00',0),
 (15634,5,53,64,0,'0.00',0),
 (15635,5,54,64,0,'0.00',0),
 (15636,5,1,65,30549,'35.36',0),
 (15637,5,2,65,41607,'48.16',0),
 (15638,5,14,65,50,'0.06',0),
 (15639,5,15,65,104,'0.12',0),
 (15640,5,28,65,103,'0.12',0),
 (15641,5,32,65,17,'0.02',0),
 (15642,5,36,65,56,'0.06',0),
 (15643,5,38,65,9644,'11.16',0),
 (15644,5,39,65,1021,'1.18',0),
 (15645,5,40,65,34,'0.04',0),
 (15646,5,41,65,73,'0.08',0),
 (15647,5,42,65,67,'0.08',0),
 (15648,5,45,65,56,'0.06',0),
 (15649,5,46,65,63,'0.07',0),
 (15650,5,47,65,35,'0.04',0),
 (15651,5,48,65,23,'0.03',0),
 (15652,5,51,65,1101,'1.27',0),
 (15653,5,52,65,38,'0.04',0),
 (15654,5,53,65,147,'0.17',0),
 (15655,5,54,65,62,'0.07',0),
 (15656,5,1,66,2261,'63.14',0),
 (15657,5,2,66,1007,'28.12',0),
 (15658,5,14,66,0,'0.00',0),
 (15659,5,15,66,1,'0.03',0),
 (15660,5,28,66,3,'0.08',0),
 (15661,5,32,66,1,'0.03',0),
 (15662,5,36,66,2,'0.06',0),
 (15663,5,38,66,122,'3.41',0),
 (15664,5,39,66,35,'0.98',0),
 (15665,5,40,66,1,'0.03',0),
 (15666,5,41,66,2,'0.06',0),
 (15667,5,42,66,3,'0.08',0),
 (15668,5,45,66,5,'0.14',0),
 (15669,5,46,66,2,'0.06',0),
 (15670,5,47,66,0,'0.00',0),
 (15671,5,48,66,0,'0.00',0),
 (15672,5,51,66,47,'1.31',0),
 (15673,5,52,66,1,'0.03',0),
 (15674,5,53,66,6,'0.17',0),
 (15675,5,54,66,1,'0.03',0),
 (15676,5,1,67,1018,'46.21',0),
 (15677,5,2,67,937,'42.53',0),
 (15678,5,14,67,2,'0.09',0),
 (15679,5,15,67,4,'0.18',0),
 (15680,5,28,67,2,'0.09',0),
 (15681,5,32,67,2,'0.09',0),
 (15682,5,36,67,3,'0.14',0),
 (15683,5,38,67,170,'7.72',0),
 (15684,5,39,67,11,'0.50',0),
 (15685,5,40,67,1,'0.05',0),
 (15686,5,41,67,3,'0.14',0),
 (15687,5,42,67,1,'0.05',0),
 (15688,5,45,67,1,'0.05',0),
 (15689,5,46,67,1,'0.05',0),
 (15690,5,47,67,0,'0.00',0),
 (15691,5,48,67,1,'0.05',0),
 (15692,5,51,67,13,'0.59',0),
 (15693,5,52,67,2,'0.09',0),
 (15694,5,53,67,0,'0.00',0),
 (15695,5,54,67,3,'0.14',0),
 (15696,5,1,68,3251,'54.44',0),
 (15697,5,2,68,2208,'36.97',0),
 (15698,5,14,68,3,'0.05',0),
 (15699,5,15,68,3,'0.05',0),
 (15700,5,28,68,11,'0.18',0),
 (15701,5,32,68,0,'0.00',0),
 (15702,5,36,68,5,'0.08',0),
 (15703,5,38,68,202,'3.38',0),
 (15704,5,39,68,53,'0.89',0),
 (15705,5,40,68,3,'0.05',0),
 (15706,5,41,68,6,'0.10',0),
 (15707,5,42,68,2,'0.03',0),
 (15708,5,45,68,4,'0.07',0),
 (15709,5,46,68,4,'0.07',0),
 (15710,5,47,68,0,'0.00',0),
 (15711,5,48,68,3,'0.05',0),
 (15712,5,51,68,58,'0.97',0),
 (15713,5,52,68,2,'0.03',0),
 (15714,5,53,68,15,'0.25',0),
 (15715,5,54,68,11,'0.18',0),
 (15716,5,1,69,47,'59.49',0),
 (15717,5,2,69,19,'24.05',0),
 (15718,5,14,69,0,'0.00',0),
 (15719,5,15,69,0,'0.00',0),
 (15720,5,28,69,0,'0.00',0),
 (15721,5,32,69,0,'0.00',0),
 (15722,5,36,69,0,'0.00',0),
 (15723,5,38,69,9,'11.39',0),
 (15724,5,39,69,2,'2.53',0),
 (15725,5,40,69,0,'0.00',0),
 (15726,5,41,69,0,'0.00',0),
 (15727,5,42,69,0,'0.00',0),
 (15728,5,45,69,0,'0.00',0),
 (15729,5,46,69,0,'0.00',0),
 (15730,5,47,69,0,'0.00',0),
 (15731,5,48,69,0,'0.00',0),
 (15732,5,51,69,2,'2.53',0),
 (15733,5,52,69,0,'0.00',0),
 (15734,5,53,69,0,'0.00',0),
 (15735,5,54,69,0,'0.00',0),
 (15736,5,1,70,64,'58.18',0),
 (15737,5,2,70,36,'32.73',0),
 (15738,5,14,70,0,'0.00',0),
 (15739,5,15,70,0,'0.00',0),
 (15740,5,28,70,0,'0.00',0),
 (15741,5,32,70,0,'0.00',0),
 (15742,5,36,70,0,'0.00',0),
 (15743,5,38,70,8,'7.27',0),
 (15744,5,39,70,1,'0.91',0),
 (15745,5,40,70,0,'0.00',0),
 (15746,5,41,70,0,'0.00',0),
 (15747,5,42,70,0,'0.00',0),
 (15748,5,45,70,0,'0.00',0),
 (15749,5,46,70,0,'0.00',0),
 (15750,5,47,70,0,'0.00',0),
 (15751,5,48,70,0,'0.00',0),
 (15752,5,51,70,0,'0.00',0),
 (15753,5,52,70,0,'0.00',0),
 (15754,5,53,70,0,'0.00',0),
 (15755,5,54,70,0,'0.00',0),
 (15756,5,1,71,36,'50.70',0),
 (15757,5,2,71,29,'40.85',0),
 (15758,5,14,71,2,'2.82',0),
 (15759,5,15,71,0,'0.00',0),
 (15760,5,28,71,0,'0.00',0),
 (15761,5,32,71,0,'0.00',0),
 (15762,5,36,71,0,'0.00',0),
 (15763,5,38,71,2,'2.82',0),
 (15764,5,39,71,2,'2.82',0),
 (15765,5,40,71,0,'0.00',0),
 (15766,5,41,71,0,'0.00',0),
 (15767,5,42,71,0,'0.00',0),
 (15768,5,45,71,0,'0.00',0),
 (15769,5,46,71,0,'0.00',0),
 (15770,5,47,71,0,'0.00',0),
 (15771,5,48,71,0,'0.00',0),
 (15772,5,51,71,0,'0.00',0),
 (15773,5,52,71,0,'0.00',0),
 (15774,5,53,71,0,'0.00',0),
 (15775,5,54,71,0,'0.00',0),
 (15776,5,1,72,1657,'58.37',0),
 (15777,5,2,72,760,'26.77',0),
 (15778,5,14,72,1,'0.04',0),
 (15779,5,15,72,10,'0.35',0),
 (15780,5,28,72,6,'0.21',0),
 (15781,5,32,72,0,'0.00',0),
 (15782,5,36,72,9,'0.32',0),
 (15783,5,38,72,190,'6.69',0),
 (15784,5,39,72,47,'1.66',0),
 (15785,5,40,72,1,'0.04',0),
 (15786,5,41,72,3,'0.11',0),
 (15787,5,42,72,2,'0.07',0),
 (15788,5,45,72,3,'0.11',0),
 (15789,5,46,72,3,'0.11',0),
 (15790,5,47,72,6,'0.21',0),
 (15791,5,48,72,0,'0.00',0),
 (15792,5,51,72,56,'1.97',0),
 (15793,5,52,72,1,'0.04',0),
 (15794,5,53,72,2,'0.07',0),
 (15795,5,54,72,1,'0.04',0),
 (15796,5,1,73,2281,'42.08',0),
 (15797,5,2,73,2334,'43.05',0),
 (15798,5,14,73,12,'0.22',0),
 (15799,5,15,73,11,'0.20',0),
 (15800,5,28,73,12,'0.22',0),
 (15801,5,32,73,2,'0.04',0),
 (15802,5,36,73,3,'0.06',0),
 (15803,5,38,73,374,'6.90',0),
 (15804,5,39,73,87,'1.60',0),
 (15805,5,40,73,4,'0.07',0),
 (15806,5,41,73,6,'0.11',0),
 (15807,5,42,73,5,'0.09',0),
 (15808,5,45,73,2,'0.04',0),
 (15809,5,46,73,7,'0.13',0),
 (15810,5,47,73,4,'0.07',0),
 (15811,5,48,73,3,'0.06',0),
 (15812,5,51,73,126,'2.32',0),
 (15813,5,52,73,8,'0.15',0),
 (15814,5,53,73,48,'0.89',0),
 (15815,5,54,73,2,'0.04',0),
 (15816,5,1,74,34772,'36.34',0),
 (15817,5,2,74,44347,'46.35',0),
 (15818,5,14,74,93,'0.10',0),
 (15819,5,15,74,192,'0.20',0),
 (15820,5,28,74,119,'0.12',0),
 (15821,5,32,74,64,'0.07',0),
 (15822,5,36,74,100,'0.10',0),
 (15823,5,38,74,10671,'11.15',0),
 (15824,5,39,74,1260,'1.32',0),
 (15825,5,40,74,47,'0.05',0),
 (15826,5,41,74,103,'0.11',0),
 (15827,5,42,74,92,'0.10',0),
 (15828,5,45,74,67,'0.07',0),
 (15829,5,46,74,82,'0.09',0),
 (15830,5,47,74,67,'0.07',0),
 (15831,5,48,74,183,'0.19',0),
 (15832,5,51,74,1413,'1.48',0),
 (15833,5,52,74,77,'0.08',0),
 (15834,5,53,74,194,'0.20',0),
 (15835,5,54,74,104,'0.11',0),
 (15836,5,1,75,1019,'46.36',0),
 (15837,5,2,75,931,'42.36',0),
 (15838,5,14,75,0,'0.00',0),
 (15839,5,15,75,1,'0.05',0),
 (15840,5,28,75,1,'0.05',0),
 (15841,5,32,75,2,'0.09',0),
 (15842,5,36,75,3,'0.14',0),
 (15843,5,38,75,184,'8.37',0),
 (15844,5,39,75,6,'0.27',0),
 (15845,5,40,75,0,'0.00',0),
 (15846,5,41,75,1,'0.05',0),
 (15847,5,42,75,2,'0.09',0),
 (15848,5,45,75,2,'0.09',0),
 (15849,5,46,75,3,'0.14',0),
 (15850,5,47,75,0,'0.00',0),
 (15851,5,48,75,0,'0.00',0),
 (15852,5,51,75,13,'0.59',0),
 (15853,5,52,75,0,'0.00',0),
 (15854,5,53,75,0,'0.00',0),
 (15855,5,54,75,0,'0.00',0),
 (15856,5,1,76,170,'52.15',0),
 (15857,5,2,76,129,'39.57',0),
 (15858,5,14,76,0,'0.00',0),
 (15859,5,15,76,1,'0.31',0),
 (15860,5,28,76,1,'0.31',0),
 (15861,5,32,76,0,'0.00',0),
 (15862,5,36,76,0,'0.00',0),
 (15863,5,38,76,14,'4.29',0),
 (15864,5,39,76,2,'0.61',0),
 (15865,5,40,76,0,'0.00',0),
 (15866,5,41,76,0,'0.00',0),
 (15867,5,42,76,4,'1.23',0),
 (15868,5,45,76,1,'0.31',0),
 (15869,5,46,76,0,'0.00',0),
 (15870,5,47,76,0,'0.00',0),
 (15871,5,48,76,0,'0.00',0),
 (15872,5,51,76,1,'0.31',0),
 (15873,5,52,76,0,'0.00',0),
 (15874,5,53,76,1,'0.31',0),
 (15875,5,54,76,0,'0.00',0),
 (15876,5,1,78,17,'68.00',0),
 (15877,5,2,78,5,'20.00',0),
 (15878,5,14,78,0,'0.00',0),
 (15879,5,15,78,0,'0.00',0),
 (15880,5,28,78,0,'0.00',0),
 (15881,5,32,78,0,'0.00',0),
 (15882,5,36,78,0,'0.00',0),
 (15883,5,38,78,2,'8.00',0),
 (15884,5,39,78,0,'0.00',0),
 (15885,5,40,78,0,'0.00',0),
 (15886,5,41,78,0,'0.00',0),
 (15887,5,42,78,0,'0.00',0),
 (15888,5,45,78,0,'0.00',0),
 (15889,5,46,78,0,'0.00',0),
 (15890,5,47,78,0,'0.00',0),
 (15891,5,48,78,0,'0.00',0),
 (15892,5,51,78,0,'0.00',0),
 (15893,5,52,78,0,'0.00',0),
 (15894,5,53,78,0,'0.00',0),
 (15895,5,54,78,0,'0.00',0),
 (15896,5,1,79,831337,'49.14',0),
 (15897,5,2,79,647400,'38.26',0),
 (15898,5,14,79,1043,'0.06',0),
 (15899,5,15,79,887,'0.05',0),
 (15900,5,28,79,2096,'0.12',0),
 (15901,5,32,79,275,'0.02',0),
 (15902,5,36,79,1053,'0.06',0),
 (15903,5,38,79,123226,'7.28',0),
 (15904,5,39,79,11952,'0.71',0),
 (15905,5,40,79,1003,'0.06',0),
 (15906,5,41,79,1087,'0.06',0),
 (15907,5,42,79,1262,'0.07',0),
 (15908,5,45,79,1031,'0.06',0),
 (15909,5,46,79,2338,'0.14',0),
 (15910,5,47,79,946,'0.06',0),
 (15911,5,48,79,666,'0.04',0),
 (15912,5,51,79,24217,'1.43',0),
 (15913,5,52,79,453,'0.03',0),
 (15914,5,53,79,2763,'0.16',0),
 (15915,5,54,79,1244,'0.07',0),
 (15916,5,1,80,16746,'58.74',0),
 (15917,5,2,80,8325,'29.20',0),
 (15918,5,14,80,17,'0.06',0),
 (15919,5,15,80,8,'0.03',0),
 (15920,5,28,80,36,'0.13',0),
 (15921,5,32,80,2,'0.01',0),
 (15922,5,36,80,25,'0.09',0),
 (15923,5,38,80,1314,'4.61',0),
 (15924,5,39,80,353,'1.24',0),
 (15925,5,40,80,18,'0.06',0),
 (15926,5,41,80,25,'0.09',0),
 (15927,5,42,80,19,'0.07',0),
 (15928,5,45,80,11,'0.04',0),
 (15929,5,46,80,57,'0.20',0),
 (15930,5,47,80,46,'0.16',0),
 (15931,5,48,80,53,'0.19',0),
 (15932,5,51,80,378,'1.33',0),
 (15933,5,52,80,5,'0.02',0),
 (15934,5,53,80,263,'0.92',0),
 (15935,5,54,80,21,'0.07',0),
 (15936,5,1,82,1524,'55.48',0),
 (15937,5,2,82,878,'31.96',0),
 (15938,5,14,82,0,'0.00',0),
 (15939,5,15,82,1,'0.04',0),
 (15940,5,28,82,1,'0.04',0),
 (15941,5,32,82,1,'0.04',0),
 (15942,5,36,82,0,'0.00',0),
 (15943,5,38,82,177,'6.44',0),
 (15944,5,39,82,35,'1.27',0),
 (15945,5,40,82,1,'0.04',0),
 (15946,5,41,82,3,'0.11',0),
 (15947,5,42,82,1,'0.04',0),
 (15948,5,45,82,3,'0.11',0),
 (15949,5,46,82,0,'0.00',0),
 (15950,5,47,82,0,'0.00',0),
 (15951,5,48,82,3,'0.11',0),
 (15952,5,51,82,38,'1.38',0),
 (15953,5,52,82,0,'0.00',0),
 (15954,5,53,82,12,'0.44',0),
 (15955,5,54,82,2,'0.07',0),
 (15956,5,1,83,1717,'43.27',0),
 (15957,5,2,83,1605,'40.45',0),
 (15958,5,14,83,3,'0.08',0),
 (15959,5,15,83,7,'0.18',0),
 (15960,5,28,83,6,'0.15',0),
 (15961,5,32,83,1,'0.03',0),
 (15962,5,36,83,10,'0.25',0),
 (15963,5,38,83,340,'8.57',0),
 (15964,5,39,83,62,'1.56',0),
 (15965,5,40,83,5,'0.13',0),
 (15966,5,41,83,2,'0.05',0),
 (15967,5,42,83,3,'0.08',0),
 (15968,5,45,83,3,'0.08',0),
 (15969,5,46,83,0,'0.00',0),
 (15970,5,47,83,2,'0.05',0),
 (15971,5,48,83,68,'1.71',0),
 (15972,5,51,83,50,'1.26',0),
 (15973,5,52,83,1,'0.03',0),
 (15974,5,53,83,6,'0.15',0),
 (15975,5,54,83,2,'0.05',0),
 (15976,5,1,84,2945,'35.37',0),
 (15977,5,2,84,3889,'46.71',0),
 (15978,5,14,84,8,'0.10',0),
 (15979,5,15,84,12,'0.14',0),
 (15980,5,28,84,10,'0.12',0),
 (15981,5,32,84,2,'0.02',0),
 (15982,5,36,84,6,'0.07',0),
 (15983,5,38,84,1026,'12.32',0),
 (15984,5,39,84,85,'1.02',0),
 (15985,5,40,84,8,'0.10',0),
 (15986,5,41,84,7,'0.08',0),
 (15987,5,42,84,5,'0.06',0),
 (15988,5,45,84,9,'0.11',0),
 (15989,5,46,84,3,'0.04',0),
 (15990,5,47,84,4,'0.05',0),
 (15991,5,48,84,7,'0.08',0),
 (15992,5,51,84,153,'1.84',0),
 (15993,5,52,84,2,'0.02',0),
 (15994,5,53,84,8,'0.10',0),
 (15995,5,54,84,11,'0.13',0),
 (15996,5,1,85,1089,'45.24',0),
 (15997,5,2,85,1061,'44.08',0),
 (15998,5,14,85,0,'0.00',0),
 (15999,5,15,85,0,'0.00',0),
 (16000,5,28,85,6,'0.25',0),
 (16001,5,32,85,0,'0.00',0),
 (16002,5,36,85,0,'0.00',0),
 (16003,5,38,85,151,'6.27',0),
 (16004,5,39,85,27,'1.12',0),
 (16005,5,40,85,0,'0.00',0),
 (16006,5,41,85,2,'0.08',0),
 (16007,5,42,85,2,'0.08',0),
 (16008,5,45,85,2,'0.08',0),
 (16009,5,46,85,0,'0.00',0),
 (16010,5,47,85,2,'0.08',0),
 (16011,5,48,85,0,'0.00',0),
 (16012,5,51,85,16,'0.66',0),
 (16013,5,52,85,1,'0.04',0),
 (16014,5,53,85,5,'0.21',0),
 (16015,5,54,85,3,'0.12',0),
 (16016,5,1,86,1195,'54.77',0),
 (16017,5,2,86,716,'32.81',0),
 (16018,5,14,86,2,'0.09',0),
 (16019,5,15,86,2,'0.09',0),
 (16020,5,28,86,5,'0.23',0),
 (16021,5,32,86,1,'0.05',0),
 (16022,5,36,86,1,'0.05',0),
 (16023,5,38,86,97,'4.45',0),
 (16024,5,39,86,14,'0.64',0),
 (16025,5,40,86,2,'0.09',0),
 (16026,5,41,86,3,'0.14',0),
 (16027,5,42,86,0,'0.00',0),
 (16028,5,45,86,5,'0.23',0),
 (16029,5,46,86,0,'0.00',0),
 (16030,5,47,86,1,'0.05',0),
 (16031,5,48,86,55,'2.52',0),
 (16032,5,51,86,26,'1.19',0),
 (16033,5,52,86,1,'0.05',0),
 (16034,5,53,86,20,'0.92',0),
 (16035,5,54,86,4,'0.18',0),
 (16036,5,1,87,1152,'52.58',0),
 (16037,5,2,87,782,'35.69',0),
 (16038,5,14,87,0,'0.00',0),
 (16039,5,15,87,3,'0.14',0),
 (16040,5,28,87,4,'0.18',0),
 (16041,5,32,87,0,'0.00',0),
 (16042,5,36,87,2,'0.09',0),
 (16043,5,38,87,106,'4.84',0),
 (16044,5,39,87,16,'0.73',0),
 (16045,5,40,87,1,'0.05',0),
 (16046,5,41,87,1,'0.05',0),
 (16047,5,42,87,3,'0.14',0),
 (16048,5,45,87,2,'0.09',0),
 (16049,5,46,87,5,'0.23',0),
 (16050,5,47,87,0,'0.00',0),
 (16051,5,48,87,32,'1.46',0),
 (16052,5,51,87,14,'0.64',0),
 (16053,5,52,87,0,'0.00',0),
 (16054,5,53,87,22,'1.00',0),
 (16055,5,54,87,4,'0.18',0),
 (16056,5,1,88,103,'43.64',0),
 (16057,5,2,88,101,'42.80',0),
 (16058,5,14,88,0,'0.00',0),
 (16059,5,15,88,0,'0.00',0),
 (16060,5,28,88,0,'0.00',0),
 (16061,5,32,88,0,'0.00',0),
 (16062,5,36,88,0,'0.00',0),
 (16063,5,38,88,24,'10.17',0),
 (16064,5,39,88,2,'0.85',0),
 (16065,5,40,88,0,'0.00',0),
 (16066,5,41,88,1,'0.42',0),
 (16067,5,42,88,0,'0.00',0),
 (16068,5,45,88,0,'0.00',0),
 (16069,5,46,88,0,'0.00',0),
 (16070,5,47,88,0,'0.00',0),
 (16071,5,48,88,0,'0.00',0),
 (16072,5,51,88,1,'0.42',0),
 (16073,5,52,88,0,'0.00',0),
 (16074,5,53,88,0,'0.00',0),
 (16075,5,54,88,0,'0.00',0),
 (16076,5,1,89,1198,'57.54',0),
 (16077,5,2,89,758,'36.41',0),
 (16078,5,14,89,0,'0.00',0),
 (16079,5,15,89,1,'0.05',0),
 (16080,5,28,89,1,'0.05',0),
 (16081,5,32,89,0,'0.00',0),
 (16082,5,36,89,0,'0.00',0),
 (16083,5,38,89,69,'3.31',0),
 (16084,5,39,89,6,'0.29',0),
 (16085,5,40,89,1,'0.05',0),
 (16086,5,41,89,1,'0.05',0),
 (16087,5,42,89,0,'0.00',0),
 (16088,5,45,89,0,'0.00',0),
 (16089,5,46,89,0,'0.00',0),
 (16090,5,47,89,0,'0.00',0),
 (16091,5,48,89,0,'0.00',0),
 (16092,5,51,89,14,'0.67',0),
 (16093,5,52,89,0,'0.00',0),
 (16094,5,53,89,1,'0.05',0),
 (16095,5,54,89,3,'0.14',0),
 (16096,5,1,90,2050,'48.09',0),
 (16097,5,2,90,1612,'37.81',0),
 (16098,5,14,90,1,'0.02',0),
 (16099,5,15,90,2,'0.05',0),
 (16100,5,28,90,9,'0.21',0),
 (16101,5,32,90,1,'0.02',0),
 (16102,5,36,90,5,'0.12',0),
 (16103,5,38,90,283,'6.64',0),
 (16104,5,39,90,52,'1.22',0),
 (16105,5,40,90,3,'0.07',0),
 (16106,5,41,90,5,'0.12',0),
 (16107,5,42,90,4,'0.09',0),
 (16108,5,45,90,4,'0.09',0),
 (16109,5,46,90,0,'0.00',0),
 (16110,5,47,90,3,'0.07',0),
 (16111,5,48,90,32,'0.75',0),
 (16112,5,51,90,57,'1.34',0),
 (16113,5,52,90,1,'0.02',0),
 (16114,5,53,90,31,'0.73',0),
 (16115,5,54,90,7,'0.16',0),
 (16116,5,1,91,1494,'45.30',0),
 (16117,5,2,91,1380,'41.84',0),
 (16118,5,14,91,1,'0.03',0),
 (16119,5,15,91,2,'0.06',0),
 (16120,5,28,91,3,'0.09',0),
 (16121,5,32,91,2,'0.06',0),
 (16122,5,36,91,0,'0.00',0),
 (16123,5,38,91,351,'10.64',0),
 (16124,5,39,91,11,'0.33',0),
 (16125,5,40,91,1,'0.03',0),
 (16126,5,41,91,0,'0.00',0),
 (16127,5,42,91,2,'0.06',0),
 (16128,5,45,91,2,'0.06',0),
 (16129,5,46,91,2,'0.06',0),
 (16130,5,47,91,0,'0.00',0),
 (16131,5,48,91,0,'0.00',0),
 (16132,5,51,91,12,'0.36',0),
 (16133,5,52,91,0,'0.00',0),
 (16134,5,53,91,0,'0.00',0),
 (16135,5,54,91,0,'0.00',0),
 (16136,5,1,92,43549,'42.41',0),
 (16137,5,2,92,44940,'43.77',0),
 (16138,5,14,92,85,'0.08',0),
 (16139,5,15,92,148,'0.14',0),
 (16140,5,28,92,165,'0.16',0),
 (16141,5,32,92,34,'0.03',0),
 (16142,5,36,92,66,'0.06',0),
 (16143,5,38,92,7984,'7.78',0),
 (16144,5,39,92,1269,'1.24',0),
 (16145,5,40,92,51,'0.05',0),
 (16146,5,41,92,92,'0.09',0),
 (16147,5,42,92,97,'0.09',0),
 (16148,5,45,92,54,'0.05',0),
 (16149,5,46,92,104,'0.10',0),
 (16150,5,47,92,68,'0.07',0),
 (16151,5,48,92,35,'0.03',0),
 (16152,5,51,92,1651,'1.61',0),
 (16153,5,52,92,107,'0.10',0),
 (16154,5,53,92,181,'0.18',0),
 (16155,5,54,92,130,'0.13',0),
 (16156,5,1,93,786,'59.50',0),
 (16157,5,2,93,454,'34.37',0),
 (16158,5,14,93,1,'0.08',0),
 (16159,5,15,93,0,'0.00',0),
 (16160,5,28,93,1,'0.08',0),
 (16161,5,32,93,0,'0.00',0),
 (16162,5,36,93,1,'0.08',0),
 (16163,5,38,93,40,'3.03',0),
 (16164,5,39,93,9,'0.68',0),
 (16165,5,40,93,0,'0.00',0),
 (16166,5,41,93,0,'0.00',0),
 (16167,5,42,93,0,'0.00',0),
 (16168,5,45,93,0,'0.00',0),
 (16169,5,46,93,1,'0.08',0),
 (16170,5,47,93,0,'0.00',0),
 (16171,5,48,93,0,'0.00',0),
 (16172,5,51,93,7,'0.53',0),
 (16173,5,52,93,0,'0.00',0),
 (16174,5,53,93,0,'0.00',0),
 (16175,5,54,93,1,'0.08',0),
 (16176,5,1,94,242,'61.27',0),
 (16177,5,2,94,118,'29.87',0),
 (16178,5,14,94,0,'0.00',0),
 (16179,5,15,94,0,'0.00',0),
 (16180,5,28,94,0,'0.00',0),
 (16181,5,32,94,0,'0.00',0),
 (16182,5,36,94,1,'0.25',0),
 (16183,5,38,94,16,'4.05',0),
 (16184,5,39,94,7,'1.77',0),
 (16185,5,40,94,0,'0.00',0),
 (16186,5,41,94,1,'0.25',0),
 (16187,5,42,94,0,'0.00',0),
 (16188,5,45,94,0,'0.00',0),
 (16189,5,46,94,0,'0.00',0),
 (16190,5,47,94,0,'0.00',0),
 (16191,5,48,94,0,'0.00',0),
 (16192,5,51,94,2,'0.51',0),
 (16193,5,52,94,1,'0.25',0),
 (16194,5,53,94,3,'0.76',0),
 (16195,5,54,94,0,'0.00',0),
 (16196,5,1,95,410,'48.75',0),
 (16197,5,2,95,312,'37.10',0),
 (16198,5,14,95,1,'0.12',0),
 (16199,5,15,95,0,'0.00',0),
 (16200,5,28,95,1,'0.12',0),
 (16201,5,32,95,0,'0.00',0),
 (16202,5,36,95,1,'0.12',0),
 (16203,5,38,95,97,'11.53',0),
 (16204,5,39,95,8,'0.95',0),
 (16205,5,40,95,0,'0.00',0),
 (16206,5,41,95,0,'0.00',0),
 (16207,5,42,95,0,'0.00',0),
 (16208,5,45,95,0,'0.00',0),
 (16209,5,46,95,1,'0.12',0),
 (16210,5,47,95,0,'0.00',0),
 (16211,5,48,95,0,'0.00',0),
 (16212,5,51,95,3,'0.36',0),
 (16213,5,52,95,0,'0.00',0),
 (16214,5,53,95,0,'0.00',0),
 (16215,5,54,95,0,'0.00',0),
 (16216,5,1,96,4406,'55.57',0),
 (16217,5,2,96,2986,'37.66',0),
 (16218,5,14,96,3,'0.04',0),
 (16219,5,15,96,1,'0.01',0),
 (16220,5,28,96,7,'0.09',0),
 (16221,5,32,96,1,'0.01',0),
 (16222,5,36,96,1,'0.01',0),
 (16223,5,38,96,234,'2.95',0),
 (16224,5,39,96,66,'0.83',0),
 (16225,5,40,96,3,'0.04',0),
 (16226,5,41,96,4,'0.05',0),
 (16227,5,42,96,0,'0.00',0),
 (16228,5,45,96,1,'0.01',0),
 (16229,5,46,96,6,'0.08',0),
 (16230,5,47,96,1,'0.01',0),
 (16231,5,48,96,2,'0.03',0),
 (16232,5,51,96,78,'0.98',0),
 (16233,5,52,96,2,'0.03',0),
 (16234,5,53,96,15,'0.19',0),
 (16235,5,54,96,6,'0.08',0),
 (16236,5,1,97,23,'21.50',0),
 (16237,5,2,97,61,'57.01',0),
 (16238,5,14,97,0,'0.00',0),
 (16239,5,15,97,0,'0.00',0),
 (16240,5,28,97,0,'0.00',0),
 (16241,5,32,97,0,'0.00',0),
 (16242,5,36,97,0,'0.00',0),
 (16243,5,38,97,12,'11.21',0),
 (16244,5,39,97,2,'1.87',0),
 (16245,5,40,97,0,'0.00',0),
 (16246,5,41,97,0,'0.00',0),
 (16247,5,42,97,0,'0.00',0),
 (16248,5,45,97,1,'0.93',0),
 (16249,5,46,97,0,'0.00',0),
 (16250,5,47,97,0,'0.00',0),
 (16251,5,48,97,0,'0.00',0),
 (16252,5,51,97,2,'1.87',0),
 (16253,5,52,97,0,'0.00',0),
 (16254,5,53,97,0,'0.00',0),
 (16255,5,54,97,2,'1.87',0),
 (16256,5,1,99,662,'57.82',0),
 (16257,5,2,99,357,'31.18',0),
 (16258,5,14,99,1,'0.09',0),
 (16259,5,15,99,6,'0.52',0),
 (16260,5,28,99,3,'0.26',0),
 (16261,5,32,99,2,'0.17',0),
 (16262,5,36,99,0,'0.00',0),
 (16263,5,38,99,57,'4.98',0),
 (16264,5,39,99,13,'1.14',0),
 (16265,5,40,99,1,'0.09',0),
 (16266,5,41,99,2,'0.17',0),
 (16267,5,42,99,0,'0.00',0),
 (16268,5,45,99,4,'0.35',0),
 (16269,5,46,99,2,'0.17',0),
 (16270,5,47,99,2,'0.17',0),
 (16271,5,48,99,0,'0.00',0),
 (16272,5,51,99,7,'0.61',0),
 (16273,5,52,99,0,'0.00',0),
 (16274,5,53,99,8,'0.70',0),
 (16275,5,54,99,4,'0.35',0),
 (16276,5,1,100,928,'48.74',0),
 (16277,5,2,100,653,'34.30',0),
 (16278,5,14,100,4,'0.21',0),
 (16279,5,15,100,1,'0.05',0),
 (16280,5,28,100,4,'0.21',0),
 (16281,5,32,100,0,'0.00',0),
 (16282,5,36,100,0,'0.00',0),
 (16283,5,38,100,197,'10.35',0),
 (16284,5,39,100,42,'2.21',0),
 (16285,5,40,100,2,'0.11',0),
 (16286,5,41,100,2,'0.11',0),
 (16287,5,42,100,0,'0.00',0),
 (16288,5,45,100,1,'0.05',0),
 (16289,5,46,100,1,'0.05',0),
 (16290,5,47,100,0,'0.00',0),
 (16291,5,48,100,1,'0.05',0),
 (16292,5,51,100,22,'1.16',0),
 (16293,5,52,100,0,'0.00',0),
 (16294,5,53,100,2,'0.11',0),
 (16295,5,54,100,0,'0.00',0),
 (16296,5,1,101,65,'56.52',0),
 (16297,5,2,101,34,'29.57',0),
 (16298,5,14,101,0,'0.00',0),
 (16299,5,15,101,0,'0.00',0),
 (16300,5,28,101,0,'0.00',0),
 (16301,5,32,101,0,'0.00',0),
 (16302,5,36,101,0,'0.00',0),
 (16303,5,38,101,9,'7.83',0),
 (16304,5,39,101,2,'1.74',0),
 (16305,5,40,101,0,'0.00',0),
 (16306,5,41,101,0,'0.00',0),
 (16307,5,42,101,0,'0.00',0),
 (16308,5,45,101,0,'0.00',0),
 (16309,5,46,101,0,'0.00',0),
 (16310,5,47,101,0,'0.00',0),
 (16311,5,48,101,0,'0.00',0),
 (16312,5,51,101,0,'0.00',0),
 (16313,5,52,101,0,'0.00',0),
 (16314,5,53,101,0,'0.00',0),
 (16315,5,54,101,0,'0.00',0),
 (16316,5,1,102,154,'28.68',0),
 (16317,5,2,102,306,'56.98',0),
 (16318,5,14,102,0,'0.00',0),
 (16319,5,15,102,1,'0.19',0),
 (16320,5,28,102,0,'0.00',0),
 (16321,5,32,102,0,'0.00',0),
 (16322,5,36,102,0,'0.00',0),
 (16323,5,38,102,65,'12.10',0),
 (16324,5,39,102,2,'0.37',0),
 (16325,5,40,102,0,'0.00',0),
 (16326,5,41,102,2,'0.37',0),
 (16327,5,42,102,0,'0.00',0),
 (16328,5,45,102,0,'0.00',0),
 (16329,5,46,102,0,'0.00',0),
 (16330,5,47,102,0,'0.00',0),
 (16331,5,48,102,0,'0.00',0),
 (16332,5,51,102,4,'0.74',0),
 (16333,5,52,102,0,'0.00',0),
 (16334,5,53,102,0,'0.00',0),
 (16335,5,54,102,0,'0.00',0),
 (16336,5,1,104,1703,'46.45',0),
 (16337,5,2,104,1192,'32.52',0),
 (16338,5,14,104,4,'0.11',0),
 (16339,5,15,104,1,'0.03',0),
 (16340,5,28,104,2,'0.05',0),
 (16341,5,32,104,3,'0.08',0),
 (16342,5,36,104,15,'0.41',0),
 (16343,5,38,104,476,'12.98',0),
 (16344,5,39,104,67,'1.83',0),
 (16345,5,40,104,1,'0.03',0),
 (16346,5,41,104,3,'0.08',0),
 (16347,5,42,104,2,'0.05',0),
 (16348,5,45,104,13,'0.35',0),
 (16349,5,46,104,9,'0.25',0),
 (16350,5,47,104,5,'0.14',0),
 (16351,5,48,104,1,'0.03',0),
 (16352,5,51,104,44,'1.20',0),
 (16353,5,52,104,2,'0.05',0),
 (16354,5,53,104,31,'0.85',0),
 (16355,5,54,104,4,'0.11',0),
 (16356,5,1,106,10187,'25.49',0),
 (16357,5,2,106,25250,'63.18',0),
 (16358,5,14,106,20,'0.05',0),
 (16359,5,15,106,85,'0.21',0),
 (16360,5,28,106,65,'0.16',0),
 (16361,5,32,106,8,'0.02',0),
 (16362,5,36,106,17,'0.04',0),
 (16363,5,38,106,2897,'7.25',0),
 (16364,5,39,106,427,'1.07',0),
 (16365,5,40,106,13,'0.03',0),
 (16366,5,41,106,27,'0.07',0),
 (16367,5,42,106,29,'0.07',0),
 (16368,5,45,106,32,'0.08',0),
 (16369,5,46,106,28,'0.07',0),
 (16370,5,47,106,21,'0.05',0),
 (16371,5,48,106,19,'0.05',0),
 (16372,5,51,106,299,'0.75',0),
 (16373,5,52,106,10,'0.03',0),
 (16374,5,53,106,37,'0.09',0),
 (16375,5,54,106,36,'0.09',0),
 (16376,5,1,107,101,'36.20',0),
 (16377,5,2,107,159,'56.99',0),
 (16378,5,14,107,0,'0.00',0),
 (16379,5,15,107,0,'0.00',0),
 (16380,5,28,107,1,'0.36',0),
 (16381,5,32,107,0,'0.00',0),
 (16382,5,36,107,0,'0.00',0),
 (16383,5,38,107,7,'2.51',0),
 (16384,5,39,107,1,'0.36',0),
 (16385,5,40,107,0,'0.00',0),
 (16386,5,41,107,0,'0.00',0),
 (16387,5,42,107,0,'0.00',0),
 (16388,5,45,107,0,'0.00',0),
 (16389,5,46,107,0,'0.00',0),
 (16390,5,47,107,0,'0.00',0),
 (16391,5,48,107,0,'0.00',0),
 (16392,5,51,107,3,'1.08',0),
 (16393,5,52,107,0,'0.00',0),
 (16394,5,53,107,0,'0.00',0),
 (16395,5,54,107,1,'0.36',0),
 (16396,5,1,108,675,'58.39',0),
 (16397,5,2,108,354,'30.62',0),
 (16398,5,14,108,0,'0.00',0),
 (16399,5,15,108,0,'0.00',0),
 (16400,5,28,108,3,'0.26',0),
 (16401,5,32,108,0,'0.00',0),
 (16402,5,36,108,0,'0.00',0),
 (16403,5,38,108,49,'4.24',0),
 (16404,5,39,108,16,'1.38',0),
 (16405,5,40,108,0,'0.00',0),
 (16406,5,41,108,1,'0.09',0),
 (16407,5,42,108,0,'0.00',0),
 (16408,5,45,108,2,'0.17',0),
 (16409,5,46,108,1,'0.09',0),
 (16410,5,47,108,0,'0.00',0),
 (16411,5,48,108,0,'0.00',0),
 (16412,5,51,108,14,'1.21',0),
 (16413,5,52,108,0,'0.00',0),
 (16414,5,53,108,0,'0.00',0),
 (16415,5,54,108,2,'0.17',0),
 (16416,5,1,109,583,'63.58',0),
 (16417,5,2,109,240,'26.17',0),
 (16418,5,14,109,3,'0.33',0),
 (16419,5,15,109,2,'0.22',0),
 (16420,5,28,109,4,'0.44',0),
 (16421,5,32,109,0,'0.00',0),
 (16422,5,36,109,0,'0.00',0),
 (16423,5,38,109,52,'5.67',0),
 (16424,5,39,109,7,'0.76',0),
 (16425,5,40,109,1,'0.11',0),
 (16426,5,41,109,11,'1.20',0),
 (16427,5,42,109,1,'0.11',0),
 (16428,5,45,109,0,'0.00',0),
 (16429,5,46,109,0,'0.00',0),
 (16430,5,47,109,0,'0.00',0),
 (16431,5,48,109,0,'0.00',0),
 (16432,5,51,109,6,'0.65',0),
 (16433,5,52,109,0,'0.00',0),
 (16434,5,53,109,0,'0.00',0),
 (16435,5,54,109,1,'0.11',0),
 (16436,5,1,110,720,'49.01',0),
 (16437,5,2,110,695,'47.31',0),
 (16438,5,14,110,0,'0.00',0),
 (16439,5,15,110,1,'0.07',0),
 (16440,5,28,110,0,'0.00',0),
 (16441,5,32,110,0,'0.00',0),
 (16442,5,36,110,0,'0.00',0),
 (16443,5,38,110,29,'1.97',0),
 (16444,5,39,110,3,'0.20',0),
 (16445,5,40,110,0,'0.00',0),
 (16446,5,41,110,0,'0.00',0),
 (16447,5,42,110,0,'0.00',0),
 (16448,5,45,110,0,'0.00',0),
 (16449,5,46,110,0,'0.00',0),
 (16450,5,47,110,0,'0.00',0),
 (16451,5,48,110,3,'0.20',0),
 (16452,5,51,110,7,'0.48',0),
 (16453,5,52,110,0,'0.00',0),
 (16454,5,53,110,0,'0.00',0),
 (16455,5,54,110,2,'0.14',0),
 (16456,5,1,111,206,'54.64',0),
 (16457,5,2,111,140,'37.14',0),
 (16458,5,14,111,0,'0.00',0),
 (16459,5,15,111,0,'0.00',0),
 (16460,5,28,111,0,'0.00',0),
 (16461,5,32,111,0,'0.00',0),
 (16462,5,36,111,2,'0.53',0),
 (16463,5,38,111,22,'5.84',0),
 (16464,5,39,111,0,'0.00',0),
 (16465,5,40,111,0,'0.00',0),
 (16466,5,41,111,0,'0.00',0),
 (16467,5,42,111,0,'0.00',0),
 (16468,5,45,111,0,'0.00',0),
 (16469,5,46,111,0,'0.00',0),
 (16470,5,47,111,0,'0.00',0),
 (16471,5,48,111,0,'0.00',0),
 (16472,5,51,111,0,'0.00',0),
 (16473,5,52,111,0,'0.00',0),
 (16474,5,53,111,0,'0.00',0),
 (16475,5,54,111,1,'0.27',0),
 (16476,5,1,112,66,'50.77',0),
 (16477,5,2,112,55,'42.31',0),
 (16478,5,14,112,2,'1.54',0),
 (16479,5,15,112,0,'0.00',0),
 (16480,5,28,112,1,'0.77',0),
 (16481,5,32,112,0,'0.00',0),
 (16482,5,36,112,0,'0.00',0),
 (16483,5,38,112,3,'2.31',0),
 (16484,5,39,112,1,'0.77',0),
 (16485,5,40,112,0,'0.00',0),
 (16486,5,41,112,0,'0.00',0),
 (16487,5,42,112,0,'0.00',0),
 (16488,5,45,112,0,'0.00',0),
 (16489,5,46,112,0,'0.00',0),
 (16490,5,47,112,0,'0.00',0),
 (16491,5,48,112,0,'0.00',0),
 (16492,5,51,112,1,'0.77',0),
 (16493,5,52,112,0,'0.00',0),
 (16494,5,53,112,0,'0.00',0),
 (16495,5,54,112,0,'0.00',0),
 (16496,5,1,113,6278,'36.11',0),
 (16497,5,2,113,8607,'49.51',0),
 (16498,5,14,113,18,'0.10',0),
 (16499,5,15,113,25,'0.14',0),
 (16500,5,28,113,19,'0.11',0),
 (16501,5,32,113,7,'0.04',0),
 (16502,5,36,113,14,'0.08',0),
 (16503,5,38,113,1521,'8.75',0),
 (16504,5,39,113,318,'1.83',0),
 (16505,5,40,113,2,'0.01',0),
 (16506,5,41,113,9,'0.05',0),
 (16507,5,42,113,21,'0.12',0),
 (16508,5,45,113,4,'0.02',0),
 (16509,5,46,113,11,'0.06',0),
 (16510,5,47,113,5,'0.03',0),
 (16511,5,48,113,7,'0.04',0),
 (16512,5,51,113,172,'0.99',0),
 (16513,5,52,113,6,'0.03',0),
 (16514,5,53,113,17,'0.10',0),
 (16515,5,54,113,6,'0.03',0),
 (16516,5,1,114,96,'72.18',0),
 (16517,5,2,114,28,'21.05',0),
 (16518,5,14,114,0,'0.00',0),
 (16519,5,15,114,0,'0.00',0),
 (16520,5,28,114,0,'0.00',0),
 (16521,5,32,114,0,'0.00',0),
 (16522,5,36,114,0,'0.00',0),
 (16523,5,38,114,3,'2.26',0),
 (16524,5,39,114,2,'1.50',0),
 (16525,5,40,114,0,'0.00',0),
 (16526,5,41,114,0,'0.00',0),
 (16527,5,42,114,0,'0.00',0),
 (16528,5,45,114,0,'0.00',0),
 (16529,5,46,114,3,'2.26',0),
 (16530,5,47,114,0,'0.00',0),
 (16531,5,48,114,0,'0.00',0),
 (16532,5,51,114,0,'0.00',0),
 (16533,5,52,114,0,'0.00',0),
 (16534,5,53,114,0,'0.00',0),
 (16535,5,54,114,0,'0.00',0),
 (16536,5,1,115,24121,'61.87',0),
 (16537,5,2,115,10972,'28.14',0),
 (16538,5,14,115,21,'0.05',0),
 (16539,5,15,115,27,'0.07',0),
 (16540,5,28,115,45,'0.12',0),
 (16541,5,32,115,6,'0.02',0),
 (16542,5,36,115,17,'0.04',0),
 (16543,5,38,115,1368,'3.51',0),
 (16544,5,39,115,343,'0.88',0),
 (16545,5,40,115,16,'0.04',0),
 (16546,5,41,115,29,'0.07',0),
 (16547,5,42,115,24,'0.06',0),
 (16548,5,45,115,8,'0.02',0),
 (16549,5,46,115,159,'0.41',0),
 (16550,5,47,115,30,'0.08',0),
 (16551,5,48,115,141,'0.36',0),
 (16552,5,51,115,457,'1.17',0),
 (16553,5,52,115,7,'0.02',0),
 (16554,5,53,115,161,'0.41',0),
 (16555,5,54,115,25,'0.06',0),
 (16556,5,1,116,88,'49.16',0),
 (16557,5,2,116,82,'45.81',0),
 (16558,5,14,116,0,'0.00',0),
 (16559,5,15,116,0,'0.00',0),
 (16560,5,28,116,0,'0.00',0),
 (16561,5,32,116,0,'0.00',0),
 (16562,5,36,116,0,'0.00',0),
 (16563,5,38,116,8,'4.47',0),
 (16564,5,39,116,0,'0.00',0),
 (16565,5,40,116,0,'0.00',0),
 (16566,5,41,116,0,'0.00',0),
 (16567,5,42,116,0,'0.00',0),
 (16568,5,45,116,0,'0.00',0),
 (16569,5,46,116,0,'0.00',0),
 (16570,5,47,116,0,'0.00',0),
 (16571,5,48,116,0,'0.00',0),
 (16572,5,51,116,0,'0.00',0),
 (16573,5,52,116,0,'0.00',0),
 (16574,5,53,116,0,'0.00',0),
 (16575,5,54,116,1,'0.56',0),
 (16576,5,1,117,54,'65.06',0),
 (16577,5,2,117,22,'26.51',0),
 (16578,5,14,117,0,'0.00',0),
 (16579,5,15,117,0,'0.00',0),
 (16580,5,28,117,0,'0.00',0),
 (16581,5,32,117,0,'0.00',0),
 (16582,5,36,117,0,'0.00',0),
 (16583,5,38,117,5,'6.02',0),
 (16584,5,39,117,0,'0.00',0),
 (16585,5,40,117,0,'0.00',0),
 (16586,5,41,117,0,'0.00',0),
 (16587,5,42,117,0,'0.00',0),
 (16588,5,45,117,1,'1.20',0),
 (16589,5,46,117,0,'0.00',0),
 (16590,5,47,117,0,'0.00',0),
 (16591,5,48,117,0,'0.00',0),
 (16592,5,51,117,0,'0.00',0),
 (16593,5,52,117,0,'0.00',0),
 (16594,5,53,117,0,'0.00',0),
 (16595,5,54,117,0,'0.00',0),
 (16596,5,1,118,31,'39.24',0),
 (16597,5,2,118,32,'40.51',0),
 (16598,5,14,118,0,'0.00',0),
 (16599,5,15,118,1,'1.27',0),
 (16600,5,28,118,3,'3.80',0),
 (16601,5,32,118,0,'0.00',0),
 (16602,5,36,118,0,'0.00',0),
 (16603,5,38,118,7,'8.86',0),
 (16604,5,39,118,2,'2.53',0),
 (16605,5,40,118,0,'0.00',0),
 (16606,5,41,118,0,'0.00',0),
 (16607,5,42,118,0,'0.00',0),
 (16608,5,45,118,0,'0.00',0),
 (16609,5,46,118,0,'0.00',0),
 (16610,5,47,118,0,'0.00',0),
 (16611,5,48,118,0,'0.00',0),
 (16612,5,51,118,0,'0.00',0),
 (16613,5,52,118,0,'0.00',0),
 (16614,5,53,118,0,'0.00',0),
 (16615,5,54,118,1,'1.27',0),
 (16616,5,1,119,603,'62.94',0),
 (16617,5,2,119,277,'28.91',0),
 (16618,5,14,119,0,'0.00',0),
 (16619,5,15,119,0,'0.00',0),
 (16620,5,28,119,0,'0.00',0),
 (16621,5,32,119,0,'0.00',0),
 (16622,5,36,119,1,'0.10',0),
 (16623,5,38,119,49,'5.11',0),
 (16624,5,39,119,5,'0.52',0),
 (16625,5,40,119,0,'0.00',0),
 (16626,5,41,119,0,'0.00',0),
 (16627,5,42,119,0,'0.00',0),
 (16628,5,45,119,0,'0.00',0),
 (16629,5,46,119,1,'0.10',0),
 (16630,5,47,119,0,'0.00',0),
 (16631,5,48,119,0,'0.00',0),
 (16632,5,51,119,2,'0.21',0),
 (16633,5,52,119,0,'0.00',0),
 (16634,5,53,119,0,'0.00',0),
 (16635,5,54,119,0,'0.00',0),
 (16636,5,1,120,481,'47.16',0),
 (16637,5,2,120,469,'45.98',0),
 (16638,5,14,120,0,'0.00',0),
 (16639,5,15,120,1,'0.10',0),
 (16640,5,28,120,1,'0.10',0),
 (16641,5,32,120,0,'0.00',0),
 (16642,5,36,120,0,'0.00',0),
 (16643,5,38,120,39,'3.82',0),
 (16644,5,39,120,4,'0.39',0),
 (16645,5,40,120,0,'0.00',0),
 (16646,5,41,120,0,'0.00',0),
 (16647,5,42,120,1,'0.10',0),
 (16648,5,45,120,1,'0.10',0),
 (16649,5,46,120,0,'0.00',0),
 (16650,5,47,120,0,'0.00',0),
 (16651,5,48,120,0,'0.00',0),
 (16652,5,51,120,5,'0.49',0),
 (16653,5,52,120,1,'0.10',0),
 (16654,5,53,120,0,'0.00',0),
 (16655,5,54,120,0,'0.00',0),
 (16656,5,1,121,77,'44.51',0),
 (16657,5,2,121,82,'47.40',0),
 (16658,5,14,121,1,'0.58',0),
 (16659,5,15,121,0,'0.00',0),
 (16660,5,28,121,0,'0.00',0),
 (16661,5,32,121,0,'0.00',0),
 (16662,5,36,121,0,'0.00',0),
 (16663,5,38,121,6,'3.47',0),
 (16664,5,39,121,2,'1.16',0),
 (16665,5,40,121,0,'0.00',0),
 (16666,5,41,121,0,'0.00',0),
 (16667,5,42,121,0,'0.00',0),
 (16668,5,45,121,0,'0.00',0),
 (16669,5,46,121,1,'0.58',0),
 (16670,5,47,121,0,'0.00',0),
 (16671,5,48,121,0,'0.00',0),
 (16672,5,51,121,0,'0.00',0),
 (16673,5,52,121,0,'0.00',0),
 (16674,5,53,121,3,'1.73',0),
 (16675,5,54,121,0,'0.00',0),
 (16676,5,1,122,131,'49.81',0),
 (16677,5,2,122,107,'40.68',0),
 (16678,5,14,122,0,'0.00',0),
 (16679,5,15,122,0,'0.00',0),
 (16680,5,28,122,0,'0.00',0),
 (16681,5,32,122,0,'0.00',0),
 (16682,5,36,122,0,'0.00',0),
 (16683,5,38,122,14,'5.32',0),
 (16684,5,39,122,0,'0.00',0),
 (16685,5,40,122,0,'0.00',0),
 (16686,5,41,122,0,'0.00',0),
 (16687,5,42,122,0,'0.00',0),
 (16688,5,45,122,1,'0.38',0),
 (16689,5,46,122,0,'0.00',0),
 (16690,5,47,122,0,'0.00',0),
 (16691,5,48,122,0,'0.00',0),
 (16692,5,51,122,7,'2.66',0),
 (16693,5,52,122,0,'0.00',0),
 (16694,5,53,122,1,'0.38',0),
 (16695,5,54,122,0,'0.00',0),
 (16696,5,1,123,6112,'29.35',0),
 (16697,5,2,123,6659,'31.97',0),
 (16698,5,14,123,8,'0.04',0),
 (16699,5,15,123,12,'0.06',0),
 (16700,5,28,123,15,'0.07',0),
 (16701,5,32,123,2,'0.01',0),
 (16702,5,36,123,9,'0.04',0),
 (16703,5,38,123,7171,'34.43',0),
 (16704,5,39,123,181,'0.87',0),
 (16705,5,40,123,6,'0.03',0),
 (16706,5,41,123,8,'0.04',0),
 (16707,5,42,123,17,'0.08',0),
 (16708,5,45,123,5,'0.02',0),
 (16709,5,46,123,17,'0.08',0),
 (16710,5,47,123,7,'0.03',0),
 (16711,5,48,123,4,'0.02',0),
 (16712,5,51,123,204,'0.98',0),
 (16713,5,52,123,8,'0.04',0),
 (16714,5,53,123,48,'0.23',0),
 (16715,5,54,123,9,'0.04',0),
 (16716,5,1,124,58,'61.70',0),
 (16717,5,2,124,27,'28.72',0),
 (16718,5,14,124,0,'0.00',0),
 (16719,5,15,124,0,'0.00',0),
 (16720,5,28,124,0,'0.00',0),
 (16721,5,32,124,0,'0.00',0),
 (16722,5,36,124,0,'0.00',0),
 (16723,5,38,124,4,'4.26',0),
 (16724,5,39,124,0,'0.00',0),
 (16725,5,40,124,0,'0.00',0),
 (16726,5,41,124,0,'0.00',0),
 (16727,5,42,124,0,'0.00',0),
 (16728,5,45,124,0,'0.00',0),
 (16729,5,46,124,0,'0.00',0),
 (16730,5,47,124,0,'0.00',0),
 (16731,5,48,124,0,'0.00',0),
 (16732,5,51,124,1,'1.06',0),
 (16733,5,52,124,0,'0.00',0),
 (16734,5,53,124,0,'0.00',0),
 (16735,5,54,124,0,'0.00',0),
 (16736,5,1,125,1037,'62.58',0),
 (16737,5,2,125,478,'28.85',0),
 (16738,5,14,125,0,'0.00',0),
 (16739,5,15,125,0,'0.00',0),
 (16740,5,28,125,0,'0.00',0),
 (16741,5,32,125,0,'0.00',0),
 (16742,5,36,125,0,'0.00',0),
 (16743,5,38,125,71,'4.28',0),
 (16744,5,39,125,11,'0.66',0),
 (16745,5,40,125,1,'0.06',0),
 (16746,5,41,125,2,'0.12',0),
 (16747,5,42,125,0,'0.00',0),
 (16748,5,45,125,0,'0.00',0),
 (16749,5,46,125,0,'0.00',0),
 (16750,5,47,125,0,'0.00',0),
 (16751,5,48,125,17,'1.03',0),
 (16752,5,51,125,21,'1.27',0),
 (16753,5,52,125,0,'0.00',0),
 (16754,5,53,125,4,'0.24',0),
 (16755,5,54,125,1,'0.06',0),
 (16756,5,1,126,16,'23.53',0),
 (16757,5,2,126,49,'72.06',0),
 (16758,5,14,126,0,'0.00',0),
 (16759,5,15,126,0,'0.00',0),
 (16760,5,28,126,0,'0.00',0),
 (16761,5,32,126,0,'0.00',0),
 (16762,5,36,126,0,'0.00',0),
 (16763,5,38,126,1,'1.47',0),
 (16764,5,39,126,0,'0.00',0),
 (16765,5,40,126,0,'0.00',0),
 (16766,5,41,126,0,'0.00',0),
 (16767,5,42,126,0,'0.00',0),
 (16768,5,45,126,0,'0.00',0),
 (16769,5,46,126,0,'0.00',0),
 (16770,5,47,126,0,'0.00',0),
 (16771,5,48,126,0,'0.00',0),
 (16772,5,51,126,2,'2.94',0),
 (16773,5,52,126,0,'0.00',0),
 (16774,5,53,126,0,'0.00',0),
 (16775,5,54,126,0,'0.00',0),
 (16776,5,1,127,20452,'57.30',0),
 (16777,5,2,127,11222,'31.44',0),
 (16778,5,14,127,20,'0.06',0),
 (16779,5,15,127,20,'0.06',0),
 (16780,5,28,127,40,'0.11',0),
 (16781,5,32,127,12,'0.03',0),
 (16782,5,36,127,30,'0.08',0),
 (16783,5,38,127,1547,'4.33',0),
 (16784,5,39,127,525,'1.47',0),
 (16785,5,40,127,21,'0.06',0),
 (16786,5,41,127,13,'0.04',0),
 (16787,5,42,127,26,'0.07',0),
 (16788,5,45,127,8,'0.02',0),
 (16789,5,46,127,94,'0.26',0),
 (16790,5,47,127,25,'0.07',0),
 (16791,5,48,127,37,'0.10',0),
 (16792,5,51,127,414,'1.16',0),
 (16793,5,52,127,4,'0.01',0),
 (16794,5,53,127,200,'0.56',0),
 (16795,5,54,127,20,'0.06',0),
 (16796,5,1,128,129,'47.43',0),
 (16797,5,2,128,112,'41.18',0),
 (16798,5,14,128,0,'0.00',0),
 (16799,5,15,128,0,'0.00',0),
 (16800,5,28,128,0,'0.00',0),
 (16801,5,32,128,0,'0.00',0),
 (16802,5,36,128,0,'0.00',0),
 (16803,5,38,128,25,'9.19',0),
 (16804,5,39,128,1,'0.37',0),
 (16805,5,40,128,0,'0.00',0),
 (16806,5,41,128,2,'0.74',0),
 (16807,5,42,128,0,'0.00',0),
 (16808,5,45,128,0,'0.00',0),
 (16809,5,46,128,0,'0.00',0),
 (16810,5,47,128,0,'0.00',0),
 (16811,5,48,128,0,'0.00',0),
 (16812,5,51,128,1,'0.37',0),
 (16813,5,52,128,0,'0.00',0),
 (16814,5,53,128,0,'0.00',0),
 (16815,5,54,128,0,'0.00',0),
 (16816,5,1,129,1749,'49.91',0),
 (16817,5,2,129,1385,'39.53',0),
 (16818,5,14,129,1,'0.03',0),
 (16819,5,15,129,2,'0.06',0),
 (16820,5,28,129,4,'0.11',0),
 (16821,5,32,129,1,'0.03',0),
 (16822,5,36,129,1,'0.03',0),
 (16823,5,38,129,150,'4.28',0),
 (16824,5,39,129,42,'1.20',0),
 (16825,5,40,129,1,'0.03',0),
 (16826,5,41,129,0,'0.00',0),
 (16827,5,42,129,5,'0.14',0),
 (16828,5,45,129,2,'0.06',0),
 (16829,5,46,129,4,'0.11',0),
 (16830,5,47,129,5,'0.14',0),
 (16831,5,48,129,5,'0.14',0),
 (16832,5,51,129,47,'1.34',0),
 (16833,5,52,129,5,'0.14',0),
 (16834,5,53,129,10,'0.29',0),
 (16835,5,54,129,3,'0.09',0),
 (16836,5,1,130,6194,'33.59',0),
 (16837,5,2,130,7803,'42.32',0),
 (16838,5,14,130,12,'0.07',0),
 (16839,5,15,130,22,'0.12',0),
 (16840,5,28,130,21,'0.11',0),
 (16841,5,32,130,6,'0.03',0),
 (16842,5,36,130,35,'0.19',0),
 (16843,5,38,130,3461,'18.77',0),
 (16844,5,39,130,220,'1.19',0),
 (16845,5,40,130,15,'0.08',0),
 (16846,5,41,130,9,'0.05',0),
 (16847,5,42,130,13,'0.07',0),
 (16848,5,45,130,10,'0.05',0),
 (16849,5,46,130,16,'0.09',0),
 (16850,5,47,130,4,'0.02',0),
 (16851,5,48,130,6,'0.03',0),
 (16852,5,51,130,173,'0.94',0),
 (16853,5,52,130,9,'0.05',0),
 (16854,5,53,130,69,'0.37',0),
 (16855,5,54,130,18,'0.10',0),
 (16856,5,1,131,3884,'52.34',0),
 (16857,5,2,131,2660,'35.84',0),
 (16858,5,14,131,2,'0.03',0),
 (16859,5,15,131,6,'0.08',0),
 (16860,5,28,131,13,'0.18',0),
 (16861,5,32,131,4,'0.05',0),
 (16862,5,36,131,12,'0.16',0),
 (16863,5,38,131,378,'5.09',0),
 (16864,5,39,131,106,'1.43',0),
 (16865,5,40,131,5,'0.07',0),
 (16866,5,41,131,5,'0.07',0),
 (16867,5,42,131,5,'0.07',0),
 (16868,5,45,131,3,'0.04',0),
 (16869,5,46,131,7,'0.09',0),
 (16870,5,47,131,4,'0.05',0),
 (16871,5,48,131,5,'0.07',0),
 (16872,5,51,131,92,'1.24',0),
 (16873,5,52,131,6,'0.08',0),
 (16874,5,53,131,49,'0.66',0),
 (16875,5,54,131,8,'0.11',0),
 (16876,5,1,132,2712,'44.28',0),
 (16877,5,2,132,2659,'43.42',0),
 (16878,5,14,132,2,'0.03',0),
 (16879,5,15,132,5,'0.08',0),
 (16880,5,28,132,8,'0.13',0),
 (16881,5,32,132,1,'0.02',0),
 (16882,5,36,132,3,'0.05',0),
 (16883,5,38,132,549,'8.96',0),
 (16884,5,39,132,56,'0.91',0),
 (16885,5,40,132,1,'0.02',0),
 (16886,5,41,132,2,'0.03',0),
 (16887,5,42,132,3,'0.05',0),
 (16888,5,45,132,0,'0.00',0),
 (16889,5,46,132,1,'0.02',0),
 (16890,5,47,132,0,'0.00',0),
 (16891,5,48,132,2,'0.03',0),
 (16892,5,51,132,39,'0.64',0),
 (16893,5,52,132,3,'0.05',0),
 (16894,5,53,132,3,'0.05',0),
 (16895,5,54,132,3,'0.05',0),
 (16896,5,1,133,1787,'46.30',0),
 (16897,5,2,133,1794,'46.48',0),
 (16898,5,14,133,0,'0.00',0),
 (16899,5,15,133,1,'0.03',0),
 (16900,5,28,133,5,'0.13',0),
 (16901,5,32,133,1,'0.03',0),
 (16902,5,36,133,1,'0.03',0),
 (16903,5,38,133,178,'4.61',0),
 (16904,5,39,133,20,'0.52',0),
 (16905,5,40,133,1,'0.03',0),
 (16906,5,41,133,1,'0.03',0),
 (16907,5,42,133,2,'0.05',0),
 (16908,5,45,133,0,'0.00',0),
 (16909,5,46,133,3,'0.08',0),
 (16910,5,47,133,1,'0.03',0),
 (16911,5,48,133,1,'0.03',0),
 (16912,5,51,133,13,'0.34',0),
 (16913,5,52,133,0,'0.00',0),
 (16914,5,53,133,8,'0.21',0),
 (16915,5,54,133,3,'0.08',0),
 (16916,5,1,134,13081,'41.88',0),
 (16917,5,2,134,13316,'42.63',0),
 (16918,5,14,134,22,'0.07',0),
 (16919,5,15,134,37,'0.12',0),
 (16920,5,28,134,54,'0.17',0),
 (16921,5,32,134,3,'0.01',0),
 (16922,5,36,134,23,'0.07',0),
 (16923,5,38,134,2408,'7.71',0),
 (16924,5,39,134,418,'1.34',0),
 (16925,5,40,134,22,'0.07',0),
 (16926,5,41,134,23,'0.07',0),
 (16927,5,42,134,21,'0.07',0),
 (16928,5,45,134,21,'0.07',0),
 (16929,5,46,134,37,'0.12',0),
 (16930,5,47,134,24,'0.08',0),
 (16931,5,48,134,17,'0.05',0),
 (16932,5,51,134,974,'3.12',0),
 (16933,5,52,134,26,'0.08',0),
 (16934,5,53,134,32,'0.10',0),
 (16935,5,54,134,25,'0.08',0),
 (16936,5,1,135,336,'54.90',0),
 (16937,5,2,135,206,'33.66',0),
 (16938,5,14,135,0,'0.00',0),
 (16939,5,15,135,0,'0.00',0),
 (16940,5,28,135,0,'0.00',0),
 (16941,5,32,135,0,'0.00',0),
 (16942,5,36,135,0,'0.00',0),
 (16943,5,38,135,56,'9.15',0),
 (16944,5,39,135,2,'0.33',0),
 (16945,5,40,135,0,'0.00',0),
 (16946,5,41,135,0,'0.00',0),
 (16947,5,42,135,0,'0.00',0),
 (16948,5,45,135,0,'0.00',0),
 (16949,5,46,135,0,'0.00',0),
 (16950,5,47,135,1,'0.16',0),
 (16951,5,48,135,0,'0.00',0),
 (16952,5,51,135,2,'0.33',0),
 (16953,5,52,135,0,'0.00',0),
 (16954,5,53,135,2,'0.33',0),
 (16955,5,54,135,0,'0.00',0),
 (16956,5,1,136,235,'54.27',0),
 (16957,5,2,136,155,'35.80',0),
 (16958,5,14,136,0,'0.00',0),
 (16959,5,15,136,0,'0.00',0),
 (16960,5,28,136,2,'0.46',0),
 (16961,5,32,136,0,'0.00',0),
 (16962,5,36,136,13,'3.00',0),
 (16963,5,38,136,15,'3.46',0),
 (16964,5,39,136,1,'0.23',0),
 (16965,5,40,136,0,'0.00',0),
 (16966,5,41,136,0,'0.00',0),
 (16967,5,42,136,0,'0.00',0),
 (16968,5,45,136,0,'0.00',0),
 (16969,5,46,136,3,'0.69',0),
 (16970,5,47,136,0,'0.00',0),
 (16971,5,48,136,0,'0.00',0),
 (16972,5,51,136,1,'0.23',0),
 (16973,5,52,136,0,'0.00',0),
 (16974,5,53,136,0,'0.00',0),
 (16975,5,54,136,1,'0.23',0),
 (16976,5,1,137,460,'53.68',0),
 (16977,5,2,137,354,'41.31',0),
 (16978,5,14,137,0,'0.00',0),
 (16979,5,15,137,1,'0.12',0),
 (16980,5,28,137,1,'0.12',0),
 (16981,5,32,137,0,'0.00',0),
 (16982,5,36,137,10,'1.17',0),
 (16983,5,38,137,19,'2.22',0),
 (16984,5,39,137,3,'0.35',0),
 (16985,5,40,137,0,'0.00',0),
 (16986,5,41,137,1,'0.12',0),
 (16987,5,42,137,0,'0.00',0),
 (16988,5,45,137,0,'0.00',0),
 (16989,5,46,137,0,'0.00',0),
 (16990,5,47,137,0,'0.00',0),
 (16991,5,48,137,0,'0.00',0),
 (16992,5,51,137,3,'0.35',0),
 (16993,5,52,137,0,'0.00',0),
 (16994,5,53,137,1,'0.12',0),
 (16995,5,54,137,0,'0.00',0),
 (16996,5,1,138,60,'56.60',0),
 (16997,5,2,138,35,'33.02',0),
 (16998,5,14,138,0,'0.00',0),
 (16999,5,15,138,1,'0.94',0),
 (17000,5,28,138,0,'0.00',0),
 (17001,5,32,138,0,'0.00',0),
 (17002,5,36,138,0,'0.00',0),
 (17003,5,38,138,4,'3.77',0),
 (17004,5,39,138,1,'0.94',0),
 (17005,5,40,138,0,'0.00',0),
 (17006,5,41,138,0,'0.00',0),
 (17007,5,42,138,1,'0.94',0),
 (17008,5,45,138,0,'0.00',0),
 (17009,5,46,138,0,'0.00',0),
 (17010,5,47,138,0,'0.00',0),
 (17011,5,48,138,0,'0.00',0),
 (17012,5,51,138,2,'1.89',0),
 (17013,5,52,138,0,'0.00',0),
 (17014,5,53,138,2,'1.89',0),
 (17015,5,54,138,0,'0.00',0),
 (17016,5,1,140,668,'55.30',0),
 (17017,5,2,140,447,'37.00',0),
 (17018,5,14,140,0,'0.00',0),
 (17019,5,15,140,0,'0.00',0),
 (17020,5,28,140,2,'0.17',0),
 (17021,5,32,140,0,'0.00',0),
 (17022,5,36,140,0,'0.00',0),
 (17023,5,38,140,54,'4.47',0),
 (17024,5,39,140,7,'0.58',0),
 (17025,5,40,140,0,'0.00',0),
 (17026,5,41,140,1,'0.08',0),
 (17027,5,42,140,2,'0.17',0),
 (17028,5,45,140,0,'0.00',0),
 (17029,5,46,140,0,'0.00',0),
 (17030,5,47,140,0,'0.00',0),
 (17031,5,48,140,0,'0.00',0),
 (17032,5,51,140,14,'1.16',0),
 (17033,5,52,140,0,'0.00',0),
 (17034,5,53,140,0,'0.00',0),
 (17035,5,54,140,2,'0.17',0),
 (17036,5,1,141,1362,'55.10',0),
 (17037,5,2,141,827,'33.45',0),
 (17038,5,14,141,1,'0.04',0),
 (17039,5,15,141,0,'0.00',0),
 (17040,5,28,141,4,'0.16',0),
 (17041,5,32,141,0,'0.00',0),
 (17042,5,36,141,1,'0.04',0),
 (17043,5,38,141,113,'4.57',0),
 (17044,5,39,141,28,'1.13',0),
 (17045,5,40,141,1,'0.04',0),
 (17046,5,41,141,7,'0.28',0),
 (17047,5,42,141,1,'0.04',0),
 (17048,5,45,141,2,'0.08',0),
 (17049,5,46,141,1,'0.04',0),
 (17050,5,47,141,2,'0.08',0),
 (17051,5,48,141,1,'0.04',0),
 (17052,5,51,141,32,'1.29',0),
 (17053,5,52,141,3,'0.12',0),
 (17054,5,53,141,33,'1.33',0),
 (17055,5,54,141,2,'0.08',0),
 (17056,5,1,143,55,'59.78',0),
 (17057,5,2,143,33,'35.87',0),
 (17058,5,14,143,0,'0.00',0),
 (17059,5,15,143,0,'0.00',0),
 (17060,5,28,143,0,'0.00',0),
 (17061,5,32,143,0,'0.00',0),
 (17062,5,36,143,0,'0.00',0),
 (17063,5,38,143,2,'2.17',0),
 (17064,5,39,143,0,'0.00',0),
 (17065,5,40,143,0,'0.00',0),
 (17066,5,41,143,0,'0.00',0),
 (17067,5,42,143,0,'0.00',0),
 (17068,5,45,143,0,'0.00',0),
 (17069,5,46,143,1,'1.09',0),
 (17070,5,47,143,1,'1.09',0),
 (17071,5,48,143,0,'0.00',0),
 (17072,5,51,143,0,'0.00',0),
 (17073,5,52,143,0,'0.00',0),
 (17074,5,53,143,0,'0.00',0),
 (17075,5,54,143,0,'0.00',0),
 (17076,5,1,144,1824,'51.83',0),
 (17077,5,2,144,1234,'35.07',0),
 (17078,5,14,144,0,'0.00',0),
 (17079,5,15,144,1,'0.03',0),
 (17080,5,28,144,4,'0.11',0),
 (17081,5,32,144,0,'0.00',0),
 (17082,5,36,144,4,'0.11',0),
 (17083,5,38,144,175,'4.97',0),
 (17084,5,39,144,18,'0.51',0),
 (17085,5,40,144,0,'0.00',0),
 (17086,5,41,144,4,'0.11',0),
 (17087,5,42,144,3,'0.09',0),
 (17088,5,45,144,3,'0.09',0),
 (17089,5,46,144,6,'0.17',0),
 (17090,5,47,144,0,'0.00',0),
 (17091,5,48,144,43,'1.22',0),
 (17092,5,51,144,104,'2.96',0),
 (17093,5,52,144,1,'0.03',0),
 (17094,5,53,144,32,'0.91',0),
 (17095,5,54,144,4,'0.11',0),
 (17096,5,1,145,338,'37.35',0),
 (17097,5,2,145,443,'48.95',0),
 (17098,5,14,145,1,'0.11',0),
 (17099,5,15,145,1,'0.11',0),
 (17100,5,28,145,0,'0.00',0),
 (17101,5,32,145,1,'0.11',0),
 (17102,5,36,145,0,'0.00',0),
 (17103,5,38,145,76,'8.40',0),
 (17104,5,39,145,4,'0.44',0),
 (17105,5,40,145,0,'0.00',0),
 (17106,5,41,145,1,'0.11',0),
 (17107,5,42,145,0,'0.00',0),
 (17108,5,45,145,6,'0.66',0),
 (17109,5,46,145,2,'0.22',0),
 (17110,5,47,145,2,'0.22',0),
 (17111,5,48,145,0,'0.00',0),
 (17112,5,51,145,12,'1.33',0),
 (17113,5,52,145,0,'0.00',0),
 (17114,5,53,145,0,'0.00',0),
 (17115,5,54,145,1,'0.11',0),
 (17116,5,1,146,694,'57.88',0),
 (17117,5,2,146,436,'36.36',0),
 (17118,5,14,146,0,'0.00',0),
 (17119,5,15,146,0,'0.00',0),
 (17120,5,28,146,2,'0.17',0),
 (17121,5,32,146,0,'0.00',0),
 (17122,5,36,146,1,'0.08',0),
 (17123,5,38,146,51,'4.25',0),
 (17124,5,39,146,1,'0.08',0),
 (17125,5,40,146,0,'0.00',0),
 (17126,5,41,146,0,'0.00',0),
 (17127,5,42,146,1,'0.08',0),
 (17128,5,45,146,1,'0.08',0),
 (17129,5,46,146,0,'0.00',0),
 (17130,5,47,146,0,'0.00',0),
 (17131,5,48,146,0,'0.00',0),
 (17132,5,51,146,3,'0.25',0),
 (17133,5,52,146,0,'0.00',0),
 (17134,5,53,146,0,'0.00',0),
 (17135,5,54,146,0,'0.00',0),
 (17136,5,1,147,319,'53.43',0),
 (17137,5,2,147,242,'40.54',0),
 (17138,5,14,147,0,'0.00',0),
 (17139,5,15,147,0,'0.00',0),
 (17140,5,28,147,0,'0.00',0),
 (17141,5,32,147,0,'0.00',0),
 (17142,5,36,147,0,'0.00',0),
 (17143,5,38,147,27,'4.52',0),
 (17144,5,39,147,2,'0.34',0),
 (17145,5,40,147,0,'0.00',0),
 (17146,5,41,147,0,'0.00',0),
 (17147,5,42,147,0,'0.00',0),
 (17148,5,45,147,0,'0.00',0),
 (17149,5,46,147,0,'0.00',0),
 (17150,5,47,147,1,'0.17',0),
 (17151,5,48,147,0,'0.00',0),
 (17152,5,51,147,1,'0.17',0),
 (17153,5,52,147,0,'0.00',0),
 (17154,5,53,147,0,'0.00',0),
 (17155,5,54,147,1,'0.17',0),
 (17156,5,1,148,18546,'37.99',0),
 (17157,5,2,148,21481,'44.01',0),
 (17158,5,14,148,20,'0.04',0),
 (17159,5,15,148,59,'0.12',0),
 (17160,5,28,148,69,'0.14',0),
 (17161,5,32,148,1253,'2.57',0),
 (17162,5,36,148,299,'0.61',0),
 (17163,5,38,148,3828,'7.84',0),
 (17164,5,39,148,542,'1.11',0),
 (17165,5,40,148,23,'0.05',0),
 (17166,5,41,148,35,'0.07',0),
 (17167,5,42,148,25,'0.05',0),
 (17168,5,45,148,26,'0.05',0),
 (17169,5,46,148,33,'0.07',0),
 (17170,5,47,148,22,'0.05',0),
 (17171,5,48,148,951,'1.95',0),
 (17172,5,51,148,696,'1.43',0),
 (17173,5,52,148,30,'0.06',0),
 (17174,5,53,148,82,'0.17',0),
 (17175,5,54,148,47,'0.10',0),
 (17176,5,1,149,1236,'47.23',0),
 (17177,5,2,149,1064,'40.66',0),
 (17178,5,14,149,1,'0.04',0),
 (17179,5,15,149,3,'0.11',0),
 (17180,5,28,149,9,'0.34',0),
 (17181,5,32,149,3,'0.11',0),
 (17182,5,36,149,4,'0.15',0),
 (17183,5,38,149,158,'6.04',0),
 (17184,5,39,149,46,'1.76',0),
 (17185,5,40,149,2,'0.08',0),
 (17186,5,41,149,0,'0.00',0),
 (17187,5,42,149,0,'0.00',0),
 (17188,5,45,149,1,'0.04',0),
 (17189,5,46,149,1,'0.04',0),
 (17190,5,47,149,1,'0.04',0),
 (17191,5,48,149,2,'0.08',0),
 (17192,5,51,149,25,'0.96',0),
 (17193,5,52,149,1,'0.04',0),
 (17194,5,53,149,3,'0.11',0),
 (17195,5,54,149,6,'0.23',0),
 (17196,5,1,150,852,'50.18',0),
 (17197,5,2,150,616,'36.28',0),
 (17198,5,14,150,0,'0.00',0),
 (17199,5,15,150,3,'0.18',0),
 (17200,5,28,150,5,'0.29',0),
 (17201,5,32,150,0,'0.00',0),
 (17202,5,36,150,0,'0.00',0),
 (17203,5,38,150,147,'8.66',0),
 (17204,5,39,150,6,'0.35',0),
 (17205,5,40,150,0,'0.00',0),
 (17206,5,41,150,0,'0.00',0),
 (17207,5,42,150,0,'0.00',0),
 (17208,5,45,150,3,'0.18',0),
 (17209,5,46,150,2,'0.12',0),
 (17210,5,47,150,0,'0.00',0),
 (17211,5,48,150,0,'0.00',0),
 (17212,5,51,150,4,'0.24',0),
 (17213,5,52,150,0,'0.00',0),
 (17214,5,53,150,43,'2.53',0),
 (17215,5,54,150,0,'0.00',0),
 (17216,5,1,151,880,'47.16',0),
 (17217,5,2,151,825,'44.21',0),
 (17218,5,14,151,0,'0.00',0),
 (17219,5,15,151,3,'0.16',0),
 (17220,5,28,151,1,'0.05',0),
 (17221,5,32,151,0,'0.00',0),
 (17222,5,36,151,3,'0.16',0),
 (17223,5,38,151,90,'4.82',0),
 (17224,5,39,151,10,'0.54',0),
 (17225,5,40,151,1,'0.05',0),
 (17226,5,41,151,2,'0.11',0),
 (17227,5,42,151,0,'0.00',0),
 (17228,5,45,151,8,'0.43',0),
 (17229,5,46,151,1,'0.05',0),
 (17230,5,47,151,2,'0.11',0),
 (17231,5,48,151,1,'0.05',0),
 (17232,5,51,151,19,'1.02',0),
 (17233,5,52,151,4,'0.21',0),
 (17234,5,53,151,2,'0.11',0),
 (17235,5,54,151,1,'0.05',0),
 (17236,5,1,152,5192,'58.69',0),
 (17237,5,2,152,2522,'28.51',0),
 (17238,5,14,152,1,'0.01',0),
 (17239,5,15,152,6,'0.07',0),
 (17240,5,28,152,13,'0.15',0),
 (17241,5,32,152,2,'0.02',0),
 (17242,5,36,152,7,'0.08',0),
 (17243,5,38,152,574,'6.49',0),
 (17244,5,39,152,99,'1.12',0),
 (17245,5,40,152,2,'0.02',0),
 (17246,5,41,152,4,'0.05',0),
 (17247,5,42,152,8,'0.09',0),
 (17248,5,45,152,5,'0.06',0),
 (17249,5,46,152,18,'0.20',0),
 (17250,5,47,152,5,'0.06',0),
 (17251,5,48,152,4,'0.05',0),
 (17252,5,51,152,103,'1.16',0),
 (17253,5,52,152,1,'0.01',0),
 (17254,5,53,152,61,'0.69',0),
 (17255,5,54,152,3,'0.03',0),
 (17256,5,1,153,134,'46.05',0),
 (17257,5,2,153,107,'36.77',0),
 (17258,5,14,153,0,'0.00',0),
 (17259,5,15,153,0,'0.00',0),
 (17260,5,28,153,1,'0.34',0),
 (17261,5,32,153,0,'0.00',0),
 (17262,5,36,153,0,'0.00',0),
 (17263,5,38,153,34,'11.68',0),
 (17264,5,39,153,3,'1.03',0),
 (17265,5,40,153,1,'0.34',0),
 (17266,5,41,153,0,'0.00',0),
 (17267,5,42,153,1,'0.34',0),
 (17268,5,45,153,0,'0.00',0),
 (17269,5,46,153,1,'0.34',0),
 (17270,5,47,153,0,'0.00',0),
 (17271,5,48,153,0,'0.00',0),
 (17272,5,51,153,1,'0.34',0),
 (17273,5,52,153,0,'0.00',0),
 (17274,5,53,153,0,'0.00',0),
 (17275,5,54,153,1,'0.34',0),
 (17276,5,1,154,1381,'45.10',0),
 (17277,5,2,154,1458,'47.62',0),
 (17278,5,14,154,1,'0.03',0),
 (17279,5,15,154,6,'0.20',0),
 (17280,5,28,154,0,'0.00',0),
 (17281,5,32,154,0,'0.00',0),
 (17282,5,36,154,2,'0.07',0),
 (17283,5,38,154,111,'3.63',0),
 (17284,5,39,154,18,'0.59',0),
 (17285,5,40,154,1,'0.03',0),
 (17286,5,41,154,1,'0.03',0),
 (17287,5,42,154,0,'0.00',0),
 (17288,5,45,154,1,'0.03',0),
 (17289,5,46,154,1,'0.03',0),
 (17290,5,47,154,2,'0.07',0),
 (17291,5,48,154,0,'0.00',0),
 (17292,5,51,154,22,'0.72',0),
 (17293,5,52,154,0,'0.00',0),
 (17294,5,53,154,3,'0.10',0),
 (17295,5,54,154,2,'0.07',0),
 (17296,5,1,155,179,'40.13',0),
 (17297,5,2,155,258,'57.85',0),
 (17298,5,14,155,0,'0.00',0),
 (17299,5,15,155,1,'0.22',0),
 (17300,5,28,155,0,'0.00',0),
 (17301,5,32,155,0,'0.00',0),
 (17302,5,36,155,0,'0.00',0),
 (17303,5,38,155,6,'1.35',0),
 (17304,5,39,155,0,'0.00',0),
 (17305,5,40,155,0,'0.00',0),
 (17306,5,41,155,0,'0.00',0),
 (17307,5,42,155,0,'0.00',0),
 (17308,5,45,155,0,'0.00',0),
 (17309,5,46,155,0,'0.00',0),
 (17310,5,47,155,1,'0.22',0),
 (17311,5,48,155,0,'0.00',0),
 (17312,5,51,155,0,'0.00',0),
 (17313,5,52,155,0,'0.00',0),
 (17314,5,53,155,0,'0.00',0),
 (17315,5,54,155,0,'0.00',0),
 (17316,5,1,156,221,'44.74',0),
 (17317,5,2,156,234,'47.37',0),
 (17318,5,14,156,0,'0.00',0),
 (17319,5,15,156,1,'0.20',0),
 (17320,5,28,156,0,'0.00',0),
 (17321,5,32,156,0,'0.00',0),
 (17322,5,36,156,1,'0.20',0),
 (17323,5,38,156,23,'4.66',0),
 (17324,5,39,156,6,'1.21',0),
 (17325,5,40,156,0,'0.00',0),
 (17326,5,41,156,1,'0.20',0),
 (17327,5,42,156,0,'0.00',0),
 (17328,5,45,156,0,'0.00',0),
 (17329,5,46,156,0,'0.00',0),
 (17330,5,47,156,0,'0.00',0),
 (17331,5,48,156,0,'0.00',0),
 (17332,5,51,156,3,'0.61',0),
 (17333,5,52,156,0,'0.00',0),
 (17334,5,53,156,0,'0.00',0),
 (17335,5,54,156,0,'0.00',0),
 (17336,5,1,157,256,'60.38',0),
 (17337,5,2,157,141,'33.25',0),
 (17338,5,14,157,0,'0.00',0),
 (17339,5,15,157,0,'0.00',0),
 (17340,5,28,157,0,'0.00',0),
 (17341,5,32,157,0,'0.00',0),
 (17342,5,36,157,0,'0.00',0),
 (17343,5,38,157,10,'2.36',0),
 (17344,5,39,157,2,'0.47',0),
 (17345,5,40,157,0,'0.00',0),
 (17346,5,41,157,1,'0.24',0),
 (17347,5,42,157,1,'0.24',0),
 (17348,5,45,157,0,'0.00',0),
 (17349,5,46,157,0,'0.00',0),
 (17350,5,47,157,0,'0.00',0),
 (17351,5,48,157,0,'0.00',0),
 (17352,5,51,157,4,'0.94',0),
 (17353,5,52,157,2,'0.47',0),
 (17354,5,53,157,1,'0.24',0),
 (17355,5,54,157,0,'0.00',0),
 (17356,5,1,158,271,'62.01',0),
 (17357,5,2,158,143,'32.72',0),
 (17358,5,14,158,0,'0.00',0),
 (17359,5,15,158,0,'0.00',0),
 (17360,5,28,158,1,'0.23',0),
 (17361,5,32,158,0,'0.00',0),
 (17362,5,36,158,0,'0.00',0),
 (17363,5,38,158,9,'2.06',0),
 (17364,5,39,158,0,'0.00',0),
 (17365,5,40,158,0,'0.00',0),
 (17366,5,41,158,0,'0.00',0),
 (17367,5,42,158,0,'0.00',0),
 (17368,5,45,158,0,'0.00',0),
 (17369,5,46,158,0,'0.00',0),
 (17370,5,47,158,0,'0.00',0),
 (17371,5,48,158,1,'0.23',0),
 (17372,5,51,158,0,'0.00',0),
 (17373,5,52,158,0,'0.00',0),
 (17374,5,53,158,0,'0.00',0),
 (17375,5,54,158,3,'0.69',0),
 (17376,5,1,159,193,'41.96',0),
 (17377,5,2,159,242,'52.61',0),
 (17378,5,14,159,0,'0.00',0),
 (17379,5,15,159,0,'0.00',0),
 (17380,5,28,159,0,'0.00',0),
 (17381,5,32,159,0,'0.00',0),
 (17382,5,36,159,0,'0.00',0),
 (17383,5,38,159,15,'3.26',0),
 (17384,5,39,159,1,'0.22',0),
 (17385,5,40,159,0,'0.00',0),
 (17386,5,41,159,0,'0.00',0),
 (17387,5,42,159,0,'0.00',0),
 (17388,5,45,159,0,'0.00',0),
 (17389,5,46,159,0,'0.00',0),
 (17390,5,47,159,0,'0.00',0),
 (17391,5,48,159,1,'0.22',0),
 (17392,5,51,159,4,'0.87',0),
 (17393,5,52,159,0,'0.00',0),
 (17394,5,53,159,0,'0.00',0),
 (17395,5,54,159,0,'0.00',0),
 (17396,5,1,160,2051,'51.87',0),
 (17397,5,2,160,1425,'36.04',0),
 (17398,5,14,160,4,'0.10',0),
 (17399,5,15,160,1,'0.03',0),
 (17400,5,28,160,5,'0.13',0),
 (17401,5,32,160,0,'0.00',0),
 (17402,5,36,160,12,'0.30',0),
 (17403,5,38,160,195,'4.93',0),
 (17404,5,39,160,40,'1.01',0),
 (17405,5,40,160,2,'0.05',0),
 (17406,5,41,160,3,'0.08',0),
 (17407,5,42,160,4,'0.10',0),
 (17408,5,45,160,4,'0.10',0),
 (17409,5,46,160,3,'0.08',0),
 (17410,5,47,160,6,'0.15',0),
 (17411,5,48,160,9,'0.23',0),
 (17412,5,51,160,68,'1.72',0),
 (17413,5,52,160,2,'0.05',0),
 (17414,5,53,160,14,'0.35',0),
 (17415,5,54,160,7,'0.18',0),
 (17416,5,1,161,10029,'53.46',0),
 (17417,5,2,161,6620,'35.29',0),
 (17418,5,14,161,8,'0.04',0),
 (17419,5,15,161,18,'0.10',0),
 (17420,5,28,161,26,'0.14',0),
 (17421,5,32,161,3,'0.02',0),
 (17422,5,36,161,15,'0.08',0),
 (17423,5,38,161,1076,'5.74',0),
 (17424,5,39,161,156,'0.83',0),
 (17425,5,40,161,13,'0.07',0),
 (17426,5,41,161,10,'0.05',0),
 (17427,5,42,161,9,'0.05',0),
 (17428,5,45,161,9,'0.05',0),
 (17429,5,46,161,13,'0.07',0),
 (17430,5,47,161,13,'0.07',0),
 (17431,5,48,161,11,'0.06',0),
 (17432,5,51,161,337,'1.80',0),
 (17433,5,52,161,3,'0.02',0),
 (17434,5,53,161,30,'0.16',0),
 (17435,5,54,161,15,'0.08',0),
 (17436,5,1,162,647,'56.80',0),
 (17437,5,2,162,379,'33.27',0),
 (17438,5,14,162,1,'0.09',0),
 (17439,5,15,162,1,'0.09',0),
 (17440,5,28,162,1,'0.09',0),
 (17441,5,32,162,0,'0.00',0),
 (17442,5,36,162,1,'0.09',0),
 (17443,5,38,162,41,'3.60',0),
 (17444,5,39,162,11,'0.97',0),
 (17445,5,40,162,0,'0.00',0),
 (17446,5,41,162,0,'0.00',0),
 (17447,5,42,162,1,'0.09',0),
 (17448,5,45,162,4,'0.35',0),
 (17449,5,46,162,0,'0.00',0),
 (17450,5,47,162,1,'0.09',0),
 (17451,5,48,162,1,'0.09',0),
 (17452,5,51,162,18,'1.58',0),
 (17453,5,52,162,1,'0.09',0),
 (17454,5,53,162,3,'0.26',0),
 (17455,5,54,162,1,'0.09',0),
 (17456,5,1,163,104,'48.15',0),
 (17457,5,2,163,85,'39.35',0),
 (17458,5,14,163,0,'0.00',0),
 (17459,5,15,163,0,'0.00',0),
 (17460,5,28,163,0,'0.00',0),
 (17461,5,32,163,0,'0.00',0),
 (17462,5,36,163,0,'0.00',0),
 (17463,5,38,163,12,'5.56',0),
 (17464,5,39,163,1,'0.46',0),
 (17465,5,40,163,0,'0.00',0),
 (17466,5,41,163,0,'0.00',0),
 (17467,5,42,163,0,'0.00',0),
 (17468,5,45,163,1,'0.46',0),
 (17469,5,46,163,0,'0.00',0),
 (17470,5,47,163,0,'0.00',0),
 (17471,5,48,163,0,'0.00',0),
 (17472,5,51,163,1,'0.46',0),
 (17473,5,52,163,0,'0.00',0),
 (17474,5,53,163,1,'0.46',0),
 (17475,5,54,163,2,'0.93',0),
 (17476,5,1,164,688,'47.68',0),
 (17477,5,2,164,564,'39.09',0),
 (17478,5,14,164,1,'0.07',0),
 (17479,5,15,164,2,'0.14',0),
 (17480,5,28,164,0,'0.00',0),
 (17481,5,32,164,1,'0.07',0),
 (17482,5,36,164,3,'0.21',0),
 (17483,5,38,164,85,'5.89',0),
 (17484,5,39,164,8,'0.55',0),
 (17485,5,40,164,0,'0.00',0),
 (17486,5,41,164,1,'0.07',0),
 (17487,5,42,164,0,'0.00',0),
 (17488,5,45,164,0,'0.00',0),
 (17489,5,46,164,1,'0.07',0),
 (17490,5,47,164,1,'0.07',0),
 (17491,5,48,164,0,'0.00',0),
 (17492,5,51,164,49,'3.40',0),
 (17493,5,52,164,0,'0.00',0),
 (17494,5,53,164,1,'0.07',0),
 (17495,5,54,164,4,'0.28',0),
 (17496,5,1,165,722,'57.21',0),
 (17497,5,2,165,507,'40.17',0),
 (17498,5,14,165,0,'0.00',0),
 (17499,5,15,165,0,'0.00',0),
 (17500,5,28,165,0,'0.00',0),
 (17501,5,32,165,0,'0.00',0),
 (17502,5,36,165,0,'0.00',0),
 (17503,5,38,165,16,'1.27',0),
 (17504,5,39,165,1,'0.08',0),
 (17505,5,40,165,0,'0.00',0),
 (17506,5,41,165,0,'0.00',0),
 (17507,5,42,165,0,'0.00',0),
 (17508,5,45,165,1,'0.08',0),
 (17509,5,46,165,0,'0.00',0),
 (17510,5,47,165,0,'0.00',0),
 (17511,5,48,165,0,'0.00',0),
 (17512,5,51,165,4,'0.32',0),
 (17513,5,52,165,0,'0.00',0),
 (17514,5,53,165,0,'0.00',0),
 (17515,5,54,165,0,'0.00',0),
 (17516,5,1,166,115,'49.36',0),
 (17517,5,2,166,104,'44.64',0),
 (17518,5,14,166,0,'0.00',0),
 (17519,5,15,166,0,'0.00',0),
 (17520,5,28,166,0,'0.00',0),
 (17521,5,32,166,0,'0.00',0),
 (17522,5,36,166,0,'0.00',0),
 (17523,5,38,166,11,'4.72',0),
 (17524,5,39,166,0,'0.00',0),
 (17525,5,40,166,0,'0.00',0),
 (17526,5,41,166,0,'0.00',0),
 (17527,5,42,166,0,'0.00',0),
 (17528,5,45,166,1,'0.43',0),
 (17529,5,46,166,0,'0.00',0),
 (17530,5,47,166,0,'0.00',0),
 (17531,5,48,166,0,'0.00',0),
 (17532,5,51,166,1,'0.43',0),
 (17533,5,52,166,0,'0.00',0),
 (17534,5,53,166,0,'0.00',0),
 (17535,5,54,166,0,'0.00',0),
 (17536,5,1,167,1746,'38.37',0),
 (17537,5,2,167,2097,'46.08',0),
 (17538,5,14,167,4,'0.09',0),
 (17539,5,15,167,0,'0.00',0),
 (17540,5,28,167,1,'0.02',0),
 (17541,5,32,167,0,'0.00',0),
 (17542,5,36,167,5,'0.11',0),
 (17543,5,38,167,524,'11.51',0),
 (17544,5,39,167,37,'0.81',0),
 (17545,5,40,167,0,'0.00',0),
 (17546,5,41,167,0,'0.00',0),
 (17547,5,42,167,3,'0.07',0),
 (17548,5,45,167,1,'0.02',0),
 (17549,5,46,167,4,'0.09',0),
 (17550,5,47,167,1,'0.02',0),
 (17551,5,48,167,2,'0.04',0),
 (17552,5,51,167,44,'0.97',0),
 (17553,5,52,167,3,'0.07',0),
 (17554,5,53,167,9,'0.20',0),
 (17555,5,54,167,3,'0.07',0),
 (17556,5,1,168,420,'57.69',0),
 (17557,5,2,168,280,'38.46',0),
 (17558,5,14,168,0,'0.00',0),
 (17559,5,15,168,0,'0.00',0),
 (17560,5,28,168,0,'0.00',0),
 (17561,5,32,168,0,'0.00',0),
 (17562,5,36,168,0,'0.00',0),
 (17563,5,38,168,16,'2.20',0),
 (17564,5,39,168,2,'0.27',0),
 (17565,5,40,168,0,'0.00',0),
 (17566,5,41,168,0,'0.00',0),
 (17567,5,42,168,0,'0.00',0),
 (17568,5,45,168,0,'0.00',0),
 (17569,5,46,168,0,'0.00',0),
 (17570,5,47,168,0,'0.00',0),
 (17571,5,48,168,1,'0.14',0),
 (17572,5,51,168,2,'0.27',0),
 (17573,5,52,168,0,'0.00',0),
 (17574,5,53,168,2,'0.27',0),
 (17575,5,54,168,0,'0.00',0),
 (17576,5,1,169,332,'57.04',0),
 (17577,5,2,169,188,'32.30',0),
 (17578,5,14,169,0,'0.00',0),
 (17579,5,15,169,0,'0.00',0),
 (17580,5,28,169,1,'0.17',0),
 (17581,5,32,169,0,'0.00',0),
 (17582,5,36,169,0,'0.00',0),
 (17583,5,38,169,30,'5.15',0),
 (17584,5,39,169,5,'0.86',0),
 (17585,5,40,169,0,'0.00',0),
 (17586,5,41,169,1,'0.17',0),
 (17587,5,42,169,1,'0.17',0),
 (17588,5,45,169,1,'0.17',0),
 (17589,5,46,169,0,'0.00',0),
 (17590,5,47,169,0,'0.00',0),
 (17591,5,48,169,0,'0.00',0),
 (17592,5,51,169,8,'1.37',0),
 (17593,5,52,169,0,'0.00',0),
 (17594,5,53,169,0,'0.00',0),
 (17595,5,54,169,0,'0.00',0),
 (17596,5,1,170,538,'32.35',0),
 (17597,5,2,170,739,'44.44',0),
 (17598,5,14,170,0,'0.00',0),
 (17599,5,15,170,2,'0.12',0),
 (17600,5,28,170,1,'0.06',0),
 (17601,5,32,170,0,'0.00',0),
 (17602,5,36,170,2,'0.12',0),
 (17603,5,38,170,338,'20.32',0),
 (17604,5,39,170,10,'0.60',0),
 (17605,5,40,170,0,'0.00',0),
 (17606,5,41,170,1,'0.06',0),
 (17607,5,42,170,1,'0.06',0),
 (17608,5,45,170,0,'0.00',0),
 (17609,5,46,170,0,'0.00',0),
 (17610,5,47,170,0,'0.00',0),
 (17611,5,48,170,0,'0.00',0),
 (17612,5,51,170,8,'0.48',0),
 (17613,5,52,170,0,'0.00',0),
 (17614,5,53,170,1,'0.06',0),
 (17615,5,54,170,0,'0.00',0),
 (17616,5,1,171,1598,'59.65',0),
 (17617,5,2,171,975,'36.39',0),
 (17618,5,14,171,0,'0.00',0),
 (17619,5,15,171,1,'0.04',0),
 (17620,5,28,171,5,'0.19',0),
 (17621,5,32,171,0,'0.00',0),
 (17622,5,36,171,1,'0.04',0),
 (17623,5,38,171,55,'2.05',0);
INSERT INTO `elecmunicandi` (`idElecMuniCandi`,`Convocatoria_idConvocatoria`,`Candidatura_idCandidatura`,`Municipio`,`Votos`,`PorcVotos`,`Concejales`) VALUES 
 (17624,5,39,171,13,'0.49',0),
 (17625,5,40,171,0,'0.00',0),
 (17626,5,41,171,0,'0.00',0),
 (17627,5,42,171,0,'0.00',0),
 (17628,5,45,171,2,'0.07',0),
 (17629,5,46,171,0,'0.00',0),
 (17630,5,47,171,0,'0.00',0),
 (17631,5,48,171,0,'0.00',0),
 (17632,5,51,171,8,'0.30',0),
 (17633,5,52,171,0,'0.00',0),
 (17634,5,53,171,1,'0.04',0),
 (17635,5,54,171,3,'0.11',0),
 (17636,5,1,172,2011,'56.65',0),
 (17637,5,2,172,1134,'31.94',0),
 (17638,5,14,172,4,'0.11',0),
 (17639,5,15,172,3,'0.08',0),
 (17640,5,28,172,4,'0.11',0),
 (17641,5,32,172,0,'0.00',0),
 (17642,5,36,172,15,'0.42',0),
 (17643,5,38,172,195,'5.49',0),
 (17644,5,39,172,39,'1.10',0),
 (17645,5,40,172,3,'0.08',0),
 (17646,5,41,172,2,'0.06',0),
 (17647,5,42,172,2,'0.06',0),
 (17648,5,45,172,5,'0.14',0),
 (17649,5,46,172,1,'0.03',0),
 (17650,5,47,172,1,'0.03',0),
 (17651,5,48,172,6,'0.17',0),
 (17652,5,51,172,55,'1.55',0),
 (17653,5,52,172,0,'0.00',0),
 (17654,5,53,172,3,'0.08',0),
 (17655,5,54,172,2,'0.06',0),
 (17656,5,1,173,214,'54.31',0),
 (17657,5,2,173,163,'41.37',0),
 (17658,5,14,173,0,'0.00',0),
 (17659,5,15,173,0,'0.00',0),
 (17660,5,28,173,0,'0.00',0),
 (17661,5,32,173,0,'0.00',0),
 (17662,5,36,173,0,'0.00',0),
 (17663,5,38,173,7,'1.78',0),
 (17664,5,39,173,2,'0.51',0),
 (17665,5,40,173,0,'0.00',0),
 (17666,5,41,173,0,'0.00',0),
 (17667,5,42,173,1,'0.25',0),
 (17668,5,45,173,0,'0.00',0),
 (17669,5,46,173,0,'0.00',0),
 (17670,5,47,173,0,'0.00',0),
 (17671,5,48,173,0,'0.00',0),
 (17672,5,51,173,1,'0.25',0),
 (17673,5,52,173,0,'0.00',0),
 (17674,5,53,173,1,'0.25',0),
 (17675,5,54,173,1,'0.25',0),
 (17676,5,1,174,643,'58.83',0),
 (17677,5,2,174,369,'33.76',0),
 (17678,5,14,174,0,'0.00',0),
 (17679,5,15,174,0,'0.00',0),
 (17680,5,28,174,1,'0.09',0),
 (17681,5,32,174,0,'0.00',0),
 (17682,5,36,174,0,'0.00',0),
 (17683,5,38,174,18,'1.65',0),
 (17684,5,39,174,8,'0.73',0),
 (17685,5,40,174,0,'0.00',0),
 (17686,5,41,174,1,'0.09',0),
 (17687,5,42,174,1,'0.09',0),
 (17688,5,45,174,21,'1.92',0),
 (17689,5,46,174,0,'0.00',0),
 (17690,5,47,174,1,'0.09',0),
 (17691,5,48,174,1,'0.09',0),
 (17692,5,51,174,7,'0.64',0),
 (17693,5,52,174,0,'0.00',0),
 (17694,5,53,174,8,'0.73',0),
 (17695,5,54,174,2,'0.18',0),
 (17696,5,1,175,191,'66.78',0),
 (17697,5,2,175,82,'28.67',0),
 (17698,5,14,175,2,'0.70',0),
 (17699,5,15,175,0,'0.00',0),
 (17700,5,28,175,2,'0.70',0),
 (17701,5,32,175,0,'0.00',0),
 (17702,5,36,175,0,'0.00',0),
 (17703,5,38,175,3,'1.05',0),
 (17704,5,39,175,2,'0.70',0),
 (17705,5,40,175,0,'0.00',0),
 (17706,5,41,175,0,'0.00',0),
 (17707,5,42,175,0,'0.00',0),
 (17708,5,45,175,0,'0.00',0),
 (17709,5,46,175,0,'0.00',0),
 (17710,5,47,175,0,'0.00',0),
 (17711,5,48,175,0,'0.00',0),
 (17712,5,51,175,1,'0.35',0),
 (17713,5,52,175,0,'0.00',0),
 (17714,5,53,175,0,'0.00',0),
 (17715,5,54,175,0,'0.00',0),
 (17716,5,1,176,3891,'66.54',0),
 (17717,5,2,176,1428,'24.42',0),
 (17718,5,14,176,2,'0.03',0),
 (17719,5,15,176,6,'0.10',0),
 (17720,5,28,176,6,'0.10',0),
 (17721,5,32,176,3,'0.05',0),
 (17722,5,36,176,1,'0.02',0),
 (17723,5,38,176,168,'2.87',0),
 (17724,5,39,176,57,'0.97',0),
 (17725,5,40,176,3,'0.05',0),
 (17726,5,41,176,1,'0.02',0),
 (17727,5,42,176,9,'0.15',0),
 (17728,5,45,176,3,'0.05',0),
 (17729,5,46,176,10,'0.17',0),
 (17730,5,47,176,1,'0.02',0),
 (17731,5,48,176,4,'0.07',0),
 (17732,5,51,176,93,'1.59',0),
 (17733,5,52,176,0,'0.00',0),
 (17734,5,53,176,23,'0.39',0),
 (17735,5,54,176,6,'0.10',0),
 (17736,5,1,177,2071,'53.81',0),
 (17737,5,2,177,1371,'35.62',0),
 (17738,5,14,177,3,'0.08',0),
 (17739,5,15,177,1,'0.03',0),
 (17740,5,28,177,8,'0.21',0),
 (17741,5,32,177,0,'0.00',0),
 (17742,5,36,177,0,'0.00',0),
 (17743,5,38,177,193,'5.01',0),
 (17744,5,39,177,37,'0.96',0),
 (17745,5,40,177,1,'0.03',0),
 (17746,5,41,177,3,'0.08',0),
 (17747,5,42,177,3,'0.08',0),
 (17748,5,45,177,3,'0.08',0),
 (17749,5,46,177,5,'0.13',0),
 (17750,5,47,177,3,'0.08',0),
 (17751,5,48,177,1,'0.03',0),
 (17752,5,51,177,30,'0.78',0),
 (17753,5,52,177,1,'0.03',0),
 (17754,5,53,177,40,'1.04',0),
 (17755,5,54,177,4,'0.10',0),
 (17756,5,1,178,300,'48.54',0),
 (17757,5,2,178,241,'39.00',0),
 (17758,5,14,178,0,'0.00',0),
 (17759,5,15,178,0,'0.00',0),
 (17760,5,28,178,0,'0.00',0),
 (17761,5,32,178,0,'0.00',0),
 (17762,5,36,178,0,'0.00',0),
 (17763,5,38,178,53,'8.58',0),
 (17764,5,39,178,6,'0.97',0),
 (17765,5,40,178,0,'0.00',0),
 (17766,5,41,178,0,'0.00',0),
 (17767,5,42,178,0,'0.00',0),
 (17768,5,45,178,0,'0.00',0),
 (17769,5,46,178,0,'0.00',0),
 (17770,5,47,178,0,'0.00',0),
 (17771,5,48,178,0,'0.00',0),
 (17772,5,51,178,6,'0.97',0),
 (17773,5,52,178,1,'0.16',0),
 (17774,5,53,178,0,'0.00',0),
 (17775,5,54,178,0,'0.00',0),
 (17776,5,1,179,452,'57.43',0),
 (17777,5,2,179,244,'31.00',0),
 (17778,5,14,179,0,'0.00',0),
 (17779,5,15,179,1,'0.13',0),
 (17780,5,28,179,0,'0.00',0),
 (17781,5,32,179,1,'0.13',0),
 (17782,5,36,179,0,'0.00',0),
 (17783,5,38,179,62,'7.88',0),
 (17784,5,39,179,5,'0.64',0),
 (17785,5,40,179,0,'0.00',0),
 (17786,5,41,179,0,'0.00',0),
 (17787,5,42,179,0,'0.00',0),
 (17788,5,45,179,0,'0.00',0),
 (17789,5,46,179,0,'0.00',0),
 (17790,5,47,179,1,'0.13',0),
 (17791,5,48,179,0,'0.00',0),
 (17792,5,51,179,8,'1.02',0),
 (17793,5,52,179,0,'0.00',0),
 (17794,5,53,179,2,'0.25',0),
 (17795,5,54,179,1,'0.13',0),
 (17796,5,1,180,1714,'47.24',0),
 (17797,5,2,180,1630,'44.93',0),
 (17798,5,14,180,4,'0.11',0),
 (17799,5,15,180,1,'0.03',0),
 (17800,5,28,180,0,'0.00',0),
 (17801,5,32,180,4,'0.11',0),
 (17802,5,36,180,2,'0.06',0),
 (17803,5,38,180,170,'4.69',0),
 (17804,5,39,180,25,'0.69',0),
 (17805,5,40,180,1,'0.03',0),
 (17806,5,41,180,2,'0.06',0),
 (17807,5,42,180,3,'0.08',0),
 (17808,5,45,180,5,'0.14',0),
 (17809,5,46,180,1,'0.03',0),
 (17810,5,47,180,1,'0.03',0),
 (17811,5,48,180,0,'0.00',0),
 (17812,5,51,180,27,'0.74',0),
 (17813,5,52,180,0,'0.00',0),
 (17814,5,53,180,2,'0.06',0),
 (17815,5,54,180,3,'0.08',0),
 (17816,5,1,181,7683,'58.70',0),
 (17817,5,2,181,3957,'30.23',0),
 (17818,5,14,181,10,'0.08',0),
 (17819,5,15,181,5,'0.04',0),
 (17820,5,28,181,14,'0.11',0),
 (17821,5,32,181,0,'0.00',0),
 (17822,5,36,181,8,'0.06',0),
 (17823,5,38,181,671,'5.13',0),
 (17824,5,39,181,102,'0.78',0),
 (17825,5,40,181,7,'0.05',0),
 (17826,5,41,181,7,'0.05',0),
 (17827,5,42,181,5,'0.04',0),
 (17828,5,45,181,3,'0.02',0),
 (17829,5,46,181,10,'0.08',0),
 (17830,5,47,181,4,'0.03',0),
 (17831,5,48,181,3,'0.02',0),
 (17832,5,51,181,199,'1.52',0),
 (17833,5,52,181,1,'0.01',0),
 (17834,5,53,181,106,'0.81',0),
 (17835,5,54,181,9,'0.07',0),
 (17836,5,1,182,59,'42.75',0),
 (17837,5,2,182,65,'47.10',0),
 (17838,5,14,182,1,'0.72',0),
 (17839,5,15,182,0,'0.00',0),
 (17840,5,28,182,0,'0.00',0),
 (17841,5,32,182,0,'0.00',0),
 (17842,5,36,182,0,'0.00',0),
 (17843,5,38,182,6,'4.35',0),
 (17844,5,39,182,2,'1.45',0),
 (17845,5,40,182,1,'0.72',0),
 (17846,5,41,182,0,'0.00',0),
 (17847,5,42,182,0,'0.00',0),
 (17848,5,45,182,0,'0.00',0),
 (17849,5,46,182,0,'0.00',0),
 (17850,5,47,182,1,'0.72',0),
 (17851,5,48,182,0,'0.00',0),
 (17852,5,51,182,2,'1.45',0),
 (17853,5,52,182,0,'0.00',0),
 (17854,5,53,182,0,'0.00',0),
 (17855,5,54,182,0,'0.00',0),
 (17856,5,1,183,320,'48.93',0),
 (17857,5,2,183,234,'35.78',0),
 (17858,5,14,183,1,'0.15',0),
 (17859,5,15,183,0,'0.00',0),
 (17860,5,28,183,0,'0.00',0),
 (17861,5,32,183,0,'0.00',0),
 (17862,5,36,183,0,'0.00',0),
 (17863,5,38,183,41,'6.27',0),
 (17864,5,39,183,3,'0.46',0),
 (17865,5,40,183,0,'0.00',0),
 (17866,5,41,183,1,'0.15',0),
 (17867,5,42,183,0,'0.00',0),
 (17868,5,45,183,1,'0.15',0),
 (17869,5,46,183,0,'0.00',0),
 (17870,5,47,183,2,'0.31',0),
 (17871,5,48,183,0,'0.00',0),
 (17872,5,51,183,32,'4.89',0),
 (17873,5,52,183,0,'0.00',0),
 (17874,5,53,183,9,'1.38',0),
 (17875,5,54,183,1,'0.15',0),
 (17876,5,1,901,261,'52.52',0),
 (17877,5,2,901,195,'39.24',0),
 (17878,5,14,901,1,'0.20',0),
 (17879,5,15,901,2,'0.40',0),
 (17880,5,28,901,1,'0.20',0),
 (17881,5,32,901,0,'0.00',0),
 (17882,5,36,901,0,'0.00',0),
 (17883,5,38,901,21,'4.23',0),
 (17884,5,39,901,3,'0.60',0),
 (17885,5,40,901,1,'0.20',0),
 (17886,5,41,901,0,'0.00',0),
 (17887,5,42,901,0,'0.00',0),
 (17888,5,45,901,1,'0.20',0),
 (17889,5,46,901,0,'0.00',0),
 (17890,5,47,901,0,'0.00',0),
 (17891,5,48,901,0,'0.00',0),
 (17892,5,51,901,2,'0.40',0),
 (17893,5,52,901,0,'0.00',0),
 (17894,5,53,901,0,'0.00',0),
 (17895,5,54,901,1,'0.20',0),
 (17896,5,1,902,220,'66.67',0),
 (17897,5,2,902,73,'22.12',0),
 (17898,5,14,902,0,'0.00',0),
 (17899,5,15,902,2,'0.61',0),
 (17900,5,28,902,0,'0.00',0),
 (17901,5,32,902,0,'0.00',0),
 (17902,5,36,902,0,'0.00',0),
 (17903,5,38,902,22,'6.67',0),
 (17904,5,39,902,0,'0.00',0),
 (17905,5,40,902,0,'0.00',0),
 (17906,5,41,902,0,'0.00',0),
 (17907,5,42,902,0,'0.00',0),
 (17908,5,45,902,0,'0.00',0),
 (17909,5,46,902,0,'0.00',0),
 (17910,5,47,902,1,'0.30',0),
 (17911,5,48,902,0,'0.00',0),
 (17912,5,51,902,4,'1.21',0),
 (17913,5,52,902,1,'0.30',0),
 (17914,5,53,902,1,'0.30',0),
 (17915,5,54,902,0,'0.00',0),
 (17916,5,1,903,9195,'45.73',0),
 (17917,5,2,903,7592,'37.75',0),
 (17918,5,14,903,14,'0.07',0),
 (17919,5,15,903,17,'0.08',0),
 (17920,5,28,903,20,'0.10',0),
 (17921,5,32,903,5,'0.02',0),
 (17922,5,36,903,10,'0.05',0),
 (17923,5,38,903,1801,'8.96',0),
 (17924,5,39,903,236,'1.17',0),
 (17925,5,40,903,23,'0.11',0),
 (17926,5,41,903,16,'0.08',0),
 (17927,5,42,903,15,'0.07',0),
 (17928,5,45,903,14,'0.07',0),
 (17929,5,46,903,48,'0.24',0),
 (17930,5,47,903,13,'0.06',0),
 (17931,5,48,903,14,'0.07',0),
 (17932,5,51,903,343,'1.71',0),
 (17933,5,52,903,11,'0.05',0),
 (17934,5,53,903,43,'0.21',0),
 (17935,5,54,903,18,'0.09',0),
 (17936,5,1,999,9911,'44.62',0),
 (17937,5,2,999,8283,'37.29',0),
 (17938,5,14,999,140,'0.63',0),
 (17939,5,15,999,80,'0.36',0),
 (17940,5,28,999,79,'0.36',0),
 (17941,5,32,999,31,'0.14',0),
 (17942,5,36,999,112,'0.50',0),
 (17943,5,38,999,1323,'5.96',0),
 (17944,5,39,999,394,'1.77',0),
 (17945,5,40,999,43,'0.19',0),
 (17946,5,41,999,74,'0.33',0),
 (17947,5,42,999,96,'0.43',0),
 (17948,5,45,999,109,'0.49',0),
 (17949,5,46,999,214,'0.96',0),
 (17950,5,47,999,75,'0.34',0),
 (17951,5,48,999,258,'1.16',0),
 (17952,5,51,999,695,'3.13',0),
 (17953,5,52,999,14,'0.06',0),
 (17954,5,53,999,146,'0.66',0),
 (17955,5,54,999,44,'0.20',0),
 (18451,6,1,1,33,'78.57',0),
 (18452,6,2,1,5,'11.90',0),
 (18453,6,14,1,0,'0.00',0),
 (18454,6,15,1,0,'0.00',0),
 (18455,6,28,1,0,'0.00',0),
 (18456,6,32,1,0,'0.00',0),
 (18457,6,38,1,3,'7.14',0),
 (18458,6,40,1,0,'0.00',0),
 (18459,6,45,1,0,'0.00',0),
 (18460,6,48,1,0,'0.00',0),
 (18461,6,50,1,0,'0.00',0),
 (18462,6,51,1,0,'0.00',0),
 (18463,6,55,1,0,'0.00',0),
 (18464,6,56,1,0,'0.00',0),
 (18465,6,57,1,0,'0.00',0),
 (18466,6,58,1,0,'0.00',0),
 (18467,6,59,1,0,'0.00',0),
 (18468,6,60,1,0,'0.00',0),
 (18469,6,61,1,0,'0.00',0),
 (18470,6,62,1,0,'0.00',0),
 (18471,6,1,2,667,'56.24',0),
 (18472,6,2,2,405,'34.15',0),
 (18473,6,14,2,0,'0.00',0),
 (18474,6,15,2,2,'0.17',0),
 (18475,6,28,2,3,'0.25',0),
 (18476,6,32,2,0,'0.00',0),
 (18477,6,38,2,61,'5.14',0),
 (18478,6,40,2,0,'0.00',0),
 (18479,6,45,2,6,'0.51',0),
 (18480,6,48,2,5,'0.42',0),
 (18481,6,50,2,0,'0.00',0),
 (18482,6,51,2,2,'0.17',0),
 (18483,6,55,2,0,'0.00',0),
 (18484,6,56,2,5,'0.42',0),
 (18485,6,57,2,1,'0.08',0),
 (18486,6,58,2,1,'0.08',0),
 (18487,6,59,2,0,'0.00',0),
 (18488,6,60,2,0,'0.00',0),
 (18489,6,61,2,0,'0.00',0),
 (18490,6,62,2,0,'0.00',0),
 (18491,6,1,3,88,'68.75',0),
 (18492,6,2,3,33,'25.78',0),
 (18493,6,14,3,0,'0.00',0),
 (18494,6,15,3,0,'0.00',0),
 (18495,6,28,3,1,'0.78',0),
 (18496,6,32,3,0,'0.00',0),
 (18497,6,38,3,1,'0.78',0),
 (18498,6,40,3,0,'0.00',0),
 (18499,6,45,3,2,'1.56',0),
 (18500,6,48,3,0,'0.00',0),
 (18501,6,50,3,0,'0.00',0),
 (18502,6,51,3,2,'1.56',0),
 (18503,6,55,3,0,'0.00',0),
 (18504,6,56,3,0,'0.00',0),
 (18505,6,57,3,0,'0.00',0),
 (18506,6,58,3,0,'0.00',0),
 (18507,6,59,3,0,'0.00',0),
 (18508,6,60,3,0,'0.00',0),
 (18509,6,61,3,0,'0.00',0),
 (18510,6,62,3,0,'0.00',0),
 (18511,6,1,4,1692,'60.39',0),
 (18512,6,2,4,967,'34.51',0),
 (18513,6,14,4,1,'0.04',0),
 (18514,6,15,4,0,'0.00',0),
 (18515,6,28,4,1,'0.04',0),
 (18516,6,32,4,4,'0.14',0),
 (18517,6,38,4,96,'3.43',0),
 (18518,6,40,4,0,'0.00',0),
 (18519,6,45,4,0,'0.00',0),
 (18520,6,48,4,1,'0.04',0),
 (18521,6,50,4,0,'0.00',0),
 (18522,6,51,4,7,'0.25',0),
 (18523,6,55,4,0,'0.00',0),
 (18524,6,56,4,3,'0.11',0),
 (18525,6,57,4,2,'0.07',0),
 (18526,6,58,4,0,'0.00',0),
 (18527,6,59,4,0,'0.00',0),
 (18528,6,60,4,1,'0.04',0),
 (18529,6,61,4,0,'0.00',0),
 (18530,6,62,4,3,'0.11',0),
 (18531,6,1,5,32156,'43.28',0),
 (18532,6,2,5,30233,'40.70',0),
 (18533,6,14,5,97,'0.13',0),
 (18534,6,15,5,119,'0.16',0),
 (18535,6,28,5,164,'0.22',0),
 (18536,6,32,5,36,'0.05',0),
 (18537,6,38,5,7696,'10.36',0),
 (18538,6,40,5,51,'0.07',0),
 (18539,6,45,5,66,'0.09',0),
 (18540,6,48,5,113,'0.15',0),
 (18541,6,50,5,68,'0.09',0),
 (18542,6,51,5,805,'1.08',0),
 (18543,6,55,5,43,'0.06',0),
 (18544,6,56,5,635,'0.85',0),
 (18545,6,57,5,200,'0.27',0),
 (18546,6,58,5,43,'0.06',0),
 (18547,6,59,5,26,'0.03',0),
 (18548,6,60,5,53,'0.07',0),
 (18549,6,61,5,38,'0.05',0),
 (18550,6,62,5,41,'0.06',0),
 (18551,6,1,6,20910,'49.35',0),
 (18552,6,2,6,16660,'39.32',0),
 (18553,6,14,6,80,'0.19',0),
 (18554,6,15,6,60,'0.14',0),
 (18555,6,28,6,44,'0.10',0),
 (18556,6,32,6,16,'0.04',0),
 (18557,6,38,6,2568,'6.06',0),
 (18558,6,40,6,40,'0.09',0),
 (18559,6,45,6,40,'0.09',0),
 (18560,6,48,6,71,'0.17',0),
 (18561,6,50,6,27,'0.06',0),
 (18562,6,51,6,382,'0.90',0),
 (18563,6,55,6,17,'0.04',0),
 (18564,6,56,6,333,'0.79',0),
 (18565,6,57,6,144,'0.34',0),
 (18566,6,58,6,30,'0.07',0),
 (18567,6,59,6,11,'0.03',0),
 (18568,6,60,6,56,'0.13',0),
 (18569,6,61,6,26,'0.06',0),
 (18570,6,62,6,16,'0.04',0),
 (18571,6,1,7,37236,'48.64',0),
 (18572,6,2,7,28871,'37.72',0),
 (18573,6,14,7,125,'0.16',0),
 (18574,6,15,7,203,'0.27',0),
 (18575,6,28,7,61,'0.08',0),
 (18576,6,32,7,19,'0.02',0),
 (18577,6,38,7,5668,'7.40',0),
 (18578,6,40,7,23,'0.03',0),
 (18579,6,45,7,40,'0.05',0),
 (18580,6,48,7,25,'0.03',0),
 (18581,6,50,7,65,'0.08',0),
 (18582,6,51,7,639,'0.83',0),
 (18583,6,55,7,28,'0.04',0),
 (18584,6,56,7,442,'0.58',0),
 (18585,6,57,7,508,'0.66',0),
 (18586,6,58,7,149,'0.19',0),
 (18587,6,59,7,24,'0.03',0),
 (18588,6,60,7,59,'0.08',0),
 (18589,6,61,7,39,'0.05',0),
 (18590,6,62,7,66,'0.09',0),
 (18591,6,1,8,526,'56.26',0),
 (18592,6,2,8,336,'35.94',0),
 (18593,6,14,8,1,'0.11',0),
 (18594,6,15,8,1,'0.11',0),
 (18595,6,28,8,0,'0.00',0),
 (18596,6,32,8,0,'0.00',0),
 (18597,6,38,8,17,'1.82',0),
 (18598,6,40,8,0,'0.00',0),
 (18599,6,45,8,12,'1.28',0),
 (18600,6,48,8,0,'0.00',0),
 (18601,6,50,8,1,'0.11',0),
 (18602,6,51,8,5,'0.53',0),
 (18603,6,55,8,0,'0.00',0),
 (18604,6,56,8,0,'0.00',0),
 (18605,6,57,8,24,'2.57',0),
 (18606,6,58,8,0,'0.00',0),
 (18607,6,59,8,0,'0.00',0),
 (18608,6,60,8,0,'0.00',0),
 (18609,6,61,8,0,'0.00',0),
 (18610,6,62,8,0,'0.00',0),
 (18611,6,1,9,3243,'50.78',0),
 (18612,6,2,9,2314,'36.23',0),
 (18613,6,14,9,5,'0.08',0),
 (18614,6,15,9,3,'0.05',0),
 (18615,6,28,9,15,'0.23',0),
 (18616,6,32,9,1,'0.02',0),
 (18617,6,38,9,426,'6.67',0),
 (18618,6,40,9,7,'0.11',0),
 (18619,6,45,9,97,'1.52',0),
 (18620,6,48,9,3,'0.05',0),
 (18621,6,50,9,4,'0.06',0),
 (18622,6,51,9,46,'0.72',0),
 (18623,6,55,9,2,'0.03',0),
 (18624,6,56,9,61,'0.96',0),
 (18625,6,57,9,15,'0.23',0),
 (18626,6,58,9,3,'0.05',0),
 (18627,6,59,9,3,'0.05',0),
 (18628,6,60,9,11,'0.17',0),
 (18629,6,61,9,3,'0.05',0),
 (18630,6,62,9,2,'0.03',0),
 (18631,6,1,10,1713,'52.08',0),
 (18632,6,2,10,1162,'35.33',0),
 (18633,6,14,10,2,'0.06',0),
 (18634,6,15,10,2,'0.06',0),
 (18635,6,28,10,5,'0.15',0),
 (18636,6,32,10,0,'0.00',0),
 (18637,6,38,10,248,'7.54',0),
 (18638,6,40,10,3,'0.09',0),
 (18639,6,45,10,4,'0.12',0),
 (18640,6,48,10,3,'0.09',0),
 (18641,6,50,10,0,'0.00',0),
 (18642,6,51,10,33,'1.00',0),
 (18643,6,55,10,3,'0.09',0),
 (18644,6,56,10,21,'0.64',0),
 (18645,6,57,10,10,'0.30',0),
 (18646,6,58,10,3,'0.09',0),
 (18647,6,59,10,0,'0.00',0),
 (18648,6,60,10,5,'0.15',0),
 (18649,6,61,10,1,'0.03',0),
 (18650,6,62,10,0,'0.00',0),
 (18651,6,1,11,136,'60.71',0),
 (18652,6,2,11,43,'19.20',0),
 (18653,6,14,11,0,'0.00',0),
 (18654,6,15,11,0,'0.00',0),
 (18655,6,28,11,0,'0.00',0),
 (18656,6,32,11,0,'0.00',0),
 (18657,6,38,11,41,'18.30',0),
 (18658,6,40,11,0,'0.00',0),
 (18659,6,45,11,0,'0.00',0),
 (18660,6,48,11,0,'0.00',0),
 (18661,6,50,11,0,'0.00',0),
 (18662,6,51,11,0,'0.00',0),
 (18663,6,55,11,0,'0.00',0),
 (18664,6,56,11,1,'0.45',0),
 (18665,6,57,11,0,'0.00',0),
 (18666,6,58,11,0,'0.00',0),
 (18667,6,59,11,0,'0.00',0),
 (18668,6,60,11,0,'0.00',0),
 (18669,6,61,11,0,'0.00',0),
 (18670,6,62,11,0,'0.00',0),
 (18671,6,1,12,219,'50.46',0),
 (18672,6,2,12,183,'42.17',0),
 (18673,6,14,12,0,'0.00',0),
 (18674,6,15,12,0,'0.00',0),
 (18675,6,28,12,0,'0.00',0),
 (18676,6,32,12,0,'0.00',0),
 (18677,6,38,12,18,'4.15',0),
 (18678,6,40,12,0,'0.00',0),
 (18679,6,45,12,0,'0.00',0),
 (18680,6,48,12,0,'0.00',0),
 (18681,6,50,12,0,'0.00',0),
 (18682,6,51,12,5,'1.15',0),
 (18683,6,55,12,0,'0.00',0),
 (18684,6,56,12,2,'0.46',0),
 (18685,6,57,12,1,'0.23',0),
 (18686,6,58,12,0,'0.00',0),
 (18687,6,59,12,0,'0.00',0),
 (18688,6,60,12,0,'0.00',0),
 (18689,6,61,12,0,'0.00',0),
 (18690,6,62,12,0,'0.00',0),
 (18691,6,1,13,10442,'48.38',0),
 (18692,6,2,13,8708,'40.35',0),
 (18693,6,14,13,16,'0.07',0),
 (18694,6,15,13,14,'0.06',0),
 (18695,6,28,13,15,'0.07',0),
 (18696,6,32,13,6,'0.03',0),
 (18697,6,38,13,1664,'7.71',0),
 (18698,6,40,13,11,'0.05',0),
 (18699,6,45,13,14,'0.06',0),
 (18700,6,48,13,0,'0.00',0),
 (18701,6,50,13,4,'0.02',0),
 (18702,6,51,13,108,'0.50',0),
 (18703,6,55,13,8,'0.04',0),
 (18704,6,56,13,97,'0.45',0),
 (18705,6,57,13,26,'0.12',0),
 (18706,6,58,13,13,'0.06',0),
 (18707,6,59,13,11,'0.05',0),
 (18708,6,60,13,24,'0.11',0),
 (18709,6,61,13,7,'0.03',0),
 (18710,6,62,13,8,'0.04',0),
 (18711,6,1,14,7392,'48.09',0),
 (18712,6,2,14,6569,'42.74',0),
 (18713,6,14,14,6,'0.04',0),
 (18714,6,15,14,11,'0.07',0),
 (18715,6,28,14,26,'0.17',0),
 (18716,6,32,14,6,'0.04',0),
 (18717,6,38,14,973,'6.33',0),
 (18718,6,40,14,5,'0.03',0),
 (18719,6,45,14,6,'0.04',0),
 (18720,6,48,14,2,'0.01',0),
 (18721,6,50,14,3,'0.02',0),
 (18722,6,51,14,69,'0.45',0),
 (18723,6,55,14,4,'0.03',0),
 (18724,6,56,14,78,'0.51',0),
 (18725,6,57,14,13,'0.08',0),
 (18726,6,58,14,1,'0.01',0),
 (18727,6,59,14,2,'0.01',0),
 (18728,6,60,14,11,'0.07',0),
 (18729,6,61,14,4,'0.03',0),
 (18730,6,62,14,0,'0.00',0),
 (18731,6,1,15,995,'53.27',0),
 (18732,6,2,15,651,'34.85',0),
 (18733,6,14,15,2,'0.11',0),
 (18734,6,15,15,1,'0.05',0),
 (18735,6,28,15,3,'0.16',0),
 (18736,6,32,15,1,'0.05',0),
 (18737,6,38,15,124,'6.64',0),
 (18738,6,40,15,1,'0.05',0),
 (18739,6,45,15,0,'0.00',0),
 (18740,6,48,15,0,'0.00',0),
 (18741,6,50,15,1,'0.05',0),
 (18742,6,51,15,9,'0.48',0),
 (18743,6,55,15,1,'0.05',0),
 (18744,6,56,15,19,'1.02',0),
 (18745,6,57,15,19,'1.02',0),
 (18746,6,58,15,2,'0.11',0),
 (18747,6,59,15,2,'0.11',0),
 (18748,6,60,15,3,'0.16',0),
 (18749,6,61,15,2,'0.11',0),
 (18750,6,62,15,0,'0.00',0),
 (18751,6,1,16,41,'56.94',0),
 (18752,6,2,16,25,'34.72',0),
 (18753,6,14,16,0,'0.00',0),
 (18754,6,15,16,0,'0.00',0),
 (18755,6,28,16,0,'0.00',0),
 (18756,6,32,16,0,'0.00',0),
 (18757,6,38,16,4,'5.56',0),
 (18758,6,40,16,0,'0.00',0),
 (18759,6,45,16,0,'0.00',0),
 (18760,6,48,16,0,'0.00',0),
 (18761,6,50,16,0,'0.00',0),
 (18762,6,51,16,0,'0.00',0),
 (18763,6,55,16,0,'0.00',0),
 (18764,6,56,16,0,'0.00',0),
 (18765,6,57,16,0,'0.00',0),
 (18766,6,58,16,0,'0.00',0),
 (18767,6,59,16,1,'1.39',0),
 (18768,6,60,16,0,'0.00',0),
 (18769,6,61,16,0,'0.00',0),
 (18770,6,62,16,0,'0.00',0),
 (18771,6,1,17,225,'46.88',0),
 (18772,6,2,17,182,'37.92',0),
 (18773,6,14,17,0,'0.00',0),
 (18774,6,15,17,0,'0.00',0),
 (18775,6,28,17,0,'0.00',0),
 (18776,6,32,17,0,'0.00',0),
 (18777,6,38,17,51,'10.63',0),
 (18778,6,40,17,3,'0.63',0),
 (18779,6,45,17,0,'0.00',0),
 (18780,6,48,17,0,'0.00',0),
 (18781,6,50,17,0,'0.00',0),
 (18782,6,51,17,5,'1.04',0),
 (18783,6,55,17,0,'0.00',0),
 (18784,6,56,17,0,'0.00',0),
 (18785,6,57,17,0,'0.00',0),
 (18786,6,58,17,0,'0.00',0),
 (18787,6,59,17,0,'0.00',0),
 (18788,6,60,17,0,'0.00',0),
 (18789,6,61,17,0,'0.00',0),
 (18790,6,62,17,1,'0.21',0),
 (18791,6,1,18,1065,'55.85',0),
 (18792,6,2,18,698,'36.60',0),
 (18793,6,14,18,0,'0.00',0),
 (18794,6,15,18,1,'0.05',0),
 (18795,6,28,18,1,'0.05',0),
 (18796,6,32,18,0,'0.00',0),
 (18797,6,38,18,72,'3.78',0),
 (18798,6,40,18,0,'0.00',0),
 (18799,6,45,18,0,'0.00',0),
 (18800,6,48,18,0,'0.00',0),
 (18801,6,50,18,0,'0.00',0),
 (18802,6,51,18,6,'0.31',0),
 (18803,6,55,18,0,'0.00',0),
 (18804,6,56,18,7,'0.37',0),
 (18805,6,57,18,2,'0.10',0),
 (18806,6,58,18,0,'0.00',0),
 (18807,6,59,18,0,'0.00',0),
 (18808,6,60,18,0,'0.00',0),
 (18809,6,61,18,1,'0.05',0),
 (18810,6,62,18,0,'0.00',0),
 (18811,6,1,19,318,'45.04',0),
 (18812,6,2,19,334,'47.31',0),
 (18813,6,14,19,0,'0.00',0),
 (18814,6,15,19,0,'0.00',0),
 (18815,6,28,19,4,'0.57',0),
 (18816,6,32,19,0,'0.00',0),
 (18817,6,38,19,31,'4.39',0),
 (18818,6,40,19,0,'0.00',0),
 (18819,6,45,19,0,'0.00',0),
 (18820,6,48,19,0,'0.00',0),
 (18821,6,50,19,0,'0.00',0),
 (18822,6,51,19,3,'0.42',0),
 (18823,6,55,19,0,'0.00',0),
 (18824,6,56,19,6,'0.85',0),
 (18825,6,57,19,0,'0.00',0),
 (18826,6,58,19,0,'0.00',0),
 (18827,6,59,19,0,'0.00',0),
 (18828,6,60,19,0,'0.00',0),
 (18829,6,61,19,0,'0.00',0),
 (18830,6,62,19,0,'0.00',0),
 (18831,6,1,20,53,'54.64',0),
 (18832,6,2,20,24,'24.74',0),
 (18833,6,14,20,0,'0.00',0),
 (18834,6,15,20,0,'0.00',0),
 (18835,6,28,20,0,'0.00',0),
 (18836,6,32,20,0,'0.00',0),
 (18837,6,38,20,14,'14.43',0),
 (18838,6,40,20,0,'0.00',0),
 (18839,6,45,20,0,'0.00',0),
 (18840,6,48,20,1,'1.03',0),
 (18841,6,50,20,0,'0.00',0),
 (18842,6,51,20,1,'1.03',0),
 (18843,6,55,20,0,'0.00',0),
 (18844,6,56,20,0,'0.00',0),
 (18845,6,57,20,0,'0.00',0),
 (18846,6,58,20,0,'0.00',0),
 (18847,6,59,20,0,'0.00',0),
 (18848,6,60,20,0,'0.00',0),
 (18849,6,61,20,0,'0.00',0),
 (18850,6,62,20,0,'0.00',0),
 (18851,6,1,21,167,'72.29',0),
 (18852,6,2,21,47,'20.35',0),
 (18853,6,14,21,0,'0.00',0),
 (18854,6,15,21,0,'0.00',0),
 (18855,6,28,21,0,'0.00',0),
 (18856,6,32,21,0,'0.00',0),
 (18857,6,38,21,10,'4.33',0),
 (18858,6,40,21,1,'0.43',0),
 (18859,6,45,21,0,'0.00',0),
 (18860,6,48,21,0,'0.00',0),
 (18861,6,50,21,0,'0.00',0),
 (18862,6,51,21,2,'0.87',0),
 (18863,6,55,21,0,'0.00',0),
 (18864,6,56,21,0,'0.00',0),
 (18865,6,57,21,0,'0.00',0),
 (18866,6,58,21,0,'0.00',0),
 (18867,6,59,21,0,'0.00',0),
 (18868,6,60,21,0,'0.00',0),
 (18869,6,61,21,0,'0.00',0),
 (18870,6,62,21,1,'0.43',0),
 (18871,6,1,22,6090,'66.14',0),
 (18872,6,2,22,2157,'23.43',0),
 (18873,6,14,22,20,'0.22',0),
 (18874,6,15,22,9,'0.10',0),
 (18875,6,28,22,21,'0.23',0),
 (18876,6,32,22,5,'0.05',0),
 (18877,6,38,22,350,'3.80',0),
 (18878,6,40,22,7,'0.08',0),
 (18879,6,45,22,7,'0.08',0),
 (18880,6,48,22,9,'0.10',0),
 (18881,6,50,22,7,'0.08',0),
 (18882,6,51,22,61,'0.66',0),
 (18883,6,55,22,7,'0.08',0),
 (18884,6,56,22,96,'1.04',0),
 (18885,6,57,22,68,'0.74',0),
 (18886,6,58,22,2,'0.02',0),
 (18887,6,59,22,6,'0.07',0),
 (18888,6,60,22,14,'0.15',0),
 (18889,6,61,22,7,'0.08',0),
 (18890,6,62,22,8,'0.09',0),
 (18891,6,1,23,1065,'60.65',0),
 (18892,6,2,23,555,'31.61',0),
 (18893,6,14,23,0,'0.00',0),
 (18894,6,15,23,0,'0.00',0),
 (18895,6,28,23,3,'0.17',0),
 (18896,6,32,23,1,'0.06',0),
 (18897,6,38,23,62,'3.53',0),
 (18898,6,40,23,0,'0.00',0),
 (18899,6,45,23,1,'0.06',0),
 (18900,6,48,23,0,'0.00',0),
 (18901,6,50,23,2,'0.11',0),
 (18902,6,51,23,3,'0.17',0),
 (18903,6,55,23,0,'0.00',0),
 (18904,6,56,23,15,'0.85',0),
 (18905,6,57,23,9,'0.51',0),
 (18906,6,58,23,1,'0.06',0),
 (18907,6,59,23,2,'0.11',0),
 (18908,6,60,23,0,'0.00',0),
 (18909,6,61,23,1,'0.06',0),
 (18910,6,62,23,1,'0.06',0),
 (18911,6,1,24,72,'67.92',0),
 (18912,6,2,24,22,'20.75',0),
 (18913,6,14,24,2,'1.89',0),
 (18914,6,15,24,0,'0.00',0),
 (18915,6,28,24,0,'0.00',0),
 (18916,6,32,24,0,'0.00',0),
 (18917,6,38,24,5,'4.72',0),
 (18918,6,40,24,0,'0.00',0),
 (18919,6,45,24,0,'0.00',0),
 (18920,6,48,24,0,'0.00',0),
 (18921,6,50,24,0,'0.00',0),
 (18922,6,51,24,0,'0.00',0),
 (18923,6,55,24,0,'0.00',0),
 (18924,6,56,24,0,'0.00',0),
 (18925,6,57,24,0,'0.00',0),
 (18926,6,58,24,0,'0.00',0),
 (18927,6,59,24,0,'0.00',0),
 (18928,6,60,24,1,'0.94',0),
 (18929,6,61,24,0,'0.00',0),
 (18930,6,62,24,0,'0.00',0),
 (18931,6,1,25,246,'71.72',0),
 (18932,6,2,25,75,'21.87',0),
 (18933,6,14,25,0,'0.00',0),
 (18934,6,15,25,0,'0.00',0),
 (18935,6,28,25,1,'0.29',0),
 (18936,6,32,25,0,'0.00',0),
 (18937,6,38,25,12,'3.50',0),
 (18938,6,40,25,0,'0.00',0),
 (18939,6,45,25,0,'0.00',0),
 (18940,6,48,25,0,'0.00',0),
 (18941,6,50,25,0,'0.00',0),
 (18942,6,51,25,2,'0.58',0),
 (18943,6,55,25,0,'0.00',0),
 (18944,6,56,25,0,'0.00',0),
 (18945,6,57,25,2,'0.58',0),
 (18946,6,58,25,1,'0.29',0),
 (18947,6,59,25,0,'0.00',0),
 (18948,6,60,25,2,'0.58',0),
 (18949,6,61,25,1,'0.29',0),
 (18950,6,62,25,0,'0.00',0),
 (18951,6,1,26,1522,'60.13',0),
 (18952,6,2,26,709,'28.01',0),
 (18953,6,14,26,2,'0.08',0),
 (18954,6,15,26,4,'0.16',0),
 (18955,6,28,26,10,'0.40',0),
 (18956,6,32,26,0,'0.00',0),
 (18957,6,38,26,161,'6.36',0),
 (18958,6,40,26,2,'0.08',0),
 (18959,6,45,26,1,'0.04',0),
 (18960,6,48,26,4,'0.16',0),
 (18961,6,50,26,0,'0.00',0),
 (18962,6,51,26,20,'0.79',0),
 (18963,6,55,26,2,'0.08',0),
 (18964,6,56,26,14,'0.55',0),
 (18965,6,57,26,25,'0.99',0),
 (18966,6,58,26,0,'0.00',0),
 (18967,6,59,26,0,'0.00',0),
 (18968,6,60,26,0,'0.00',0),
 (18969,6,61,26,0,'0.00',0),
 (18970,6,62,26,1,'0.04',0),
 (18971,6,1,27,492,'57.48',0),
 (18972,6,2,27,288,'33.64',0),
 (18973,6,14,27,0,'0.00',0),
 (18974,6,15,27,0,'0.00',0),
 (18975,6,28,27,0,'0.00',0),
 (18976,6,32,27,0,'0.00',0),
 (18977,6,38,27,42,'4.91',0),
 (18978,6,40,27,0,'0.00',0),
 (18979,6,45,27,0,'0.00',0),
 (18980,6,48,27,9,'1.05',0),
 (18981,6,50,27,0,'0.00',0),
 (18982,6,51,27,1,'0.12',0),
 (18983,6,55,27,0,'0.00',0),
 (18984,6,56,27,7,'0.82',0),
 (18985,6,57,27,0,'0.00',0),
 (18986,6,58,27,0,'0.00',0),
 (18987,6,59,27,1,'0.12',0),
 (18988,6,60,27,0,'0.00',0),
 (18989,6,61,27,0,'0.00',0),
 (18990,6,62,27,1,'0.12',0),
 (18991,6,1,28,548,'61.30',0),
 (18992,6,2,28,248,'27.74',0),
 (18993,6,14,28,1,'0.11',0),
 (18994,6,15,28,0,'0.00',0),
 (18995,6,28,28,2,'0.22',0),
 (18996,6,32,28,0,'0.00',0),
 (18997,6,38,28,58,'6.49',0),
 (18998,6,40,28,3,'0.34',0),
 (18999,6,45,28,3,'0.34',0),
 (19000,6,48,28,2,'0.22',0),
 (19001,6,50,28,0,'0.00',0),
 (19002,6,51,28,6,'0.67',0),
 (19003,6,55,28,1,'0.11',0),
 (19004,6,56,28,2,'0.22',0),
 (19005,6,57,28,0,'0.00',0),
 (19006,6,58,28,0,'0.00',0),
 (19007,6,59,28,0,'0.00',0),
 (19008,6,60,28,0,'0.00',0),
 (19009,6,61,28,1,'0.11',0),
 (19010,6,62,28,0,'0.00',0),
 (19011,6,1,29,211,'62.24',0),
 (19012,6,2,29,105,'30.97',0),
 (19013,6,14,29,0,'0.00',0),
 (19014,6,15,29,0,'0.00',0),
 (19015,6,28,29,2,'0.59',0),
 (19016,6,32,29,0,'0.00',0),
 (19017,6,38,29,10,'2.95',0),
 (19018,6,40,29,1,'0.29',0),
 (19019,6,45,29,0,'0.00',0),
 (19020,6,48,29,0,'0.00',0),
 (19021,6,50,29,0,'0.00',0),
 (19022,6,51,29,2,'0.59',0),
 (19023,6,55,29,0,'0.00',0),
 (19024,6,56,29,2,'0.59',0),
 (19025,6,57,29,0,'0.00',0),
 (19026,6,58,29,0,'0.00',0),
 (19027,6,59,29,0,'0.00',0),
 (19028,6,60,29,0,'0.00',0),
 (19029,6,61,29,0,'0.00',0),
 (19030,6,62,29,0,'0.00',0),
 (19031,6,1,30,592,'61.03',0),
 (19032,6,2,30,309,'31.86',0),
 (19033,6,14,30,4,'0.41',0),
 (19034,6,15,30,1,'0.10',0),
 (19035,6,28,30,0,'0.00',0),
 (19036,6,32,30,1,'0.10',0),
 (19037,6,38,30,33,'3.40',0),
 (19038,6,40,30,2,'0.21',0),
 (19039,6,45,30,1,'0.10',0),
 (19040,6,48,30,3,'0.31',0),
 (19041,6,50,30,0,'0.00',0),
 (19042,6,51,30,3,'0.31',0),
 (19043,6,55,30,0,'0.00',0),
 (19044,6,56,30,3,'0.31',0),
 (19045,6,57,30,1,'0.10',0),
 (19046,6,58,30,0,'0.00',0),
 (19047,6,59,30,1,'0.10',0),
 (19048,6,60,30,0,'0.00',0),
 (19049,6,61,30,0,'0.00',0),
 (19050,6,62,30,1,'0.10',0),
 (19051,6,1,31,633,'42.68',0),
 (19052,6,2,31,746,'50.30',0),
 (19053,6,14,31,2,'0.13',0),
 (19054,6,15,31,0,'0.00',0),
 (19055,6,28,31,3,'0.20',0),
 (19056,6,32,31,1,'0.07',0),
 (19057,6,38,31,75,'5.06',0),
 (19058,6,40,31,0,'0.00',0),
 (19059,6,45,31,2,'0.13',0),
 (19060,6,48,31,0,'0.00',0),
 (19061,6,50,31,0,'0.00',0),
 (19062,6,51,31,0,'0.00',0),
 (19063,6,55,31,0,'0.00',0),
 (19064,6,56,31,2,'0.13',0),
 (19065,6,57,31,1,'0.07',0),
 (19066,6,58,31,0,'0.00',0),
 (19067,6,59,31,0,'0.00',0),
 (19068,6,60,31,0,'0.00',0),
 (19069,6,61,31,0,'0.00',0),
 (19070,6,62,31,1,'0.07',0),
 (19071,6,1,32,522,'40.12',0),
 (19072,6,2,32,583,'44.81',0),
 (19073,6,14,32,0,'0.00',0),
 (19074,6,15,32,4,'0.31',0),
 (19075,6,28,32,0,'0.00',0),
 (19076,6,32,32,0,'0.00',0),
 (19077,6,38,32,158,'12.14',0),
 (19078,6,40,32,0,'0.00',0),
 (19079,6,45,32,0,'0.00',0),
 (19080,6,48,32,0,'0.00',0),
 (19081,6,50,32,0,'0.00',0),
 (19082,6,51,32,9,'0.69',0),
 (19083,6,55,32,0,'0.00',0),
 (19084,6,56,32,3,'0.23',0),
 (19085,6,57,32,3,'0.23',0),
 (19086,6,58,32,1,'0.08',0),
 (19087,6,59,32,0,'0.00',0),
 (19088,6,60,32,1,'0.08',0),
 (19089,6,61,32,0,'0.00',0),
 (19090,6,62,32,0,'0.00',0),
 (19091,6,1,33,891,'56.07',0),
 (19092,6,2,33,594,'37.38',0),
 (19093,6,14,33,0,'0.00',0),
 (19094,6,15,33,0,'0.00',0),
 (19095,6,28,33,6,'0.38',0),
 (19096,6,32,33,0,'0.00',0),
 (19097,6,38,33,57,'3.59',0),
 (19098,6,40,33,0,'0.00',0),
 (19099,6,45,33,0,'0.00',0),
 (19100,6,48,33,0,'0.00',0),
 (19101,6,50,33,1,'0.06',0),
 (19102,6,51,33,8,'0.50',0),
 (19103,6,55,33,0,'0.00',0),
 (19104,6,56,33,2,'0.13',0),
 (19105,6,57,33,11,'0.69',0),
 (19106,6,58,33,0,'0.00',0),
 (19107,6,59,33,0,'0.00',0),
 (19108,6,60,33,1,'0.06',0),
 (19109,6,61,33,1,'0.06',0),
 (19110,6,62,33,0,'0.00',0),
 (19111,6,1,34,221,'67.58',0),
 (19112,6,2,34,94,'28.75',0),
 (19113,6,14,34,0,'0.00',0),
 (19114,6,15,34,0,'0.00',0),
 (19115,6,28,34,0,'0.00',0),
 (19116,6,32,34,0,'0.00',0),
 (19117,6,38,34,5,'1.53',0),
 (19118,6,40,34,0,'0.00',0),
 (19119,6,45,34,1,'0.31',0),
 (19120,6,48,34,0,'0.00',0),
 (19121,6,50,34,0,'0.00',0),
 (19122,6,51,34,0,'0.00',0),
 (19123,6,55,34,0,'0.00',0),
 (19124,6,56,34,0,'0.00',0),
 (19125,6,57,34,0,'0.00',0),
 (19126,6,58,34,0,'0.00',0),
 (19127,6,59,34,0,'0.00',0),
 (19128,6,60,34,0,'0.00',0),
 (19129,6,61,34,0,'0.00',0),
 (19130,6,62,34,0,'0.00',0),
 (19131,6,1,35,361,'46.70',0),
 (19132,6,2,35,311,'40.23',0),
 (19133,6,14,35,0,'0.00',0),
 (19134,6,15,35,0,'0.00',0),
 (19135,6,28,35,1,'0.13',0),
 (19136,6,32,35,1,'0.13',0),
 (19137,6,38,35,83,'10.74',0),
 (19138,6,40,35,0,'0.00',0),
 (19139,6,45,35,0,'0.00',0),
 (19140,6,48,35,0,'0.00',0),
 (19141,6,50,35,0,'0.00',0),
 (19142,6,51,35,1,'0.13',0),
 (19143,6,55,35,0,'0.00',0),
 (19144,6,56,35,1,'0.13',0),
 (19145,6,57,35,0,'0.00',0),
 (19146,6,58,35,2,'0.26',0),
 (19147,6,59,35,0,'0.00',0),
 (19148,6,60,35,1,'0.13',0),
 (19149,6,61,35,0,'0.00',0),
 (19150,6,62,35,0,'0.00',0),
 (19151,6,1,36,280,'54.26',0),
 (19152,6,2,36,71,'13.76',0),
 (19153,6,14,36,0,'0.00',0),
 (19154,6,15,36,0,'0.00',0),
 (19155,6,28,36,0,'0.00',0),
 (19156,6,32,36,0,'0.00',0),
 (19157,6,38,36,155,'30.04',0),
 (19158,6,40,36,0,'0.00',0),
 (19159,6,45,36,0,'0.00',0),
 (19160,6,48,36,0,'0.00',0),
 (19161,6,50,36,0,'0.00',0),
 (19162,6,51,36,0,'0.00',0),
 (19163,6,55,36,0,'0.00',0),
 (19164,6,56,36,0,'0.00',0),
 (19165,6,57,36,1,'0.19',0),
 (19166,6,58,36,0,'0.00',0),
 (19167,6,59,36,0,'0.00',0),
 (19168,6,60,36,0,'0.00',0),
 (19169,6,61,36,0,'0.00',0),
 (19170,6,62,36,0,'0.00',0),
 (19171,6,1,37,589,'45.98',0),
 (19172,6,2,37,637,'49.73',0),
 (19173,6,14,37,0,'0.00',0),
 (19174,6,15,37,1,'0.08',0),
 (19175,6,28,37,0,'0.00',0),
 (19176,6,32,37,0,'0.00',0),
 (19177,6,38,37,47,'3.67',0),
 (19178,6,40,37,0,'0.00',0),
 (19179,6,45,37,0,'0.00',0),
 (19180,6,48,37,1,'0.08',0),
 (19181,6,50,37,0,'0.00',0),
 (19182,6,51,37,2,'0.16',0),
 (19183,6,55,37,0,'0.00',0),
 (19184,6,56,37,0,'0.00',0),
 (19185,6,57,37,2,'0.16',0),
 (19186,6,58,37,0,'0.00',0),
 (19187,6,59,37,0,'0.00',0),
 (19188,6,60,37,0,'0.00',0),
 (19189,6,61,37,0,'0.00',0),
 (19190,6,62,37,0,'0.00',0),
 (19191,6,1,38,1577,'48.14',0),
 (19192,6,2,38,1352,'41.27',0),
 (19193,6,14,38,0,'0.00',0),
 (19194,6,15,38,1,'0.03',0),
 (19195,6,28,38,2,'0.06',0),
 (19196,6,32,38,1,'0.03',0),
 (19197,6,38,38,207,'6.32',0),
 (19198,6,40,38,1,'0.03',0),
 (19199,6,45,38,6,'0.18',0),
 (19200,6,48,38,1,'0.03',0),
 (19201,6,50,38,1,'0.03',0),
 (19202,6,51,38,23,'0.70',0),
 (19203,6,55,38,4,'0.12',0),
 (19204,6,56,38,16,'0.49',0),
 (19205,6,57,38,13,'0.40',0),
 (19206,6,58,38,0,'0.00',0),
 (19207,6,59,38,1,'0.03',0),
 (19208,6,60,38,5,'0.15',0),
 (19209,6,61,38,1,'0.03',0),
 (19210,6,62,38,2,'0.06',0),
 (19211,6,1,39,29,'38.16',0),
 (19212,6,2,39,39,'51.32',0),
 (19213,6,14,39,0,'0.00',0),
 (19214,6,15,39,0,'0.00',0),
 (19215,6,28,39,0,'0.00',0),
 (19216,6,32,39,0,'0.00',0),
 (19217,6,38,39,3,'3.95',0),
 (19218,6,40,39,0,'0.00',0),
 (19219,6,45,39,0,'0.00',0),
 (19220,6,48,39,0,'0.00',0),
 (19221,6,50,39,0,'0.00',0),
 (19222,6,51,39,0,'0.00',0),
 (19223,6,55,39,1,'1.32',0),
 (19224,6,56,39,0,'0.00',0),
 (19225,6,57,39,0,'0.00',0),
 (19226,6,58,39,1,'1.32',0),
 (19227,6,59,39,0,'0.00',0),
 (19228,6,60,39,0,'0.00',0),
 (19229,6,61,39,0,'0.00',0),
 (19230,6,62,39,0,'0.00',0),
 (19231,6,1,40,2682,'47.71',0),
 (19232,6,2,40,2276,'40.48',0),
 (19233,6,14,40,9,'0.16',0),
 (19234,6,15,40,6,'0.11',0),
 (19235,6,28,40,5,'0.09',0),
 (19236,6,32,40,4,'0.07',0),
 (19237,6,38,40,467,'8.31',0),
 (19238,6,40,40,5,'0.09',0),
 (19239,6,45,40,3,'0.05',0),
 (19240,6,48,40,1,'0.02',0),
 (19241,6,50,40,2,'0.04',0),
 (19242,6,51,40,20,'0.36',0),
 (19243,6,55,40,5,'0.09',0),
 (19244,6,56,40,30,'0.53',0),
 (19245,6,57,40,4,'0.07',0),
 (19246,6,58,40,2,'0.04',0),
 (19247,6,59,40,1,'0.02',0),
 (19248,6,60,40,4,'0.07',0),
 (19249,6,61,40,1,'0.02',0),
 (19250,6,62,40,2,'0.04',0),
 (19251,6,1,41,712,'50.11',0),
 (19252,6,2,41,544,'38.28',0),
 (19253,6,14,41,1,'0.07',0),
 (19254,6,15,41,1,'0.07',0),
 (19255,6,28,41,2,'0.14',0),
 (19256,6,32,41,0,'0.00',0),
 (19257,6,38,41,86,'6.05',0),
 (19258,6,40,41,1,'0.07',0),
 (19259,6,45,41,2,'0.14',0),
 (19260,6,48,41,3,'0.21',0),
 (19261,6,50,41,0,'0.00',0),
 (19262,6,51,41,8,'0.56',0),
 (19263,6,55,41,0,'0.00',0),
 (19264,6,56,41,8,'0.56',0),
 (19265,6,57,41,1,'0.07',0),
 (19266,6,58,41,0,'0.00',0),
 (19267,6,59,41,0,'0.00',0),
 (19268,6,60,41,0,'0.00',0),
 (19269,6,61,41,1,'0.07',0),
 (19270,6,62,41,1,'0.07',0),
 (19271,6,1,42,365,'69.26',0),
 (19272,6,2,42,128,'24.29',0),
 (19273,6,14,42,0,'0.00',0),
 (19274,6,15,42,0,'0.00',0),
 (19275,6,28,42,4,'0.76',0),
 (19276,6,32,42,0,'0.00',0),
 (19277,6,38,42,17,'3.23',0),
 (19278,6,40,42,0,'0.00',0),
 (19279,6,45,42,0,'0.00',0),
 (19280,6,48,42,0,'0.00',0),
 (19281,6,50,42,0,'0.00',0),
 (19282,6,51,42,0,'0.00',0),
 (19283,6,55,42,0,'0.00',0),
 (19284,6,56,42,2,'0.38',0),
 (19285,6,57,42,0,'0.00',0),
 (19286,6,58,42,0,'0.00',0),
 (19287,6,59,42,0,'0.00',0),
 (19288,6,60,42,2,'0.38',0),
 (19289,6,61,42,0,'0.00',0),
 (19290,6,62,42,0,'0.00',0),
 (19291,6,1,43,1604,'47.87',0),
 (19292,6,2,43,1502,'44.82',0),
 (19293,6,14,43,3,'0.09',0),
 (19294,6,15,43,0,'0.00',0),
 (19295,6,28,43,7,'0.21',0),
 (19296,6,32,43,4,'0.12',0),
 (19297,6,38,43,100,'2.98',0),
 (19298,6,40,43,0,'0.00',0),
 (19299,6,45,43,29,'0.87',0),
 (19300,6,48,43,3,'0.09',0),
 (19301,6,50,43,1,'0.03',0),
 (19302,6,51,43,11,'0.33',0),
 (19303,6,55,43,3,'0.09',0),
 (19304,6,56,43,5,'0.15',0),
 (19305,6,57,43,1,'0.03',0),
 (19306,6,58,43,5,'0.15',0),
 (19307,6,59,43,4,'0.12',0),
 (19308,6,60,43,8,'0.24',0),
 (19309,6,61,43,4,'0.12',0),
 (19310,6,62,43,4,'0.12',0),
 (19311,6,1,44,1199,'52.50',0),
 (19312,6,2,44,841,'36.82',0),
 (19313,6,14,44,1,'0.04',0),
 (19314,6,15,44,2,'0.09',0),
 (19315,6,28,44,1,'0.04',0),
 (19316,6,32,44,0,'0.00',0),
 (19317,6,38,44,136,'5.95',0),
 (19318,6,40,44,0,'0.00',0),
 (19319,6,45,44,0,'0.00',0),
 (19320,6,48,44,3,'0.13',0),
 (19321,6,50,44,0,'0.00',0),
 (19322,6,51,44,23,'1.01',0),
 (19323,6,55,44,1,'0.04',0),
 (19324,6,56,44,11,'0.48',0),
 (19325,6,57,44,3,'0.13',0),
 (19326,6,58,44,0,'0.00',0),
 (19327,6,59,44,0,'0.00',0),
 (19328,6,60,44,2,'0.09',0),
 (19329,6,61,44,0,'0.00',0),
 (19330,6,62,44,0,'0.00',0),
 (19331,6,1,45,7768,'51.22',0),
 (19332,6,2,45,5547,'36.58',0),
 (19333,6,14,45,17,'0.11',0),
 (19334,6,15,45,22,'0.15',0),
 (19335,6,28,45,13,'0.09',0),
 (19336,6,32,45,11,'0.07',0),
 (19337,6,38,45,1307,'8.62',0),
 (19338,6,40,45,14,'0.09',0),
 (19339,6,45,45,10,'0.07',0),
 (19340,6,48,45,1,'0.01',0),
 (19341,6,50,45,12,'0.08',0),
 (19342,6,51,45,117,'0.77',0),
 (19343,6,55,45,7,'0.05',0),
 (19344,6,56,45,100,'0.66',0),
 (19345,6,57,45,22,'0.15',0),
 (19346,6,58,45,14,'0.09',0),
 (19347,6,59,45,9,'0.06',0),
 (19348,6,60,45,10,'0.07',0),
 (19349,6,61,45,10,'0.07',0),
 (19350,6,62,45,5,'0.03',0),
 (19351,6,1,46,1168,'54.96',0),
 (19352,6,2,46,682,'32.09',0),
 (19353,6,14,46,1,'0.05',0),
 (19354,6,15,46,2,'0.09',0),
 (19355,6,28,46,4,'0.19',0),
 (19356,6,32,46,0,'0.00',0),
 (19357,6,38,46,143,'6.73',0),
 (19358,6,40,46,1,'0.05',0),
 (19359,6,45,46,2,'0.09',0),
 (19360,6,48,46,0,'0.00',0),
 (19361,6,50,46,0,'0.00',0),
 (19362,6,51,46,11,'0.52',0),
 (19363,6,55,46,2,'0.09',0),
 (19364,6,56,46,24,'1.13',0),
 (19365,6,57,46,26,'1.22',0),
 (19366,6,58,46,0,'0.00',0),
 (19367,6,59,46,1,'0.05',0),
 (19368,6,60,46,1,'0.05',0),
 (19369,6,61,46,2,'0.09',0),
 (19370,6,62,46,0,'0.00',0),
 (19371,6,1,47,7898,'44.87',0),
 (19372,6,2,47,7256,'41.22',0),
 (19373,6,14,47,17,'0.10',0),
 (19374,6,15,47,19,'0.11',0),
 (19375,6,28,47,31,'0.18',0),
 (19376,6,32,47,3,'0.02',0),
 (19377,6,38,47,1397,'7.94',0),
 (19378,6,40,47,12,'0.07',0),
 (19379,6,45,47,7,'0.04',0),
 (19380,6,48,47,12,'0.07',0),
 (19381,6,50,47,3,'0.02',0),
 (19382,6,51,47,186,'1.06',0),
 (19383,6,55,47,9,'0.05',0),
 (19384,6,56,47,209,'1.19',0),
 (19385,6,57,47,89,'0.51',0),
 (19386,6,58,47,6,'0.03',0),
 (19387,6,59,47,8,'0.05',0),
 (19388,6,60,47,18,'0.10',0),
 (19389,6,61,47,10,'0.06',0),
 (19390,6,62,47,18,'0.10',0),
 (19391,6,1,48,132,'42.86',0),
 (19392,6,2,48,149,'48.38',0),
 (19393,6,14,48,0,'0.00',0),
 (19394,6,15,48,0,'0.00',0),
 (19395,6,28,48,0,'0.00',0),
 (19396,6,32,48,0,'0.00',0),
 (19397,6,38,48,23,'7.47',0),
 (19398,6,40,48,0,'0.00',0),
 (19399,6,45,48,0,'0.00',0),
 (19400,6,48,48,0,'0.00',0),
 (19401,6,50,48,0,'0.00',0),
 (19402,6,51,48,0,'0.00',0),
 (19403,6,55,48,0,'0.00',0),
 (19404,6,56,48,0,'0.00',0),
 (19405,6,57,48,0,'0.00',0),
 (19406,6,58,48,0,'0.00',0),
 (19407,6,59,48,0,'0.00',0),
 (19408,6,60,48,0,'0.00',0),
 (19409,6,61,48,0,'0.00',0),
 (19410,6,62,48,0,'0.00',0),
 (19411,6,1,49,13087,'37.63',0),
 (19412,6,2,49,15128,'43.49',0),
 (19413,6,14,49,49,'0.14',0),
 (19414,6,15,49,79,'0.23',0),
 (19415,6,28,49,41,'0.12',0),
 (19416,6,32,49,17,'0.05',0),
 (19417,6,38,49,4810,'13.83',0),
 (19418,6,40,49,17,'0.05',0),
 (19419,6,45,49,40,'0.12',0),
 (19420,6,48,49,16,'0.05',0),
 (19421,6,50,49,4,'0.01',0),
 (19422,6,51,49,267,'0.77',0),
 (19423,6,55,49,15,'0.04',0),
 (19424,6,56,49,257,'0.74',0),
 (19425,6,57,49,63,'0.18',0),
 (19426,6,58,49,21,'0.06',0),
 (19427,6,59,49,20,'0.06',0),
 (19428,6,60,49,31,'0.09',0),
 (19429,6,61,49,25,'0.07',0),
 (19430,6,62,49,32,'0.09',0),
 (19431,6,1,50,534,'60.07',0),
 (19432,6,2,50,271,'30.48',0),
 (19433,6,14,50,1,'0.11',0),
 (19434,6,15,50,2,'0.22',0),
 (19435,6,28,50,3,'0.34',0),
 (19436,6,32,50,0,'0.00',0),
 (19437,6,38,50,45,'5.06',0),
 (19438,6,40,50,3,'0.34',0),
 (19439,6,45,50,0,'0.00',0),
 (19440,6,48,50,0,'0.00',0),
 (19441,6,50,50,0,'0.00',0),
 (19442,6,51,50,5,'0.56',0),
 (19443,6,55,50,2,'0.22',0),
 (19444,6,56,50,3,'0.34',0),
 (19445,6,57,50,2,'0.22',0),
 (19446,6,58,50,2,'0.22',0),
 (19447,6,59,50,1,'0.11',0),
 (19448,6,60,50,1,'0.11',0),
 (19449,6,61,50,0,'0.00',0),
 (19450,6,62,50,2,'0.22',0),
 (19451,6,1,51,465,'58.42',0),
 (19452,6,2,51,247,'31.03',0),
 (19453,6,14,51,0,'0.00',0),
 (19454,6,15,51,2,'0.25',0),
 (19455,6,28,51,5,'0.63',0),
 (19456,6,32,51,0,'0.00',0),
 (19457,6,38,51,43,'5.40',0),
 (19458,6,40,51,2,'0.25',0),
 (19459,6,45,51,2,'0.25',0),
 (19460,6,48,51,1,'0.13',0),
 (19461,6,50,51,0,'0.00',0),
 (19462,6,51,51,6,'0.75',0),
 (19463,6,55,51,0,'0.00',0),
 (19464,6,56,51,9,'1.13',0),
 (19465,6,57,51,2,'0.25',0),
 (19466,6,58,51,1,'0.13',0),
 (19467,6,59,51,0,'0.00',0),
 (19468,6,60,51,0,'0.00',0),
 (19469,6,61,51,2,'0.25',0),
 (19470,6,62,51,2,'0.25',0),
 (19471,6,1,52,1585,'62.01',0),
 (19472,6,2,52,831,'32.51',0),
 (19473,6,14,52,0,'0.00',0),
 (19474,6,15,52,3,'0.12',0),
 (19475,6,28,52,5,'0.20',0),
 (19476,6,32,52,1,'0.04',0),
 (19477,6,38,52,68,'2.66',0),
 (19478,6,40,52,0,'0.00',0),
 (19479,6,45,52,1,'0.04',0),
 (19480,6,48,52,15,'0.59',0),
 (19481,6,50,52,1,'0.04',0),
 (19482,6,51,52,4,'0.16',0),
 (19483,6,55,52,0,'0.00',0),
 (19484,6,56,52,4,'0.16',0),
 (19485,6,57,52,5,'0.20',0),
 (19486,6,58,52,0,'0.00',0),
 (19487,6,59,52,0,'0.00',0),
 (19488,6,60,52,1,'0.04',0),
 (19489,6,61,52,0,'0.00',0),
 (19490,6,62,52,1,'0.04',0),
 (19491,6,1,53,844,'48.98',0),
 (19492,6,2,53,651,'37.78',0),
 (19493,6,14,53,0,'0.00',0),
 (19494,6,15,53,0,'0.00',0),
 (19495,6,28,53,3,'0.17',0),
 (19496,6,32,53,1,'0.06',0),
 (19497,6,38,53,134,'7.78',0),
 (19498,6,40,53,0,'0.00',0),
 (19499,6,45,53,0,'0.00',0),
 (19500,6,48,53,0,'0.00',0),
 (19501,6,50,53,0,'0.00',0),
 (19502,6,51,53,31,'1.80',0),
 (19503,6,55,53,1,'0.06',0),
 (19504,6,56,53,8,'0.46',0),
 (19505,6,57,53,14,'0.81',0),
 (19506,6,58,53,0,'0.00',0),
 (19507,6,59,53,0,'0.00',0),
 (19508,6,60,53,2,'0.12',0),
 (19509,6,61,53,1,'0.06',0),
 (19510,6,62,53,0,'0.00',0),
 (19511,6,1,54,2851,'56.91',0),
 (19512,6,2,54,1585,'31.64',0),
 (19513,6,14,54,2,'0.04',0),
 (19514,6,15,54,4,'0.08',0),
 (19515,6,28,54,2,'0.04',0),
 (19516,6,32,54,0,'0.00',0),
 (19517,6,38,54,370,'7.39',0),
 (19518,6,40,54,4,'0.08',0),
 (19519,6,45,54,0,'0.00',0),
 (19520,6,48,54,4,'0.08',0),
 (19521,6,50,54,0,'0.00',0),
 (19522,6,51,54,34,'0.68',0),
 (19523,6,55,54,2,'0.04',0),
 (19524,6,56,54,35,'0.70',0),
 (19525,6,57,54,8,'0.16',0),
 (19526,6,58,54,0,'0.00',0),
 (19527,6,59,54,0,'0.00',0),
 (19528,6,60,54,1,'0.02',0),
 (19529,6,61,54,3,'0.06',0),
 (19530,6,62,54,3,'0.06',0),
 (19531,6,1,55,438,'58.09',0),
 (19532,6,2,55,298,'39.52',0),
 (19533,6,14,55,0,'0.00',0),
 (19534,6,15,55,0,'0.00',0),
 (19535,6,28,55,1,'0.13',0),
 (19536,6,32,55,0,'0.00',0),
 (19537,6,38,55,14,'1.86',0),
 (19538,6,40,55,0,'0.00',0),
 (19539,6,45,55,0,'0.00',0),
 (19540,6,48,55,0,'0.00',0),
 (19541,6,50,55,1,'0.13',0),
 (19542,6,51,55,0,'0.00',0),
 (19543,6,55,55,0,'0.00',0),
 (19544,6,56,55,0,'0.00',0),
 (19545,6,57,55,0,'0.00',0),
 (19546,6,58,55,0,'0.00',0),
 (19547,6,59,55,0,'0.00',0),
 (19548,6,60,55,1,'0.13',0),
 (19549,6,61,55,0,'0.00',0),
 (19550,6,62,55,0,'0.00',0),
 (19551,6,1,56,259,'63.79',0),
 (19552,6,2,56,105,'25.86',0),
 (19553,6,14,56,0,'0.00',0),
 (19554,6,15,56,1,'0.25',0),
 (19555,6,28,56,0,'0.00',0),
 (19556,6,32,56,0,'0.00',0),
 (19557,6,38,56,19,'4.68',0),
 (19558,6,40,56,1,'0.25',0),
 (19559,6,45,56,0,'0.00',0),
 (19560,6,48,56,0,'0.00',0),
 (19561,6,50,56,1,'0.25',0),
 (19562,6,51,56,1,'0.25',0),
 (19563,6,55,56,0,'0.00',0),
 (19564,6,56,56,3,'0.74',0),
 (19565,6,57,56,0,'0.00',0),
 (19566,6,58,56,0,'0.00',0),
 (19567,6,59,56,0,'0.00',0),
 (19568,6,60,56,0,'0.00',0),
 (19569,6,61,56,0,'0.00',0),
 (19570,6,62,56,0,'0.00',0),
 (19571,6,1,57,204,'52.99',0),
 (19572,6,2,57,125,'32.47',0),
 (19573,6,14,57,0,'0.00',0),
 (19574,6,15,57,0,'0.00',0),
 (19575,6,28,57,0,'0.00',0),
 (19576,6,32,57,0,'0.00',0),
 (19577,6,38,57,35,'9.09',0),
 (19578,6,40,57,0,'0.00',0),
 (19579,6,45,57,2,'0.52',0),
 (19580,6,48,57,0,'0.00',0),
 (19581,6,50,57,1,'0.26',0),
 (19582,6,51,57,5,'1.30',0),
 (19583,6,55,57,0,'0.00',0),
 (19584,6,56,57,4,'1.04',0),
 (19585,6,57,57,1,'0.26',0),
 (19586,6,58,57,0,'0.00',0),
 (19587,6,59,57,0,'0.00',0),
 (19588,6,60,57,1,'0.26',0),
 (19589,6,61,57,0,'0.00',0),
 (19590,6,62,57,0,'0.00',0),
 (19591,6,1,58,25696,'35.07',0),
 (19592,6,2,58,38105,'52.00',0),
 (19593,6,14,58,50,'0.07',0),
 (19594,6,15,58,94,'0.13',0),
 (19595,6,28,58,113,'0.15',0),
 (19596,6,32,58,33,'0.05',0),
 (19597,6,38,58,5863,'8.00',0),
 (19598,6,40,58,37,'0.05',0),
 (19599,6,45,58,55,'0.08',0),
 (19600,6,48,58,172,'0.23',0),
 (19601,6,50,58,24,'0.03',0),
 (19602,6,51,58,566,'0.77',0),
 (19603,6,55,58,41,'0.06',0),
 (19604,6,56,58,663,'0.90',0),
 (19605,6,57,58,160,'0.22',0),
 (19606,6,58,58,30,'0.04',0),
 (19607,6,59,58,22,'0.03',0),
 (19608,6,60,58,42,'0.06',0),
 (19609,6,61,58,24,'0.03',0),
 (19610,6,62,58,50,'0.07',0),
 (19611,6,1,59,1077,'55.26',0),
 (19612,6,2,59,681,'34.94',0),
 (19613,6,14,59,0,'0.00',0),
 (19614,6,15,59,2,'0.10',0),
 (19615,6,28,59,3,'0.15',0),
 (19616,6,32,59,2,'0.10',0),
 (19617,6,38,59,120,'6.16',0),
 (19618,6,40,59,2,'0.10',0),
 (19619,6,45,59,2,'0.10',0),
 (19620,6,48,59,1,'0.05',0),
 (19621,6,50,59,1,'0.05',0),
 (19622,6,51,59,5,'0.26',0),
 (19623,6,55,59,0,'0.00',0),
 (19624,6,56,59,12,'0.62',0),
 (19625,6,57,59,0,'0.00',0),
 (19626,6,58,59,0,'0.00',0),
 (19627,6,59,59,1,'0.05',0),
 (19628,6,60,59,2,'0.10',0),
 (19629,6,61,59,2,'0.10',0),
 (19630,6,62,59,1,'0.05',0),
 (19631,6,1,60,319,'31.34',0),
 (19632,6,2,60,563,'55.30',0),
 (19633,6,14,60,0,'0.00',0),
 (19634,6,15,60,0,'0.00',0),
 (19635,6,28,60,0,'0.00',0),
 (19636,6,32,60,0,'0.00',0),
 (19637,6,38,60,124,'12.18',0),
 (19638,6,40,60,0,'0.00',0),
 (19639,6,45,60,1,'0.10',0),
 (19640,6,48,60,0,'0.00',0),
 (19641,6,50,60,0,'0.00',0),
 (19642,6,51,60,1,'0.10',0),
 (19643,6,55,60,0,'0.00',0),
 (19644,6,56,60,1,'0.10',0),
 (19645,6,57,60,0,'0.00',0),
 (19646,6,58,60,0,'0.00',0),
 (19647,6,59,60,0,'0.00',0),
 (19648,6,60,60,0,'0.00',0),
 (19649,6,61,60,0,'0.00',0),
 (19650,6,62,60,0,'0.00',0),
 (19651,6,1,61,5249,'54.60',0),
 (19652,6,2,61,3332,'34.66',0),
 (19653,6,14,61,5,'0.05',0),
 (19654,6,15,61,8,'0.08',0),
 (19655,6,28,61,10,'0.10',0),
 (19656,6,32,61,2,'0.02',0),
 (19657,6,38,61,483,'5.02',0),
 (19658,6,40,61,4,'0.04',0),
 (19659,6,45,61,10,'0.10',0),
 (19660,6,48,61,31,'0.32',0),
 (19661,6,50,61,2,'0.02',0),
 (19662,6,51,61,77,'0.80',0),
 (19663,6,55,61,4,'0.04',0),
 (19664,6,56,61,79,'0.82',0),
 (19665,6,57,61,31,'0.32',0),
 (19666,6,58,61,6,'0.06',0),
 (19667,6,59,61,4,'0.04',0),
 (19668,6,60,61,15,'0.16',0),
 (19669,6,61,61,0,'0.00',0),
 (19670,6,62,61,5,'0.05',0),
 (19671,6,1,62,151,'70.89',0),
 (19672,6,2,62,50,'23.47',0),
 (19673,6,14,62,0,'0.00',0),
 (19674,6,15,62,0,'0.00',0),
 (19675,6,28,62,0,'0.00',0),
 (19676,6,32,62,0,'0.00',0),
 (19677,6,38,62,8,'3.76',0),
 (19678,6,40,62,0,'0.00',0),
 (19679,6,45,62,0,'0.00',0),
 (19680,6,48,62,0,'0.00',0),
 (19681,6,50,62,0,'0.00',0),
 (19682,6,51,62,0,'0.00',0),
 (19683,6,55,62,0,'0.00',0),
 (19684,6,56,62,0,'0.00',0),
 (19685,6,57,62,0,'0.00',0),
 (19686,6,58,62,0,'0.00',0),
 (19687,6,59,62,0,'0.00',0),
 (19688,6,60,62,1,'0.47',0),
 (19689,6,61,62,0,'0.00',0),
 (19690,6,62,62,0,'0.00',0),
 (19691,6,1,63,92,'57.86',0),
 (19692,6,2,63,36,'22.64',0),
 (19693,6,14,63,0,'0.00',0),
 (19694,6,15,63,0,'0.00',0),
 (19695,6,28,63,0,'0.00',0),
 (19696,6,32,63,0,'0.00',0),
 (19697,6,38,63,25,'15.72',0),
 (19698,6,40,63,0,'0.00',0),
 (19699,6,45,63,0,'0.00',0),
 (19700,6,48,63,0,'0.00',0),
 (19701,6,50,63,0,'0.00',0),
 (19702,6,51,63,1,'0.63',0),
 (19703,6,55,63,0,'0.00',0),
 (19704,6,56,63,1,'0.63',0),
 (19705,6,57,63,0,'0.00',0),
 (19706,6,58,63,0,'0.00',0),
 (19707,6,59,63,0,'0.00',0),
 (19708,6,60,63,0,'0.00',0),
 (19709,6,61,63,0,'0.00',0),
 (19710,6,62,63,0,'0.00',0),
 (19711,6,1,64,59,'71.08',0),
 (19712,6,2,64,22,'26.51',0),
 (19713,6,14,64,0,'0.00',0),
 (19714,6,15,64,0,'0.00',0),
 (19715,6,28,64,0,'0.00',0),
 (19716,6,32,64,0,'0.00',0),
 (19717,6,38,64,1,'1.20',0),
 (19718,6,40,64,0,'0.00',0),
 (19719,6,45,64,0,'0.00',0),
 (19720,6,48,64,0,'0.00',0),
 (19721,6,50,64,0,'0.00',0),
 (19722,6,51,64,0,'0.00',0),
 (19723,6,55,64,0,'0.00',0),
 (19724,6,56,64,0,'0.00',0),
 (19725,6,57,64,0,'0.00',0),
 (19726,6,58,64,0,'0.00',0),
 (19727,6,59,64,0,'0.00',0),
 (19728,6,60,64,0,'0.00',0),
 (19729,6,61,64,0,'0.00',0),
 (19730,6,62,64,0,'0.00',0),
 (19731,6,1,65,29985,'39.37',0),
 (19732,6,2,65,33920,'44.54',0),
 (19733,6,14,65,66,'0.09',0),
 (19734,6,15,65,148,'0.19',0),
 (19735,6,28,65,78,'0.10',0),
 (19736,6,32,65,36,'0.05',0),
 (19737,6,38,65,8671,'11.38',0),
 (19738,6,40,65,26,'0.03',0),
 (19739,6,45,65,62,'0.08',0),
 (19740,6,48,65,23,'0.03',0),
 (19741,6,50,65,73,'0.10',0),
 (19742,6,51,65,695,'0.91',0),
 (19743,6,55,65,39,'0.05',0),
 (19744,6,56,65,680,'0.89',0),
 (19745,6,57,65,302,'0.40',0),
 (19746,6,58,65,62,'0.08',0),
 (19747,6,59,65,31,'0.04',0),
 (19748,6,60,65,30,'0.04',0),
 (19749,6,61,65,35,'0.05',0),
 (19750,6,62,65,51,'0.07',0),
 (19751,6,1,66,1648,'68.47',0),
 (19752,6,2,66,569,'23.64',0),
 (19753,6,14,66,3,'0.12',0),
 (19754,6,15,66,1,'0.04',0),
 (19755,6,28,66,4,'0.17',0),
 (19756,6,32,66,0,'0.00',0),
 (19757,6,38,66,83,'3.45',0),
 (19758,6,40,66,3,'0.12',0),
 (19759,6,45,66,0,'0.00',0),
 (19760,6,48,66,13,'0.54',0),
 (19761,6,50,66,1,'0.04',0),
 (19762,6,51,66,12,'0.50',0),
 (19763,6,55,66,1,'0.04',0),
 (19764,6,56,66,12,'0.50',0),
 (19765,6,57,66,8,'0.33',0),
 (19766,6,58,66,3,'0.12',0),
 (19767,6,59,66,1,'0.04',0),
 (19768,6,60,66,2,'0.08',0),
 (19769,6,61,66,1,'0.04',0),
 (19770,6,62,66,0,'0.00',0),
 (19771,6,1,67,860,'48.21',0),
 (19772,6,2,67,707,'39.63',0),
 (19773,6,14,67,0,'0.00',0),
 (19774,6,15,67,1,'0.06',0),
 (19775,6,28,67,1,'0.06',0),
 (19776,6,32,67,2,'0.11',0),
 (19777,6,38,67,159,'8.91',0),
 (19778,6,40,67,1,'0.06',0),
 (19779,6,45,67,1,'0.06',0),
 (19780,6,48,67,0,'0.00',0),
 (19781,6,50,67,0,'0.00',0),
 (19782,6,51,67,5,'0.28',0),
 (19783,6,55,67,0,'0.00',0),
 (19784,6,56,67,5,'0.28',0),
 (19785,6,57,67,6,'0.34',0),
 (19786,6,58,67,0,'0.00',0),
 (19787,6,59,67,1,'0.06',0),
 (19788,6,60,67,0,'0.00',0),
 (19789,6,61,67,1,'0.06',0),
 (19790,6,62,67,0,'0.00',0),
 (19791,6,1,68,2438,'53.65',0),
 (19792,6,2,68,1723,'37.92',0),
 (19793,6,14,68,3,'0.07',0),
 (19794,6,15,68,7,'0.15',0),
 (19795,6,28,68,11,'0.24',0),
 (19796,6,32,68,6,'0.13',0),
 (19797,6,38,68,158,'3.48',0),
 (19798,6,40,68,1,'0.02',0),
 (19799,6,45,68,7,'0.15',0),
 (19800,6,48,68,0,'0.00',0),
 (19801,6,50,68,2,'0.04',0),
 (19802,6,51,68,30,'0.66',0),
 (19803,6,55,68,3,'0.07',0),
 (19804,6,56,68,24,'0.53',0),
 (19805,6,57,68,10,'0.22',0),
 (19806,6,58,68,2,'0.04',0),
 (19807,6,59,68,5,'0.11',0),
 (19808,6,60,68,5,'0.11',0),
 (19809,6,61,68,2,'0.04',0),
 (19810,6,62,68,5,'0.11',0),
 (19811,6,1,69,29,'67.44',0),
 (19812,6,2,69,8,'18.60',0),
 (19813,6,14,69,1,'2.33',0),
 (19814,6,15,69,0,'0.00',0),
 (19815,6,28,69,0,'0.00',0),
 (19816,6,32,69,0,'0.00',0),
 (19817,6,38,69,4,'9.30',0),
 (19818,6,40,69,0,'0.00',0),
 (19819,6,45,69,0,'0.00',0),
 (19820,6,48,69,0,'0.00',0),
 (19821,6,50,69,0,'0.00',0),
 (19822,6,51,69,0,'0.00',0),
 (19823,6,55,69,0,'0.00',0),
 (19824,6,56,69,0,'0.00',0),
 (19825,6,57,69,0,'0.00',0),
 (19826,6,58,69,0,'0.00',0),
 (19827,6,59,69,0,'0.00',0),
 (19828,6,60,69,0,'0.00',0),
 (19829,6,61,69,0,'0.00',0),
 (19830,6,62,69,0,'0.00',0),
 (19831,6,1,70,86,'72.27',0),
 (19832,6,2,70,24,'20.17',0),
 (19833,6,14,70,0,'0.00',0),
 (19834,6,15,70,0,'0.00',0),
 (19835,6,28,70,1,'0.84',0),
 (19836,6,32,70,1,'0.84',0),
 (19837,6,38,70,6,'5.04',0),
 (19838,6,40,70,0,'0.00',0),
 (19839,6,45,70,0,'0.00',0),
 (19840,6,48,70,0,'0.00',0),
 (19841,6,50,70,0,'0.00',0),
 (19842,6,51,70,0,'0.00',0),
 (19843,6,55,70,0,'0.00',0),
 (19844,6,56,70,0,'0.00',0),
 (19845,6,57,70,0,'0.00',0),
 (19846,6,58,70,0,'0.00',0),
 (19847,6,59,70,0,'0.00',0),
 (19848,6,60,70,0,'0.00',0),
 (19849,6,61,70,0,'0.00',0),
 (19850,6,62,70,0,'0.00',0),
 (19851,6,1,71,34,'54.84',0),
 (19852,6,2,71,22,'35.48',0),
 (19853,6,14,71,0,'0.00',0),
 (19854,6,15,71,0,'0.00',0),
 (19855,6,28,71,0,'0.00',0),
 (19856,6,32,71,0,'0.00',0),
 (19857,6,38,71,5,'8.06',0),
 (19858,6,40,71,0,'0.00',0),
 (19859,6,45,71,0,'0.00',0),
 (19860,6,48,71,0,'0.00',0),
 (19861,6,50,71,0,'0.00',0),
 (19862,6,51,71,0,'0.00',0),
 (19863,6,55,71,0,'0.00',0),
 (19864,6,56,71,0,'0.00',0),
 (19865,6,57,71,0,'0.00',0),
 (19866,6,58,71,0,'0.00',0),
 (19867,6,59,71,0,'0.00',0),
 (19868,6,60,71,0,'0.00',0),
 (19869,6,61,71,0,'0.00',0),
 (19870,6,62,71,0,'0.00',0),
 (19871,6,1,72,1696,'60.90',0),
 (19872,6,2,72,739,'26.54',0),
 (19873,6,14,72,2,'0.07',0),
 (19874,6,15,72,3,'0.11',0),
 (19875,6,28,72,9,'0.32',0),
 (19876,6,32,72,2,'0.07',0),
 (19877,6,38,72,156,'5.60',0),
 (19878,6,40,72,3,'0.11',0),
 (19879,6,45,72,0,'0.00',0),
 (19880,6,48,72,6,'0.22',0),
 (19881,6,50,72,0,'0.00',0),
 (19882,6,51,72,32,'1.15',0),
 (19883,6,55,72,0,'0.00',0),
 (19884,6,56,72,19,'0.68',0),
 (19885,6,57,72,5,'0.18',0),
 (19886,6,58,72,4,'0.14',0),
 (19887,6,59,72,1,'0.04',0),
 (19888,6,60,72,5,'0.18',0),
 (19889,6,61,72,4,'0.14',0),
 (19890,6,62,72,2,'0.07',0),
 (19891,6,1,73,1738,'42.64',0),
 (19892,6,2,73,1979,'48.55',0),
 (19893,6,14,73,4,'0.10',0),
 (19894,6,15,73,4,'0.10',0),
 (19895,6,28,73,5,'0.12',0),
 (19896,6,32,73,9,'0.22',0),
 (19897,6,38,73,239,'5.86',0),
 (19898,6,40,73,0,'0.00',0),
 (19899,6,45,73,3,'0.07',0),
 (19900,6,48,73,24,'0.59',0),
 (19901,6,50,73,1,'0.02',0),
 (19902,6,51,73,36,'0.88',0),
 (19903,6,55,73,1,'0.02',0),
 (19904,6,56,73,32,'0.79',0),
 (19905,6,57,73,9,'0.22',0),
 (19906,6,58,73,2,'0.05',0),
 (19907,6,59,73,6,'0.15',0),
 (19908,6,60,73,3,'0.07',0),
 (19909,6,61,73,4,'0.10',0),
 (19910,6,62,73,2,'0.05',0),
 (19911,6,1,74,32124,'37.87',0),
 (19912,6,2,74,39034,'46.02',0),
 (19913,6,14,74,134,'0.16',0),
 (19914,6,15,74,192,'0.23',0),
 (19915,6,28,74,98,'0.12',0),
 (19916,6,32,74,34,'0.04',0),
 (19917,6,38,74,9292,'10.95',0),
 (19918,6,40,74,39,'0.05',0),
 (19919,6,45,74,59,'0.07',0),
 (19920,6,48,74,34,'0.04',0),
 (19921,6,50,74,27,'0.03',0),
 (19922,6,51,74,738,'0.87',0),
 (19923,6,55,74,101,'0.12',0),
 (19924,6,56,74,684,'0.81',0),
 (19925,6,57,74,306,'0.36',0),
 (19926,6,58,74,48,'0.06',0),
 (19927,6,59,74,37,'0.04',0),
 (19928,6,60,74,89,'0.10',0),
 (19929,6,61,74,47,'0.06',0),
 (19930,6,62,74,50,'0.06',0),
 (19931,6,1,75,918,'50.08',0),
 (19932,6,2,75,733,'39.99',0),
 (19933,6,14,75,1,'0.05',0),
 (19934,6,15,75,0,'0.00',0),
 (19935,6,28,75,2,'0.11',0),
 (19936,6,32,75,0,'0.00',0),
 (19937,6,38,75,148,'8.07',0),
 (19938,6,40,75,1,'0.05',0),
 (19939,6,45,75,3,'0.16',0),
 (19940,6,48,75,0,'0.00',0),
 (19941,6,50,75,1,'0.05',0),
 (19942,6,51,75,3,'0.16',0),
 (19943,6,55,75,0,'0.00',0),
 (19944,6,56,75,8,'0.44',0),
 (19945,6,57,75,2,'0.11',0),
 (19946,6,58,75,0,'0.00',0),
 (19947,6,59,75,0,'0.00',0),
 (19948,6,60,75,2,'0.11',0),
 (19949,6,61,75,0,'0.00',0),
 (19950,6,62,75,0,'0.00',0),
 (19951,6,1,76,177,'53.31',0),
 (19952,6,2,76,118,'35.54',0),
 (19953,6,14,76,0,'0.00',0),
 (19954,6,15,76,1,'0.30',0),
 (19955,6,28,76,1,'0.30',0),
 (19956,6,32,76,0,'0.00',0),
 (19957,6,38,76,14,'4.22',0),
 (19958,6,40,76,0,'0.00',0),
 (19959,6,45,76,0,'0.00',0),
 (19960,6,48,76,2,'0.60',0),
 (19961,6,50,76,0,'0.00',0),
 (19962,6,51,76,0,'0.00',0),
 (19963,6,55,76,1,'0.30',0),
 (19964,6,56,76,2,'0.60',0),
 (19965,6,57,76,0,'0.00',0),
 (19966,6,58,76,0,'0.00',0),
 (19967,6,59,76,1,'0.30',0),
 (19968,6,60,76,0,'0.00',0),
 (19969,6,61,76,0,'0.00',0),
 (19970,6,62,76,0,'0.00',0),
 (19971,6,1,78,15,'71.43',0),
 (19972,6,2,78,6,'28.57',0),
 (19973,6,14,78,0,'0.00',0),
 (19974,6,15,78,0,'0.00',0),
 (19975,6,28,78,0,'0.00',0),
 (19976,6,32,78,0,'0.00',0),
 (19977,6,38,78,0,'0.00',0),
 (19978,6,40,78,0,'0.00',0),
 (19979,6,45,78,0,'0.00',0),
 (19980,6,48,78,0,'0.00',0),
 (19981,6,50,78,0,'0.00',0),
 (19982,6,51,78,0,'0.00',0),
 (19983,6,55,78,0,'0.00',0),
 (19984,6,56,78,0,'0.00',0),
 (19985,6,57,78,0,'0.00',0),
 (19986,6,58,78,0,'0.00',0),
 (19987,6,59,78,0,'0.00',0),
 (19988,6,60,78,0,'0.00',0),
 (19989,6,61,78,0,'0.00',0),
 (19990,6,62,78,0,'0.00',0),
 (19991,6,1,79,806074,'54.35',0),
 (19992,6,2,79,504734,'34.03',0),
 (19993,6,14,79,1302,'0.09',0),
 (19994,6,15,79,1248,'0.08',0),
 (19995,6,28,79,2257,'0.15',0),
 (19996,6,32,79,438,'0.03',0),
 (19997,6,38,79,104122,'7.02',0),
 (19998,6,40,79,894,'0.06',0),
 (19999,6,45,79,967,'0.07',0),
 (20000,6,48,79,719,'0.05',0),
 (20001,6,50,79,437,'0.03',0),
 (20002,6,51,79,8150,'0.55',0),
 (20003,6,55,79,1674,'0.11',0),
 (20004,6,56,79,7192,'0.48',0),
 (20005,6,57,79,3988,'0.27',0),
 (20006,6,58,79,733,'0.05',0),
 (20007,6,59,79,397,'0.03',0),
 (20008,6,60,79,1273,'0.09',0),
 (20009,6,61,79,804,'0.05',0),
 (20010,6,62,79,672,'0.05',0),
 (20011,6,1,80,13076,'61.85',0),
 (20012,6,2,80,5451,'25.79',0),
 (20013,6,14,80,18,'0.09',0),
 (20014,6,15,80,19,'0.09',0),
 (20015,6,28,80,31,'0.15',0),
 (20016,6,32,80,4,'0.02',0),
 (20017,6,38,80,1004,'4.75',0),
 (20018,6,40,80,8,'0.04',0),
 (20019,6,45,80,16,'0.08',0),
 (20020,6,48,80,16,'0.08',0),
 (20021,6,50,80,3,'0.01',0),
 (20022,6,51,80,171,'0.81',0),
 (20023,6,55,80,9,'0.04',0),
 (20024,6,56,80,141,'0.67',0),
 (20025,6,57,80,212,'1.00',0),
 (20026,6,58,80,10,'0.05',0),
 (20027,6,59,80,1,'0.00',0),
 (20028,6,60,80,26,'0.12',0),
 (20029,6,61,80,11,'0.05',0),
 (20030,6,62,80,17,'0.08',0),
 (20031,6,1,82,1297,'61.53',0),
 (20032,6,2,82,568,'26.94',0),
 (20033,6,14,82,2,'0.09',0),
 (20034,6,15,82,2,'0.09',0),
 (20035,6,28,82,6,'0.28',0),
 (20036,6,32,82,0,'0.00',0),
 (20037,6,38,82,104,'4.93',0),
 (20038,6,40,82,2,'0.09',0),
 (20039,6,45,82,0,'0.00',0),
 (20040,6,48,82,0,'0.00',0),
 (20041,6,50,82,1,'0.05',0),
 (20042,6,51,82,20,'0.95',0),
 (20043,6,55,82,22,'1.04',0),
 (20044,6,56,82,15,'0.71',0),
 (20045,6,57,82,9,'0.43',0),
 (20046,6,58,82,0,'0.00',0),
 (20047,6,59,82,0,'0.00',0),
 (20048,6,60,82,1,'0.05',0),
 (20049,6,61,82,2,'0.09',0),
 (20050,6,62,82,1,'0.05',0),
 (20051,6,1,83,1003,'43.03',0),
 (20052,6,2,83,927,'39.77',0),
 (20053,6,14,83,2,'0.09',0),
 (20054,6,15,83,11,'0.47',0),
 (20055,6,28,83,8,'0.34',0),
 (20056,6,32,83,3,'0.13',0),
 (20057,6,38,83,241,'10.34',0),
 (20058,6,40,83,2,'0.09',0),
 (20059,6,45,83,1,'0.04',0),
 (20060,6,48,83,7,'0.30',0),
 (20061,6,50,83,1,'0.04',0),
 (20062,6,51,83,24,'1.03',0),
 (20063,6,55,83,1,'0.04',0),
 (20064,6,56,83,32,'1.37',0),
 (20065,6,57,83,7,'0.30',0),
 (20066,6,58,83,2,'0.09',0),
 (20067,6,59,83,6,'0.26',0),
 (20068,6,60,83,3,'0.13',0),
 (20069,6,61,83,1,'0.04',0),
 (20070,6,62,83,1,'0.04',0),
 (20071,6,1,84,2500,'36.27',0),
 (20072,6,2,84,2817,'40.87',0),
 (20073,6,14,84,0,'0.00',0),
 (20074,6,15,84,6,'0.09',0),
 (20075,6,28,84,7,'0.10',0),
 (20076,6,32,84,1,'0.01',0),
 (20077,6,38,84,1274,'18.49',0),
 (20078,6,40,84,3,'0.04',0),
 (20079,6,45,84,5,'0.07',0),
 (20080,6,48,84,2,'0.03',0),
 (20081,6,50,84,2,'0.03',0),
 (20082,6,51,84,68,'0.99',0),
 (20083,6,55,84,3,'0.04',0),
 (20084,6,56,84,77,'1.12',0),
 (20085,6,57,84,16,'0.23',0),
 (20086,6,58,84,4,'0.06',0),
 (20087,6,59,84,0,'0.00',0),
 (20088,6,60,84,5,'0.07',0),
 (20089,6,61,84,4,'0.06',0),
 (20090,6,62,84,2,'0.03',0),
 (20091,6,1,85,1015,'47.23',0),
 (20092,6,2,85,937,'43.60',0),
 (20093,6,14,85,0,'0.00',0),
 (20094,6,15,85,1,'0.05',0),
 (20095,6,28,85,17,'0.79',0),
 (20096,6,32,85,0,'0.00',0),
 (20097,6,38,85,79,'3.68',0),
 (20098,6,40,85,1,'0.05',0),
 (20099,6,45,85,2,'0.09',0),
 (20100,6,48,85,0,'0.00',0),
 (20101,6,50,85,0,'0.00',0),
 (20102,6,51,85,13,'0.60',0),
 (20103,6,55,85,2,'0.09',0),
 (20104,6,56,85,10,'0.47',0),
 (20105,6,57,85,4,'0.19',0),
 (20106,6,58,85,2,'0.09',0),
 (20107,6,59,85,1,'0.05',0),
 (20108,6,60,85,2,'0.09',0),
 (20109,6,61,85,2,'0.09',0),
 (20110,6,62,85,0,'0.00',0),
 (20111,6,1,86,1058,'60.18',0),
 (20112,6,2,86,624,'35.49',0),
 (20113,6,14,86,2,'0.11',0),
 (20114,6,15,86,1,'0.06',0),
 (20115,6,28,86,4,'0.23',0),
 (20116,6,32,86,2,'0.11',0),
 (20117,6,38,86,95,'5.40',0),
 (20118,6,40,86,3,'0.17',0),
 (20119,6,45,86,6,'0.34',0),
 (20120,6,48,86,1,'0.06',0),
 (20121,6,50,86,1,'0.06',0),
 (20122,6,51,86,6,'0.34',0),
 (20123,6,55,86,1,'0.06',0),
 (20124,6,56,86,3,'0.17',0),
 (20125,6,57,86,22,'1.25',0),
 (20126,6,58,86,2,'0.11',0),
 (20127,6,59,86,3,'0.17',0),
 (20128,6,60,86,4,'0.23',0),
 (20129,6,61,86,2,'0.11',0),
 (20130,6,62,86,0,'0.00',0),
 (20131,6,1,87,1046,'57.89',0),
 (20132,6,2,87,597,'33.04',0),
 (20133,6,14,87,0,'0.00',0),
 (20134,6,15,87,0,'0.00',0),
 (20135,6,28,87,4,'0.22',0),
 (20136,6,32,87,0,'0.00',0),
 (20137,6,38,87,85,'4.70',0),
 (20138,6,40,87,1,'0.06',0),
 (20139,6,45,87,0,'0.00',0),
 (20140,6,48,87,4,'0.22',0),
 (20141,6,50,87,1,'0.06',0),
 (20142,6,51,87,10,'0.55',0),
 (20143,6,55,87,2,'0.11',0),
 (20144,6,56,87,6,'0.33',0),
 (20145,6,57,87,0,'0.00',0),
 (20146,6,58,87,0,'0.00',0),
 (20147,6,59,87,0,'0.00',0),
 (20148,6,60,87,3,'0.17',0),
 (20149,6,61,87,1,'0.06',0),
 (20150,6,62,87,3,'0.17',0),
 (20151,6,1,88,93,'44.93',0),
 (20152,6,2,88,97,'46.86',0),
 (20153,6,14,88,0,'0.00',0),
 (20154,6,15,88,0,'0.00',0),
 (20155,6,28,88,0,'0.00',0),
 (20156,6,32,88,0,'0.00',0),
 (20157,6,38,88,11,'5.31',0),
 (20158,6,40,88,0,'0.00',0),
 (20159,6,45,88,0,'0.00',0),
 (20160,6,48,88,0,'0.00',0),
 (20161,6,50,88,0,'0.00',0),
 (20162,6,51,88,1,'0.48',0),
 (20163,6,55,88,0,'0.00',0),
 (20164,6,56,88,0,'0.00',0),
 (20165,6,57,88,0,'0.00',0),
 (20166,6,58,88,0,'0.00',0),
 (20167,6,59,88,0,'0.00',0),
 (20168,6,60,88,0,'0.00',0),
 (20169,6,61,88,0,'0.00',0),
 (20170,6,62,88,0,'0.00',0),
 (20171,6,1,89,896,'57.18',0),
 (20172,6,2,89,574,'36.63',0),
 (20173,6,14,89,2,'0.13',0),
 (20174,6,15,89,2,'0.13',0),
 (20175,6,28,89,0,'0.00',0),
 (20176,6,32,89,0,'0.00',0),
 (20177,6,38,89,54,'3.45',0),
 (20178,6,40,89,0,'0.00',0),
 (20179,6,45,89,0,'0.00',0),
 (20180,6,48,89,0,'0.00',0),
 (20181,6,50,89,0,'0.00',0),
 (20182,6,51,89,7,'0.45',0),
 (20183,6,55,89,0,'0.00',0),
 (20184,6,56,89,6,'0.38',0),
 (20185,6,57,89,1,'0.06',0),
 (20186,6,58,89,0,'0.00',0),
 (20187,6,59,89,0,'0.00',0),
 (20188,6,60,89,1,'0.06',0),
 (20189,6,61,89,0,'0.00',0),
 (20190,6,62,89,1,'0.06',0),
 (20191,6,1,90,1398,'57.04',0),
 (20192,6,2,90,825,'33.66',0),
 (20193,6,14,90,1,'0.04',0),
 (20194,6,15,90,1,'0.04',0),
 (20195,6,28,90,1,'0.04',0),
 (20196,6,32,90,0,'0.00',0),
 (20197,6,38,90,115,'4.69',0),
 (20198,6,40,90,4,'0.16',0),
 (20199,6,45,90,2,'0.08',0),
 (20200,6,48,90,1,'0.04',0),
 (20201,6,50,90,0,'0.00',0),
 (20202,6,51,90,13,'0.53',0),
 (20203,6,55,90,2,'0.08',0),
 (20204,6,56,90,12,'0.49',0),
 (20205,6,57,90,4,'0.16',0),
 (20206,6,58,90,2,'0.08',0),
 (20207,6,59,90,1,'0.04',0),
 (20208,6,60,90,3,'0.12',0),
 (20209,6,61,90,2,'0.08',0),
 (20210,6,62,90,4,'0.16',0),
 (20211,6,1,91,1514,'46.92',0),
 (20212,6,2,91,1421,'44.03',0),
 (20213,6,14,91,0,'0.00',0),
 (20214,6,15,91,7,'0.22',0),
 (20215,6,28,91,5,'0.15',0),
 (20216,6,32,91,1,'0.03',0),
 (20217,6,38,91,225,'6.97',0),
 (20218,6,40,91,1,'0.03',0),
 (20219,6,45,91,0,'0.00',0),
 (20220,6,48,91,0,'0.00',0),
 (20221,6,50,91,0,'0.00',0),
 (20222,6,51,91,6,'0.19',0),
 (20223,6,55,91,0,'0.00',0),
 (20224,6,56,91,3,'0.09',0),
 (20225,6,57,91,0,'0.00',0),
 (20226,6,58,91,0,'0.00',0),
 (20227,6,59,91,1,'0.03',0),
 (20228,6,60,91,3,'0.09',0),
 (20229,6,61,91,2,'0.06',0),
 (20230,6,62,91,0,'0.00',0),
 (20231,6,1,92,40854,'45.80',0),
 (20232,6,2,92,35572,'39.88',0),
 (20233,6,14,92,72,'0.08',0),
 (20234,6,15,92,182,'0.20',0),
 (20235,6,28,92,96,'0.11',0),
 (20236,6,32,92,43,'0.05',0),
 (20237,6,38,92,7742,'8.68',0),
 (20238,6,40,92,54,'0.06',0),
 (20239,6,45,92,49,'0.05',0),
 (20240,6,48,92,32,'0.04',0),
 (20241,6,50,92,23,'0.03',0),
 (20242,6,51,92,1166,'1.31',0),
 (20243,6,55,92,49,'0.05',0),
 (20244,6,56,92,760,'0.85',0),
 (20245,6,57,92,443,'0.50',0),
 (20246,6,58,92,45,'0.05',0),
 (20247,6,59,92,27,'0.03',0),
 (20248,6,60,92,69,'0.08',0),
 (20249,6,61,92,39,'0.04',0),
 (20250,6,62,92,101,'0.11',0),
 (20251,6,1,93,707,'60.43',0),
 (20252,6,2,93,369,'31.54',0),
 (20253,6,14,93,1,'0.09',0),
 (20254,6,15,93,0,'0.00',0),
 (20255,6,28,93,2,'0.17',0),
 (20256,6,32,93,0,'0.00',0),
 (20257,6,38,93,21,'1.79',0),
 (20258,6,40,93,0,'0.00',0),
 (20259,6,45,93,0,'0.00',0),
 (20260,6,48,93,2,'0.17',0),
 (20261,6,50,93,0,'0.00',0),
 (20262,6,51,93,8,'0.68',0),
 (20263,6,55,93,0,'0.00',0),
 (20264,6,56,93,26,'2.22',0),
 (20265,6,57,93,5,'0.43',0),
 (20266,6,58,93,2,'0.17',0),
 (20267,6,59,93,2,'0.17',0),
 (20268,6,60,93,2,'0.17',0),
 (20269,6,61,93,0,'0.00',0),
 (20270,6,62,93,0,'0.00',0),
 (20271,6,1,94,197,'68.40',0),
 (20272,6,2,94,59,'20.49',0),
 (20273,6,14,94,0,'0.00',0),
 (20274,6,15,94,0,'0.00',0),
 (20275,6,28,94,0,'0.00',0),
 (20276,6,32,94,0,'0.00',0),
 (20277,6,38,94,14,'4.86',0),
 (20278,6,40,94,0,'0.00',0);
INSERT INTO `elecmunicandi` (`idElecMuniCandi`,`Convocatoria_idConvocatoria`,`Candidatura_idCandidatura`,`Municipio`,`Votos`,`PorcVotos`,`Concejales`) VALUES 
 (20279,6,45,94,0,'0.00',0),
 (20280,6,48,94,0,'0.00',0),
 (20281,6,50,94,5,'1.74',0),
 (20282,6,51,94,3,'1.04',0),
 (20283,6,55,94,0,'0.00',0),
 (20284,6,56,94,1,'0.35',0),
 (20285,6,57,94,0,'0.00',0),
 (20286,6,58,94,0,'0.00',0),
 (20287,6,59,94,1,'0.35',0),
 (20288,6,60,94,1,'0.35',0),
 (20289,6,61,94,0,'0.00',0),
 (20290,6,62,94,0,'0.00',0),
 (20291,6,1,95,368,'58.23',0),
 (20292,6,2,95,210,'33.23',0),
 (20293,6,14,95,0,'0.00',0),
 (20294,6,15,95,0,'0.00',0),
 (20295,6,28,95,0,'0.00',0),
 (20296,6,32,95,1,'0.16',0),
 (20297,6,38,95,45,'7.12',0),
 (20298,6,40,95,0,'0.00',0),
 (20299,6,45,95,0,'0.00',0),
 (20300,6,48,95,0,'0.00',0),
 (20301,6,50,95,0,'0.00',0),
 (20302,6,51,95,1,'0.16',0),
 (20303,6,55,95,0,'0.00',0),
 (20304,6,56,95,1,'0.16',0),
 (20305,6,57,95,0,'0.00',0),
 (20306,6,58,95,0,'0.00',0),
 (20307,6,59,95,0,'0.00',0),
 (20308,6,60,95,0,'0.00',0),
 (20309,6,61,95,1,'0.16',0),
 (20310,6,62,95,0,'0.00',0),
 (20311,6,1,96,3711,'54.63',0),
 (20312,6,2,96,2560,'37.69',0),
 (20313,6,14,96,3,'0.04',0),
 (20314,6,15,96,3,'0.04',0),
 (20315,6,28,96,9,'0.13',0),
 (20316,6,32,96,1,'0.01',0),
 (20317,6,38,96,250,'3.68',0),
 (20318,6,40,96,3,'0.04',0),
 (20319,6,45,96,2,'0.03',0),
 (20320,6,48,96,1,'0.01',0),
 (20321,6,50,96,2,'0.03',0),
 (20322,6,51,96,62,'0.91',0),
 (20323,6,55,96,5,'0.07',0),
 (20324,6,56,96,38,'0.56',0),
 (20325,6,57,96,44,'0.65',0),
 (20326,6,58,96,2,'0.03',0),
 (20327,6,59,96,3,'0.04',0),
 (20328,6,60,96,9,'0.13',0),
 (20329,6,61,96,1,'0.01',0),
 (20330,6,62,96,6,'0.09',0),
 (20331,6,1,97,26,'31.33',0),
 (20332,6,2,97,40,'48.19',0),
 (20333,6,14,97,0,'0.00',0),
 (20334,6,15,97,1,'1.20',0),
 (20335,6,28,97,0,'0.00',0),
 (20336,6,32,97,0,'0.00',0),
 (20337,6,38,97,11,'13.25',0),
 (20338,6,40,97,0,'0.00',0),
 (20339,6,45,97,0,'0.00',0),
 (20340,6,48,97,0,'0.00',0),
 (20341,6,50,97,1,'1.20',0),
 (20342,6,51,97,0,'0.00',0),
 (20343,6,55,97,1,'1.20',0),
 (20344,6,56,97,0,'0.00',0),
 (20345,6,57,97,1,'1.20',0),
 (20346,6,58,97,0,'0.00',0),
 (20347,6,59,97,0,'0.00',0),
 (20348,6,60,97,1,'1.20',0),
 (20349,6,61,97,0,'0.00',0),
 (20350,6,62,97,0,'0.00',0),
 (20351,6,1,99,617,'63.87',0),
 (20352,6,2,99,267,'27.64',0),
 (20353,6,14,99,1,'0.10',0),
 (20354,6,15,99,1,'0.10',0),
 (20355,6,28,99,5,'0.52',0),
 (20356,6,32,99,4,'0.41',0),
 (20357,6,38,99,30,'3.11',0),
 (20358,6,40,99,1,'0.10',0),
 (20359,6,45,99,1,'0.10',0),
 (20360,6,48,99,0,'0.00',0),
 (20361,6,50,99,2,'0.21',0),
 (20362,6,51,99,1,'0.10',0),
 (20363,6,55,99,0,'0.00',0),
 (20364,6,56,99,8,'0.83',0),
 (20365,6,57,99,9,'0.93',0),
 (20366,6,58,99,1,'0.10',0),
 (20367,6,59,99,0,'0.00',0),
 (20368,6,60,99,1,'0.10',0),
 (20369,6,61,99,1,'0.10',0),
 (20370,6,62,99,4,'0.41',0),
 (20371,6,1,100,731,'53.67',0),
 (20372,6,2,100,414,'30.40',0),
 (20373,6,14,100,4,'0.29',0),
 (20374,6,15,100,3,'0.22',0),
 (20375,6,28,100,1,'0.07',0),
 (20376,6,32,100,1,'0.07',0),
 (20377,6,38,100,145,'10.65',0),
 (20378,6,40,100,2,'0.15',0),
 (20379,6,45,100,0,'0.00',0),
 (20380,6,48,100,0,'0.00',0),
 (20381,6,50,100,3,'0.22',0),
 (20382,6,51,100,23,'1.69',0),
 (20383,6,55,100,0,'0.00',0),
 (20384,6,56,100,0,'0.00',0),
 (20385,6,57,100,10,'0.73',0),
 (20386,6,58,100,0,'0.00',0),
 (20387,6,59,100,0,'0.00',0),
 (20388,6,60,100,4,'0.29',0),
 (20389,6,61,100,2,'0.15',0),
 (20390,6,62,100,1,'0.07',0),
 (20391,6,1,101,64,'64.00',0),
 (20392,6,2,101,22,'22.00',0),
 (20393,6,14,101,0,'0.00',0),
 (20394,6,15,101,0,'0.00',0),
 (20395,6,28,101,0,'0.00',0),
 (20396,6,32,101,0,'0.00',0),
 (20397,6,38,101,7,'7.00',0),
 (20398,6,40,101,0,'0.00',0),
 (20399,6,45,101,0,'0.00',0),
 (20400,6,48,101,0,'0.00',0),
 (20401,6,50,101,0,'0.00',0),
 (20402,6,51,101,0,'0.00',0),
 (20403,6,55,101,0,'0.00',0),
 (20404,6,56,101,2,'2.00',0),
 (20405,6,57,101,0,'0.00',0),
 (20406,6,58,101,0,'0.00',0),
 (20407,6,59,101,0,'0.00',0),
 (20408,6,60,101,0,'0.00',0),
 (20409,6,61,101,0,'0.00',0),
 (20410,6,62,101,0,'0.00',0),
 (20411,6,1,102,169,'32.63',0),
 (20412,6,2,102,281,'54.25',0),
 (20413,6,14,102,0,'0.00',0),
 (20414,6,15,102,0,'0.00',0),
 (20415,6,28,102,0,'0.00',0),
 (20416,6,32,102,0,'0.00',0),
 (20417,6,38,102,57,'11.00',0),
 (20418,6,40,102,0,'0.00',0),
 (20419,6,45,102,0,'0.00',0),
 (20420,6,48,102,0,'0.00',0),
 (20421,6,50,102,0,'0.00',0),
 (20422,6,51,102,0,'0.00',0),
 (20423,6,55,102,0,'0.00',0),
 (20424,6,56,102,1,'0.19',0),
 (20425,6,57,102,0,'0.00',0),
 (20426,6,58,102,0,'0.00',0),
 (20427,6,59,102,0,'0.00',0),
 (20428,6,60,102,0,'0.00',0),
 (20429,6,61,102,0,'0.00',0),
 (20430,6,62,102,0,'0.00',0),
 (20431,6,1,104,1542,'51.06',0),
 (20432,6,2,104,947,'31.36',0),
 (20433,6,14,104,4,'0.13',0),
 (20434,6,15,104,3,'0.10',0),
 (20435,6,28,104,2,'0.07',0),
 (20436,6,32,104,1,'0.03',0),
 (20437,6,38,104,349,'11.56',0),
 (20438,6,40,104,0,'0.00',0),
 (20439,6,45,104,6,'0.20',0),
 (20440,6,48,104,1,'0.03',0),
 (20441,6,50,104,0,'0.00',0),
 (20442,6,51,104,23,'0.76',0),
 (20443,6,55,104,1,'0.03',0),
 (20444,6,56,104,17,'0.56',0),
 (20445,6,57,104,37,'1.23',0),
 (20446,6,58,104,5,'0.17',0),
 (20447,6,59,104,2,'0.07',0),
 (20448,6,60,104,9,'0.30',0),
 (20449,6,61,104,4,'0.13',0),
 (20450,6,62,104,2,'0.07',0),
 (20451,6,1,106,10670,'35.21',0),
 (20452,6,2,106,13551,'44.72',0),
 (20453,6,14,106,39,'0.13',0),
 (20454,6,15,106,137,'0.45',0),
 (20455,6,28,106,44,'0.15',0),
 (20456,6,32,106,16,'0.05',0),
 (20457,6,38,106,4352,'14.36',0),
 (20458,6,40,106,19,'0.06',0),
 (20459,6,45,106,46,'0.15',0),
 (20460,6,48,106,15,'0.05',0),
 (20461,6,50,106,45,'0.15',0),
 (20462,6,51,106,359,'1.18',0),
 (20463,6,55,106,20,'0.07',0),
 (20464,6,56,106,270,'0.89',0),
 (20465,6,57,106,93,'0.31',0),
 (20466,6,58,106,19,'0.06',0),
 (20467,6,59,106,19,'0.06',0),
 (20468,6,60,106,30,'0.10',0),
 (20469,6,61,106,20,'0.07',0),
 (20470,6,62,106,25,'0.08',0),
 (20471,6,1,107,116,'44.11',0),
 (20472,6,2,107,135,'51.33',0),
 (20473,6,14,107,0,'0.00',0),
 (20474,6,15,107,0,'0.00',0),
 (20475,6,28,107,2,'0.76',0),
 (20476,6,32,107,0,'0.00',0),
 (20477,6,38,107,4,'1.52',0),
 (20478,6,40,107,0,'0.00',0),
 (20479,6,45,107,0,'0.00',0),
 (20480,6,48,107,0,'0.00',0),
 (20481,6,50,107,0,'0.00',0),
 (20482,6,51,107,2,'0.76',0),
 (20483,6,55,107,0,'0.00',0),
 (20484,6,56,107,0,'0.00',0),
 (20485,6,57,107,1,'0.38',0),
 (20486,6,58,107,0,'0.00',0),
 (20487,6,59,107,0,'0.00',0),
 (20488,6,60,107,0,'0.00',0),
 (20489,6,61,107,0,'0.00',0),
 (20490,6,62,107,0,'0.00',0),
 (20491,6,1,108,534,'60.61',0),
 (20492,6,2,108,262,'29.74',0),
 (20493,6,14,108,0,'0.00',0),
 (20494,6,15,108,0,'0.00',0),
 (20495,6,28,108,1,'0.11',0),
 (20496,6,32,108,0,'0.00',0),
 (20497,6,38,108,47,'5.33',0),
 (20498,6,40,108,0,'0.00',0),
 (20499,6,45,108,0,'0.00',0),
 (20500,6,48,108,0,'0.00',0),
 (20501,6,50,108,1,'0.11',0),
 (20502,6,51,108,3,'0.34',0),
 (20503,6,55,108,0,'0.00',0),
 (20504,6,56,108,4,'0.45',0),
 (20505,6,57,108,0,'0.00',0),
 (20506,6,58,108,0,'0.00',0),
 (20507,6,59,108,0,'0.00',0),
 (20508,6,60,108,1,'0.11',0),
 (20509,6,61,108,1,'0.11',0),
 (20510,6,62,108,0,'0.00',0),
 (20511,6,1,109,404,'51.93',0),
 (20512,6,2,109,206,'26.48',0),
 (20513,6,14,109,0,'0.00',0),
 (20514,6,15,109,1,'0.13',0),
 (20515,6,28,109,3,'0.39',0),
 (20516,6,32,109,0,'0.00',0),
 (20517,6,38,109,28,'3.60',0),
 (20518,6,40,109,0,'0.00',0),
 (20519,6,45,109,1,'0.13',0),
 (20520,6,48,109,0,'0.00',0),
 (20521,6,50,109,0,'0.00',0),
 (20522,6,51,109,1,'0.13',0),
 (20523,6,55,109,0,'0.00',0),
 (20524,6,56,109,4,'0.51',0),
 (20525,6,57,109,113,'14.52',0),
 (20526,6,58,109,0,'0.00',0),
 (20527,6,59,109,0,'0.00',0),
 (20528,6,60,109,0,'0.00',0),
 (20529,6,61,109,1,'0.13',0),
 (20530,6,62,109,0,'0.00',0),
 (20531,6,1,110,708,'50.43',0),
 (20532,6,2,110,625,'44.52',0),
 (20533,6,14,110,0,'0.00',0),
 (20534,6,15,110,0,'0.00',0),
 (20535,6,28,110,1,'0.07',0),
 (20536,6,32,110,0,'0.00',0),
 (20537,6,38,110,34,'2.42',0),
 (20538,6,40,110,0,'0.00',0),
 (20539,6,45,110,0,'0.00',0),
 (20540,6,48,110,17,'1.21',0),
 (20541,6,50,110,0,'0.00',0),
 (20542,6,51,110,2,'0.14',0),
 (20543,6,55,110,0,'0.00',0),
 (20544,6,56,110,3,'0.21',0),
 (20545,6,57,110,1,'0.07',0),
 (20546,6,58,110,0,'0.00',0),
 (20547,6,59,110,0,'0.00',0),
 (20548,6,60,110,0,'0.00',0),
 (20549,6,61,110,0,'0.00',0),
 (20550,6,62,110,0,'0.00',0),
 (20551,6,1,111,214,'59.94',0),
 (20552,6,2,111,119,'33.33',0),
 (20553,6,14,111,0,'0.00',0),
 (20554,6,15,111,0,'0.00',0),
 (20555,6,28,111,1,'0.28',0),
 (20556,6,32,111,0,'0.00',0),
 (20557,6,38,111,9,'2.52',0),
 (20558,6,40,111,0,'0.00',0),
 (20559,6,45,111,0,'0.00',0),
 (20560,6,48,111,2,'0.56',0),
 (20561,6,50,111,0,'0.00',0),
 (20562,6,51,111,2,'0.56',0),
 (20563,6,55,111,1,'0.28',0),
 (20564,6,56,111,1,'0.28',0),
 (20565,6,57,111,2,'0.56',0),
 (20566,6,58,111,0,'0.00',0),
 (20567,6,59,111,0,'0.00',0),
 (20568,6,60,111,0,'0.00',0),
 (20569,6,61,111,0,'0.00',0),
 (20570,6,62,111,0,'0.00',0),
 (20571,6,1,112,76,'61.29',0),
 (20572,6,2,112,41,'33.06',0),
 (20573,6,14,112,0,'0.00',0),
 (20574,6,15,112,0,'0.00',0),
 (20575,6,28,112,0,'0.00',0),
 (20576,6,32,112,0,'0.00',0),
 (20577,6,38,112,5,'4.03',0),
 (20578,6,40,112,0,'0.00',0),
 (20579,6,45,112,0,'0.00',0),
 (20580,6,48,112,1,'0.81',0),
 (20581,6,50,112,0,'0.00',0),
 (20582,6,51,112,0,'0.00',0),
 (20583,6,55,112,0,'0.00',0),
 (20584,6,56,112,1,'0.81',0),
 (20585,6,57,112,0,'0.00',0),
 (20586,6,58,112,0,'0.00',0),
 (20587,6,59,112,0,'0.00',0),
 (20588,6,60,112,0,'0.00',0),
 (20589,6,61,112,0,'0.00',0),
 (20590,6,62,112,0,'0.00',0),
 (20591,6,1,113,5374,'39.23',0),
 (20592,6,2,113,6069,'44.31',0),
 (20593,6,14,113,6,'0.04',0),
 (20594,6,15,113,18,'0.13',0),
 (20595,6,28,113,1,'0.01',0),
 (20596,6,32,113,7,'0.05',0),
 (20597,6,38,113,1347,'9.83',0),
 (20598,6,40,113,3,'0.02',0),
 (20599,6,45,113,11,'0.08',0),
 (20600,6,48,113,0,'0.00',0),
 (20601,6,50,113,1,'0.01',0),
 (20602,6,51,113,232,'1.69',0),
 (20603,6,55,113,9,'0.07',0),
 (20604,6,56,113,72,'0.53',0),
 (20605,6,57,113,44,'0.32',0),
 (20606,6,58,113,13,'0.09',0),
 (20607,6,59,113,12,'0.09',0),
 (20608,6,60,113,7,'0.05',0),
 (20609,6,61,113,6,'0.04',0),
 (20610,6,62,113,5,'0.04',0),
 (20611,6,1,114,70,'64.22',0),
 (20612,6,2,114,32,'29.36',0),
 (20613,6,14,114,1,'0.92',0),
 (20614,6,15,114,0,'0.00',0),
 (20615,6,28,114,0,'0.00',0),
 (20616,6,32,114,1,'0.92',0),
 (20617,6,38,114,1,'0.92',0),
 (20618,6,40,114,0,'0.00',0),
 (20619,6,45,114,0,'0.00',0),
 (20620,6,48,114,0,'0.00',0),
 (20621,6,50,114,0,'0.00',0),
 (20622,6,51,114,1,'0.92',0),
 (20623,6,55,114,0,'0.00',0),
 (20624,6,56,114,1,'0.92',0),
 (20625,6,57,114,0,'0.00',0),
 (20626,6,58,114,0,'0.00',0),
 (20627,6,59,114,0,'0.00',0),
 (20628,6,60,114,0,'0.00',0),
 (20629,6,61,114,0,'0.00',0),
 (20630,6,62,114,0,'0.00',0),
 (20631,6,1,115,20316,'64.87',0),
 (20632,6,2,115,7727,'24.67',0),
 (20633,6,14,115,15,'0.05',0),
 (20634,6,15,115,27,'0.09',0),
 (20635,6,28,115,47,'0.15',0),
 (20636,6,32,115,17,'0.05',0),
 (20637,6,38,115,1155,'3.69',0),
 (20638,6,40,115,27,'0.09',0),
 (20639,6,45,115,19,'0.06',0),
 (20640,6,48,115,200,'0.64',0),
 (20641,6,50,115,15,'0.05',0),
 (20642,6,51,115,230,'0.73',0),
 (20643,6,55,115,13,'0.04',0),
 (20644,6,56,115,210,'0.67',0),
 (20645,6,57,115,206,'0.66',0),
 (20646,6,58,115,11,'0.04',0),
 (20647,6,59,115,8,'0.03',0),
 (20648,6,60,115,38,'0.12',0),
 (20649,6,61,115,21,'0.07',0),
 (20650,6,62,115,27,'0.09',0),
 (20651,6,1,116,78,'45.09',0),
 (20652,6,2,116,90,'52.02',0),
 (20653,6,14,116,0,'0.00',0),
 (20654,6,15,116,0,'0.00',0),
 (20655,6,28,116,0,'0.00',0),
 (20656,6,32,116,0,'0.00',0),
 (20657,6,38,116,5,'2.89',0),
 (20658,6,40,116,0,'0.00',0),
 (20659,6,45,116,0,'0.00',0),
 (20660,6,48,116,0,'0.00',0),
 (20661,6,50,116,0,'0.00',0),
 (20662,6,51,116,0,'0.00',0),
 (20663,6,55,116,0,'0.00',0),
 (20664,6,56,116,0,'0.00',0),
 (20665,6,57,116,0,'0.00',0),
 (20666,6,58,116,0,'0.00',0),
 (20667,6,59,116,0,'0.00',0),
 (20668,6,60,116,0,'0.00',0),
 (20669,6,61,116,0,'0.00',0),
 (20670,6,62,116,0,'0.00',0),
 (20671,6,1,117,61,'83.56',0),
 (20672,6,2,117,9,'12.33',0),
 (20673,6,14,117,0,'0.00',0),
 (20674,6,15,117,0,'0.00',0),
 (20675,6,28,117,0,'0.00',0),
 (20676,6,32,117,0,'0.00',0),
 (20677,6,38,117,0,'0.00',0),
 (20678,6,40,117,0,'0.00',0),
 (20679,6,45,117,0,'0.00',0),
 (20680,6,48,117,0,'0.00',0),
 (20681,6,50,117,0,'0.00',0),
 (20682,6,51,117,0,'0.00',0),
 (20683,6,55,117,0,'0.00',0),
 (20684,6,56,117,0,'0.00',0),
 (20685,6,57,117,0,'0.00',0),
 (20686,6,58,117,0,'0.00',0),
 (20687,6,59,117,0,'0.00',0),
 (20688,6,60,117,0,'0.00',0),
 (20689,6,61,117,0,'0.00',0),
 (20690,6,62,117,0,'0.00',0),
 (20691,6,1,118,27,'41.54',0),
 (20692,6,2,118,28,'43.08',0),
 (20693,6,14,118,0,'0.00',0),
 (20694,6,15,118,0,'0.00',0),
 (20695,6,28,118,0,'0.00',0),
 (20696,6,32,118,0,'0.00',0),
 (20697,6,38,118,4,'6.15',0),
 (20698,6,40,118,0,'0.00',0),
 (20699,6,45,118,0,'0.00',0),
 (20700,6,48,118,0,'0.00',0),
 (20701,6,50,118,0,'0.00',0),
 (20702,6,51,118,1,'1.54',0),
 (20703,6,55,118,2,'3.08',0),
 (20704,6,56,118,0,'0.00',0),
 (20705,6,57,118,0,'0.00',0),
 (20706,6,58,118,0,'0.00',0),
 (20707,6,59,118,0,'0.00',0),
 (20708,6,60,118,1,'1.54',0),
 (20709,6,61,118,0,'0.00',0),
 (20710,6,62,118,0,'0.00',0),
 (20711,6,1,119,416,'60.82',0),
 (20712,6,2,119,180,'26.32',0),
 (20713,6,14,119,0,'0.00',0),
 (20714,6,15,119,0,'0.00',0),
 (20715,6,28,119,0,'0.00',0),
 (20716,6,32,119,0,'0.00',0),
 (20717,6,38,119,45,'6.58',0),
 (20718,6,40,119,0,'0.00',0),
 (20719,6,45,119,3,'0.44',0),
 (20720,6,48,119,0,'0.00',0),
 (20721,6,50,119,0,'0.00',0),
 (20722,6,51,119,5,'0.73',0),
 (20723,6,55,119,0,'0.00',0),
 (20724,6,56,119,6,'0.88',0),
 (20725,6,57,119,4,'0.58',0),
 (20726,6,58,119,1,'0.15',0),
 (20727,6,59,119,0,'0.00',0),
 (20728,6,60,119,0,'0.00',0),
 (20729,6,61,119,0,'0.00',0),
 (20730,6,62,119,2,'0.29',0),
 (20731,6,1,120,530,'51.31',0),
 (20732,6,2,120,439,'42.50',0),
 (20733,6,14,120,0,'0.00',0),
 (20734,6,15,120,0,'0.00',0),
 (20735,6,28,120,0,'0.00',0),
 (20736,6,32,120,0,'0.00',0),
 (20737,6,38,120,39,'3.78',0),
 (20738,6,40,120,0,'0.00',0),
 (20739,6,45,120,2,'0.19',0),
 (20740,6,48,120,0,'0.00',0),
 (20741,6,50,120,0,'0.00',0),
 (20742,6,51,120,1,'0.10',0),
 (20743,6,55,120,0,'0.00',0),
 (20744,6,56,120,0,'0.00',0),
 (20745,6,57,120,0,'0.00',0),
 (20746,6,58,120,0,'0.00',0),
 (20747,6,59,120,1,'0.10',0),
 (20748,6,60,120,0,'0.00',0),
 (20749,6,61,120,0,'0.00',0),
 (20750,6,62,120,0,'0.00',0),
 (20751,6,1,121,65,'50.00',0),
 (20752,6,2,121,58,'44.62',0),
 (20753,6,14,121,0,'0.00',0),
 (20754,6,15,121,0,'0.00',0),
 (20755,6,28,121,0,'0.00',0),
 (20756,6,32,121,0,'0.00',0),
 (20757,6,38,121,6,'4.62',0),
 (20758,6,40,121,0,'0.00',0),
 (20759,6,45,121,0,'0.00',0),
 (20760,6,48,121,0,'0.00',0),
 (20761,6,50,121,0,'0.00',0),
 (20762,6,51,121,1,'0.77',0),
 (20763,6,55,121,0,'0.00',0),
 (20764,6,56,121,0,'0.00',0),
 (20765,6,57,121,0,'0.00',0),
 (20766,6,58,121,0,'0.00',0),
 (20767,6,59,121,0,'0.00',0),
 (20768,6,60,121,0,'0.00',0),
 (20769,6,61,121,0,'0.00',0),
 (20770,6,62,121,0,'0.00',0),
 (20771,6,1,122,131,'54.13',0),
 (20772,6,2,122,75,'30.99',0),
 (20773,6,14,122,0,'0.00',0),
 (20774,6,15,122,0,'0.00',0),
 (20775,6,28,122,0,'0.00',0),
 (20776,6,32,122,0,'0.00',0),
 (20777,6,38,122,7,'2.89',0),
 (20778,6,40,122,1,'0.41',0),
 (20779,6,45,122,23,'9.50',0),
 (20780,6,48,122,0,'0.00',0),
 (20781,6,50,122,0,'0.00',0),
 (20782,6,51,122,1,'0.41',0),
 (20783,6,55,122,0,'0.00',0),
 (20784,6,56,122,0,'0.00',0),
 (20785,6,57,122,0,'0.00',0),
 (20786,6,58,122,2,'0.83',0),
 (20787,6,59,122,0,'0.00',0),
 (20788,6,60,122,0,'0.00',0),
 (20789,6,61,122,0,'0.00',0),
 (20790,6,62,122,0,'0.00',0),
 (20791,6,1,123,4772,'37.33',0),
 (20792,6,2,123,5442,'42.58',0),
 (20793,6,14,123,12,'0.09',0),
 (20794,6,15,123,11,'0.09',0),
 (20795,6,28,123,6,'0.05',0),
 (20796,6,32,123,1,'0.01',0),
 (20797,6,38,123,2020,'15.80',0),
 (20798,6,40,123,8,'0.06',0),
 (20799,6,45,123,3,'0.02',0),
 (20800,6,48,123,0,'0.00',0),
 (20801,6,50,123,3,'0.02',0),
 (20802,6,51,123,74,'0.58',0),
 (20803,6,55,123,4,'0.03',0),
 (20804,6,56,123,95,'0.74',0),
 (20805,6,57,123,16,'0.13',0),
 (20806,6,58,123,3,'0.02',0),
 (20807,6,59,123,2,'0.02',0),
 (20808,6,60,123,6,'0.05',0),
 (20809,6,61,123,5,'0.04',0),
 (20810,6,62,123,5,'0.04',0),
 (20811,6,1,124,51,'62.20',0),
 (20812,6,2,124,18,'21.95',0),
 (20813,6,14,124,0,'0.00',0),
 (20814,6,15,124,0,'0.00',0),
 (20815,6,28,124,0,'0.00',0),
 (20816,6,32,124,0,'0.00',0),
 (20817,6,38,124,11,'13.41',0),
 (20818,6,40,124,0,'0.00',0),
 (20819,6,45,124,0,'0.00',0),
 (20820,6,48,124,0,'0.00',0),
 (20821,6,50,124,0,'0.00',0),
 (20822,6,51,124,0,'0.00',0),
 (20823,6,55,124,0,'0.00',0),
 (20824,6,56,124,0,'0.00',0),
 (20825,6,57,124,0,'0.00',0),
 (20826,6,58,124,0,'0.00',0),
 (20827,6,59,124,0,'0.00',0),
 (20828,6,60,124,0,'0.00',0),
 (20829,6,61,124,0,'0.00',0),
 (20830,6,62,124,0,'0.00',0),
 (20831,6,1,125,1010,'70.83',0),
 (20832,6,2,125,309,'21.67',0),
 (20833,6,14,125,0,'0.00',0),
 (20834,6,15,125,0,'0.00',0),
 (20835,6,28,125,2,'0.14',0),
 (20836,6,32,125,2,'0.14',0),
 (20837,6,38,125,44,'3.09',0),
 (20838,6,40,125,1,'0.07',0),
 (20839,6,45,125,0,'0.00',0),
 (20840,6,48,125,8,'0.56',0),
 (20841,6,50,125,0,'0.00',0),
 (20842,6,51,125,7,'0.49',0),
 (20843,6,55,125,0,'0.00',0),
 (20844,6,56,125,5,'0.35',0),
 (20845,6,57,125,1,'0.07',0),
 (20846,6,58,125,1,'0.07',0),
 (20847,6,59,125,0,'0.00',0),
 (20848,6,60,125,2,'0.14',0),
 (20849,6,61,125,0,'0.00',0),
 (20850,6,62,125,0,'0.00',0),
 (20851,6,1,126,30,'41.10',0),
 (20852,6,2,126,39,'53.42',0),
 (20853,6,14,126,1,'1.37',0),
 (20854,6,15,126,0,'0.00',0),
 (20855,6,28,126,0,'0.00',0),
 (20856,6,32,126,0,'0.00',0),
 (20857,6,38,126,0,'0.00',0),
 (20858,6,40,126,0,'0.00',0),
 (20859,6,45,126,2,'2.74',0),
 (20860,6,48,126,0,'0.00',0),
 (20861,6,50,126,0,'0.00',0),
 (20862,6,51,126,0,'0.00',0),
 (20863,6,55,126,0,'0.00',0),
 (20864,6,56,126,0,'0.00',0),
 (20865,6,57,126,0,'0.00',0),
 (20866,6,58,126,0,'0.00',0),
 (20867,6,59,126,0,'0.00',0),
 (20868,6,60,126,0,'0.00',0),
 (20869,6,61,126,0,'0.00',0),
 (20870,6,62,126,0,'0.00',0),
 (20871,6,1,127,14508,'60.13',0),
 (20872,6,2,127,6642,'27.53',0),
 (20873,6,14,127,16,'0.07',0),
 (20874,6,15,127,21,'0.09',0),
 (20875,6,28,127,38,'0.16',0),
 (20876,6,32,127,3,'0.01',0),
 (20877,6,38,127,1295,'5.37',0),
 (20878,6,40,127,12,'0.05',0),
 (20879,6,45,127,9,'0.04',0),
 (20880,6,48,127,20,'0.08',0),
 (20881,6,50,127,9,'0.04',0),
 (20882,6,51,127,226,'0.94',0),
 (20883,6,55,127,12,'0.05',0),
 (20884,6,56,127,173,'0.72',0),
 (20885,6,57,127,116,'0.48',0),
 (20886,6,58,127,5,'0.02',0),
 (20887,6,59,127,4,'0.02',0),
 (20888,6,60,127,35,'0.15',0),
 (20889,6,61,127,15,'0.06',0),
 (20890,6,62,127,17,'0.07',0),
 (20891,6,1,128,133,'47.84',0),
 (20892,6,2,128,103,'37.05',0),
 (20893,6,14,128,0,'0.00',0),
 (20894,6,15,128,1,'0.36',0),
 (20895,6,28,128,1,'0.36',0),
 (20896,6,32,128,0,'0.00',0),
 (20897,6,38,128,18,'6.47',0),
 (20898,6,40,128,0,'0.00',0),
 (20899,6,45,128,0,'0.00',0),
 (20900,6,48,128,0,'0.00',0),
 (20901,6,50,128,0,'0.00',0),
 (20902,6,51,128,3,'1.08',0),
 (20903,6,55,128,1,'0.36',0),
 (20904,6,56,128,3,'1.08',0),
 (20905,6,57,128,1,'0.36',0),
 (20906,6,58,128,1,'0.36',0),
 (20907,6,59,128,0,'0.00',0),
 (20908,6,60,128,0,'0.00',0),
 (20909,6,61,128,0,'0.00',0),
 (20910,6,62,128,1,'0.36',0),
 (20911,6,1,129,1517,'56.04',0),
 (20912,6,2,129,898,'33.17',0),
 (20913,6,14,129,1,'0.04',0),
 (20914,6,15,129,2,'0.07',0),
 (20915,6,28,129,4,'0.15',0),
 (20916,6,32,129,0,'0.00',0),
 (20917,6,38,129,156,'5.76',0),
 (20918,6,40,129,1,'0.04',0),
 (20919,6,45,129,2,'0.07',0),
 (20920,6,48,129,1,'0.04',0),
 (20921,6,50,129,0,'0.00',0),
 (20922,6,51,129,23,'0.85',0),
 (20923,6,55,129,2,'0.07',0),
 (20924,6,56,129,17,'0.63',0),
 (20925,6,57,129,21,'0.78',0),
 (20926,6,58,129,1,'0.04',0),
 (20927,6,59,129,2,'0.07',0),
 (20928,6,60,129,0,'0.00',0),
 (20929,6,61,129,5,'0.18',0),
 (20930,6,62,129,4,'0.15',0),
 (20931,6,1,130,4983,'34.57',0),
 (20932,6,2,130,5806,'40.28',0),
 (20933,6,14,130,5,'0.03',0),
 (20934,6,15,130,23,'0.16',0),
 (20935,6,28,130,6,'0.04',0),
 (20936,6,32,130,2,'0.01',0),
 (20937,6,38,130,3033,'21.04',0),
 (20938,6,40,130,5,'0.03',0),
 (20939,6,45,130,8,'0.06',0),
 (20940,6,48,130,4,'0.03',0),
 (20941,6,50,130,6,'0.04',0),
 (20942,6,51,130,97,'0.67',0),
 (20943,6,55,130,14,'0.10',0),
 (20944,6,56,130,94,'0.65',0),
 (20945,6,57,130,59,'0.41',0),
 (20946,6,58,130,13,'0.09',0),
 (20947,6,59,130,6,'0.04',0),
 (20948,6,60,130,11,'0.08',0),
 (20949,6,61,130,7,'0.05',0),
 (20950,6,62,130,11,'0.08',0),
 (20951,6,1,131,3427,'57.12',0),
 (20952,6,2,131,1982,'33.03',0),
 (20953,6,14,131,4,'0.07',0),
 (20954,6,15,131,8,'0.13',0),
 (20955,6,28,131,28,'0.47',0),
 (20956,6,32,131,3,'0.05',0),
 (20957,6,38,131,244,'4.07',0),
 (20958,6,40,131,2,'0.03',0),
 (20959,6,45,131,5,'0.08',0),
 (20960,6,48,131,1,'0.02',0),
 (20961,6,50,131,4,'0.07',0),
 (20962,6,51,131,56,'0.93',0),
 (20963,6,55,131,1,'0.02',0),
 (20964,6,56,131,28,'0.47',0),
 (20965,6,57,131,15,'0.25',0),
 (20966,6,58,131,2,'0.03',0),
 (20967,6,59,131,2,'0.03',0),
 (20968,6,60,131,12,'0.20',0),
 (20969,6,61,131,1,'0.02',0),
 (20970,6,62,131,6,'0.10',0),
 (20971,6,1,132,2268,'45.97',0),
 (20972,6,2,132,2108,'42.72',0),
 (20973,6,14,132,4,'0.08',0),
 (20974,6,15,132,4,'0.08',0),
 (20975,6,28,132,2,'0.04',0),
 (20976,6,32,132,0,'0.00',0),
 (20977,6,38,132,466,'9.44',0),
 (20978,6,40,132,0,'0.00',0),
 (20979,6,45,132,0,'0.00',0),
 (20980,6,48,132,0,'0.00',0),
 (20981,6,50,132,0,'0.00',0),
 (20982,6,51,132,10,'0.20',0),
 (20983,6,55,132,2,'0.04',0),
 (20984,6,56,132,12,'0.24',0),
 (20985,6,57,132,6,'0.12',0),
 (20986,6,58,132,2,'0.04',0),
 (20987,6,59,132,1,'0.02',0),
 (20988,6,60,132,2,'0.04',0),
 (20989,6,61,132,1,'0.02',0),
 (20990,6,62,132,0,'0.00',0),
 (20991,6,1,133,1712,'48.01',0),
 (20992,6,2,133,1586,'44.48',0),
 (20993,6,14,133,0,'0.00',0),
 (20994,6,15,133,3,'0.08',0),
 (20995,6,28,133,6,'0.17',0),
 (20996,6,32,133,0,'0.00',0),
 (20997,6,38,133,174,'4.88',0),
 (20998,6,40,133,0,'0.00',0),
 (20999,6,45,133,1,'0.03',0),
 (21000,6,48,133,0,'0.00',0),
 (21001,6,50,133,3,'0.08',0),
 (21002,6,51,133,12,'0.34',0),
 (21003,6,55,133,0,'0.00',0),
 (21004,6,56,133,5,'0.14',0),
 (21005,6,57,133,11,'0.31',0),
 (21006,6,58,133,1,'0.03',0),
 (21007,6,59,133,1,'0.03',0),
 (21008,6,60,133,0,'0.00',0),
 (21009,6,61,133,2,'0.06',0),
 (21010,6,62,133,2,'0.06',0),
 (21011,6,1,134,12023,'45.40',0),
 (21012,6,2,134,10437,'39.41',0),
 (21013,6,14,134,29,'0.11',0),
 (21014,6,15,134,38,'0.14',0),
 (21015,6,28,134,42,'0.16',0),
 (21016,6,32,134,18,'0.07',0),
 (21017,6,38,134,2490,'9.40',0),
 (21018,6,40,134,30,'0.11',0),
 (21019,6,45,134,43,'0.16',0),
 (21020,6,48,134,16,'0.06',0),
 (21021,6,50,134,12,'0.05',0),
 (21022,6,51,134,179,'0.68',0),
 (21023,6,55,134,25,'0.09',0),
 (21024,6,56,134,275,'1.04',0),
 (21025,6,57,134,91,'0.34',0),
 (21026,6,58,134,16,'0.06',0),
 (21027,6,59,134,17,'0.06',0),
 (21028,6,60,134,31,'0.12',0),
 (21029,6,61,134,9,'0.03',0),
 (21030,6,62,134,11,'0.04',0),
 (21031,6,1,135,347,'67.38',0),
 (21032,6,2,135,127,'24.66',0),
 (21033,6,14,135,0,'0.00',0),
 (21034,6,15,135,1,'0.19',0),
 (21035,6,28,135,0,'0.00',0),
 (21036,6,32,135,2,'0.39',0),
 (21037,6,38,135,23,'4.47',0),
 (21038,6,40,135,0,'0.00',0),
 (21039,6,45,135,1,'0.19',0),
 (21040,6,48,135,0,'0.00',0),
 (21041,6,50,135,0,'0.00',0),
 (21042,6,51,135,2,'0.39',0),
 (21043,6,55,135,1,'0.19',0),
 (21044,6,56,135,1,'0.19',0),
 (21045,6,57,135,0,'0.00',0),
 (21046,6,58,135,0,'0.00',0),
 (21047,6,59,135,1,'0.19',0),
 (21048,6,60,135,0,'0.00',0),
 (21049,6,61,135,0,'0.00',0),
 (21050,6,62,135,0,'0.00',0),
 (21051,6,1,136,239,'59.75',0),
 (21052,6,2,136,121,'30.25',0),
 (21053,6,14,136,0,'0.00',0),
 (21054,6,15,136,0,'0.00',0),
 (21055,6,28,136,4,'1.00',0),
 (21056,6,32,136,0,'0.00',0),
 (21057,6,38,136,17,'4.25',0),
 (21058,6,40,136,0,'0.00',0),
 (21059,6,45,136,0,'0.00',0),
 (21060,6,48,136,0,'0.00',0),
 (21061,6,50,136,0,'0.00',0),
 (21062,6,51,136,4,'1.00',0),
 (21063,6,55,136,0,'0.00',0),
 (21064,6,56,136,1,'0.25',0),
 (21065,6,57,136,4,'1.00',0),
 (21066,6,58,136,0,'0.00',0),
 (21067,6,59,136,1,'0.25',0),
 (21068,6,60,136,3,'0.75',0),
 (21069,6,61,136,0,'0.00',0),
 (21070,6,62,136,0,'0.00',0),
 (21071,6,1,137,386,'49.05',0),
 (21072,6,2,137,327,'41.55',0),
 (21073,6,14,137,0,'0.00',0),
 (21074,6,15,137,0,'0.00',0),
 (21075,6,28,137,1,'0.13',0),
 (21076,6,32,137,0,'0.00',0),
 (21077,6,38,137,27,'3.43',0),
 (21078,6,40,137,0,'0.00',0),
 (21079,6,45,137,0,'0.00',0),
 (21080,6,48,137,0,'0.00',0),
 (21081,6,50,137,0,'0.00',0),
 (21082,6,51,137,2,'0.25',0),
 (21083,6,55,137,28,'3.56',0),
 (21084,6,56,137,4,'0.51',0),
 (21085,6,57,137,0,'0.00',0),
 (21086,6,58,137,0,'0.00',0),
 (21087,6,59,137,0,'0.00',0),
 (21088,6,60,137,0,'0.00',0),
 (21089,6,61,137,0,'0.00',0),
 (21090,6,62,137,0,'0.00',0),
 (21091,6,1,138,58,'68.24',0),
 (21092,6,2,138,13,'15.29',0),
 (21093,6,14,138,0,'0.00',0),
 (21094,6,15,138,0,'0.00',0),
 (21095,6,28,138,0,'0.00',0),
 (21096,6,32,138,0,'0.00',0),
 (21097,6,38,138,7,'8.24',0),
 (21098,6,40,138,0,'0.00',0),
 (21099,6,45,138,0,'0.00',0),
 (21100,6,48,138,0,'0.00',0),
 (21101,6,50,138,0,'0.00',0),
 (21102,6,51,138,0,'0.00',0),
 (21103,6,55,138,0,'0.00',0),
 (21104,6,56,138,0,'0.00',0),
 (21105,6,57,138,4,'4.71',0),
 (21106,6,58,138,0,'0.00',0),
 (21107,6,59,138,0,'0.00',0),
 (21108,6,60,138,0,'0.00',0),
 (21109,6,61,138,0,'0.00',0),
 (21110,6,62,138,0,'0.00',0),
 (21111,6,1,140,391,'65.49',0),
 (21112,6,2,140,163,'27.30',0),
 (21113,6,14,140,2,'0.34',0),
 (21114,6,15,140,0,'0.00',0),
 (21115,6,28,140,1,'0.17',0),
 (21116,6,32,140,0,'0.00',0),
 (21117,6,38,140,28,'4.69',0),
 (21118,6,40,140,0,'0.00',0),
 (21119,6,45,140,0,'0.00',0),
 (21120,6,48,140,2,'0.34',0),
 (21121,6,50,140,0,'0.00',0),
 (21122,6,51,140,3,'0.50',0),
 (21123,6,55,140,0,'0.00',0),
 (21124,6,56,140,1,'0.17',0),
 (21125,6,57,140,2,'0.34',0),
 (21126,6,58,140,0,'0.00',0),
 (21127,6,59,140,0,'0.00',0),
 (21128,6,60,140,0,'0.00',0),
 (21129,6,61,140,0,'0.00',0),
 (21130,6,62,140,0,'0.00',0),
 (21131,6,1,141,876,'54.21',0),
 (21132,6,2,141,514,'31.81',0),
 (21133,6,14,141,0,'0.00',0),
 (21134,6,15,141,1,'0.06',0),
 (21135,6,28,141,7,'0.43',0),
 (21136,6,32,141,0,'0.00',0),
 (21137,6,38,141,62,'3.84',0),
 (21138,6,40,141,0,'0.00',0),
 (21139,6,45,141,1,'0.06',0),
 (21140,6,48,141,2,'0.12',0),
 (21141,6,50,141,2,'0.12',0),
 (21142,6,51,141,12,'0.74',0),
 (21143,6,55,141,1,'0.06',0),
 (21144,6,56,141,16,'0.99',0),
 (21145,6,57,141,98,'6.06',0),
 (21146,6,58,141,0,'0.00',0),
 (21147,6,59,141,0,'0.00',0),
 (21148,6,60,141,0,'0.00',0),
 (21149,6,61,141,2,'0.12',0),
 (21150,6,62,141,1,'0.06',0),
 (21151,6,1,143,50,'58.14',0),
 (21152,6,2,143,33,'38.37',0),
 (21153,6,14,143,0,'0.00',0),
 (21154,6,15,143,0,'0.00',0),
 (21155,6,28,143,0,'0.00',0),
 (21156,6,32,143,0,'0.00',0),
 (21157,6,38,143,0,'0.00',0),
 (21158,6,40,143,0,'0.00',0),
 (21159,6,45,143,0,'0.00',0),
 (21160,6,48,143,0,'0.00',0),
 (21161,6,50,143,0,'0.00',0),
 (21162,6,51,143,0,'0.00',0),
 (21163,6,55,143,0,'0.00',0),
 (21164,6,56,143,1,'1.16',0),
 (21165,6,57,143,0,'0.00',0),
 (21166,6,58,143,0,'0.00',0),
 (21167,6,59,143,0,'0.00',0),
 (21168,6,60,143,0,'0.00',0),
 (21169,6,61,143,0,'0.00',0),
 (21170,6,62,143,0,'0.00',0),
 (21171,6,1,144,1662,'63.07',0),
 (21172,6,2,144,692,'26.26',0),
 (21173,6,14,144,3,'0.11',0),
 (21174,6,15,144,4,'0.15',0),
 (21175,6,28,144,3,'0.11',0),
 (21176,6,32,144,1,'0.04',0),
 (21177,6,38,144,124,'4.71',0),
 (21178,6,40,144,2,'0.08',0),
 (21179,6,45,144,4,'0.15',0),
 (21180,6,48,144,0,'0.00',0),
 (21181,6,50,144,0,'0.00',0),
 (21182,6,51,144,19,'0.72',0),
 (21183,6,55,144,1,'0.04',0),
 (21184,6,56,144,27,'1.02',0),
 (21185,6,57,144,23,'0.87',0),
 (21186,6,58,144,0,'0.00',0),
 (21187,6,59,144,1,'0.04',0),
 (21188,6,60,144,6,'0.23',0),
 (21189,6,61,144,1,'0.04',0),
 (21190,6,62,144,4,'0.15',0),
 (21191,6,1,145,408,'47.11',0),
 (21192,6,2,145,344,'39.72',0),
 (21193,6,14,145,0,'0.00',0),
 (21194,6,15,145,0,'0.00',0),
 (21195,6,28,145,1,'0.12',0),
 (21196,6,32,145,0,'0.00',0),
 (21197,6,38,145,76,'8.78',0),
 (21198,6,40,145,1,'0.12',0),
 (21199,6,45,145,14,'1.62',0),
 (21200,6,48,145,0,'0.00',0),
 (21201,6,50,145,0,'0.00',0),
 (21202,6,51,145,3,'0.35',0),
 (21203,6,55,145,0,'0.00',0),
 (21204,6,56,145,1,'0.12',0),
 (21205,6,57,145,3,'0.35',0),
 (21206,6,58,145,1,'0.12',0),
 (21207,6,59,145,0,'0.00',0),
 (21208,6,60,145,3,'0.35',0),
 (21209,6,61,145,0,'0.00',0),
 (21210,6,62,145,0,'0.00',0),
 (21211,6,1,146,698,'56.93',0),
 (21212,6,2,146,444,'36.22',0),
 (21213,6,14,146,1,'0.08',0),
 (21214,6,15,146,1,'0.08',0),
 (21215,6,28,146,1,'0.08',0),
 (21216,6,32,146,0,'0.00',0),
 (21217,6,38,146,60,'4.89',0),
 (21218,6,40,146,0,'0.00',0),
 (21219,6,45,146,0,'0.00',0),
 (21220,6,48,146,0,'0.00',0),
 (21221,6,50,146,0,'0.00',0),
 (21222,6,51,146,2,'0.16',0),
 (21223,6,55,146,0,'0.00',0),
 (21224,6,56,146,2,'0.16',0),
 (21225,6,57,146,0,'0.00',0),
 (21226,6,58,146,0,'0.00',0),
 (21227,6,59,146,0,'0.00',0),
 (21228,6,60,146,0,'0.00',0),
 (21229,6,61,146,1,'0.08',0),
 (21230,6,62,146,0,'0.00',0),
 (21231,6,1,147,322,'48.57',0),
 (21232,6,2,147,231,'34.84',0),
 (21233,6,14,147,1,'0.15',0),
 (21234,6,15,147,1,'0.15',0),
 (21235,6,28,147,0,'0.00',0),
 (21236,6,32,147,2,'0.30',0),
 (21237,6,38,147,48,'7.24',0),
 (21238,6,40,147,1,'0.15',0),
 (21239,6,45,147,2,'0.30',0),
 (21240,6,48,147,0,'0.00',0),
 (21241,6,50,147,0,'0.00',0),
 (21242,6,51,147,2,'0.30',0),
 (21243,6,55,147,0,'0.00',0),
 (21244,6,56,147,2,'0.30',0),
 (21245,6,57,147,2,'0.30',0),
 (21246,6,58,147,0,'0.00',0),
 (21247,6,59,147,0,'0.00',0),
 (21248,6,60,147,2,'0.30',0),
 (21249,6,61,147,1,'0.15',0),
 (21250,6,62,147,1,'0.15',0),
 (21251,6,1,148,16748,'42.45',0),
 (21252,6,2,148,15643,'39.65',0),
 (21253,6,14,148,32,'0.08',0),
 (21254,6,15,148,68,'0.17',0),
 (21255,6,28,148,40,'0.10',0),
 (21256,6,32,148,875,'2.22',0),
 (21257,6,38,148,3405,'8.63',0),
 (21258,6,40,148,25,'0.06',0),
 (21259,6,45,148,30,'0.08',0),
 (21260,6,48,148,754,'1.91',0),
 (21261,6,50,148,17,'0.04',0),
 (21262,6,51,148,380,'0.96',0),
 (21263,6,55,148,52,'0.13',0),
 (21264,6,56,148,325,'0.82',0),
 (21265,6,57,148,120,'0.30',0),
 (21266,6,58,148,21,'0.05',0),
 (21267,6,59,148,22,'0.06',0),
 (21268,6,60,148,43,'0.11',0),
 (21269,6,61,148,34,'0.09',0),
 (21270,6,62,148,22,'0.06',0),
 (21271,6,1,149,1103,'55.76',0),
 (21272,6,2,149,608,'30.74',0),
 (21273,6,14,149,1,'0.05',0),
 (21274,6,15,149,6,'0.30',0),
 (21275,6,28,149,6,'0.30',0),
 (21276,6,32,149,4,'0.20',0),
 (21277,6,38,149,93,'4.70',0),
 (21278,6,40,149,0,'0.00',0),
 (21279,6,45,149,3,'0.15',0),
 (21280,6,48,149,0,'0.00',0),
 (21281,6,50,149,3,'0.15',0),
 (21282,6,51,149,17,'0.86',0),
 (21283,6,55,149,4,'0.20',0),
 (21284,6,56,149,16,'0.81',0),
 (21285,6,57,149,5,'0.25',0),
 (21286,6,58,149,2,'0.10',0),
 (21287,6,59,149,70,'3.54',0),
 (21288,6,60,149,5,'0.25',0),
 (21289,6,61,149,2,'0.10',0),
 (21290,6,62,149,3,'0.15',0),
 (21291,6,1,150,699,'59.04',0),
 (21292,6,2,150,317,'26.77',0),
 (21293,6,14,150,1,'0.08',0),
 (21294,6,15,150,6,'0.51',0),
 (21295,6,28,150,0,'0.00',0),
 (21296,6,32,150,1,'0.08',0),
 (21297,6,38,150,117,'9.88',0),
 (21298,6,40,150,5,'0.42',0),
 (21299,6,45,150,0,'0.00',0),
 (21300,6,48,150,0,'0.00',0),
 (21301,6,50,150,2,'0.17',0),
 (21302,6,51,150,8,'0.68',0),
 (21303,6,55,150,3,'0.25',0),
 (21304,6,56,150,7,'0.59',0),
 (21305,6,57,150,0,'0.00',0),
 (21306,6,58,150,2,'0.17',0),
 (21307,6,59,150,1,'0.08',0),
 (21308,6,60,150,3,'0.25',0),
 (21309,6,61,150,1,'0.08',0),
 (21310,6,62,150,0,'0.00',0),
 (21311,6,1,151,803,'50.66',0),
 (21312,6,2,151,630,'39.75',0),
 (21313,6,14,151,0,'0.00',0),
 (21314,6,15,151,0,'0.00',0),
 (21315,6,28,151,0,'0.00',0),
 (21316,6,32,151,1,'0.06',0),
 (21317,6,38,151,96,'6.06',0),
 (21318,6,40,151,0,'0.00',0),
 (21319,6,45,151,0,'0.00',0),
 (21320,6,48,151,0,'0.00',0),
 (21321,6,50,151,0,'0.00',0),
 (21322,6,51,151,6,'0.38',0),
 (21323,6,55,151,1,'0.06',0),
 (21324,6,56,151,13,'0.82',0),
 (21325,6,57,151,1,'0.06',0),
 (21326,6,58,151,0,'0.00',0),
 (21327,6,59,151,0,'0.00',0),
 (21328,6,60,151,2,'0.13',0),
 (21329,6,61,151,1,'0.06',0),
 (21330,6,62,151,1,'0.06',0),
 (21331,6,1,152,4005,'62.86',0),
 (21332,6,2,152,1528,'23.98',0),
 (21333,6,14,152,6,'0.09',0),
 (21334,6,15,152,5,'0.08',0),
 (21335,6,28,152,20,'0.31',0),
 (21336,6,32,152,2,'0.03',0),
 (21337,6,38,152,436,'6.84',0),
 (21338,6,40,152,5,'0.08',0),
 (21339,6,45,152,6,'0.09',0),
 (21340,6,48,152,3,'0.05',0),
 (21341,6,50,152,2,'0.03',0),
 (21342,6,51,152,51,'0.80',0),
 (21343,6,55,152,1,'0.02',0),
 (21344,6,56,152,58,'0.91',0),
 (21345,6,57,152,21,'0.33',0),
 (21346,6,58,152,2,'0.03',0),
 (21347,6,59,152,0,'0.00',0),
 (21348,6,60,152,14,'0.22',0),
 (21349,6,61,152,3,'0.05',0),
 (21350,6,62,152,5,'0.08',0),
 (21351,6,1,153,125,'47.89',0),
 (21352,6,2,153,94,'36.02',0),
 (21353,6,14,153,0,'0.00',0),
 (21354,6,15,153,0,'0.00',0),
 (21355,6,28,153,0,'0.00',0),
 (21356,6,32,153,0,'0.00',0),
 (21357,6,38,153,20,'7.66',0),
 (21358,6,40,153,0,'0.00',0),
 (21359,6,45,153,0,'0.00',0),
 (21360,6,48,153,0,'0.00',0),
 (21361,6,50,153,0,'0.00',0),
 (21362,6,51,153,4,'1.53',0),
 (21363,6,55,153,0,'0.00',0),
 (21364,6,56,153,3,'1.15',0),
 (21365,6,57,153,3,'1.15',0),
 (21366,6,58,153,1,'0.38',0),
 (21367,6,59,153,0,'0.00',0),
 (21368,6,60,153,3,'1.15',0),
 (21369,6,61,153,0,'0.00',0),
 (21370,6,62,153,0,'0.00',0),
 (21371,6,1,154,1213,'46.71',0),
 (21372,6,2,154,1168,'44.97',0),
 (21373,6,14,154,1,'0.04',0),
 (21374,6,15,154,3,'0.12',0),
 (21375,6,28,154,2,'0.08',0),
 (21376,6,32,154,2,'0.08',0),
 (21377,6,38,154,128,'4.93',0),
 (21378,6,40,154,1,'0.04',0),
 (21379,6,45,154,0,'0.00',0),
 (21380,6,48,154,0,'0.00',0),
 (21381,6,50,154,1,'0.04',0),
 (21382,6,51,154,3,'0.12',0),
 (21383,6,55,154,0,'0.00',0),
 (21384,6,56,154,23,'0.89',0),
 (21385,6,57,154,2,'0.08',0),
 (21386,6,58,154,1,'0.04',0),
 (21387,6,59,154,1,'0.04',0),
 (21388,6,60,154,1,'0.04',0),
 (21389,6,61,154,1,'0.04',0),
 (21390,6,62,154,1,'0.04',0),
 (21391,6,1,155,186,'40.35',0),
 (21392,6,2,155,261,'56.62',0),
 (21393,6,14,155,0,'0.00',0),
 (21394,6,15,155,0,'0.00',0),
 (21395,6,28,155,0,'0.00',0),
 (21396,6,32,155,0,'0.00',0),
 (21397,6,38,155,7,'1.52',0),
 (21398,6,40,155,1,'0.22',0),
 (21399,6,45,155,0,'0.00',0),
 (21400,6,48,155,0,'0.00',0),
 (21401,6,50,155,0,'0.00',0),
 (21402,6,51,155,4,'0.87',0),
 (21403,6,55,155,0,'0.00',0),
 (21404,6,56,155,1,'0.22',0),
 (21405,6,57,155,0,'0.00',0),
 (21406,6,58,155,0,'0.00',0),
 (21407,6,59,155,0,'0.00',0),
 (21408,6,60,155,0,'0.00',0),
 (21409,6,61,155,0,'0.00',0),
 (21410,6,62,155,0,'0.00',0),
 (21411,6,1,156,220,'52.76',0),
 (21412,6,2,156,172,'41.25',0),
 (21413,6,14,156,0,'0.00',0),
 (21414,6,15,156,0,'0.00',0),
 (21415,6,28,156,0,'0.00',0),
 (21416,6,32,156,0,'0.00',0),
 (21417,6,38,156,18,'4.32',0),
 (21418,6,40,156,1,'0.24',0),
 (21419,6,45,156,0,'0.00',0),
 (21420,6,48,156,0,'0.00',0),
 (21421,6,50,156,0,'0.00',0),
 (21422,6,51,156,2,'0.48',0),
 (21423,6,55,156,0,'0.00',0),
 (21424,6,56,156,0,'0.00',0),
 (21425,6,57,156,0,'0.00',0),
 (21426,6,58,156,1,'0.24',0),
 (21427,6,59,156,0,'0.00',0),
 (21428,6,60,156,0,'0.00',0),
 (21429,6,61,156,0,'0.00',0),
 (21430,6,62,156,0,'0.00',0),
 (21431,6,1,157,225,'67.16',0),
 (21432,6,2,157,92,'27.46',0),
 (21433,6,14,157,1,'0.30',0),
 (21434,6,15,157,0,'0.00',0),
 (21435,6,28,157,1,'0.30',0),
 (21436,6,32,157,0,'0.00',0),
 (21437,6,38,157,4,'1.19',0),
 (21438,6,40,157,0,'0.00',0),
 (21439,6,45,157,0,'0.00',0),
 (21440,6,48,157,0,'0.00',0),
 (21441,6,50,157,0,'0.00',0),
 (21442,6,51,157,2,'0.60',0),
 (21443,6,55,157,1,'0.30',0),
 (21444,6,56,157,0,'0.00',0),
 (21445,6,57,157,0,'0.00',0),
 (21446,6,58,157,0,'0.00',0),
 (21447,6,59,157,0,'0.00',0),
 (21448,6,60,157,2,'0.60',0),
 (21449,6,61,157,0,'0.00',0),
 (21450,6,62,157,0,'0.00',0),
 (21451,6,1,158,266,'74.72',0),
 (21452,6,2,158,55,'15.45',0),
 (21453,6,14,158,0,'0.00',0),
 (21454,6,15,158,0,'0.00',0),
 (21455,6,28,158,1,'0.28',0),
 (21456,6,32,158,0,'0.00',0),
 (21457,6,38,158,16,'4.49',0),
 (21458,6,40,158,0,'0.00',0),
 (21459,6,45,158,1,'0.28',0),
 (21460,6,48,158,0,'0.00',0),
 (21461,6,50,158,1,'0.28',0),
 (21462,6,51,158,2,'0.56',0),
 (21463,6,55,158,0,'0.00',0),
 (21464,6,56,158,1,'0.28',0),
 (21465,6,57,158,1,'0.28',0),
 (21466,6,58,158,1,'0.28',0),
 (21467,6,59,158,0,'0.00',0),
 (21468,6,60,158,1,'0.28',0),
 (21469,6,61,158,0,'0.00',0),
 (21470,6,62,158,0,'0.00',0),
 (21471,6,1,159,193,'50.92',0),
 (21472,6,2,159,173,'45.65',0),
 (21473,6,14,159,0,'0.00',0),
 (21474,6,15,159,0,'0.00',0),
 (21475,6,28,159,0,'0.00',0),
 (21476,6,32,159,0,'0.00',0),
 (21477,6,38,159,7,'1.85',0),
 (21478,6,40,159,0,'0.00',0),
 (21479,6,45,159,0,'0.00',0),
 (21480,6,48,159,0,'0.00',0),
 (21481,6,50,159,0,'0.00',0),
 (21482,6,51,159,0,'0.00',0),
 (21483,6,55,159,0,'0.00',0),
 (21484,6,56,159,1,'0.26',0),
 (21485,6,57,159,1,'0.26',0),
 (21486,6,58,159,0,'0.00',0),
 (21487,6,59,159,0,'0.00',0),
 (21488,6,60,159,0,'0.00',0),
 (21489,6,61,159,0,'0.00',0),
 (21490,6,62,159,0,'0.00',0),
 (21491,6,1,160,1605,'57.55',0),
 (21492,6,2,160,914,'32.77',0),
 (21493,6,14,160,0,'0.00',0),
 (21494,6,15,160,1,'0.04',0),
 (21495,6,28,160,6,'0.22',0),
 (21496,6,32,160,1,'0.04',0),
 (21497,6,38,160,114,'4.09',0),
 (21498,6,40,160,3,'0.11',0),
 (21499,6,45,160,4,'0.14',0),
 (21500,6,48,160,0,'0.00',0),
 (21501,6,50,160,0,'0.00',0),
 (21502,6,51,160,33,'1.18',0),
 (21503,6,55,160,1,'0.04',0),
 (21504,6,56,160,15,'0.54',0),
 (21505,6,57,160,9,'0.32',0),
 (21506,6,58,160,1,'0.04',0),
 (21507,6,59,160,2,'0.07',0),
 (21508,6,60,160,3,'0.11',0),
 (21509,6,61,160,1,'0.04',0),
 (21510,6,62,160,1,'0.04',0),
 (21511,6,1,161,6804,'55.02',0),
 (21512,6,2,161,4463,'36.09',0),
 (21513,6,14,161,6,'0.05',0),
 (21514,6,15,161,12,'0.10',0),
 (21515,6,28,161,20,'0.16',0),
 (21516,6,32,161,3,'0.02',0),
 (21517,6,38,161,728,'5.89',0),
 (21518,6,40,161,3,'0.02',0),
 (21519,6,45,161,6,'0.05',0),
 (21520,6,48,161,4,'0.03',0),
 (21521,6,50,161,8,'0.06',0),
 (21522,6,51,161,74,'0.60',0),
 (21523,6,55,161,12,'0.10',0),
 (21524,6,56,161,99,'0.80',0),
 (21525,6,57,161,65,'0.53',0),
 (21526,6,58,161,3,'0.02',0),
 (21527,6,59,161,0,'0.00',0),
 (21528,6,60,161,12,'0.10',0),
 (21529,6,61,161,2,'0.02',0),
 (21530,6,62,161,6,'0.05',0),
 (21531,6,1,162,582,'61.01',0),
 (21532,6,2,162,279,'29.25',0),
 (21533,6,14,162,1,'0.10',0),
 (21534,6,15,162,0,'0.00',0),
 (21535,6,28,162,5,'0.52',0),
 (21536,6,32,162,0,'0.00',0),
 (21537,6,38,162,48,'5.03',0),
 (21538,6,40,162,0,'0.00',0),
 (21539,6,45,162,1,'0.10',0),
 (21540,6,48,162,0,'0.00',0),
 (21541,6,50,162,3,'0.31',0),
 (21542,6,51,162,6,'0.63',0),
 (21543,6,55,162,0,'0.00',0),
 (21544,6,56,162,2,'0.21',0),
 (21545,6,57,162,8,'0.84',0),
 (21546,6,58,162,0,'0.00',0),
 (21547,6,59,162,2,'0.21',0),
 (21548,6,60,162,0,'0.00',0),
 (21549,6,61,162,0,'0.00',0),
 (21550,6,62,162,1,'0.10',0),
 (21551,6,1,163,109,'56.19',0),
 (21552,6,2,163,73,'37.63',0),
 (21553,6,14,163,0,'0.00',0),
 (21554,6,15,163,0,'0.00',0),
 (21555,6,28,163,0,'0.00',0),
 (21556,6,32,163,1,'0.52',0),
 (21557,6,38,163,6,'3.09',0),
 (21558,6,40,163,0,'0.00',0),
 (21559,6,45,163,1,'0.52',0),
 (21560,6,48,163,0,'0.00',0),
 (21561,6,50,163,0,'0.00',0),
 (21562,6,51,163,1,'0.52',0),
 (21563,6,55,163,0,'0.00',0),
 (21564,6,56,163,0,'0.00',0),
 (21565,6,57,163,0,'0.00',0),
 (21566,6,58,163,0,'0.00',0),
 (21567,6,59,163,0,'0.00',0),
 (21568,6,60,163,0,'0.00',0),
 (21569,6,61,163,0,'0.00',0),
 (21570,6,62,163,0,'0.00',0),
 (21571,6,1,164,590,'52.63',0),
 (21572,6,2,164,415,'37.02',0),
 (21573,6,14,164,0,'0.00',0),
 (21574,6,15,164,1,'0.09',0),
 (21575,6,28,164,0,'0.00',0),
 (21576,6,32,164,0,'0.00',0),
 (21577,6,38,164,64,'5.71',0),
 (21578,6,40,164,0,'0.00',0),
 (21579,6,45,164,0,'0.00',0),
 (21580,6,48,164,2,'0.18',0),
 (21581,6,50,164,0,'0.00',0),
 (21582,6,51,164,5,'0.45',0),
 (21583,6,55,164,5,'0.45',0),
 (21584,6,56,164,7,'0.62',0),
 (21585,6,57,164,3,'0.27',0),
 (21586,6,58,164,0,'0.00',0),
 (21587,6,59,164,0,'0.00',0),
 (21588,6,60,164,1,'0.09',0),
 (21589,6,61,164,4,'0.36',0),
 (21590,6,62,164,0,'0.00',0),
 (21591,6,1,165,707,'58.48',0),
 (21592,6,2,165,448,'37.06',0),
 (21593,6,14,165,0,'0.00',0),
 (21594,6,15,165,0,'0.00',0),
 (21595,6,28,165,1,'0.08',0),
 (21596,6,32,165,0,'0.00',0),
 (21597,6,38,165,32,'2.65',0),
 (21598,6,40,165,0,'0.00',0),
 (21599,6,45,165,2,'0.17',0),
 (21600,6,48,165,0,'0.00',0),
 (21601,6,50,165,0,'0.00',0),
 (21602,6,51,165,2,'0.17',0),
 (21603,6,55,165,0,'0.00',0),
 (21604,6,56,165,3,'0.25',0),
 (21605,6,57,165,0,'0.00',0),
 (21606,6,58,165,0,'0.00',0),
 (21607,6,59,165,0,'0.00',0),
 (21608,6,60,165,0,'0.00',0),
 (21609,6,61,165,0,'0.00',0),
 (21610,6,62,165,0,'0.00',0),
 (21611,6,1,166,100,'48.54',0),
 (21612,6,2,166,97,'47.09',0),
 (21613,6,14,166,0,'0.00',0),
 (21614,6,15,166,0,'0.00',0),
 (21615,6,28,166,0,'0.00',0),
 (21616,6,32,166,0,'0.00',0),
 (21617,6,38,166,8,'3.88',0),
 (21618,6,40,166,0,'0.00',0),
 (21619,6,45,166,0,'0.00',0),
 (21620,6,48,166,0,'0.00',0),
 (21621,6,50,166,0,'0.00',0),
 (21622,6,51,166,0,'0.00',0),
 (21623,6,55,166,0,'0.00',0),
 (21624,6,56,166,0,'0.00',0),
 (21625,6,57,166,0,'0.00',0),
 (21626,6,58,166,0,'0.00',0),
 (21627,6,59,166,0,'0.00',0),
 (21628,6,60,166,0,'0.00',0),
 (21629,6,61,166,0,'0.00',0),
 (21630,6,62,166,0,'0.00',0),
 (21631,6,1,167,1206,'38.65',0),
 (21632,6,2,167,1436,'46.03',0),
 (21633,6,14,167,4,'0.13',0),
 (21634,6,15,167,1,'0.03',0),
 (21635,6,28,167,0,'0.00',0),
 (21636,6,32,167,0,'0.00',0),
 (21637,6,38,167,401,'12.85',0),
 (21638,6,40,167,2,'0.06',0),
 (21639,6,45,167,0,'0.00',0),
 (21640,6,48,167,1,'0.03',0),
 (21641,6,50,167,0,'0.00',0),
 (21642,6,51,167,14,'0.45',0),
 (21643,6,55,167,0,'0.00',0),
 (21644,6,56,167,10,'0.32',0),
 (21645,6,57,167,1,'0.03',0),
 (21646,6,58,167,0,'0.00',0),
 (21647,6,59,167,0,'0.00',0),
 (21648,6,60,167,0,'0.00',0),
 (21649,6,61,167,0,'0.00',0),
 (21650,6,62,167,0,'0.00',0),
 (21651,6,1,168,418,'58.79',0),
 (21652,6,2,168,256,'36.01',0),
 (21653,6,14,168,0,'0.00',0),
 (21654,6,15,168,1,'0.14',0),
 (21655,6,28,168,0,'0.00',0),
 (21656,6,32,168,0,'0.00',0),
 (21657,6,38,168,16,'2.25',0),
 (21658,6,40,168,0,'0.00',0),
 (21659,6,45,168,0,'0.00',0),
 (21660,6,48,168,0,'0.00',0),
 (21661,6,50,168,0,'0.00',0),
 (21662,6,51,168,2,'0.28',0),
 (21663,6,55,168,0,'0.00',0),
 (21664,6,56,168,2,'0.28',0),
 (21665,6,57,168,4,'0.56',0),
 (21666,6,58,168,1,'0.14',0),
 (21667,6,59,168,0,'0.00',0),
 (21668,6,60,168,0,'0.00',0),
 (21669,6,61,168,0,'0.00',0),
 (21670,6,62,168,0,'0.00',0),
 (21671,6,1,169,278,'63.76',0),
 (21672,6,2,169,122,'27.98',0),
 (21673,6,14,169,2,'0.46',0),
 (21674,6,15,169,1,'0.23',0),
 (21675,6,28,169,2,'0.46',0),
 (21676,6,32,169,1,'0.23',0),
 (21677,6,38,169,19,'4.36',0),
 (21678,6,40,169,0,'0.00',0),
 (21679,6,45,169,0,'0.00',0),
 (21680,6,48,169,0,'0.00',0),
 (21681,6,50,169,0,'0.00',0),
 (21682,6,51,169,2,'0.46',0),
 (21683,6,55,169,1,'0.23',0),
 (21684,6,56,169,0,'0.00',0),
 (21685,6,57,169,0,'0.00',0),
 (21686,6,58,169,1,'0.23',0),
 (21687,6,59,169,0,'0.00',0),
 (21688,6,60,169,0,'0.00',0),
 (21689,6,61,169,0,'0.00',0),
 (21690,6,62,169,0,'0.00',0),
 (21691,6,1,170,571,'38.09',0),
 (21692,6,2,170,551,'36.76',0),
 (21693,6,14,170,0,'0.00',0),
 (21694,6,15,170,6,'0.40',0),
 (21695,6,28,170,5,'0.33',0),
 (21696,6,32,170,0,'0.00',0),
 (21697,6,38,170,336,'22.41',0),
 (21698,6,40,170,0,'0.00',0),
 (21699,6,45,170,1,'0.07',0),
 (21700,6,48,170,0,'0.00',0),
 (21701,6,50,170,0,'0.00',0),
 (21702,6,51,170,6,'0.40',0),
 (21703,6,55,170,2,'0.13',0),
 (21704,6,56,170,6,'0.40',0),
 (21705,6,57,170,0,'0.00',0),
 (21706,6,58,170,1,'0.07',0),
 (21707,6,59,170,0,'0.00',0),
 (21708,6,60,170,2,'0.13',0),
 (21709,6,61,170,0,'0.00',0),
 (21710,6,62,170,1,'0.07',0),
 (21711,6,1,171,1471,'62.81',0),
 (21712,6,2,171,793,'33.86',0),
 (21713,6,14,171,1,'0.04',0),
 (21714,6,15,171,2,'0.09',0),
 (21715,6,28,171,1,'0.04',0),
 (21716,6,32,171,0,'0.00',0),
 (21717,6,38,171,37,'1.58',0),
 (21718,6,40,171,0,'0.00',0),
 (21719,6,45,171,0,'0.00',0),
 (21720,6,48,171,0,'0.00',0),
 (21721,6,50,171,1,'0.04',0),
 (21722,6,51,171,5,'0.21',0),
 (21723,6,55,171,0,'0.00',0),
 (21724,6,56,171,3,'0.13',0),
 (21725,6,57,171,2,'0.09',0),
 (21726,6,58,171,0,'0.00',0),
 (21727,6,59,171,1,'0.04',0),
 (21728,6,60,171,1,'0.04',0),
 (21729,6,61,171,0,'0.00',0),
 (21730,6,62,171,3,'0.13',0),
 (21731,6,1,172,1476,'59.49',0),
 (21732,6,2,172,757,'30.51',0),
 (21733,6,14,172,3,'0.12',0),
 (21734,6,15,172,6,'0.24',0),
 (21735,6,28,172,5,'0.20',0),
 (21736,6,32,172,1,'0.04',0),
 (21737,6,38,172,104,'4.19',0),
 (21738,6,40,172,4,'0.16',0),
 (21739,6,45,172,1,'0.04',0),
 (21740,6,48,172,0,'0.00',0),
 (21741,6,50,172,1,'0.04',0),
 (21742,6,51,172,40,'1.61',0),
 (21743,6,55,172,1,'0.04',0),
 (21744,6,56,172,18,'0.73',0),
 (21745,6,57,172,4,'0.16',0),
 (21746,6,58,172,1,'0.04',0),
 (21747,6,59,172,3,'0.12',0),
 (21748,6,60,172,5,'0.20',0),
 (21749,6,61,172,2,'0.08',0),
 (21750,6,62,172,1,'0.04',0),
 (21751,6,1,173,201,'50.00',0),
 (21752,6,2,173,177,'44.03',0),
 (21753,6,14,173,0,'0.00',0),
 (21754,6,15,173,0,'0.00',0),
 (21755,6,28,173,0,'0.00',0),
 (21756,6,32,173,0,'0.00',0),
 (21757,6,38,173,7,'1.74',0),
 (21758,6,40,173,0,'0.00',0),
 (21759,6,45,173,0,'0.00',0),
 (21760,6,48,173,0,'0.00',0),
 (21761,6,50,173,0,'0.00',0),
 (21762,6,51,173,3,'0.75',0),
 (21763,6,55,173,2,'0.50',0),
 (21764,6,56,173,0,'0.00',0),
 (21765,6,57,173,0,'0.00',0),
 (21766,6,58,173,2,'0.50',0),
 (21767,6,59,173,0,'0.00',0),
 (21768,6,60,173,2,'0.50',0),
 (21769,6,61,173,0,'0.00',0),
 (21770,6,62,173,0,'0.00',0),
 (21771,6,1,174,607,'64.64',0),
 (21772,6,2,174,278,'29.61',0),
 (21773,6,14,174,1,'0.11',0),
 (21774,6,15,174,0,'0.00',0),
 (21775,6,28,174,0,'0.00',0),
 (21776,6,32,174,0,'0.00',0),
 (21777,6,38,174,12,'1.28',0),
 (21778,6,40,174,0,'0.00',0),
 (21779,6,45,174,0,'0.00',0),
 (21780,6,48,174,0,'0.00',0),
 (21781,6,50,174,2,'0.21',0),
 (21782,6,51,174,2,'0.21',0),
 (21783,6,55,174,0,'0.00',0),
 (21784,6,56,174,4,'0.43',0),
 (21785,6,57,174,21,'2.24',0),
 (21786,6,58,174,0,'0.00',0),
 (21787,6,59,174,0,'0.00',0),
 (21788,6,60,174,1,'0.11',0),
 (21789,6,61,174,0,'0.00',0),
 (21790,6,62,174,0,'0.00',0),
 (21791,6,1,175,166,'57.64',0),
 (21792,6,2,175,59,'20.49',0),
 (21793,6,14,175,1,'0.35',0),
 (21794,6,15,175,0,'0.00',0),
 (21795,6,28,175,1,'0.35',0),
 (21796,6,32,175,0,'0.00',0),
 (21797,6,38,175,4,'1.39',0),
 (21798,6,40,175,0,'0.00',0),
 (21799,6,45,175,0,'0.00',0),
 (21800,6,48,175,0,'0.00',0),
 (21801,6,50,175,2,'0.69',0),
 (21802,6,51,175,1,'0.35',0),
 (21803,6,55,175,0,'0.00',0),
 (21804,6,56,175,1,'0.35',0),
 (21805,6,57,175,0,'0.00',0),
 (21806,6,58,175,0,'0.00',0),
 (21807,6,59,175,0,'0.00',0),
 (21808,6,60,175,0,'0.00',0),
 (21809,6,61,175,0,'0.00',0),
 (21810,6,62,175,0,'0.00',0),
 (21811,6,1,176,3155,'70.79',0),
 (21812,6,2,176,890,'19.97',0),
 (21813,6,14,176,6,'0.13',0),
 (21814,6,15,176,3,'0.07',0),
 (21815,6,28,176,7,'0.16',0),
 (21816,6,32,176,1,'0.02',0),
 (21817,6,38,176,136,'3.05',0),
 (21818,6,40,176,2,'0.04',0),
 (21819,6,45,176,5,'0.11',0),
 (21820,6,48,176,3,'0.07',0),
 (21821,6,50,176,2,'0.04',0),
 (21822,6,51,176,19,'0.43',0),
 (21823,6,55,176,0,'0.00',0),
 (21824,6,56,176,55,'1.23',0),
 (21825,6,57,176,16,'0.36',0),
 (21826,6,58,176,3,'0.07',0),
 (21827,6,59,176,0,'0.00',0),
 (21828,6,60,176,4,'0.09',0),
 (21829,6,61,176,4,'0.09',0),
 (21830,6,62,176,5,'0.11',0),
 (21831,6,1,177,1071,'52.60',0),
 (21832,6,2,177,761,'37.38',0),
 (21833,6,14,177,2,'0.10',0),
 (21834,6,15,177,1,'0.05',0),
 (21835,6,28,177,1,'0.05',0),
 (21836,6,32,177,0,'0.00',0),
 (21837,6,38,177,110,'5.40',0),
 (21838,6,40,177,0,'0.00',0),
 (21839,6,45,177,3,'0.15',0),
 (21840,6,48,177,3,'0.15',0),
 (21841,6,50,177,1,'0.05',0),
 (21842,6,51,177,9,'0.44',0),
 (21843,6,55,177,1,'0.05',0),
 (21844,6,56,177,19,'0.93',0),
 (21845,6,57,177,8,'0.39',0),
 (21846,6,58,177,0,'0.00',0),
 (21847,6,59,177,0,'0.00',0),
 (21848,6,60,177,4,'0.20',0),
 (21849,6,61,177,2,'0.10',0),
 (21850,6,62,177,3,'0.15',0),
 (21851,6,1,178,181,'52.01',0),
 (21852,6,2,178,147,'42.24',0),
 (21853,6,14,178,0,'0.00',0),
 (21854,6,15,178,0,'0.00',0),
 (21855,6,28,178,0,'0.00',0),
 (21856,6,32,178,0,'0.00',0),
 (21857,6,38,178,18,'5.17',0),
 (21858,6,40,178,1,'0.29',0),
 (21859,6,45,178,0,'0.00',0),
 (21860,6,48,178,0,'0.00',0),
 (21861,6,50,178,0,'0.00',0),
 (21862,6,51,178,0,'0.00',0),
 (21863,6,55,178,0,'0.00',0),
 (21864,6,56,178,0,'0.00',0),
 (21865,6,57,178,1,'0.29',0),
 (21866,6,58,178,0,'0.00',0),
 (21867,6,59,178,0,'0.00',0),
 (21868,6,60,178,0,'0.00',0),
 (21869,6,61,178,0,'0.00',0),
 (21870,6,62,178,0,'0.00',0),
 (21871,6,1,179,372,'65.38',0),
 (21872,6,2,179,129,'22.67',0),
 (21873,6,14,179,0,'0.00',0),
 (21874,6,15,179,0,'0.00',0),
 (21875,6,28,179,1,'0.18',0),
 (21876,6,32,179,0,'0.00',0),
 (21877,6,38,179,53,'9.31',0),
 (21878,6,40,179,0,'0.00',0),
 (21879,6,45,179,0,'0.00',0),
 (21880,6,48,179,0,'0.00',0),
 (21881,6,50,179,0,'0.00',0),
 (21882,6,51,179,5,'0.88',0),
 (21883,6,55,179,0,'0.00',0),
 (21884,6,56,179,1,'0.18',0),
 (21885,6,57,179,1,'0.18',0),
 (21886,6,58,179,0,'0.00',0),
 (21887,6,59,179,0,'0.00',0),
 (21888,6,60,179,1,'0.18',0),
 (21889,6,61,179,0,'0.00',0),
 (21890,6,62,179,1,'0.18',0),
 (21891,6,1,180,1506,'43.48',0),
 (21892,6,2,180,1497,'43.22',0),
 (21893,6,14,180,1,'0.03',0),
 (21894,6,15,180,1,'0.03',0),
 (21895,6,28,180,0,'0.00',0),
 (21896,6,32,180,0,'0.00',0),
 (21897,6,38,180,413,'11.92',0),
 (21898,6,40,180,0,'0.00',0),
 (21899,6,45,180,0,'0.00',0),
 (21900,6,48,180,0,'0.00',0),
 (21901,6,50,180,0,'0.00',0),
 (21902,6,51,180,10,'0.29',0),
 (21903,6,55,180,0,'0.00',0),
 (21904,6,56,180,9,'0.26',0),
 (21905,6,57,180,5,'0.14',0),
 (21906,6,58,180,0,'0.00',0),
 (21907,6,59,180,0,'0.00',0),
 (21908,6,60,180,2,'0.06',0),
 (21909,6,61,180,0,'0.00',0),
 (21910,6,62,180,0,'0.00',0),
 (21911,6,1,181,6215,'63.70',0),
 (21912,6,2,181,2473,'25.35',0),
 (21913,6,14,181,6,'0.06',0),
 (21914,6,15,181,5,'0.05',0),
 (21915,6,28,181,8,'0.08',0),
 (21916,6,32,181,2,'0.02',0),
 (21917,6,38,181,480,'4.92',0),
 (21918,6,40,181,5,'0.05',0),
 (21919,6,45,181,7,'0.07',0),
 (21920,6,48,181,3,'0.03',0),
 (21921,6,50,181,0,'0.00',0),
 (21922,6,51,181,98,'1.00',0),
 (21923,6,55,181,1,'0.01',0),
 (21924,6,56,181,52,'0.53',0),
 (21925,6,57,181,30,'0.31',0),
 (21926,6,58,181,6,'0.06',0),
 (21927,6,59,181,2,'0.02',0),
 (21928,6,60,181,9,'0.09',0),
 (21929,6,61,181,8,'0.08',0),
 (21930,6,62,181,13,'0.13',0),
 (21931,6,1,182,61,'50.83',0),
 (21932,6,2,182,48,'40.00',0),
 (21933,6,14,182,0,'0.00',0),
 (21934,6,15,182,0,'0.00',0),
 (21935,6,28,182,1,'0.83',0),
 (21936,6,32,182,0,'0.00',0),
 (21937,6,38,182,7,'5.83',0),
 (21938,6,40,182,0,'0.00',0),
 (21939,6,45,182,0,'0.00',0),
 (21940,6,48,182,0,'0.00',0),
 (21941,6,50,182,0,'0.00',0),
 (21942,6,51,182,0,'0.00',0),
 (21943,6,55,182,0,'0.00',0),
 (21944,6,56,182,1,'0.83',0),
 (21945,6,57,182,0,'0.00',0),
 (21946,6,58,182,1,'0.83',0),
 (21947,6,59,182,0,'0.00',0),
 (21948,6,60,182,0,'0.00',0),
 (21949,6,61,182,0,'0.00',0),
 (21950,6,62,182,0,'0.00',0),
 (21951,6,1,183,332,'54.61',0),
 (21952,6,2,183,205,'33.72',0),
 (21953,6,14,183,2,'0.33',0),
 (21954,6,15,183,0,'0.00',0),
 (21955,6,28,183,0,'0.00',0),
 (21956,6,32,183,0,'0.00',0),
 (21957,6,38,183,32,'5.26',0),
 (21958,6,40,183,0,'0.00',0),
 (21959,6,45,183,2,'0.33',0),
 (21960,6,48,183,0,'0.00',0),
 (21961,6,50,183,1,'0.16',0),
 (21962,6,51,183,6,'0.99',0),
 (21963,6,55,183,0,'0.00',0),
 (21964,6,56,183,4,'0.66',0),
 (21965,6,57,183,1,'0.16',0),
 (21966,6,58,183,0,'0.00',0),
 (21967,6,59,183,0,'0.00',0),
 (21968,6,60,183,1,'0.16',0),
 (21969,6,61,183,1,'0.16',0),
 (21970,6,62,183,0,'0.00',0),
 (21971,6,1,901,285,'65.97',0),
 (21972,6,2,901,120,'27.78',0),
 (21973,6,14,901,0,'0.00',0),
 (21974,6,15,901,0,'0.00',0),
 (21975,6,28,901,1,'0.23',0),
 (21976,6,32,901,0,'0.00',0),
 (21977,6,38,901,12,'2.78',0),
 (21978,6,40,901,0,'0.00',0),
 (21979,6,45,901,0,'0.00',0),
 (21980,6,48,901,1,'0.23',0),
 (21981,6,50,901,1,'0.23',0),
 (21982,6,51,901,0,'0.00',0),
 (21983,6,55,901,0,'0.00',0),
 (21984,6,56,901,1,'0.23',0),
 (21985,6,57,901,1,'0.23',0),
 (21986,6,58,901,0,'0.00',0),
 (21987,6,59,901,5,'1.16',0),
 (21988,6,60,901,0,'0.00',0),
 (21989,6,61,901,0,'0.00',0),
 (21990,6,62,901,0,'0.00',0),
 (21991,6,1,902,184,'67.40',0),
 (21992,6,2,902,74,'27.11',0),
 (21993,6,14,902,1,'0.37',0),
 (21994,6,15,902,0,'0.00',0),
 (21995,6,28,902,0,'0.00',0),
 (21996,6,32,902,0,'0.00',0),
 (21997,6,38,902,8,'2.93',0),
 (21998,6,40,902,1,'0.37',0),
 (21999,6,45,902,0,'0.00',0),
 (22000,6,48,902,0,'0.00',0),
 (22001,6,50,902,0,'0.00',0),
 (22002,6,51,902,1,'0.37',0),
 (22003,6,55,902,0,'0.00',0),
 (22004,6,56,902,1,'0.37',0),
 (22005,6,57,902,2,'0.73',0),
 (22006,6,58,902,0,'0.00',0),
 (22007,6,59,902,0,'0.00',0),
 (22008,6,60,902,0,'0.00',0),
 (22009,6,61,902,0,'0.00',0),
 (22010,6,62,902,0,'0.00',0),
 (22011,6,1,903,8302,'53.22',0),
 (22012,6,2,903,5022,'32.19',0),
 (22013,6,14,903,10,'0.06',0),
 (22014,6,15,903,31,'0.20',0),
 (22015,6,28,903,25,'0.16',0),
 (22016,6,32,903,2,'0.01',0),
 (22017,6,38,903,1293,'8.29',0),
 (22018,6,40,903,12,'0.08',0),
 (22019,6,45,903,8,'0.05',0),
 (22020,6,48,903,14,'0.09',0),
 (22021,6,50,903,3,'0.02',0),
 (22022,6,51,903,122,'0.78',0),
 (22023,6,55,903,8,'0.05',0),
 (22024,6,56,903,93,'0.60',0),
 (22025,6,57,903,39,'0.25',0),
 (22026,6,58,903,6,'0.04',0),
 (22027,6,59,903,5,'0.03',0),
 (22028,6,60,903,14,'0.09',0),
 (22029,6,61,903,12,'0.08',0),
 (22030,6,62,903,13,'0.08',0),
 (22031,6,1,999,5194,'39.11',0),
 (22032,6,2,999,5374,'40.46',0),
 (22033,6,14,999,113,'0.85',0),
 (22034,6,15,999,115,'0.87',0),
 (22035,6,28,999,85,'0.64',0),
 (22036,6,32,999,39,'0.29',0),
 (22037,6,38,999,970,'7.30',0),
 (22038,6,40,999,52,'0.39',0),
 (22039,6,45,999,94,'0.71',0),
 (22040,6,48,999,205,'1.54',0),
 (22041,6,50,999,12,'0.09',0),
 (22042,6,51,999,295,'2.22',0),
 (22043,6,55,999,168,'1.26',0),
 (22044,6,56,999,250,'1.88',0),
 (22045,6,57,999,74,'0.56',0),
 (22046,6,58,999,12,'0.09',0),
 (22047,6,59,999,21,'0.16',0),
 (22048,6,60,999,76,'0.57',0),
 (22049,6,61,999,25,'0.19',0),
 (22050,6,62,999,9,'0.07',0),
 (22051,11,1,1,17,'56.67',0),
 (22052,11,1,2,425,'57.67',0),
 (22053,11,1,3,63,'66.32',0),
 (22054,11,1,4,915,'51.55',0),
 (22055,11,1,5,28155,'40.62',0),
 (22056,11,1,6,17433,'48.74',0),
 (22057,11,1,7,28657,'44.88',0),
 (22058,11,1,8,352,'58.96',0),
 (22059,11,1,9,2670,'56.65',0),
 (22060,11,1,10,1100,'56.82',0),
 (22061,11,1,11,94,'52.51',0),
 (22062,11,1,12,180,'56.60',0),
 (22063,11,1,13,8494,'47.83',0),
 (22064,11,1,14,5063,'46.29',0),
 (22065,11,1,15,387,'52.87',0),
 (22066,11,1,16,23,'38.33',0),
 (22067,11,1,17,108,'40.75',0),
 (22068,11,1,18,627,'52.34',0),
 (22069,11,1,19,254,'41.91',0),
 (22070,11,1,20,20,'38.46',0),
 (22071,11,1,21,105,'64.02',0),
 (22072,11,1,22,5813,'70.18',0),
 (22073,11,1,23,590,'58.65',0),
 (22074,11,1,24,46,'65.71',0),
 (22075,11,1,25,178,'59.33',0),
 (22076,11,1,26,861,'61.85',0),
 (22077,11,1,27,346,'53.89',0),
 (22078,11,1,28,391,'59.60',0),
 (22079,11,1,29,142,'62.28',0),
 (22080,11,1,30,353,'62.04',0),
 (22081,11,1,31,452,'41.32',0),
 (22082,11,1,32,303,'38.70',0),
 (22083,11,1,33,651,'57.21',0),
 (22084,11,1,34,155,'57.20',0),
 (22085,11,1,35,277,'39.24',0),
 (22086,11,1,36,167,'57.79',0),
 (22087,11,1,37,406,'38.81',0),
 (22088,11,1,38,1038,'44.68',0),
 (22089,11,1,39,21,'42.86',0),
 (22090,11,1,40,1654,'39.98',0),
 (22091,11,1,41,314,'44.73',0),
 (22092,11,1,42,223,'68.40',0),
 (22093,11,1,43,872,'42.50',0),
 (22094,11,1,44,751,'53.49',0),
 (22095,11,1,45,5725,'48.35',0),
 (22096,11,1,46,814,'56.29',0),
 (22097,11,1,47,6183,'47.00',0),
 (22098,11,1,48,120,'48.98',0),
 (22099,11,1,49,8939,'33.09',0),
 (22100,11,1,50,341,'66.86',0),
 (22101,11,1,51,287,'53.15',0),
 (22102,11,1,52,1228,'61.90',0),
 (22103,11,1,53,376,'46.82',0),
 (22104,11,1,54,1935,'52.80',0),
 (22105,11,1,55,357,'53.36',0),
 (22106,11,1,56,175,'76.09',0),
 (22107,11,1,57,101,'49.75',0),
 (22108,11,1,58,17717,'34.63',0),
 (22109,11,1,59,687,'51.77',0),
 (22110,11,1,60,229,'29.62',0),
 (22111,11,1,61,3340,'56.61',0),
 (22112,11,1,62,109,'61.93',0),
 (22113,11,1,63,79,'61.72',0),
 (22114,11,1,64,41,'57.75',0),
 (22115,11,1,65,22458,'34.10',0),
 (22116,11,1,66,1005,'68.93',0),
 (22117,11,1,67,524,'44.33',0),
 (22118,11,1,68,1855,'55.62',0),
 (22119,11,1,69,29,'87.88',0),
 (22120,11,1,70,65,'82.28',0),
 (22121,11,1,71,19,'46.34',0),
 (22122,11,1,72,1327,'64.92',0),
 (22123,11,1,73,1084,'42.13',0),
 (22124,11,1,74,25408,'33.45',0),
 (22125,11,1,75,594,'45.94',0),
 (22126,11,1,76,131,'50.58',0),
 (22127,11,1,78,20,'90.91',0),
 (22128,11,1,79,820783,'53.94',0),
 (22129,11,1,80,11363,'64.49',0),
 (22130,11,1,82,810,'59.96',0),
 (22131,11,1,83,495,'42.02',0),
 (22132,11,1,84,1675,'33.00',0),
 (22133,11,1,85,762,'49.93',0),
 (22134,11,1,86,763,'55.41',0),
 (22135,11,1,87,796,'59.80',0),
 (22136,11,1,88,70,'44.30',0),
 (22137,11,1,89,480,'59.55',0),
 (22138,11,1,90,718,'55.23',0),
 (22139,11,1,91,1111,'48.52',0),
 (22140,11,1,92,31068,'41.94',0),
 (22141,11,1,93,502,'57.11',0),
 (22142,11,1,94,137,'72.49',0),
 (22143,11,1,95,223,'57.77',0),
 (22144,11,1,96,2641,'55.53',0),
 (22145,11,1,97,11,'15.28',0),
 (22146,11,1,99,371,'61.83',0),
 (22147,11,1,100,359,'54.31',0),
 (22148,11,1,101,50,'62.50',0),
 (22149,11,1,102,135,'30.96',0),
 (22150,11,1,104,1170,'49.58',0),
 (22151,11,1,106,7579,'30.15',0),
 (22152,11,1,107,58,'39.19',0),
 (22153,11,1,108,298,'59.13',0),
 (22154,11,1,109,276,'65.56',0),
 (22155,11,1,110,559,'48.69',0),
 (22156,11,1,111,168,'54.90',0),
 (22157,11,1,112,55,'53.40',0),
 (22158,11,1,113,3336,'35.96',0),
 (22159,11,1,114,53,'61.63',0),
 (22160,11,1,115,18410,'66.52',0),
 (22161,11,1,116,59,'46.46',0),
 (22162,11,1,117,39,'58.21',0),
 (22163,11,1,118,21,'48.84',0),
 (22164,11,1,119,267,'62.38',0),
 (22165,11,1,120,328,'44.38',0),
 (22166,11,1,121,30,'39.47',0),
 (22167,11,1,122,86,'56.95',0),
 (22168,11,1,123,2394,'30.22',0),
 (22169,11,1,124,36,'65.45',0),
 (22170,11,1,125,608,'62.75',0),
 (22171,11,1,126,26,'40.00',0),
 (22172,11,1,127,12727,'63.56',0),
 (22173,11,1,128,91,'43.54',0),
 (22174,11,1,129,911,'53.71',0),
 (22175,11,1,130,3279,'30.72',0),
 (22176,11,1,131,2653,'56.99',0),
 (22177,11,1,132,1282,'37.52',0),
 (22178,11,1,133,1319,'47.82',0),
 (22179,11,1,134,8997,'40.14',0),
 (22180,11,1,135,179,'61.30',0),
 (22181,11,1,136,177,'54.13',0),
 (22182,11,1,137,303,'50.84',0),
 (22183,11,1,138,33,'73.33',0),
 (22184,11,1,140,198,'64.71',0),
 (22185,11,1,141,458,'54.14',0),
 (22186,11,1,143,50,'65.79',0),
 (22187,11,1,144,999,'63.19',0),
 (22188,11,1,145,271,'43.22',0),
 (22189,11,1,146,485,'51.32',0),
 (22190,11,1,147,196,'45.16',0),
 (22191,11,1,148,12675,'38.17',0),
 (22192,11,1,149,480,'54.79',0),
 (22193,11,1,150,473,'56.85',0),
 (22194,11,1,151,623,'49.13',0),
 (22195,11,1,152,2663,'63.77',0),
 (22196,11,1,153,74,'56.49',0),
 (22197,11,1,154,679,'39.85',0),
 (22198,11,1,155,156,'35.21',0),
 (22199,11,1,156,170,'59.23',0),
 (22200,11,1,157,187,'67.03',0),
 (22201,11,1,158,150,'76.14',0),
 (22202,11,1,159,104,'50.24',0),
 (22203,11,1,160,820,'56.87',0),
 (22204,11,1,161,4216,'52.77',0),
 (22205,11,1,162,367,'55.02',0),
 (22206,11,1,163,114,'60.64',0),
 (22207,11,1,164,394,'52.96',0),
 (22208,11,1,165,509,'56.31',0),
 (22209,11,1,166,68,'42.77',0),
 (22210,11,1,167,584,'37.82',0),
 (22211,11,1,168,292,'56.05',0),
 (22212,11,1,169,170,'65.89',0),
 (22213,11,1,170,472,'39.97',0),
 (22214,11,1,171,945,'60.42',0),
 (22215,11,1,172,803,'63.63',0),
 (22216,11,1,173,137,'40.29',0),
 (22217,11,1,174,395,'63.50',0),
 (22218,11,1,175,146,'68.87',0),
 (22219,11,1,176,2024,'75.72',0),
 (22220,11,1,177,395,'41.67',0),
 (22221,11,1,178,113,'54.59',0),
 (22222,11,1,179,223,'56.89',0),
 (22223,11,1,180,1127,'42.59',0),
 (22224,11,1,181,4827,'64.51',0),
 (22225,11,1,182,36,'38.30',0),
 (22226,11,1,183,223,'52.97',0),
 (22227,11,1,901,177,'52.68',0),
 (22228,11,1,902,98,'50.00',0),
 (22229,11,1,903,5302,'53.62',0),
 (22230,13,1,1,33,'78.57',0),
 (22231,13,1,2,654,'55.71',0),
 (22232,13,1,3,83,'64.34',0),
 (22233,13,1,4,1654,'59.18',0),
 (22234,13,1,5,31730,'42.74',0),
 (22235,13,1,6,20439,'48.07',0),
 (22236,13,1,7,35651,'47.13',0),
 (22237,13,1,8,519,'55.39',0),
 (22238,13,1,9,3176,'49.32',0),
 (22239,13,1,10,1681,'50.97',0),
 (22240,13,1,11,137,'61.43',0),
 (22241,13,1,12,219,'50.34',0),
 (22242,13,1,13,9801,'45.47',0),
 (22243,13,1,14,7060,'46.01',0),
 (22244,13,1,15,958,'51.28',0),
 (22245,13,1,16,41,'56.16',0),
 (22246,13,1,17,224,'46.19',0),
 (22247,13,1,18,1049,'55.07',0),
 (22248,13,1,19,306,'43.59',0),
 (22249,13,1,20,48,'48.48',0),
 (22250,13,1,21,168,'72.73',0),
 (22251,13,1,22,5981,'64.98',0),
 (22252,13,1,23,1051,'59.35',0),
 (22253,13,1,24,74,'69.81',0),
 (22254,13,1,25,247,'71.80',0),
 (22255,13,1,26,1453,'57.18',0),
 (22256,13,1,27,486,'56.84',0),
 (22257,13,1,28,533,'59.69',0),
 (22258,13,1,29,208,'61.72',0),
 (22259,13,1,30,585,'61.00',0),
 (22260,13,1,31,620,'41.89',0),
 (22261,13,1,32,506,'38.89',0),
 (22262,13,1,33,871,'54.85',0),
 (22263,13,1,34,221,'67.58',0),
 (22264,13,1,35,347,'44.77',0),
 (22265,13,1,36,274,'53.94',0),
 (22266,13,1,37,576,'45.00',0),
 (22267,13,1,38,1539,'46.82',0),
 (22268,13,1,39,31,'40.26',0),
 (22269,13,1,40,2570,'46.00',0),
 (22270,13,1,41,705,'48.96',0),
 (22271,13,1,42,337,'64.19',0),
 (22272,13,1,43,1571,'46.91',0),
 (22273,13,1,44,1159,'50.70',0),
 (22274,13,1,45,7459,'49.26',0),
 (22275,13,1,46,1118,'52.34',0),
 (22276,13,1,47,7647,'43.52',0),
 (22277,13,1,48,132,'43.28',0),
 (22278,13,1,49,12254,'35.50',0),
 (22279,13,1,50,524,'59.01',0),
 (22280,13,1,51,467,'58.59',0),
 (22281,13,1,52,1571,'61.46',0),
 (22282,13,1,53,789,'45.71',0),
 (22283,13,1,54,2749,'54.73',0),
 (22284,13,1,55,420,'56.00',0),
 (22285,13,1,56,242,'61.27',0),
 (22286,13,1,57,207,'53.08',0),
 (22287,13,1,58,24690,'34.00',0),
 (22288,13,1,59,1031,'52.79',0),
 (22289,13,1,60,284,'27.90',0),
 (22290,13,1,61,5046,'52.30',0),
 (22291,13,1,62,135,'63.68',0),
 (22292,13,1,63,91,'59.09',0),
 (22293,13,1,64,60,'72.29',0),
 (22294,13,1,65,27012,'35.57',0),
 (22295,13,1,66,1604,'66.97',0),
 (22296,13,1,67,830,'46.68',0),
 (22297,13,1,68,2429,'53.38',0),
 (22298,13,1,69,29,'67.44',0),
 (22299,13,1,70,86,'72.88',0),
 (22300,13,1,71,37,'59.68',0),
 (22301,13,1,72,1659,'59.25',0),
 (22302,13,1,73,1663,'40.06',0),
 (22303,13,1,74,30607,'36.25',0),
 (22304,13,1,75,890,'48.63',0),
 (22305,13,1,76,180,'55.73',0),
 (22306,13,1,78,15,'68.18',0),
 (22307,13,1,79,779748,'52.69',0),
 (22308,13,1,80,12844,'60.44',0),
 (22309,13,1,82,1248,'58.90',0),
 (22310,13,1,83,993,'42.82',0),
 (22311,13,1,84,2421,'35.16',0),
 (22312,13,1,85,1019,'47.29',0),
 (22313,13,1,86,1009,'54.07',0),
 (22314,13,1,87,1033,'56.29',0),
 (22315,13,1,88,93,'45.15',0),
 (22316,13,1,89,879,'55.99',0),
 (22317,13,1,90,1355,'55.51',0),
 (22318,13,1,91,1463,'45.58',0),
 (22319,13,1,92,38971,'43.77',0),
 (22320,13,1,93,701,'60.43',0),
 (22321,13,1,94,197,'67.70',0),
 (22322,13,1,95,367,'58.16',0),
 (22323,13,1,96,3401,'53.53',0),
 (22324,13,1,97,24,'29.27',0),
 (22325,13,1,99,624,'63.74',0),
 (22326,13,1,100,699,'50.95',0),
 (22327,13,1,101,62,'60.78',0),
 (22328,13,1,102,170,'32.95',0),
 (22329,13,1,104,1496,'49.39',0),
 (22330,13,1,106,10222,'34.15',0),
 (22331,13,1,107,107,'41.15',0),
 (22332,13,1,108,526,'59.50',0),
 (22333,13,1,109,414,'53.15',0),
 (22334,13,1,110,683,'48.75',0),
 (22335,13,1,111,221,'61.73',0),
 (22336,13,1,112,76,'60.80',0),
 (22337,13,1,113,5009,'36.95',0),
 (22338,13,1,114,64,'59.81',0),
 (22339,13,1,115,20027,'63.73',0),
 (22340,13,1,116,77,'44.51',0),
 (22341,13,1,117,58,'79.45',0),
 (22342,13,1,118,30,'46.88',0),
 (22343,13,1,119,440,'62.59',0),
 (22344,13,1,120,518,'50.49',0),
 (22345,13,1,121,55,'42.97',0),
 (22346,13,1,122,129,'54.89',0),
 (22347,13,1,123,4267,'33.44',0),
 (22348,13,1,124,53,'64.63',0),
 (22349,13,1,125,1008,'71.24',0),
 (22350,13,1,126,31,'42.47',0),
 (22351,13,1,127,14314,'58.88',0),
 (22352,13,1,128,137,'48.75',0),
 (22353,13,1,129,1471,'54.12',0),
 (22354,13,1,130,4620,'32.14',0),
 (22355,13,1,131,3339,'55.62',0),
 (22356,13,1,132,2076,'42.14',0),
 (22357,13,1,133,1677,'47.11',0),
 (22358,13,1,134,11464,'43.36',0),
 (22359,13,1,135,324,'63.28',0),
 (22360,13,1,136,237,'58.81',0),
 (22361,13,1,137,385,'48.92',0);
INSERT INTO `elecmunicandi` (`idElecMuniCandi`,`Convocatoria_idConvocatoria`,`Candidatura_idCandidatura`,`Municipio`,`Votos`,`PorcVotos`,`Concejales`) VALUES 
 (22362,13,1,138,60,'70.59',0),
 (22363,13,1,140,377,'62.31',0),
 (22364,13,1,141,868,'54.45',0),
 (22365,13,1,143,52,'60.47',0),
 (22366,13,1,144,1606,'60.97',0),
 (22367,13,1,145,393,'45.43',0),
 (22368,13,1,146,676,'55.18',0),
 (22369,13,1,147,319,'51.20',0),
 (22370,13,1,148,16659,'42.45',0),
 (22371,13,1,149,1054,'53.50',0),
 (22372,13,1,150,667,'56.48',0),
 (22373,13,1,151,807,'50.50',0),
 (22374,13,1,152,3877,'60.80',0),
 (22375,13,1,153,116,'44.62',0),
 (22376,13,1,154,1183,'45.73',0),
 (22377,13,1,155,191,'41.34',0),
 (22378,13,1,156,214,'51.07',0),
 (22379,13,1,157,217,'64.01',0),
 (22380,13,1,158,263,'76.23',0),
 (22381,13,1,159,188,'49.34',0),
 (22382,13,1,160,1536,'54.62',0),
 (22383,13,1,161,6654,'51.81',0),
 (22384,13,1,162,576,'60.38',0),
 (22385,13,1,163,105,'53.85',0),
 (22386,13,1,164,571,'51.16',0),
 (22387,13,1,165,699,'57.63',0),
 (22388,13,1,166,101,'49.03',0),
 (22389,13,1,167,1161,'37.28',0),
 (22390,13,1,168,407,'57.40',0),
 (22391,13,1,169,284,'64.69',0),
 (22392,13,1,170,566,'37.78',0),
 (22393,13,1,171,1467,'63.10',0),
 (22394,13,1,172,1453,'58.17',0),
 (22395,13,1,173,200,'49.50',0),
 (22396,13,1,174,592,'63.11',0),
 (22397,13,1,175,164,'70.09',0),
 (22398,13,1,176,3140,'69.86',0),
 (22399,13,1,177,1061,'51.78',0),
 (22400,13,1,178,183,'52.29',0),
 (22401,13,1,179,351,'61.58',0),
 (22402,13,1,180,1437,'41.46',0),
 (22403,13,1,181,6139,'63.16',0),
 (22404,13,1,182,54,'45.38',0),
 (22405,13,1,183,320,'52.81',0),
 (22406,13,1,901,280,'65.88',0),
 (22407,13,1,902,184,'67.15',0),
 (22408,13,1,903,7836,'50.21',0),
 (22409,27,1,1,41,'89.13',0),
 (22410,27,1,2,590,'54.08',0),
 (22411,27,1,3,50,'49.50',0),
 (22412,27,1,4,1166,'54.49',0),
 (22413,27,1,5,26852,'43.50',0),
 (22414,27,1,6,18368,'51.13',0),
 (22415,27,1,7,26758,'44.08',0),
 (22416,27,1,8,330,'51.24',0),
 (22417,27,1,9,3146,'55.45',0),
 (22418,27,1,10,2021,'54.37',0),
 (22419,27,1,11,134,'66.67',0),
 (22420,27,1,12,165,'53.92',0),
 (22421,27,1,13,7070,'43.98',0),
 (22422,27,1,14,4982,'47.34',0),
 (22423,27,1,15,1154,'52.41',0),
 (22424,27,1,16,28,'42.42',0),
 (22425,27,1,17,222,'49.22',0),
 (22426,27,1,18,983,'56.24',0),
 (22427,27,1,19,218,'42.91',0),
 (22428,27,1,20,33,'41.25',0),
 (22429,27,1,21,124,'61.69',0),
 (22430,27,1,22,8944,'68.05',0),
 (22431,27,1,23,936,'53.67',0),
 (22432,27,1,24,53,'69.74',0),
 (22433,27,1,25,178,'64.96',0),
 (22434,27,1,26,1510,'60.86',0),
 (22435,27,1,27,338,'53.48',0),
 (22436,27,1,28,355,'47.46',0),
 (22437,27,1,29,167,'59.64',0),
 (22438,27,1,30,406,'53.07',0),
 (22439,27,1,31,482,'45.69',0),
 (22440,27,1,32,594,'45.14',0),
 (22441,27,1,33,726,'58.69',0),
 (22442,27,1,34,160,'60.15',0),
 (22443,27,1,35,274,'43.91',0),
 (22444,27,1,36,300,'48.08',0),
 (22445,27,1,37,426,'43.56',0),
 (22446,27,1,38,1076,'41.80',0),
 (22447,27,1,39,30,'41.10',0),
 (22448,27,1,40,1975,'41.35',0),
 (22449,27,1,41,623,'50.65',0),
 (22450,27,1,42,277,'65.95',0),
 (22451,27,1,43,1020,'52.12',0),
 (22452,27,1,44,1131,'49.09',0),
 (22453,27,1,45,6366,'48.29',0),
 (22454,27,1,46,1026,'53.52',0),
 (22455,27,1,47,7187,'46.05',0),
 (22456,27,1,48,104,'38.66',0),
 (22457,27,1,49,9104,'35.29',0),
 (22458,27,1,50,506,'63.65',0),
 (22459,27,1,51,357,'55.18',0),
 (22460,27,1,52,1041,'57.61',0),
 (22461,27,1,53,909,'46.78',0),
 (22462,27,1,54,2406,'52.83',0),
 (22463,27,1,55,321,'55.34',0),
 (22464,27,1,56,155,'52.19',0),
 (22465,27,1,57,218,'49.43',0),
 (22466,27,1,58,17510,'32.78',0),
 (22467,27,1,59,986,'52.61',0),
 (22468,27,1,60,234,'28.96',0),
 (22469,27,1,61,5045,'55.65',0),
 (22470,27,1,62,111,'64.53',0),
 (22471,27,1,63,68,'50.37',0),
 (22472,27,1,64,56,'62.92',0),
 (22473,27,1,65,20595,'35.53',0),
 (22474,27,1,66,1628,'66.78',0),
 (22475,27,1,67,780,'46.62',0),
 (22476,27,1,68,2431,'57.23',0),
 (22477,27,1,69,30,'57.69',0),
 (22478,27,1,70,57,'64.77',0),
 (22479,27,1,71,28,'43.75',0),
 (22480,27,1,72,1671,'61.03',0),
 (22481,27,1,73,1282,'41.94',0),
 (22482,27,1,74,22234,'34.75',0),
 (22483,27,1,75,713,'48.27',0),
 (22484,27,1,76,126,'52.72',0),
 (22485,27,1,78,13,'65.00',0),
 (22486,27,1,79,655827,'52.50',0),
 (22487,27,1,80,15508,'65.15',0),
 (22488,27,1,82,1053,'55.42',0),
 (22489,27,1,83,1060,'44.86',0),
 (22490,27,1,84,1807,'38.11',0),
 (22491,27,1,85,870,'47.33',0),
 (22492,27,1,86,799,'56.03',0),
 (22493,27,1,87,917,'57.13',0),
 (22494,27,1,88,73,'47.40',0),
 (22495,27,1,89,786,'55.35',0),
 (22496,27,1,90,1655,'51.11',0),
 (22497,27,1,91,960,'46.13',0),
 (22498,27,1,92,27384,'41.30',0),
 (22499,27,1,93,640,'62.26',0),
 (22500,27,1,94,177,'67.82',0),
 (22501,27,1,95,310,'53.26',0),
 (22502,27,1,96,2880,'53.45',0),
 (22503,27,1,97,13,'16.46',0),
 (22504,27,1,99,390,'58.56',0),
 (22505,27,1,100,701,'51.39',0),
 (22506,27,1,101,44,'57.89',0),
 (22507,27,1,102,132,'28.57',0),
 (22508,27,1,104,1293,'50.23',0),
 (22509,27,1,106,6382,'27.52',0),
 (22510,27,1,107,83,'41.92',0),
 (22511,27,1,108,526,'58.31',0),
 (22512,27,1,109,383,'61.38',0),
 (22513,27,1,110,582,'50.13',0),
 (22514,27,1,111,151,'53.74',0),
 (22515,27,1,112,54,'50.94',0),
 (22516,27,1,113,4283,'39.33',0),
 (22517,27,1,114,50,'75.76',0),
 (22518,27,1,115,21854,'68.41',0),
 (22519,27,1,116,70,'44.87',0),
 (22520,27,1,117,47,'64.38',0),
 (22521,27,1,118,19,'38.78',0),
 (22522,27,1,119,414,'59.83',0),
 (22523,27,1,120,308,'46.74',0),
 (22524,27,1,121,60,'45.80',0),
 (22525,27,1,122,106,'54.92',0),
 (22526,27,1,123,4904,'32.04',0),
 (22527,27,1,124,45,'66.18',0),
 (22528,27,1,125,620,'56.16',0),
 (22529,27,1,126,19,'36.54',0),
 (22530,27,1,127,17963,'63.40',0),
 (22531,27,1,128,100,'52.08',0),
 (22532,27,1,129,1302,'54.25',0),
 (22533,27,1,130,3838,'33.75',0),
 (22534,27,1,131,3111,'55.93',0),
 (22535,27,1,132,1610,'41.13',0),
 (22536,27,1,133,1225,'48.69',0),
 (22537,27,1,134,9507,'43.60',0),
 (22538,27,1,135,193,'54.52',0),
 (22539,27,1,136,204,'55.89',0),
 (22540,27,1,137,317,'47.89',0),
 (22541,27,1,138,33,'47.14',0),
 (22542,27,1,140,403,'55.36',0),
 (22543,27,1,141,1000,'59.03',0),
 (22544,27,1,143,38,'52.05',0),
 (22545,27,1,144,1505,'56.14',0),
 (22546,27,1,145,296,'41.00',0),
 (22547,27,1,146,454,'51.13',0),
 (22548,27,1,147,204,'47.89',0),
 (22549,27,1,148,12831,'41.31',0),
 (22550,27,1,149,786,'52.05',0),
 (22551,27,1,150,559,'55.35',0),
 (22552,27,1,151,690,'49.96',0),
 (22553,27,1,152,4556,'64.32',0),
 (22554,27,1,153,94,'45.63',0),
 (22555,27,1,154,821,'44.07',0),
 (22556,27,1,155,125,'34.53',0),
 (22557,27,1,156,191,'48.48',0),
 (22558,27,1,157,175,'62.28',0),
 (22559,27,1,158,192,'72.73',0),
 (22560,27,1,159,116,'42.49',0),
 (22561,27,1,160,1593,'54.67',0),
 (22562,27,1,161,6335,'51.93',0),
 (22563,27,1,162,556,'60.57',0),
 (22564,27,1,163,84,'44.68',0),
 (22565,27,1,164,506,'50.70',0),
 (22566,27,1,165,482,'57.24',0),
 (22567,27,1,166,74,'43.27',0),
 (22568,27,1,167,1085,'40.44',0),
 (22569,27,1,168,283,'54.84',0),
 (22570,27,1,169,297,'64.43',0),
 (22571,27,1,170,366,'40.13',0),
 (22572,27,1,171,972,'58.70',0),
 (22573,27,1,172,1615,'61.64',0),
 (22574,27,1,173,160,'53.33',0),
 (22575,27,1,174,408,'59.91',0),
 (22576,27,1,175,157,'60.15',0),
 (22577,27,1,176,3442,'71.09',0),
 (22578,27,1,177,1669,'58.01',0),
 (22579,27,1,178,181,'52.16',0),
 (22580,27,1,179,338,'58.48',0),
 (22581,27,1,180,1106,'43.51',0),
 (22582,27,1,181,6435,'63.09',0),
 (22583,27,1,182,42,'43.30',0),
 (22584,27,1,183,222,'48.16',0),
 (22585,27,1,901,191,'54.57',0),
 (22586,27,1,902,123,'63.73',0),
 (22587,27,1,903,7801,'49.83',0),
 (22588,27,1,999,9797,'38.64',0),
 (22589,20,1,1,28,'82.35',0),
 (22590,20,1,2,726,'55.21',0),
 (22591,20,1,3,53,'43.80',0),
 (22592,20,1,4,1424,'58.60',0),
 (22593,20,1,5,28986,'44.35',0),
 (22594,20,1,6,18787,'50.28',0),
 (22595,20,1,7,27936,'45.24',0),
 (22596,20,1,8,405,'51.66',0),
 (22597,20,1,9,3421,'52.99',0),
 (22598,20,1,10,2360,'49.62',0),
 (22599,20,1,11,127,'59.07',0),
 (22600,20,1,12,230,'54.50',0),
 (22601,20,1,13,8524,'48.51',0),
 (22602,20,1,14,7024,'51.34',0),
 (22603,20,1,15,2511,'55.63',0),
 (22604,20,1,16,23,'37.70',0),
 (22605,20,1,17,257,'46.06',0),
 (22606,20,1,18,1065,'55.88',0),
 (22607,20,1,19,261,'42.58',0),
 (22608,20,1,20,34,'38.64',0),
 (22609,20,1,21,123,'57.21',0),
 (22610,20,1,22,9889,'61.52',0),
 (22611,20,1,23,1157,'52.09',0),
 (22612,20,1,24,48,'60.00',0),
 (22613,20,1,25,177,'65.56',0),
 (22614,20,1,26,1684,'57.89',0),
 (22615,20,1,27,333,'52.36',0),
 (22616,20,1,28,347,'41.56',0),
 (22617,20,1,29,186,'58.68',0),
 (22618,20,1,30,473,'50.81',0),
 (22619,20,1,31,481,'46.61',0),
 (22620,20,1,32,958,'50.63',0),
 (22621,20,1,33,944,'62.72',0),
 (22622,20,1,34,161,'65.98',0),
 (22623,20,1,35,377,'50.33',0),
 (22624,20,1,36,465,'47.89',0),
 (22625,20,1,37,437,'45.71',0),
 (22626,20,1,38,1155,'43.08',0),
 (22627,20,1,39,31,'43.06',0),
 (22628,20,1,40,2644,'47.00',0),
 (22629,20,1,41,948,'53.83',0),
 (22630,20,1,42,347,'64.38',0),
 (22631,20,1,43,1314,'57.86',0),
 (22632,20,1,44,1247,'47.45',0),
 (22633,20,1,45,7077,'48.39',0),
 (22634,20,1,46,1115,'49.38',0),
 (22635,20,1,47,8067,'44.38',0),
 (22636,20,1,48,116,'39.32',0),
 (22637,20,1,49,11272,'38.01',0),
 (22638,20,1,50,809,'57.66',0),
 (22639,20,1,51,444,'58.42',0),
 (22640,20,1,52,1186,'63.05',0),
 (22641,20,1,53,1384,'47.20',0),
 (22642,20,1,54,2629,'51.17',0),
 (22643,20,1,55,334,'57.39',0),
 (22644,20,1,56,215,'53.75',0),
 (22645,20,1,57,351,'48.41',0),
 (22646,20,1,58,24111,'39.75',0),
 (22647,20,1,59,1097,'54.04',0),
 (22648,20,1,60,263,'31.65',0),
 (22649,20,1,61,5206,'51.38',0),
 (22650,20,1,62,109,'63.01',0),
 (22651,20,1,63,78,'51.66',0),
 (22652,20,1,64,47,'65.28',0),
 (22653,20,1,65,23236,'39.02',0),
 (22654,20,1,66,2229,'64.76',0),
 (22655,20,1,67,903,'45.93',0),
 (22656,20,1,68,2781,'55.41',0),
 (22657,20,1,69,17,'50.00',0),
 (22658,20,1,70,51,'59.30',0),
 (22659,20,1,71,26,'60.47',0),
 (22660,20,1,72,1437,'52.10',0),
 (22661,20,1,73,2292,'47.22',0),
 (22662,20,1,74,26109,'38.58',0),
 (22663,20,1,75,1083,'50.70',0),
 (22664,20,1,76,130,'50.58',0),
 (22665,20,1,78,16,'64.00',0),
 (22666,20,1,79,611690,'50.06',0),
 (22667,20,1,80,15379,'59.45',0),
 (22668,20,1,82,1260,'50.60',0),
 (22669,20,1,83,1546,'47.89',0),
 (22670,20,1,84,2918,'45.30',0),
 (22671,20,1,85,935,'46.61',0),
 (22672,20,1,86,1120,'57.44',0),
 (22673,20,1,87,919,'52.88',0),
 (22674,20,1,88,50,'38.17',0),
 (22675,20,1,89,948,'59.18',0),
 (22676,20,1,90,2029,'50.76',0),
 (22677,20,1,91,1136,'50.81',0),
 (22678,20,1,92,31535,'44.45',0),
 (22679,20,1,93,627,'57.21',0),
 (22680,20,1,94,222,'63.07',0),
 (22681,20,1,95,375,'55.07',0),
 (22682,20,1,96,3931,'57.01',0),
 (22683,20,1,97,16,'22.86',0),
 (22684,20,1,99,549,'65.12',0),
 (22685,20,1,100,908,'51.68',0),
 (22686,20,1,101,54,'43.20',0),
 (22687,20,1,102,218,'41.84',0),
 (22688,20,1,104,2545,'51.68',0),
 (22689,20,1,106,10628,'36.44',0),
 (22690,20,1,107,89,'41.40',0),
 (22691,20,1,108,691,'52.67',0),
 (22692,20,1,109,483,'63.14',0),
 (22693,20,1,110,612,'52.58',0),
 (22694,20,1,111,187,'53.89',0),
 (22695,20,1,112,60,'51.72',0),
 (22696,20,1,113,6112,'43.88',0),
 (22697,20,1,114,57,'75.00',0),
 (22698,20,1,115,20612,'62.07',0),
 (22699,20,1,116,130,'45.94',0),
 (22700,20,1,117,41,'66.13',0),
 (22701,20,1,118,20,'43.48',0),
 (22702,20,1,119,563,'60.73',0),
 (22703,20,1,120,305,'45.45',0),
 (22704,20,1,121,60,'46.88',0),
 (22705,20,1,122,147,'56.76',0),
 (22706,20,1,123,7628,'32.76',0),
 (22707,20,1,124,28,'45.90',0),
 (22708,20,1,125,790,'58.30',0),
 (22709,20,1,126,17,'39.53',0),
 (22710,20,1,127,19135,'58.10',0),
 (22711,20,1,128,111,'52.36',0),
 (22712,20,1,129,1667,'51.59',0),
 (22713,20,1,130,4815,'37.37',0),
 (22714,20,1,131,3333,'53.59',0),
 (22715,20,1,132,2109,'44.20',0),
 (22716,20,1,133,1529,'52.98',0),
 (22717,20,1,134,11691,'45.24',0),
 (22718,20,1,135,265,'57.48',0),
 (22719,20,1,136,220,'55.28',0),
 (22720,20,1,137,393,'49.81',0),
 (22721,20,1,138,26,'52.00',0),
 (22722,20,1,140,707,'58.67',0),
 (22723,20,1,141,1300,'55.20',0),
 (22724,20,1,143,31,'54.39',0),
 (22725,20,1,144,1717,'54.72',0),
 (22726,20,1,145,432,'45.05',0),
 (22727,20,1,146,474,'54.36',0),
 (22728,20,1,147,249,'52.64',0),
 (22729,20,1,148,16927,'47.52',0),
 (22730,20,1,149,1146,'53.28',0),
 (22731,20,1,150,862,'58.64',0),
 (22732,20,1,151,742,'49.57',0),
 (22733,20,1,152,4542,'56.74',0),
 (22734,20,1,153,99,'35.48',0),
 (22735,20,1,154,1229,'49.28',0),
 (22736,20,1,155,125,'38.70',0),
 (22737,20,1,156,239,'52.30',0),
 (22738,20,1,157,221,'65.58',0),
 (22739,20,1,158,218,'65.27',0),
 (22740,20,1,159,193,'60.50',0),
 (22741,20,1,160,1970,'55.73',0),
 (22742,20,1,161,9255,'51.05',0),
 (22743,20,1,162,636,'54.36',0),
 (22744,20,1,163,96,'46.15',0),
 (22745,20,1,164,787,'58.56',0),
 (22746,20,1,165,556,'63.91',0),
 (22747,20,1,166,107,'52.71',0),
 (22748,20,1,167,1592,'45.38',0),
 (22749,20,1,168,294,'54.95',0),
 (22750,20,1,169,356,'57.23',0),
 (22751,20,1,170,514,'51.45',0),
 (22752,20,1,171,1210,'64.64',0),
 (22753,20,1,172,1897,'57.00',0),
 (22754,20,1,173,151,'49.03',0),
 (22755,20,1,174,472,'55.86',0),
 (22756,20,1,175,235,'61.84',0),
 (22757,20,1,176,3807,'64.65',0),
 (22758,20,1,177,2613,'56.36',0),
 (22759,20,1,178,243,'53.17',0),
 (22760,20,1,179,403,'61.25',0),
 (22761,20,1,180,1347,'48.16',0),
 (22762,20,1,181,6578,'59.57',0),
 (22763,20,1,182,56,'50.45',0),
 (22764,20,1,183,227,'45.04',0),
 (22765,20,1,901,184,'51.40',0),
 (22766,20,1,902,117,'58.79',0),
 (22767,20,1,903,7047,'41.95',0),
 (22768,20,1,999,6675,'35.44',0),
 (22949,12,1,1,21,'58.33',0),
 (22950,12,1,2,536,'56.54',0),
 (22951,12,1,3,66,'61.11',0),
 (22952,12,1,4,1402,'56.42',0),
 (22953,12,1,5,40786,'40.60',0),
 (22954,12,1,6,24919,'48.21',0),
 (22955,12,1,7,43856,'46.07',0),
 (22956,12,1,8,491,'60.47',0),
 (22957,12,1,9,3746,'51.60',0),
 (22958,12,1,10,1763,'56.13',0),
 (22959,12,1,11,125,'54.82',0),
 (22960,12,1,12,228,'54.55',0),
 (22961,12,1,13,11646,'46.04',0),
 (22962,12,1,14,7788,'44.93',0),
 (22963,12,1,15,770,'50.46',0),
 (22964,12,1,16,28,'36.84',0),
 (22965,12,1,17,213,'50.35',0),
 (22966,12,1,18,906,'52.92',0),
 (22967,12,1,19,306,'38.49',0),
 (22968,12,1,20,39,'44.32',0),
 (22969,12,1,21,149,'66.52',0),
 (22970,12,1,22,7956,'69.42',0),
 (22971,12,1,23,888,'56.52',0),
 (22972,12,1,24,67,'73.63',0),
 (22973,12,1,25,206,'61.31',0),
 (22974,12,1,26,1286,'59.04',0),
 (22975,12,1,27,478,'56.43',0),
 (22976,12,1,28,539,'59.36',0),
 (22977,12,1,29,172,'60.35',0),
 (22978,12,1,30,516,'61.43',0),
 (22979,12,1,31,595,'41.15',0),
 (22980,12,1,32,523,'38.86',0),
 (22981,12,1,33,878,'55.32',0),
 (22982,12,1,34,187,'56.67',0),
 (22983,12,1,35,360,'45.06',0),
 (22984,12,1,36,216,'53.07',0),
 (22985,12,1,37,531,'41.81',0),
 (22986,12,1,38,1425,'45.04',0),
 (22987,12,1,39,29,'42.03',0),
 (22988,12,1,40,2809,'41.89',0),
 (22989,12,1,41,582,'50.39',0),
 (22990,12,1,42,314,'65.55',0),
 (22991,12,1,43,1418,'43.30',0),
 (22992,12,1,44,1075,'50.83',0),
 (22993,12,1,45,8307,'48.36',0),
 (22994,12,1,46,1213,'55.04',0),
 (22995,12,1,47,9986,'46.61',0),
 (22996,12,1,48,135,'46.23',0),
 (22997,12,1,49,15262,'33.90',0),
 (22998,12,1,50,465,'64.32',0),
 (22999,12,1,51,418,'54.78',0),
 (23000,12,1,52,1583,'58.94',0),
 (23001,12,1,53,603,'45.48',0),
 (23002,12,1,54,2876,'52.86',0),
 (23003,12,1,55,402,'52.21',0),
 (23004,12,1,56,226,'64.94',0),
 (23005,12,1,57,152,'47.95',0),
 (23006,12,1,58,30602,'35.26',0),
 (23007,12,1,59,981,'52.01',0),
 (23008,12,1,60,317,'32.12',0),
 (23009,12,1,61,5513,'55.92',0),
 (23010,12,1,62,136,'63.55',0),
 (23011,12,1,63,99,'63.06',0),
 (23012,12,1,64,51,'65.38',0),
 (23013,12,1,65,33708,'35.37',0),
 (23014,12,1,66,1578,'70.29',0),
 (23015,12,1,67,743,'46.73',0),
 (23016,12,1,68,2765,'55.90',0),
 (23017,12,1,69,31,'79.49',0),
 (23018,12,1,70,68,'76.40',0),
 (23019,12,1,71,31,'52.54',0),
 (23020,12,1,72,1812,'64.42',0),
 (23021,12,1,73,1819,'40.95',0),
 (23022,12,1,74,40113,'35.12',0),
 (23023,12,1,75,837,'47.72',0),
 (23024,12,1,76,179,'53.59',0),
 (23025,12,1,78,16,'66.67',0),
 (23026,12,1,79,1054858,'52.76',0),
 (23027,12,1,80,15427,'63.83',0),
 (23028,12,1,82,1143,'58.92',0),
 (23029,12,1,83,839,'40.75',0),
 (23030,12,1,84,2702,'32.86',0),
 (23031,12,1,85,1103,'50.97',0),
 (23032,12,1,86,1091,'54.31',0),
 (23033,12,1,87,1022,'57.45',0),
 (23034,12,1,88,78,'41.27',0),
 (23035,12,1,89,705,'57.50',0),
 (23036,12,1,90,1084,'52.29',0),
 (23037,12,1,91,1597,'47.00',0),
 (23038,12,1,92,49217,'42.40',0),
 (23039,12,1,93,700,'60.19',0),
 (23040,12,1,94,162,'62.55',0),
 (23041,12,1,95,310,'57.30',0),
 (23042,12,1,96,3573,'52.33',0),
 (23043,12,1,97,18,'22.50',0),
 (23044,12,1,99,550,'61.59',0),
 (23045,12,1,100,660,'55.32',0),
 (23046,12,1,101,70,'65.42',0),
 (23047,12,1,102,177,'33.08',0),
 (23048,12,1,104,1649,'50.94',0),
 (23049,12,1,106,12697,'31.14',0),
 (23050,12,1,107,89,'38.36',0),
 (23051,12,1,108,431,'58.48',0),
 (23052,12,1,109,393,'62.68',0),
 (23053,12,1,110,717,'50.49',0),
 (23054,12,1,111,196,'54.60',0),
 (23055,12,1,112,68,'55.74',0),
 (23056,12,1,113,5748,'38.08',0),
 (23057,12,1,114,57,'51.82',0),
 (23058,12,1,115,24637,'67.13',0),
 (23059,12,1,116,78,'46.99',0),
 (23060,12,1,117,57,'75.00',0),
 (23061,12,1,118,28,'47.46',0),
 (23062,12,1,119,345,'60.95',0),
 (23063,12,1,120,469,'47.61',0),
 (23064,12,1,121,40,'38.10',0),
 (23065,12,1,122,108,'54.82',0),
 (23066,12,1,123,4036,'32.07',0),
 (23067,12,1,124,31,'41.89',0),
 (23068,12,1,125,817,'59.29',0),
 (23069,12,1,126,23,'31.51',0),
 (23070,12,1,127,17505,'63.31',0),
 (23071,12,1,128,112,'44.62',0),
 (23072,12,1,129,1461,'54.05',0),
 (23073,12,1,130,5716,'32.93',0),
 (23074,12,1,131,3746,'55.81',0),
 (23075,12,1,132,2169,'39.75',0),
 (23076,12,1,133,1745,'46.41',0),
 (23077,12,1,134,14475,'41.73',0),
 (23078,12,1,135,253,'56.10',0),
 (23079,12,1,136,207,'53.21',0),
 (23080,12,1,137,328,'47.13',0),
 (23081,12,1,138,48,'66.67',0),
 (23082,12,1,140,296,'63.79',0),
 (23083,12,1,141,761,'53.78',0),
 (23084,12,1,143,43,'51.19',0),
 (23085,12,1,144,1427,'62.04',0),
 (23086,12,1,145,362,'43.41',0),
 (23087,12,1,146,620,'49.48',0),
 (23088,12,1,147,300,'47.92',0),
 (23089,12,1,148,20530,'39.89',0),
 (23090,12,1,149,923,'53.73',0),
 (23091,12,1,150,638,'59.07',0),
 (23092,12,1,151,831,'47.57',0),
 (23093,12,1,152,4078,'65.23',0),
 (23094,12,1,153,88,'48.35',0),
 (23095,12,1,154,952,'39.77',0),
 (23096,12,1,155,167,'34.50',0),
 (23097,12,1,156,199,'52.79',0),
 (23098,12,1,157,224,'58.18',0),
 (23099,12,1,158,229,'75.58',0),
 (23100,12,1,159,182,'51.70',0),
 (23101,12,1,160,1354,'55.15',0),
 (23102,12,1,161,6761,'53.49',0),
 (23103,12,1,162,572,'58.25',0),
 (23104,12,1,163,142,'60.68',0),
 (23105,12,1,164,535,'50.81',0),
 (23106,12,1,165,643,'54.54',0),
 (23107,12,1,166,98,'44.55',0),
 (23108,12,1,167,932,'37.89',0),
 (23109,12,1,168,403,'58.41',0),
 (23110,12,1,169,239,'66.02',0),
 (23111,12,1,170,613,'33.63',0),
 (23112,12,1,171,1308,'58.39',0),
 (23113,12,1,172,1284,'62.91',0),
 (23114,12,1,173,176,'42.82',0),
 (23115,12,1,174,543,'61.36',0),
 (23116,12,1,175,155,'64.32',0),
 (23117,12,1,176,3027,'73.47',0),
 (23118,12,1,177,717,'45.93',0),
 (23119,12,1,178,163,'53.97',0),
 (23120,12,1,179,349,'60.28',0),
 (23121,12,1,180,1494,'42.84',0),
 (23122,12,1,181,7095,'65.75',0),
 (23123,12,1,182,48,'37.80',0),
 (23124,12,1,183,334,'55.12',0),
 (23125,12,1,901,223,'54.13',0),
 (23126,12,1,902,143,'54.17',0),
 (23127,12,1,903,7986,'52.87',0),
 (23128,15,1,1,44,'89.80',0),
 (23129,15,1,2,747,'58.77',0),
 (23130,15,1,3,76,'61.79',0),
 (23131,15,1,4,1593,'59.62',0),
 (23132,15,1,5,44055,'47.27',0),
 (23133,15,1,6,26896,'53.52',0),
 (23134,15,1,7,45748,'49.66',0),
 (23135,15,1,8,506,'58.63',0),
 (23136,15,1,9,4226,'55.57',0),
 (23137,15,1,10,2414,'57.70',0),
 (23138,15,1,11,136,'64.15',0),
 (23139,15,1,12,211,'52.62',0),
 (23140,15,1,13,11633,'49.04',0),
 (23141,15,1,14,8584,'50.55',0),
 (23142,15,1,15,1135,'54.99',0),
 (23143,15,1,16,39,'59.09',0),
 (23144,15,1,17,247,'48.72',0),
 (23145,15,1,18,1149,'59.63',0),
 (23146,15,1,19,305,'42.66',0),
 (23147,15,1,20,54,'58.06',0),
 (23148,15,1,21,137,'63.13',0),
 (23149,15,1,22,8506,'70.27',0),
 (23150,15,1,23,1103,'60.11',0),
 (23151,15,1,24,58,'64.44',0),
 (23152,15,1,25,217,'64.20',0),
 (23153,15,1,26,1639,'60.55',0),
 (23154,15,1,27,488,'59.51',0),
 (23155,15,1,28,498,'56.91',0),
 (23156,15,1,29,190,'59.56',0),
 (23157,15,1,30,598,'59.92',0),
 (23158,15,1,31,638,'44.74',0),
 (23159,15,1,32,646,'47.68',0),
 (23160,15,1,33,957,'57.72',0),
 (23161,15,1,34,195,'62.30',0),
 (23162,15,1,35,406,'51.79',0),
 (23163,15,1,36,252,'52.28',0),
 (23164,15,1,37,538,'44.03',0),
 (23165,15,1,38,1645,'49.13',0),
 (23166,15,1,39,28,'40.00',0),
 (23167,15,1,40,3132,'47.52',0),
 (23168,15,1,41,851,'54.94',0),
 (23169,15,1,42,322,'64.92',0),
 (23170,15,1,43,1545,'51.33',0),
 (23171,15,1,44,1328,'54.36',0),
 (23172,15,1,45,9233,'52.30',0),
 (23173,15,1,46,1368,'56.37',0),
 (23174,15,1,47,11109,'49.85',0),
 (23175,15,1,48,112,'40.29',0),
 (23176,15,1,49,17101,'39.99',0),
 (23177,15,1,50,641,'66.98',0),
 (23178,15,1,51,506,'61.86',0),
 (23179,15,1,52,1628,'63.92',0),
 (23180,15,1,53,1086,'52.95',0),
 (23181,15,1,54,3243,'55.84',0),
 (23182,15,1,55,369,'51.97',0),
 (23183,15,1,56,232,'59.18',0),
 (23184,15,1,57,204,'56.35',0),
 (23185,15,1,58,35167,'38.96',0),
 (23186,15,1,59,1330,'58.08',0),
 (23187,15,1,60,323,'32.17',0),
 (23188,15,1,61,6790,'57.85',0),
 (23189,15,1,62,139,'69.50',0),
 (23190,15,1,63,73,'50.69',0),
 (23191,15,1,64,52,'65.82',0),
 (23192,15,1,65,35698,'39.62',0),
 (23193,15,1,66,1875,'67.86',0),
 (23194,15,1,67,936,'51.01',0),
 (23195,15,1,68,3137,'58.45',0),
 (23196,15,1,69,31,'67.39',0),
 (23197,15,1,70,75,'76.53',0),
 (23198,15,1,71,36,'66.67',0),
 (23199,15,1,72,1999,'64.13',0),
 (23200,15,1,73,1917,'44.14',0),
 (23201,15,1,74,40862,'39.72',0),
 (23202,15,1,75,931,'50.65',0),
 (23203,15,1,76,172,'55.31',0),
 (23204,15,1,78,12,'63.16',0),
 (23205,15,1,79,974608,'55.38',0),
 (23206,15,1,80,17250,'65.48',0),
 (23207,15,1,82,1372,'62.42',0),
 (23208,15,1,83,1318,'47.02',0),
 (23209,15,1,84,3333,'42.59',0),
 (23210,15,1,85,1121,'50.72',0),
 (23211,15,1,86,1114,'58.42',0),
 (23212,15,1,87,1195,'61.44',0),
 (23213,15,1,88,91,'47.89',0),
 (23214,15,1,89,981,'59.74',0),
 (23215,15,1,90,1674,'56.19',0),
 (23216,15,1,91,1585,'50.06',0),
 (23217,15,1,92,49723,'45.97',0),
 (23218,15,1,93,738,'61.71',0),
 (23219,15,1,94,212,'65.43',0),
 (23220,15,1,95,399,'63.03',0),
 (23221,15,1,96,3949,'54.00',0),
 (23222,15,1,97,27,'33.33',0),
 (23223,15,1,99,643,'68.11',0),
 (23224,15,1,100,972,'56.94',0),
 (23225,15,1,101,65,'60.19',0),
 (23226,15,1,102,187,'35.89',0),
 (23227,15,1,104,1820,'54.95',0),
 (23228,15,1,106,13847,'36.28',0),
 (23229,15,1,107,101,'41.91',0),
 (23230,15,1,108,558,'61.59',0),
 (23231,15,1,109,453,'64.81',0),
 (23232,15,1,110,701,'51.09',0),
 (23233,15,1,111,0,'0.00',0),
 (23234,15,1,112,67,'50.76',0),
 (23235,15,1,113,6923,'44.07',0),
 (23236,15,1,114,70,'67.96',0),
 (23237,15,1,115,26627,'68.63',0),
 (23238,15,1,116,78,'46.99',0),
 (23239,15,1,117,57,'75.00',0),
 (23240,15,1,118,27,'46.55',0),
 (23241,15,1,119,450,'65.89',0),
 (23242,15,1,120,512,'53.17',0),
 (23243,15,1,121,51,'41.13',0),
 (23244,15,1,122,122,'52.36',0),
 (23245,15,1,123,5724,'36.82',0),
 (23246,15,1,124,48,'63.16',0),
 (23247,15,1,125,939,'67.60',0),
 (23248,15,1,126,24,'38.10',0),
 (23249,15,1,127,19964,'64.69',0),
 (23250,15,1,128,105,'44.12',0),
 (23251,15,1,129,1677,'57.63',0),
 (23252,15,1,130,7004,'39.01',0),
 (23253,15,1,131,4041,'58.37',0),
 (23254,15,1,132,2393,'43.01',0),
 (23255,15,1,133,1912,'51.93',0),
 (23256,15,1,134,15592,'47.24',0),
 (23257,15,1,135,313,'64.94',0),
 (23258,15,1,136,238,'60.25',0),
 (23259,15,1,137,370,'51.53',0),
 (23260,15,1,138,49,'69.01',0),
 (23261,15,1,140,349,'63.00',0),
 (23262,15,1,141,1172,'62.24',0),
 (23263,15,1,143,48,'61.54',0),
 (23264,15,1,144,1789,'61.00',0),
 (23265,15,1,145,436,'48.93',0),
 (23266,15,1,146,674,'55.38',0),
 (23267,15,1,147,296,'49.83',0),
 (23268,15,1,148,23457,'46.73',0),
 (23269,15,1,149,1287,'57.38',0),
 (23270,15,1,150,733,'60.58',0),
 (23271,15,1,151,872,'53.46',0),
 (23272,15,1,152,5280,'66.65',0),
 (23273,15,1,153,122,'53.74',0),
 (23274,15,1,154,1250,'49.04',0),
 (23275,15,1,155,174,'40.00',0),
 (23276,15,1,156,224,'53.98',0),
 (23277,15,1,157,240,'61.86',0),
 (23278,15,1,158,257,'75.15',0),
 (23279,15,1,159,205,'56.63',0),
 (23280,15,1,160,1758,'58.04',0),
 (23281,15,1,161,8579,'57.48',0),
 (23282,15,1,162,672,'61.65',0),
 (23283,15,1,163,118,'57.00',0),
 (23284,15,1,164,637,'55.10',0),
 (23285,15,1,165,678,'59.47',0),
 (23286,15,1,166,96,'47.76',0),
 (23287,15,1,167,1639,'43.84',0),
 (23288,15,1,168,414,'59.40',0),
 (23289,15,1,169,308,'65.67',0),
 (23290,15,1,170,606,'43.60',0),
 (23291,15,1,171,1407,'62.15',0),
 (23292,15,1,172,1893,'64.19',0),
 (23293,15,1,173,198,'49.87',0),
 (23294,15,1,174,634,'67.52',0),
 (23295,15,1,175,171,'69.23',0),
 (23296,15,1,176,3971,'71.43',0),
 (23297,15,1,177,1297,'54.89',0),
 (23298,15,1,178,194,'58.43',0),
 (23299,15,1,179,463,'63.34',0),
 (23300,15,1,180,1535,'44.86',0),
 (23301,15,1,181,7981,'66.28',0),
 (23302,15,1,182,66,'53.23',0),
 (23303,15,1,183,310,'52.36',0),
 (23304,15,1,901,239,'57.31',0),
 (23305,15,1,902,179,'69.92',0),
 (23306,15,1,903,10597,'55.09',0),
 (23307,15,1,999,10810,'49.45',0),
 (23308,17,1,1,44,'89.80',0),
 (23309,17,1,2,872,'50.82',0),
 (23310,17,1,3,69,'52.67',0),
 (23311,17,1,4,1824,'50.99',0),
 (23312,17,1,5,43624,'40.01',0),
 (23313,17,1,6,26914,'46.08',0),
 (23314,17,1,7,41934,'40.51',0),
 (23315,17,1,8,558,'52.74',0),
 (23316,17,1,9,4831,'49.24',0),
 (23317,17,1,10,3070,'50.67',0),
 (23318,17,1,11,151,'61.63',0),
 (23319,17,1,12,229,'49.57',0),
 (23320,17,1,13,11208,'41.96',0),
 (23321,17,1,14,9177,'46.54',0),
 (23322,17,1,15,2064,'49.77',0),
 (23323,17,1,16,35,'46.67',0),
 (23324,17,1,17,368,'46.35',0),
 (23325,17,1,18,1337,'53.20',0),
 (23326,17,1,19,301,'38.49',0),
 (23327,17,1,20,35,'32.71',0),
 (23328,17,1,21,162,'58.70',0),
 (23329,17,1,22,12205,'62.08',0),
 (23330,17,1,23,1361,'51.42',0),
 (23331,17,1,24,68,'61.26',0),
 (23332,17,1,25,222,'63.07',0),
 (23333,17,1,26,2207,'56.24',0),
 (23334,17,1,27,489,'52.75',0),
 (23335,17,1,28,477,'45.30',0),
 (23336,17,1,29,192,'52.46',0),
 (23337,17,1,30,567,'47.89',0),
 (23338,17,1,31,699,'46.41',0),
 (23339,17,1,32,973,'40.76',0),
 (23340,17,1,33,1101,'54.97',0),
 (23341,17,1,34,191,'59.32',0),
 (23342,17,1,35,394,'46.74',0),
 (23343,17,1,36,484,'42.31',0),
 (23344,17,1,37,550,'43.48',0),
 (23345,17,1,38,1559,'41.62',0),
 (23346,17,1,39,46,'46.94',0),
 (23347,17,1,40,3323,'38.63',0),
 (23348,17,1,41,983,'49.32',0),
 (23349,17,1,42,357,'62.52',0),
 (23350,17,1,43,1745,'48.36',0),
 (23351,17,1,44,1754,'47.74',0),
 (23352,17,1,45,9571,'44.97',0),
 (23353,17,1,46,1525,'51.29',0),
 (23354,17,1,47,11732,'43.19',0),
 (23355,17,1,48,132,'38.71',0),
 (23356,17,1,49,16409,'32.89',0),
 (23357,17,1,50,845,'54.55',0),
 (23358,17,1,51,540,'52.58',0),
 (23359,17,1,52,1582,'57.38',0),
 (23360,17,1,53,1601,'44.31',0),
 (23361,17,1,54,3674,'50.08',0),
 (23362,17,1,55,392,'54.29',0),
 (23363,17,1,56,217,'44.83',0),
 (23364,17,1,57,354,'47.58',0),
 (23365,17,1,58,33968,'30.90',0),
 (23366,17,1,59,1495,'49.37',0),
 (23367,17,1,60,312,'29.46',0),
 (23368,17,1,61,7446,'50.80',0),
 (23369,17,1,62,128,'58.72',0),
 (23370,17,1,63,89,'50.57',0),
 (23371,17,1,64,59,'54.63',0),
 (23372,17,1,65,33214,'33.18',0),
 (23373,17,1,66,2624,'61.38',0),
 (23374,17,1,67,1141,'45.44',0),
 (23375,17,1,68,3732,'53.57',0),
 (23376,17,1,69,33,'50.77',0),
 (23377,17,1,70,66,'66.67',0),
 (23378,17,1,71,27,'38.03',0),
 (23379,17,1,72,2177,'57.00',0),
 (23380,17,1,73,2422,'37.92',0),
 (23381,17,1,74,37644,'33.17',0),
 (23382,17,1,75,1137,'46.00',0),
 (23383,17,1,76,150,'46.44',0),
 (23384,17,1,78,15,'62.50',0),
 (23385,17,1,79,893135,'47.61',0),
 (23386,17,1,80,20055,'59.82',0),
 (23387,17,1,82,1598,'51.17',0),
 (23388,17,1,83,2033,'41.17',0),
 (23389,17,1,84,3654,'34.91',0),
 (23390,17,1,85,1203,'45.43',0),
 (23391,17,1,86,1227,'52.68',0),
 (23392,17,1,87,1273,'54.17',0),
 (23393,17,1,88,85,'41.87',0),
 (23394,17,1,89,1185,'53.12',0),
 (23395,17,1,90,2481,'49.09',0),
 (23396,17,1,91,1489,'43.18',0),
 (23397,17,1,92,47285,'38.25',0),
 (23398,17,1,93,811,'57.23',0),
 (23399,17,1,94,272,'58.49',0),
 (23400,17,1,95,421,'50.18',0),
 (23401,17,1,96,4634,'51.13',0),
 (23402,17,1,97,15,'16.30',0),
 (23403,17,1,99,646,'58.25',0),
 (23404,17,1,100,1214,'48.95',0),
 (23405,17,1,101,63,'56.76',0),
 (23406,17,1,102,164,'28.67',0),
 (23407,17,1,104,1937,'48.22',0),
 (23408,17,1,106,12456,'26.45',0),
 (23409,17,1,107,97,'34.89',0),
 (23410,17,1,108,725,'54.59',0),
 (23411,17,1,109,555,'57.57',0),
 (23412,17,1,110,722,'48.42',0),
 (23413,17,1,111,193,'50.00',0),
 (23414,17,1,112,67,'51.54',0),
 (23415,17,1,113,7612,'36.49',0),
 (23416,17,1,114,78,'62.90',0),
 (23417,17,1,115,28418,'62.76',0),
 (23418,17,1,116,88,'46.81',0),
 (23419,17,1,117,47,'53.41',0),
 (23420,17,1,118,27,'40.91',0),
 (23421,17,1,119,587,'56.99',0),
 (23422,17,1,120,452,'46.41',0),
 (23423,17,1,121,73,'46.20',0),
 (23424,17,1,122,129,'48.68',0),
 (23425,17,1,123,8089,'31.23',0),
 (23426,17,1,124,48,'60.00',0),
 (23427,17,1,125,970,'57.13',0),
 (23428,17,1,126,24,'47.06',0),
 (23429,17,1,127,24518,'58.91',0),
 (23430,17,1,128,117,'46.06',0),
 (23431,17,1,129,1960,'49.31',0),
 (23432,17,1,130,7139,'32.06',0),
 (23433,17,1,131,4415,'51.76',0),
 (23434,17,1,132,2826,'40.91',0),
 (23435,17,1,133,1942,'47.74',0),
 (23436,17,1,134,15249,'39.61',0),
 (23437,17,1,135,302,'51.19',0),
 (23438,17,1,136,260,'54.62',0),
 (23439,17,1,137,431,'47.62',0),
 (23440,17,1,138,46,'50.00',0),
 (23441,17,1,140,767,'54.71',0),
 (23442,17,1,141,1625,'52.61',0),
 (23443,17,1,143,46,'56.10',0),
 (23444,17,1,144,2148,'53.00',0),
 (23445,17,1,145,426,'40.49',0),
 (23446,17,1,146,627,'49.88',0),
 (23447,17,1,147,265,'44.99',0),
 (23448,17,1,148,22729,'38.01',0),
 (23449,17,1,149,1404,'46.21',0),
 (23450,17,1,150,926,'49.12',0),
 (23451,17,1,151,935,'47.61',0),
 (23452,17,1,152,6251,'60.04',0),
 (23453,17,1,153,125,'41.25',0),
 (23454,17,1,154,1340,'42.36',0),
 (23455,17,1,155,156,'35.06',0),
 (23456,17,1,156,262,'48.34',0),
 (23457,17,1,157,235,'54.52',0),
 (23458,17,1,158,288,'64.57',0),
 (23459,17,1,159,225,'49.89',0),
 (23460,17,1,160,2345,'49.97',0),
 (23461,17,1,161,10619,'47.28',0),
 (23462,17,1,162,726,'56.45',0),
 (23463,17,1,163,106,'44.35',0),
 (23464,17,1,164,787,'47.55',0),
 (23465,17,1,165,668,'54.49',0),
 (23466,17,1,166,110,'47.83',0),
 (23467,17,1,167,2000,'37.52',0),
 (23468,17,1,168,399,'53.92',0),
 (23469,17,1,169,386,'59.38',0),
 (23470,17,1,170,585,'34.49',0),
 (23471,17,1,171,1476,'55.97',0),
 (23472,17,1,172,2455,'56.88',0),
 (23473,17,1,173,201,'50.50',0),
 (23474,17,1,174,634,'58.22',0),
 (23475,17,1,175,183,'56.66',0),
 (23476,17,1,176,4513,'65.41',0),
 (23477,17,1,177,2519,'53.33',0),
 (23478,17,1,178,304,'50.67',0),
 (23479,17,1,179,499,'52.69',0),
 (23480,17,1,180,1624,'42.36',0),
 (23481,17,1,181,9139,'59.00',0),
 (23482,17,1,182,60,'45.80',0),
 (23483,17,1,183,311,'45.40',0),
 (23484,17,1,901,250,'51.23',0),
 (23485,17,1,902,173,'61.13',0),
 (23486,17,1,903,10865,'46.89',0),
 (23487,17,1,999,17170,'51.14',0),
 (23488,19,1,1,38,'82.61',0),
 (23489,19,1,2,1039,'56.25',0),
 (23490,19,1,3,78,'48.75',0),
 (23491,19,1,4,2411,'58.66',0),
 (23492,19,1,5,48087,'45.24',0),
 (23493,19,1,6,29818,'50.58',0),
 (23494,19,1,7,45878,'45.70',0),
 (23495,19,1,8,712,'56.20',0),
 (23496,19,1,9,5654,'54.65',0),
 (23497,19,1,10,3861,'53.74',0),
 (23498,19,1,11,172,'57.33',0),
 (23499,19,1,12,354,'57.00',0),
 (23500,19,1,13,13434,'47.49',0),
 (23501,19,1,14,11933,'51.74',0),
 (23502,19,1,15,3888,'57.22',0),
 (23503,19,1,16,30,'40.00',0),
 (23504,19,1,17,472,'53.82',0),
 (23505,19,1,18,1578,'55.90',0),
 (23506,19,1,19,355,'41.23',0),
 (23507,19,1,20,39,'37.50',0),
 (23508,19,1,21,160,'51.61',0),
 (23509,19,1,22,15031,'64.90',0),
 (23510,19,1,23,1785,'54.67',0),
 (23511,19,1,24,71,'62.83',0),
 (23512,19,1,25,230,'64.43',0),
 (23513,19,1,26,2689,'58.81',0),
 (23514,19,1,27,513,'53.05',0),
 (23515,19,1,28,505,'42.58',0),
 (23516,19,1,29,250,'56.69',0),
 (23517,19,1,30,642,'51.61',0),
 (23518,19,1,31,731,'47.75',0),
 (23519,19,1,32,1689,'50.92',0),
 (23520,19,1,33,1443,'58.59',0),
 (23521,19,1,34,190,'60.51',0),
 (23522,19,1,35,498,'50.61',0),
 (23523,19,1,36,908,'49.73',0),
 (23524,19,1,37,606,'46.47',0),
 (23525,19,1,38,1758,'45.02',0),
 (23526,19,1,39,45,'54.22',0),
 (23527,19,1,40,4534,'46.23',0),
 (23528,19,1,41,1427,'55.05',0),
 (23529,19,1,42,473,'63.66',0),
 (23530,19,1,43,2447,'58.03',0),
 (23531,19,1,44,2078,'50.73',0),
 (23532,19,1,45,11245,'49.93',0),
 (23533,19,1,46,1755,'52.72',0),
 (23534,19,1,47,13735,'47.95',0),
 (23535,19,1,48,147,'40.05',0),
 (23536,19,1,49,19551,'39.88',0),
 (23537,19,1,50,1401,'60.03',0),
 (23538,19,1,51,638,'57.27',0),
 (23539,19,1,52,1802,'61.25',0),
 (23540,19,1,53,2333,'50.32',0),
 (23541,19,1,54,4399,'54.51',0),
 (23542,19,1,55,453,'54.25',0),
 (23543,19,1,56,293,'53.08',0),
 (23544,19,1,57,584,'51.96',0),
 (23545,19,1,58,43201,'40.31',0),
 (23546,19,1,59,1683,'54.13',0),
 (23547,19,1,60,369,'30.90',0),
 (23548,19,1,61,8117,'53.01',0),
 (23549,19,1,62,158,'65.02',0),
 (23550,19,1,63,102,'45.95',0),
 (23551,19,1,64,57,'55.34',0),
 (23552,19,1,65,37938,'39.34',0),
 (23553,19,1,66,3486,'65.39',0),
 (23554,19,1,67,1492,'48.32',0),
 (23555,19,1,68,4447,'56.75',0),
 (23556,19,1,69,41,'67.21',0),
 (23557,19,1,70,64,'64.00',0),
 (23558,19,1,71,34,'59.65',0),
 (23559,19,1,72,2352,'57.20',0),
 (23560,19,1,73,4139,'47.80',0),
 (23561,19,1,74,43128,'38.92',0),
 (23562,19,1,75,1734,'51.36',0),
 (23563,19,1,76,170,'50.60',0),
 (23564,19,1,78,16,'57.14',0),
 (23565,19,1,79,919701,'50.63',0),
 (23566,19,1,80,22818,'62.05',0),
 (23567,19,1,82,1879,'50.82',0),
 (23568,19,1,83,2800,'50.22',0),
 (23569,19,1,84,5212,'45.70',0),
 (23570,19,1,85,1505,'50.55',0),
 (23571,19,1,86,1720,'56.23',0),
 (23572,19,1,87,1429,'56.89',0),
 (23573,19,1,88,73,'37.63',0),
 (23574,19,1,89,1599,'58.90',0),
 (23575,19,1,90,3350,'54.14',0),
 (23576,19,1,91,1876,'48.94',0),
 (23577,19,1,92,54205,'45.18',0),
 (23578,19,1,93,898,'58.58',0),
 (23579,19,1,94,322,'61.10',0),
 (23580,19,1,95,572,'55.16',0),
 (23581,19,1,96,6168,'59.02',0),
 (23582,19,1,97,23,'21.10',0),
 (23583,19,1,99,780,'62.80',0),
 (23584,19,1,100,1566,'52.91',0),
 (23585,19,1,101,75,'47.17',0),
 (23586,19,1,102,269,'41.77',0),
 (23587,19,1,104,3048,'53.03',0),
 (23588,19,1,106,18540,'36.77',0),
 (23589,19,1,107,118,'38.56',0),
 (23590,19,1,108,1070,'54.82',0),
 (23591,19,1,109,705,'61.04',0),
 (23592,19,1,110,830,'51.94',0),
 (23593,19,1,111,292,'56.15',0),
 (23594,19,1,112,68,'51.13',0),
 (23595,19,1,113,10439,'44.18',0),
 (23596,19,1,114,83,'66.40',0),
 (23597,19,1,115,30437,'64.78',0),
 (23598,19,1,116,165,'46.48',0),
 (23599,19,1,117,50,'61.73',0),
 (23600,19,1,118,26,'38.81',0),
 (23601,19,1,119,868,'60.36',0),
 (23602,19,1,120,478,'47.75',0),
 (23603,19,1,121,74,'49.01',0),
 (23604,19,1,122,198,'55.00',0),
 (23605,19,1,123,12847,'36.26',0),
 (23606,19,1,124,45,'52.33',0),
 (23607,19,1,125,1248,'58.10',0),
 (23608,19,1,126,18,'42.86',0),
 (23609,19,1,127,28930,'61.38',0),
 (23610,19,1,128,137,'50.93',0),
 (23611,19,1,129,2656,'54.37',0),
 (23612,19,1,130,8608,'39.16',0),
 (23613,19,1,131,5186,'54.62',0),
 (23614,19,1,132,3516,'45.88',0),
 (23615,19,1,133,2357,'53.53',0),
 (23616,19,1,134,19158,'46.35',0),
 (23617,19,1,135,382,'54.57',0),
 (23618,19,1,136,281,'53.73',0),
 (23619,19,1,137,598,'49.46',0),
 (23620,19,1,138,41,'53.25',0),
 (23621,19,1,140,1176,'58.98',0),
 (23622,19,1,141,2307,'59.18',0),
 (23623,19,1,143,42,'54.55',0),
 (23624,19,1,144,2498,'56.21',0),
 (23625,19,1,145,584,'44.21',0),
 (23626,19,1,146,654,'50.74',0),
 (23627,19,1,147,351,'51.77',0),
 (23628,19,1,148,27839,'46.54',0),
 (23629,19,1,149,2024,'54.58',0),
 (23630,19,1,150,1389,'57.33',0),
 (23631,19,1,151,1153,'51.20',0),
 (23632,19,1,152,7073,'60.84',0),
 (23633,19,1,153,147,'37.31',0),
 (23634,19,1,154,1954,'50.00',0),
 (23635,19,1,155,194,'42.73',0),
 (23636,19,1,156,348,'51.10',0),
 (23637,19,1,157,278,'60.57',0),
 (23638,19,1,158,322,'64.14',0),
 (23639,19,1,159,278,'57.44',0),
 (23640,19,1,160,3206,'56.24',0),
 (23641,19,1,161,16053,'52.77',0),
 (23642,19,1,162,932,'59.44',0),
 (23643,19,1,163,123,'48.05',0),
 (23644,19,1,164,1195,'56.18',0),
 (23645,19,1,165,765,'59.44',0),
 (23646,19,1,166,136,'51.13',0),
 (23647,19,1,167,2663,'44.83',0),
 (23648,19,1,168,419,'54.06',0),
 (23649,19,1,169,566,'59.77',0),
 (23650,19,1,170,850,'47.75',0),
 (23651,19,1,171,1871,'61.91',0),
 (23652,19,1,172,2951,'59.96',0),
 (23653,19,1,173,220,'54.19',0),
 (23654,19,1,174,729,'57.36',0),
 (23655,19,1,175,290,'58.47',0),
 (23656,19,1,176,5502,'66.53',0),
 (23657,19,1,177,4368,'59.18',0),
 (23658,19,1,178,439,'57.01',0),
 (23659,19,1,179,644,'61.33',0),
 (23660,19,1,180,1903,'46.99',0),
 (23661,19,1,181,10160,'62.36',0),
 (23662,19,1,182,87,'51.48',0),
 (23663,19,1,183,329,'45.69',0),
 (23664,19,1,901,274,'50.55',0),
 (23665,19,1,902,208,'65.82',0),
 (23666,19,1,903,11290,'47.28',0),
 (23667,19,1,999,14969,'37.81',0),
 (23668,22,1,1,38,'84.44',0),
 (23669,22,1,2,1162,'58.30',0),
 (23670,22,1,3,67,'44.37',0),
 (23671,22,1,4,2443,'60.41',0),
 (23672,22,1,5,46667,'46.90',0),
 (23673,22,1,6,30216,'53.11',0),
 (23674,22,1,7,45333,'48.16',0),
 (23675,22,1,8,752,'61.59',0),
 (23676,22,1,9,5761,'56.01',0),
 (23677,22,1,10,3898,'53.92',0),
 (23678,22,1,11,196,'62.22',0),
 (23679,22,1,12,359,'55.15',0),
 (23680,22,1,13,14449,'52.45',0),
 (23681,22,1,14,12547,'54.24',0),
 (23682,22,1,15,6315,'55.31',0),
 (23683,22,1,16,33,'49.25',0),
 (23684,22,1,17,491,'55.29',0),
 (23685,22,1,18,1619,'57.92',0),
 (23686,22,1,19,398,'44.82',0),
 (23687,22,1,20,40,'40.00',0),
 (23688,22,1,21,175,'53.35',0),
 (23689,22,1,22,15899,'65.48',0),
 (23690,22,1,23,1913,'56.40',0),
 (23691,22,1,24,74,'56.06',0),
 (23692,22,1,25,225,'67.77',0),
 (23693,22,1,26,2668,'59.97',0),
 (23694,22,1,27,481,'52.34',0),
 (23695,22,1,28,524,'44.67',0),
 (23696,22,1,29,240,'57.97',0),
 (23697,22,1,30,620,'50.41',0),
 (23698,22,1,31,838,'55.87',0),
 (23699,22,1,32,1790,'53.13',0),
 (23700,22,1,33,1690,'62.80',0),
 (23701,22,1,34,186,'67.39',0),
 (23702,22,1,35,566,'54.11',0),
 (23703,22,1,36,917,'51.40',0),
 (23704,22,1,37,639,'51.12',0),
 (23705,22,1,38,1683,'46.88',0),
 (23706,22,1,39,54,'52.43',0),
 (23707,22,1,40,4845,'49.18',0),
 (23708,22,1,41,1837,'58.24',0),
 (23709,22,1,42,536,'66.34',0),
 (23710,22,1,43,2538,'61.20',0),
 (23711,22,1,44,2242,'53.53',0),
 (23712,22,1,45,11881,'51.93',0),
 (23713,22,1,46,1726,'52.75',0),
 (23714,22,1,47,13927,'48.98',0),
 (23715,22,1,48,168,'43.19',0),
 (23716,22,1,49,19291,'41.59',0),
 (23717,22,1,50,1611,'60.50',0),
 (23718,22,1,51,669,'59.26',0),
 (23719,22,1,52,1812,'66.64',0),
 (23720,22,1,53,2465,'51.54',0),
 (23721,22,1,54,4199,'54.55',0),
 (23722,22,1,55,429,'60.68',0),
 (23723,22,1,56,316,'53.92',0),
 (23724,22,1,57,579,'53.91',0),
 (23725,22,1,58,44055,'42.90',0),
 (23726,22,1,59,1806,'57.70',0),
 (23727,22,1,60,450,'37.75',0),
 (23728,22,1,61,8114,'54.44',0),
 (23729,22,1,62,149,'65.93',0),
 (23730,22,1,63,109,'53.69',0),
 (23731,22,1,64,70,'63.64',0),
 (23732,22,1,65,39047,'42.36',0),
 (23733,22,1,66,3559,'66.12',0),
 (23734,22,1,67,1467,'49.73',0),
 (23735,22,1,68,4494,'57.78',0),
 (23736,22,1,69,24,'72.73',0),
 (23737,22,1,70,52,'53.61',0),
 (23738,22,1,71,37,'67.27',0),
 (23739,22,1,72,2288,'57.10',0),
 (23740,22,1,73,4540,'51.77',0),
 (23741,22,1,74,44175,'42.03',0),
 (23742,22,1,75,2075,'52.99',0),
 (23743,22,1,76,176,'54.83',0),
 (23744,22,1,78,19,'82.61',0),
 (23745,22,1,79,880723,'51.65',0),
 (23746,22,1,80,23342,'63.90',0),
 (23747,22,1,82,2006,'51.37',0),
 (23748,22,1,83,3052,'50.66',0),
 (23749,22,1,84,5555,'48.92',0),
 (23750,22,1,85,1490,'50.80',0),
 (23751,22,1,86,1893,'58.28',0),
 (23752,22,1,87,1451,'59.15',0),
 (23753,22,1,88,78,'45.09',0),
 (23754,22,1,89,1645,'59.75',0),
 (23755,22,1,90,3311,'54.00',0),
 (23756,22,1,91,1972,'53.72',0),
 (23757,22,1,92,52822,'47.66',0),
 (23758,22,1,93,917,'60.41',0),
 (23759,22,1,94,308,'55.90',0),
 (23760,22,1,95,604,'56.08',0),
 (23761,22,1,96,6877,'55.87',0),
 (23762,22,1,97,26,'28.26',0),
 (23763,22,1,99,809,'64.93',0),
 (23764,22,1,100,1599,'55.81',0),
 (23765,22,1,101,78,'49.37',0),
 (23766,22,1,102,321,'46.32',0),
 (23767,22,1,104,5177,'55.30',0),
 (23768,22,1,106,21993,'41.87',0),
 (23769,22,1,107,149,'44.74',0),
 (23770,22,1,108,1169,'52.47',0),
 (23771,22,1,109,739,'66.94',0),
 (23772,22,1,110,795,'53.90',0),
 (23773,22,1,111,274,'57.20',0),
 (23774,22,1,112,74,'54.01',0),
 (23775,22,1,113,10880,'46.42',0),
 (23776,22,1,114,72,'65.45',0),
 (23777,22,1,115,30787,'66.27',0),
 (23778,22,1,116,258,'51.81',0),
 (23779,22,1,117,50,'55.56',0),
 (23780,22,1,118,26,'55.32',0),
 (23781,22,1,119,953,'62.95',0),
 (23782,22,1,120,472,'50.70',0),
 (23783,22,1,121,81,'53.29',0),
 (23784,22,1,122,203,'55.46',0),
 (23785,22,1,123,14250,'37.32',0),
 (23786,22,1,124,26,'49.06',0),
 (23787,22,1,125,1252,'60.92',0),
 (23788,22,1,126,20,'54.05',0),
 (23789,22,1,127,30089,'62.63',0),
 (23790,22,1,128,137,'49.82',0),
 (23791,22,1,129,3004,'55.01',0),
 (23792,22,1,130,8808,'41.72',0),
 (23793,22,1,131,5091,'54.50',0),
 (23794,22,1,132,3784,'47.64',0),
 (23795,22,1,133,2288,'55.21',0),
 (23796,22,1,134,20880,'49.45',0),
 (23797,22,1,135,365,'55.39',0),
 (23798,22,1,136,286,'55.43',0),
 (23799,22,1,137,651,'53.27',0),
 (23800,22,1,138,26,'56.52',0),
 (23801,22,1,140,1268,'59.22',0),
 (23802,22,1,141,2383,'58.82',0),
 (23803,22,1,143,40,'59.70',0),
 (23804,22,1,144,2573,'58.34',0),
 (23805,22,1,145,793,'48.95',0),
 (23806,22,1,146,704,'58.42',0),
 (23807,22,1,147,378,'54.15',0),
 (23808,22,1,148,30028,'50.34',0),
 (23809,22,1,149,2272,'55.92',0),
 (23810,22,1,150,1440,'61.41',0),
 (23811,22,1,151,1119,'51.21',0),
 (23812,22,1,152,7457,'62.85',0),
 (23813,22,1,153,164,'40.39',0),
 (23814,22,1,154,1991,'51.58',0),
 (23815,22,1,155,196,'47.12',0),
 (23816,22,1,156,390,'53.21',0),
 (23817,22,1,157,287,'64.35',0),
 (23818,22,1,158,317,'64.04',0),
 (23819,22,1,159,305,'63.81',0),
 (23820,22,1,160,3215,'57.28',0),
 (23821,22,1,161,17616,'53.44',0),
 (23822,22,1,162,1058,'59.24',0),
 (23823,22,1,163,142,'47.18',0),
 (23824,22,1,164,1308,'60.19',0),
 (23825,22,1,165,888,'68.57',0),
 (23826,22,1,166,137,'51.12',0),
 (23827,22,1,167,2852,'48.00',0),
 (23828,22,1,168,453,'55.93',0),
 (23829,22,1,169,576,'59.88',0),
 (23830,22,1,170,910,'52.69',0),
 (23831,22,1,171,1897,'64.77',0),
 (23832,22,1,172,3605,'59.33',0),
 (23833,22,1,173,233,'59.74',0),
 (23834,22,1,174,754,'61.60',0),
 (23835,22,1,175,387,'61.43',0),
 (23836,22,1,176,5866,'67.29',0),
 (23837,22,1,177,4552,'60.97',0),
 (23838,22,1,178,463,'58.53',0),
 (23839,22,1,179,627,'61.05',0),
 (23840,22,1,180,2103,'52.91',0),
 (23841,22,1,181,10232,'64.14',0),
 (23842,22,1,182,92,'51.69',0),
 (23843,22,1,183,302,'46.53',0),
 (23844,22,1,901,288,'50.79',0),
 (23845,22,1,902,203,'61.70',0),
 (23846,22,1,903,11173,'47.17',0),
 (23847,22,1,999,5941,'48.06',0),
 (23848,25,1,1,32,'66.67',0),
 (23849,25,1,2,809,'37.16',0),
 (23850,25,1,3,44,'31.21',0),
 (23851,25,1,4,1614,'36.98',0),
 (23852,25,1,5,30927,'29.76',0),
 (23853,25,1,6,21784,'35.36',0),
 (23854,25,1,7,30500,'30.85',0),
 (23855,25,1,8,511,'39.86',0),
 (23856,25,1,9,3803,'34.70',0),
 (23857,25,1,10,2820,'35.55',0),
 (23858,25,1,11,132,'39.05',0),
 (23859,25,1,12,262,'37.92',0),
 (23860,25,1,13,9717,'32.38',0),
 (23861,25,1,14,8168,'33.15',0),
 (23862,25,1,15,4254,'29.03',0),
 (23863,25,1,16,19,'33.33',0),
 (23864,25,1,17,297,'31.50',0),
 (23865,25,1,18,1217,'39.86',0),
 (23866,25,1,19,258,'27.51',0),
 (23867,25,1,20,38,'39.18',0),
 (23868,25,1,21,125,'32.30',0),
 (23869,25,1,22,12404,'45.23',0),
 (23870,25,1,23,1326,'34.71',0),
 (23871,25,1,24,61,'47.29',0),
 (23872,25,1,25,193,'58.84',0),
 (23873,25,1,26,1858,'38.14',0),
 (23874,25,1,27,327,'37.03',0),
 (23875,25,1,28,373,'28.11',0),
 (23876,25,1,29,162,'38.21',0),
 (23877,25,1,30,467,'35.46',0),
 (23878,25,1,31,649,'42.59',0),
 (23879,25,1,32,1123,'31.01',0),
 (23880,25,1,33,1164,'41.06',0),
 (23881,25,1,34,135,'50.19',0),
 (23882,25,1,35,392,'37.76',0),
 (23883,25,1,36,517,'26.51',0),
 (23884,25,1,37,419,'35.81',0),
 (23885,25,1,38,1240,'32.46',0),
 (23886,25,1,39,36,'37.11',0),
 (23887,25,1,40,3109,'28.92',0),
 (23888,25,1,41,1196,'33.68',0),
 (23889,25,1,42,412,'47.19',0),
 (23890,25,1,43,1574,'39.09',0),
 (23891,25,1,44,1418,'30.90',0),
 (23892,25,1,45,8428,'33.30',0),
 (23893,25,1,46,1343,'37.87',0),
 (23894,25,1,47,9479,'30.44',0),
 (23895,25,1,48,113,'28.18',0),
 (23896,25,1,49,11756,'24.66',0),
 (23897,25,1,50,1063,'35.33',0),
 (23898,25,1,51,448,'36.30',0),
 (23899,25,1,52,1258,'45.42',0),
 (23900,25,1,53,1579,'29.92',0),
 (23901,25,1,54,3026,'35.15',0),
 (23902,25,1,55,313,'46.30',0),
 (23903,25,1,56,230,'35.44',0),
 (23904,25,1,57,387,'34.52',0),
 (23905,25,1,58,24575,'22.86',0),
 (23906,25,1,59,1187,'36.67',0),
 (23907,25,1,60,263,'22.18',0),
 (23908,25,1,61,5814,'34.97',0),
 (23909,25,1,62,98,'40.66',0),
 (23910,25,1,63,72,'37.11',0),
 (23911,25,1,64,57,'54.29',0),
 (23912,25,1,65,25896,'25.65',0),
 (23913,25,1,66,2398,'43.11',0),
 (23914,25,1,67,1074,'33.53',0),
 (23915,25,1,68,3194,'38.41',0),
 (23916,25,1,69,14,'32.56',0),
 (23917,25,1,70,41,'45.05',0),
 (23918,25,1,71,23,'50.00',0),
 (23919,25,1,72,1709,'38.40',0),
 (23920,25,1,73,2610,'27.69',0),
 (23921,25,1,74,27777,'25.32',0),
 (23922,25,1,75,1264,'28.93',0),
 (23923,25,1,76,131,'41.07',0),
 (23924,25,1,78,12,'35.29',0),
 (23925,25,1,79,646348,'35.74',0),
 (23926,25,1,80,18213,'45.99',0),
 (23927,25,1,82,1346,'29.96',0),
 (23928,25,1,83,1974,'29.19',0),
 (23929,25,1,84,3031,'25.37',0),
 (23930,25,1,85,1112,'36.02',0),
 (23931,25,1,86,1264,'35.21',0),
 (23932,25,1,87,1042,'41.15',0),
 (23933,25,1,88,52,'29.05',0),
 (23934,25,1,89,1125,'38.19',0),
 (23935,25,1,90,2248,'33.24',0),
 (23936,25,1,91,1397,'36.72',0),
 (23937,25,1,92,33570,'28.69',0),
 (23938,25,1,93,743,'44.73',0),
 (23939,25,1,94,205,'32.33',0),
 (23940,25,1,95,457,'39.13',0),
 (23941,25,1,96,4542,'33.22',0),
 (23942,25,1,97,16,'19.05',0),
 (23943,25,1,99,569,'44.52',0),
 (23944,25,1,100,1027,'33.64',0),
 (23945,25,1,101,65,'36.11',0),
 (23946,25,1,102,189,'29.08',0),
 (23947,25,1,104,3601,'31.73',0),
 (23948,25,1,106,12451,'22.22',0),
 (23949,25,1,107,85,'26.48',0),
 (23950,25,1,108,749,'29.56',0),
 (23951,25,1,109,514,'46.10',0),
 (23952,25,1,110,620,'40.63',0),
 (23953,25,1,111,178,'36.85',0),
 (23954,25,1,112,51,'38.64',0),
 (23955,25,1,113,6764,'25.13',0),
 (23956,25,1,114,48,'46.15',0),
 (23957,25,1,115,25006,'49.36',0),
 (23958,25,1,116,157,'28.86',0),
 (23959,25,1,117,38,'45.24',0),
 (23960,25,1,118,20,'41.67',0),
 (23961,25,1,119,640,'39.36',0),
 (23962,25,1,120,326,'36.06',0),
 (23963,25,1,121,66,'40.24',0),
 (23964,25,1,122,149,'38.70',0),
 (23965,25,1,123,9139,'19.46',0),
 (23966,25,1,124,21,'38.89',0),
 (23967,25,1,125,905,'41.21',0),
 (23968,25,1,126,15,'60.00',0),
 (23969,25,1,127,22327,'42.11',0),
 (23970,25,1,128,115,'35.94',0),
 (23971,25,1,129,2126,'34.62',0),
 (23972,25,1,130,5294,'23.51',0),
 (23973,25,1,131,3547,'36.22',0),
 (23974,25,1,132,2281,'26.66',0),
 (23975,25,1,133,1631,'38.60',0),
 (23976,25,1,134,14163,'29.99',0),
 (23977,25,1,135,297,'40.41',0),
 (23978,25,1,136,213,'40.04',0),
 (23979,25,1,137,447,'34.81',0),
 (23980,25,1,138,23,'42.59',0),
 (23981,25,1,140,857,'36.34',0),
 (23982,25,1,141,1547,'34.46',0),
 (23983,25,1,143,33,'55.93',0),
 (23984,25,1,144,1926,'40.45',0),
 (23985,25,1,145,498,'27.50',0),
 (23986,25,1,146,519,'41.06',0),
 (23987,25,1,147,256,'34.36',0),
 (23988,25,1,148,18773,'28.79',0),
 (23989,25,1,149,1393,'31.11',0),
 (23990,25,1,150,898,'37.72',0),
 (23991,25,1,151,713,'33.01',0),
 (23992,25,1,152,5597,'42.29',0),
 (23993,25,1,153,110,'21.70',0),
 (23994,25,1,154,1235,'31.47',0),
 (23995,25,1,155,153,'36.43',0),
 (23996,25,1,156,273,'36.69',0),
 (23997,25,1,157,205,'46.38',0),
 (23998,25,1,158,264,'48.62',0),
 (23999,25,1,159,205,'43.80',0),
 (24000,25,1,160,2324,'37.09',0),
 (24001,25,1,161,10652,'28.63',0),
 (24002,25,1,162,763,'37.55',0),
 (24003,25,1,163,111,'31.36',0),
 (24004,25,1,164,879,'38.74',0),
 (24005,25,1,165,654,'49.36',0),
 (24006,25,1,166,84,'32.94',0),
 (24007,25,1,167,1580,'24.07',0),
 (24008,25,1,168,367,'40.78',0),
 (24009,25,1,169,428,'36.96',0),
 (24010,25,1,170,592,'33.94',0),
 (24011,25,1,171,1366,'46.18',0),
 (24012,25,1,172,2559,'35.44',0),
 (24013,25,1,173,157,'38.48',0),
 (24014,25,1,174,522,'41.17',0),
 (24015,25,1,175,269,'38.87',0),
 (24016,25,1,176,4508,'46.19',0),
 (24017,25,1,177,3095,'37.53',0),
 (24018,25,1,178,296,'34.99',0),
 (24019,25,1,179,417,'38.86',0),
 (24020,25,1,180,1348,'33.55',0),
 (24021,25,1,181,7457,'45.00',0),
 (24022,25,1,182,45,'26.47',0),
 (24023,25,1,183,249,'32.59',0),
 (24024,25,1,901,185,'31.68',0),
 (24025,25,1,902,150,'43.23',0),
 (24026,25,1,903,8367,'30.36',0),
 (24027,25,1,999,5280,'26.82',0),
 (24028,26,1,1,30,'66.67',0),
 (24029,26,1,2,910,'43.88',0),
 (24030,26,1,3,51,'36.17',0),
 (24031,26,1,4,1785,'42.84',0),
 (24032,26,1,5,33949,'34.47',0),
 (24033,26,1,6,23888,'40.70',0),
 (24034,26,1,7,33088,'35.38',0),
 (24035,26,1,8,519,'44.21',0),
 (24036,26,1,9,4394,'41.67',0),
 (24037,26,1,10,3231,'42.03',0),
 (24038,26,1,11,136,'43.04',0),
 (24039,26,1,12,286,'43.27',0),
 (24040,26,1,13,10670,'37.45',0),
 (24041,26,1,14,8810,'37.54',0),
 (24042,26,1,15,5133,'36.33',0),
 (24043,26,1,16,19,'37.25',0),
 (24044,26,1,17,333,'37.04',0),
 (24045,26,1,18,1310,'44.48',0),
 (24046,26,1,19,286,'32.32',0),
 (24047,26,1,20,38,'40.43',0),
 (24048,26,1,21,135,'37.09',0),
 (24049,26,1,22,14235,'52.65',0),
 (24050,26,1,23,1507,'40.35',0),
 (24051,26,1,24,66,'53.23',0),
 (24052,26,1,25,182,'57.78',0),
 (24053,26,1,26,2104,'44.76',0),
 (24054,26,1,27,356,'41.54',0),
 (24055,26,1,28,419,'31.18',0),
 (24056,26,1,29,173,'42.61',0),
 (24057,26,1,30,517,'39.80',0),
 (24058,26,1,31,718,'48.32',0),
 (24059,26,1,32,1295,'38.08',0),
 (24060,26,1,33,1290,'46.27',0),
 (24061,26,1,34,147,'54.65',0),
 (24062,26,1,35,395,'39.58',0),
 (24063,26,1,36,630,'33.55',0),
 (24064,26,1,37,468,'40.14',0),
 (24065,26,1,38,1345,'36.47',0),
 (24066,26,1,39,43,'44.33',0),
 (24067,26,1,40,3386,'33.83',0),
 (24068,26,1,41,1380,'39.54',0),
 (24069,26,1,42,436,'49.38',0),
 (24070,26,1,43,1669,'44.40',0),
 (24071,26,1,44,1623,'36.81',0),
 (24072,26,1,45,9359,'38.30',0),
 (24073,26,1,46,1464,'42.78',0),
 (24074,26,1,47,10738,'36.05',0),
 (24075,26,1,48,116,'29.97',0),
 (24076,26,1,49,12947,'28.89',0),
 (24077,26,1,50,1209,'42.59',0),
 (24078,26,1,51,468,'40.73',0),
 (24079,26,1,52,1331,'51.45',0),
 (24080,26,1,53,1794,'36.21',0),
 (24081,26,1,54,3375,'40.80',0),
 (24082,26,1,55,327,'47.60',0),
 (24083,26,1,56,228,'36.95',0),
 (24084,26,1,57,419,'38.51',0),
 (24085,26,1,58,27325,'27.39',0),
 (24086,26,1,59,1339,'42.41',0),
 (24087,26,1,60,290,'25.96',0),
 (24088,26,1,61,6649,'41.21',0),
 (24089,26,1,62,118,'52.21',0),
 (24090,26,1,63,75,'38.86',0),
 (24091,26,1,64,53,'50.00',0),
 (24092,26,1,65,28270,'29.38',0),
 (24093,26,1,66,2734,'50.90',0),
 (24094,26,1,67,1168,'37.93',0),
 (24095,26,1,68,3590,'44.45',0),
 (24096,26,1,69,15,'36.59',0),
 (24097,26,1,70,48,'52.75',0),
 (24098,26,1,71,29,'54.72',0),
 (24099,26,1,72,1846,'42.69',0),
 (24100,26,1,73,2861,'32.88',0),
 (24101,26,1,74,29905,'29.10',0),
 (24102,26,1,75,1443,'34.79',0),
 (24103,26,1,76,139,'43.85',0),
 (24104,26,1,78,14,'43.75',0),
 (24105,26,1,79,696804,'40.20',0),
 (24106,26,1,80,20354,'52.61',0),
 (24107,26,1,82,1442,'33.64',0),
 (24108,26,1,83,2212,'34.85',0),
 (24109,26,1,84,3359,'30.38',0),
 (24110,26,1,85,1167,'39.51',0),
 (24111,26,1,86,1454,'41.63',0),
 (24112,26,1,87,1188,'47.77',0),
 (24113,26,1,88,55,'30.90',0),
 (24114,26,1,89,1187,'43.48',0),
 (24115,26,1,90,2674,'40.46',0),
 (24116,26,1,91,1451,'40.78',0),
 (24117,26,1,92,36419,'33.12',0),
 (24118,26,1,93,820,'49.61',0),
 (24119,26,1,94,222,'35.69',0),
 (24120,26,1,95,485,'43.85',0),
 (24121,26,1,96,5196,'39.35',0),
 (24122,26,1,97,23,'24.47',0),
 (24123,26,1,99,650,'50.66',0),
 (24124,26,1,100,1109,'37.53',0),
 (24125,26,1,101,67,'35.83',0),
 (24126,26,1,102,204,'32.08',0),
 (24127,26,1,104,4232,'38.14',0),
 (24128,26,1,106,13982,'26.75',0),
 (24129,26,1,107,97,'31.09',0),
 (24130,26,1,108,886,'35.94',0),
 (24131,26,1,109,561,'51.09',0),
 (24132,26,1,110,656,'44.84',0),
 (24133,26,1,111,191,'40.90',0),
 (24134,26,1,112,45,'33.09',0),
 (24135,26,1,113,7658,'29.90',0),
 (24136,26,1,114,50,'50.00',0),
 (24137,26,1,115,27523,'55.59',0),
 (24138,26,1,116,187,'35.76',0),
 (24139,26,1,117,38,'42.70',0),
 (24140,26,1,118,20,'44.44',0),
 (24141,26,1,119,725,'45.83',0),
 (24142,26,1,120,353,'39.93',0),
 (24143,26,1,121,77,'48.73',0),
 (24144,26,1,122,161,'43.51',0),
 (24145,26,1,123,10589,'23.54',0),
 (24146,26,1,124,19,'35.19',0),
 (24147,26,1,125,998,'46.14',0),
 (24148,26,1,126,19,'65.52',0),
 (24149,26,1,127,25537,'49.48',0),
 (24150,26,1,128,132,'42.04',0),
 (24151,26,1,129,2445,'41.15',0),
 (24152,26,1,130,5788,'27.51',0),
 (24153,26,1,131,3945,'41.82',0),
 (24154,26,1,132,2554,'31.68',0),
 (24155,26,1,133,1746,'42.61',0),
 (24156,26,1,134,15667,'34.89',0),
 (24157,26,1,135,321,'45.28',0),
 (24158,26,1,136,231,'44.59',0),
 (24159,26,1,137,489,'40.08',0),
 (24160,26,1,138,22,'47.83',0),
 (24161,26,1,140,977,'43.31',0),
 (24162,26,1,141,1739,'40.80',0),
 (24163,26,1,143,34,'59.65',0),
 (24164,26,1,144,2120,'45.65',0),
 (24165,26,1,145,577,'33.24',0),
 (24166,26,1,146,541,'45.31',0),
 (24167,26,1,147,279,'38.75',0),
 (24168,26,1,148,20741,'33.52',0),
 (24169,26,1,149,1546,'35.87',0),
 (24170,26,1,150,1000,'43.92',0),
 (24171,26,1,151,804,'36.56',0),
 (24172,26,1,152,6298,'48.91',0),
 (24173,26,1,153,113,'22.65',0),
 (24174,26,1,154,1448,'38.44',0),
 (24175,26,1,155,160,'38.93',0),
 (24176,26,1,156,309,'41.87',0),
 (24177,26,1,157,233,'54.19',0),
 (24178,26,1,158,281,'52.72',0),
 (24179,26,1,159,217,'46.37',0),
 (24180,26,1,160,2562,'42.28',0),
 (24181,26,1,161,12369,'35.14',0),
 (24182,26,1,162,908,'45.04',0),
 (24183,26,1,163,114,'33.63',0),
 (24184,26,1,164,952,'43.91',0),
 (24185,26,1,165,672,'52.30',0),
 (24186,26,1,166,89,'35.46',0),
 (24187,26,1,167,1763,'28.87',0),
 (24188,26,1,168,386,'43.86',0),
 (24189,26,1,169,479,'43.04',0),
 (24190,26,1,170,625,'38.53',0),
 (24191,26,1,171,1437,'50.96',0),
 (24192,26,1,172,2957,'42.63',0),
 (24193,26,1,173,170,'43.81',0),
 (24194,26,1,174,585,'47.91',0),
 (24195,26,1,175,288,'43.11',0),
 (24196,26,1,176,5240,'54.21',0),
 (24197,26,1,177,3566,'44.41',0),
 (24198,26,1,178,327,'39.98',0),
 (24199,26,1,179,467,'45.03',0),
 (24200,26,1,180,1449,'37.22',0),
 (24201,26,1,181,8307,'51.70',0),
 (24202,26,1,182,57,'33.73',0),
 (24203,26,1,183,265,'36.05',0),
 (24204,26,1,901,186,'33.57',0),
 (24205,26,1,902,165,'46.35',0),
 (24206,26,1,903,9445,'35.08',0),
 (24207,26,1,999,8861,'33.38',0),
 (24208,14,1,1,42,'100.00',0),
 (24209,14,1,2,137,'11.51',0),
 (24210,14,1,3,100,'75.76',0),
 (24211,14,1,4,1601,'57.55',0),
 (24212,14,1,5,31722,'42.76',0),
 (24213,14,1,6,16853,'39.46',0),
 (24214,14,1,7,34516,'45.59',0),
 (24215,14,1,8,325,'34.91',0),
 (24216,14,1,9,2393,'37.71',0),
 (24217,14,1,10,1192,'35.89',0),
 (24218,14,1,11,111,'49.55',0),
 (24219,14,1,12,155,'36.64',0),
 (24220,14,1,13,10289,'47.93',0),
 (24221,14,1,14,7193,'46.98',0),
 (24222,14,1,15,600,'32.12',0),
 (24223,14,1,16,53,'71.62',0),
 (24224,14,1,17,227,'46.80',0),
 (24225,14,1,18,847,'44.25',0),
 (24226,14,1,19,213,'30.96',0),
 (24227,14,1,20,27,'26.21',0),
 (24228,14,1,21,82,'34.45',0),
 (24229,14,1,22,3602,'39.53',0),
 (24230,14,1,23,736,'41.58',0),
 (24231,14,1,24,17,'15.60',0),
 (24232,14,1,25,212,'63.66',0),
 (24233,14,1,26,838,'33.15',0),
 (24234,14,1,27,315,'36.89',0),
 (24235,14,1,28,611,'68.73',0),
 (24236,14,1,29,220,'63.77',0),
 (24237,14,1,30,561,'59.05',0),
 (24238,14,1,31,500,'34.44',0),
 (24239,14,1,32,426,'35.44',0),
 (24240,14,1,33,306,'18.99',0),
 (24241,14,1,34,173,'54.75',0),
 (24242,14,1,35,262,'34.93',0),
 (24243,14,1,36,190,'36.75',0),
 (24244,14,1,37,648,'50.98',0),
 (24245,14,1,38,744,'22.81',0),
 (24246,14,1,39,12,'15.38',0),
 (24247,14,1,40,2629,'47.32',0),
 (24248,14,1,41,378,'26.00',0),
 (24249,14,1,42,322,'61.69',0),
 (24250,14,1,43,786,'23.06',0),
 (24251,14,1,44,968,'42.22',0),
 (24252,14,1,45,7222,'47.77',0),
 (24253,14,1,46,770,'35.91',0),
 (24254,14,1,47,6105,'34.94',0),
 (24255,14,1,48,120,'39.34',0),
 (24256,14,1,49,9663,'28.37',0),
 (24257,14,1,50,265,'29.15',0),
 (24258,14,1,51,76,'9.23',0),
 (24259,14,1,52,1211,'47.71',0),
 (24260,14,1,53,701,'40.80',0),
 (24261,14,1,54,2678,'53.36',0),
 (24262,14,1,55,384,'51.20',0),
 (24263,14,1,56,104,'25.30',0),
 (24264,14,1,57,14,'3.51',0),
 (24265,14,1,58,18706,'25.67',0),
 (24266,14,1,59,815,'41.54',0),
 (24267,14,1,60,218,'21.54',0),
 (24268,14,1,61,3679,'38.34',0),
 (24269,14,1,62,157,'70.09',0),
 (24270,14,1,63,85,'48.30',0),
 (24271,14,1,64,38,'44.71',0),
 (24272,14,1,65,22381,'29.58',0),
 (24273,14,1,66,890,'37.02',0),
 (24274,14,1,67,631,'35.51',0),
 (24275,14,1,68,1839,'40.44',0),
 (24276,14,1,69,42,'91.30',0),
 (24277,14,1,70,54,'45.38',0),
 (24278,14,1,71,49,'85.96',0),
 (24279,14,1,72,1053,'37.27',0),
 (24280,14,1,73,876,'20.99',0),
 (24281,14,1,74,27129,'32.13',0),
 (24282,14,1,75,784,'43.01',0),
 (24283,14,1,76,188,'63.51',0),
 (24284,14,1,78,17,'85.00',0),
 (24285,14,1,79,734921,'49.48',0),
 (24286,14,1,80,10337,'49.20',0),
 (24287,14,1,82,447,'21.02',0),
 (24288,14,1,83,526,'22.65',0),
 (24289,14,1,84,1612,'23.32',0),
 (24290,14,1,85,853,'39.84',0),
 (24291,14,1,86,697,'36.96',0),
 (24292,14,1,87,640,'36.20',0),
 (24293,14,1,88,11,'5.19',0),
 (24294,14,1,89,780,'49.90',0),
 (24295,14,1,90,1247,'50.75',0),
 (24296,14,1,91,1280,'39.75',0),
 (24297,14,1,92,38271,'43.10',0),
 (24298,14,1,93,555,'47.80',0),
 (24299,14,1,94,226,'78.20',0),
 (24300,14,1,95,117,'18.66',0),
 (24301,14,1,96,3709,'54.42',0),
 (24302,14,1,97,5,'5.95',0),
 (24303,14,1,99,150,'14.31',0),
 (24304,14,1,100,360,'26.32',0),
 (24305,14,1,101,37,'32.74',0),
 (24306,14,1,102,112,'21.92',0),
 (24307,14,1,104,900,'29.56',0),
 (24308,14,1,106,10236,'33.66',0),
 (24309,14,1,107,62,'23.66',0),
 (24310,14,1,108,461,'51.97',0),
 (24311,14,1,109,358,'44.81',0),
 (24312,14,1,110,546,'39.37',0),
 (24313,14,1,111,161,'44.23',0),
 (24314,14,1,112,78,'63.93',0),
 (24315,14,1,113,2280,'16.72',0),
 (24316,14,1,114,52,'44.44',0),
 (24317,14,1,115,15031,'48.18',0),
 (24318,14,1,116,54,'32.53',0),
 (24319,14,1,117,66,'94.29',0),
 (24320,14,1,118,5,'7.35',0),
 (24321,14,1,119,160,'22.13',0),
 (24322,14,1,120,208,'20.06',0),
 (24323,14,1,121,50,'39.37',0),
 (24324,14,1,122,139,'56.73',0),
 (24325,14,1,123,3861,'30.22',0),
 (24326,14,1,124,29,'33.33',0),
 (24327,14,1,125,1058,'75.25',0),
 (24328,14,1,126,29,'40.28',0),
 (24329,14,1,127,11866,'49.21',0),
 (24330,14,1,128,113,'40.79',0),
 (24331,14,1,129,1268,'46.31',0),
 (24332,14,1,130,2359,'16.49',0),
 (24333,14,1,131,3172,'53.17',0),
 (24334,14,1,132,2008,'40.70',0),
 (24335,14,1,133,1383,'38.92',0),
 (24336,14,1,134,9952,'37.82',0),
 (24337,14,1,135,247,'46.96',0),
 (24338,14,1,136,326,'80.49',0),
 (24339,14,1,137,397,'49.94',0),
 (24340,14,1,138,49,'54.44',0),
 (24341,14,1,140,178,'29.67',0),
 (24342,14,1,141,694,'42.81',0),
 (24343,14,1,143,29,'32.58',0),
 (24344,14,1,144,1393,'52.81',0),
 (24345,14,1,145,281,'32.15',0),
 (24346,14,1,146,505,'41.06',0),
 (24347,14,1,147,278,'42.90',0),
 (24348,14,1,148,10370,'26.36',0),
 (24349,14,1,149,277,'13.84',0),
 (24350,14,1,150,324,'26.91',0),
 (24351,14,1,151,602,'38.52',0),
 (24352,14,1,152,2876,'45.01',0),
 (24353,14,1,153,72,'26.87',0),
 (24354,14,1,154,1068,'41.38',0),
 (24355,14,1,155,173,'37.61',0),
 (24356,14,1,156,184,'44.34',0),
 (24357,14,1,157,254,'76.97',0),
 (24358,14,1,158,219,'61.86',0),
 (24359,14,1,159,75,'19.58',0),
 (24360,14,1,160,612,'21.63',0),
 (24361,14,1,161,6316,'49.46',0),
 (24362,14,1,162,575,'59.77',0),
 (24363,14,1,163,3,'1.55',0),
 (24364,14,1,164,252,'22.20',0),
 (24365,14,1,165,636,'52.87',0),
 (24366,14,1,166,52,'25.24',0),
 (24367,14,1,167,885,'28.44',0),
 (24368,14,1,168,333,'47.03',0),
 (24369,14,1,169,168,'38.27',0),
 (24370,14,1,170,334,'21.42',0),
 (24371,14,1,171,1314,'52.08',0),
 (24372,14,1,172,414,'16.36',0),
 (24373,14,1,173,248,'60.93',0),
 (24374,14,1,174,496,'52.77',0),
 (24375,14,1,175,156,'67.24',0),
 (24376,14,1,176,3251,'73.34',0),
 (24377,14,1,177,1205,'59.16',0),
 (24378,14,1,178,141,'40.75',0),
 (24379,14,1,179,402,'72.56',0),
 (24380,14,1,180,1083,'31.39',0),
 (24381,14,1,181,5820,'60.41',0),
 (24382,14,1,182,83,'72.17',0),
 (24383,14,1,183,263,'42.49',0),
 (24384,14,1,901,233,'54.06',0),
 (24385,14,1,902,120,'41.52',0),
 (24386,14,1,903,6259,'40.17',0),
 (24387,16,1,1,47,'97.92',0),
 (24388,16,1,2,446,'29.95',0),
 (24389,16,1,3,80,'55.94',0),
 (24390,16,1,4,1269,'36.86',0),
 (24391,16,1,5,42738,'47.34',0),
 (24392,16,1,6,20829,'41.56',0),
 (24393,16,1,7,34221,'38.63',0),
 (24394,16,1,8,310,'27.73',0),
 (24395,16,1,9,3376,'39.82',0),
 (24396,16,1,10,2072,'40.80',0),
 (24397,16,1,11,125,'52.30',0),
 (24398,16,1,12,215,'46.94',0),
 (24399,16,1,13,9602,'39.88',0),
 (24400,16,1,14,8873,'51.51',0),
 (24401,16,1,15,1461,'42.95',0),
 (24402,16,1,16,35,'41.67',0),
 (24403,16,1,17,297,'40.91',0),
 (24404,16,1,18,1060,'46.90',0),
 (24405,16,1,19,292,'37.97',0),
 (24406,16,1,20,7,'6.09',0),
 (24407,16,1,21,201,'67.00',0),
 (24408,16,1,22,8636,'51.96',0),
 (24409,16,1,23,836,'34.16',0),
 (24410,16,1,24,34,'31.78',0),
 (24411,16,1,25,248,'69.66',0),
 (24412,16,1,26,1544,'44.48',0),
 (24413,16,1,27,437,'49.38',0),
 (24414,16,1,28,109,'10.50',0),
 (24415,16,1,29,237,'59.85',0),
 (24416,16,1,30,366,'31.52',0),
 (24417,16,1,31,697,'43.95',0),
 (24418,16,1,32,512,'28.04',0),
 (24419,16,1,33,830,'44.01',0),
 (24420,16,1,34,225,'63.56',0),
 (24421,16,1,35,313,'38.08',0),
 (24422,16,1,36,206,'20.58',0),
 (24423,16,1,37,671,'50.60',0),
 (24424,16,1,38,1093,'31.11',0),
 (24425,16,1,39,30,'29.41',0),
 (24426,16,1,40,1783,'23.41',0),
 (24427,16,1,41,332,'17.59',0),
 (24428,16,1,42,365,'60.93',0),
 (24429,16,1,43,505,'13.83',0),
 (24430,16,1,44,1178,'36.88',0),
 (24431,16,1,45,8907,'46.44',0),
 (24432,16,1,46,790,'30.48',0),
 (24433,16,1,47,6191,'27.19',0),
 (24434,16,1,48,121,'37.00',0),
 (24435,16,1,49,11857,'28.30',0),
 (24436,16,1,50,783,'58.56',0),
 (24437,16,1,51,218,'22.20',0),
 (24438,16,1,52,1082,'39.97',0),
 (24439,16,1,53,1192,'41.56',0),
 (24440,16,1,54,2755,'43.42',0),
 (24441,16,1,55,379,'51.01',0),
 (24442,16,1,56,230,'44.15',0),
 (24443,16,1,57,60,'9.42',0),
 (24444,16,1,58,25011,'28.44',0),
 (24445,16,1,59,1121,'42.74',0),
 (24446,16,1,60,159,'15.29',0),
 (24447,16,1,61,5555,'44.84',0),
 (24448,16,1,62,184,'75.41',0),
 (24449,16,1,63,88,'45.36',0),
 (24450,16,1,64,2,'1.83',0),
 (24451,16,1,65,29048,'33.66',0),
 (24452,16,1,66,1544,'42.88',0),
 (24453,16,1,67,964,'43.48',0),
 (24454,16,1,68,3145,'52.34',0),
 (24455,16,1,69,59,'76.62',0),
 (24456,16,1,70,27,'25.00',0),
 (24457,16,1,71,54,'75.00',0),
 (24458,16,1,72,1451,'41.64',0),
 (24459,16,1,73,1455,'26.13',0),
 (24460,16,1,74,35637,'37.34',0),
 (24461,16,1,75,828,'37.84',0),
 (24462,16,1,76,126,'37.39',0),
 (24463,16,1,78,19,'76.00',0),
 (24464,16,1,79,874264,'51.30',0),
 (24465,16,1,80,14846,'52.01',0),
 (24466,16,1,82,933,'33.83',0),
 (24467,16,1,83,1354,'33.74',0),
 (24468,16,1,84,2035,'24.41',0),
 (24469,16,1,85,969,'40.27',0),
 (24470,16,1,86,857,'38.80',0),
 (24471,16,1,87,843,'38.99',0),
 (24472,16,1,88,8,'3.36',0),
 (24473,16,1,89,1213,'58.57',0),
 (24474,16,1,90,1911,'44.65',0),
 (24475,16,1,91,1449,'43.84',0),
 (24476,16,1,92,46915,'45.77',0),
 (24477,16,1,93,801,'60.14',0),
 (24478,16,1,94,139,'34.66',0),
 (24479,16,1,95,240,'28.07',0),
 (24480,16,1,96,4473,'56.58',0),
 (24481,16,1,97,5,'4.50',0),
 (24482,16,1,99,43,'3.62',0),
 (24483,16,1,100,431,'22.64',0),
 (24484,16,1,101,26,'22.41',0),
 (24485,16,1,102,100,'18.66',0),
 (24486,16,1,104,1012,'27.18',0),
 (24487,16,1,106,6193,'15.49',0),
 (24488,16,1,107,77,'27.90',0),
 (24489,16,1,108,654,'56.38',0),
 (24490,16,1,109,478,'50.21',0),
 (24491,16,1,110,671,'45.90',0);
INSERT INTO `elecmunicandi` (`idElecMuniCandi`,`Convocatoria_idConvocatoria`,`Candidatura_idCandidatura`,`Municipio`,`Votos`,`PorcVotos`,`Concejales`) VALUES 
 (24492,16,1,111,181,'48.14',0),
 (24493,16,1,112,56,'44.44',0),
 (24494,16,1,113,3709,'21.36',0),
 (24495,16,1,114,71,'52.21',0),
 (24496,16,1,115,22331,'56.94',0),
 (24497,16,1,116,76,'43.93',0),
 (24498,16,1,117,4,'5.13',0),
 (24499,16,1,118,3,'3.61',0),
 (24500,16,1,119,294,'30.37',0),
 (24501,16,1,120,319,'31.18',0),
 (24502,16,1,121,8,'4.62',0),
 (24503,16,1,122,142,'55.04',0),
 (24504,16,1,123,5481,'26.31',0),
 (24505,16,1,124,18,'18.37',0),
 (24506,16,1,125,1105,'66.81',0),
 (24507,16,1,126,18,'26.87',0),
 (24508,16,1,127,18285,'50.85',0),
 (24509,16,1,128,131,'48.52',0),
 (24510,16,1,129,1175,'33.13',0),
 (24511,16,1,130,4346,'23.54',0),
 (24512,16,1,131,3512,'46.68',0),
 (24513,16,1,132,2845,'46.34',0),
 (24514,16,1,133,1467,'38.29',0),
 (24515,16,1,134,12562,'40.00',0),
 (24516,16,1,135,301,'48.86',0),
 (24517,16,1,136,146,'33.95',0),
 (24518,16,1,137,482,'56.18',0),
 (24519,16,1,138,58,'54.72',0),
 (24520,16,1,140,650,'53.72',0),
 (24521,16,1,141,610,'24.59',0),
 (24522,16,1,143,25,'27.17',0),
 (24523,16,1,144,1364,'38.47',0),
 (24524,16,1,145,120,'13.35',0),
 (24525,16,1,146,765,'65.11',0),
 (24526,16,1,147,283,'47.32',0),
 (24527,16,1,148,15008,'30.77',0),
 (24528,16,1,149,996,'38.22',0),
 (24529,16,1,150,696,'40.85',0),
 (24530,16,1,151,593,'31.69',0),
 (24531,16,1,152,4142,'46.26',0),
 (24532,16,1,153,80,'25.81',0),
 (24533,16,1,154,1123,'36.83',0),
 (24534,16,1,155,178,'39.73',0),
 (24535,16,1,156,143,'29.73',0),
 (24536,16,1,157,152,'35.60',0),
 (24537,16,1,158,161,'36.93',0),
 (24538,16,1,159,144,'31.79',0),
 (24539,16,1,160,1644,'41.05',0),
 (24540,16,1,161,10874,'57.90',0),
 (24541,16,1,162,605,'52.88',0),
 (24542,16,1,163,0,'0.00',0),
 (24543,16,1,164,334,'23.18',0),
 (24544,16,1,165,626,'49.72',0),
 (24545,16,1,166,14,'5.83',0),
 (24546,16,1,167,1620,'35.60',0),
 (24547,16,1,168,182,'24.73',0),
 (24548,16,1,169,121,'20.20',0),
 (24549,16,1,170,211,'12.54',0),
 (24550,16,1,171,1493,'55.79',0),
 (24551,16,1,172,863,'24.13',0),
 (24552,16,1,173,282,'72.68',0),
 (24553,16,1,174,457,'41.66',0),
 (24554,16,1,175,171,'59.58',0),
 (24555,16,1,176,3909,'66.66',0),
 (24556,16,1,177,2006,'51.62',0),
 (24557,16,1,178,117,'18.87',0),
 (24558,16,1,179,451,'57.38',0),
 (24559,16,1,180,1491,'41.37',0),
 (24560,16,1,181,6105,'46.82',0),
 (24561,16,1,182,2,'1.43',0),
 (24562,16,1,183,204,'31.24',0),
 (24563,16,1,901,233,'47.84',0),
 (24564,16,1,902,148,'44.71',0),
 (24565,16,1,903,5948,'29.42',0),
 (24566,18,1,1,44,'93.62',0),
 (24567,18,1,2,743,'44.57',0),
 (24568,18,1,3,63,'37.72',0),
 (24569,18,1,4,1547,'42.43',0),
 (24570,18,1,5,42356,'48.83',0),
 (24571,18,1,6,24892,'49.89',0),
 (24572,18,1,7,35567,'42.17',0),
 (24573,18,1,8,116,'9.06',0),
 (24574,18,1,9,4820,'53.91',0),
 (24575,18,1,10,2875,'46.87',0),
 (24576,18,1,11,186,'61.18',0),
 (24577,18,1,12,332,'55.70',0),
 (24578,18,1,13,9012,'37.95',0),
 (24579,18,1,14,10775,'55.51',0),
 (24580,18,1,15,3275,'64.33',0),
 (24581,18,1,16,37,'46.25',0),
 (24582,18,1,17,341,'42.41',0),
 (24583,18,1,18,1336,'56.30',0),
 (24584,18,1,19,341,'41.43',0),
 (24585,18,1,20,86,'26.22',0),
 (24586,18,1,21,181,'55.18',0),
 (24587,18,1,22,12551,'63.72',0),
 (24588,18,1,23,1200,'42.24',0),
 (24589,18,1,24,52,'47.71',0),
 (24590,18,1,25,223,'61.26',0),
 (24591,18,1,26,1941,'48.08',0),
 (24592,18,1,27,438,'47.00',0),
 (24593,18,1,28,465,'42.82',0),
 (24594,18,1,29,293,'64.40',0),
 (24595,18,1,30,495,'40.51',0),
 (24596,18,1,31,634,'39.87',0),
 (24597,18,1,32,932,'34.78',0),
 (24598,18,1,33,1084,'48.68',0),
 (24599,18,1,34,244,'79.22',0),
 (24600,18,1,35,411,'42.63',0),
 (24601,18,1,36,421,'25.38',0),
 (24602,18,1,37,723,'55.32',0),
 (24603,18,1,38,913,'25.40',0),
 (24604,18,1,39,32,'34.78',0),
 (24605,18,1,40,2711,'34.97',0),
 (24606,18,1,41,545,'24.47',0),
 (24607,18,1,42,336,'47.19',0),
 (24608,18,1,43,2432,'63.98',0),
 (24609,18,1,44,923,'25.85',0),
 (24610,18,1,45,9266,'48.75',0),
 (24611,18,1,46,1535,'54.09',0),
 (24612,18,1,47,7362,'31.27',0),
 (24613,18,1,48,177,'48.49',0),
 (24614,18,1,49,16617,'40.24',0),
 (24615,18,1,50,1203,'63.75',0),
 (24616,18,1,51,247,'21.37',0),
 (24617,18,1,52,1381,'51.90',0),
 (24618,18,1,53,1477,'36.21',0),
 (24619,18,1,54,3600,'51.55',0),
 (24620,18,1,55,456,'49.73',0),
 (24621,18,1,56,321,'54.97',0),
 (24622,18,1,57,77,'7.15',0),
 (24623,18,1,58,25880,'31.37',0),
 (24624,18,1,59,1031,'35.79',0),
 (24625,18,1,60,320,'26.94',0),
 (24626,18,1,61,4868,'38.40',0),
 (24627,18,1,62,196,'74.52',0),
 (24628,18,1,63,73,'30.04',0),
 (24629,18,1,64,44,'41.51',0),
 (24630,18,1,65,29016,'36.36',0),
 (24631,18,1,66,2825,'62.83',0),
 (24632,18,1,67,1431,'51.59',0),
 (24633,18,1,68,3840,'58.85',0),
 (24634,18,1,69,50,'89.29',0),
 (24635,18,1,70,28,'27.72',0),
 (24636,18,1,71,39,'65.00',0),
 (24637,18,1,72,861,'23.16',0),
 (24638,18,1,73,2523,'34.28',0),
 (24639,18,1,74,36283,'39.41',0),
 (24640,18,1,75,1211,'41.85',0),
 (24641,18,1,76,155,'44.41',0),
 (24642,18,1,78,22,'75.86',0),
 (24643,18,1,79,877544,'55.65',0),
 (24644,18,1,80,18555,'59.18',0),
 (24645,18,1,82,751,'22.63',0),
 (24646,18,1,83,2345,'52.05',0),
 (24647,18,1,84,3123,'34.30',0),
 (24648,18,1,85,1510,'54.47',0),
 (24649,18,1,86,1308,'48.93',0),
 (24650,18,1,87,931,'41.27',0),
 (24651,18,1,88,6,'2.61',0),
 (24652,18,1,89,1559,'62.81',0),
 (24653,18,1,90,2709,'51.25',0),
 (24654,18,1,91,1329,'41.79',0),
 (24655,18,1,92,53350,'54.09',0),
 (24656,18,1,93,690,'48.66',0),
 (24657,18,1,94,192,'40.42',0),
 (24658,18,1,95,194,'20.17',0),
 (24659,18,1,96,5620,'64.29',0),
 (24660,18,1,97,1,'0.93',0),
 (24661,18,1,99,460,'38.92',0),
 (24662,18,1,100,649,'27.28',0),
 (24663,18,1,101,38,'21.11',0),
 (24664,18,1,102,272,'40.48',0),
 (24665,18,1,104,1267,'28.97',0),
 (24666,18,1,106,6534,'16.61',0),
 (24667,18,1,107,90,'25.86',0),
 (24668,18,1,108,896,'55.04',0),
 (24669,18,1,109,583,'56.60',0),
 (24670,18,1,110,859,'54.51',0),
 (24671,18,1,111,223,'48.69',0),
 (24672,18,1,112,67,'47.86',0),
 (24673,18,1,113,7915,'40.94',0),
 (24674,18,1,114,61,'42.96',0),
 (24675,18,1,115,27455,'67.18',0),
 (24676,18,1,116,47,'16.91',0),
 (24677,18,1,117,49,'50.52',0),
 (24678,18,1,118,1,'1.30',0),
 (24679,18,1,119,691,'51.95',0),
 (24680,18,1,120,425,'42.08',0),
 (24681,18,1,121,8,'4.91',0),
 (24682,18,1,122,217,'61.30',0),
 (24683,18,1,123,6891,'23.90',0),
 (24684,18,1,124,14,'17.28',0),
 (24685,18,1,125,1280,'65.47',0),
 (24686,18,1,126,18,'36.73',0),
 (24687,18,1,127,23827,'59.70',0),
 (24688,18,1,128,88,'31.88',0),
 (24689,18,1,129,1950,'46.65',0),
 (24690,18,1,130,6186,'33.80',0),
 (24691,18,1,131,4071,'50.98',0),
 (24692,18,1,132,3524,'52.39',0),
 (24693,18,1,133,1291,'32.02',0),
 (24694,18,1,134,16075,'48.97',0),
 (24695,18,1,135,400,'56.50',0),
 (24696,18,1,136,268,'52.45',0),
 (24697,18,1,137,426,'39.23',0),
 (24698,18,1,138,52,'66.67',0),
 (24699,18,1,140,1045,'60.93',0),
 (24700,18,1,141,1651,'50.43',0),
 (24701,18,1,143,17,'21.25',0),
 (24702,18,1,144,2077,'50.18',0),
 (24703,18,1,145,412,'35.86',0),
 (24704,18,1,146,658,'55.39',0),
 (24705,18,1,147,462,'71.41',0),
 (24706,18,1,148,21157,'43.27',0),
 (24707,18,1,149,831,'26.17',0),
 (24708,18,1,150,1225,'57.89',0),
 (24709,18,1,151,466,'22.87',0),
 (24710,18,1,152,4485,'44.04',0),
 (24711,18,1,153,35,'8.37',0),
 (24712,18,1,154,1365,'39.27',0),
 (24713,18,1,155,215,'47.88',0),
 (24714,18,1,156,222,'40.36',0),
 (24715,18,1,157,277,'61.01',0),
 (24716,18,1,158,182,'34.08',0),
 (24717,18,1,159,76,'13.97',0),
 (24718,18,1,160,2244,'45.63',0),
 (24719,18,1,161,14002,'59.32',0),
 (24720,18,1,162,955,'66.92',0),
 (24721,18,1,163,0,'0.00',0),
 (24722,18,1,164,724,'37.53',0),
 (24723,18,1,165,545,'41.13',0),
 (24724,18,1,166,84,'29.17',0),
 (24725,18,1,167,1867,'39.45',0),
 (24726,18,1,168,234,'30.83',0),
 (24727,18,1,169,318,'34.91',0),
 (24728,18,1,170,312,'17.52',0),
 (24729,18,1,171,1669,'54.72',0),
 (24730,18,1,172,1382,'34.27',0),
 (24731,18,1,173,185,'46.84',0),
 (24732,18,1,174,391,'31.21',0),
 (24733,18,1,175,240,'58.11',0),
 (24734,18,1,176,4941,'70.33',0),
 (24735,18,1,177,3405,'53.64',0),
 (24736,18,1,178,145,'19.57',0),
 (24737,18,1,179,519,'64.31',0),
 (24738,18,1,180,1684,'45.35',0),
 (24739,18,1,181,6972,'49.89',0),
 (24740,18,1,182,7,'3.89',0),
 (24741,18,1,183,312,'45.02',0),
 (24742,18,1,901,291,'55.11',0),
 (24743,18,1,902,157,'44.10',0),
 (24744,18,1,903,8894,'42.80',0),
 (25103,11,2,1,11,'36.67',0),
 (25104,11,2,2,192,'26.05',0),
 (25105,11,2,3,21,'22.11',0),
 (25106,11,2,4,667,'37.58',0),
 (25107,11,2,5,18433,'26.60',0),
 (25108,11,2,6,8456,'23.64',0),
 (25109,11,2,7,16539,'25.90',0),
 (25110,11,2,8,179,'29.98',0),
 (25111,11,2,9,949,'20.14',0),
 (25112,11,2,10,493,'25.46',0),
 (25113,11,2,11,42,'23.46',0),
 (25114,11,2,12,92,'28.93',0),
 (25115,11,2,13,4944,'27.84',0),
 (25116,11,2,14,3290,'30.08',0),
 (25117,11,2,15,191,'26.09',0),
 (25118,11,2,16,21,'35.00',0),
 (25119,11,2,17,100,'37.74',0),
 (25120,11,2,18,397,'33.14',0),
 (25121,11,2,19,266,'43.89',0),
 (25122,11,2,20,17,'32.69',0),
 (25123,11,2,21,33,'20.12',0),
 (25124,11,2,22,1074,'12.97',0),
 (25125,11,2,23,261,'25.94',0),
 (25126,11,2,24,8,'11.43',0),
 (25127,11,2,25,89,'29.67',0),
 (25128,11,2,26,276,'19.83',0),
 (25129,11,2,27,197,'30.69',0),
 (25130,11,2,28,136,'20.73',0),
 (25131,11,2,29,62,'27.19',0),
 (25132,11,2,30,143,'25.13',0),
 (25133,11,2,31,515,'47.07',0),
 (25134,11,2,32,245,'31.29',0),
 (25135,11,2,33,368,'32.34',0),
 (25136,11,2,34,93,'34.32',0),
 (25137,11,2,35,292,'41.36',0),
 (25138,11,2,36,58,'20.07',0),
 (25139,11,2,37,538,'51.43',0),
 (25140,11,2,38,855,'36.81',0),
 (25141,11,2,39,20,'40.82',0),
 (25142,11,2,40,1562,'37.76',0),
 (25143,11,2,41,227,'32.34',0),
 (25144,11,2,42,52,'15.95',0),
 (25145,11,2,43,955,'46.54',0),
 (25146,11,2,44,403,'28.70',0),
 (25147,11,2,45,3238,'27.35',0),
 (25148,11,2,46,344,'23.79',0),
 (25149,11,2,47,3388,'25.76',0),
 (25150,11,2,48,95,'38.78',0),
 (25151,11,2,49,7446,'27.56',0),
 (25152,11,2,50,103,'20.20',0),
 (25153,11,2,51,154,'28.52',0),
 (25154,11,2,52,577,'29.08',0),
 (25155,11,2,53,237,'29.51',0),
 (25156,11,2,54,1017,'27.75',0),
 (25157,11,2,55,262,'39.16',0),
 (25158,11,2,56,29,'12.61',0),
 (25159,11,2,57,40,'19.70',0),
 (25160,11,2,58,15191,'29.69',0),
 (25161,11,2,59,366,'27.58',0),
 (25162,11,2,60,399,'51.62',0),
 (25163,11,2,61,1370,'23.22',0),
 (25164,11,2,62,46,'26.14',0),
 (25165,11,2,63,29,'22.66',0),
 (25166,11,2,64,21,'29.58',0),
 (25167,11,2,65,18356,'27.87',0),
 (25168,11,2,66,187,'12.83',0),
 (25169,11,2,67,438,'37.06',0),
 (25170,11,2,68,941,'28.22',0),
 (25171,11,2,69,1,'3.03',0),
 (25172,11,2,70,8,'10.13',0),
 (25173,11,2,71,11,'26.83',0),
 (25174,11,2,72,344,'16.83',0),
 (25175,11,2,73,760,'29.54',0),
 (25176,11,2,74,22926,'30.18',0),
 (25177,11,2,75,515,'39.83',0),
 (25178,11,2,76,90,'34.75',0),
 (25179,11,2,78,1,'4.55',0),
 (25180,11,2,79,341307,'22.43',0),
 (25181,11,2,80,2607,'14.80',0),
 (25182,11,2,82,309,'22.87',0),
 (25183,11,2,83,353,'29.97',0),
 (25184,11,2,84,1360,'26.80',0),
 (25185,11,2,85,545,'35.71',0),
 (25186,11,2,86,421,'30.57',0),
 (25187,11,2,87,371,'27.87',0),
 (25188,11,2,88,51,'32.28',0),
 (25189,11,2,89,204,'25.31',0),
 (25190,11,2,90,335,'25.77',0),
 (25191,11,2,91,798,'34.85',0),
 (25192,11,2,92,19311,'26.07',0),
 (25193,11,2,93,222,'25.26',0),
 (25194,11,2,94,24,'12.70',0),
 (25195,11,2,95,115,'29.79',0),
 (25196,11,2,96,1416,'29.77',0),
 (25197,11,2,97,34,'47.22',0),
 (25198,11,2,99,141,'23.50',0),
 (25199,11,2,100,110,'16.64',0),
 (25200,11,2,101,13,'16.25',0),
 (25201,11,2,102,243,'55.73',0),
 (25202,11,2,104,573,'24.28',0),
 (25203,11,2,106,7753,'30.84',0),
 (25204,11,2,107,74,'50.00',0),
 (25205,11,2,108,138,'27.38',0),
 (25206,11,2,109,93,'22.09',0),
 (25207,11,2,110,476,'41.46',0),
 (25208,11,2,111,95,'31.05',0),
 (25209,11,2,112,45,'43.69',0),
 (25210,11,2,113,2769,'29.84',0),
 (25211,11,2,114,21,'24.42',0),
 (25212,11,2,115,4091,'14.78',0),
 (25213,11,2,116,55,'43.31',0),
 (25214,11,2,117,20,'29.85',0),
 (25215,11,2,118,13,'30.23',0),
 (25216,11,2,119,113,'26.40',0),
 (25217,11,2,120,270,'36.54',0),
 (25218,11,2,121,31,'40.79',0),
 (25219,11,2,122,48,'31.79',0),
 (25220,11,2,123,2022,'25.52',0),
 (25221,11,2,124,5,'9.09',0),
 (25222,11,2,125,267,'27.55',0),
 (25223,11,2,126,32,'49.23',0),
 (25224,11,2,127,3241,'16.19',0),
 (25225,11,2,128,77,'36.84',0),
 (25226,11,2,129,389,'22.94',0),
 (25227,11,2,130,3070,'28.76',0),
 (25228,11,2,131,1256,'26.98',0),
 (25229,11,2,132,1327,'38.84',0),
 (25230,11,2,133,1078,'39.09',0),
 (25231,11,2,134,5878,'26.22',0),
 (25232,11,2,135,93,'31.85',0),
 (25233,11,2,136,101,'30.89',0),
 (25234,11,2,137,218,'36.58',0),
 (25235,11,2,138,3,'6.67',0),
 (25236,11,2,140,61,'19.93',0),
 (25237,11,2,141,167,'19.74',0),
 (25238,11,2,143,15,'19.74',0),
 (25239,11,2,144,267,'16.89',0),
 (25240,11,2,145,232,'37.00',0),
 (25241,11,2,146,388,'41.06',0),
 (25242,11,2,147,191,'44.01',0),
 (25243,11,2,148,9107,'27.43',0),
 (25244,11,2,149,199,'22.72',0),
 (25245,11,2,150,210,'25.24',0),
 (25246,11,2,151,451,'35.57',0),
 (25247,11,2,152,680,'16.28',0),
 (25248,11,2,153,39,'29.77',0),
 (25249,11,2,154,722,'42.37',0),
 (25250,11,2,155,256,'57.79',0),
 (25251,11,2,156,89,'31.01',0),
 (25252,11,2,157,70,'25.09',0),
 (25253,11,2,158,31,'15.74',0),
 (25254,11,2,159,81,'39.13',0),
 (25255,11,2,160,394,'27.32',0),
 (25256,11,2,161,1997,'24.99',0),
 (25257,11,2,162,140,'20.99',0),
 (25258,11,2,163,58,'30.85',0),
 (25259,11,2,164,228,'30.65',0),
 (25260,11,2,165,310,'34.29',0),
 (25261,11,2,166,57,'35.85',0),
 (25262,11,2,167,521,'33.74',0),
 (25263,11,2,168,182,'34.93',0),
 (25264,11,2,169,49,'18.99',0),
 (25265,11,2,170,320,'27.10',0),
 (25266,11,2,171,494,'31.59',0),
 (25267,11,2,172,280,'22.19',0),
 (25268,11,2,173,168,'49.41',0),
 (25269,11,2,174,169,'27.17',0),
 (25270,11,2,175,49,'23.11',0),
 (25271,11,2,176,272,'10.18',0),
 (25272,11,2,177,366,'38.61',0),
 (25273,11,2,178,80,'38.65',0),
 (25274,11,2,179,108,'27.55',0),
 (25275,11,2,180,1094,'41.35',0),
 (25276,11,2,181,1228,'16.41',0),
 (25277,11,2,182,35,'37.23',0),
 (25278,11,2,183,123,'29.22',0),
 (25279,11,2,901,122,'36.31',0),
 (25280,11,2,902,62,'31.63',0),
 (25281,11,2,903,1528,'15.45',0),
 (25282,13,2,1,7,'16.67',0),
 (25283,13,2,2,425,'36.20',0),
 (25284,13,2,3,37,'28.68',0),
 (25285,13,2,4,977,'34.96',0),
 (25286,13,2,5,29916,'40.29',0),
 (25287,13,2,6,16644,'39.14',0),
 (25288,13,2,7,29140,'38.52',0),
 (25289,13,2,8,333,'35.54',0),
 (25290,13,2,9,2382,'36.99',0),
 (25291,13,2,10,1141,'34.60',0),
 (25292,13,2,11,42,'18.83',0),
 (25293,13,2,12,181,'41.61',0),
 (25294,13,2,13,8793,'40.79',0),
 (25295,13,2,14,6509,'42.42',0),
 (25296,13,2,15,655,'35.06',0),
 (25297,13,2,16,20,'27.40',0),
 (25298,13,2,17,175,'36.08',0),
 (25299,13,2,18,695,'36.48',0),
 (25300,13,2,19,337,'48.01',0),
 (25301,13,2,20,29,'29.29',0),
 (25302,13,2,21,43,'18.61',0),
 (25303,13,2,22,2231,'24.24',0),
 (25304,13,2,23,570,'32.19',0),
 (25305,13,2,24,19,'17.92',0),
 (25306,13,2,25,81,'23.55',0),
 (25307,13,2,26,710,'27.94',0),
 (25308,13,2,27,277,'32.40',0),
 (25309,13,2,28,232,'25.98',0),
 (25310,13,2,29,98,'29.08',0),
 (25311,13,2,30,305,'31.80',0),
 (25312,13,2,31,757,'51.15',0),
 (25313,13,2,32,572,'43.97',0),
 (25314,13,2,33,618,'38.92',0),
 (25315,13,2,34,89,'27.22',0),
 (25316,13,2,35,316,'40.77',0),
 (25317,13,2,36,82,'16.14',0),
 (25318,13,2,37,635,'49.61',0),
 (25319,13,2,38,1358,'41.31',0),
 (25320,13,2,39,37,'48.05',0),
 (25321,13,2,40,2332,'41.74',0),
 (25322,13,2,41,566,'39.31',0),
 (25323,13,2,42,140,'26.67',0),
 (25324,13,2,43,1529,'45.66',0),
 (25325,13,2,44,854,'37.36',0),
 (25326,13,2,45,5469,'36.12',0),
 (25327,13,2,46,727,'34.04',0),
 (25328,13,2,47,7208,'41.02',0),
 (25329,13,2,48,150,'49.18',0),
 (25330,13,2,49,15296,'44.31',0),
 (25331,13,2,50,274,'30.86',0),
 (25332,13,2,51,248,'31.12',0),
 (25333,13,2,52,824,'32.24',0),
 (25334,13,2,53,668,'38.70',0),
 (25335,13,2,54,1642,'32.69',0),
 (25336,13,2,55,306,'40.80',0),
 (25337,13,2,56,119,'30.13',0),
 (25338,13,2,57,119,'30.51',0),
 (25339,13,2,58,37757,'51.99',0),
 (25340,13,2,59,707,'36.20',0),
 (25341,13,2,60,586,'57.56',0),
 (25342,13,2,61,3402,'35.26',0),
 (25343,13,2,62,62,'29.25',0),
 (25344,13,2,63,39,'25.32',0),
 (25345,13,2,64,22,'26.51',0),
 (25346,13,2,65,34877,'45.92',0),
 (25347,13,2,66,585,'24.43',0),
 (25348,13,2,67,731,'41.11',0),
 (25349,13,2,68,1710,'37.58',0),
 (25350,13,2,69,8,'18.60',0),
 (25351,13,2,70,20,'16.95',0),
 (25352,13,2,71,18,'29.03',0),
 (25353,13,2,72,775,'27.68',0),
 (25354,13,2,73,1954,'47.07',0),
 (25355,13,2,74,39146,'46.37',0),
 (25356,13,2,75,747,'40.82',0),
 (25357,13,2,76,113,'34.98',0),
 (25358,13,2,78,7,'31.82',0),
 (25359,13,2,79,510396,'34.49',0),
 (25360,13,2,80,5685,'26.75',0),
 (25361,13,2,82,596,'28.13',0),
 (25362,13,2,83,890,'38.38',0),
 (25363,13,2,84,2836,'41.19',0),
 (25364,13,2,85,954,'44.27',0),
 (25365,13,2,86,629,'33.71',0),
 (25366,13,2,87,572,'31.17',0),
 (25367,13,2,88,97,'47.09',0),
 (25368,13,2,89,567,'36.11',0),
 (25369,13,2,90,822,'33.67',0),
 (25370,13,2,91,1436,'44.74',0),
 (25371,13,2,92,36137,'40.58',0),
 (25372,13,2,93,373,'32.16',0),
 (25373,13,2,94,65,'22.34',0),
 (25374,13,2,95,205,'32.49',0),
 (25375,13,2,96,2425,'38.16',0),
 (25376,13,2,97,43,'52.44',0),
 (25377,13,2,99,255,'26.05',0),
 (25378,13,2,100,427,'31.12',0),
 (25379,13,2,101,24,'23.53',0),
 (25380,13,2,102,286,'55.43',0),
 (25381,13,2,104,939,'31.00',0),
 (25382,13,2,106,13455,'44.96',0),
 (25383,13,2,107,138,'53.08',0),
 (25384,13,2,108,262,'29.64',0),
 (25385,13,2,109,209,'26.83',0),
 (25386,13,2,110,640,'45.68',0),
 (25387,13,2,111,118,'32.96',0),
 (25388,13,2,112,40,'32.00',0),
 (25389,13,2,113,6388,'47.12',0),
 (25390,13,2,114,34,'31.78',0),
 (25391,13,2,115,7946,'25.29',0),
 (25392,13,2,116,88,'50.87',0),
 (25393,13,2,117,12,'16.44',0),
 (25394,13,2,118,25,'39.06',0),
 (25395,13,2,119,183,'26.03',0),
 (25396,13,2,120,437,'42.59',0),
 (25397,13,2,121,63,'49.22',0),
 (25398,13,2,122,82,'34.89',0),
 (25399,13,2,123,5630,'44.12',0),
 (25400,13,2,124,13,'15.85',0),
 (25401,13,2,125,306,'21.63',0),
 (25402,13,2,126,38,'52.05',0),
 (25403,13,2,127,6947,'28.57',0),
 (25404,13,2,128,103,'36.65',0),
 (25405,13,2,129,918,'33.77',0),
 (25406,13,2,130,5918,'41.17',0),
 (25407,13,2,131,2010,'33.48',0),
 (25408,13,2,132,2203,'44.72',0),
 (25409,13,2,133,1579,'44.35',0),
 (25410,13,2,134,10601,'40.09',0),
 (25411,13,2,135,137,'26.76',0),
 (25412,13,2,136,122,'30.27',0),
 (25413,13,2,137,348,'44.22',0),
 (25414,13,2,138,12,'14.12',0),
 (25415,13,2,140,164,'27.11',0),
 (25416,13,2,141,519,'32.56',0),
 (25417,13,2,143,29,'33.72',0),
 (25418,13,2,144,688,'26.12',0),
 (25419,13,2,145,348,'40.23',0),
 (25420,13,2,146,467,'38.12',0),
 (25421,13,2,147,231,'37.08',0),
 (25422,13,2,148,15707,'40.02',0),
 (25423,13,2,149,653,'33.15',0),
 (25424,13,2,150,369,'31.24',0),
 (25425,13,2,151,627,'39.24',0),
 (25426,13,2,152,1635,'25.64',0),
 (25427,13,2,153,92,'35.38',0),
 (25428,13,2,154,1180,'45.61',0),
 (25429,13,2,155,256,'55.41',0),
 (25430,13,2,156,172,'41.05',0),
 (25431,13,2,157,94,'27.73',0),
 (25432,13,2,158,57,'16.52',0),
 (25433,13,2,159,174,'45.67',0),
 (25434,13,2,160,988,'35.14',0),
 (25435,13,2,161,4745,'36.94',0),
 (25436,13,2,162,278,'29.14',0),
 (25437,13,2,163,72,'36.92',0),
 (25438,13,2,164,398,'35.66',0),
 (25439,13,2,165,460,'37.92',0),
 (25440,13,2,166,96,'46.60',0),
 (25441,13,2,167,1436,'46.11',0),
 (25442,13,2,168,264,'37.24',0),
 (25443,13,2,169,113,'25.74',0),
 (25444,13,2,170,527,'35.18',0),
 (25445,13,2,171,785,'33.76',0),
 (25446,13,2,172,769,'30.78',0),
 (25447,13,2,173,188,'46.53',0),
 (25448,13,2,174,291,'31.02',0),
 (25449,13,2,175,61,'26.07',0),
 (25450,13,2,176,881,'19.60',0),
 (25451,13,2,177,761,'37.14',0),
 (25452,13,2,178,143,'40.86',0),
 (25453,13,2,179,145,'25.44',0),
 (25454,13,2,180,1568,'45.24',0),
 (25455,13,2,181,2506,'25.78',0),
 (25456,13,2,182,52,'43.70',0),
 (25457,13,2,183,215,'35.48',0),
 (25458,13,2,901,123,'28.94',0),
 (25459,13,2,902,65,'23.72',0),
 (25460,13,2,903,5156,'33.04',0),
 (25461,27,2,1,2,'4.35',0),
 (25462,27,2,2,452,'41.43',0),
 (25463,27,2,3,43,'42.57',0),
 (25464,27,2,4,900,'42.06',0),
 (25465,27,2,5,29674,'48.07',0),
 (25466,27,2,6,15163,'42.21',0),
 (25467,27,2,7,29366,'48.37',0),
 (25468,27,2,8,288,'44.72',0),
 (25469,27,2,9,2229,'39.28',0),
 (25470,27,2,10,1395,'37.53',0),
 (25471,27,2,11,51,'25.37',0),
 (25472,27,2,12,128,'41.83',0),
 (25473,27,2,13,8003,'49.79',0),
 (25474,27,2,14,4908,'46.64',0),
 (25475,27,2,15,925,'42.01',0),
 (25476,27,2,16,26,'39.39',0),
 (25477,27,2,17,196,'43.46',0),
 (25478,27,2,18,653,'37.36',0),
 (25479,27,2,19,273,'53.74',0),
 (25480,27,2,20,24,'30.00',0),
 (25481,27,2,21,70,'34.83',0),
 (25482,27,2,22,3565,'27.12',0),
 (25483,27,2,23,689,'39.51',0),
 (25484,27,2,24,19,'25.00',0),
 (25485,27,2,25,88,'32.12',0),
 (25486,27,2,26,794,'32.00',0),
 (25487,27,2,27,250,'39.56',0),
 (25488,27,2,28,293,'39.17',0),
 (25489,27,2,29,97,'34.64',0),
 (25490,27,2,30,305,'39.87',0),
 (25491,27,2,31,526,'49.86',0),
 (25492,27,2,32,616,'46.81',0),
 (25493,27,2,33,463,'37.43',0),
 (25494,27,2,34,99,'37.22',0),
 (25495,27,2,35,293,'46.96',0),
 (25496,27,2,36,245,'39.26',0),
 (25497,27,2,37,524,'53.58',0),
 (25498,27,2,38,1283,'49.84',0),
 (25499,27,2,39,31,'42.47',0),
 (25500,27,2,40,2410,'50.46',0),
 (25501,27,2,41,521,'42.36',0),
 (25502,27,2,42,116,'27.62',0),
 (25503,27,2,43,878,'44.86',0),
 (25504,27,2,44,993,'43.10',0),
 (25505,27,2,45,5762,'43.70',0),
 (25506,27,2,46,716,'37.35',0),
 (25507,27,2,47,7169,'45.94',0),
 (25508,27,2,48,136,'50.56',0),
 (25509,27,2,49,14136,'54.79',0),
 (25510,27,2,50,265,'33.33',0),
 (25511,27,2,51,250,'38.64',0),
 (25512,27,2,52,694,'38.41',0),
 (25513,27,2,53,885,'45.55',0),
 (25514,27,2,54,1805,'39.64',0),
 (25515,27,2,55,251,'43.28',0),
 (25516,27,2,56,113,'38.05',0),
 (25517,27,2,57,186,'42.18',0),
 (25518,27,2,58,31981,'59.87',0),
 (25519,27,2,59,770,'41.09',0),
 (25520,27,2,60,501,'62.00',0),
 (25521,27,2,61,3368,'37.15',0),
 (25522,27,2,62,55,'31.98',0),
 (25523,27,2,63,55,'40.74',0),
 (25524,27,2,64,32,'35.96',0),
 (25525,27,2,65,31404,'54.18',0),
 (25526,27,2,66,711,'29.16',0),
 (25527,27,2,67,768,'45.91',0),
 (25528,27,2,68,1595,'37.55',0),
 (25529,27,2,69,15,'28.85',0),
 (25530,27,2,70,23,'26.14',0),
 (25531,27,2,71,29,'45.31',0),
 (25532,27,2,72,857,'31.30',0),
 (25533,27,2,73,1536,'50.25',0),
 (25534,27,2,74,35977,'56.23',0),
 (25535,27,2,75,677,'45.84',0),
 (25536,27,2,76,96,'40.17',0),
 (25537,27,2,78,4,'20.00',0),
 (25538,27,2,79,499912,'40.02',0),
 (25539,27,2,80,6779,'28.48',0),
 (25540,27,2,82,700,'36.84',0),
 (25541,27,2,83,1126,'47.65',0),
 (25542,27,2,84,2530,'53.36',0),
 (25543,27,2,85,844,'45.92',0),
 (25544,27,2,86,560,'39.27',0),
 (25545,27,2,87,582,'36.26',0),
 (25546,27,2,88,69,'44.81',0),
 (25547,27,2,89,555,'39.08',0),
 (25548,27,2,90,1302,'40.21',0),
 (25549,27,2,91,971,'46.66',0),
 (25550,27,2,92,33891,'51.11',0),
 (25551,27,2,93,343,'33.37',0),
 (25552,27,2,94,68,'26.05',0),
 (25553,27,2,95,229,'39.35',0),
 (25554,27,2,96,2297,'42.63',0),
 (25555,27,2,97,56,'70.89',0),
 (25556,27,2,99,240,'36.04',0),
 (25557,27,2,100,529,'38.78',0),
 (25558,27,2,101,25,'32.89',0),
 (25559,27,2,102,275,'59.52',0),
 (25560,27,2,104,1033,'40.13',0),
 (25561,27,2,106,14964,'64.53',0),
 (25562,27,2,107,104,'52.53',0),
 (25563,27,2,108,310,'34.37',0),
 (25564,27,2,109,206,'33.01',0),
 (25565,27,2,110,559,'48.15',0),
 (25566,27,2,111,120,'42.70',0),
 (25567,27,2,112,49,'46.23',0),
 (25568,27,2,113,5677,'52.13',0),
 (25569,27,2,114,12,'18.18',0),
 (25570,27,2,115,8436,'26.41',0),
 (25571,27,2,116,79,'50.64',0),
 (25572,27,2,117,17,'23.29',0),
 (25573,27,2,118,24,'48.98',0),
 (25574,27,2,119,234,'33.82',0),
 (25575,27,2,120,331,'50.23',0),
 (25576,27,2,121,67,'51.15',0),
 (25577,27,2,122,77,'39.90',0),
 (25578,27,2,123,7981,'52.14',0),
 (25579,27,2,124,19,'27.94',0),
 (25580,27,2,125,408,'36.96',0),
 (25581,27,2,126,29,'55.77',0),
 (25582,27,2,127,8662,'30.57',0),
 (25583,27,2,128,76,'39.58',0),
 (25584,27,2,129,969,'40.38',0),
 (25585,27,2,130,6173,'54.29',0),
 (25586,27,2,131,2144,'38.55',0),
 (25587,27,2,132,2037,'52.04',0),
 (25588,27,2,133,1150,'45.71',0),
 (25589,27,2,134,10585,'48.55',0),
 (25590,27,2,135,128,'36.16',0),
 (25591,27,2,136,139,'38.08',0),
 (25592,27,2,137,316,'47.73',0),
 (25593,27,2,138,32,'45.71',0),
 (25594,27,2,140,299,'41.07',0),
 (25595,27,2,141,603,'35.60',0),
 (25596,27,2,143,32,'43.84',0),
 (25597,27,2,144,995,'37.11',0),
 (25598,27,2,145,368,'50.97',0),
 (25599,27,2,146,405,'45.61',0),
 (25600,27,2,147,204,'47.89',0),
 (25601,27,2,148,15807,'50.89',0),
 (25602,27,2,149,647,'42.85',0),
 (25603,27,2,150,382,'37.82',0),
 (25604,27,2,151,608,'44.03',0),
 (25605,27,2,152,2079,'29.35',0),
 (25606,27,2,153,77,'37.38',0),
 (25607,27,2,154,941,'50.51',0),
 (25608,27,2,155,218,'60.22',0),
 (25609,27,2,156,178,'45.18',0),
 (25610,27,2,157,102,'36.30',0),
 (25611,27,2,158,62,'23.48',0),
 (25612,27,2,159,139,'50.92',0),
 (25613,27,2,160,1144,'39.26',0),
 (25614,27,2,161,5041,'41.33',0),
 (25615,27,2,162,315,'34.31',0),
 (25616,27,2,163,92,'48.94',0),
 (25617,27,2,164,447,'44.79',0),
 (25618,27,2,165,344,'40.86',0),
 (25619,27,2,166,87,'50.88',0),
 (25620,27,2,167,1298,'48.38',0),
 (25621,27,2,168,217,'42.05',0),
 (25622,27,2,169,135,'29.28',0),
 (25623,27,2,170,415,'45.50',0),
 (25624,27,2,171,635,'38.35',0),
 (25625,27,2,172,871,'33.24',0),
 (25626,27,2,173,131,'43.67',0),
 (25627,27,2,174,256,'37.59',0),
 (25628,27,2,175,96,'36.78',0),
 (25629,27,2,176,1182,'24.41',0),
 (25630,27,2,177,1037,'36.04',0),
 (25631,27,2,178,134,'38.62',0),
 (25632,27,2,179,215,'37.20',0),
 (25633,27,2,180,1334,'52.48',0),
 (25634,27,2,181,3187,'31.25',0),
 (25635,27,2,182,45,'46.39',0),
 (25636,27,2,183,187,'40.56',0),
 (25637,27,2,901,131,'37.43',0),
 (25638,27,2,902,52,'26.94',0),
 (25639,27,2,903,6313,'40.33',0),
 (25640,27,2,999,12748,'50.28',0),
 (25641,20,2,1,4,'11.76',0),
 (25642,20,2,2,417,'31.71',0),
 (25643,20,2,3,44,'36.36',0),
 (25644,20,2,4,781,'32.14',0),
 (25645,20,2,5,26112,'39.95',0),
 (25646,20,2,6,13159,'35.22',0),
 (25647,20,2,7,24362,'39.45',0),
 (25648,20,2,8,290,'36.99',0),
 (25649,20,2,9,2044,'31.66',0),
 (25650,20,2,10,1401,'29.46',0),
 (25651,20,2,11,58,'26.98',0),
 (25652,20,2,12,154,'36.49',0),
 (25653,20,2,13,6782,'38.60',0),
 (25654,20,2,14,5000,'36.54',0),
 (25655,20,2,15,1342,'29.73',0),
 (25656,20,2,16,24,'39.34',0),
 (25657,20,2,17,190,'34.05',0),
 (25658,20,2,18,571,'29.96',0),
 (25659,20,2,19,292,'47.63',0),
 (25660,20,2,20,29,'32.95',0),
 (25661,20,2,21,61,'28.37',0),
 (25662,20,2,22,3445,'21.43',0),
 (25663,20,2,23,675,'30.39',0),
 (25664,20,2,24,22,'27.50',0),
 (25665,20,2,25,72,'26.67',0),
 (25666,20,2,26,743,'25.54',0),
 (25667,20,2,27,212,'33.33',0),
 (25668,20,2,28,298,'35.69',0),
 (25669,20,2,29,93,'29.34',0),
 (25670,20,2,30,341,'36.63',0),
 (25671,20,2,31,484,'46.90',0),
 (25672,20,2,32,694,'36.68',0),
 (25673,20,2,33,417,'27.71',0),
 (25674,20,2,34,68,'27.87',0),
 (25675,20,2,35,302,'40.32',0),
 (25676,20,2,36,276,'28.42',0),
 (25677,20,2,37,484,'50.63',0),
 (25678,20,2,38,1085,'40.47',0),
 (25679,20,2,39,26,'36.11',0),
 (25680,20,2,40,2115,'37.60',0),
 (25681,20,2,41,508,'28.85',0),
 (25682,20,2,42,130,'24.12',0),
 (25683,20,2,43,789,'34.74',0),
 (25684,20,2,44,763,'29.03',0),
 (25685,20,2,45,4965,'33.95',0),
 (25686,20,2,46,702,'31.09',0),
 (25687,20,2,47,6639,'36.52',0),
 (25688,20,2,48,149,'50.51',0),
 (25689,20,2,49,13293,'44.82',0),
 (25690,20,2,50,384,'27.37',0),
 (25691,20,2,51,226,'29.74',0),
 (25692,20,2,52,535,'28.44',0),
 (25693,20,2,53,1066,'36.36',0),
 (25694,20,2,54,1641,'31.94',0),
 (25695,20,2,55,233,'40.03',0),
 (25696,20,2,56,137,'34.25',0),
 (25697,20,2,57,251,'34.62',0),
 (25698,20,2,58,27299,'45.01',0),
 (25699,20,2,59,687,'33.84',0),
 (25700,20,2,60,452,'54.39',0),
 (25701,20,2,61,3099,'30.58',0),
 (25702,20,2,62,39,'22.54',0),
 (25703,20,2,63,55,'36.42',0),
 (25704,20,2,64,18,'25.00',0),
 (25705,20,2,65,26465,'44.44',0),
 (25706,20,2,66,792,'23.01',0),
 (25707,20,2,67,778,'39.57',0),
 (25708,20,2,68,1576,'31.40',0),
 (25709,20,2,69,8,'23.53',0),
 (25710,20,2,70,20,'23.26',0),
 (25711,20,2,71,14,'32.56',0),
 (25712,20,2,72,738,'26.76',0),
 (25713,20,2,73,1824,'37.58',0),
 (25714,20,2,74,31547,'46.62',0),
 (25715,20,2,75,742,'34.74',0),
 (25716,20,2,76,92,'35.80',0),
 (25717,20,2,78,6,'24.00',0),
 (25718,20,2,79,417206,'34.15',0),
 (25719,20,2,80,5646,'21.83',0),
 (25720,20,2,82,778,'31.24',0),
 (25721,20,2,83,1026,'31.78',0),
 (25722,20,2,84,2550,'39.58',0),
 (25723,20,2,85,780,'38.88',0),
 (25724,20,2,86,619,'31.74',0),
 (25725,20,2,87,565,'32.51',0),
 (25726,20,2,88,66,'50.38',0),
 (25727,20,2,89,487,'30.40',0),
 (25728,20,2,90,1235,'30.90',0),
 (25729,20,2,91,845,'37.79',0),
 (25730,20,2,92,29363,'41.39',0),
 (25731,20,2,93,339,'30.93',0),
 (25732,20,2,94,90,'25.57',0),
 (25733,20,2,95,202,'29.66',0),
 (25734,20,2,96,2250,'32.63',0),
 (25735,20,2,97,44,'62.86',0),
 (25736,20,2,99,219,'25.98',0),
 (25737,20,2,100,555,'31.59',0),
 (25738,20,2,101,50,'40.00',0),
 (25739,20,2,102,228,'43.76',0),
 (25740,20,2,104,1463,'29.71',0),
 (25741,20,2,106,14037,'48.13',0),
 (25742,20,2,107,92,'42.79',0),
 (25743,20,2,108,430,'32.77',0),
 (25744,20,2,109,200,'26.14',0),
 (25745,20,2,110,466,'40.03',0),
 (25746,20,2,111,111,'31.99',0),
 (25747,20,2,112,49,'42.24',0),
 (25748,20,2,113,5709,'40.99',0),
 (25749,20,2,114,10,'13.16',0),
 (25750,20,2,115,7024,'21.15',0),
 (25751,20,2,116,127,'44.88',0),
 (25752,20,2,117,14,'22.58',0),
 (25753,20,2,118,19,'41.30',0),
 (25754,20,2,119,250,'26.97',0),
 (25755,20,2,120,291,'43.37',0),
 (25756,20,2,121,47,'36.72',0),
 (25757,20,2,122,80,'30.89',0),
 (25758,20,2,123,9863,'42.36',0),
 (25759,20,2,124,23,'37.70',0),
 (25760,20,2,125,408,'30.11',0),
 (25761,20,2,126,21,'48.84',0),
 (25762,20,2,127,7487,'22.73',0),
 (25763,20,2,128,84,'39.62',0),
 (25764,20,2,129,991,'30.67',0),
 (25765,20,2,130,5664,'43.95',0),
 (25766,20,2,131,1927,'30.98',0),
 (25767,20,2,132,2015,'42.23',0),
 (25768,20,2,133,1090,'37.77',0),
 (25769,20,2,134,10028,'38.81',0),
 (25770,20,2,135,152,'32.97',0),
 (25771,20,2,136,134,'33.67',0),
 (25772,20,2,137,328,'41.57',0),
 (25773,20,2,138,20,'40.00',0),
 (25774,20,2,140,356,'29.54',0),
 (25775,20,2,141,666,'28.28',0),
 (25776,20,2,143,22,'38.60',0),
 (25777,20,2,144,943,'30.05',0),
 (25778,20,2,145,398,'41.50',0),
 (25779,20,2,146,346,'39.68',0),
 (25780,20,2,147,195,'41.23',0),
 (25781,20,2,148,14023,'39.36',0),
 (25782,20,2,149,727,'33.80',0),
 (25783,20,2,150,424,'28.84',0),
 (25784,20,2,151,609,'40.68',0),
 (25785,20,2,152,1939,'24.22',0),
 (25786,20,2,153,111,'39.78',0),
 (25787,20,2,154,862,'34.56',0),
 (25788,20,2,155,173,'53.56',0),
 (25789,20,2,156,157,'34.35',0),
 (25790,20,2,157,93,'27.60',0),
 (25791,20,2,158,82,'24.55',0),
 (25792,20,2,159,103,'32.29',0),
 (25793,20,2,160,1056,'29.87',0),
 (25794,20,2,161,5856,'32.30',0),
 (25795,20,2,162,336,'28.72',0),
 (25796,20,2,163,85,'40.87',0),
 (25797,20,2,164,421,'31.32',0),
 (25798,20,2,165,282,'32.41',0),
 (25799,20,2,166,78,'38.42',0),
 (25800,20,2,167,1285,'36.63',0),
 (25801,20,2,168,189,'35.33',0),
 (25802,20,2,169,157,'25.24',0),
 (25803,20,2,170,334,'33.43',0),
 (25804,20,2,171,559,'29.86',0),
 (25805,20,2,172,924,'27.76',0),
 (25806,20,2,173,133,'43.18',0),
 (25807,20,2,174,306,'36.21',0),
 (25808,20,2,175,109,'28.68',0),
 (25809,20,2,176,1095,'18.59',0),
 (25810,20,2,177,1166,'25.15',0),
 (25811,20,2,178,157,'34.35',0),
 (25812,20,2,179,183,'27.81',0),
 (25813,20,2,180,1279,'45.73',0),
 (25814,20,2,181,2713,'24.57',0),
 (25815,20,2,182,38,'34.23',0),
 (25816,20,2,183,207,'41.07',0),
 (25817,20,2,901,126,'35.20',0),
 (25818,20,2,902,43,'21.61',0),
 (25819,20,2,903,5744,'34.20',0),
 (25820,20,2,999,9181,'48.74',0),
 (26001,12,2,1,12,'33.33',0),
 (26002,12,2,2,308,'32.49',0),
 (26003,12,2,3,35,'32.41',0),
 (26004,12,2,4,872,'35.09',0),
 (26005,12,2,5,36517,'36.35',0),
 (26006,12,2,6,16695,'32.30',0),
 (26007,12,2,7,31434,'33.02',0),
 (26008,12,2,8,255,'31.40',0),
 (26009,12,2,9,2209,'30.43',0),
 (26010,12,2,10,878,'27.95',0),
 (26011,12,2,11,56,'24.56',0),
 (26012,12,2,12,145,'34.69',0),
 (26013,12,2,13,9376,'37.06',0),
 (26014,12,2,14,6780,'39.12',0),
 (26015,12,2,15,498,'32.63',0),
 (26016,12,2,16,36,'47.37',0),
 (26017,12,2,17,126,'29.79',0),
 (26018,12,2,18,632,'36.92',0),
 (26019,12,2,19,403,'50.69',0),
 (26020,12,2,20,24,'27.27',0),
 (26021,12,2,21,57,'25.45',0),
 (26022,12,2,22,2096,'18.29',0),
 (26023,12,2,23,452,'28.77',0),
 (26024,12,2,24,14,'15.38',0),
 (26025,12,2,25,109,'32.44',0),
 (26026,12,2,26,557,'25.57',0),
 (26027,12,2,27,284,'33.53',0),
 (26028,12,2,28,219,'24.12',0),
 (26029,12,2,29,87,'30.53',0),
 (26030,12,2,30,242,'28.81',0),
 (26031,12,2,31,712,'49.24',0),
 (26032,12,2,32,515,'38.26',0),
 (26033,12,2,33,608,'38.31',0),
 (26034,12,2,34,116,'35.15',0),
 (26035,12,2,35,328,'41.05',0),
 (26036,12,2,36,99,'24.32',0),
 (26037,12,2,37,634,'49.92',0),
 (26038,12,2,38,1283,'40.55',0),
 (26039,12,2,39,30,'43.48',0),
 (26040,12,2,40,2718,'40.53',0),
 (26041,12,2,41,395,'34.20',0),
 (26042,12,2,42,118,'24.63',0),
 (26043,12,2,43,1617,'49.37',0),
 (26044,12,2,44,693,'32.77',0),
 (26045,12,2,45,5771,'33.60',0),
 (26046,12,2,46,648,'29.40',0),
 (26047,12,2,47,7103,'33.15',0),
 (26048,12,2,48,130,'44.52',0),
 (26049,12,2,49,16738,'37.18',0),
 (26050,12,2,50,178,'24.62',0),
 (26051,12,2,51,236,'30.93',0),
 (26052,12,2,52,901,'33.54',0),
 (26053,12,2,53,472,'35.60',0),
 (26054,12,2,54,1659,'30.49',0),
 (26055,12,2,55,327,'42.47',0),
 (26056,12,2,56,79,'22.70',0),
 (26057,12,2,57,83,'26.18',0),
 (26058,12,2,58,35383,'40.77',0),
 (26059,12,2,59,639,'33.88',0),
 (26060,12,2,60,538,'54.51',0),
 (26061,12,2,61,2843,'28.84',0),
 (26062,12,2,62,57,'26.64',0),
 (26063,12,2,63,39,'24.84',0),
 (26064,12,2,64,26,'33.33',0),
 (26065,12,2,65,34746,'36.46',0),
 (26066,12,2,66,419,'18.66',0),
 (26067,12,2,67,641,'40.31',0),
 (26068,12,2,68,1632,'33.00',0),
 (26069,12,2,69,4,'10.26',0),
 (26070,12,2,70,14,'15.73',0),
 (26071,12,2,71,19,'32.20',0),
 (26072,12,2,72,597,'21.22',0),
 (26073,12,2,73,1769,'39.82',0),
 (26074,12,2,74,44042,'38.57',0),
 (26075,12,2,75,675,'38.48',0),
 (26076,12,2,76,128,'38.32',0),
 (26077,12,2,78,6,'25.00',0),
 (26078,12,2,79,584974,'29.26',0),
 (26079,12,2,80,5091,'21.07',0),
 (26080,12,2,82,507,'26.13',0),
 (26081,12,2,83,776,'37.69',0),
 (26082,12,2,84,2982,'36.27',0),
 (26083,12,2,85,830,'38.35',0),
 (26084,12,2,86,709,'35.29',0),
 (26085,12,2,87,589,'33.11',0),
 (26086,12,2,88,85,'44.97',0),
 (26087,12,2,89,359,'29.28',0),
 (26088,12,2,90,679,'32.75',0),
 (26089,12,2,91,1371,'40.35',0),
 (26090,12,2,92,40390,'34.80',0),
 (26091,12,2,93,347,'29.84',0),
 (26092,12,2,94,57,'22.01',0),
 (26093,12,2,95,154,'28.47',0),
 (26094,12,2,96,2438,'35.71',0),
 (26095,12,2,97,41,'51.25',0),
 (26096,12,2,99,242,'27.10',0),
 (26097,12,2,100,283,'23.72',0),
 (26098,12,2,101,20,'18.69',0),
 (26099,12,2,102,289,'54.02',0),
 (26100,12,2,104,923,'28.51',0),
 (26101,12,2,106,16710,'40.98',0),
 (26102,12,2,107,120,'51.72',0),
 (26103,12,2,108,211,'28.63',0),
 (26104,12,2,109,175,'27.91',0),
 (26105,12,2,110,605,'42.61',0),
 (26106,12,2,111,131,'36.49',0),
 (26107,12,2,112,49,'40.16',0),
 (26108,12,2,113,5767,'38.21',0),
 (26109,12,2,114,39,'35.45',0),
 (26110,12,2,115,7343,'20.01',0),
 (26111,12,2,116,77,'46.39',0),
 (26112,12,2,117,16,'21.05',0),
 (26113,12,2,118,22,'37.29',0),
 (26114,12,2,119,155,'27.39',0),
 (26115,12,2,120,409,'41.52',0),
 (26116,12,2,121,53,'50.48',0),
 (26117,12,2,122,67,'34.01',0),
 (26118,12,2,123,4587,'36.45',0),
 (26119,12,2,124,23,'31.08',0),
 (26120,12,2,125,430,'31.20',0),
 (26121,12,2,126,46,'63.01',0),
 (26122,12,2,127,6028,'21.80',0),
 (26123,12,2,128,116,'46.22',0),
 (26124,12,2,129,793,'29.34',0),
 (26125,12,2,130,6395,'36.84',0),
 (26126,12,2,131,2013,'29.99',0),
 (26127,12,2,132,2377,'43.57',0),
 (26128,12,2,133,1541,'40.98',0),
 (26129,12,2,134,11955,'34.46',0),
 (26130,12,2,135,166,'36.81',0),
 (26131,12,2,136,133,'34.19',0),
 (26132,12,2,137,304,'43.68',0),
 (26133,12,2,138,9,'12.50',0),
 (26134,12,2,140,124,'26.72',0),
 (26135,12,2,141,405,'28.62',0),
 (26136,12,2,143,37,'44.05',0),
 (26137,12,2,144,491,'21.35',0),
 (26138,12,2,145,342,'41.01',0),
 (26139,12,2,146,552,'44.05',0),
 (26140,12,2,147,275,'43.93',0),
 (26141,12,2,148,18663,'36.26',0),
 (26142,12,2,149,508,'29.57',0),
 (26143,12,2,150,309,'28.61',0),
 (26144,12,2,151,740,'42.36',0),
 (26145,12,2,152,1313,'21.00',0),
 (26146,12,2,153,68,'37.36',0),
 (26147,12,2,154,1122,'46.87',0),
 (26148,12,2,155,305,'63.02',0),
 (26149,12,2,156,132,'35.01',0),
 (26150,12,2,157,137,'35.58',0),
 (26151,12,2,158,48,'15.84',0),
 (26152,12,2,159,148,'42.05',0),
 (26153,12,2,160,785,'31.98',0),
 (26154,12,2,161,3833,'30.32',0),
 (26155,12,2,162,267,'27.19',0),
 (26156,12,2,163,72,'30.77',0),
 (26157,12,2,164,379,'35.99',0),
 (26158,12,2,165,457,'38.76',0),
 (26159,12,2,166,96,'43.64',0),
 (26160,12,2,167,997,'40.53',0),
 (26161,12,2,168,241,'34.93',0),
 (26162,12,2,169,76,'20.99',0),
 (26163,12,2,170,650,'35.66',0),
 (26164,12,2,171,741,'33.08',0),
 (26165,12,2,172,522,'25.58',0),
 (26166,12,2,173,199,'48.42',0),
 (26167,12,2,174,276,'31.19',0),
 (26168,12,2,175,60,'24.90',0),
 (26169,12,2,176,656,'15.92',0),
 (26170,12,2,177,617,'39.53',0),
 (26171,12,2,178,116,'38.41',0),
 (26172,12,2,179,148,'25.56',0),
 (26173,12,2,180,1549,'44.42',0),
 (26174,12,2,181,2257,'20.92',0),
 (26175,12,2,182,59,'46.46',0),
 (26176,12,2,183,180,'29.70',0),
 (26177,12,2,901,161,'39.08',0),
 (26178,12,2,902,88,'33.33',0),
 (26179,12,2,903,3570,'23.63',0),
 (26180,15,2,1,3,'6.12',0),
 (26181,15,2,2,381,'29.98',0),
 (26182,15,2,3,38,'30.89',0),
 (26183,15,2,4,898,'33.61',0),
 (26184,15,2,5,33377,'35.81',0),
 (26185,15,2,6,16733,'33.30',0),
 (26186,15,2,7,31973,'34.71',0),
 (26187,15,2,8,288,'33.37',0),
 (26188,15,2,9,2407,'31.65',0),
 (26189,15,2,10,1112,'26.58',0),
 (26190,15,2,11,42,'19.81',0),
 (26191,15,2,12,153,'38.15',0),
 (26192,15,2,13,9283,'39.13',0),
 (26193,15,2,14,6592,'38.82',0),
 (26194,15,2,15,639,'30.96',0),
 (26195,15,2,16,17,'25.76',0),
 (26196,15,2,17,181,'35.70',0),
 (26197,15,2,18,610,'31.66',0),
 (26198,15,2,19,349,'48.81',0),
 (26199,15,2,20,16,'17.20',0),
 (26200,15,2,21,53,'24.42',0),
 (26201,15,2,22,2359,'19.49',0),
 (26202,15,2,23,506,'27.57',0),
 (26203,15,2,24,21,'23.33',0),
 (26204,15,2,25,105,'31.07',0),
 (26205,15,2,26,727,'26.86',0),
 (26206,15,2,27,262,'31.95',0),
 (26207,15,2,28,233,'26.63',0),
 (26208,15,2,29,94,'29.47',0),
 (26209,15,2,30,312,'31.26',0),
 (26210,15,2,31,708,'49.65',0),
 (26211,15,2,32,499,'36.83',0),
 (26212,15,2,33,605,'36.49',0),
 (26213,15,2,34,104,'33.23',0),
 (26214,15,2,35,294,'37.50',0),
 (26215,15,2,36,129,'26.76',0),
 (26216,15,2,37,611,'50.00',0),
 (26217,15,2,38,1269,'37.90',0),
 (26218,15,2,39,33,'47.14',0),
 (26219,15,2,40,2626,'39.84',0),
 (26220,15,2,41,508,'32.80',0),
 (26221,15,2,42,127,'25.60',0),
 (26222,15,2,43,1308,'43.46',0),
 (26223,15,2,44,799,'32.71',0),
 (26224,15,2,45,5883,'33.33',0),
 (26225,15,2,46,687,'28.31',0),
 (26226,15,2,47,7839,'35.18',0),
 (26227,15,2,48,126,'45.32',0),
 (26228,15,2,49,17184,'40.19',0),
 (26229,15,2,50,224,'23.41',0),
 (26230,15,2,51,227,'27.75',0),
 (26231,15,2,52,756,'29.68',0),
 (26232,15,2,53,670,'32.67',0),
 (26233,15,2,54,1815,'31.25',0),
 (26234,15,2,55,313,'44.08',0),
 (26235,15,2,56,113,'28.83',0),
 (26236,15,2,57,95,'26.24',0),
 (26237,15,2,58,41052,'45.48',0),
 (26238,15,2,59,701,'30.61',0),
 (26239,15,2,60,595,'59.26',0),
 (26240,15,2,61,3456,'29.45',0),
 (26241,15,2,62,47,'23.50',0),
 (26242,15,2,63,48,'33.33',0),
 (26243,15,2,64,24,'30.38',0),
 (26244,15,2,65,36679,'40.71',0),
 (26245,15,2,66,605,'21.90',0),
 (26246,15,2,67,708,'38.58',0),
 (26247,15,2,68,1723,'32.10',0),
 (26248,15,2,69,9,'19.57',0),
 (26249,15,2,70,12,'12.24',0),
 (26250,15,2,71,11,'20.37',0),
 (26251,15,2,72,709,'22.75',0),
 (26252,15,2,73,1876,'43.20',0),
 (26253,15,2,74,43095,'41.89',0),
 (26254,15,2,75,712,'38.74',0),
 (26255,15,2,76,111,'35.69',0),
 (26256,15,2,78,5,'26.32',0),
 (26257,15,2,79,543402,'30.88',0),
 (26258,15,2,80,5805,'22.04',0),
 (26259,15,2,82,526,'23.93',0),
 (26260,15,2,83,990,'35.32',0),
 (26261,15,2,84,2977,'38.04',0),
 (26262,15,2,85,887,'40.14',0),
 (26263,15,2,86,637,'33.40',0),
 (26264,15,2,87,595,'30.59',0),
 (26265,15,2,88,76,'40.00',0),
 (26266,15,2,89,492,'29.96',0),
 (26267,15,2,90,896,'30.08',0),
 (26268,15,2,91,1284,'40.56',0),
 (26269,15,2,92,40859,'37.78',0),
 (26270,15,2,93,357,'29.85',0),
 (26271,15,2,94,75,'23.15',0),
 (26272,15,2,95,170,'26.86',0),
 (26273,15,2,96,2714,'37.11',0),
 (26274,15,2,97,45,'55.56',0),
 (26275,15,2,99,220,'23.31',0),
 (26276,15,2,100,467,'27.36',0),
 (26277,15,2,101,25,'23.15',0),
 (26278,15,2,102,267,'51.25',0),
 (26279,15,2,104,945,'28.53',0),
 (26280,15,2,106,16725,'43.83',0),
 (26281,15,2,107,122,'50.62',0),
 (26282,15,2,108,253,'27.92',0),
 (26283,15,2,109,186,'26.61',0),
 (26284,15,2,110,592,'43.15',0),
 (26285,15,2,111,116,'32.68',0),
 (26286,15,2,112,51,'38.64',0),
 (26287,15,2,113,6269,'39.90',0),
 (26288,15,2,114,26,'25.24',0),
 (26289,15,2,115,8104,'20.89',0),
 (26290,15,2,116,78,'46.99',0),
 (26291,15,2,117,13,'17.11',0),
 (26292,15,2,118,24,'41.38',0),
 (26293,15,2,119,176,'25.77',0),
 (26294,15,2,120,378,'39.25',0),
 (26295,15,2,121,61,'49.19',0),
 (26296,15,2,122,85,'36.48',0),
 (26297,15,2,123,6068,'39.03',0),
 (26298,15,2,124,12,'15.79',0),
 (26299,15,2,125,340,'24.48',0),
 (26300,15,2,126,39,'61.90',0),
 (26301,15,2,127,7193,'23.31',0),
 (26302,15,2,128,103,'43.28',0),
 (26303,15,2,129,908,'31.20',0),
 (26304,15,2,130,6804,'37.89',0),
 (26305,15,2,131,2168,'31.32',0),
 (26306,15,2,132,2457,'44.16',0),
 (26307,15,2,133,1459,'39.63',0),
 (26308,15,2,134,11895,'36.04',0),
 (26309,15,2,135,135,'28.01',0),
 (26310,15,2,136,130,'32.91',0),
 (26311,15,2,137,296,'41.23',0),
 (26312,15,2,138,14,'19.72',0),
 (26313,15,2,140,152,'27.44',0),
 (26314,15,2,141,469,'24.91',0),
 (26315,15,2,143,28,'35.90',0),
 (26316,15,2,144,778,'26.53',0),
 (26317,15,2,145,333,'37.37',0),
 (26318,15,2,146,496,'40.76',0),
 (26319,15,2,147,244,'41.08',0),
 (26320,15,2,148,18605,'37.06',0),
 (26321,15,2,149,702,'31.30',0),
 (26322,15,2,150,357,'29.50',0),
 (26323,15,2,151,637,'39.06',0),
 (26324,15,2,152,1672,'21.11',0),
 (26325,15,2,153,74,'32.60',0),
 (26326,15,2,154,1064,'41.74',0),
 (26327,15,2,155,252,'57.93',0),
 (26328,15,2,156,154,'37.11',0),
 (26329,15,2,157,131,'33.76',0),
 (26330,15,2,158,60,'17.54',0),
 (26331,15,2,159,132,'36.46',0),
 (26332,15,2,160,917,'30.27',0),
 (26333,15,2,161,4532,'30.37',0),
 (26334,15,2,162,295,'27.06',0),
 (26335,15,2,163,75,'36.23',0),
 (26336,15,2,164,392,'33.91',0),
 (26337,15,2,165,419,'36.75',0),
 (26338,15,2,166,93,'46.27',0),
 (26339,15,2,167,1455,'38.91',0),
 (26340,15,2,168,246,'35.29',0),
 (26341,15,2,169,104,'22.17',0),
 (26342,15,2,170,525,'37.77',0),
 (26343,15,2,171,729,'32.20',0),
 (26344,15,2,172,730,'24.75',0),
 (26345,15,2,173,178,'44.84',0),
 (26346,15,2,174,255,'27.16',0),
 (26347,15,2,175,57,'23.08',0),
 (26348,15,2,176,1057,'19.01',0),
 (26349,15,2,177,776,'32.84',0),
 (26350,15,2,178,107,'32.23',0),
 (26351,15,2,179,170,'23.26',0),
 (26352,15,2,180,1626,'47.52',0),
 (26353,15,2,181,2656,'22.06',0),
 (26354,15,2,182,49,'39.52',0),
 (26355,15,2,183,210,'35.47',0),
 (26356,15,2,901,154,'36.93',0),
 (26357,15,2,902,65,'25.39',0),
 (26358,15,2,903,5343,'27.78',0),
 (26359,15,2,999,8172,'37.38',0),
 (26360,17,2,1,2,'4.08',0),
 (26361,17,2,2,675,'39.34',0),
 (26362,17,2,3,53,'40.46',0),
 (26363,17,2,4,1532,'42.83',0),
 (26364,17,2,5,51899,'47.61',0),
 (26365,17,2,6,25714,'44.03',0),
 (26366,17,2,7,50258,'48.55',0),
 (26367,17,2,8,445,'42.06',0),
 (26368,17,2,9,4145,'42.25',0),
 (26369,17,2,10,2319,'38.27',0),
 (26370,17,2,11,61,'24.90',0),
 (26371,17,2,12,198,'42.86',0),
 (26372,17,2,13,13127,'49.15',0),
 (26373,17,2,14,8847,'44.87',0),
 (26374,17,2,15,1697,'40.92',0),
 (26375,17,2,16,24,'32.00',0),
 (26376,17,2,17,322,'40.55',0),
 (26377,17,2,18,955,'38.00',0),
 (26378,17,2,19,440,'56.27',0),
 (26379,17,2,20,33,'30.84',0),
 (26380,17,2,21,86,'31.16',0),
 (26381,17,2,22,5825,'29.63',0),
 (26382,17,2,23,1026,'38.76',0),
 (26383,17,2,24,30,'27.03',0),
 (26384,17,2,25,122,'34.66',0),
 (26385,17,2,26,1318,'33.59',0),
 (26386,17,2,27,370,'39.91',0),
 (26387,17,2,28,417,'39.60',0),
 (26388,17,2,29,147,'40.16',0),
 (26389,17,2,30,509,'42.99',0),
 (26390,17,2,31,745,'49.47',0),
 (26391,17,2,32,1119,'46.88',0),
 (26392,17,2,33,795,'39.69',0),
 (26393,17,2,34,117,'36.34',0),
 (26394,17,2,35,375,'44.48',0),
 (26395,17,2,36,453,'39.60',0),
 (26396,17,2,37,659,'52.09',0),
 (26397,17,2,38,1776,'47.41',0),
 (26398,17,2,39,42,'42.86',0),
 (26399,17,2,40,4264,'49.56',0),
 (26400,17,2,41,806,'40.44',0),
 (26401,17,2,42,171,'29.95',0),
 (26402,17,2,43,1653,'45.81',0),
 (26403,17,2,44,1576,'42.90',0),
 (26404,17,2,45,9509,'44.68',0),
 (26405,17,2,46,1117,'37.57',0),
 (26406,17,2,47,12531,'46.13',0),
 (26407,17,2,48,162,'47.51',0),
 (26408,17,2,49,26013,'52.13',0),
 (26409,17,2,50,586,'37.83',0),
 (26410,17,2,51,391,'38.07',0),
 (26411,17,2,52,1018,'36.92',0),
 (26412,17,2,53,1601,'44.31',0),
 (26413,17,2,54,2859,'38.97',0),
 (26414,17,2,55,316,'43.77',0),
 (26415,17,2,56,212,'43.80',0),
 (26416,17,2,57,306,'41.13',0),
 (26417,17,2,58,63676,'57.92',0),
 (26418,17,2,59,1258,'41.55',0),
 (26419,17,2,60,642,'60.62',0),
 (26420,17,2,61,5776,'39.41',0),
 (26421,17,2,62,79,'36.24',0),
 (26422,17,2,63,66,'37.50',0),
 (26423,17,2,64,45,'41.67',0),
 (26424,17,2,65,52783,'52.72',0),
 (26425,17,2,66,1333,'31.18',0),
 (26426,17,2,67,1108,'44.13',0),
 (26427,17,2,68,2722,'39.07',0),
 (26428,17,2,69,16,'24.62',0),
 (26429,17,2,70,22,'22.22',0),
 (26430,17,2,71,38,'53.52',0),
 (26431,17,2,72,1245,'32.60',0),
 (26432,17,2,73,3215,'50.34',0),
 (26433,17,2,74,61123,'53.86',0),
 (26434,17,2,75,1094,'44.26',0),
 (26435,17,2,76,145,'44.89',0),
 (26436,17,2,78,5,'20.83',0),
 (26437,17,2,79,783797,'41.78',0),
 (26438,17,2,80,10341,'30.85',0),
 (26439,17,2,82,1161,'37.18',0),
 (26440,17,2,83,2280,'46.17',0),
 (26441,17,2,84,5458,'52.14',0),
 (26442,17,2,85,1204,'45.47',0),
 (26443,17,2,86,931,'39.97',0),
 (26444,17,2,87,883,'37.57',0),
 (26445,17,2,88,96,'47.29',0),
 (26446,17,2,89,873,'39.13',0),
 (26447,17,2,90,2042,'40.40',0),
 (26448,17,2,91,1619,'46.95',0),
 (26449,17,2,92,62664,'50.69',0),
 (26450,17,2,93,511,'36.06',0),
 (26451,17,2,94,143,'30.75',0),
 (26452,17,2,95,334,'39.81',0),
 (26453,17,2,96,3848,'42.46',0),
 (26454,17,2,97,69,'75.00',0),
 (26455,17,2,99,388,'34.99',0),
 (26456,17,2,100,963,'38.83',0),
 (26457,17,2,101,39,'35.14',0),
 (26458,17,2,102,331,'57.87',0),
 (26459,17,2,104,1562,'38.88',0),
 (26460,17,2,106,29354,'62.34',0),
 (26461,17,2,107,163,'58.63',0),
 (26462,17,2,108,495,'37.27',0),
 (26463,17,2,109,346,'35.89',0),
 (26464,17,2,110,712,'47.75',0),
 (26465,17,2,111,161,'41.71',0),
 (26466,17,2,112,59,'45.38',0),
 (26467,17,2,113,10838,'51.96',0),
 (26468,17,2,114,41,'33.06',0),
 (26469,17,2,115,13280,'29.33',0),
 (26470,17,2,116,91,'48.40',0),
 (26471,17,2,117,32,'36.36',0),
 (26472,17,2,118,31,'46.97',0),
 (26473,17,2,119,361,'35.05',0),
 (26474,17,2,120,462,'47.43',0),
 (26475,17,2,121,79,'50.00',0),
 (26476,17,2,122,109,'41.13',0),
 (26477,17,2,123,12851,'49.61',0),
 (26478,17,2,124,24,'30.00',0),
 (26479,17,2,125,610,'35.92',0),
 (26480,17,2,126,23,'45.10',0),
 (26481,17,2,127,13558,'32.58',0),
 (26482,17,2,128,106,'41.73',0),
 (26483,17,2,129,1673,'42.09',0),
 (26484,17,2,130,11147,'50.05',0),
 (26485,17,2,131,3318,'38.90',0),
 (26486,17,2,132,3414,'49.42',0),
 (26487,17,2,133,1847,'45.40',0),
 (26488,17,2,134,18719,'48.63',0),
 (26489,17,2,135,240,'40.68',0),
 (26490,17,2,136,166,'34.87',0),
 (26491,17,2,137,411,'45.41',0),
 (26492,17,2,138,40,'43.48',0),
 (26493,17,2,140,554,'39.51',0),
 (26494,17,2,141,1157,'37.46',0),
 (26495,17,2,143,32,'39.02',0),
 (26496,17,2,144,1533,'37.82',0),
 (26497,17,2,145,531,'50.48',0),
 (26498,17,2,146,568,'45.19',0),
 (26499,17,2,147,297,'50.42',0),
 (26500,17,2,148,29955,'50.10',0),
 (26501,17,2,149,1327,'43.68',0),
 (26502,17,2,150,778,'41.27',0),
 (26503,17,2,151,893,'45.47',0),
 (26504,17,2,152,3206,'30.79',0),
 (26505,17,2,153,125,'41.25',0),
 (26506,17,2,154,1557,'49.23',0),
 (26507,17,2,155,272,'61.12',0),
 (26508,17,2,156,245,'45.20',0),
 (26509,17,2,157,173,'40.14',0),
 (26510,17,2,158,129,'28.92',0),
 (26511,17,2,159,194,'43.02',0),
 (26512,17,2,160,1849,'39.40',0),
 (26513,17,2,161,9470,'42.16',0),
 (26514,17,2,162,460,'35.77',0),
 (26515,17,2,163,111,'46.44',0),
 (26516,17,2,164,706,'42.66',0),
 (26517,17,2,165,519,'42.33',0),
 (26518,17,2,166,104,'45.22',0),
 (26519,17,2,167,2605,'48.87',0),
 (26520,17,2,168,303,'40.95',0),
 (26521,17,2,169,206,'31.69',0),
 (26522,17,2,170,817,'48.17',0),
 (26523,17,2,171,1040,'39.44',0),
 (26524,17,2,172,1487,'34.45',0),
 (26525,17,2,173,182,'45.73',0),
 (26526,17,2,174,409,'37.56',0),
 (26527,17,2,175,124,'38.39',0),
 (26528,17,2,176,1889,'27.38',0),
 (26529,17,2,177,1768,'37.43',0),
 (26530,17,2,178,240,'40.00',0),
 (26531,17,2,179,361,'38.12',0),
 (26532,17,2,180,1996,'52.06',0),
 (26533,17,2,181,5025,'32.44',0),
 (26534,17,2,182,55,'41.98',0),
 (26535,17,2,183,304,'44.38',0),
 (26536,17,2,901,208,'42.62',0),
 (26537,17,2,902,79,'27.92',0),
 (26538,17,2,903,9478,'40.90',0),
 (26539,17,2,999,12898,'38.41',0),
 (26540,19,2,1,6,'13.04',0),
 (26541,19,2,2,660,'35.73',0),
 (26542,19,2,3,63,'39.38',0),
 (26543,19,2,4,1420,'34.55',0),
 (26544,19,2,5,46095,'43.37',0),
 (26545,19,2,6,23092,'39.17',0),
 (26546,19,2,7,43619,'43.45',0),
 (26547,19,2,8,471,'37.17',0),
 (26548,19,2,9,3687,'35.64',0),
 (26549,19,2,10,2472,'34.41',0),
 (26550,19,2,11,89,'29.67',0),
 (26551,19,2,12,224,'36.07',0),
 (26552,19,2,13,12048,'42.59',0),
 (26553,19,2,14,9132,'39.59',0),
 (26554,19,2,15,2289,'33.69',0),
 (26555,19,2,16,32,'42.67',0),
 (26556,19,2,17,323,'36.83',0),
 (26557,19,2,18,960,'34.01',0),
 (26558,19,2,19,443,'51.45',0),
 (26559,19,2,20,40,'38.46',0),
 (26560,19,2,21,99,'31.94',0),
 (26561,19,2,22,5915,'25.54',0),
 (26562,19,2,23,1107,'33.91',0),
 (26563,19,2,24,30,'26.55',0),
 (26564,19,2,25,109,'30.53',0),
 (26565,19,2,26,1395,'30.51',0),
 (26566,19,2,27,351,'36.30',0),
 (26567,19,2,28,454,'38.28',0),
 (26568,19,2,29,162,'36.73',0),
 (26569,19,2,30,492,'39.55',0),
 (26570,19,2,31,711,'46.44',0),
 (26571,19,2,32,1294,'39.01',0),
 (26572,19,2,33,858,'34.84',0),
 (26573,19,2,34,96,'30.57',0),
 (26574,19,2,35,415,'42.17',0),
 (26575,19,2,36,623,'34.12',0),
 (26576,19,2,37,651,'49.92',0),
 (26577,19,2,38,1709,'43.76',0),
 (26578,19,2,39,30,'36.14',0),
 (26579,19,2,40,4155,'42.37',0),
 (26580,19,2,41,875,'33.76',0),
 (26581,19,2,42,210,'28.26',0),
 (26582,19,2,43,1536,'36.42',0),
 (26583,19,2,44,1541,'37.62',0),
 (26584,19,2,45,8681,'38.55',0),
 (26585,19,2,46,1187,'35.66',0),
 (26586,19,2,47,11484,'40.09',0),
 (26587,19,2,48,187,'50.95',0),
 (26588,19,2,49,23146,'47.22',0),
 (26589,19,2,50,515,'22.07',0),
 (26590,19,2,51,388,'34.83',0),
 (26591,19,2,52,931,'31.65',0),
 (26592,19,2,53,1862,'40.16',0),
 (26593,19,2,54,2802,'34.72',0),
 (26594,19,2,55,364,'43.59',0),
 (26595,19,2,56,191,'34.60',0),
 (26596,19,2,57,401,'35.68',0),
 (26597,19,2,58,52624,'49.10',0),
 (26598,19,2,59,1168,'37.57',0),
 (26599,19,2,60,676,'56.62',0),
 (26600,19,2,61,5488,'35.84',0),
 (26601,19,2,62,61,'25.10',0),
 (26602,19,2,63,98,'44.14',0),
 (26603,19,2,64,36,'34.95',0),
 (26604,19,2,65,45746,'47.44',0),
 (26605,19,2,66,1429,'26.81',0),
 (26606,19,2,67,1276,'41.32',0),
 (26607,19,2,68,2737,'34.93',0),
 (26608,19,2,69,16,'26.23',0),
 (26609,19,2,70,19,'19.00',0),
 (26610,19,2,71,22,'38.60',0),
 (26611,19,2,72,1271,'30.91',0),
 (26612,19,2,73,3691,'42.63',0),
 (26613,19,2,74,54681,'49.34',0),
 (26614,19,2,75,1323,'39.19',0),
 (26615,19,2,76,129,'38.39',0),
 (26616,19,2,78,8,'28.57',0),
 (26617,19,2,79,691580,'38.07',0),
 (26618,19,2,80,9813,'26.68',0),
 (26619,19,2,82,1329,'35.95',0),
 (26620,19,2,83,2208,'39.61',0),
 (26621,19,2,84,4930,'43.22',0),
 (26622,19,2,85,1159,'38.93',0),
 (26623,19,2,86,1107,'36.19',0),
 (26624,19,2,87,851,'33.88',0),
 (26625,19,2,88,100,'51.55',0),
 (26626,19,2,89,884,'32.56',0),
 (26627,19,2,90,2120,'34.26',0),
 (26628,19,2,91,1569,'40.93',0),
 (26629,19,2,92,53370,'44.48',0),
 (26630,19,2,93,534,'34.83',0),
 (26631,19,2,94,149,'28.27',0),
 (26632,19,2,95,342,'32.98',0),
 (26633,19,2,96,3583,'34.29',0),
 (26634,19,2,97,77,'70.64',0),
 (26635,19,2,99,382,'30.76',0),
 (26636,19,2,100,1061,'35.84',0),
 (26637,19,2,101,66,'41.51',0),
 (26638,19,2,102,293,'45.50',0),
 (26639,19,2,104,2025,'35.23',0),
 (26640,19,2,106,26439,'52.43',0),
 (26641,19,2,107,149,'48.69',0),
 (26642,19,2,108,679,'34.78',0),
 (26643,19,2,109,350,'30.30',0),
 (26644,19,2,110,683,'42.74',0),
 (26645,19,2,111,182,'35.00',0),
 (26646,19,2,112,59,'44.36',0),
 (26647,19,2,113,10638,'45.03',0),
 (26648,19,2,114,31,'24.80',0),
 (26649,19,2,115,11839,'25.20',0),
 (26650,19,2,116,159,'44.79',0),
 (26651,19,2,117,20,'24.69',0),
 (26652,19,2,118,30,'44.78',0),
 (26653,19,2,119,442,'30.74',0),
 (26654,19,2,120,426,'42.56',0),
 (26655,19,2,121,67,'44.37',0),
 (26656,19,2,122,133,'36.94',0),
 (26657,19,2,123,16259,'45.89',0),
 (26658,19,2,124,33,'38.37',0),
 (26659,19,2,125,703,'32.73',0),
 (26660,19,2,126,23,'54.76',0),
 (26661,19,2,127,12945,'27.46',0),
 (26662,19,2,128,106,'39.41',0),
 (26663,19,2,129,1754,'35.91',0),
 (26664,19,2,130,9979,'45.40',0),
 (26665,19,2,131,3312,'34.89',0),
 (26666,19,2,132,3445,'44.95',0),
 (26667,19,2,133,1752,'39.79',0),
 (26668,19,2,134,17451,'42.22',0),
 (26669,19,2,135,252,'36.00',0),
 (26670,19,2,136,200,'38.24',0),
 (26671,19,2,137,505,'41.77',0),
 (26672,19,2,138,26,'33.77',0),
 (26673,19,2,140,675,'33.85',0),
 (26674,19,2,141,1264,'32.43',0),
 (26675,19,2,143,31,'40.26',0),
 (26676,19,2,144,1521,'34.23',0),
 (26677,19,2,145,611,'46.25',0),
 (26678,19,2,146,588,'45.62',0),
 (26679,19,2,147,298,'43.95',0),
 (26680,19,2,148,26041,'43.53',0),
 (26681,19,2,149,1364,'36.79',0),
 (26682,19,2,150,776,'32.03',0),
 (26683,19,2,151,914,'40.59',0),
 (26684,19,2,152,3313,'28.50',0),
 (26685,19,2,153,176,'44.67',0),
 (26686,19,2,154,1617,'41.38',0),
 (26687,19,2,155,224,'49.34',0),
 (26688,19,2,156,270,'39.65',0),
 (26689,19,2,157,157,'34.20',0),
 (26690,19,2,158,133,'26.49',0),
 (26691,19,2,159,176,'36.36',0),
 (26692,19,2,160,1964,'34.45',0),
 (26693,19,2,161,11092,'36.46',0),
 (26694,19,2,162,493,'31.44',0),
 (26695,19,2,163,113,'44.14',0),
 (26696,19,2,164,749,'35.21',0),
 (26697,19,2,165,479,'37.22',0),
 (26698,19,2,166,113,'42.48',0),
 (26699,19,2,167,2509,'42.24',0),
 (26700,19,2,168,298,'38.45',0),
 (26701,19,2,169,277,'29.25',0),
 (26702,19,2,170,702,'39.44',0),
 (26703,19,2,171,1002,'33.16',0),
 (26704,19,2,172,1482,'30.11',0),
 (26705,19,2,173,164,'40.39',0),
 (26706,19,2,174,472,'37.14',0),
 (26707,19,2,175,167,'33.67',0),
 (26708,19,2,176,2011,'24.32',0),
 (26709,19,2,177,2233,'30.25',0),
 (26710,19,2,178,266,'34.55',0),
 (26711,19,2,179,329,'31.33',0),
 (26712,19,2,180,1948,'48.10',0),
 (26713,19,2,181,4648,'28.53',0),
 (26714,19,2,182,62,'36.69',0),
 (26715,19,2,183,303,'42.08',0),
 (26716,19,2,901,214,'39.48',0),
 (26717,19,2,902,72,'22.78',0),
 (26718,19,2,903,9214,'38.59',0),
 (26719,19,2,999,21036,'53.14',0),
 (26720,22,2,1,2,'4.44',0),
 (26721,22,2,2,454,'22.78',0),
 (26722,22,2,3,45,'29.80',0),
 (26723,22,2,4,965,'23.86',0),
 (26724,22,2,5,28604,'28.75',0),
 (26725,22,2,6,14051,'24.70',0),
 (26726,22,2,7,27001,'28.68',0),
 (26727,22,2,8,303,'24.82',0),
 (26728,22,2,9,2334,'22.69',0),
 (26729,22,2,10,1464,'20.25',0),
 (26730,22,2,11,56,'17.78',0),
 (26731,22,2,12,191,'29.34',0),
 (26732,22,2,13,7778,'28.24',0),
 (26733,22,2,14,5674,'24.53',0),
 (26734,22,2,15,2343,'20.52',0),
 (26735,22,2,16,21,'31.34',0),
 (26736,22,2,17,186,'20.95',0),
 (26737,22,2,18,601,'21.50',0),
 (26738,22,2,19,312,'35.14',0),
 (26739,22,2,20,27,'27.00',0),
 (26740,22,2,21,74,'22.56',0),
 (26741,22,2,22,3678,'15.15',0),
 (26742,22,2,23,681,'20.08',0),
 (26743,22,2,24,19,'14.39',0),
 (26744,22,2,25,80,'24.10',0),
 (26745,22,2,26,837,'18.81',0),
 (26746,22,2,27,228,'24.81',0),
 (26747,22,2,28,285,'24.30',0),
 (26748,22,2,29,94,'22.71',0),
 (26749,22,2,30,324,'26.34',0),
 (26750,22,2,31,499,'33.27',0),
 (26751,22,2,32,834,'24.76',0),
 (26752,22,2,33,547,'20.33',0),
 (26753,22,2,34,60,'21.74',0),
 (26754,22,2,35,311,'29.73',0),
 (26755,22,2,36,340,'19.06',0),
 (26756,22,2,37,508,'40.64',0),
 (26757,22,2,38,1026,'28.58',0),
 (26758,22,2,39,31,'30.10',0),
 (26759,22,2,40,2636,'26.76',0),
 (26760,22,2,41,612,'19.40',0),
 (26761,22,2,42,132,'16.34',0),
 (26762,22,2,43,994,'23.97',0),
 (26763,22,2,44,1002,'23.93',0),
 (26764,22,2,45,5463,'23.88',0),
 (26765,22,2,46,760,'23.23',0),
 (26766,22,2,47,7193,'25.30',0),
 (26767,22,2,48,141,'36.25',0),
 (26768,22,2,49,14555,'31.38',0),
 (26769,22,2,50,499,'18.74',0),
 (26770,22,2,51,228,'20.19',0),
 (26771,22,2,52,558,'20.52',0),
 (26772,22,2,53,1140,'23.83',0),
 (26773,22,2,54,1731,'22.49',0),
 (26774,22,2,55,238,'33.66',0),
 (26775,22,2,56,115,'19.62',0),
 (26776,22,2,57,232,'21.60',0),
 (26777,22,2,58,32526,'31.68',0),
 (26778,22,2,59,735,'23.48',0),
 (26779,22,2,60,499,'41.86',0),
 (26780,22,2,61,3213,'21.56',0),
 (26781,22,2,62,30,'13.27',0),
 (26782,22,2,63,40,'19.70',0),
 (26783,22,2,64,15,'13.64',0),
 (26784,22,2,65,29410,'31.90',0),
 (26785,22,2,66,879,'16.33',0),
 (26786,22,2,67,894,'30.31',0),
 (26787,22,2,68,1737,'22.33',0),
 (26788,22,2,69,4,'12.12',0),
 (26789,22,2,70,17,'17.53',0),
 (26790,22,2,71,7,'12.73',0),
 (26791,22,2,72,763,'19.04',0),
 (26792,22,2,73,2290,'26.11',0),
 (26793,22,2,74,35250,'33.54',0),
 (26794,22,2,75,936,'23.90',0),
 (26795,22,2,76,89,'27.73',0),
 (26796,22,2,78,1,'4.35',0),
 (26797,22,2,79,438654,'25.72',0),
 (26798,22,2,80,6051,'16.56',0),
 (26799,22,2,82,838,'21.46',0),
 (26800,22,2,83,1481,'24.58',0),
 (26801,22,2,84,2997,'26.39',0),
 (26802,22,2,85,911,'31.06',0),
 (26803,22,2,86,729,'22.44',0),
 (26804,22,2,87,554,'22.58',0),
 (26805,22,2,88,52,'30.06',0),
 (26806,22,2,89,570,'20.70',0),
 (26807,22,2,90,1310,'21.37',0),
 (26808,22,2,91,1037,'28.25',0),
 (26809,22,2,92,32579,'29.39',0),
 (26810,22,2,93,350,'23.06',0),
 (26811,22,2,94,104,'18.87',0),
 (26812,22,2,95,224,'20.80',0),
 (26813,22,2,96,2825,'22.95',0),
 (26814,22,2,97,44,'47.83',0),
 (26815,22,2,99,229,'18.38',0),
 (26816,22,2,100,616,'21.50',0),
 (26817,22,2,101,42,'26.58',0),
 (26818,22,2,102,270,'38.96',0),
 (26819,22,2,104,1872,'20.00',0),
 (26820,22,2,106,16172,'30.79',0),
 (26821,22,2,107,111,'33.33',0),
 (26822,22,2,108,499,'22.40',0),
 (26823,22,2,109,197,'17.84',0),
 (26824,22,2,110,471,'31.93',0),
 (26825,22,2,111,114,'23.80',0),
 (26826,22,2,112,47,'34.31',0),
 (26827,22,2,113,6553,'27.96',0),
 (26828,22,2,114,11,'10.00',0),
 (26829,22,2,115,7315,'15.75',0),
 (26830,22,2,116,131,'26.31',0),
 (26831,22,2,117,18,'20.00',0),
 (26832,22,2,118,11,'23.40',0),
 (26833,22,2,119,273,'18.03',0),
 (26834,22,2,120,303,'32.55',0),
 (26835,22,2,121,39,'25.66',0),
 (26836,22,2,122,103,'28.14',0),
 (26837,22,2,123,10986,'28.77',0),
 (26838,22,2,124,9,'16.98',0),
 (26839,22,2,125,448,'21.80',0),
 (26840,22,2,126,16,'43.24',0),
 (26841,22,2,127,8065,'16.79',0),
 (26842,22,2,128,88,'32.00',0),
 (26843,22,2,129,1206,'22.08',0),
 (26844,22,2,130,6243,'29.57',0),
 (26845,22,2,131,2018,'21.60',0),
 (26846,22,2,132,2370,'29.84',0),
 (26847,22,2,133,1267,'30.57',0),
 (26848,22,2,134,11253,'26.65',0),
 (26849,22,2,135,151,'22.91',0),
 (26850,22,2,136,135,'26.16',0),
 (26851,22,2,137,354,'28.97',0),
 (26852,22,2,138,10,'21.74',0),
 (26853,22,2,140,446,'20.83',0),
 (26854,22,2,141,773,'19.08',0),
 (26855,22,2,143,13,'19.40',0),
 (26856,22,2,144,916,'20.77',0),
 (26857,22,2,145,492,'30.37',0),
 (26858,22,2,146,387,'32.12',0),
 (26859,22,2,147,228,'32.66',0),
 (26860,22,2,148,16269,'27.27',0),
 (26861,22,2,149,974,'23.97',0),
 (26862,22,2,150,461,'19.66',0),
 (26863,22,2,151,680,'31.12',0),
 (26864,22,2,152,2008,'16.92',0),
 (26865,22,2,153,109,'26.85',0),
 (26866,22,2,154,1141,'29.56',0),
 (26867,22,2,155,165,'39.66',0),
 (26868,22,2,156,191,'26.06',0),
 (26869,22,2,157,104,'23.32',0),
 (26870,22,2,158,89,'17.98',0),
 (26871,22,2,159,106,'22.18',0),
 (26872,22,2,160,1217,'21.68',0),
 (26873,22,2,161,7354,'22.31',0),
 (26874,22,2,162,341,'19.09',0),
 (26875,22,2,163,81,'26.91',0),
 (26876,22,2,164,493,'22.69',0),
 (26877,22,2,165,277,'21.39',0),
 (26878,22,2,166,90,'33.58',0),
 (26879,22,2,167,1599,'26.91',0),
 (26880,22,2,168,226,'27.90',0),
 (26881,22,2,169,199,'20.69',0),
 (26882,22,2,170,444,'25.71',0),
 (26883,22,2,171,661,'22.57',0),
 (26884,22,2,172,1173,'19.31',0),
 (26885,22,2,173,116,'29.74',0),
 (26886,22,2,174,297,'24.26',0),
 (26887,22,2,175,113,'17.94',0),
 (26888,22,2,176,1201,'13.78',0),
 (26889,22,2,177,1392,'18.64',0),
 (26890,22,2,178,182,'23.01',0),
 (26891,22,2,179,199,'19.38',0),
 (26892,22,2,180,1378,'34.67',0),
 (26893,22,2,181,2712,'17.00',0),
 (26894,22,2,182,42,'23.60',0),
 (26895,22,2,183,157,'24.19',0),
 (26896,22,2,901,169,'29.81',0),
 (26897,22,2,902,41,'12.46',0),
 (26898,22,2,903,5638,'23.80',0),
 (26899,22,2,999,3622,'29.30',0),
 (26900,25,2,1,4,'8.33',0),
 (26901,25,2,2,377,'17.32',0),
 (26902,25,2,3,31,'21.99',0),
 (26903,25,2,4,854,'19.56',0),
 (26904,25,2,5,22248,'21.41',0),
 (26905,25,2,6,11073,'17.97',0),
 (26906,25,2,7,20135,'20.36',0),
 (26907,25,2,8,244,'19.03',0),
 (26908,25,2,9,1749,'15.96',0),
 (26909,25,2,10,1016,'12.81',0),
 (26910,25,2,11,58,'17.16',0),
 (26911,25,2,12,130,'18.81',0),
 (26912,25,2,13,6580,'21.93',0),
 (26913,25,2,14,4763,'19.33',0),
 (26914,25,2,15,1769,'12.07',0),
 (26915,25,2,16,17,'29.82',0),
 (26916,25,2,17,118,'12.51',0